/*
    ACfax - Fax reception with X11-interface for amateur radio
    Copyright (C) 1995-1998 Andreas Czechanowski, DL4SDC

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    andreas.czechanowski@ins.uni-stuttgart.de
*/
    
/*
 * mod_demod.h - header file for the AM/FM modulator and demodulator
 *		 contained in mod_demod.c
 */

#define MOD_BITS	0x000000f0
#define MOD_FM		0x00000010
#define MOD_AM		0x00000020
#define FIL_MASK	0x00000007
#define FIL_NARR	0x00000001
#define FIL_MIDL	0x00000002
#define FIL_WIDE	0x00000003

/* defining SHORT as short may increase performance on some machines... */
#define SHORT 

extern SHORT int firwide[], firmiddle[], firnarrow[]; 

void modem_init(void);
void set_modem_param(int, int, int);
void fm_demod(char *, int, char *);
void am_demod(char *, int, char *);
void fm_modulate(char *, int , char *);
void am_modulate(char *, int , char *);
