!{\src2tex{textfont=tt}}
!!****f* ABINIT/cvxclda
!! NAME
!! cvxclda
!!
!! FUNCTION
!! Calculate Vxc on the FFT grid.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, YMN, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!  ixc = choice for the exchange-correlation potential.
!!  mpi_enreg = informations about MPI parallelization.
!!  ngfft1,ngfft2,ngfft3 = size of the FFT grid.
!!  nr = total number of points on the FFT grid.
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  rho(nr,nsppol) = the charge density on the FFT grid.
!!   (total in first half and spin-up in second half if nsppol=2)
!!  rprimd(3,3) = dimensional real space primitive translations (bohr).
!!
!! OUTPUT
!!  vxclda(nr,nsppol) = the exchange-correlation potential on the FFT grid.
!!                      (spin up in first half and spin down in second half if nsppol=2)
!!
!! NOTES
!!  
!! No xc quadrature
!! No nl core correction
!!
!! PARENTS
!!      cmevxclda
!!
!! CHILDREN
!!      leave_new,rhohxc,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cvxclda(dtset,ixc,mpi_enreg,ngfft1,ngfft2,ngfft3,nr,nsppol,rho,rprimd,vxclda)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13xc
 use interfaces_15gw, except_this_one => cvxclda
#else
 use defs_xc
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ixc,ngfft1,ngfft2,ngfft3,nr,nsppol
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
!arrays
 real(dp),intent(in) :: rho(nr,nsppol),rprimd(3,3)
 real(dp),intent(out) :: vxclda(nr,nsppol)

!Local variables ------------------------------
!scalars
 integer,parameter :: nkxc=0,option=0
 integer :: ir,n3xccc,nspden
 real(dp) :: enxc,gsqcut,vxcavg
 character(len=500) :: message
 type(dataset_type) :: dtGW
!arrays
 integer :: ngfft(18)
 real(dp) :: strsxc(6)
 real(dp),allocatable :: dum(:),kxc(:,:),rhog(:,:),vhartr(:),xccc3d(:)
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: vxcca
#endif
!End of the abilint section

!************************************************************************
 !print info
 write(message,'(a,i3)') ' cvxclda: calculating Vxc using ixc = ',ixc
 call wrtout(std_out,message,'COLL')

 !form Vxc (in Hartrees)

 if (ixc==0) then
  !for backward compatibility
  write (message,'(5a)') &
&  ' cvxclda: WARNING - ',ch10,&
&  '  ixc = 0 is a relativistic Ceperley-Alder xc functional [PRB 26, p. 4199, (1982)]',ch10,&
&  '  in the GW code. It should be used only for backward compatibility.'
  call wrtout(ab_out,message,'COLL')
  call wrtout(std_out,message,'COLL')
  if (nsppol==2) then 
   write (message,'(3a)')&
&   ' cvxclda: ERROR- ',ch10,&
&   '  ixc = 0 and nsppol==2 not yet implemented ' 
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
  end if 
   do ir=1,nr
    vxclda(ir,1)=vxcca(rho(ir,1))
   end do
 else
  if ((ixc<0).or.(ixc>16)) then
   write (message,'(4a,i3,a)') ch10,&
&   ' cvxclda: ERROR - ',ch10,&
&   '  ixc = ',ixc,' is not allowed at the present time in the GW code.'
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
  end if

  !Copy the input variables from the current dataset to a temporary one
  !to tune some parameters
  call dtsetCopy(dtGW, dtset)
  dtGW%intxc = 0

  write(message,'(a)') ' cvxclda: calling rhohxc to calculate Vxc[n_val] (excluding non-linear core corrections)'
  call wrtout(std_out,message,'COLL')

  !these values have been copied from fftwfn.f (they should always work, but may not be optimal)
  ! note: one must have nr=ngfft1*ngfft2*ngfft3 (ie the FFT grid must not be augmented a priori)
  !       this is actually enforced at the present time in setmesh.f
  ngfft(1)=ngfft1
  ngfft(2)=ngfft2
  ngfft(3)=ngfft3
  ngfft(4)=2*(ngfft(1)/2)+1
  ngfft(5)=2*(ngfft(2)/2)+1
  ngfft(6)=ngfft(3)
  ngfft(7)=200
  ngfft(8)=256
  ngfft(9)=0
  ngfft(10)=1
  ngfft(11)=0
  ngfft(12)=ngfft2
  ngfft(13)=ngfft3
  ngfft(14)=0

  allocate(rhog(2,nr),vhartr(nr))
  allocate(kxc(nr,nkxc))
  !gsqcut & rhog are zeroed because they are not used by rhohxc if 1<=ixc<=16 and option=0
  gsqcut=0.0
  rhog(:,:)=0.0
!MG FIXME this is the 3D core electron density for XC core correction (bohr^-3)
!   should implement the non linear core correction 
  n3xccc=0       
  allocate(xccc3d(n3xccc))

  !NOTE nkxc=0    ==> no computation of the exchange-correlation kernel
  !     option=0  ==> only exc, vxc, strsxc
  nspden=nsppol

!MG Now rho(nr,sp%nsppol)
  call rhohxc(dtGW,enxc,gsqcut,0,kxc,mpi_enreg,nr,ngfft,&
&             dum,0,dum,0,nkxc,nspden,n3xccc,option,rhog,rho,rprimd,strsxc,1,&
&             vhartr,vxclda,vxcavg,xccc3d)

  deallocate(rhog,vhartr,xccc3d)
  deallocate(kxc)

  call dtsetFree(dtGW)

  write(std_out,'(a,f8.4,a)') ' cvxclda: rhohxc returned  Exc[n_val]  = ',enxc,' [Ha]'
  write(std_out,'(a,f8.4,a)') '                      and <Vxc[n_val]> = ',vxcavg,' [Ha]'

 end if

 write(std_out,*)

!write Vxc
!open(unit=66,file='vxc')
!write(66,'(f7.4)') ((vxclda(ir,is),ir=1,nr),is=1,nsppol)
!close(66)

end subroutine cvxclda

!!***
