#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Fill Multicolor
# send your bug reports to contact@dotslashplay.it
###

script_version=20240229.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='fill-multicolor'
GAME_NAME='Fill Multicolor'

ARCHIVE_BASE_0_NAME='setup_fill_multicolor_1.0.1_(70326).exe'
ARCHIVE_BASE_0_MD5='c934cb4e7bf11097cb4a18a422bc805e'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='14335'
ARCHIVE_BASE_0_VERSION='1.0.1-gog70326'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/fill_multicolor'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
almixer.dll
coronalabs.corona.native.dll
lua.dll
openal32.dll
plugin_hwcursor.dll
pthreads.dll
fill multicolor.exe'
CONTENT_GAME_DATA_FILES='
resources'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/AleC Games/Fill Multicolor
users/${USER}/AppData/Local/AleC Games/Fill Multicolor'

APP_MAIN_EXE='fill multicolor.exe'
APP_MAIN_ICON='resources/icon-win32.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
