#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
set -o errexit

###
# Cat Quest
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20221129.1

# Set game-specific variables

GAME_ID='cat-quest-1'
GAME_NAME='Cat Quest'

ARCHIVE_BASE_0='setup_cat_quest_1.2.10.2_(42782).exe'
ARCHIVE_BASE_0_MD5='496d069ea28098aa6d575fc56f8c71ec'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='334416'
ARCHIVE_BASE_0_VERSION='1.2.10.2-gog42782'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/cat_quest'

UNITY3D_NAME='cat quest'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
cat?quest.exe
cat?quest_data/plugins
mono
gameassembly.dll
unitycrashhandler32.exe
unityplayer.dll'
ARCHIVE_GAME_DATA_FILES='
cat?quest_data'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/The Gentlebros Pte_ Ltd_/Cat Quest'
USER_PERSISTENT_FILES='
userdata/*.dat
userdata/*.dat.bak'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
