#!/bin/bash

###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SoftwareIdentity.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SoftwareIdentity provider module";
Name = "SoftwareInventory_OpenDRIM_SoftwareIdentityModule";
Location = "cmpiSoftwareInventory_OpenDRIM_SoftwareIdentityProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SoftwareIdentity provider";
Name = "SoftwareInventory_OpenDRIM_SoftwareIdentityProvider";
ProviderModuleName = "SoftwareInventory_OpenDRIM_SoftwareIdentityModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SoftwareIdentity provider capabilities";
ProviderModuleName = "SoftwareInventory_OpenDRIM_SoftwareIdentityModule";
ProviderName = "SoftwareInventory_OpenDRIM_SoftwareIdentityProvider";
ClassName = "OpenDRIM_SoftwareIdentity";
ProviderType = {2};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstallDate", "Name", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "PrimaryStatus", "DetailedStatus", "OperatingStatus", "CommunicationStatus", "InstanceID", "MajorVersion", "MinorVersion", "RevisionNumber", "BuildNumber", "VersionString", "TargetOperatingSystems", "Manufacturer", "Languages", "Classifications", "ClassificationDescriptions", "SerialNumber", "TargetTypes", "IdentityInfoValue", "IdentityInfoType", "ReleaseDate", "IsEntity", "ExtendedResourceType", "OtherExtendedResourceTypeDescription", "MinExtendedResourceTypeMajorVersion", "MinExtendedResourceTypeMinorVersion", "MinExtendedResourceTypeRevisionNumber", "MinExtendedResourceTypeBuildNumber", "TargetOSTypes"};
CapabilityID = "SoftwareInventory_OpenDRIM_SoftwareIdentity";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SoftwareIdentity.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SoftwareIdentity]   
   provider: SoftwareInventory_OpenDRIM_SoftwareIdentityProvider
   location: cmpiSoftwareInventory_OpenDRIM_SoftwareIdentityProvider
   type: instance
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SoftwareIdentity.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SoftwareIdentity-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SoftwareIdentity.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
