/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREIDENTITYCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_SOFTWAREIDENTITYCONFORMSTOPROFILEACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_SoftwareIdentityConformsToProfile.h"
#include "assocOpenDRIM_SoftwareIdentityConformsToProfile.h"

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SoftwareIdentityConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SoftwareIdentityConformsToProfile& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityConformsToProfile& newInstance, const OpenDRIM_SoftwareIdentityConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityConformsToProfile& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityConformsToProfile& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SoftwareIdentityConformsToProfile>& OpenDRIM_SoftwareIdentityConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_SoftwareIdentityConformsToProfile>& OpenDRIM_SoftwareIdentityConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SoftwareIdentityConformsToProfile_populate(OpenDRIM_SoftwareIdentityConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_SOFTWAREIDENTITYCONFORMSTOPROFILEACCESS_H_*/
