/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_HOSTEDSOFTWAREINVENTORYCOLLECTIONACCESS_H_
#define OPENDRIM_HOSTEDSOFTWAREINVENTORYCOLLECTIONACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_HostedSoftwareInventoryCollection.h"
#include "assocOpenDRIM_HostedSoftwareInventoryCollection.h"

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_HostedSoftwareInventoryCollection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_HostedSoftwareInventoryCollection& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HostedSoftwareInventoryCollection& newInstance, const OpenDRIM_HostedSoftwareInventoryCollection& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HostedSoftwareInventoryCollection& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HostedSoftwareInventoryCollection& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_HostedSoftwareInventoryCollection>& OpenDRIM_HostedSoftwareInventoryCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_HostedSoftwareInventoryCollection>& OpenDRIM_HostedSoftwareInventoryCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_HostedSoftwareInventoryCollection_populate(OpenDRIM_HostedSoftwareInventoryCollection& instance, string& errorMessage);

#endif /*OPENDRIM_HOSTEDSOFTWAREINVENTORYCOLLECTIONACCESS_H_*/
