/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_GatewayAccess.h"
#include "Common/IP_Common.h"

static const string systemCreationClassName = "OpenDRIM_ComputerSystem";
static const string creationClassName = "OpenDRIM_Gateway"; // "OpenDRIM_IPProtocolEndpoint";
static string systemName;

int IP_OpenDRIM_Gateway_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int IP_OpenDRIM_Gateway_unload(string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return OK;
}

int IP_OpenDRIM_Gateway_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Gateway>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	vector<string> eth_names;
	CF_assert(CF_getEthernetPortNames(eth_names, errorMessage));

	//Initialize an instance
	OpenDRIM_Gateway instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setCreationClassName(creationClassName);
	instance.setSystemName(systemName);

	for(unsigned int i=0;i<eth_names.size();i++)
	{
		if (!CF_startsWith(eth_names[i], "eth"))
			continue;

		instance.setName(eth_names[i]);
		if (discriminant == "ei")
		{
			CF_assert(IP_OpenDRIM_Gateway_populate(instance,errorMessage));
		}
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int IP_OpenDRIM_Gateway_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Gateway& instance, const char** properties, string& errorMessage) {
	_E_;
	vector<string> if_names;
	vector<string>::size_type index;

	CF_assert(CF_getEthernetPortNames(if_names, errorMessage));

	if (instance.SystemCreationClassName == systemCreationClassName &&
			instance.CreationClassName == creationClassName &&
			instance.SystemName == systemName &&
			CF_foundInList(instance.Name,if_names,index))
	{
		CF_assert(IP_OpenDRIM_Gateway_populate(instance,errorMessage));
	}
	else
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int IP_OpenDRIM_Gateway_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& newInstance, const OpenDRIM_Gateway& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int IP_OpenDRIM_Gateway_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& instance, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int IP_OpenDRIM_Gateway_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& instance, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int IP_OpenDRIM_Gateway_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& instance, unsigned int& returnValue, const OpenDRIM_Gateway_RequestStateChange_In& in, OpenDRIM_Gateway_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int IP_OpenDRIM_Gateway_populate(OpenDRIM_Gateway& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName [KEY]
	 * [X] CreationClassName       [KEY]
	 * [X] SystemName              [KEY]
	 * [X] Name                    [KEY]
	 * [X] AccessContext
	 * [X] AccessInfo
	 * [X] InfoFormat
	 * [X] ElementName
	 */

	string gateway;
	
	CF_assert(CF_getDefaultGateway(instance.Name,gateway,errorMessage));

	instance.setAccessContext(2);	// Default Gateway
	instance.setAccessInfo(gateway);
	instance.setInfoFormat(3);		//IPv4
	instance.setElementName(instance.Name+" Default Gateway");
	_L_;
	return OK;
}

