/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_DNSProtocolEndpointAccess.h"

string systemName;
const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_DNSProtocolEndpoint";

int DNS_OpenDRIM_DNSProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_unload(string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSProtocolEndpoint>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_DNSProtocolEndpoint instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	instance.setName(systemName);
	
	if (discriminant == "ei") {
		CF_assert(DNS_OpenDRIM_DNSProtocolEndpoint_populate(instance, errorMessage));
	}
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSProtocolEndpoint& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName == systemCreationClassName &&
			instance.SystemName == systemName &&
			instance.CreationClassName == creationClassName &&
			instance.Name == systemName) {
		CF_assert(DNS_OpenDRIM_DNSProtocolEndpoint_populate(instance, errorMessage));
	} else {
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& newInstance, const OpenDRIM_DNSProtocolEndpoint& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_DNSProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_DNSProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_populate(OpenDRIM_DNSProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	const string filepath("/etc/resolv.conf");
	
	instance.setNameFormat("DNS-client-hostname");
	instance.setHostname(instance.Name);
	instance.setProtocolIFType(1);
	instance.setOtherTypeDescription("DNS");
	instance.setEnabledState(2);
	instance.setElementName("DNS client");	
	
	string modifiedTime;
	CF_assert(CF_lastModified(filepath, modifiedTime, errorMessage));
	instance.setTimeOfLastStateChange(modifiedTime);
	_L_;
	return OK;
}

