########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 13 April 2007 12:44:50 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/CSD_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#
# $Id: CSD_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node CSD ##
    from Vision.matplotlibNodes import CSDNE
    CSD_32 = CSDNE(constrkw = {}, name='CSD', library=matplotliblib)
    masterNet.addNode(CSD_32,169,427)
    CSD_32.inputPortByName['NFFT'].widget.set("256", run=False)
    CSD_32.inputPortByName['nOverlap'].widget.set("0", run=False)
except:
    print "WARNING: failed to restore CSDNE named CSD in network masterNet"
    print_exc()
    CSD_32=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_33 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_33,88,8)
    ReadTable_33.inputPortByName['filename'].widget.set("Data/csd_plot_data.dat", run=False)
    ReadTable_33.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_33.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_33.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_33=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_34 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_34,27,174)
    apply(Index_34.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_34=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_35 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_35,220,176)
    apply(Index_35.inputPortByName['index'].widget.configure, (), {'max': 1})
    Index_35.inputPortByName['index'].widget.set(1, run=False)
    apply(Index_35.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_35=None

try:
    ## saving node As Type ##
    from Vision.StandardNodes import AsType
    As_Type_36 = AsType(constrkw = {}, name='As Type', library=stdlib)
    masterNet.addNode(As_Type_36,9,295)
    apply(As_Type_36.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore AsType named As Type in network masterNet"
    print_exc()
    As_Type_36=None

try:
    ## saving node As Type ##
    from Vision.StandardNodes import AsType
    As_Type_37 = AsType(constrkw = {}, name='As Type', library=stdlib)
    masterNet.addNode(As_Type_37,246,292)
    apply(As_Type_37.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore AsType named As Type in network masterNet"
    print_exc()
    As_Type_37=None

masterNet.freeze()

## saving connections for network CSD ##
if ReadTable_33 is not None and Index_34 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_33, Index_34, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_33 and Index_34 in network masterNet"
if ReadTable_33 is not None and Index_35 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_33, Index_35, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_33 and Index_35 in network masterNet"
if Index_34 is not None and As_Type_36 is not None:
    try:
        masterNet.connectNodes(
            Index_34, As_Type_36, "data", "inArrayList", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_34 and As_Type_36 in network masterNet"
if As_Type_36 is not None and CSD_32 is not None:
    try:
        masterNet.connectNodes(
            As_Type_36, CSD_32, "outArray", "arraylistx", blocking=True)
    except:
        print "WARNING: failed to restore connection between As_Type_36 and CSD_32 in network masterNet"
if Index_35 is not None and As_Type_37 is not None:
    try:
        masterNet.connectNodes(
            Index_35, As_Type_37, "data", "inArrayList", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_35 and As_Type_37 in network masterNet"
if As_Type_37 is not None and CSD_32 is not None:
    try:
        masterNet.connectNodes(
            As_Type_37, CSD_32, "outArray", "arraylisty", blocking=True)
    except:
        print "WARNING: failed to restore connection between As_Type_37 and CSD_32 in network masterNet"
masterNet.unfreeze()
#masterNet.run()

