/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class BytestreamModule
extends ModuleBase {
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    private static final String NAME = "BYTESTREAM";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2007, 4, 10};
    private static final String[] FORMAT = new String[]{"bytestream"};
    private static final String COVERAGE = null;
    private static final String[] MIMETYPE = new String[]{"application/octet-stream"};
    private static final String WELLFORMED = "All bytestreams are well-formed";
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "This is the default format";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";

    public BytestreamModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
    }

    public final int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        this.initParse();
        repInfo.setModule((Module)this);
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        Checksummer checksummer = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            checksummer = new Checksummer();
            this._cstream = new ChecksumInputStream(inputStream, checksummer);
            this._dstream = BytestreamModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = BytestreamModule.getBufferedDataStream((InputStream)inputStream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        boolean bl = false;
        this._nByte = 0L;
        byte[] byArray = new byte[4096];
        while (!bl) {
            try {
                int n2 = BytestreamModule.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)this);
                if (n2 > 0) continue;
                break;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        repInfo.setSize(this._nByte);
        if (this._nByte == 0L) {
            repInfo.setMessage((Message)new InfoMessage("Zero-length file"));
        }
        if (checksummer != null) {
            repInfo.setChecksum(new Checksum(checksummer.getCRC32(), ChecksumType.CRC32));
            String string = checksummer.getMD5();
            if (string != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.MD5));
            }
            if ((string = checksummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.SHA1));
            }
        }
        return 0;
    }

    public void checkSignatures(File file, InputStream inputStream, RepInfo repInfo) throws IOException {
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        repInfo.setSigMatch(this._name);
    }
}

