/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.NumberAssert;
import org.fest.assertions.PrimitiveAssert;

public class ByteAssert
extends PrimitiveAssert
implements NumberAssert {
    private static final byte ZERO = 0;
    private final byte actual;

    protected ByteAssert(byte actual) {
        this.actual = actual;
    }

    public ByteAssert as(String description) {
        this.description(description);
        return this;
    }

    public ByteAssert describedAs(String description) {
        return this.as(description);
    }

    public ByteAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ByteAssert describedAs(Description description) {
        return this.as(description);
    }

    public ByteAssert isEqualTo(byte expected) {
        if (this.actual == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.fail(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public ByteAssert isNotEqualTo(byte other) {
        if (this.actual != other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    public ByteAssert isGreaterThan(byte other) {
        if (this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public ByteAssert isLessThan(byte other) {
        if (this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public ByteAssert isGreaterThanOrEqualTo(byte other) {
        if (this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public ByteAssert isLessThanOrEqualTo(byte other) {
        if (this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    public ByteAssert isZero() {
        return this.isEqualTo((byte)0);
    }

    public ByteAssert isPositive() {
        return this.isGreaterThan((byte)0);
    }

    public ByteAssert isNegative() {
        return this.isLessThan((byte)0);
    }

    public ByteAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

