/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.MenuElementComponentQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

final class JPopupMenuElementsAsTextQuery {
    @RunsInEDT
    static String[] menuElementsAsText(final JPopupMenu popupMenu) {
        return GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() throws Throwable {
                MenuElement[] subElements = popupMenu.getSubElements();
                String[] result = new String[subElements.length];
                for (int i = 0; i < subElements.length; ++i) {
                    result[i] = JPopupMenuElementsAsTextQuery.textOf(subElements[i]);
                }
                return result;
            }
        });
    }

    private static String textOf(MenuElement e) {
        Component c = MenuElementComponentQuery.componentIn(e);
        if (c instanceof JMenuItem) {
            return ((JMenuItem)c).getText();
        }
        return "-";
    }

    private JPopupMenuElementsAsTextQuery() {
    }
}

