/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TreeViewModel {
    public <T> NodeInfo<?> getNodeInfo(T var1);

    public boolean isLeaf(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeInfo<T> {
        public Cell<T> getCell();

        public ProvidesKey<T> getProvidesKey();

        public SelectionModel<? super T> getSelectionModel();

        public ValueUpdater<T> getValueUpdater();

        public void setDataDisplay(HasData<T> var1);

        public void unsetDataDisplay();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultNodeInfo<T>
    implements NodeInfo<T> {
        private final Cell<T> cell;
        private final AbstractDataProvider<T> dataProvider;
        private final CellPreviewEvent.Handler<T> selectionEventManager;
        private HandlerRegistration selectionEventManagerReg;
        private final SelectionModel<? super T> selectionModel;
        private final ValueUpdater<T> valueUpdater;
        private HasData<T> display;

        public DefaultNodeInfo(AbstractDataProvider<T> dataProvider, Cell<T> cell) {
            this(dataProvider, cell, null, null);
        }

        public DefaultNodeInfo(AbstractDataProvider<T> dataProvider, Cell<T> cell, SelectionModel<? super T> selectionModel, ValueUpdater<T> valueUpdater) {
            this(dataProvider, cell, selectionModel, DefaultSelectionEventManager.createDefaultManager(), valueUpdater);
        }

        public DefaultNodeInfo(AbstractDataProvider<T> dataProvider, Cell<T> cell, SelectionModel<? super T> selectionModel, CellPreviewEvent.Handler<T> selectionEventManager, ValueUpdater<T> valueUpdater) {
            this.dataProvider = dataProvider;
            this.cell = cell;
            this.selectionModel = selectionModel;
            this.valueUpdater = valueUpdater;
            this.selectionEventManager = selectionEventManager;
        }

        @Override
        public Cell<T> getCell() {
            return this.cell;
        }

        @Override
        public ProvidesKey<T> getProvidesKey() {
            return this.dataProvider;
        }

        @Override
        public SelectionModel<? super T> getSelectionModel() {
            return this.selectionModel;
        }

        @Override
        public ValueUpdater<T> getValueUpdater() {
            return this.valueUpdater;
        }

        @Override
        public void setDataDisplay(HasData<T> display) {
            this.display = display;
            if (this.selectionEventManager != null) {
                this.selectionEventManagerReg = display.addCellPreviewHandler(this.selectionEventManager);
            }
            this.dataProvider.addDataDisplay(display);
        }

        @Override
        public void unsetDataDisplay() {
            if (this.display != null) {
                this.dataProvider.removeDataDisplay(this.display);
                if (this.selectionEventManagerReg != null) {
                    this.selectionEventManagerReg.removeHandler();
                    this.selectionEventManagerReg = null;
                }
                this.display = null;
            }
        }
    }
}

