/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package inotify

import (
	"os"
	"sync"
)

// Event represents a notification
type Event struct {
	Mask   uint32 // Mask of events
	Cookie uint32 // Unique cookie associating related events (for rename(2))
	Name   string // File name (optional)
}

type watch struct {
	wd    uint32 // Watch descriptor (as returned by the inotify_add_watch() syscall)
	flags uint32 // inotify flags of this watch (see inotify(7) for the list of valid flags)
}

// Watcher represents an inotify instance
type Watcher struct {
	mu         sync.Mutex
	fd         int               // File descriptor (as returned by the inotify_init() syscall)
	notifyFile *os.File          // An os.File object mapped onto the inotify file descriptor
	watches    map[string]*watch // Map of inotify watches (key: path)
	paths      map[int]string    // Map of watched paths (key: watch descriptor)
	Error      chan error        // Errors are sent on this channel
	Event      chan *Event       // Events are returned on this channel
	done       chan bool         // Channel for sending a "quit message" to the reader goroutine
	isClosed   bool              // Set to true when Close() is first called
}
