// XXX: util
/* Trivial string checksum used to summarize brute force output lines
 * (minimizes test case size).
 */
function checkSumString(x) {
    var i, n;
    var res = 0;
    var mult = [ 1, 3, 5, 7, 11, 13, 17, 19, 23 ];

    n = x.length;
    for (i = 0; i < n; i++) {
        res += x.charCodeAt(i) * mult[i % mult.length];
        res = res >>> 0;  // coerce to 32 bits
    }

    return res;
}

// indirect eval -> this is bound to the global object, E5 Section 10.4.2, step 1.a.
var g = (function () { var e = eval; return e('this'); } )();

/*===
basic
%00%01%02%03%04%05%06%07%08%09%0A%0B%0C%0D%0E%0F%10%11%12%13%14%15%16%17%18%19%1A%1B%1C%1D%1E%1F
%20%21%22%23%24%25%26%27%28%29*+%2C-./0123456789%3A%3B%3C%3D%3E%3F
@ABCDEFGHIJKLMNOPQRSTUVWXYZ%5B%5C%5D%5E_
%60abcdefghijklmnopqrstuvwxyz%7B%7C%7D%7E%7F
%80%81%82%83%84%85%86%87%88%89%8A%8B%8C%8D%8E%8F%90%91%92%93%94%95%96%97%98%99%9A%9B%9C%9D%9E%9F
%A0%A1%A2%A3%A4%A5%A6%A7%A8%A9%AA%AB%AC%AD%AE%AF%B0%B1%B2%B3%B4%B5%B6%B7%B8%B9%BA%BB%BC%BD%BE%BF
%C0%C1%C2%C3%C4%C5%C6%C7%C8%C9%CA%CB%CC%CD%CE%CF%D0%D1%D2%D3%D4%D5%D6%D7%D8%D9%DA%DB%DC%DD%DE%DF
%E0%E1%E2%E3%E4%E5%E6%E7%E8%E9%EA%EB%EC%ED%EE%EF%F0%F1%F2%F3%F4%F5%F6%F7%F8%F9%FA%FB%FC%FD%FE%FF
%u0100%u0101%u0102%u0103%u0104%u0105%u0106%u0107%u0108%u0109%u010A%u010B%u010C%u010D%u010E%u010F%u0110%u0111%u0112%u0113%u0114%u0115%u0116%u0117%u0118%u0119%u011A%u011B%u011C%u011D%u011E%u011F
%u0120%u0121%u0122%u0123%u0124%u0125%u0126%u0127%u0128%u0129%u012A%u012B%u012C%u012D%u012E%u012F%u0130%u0131%u0132%u0133%u0134%u0135%u0136%u0137%u0138%u0139%u013A%u013B%u013C%u013D%u013E%u013F
%u0140%u0141%u0142%u0143%u0144%u0145%u0146%u0147%u0148%u0149%u014A%u014B%u014C%u014D%u014E%u014F%u0150%u0151%u0152%u0153%u0154%u0155%u0156%u0157%u0158%u0159%u015A%u015B%u015C%u015D%u015E%u015F
%u0160%u0161%u0162%u0163%u0164%u0165%u0166%u0167%u0168%u0169%u016A%u016B%u016C%u016D%u016E%u016F%u0170%u0171%u0172%u0173%u0174%u0175%u0176%u0177%u0178%u0179%u017A%u017B%u017C%u017D%u017E%u017F
%u0180%u0181%u0182%u0183%u0184%u0185%u0186%u0187%u0188%u0189%u018A%u018B%u018C%u018D%u018E%u018F%u0190%u0191%u0192%u0193%u0194%u0195%u0196%u0197%u0198%u0199%u019A%u019B%u019C%u019D%u019E%u019F
%u01A0%u01A1%u01A2%u01A3%u01A4%u01A5%u01A6%u01A7%u01A8%u01A9%u01AA%u01AB%u01AC%u01AD%u01AE%u01AF%u01B0%u01B1%u01B2%u01B3%u01B4%u01B5%u01B6%u01B7%u01B8%u01B9%u01BA%u01BB%u01BC%u01BD%u01BE%u01BF
%u01C0%u01C1%u01C2%u01C3%u01C4%u01C5%u01C6%u01C7%u01C8%u01C9%u01CA%u01CB%u01CC%u01CD%u01CE%u01CF%u01D0%u01D1%u01D2%u01D3%u01D4%u01D5%u01D6%u01D7%u01D8%u01D9%u01DA%u01DB%u01DC%u01DD%u01DE%u01DF
%u01E0%u01E1%u01E2%u01E3%u01E4%u01E5%u01E6%u01E7%u01E8%u01E9%u01EA%u01EB%u01EC%u01ED%u01EE%u01EF%u01F0%u01F1%u01F2%u01F3%u01F4%u01F5%u01F6%u01F7%u01F8%u01F9%u01FA%u01FB%u01FC%u01FD%u01FE%u01FF
%u0200%u0201%u0202%u0203%u0204%u0205%u0206%u0207%u0208%u0209%u020A%u020B%u020C%u020D%u020E%u020F%u0210%u0211%u0212%u0213%u0214%u0215%u0216%u0217%u0218%u0219%u021A%u021B%u021C%u021D%u021E%u021F
%u0220%u0221%u0222%u0223%u0224%u0225%u0226%u0227%u0228%u0229%u022A%u022B%u022C%u022D%u022E%u022F%u0230%u0231%u0232%u0233%u0234%u0235%u0236%u0237%u0238%u0239%u023A%u023B%u023C%u023D%u023E%u023F
%u0240%u0241%u0242%u0243%u0244%u0245%u0246%u0247%u0248%u0249%u024A%u024B%u024C%u024D%u024E%u024F%u0250%u0251%u0252%u0253%u0254%u0255%u0256%u0257%u0258%u0259%u025A%u025B%u025C%u025D%u025E%u025F
%u0260%u0261%u0262%u0263%u0264%u0265%u0266%u0267%u0268%u0269%u026A%u026B%u026C%u026D%u026E%u026F%u0270%u0271%u0272%u0273%u0274%u0275%u0276%u0277%u0278%u0279%u027A%u027B%u027C%u027D%u027E%u027F
%u0280%u0281%u0282%u0283%u0284%u0285%u0286%u0287%u0288%u0289%u028A%u028B%u028C%u028D%u028E%u028F%u0290%u0291%u0292%u0293%u0294%u0295%u0296%u0297%u0298%u0299%u029A%u029B%u029C%u029D%u029E%u029F
%u02A0%u02A1%u02A2%u02A3%u02A4%u02A5%u02A6%u02A7%u02A8%u02A9%u02AA%u02AB%u02AC%u02AD%u02AE%u02AF%u02B0%u02B1%u02B2%u02B3%u02B4%u02B5%u02B6%u02B7%u02B8%u02B9%u02BA%u02BB%u02BC%u02BD%u02BE%u02BF
%u02C0%u02C1%u02C2%u02C3%u02C4%u02C5%u02C6%u02C7%u02C8%u02C9%u02CA%u02CB%u02CC%u02CD%u02CE%u02CF%u02D0%u02D1%u02D2%u02D3%u02D4%u02D5%u02D6%u02D7%u02D8%u02D9%u02DA%u02DB%u02DC%u02DD%u02DE%u02DF
%u02E0%u02E1%u02E2%u02E3%u02E4%u02E5%u02E6%u02E7%u02E8%u02E9%u02EA%u02EB%u02EC%u02ED%u02EE%u02EF%u02F0%u02F1%u02F2%u02F3%u02F4%u02F5%u02F6%u02F7%u02F8%u02F9%u02FA%u02FB%u02FC%u02FD%u02FE%u02FF
%u0300%u0301%u0302%u0303%u0304%u0305%u0306%u0307%u0308%u0309%u030A%u030B%u030C%u030D%u030E%u030F%u0310%u0311%u0312%u0313%u0314%u0315%u0316%u0317%u0318%u0319%u031A%u031B%u031C%u031D%u031E%u031F
%u0320%u0321%u0322%u0323%u0324%u0325%u0326%u0327%u0328%u0329%u032A%u032B%u032C%u032D%u032E%u032F%u0330%u0331%u0332%u0333%u0334%u0335%u0336%u0337%u0338%u0339%u033A%u033B%u033C%u033D%u033E%u033F
%u0340%u0341%u0342%u0343%u0344%u0345%u0346%u0347%u0348%u0349%u034A%u034B%u034C%u034D%u034E%u034F%u0350%u0351%u0352%u0353%u0354%u0355%u0356%u0357%u0358%u0359%u035A%u035B%u035C%u035D%u035E%u035F
%u0360%u0361%u0362%u0363%u0364%u0365%u0366%u0367%u0368%u0369%u036A%u036B%u036C%u036D%u036E%u036F%u0370%u0371%u0372%u0373%u0374%u0375%u0376%u0377%u0378%u0379%u037A%u037B%u037C%u037D%u037E%u037F
%u0380%u0381%u0382%u0383%u0384%u0385%u0386%u0387%u0388%u0389%u038A%u038B%u038C%u038D%u038E%u038F%u0390%u0391%u0392%u0393%u0394%u0395%u0396%u0397%u0398%u0399%u039A%u039B%u039C%u039D%u039E%u039F
%u03A0%u03A1%u03A2%u03A3%u03A4%u03A5%u03A6%u03A7%u03A8%u03A9%u03AA%u03AB%u03AC%u03AD%u03AE%u03AF%u03B0%u03B1%u03B2%u03B3%u03B4%u03B5%u03B6%u03B7%u03B8%u03B9%u03BA%u03BB%u03BC%u03BD%u03BE%u03BF
%u03C0%u03C1%u03C2%u03C3%u03C4%u03C5%u03C6%u03C7%u03C8%u03C9%u03CA%u03CB%u03CC%u03CD%u03CE%u03CF%u03D0%u03D1%u03D2%u03D3%u03D4%u03D5%u03D6%u03D7%u03D8%u03D9%u03DA%u03DB%u03DC%u03DD%u03DE%u03DF
%u03E0%u03E1%u03E2%u03E3%u03E4%u03E5%u03E6%u03E7%u03E8%u03E9%u03EA%u03EB%u03EC%u03ED%u03EE%u03EF%u03F0%u03F1%u03F2%u03F3%u03F4%u03F5%u03F6%u03F7%u03F8%u03F9%u03FA%u03FB%u03FC%u03FD%u03FE%u03FF
===*/

/* Test the ASCII range and a part of the non-ASCII range to get both
 * escape types.
 */

print('basic');

function basicTest() {
    var i, j;
    var tmp;

    for (i = 0; i < 1024; i += 32) {
        tmp = [];
        for (j = 0; j < 32; j++) {
            tmp.push(String.fromCharCode(i + j));
        }
        tmp = g.escape(tmp.join(''));

        print(tmp);
    }
}

try {
    basicTest();
} catch (e) {
    print(e);
}

/*===
bruteforce
0 3544552
1024 4228420
2048 4292466
3072 4356400
4096 4208278
5120 4242406
6144 4306452
7168 4370386
8192 4222264
9216 4256392
10240 4320438
11264 4384372
12288 4236250
13312 4270378
14336 4334424
15360 4398358
16384 4250236
17408 4284364
18432 4348410
19456 4412344
20480 4264222
21504 4298350
22528 4362396
23552 4426330
24576 4278208
25600 4312336
26624 4376382
27648 4440316
28672 4292194
29696 4326322
30720 4390368
31744 4454302
32768 4306180
33792 4340308
34816 4404354
35840 4468288
36864 4320166
37888 4354294
38912 4418340
39936 4482274
40960 4432054
41984 4466182
43008 4530228
44032 4594162
45056 4446040
46080 4480168
47104 4544214
48128 4608148
49152 4460026
50176 4494154
51200 4558200
52224 4622134
53248 4474012
54272 4508140
55296 4572186
56320 4636120
57344 4487998
58368 4522126
59392 4586172
60416 4650106
61440 4501984
62464 4536112
63488 4600158
64512 4664092
===*/

/* Bruteforce test of the whole Unicode range, string hash outputs. */

print('bruteforce');

function bruteForceTest() {
    for (i = 0; i < 65536; i += 1024) {
        tmp = [];
        for (j = 0; j < 1024; j++) {
            tmp.push(String.fromCharCode(i + j));
        }
        tmp = tmp.join('');

        tmp = g.escape(tmp);
        print(i, checkSumString(tmp));
    }
}

try {
    bruteForceTest();
} catch (e) {
    print(e);
}

/*===
coercion
undefined
undefined
null
true
false
1234
foo
1%2C2%2C3
%5Bobject%20Object%5D
===*/

print('coercion');

function coercionTest() {
    print(g.escape());
    print(g.escape(undefined));
    print(g.escape(null));
    print(g.escape(true));
    print(g.escape(false));
    print(g.escape(1234));
    print(g.escape('foo'));
    print(g.escape([1,2,3]));
    print(g.escape({ foo: 1, bar: 2}));
}

try {
    coercionTest();
} catch (e) {
    print(e);
}
