/* automatically generated by rust-bindgen 0.65.1 */

#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals)]

pub type __off_t = ::std::os::raw::c_long;
pub type __time_t = ::std::os::raw::c_long;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type off_t = __off_t;
pub type time_t = __time_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bignum_st {
    _unused: [u8; 0],
}
pub type BIGNUM = bignum_st;
pub const cl_error_t_CL_CLEAN: cl_error_t = 0;
pub const cl_error_t_CL_SUCCESS: cl_error_t = 0;
pub const cl_error_t_CL_VIRUS: cl_error_t = 1;
pub const cl_error_t_CL_ENULLARG: cl_error_t = 2;
pub const cl_error_t_CL_EARG: cl_error_t = 3;
pub const cl_error_t_CL_EMALFDB: cl_error_t = 4;
pub const cl_error_t_CL_ECVD: cl_error_t = 5;
pub const cl_error_t_CL_EVERIFY: cl_error_t = 6;
pub const cl_error_t_CL_EUNPACK: cl_error_t = 7;
pub const cl_error_t_CL_EOPEN: cl_error_t = 8;
pub const cl_error_t_CL_ECREAT: cl_error_t = 9;
pub const cl_error_t_CL_EUNLINK: cl_error_t = 10;
pub const cl_error_t_CL_ESTAT: cl_error_t = 11;
pub const cl_error_t_CL_EREAD: cl_error_t = 12;
pub const cl_error_t_CL_ESEEK: cl_error_t = 13;
pub const cl_error_t_CL_EWRITE: cl_error_t = 14;
pub const cl_error_t_CL_EDUP: cl_error_t = 15;
pub const cl_error_t_CL_EACCES: cl_error_t = 16;
pub const cl_error_t_CL_ETMPFILE: cl_error_t = 17;
pub const cl_error_t_CL_ETMPDIR: cl_error_t = 18;
pub const cl_error_t_CL_EMAP: cl_error_t = 19;
pub const cl_error_t_CL_EMEM: cl_error_t = 20;
pub const cl_error_t_CL_ETIMEOUT: cl_error_t = 21;
pub const cl_error_t_CL_BREAK: cl_error_t = 22;
pub const cl_error_t_CL_EMAXREC: cl_error_t = 23;
pub const cl_error_t_CL_EMAXSIZE: cl_error_t = 24;
pub const cl_error_t_CL_EMAXFILES: cl_error_t = 25;
pub const cl_error_t_CL_EFORMAT: cl_error_t = 26;
pub const cl_error_t_CL_EPARSE: cl_error_t = 27;
pub const cl_error_t_CL_EBYTECODE: cl_error_t = 28;
pub const cl_error_t_CL_EBYTECODE_TESTFAIL: cl_error_t = 29;
pub const cl_error_t_CL_ELOCK: cl_error_t = 30;
pub const cl_error_t_CL_EBUSY: cl_error_t = 31;
pub const cl_error_t_CL_ESTATE: cl_error_t = 32;
pub const cl_error_t_CL_VERIFIED: cl_error_t = 33;
pub const cl_error_t_CL_ERROR: cl_error_t = 34;
pub const cl_error_t_CL_ELAST_ERROR: cl_error_t = 35;
pub type cl_error_t = ::std::os::raw::c_uint;
#[doc = " scan options"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cl_scan_options {
    pub general: u32,
    pub parse: u32,
    pub heuristic: u32,
    pub mail: u32,
    pub dev: u32,
}
pub const bytecode_security_CL_BYTECODE_TRUST_ALL: bytecode_security = 0;
pub const bytecode_security_CL_BYTECODE_TRUST_SIGNED: bytecode_security = 1;
pub const bytecode_security_CL_BYTECODE_TRUST_NOTHING: bytecode_security = 2;
pub type bytecode_security = ::std::os::raw::c_uint;
pub const bytecode_mode_CL_BYTECODE_MODE_AUTO: bytecode_mode = 0;
pub const bytecode_mode_CL_BYTECODE_MODE_JIT: bytecode_mode = 1;
pub const bytecode_mode_CL_BYTECODE_MODE_INTERPRETER: bytecode_mode = 2;
pub const bytecode_mode_CL_BYTECODE_MODE_TEST: bytecode_mode = 3;
pub const bytecode_mode_CL_BYTECODE_MODE_OFF: bytecode_mode = 4;
pub type bytecode_mode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_section_hash {
    pub md5: [::std::os::raw::c_uchar; 16usize],
    pub len: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_stats_sections {
    pub nsections: usize,
    pub sections: *mut cli_section_hash,
}
pub type stats_section_t = cli_stats_sections;
#[doc = " @brief Pre-cache callback.\n\n Called for each processed file (both the entry level - AKA 'outer' - file and\n inner files - those generated when processing archive and container files), before\n the actual scanning takes place.\n\n @param fd        File descriptor which is about to be scanned.\n @param type      File type detected via magic - i.e. NOT on the fly - (e.g. \"CL_TYPE_MSEXE\").\n @param context   Opaque application provided data.\n @return          CL_CLEAN = File is scanned.\n @return          CL_BREAK = Allowed by callback - file is skipped and marked as clean.\n @return          CL_VIRUS = Blocked by callback - file is skipped and marked as infected."]
pub type clcb_pre_cache = ::std::option::Option<
    unsafe extern "C" fn(
        fd: ::std::os::raw::c_int,
        type_: *const ::std::os::raw::c_char,
        context: *mut ::std::os::raw::c_void,
    ) -> cl_error_t,
>;
#[doc = " @brief File inspection callback.\n\n DISCLAIMER: This interface is to be considered unstable while we continue to evaluate it.\n We may change this interface in the future.\n\n Called for each NEW file (inner and outer).\n Provides capability to record embedded file information during a scan.\n\n @param fd                  Current file descriptor which is about to be scanned.\n @param type                Current file type detected via magic - i.e. NOT on the fly - (e.g. \"CL_TYPE_MSEXE\").\n @param ancestors           An array of ancestors filenames of size `recursion_level`. filenames may be NULL.\n @param parent_file_size    Parent file size.\n @param file_name           Current file name, or NULL if the file does not have a name or ClamAV failed to record the name.\n @param file_size           Current file size.\n @param file_buffer         Current file buffer pointer.\n @param recursion_level     Recursion level / depth of the current file.\n @param layer_attributes    See LAYER_ATTRIBUTES_* flags.\n @param context             Opaque application provided data.\n @return                    CL_CLEAN = File is scanned.\n @return                    CL_BREAK = Whitelisted by callback - file is skipped and marked as clean.\n @return                    CL_VIRUS = Blacklisted by callback - file is skipped and marked as infected."]
pub type clcb_file_inspection = ::std::option::Option<
    unsafe extern "C" fn(
        fd: ::std::os::raw::c_int,
        type_: *const ::std::os::raw::c_char,
        ancestors: *mut *const ::std::os::raw::c_char,
        parent_file_size: usize,
        file_name: *const ::std::os::raw::c_char,
        file_size: usize,
        file_buffer: *const ::std::os::raw::c_char,
        recursion_level: u32,
        layer_attributes: u32,
        context: *mut ::std::os::raw::c_void,
    ) -> cl_error_t,
>;
#[doc = " @brief Pre-scan callback.\n\n Called for each NEW file (inner and outer) before the scanning takes place. This is\n roughly the same as clcb_before_cache, but it is affected by clean file caching.\n This means that it won't be called if a clean cached file (inner or outer) is\n scanned a second time.\n\n @param fd        File descriptor which is about to be scanned.\n @param type      File type detected via magic - i.e. NOT on the fly - (e.g. \"CL_TYPE_MSEXE\").\n @param context   Opaque application provided data.\n @return          CL_CLEAN = File is scanned.\n @return          CL_BREAK = Allowed by callback - file is skipped and marked as clean.\n @return          CL_VIRUS = Blocked by callback - file is skipped and marked as infected."]
pub type clcb_pre_scan = ::std::option::Option<
    unsafe extern "C" fn(
        fd: ::std::os::raw::c_int,
        type_: *const ::std::os::raw::c_char,
        context: *mut ::std::os::raw::c_void,
    ) -> cl_error_t,
>;
#[doc = " @brief Post-scan callback.\n\n Called for each processed file (inner and outer), after the scanning is complete.\n In all-match mode, the virname will be one of the matches, but there is no\n guarantee in which order the matches will occur, thus the final virname may\n be any one of the matches.\n\n @param fd        File descriptor which was scanned.\n @param result    The scan result for the file.\n @param virname   A signature name if there was one or more matches.\n @param context   Opaque application provided data.\n @return          Scan result is not overridden.\n @return          CL_BREAK = Allowed by callback - scan result is set to CL_CLEAN.\n @return          Blocked by callback - scan result is set to CL_VIRUS."]
pub type clcb_post_scan = ::std::option::Option<
    unsafe extern "C" fn(
        fd: ::std::os::raw::c_int,
        result: ::std::os::raw::c_int,
        virname: *const ::std::os::raw::c_char,
        context: *mut ::std::os::raw::c_void,
    ) -> cl_error_t,
>;
#[doc = " @brief Virus-found callback.\n\n Called for each signature match.\n If all-match is enabled, clcb_virus_found() may be called multiple times per\n scan.\n\n In addition, clcb_virus_found() does not have a return value and thus.\n can not be used to ignore the match.\n\n @param fd        File descriptor which was scanned.\n @param virname   Virus name.\n @param context   Opaque application provided data."]
pub type clcb_virus_found = ::std::option::Option<
    unsafe extern "C" fn(
        fd: ::std::os::raw::c_int,
        virname: *const ::std::os::raw::c_char,
        context: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " @brief Signature-load callback.\n\n May be used to ignore signatures at database load time.\n\n WARNING: Some signatures (notably ldb, cbc) can be dependent upon other signatures.\n          Failure to preserve dependency chains will result in database loading failure.\n          It is the implementor's responsibility to guarantee consistency.\n\n @param type      The signature type (e.g. \"db\", \"ndb\", \"mdb\", etc.)\n @param name      Signature name.\n @param custom    The signature is official (custom == 0) or custom (custom != 0)\n @param context   Opaque application provided data\n @return          0 to load the current signature.\n @return          Non-0 to skip the current signature."]
pub type clcb_sigload = ::std::option::Option<
    unsafe extern "C" fn(
        type_: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        custom: ::std::os::raw::c_uint,
        context: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " @brief Progress callback for sig-load, engine-compile, and engine-free.\n\n Progress is complete when total_items == now_completed.\n\n Note: The callback should return CL_SUCCESS. We reserve the right to have it\n       cancel the operation in the future if you return something else...\n       ... but for now, the return value will be ignored.\n\n @param total_items   Total number of items\n @param now_completed Number of items completed\n @param context       Opaque application provided data\n @return cl_error_t   reserved for future use"]
pub type clcb_progress = ::std::option::Option<
    unsafe extern "C" fn(
        total_items: usize,
        now_completed: usize,
        context: *mut ::std::os::raw::c_void,
    ) -> cl_error_t,
>;
#[doc = " @brief LibClamAV hash stats callback.\n\n Callback that provides the hash of a scanned sample if a signature alerted.\n Provides a mechanism to record detection statistics.\n\n @param fd        File descriptor if available, else -1.\n @param size      Sample size\n @param md5       Sample md5 hash\n @param virname   Signature name that the sample matched against\n @param context   Opaque application provided data"]
pub type clcb_hash = ::std::option::Option<
    unsafe extern "C" fn(
        fd: ::std::os::raw::c_int,
        size: ::std::os::raw::c_ulonglong,
        md5: *const ::std::os::raw::c_uchar,
        virname: *const ::std::os::raw::c_char,
        context: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " @brief Archive meta matching callback function.\n\n May be used to block archive/container samples based on archive metadata.\n Function is invoked multiple times per archive. Typically once per contained file.\n\n Note: Used by the --archive-verbose clamscan option. Overriding this will alter\n the output from --archive-verbose.\n\n @param container_type    String name of type (CL_TYPE).\n @param fsize_container   Sample size\n @param filename          Filename associated with the data in archive.\n @param fsize_real        Size of file after decompression (according to the archive).\n @param is_encrypted      Boolean non-zero if the contained file is encrypted.\n @param filepos_container File index in container.\n @param context           Opaque application provided data.\n @return                  CL_VIRUS to block (alert on)\n @return                  CL_CLEAN to continue scanning"]
pub type clcb_meta = ::std::option::Option<
    unsafe extern "C" fn(
        container_type: *const ::std::os::raw::c_char,
        fsize_container: ::std::os::raw::c_ulong,
        filename: *const ::std::os::raw::c_char,
        fsize_real: ::std::os::raw::c_ulong,
        is_encrypted: ::std::os::raw::c_int,
        filepos_container: ::std::os::raw::c_uint,
        context: *mut ::std::os::raw::c_void,
    ) -> cl_error_t,
>;
#[doc = " @brief File properties callback function.\n\n Invoked after a scan the CL_SCAN_GENERAL_COLLECT_METADATA general scan option\n is enabled and libclamav was built with json support.\n\n @param j_propstr File properties/metadata in a JSON encoded string.\n @param rc        The cl_error_t return code from the scan.\n @param cbdata    Opaque application provided data."]
pub type clcb_file_props = ::std::option::Option<
    unsafe extern "C" fn(
        j_propstr: *const ::std::os::raw::c_char,
        rc: ::std::os::raw::c_int,
        cbdata: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " @brief generic data callback function.\n\n Callback handler prototype for callbacks passing back data and application context.\n\n @param data      A pointer to some data. Should be treated as read-only and may be freed after callback.\n @param data_len  The length of data.\n @param cbdata    Opaque application provided data."]
pub type clcb_generic_data = ::std::option::Option<
    unsafe extern "C" fn(
        data: *const ::std::os::raw::c_uchar,
        data_len: usize,
        cbdata: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " @brief Add sample metadata to the statistics for a sample that matched on a signature.\n\n @param virname   Name of the signature that matched.\n @param md5       Sample hash.\n @param size      Sample size.\n @param sections  PE section data, if applicable.\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_add_sample = ::std::option::Option<
    unsafe extern "C" fn(
        virname: *const ::std::os::raw::c_char,
        md5: *const ::std::os::raw::c_uchar,
        size: usize,
        sections: *mut stats_section_t,
        cbdata: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " @brief Remove a specific sample from the statistics report.\n\n @param virname   Name of the signature that matched.\n @param md5       Sample hash.\n @param size      Sample size.\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_remove_sample = ::std::option::Option<
    unsafe extern "C" fn(
        virname: *const ::std::os::raw::c_char,
        md5: *const ::std::os::raw::c_uchar,
        size: usize,
        cbdata: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " @brief Decrement the hit count listed in the statistics report for a specific sample.\n\n @param virname   Name of the signature that matched.\n @param md5       Sample hash.\n @param size      Sample size.\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_decrement_count = ::std::option::Option<
    unsafe extern "C" fn(
        virname: *const ::std::os::raw::c_char,
        md5: *const ::std::os::raw::c_uchar,
        size: usize,
        cbdata: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " @brief Function to submit a statistics report.\n\n @param engine    The initialized scanning engine.\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_submit = ::std::option::Option<
    unsafe extern "C" fn(engine: *mut cl_engine, cbdata: *mut ::std::os::raw::c_void),
>;
#[doc = " @brief Function to flush/free the statistics report data.\n\n @param engine    The initialized scanning engine.\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_flush = ::std::option::Option<
    unsafe extern "C" fn(engine: *mut cl_engine, cbdata: *mut ::std::os::raw::c_void),
>;
#[doc = " @brief Function to get the number of samples listed in the statistics report.\n\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_get_num =
    ::std::option::Option<unsafe extern "C" fn(cbdata: *mut ::std::os::raw::c_void) -> usize>;
#[doc = " @brief Function to get the size of memory used to store the statistics report.\n\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_get_size =
    ::std::option::Option<unsafe extern "C" fn(cbdata: *mut ::std::os::raw::c_void) -> usize>;
#[doc = " @brief Function to get the machine's unique host ID.\n\n @param cbdata    The statistics data. Probably a pointer to a malloc'd struct."]
pub type clcb_stats_get_hostid = ::std::option::Option<
    unsafe extern "C" fn(cbdata: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cl_cvd {
    pub time: *mut ::std::os::raw::c_char,
    pub version: ::std::os::raw::c_uint,
    pub sigs: ::std::os::raw::c_uint,
    pub fl: ::std::os::raw::c_uint,
    pub md5: *mut ::std::os::raw::c_char,
    pub dsig: *mut ::std::os::raw::c_char,
    pub builder: *mut ::std::os::raw::c_char,
    pub stime: ::std::os::raw::c_uint,
}
pub type cl_fmap_t = cl_fmap;
#[doc = " @brief Read callback function type.\n\n A callback function pointer type for reading data from a cl_fmap_t that uses\n reads data from a handle interface.\n\n Read 'count' bytes starting at 'offset' into the buffer 'buf'\n\n Thread safety: It is guaranteed that only one callback is executing for a\n specific handle at any time, but there might be multiple callbacks executing\n for different handle at the same time.\n\n @param handle    The handle passed to cl_fmap_open_handle, its meaning is up\n                  to the callback's implementation\n @param buf       A buffer to read data into, must be at least offset + count\n                  bytes in size.\n @param count     The number of bytes to read.\n @param offset    The offset into buf to read the data to. If successful,\n                  the number of bytes actually read is returned. Upon reading\n                  end-of-file, zero is returned. Otherwise, a -1 is returned\n                  and the global variable errno is set to indicate the error."]
pub type clcb_pread = ::std::option::Option<
    unsafe extern "C" fn(
        handle: *mut ::std::os::raw::c_void,
        buf: *mut ::std::os::raw::c_void,
        count: usize,
        offset: off_t,
    ) -> off_t,
>;
pub type fmap_t = cl_fmap_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cl_fmap {
    pub handle: *mut ::std::os::raw::c_void,
    pub pread_cb: clcb_pread,
    pub data: *const ::std::os::raw::c_void,
    pub mtime: u64,
    pub pages: u64,
    pub pgsz: u64,
    pub paged: u64,
    pub aging: bool,
    #[doc = " indicates if we should age off memory mapped pages"]
    pub dont_cache_flag: bool,
    #[doc = " indicates if we should not cache scan results for this fmap. Used if limits exceeded"]
    pub handle_is_fd: bool,
    #[doc = " non-zero if map->handle is an fd."]
    pub offset: usize,
    #[doc = " file offset representing start of original fmap, if the fmap created reading from a file starting at offset other than 0"]
    pub nested_offset: usize,
    #[doc = " offset from start of original fmap (data) for nested scan. 0 for orig fmap."]
    pub real_len: usize,
    #[doc = " len from start of original fmap (data) to end of current (possibly nested) map."]
    pub len: usize,
    #[doc = " length of data from nested_offset, accessible via current fmap"]
    pub unmap: ::std::option::Option<unsafe extern "C" fn(arg1: *mut fmap_t)>,
    pub need: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut fmap_t,
            at: usize,
            len: usize,
            lock: ::std::os::raw::c_int,
        ) -> *const ::std::os::raw::c_void,
    >,
    pub need_offstr: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut fmap_t,
            at: usize,
            len_hint: usize,
        ) -> *const ::std::os::raw::c_void,
    >,
    pub gets: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut fmap_t,
            dst: *mut ::std::os::raw::c_char,
            at: *mut usize,
            max_len: usize,
        ) -> *const ::std::os::raw::c_void,
    >,
    pub unneed_off:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut fmap_t, at: usize, len: usize)>,
    pub windows_file_handle: *mut ::std::os::raw::c_void,
    pub windows_map_handle: *mut ::std::os::raw::c_void,
    pub have_md5: bool,
    pub md5: [::std::os::raw::c_uchar; 16usize],
    pub have_sha1: bool,
    pub sha1: [::std::os::raw::c_uchar; 20usize],
    pub have_sha256: bool,
    pub sha256: [::std::os::raw::c_uchar; 32usize],
    pub bitmap: *mut u64,
    pub name: *mut ::std::os::raw::c_char,
}
pub const cli_file_CL_TYPE_ANY: cli_file = 0;
pub const cli_file_CL_TYPE_TEXT_ASCII: cli_file = 500;
pub const cli_file_CL_TYPE_TEXT_UTF8: cli_file = 501;
pub const cli_file_CL_TYPE_TEXT_UTF16LE: cli_file = 502;
pub const cli_file_CL_TYPE_TEXT_UTF16BE: cli_file = 503;
pub const cli_file_CL_TYPE_BINARY_DATA: cli_file = 504;
pub const cli_file_CL_TYPE_ERROR: cli_file = 505;
pub const cli_file_CL_TYPE_MSEXE: cli_file = 506;
pub const cli_file_CL_TYPE_ELF: cli_file = 507;
pub const cli_file_CL_TYPE_MACHO: cli_file = 508;
pub const cli_file_CL_TYPE_MACHO_UNIBIN: cli_file = 509;
pub const cli_file_CL_TYPE_POSIX_TAR: cli_file = 510;
pub const cli_file_CL_TYPE_OLD_TAR: cli_file = 511;
pub const cli_file_CL_TYPE_CPIO_OLD: cli_file = 512;
pub const cli_file_CL_TYPE_CPIO_ODC: cli_file = 513;
pub const cli_file_CL_TYPE_CPIO_NEWC: cli_file = 514;
pub const cli_file_CL_TYPE_CPIO_CRC: cli_file = 515;
pub const cli_file_CL_TYPE_GZ: cli_file = 516;
pub const cli_file_CL_TYPE_ZIP: cli_file = 517;
pub const cli_file_CL_TYPE_BZ: cli_file = 518;
pub const cli_file_CL_TYPE_RAR: cli_file = 519;
pub const cli_file_CL_TYPE_ARJ: cli_file = 520;
pub const cli_file_CL_TYPE_MSSZDD: cli_file = 521;
pub const cli_file_CL_TYPE_MSOLE2: cli_file = 522;
pub const cli_file_CL_TYPE_MSCAB: cli_file = 523;
pub const cli_file_CL_TYPE_MSCHM: cli_file = 524;
pub const cli_file_CL_TYPE_SIS: cli_file = 525;
pub const cli_file_CL_TYPE_SCRENC: cli_file = 526;
pub const cli_file_CL_TYPE_GRAPHICS: cli_file = 527;
pub const cli_file_CL_TYPE_GIF: cli_file = 528;
pub const cli_file_CL_TYPE_PNG: cli_file = 529;
pub const cli_file_CL_TYPE_JPEG: cli_file = 530;
pub const cli_file_CL_TYPE_TIFF: cli_file = 531;
pub const cli_file_CL_TYPE_RIFF: cli_file = 532;
pub const cli_file_CL_TYPE_BINHEX: cli_file = 533;
pub const cli_file_CL_TYPE_TNEF: cli_file = 534;
pub const cli_file_CL_TYPE_CRYPTFF: cli_file = 535;
pub const cli_file_CL_TYPE_PDF: cli_file = 536;
pub const cli_file_CL_TYPE_UUENCODED: cli_file = 537;
pub const cli_file_CL_TYPE_SCRIPT: cli_file = 538;
pub const cli_file_CL_TYPE_HTML_UTF16: cli_file = 539;
pub const cli_file_CL_TYPE_RTF: cli_file = 540;
pub const cli_file_CL_TYPE_7Z: cli_file = 541;
pub const cli_file_CL_TYPE_SWF: cli_file = 542;
pub const cli_file_CL_TYPE_JAVA: cli_file = 543;
pub const cli_file_CL_TYPE_XAR: cli_file = 544;
pub const cli_file_CL_TYPE_XZ: cli_file = 545;
pub const cli_file_CL_TYPE_OOXML_WORD: cli_file = 546;
pub const cli_file_CL_TYPE_OOXML_PPT: cli_file = 547;
pub const cli_file_CL_TYPE_OOXML_XL: cli_file = 548;
pub const cli_file_CL_TYPE_INTERNAL: cli_file = 549;
pub const cli_file_CL_TYPE_HWP3: cli_file = 550;
pub const cli_file_CL_TYPE_OOXML_HWP: cli_file = 551;
pub const cli_file_CL_TYPE_PS: cli_file = 552;
pub const cli_file_CL_TYPE_EGG: cli_file = 553;
pub const cli_file_CL_TYPE_ONENOTE: cli_file = 554;
pub const cli_file_CL_TYPE_PYTHON_COMPILED: cli_file = 555;
pub const cli_file_CL_TYPE_PART_ANY: cli_file = 556;
pub const cli_file_CL_TYPE_PART_HFSPLUS: cli_file = 557;
pub const cli_file_CL_TYPE_MBR: cli_file = 558;
pub const cli_file_CL_TYPE_HTML: cli_file = 559;
pub const cli_file_CL_TYPE_MAIL: cli_file = 560;
pub const cli_file_CL_TYPE_SFX: cli_file = 561;
pub const cli_file_CL_TYPE_ZIPSFX: cli_file = 562;
pub const cli_file_CL_TYPE_RARSFX: cli_file = 563;
pub const cli_file_CL_TYPE_7ZSFX: cli_file = 564;
pub const cli_file_CL_TYPE_CABSFX: cli_file = 565;
pub const cli_file_CL_TYPE_ARJSFX: cli_file = 566;
pub const cli_file_CL_TYPE_EGGSFX: cli_file = 567;
pub const cli_file_CL_TYPE_NULSFT: cli_file = 568;
pub const cli_file_CL_TYPE_AUTOIT: cli_file = 569;
pub const cli_file_CL_TYPE_ISHIELD_MSI: cli_file = 570;
pub const cli_file_CL_TYPE_ISO9660: cli_file = 571;
pub const cli_file_CL_TYPE_DMG: cli_file = 572;
pub const cli_file_CL_TYPE_GPT: cli_file = 573;
pub const cli_file_CL_TYPE_APM: cli_file = 574;
pub const cli_file_CL_TYPE_XDP: cli_file = 575;
pub const cli_file_CL_TYPE_XML_WORD: cli_file = 576;
pub const cli_file_CL_TYPE_XML_XL: cli_file = 577;
pub const cli_file_CL_TYPE_XML_HWP: cli_file = 578;
pub const cli_file_CL_TYPE_HWPOLE2: cli_file = 579;
pub const cli_file_CL_TYPE_MHTML: cli_file = 580;
pub const cli_file_CL_TYPE_LNK: cli_file = 581;
pub const cli_file_CL_TYPE_UDF: cli_file = 582;
pub const cli_file_CL_TYPE_OTHER: cli_file = 583;
pub const cli_file_CL_TYPE_IGNORED: cli_file = 584;
pub type cli_file = ::std::os::raw::c_uint;
pub use self::cli_file as cli_file_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_ftype {
    pub type_: cli_file_t,
    pub offset: u32,
    pub magic: *mut ::std::os::raw::c_uchar,
    pub tname: *mut ::std::os::raw::c_char,
    pub next: *mut cli_ftype,
    pub length: u16,
}
pub type mpool_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_dconf {
    pub pe: u32,
    pub elf: u32,
    pub macho: u32,
    pub archive: u32,
    pub doc: u32,
    pub mail: u32,
    pub other: u32,
    pub phishing: u32,
    pub bytecode: u32,
    pub stats: u32,
    pub pcre: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct regex_t {
    pub re_magic: ::std::os::raw::c_int,
    pub re_nsub: usize,
    pub re_endp: *const ::std::os::raw::c_char,
    pub re_g: *mut re_guts,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bytecode_metadata {
    pub compiler: *mut ::std::os::raw::c_char,
    pub sigmaker: *mut ::std::os::raw::c_char,
    pub timestamp: u64,
    pub formatlevel: ::std::os::raw::c_uint,
    pub minfunc: ::std::os::raw::c_uint,
    pub maxfunc: ::std::os::raw::c_uint,
    pub maxresource: ::std::os::raw::c_uint,
    pub targetExclude: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_environment {
    pub platform_id_a: u32,
    pub platform_id_b: u32,
    pub platform_id_c: u32,
    pub c_version: u32,
    pub cpp_version: u32,
    pub functionality_level: u32,
    pub dconf_level: u32,
    pub engine_version: [i8; 65usize],
    pub triple: [i8; 65usize],
    pub cpu: [i8; 65usize],
    pub sysname: [i8; 65usize],
    pub release: [i8; 65usize],
    pub version: [i8; 65usize],
    pub machine: [i8; 65usize],
    pub big_endian: u8,
    pub sizeof_ptr: u8,
    pub arch: u8,
    pub os_category: u8,
    pub os: u8,
    pub compiler: u8,
    pub has_jit_compiled: u8,
    pub os_features: u8,
    pub reserved0: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bc_func {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bc_type {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bc_dbgnode {
    _unused: [u8; 0],
}
pub const bc_state_bc_skip: bc_state = 0;
pub const bc_state_bc_loaded: bc_state = 1;
pub const bc_state_bc_jit: bc_state = 2;
pub const bc_state_bc_interp: bc_state = 3;
pub const bc_state_bc_disabled: bc_state = 4;
pub type bc_state = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bc {
    pub metadata: bytecode_metadata,
    pub id: ::std::os::raw::c_uint,
    pub kind: ::std::os::raw::c_uint,
    pub num_types: ::std::os::raw::c_uint,
    pub num_func: ::std::os::raw::c_uint,
    pub funcs: *mut cli_bc_func,
    pub types: *mut cli_bc_type,
    pub globals: *mut *mut u64,
    pub globaltys: *mut u16,
    pub num_globals: usize,
    pub state: bc_state,
    pub uses_apis: *mut bitset_tag,
    pub lsig: *mut ::std::os::raw::c_char,
    pub vnameprefix: *mut ::std::os::raw::c_char,
    pub vnames: *mut *mut ::std::os::raw::c_char,
    pub vnames_cnt: ::std::os::raw::c_uint,
    pub start_tid: u16,
    pub dbgnodes: *mut cli_bc_dbgnode,
    pub dbgnode_cnt: ::std::os::raw::c_uint,
    pub hook_lsig_id: ::std::os::raw::c_uint,
    pub trusted: ::std::os::raw::c_uint,
    pub numGlobalBytes: u32,
    pub globalBytes: *mut u8,
    pub sigtime_id: u32,
    pub sigmatch_id: u32,
    pub hook_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_all_bc {
    pub all_bcs: *mut cli_bc,
    pub count: ::std::os::raw::c_uint,
    pub engine: *mut cli_bcengine,
    pub env: cli_environment,
    pub inited: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_events {
    _unused: [u8; 0],
}
pub type cli_events_t = cli_events;
pub const cli_crt_hashtype_CLI_HASHTYPE_ANY: cli_crt_hashtype = 0;
pub const cli_crt_hashtype_CLI_SHA1RSA: cli_crt_hashtype = 1;
pub const cli_crt_hashtype_CLI_MD5RSA: cli_crt_hashtype = 2;
pub const cli_crt_hashtype_CLI_MD2RSA: cli_crt_hashtype = 3;
pub const cli_crt_hashtype_CLI_RSA: cli_crt_hashtype = 4;
pub const cli_crt_hashtype_CLI_SHA256RSA: cli_crt_hashtype = 5;
pub const cli_crt_hashtype_CLI_SHA384RSA: cli_crt_hashtype = 6;
pub const cli_crt_hashtype_CLI_SHA512RSA: cli_crt_hashtype = 7;
pub type cli_crt_hashtype = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_crt_t {
    pub name: *mut ::std::os::raw::c_char,
    pub raw_subject: [u8; 64usize],
    pub raw_issuer: [u8; 64usize],
    pub raw_serial: [u8; 64usize],
    pub subject: [u8; 20usize],
    pub issuer: [u8; 20usize],
    pub serial: [u8; 20usize],
    pub ignore_serial: ::std::os::raw::c_int,
    pub tbshash: [u8; 64usize],
    pub n: *mut BIGNUM,
    pub e: *mut BIGNUM,
    pub sig: *mut BIGNUM,
    pub not_before: time_t,
    pub not_after: time_t,
    pub hashtype: cli_crt_hashtype,
    pub certSign: ::std::os::raw::c_int,
    pub codeSign: ::std::os::raw::c_int,
    pub timeSign: ::std::os::raw::c_int,
    pub isBlocked: ::std::os::raw::c_int,
    pub prev: *mut cli_crt_t,
    pub next: *mut cli_crt_t,
}
pub type cli_crt = cli_crt_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crtmgr {
    pub crts: *mut cli_crt,
    pub items: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bitset_tag {
    pub bitset: *mut ::std::os::raw::c_uchar,
    pub length: ::std::os::raw::c_ulong,
}
pub type bitset_t = bitset_tag;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct image_fuzzy_hash {
    pub hash: [u8; 8usize],
}
pub type image_fuzzy_hash_t = image_fuzzy_hash;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct recursion_level_tag {
    pub type_: cli_file_t,
    pub size: usize,
    pub fmap: *mut cl_fmap_t,
    pub recursion_level_buffer: u32,
    pub recursion_level_buffer_fmap: u32,
    pub attributes: u32,
    pub image_fuzzy_hash: image_fuzzy_hash_t,
    pub calculated_image_fuzzy_hash: bool,
}
pub type recursion_level_t = recursion_level_tag;
pub type evidence_t = *mut ::std::os::raw::c_void;
pub type onedump_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_ctx_tag {
    pub target_filepath: *mut ::std::os::raw::c_char,
    pub sub_filepath: *const ::std::os::raw::c_char,
    pub sub_tmpdir: *mut ::std::os::raw::c_char,
    pub evidence: evidence_t,
    pub scanned: *mut ::std::os::raw::c_ulong,
    pub root: *const cli_matcher,
    pub engine: *const cl_engine,
    pub scansize: u64,
    pub options: *mut cl_scan_options,
    pub scannedfiles: ::std::os::raw::c_uint,
    pub corrupted_input: ::std::os::raw::c_uint,
    pub recursion_stack: *mut recursion_level_t,
    pub recursion_stack_size: u32,
    pub recursion_level: u32,
    pub fmap: *mut fmap_t,
    pub handlertype_hash: [::std::os::raw::c_uchar; 16usize],
    pub dconf: *mut cli_dconf,
    pub hook_lsig_matches: *mut bitset_t,
    pub cb_ctx: *mut ::std::os::raw::c_void,
    pub perf: *mut cli_events_t,
    pub time_limit: timeval,
    pub limit_exceeded: bool,
    pub abort_scan: bool,
}
pub type cli_ctx = cli_ctx_tag;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct icomtr {
    pub group: [::std::os::raw::c_uint; 2usize],
    pub color_avg: [::std::os::raw::c_uint; 3usize],
    pub color_x: [::std::os::raw::c_uint; 3usize],
    pub color_y: [::std::os::raw::c_uint; 3usize],
    pub gray_avg: [::std::os::raw::c_uint; 3usize],
    pub gray_x: [::std::os::raw::c_uint; 3usize],
    pub gray_y: [::std::os::raw::c_uint; 3usize],
    pub bright_avg: [::std::os::raw::c_uint; 3usize],
    pub bright_x: [::std::os::raw::c_uint; 3usize],
    pub bright_y: [::std::os::raw::c_uint; 3usize],
    pub dark_avg: [::std::os::raw::c_uint; 3usize],
    pub dark_x: [::std::os::raw::c_uint; 3usize],
    pub dark_y: [::std::os::raw::c_uint; 3usize],
    pub edge_avg: [::std::os::raw::c_uint; 3usize],
    pub edge_x: [::std::os::raw::c_uint; 3usize],
    pub edge_y: [::std::os::raw::c_uint; 3usize],
    pub noedge_avg: [::std::os::raw::c_uint; 3usize],
    pub noedge_x: [::std::os::raw::c_uint; 3usize],
    pub noedge_y: [::std::os::raw::c_uint; 3usize],
    pub rsum: ::std::os::raw::c_uint,
    pub gsum: ::std::os::raw::c_uint,
    pub bsum: ::std::os::raw::c_uint,
    pub ccount: ::std::os::raw::c_uint,
    pub name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct icon_matcher {
    pub group_names: [*mut *mut ::std::os::raw::c_char; 2usize],
    pub group_counts: [::std::os::raw::c_uint; 2usize],
    pub icons: [*mut icomtr; 3usize],
    pub icon_counts: [::std::os::raw::c_uint; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_dbinfo {
    pub name: *mut ::std::os::raw::c_char,
    pub hash: *mut ::std::os::raw::c_char,
    pub size: usize,
    pub cvd: *mut cl_cvd,
    pub next: *mut cli_dbinfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_pwdb {
    pub name: *mut ::std::os::raw::c_char,
    pub passwd: *mut ::std::os::raw::c_char,
    pub length: u16,
    pub next: *mut cli_pwdb,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cl_engine {
    pub refcount: u32,
    pub sdb: u32,
    pub dboptions: u32,
    pub dbversion: [u32; 2usize],
    pub ac_only: u32,
    pub ac_mindepth: u32,
    pub ac_maxdepth: u32,
    pub tmpdir: *mut ::std::os::raw::c_char,
    pub keeptmp: u32,
    pub engine_options: u64,
    pub cache_size: u32,
    pub maxscantime: u32,
    pub maxscansize: u64,
    pub maxfilesize: u64,
    pub max_recursion_level: u32,
    pub maxfiles: u32,
    pub min_cc_count: u32,
    pub min_ssn_count: u32,
    pub root: *mut *mut cli_matcher,
    pub hm_hdb: *mut cli_matcher,
    pub hm_mdb: *mut cli_matcher,
    pub hm_imp: *mut cli_matcher,
    pub hm_fp: *mut cli_matcher,
    pub cdb: *mut cli_cdb,
    pub allow_list_matcher: *mut regex_matcher,
    pub domain_list_matcher: *mut regex_matcher,
    pub phishcheck: *mut phishcheck,
    pub dconf: *mut cli_dconf,
    pub ftypes: *mut cli_ftype,
    pub ptypes: *mut cli_ftype,
    pub pwdbs: *mut *mut cli_pwdb,
    pub test_root: *mut cli_matcher,
    pub ignored: *mut cli_matcher,
    pub pua_cats: *mut ::std::os::raw::c_char,
    pub iconcheck: *mut icon_matcher,
    pub cache: *mut CACHE,
    pub dbinfo: *mut cli_dbinfo,
    pub num_total_signatures: usize,
    pub mempool: *mut mpool_t,
    pub cmgr: crtmgr,
    pub cb_file_inspection: clcb_file_inspection,
    pub cb_pre_cache: clcb_pre_cache,
    pub cb_pre_scan: clcb_pre_scan,
    pub cb_post_scan: clcb_post_scan,
    pub cb_virus_found: clcb_virus_found,
    pub cb_sigload: clcb_sigload,
    pub cb_sigload_ctx: *mut ::std::os::raw::c_void,
    pub cb_hash: clcb_hash,
    pub cb_meta: clcb_meta,
    pub cb_vba: clcb_generic_data,
    pub cb_file_props: clcb_file_props,
    pub cb_sigload_progress: clcb_progress,
    pub cb_sigload_progress_ctx: *mut ::std::os::raw::c_void,
    pub cb_engine_compile_progress: clcb_progress,
    pub cb_engine_compile_progress_ctx: *mut ::std::os::raw::c_void,
    pub cb_engine_free_progress: clcb_progress,
    pub cb_engine_free_progress_ctx: *mut ::std::os::raw::c_void,
    pub bcs: cli_all_bc,
    pub hooks: [*mut ::std::os::raw::c_uint; 7usize],
    pub hooks_cnt: [::std::os::raw::c_uint; 7usize],
    pub hook_lsig_ids: ::std::os::raw::c_uint,
    pub bytecode_security: bytecode_security,
    pub bytecode_timeout: u32,
    pub bytecode_mode: bytecode_mode,
    pub maxembeddedpe: u64,
    pub maxhtmlnormalize: u64,
    pub maxhtmlnotags: u64,
    pub maxscriptnormalize: u64,
    pub maxziptypercg: u64,
    pub stats_data: *mut ::std::os::raw::c_void,
    pub cb_stats_add_sample: clcb_stats_add_sample,
    pub cb_stats_remove_sample: clcb_stats_remove_sample,
    pub cb_stats_decrement_count: clcb_stats_decrement_count,
    pub cb_stats_submit: clcb_stats_submit,
    pub cb_stats_flush: clcb_stats_flush,
    pub cb_stats_get_num: clcb_stats_get_num,
    pub cb_stats_get_size: clcb_stats_get_size,
    pub cb_stats_get_hostid: clcb_stats_get_hostid,
    pub maxpartitions: u32,
    pub maxiconspe: u32,
    pub maxrechwp3: u32,
    pub pcre_match_limit: u64,
    pub pcre_recmatch_limit: u64,
    pub pcre_max_filesize: u64,
}
extern "C" {
    #[doc = " @brief Append an alert.\n\n An FP-check will verify that the file is not allowed.\n The allow list check does not happen before the scan because allowing files\n is so infrequent that such action would be detrimental to performance.\n\n TODO: Replace implementation with severity scale, and severity threshold\n wherein signatures that do not meet the threshold are documented in JSON\n metadata but do not halt the scan.\n\n @param ctx       The scan context.\n @param virname   The alert name.\n @return cl_error_t CL_VIRUS if scan should be halted due to an alert, CL_CLEAN if scan should continue."]
    pub fn cli_append_virus(
        ctx: *mut cli_ctx,
        virname: *const ::std::os::raw::c_char,
    ) -> cl_error_t;
}
extern "C" {
    pub fn cli_warnmsg(str_: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn cli_errmsg(str_: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn cli_infomsg_simple(fmt: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn cli_dbgmsg_no_inline(str_: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn cli_checklimits(
        who: *const ::std::os::raw::c_char,
        ctx: *mut cli_ctx,
        need1: u64,
        need2: u64,
        need3: u64,
    ) -> cl_error_t;
}
extern "C" {
    #[doc = " @brief   Get the libclamav debug flag (e.g. if debug logging is enabled)\n\n This is required for unit tests to be able to link with clamav.dll and not\n directly manipulate libclamav global variables."]
    pub fn cli_get_debug_flag() -> u8;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cli_htu32_element {
    pub key: u32,
    pub data: cli_htu32_element__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cli_htu32_element__bindgen_ty_1 {
    pub as_size_t: usize,
    pub as_ptr: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_htu32 {
    pub htable: *mut cli_htu32_element,
    pub capacity: usize,
    pub used: usize,
    pub maxfill: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_hashset {
    pub keys: *mut u32,
    pub bitmap: *mut u32,
    pub mempool: *mut mpool_t,
    pub capacity: u32,
    pub mask: u32,
    pub count: u32,
    pub limit: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_subsig_matches {
    pub last: u32,
    pub next: u32,
    pub offsets: [u32; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_lsig_matches {
    pub subsigs: u32,
    pub matches: [*mut cli_subsig_matches; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_ac_data {
    pub offmatrix: *mut *mut *mut u32,
    pub partsigs: u32,
    pub lsigs: u32,
    pub reloffsigs: u32,
    pub lsigcnt: *mut *mut u32,
    pub lsigsuboff_last: *mut *mut u32,
    pub lsigsuboff_first: *mut *mut u32,
    pub lsig_matches: *mut *mut cli_lsig_matches,
    pub yr_matches: *mut u8,
    pub offset: *mut u32,
    pub macro_lastmatch: [u32; 32usize],
    #[doc = " Hashset for versioninfo matching"]
    pub vinfo: *const cli_hashset,
    pub min_partno: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_alt_node {
    pub str_: *mut u16,
    pub len: u16,
    pub unique: u8,
    pub next: *mut cli_alt_node,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cli_ac_special {
    pub alt: cli_ac_special__bindgen_ty_1,
    pub len: [u16; 2usize],
    pub num: u16,
    pub type_: u16,
    pub negative: u16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cli_ac_special__bindgen_ty_1 {
    pub byte: *mut ::std::os::raw::c_uchar,
    pub f_str: *mut *mut ::std::os::raw::c_uchar,
    pub v_str: *mut cli_alt_node,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_ac_patt {
    pub pattern: *mut u16,
    pub prefix: *mut u16,
    pub length: [u16; 3usize],
    pub prefix_length: [u16; 3usize],
    pub mindist: u32,
    pub maxdist: u32,
    pub sigid: u32,
    pub lsigid: [u32; 3usize],
    pub ch: [u16; 2usize],
    pub virname: *mut ::std::os::raw::c_char,
    pub customdata: *mut ::std::os::raw::c_void,
    pub ch_mindist: [u16; 2usize],
    pub ch_maxdist: [u16; 2usize],
    pub parts: u16,
    pub partno: u16,
    pub special: u16,
    pub special_pattern: u16,
    pub special_table: *mut *mut cli_ac_special,
    pub rtype: u16,
    pub type_: u16,
    pub offdata: [u32; 4usize],
    pub offset_min: u32,
    pub offset_max: u32,
    pub boundary: u32,
    pub depth: u8,
    pub sigopts: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cli_ac_list {
    pub me: *mut cli_ac_patt,
    pub __bindgen_anon_1: cli_ac_list__bindgen_ty_1,
    pub next_same: *mut cli_ac_list,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cli_ac_list__bindgen_ty_1 {
    pub node: *mut cli_ac_node,
    pub next: *mut cli_ac_list,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_ac_node {
    pub list: *mut cli_ac_list,
    pub trans: *mut *mut cli_ac_node,
    pub fail: *mut cli_ac_node,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_ac_result {
    pub virname: *const ::std::os::raw::c_char,
    pub customdata: *mut ::std::os::raw::c_void,
    pub offset: off_t,
    pub next: *mut cli_ac_result,
}
extern "C" {
    #[doc = " @brief Increment the count for a subsignature of a logical signature.\n\n This is and alternative to lsig_increment_subsig_match() for use in subsigs that don't have a specific offset,\n like byte-compare subsigs and fuzzy-hash subsigs."]
    pub fn lsig_increment_subsig_match(mdata: *mut cli_ac_data, lsig_id: u32, subsig_id: u32);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bm_patt {
    pub pattern: *mut ::std::os::raw::c_uchar,
    pub prefix: *mut ::std::os::raw::c_uchar,
    pub virname: *mut ::std::os::raw::c_char,
    pub offdata: [u32; 4usize],
    pub offset_min: u32,
    pub offset_max: u32,
    pub next: *mut cli_bm_patt,
    pub length: u16,
    pub prefix_length: u16,
    pub cnt: u16,
    pub pattern0: ::std::os::raw::c_uchar,
    pub boundary: u32,
    pub filesize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_sz_hash {
    pub hash_array: *mut u8,
    pub virusnames: *mut *const ::std::os::raw::c_char,
    pub items: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_hash_patt {
    pub sizehashes: [cli_htu32; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_hash_wild {
    pub hashes: [cli_sz_hash; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_context_8 {
    _unused: [u8; 0],
}
pub type pcre2_match_context_8 = pcre2_real_match_context_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_code_8 {
    _unused: [u8; 0],
}
pub type pcre2_code_8 = pcre2_real_code_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_pcre_data {
    pub re: *mut pcre2_code_8,
    pub mctx: *mut pcre2_match_context_8,
    pub options: ::std::os::raw::c_int,
    pub expression: *mut ::std::os::raw::c_char,
    pub search_offset: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_pcre_meta {
    pub trigger: *mut ::std::os::raw::c_char,
    pub lsigid: [u32; 3usize],
    pub pdata: cli_pcre_data,
    pub offdata: [u32; 4usize],
    pub offset_min: u32,
    pub offset_max: u32,
    pub flags: u32,
    pub statname: *mut ::std::os::raw::c_char,
    pub sigtime_id: u32,
    pub sigmatch_id: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bcomp_meta {
    pub ref_subsigid: u16,
    pub lsigid: [u32; 3usize],
    pub offset: isize,
    pub options: u16,
    pub byte_len: usize,
    pub comps: *mut *mut cli_bcomp_comp,
    pub comp_count: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bcomp_comp {
    pub comp_symbol: ::std::os::raw::c_char,
    pub comp_value: i64,
}
pub const tdb_type_CLI_TDB_UINT: tdb_type = 0;
pub const tdb_type_CLI_TDB_RANGE: tdb_type = 1;
pub const tdb_type_CLI_TDB_STR: tdb_type = 2;
pub const tdb_type_CLI_TDB_RANGE2: tdb_type = 3;
pub const tdb_type_CLI_TDB_FTYPE: tdb_type = 4;
pub const tdb_type_CLI_TDB_FTYPE_EXPR: tdb_type = 5;
pub type tdb_type = ::std::os::raw::c_uint;
pub use self::tdb_type as tdb_type_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_lsig_tdb {
    pub val: *mut u32,
    pub range: *mut u32,
    pub str_: *mut ::std::os::raw::c_char,
    pub cnt: [tdb_type_t; 3usize],
    pub subsigs: u32,
    pub target: *const u32,
    pub engine: *const u32,
    pub nos: *const u32,
    pub ep: *const u32,
    pub filesize: *const u32,
    pub container: *const u32,
    pub handlertype: *const u32,
    pub intermediates: *const u32,
    pub icongrp1: *const ::std::os::raw::c_char,
    pub icongrp2: *const ::std::os::raw::c_char,
    pub macro_ptids: *mut u32,
    pub mempool: *mut mpool_t,
}
pub const lsig_type_CLI_LSIG_NORMAL: lsig_type = 0;
pub const lsig_type_CLI_YARA_NORMAL: lsig_type = 1;
pub const lsig_type_CLI_YARA_OFFSET: lsig_type = 2;
pub type lsig_type = ::std::os::raw::c_uint;
pub use self::lsig_type as lsig_type_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cli_ac_lsig {
    pub id: u32,
    pub bc_idx: ::std::os::raw::c_uint,
    pub type_: lsig_type_t,
    pub flag: u8,
    pub u: cli_ac_lsig__bindgen_ty_1,
    pub virname: *mut ::std::os::raw::c_char,
    pub tdb: cli_lsig_tdb,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cli_ac_lsig__bindgen_ty_1 {
    pub logic: *mut ::std::os::raw::c_char,
    pub code_start: *mut u8,
}
pub type fuzzyhashmap_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_matcher {
    pub type_: ::std::os::raw::c_uint,
    pub bm_shift: *mut u8,
    pub bm_suffix: *mut *mut cli_bm_patt,
    pub bm_pattab: *mut *mut cli_bm_patt,
    pub soff: *mut u32,
    pub soff_len: u32,
    pub bm_offmode: u32,
    pub bm_patterns: u32,
    pub bm_reloff_num: u32,
    pub bm_absoff_num: u32,
    pub hm: cli_hash_patt,
    pub hwild: cli_hash_wild,
    pub ac_partsigs: u32,
    pub ac_nodes: u32,
    pub ac_lists: u32,
    pub ac_patterns: u32,
    pub ac_lsigs: u32,
    pub ac_lsigtable: *mut *mut cli_ac_lsig,
    pub ac_root: *mut cli_ac_node,
    pub ac_nodetable: *mut *mut cli_ac_node,
    pub ac_listtable: *mut *mut cli_ac_list,
    pub ac_pattable: *mut *mut cli_ac_patt,
    pub ac_reloff: *mut *mut cli_ac_patt,
    pub ac_reloff_num: u32,
    pub ac_absoff_num: u32,
    pub ac_mindepth: u8,
    pub ac_maxdepth: u8,
    pub filter: *mut filter,
    pub maxpatlen: u16,
    pub ac_only: u8,
    pub pcre_metas: u32,
    pub pcre_metatable: *mut *mut cli_pcre_meta,
    pub pcre_reloff_num: u32,
    pub pcre_absoff_num: u32,
    pub bcomp_metas: u32,
    pub bcomp_metatable: *mut *mut cli_bcomp_meta,
    pub fuzzy_hashmap: fuzzyhashmap_t,
    pub linked_bcs: u32,
    pub trans_array: *mut *mut *mut cli_ac_node,
    pub trans_cnt: usize,
    pub trans_capacity: usize,
    pub mempool: *mut mpool_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_cdb {
    pub virname: *mut ::std::os::raw::c_char,
    pub ctype: cli_file_t,
    pub name: regex_t,
    pub csize: [usize; 2usize],
    pub fsizec: [usize; 2usize],
    pub fsizer: [usize; 2usize],
    pub encrypted: ::std::os::raw::c_int,
    pub filepos: [::std::os::raw::c_uint; 2usize],
    pub res1: ::std::os::raw::c_int,
    pub res2: *mut ::std::os::raw::c_void,
    pub next: *mut cli_cdb,
}
extern "C" {
    pub fn cli_matchmeta(
        ctx: *mut cli_ctx,
        fname: *const ::std::os::raw::c_char,
        fsizec: usize,
        fsizer: usize,
        encrypted: ::std::os::raw::c_int,
        filepos: ::std::os::raw::c_uint,
        res1: ::std::os::raw::c_int,
    ) -> cl_error_t;
}
extern "C" {
    pub fn cli_versig2(
        sha256: *const ::std::os::raw::c_uchar,
        dsig_str: *const ::std::os::raw::c_char,
        n_str: *const ::std::os::raw::c_char,
        e_str: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Connect to a signing server, send the data to be signed, and return the digital signature.\n\n Caller is responsible for freeing the returned dsig.\n\n @param host\n @param user\n @param data\n @param datalen\n @param mode\n @return char*"]
    pub fn cli_getdsig(
        host: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        data: *const ::std::os::raw::c_uchar,
        datalen: ::std::os::raw::c_uint,
        mode: ::std::os::raw::c_ushort,
    ) -> *mut ::std::os::raw::c_char;
}
pub type css_image_extractor_t = *mut ::std::os::raw::c_void;
pub type css_image_handle_t = *mut ::std::os::raw::c_void;
extern "C" {
    #[doc = " @brief   Convenience wrapper for cli_magic_scan_nested_fmap_type().\n\n Creates an fmap and calls cli_magic_scan_nested_fmap_type() for you, with type CL_TYPE_ANY.\n\n @param buffer        Pointer to the buffer to be scanned.\n @param length        Size in bytes of the buffer being scanned.\n @param ctx           Scanning context structure.\n @param name          (optional) Original name of the file (to set fmap name metadata)\n @param attributes    Layer attributes of the file being scanned (is it normalized, decrypted, etc)\n @return int          CL_SUCCESS, or an error code."]
    pub fn cli_magic_scan_buff(
        buffer: *const ::std::os::raw::c_void,
        length: usize,
        ctx: *mut cli_ctx,
        name: *const ::std::os::raw::c_char,
        attributes: u32,
    ) -> cl_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct re_guts {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cli_bcengine {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct regex_matcher {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct phishcheck {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CACHE {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct filter {
    pub _address: u8,
}
