/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef MOUSE_H
#define MOUSE_H

#include <QObject>
#include <QWidget>

#include "shell/interface.h"

#include "mouseui.h"

class Mouse : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    Mouse();
    ~Mouse();

    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget *pluginUi() Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

private:
    bool            mFirstLoad   = true;
    QString         pluginName   = "";
    int             pluginType   = 0;
    MouseUI         *mouseWidget = nullptr;
    QDBusInterface  *mouseDbus   = nullptr;

    void initMouseStatus();
    void initDominantHand();
    void initScrollDirection();
    void initWheelSpeed();
    void initDoubleClickInterval();
    void initPointerSpeed();
    void initMouseAcceleration();
    void initPointerPosition();
    void initPointerSize();
    void initBlinkingCursor();
    void initCursorSpeed();

    void initConnection();

protected:
    bool eventFilter(QObject *watched, QEvent *event);

public Q_SLOTS:
    void dominantHandSlot(int id);
    void scrollDirectionSlot(int id);
    void wheelSpeedSlot();
    void doubleClickIntervalSlot();
    void pointerSpeedSlot(int value);
    void mouseAccelerationSlot(bool checked);
    void pointerPositionSlot(bool checked);
    void pointerSizeSlot(int id);
    void blinkCursorOnTextSlot(bool checked);
    void cursorSpeedSlot();

    void dataChanged(QString key);

signals:

};

#endif // MOUSE_H
