use core:lang;

/**
 * Thrown when an invalid table name is encountered.
 */
class NoSuchTable extends SyntaxError {
	init(SrcPos pos, Str name) {
		init(pos, "No table named ${name} is known.") {}
	}
}

/**
 * Thrown when we don't find a column.
 */
class NoSuchColumn extends SyntaxError {
	init(SrcPos pos, Str col, Str table) {
		init(pos, "No column named ${col} in ${table}.") {}
	}
}


/**
 * Error in the database schema.
 */
class SchemaError extends SQLError {
	init(Str message, Table expected, Schema actual) {
		init(message) {
			expected = expected;
			actual = actual;
		}
	}

	private Table expected;
	private Schema actual;

	void message(StrBuf out) : override {
		super:message(out);

		out << "\nExpected these columns in table " << actual.name << "\n";
		out.indent();
		for (c in expected.columns)
			out << c << "\n";
		out.dedent();
		out << "But got the following columns:\n";
		out.indent();
		Set<Str> pk;
		for (x in actual.primaryKeys)
			pk.put(x);
		for (Nat i = 0; i < actual.count; i++) {
			out << actual[i];
			if (pk.has(actual[i].name))
				out << " (primary key)";
			out << "\n";
		}
		out.dedent();
	}
}
