% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown.R
\name{embed_file}
\alias{embed_file}
\alias{embed_dir}
\alias{embed_files}
\title{Embed a file, multiple files, or directory on an HTML page}
\usage{
embed_file(path, name = basename(path), text = paste("Download", name), ...)

embed_dir(path, name = paste0(normalize_path(path), ".zip"), ...)

embed_files(path, name = with_ext(basename(path[1]), ".zip"), ...)
}
\arguments{
\item{path}{Path to the file(s) or directory.}

\item{name}{The default filename to use when downloading the file. Note that
for \code{embed_dir()}, only the base name (of the zip filename) will be
used.}

\item{text}{The text for the hyperlink.}

\item{...}{For \code{embed_file()}, additional arguments to be passed to
\code{htmltools::a()} (e.g., \code{class = 'foo'}). For \code{embed_dir()}
and \code{embed_files()}, arguments passed to \code{embed_file()}.}
}
\value{
An HTML tag \samp{<a>} with the appropriate attributes.
}
\description{
For a file, first encode it into base64 data (a character string). Then
generate a hyperlink of the form \samp{<a href="base64 data"
download="filename">Download filename</a>}. The file can be downloaded when
the link is clicked in modern web browsers. For a directory, it will be
compressed as a zip archive first, and the zip file is passed to
\code{embed_file()}. For multiple files, they are also compressed to a zip
file first.
}
\details{
These functions can be called in R code chunks in R Markdown documents with
HTML output formats. You may embed an arbitrary file or directory in the HTML
output file, so that readers of the HTML page can download it from the
browser. A common use case is to embed data files for readers to download.
}
\note{
Windows users may need to install Rtools to obtain the \command{zip}
  command to use \code{embed_dir()} and \code{embed_files()}.

  These functions require R packages \pkg{mime} and \pkg{htmltools}. If you
  have installed the \pkg{rmarkdown} package, these packages should be
  available, otherwise you need to install them separately.

  Currently Internet Explorer does not support downloading embedded files
  (\url{https://caniuse.com/#feat=download}). Chrome has a 2MB limit on the
  file size.
}
\examples{
logo = xfun:::R_logo()
link = xfun::embed_file(logo, text = "Download R logo")
link
if (interactive()) htmltools::browsable(link)
}
