% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{isNA}
\alias{isNA}
\title{Check if values are R NA symbol or any one of the na.strings
elements}
\usage{
isNA(x, na.strings = c("\\\\.", "", "\\\\s+", "N/A"))
}
\arguments{
\item{x}{Input data vector}

\item{na.strings}{Vector of string values to be considered as
missing. Defaults will match values that are equal to ., empty
string, any number of white space elements, or charcter
string N/A. We do not include `NA` by default because some
projects use NA to mean "not appropriate".}
}
\value{
Logical vector, TRUE if a value is either NA or in
    na.strings.
}
\description{
A value vector in the key will generally be a character
vector.  This utility is used to check if the characters
are either R missing or values in a list of characters that
represent missings.
}
\examples{
x1 <- c("TRUE", "FALSE", FALSE, TRUE, NA, "NA", ".", "N/A", " ", "")
x1na <- kutils:::isNA(x1)
cbind(x1, x1na)
}
