```
      ______                           _                          __ 
     / ____/_  __ ____   __  __ _____ (_)____ ___   ___   ____   / /_
    / __/  | |/_// __ \ / / / // ___// // __ `__ \ / _ \ / __ \ / __/
   / /___ _>  < / /_/ // /_/ // /   / // / / / / //  __// / / // /_  
  /_____//_/|_|/ .___/ \__, //_/   /_//_/ /_/ /_/ \___//_/ /_/ \__/  
              /_/     /____/                                         
```


Overview
========
**Expyriment** is an open-source and platform-independent lightweight Python
library for designing and conducting timing-critical behavioral and
neuroimaging experiments. The major goal is to provide a well-structured
Python library for script-based experiment development, with a high priority
being the readability of the resulting program code.

**Expyriment** has been tested extensively under Linux and Windows and is an
all-in-one solution, as it handles stimulus presentation, the recording of
input/output events, communication with other devices, and the collection and
preprocessing of data. Furthermore, it offers a hierarchical design structure,
which allows for an intuitive transition from the experimental design to a
running program. It is therefore also suited for students, as well as for
experimental psychologists and neuroscientists with little programming
experience.

- Project Homepage: http://www.expyriment.org

*GNU General Public License v3*  
Florian Krause (florian@expyriment.org) & Oliver Lindemann (oliver@expyriment.org)

Documentation
=============
Documentation can be found in the directory "documentation".
For online documentation see: 
http://docs.expyriment.org

Examples
========
Examples can be found in the directory "examples".
For online examples see: 
http://docs.expyriment.org/Examples.html

Installation
============

Detailed installation instructions can be found in the documentation.
For online installation instructions see:
http://docs.expyriment.org/Installation.html

Reference
=========
Krause, F. & Lindemann, O. (2013). Expyriment: A Python library for cognitive and neuroscientific experiments. *Behavior Research Methods*. http://dx.doi.org/10.3758/s13428-013-0390-6
