/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_PATH_H_
#define _OPENRIJN_PATH_H_

#include <cstddef>

#include <OpenRijn/DrawingPoint.h>
#include <OpenRijn/Export.h>

namespace GTLCore {
  class RegionF;
}

namespace OpenRijn {
  /**
   * @ingroup OpenRijn
   *
   * Define a path, a set of lines and curves.
   */
  class OPENRIJN_EXPORT Path {
    public:
      enum ElementType {
        MoveToElement,
        LineToElement,
        CurveToElement
      };
      struct Element {
        ElementType type;
        DrawingPoint point;
      };
      struct CurveElement : public Element {
        float x1, y1, x2, y2;
      };
    public:
      Path();
      Path(const Path&);
      Path& operator=(const Path& );
      ~Path();
    public:
      void moveTo(const DrawingPoint&);
      void lineTo(const DrawingPoint&);
      void curveTo(float x1, float y1, float x2, float y2, const DrawingPoint& pt2);
      std::size_t elementCount() const;
      const Element* elementAt(int idx) const;
      GTLCore::RegionF boundingRegion() const;
    private:
      inline void deref();
    private:
      struct Private;
      Private* d;
  };
}

#endif
