#!/bin/sh

VERSION_FILE=$1
OUTPUT_FILE=$2

if test -z "$VERSION_FILE";then
    $VERSION_FILE="VERSION"
fi

if test -z "$OUTPUT_FILE";then
    $OUTPUT_FILE="libmapi/version.h"
fi

OPENCHANGE_VERSION_STRING=$3
SOURCE_DIR=$4

OPENCHANGE_MAJOR_RELEASE=`echo ${OPENCHANGE_VERSION_STRING} | cut -d. -f1`
OPENCHANGE_MINOR_RELEASE=`echo ${OPENCHANGE_VERSION_STRING} | cut -d. -f2`

OPENCHANGE_VERSION_IS_SVN_SNAPSHOT=`sed -n 's/^OPENCHANGE_VERSION_IS_SVN_SNAPSHOT=//p' $SOURCE_DIR$VERSION_FILE`
OPENCHANGE_VERSION_RELEASE_NICKNAME=`sed -n 's/^OPENCHANGE_VERSION_RELEASE_NICKNAME=//p' $SOURCE_DIR$VERSION_FILE`
OPENCHANGE_VERSION_RELEASE_NUMBER=`sed -n 's/^OPENCHANGE_VERSION_RELEASE_NUMBER=//p' $SOURCE_DIR$VERSION_FILE`

TMPFILE=`mktemp`

echo "/* Autogenerated by script/mkversion.h */" >> $TMPFILE
echo "#define OPENCHANGE_MAJOR_RELEASE ${OPENCHANGE_MAJOR_RELEASE}" >> $TMPFILE
echo "#define OPENCHANGE_MINOR_RELEASE ${OPENCHANGE_MINOR_RELEASE}" >> $TMPFILE

#
# SVN revision number
#
if test x"${OPENCHANGE_VERSION_IS_SVN_SNAPSHOT}" = x"yes";then
    _SAVE_LANG=${LANG}
    LANG=""
    HAVEVER="no"

    if test x"${HAVEVER}" != x"yes";then
        HAVESVN=no
        SVN_INFO=`svn info ${SOURCE_DIR} 2>/dev/null`
        TMP_REVISION=`echo -e "${SVN_INFO}" | grep 'Last Changed Rev.*:' |sed -e 's/Last Changed Rev.*: \([0-9]*\).*/\1/'`
        if test -n "$TMP_REVISION"; then
            HAVESVN=yes
            HAVEVER=yes
        fi
    fi

    if test x"${HAVESVN}" = x"yes";then
        OPENCHANGE_VERSION_STRING="${OPENCHANGE_VERSION_STRING}-SVN-build-${TMP_REVISION}"
        echo "#define OPENCHANGE_VERSION_SVN_REVISION ${TMP_REVISION}" >> $TMPFILE
    fi

    LANG=${_SAVE_LANG}
fi

if test -z "${OPENCHANGE_VERSION_RELEASE_NUMBER}";then
    echo "#define OPENCHANGE_VERSION_OFFICIAL_STRING \"${OPENCHANGE_VERSION_STRING}\"" >> $TMPFILE
else
    OPENCHANGE_VERSION_STRING="${OPENCHANGE_VERSION_RELEASE_NUMBER}"
    echo "#define OPENCHANGE_VERSION_OFFICIAL_STRING \"${OPENCHANGE_VERSION_RELEASE_NUMBER}\"" >> $TMPFILE
fi

##
## Add a release nickname
##
if test -n "${OPENCHANGE_VERSION_RELEASE_NICKNAME}";then
    echo "#define OPENCHANGE_VERSION_RELEASE_NICKNAME ${OPENCHANGE_VERSION_RELEASE_NICKNAME}" >> $TMPFILE
    OPENCHANGE_VERSION_STRING="${OPENCHANGE_VERSION_STRING} (${OPENCHANGE_VERSION_RELEASE_NICKNAME})"
fi

echo "#define OPENCHANGE_VERSION_STRING \"${OPENCHANGE_VERSION_STRING}\"" >> $TMPFILE

##
## Add some System related information (useful for debug and report)
##
echo "" >> $TMPFILE
echo "/* System related information */" >> $TMPFILE

OPENCHANGE_SYS_KERNEL_NAME=`uname -s`
OPENCHANGE_SYS_KERNEL_RELEASE=`uname -r`
OPENCHANGE_SYS_PROCESSOR=`uname -p`

echo "#define OPENCHANGE_SYS_KERNEL_NAME \"${OPENCHANGE_SYS_KERNEL_NAME}\"" >> $TMPFILE
echo "#define OPENCHANGE_SYS_KERNEL_RELEASE \"${OPENCHANGE_SYS_KERNEL_RELEASE}\"" >> $TMPFILE
echo "#define OPENCHANGE_SYS_PROCESSOR \"${OPENCHANGE_SYS_PROCESSOR}\"" >> $TMPFILE

mv "$TMPFILE" "$OUTPUT_FILE"

echo "$0: '$OUTPUT_FILE' created for OpenChange libmapi(\"${OPENCHANGE_VERSION_STRING}\")"

exit 0
