/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "bamf-indicator.h"
#include "bamf-indicator-proxy.h"
#include "bamf-factory.h"

BamfIndicator::BamfIndicator(QString path) :
    BamfView(path), m_indicator_proxy(NULL)
{
    m_indicator_proxy = new OrgAyatanaBamfIndicatorInterface("org.ayatana.bamf", path,
                                                             QDBusConnection::sessionBus(),
                                                             static_cast<QObject*>(this));
}

BamfIndicator::~BamfIndicator()
{
    delete m_indicator_proxy;
}

const QString
BamfIndicator::address() const
{
    QDBusPendingReply<QString> reply = m_indicator_proxy->Address();
    reply.waitForFinished();
    if (reply.isError()) {
        qWarning() << reply.error();
        return QString();
    } else {
        return reply.value();
    }
}

const QString
BamfIndicator::path() const
{
    QDBusPendingReply<QString> reply = m_indicator_proxy->Path();
    reply.waitForFinished();
    if (reply.isError()) {
        qWarning() << reply.error();
        return QString();
    } else {
        return reply.value();
    }
}

const QString
BamfIndicator::dbus_menu_path() const
{
    QDBusInterface remote(address(), path(), "org.kde.StatusNotifierItem");
    if (remote.isValid()) {
        QVariant objectPath = remote.property("Menu");
        if (objectPath.isValid()) {
            return objectPath.value<QDBusObjectPath>().path();
        }
    }
    return QString();
}

