/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/**
 *
 * @author Petr Hejl
 */
public class RenamePanel extends javax.swing.JPanel implements DocumentListener {

    private final ChangeSupport changeSupport = new ChangeSupport(this);

    private final String serverName;

    /**
     * Creates new form ServerInstanceRenamePanel
     */
    public RenamePanel(String name) {
        this.serverName = name;
        
        initComponents();

        nameTextField.setText(name);
        nameTextField.getDocument().addDocumentListener(this);
        validateDialog();
    }

    public String getServerName() {
        return nameTextField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        //ignored
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        validateDialog();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        validateDialog();
    }

    public boolean isPanelValid() {
        return " ".equals(errorMessage.getText());
    }

    public void addChangeListener(ChangeListener l) {
        changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        changeSupport.removeChangeListener(l);
    }

    private void validateDialog() {
        String newError = computeError();
        boolean changed = false;
        String currentError = errorMessage.getText();

        newError = newError != null ? newError : " ";
        changed = !currentError.equals(newError);

        errorMessage.setText(newError);

        if (changed) {
            changeSupport.fireChange();
        }
    }

    @NbBundle.Messages("MSG_ErrorEmptyName=Server name must be entered.")
    private String computeError() {
        if (nameTextField == null || nameTextField.getText().isEmpty()) {
            return Bundle.MSG_ErrorEmptyName();
        }

        return null;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        renameLabel = new javax.swing.JLabel();
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        errorMessage = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(renameLabel, org.openide.util.NbBundle.getMessage(RenamePanel.class, "RenamePanel.renameLabel.text", new Object[] {serverName})); // NOI18N

        nameLabel.setLabelFor(nameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(RenamePanel.class, "RenamePanel.nameLabel.text")); // NOI18N

        nameTextField.setColumns(30);

        errorMessage.setForeground(UIManager.getColor("nb.errorForeground"));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(renameLabel)
            .addGroup(layout.createSequentialGroup()
                .addComponent(nameLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(nameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 287, Short.MAX_VALUE))
            .addComponent(errorMessage)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(renameLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nameLabel)
                    .addComponent(nameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(errorMessage))
        );

        nameTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(RenamePanel.class, "RenamePanel.nameTextField.AccessibleContext.accessibleName", new Object[] {})); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel errorMessage;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JLabel renameLabel;
    // End of variables declaration//GEN-END:variables
}
