; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mcpu=future < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-aix \
; RUN:   -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mcpu=future < %s | FileCheck %s --check-prefix=AIX
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-aix \
; RUN:   -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mcpu=future < %s | FileCheck %s --check-prefix=AIX32

declare <1024 x i1> @llvm.ppc.mma.dmxvbf16gerx2pp(<1024 x i1>, <256 x i1>, <16 x i8>)
declare void @dummy_func()

define void @spillDMRreg(ptr %vop, ptr %vpp, ptr %vcp, ptr %resp) nounwind {
; CHECK-LABEL: spillDMRreg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r0, 16(r1)
; CHECK-NEXT:    stdu r1, -176(r1)
; CHECK-NEXT:    lxvp vsp34, 0(r3)
; CHECK-NEXT:    lxvp vsp36, 32(r3)
; CHECK-NEXT:    mr r30, r6
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-NEXT:    lxvp vsp34, 64(r3)
; CHECK-NEXT:    lxvp vsp36, 96(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-NEXT:    lxv v2, 16(r4)
; CHECK-NEXT:    lxv v3, 0(r4)
; CHECK-NEXT:    lxv vs0, 0(r5)
; CHECK-NEXT:    dmxvbf16gerx2pp dmr0, vsp34, vs0
; CHECK-NEXT:    dmxxextfdmr512 vsp36, vsp34, wacc0, 0
; CHECK-NEXT:    stxvp vsp36, 128(r1)
; CHECK-NEXT:    stxvp vsp34, 96(r1)
; CHECK-NEXT:    dmxxextfdmr512 vsp36, vsp34, wacc_hi0, 1
; CHECK-NEXT:    stxvp vsp36, 64(r1)
; CHECK-NEXT:    stxvp vsp34, 32(r1)
; CHECK-NEXT:    bl dummy_func@notoc
; CHECK-NEXT:    lxvp vsp34, 128(r1)
; CHECK-NEXT:    lxvp vsp36, 96(r1)
; CHECK-NEXT:    dmxxinstdmr512 wacc0, vsp34, vsp36, 0
; CHECK-NEXT:    lxvp vsp34, 64(r1)
; CHECK-NEXT:    lxvp vsp36, 32(r1)
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi0, vsp34, vsp36, 1
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-NEXT:    stxvp vsp34, 96(r30)
; CHECK-NEXT:    stxvp vsp36, 64(r30)
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-NEXT:    stxvp vsp34, 32(r30)
; CHECK-NEXT:    stxvp vsp36, 0(r30)
; CHECK-NEXT:    addi r1, r1, 176
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
;
; AIX-LABEL: spillDMRreg:
; AIX:       # %bb.0:
; AIX-NEXT:    mflr r0
; AIX-NEXT:    std r0, 16(r1)
; AIX-NEXT:    stdu r1, -256(r1)
; AIX-NEXT:    std r31, 248(r1) # 8-byte Folded Spill
; AIX-NEXT:    lxvp vsp34, 96(r3)
; AIX-NEXT:    lxvp vsp36, 64(r3)
; AIX-NEXT:    mr r31, r6
; AIX-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; AIX-NEXT:    lxvp vsp34, 32(r3)
; AIX-NEXT:    lxvp vsp36, 0(r3)
; AIX-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; AIX-NEXT:    lxv v2, 0(r4)
; AIX-NEXT:    lxv v3, 16(r4)
; AIX-NEXT:    lxv vs0, 0(r5)
; AIX-NEXT:    dmxvbf16gerx2pp dmr0, vsp34, vs0
; AIX-NEXT:    dmxxextfdmr512 vsp36, vsp34, wacc0, 0
; AIX-NEXT:    stxvp vsp36, 112(r1)
; AIX-NEXT:    stxvp vsp34, 144(r1)
; AIX-NEXT:    dmxxextfdmr512 vsp36, vsp34, wacc_hi0, 1
; AIX-NEXT:    stxvp vsp36, 176(r1)
; AIX-NEXT:    stxvp vsp34, 208(r1)
; AIX-NEXT:    bl .dummy_func[PR]
; AIX-NEXT:    nop
; AIX-NEXT:    lxvp vsp34, 112(r1)
; AIX-NEXT:    lxvp vsp36, 144(r1)
; AIX-NEXT:    dmxxinstdmr512 wacc0, vsp34, vsp36, 0
; AIX-NEXT:    lxvp vsp34, 176(r1)
; AIX-NEXT:    lxvp vsp36, 208(r1)
; AIX-NEXT:    dmxxinstdmr512 wacc_hi0, vsp34, vsp36, 1
; AIX-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; AIX-NEXT:    stxvp vsp36, 96(r31)
; AIX-NEXT:    stxvp vsp34, 64(r31)
; AIX-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; AIX-NEXT:    stxvp vsp36, 32(r31)
; AIX-NEXT:    stxvp vsp34, 0(r31)
; AIX-NEXT:    ld r31, 248(r1) # 8-byte Folded Reload
; AIX-NEXT:    addi r1, r1, 256
; AIX-NEXT:    ld r0, 16(r1)
; AIX-NEXT:    mtlr r0
; AIX-NEXT:    blr
;
; AIX32-LABEL: spillDMRreg:
; AIX32:       # %bb.0:
; AIX32-NEXT:    mflr r0
; AIX32-NEXT:    stw r0, 8(r1)
; AIX32-NEXT:    stwu r1, -208(r1)
; AIX32-NEXT:    stw r31, 204(r1) # 4-byte Folded Spill
; AIX32-NEXT:    lxvp vsp34, 96(r3)
; AIX32-NEXT:    lxvp vsp36, 64(r3)
; AIX32-NEXT:    mr r31, r6
; AIX32-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; AIX32-NEXT:    lxvp vsp34, 32(r3)
; AIX32-NEXT:    lxvp vsp36, 0(r3)
; AIX32-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; AIX32-NEXT:    lxv v2, 0(r4)
; AIX32-NEXT:    lxv v3, 16(r4)
; AIX32-NEXT:    lxv vs0, 0(r5)
; AIX32-NEXT:    dmxvbf16gerx2pp dmr0, vsp34, vs0
; AIX32-NEXT:    dmxxextfdmr512 vsp36, vsp34, wacc0, 0
; AIX32-NEXT:    stxvp vsp36, 64(r1)
; AIX32-NEXT:    stxvp vsp34, 96(r1)
; AIX32-NEXT:    dmxxextfdmr512 vsp36, vsp34, wacc_hi0, 1
; AIX32-NEXT:    stxvp vsp36, 128(r1)
; AIX32-NEXT:    stxvp vsp34, 160(r1)
; AIX32-NEXT:    bl .dummy_func[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lxvp vsp34, 64(r1)
; AIX32-NEXT:    lxvp vsp36, 96(r1)
; AIX32-NEXT:    dmxxinstdmr512 wacc0, vsp34, vsp36, 0
; AIX32-NEXT:    lxvp vsp34, 128(r1)
; AIX32-NEXT:    lxvp vsp36, 160(r1)
; AIX32-NEXT:    dmxxinstdmr512 wacc_hi0, vsp34, vsp36, 1
; AIX32-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; AIX32-NEXT:    stxvp vsp36, 96(r31)
; AIX32-NEXT:    stxvp vsp34, 64(r31)
; AIX32-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; AIX32-NEXT:    stxvp vsp36, 32(r31)
; AIX32-NEXT:    stxvp vsp34, 0(r31)
; AIX32-NEXT:    lwz r31, 204(r1) # 4-byte Folded Reload
; AIX32-NEXT:    addi r1, r1, 208
; AIX32-NEXT:    lwz r0, 8(r1)
; AIX32-NEXT:    mtlr r0
; AIX32-NEXT:    blr
  %v.dmr = load <1024 x i1>, ptr %vop, align 64
  %v1 = load <256 x i1>, ptr %vpp, align 32
  %v2 = load <16 x i8>, ptr %vcp, align 32
  %call = tail call <1024 x i1> @llvm.ppc.mma.dmxvbf16gerx2pp(<1024 x i1> %v.dmr, <256 x i1> %v1, <16 x i8> %v2)
  tail call void @dummy_func()
  %call2 = tail call <1024 x i1> @llvm.ppc.mma.dmxvbf16gerx2pp(<1024 x i1> %v.dmr, <256 x i1> %v1, <16 x i8> %v2)
  store <1024 x i1> %call, ptr %resp, align 64
  ret void
}
