/*
 * SPDX-License-Identifier: ODbL-1.0
 * SPDX-FileCopyrightText: OpenStreetMap contributors
 *
 * This code is auto-generated from OpenStreetMap (licensed under ODbL) and Wikidata (licensed under CC0), do not edit!
 */


#include "airportdb.h"
#include "airportdb_p.h"
#include "knowledgedb.h"
#include "timezonedb.h"
#include "timezonedb_data.h"

#include <limits>

using namespace KItinerary::KnowledgeDb;

namespace KItinerary {
namespace KnowledgeDb {

// airport data sorted by IATA code
// the corresponding index is used to access data the following tables
static constexpr Airport airport_table[] = {
    Airport{IataCode{"AAA"}, CountryId{"FR"}, Coordinate{-145.512, -17.3489}}, // Anaa Airport
    Airport{IataCode{"AAB"}, CountryId{"AU"}, Coordinate{141.047, -26.6906}}, // Arrabury Airport
    Airport{IataCode{"AAC"}, CountryId{"EG"}, Coordinate{33.8368, 31.0786}}, // El Arish International Airport
    Airport{IataCode{"AAD"}, CountryId{"SO"}, Coordinate{46.6375, 6.09583}}, // Adado Airport
    Airport{IataCode{"AAE"}, CountryId{"DZ"}, Coordinate{7.81647, 36.8228}}, // Rabah Bitat Airport
    Airport{IataCode{"AAF"}, CountryId{"US"}, Coordinate{-85.0275, 29.7275}}, // Apalachicola Regional Airport
    Airport{IataCode{"AAI"}, CountryId{"BR"}, Coordinate{-56.9917, -13.0239}}, // Arraias Airport
    Airport{IataCode{"AAJ"}, CountryId{"SR"}, Coordinate{-55.5778, 3.89861}}, // Cayana Airstrip
    Airport{IataCode{"AAK"}, CountryId{"KI"}, Coordinate{173.636, 0.185278}}, // Aranuka Airport
    Airport{IataCode{"AAL"}, CountryId{"DK"}, Coordinate{9.84917, 57.0928}}, // Aalborg Airport
    Airport{IataCode{"AAM"}, CountryId{"ZA"}, Coordinate{31.5447, -24.8181}}, // Mala Mala Airport
    Airport{IataCode{"AAN"}, CountryId{"AE"}, Coordinate{55.6149, 24.2595}}, // Al Ain International Airport
    Airport{IataCode{"AAO"}, CountryId{"VE"}, Coordinate{-64.4708, 9.4303}}, // Anaco Airport
    Airport{IataCode{"AAP"}, CountryId{"ID"}, Coordinate{117.254, -0.376389}}, // Samarinda International Airport
    Airport{IataCode{"AAQ"}, CountryId{"RU"}, Coordinate{37.3407, 45.0032}}, // Anapa Airport
    Airport{IataCode{"AAR"}, CountryId{"DK"}, Coordinate{10.6279, 56.3077}}, // Aarhus Airport
    Airport{IataCode{"AAS"}, CountryId{"ID"}, Coordinate{139.311, -3.88472}}, // Apalapsili Airport
    Airport{IataCode{"AAT"}, CountryId{"CN"}, Coordinate{88.0873, 47.7523}}, // Altay Airport
    Airport{IataCode{"AAU"}, CountryId{"WS"}, Coordinate{-172.628, -13.505}}, // Asau Airport
    Airport{IataCode{"AAV"}, CountryId{"PH"}, Coordinate{124.753, 6.36777}}, // Allah Valley Airport
    Airport{IataCode{"AAY"}, CountryId{"YE"}, Coordinate{52.1725, 16.1918}}, // Al Ghaydah Airport
    Airport{IataCode{"AAZ"}, CountryId{"GT"}, Coordinate{-91.5019, 14.8656}}, // Quetzaltenango International Airport
    Airport{IataCode{"ABA"}, CountryId{"RU"}, Coordinate{91.3997, 53.7513}}, // Abakan International Airport
    Airport{IataCode{"ABB"}, CountryId{"NG"}, Coordinate{6.6611, 6.20918}}, // Asaba International Airport
    Airport{IataCode{"ABC"}, CountryId{"ES"}, Coordinate{-1.87954, 38.9451}}, // Albacete Airport
    Airport{IataCode{"ABD"}, CountryId{"IR"}, Coordinate{48.227, 30.364}}, // Abadan International Airport
    Airport{IataCode{"ABE"}, CountryId{"US"}, Coordinate{-75.4347, 40.6523}}, // Lehigh Valley International Airport
    Airport{IataCode{"ABF"}, CountryId{"KI"}, Coordinate{173.04, 1.79899}}, // Abaiang Atoll Airport
    Airport{IataCode{"ABG"}, CountryId{"AU"}, Coordinate{143.184, -17.6075}}, // Abingdon Airport
    Airport{IataCode{"ABH"}, CountryId{"AU"}, Coordinate{146.583, -23.6467}}, // Alpha Airport
    Airport{IataCode{"ABI"}, CountryId{"US"}, Coordinate{-99.6801, 32.4115}}, // Abilene Regional Airport
    Airport{IataCode{"ABJ"}, CountryId{"CI"}, Coordinate{-3.93382, 5.25094}}, // Port Bouet Airport
    Airport{IataCode{"ABK"}, CountryId{"ET"}, Coordinate{44.2416, 6.73281}}, // Kabri Dar Airport
    Airport{IataCode{"ABL"}, CountryId{"US"}, Coordinate{-157.857, 67.1066}}, // Ambler Airport
    Airport{IataCode{"ABM"}, CountryId{"AU"}, Coordinate{142.459, -10.9508}}, // Northern Peninsula Airport
    Airport{IataCode{"ABN"}, CountryId{"SR"}, Coordinate{-54.0501, 5.51272}}, // Albina Airstrip
    Airport{IataCode{"ABO"}, CountryId{"CI"}, Coordinate{-3.26667, 5.43306}}, // Aboisso Airport
    Airport{IataCode{"ABP"}, CountryId{"PG"}, Coordinate{141.1, -6.06667}}, // Atkamba Airport
    Airport{IataCode{"ABQ"}, CountryId{"US"}, Coordinate{-106.616, 35.0484}}, // Albuquerque International Sunport
    Airport{IataCode{"ABR"}, CountryId{"US"}, Coordinate{-98.4185, 45.453}}, // Aberdeen Regional Airport
    Airport{IataCode{"ABS"}, CountryId{"EG"}, Coordinate{31.6117, 22.3758}}, // Abu Simbel Airport
    Airport{IataCode{"ABT"}, CountryId{"SA"}, Coordinate{41.6343, 20.2961}}, // Al-Baha Domestic Airport
    Airport{IataCode{"ABU"}, CountryId{"ID"}, Coordinate{124.9, -9.33333}}, // A. A. Bere Tallo Airport
    Airport{IataCode{"ABV"}, CountryId{"NG"}, Coordinate{7.2724, 9.00671}}, // Nnamdi Azikiwe International Airport verga peluda
    Airport{IataCode{"ABX"}, CountryId{"AU"}, Coordinate{146.934, -36.065}}, // Albury Airport
    Airport{IataCode{"ABY"}, CountryId{"US"}, Coordinate{-84.1944, 31.5356}}, // Southwest Georgia Regional Airport
    Airport{IataCode{"ABZ"}, CountryId{"GB"}, Coordinate{-2.19778, 57.2019}}, // Aberdeen Airport
    Airport{IataCode{"ACA"}, CountryId{"MX"}, Coordinate{-99.7516, 16.756}}, // General Juan N. Álvarez International Airport
    Airport{IataCode{"ACB"}, CountryId{"US"}, Coordinate{-85.1983, 44.9886}}, // Antrim County Airport
    Airport{IataCode{"ACC"}, CountryId{"GH"}, Coordinate{-0.171958, 5.60442}}, // Kotoka International Airport
    Airport{IataCode{"ACD"}, CountryId{"CO"}, Coordinate{-77.2739, 8.49806}}, // Alcides Fernández Airport
    Airport{IataCode{"ACE"}, CountryId{"ES"}, Coordinate{-13.6078, 28.9509}}, // César Manrique Lanzarote Airport
    Airport{IataCode{"ACH"}, CountryId{"CH"}, Coordinate{9.56083, 47.485}}, // St. Gallen-Altenrhein Airport
    Airport{IataCode{"ACI"}, CountryId{"GB"}, Coordinate{-2.21472, 49.7088}}, // Alderney Airport
    Airport{IataCode{"ACK"}, CountryId{"US"}, Coordinate{-70.0637, 41.2568}}, // Nantucket Memorial Airport
    Airport{IataCode{"ACL"}, CountryId{"CO"}, Coordinate{-72.9906, 4.74694}}, // Aguaclara Airport
    Airport{IataCode{"ACN"}, CountryId{"MX"}, Coordinate{-101.101, 29.3317}}, // Ciudad Acuña International Airport
    Airport{IataCode{"ACP"}, CountryId{"IR"}, Coordinate{46.1279, 37.348}}, // Sahand Airport
    Airport{IataCode{"ACR"}, CountryId{"CO"}, Coordinate{-72.3981, -0.601111}}, // Araracuara Airport
    Airport{IataCode{"ACS"}, CountryId{"RU"}, Coordinate{90.5626, 56.2705}}, // Achinsk Airport
    Airport{IataCode{"ACT"}, CountryId{"US"}, Coordinate{-97.2233, 31.6093}}, // Waco Regional Airport
    Airport{IataCode{"ACU"}, CountryId{"PA"}, Coordinate{-78.0167, 9.18333}}, // Achutupo Airport
    Airport{IataCode{"ACV"}, CountryId{"US"}, Coordinate{-124.107, 40.971}}, // Arcata-Eureka Airport
    Airport{IataCode{"ACX"}, CountryId{"CN"}, Coordinate{104.956, 25.0854}}, // Xingyi Wanfenglin Airport
    Airport{IataCode{"ACY"}, CountryId{"US"}, Coordinate{-74.5724, 39.4514}}, // Atlantic City International Airport
    Airport{IataCode{"ACZ"}, CountryId{"IR"}, Coordinate{61.5439, 31.0983}}, // Zabol Airport
    Airport{IataCode{"ADA"}, CountryId{"TR"}, Coordinate{35.2965, 36.9849}}, // Adana Şakirpaşa Airport
    Airport{IataCode{"ADB"}, CountryId{"TR"}, Coordinate{27.155, 38.2892}}, // İzmir Adnan Menderes Airport
    Airport{IataCode{"ADC"}, CountryId{"PG"}, Coordinate{145.733, -7.13333}}, // Andakombe Airport
    Airport{IataCode{"ADD"}, CountryId{"ET"}, Coordinate{38.7956, 8.98246}}, // Addis Ababa Bole International Airport
    Airport{IataCode{"ADE"}, CountryId{"YE"}, Coordinate{45.0375, 12.8256}}, // Aden International Airport
    Airport{IataCode{"ADF"}, CountryId{"TR"}, Coordinate{38.4705, 37.7364}}, // Adıyaman Airport
    Airport{IataCode{"ADG"}, CountryId{"US"}, Coordinate{-84.0739, 41.8735}}, // Lenawee County Airport
    Airport{IataCode{"ADH"}, CountryId{"RU"}, Coordinate{125.398, 58.6025}}, // Aldan Airport
    Airport{IataCode{"ADI"}, CountryId{"NA"}, Coordinate{14.98, -22.4622}}, // Arandis Airport
    Airport{IataCode{"ADJ"}, CountryId{"JO"}, Coordinate{35.9914, 31.9725}}, // Amman Civil Airport
    Airport{IataCode{"ADK"}, CountryId{"US"}, Coordinate{-176.646, 51.8781}}, // Adak Airport
    Airport{IataCode{"ADL"}, CountryId{"AU"}, Coordinate{138.537, -34.9386}}, // Adelaide Airport
    Airport{IataCode{"ADM"}, CountryId{"US"}, Coordinate{-97.0206, 34.3042}}, // Ardmore Municipal Airport
    Airport{IataCode{"ADO"}, CountryId{"AU"}, Coordinate{137.137, -30.4383}}, // Andamooka Airport
    Airport{IataCode{"ADP"}, CountryId{"LK"}, Coordinate{81.6258, 7.33722}}, // SLAF Ampara
    Airport{IataCode{"ADQ"}, CountryId{"US"}, Coordinate{-152.494, 57.7497}}, // Kodiak Airport
    Airport{IataCode{"ADR"}, CountryId{"US"}, Coordinate{-79.5261, 33.4517}}, // Robert F. Swinnie Airport
    Airport{IataCode{"ADS"}, CountryId{"US"}, Coordinate{-96.8364, 32.9686}}, // Addison Airport
    Airport{IataCode{"ADT"}, CountryId{"US"}, Coordinate{-96.6742, 34.804}}, // Ada Municipal Airport
    Airport{IataCode{"ADU"}, CountryId{"IR"}, Coordinate{48.4205, 38.3237}}, // Ardabil Airport
    Airport{IataCode{"ADV"}, CountryId{"SD"}, Coordinate{26.1192, 11.4036}}, // Ed Daein Airport
    Airport{IataCode{"ADY"}, CountryId{"ZA"}, Coordinate{29.0555, -22.679}}, // Alldays Airport
    Airport{IataCode{"ADZ"}, CountryId{"CO"}, Coordinate{-81.7022, 12.5864}}, // Gustavo Rojas Pinilla International Airport
    Airport{IataCode{"AEA"}, CountryId{"KI"}, Coordinate{173.829, 0.490833}}, // Abemama Airport
    Airport{IataCode{"AEB"}, CountryId{"CN"}, Coordinate{106.959, 23.7194}}, // Baise Bama Airport
    Airport{IataCode{"AEG"}, CountryId{"ID"}, Coordinate{99.4296, 1.39891}}, // Aek Godang Airport
    Airport{IataCode{"AEK"}, CountryId{"PG"}, Coordinate{146.194, -7.35087}}, // Aseki Airport
    Airport{IataCode{"AEL"}, CountryId{"US"}, Coordinate{-93.3672, 43.6817}}, // Albert Lea Municipal Airport
    Airport{IataCode{"AEO"}, CountryId{"MR"}, Coordinate{-9.63901, 16.7145}}, // Aioun el Atrouss Airport
    Airport{IataCode{"AEP"}, CountryId{"AR"}, Coordinate{-58.4139, -34.5569}}, // Aeroparque Jorge Newbery
    Airport{IataCode{"AEQ"}, CountryId{"CN"}, Coordinate{120.16, 43.8704}}, // Ar Horqin Airport
    Airport{IataCode{"AER"}, CountryId{"RU"}, Coordinate{39.9385, 43.4486}}, // Sochi International Airport
    Airport{IataCode{"AES"}, CountryId{"NO"}, Coordinate{6.11542, 62.5586}}, // Ålesund Airport, Vigra
    Airport{IataCode{"AET"}, CountryId{"US"}, Coordinate{-152.622, 66.5519}}, // Allakaket Airport
    Airport{IataCode{"AEU"}, CountryId{"IR"}, Coordinate{55.0256, 25.8787}}, // Abu Musa Airport
    Airport{IataCode{"AEX"}, CountryId{"US"}, Coordinate{-92.5421, 31.323}}, // Alexandria International Airport
    Airport{IataCode{"AEY"}, CountryId{"IS"}, Coordinate{-18.076, 65.6544}}, // Akureyri Airport
    Airport{IataCode{"AFA"}, CountryId{"AR"}, Coordinate{-68.4036, -34.5967}}, // San Rafael Airport
    Airport{IataCode{"AFD"}, CountryId{"ZA"}, Coordinate{26.8797, -33.5542}}, // Port Alfred Airport
    Airport{IataCode{"AFI"}, CountryId{"CO"}, Coordinate{-75.0667, 6.89444}}, // Amalfi Airport
    Airport{IataCode{"AFK"}, CountryId{"US"}, Coordinate{-95.8678, 40.6056}}, // Nebraska City Municipal Airport
    Airport{IataCode{"AFN"}, CountryId{"US"}, Coordinate{-72.003, 42.8051}}, // Jaffrey Airport – Silver Ranch Airpark
    Airport{IataCode{"AFO"}, CountryId{"US"}, Coordinate{-110.942, 42.7089}}, // Afton Municipal Airport
    Airport{IataCode{"AFR"}, CountryId{"PG"}, Coordinate{148.395, -9.13176}}, // Afore Airport
    Airport{IataCode{"AFT"}, CountryId{"SB"}, Coordinate{160.948, -9.19139}}, // Afutara Airport
    Airport{IataCode{"AFW"}, CountryId{"US"}, Coordinate{-97.3189, 32.9878}}, // Fort Worth Alliance Airport
    Airport{IataCode{"AFY"}, CountryId{"TR"}, Coordinate{30.6011, 38.7264}}, // Afyon Airport
    Airport{IataCode{"AFZ"}, CountryId{"IR"}, Coordinate{57.6033, 36.1712}}, // Sabzevar Airport
    Airport{IataCode{"AGA"}, CountryId{"MA"}, Coordinate{-9.4105, 30.3301}}, // Agadir–Al Massira Airport
    Airport{IataCode{"AGC"}, CountryId{"US"}, Coordinate{-79.9302, 40.3544}}, // Allegheny County Airport
    Airport{IataCode{"AGD"}, CountryId{"BR"}, Coordinate{-59.2583, -13.6981}}, // Anggi Airport
    Airport{IataCode{"AGF"}, CountryId{"FR"}, Coordinate{0.59422, 44.1763}}, // Agen La Garenne Airport
    Airport{IataCode{"AGI"}, CountryId{"SR"}, Coordinate{-56.6333, 5.76667}}, // Wageningen Airstrip
    Airport{IataCode{"AGJ"}, CountryId{"JP"}, Coordinate{127.24, 26.5928}}, // Aguni Airport
    Airport{IataCode{"AGK"}, CountryId{"PG"}, Coordinate{143.854, -6.39693}}, // Kagua Airport
    Airport{IataCode{"AGL"}, CountryId{"PG"}, Coordinate{149.156, -9.3375}}, // Wanigela Airport
    Airport{IataCode{"AGO"}, CountryId{"US"}, Coordinate{-93.2169, 33.2275}}, // Magnolia Municipal Airport
    Airport{IataCode{"AGP"}, CountryId{"ES"}, Coordinate{-4.49155, 36.6755}}, // Málaga Airport
    Airport{IataCode{"AGS"}, CountryId{"US"}, Coordinate{-82.0628, 33.1994}}, // Augusta Regional Airport
    Airport{IataCode{"AGT"}, CountryId{"PY"}, Coordinate{-54.8394, -25.4569}}, // Guaraní International Airport
    Airport{IataCode{"AGU"}, CountryId{"MX"}, Coordinate{-102.314, 21.7013}}, // Lic. Jesús Terán Peredo International Airport
    Airport{IataCode{"AGV"}, CountryId{"VE"}, Coordinate{-69.234, 9.54981}}, // Oswaldo Guevara Mujica Airport
    Airport{IataCode{"AGX"}, CountryId{"IN"}, Coordinate{72.1795, 10.8284}}, // Agatti Aerodrome
    Airport{IataCode{"AGZ"}, CountryId{"ZA"}, Coordinate{18.8155, -29.2773}}, // Aggeneys Airport
    Airport{IataCode{"AHB"}, CountryId{"SA"}, Coordinate{42.6579, 18.2346}}, // Abha Regional Airport
    Airport{IataCode{"AHD"}, CountryId{"US"}, Coordinate{-97.1228, 34.1469}}, // Ardmore Downtown Executive Airport
    Airport{IataCode{"AHE"}, CountryId{"FR"}, Coordinate{-146.257, -14.4281}}, // Ahe Airport
    Airport{IataCode{"AHF"}, CountryId{"US"}, Coordinate{-99.9064, 40.3394}}, // Arapahoe Municipal Airport
    Airport{IataCode{"AHH"}, CountryId{"US"}, Coordinate{-92.3753, 45.2811}}, // Amery Municipal Airport
    Airport{IataCode{"AHI"}, CountryId{"ID"}, Coordinate{128.917, -3.33333}}, // Amahai Airport
    Airport{IataCode{"AHJ"}, CountryId{"CN"}, Coordinate{102.357, 32.5292}}, // Hongyuan Airport
    Airport{IataCode{"AHL"}, CountryId{"GY"}, Coordinate{-59.3222, 2.47222}}, // Aishalton Airport
    Airport{IataCode{"AHM"}, CountryId{"US"}, Coordinate{-122.657, 42.1891}}, // Ashland Municipal Airport
    Airport{IataCode{"AHN"}, CountryId{"US"}, Coordinate{-83.3264, 33.9486}}, // Athens Ben Epps Airport
    Airport{IataCode{"AHO"}, CountryId{"IT"}, Coordinate{8.29567, 40.6307}}, // Aeroporto di Alghero-Fertilia
    Airport{IataCode{"AHS"}, CountryId{"HN"}, Coordinate{-84.3522, 15.4722}}, // Ahuas Airport
    Airport{IataCode{"AHU"}, CountryId{"MA"}, Coordinate{-3.84308, 35.1789}}, // Cherif Al Idrissi Airport
    Airport{IataCode{"AHW"}, CountryId{"OM"}, Coordinate{56.7656, 21.3428}}, // Saih Rawl
    Airport{IataCode{"AIA"}, CountryId{"US"}, Coordinate{-102.807, 42.0619}}, // Alliance Municipal Airport
    Airport{IataCode{"AIC"}, CountryId{"MH"}, Coordinate{168.826, 7.27917}}, // Airok Airport
    Airport{IataCode{"AID"}, CountryId{"US"}, Coordinate{-85.6131, 40.1086}}, // Anderson Municipal Airport
    Airport{IataCode{"AIE"}, CountryId{"PG"}, Coordinate{144.73, -5.14553}}, // Aiome Airport
    Airport{IataCode{"AIF"}, CountryId{"BR"}, Coordinate{-50.4531, -22.64}}, // Assis Airport
    Airport{IataCode{"AIG"}, CountryId{"CF"}, Coordinate{23.2667, 6.51667}}, // Yalinga Airport
    Airport{IataCode{"AIH"}, CountryId{"PG"}, Coordinate{141.266, -7.3425}}, // Aiambak Airport
    Airport{IataCode{"AII"}, CountryId{"DJ"}, Coordinate{42.7167, 11.1333}}, // Ali-Sabieh Airport
    Airport{IataCode{"AIK"}, CountryId{"US"}, Coordinate{-81.685, 33.6494}}, // Aiken Municipal Airport
    Airport{IataCode{"AIM"}, CountryId{"MH"}, Coordinate{169.983, 10.2169}}, // Ailuk Airport
    Airport{IataCode{"AIN"}, CountryId{"US"}, Coordinate{-159.995, 70.6381}}, // Wainwright Airport
    Airport{IataCode{"AIO"}, CountryId{"US"}, Coordinate{-95.0469, 41.4072}}, // Atlantic Municipal Airport
    Airport{IataCode{"AIR"}, CountryId{"BR"}, Coordinate{-59.4578, -10.2531}}, // Aripuanã Airport
    Airport{IataCode{"AIS"}, CountryId{"KI"}, Coordinate{176.802, -2.61626}}, // Arorae Island Airport
    Airport{IataCode{"AIT"}, CountryId{"NZ"}, Coordinate{-159.764, -18.8308}}, // Aitutaki Airport
    Airport{IataCode{"AIU"}, CountryId{"NZ"}, Coordinate{-158.12, -19.9678}}, // Enua Airport
    Airport{IataCode{"AIV"}, CountryId{"US"}, Coordinate{-88.1978, 33.1064}}, // George Downer Airport
    Airport{IataCode{"AIZ"}, CountryId{"US"}, Coordinate{-92.5504, 38.1004}}, // Lee C. Fine Memorial Airport
    Airport{IataCode{"AJA"}, CountryId{"FR"}, Coordinate{8.79446, 41.9197}}, // Ajaccio Napoleon Bonaparte Airport
    Airport{IataCode{"AJF"}, CountryId{"SA"}, Coordinate{40.1016, 29.7884}}, // Al-Jawf Domestic Airport
    Airport{IataCode{"AJI"}, CountryId{"TR"}, Coordinate{43.0272, 39.6544}}, // Ağrı Ahmed-i Hani Airport
    Airport{IataCode{"AJJ"}, CountryId{"MR"}, Coordinate{-14.3833, 19.733}}, // Akjoujt Airport
    Airport{IataCode{"AJK"}, CountryId{"IR"}, Coordinate{49.8428, 34.1338}}, // Arak Airport
    Airport{IataCode{"AJL"}, CountryId{"IN"}, Coordinate{92.6243, 23.8389}}, // Lengpui Airport
    Airport{IataCode{"AJN"}, CountryId{"KM"}, Coordinate{44.4296, -12.1317}}, // Ouani Airport
    Airport{IataCode{"AJR"}, CountryId{"SE"}, Coordinate{19.2819, 65.5903}}, // Arvidsjaur Airport
    Airport{IataCode{"AJS"}, CountryId{"MX"}, Coordinate{-113.56, 26.7272}}, // Punta Abreojos Airstrip
    Airport{IataCode{"AJU"}, CountryId{"BR"}, Coordinate{-37.072, -10.987}}, // Santa Maria Airport
    Airport{IataCode{"AJY"}, CountryId{"NE"}, Coordinate{7.99068, 16.9641}}, // Mano Dayak International Airport
    Airport{IataCode{"AKA"}, CountryId{"CN"}, Coordinate{108.931, 32.7081}}, // Ankang Wulipu Airport
    Airport{IataCode{"AKB"}, CountryId{"US"}, Coordinate{-174.206, 52.2206}}, // Atka Airport
    Airport{IataCode{"AKC"}, CountryId{"US"}, Coordinate{-81.463, 41.0421}}, // Akron Fulton International Airport
    Airport{IataCode{"AKD"}, CountryId{"IN"}, Coordinate{77.0591, 20.6962}}, // Akola Airport
    Airport{IataCode{"AKE"}, CountryId{"GA"}, Coordinate{13.9033, -1.13972}}, // Akieni Airport
    Airport{IataCode{"AKF"}, CountryId{"LY"}, Coordinate{23.322, 24.1843}}, // Kufra Airport
    Airport{IataCode{"AKG"}, CountryId{"PG"}, Coordinate{142.218, -3.56075}}, // Anguganak Airport
    Airport{IataCode{"AKI"}, CountryId{"US"}, Coordinate{-161.231, 60.9028}}, // Akiak Airport
    Airport{IataCode{"AKJ"}, CountryId{"JP"}, Coordinate{142.454, 43.671}}, // Asahikawa Airport
    Airport{IataCode{"AKK"}, CountryId{"US"}, Coordinate{-154.182, 56.9386}}, // Akhiok Airport
    Airport{IataCode{"AKL"}, CountryId{"NZ"}, Coordinate{174.792, -37.0081}}, // Auckland Airport
    Airport{IataCode{"AKM"}, CountryId{"TD"}, Coordinate{19.8175, 10.8908}}, // Zakouma Airport
    Airport{IataCode{"AKN"}, CountryId{"US"}, Coordinate{-156.666, 58.6764}}, // King Salmon Airport
    Airport{IataCode{"AKO"}, CountryId{"US"}, Coordinate{-103.222, 40.1756}}, // Colorado Plains Regional Airport
    Airport{IataCode{"AKP"}, CountryId{"US"}, Coordinate{-151.743, 68.1336}}, // Anaktuvuk Pass Airport
    Airport{IataCode{"AKR"}, CountryId{"NG"}, Coordinate{5.30083, 7.24667}}, // Akure Airport
    Airport{IataCode{"AKS"}, CountryId{"SB"}, Coordinate{160.681, -8.69778}}, // Auki Gwaunaru'u Airport
    Airport{IataCode{"AKU"}, CountryId{"CN"}, Coordinate{80.2917, 41.2625}}, // Aksu Airport
    Airport{IataCode{"AKV"}, CountryId{"CA"}, Coordinate{-78.1486, 60.8186}}, // Akulivik Airport
    Airport{IataCode{"AKW"}, CountryId{"IR"}, Coordinate{49.6769, 30.7444}}, // Aghajari Airport
    Airport{IataCode{"AKX"}, CountryId{"KZ"}, Coordinate{57.2105, 50.2488}}, // Aktobe Airport
    Airport{IataCode{"AKY"}, CountryId{"MM"}, Coordinate{92.8725, 20.1328}}, // Sittwe Airport
    Airport{IataCode{"ALA"}, CountryId{"KZ"}, Coordinate{77.0121, 43.3469}}, // Almaty International Airport
    Airport{IataCode{"ALB"}, CountryId{"US"}, Coordinate{-73.8097, 42.7458}}, // Albany International Airport
    Airport{IataCode{"ALC"}, CountryId{"ES"}, Coordinate{-0.552972, 38.2875}}, // Alicante Airport
    Airport{IataCode{"ALD"}, CountryId{"PE"}, Coordinate{-69.3333, -11.6833}}, // Alerta Airport
    Airport{IataCode{"ALE"}, CountryId{"US"}, Coordinate{-103.684, 30.3842}}, // Alpine-Casparis Municipal Airport
    Airport{IataCode{"ALF"}, CountryId{"NO"}, Coordinate{23.3473, 69.9778}}, // Alta Airport
    Airport{IataCode{"ALG"}, CountryId{"DZ"}, Coordinate{3.20922, 36.7003}}, // Algiers Houari Boumediene Airport
    Airport{IataCode{"ALH"}, CountryId{"AU"}, Coordinate{117.803, -34.945}}, // Albany Airport
    Airport{IataCode{"ALI"}, CountryId{"US"}, Coordinate{-98.0269, 27.7408}}, // Alice International Airport
    Airport{IataCode{"ALJ"}, CountryId{"ZA"}, Coordinate{16.5285, -28.5704}}, // Alexander Bay Airport
    Airport{IataCode{"ALL"}, CountryId{"IT"}, Coordinate{8.12673, 44.0458}}, // Albenga Airport-Riviera Airport
    Airport{IataCode{"ALM"}, CountryId{"US"}, Coordinate{-105.991, 32.84}}, // Alamogordo–White Sands Regional Airport
    Airport{IataCode{"ALN"}, CountryId{"US"}, Coordinate{-90.0547, 38.8914}}, // St. Louis Regional Airport
    Airport{IataCode{"ALO"}, CountryId{"US"}, Coordinate{-92.3968, 42.5504}}, // Waterloo Regional Airport
    Airport{IataCode{"ALP"}, CountryId{"SY"}, Coordinate{37.2242, 36.1806}}, // Aleppo International Airport
    Airport{IataCode{"ALQ"}, CountryId{"BR"}, Coordinate{-55.8922, -29.8125}}, // Alegrete Airport
    Airport{IataCode{"ALR"}, CountryId{"NZ"}, Coordinate{169.373, -45.2117}}, // Alexandra Aerodrome
    Airport{IataCode{"ALS"}, CountryId{"US"}, Coordinate{-105.864, 37.4438}}, // San Luis Valley Regional Airport
    Airport{IataCode{"ALU"}, CountryId{"SO"}, Coordinate{50.7483, 11.9586}}, // Alula Airport
    Airport{IataCode{"ALW"}, CountryId{"US"}, Coordinate{-118.285, 46.0874}}, // Walla Walla Regional Airport
    Airport{IataCode{"ALX"}, CountryId{"US"}, Coordinate{-85.9631, 32.9147}}, // Thomas C. Russell Field
    Airport{IataCode{"ALY"}, CountryId{"EG"}, Coordinate{29.9533, 31.1924}}, // El Nouzha Airport
    Airport{IataCode{"AMA"}, CountryId{"US"}, Coordinate{-101.705, 35.2185}}, // Rick Husband Amarillo International Airport
    Airport{IataCode{"AMB"}, CountryId{"MG"}, Coordinate{48.9833, -13.1883}}, // Ambilobe Airport
    Airport{IataCode{"AMC"}, CountryId{"TD"}, Coordinate{20.2785, 11.0393}}, // Am Timan Airport
    Airport{IataCode{"AMD"}, CountryId{"IN"}, Coordinate{72.6221, 23.0734}}, // Sardar Vallabhbhai Patel International Airport
    Airport{IataCode{"AMF"}, CountryId{"PG"}, Coordinate{141.669, -4.10066}}, // Ama Airport
    Airport{IataCode{"AMH"}, CountryId{"ET"}, Coordinate{37.5886, 6.04119}}, // Arba Minch Airport
    Airport{IataCode{"AMI"}, CountryId{"ID"}, Coordinate{116.094, -8.56056}}, // Selaparang Airport
    Airport{IataCode{"AMK"}, CountryId{"US"}, Coordinate{-107.869, 37.2031}}, // Animas Air Park
    Airport{IataCode{"AML"}, CountryId{"PA"}, Coordinate{-82.8649, 8.26806}}, // Puerto Armuelles Airport
    Airport{IataCode{"AMM"}, CountryId{"JO"}, Coordinate{35.9881, 31.7225}}, // Queen Alia International Airport
    Airport{IataCode{"AMN"}, CountryId{"US"}, Coordinate{-84.6881, 43.3222}}, // Gratiot Community Airport
    Airport{IataCode{"AMO"}, CountryId{"TD"}, Coordinate{15.3144, 14.1456}}, // Mao Airport
    Airport{IataCode{"AMP"}, CountryId{"MG"}, Coordinate{44.7325, -24.7}}, // Ampanihy Airport
    Airport{IataCode{"AMQ"}, CountryId{"ID"}, Coordinate{128.089, -3.70526}}, // Pattimura Airport
    Airport{IataCode{"AMS"}, CountryId{"NL"}, Coordinate{4.76218, 52.3095}}, // Amsterdam Airport Schiphol
    Airport{IataCode{"AMT"}, CountryId{"AU"}, Coordinate{131.207, -26.1083}}, // Amata Airport
    Airport{IataCode{"AMU"}, CountryId{"PG"}, Coordinate{141.219, -3.58829}}, // Amanab Airport
    Airport{IataCode{"AMV"}, CountryId{"RU"}, Coordinate{61.5633, 69.7633}}, // Amderma Airport
    Airport{IataCode{"AMW"}, CountryId{"US"}, Coordinate{-93.6225, 41.9986}}, // Ames Municipal Airport
    Airport{IataCode{"AMZ"}, CountryId{"NZ"}, Coordinate{174.973, -37.0297}}, // Ardmore Airport, New Zealand
    Airport{IataCode{"ANA"}, CountryId{"KE"}, Coordinate{34.9543, -1.27165}}, // Angama Mara Airport
    Airport{IataCode{"ANB"}, CountryId{"US"}, Coordinate{-85.8581, 33.5881}}, // Anniston Regional Airport
    Airport{IataCode{"ANC"}, CountryId{"US"}, Coordinate{-149.98, 61.1745}}, // Ted Stevens Anchorage International Airport
    Airport{IataCode{"AND"}, CountryId{"US"}, Coordinate{-82.709, 34.4949}}, // Anderson Regional Airport
    Airport{IataCode{"ANE"}, CountryId{"FR"}, Coordinate{-0.314403, 47.5629}}, // Angers – Loire Airport
    Airport{IataCode{"ANF"}, CountryId{"CL"}, Coordinate{-70.441, -23.4489}}, // Andrés Sabella Airport
    Airport{IataCode{"ANG"}, CountryId{"FR"}, Coordinate{0.218529, 45.7267}}, // Angoulême – Brie – Champniers Airport
    Airport{IataCode{"ANI"}, CountryId{"US"}, Coordinate{-159.543, 61.5817}}, // Aniak Airport
    Airport{IataCode{"ANJ"}, CountryId{"CG"}, Coordinate{13.8167, -2.85}}, // Zanaga Airport
    Airport{IataCode{"ANL"}, CountryId{"AO"}, Coordinate{16.711, -11.4715}}, // Andulo Airport
    Airport{IataCode{"ANM"}, CountryId{"MG"}, Coordinate{50.32, -14.9994}}, // Antsirabato Airport
    Airport{IataCode{"ANN"}, CountryId{"US"}, Coordinate{-131.572, 55.0425}}, // Annette Island Airport
    Airport{IataCode{"ANO"}, CountryId{"MZ"}, Coordinate{39.9333, -16.1833}}, // Angoche Airport
    Airport{IataCode{"ANP"}, CountryId{"US"}, Coordinate{-76.5683, 38.9428}}, // Lee Airport
    Airport{IataCode{"ANQ"}, CountryId{"US"}, Coordinate{-85.0857, 41.6355}}, // Tri-State Steuben County Airport
    Airport{IataCode{"ANR"}, CountryId{"BE"}, Coordinate{4.45128, 51.1889}}, // Antwerp International Airport
    Airport{IataCode{"ANS"}, CountryId{"PE"}, Coordinate{-73.3524, -13.7132}}, // Andahuaylas Airport
    Airport{IataCode{"ANV"}, CountryId{"US"}, Coordinate{-160.191, 62.6467}}, // Anvik Airport
    Airport{IataCode{"ANW"}, CountryId{"US"}, Coordinate{-99.9931, 42.5792}}, // Ainsworth Regional Airport
    Airport{IataCode{"ANX"}, CountryId{"NO"}, Coordinate{16.124, 69.3106}}, // Andøya Airport
    Airport{IataCode{"ANY"}, CountryId{"US"}, Coordinate{-98.0797, 37.1586}}, // Anthony Municipal Airport
    Airport{IataCode{"AOC"}, CountryId{"DE"}, Coordinate{12.511, 50.9793}}, // Leipzig-Altenburg Airport
    Airport{IataCode{"AOD"}, CountryId{"TD"}, Coordinate{19.2833, 11.4667}}, // Abou-Deïa Airport
    Airport{IataCode{"AOE"}, CountryId{"TR"}, Coordinate{30.5283, 39.8126}}, // Anadolu Airport
    Airport{IataCode{"AOG"}, CountryId{"CN"}, Coordinate{122.856, 41.1047}}, // Anshan Teng'ao Airport
    Airport{IataCode{"AOH"}, CountryId{"US"}, Coordinate{-84.0275, 40.7083}}, // Lima Allen County Airport
    Airport{IataCode{"AOI"}, CountryId{"IT"}, Coordinate{13.3575, 43.6073}}, // Ancona Falconara Airport
    Airport{IataCode{"AOJ"}, CountryId{"JP"}, Coordinate{140.689, 40.7333}}, // Aomori Airport
    Airport{IataCode{"AOK"}, CountryId{"GR"}, Coordinate{27.1487, 35.4268}}, // Karpathos Island National Airport
    Airport{IataCode{"AOL"}, CountryId{"AR"}, Coordinate{-57.1522, -29.6881}}, // Paso de los Libres Airport
    Airport{IataCode{"AOM"}, CountryId{"OM"}, Coordinate{57.3787, 22.5034}}, // Adam Airport
    Airport{IataCode{"AOO"}, CountryId{"US"}, Coordinate{-78.32, 40.2964}}, // Altoona–Blair County Airport
    Airport{IataCode{"AOP"}, CountryId{"PE"}, Coordinate{-76.4666, -2.79611}}, // Alférez FAP Alfredo Vladimir Sara Bauer Airport
    Airport{IataCode{"AOR"}, CountryId{"MY"}, Coordinate{100.398, 6.18944}}, // Sultan Abdul Halim Airport
    Airport{IataCode{"AOT"}, CountryId{"IT"}, Coordinate{7.36403, 45.7396}}, // Aosta Airport
    Airport{IataCode{"AOU"}, CountryId{"LA"}, Coordinate{106.833, 14.7931}}, // Attopeu
    Airport{IataCode{"APA"}, CountryId{"US"}, Coordinate{-104.847, 39.5701}}, // Centennial Airport
    Airport{IataCode{"APB"}, CountryId{"BO"}, Coordinate{-68.4167, -14.8181}}, // Apolo Airport
    Airport{IataCode{"APC"}, CountryId{"US"}, Coordinate{-122.281, 38.2132}}, // Napa County Airport
    Airport{IataCode{"APF"}, CountryId{"US"}, Coordinate{-81.7756, 26.1525}}, // Naples Municipal Airport
    Airport{IataCode{"APK"}, CountryId{"FR"}, Coordinate{-146.414, -15.5728}}, // Apataki Airport
    Airport{IataCode{"APL"}, CountryId{"MZ"}, Coordinate{39.2839, -15.1075}}, // Nampula Airport
    Airport{IataCode{"APN"}, CountryId{"US"}, Coordinate{-83.5666, 45.0702}}, // Alpena County Regional Airport
    Airport{IataCode{"APO"}, CountryId{"CO"}, Coordinate{-76.7178, 7.81795}}, // Antonio Roldán Betancourt Airport
    Airport{IataCode{"APP"}, CountryId{"PG"}, Coordinate{148.133, -8.98333}}, // Asapa
    Airport{IataCode{"APR"}, CountryId{"PG"}, Coordinate{142.54, -4.67914}}, // April River Airport
    Airport{IataCode{"APS"}, CountryId{"BR"}, Coordinate{-48.9281, -16.3625}}, // Anápolis Airport
    Airport{IataCode{"APT"}, CountryId{"US"}, Coordinate{-85.5853, 35.0606}}, // Marion County Airport
    Airport{IataCode{"APU"}, CountryId{"BR"}, Coordinate{-51.385, -23.6122}}, // Apucarana Airport
    Airport{IataCode{"APV"}, CountryId{"US"}, Coordinate{-117.187, 34.5803}}, // Apple Valley Airport
    Airport{IataCode{"APW"}, CountryId{"WS"}, Coordinate{-171.997, -13.8325}}, // Faleolo International Airport
    Airport{IataCode{"APX"}, CountryId{"BR"}, Coordinate{-51.4908, -23.3558}}, // Arapongas Airport
    Airport{IataCode{"APY"}, CountryId{"BR"}, Coordinate{-45.9506, -9.08361}}, // Alto Parnaiba Airport
    Airport{IataCode{"APZ"}, CountryId{"AR"}, Coordinate{-70.1136, -38.9759}}, // Zapala Airport
    Airport{IataCode{"AQA"}, CountryId{"BR"}, Coordinate{-48.1401, -21.8058}}, // Araraquara Airport
    Airport{IataCode{"AQB"}, CountryId{"GT"}, Coordinate{-91.1506, 15.0108}}, // Quiché Airport
    Airport{IataCode{"AQG"}, CountryId{"CN"}, Coordinate{117.05, 30.5822}}, // Anqing Tianzhushan Airport
    Airport{IataCode{"AQI"}, CountryId{"SA"}, Coordinate{46.125, 28.335}}, // Qaisumah Domestic Airport
    Airport{IataCode{"AQJ"}, CountryId{"JO"}, Coordinate{35.0211, 29.6098}}, // King Hussein International Airport
    Airport{IataCode{"AQM"}, CountryId{"BR"}, Coordinate{-62.8256, -10.1781}}, // Nova Vida Airport
    Airport{IataCode{"AQP"}, CountryId{"PE"}, Coordinate{-71.5681, -16.3445}}, // Rodríguez Ballón International Airport
    Airport{IataCode{"AQY"}, CountryId{"US"}, Coordinate{-149.126, 60.9661}}, // Girdwood Airport
    Airport{IataCode{"ARA"}, CountryId{"US"}, Coordinate{-91.8839, 30.0377}}, // Acadiana Regional Airport
    Airport{IataCode{"ARB"}, CountryId{"US"}, Coordinate{-83.7457, 42.2254}}, // Ann Arbor Municipal Airport
    Airport{IataCode{"ARC"}, CountryId{"US"}, Coordinate{-145.579, 68.1147}}, // Arctic Village Airport
    Airport{IataCode{"ARD"}, CountryId{"ID"}, Coordinate{124.591, -8.13574}}, // Alor Island Airport
    Airport{IataCode{"ARE"}, CountryId{"US"}, Coordinate{-66.6756, 18.4511}}, // Antonio (Nery) Juarbe Pol Airport
    Airport{IataCode{"ARG"}, CountryId{"US"}, Coordinate{-90.925, 36.1247}}, // Walnut Ridge Regional Airport
    Airport{IataCode{"ARH"}, CountryId{"RU"}, Coordinate{40.7135, 64.5962}}, // Talagi Airport
    Airport{IataCode{"ARI"}, CountryId{"CL"}, Coordinate{-70.3358, -18.3492}}, // Chacalluta International Airport
    Airport{IataCode{"ARJ"}, CountryId{"ID"}, Coordinate{140.783, -2.93333}}, // Arso Airport
    Airport{IataCode{"ARK"}, CountryId{"TZ"}, Coordinate{36.6248, -3.36785}}, // Arusha Airport
    Airport{IataCode{"ARL"}, CountryId{"BF"}, Coordinate{1.48333, 11.5833}}, // Arly Airport
    Airport{IataCode{"ARM"}, CountryId{"AU"}, Coordinate{151.615, -30.5321}}, // Armidale Airport
    Airport{IataCode{"ARN"}, CountryId{"SE"}, Coordinate{17.929, 59.6494}}, // Stockholm Arlanda Airport
    Airport{IataCode{"ARP"}, CountryId{"PG"}, Coordinate{149.5, -9.9}}, // Aragip Airport
    Airport{IataCode{"ARQ"}, CountryId{"CO"}, Coordinate{-71.3889, 7.01917}}, // Aeropuerto Arsenio Valderrama
    Airport{IataCode{"ARR"}, CountryId{"AR"}, Coordinate{-70.818, -45.0159}}, // Casimiro Szlapelis Airport
    Airport{IataCode{"ART"}, CountryId{"US"}, Coordinate{-76.0234, 43.9941}}, // Watertown International Airport
    Airport{IataCode{"ARU"}, CountryId{"BR"}, Coordinate{-50.4259, -21.1377}}, // Araçatuba Airport
    Airport{IataCode{"ARV"}, CountryId{"US"}, Coordinate{-89.7308, 45.9278}}, // Lakeland Airport
    Airport{IataCode{"ARW"}, CountryId{"RO"}, Coordinate{21.2775, 46.1722}}, // Arad International Airport
    Airport{IataCode{"ARY"}, CountryId{"AU"}, Coordinate{142.988, -37.31}}, // Ararat airport
    Airport{IataCode{"ARZ"}, CountryId{"AO"}, Coordinate{12.8626, -7.25903}}, // N'zeto Airport
    Airport{IataCode{"ASA"}, CountryId{"ER"}, Coordinate{42.6457, 13.0757}}, // Assab International Airport
    Airport{IataCode{"ASB"}, CountryId{"TM"}, Coordinate{58.3608, 37.9869}}, // Ashgabat International Airport
    Airport{IataCode{"ASC"}, CountryId{"BO"}, Coordinate{-63.1559, -15.9322}}, // Ascencion De Guarayos Airport
    Airport{IataCode{"ASD"}, CountryId{"BS"}, Coordinate{-77.8, 24.6983}}, // Andros Town International Airport
    Airport{IataCode{"ASE"}, CountryId{"US"}, Coordinate{-106.864, 39.2196}}, // Aspen/Pitkin County Airport
    Airport{IataCode{"ASF"}, CountryId{"RU"}, Coordinate{47.9998, 46.2873}}, // Narimanovo Airport
    Airport{IataCode{"ASG"}, CountryId{"NZ"}, Coordinate{171.797, -43.9033}}, // Ashburton Aerodrome
    Airport{IataCode{"ASH"}, CountryId{"US"}, Coordinate{-71.5216, 42.7819}}, // Nashua Municipal Airport
    Airport{IataCode{"ASJ"}, CountryId{"JP"}, Coordinate{129.712, 28.4308}}, // Amami Airport
    Airport{IataCode{"ASK"}, CountryId{"CI"}, Coordinate{-5.35979, 6.90588}}, // Yamoussoukro Airport
    Airport{IataCode{"ASL"}, CountryId{"US"}, Coordinate{-94.311, 32.5207}}, // Harrison County Airport
    Airport{IataCode{"ASM"}, CountryId{"ER"}, Coordinate{38.9062, 15.2936}}, // Asmara International Airport
    Airport{IataCode{"ASN"}, CountryId{"US"}, Coordinate{-86.0511, 33.5694}}, // Talladega Municipal Airport
    Airport{IataCode{"ASO"}, CountryId{"ET"}, Coordinate{34.5861, 10.0183}}, // Asosa Airport
    Airport{IataCode{"ASP"}, CountryId{"AU"}, Coordinate{133.901, -23.801}}, // Alice Springs Airport
    Airport{IataCode{"ASQ"}, CountryId{"US"}, Coordinate{-117.195, 39.4681}}, // Austin Airport
    Airport{IataCode{"ASR"}, CountryId{"TR"}, Coordinate{35.4824, 38.7655}}, // Erkilet International Airport
    Airport{IataCode{"AST"}, CountryId{"US"}, Coordinate{-123.879, 46.1581}}, // Astoria Regional Airport
    Airport{IataCode{"ASU"}, CountryId{"PY"}, Coordinate{-57.5143, -25.2417}}, // Silvio Pettirossi International Airport
    Airport{IataCode{"ASV"}, CountryId{"KE"}, Coordinate{37.2508, -2.63583}}, // Amboseli Airport
    Airport{IataCode{"ASW"}, CountryId{"EG"}, Coordinate{32.8244, 23.9681}}, // Aswan International Airport
    Airport{IataCode{"ASX"}, CountryId{"US"}, Coordinate{-90.9189, 46.5486}}, // John F. Kennedy Memorial Airport
    Airport{IataCode{"ASY"}, CountryId{"US"}, Coordinate{-99.3517, 46.0247}}, // Ashley Municipal Airport
    Airport{IataCode{"ASZ"}, CountryId{"PG"}, Coordinate{150.367, -5.86667}}, // Asirim
    Airport{IataCode{"ATA"}, CountryId{"PE"}, Coordinate{-77.5983, -9.34722}}, // Comandante FAP Germán Arias Graziani Airport
    Airport{IataCode{"ATB"}, CountryId{"SD"}, Coordinate{34.055, 17.7115}}, // Atbara Airport
    Airport{IataCode{"ATC"}, CountryId{"BS"}, Coordinate{-75.6739, 24.6294}}, // Arthur's Town Airport
    Airport{IataCode{"ATD"}, CountryId{"SB"}, Coordinate{161.011, -8.87333}}, // Uru Harbour Airport
    Airport{IataCode{"ATE"}, CountryId{"US"}, Coordinate{-95.6497, 34.1925}}, // Antlers Municipal Airport
    Airport{IataCode{"ATF"}, CountryId{"EC"}, Coordinate{-78.5744, -1.21194}}, // Chachoan Airport
    Airport{IataCode{"ATH"}, CountryId{"GR"}, Coordinate{23.9448, 37.937}}, // Athens International Airport
    Airport{IataCode{"ATI"}, CountryId{"UY"}, Coordinate{-56.5078, -30.4008}}, // Artigas Airport
    Airport{IataCode{"ATJ"}, CountryId{"MG"}, Coordinate{47.0667, -19.8358}}, // Antsirabe Airport
    Airport{IataCode{"ATK"}, CountryId{"US"}, Coordinate{-157.436, 70.4672}}, // Atqasuk Edward Burnell Sr. Memorial Airport
    Airport{IataCode{"ATL"}, CountryId{"US"}, Coordinate{-84.4462, 33.6407}}, // Hartsfield–Jackson Atlanta International Airport
    Airport{IataCode{"ATM"}, CountryId{"BR"}, Coordinate{-52.2491, -3.25362}}, // Altamira Airport
    Airport{IataCode{"ATN"}, CountryId{"PG"}, Coordinate{152.442, -3.66667}}, // Namatanai Airport
    Airport{IataCode{"ATO"}, CountryId{"US"}, Coordinate{-82.2241, 39.2111}}, // Ohio University Airport
    Airport{IataCode{"ATP"}, CountryId{"PG"}, Coordinate{142.346, -3.14417}}, // Aitape Airport
    Airport{IataCode{"ATQ"}, CountryId{"IN"}, Coordinate{74.8066, 31.7055}}, // Sri Guru Ram Dass Jee International Airport
    Airport{IataCode{"ATR"}, CountryId{"MR"}, Coordinate{-13.0511, 20.4984}}, // Atar International Airport
    Airport{IataCode{"ATS"}, CountryId{"US"}, Coordinate{-104.468, 32.8525}}, // Artesia Municipal Airport
    Airport{IataCode{"ATT"}, CountryId{"US"}, Coordinate{-162.273, 60.8667}}, // Atmautluak Airport
    Airport{IataCode{"ATV"}, CountryId{"TD"}, Coordinate{18.3133, 13.2389}}, // Ati Airport
    Airport{IataCode{"ATW"}, CountryId{"US"}, Coordinate{-88.5192, 44.2581}}, // Appleton International Airport
    Airport{IataCode{"ATX"}, CountryId{"KZ"}, Coordinate{68.3633, 51.8517}}, // Atbasar Airport
    Airport{IataCode{"ATY"}, CountryId{"US"}, Coordinate{-97.1612, 44.9214}}, // Watertown Regional Airport
    Airport{IataCode{"ATZ"}, CountryId{"EG"}, Coordinate{31.0163, 27.0508}}, // Assiut Airport
    Airport{IataCode{"AUA"}, CountryId{"NL"}, Coordinate{-70.0091, 12.5011}}, // Queen Beatrix International Airport
    Airport{IataCode{"AUC"}, CountryId{"CO"}, Coordinate{-70.7357, 7.06664}}, // Santiago Pérez Quiroz Airport
    Airport{IataCode{"AUE"}, CountryId{"EG"}, Coordinate{33.1938, 28.9048}}, // Abu Rudeis Airport
    Airport{IataCode{"AUF"}, CountryId{"FR"}, Coordinate{3.49667, 47.8464}}, // Auxerre – Branches Aerodrome
    Airport{IataCode{"AUG"}, CountryId{"US"}, Coordinate{-69.7972, 44.3206}}, // Augusta State Airport
    Airport{IataCode{"AUH"}, CountryId{"AE"}, Coordinate{54.6511, 24.4331}}, // Abu Dhabi International Airport
    Airport{IataCode{"AUI"}, CountryId{"PG"}, Coordinate{143.065, -1.46317}}, // Aua Island Airport
    Airport{IataCode{"AUJ"}, CountryId{"PG"}, Coordinate{142.823, -4.21614}}, // Ambunti Airport
    Airport{IataCode{"AUK"}, CountryId{"US"}, Coordinate{-164.66, 62.68}}, // Alakanuk Airport
    Airport{IataCode{"AUL"}, CountryId{"MH"}, Coordinate{171.173, 8.1455}}, // Aur Airport
    Airport{IataCode{"AUM"}, CountryId{"US"}, Coordinate{-92.9328, 43.6625}}, // Austin Municipal Airport
    Airport{IataCode{"AUN"}, CountryId{"US"}, Coordinate{-121.082, 38.9547}}, // Auburn Municipal Airport
    Airport{IataCode{"AUO"}, CountryId{"US"}, Coordinate{-85.4327, 32.6146}}, // Auburn University Regional Airport
    Airport{IataCode{"AUP"}, CountryId{"PG"}, Coordinate{149.386, -9.93083}}, // Agaun Airport
    Airport{IataCode{"AUQ"}, CountryId{"FR"}, Coordinate{-139.013, -9.76861}}, // Atuona Airport
    Airport{IataCode{"AUR"}, CountryId{"FR"}, Coordinate{2.42061, 44.8977}}, // Aurillac Airport
    Airport{IataCode{"AUS"}, CountryId{"US"}, Coordinate{-97.67, 30.1944}}, // Austin-Bergstrom International Airport
    Airport{IataCode{"AUT"}, CountryId{"TL"}, Coordinate{125.602, -8.28167}}, // Atauro aerodrome
    Airport{IataCode{"AUU"}, CountryId{"AU"}, Coordinate{141.721, -13.3539}}, // Aurukun Airport
    Airport{IataCode{"AUV"}, CountryId{"PG"}, Coordinate{148.447, -5.7292}}, // Aumo Airport
    Airport{IataCode{"AUW"}, CountryId{"US"}, Coordinate{-89.6267, 44.9261}}, // Wausau Downtown Airport
    Airport{IataCode{"AUZ"}, CountryId{"US"}, Coordinate{-88.4756, 41.7719}}, // Aurora Municipal Airport
    Airport{IataCode{"AVA"}, CountryId{"CN"}, Coordinate{105.873, 26.2606}}, // Anshun Huangguoshu Airport
    Airport{IataCode{"AVI"}, CountryId{"CU"}, Coordinate{-78.7875, 22.0243}}, // Máximo Gómez Airport
    Airport{IataCode{"AVK"}, CountryId{"MN"}, Coordinate{102.799, 46.2525}}, // Arvaikheer Airport
    Airport{IataCode{"AVL"}, CountryId{"US"}, Coordinate{-82.539, 35.4387}}, // Asheville Regional Airport
    Airport{IataCode{"AVN"}, CountryId{"FR"}, Coordinate{4.89805, 43.9054}}, // Avignon – Caumont Airport
    Airport{IataCode{"AVP"}, CountryId{"US"}, Coordinate{-75.7289, 41.3375}}, // Wilkes-Barre/Scranton International Airport
    Airport{IataCode{"AVU"}, CountryId{"SB"}, Coordinate{160.41, -9.86818}}, // Avu Avu Airport
    Airport{IataCode{"AVV"}, CountryId{"AU"}, Coordinate{144.474, -38.0267}}, // Avalon Airport
    Airport{IataCode{"AVW"}, CountryId{"US"}, Coordinate{-111.218, 32.4096}}, // Marana Regional Airport
    Airport{IataCode{"AVX"}, CountryId{"US"}, Coordinate{-118.416, 33.405}}, // Catalina Airport
    Airport{IataCode{"AWA"}, CountryId{"ET"}, Coordinate{38.5, 7.067}}, // Awasa Airport
    Airport{IataCode{"AWB"}, CountryId{"PG"}, Coordinate{142.751, -8.01433}}, // Awaba Airport
    Airport{IataCode{"AWD"}, CountryId{"VU"}, Coordinate{169.601, -19.2344}}, // Aniwa Airport
    Airport{IataCode{"AWK"}, CountryId{"US"}, Coordinate{166.637, 19.2825}}, // Wake Island Airfield
    Airport{IataCode{"AWM"}, CountryId{"US"}, Coordinate{-90.2344, 35.135}}, // West Memphis Municipal Airport
    Airport{IataCode{"AWN"}, CountryId{"AU"}, Coordinate{139.26, -26.4886}}, // Alton Downs
    Airport{IataCode{"AWR"}, CountryId{"PG"}, Coordinate{144.854, -4.11945}}, // Awar Airport
    Airport{IataCode{"AWZ"}, CountryId{"IR"}, Coordinate{48.7469, 31.3433}}, // Ahvaz International Airport
    Airport{IataCode{"AXA"}, CountryId{"GB"}, Coordinate{-63.0526, 18.2066}}, // Clayton J. Lloyd International Airport
    Airport{IataCode{"AXB"}, CountryId{"US"}, Coordinate{-75.8994, 44.3167}}, // Maxson Airfield
    Airport{IataCode{"AXC"}, CountryId{"AU"}, Coordinate{145.242, -22.9667}}, // Aramac Airport
    Airport{IataCode{"AXD"}, CountryId{"GR"}, Coordinate{25.9449, 40.8565}}, // Alexandroupolis International Airport
    Airport{IataCode{"AXE"}, CountryId{"BR"}, Coordinate{-52.3736, -26.8765}}, // Xanxerê Airport
    Airport{IataCode{"AXF"}, CountryId{"CN"}, Coordinate{105.626, 38.8229}}, // Alxa Left Banner Bayanhot Airport
    Airport{IataCode{"AXG"}, CountryId{"US"}, Coordinate{-94.2719, 43.0778}}, // Algona Municipal Airport
    Airport{IataCode{"AXK"}, CountryId{"YE"}, Coordinate{46.8261, 14.5511}}, // Ataq Airport
    Airport{IataCode{"AXM"}, CountryId{"CO"}, Coordinate{-75.768, 4.45297}}, // El Edén International Airport
    Airport{IataCode{"AXN"}, CountryId{"US"}, Coordinate{-95.3902, 45.8651}}, // Alexandria Municipal Airport
    Airport{IataCode{"AXP"}, CountryId{"BS"}, Coordinate{-73.975, 22.4444}}, // Spring Point Airport
    Airport{IataCode{"AXR"}, CountryId{"FR"}, Coordinate{-146.62, -15.2464}}, // Arutua Airport
    Airport{IataCode{"AXS"}, CountryId{"US"}, Coordinate{-99.3355, 34.695}}, // Altus/Quartz Mountain Regional Airport
    Airport{IataCode{"AXT"}, CountryId{"JP"}, Coordinate{140.22, 39.6118}}, // Akita Airport
    Airport{IataCode{"AXU"}, CountryId{"ET"}, Coordinate{38.7769, 14.1445}}, // Axum Airport
    Airport{IataCode{"AXV"}, CountryId{"US"}, Coordinate{-84.2981, 40.4936}}, // Neil Armstrong Airport
    Airport{IataCode{"AYA"}, CountryId{"CO"}, Coordinate{-75.1464, 8.32}}, // Ayapel Airport
    Airport{IataCode{"AYG"}, CountryId{"CO"}, Coordinate{-73.9333, 1.54417}}, // Yaguara Airport
    Airport{IataCode{"AYK"}, CountryId{"KZ"}, Coordinate{66.96, 50.325}}, // Arkalyk Airport
    Airport{IataCode{"AYN"}, CountryId{"CN"}, Coordinate{114.344, 36.1339}}, // Anyang Yudongbei Airport
    Airport{IataCode{"AYO"}, CountryId{"PY"}, Coordinate{-56.857, -27.3787}}, // Juan de Ayolas Airport
    Airport{IataCode{"AYP"}, CountryId{"PE"}, Coordinate{-74.2061, -13.1536}}, // Coronel FAP Alfredo Mendívil Duarte Airport
    Airport{IataCode{"AYQ"}, CountryId{"AU"}, Coordinate{130.977, -25.1907}}, // Ayers Rock Airport
    Airport{IataCode{"AYR"}, CountryId{"AU"}, Coordinate{147.33, -19.585}}, // Ayr Airport
    Airport{IataCode{"AYS"}, CountryId{"US"}, Coordinate{-82.3956, 31.2492}}, // Waycross-Ware County Airport
    Airport{IataCode{"AYT"}, CountryId{"TR"}, Coordinate{30.8035, 36.9145}}, // Antalya Airport
    Airport{IataCode{"AYU"}, CountryId{"PG"}, Coordinate{145.904, -6.33778}}, // Aiyura Airport
    Airport{IataCode{"AYW"}, CountryId{"ID"}, Coordinate{132.5, -1.2}}, // Ayawasi Airport
    Airport{IataCode{"AYX"}, CountryId{"PE"}, Coordinate{-73.7679, -10.7309}}, // Tnte. Gral. Gerardo Pérez Pinedo Airport
    Airport{IataCode{"AZA"}, CountryId{"US"}, Coordinate{-111.671, 33.3061}}, // Phoenix–Mesa Gateway Airport
    Airport{IataCode{"AZB"}, CountryId{"PG"}, Coordinate{149.3, -10.3}}, // Amazon Bay
    Airport{IataCode{"AZD"}, CountryId{"IR"}, Coordinate{54.2764, 31.905}}, // Shahid Sadooghi Airport
    Airport{IataCode{"AZG"}, CountryId{"MX"}, Coordinate{-102.391, 19.0939}}, // Apatzingan Airport
    Airport{IataCode{"AZI"}, CountryId{"AE"}, Coordinate{54.4529, 24.4273}}, // Al Bateen Executive Airport
    Airport{IataCode{"AZN"}, CountryId{"UZ"}, Coordinate{72.3132, 40.7391}}, // Andizhan Airport
    Airport{IataCode{"AZO"}, CountryId{"US"}, Coordinate{-85.5553, 42.2401}}, // Kalamazoo/Battle Creek International Airport
    Airport{IataCode{"AZR"}, CountryId{"DZ"}, Coordinate{-0.189297, 27.8419}}, // Touat-Cheikh Sidi Mohamed Belkebir Airport
    Airport{IataCode{"AZS"}, CountryId{"DO"}, Coordinate{-69.7306, 19.2677}}, // Samaná El Catey International Airport
    Airport{IataCode{"AZZ"}, CountryId{"AO"}, Coordinate{13.1156, -7.88333}}, // Ambriz Airport
    Airport{IataCode{"BAA"}, CountryId{"PG"}, Coordinate{151.008, -5.33058}}, // Bialla Airport
    Airport{IataCode{"BAF"}, CountryId{"US"}, Coordinate{-72.7158, 42.1581}}, // Barnes Municipal Airport
    Airport{IataCode{"BAG"}, CountryId{"PH"}, Coordinate{120.613, 16.3757}}, // Loakan Airport
    Airport{IataCode{"BAH"}, CountryId{"BH"}, Coordinate{50.6258, 26.2694}}, // Bahrain International Airport
    Airport{IataCode{"BAI"}, CountryId{"CR"}, Coordinate{-83.33, 9.16361}}, // Buenos Aires Airport, Costa Rica
    Airport{IataCode{"BAJ"}, CountryId{"PG"}, Coordinate{149.1, -4.883}}, // Bali
    Airport{IataCode{"BAM"}, CountryId{"US"}, Coordinate{-116.876, 40.5997}}, // Battle Mountain Airport
    Airport{IataCode{"BAN"}, CountryId{"CD"}, Coordinate{20.4333, -4.31667}}, // Basongo Airport
    Airport{IataCode{"BAP"}, CountryId{"PG"}, Coordinate{149.633, -10.3333}}, // Baibara
    Airport{IataCode{"BAQ"}, CountryId{"CO"}, Coordinate{-74.7768, 10.8869}}, // Ernesto Cortissoz International Airport
    Airport{IataCode{"BAR"}, CountryId{"CN"}, Coordinate{110.458, 19.1414}}, // Qionghai Bo'ao Airport
    Airport{IataCode{"BAS"}, CountryId{"SB"}, Coordinate{155.888, -6.9925}}, // Balalae Airport
    Airport{IataCode{"BAT"}, CountryId{"BR"}, Coordinate{-48.5958, -20.5856}}, // Barretos Airport
    Airport{IataCode{"BAU"}, CountryId{"BR"}, Coordinate{-49.0539, -22.3435}}, // Bauru Airport
    Airport{IataCode{"BAV"}, CountryId{"CN"}, Coordinate{109.997, 40.5647}}, // Baotou Erliban Airport
    Airport{IataCode{"BAX"}, CountryId{"RU"}, Coordinate{83.5477, 53.3611}}, // Barnaul Airport
    Airport{IataCode{"BAY"}, CountryId{"RO"}, Coordinate{23.4666, 47.661}}, // Maramures International Airport
    Airport{IataCode{"BAZ"}, CountryId{"BR"}, Coordinate{-62.9228, -0.979768}}, // Barcelos Airport
    Airport{IataCode{"BBA"}, CountryId{"CL"}, Coordinate{-71.687, -45.9164}}, // Balmaceda Airport
    Airport{IataCode{"BBB"}, CountryId{"US"}, Coordinate{-95.6506, 45.3319}}, // Benson Municipal Airport
    Airport{IataCode{"BBC"}, CountryId{"US"}, Coordinate{-95.8633, 28.9733}}, // Bay City Municipal Airport
    Airport{IataCode{"BBD"}, CountryId{"US"}, Coordinate{-99.3239, 31.1792}}, // Curtis Field
    Airport{IataCode{"BBG"}, CountryId{"KI"}, Coordinate{172.811, 3.08652}}, // Butaritari Atoll Airport
    Airport{IataCode{"BBH"}, CountryId{"DE"}, Coordinate{12.7154, 54.336}}, // Stralsund Barth Airport
    Airport{IataCode{"BBI"}, CountryId{"IN"}, Coordinate{85.8163, 20.2538}}, // Biju Patnaik Airport
    Airport{IataCode{"BBK"}, CountryId{"BW"}, Coordinate{25.1626, -17.8297}}, // Kasane Airport
    Airport{IataCode{"BBL"}, CountryId{"AU"}, Coordinate{141.808, -27.4083}}, // Ballera Airport
    Airport{IataCode{"BBM"}, CountryId{"KH"}, Coordinate{103.223, 13.0921}}, // Battambang Airport
    Airport{IataCode{"BBN"}, CountryId{"MY"}, Coordinate{115.469, 3.73694}}, // Bario Airport
    Airport{IataCode{"BBO"}, CountryId{}, Coordinate{44.9567, 10.399}}, // Berbera Airport
    Airport{IataCode{"BBQ"}, CountryId{"AG"}, Coordinate{-61.8264, 17.6369}}, // Codrington Airport
    Airport{IataCode{"BBR"}, CountryId{"FR"}, Coordinate{-61.7422, 16.0133}}, // Baillif Airport
    Airport{IataCode{"BBS"}, CountryId{"GB"}, Coordinate{-0.8475, 51.3239}}, // Blackbushe Airport
    Airport{IataCode{"BBT"}, CountryId{"CF"}, Coordinate{15.7861, 4.22139}}, // Berbérati Airport
    Airport{IataCode{"BBU"}, CountryId{"RO"}, Coordinate{26.0816, 44.4962}}, // Aurel Vlaicu International Airport
    Airport{IataCode{"BBV"}, CountryId{"CI"}, Coordinate{-6.92396, 4.63333}}, // Nero-Mer Airport
    Airport{IataCode{"BBW"}, CountryId{"US"}, Coordinate{-99.6422, 41.4364}}, // Broken Bow Municipal Airport
    Airport{IataCode{"BBX"}, CountryId{"US"}, Coordinate{-75.2653, 40.1349}}, // Wings Field
    Airport{IataCode{"BBY"}, CountryId{"CF"}, Coordinate{20.6475, 5.84694}}, // Bambari Airport
    Airport{IataCode{"BBZ"}, CountryId{"ZM"}, Coordinate{23.1083, -13.5372}}, // Zambezi Airport
    Airport{IataCode{"BCA"}, CountryId{"CU"}, Coordinate{-74.5046, 20.358}}, // Gustavo Rizo Airport
    Airport{IataCode{"BCB"}, CountryId{"US"}, Coordinate{-80.4089, 37.2061}}, // Virginia Tech Montgomery Executive Airport
    Airport{IataCode{"BCC"}, CountryId{"US"}, Coordinate{-156.15, 63.5717}}, // Bear Creek 3 Airport
    Airport{IataCode{"BCD"}, CountryId{"PH"}, Coordinate{123.014, 10.7765}}, // Bacolod-Silay International Airport
    Airport{IataCode{"BCE"}, CountryId{"US"}, Coordinate{-112.145, 37.7064}}, // Bryce Canyon Airport
    Airport{IataCode{"BCF"}, CountryId{"CF"}, Coordinate{18.2667, 6.51667}}, // Bouca Airport
    Airport{IataCode{"BCH"}, CountryId{"TL"}, Coordinate{126.399, -8.47844}}, // Baucau Airport
    Airport{IataCode{"BCI"}, CountryId{"AU"}, Coordinate{145.301, -23.5613}}, // Barcaldine Airport
    Airport{IataCode{"BCK"}, CountryId{"US"}, Coordinate{-90.8553, 44.2508}}, // Black River Falls Area Airport
    Airport{IataCode{"BCL"}, CountryId{"CR"}, Coordinate{-83.5833, 10.7667}}, // Barra del Colorado Airport
    Airport{IataCode{"BCM"}, CountryId{"RO"}, Coordinate{26.911, 46.5311}}, // Bacău International Airport
    Airport{IataCode{"BCN"}, CountryId{"ES"}, Coordinate{2.07833, 41.2969}}, // Josep Tarradellas Airport Barcelona-El Prat
    Airport{IataCode{"BCO"}, CountryId{"ET"}, Coordinate{36.5558, 5.7524}}, // Baco Airport
    Airport{IataCode{"BCR"}, CountryId{"RS"}, Coordinate{21.367, 44.8867}}, // Bela Crkva Airport
    Airport{IataCode{"BCS"}, CountryId{"US"}, Coordinate{-90.0222, 29.866}}, // Southern Seaplane Airport
    Airport{IataCode{"BCT"}, CountryId{"US"}, Coordinate{-80.1078, 26.3786}}, // Boca Raton Airport
    Airport{IataCode{"BCU"}, CountryId{"NG"}, Coordinate{9.74444, 10.4833}}, // Bauchi State Airport
    Airport{IataCode{"BCV"}, CountryId{"BZ"}, Coordinate{-88.7811, 17.2709}}, // Hector Silva Airstrip
    Airport{IataCode{"BCW"}, CountryId{"MZ"}, Coordinate{35.4383, -21.8531}}, // Benguera Island Airport
    Airport{IataCode{"BDA"}, CountryId{"GB"}, Coordinate{-64.703, 32.3612}}, // L.F. Wade International Airport
    Airport{IataCode{"BDB"}, CountryId{"AU"}, Coordinate{152.321, -24.8987}}, // Bundaberg Airport
    Airport{IataCode{"BDC"}, CountryId{"BR"}, Coordinate{-45.2158, -5.5025}}, // Barra do Corda Airport
    Airport{IataCode{"BDD"}, CountryId{"AU"}, Coordinate{142.175, -10.15}}, // Badu Island Airport
    Airport{IataCode{"BDE"}, CountryId{"US"}, Coordinate{-94.6122, 48.7283}}, // Baudette International Airport
    Airport{IataCode{"BDG"}, CountryId{"US"}, Coordinate{-109.483, 37.5833}}, // Blanding Municipal Airport
    Airport{IataCode{"BDH"}, CountryId{"IR"}, Coordinate{54.8248, 26.532}}, // Bandar Lengeh Airport
    Airport{IataCode{"BDJ"}, CountryId{"ID"}, Coordinate{114.758, -3.43733}}, // Syamsudin Noor Airport
    Airport{IataCode{"BDK"}, CountryId{"CI"}, Coordinate{-2.76194, 8.01722}}, // Soko Airport
    Airport{IataCode{"BDL"}, CountryId{"US"}, Coordinate{-72.6857, 41.9312}}, // Bradley International Airport
    Airport{IataCode{"BDN"}, CountryId{"US"}, Coordinate{-121.2, 44.0944}}, // Bend Municipal Airport
    Airport{IataCode{"BDO"}, CountryId{"ID"}, Coordinate{107.576, -6.90056}}, // Husein Sastranegara International Airport
    Airport{IataCode{"BDP"}, CountryId{"NP"}, Coordinate{88.0775, 26.5695}}, // Bhadrapur Airport
    Airport{IataCode{"BDQ"}, CountryId{"IN"}, Coordinate{73.2189, 22.33}}, // Vadodara Airport
    Airport{IataCode{"BDR"}, CountryId{"US"}, Coordinate{-73.1261, 41.1633}}, // Sikorsky Memorial Airport
    Airport{IataCode{"BDS"}, CountryId{"IT"}, Coordinate{17.9469, 40.6575}}, // Brindisi Airport
    Airport{IataCode{"BDT"}, CountryId{"CD"}, Coordinate{20.9701, 4.2548}}, // Gbadolite Airport
    Airport{IataCode{"BDU"}, CountryId{"NO"}, Coordinate{18.5383, 69.0595}}, // Bardufoss Airport
    Airport{IataCode{"BDV"}, CountryId{"CD"}, Coordinate{29.7333, -7.1}}, // Moba Airport
    Airport{IataCode{"BDX"}, CountryId{"US"}, Coordinate{-105.457, 45.4706}}, // Broadus Airport
    Airport{IataCode{"BDY"}, CountryId{"US"}, Coordinate{-124.408, 43.0865}}, // Bandon State Airport
    Airport{IataCode{"BDZ"}, CountryId{"PG"}, Coordinate{146.95, -6.33333}}, // Baindoung
    Airport{IataCode{"BEA"}, CountryId{"PG"}, Coordinate{146.5, -8.65}}, // Bereina Airport
    Airport{IataCode{"BEB"}, CountryId{"GB"}, Coordinate{-7.37173, 57.4739}}, // Benbecula Airport
    Airport{IataCode{"BEC"}, CountryId{"US"}, Coordinate{-97.215, 37.6944}}, // Beech Factory Airport
    Airport{IataCode{"BED"}, CountryId{"US"}, Coordinate{-71.2912, 42.4632}}, // Hanscom Field
    Airport{IataCode{"BEF"}, CountryId{"NI"}, Coordinate{-83.7742, 11.9908}}, // Bluefields Airport
    Airport{IataCode{"BEG"}, CountryId{"RS"}, Coordinate{20.2917, 44.8193}}, // Belgrade Nikola Tesla Airport
    Airport{IataCode{"BEH"}, CountryId{"US"}, Coordinate{-86.4261, 42.1286}}, // Southwest Michigan Regional Airport
    Airport{IataCode{"BEI"}, CountryId{"ET"}, Coordinate{34.5192, 9.39194}}, // Beica Airport
    Airport{IataCode{"BEJ"}, CountryId{"ID"}, Coordinate{117.434, 2.14818}}, // Kalimarau Airport
    Airport{IataCode{"BEK"}, CountryId{"IN"}, Coordinate{79.4469, 28.4225}}, // Bareilly Airport
    Airport{IataCode{"BEL"}, CountryId{"BR"}, Coordinate{-48.4796, -1.38966}}, // Val de Cans International Airport
    Airport{IataCode{"BEM"}, CountryId{"MA"}, Coordinate{-6.33333, 32.3973}}, // Beni Mellal Airport
    Airport{IataCode{"BEN"}, CountryId{"LY"}, Coordinate{20.2648, 32.0871}}, // Benina International Airport
    Airport{IataCode{"BEO"}, CountryId{"AU"}, Coordinate{151.646, -33.0678}}, // Belmont Airport
    Airport{IataCode{"BEP"}, CountryId{"IN"}, Coordinate{76.8828, 15.1628}}, // Bellary Airport
    Airport{IataCode{"BER"}, CountryId{"DE"}, Coordinate{13.5082, 52.3641}}, // Berlin Brandenburg Airport
    Airport{IataCode{"BES"}, CountryId{"FR"}, Coordinate{-4.42012, 48.4434}}, // Brest Bretagne Airport
    Airport{IataCode{"BET"}, CountryId{"US"}, Coordinate{-161.84, 60.7833}}, // Bethel Airport
    Airport{IataCode{"BEU"}, CountryId{"AU"}, Coordinate{139.46, -24.3461}}, // Bedourie Airport
    Airport{IataCode{"BEV"}, CountryId{"IL"}, Coordinate{34.723, 31.287}}, // Be'er Sheva Airport
    Airport{IataCode{"BEW"}, CountryId{"MZ"}, Coordinate{34.9024, -19.7986}}, // Beira Airport
    Airport{IataCode{"BEY"}, CountryId{"LB"}, Coordinate{35.4933, 33.8245}}, // Beirut–Rafic Hariri International Airport
    Airport{IataCode{"BEZ"}, CountryId{"KI"}, Coordinate{176.007, -1.35472}}, // Beru Island Airport
    Airport{IataCode{"BFD"}, CountryId{"US"}, Coordinate{-78.6396, 41.7994}}, // Bradford Regional Airport
    Airport{IataCode{"BFF"}, CountryId{"US"}, Coordinate{-103.596, 41.8739}}, // Western Nebraska Regional Airport
    Airport{IataCode{"BFG"}, CountryId{"US"}, Coordinate{-110.713, 37.5458}}, // Bullfrog Basin Airport
    Airport{IataCode{"BFH"}, CountryId{"BR"}, Coordinate{-49.2294, -25.4029}}, // Bacacheri Airport
    Airport{IataCode{"BFI"}, CountryId{"US"}, Coordinate{-122.304, 47.5368}}, // Boeing Field
    Airport{IataCode{"BFJ"}, CountryId{"CN"}, Coordinate{105.301, 27.3003}}, // Bijie Feixiong Airport
    Airport{IataCode{"BFK"}, CountryId{"US"}, Coordinate{-99.6186, 36.8633}}, // Buffalo Municipal Airport
    Airport{IataCode{"BFL"}, CountryId{"US"}, Coordinate{-119.055, 35.4377}}, // Meadows Field Airport
    Airport{IataCode{"BFM"}, CountryId{"US"}, Coordinate{-88.077, 30.6353}}, // Mobile Downtown Airport
    Airport{IataCode{"BFN"}, CountryId{"ZA"}, Coordinate{26.2979, -29.0956}}, // Bloemfontein Airport
    Airport{IataCode{"BFO"}, CountryId{"ZW"}, Coordinate{31.5786, -21.01}}, // Buffalo Range Airport
    Airport{IataCode{"BFP"}, CountryId{"US"}, Coordinate{-80.3914, 40.7725}}, // Beaver County Airport
    Airport{IataCode{"BFQ"}, CountryId{"PA"}, Coordinate{-78.1811, 7.58465}}, // Bahía Piña Airport
    Airport{IataCode{"BFR"}, CountryId{"US"}, Coordinate{-86.4453, 38.84}}, // Virgil I. Grissom Municipal Airport
    Airport{IataCode{"BFS"}, CountryId{"GB"}, Coordinate{-6.21775, 54.6623}}, // Belfast International Airport
    Airport{IataCode{"BFT"}, CountryId{"US"}, Coordinate{-80.6344, 32.4122}}, // Beaufort County Airport
    Airport{IataCode{"BFU"}, CountryId{"CN"}, Coordinate{117.32, 32.8475}}, // Bengbu Airport
    Airport{IataCode{"BFV"}, CountryId{"TH"}, Coordinate{103.248, 15.2281}}, // Buriram Airport
    Airport{IataCode{"BFW"}, CountryId{"DZ"}, Coordinate{-0.593275, 35.1718}}, // Sidi Bel Abbes Airport
    Airport{IataCode{"BFX"}, CountryId{"CM"}, Coordinate{10.3554, 5.53069}}, // Bafoussam Airport
    Airport{IataCode{"BGA"}, CountryId{"CO"}, Coordinate{-73.1812, 7.12786}}, // Palonegro International Airport
    Airport{IataCode{"BGB"}, CountryId{"GA"}, Coordinate{11.9431, -0.106944}}, // Booue Airport
    Airport{IataCode{"BGC"}, CountryId{"PT"}, Coordinate{-6.70713, 41.8578}}, // Bragança Airport
    Airport{IataCode{"BGD"}, CountryId{"US"}, Coordinate{-101.394, 35.7008}}, // Hutchinson County Airport
    Airport{IataCode{"BGE"}, CountryId{"US"}, Coordinate{-84.6375, 30.9717}}, // Decatur County Industrial Air Park
    Airport{IataCode{"BGF"}, CountryId{"CF"}, Coordinate{18.5241, 4.39875}}, // Bangui M'Poko International Airport
    Airport{IataCode{"BGG"}, CountryId{"TR"}, Coordinate{40.5907, 38.8587}}, // Bingöl Airport
    Airport{IataCode{"BGH"}, CountryId{"MR"}, Coordinate{-14.2, 16.6333}}, // Abbaye Airport
    Airport{IataCode{"BGI"}, CountryId{"BB"}, Coordinate{-59.4877, 13.0799}}, // Grantley Adams International Airport
    Airport{IataCode{"BGK"}, CountryId{"BZ"}, Coordinate{-88.4167, 16.5167}}, // Big Creek Airport
    Airport{IataCode{"BGL"}, CountryId{"NP"}, Coordinate{83.6664, 28.2128}}, // Baglung Airport
    Airport{IataCode{"BGM"}, CountryId{"US"}, Coordinate{-75.9825, 42.2079}}, // Greater Binghamton Airport
    Airport{IataCode{"BGN"}, CountryId{"RU"}, Coordinate{146.228, 68.5539}}, // Belaya Gora Airport
    Airport{IataCode{"BGO"}, CountryId{"NO"}, Coordinate{5.22854, 60.2898}}, // Bergen Airport
    Airport{IataCode{"BGQ"}, CountryId{"US"}, Coordinate{-149.814, 61.5361}}, // Big Lake Airport
    Airport{IataCode{"BGR"}, CountryId{"US"}, Coordinate{-68.817, 44.8083}}, // Bangor International Airport
    Airport{IataCode{"BGT"}, CountryId{"US"}, Coordinate{-113.17, 34.5958}}, // Bagdad Airport
    Airport{IataCode{"BGU"}, CountryId{"CF"}, Coordinate{22.7833, 4.78333}}, // Bangassou Airport
    Airport{IataCode{"BGW"}, CountryId{"IQ"}, Coordinate{44.2344, 33.2625}}, // Baghdad International Airport
    Airport{IataCode{"BGX"}, CountryId{"BR"}, Coordinate{-54.1126, -31.3883}}, // Comandante Gustavo Kraemer Airport
    Airport{IataCode{"BGY"}, CountryId{"IT"}, Coordinate{9.69968, 45.6651}}, // Il Caravaggio International Airport
    Airport{IataCode{"BGZ"}, CountryId{"PT"}, Coordinate{-8.44514, 41.5871}}, // Braga Airport
    Airport{IataCode{"BHA"}, CountryId{"EC"}, Coordinate{-80.4042, -0.605556}}, // Aeropuerto Los Perales
    Airport{IataCode{"BHB"}, CountryId{"US"}, Coordinate{-68.3617, 44.4458}}, // Hancock County-Bar Harbor Airport
    Airport{IataCode{"BHD"}, CountryId{"GB"}, Coordinate{-5.87078, 54.6146}}, // George Best Belfast City Airport
    Airport{IataCode{"BHE"}, CountryId{"NZ"}, Coordinate{173.87, -41.5183}}, // Woodbourne Airport
    Airport{IataCode{"BHG"}, CountryId{"HN"}, Coordinate{-84.5436, 15.735}}, // Brus Laguna Airport
    Airport{IataCode{"BHH"}, CountryId{"SA"}, Coordinate{42.6186, 19.9942}}, // Bisha Domestic Airport
    Airport{IataCode{"BHI"}, CountryId{"AR"}, Coordinate{-62.1639, -38.7164}}, // Comandante Espora Airport
    Airport{IataCode{"BHJ"}, CountryId{"IN"}, Coordinate{69.6703, 23.2878}}, // Bhuj Airport
    Airport{IataCode{"BHK"}, CountryId{"UZ"}, Coordinate{64.4752, 39.767}}, // Bukhara International Airport
    Airport{IataCode{"BHM"}, CountryId{"US"}, Coordinate{-86.7525, 33.562}}, // Birmingham-Shuttlesworth International Airport
    Airport{IataCode{"BHN"}, CountryId{"YE"}, Coordinate{45.72, 14.7819}}, // Beihan Airport
    Airport{IataCode{"BHO"}, CountryId{"IN"}, Coordinate{77.3357, 23.291}}, // Raja Bhoj Airport
    Airport{IataCode{"BHP"}, CountryId{"NP"}, Coordinate{87.0508, 27.1475}}, // Bhojpur Airport
    Airport{IataCode{"BHQ"}, CountryId{"AU"}, Coordinate{141.47, -31.9989}}, // Broken Hill Airport
    Airport{IataCode{"BHR"}, CountryId{"NP"}, Coordinate{84.4298, 27.6781}}, // Bharatpur Airport
    Airport{IataCode{"BHS"}, CountryId{"AU"}, Coordinate{149.655, -33.4137}}, // Bathurst Airport
    Airport{IataCode{"BHU"}, CountryId{"IN"}, Coordinate{72.1835, 21.7538}}, // Bhavnagar Airport
    Airport{IataCode{"BHV"}, CountryId{"PK"}, Coordinate{71.7178, 29.3481}}, // Bahawalpur Airport
    Airport{IataCode{"BHX"}, CountryId{"GB"}, Coordinate{-1.73267, 52.453}}, // Birmingham Airport
    Airport{IataCode{"BHY"}, CountryId{"CN"}, Coordinate{109.289, 21.543}}, // Beihai Fucheng Airport
    Airport{IataCode{"BIA"}, CountryId{"FR"}, Coordinate{9.48094, 42.5475}}, // Bastia – Poretta Airport
    Airport{IataCode{"BIB"}, CountryId{"SO"}, Coordinate{43.6178, 3.09267}}, // Baidoa Airport
    Airport{IataCode{"BID"}, CountryId{"US"}, Coordinate{-71.5802, 41.1693}}, // Block Island State Airport
    Airport{IataCode{"BII"}, CountryId{"MH"}, Coordinate{165.565, 11.5225}}, // Bikini Atoll Airport
    Airport{IataCode{"BIJ"}, CountryId{"PG"}, Coordinate{146.35, -5.58333}}, // Biliau
    Airport{IataCode{"BIK"}, CountryId{"ID"}, Coordinate{136.106, -1.19169}}, // Frans Kaisiepo Airport
    Airport{IataCode{"BIL"}, CountryId{"US"}, Coordinate{-108.537, 45.804}}, // Billings Logan International Airport
    Airport{IataCode{"BIM"}, CountryId{"BS"}, Coordinate{-79.2647, 25.7}}, // South Bimini Airport
    Airport{IataCode{"BIN"}, CountryId{"AF"}, Coordinate{67.8206, 34.81}}, // Bamyan Airport
    Airport{IataCode{"BIO"}, CountryId{"ES"}, Coordinate{-2.91056, 43.3011}}, // Bilbao Airport
    Airport{IataCode{"BIQ"}, CountryId{"FR"}, Coordinate{-1.53262, 43.4715}}, // Biarritz – Anglet – Bayonne Airport
    Airport{IataCode{"BIR"}, CountryId{"NP"}, Coordinate{87.2639, 26.4814}}, // Biratnagar Airport
    Airport{IataCode{"BIS"}, CountryId{"US"}, Coordinate{-100.757, 46.7751}}, // Bismarck Municipal Airport
    Airport{IataCode{"BIT"}, CountryId{"NP"}, Coordinate{80.5492, 29.4653}}, // Baitadi Airport
    Airport{IataCode{"BIU"}, CountryId{"IS"}, Coordinate{-23.5431, 65.6455}}, // Bíldudalur Airport
    Airport{IataCode{"BIV"}, CountryId{"CF"}, Coordinate{21.9894, 6.52667}}, // Bria Airport
    Airport{IataCode{"BIY"}, CountryId{"ZA"}, Coordinate{27.2877, -32.8958}}, // Bisho Airport
    Airport{IataCode{"BJA"}, CountryId{"DZ"}, Coordinate{5.07128, 36.7153}}, // Soummam – Abane Ramdane Airport
    Airport{IataCode{"BJB"}, CountryId{"IR"}, Coordinate{57.3081, 37.4898}}, // Bojnord Airport
    Airport{IataCode{"BJC"}, CountryId{"US"}, Coordinate{-105.112, 39.9097}}, // Rocky Mountain Metropolitan Airport
    Airport{IataCode{"BJD"}, CountryId{"IS"}, Coordinate{-14.8244, 66.0219}}, // Bakkafjörður Airport
    Airport{IataCode{"BJF"}, CountryId{"NO"}, Coordinate{29.6932, 70.6028}}, // Båtsfjord Airport
    Airport{IataCode{"BJG"}, CountryId{"ID"}, Coordinate{122.112, -0.960556}}, // Bolaang Airport
    Airport{IataCode{"BJH"}, CountryId{"NP"}, Coordinate{81.1853, 29.5389}}, // Bajhang Airport
    Airport{IataCode{"BJI"}, CountryId{"US"}, Coordinate{-94.9336, 47.5066}}, // Bemidji Regional Airport
    Airport{IataCode{"BJJ"}, CountryId{"US"}, Coordinate{-81.8883, 40.8747}}, // Wayne County Airport
    Airport{IataCode{"BJK"}, CountryId{"ID"}, Coordinate{134.275, -6.06292}}, // Benjina Airport
    Airport{IataCode{"BJL"}, CountryId{"GM"}, Coordinate{-16.6522, 13.3436}}, // Banjul International Airport
    Airport{IataCode{"BJM"}, CountryId{"BI"}, Coordinate{29.3213, -3.31862}}, // Bujumbura International Airport
    Airport{IataCode{"BJO"}, CountryId{"BO"}, Coordinate{-64.3128, -22.7733}}, // Bermejo Airport
    Airport{IataCode{"BJP"}, CountryId{"BR"}, Coordinate{-46.5375, -22.9792}}, // Bragança Paulista Airport
    Airport{IataCode{"BJR"}, CountryId{"ET"}, Coordinate{37.3231, 11.6033}}, // Bahir Dar Airport
    Airport{IataCode{"BJT"}, CountryId{"LK"}, Coordinate{79.9833, 6.41667}}, // Bentota River Airport
    Airport{IataCode{"BJU"}, CountryId{"NP"}, Coordinate{81.6667, 29.5}}, // Bajura Airport
    Airport{IataCode{"BJV"}, CountryId{"TR"}, Coordinate{27.6759, 37.2435}}, // Milas-Bodrum Airport
    Airport{IataCode{"BJW"}, CountryId{"ID"}, Coordinate{121.063, -8.7125}}, // Bajawa Soa Airport
    Airport{IataCode{"BJX"}, CountryId{"MX"}, Coordinate{-101.479, 20.986}}, // Del Bajío International Airport
    Airport{IataCode{"BJZ"}, CountryId{"ES"}, Coordinate{-6.82139, 38.8914}}, // Badajoz Airport
    Airport{IataCode{"BKB"}, CountryId{"IN"}, Coordinate{73.2069, 28.0706}}, // Nal Airport
    Airport{IataCode{"BKC"}, CountryId{"US"}, Coordinate{-161.149, 65.9817}}, // Buckland Airport
    Airport{IataCode{"BKE"}, CountryId{"US"}, Coordinate{-117.809, 44.8372}}, // Baker City Municipal Airport
    Airport{IataCode{"BKG"}, CountryId{"US"}, Coordinate{-93.1991, 36.5387}}, // Branson Airport
    Airport{IataCode{"BKI"}, CountryId{"MY"}, Coordinate{116.051, 5.93323}}, // Kota Kinabalu International Airport
    Airport{IataCode{"BKJ"}, CountryId{"GN"}, Coordinate{-14.2811, 10.9658}}, // Boké Baralande Airport
    Airport{IataCode{"BKK"}, CountryId{"TH"}, Coordinate{100.751, 13.6943}}, // Suvarnabhumi Airport
    Airport{IataCode{"BKL"}, CountryId{"US"}, Coordinate{-81.6898, 41.5116}}, // Cleveland Burke Lakefront Airport
    Airport{IataCode{"BKM"}, CountryId{"MY"}, Coordinate{115.618, 3.974}}, // Ba'kelalan Airport
    Airport{IataCode{"BKO"}, CountryId{"ML"}, Coordinate{-7.94685, 12.5411}}, // Bamako-Sénou International Airport
    Airport{IataCode{"BKQ"}, CountryId{"AU"}, Coordinate{145.429, -24.4278}}, // Blackall Airport
    Airport{IataCode{"BKR"}, CountryId{"TD"}, Coordinate{17.067, 12.383}}, // Bokoro Airport
    Airport{IataCode{"BKS"}, CountryId{"ID"}, Coordinate{102.339, -3.86071}}, // Fatmawati Soekarno Airport
    Airport{IataCode{"BKW"}, CountryId{"US"}, Coordinate{-81.1213, 37.7842}}, // Raleigh County Memorial Airport
    Airport{IataCode{"BKX"}, CountryId{"US"}, Coordinate{-96.8071, 44.3042}}, // Brookings Regional Airport
    Airport{IataCode{"BKY"}, CountryId{"CD"}, Coordinate{28.8086, -2.30889}}, // Kavumu Airport
    Airport{IataCode{"BKZ"}, CountryId{"TZ"}, Coordinate{31.8211, -1.33222}}, // Bukoba Airport
    Airport{IataCode{"BLA"}, CountryId{"VE"}, Coordinate{-64.6842, 10.1059}}, // General José Antonio Anzoátegui International Airport
    Airport{IataCode{"BLB"}, CountryId{"PA"}, Coordinate{-79.5994, 8.915}}, // Panamá Pacífico International Airport
    Airport{IataCode{"BLC"}, CountryId{"CM"}, Coordinate{10.0339, 5.89528}}, // Bali Airport
    Airport{IataCode{"BLD"}, CountryId{"US"}, Coordinate{-114.856, 35.9487}}, // Boulder City Municipal Airport
    Airport{IataCode{"BLE"}, CountryId{"SE"}, Coordinate{15.5078, 60.4296}}, // Dala Airport
    Airport{IataCode{"BLF"}, CountryId{"US"}, Coordinate{-81.2078, 37.2958}}, // Mercer County Airport
    Airport{IataCode{"BLG"}, CountryId{"MY"}, Coordinate{113.761, 2.63611}}, // Belaga Airport
    Airport{IataCode{"BLH"}, CountryId{"US"}, Coordinate{-114.713, 33.6147}}, // Blythe Airport
    Airport{IataCode{"BLJ"}, CountryId{"DZ"}, Coordinate{6.30816, 35.7575}}, // Mostépha Ben Boulaid Airport
    Airport{IataCode{"BLK"}, CountryId{"GB"}, Coordinate{-3.02833, 53.7714}}, // Blackpool Airport
    Airport{IataCode{"BLL"}, CountryId{"DK"}, Coordinate{9.1473, 55.746}}, // Billund Airport
    Airport{IataCode{"BLM"}, CountryId{"US"}, Coordinate{-74.125, 40.1869}}, // Monmouth Executive Airport
    Airport{IataCode{"BLN"}, CountryId{"AU"}, Coordinate{146.007, -36.5519}}, // Benalla Airport
    Airport{IataCode{"BLO"}, CountryId{"IS"}, Coordinate{-20.2875, 65.645}}, // Blönduós Airport
    Airport{IataCode{"BLQ"}, CountryId{"IT"}, Coordinate{11.2945, 44.5287}}, // Bologna Guglielmo Marconi Airport
    Airport{IataCode{"BLR"}, CountryId{"IN"}, Coordinate{77.7107, 13.2005}}, // Kempegowda International Airport
    Airport{IataCode{"BLT"}, CountryId{"AU"}, Coordinate{148.807, -23.6031}}, // Blackwater Airport
    Airport{IataCode{"BLU"}, CountryId{"US"}, Coordinate{-120.71, 39.275}}, // Blue Canyon–Nyack Airport
    Airport{IataCode{"BLX"}, CountryId{"IT"}, Coordinate{12.2481, 46.1667}}, // Belluno Airport
    Airport{IataCode{"BLY"}, CountryId{"IE"}, Coordinate{-10.0308, 54.2228}}, // Belmullet Aerodrome
    Airport{IataCode{"BLZ"}, CountryId{"MW"}, Coordinate{34.9717, -15.6813}}, // Chileka International Airport
    Airport{IataCode{"BMA"}, CountryId{"SE"}, Coordinate{17.9443, 59.356}}, // Stockholm Bromma Airport
    Airport{IataCode{"BMB"}, CountryId{"CD"}, Coordinate{22.4736, 2.18482}}, // Bumba Airport
    Airport{IataCode{"BMC"}, CountryId{"US"}, Coordinate{-112.062, 41.5525}}, // Brigham City Airport
    Airport{IataCode{"BMD"}, CountryId{"MG"}, Coordinate{44.5333, -19.6872}}, // Belo sur Tsiribihina Airport
    Airport{IataCode{"BME"}, CountryId{"AU"}, Coordinate{122.234, -17.9526}}, // Broome International Airport
    Airport{IataCode{"BMF"}, CountryId{"CF"}, Coordinate{22.8006, 5.69417}}, // Bakouma Airport
    Airport{IataCode{"BMG"}, CountryId{"US"}, Coordinate{-86.6167, 39.1461}}, // Monroe County Airport
    Airport{IataCode{"BMH"}, CountryId{"PG"}, Coordinate{144.633, -6.36667}}, // Bomai
    Airport{IataCode{"BMI"}, CountryId{"US"}, Coordinate{-88.9141, 40.4829}}, // Central Illinois Regional Airport
    Airport{IataCode{"BMJ"}, CountryId{"GY"}, Coordinate{-60.5, 7.37012}}, // Baramita Airport
    Airport{IataCode{"BML"}, CountryId{"US"}, Coordinate{-71.1758, 44.5753}}, // Berlin Regional Airport
    Airport{IataCode{"BMM"}, CountryId{"GA"}, Coordinate{11.4933, 2.07556}}, // Bitam Airport
    Airport{IataCode{"BMO"}, CountryId{"MM"}, Coordinate{97.2469, 24.2708}}, // Bhamo Airport
    Airport{IataCode{"BMP"}, CountryId{"IN"}, Coordinate{84.8769, 19.2975}}, // Berhampur Airport
    Airport{IataCode{"BMQ"}, CountryId{"KE"}, Coordinate{39.7312, -3.98005}}, // Bamburi Airport
    Airport{IataCode{"BMT"}, CountryId{"US"}, Coordinate{-94.215, 30.0703}}, // Beaumont Municipal Airport
    Airport{IataCode{"BMU"}, CountryId{"ID"}, Coordinate{118.692, -8.54182}}, // Bima Airport
    Airport{IataCode{"BMV"}, CountryId{"VN"}, Coordinate{108.118, 12.6648}}, // Buon Ma Thuot Airport
    Airport{IataCode{"BMW"}, CountryId{"DZ"}, Coordinate{0.927, 21.3778}}, // Bordj Mokhtar Airport
    Airport{IataCode{"BMY"}, CountryId{"FR"}, Coordinate{163.661, -19.7206}}, // Île Art – Waala Airport
    Airport{IataCode{"BMZ"}, CountryId{"PG"}, Coordinate{143.233, -7.83333}}, // Bamu
    Airport{IataCode{"BNA"}, CountryId{"US"}, Coordinate{-86.6703, 36.1315}}, // Nashville International Airport
    Airport{IataCode{"BNB"}, CountryId{"CD"}, Coordinate{20.8667, -0.283333}}, // Boende Airport
    Airport{IataCode{"BND"}, CountryId{"IR"}, Coordinate{56.3687, 27.21}}, // Bandar Abbas International Airport
    Airport{IataCode{"BNE"}, CountryId{"AU"}, Coordinate{153.119, -27.3851}}, // Brisbane Airport
    Airport{IataCode{"BNG"}, CountryId{"US"}, Coordinate{-116.851, 33.9225}}, // Banning Municipal Airport
    Airport{IataCode{"BNI"}, CountryId{"NG"}, Coordinate{5.60382, 6.31715}}, // Benin Airport
    Airport{IataCode{"BNK"}, CountryId{"AU"}, Coordinate{153.556, -28.8374}}, // Ballina Byron Gateway Airport
    Airport{IataCode{"BNL"}, CountryId{"US"}, Coordinate{-81.3881, 33.2581}}, // Barnwell Regional Airport
    Airport{IataCode{"BNN"}, CountryId{"NO"}, Coordinate{12.2175, 65.4611}}, // Brønnøysund Airport, Brønnøy
    Airport{IataCode{"BNO"}, CountryId{"US"}, Coordinate{-118.956, 43.5919}}, // Burns Municipal Airport
    Airport{IataCode{"BNP"}, CountryId{"PK"}, Coordinate{70.5189, 32.9741}}, // Bannu Airport
    Airport{IataCode{"BNR"}, CountryId{"BF"}, Coordinate{-4.717, 10.683}}, // Banfora Airport
    Airport{IataCode{"BNS"}, CountryId{"VE"}, Coordinate{-70.2212, 8.62187}}, // Barinas Airport
    Airport{IataCode{"BNU"}, CountryId{"BR"}, Coordinate{-49.0918, -26.8354}}, // Blumenau Airport
    Airport{IataCode{"BNW"}, CountryId{"US"}, Coordinate{-93.8475, 42.0494}}, // Boone Municipal Airport
    Airport{IataCode{"BNX"}, CountryId{"BA"}, Coordinate{17.3039, 44.9333}}, // Banja Luka International Airport
    Airport{IataCode{"BNY"}, CountryId{"SB"}, Coordinate{159.798, -11.3017}}, // Bellona/Anua Airport
    Airport{IataCode{"BNZ"}, CountryId{"PG"}, Coordinate{144.557, -5.78424}}, // Banz Airport
    Airport{IataCode{"BOA"}, CountryId{"CD"}, Coordinate{13.0636, -5.86667}}, // Boma Airport
    Airport{IataCode{"BOB"}, CountryId{"FR"}, Coordinate{-151.753, -16.4436}}, // Bora Bora Airport
    Airport{IataCode{"BOC"}, CountryId{"PA"}, Coordinate{-82.2445, 9.34049}}, // Bocas del Toro "Isla Colón" International Airport
    Airport{IataCode{"BOD"}, CountryId{"FR"}, Coordinate{-0.702379, 44.8307}}, // Bordeaux–Mérignac Airport
    Airport{IataCode{"BOE"}, CountryId{"CG"}, Coordinate{15.3833, -1.03333}}, // Boundji Airport
    Airport{IataCode{"BOG"}, CountryId{"CO"}, Coordinate{-74.1391, 4.69533}}, // El Dorado International Airport
    Airport{IataCode{"BOH"}, CountryId{"GB"}, Coordinate{-1.83249, 50.778}}, // Bournemouth Airport
    Airport{IataCode{"BOI"}, CountryId{"US"}, Coordinate{-116.221, 43.5683}}, // Boise Airport
    Airport{IataCode{"BOJ"}, CountryId{"BG"}, Coordinate{27.5173, 42.5658}}, // Burgas Airport
    Airport{IataCode{"BOK"}, CountryId{"US"}, Coordinate{-124.29, 42.0744}}, // Brookings Airport
    Airport{IataCode{"BOM"}, CountryId{"IN"}, Coordinate{72.8642, 19.0957}}, // Chhatrapati Shivaji International Airport
    Airport{IataCode{"BON"}, CountryId{"NL"}, Coordinate{-68.2767, 12.1332}}, // Flamingo International Airport
    Airport{IataCode{"BOO"}, CountryId{"NO"}, Coordinate{14.3657, 67.2724}}, // Bodø Airport
    Airport{IataCode{"BOP"}, CountryId{"CF"}, Coordinate{15.6378, 5.9625}}, // Bouar Airport
    Airport{IataCode{"BOQ"}, CountryId{"PG"}, Coordinate{155.2, -6.267}}, // Boku Airport
    Airport{IataCode{"BOS"}, CountryId{"US"}, Coordinate{-71.0196, 42.3633}}, // Logan International Airport
    Airport{IataCode{"BOT"}, CountryId{"PG"}, Coordinate{141.092, -7.24083}}, // Bosset Airport
    Airport{IataCode{"BOV"}, CountryId{"PG"}, Coordinate{153.333, -3.36667}}, // Boang
    Airport{IataCode{"BOX"}, CountryId{"AU"}, Coordinate{136.3, -16.0753}}, // Borroloola Airport
    Airport{IataCode{"BOY"}, CountryId{"BF"}, Coordinate{-4.32026, 11.1638}}, // Bobo Dioulasso Airport
    Airport{IataCode{"BOZ"}, CountryId{"CF"}, Coordinate{16.3167, 6.33333}}, // Bozoum Airport
    Airport{IataCode{"BPC"}, CountryId{"CM"}, Coordinate{10.1167, 6.03917}}, // Bamenda Airport
    Airport{IataCode{"BPD"}, CountryId{"PG"}, Coordinate{147, -7.75}}, // Bapi
    Airport{IataCode{"BPE"}, CountryId{"CN"}, Coordinate{119.059, 39.6619}}, // Qinhuangdao Beidaihe Airport
    Airport{IataCode{"BPF"}, CountryId{"SB"}, Coordinate{158, -8.63}}, // Batuna Airport
    Airport{IataCode{"BPG"}, CountryId{"BR"}, Coordinate{-52.3894, -15.8608}}, // Barra do Garças Airport
    Airport{IataCode{"BPH"}, CountryId{"PH"}, Coordinate{126.326, 8.19692}}, // Bislig Airport
    Airport{IataCode{"BPI"}, CountryId{"US"}, Coordinate{-110.111, 42.585}}, // Miley Memorial Field
    Airport{IataCode{"BPK"}, CountryId{"PG"}, Coordinate{141.744, -5.52639}}, // Biangabip Airport
    Airport{IataCode{"BPL"}, CountryId{"CN"}, Coordinate{82.2998, 44.8994}}, // Bole Alashankou Airport
    Airport{IataCode{"BPM"}, CountryId{"IN"}, Coordinate{78.4712, 17.4496}}, // Begumpet Airport
    Airport{IataCode{"BPN"}, CountryId{"ID"}, Coordinate{116.899, -1.26189}}, // Sultan Aji Muhammad Sulaiman Airport
    Airport{IataCode{"BPS"}, CountryId{"BR"}, Coordinate{-39.0808, -16.441}}, // Porto Seguro Airport
    Airport{IataCode{"BPT"}, CountryId{"US"}, Coordinate{-94.0186, 29.9548}}, // Jack Brooks Regional Airport
    Airport{IataCode{"BPX"}, CountryId{"CN"}, Coordinate{97.1071, 30.551}}, // Qamdo Bamda Airport
    Airport{IataCode{"BPY"}, CountryId{"MG"}, Coordinate{44.4833, -16.75}}, // Besalampy Airport
    Airport{IataCode{"BQA"}, CountryId{"PH"}, Coordinate{121.502, 15.7303}}, // Dr. Juan C. Angara Airport
    Airport{IataCode{"BQB"}, CountryId{"AU"}, Coordinate{115.4, -33.6872}}, // Busselton Margaret River Airport
    Airport{IataCode{"BQE"}, CountryId{"GW"}, Coordinate{-15.8381, 11.2972}}, // Bubaque Airport
    Airport{IataCode{"BQG"}, CountryId{"RU"}, Coordinate{140.449, 52.3806}}, // Bogorodskoye Airport
    Airport{IataCode{"BQH"}, CountryId{"GB"}, Coordinate{0.0288778, 51.332}}, // London Biggin Hill Airport
    Airport{IataCode{"BQJ"}, CountryId{"RU"}, Coordinate{134.695, 67.6489}}, // Batagay Airport
    Airport{IataCode{"BQK"}, CountryId{"US"}, Coordinate{-81.467, 31.255}}, // Brunswick Golden Isles Airport
    Airport{IataCode{"BQL"}, CountryId{"AU"}, Coordinate{139.9, -22.9133}}, // Boulia Airport
    Airport{IataCode{"BQN"}, CountryId{"US"}, Coordinate{-67.1357, 18.4956}}, // Rafael Hernández Airport
    Airport{IataCode{"BQO"}, CountryId{"CI"}, Coordinate{-3.0338, 9.254}}, // Tehini Airport
    Airport{IataCode{"BQS"}, CountryId{"RU"}, Coordinate{127.408, 50.4223}}, // Ignatyevo Airport
    Airport{IataCode{"BQT"}, CountryId{"BY"}, Coordinate{23.9002, 52.1117}}, // Brest Airport
    Airport{IataCode{"BQU"}, CountryId{"VC"}, Coordinate{-61.2619, 12.9883}}, // J. F. Mitchell Airport
    Airport{IataCode{"BQW"}, CountryId{"AU"}, Coordinate{127.973, -20.1483}}, // Balgo Hill Airport
    Airport{IataCode{"BRA"}, CountryId{"BR"}, Coordinate{-45.0094, -12.0792}}, // Barreiras Airport
    Airport{IataCode{"BRB"}, CountryId{"BR"}, Coordinate{-42.8058, -2.75639}}, // Barreirinhas Airport
    Airport{IataCode{"BRC"}, CountryId{"AR"}, Coordinate{-71.1621, -41.1462}}, // San Carlos de Bariloche Airport
    Airport{IataCode{"BRD"}, CountryId{"US"}, Coordinate{-94.1356, 46.4022}}, // Brainerd Lakes Regional Airport
    Airport{IataCode{"BRE"}, CountryId{"DE"}, Coordinate{8.78637, 53.0528}}, // Bremen Airport
    Airport{IataCode{"BRI"}, CountryId{"IT"}, Coordinate{16.7642, 41.1346}}, // Bari Karol Wojtyła Airport
    Airport{IataCode{"BRK"}, CountryId{"AU"}, Coordinate{145.952, -30.0383}}, // Bourke Airport
    Airport{IataCode{"BRL"}, CountryId{"US"}, Coordinate{-91.12, 40.7816}}, // Southeast Iowa Regional Airport
    Airport{IataCode{"BRM"}, CountryId{"VE"}, Coordinate{-69.3595, 10.0461}}, // Jacinto Lara International Airport
    Airport{IataCode{"BRN"}, CountryId{"CH"}, Coordinate{7.50087, 46.9135}}, // Bern Airport
    Airport{IataCode{"BRO"}, CountryId{"US"}, Coordinate{-97.4319, 25.9065}}, // Brownsville/South Padre Island International Airport
    Airport{IataCode{"BRP"}, CountryId{"PG"}, Coordinate{146.35, -7.66667}}, // Biaru
    Airport{IataCode{"BRQ"}, CountryId{"CZ"}, Coordinate{16.6944, 49.1514}}, // Brno-Tuřany Airport
    Airport{IataCode{"BRS"}, CountryId{"GB"}, Coordinate{-2.71305, 51.386}}, // Bristol Airport
    Airport{IataCode{"BRT"}, CountryId{"AU"}, Coordinate{130.62, -11.7692}}, // Bathurst Island Airport
    Airport{IataCode{"BRU"}, CountryId{"BE"}, Coordinate{4.48303, 50.8985}}, // Brussels Airport
    Airport{IataCode{"BRW"}, CountryId{"US"}, Coordinate{-156.758, 71.2881}}, // Wiley Post–Will Rogers Memorial Airport
    Airport{IataCode{"BRX"}, CountryId{"DO"}, Coordinate{-71.1234, 18.249}}, // María Montez International Airport
    Airport{IataCode{"BRY"}, CountryId{"US"}, Coordinate{-85.4997, 37.8144}}, // Samuels Field
    Airport{IataCode{"BSA"}, CountryId{"SO"}, Coordinate{49.1502, 11.2789}}, // Bender Qassim International Airport
    Airport{IataCode{"BSB"}, CountryId{"BR"}, Coordinate{-47.9186, -15.8711}}, // Brasília International Airport
    Airport{IataCode{"BSC"}, CountryId{"CO"}, Coordinate{-77.3961, 6.20307}}, // José Celestino Mutis Airport
    Airport{IataCode{"BSD"}, CountryId{"CN"}, Coordinate{99.1646, 25.0544}}, // Baoshan Yunduan Airport
    Airport{IataCode{"BSE"}, CountryId{"MY"}, Coordinate{109.763, 1.81361}}, // Sematan Airport
    Airport{IataCode{"BSG"}, CountryId{"GQ"}, Coordinate{9.79921, 1.90203}}, // Bata Airport
    Airport{IataCode{"BSJ"}, CountryId{"AU"}, Coordinate{147.568, -37.8875}}, // Bairnsdale Airport
    Airport{IataCode{"BSK"}, CountryId{"DZ"}, Coordinate{5.73359, 34.7914}}, // Biskra Airport
    Airport{IataCode{"BSL"}, CountryId{"FR"}, Coordinate{7.53004, 47.5989}}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"BSN"}, CountryId{"CF"}, Coordinate{17.4333, 6.5}}, // Bossangoa Airport
    Airport{IataCode{"BSO"}, CountryId{"PH"}, Coordinate{121.976, 20.4492}}, // Basco Airport
    Airport{IataCode{"BSP"}, CountryId{"PG"}, Coordinate{141.256, -8.85633}}, // Bensbach Airport
    Airport{IataCode{"BSQ"}, CountryId{"US"}, Coordinate{-109.883, 31.3639}}, // Bisbee Municipal Airport
    Airport{IataCode{"BSR"}, CountryId{"IQ"}, Coordinate{47.6625, 30.5489}}, // Basra International Airport
    Airport{IataCode{"BSS"}, CountryId{"BR"}, Coordinate{-46.0533, -7.52528}}, // Balsas Airport
    Airport{IataCode{"BST"}, CountryId{"AF"}, Coordinate{64.3633, 31.5605}}, // Bost Airport
    Airport{IataCode{"BSU"}, CountryId{"CD"}, Coordinate{19.7889, 1.21667}}, // Basankusu Airport
    Airport{IataCode{"BSW"}, CountryId{"US"}, Coordinate{-146.146, 60.4231}}, // Boswell Bay Airport
    Airport{IataCode{"BSX"}, CountryId{"MM"}, Coordinate{94.78, 16.8125}}, // Pathein Airport
    Airport{IataCode{"BSY"}, CountryId{"SO"}, Coordinate{42.3077, 2.33672}}, // Bardera Airport
    Airport{IataCode{"BTA"}, CountryId{"CM"}, Coordinate{13.7207, 4.55946}}, // Bertoua Airport
    Airport{IataCode{"BTB"}, CountryId{"CG"}, Coordinate{18.5, 3.05}}, // Bétou Airport
    Airport{IataCode{"BTF"}, CountryId{"US"}, Coordinate{-111.927, 40.8694}}, // Skypark Airport
    Airport{IataCode{"BTG"}, CountryId{"CF"}, Coordinate{18.3, 7.31667}}, // Batangafo Airport
    Airport{IataCode{"BTH"}, CountryId{"ID"}, Coordinate{104.115, 1.12284}}, // Hang Nadim Airport
    Airport{IataCode{"BTI"}, CountryId{"US"}, Coordinate{-143.582, 70.1339}}, // Barter Island LRRS Airport
    Airport{IataCode{"BTJ"}, CountryId{"ID"}, Coordinate{95.4174, 5.51864}}, // Sultan Iskandar Muda Airport
    Airport{IataCode{"BTK"}, CountryId{"RU"}, Coordinate{101.703, 56.3652}}, // Bratsk Airport
    Airport{IataCode{"BTL"}, CountryId{"US"}, Coordinate{-85.25, 42.3064}}, // W. K. Kellogg Airport
    Airport{IataCode{"BTM"}, CountryId{"US"}, Coordinate{-112.497, 45.9547}}, // Bert Mooney Airport
    Airport{IataCode{"BTN"}, CountryId{"US"}, Coordinate{-79.7344, 34.6217}}, // Marlboro County Jetport
    Airport{IataCode{"BTO"}, CountryId{"SR"}, Coordinate{-55.447, 4.21751}}, // Botopassi Airstrip
    Airport{IataCode{"BTP"}, CountryId{"US"}, Coordinate{-79.9497, 40.7769}}, // Butler County Airport
    Airport{IataCode{"BTQ"}, CountryId{"RW"}, Coordinate{29.74, -2.595}}, // Butare Airport
    Airport{IataCode{"BTR"}, CountryId{"US"}, Coordinate{-91.1561, 30.5328}}, // Baton Rouge Metropolitan Airport
    Airport{IataCode{"BTS"}, CountryId{"SK"}, Coordinate{17.2001, 48.1697}}, // M. R. Štefánik Airport
    Airport{IataCode{"BTT"}, CountryId{"US"}, Coordinate{-151.529, 66.9139}}, // Bettles Airport
    Airport{IataCode{"BTU"}, CountryId{"MY"}, Coordinate{113.024, 3.12375}}, // Bintulu Airport
    Airport{IataCode{"BTV"}, CountryId{"US"}, Coordinate{-73.1511, 44.4669}}, // Burlington International Airport
    Airport{IataCode{"BTW"}, CountryId{"ID"}, Coordinate{116, -3.45}}, // Batu Licin Airport
    Airport{IataCode{"BTY"}, CountryId{"US"}, Coordinate{-116.787, 36.8611}}, // Beatty Airport
    Airport{IataCode{"BUA"}, CountryId{"PG"}, Coordinate{154.676, -5.42103}}, // Buka Airport
    Airport{IataCode{"BUC"}, CountryId{"AU"}, Coordinate{139.534, -17.7486}}, // Burketown Airport
    Airport{IataCode{"BUD"}, CountryId{"HU"}, Coordinate{19.2619, 47.4394}}, // Budapest Ferenc Liszt International Airport
    Airport{IataCode{"BUF"}, CountryId{"US"}, Coordinate{-78.732, 42.9347}}, // Buffalo Niagara International Airport
    Airport{IataCode{"BUG"}, CountryId{"AO"}, Coordinate{13.4041, -12.606}}, // Benguela Airport
    Airport{IataCode{"BUI"}, CountryId{"ID"}, Coordinate{138.65, -3.71667}}, // Bokondini Airport
    Airport{IataCode{"BUJ"}, CountryId{"DZ"}, Coordinate{4.20575, 35.3327}}, // Ain Eddis Airport
    Airport{IataCode{"BUK"}, CountryId{"YE"}, Coordinate{43.7667, 15.8333}}, // Albuq Airport
    Airport{IataCode{"BUL"}, CountryId{"PG"}, Coordinate{146.652, -7.21545}}, // Bulolo Airport
    Airport{IataCode{"BUN"}, CountryId{"CO"}, Coordinate{-76.9933, 3.82085}}, // Gerardo Tobar López Airport
    Airport{IataCode{"BUO"}, CountryId{"SO"}, Coordinate{45.5583, 9.53212}}, // Burao Airport
    Airport{IataCode{"BUP"}, CountryId{"IN"}, Coordinate{74.7458, 30.2714}}, // Bathinda Airport
    Airport{IataCode{"BUQ"}, CountryId{"ZW"}, Coordinate{28.6223, -20.0153}}, // Joshua Mqabuko Nkomo International Airport
    Airport{IataCode{"BUR"}, CountryId{"US"}, Coordinate{-118.359, 34.2006}}, // Hollywood Burbank Airport
    Airport{IataCode{"BUS"}, CountryId{"GE"}, Coordinate{41.6108, 41.6068}}, // Batumi International Airport
    Airport{IataCode{"BUT"}, CountryId{"BT"}, Coordinate{90.7464, 27.5628}}, // Bathpalathang Airport
    Airport{IataCode{"BUU"}, CountryId{"ID"}, Coordinate{102.183, -1.5425}}, // Muara Bungo Airport
    Airport{IataCode{"BUV"}, CountryId{"UY"}, Coordinate{-57.5597, -30.3194}}, // Placeres Airport
    Airport{IataCode{"BUW"}, CountryId{"ID"}, Coordinate{122.57, -5.48796}}, // Betoambari Airport
    Airport{IataCode{"BUX"}, CountryId{"CD"}, Coordinate{30.2167, 1.56583}}, // Bunia Airport
    Airport{IataCode{"BUY"}, CountryId{"AU"}, Coordinate{115.677, -33.3781}}, // Bunbury Airport
    Airport{IataCode{"BUZ"}, CountryId{"IR"}, Coordinate{50.8303, 28.9448}}, // Bushehr Airport
    Airport{IataCode{"BVA"}, CountryId{"FR"}, Coordinate{2.11261, 49.4594}}, // Beauvais-Tillé Airport
    Airport{IataCode{"BVB"}, CountryId{"BR"}, Coordinate{-60.6922, 2.84139}}, // Boa Vista International Airport
    Airport{IataCode{"BVC"}, CountryId{"CV"}, Coordinate{-22.892, 16.1353}}, // Aristides Pereira International Airport
    Airport{IataCode{"BVE"}, CountryId{"FR"}, Coordinate{1.49032, 45.0413}}, // Brive – Souillac Airport
    Airport{IataCode{"BVF"}, CountryId{"FJ"}, Coordinate{178.617, -16.8}}, // Bua / Dama
    Airport{IataCode{"BVG"}, CountryId{"NO"}, Coordinate{29.0342, 70.8714}}, // Berlevåg Airport
    Airport{IataCode{"BVI"}, CountryId{"AU"}, Coordinate{139.351, -25.8972}}, // Birdsville Airport
    Airport{IataCode{"BVJ"}, CountryId{"RU"}, Coordinate{68.3366, 70.3198}}, // Bovanenkovo Airport
    Airport{IataCode{"BVK"}, CountryId{"BO"}, Coordinate{-63.8783, -13.6066}}, // Huacaraje Airport
    Airport{IataCode{"BVL"}, CountryId{"BO"}, Coordinate{-63.5833, -13.5833}}, // Baures Airport
    Airport{IataCode{"BVO"}, CountryId{"US"}, Coordinate{-96.0111, 36.7642}}, // Bartlesville Municipal Airport
    Airport{IataCode{"BVP"}, CountryId{"PG"}, Coordinate{141.7, -5.38333}}, // Bolovip
    Airport{IataCode{"BVU"}, CountryId{"US"}, Coordinate{-151.045, 61.1731}}, // Beluga Airport
    Airport{IataCode{"BVV"}, CountryId{"RU"}, Coordinate{147.622, 44.92}}, // Burevestnik Airport
    Airport{IataCode{"BVW"}, CountryId{"AU"}, Coordinate{142.675, -12.6592}}, // Batavia Downs Airport
    Airport{IataCode{"BVX"}, CountryId{"US"}, Coordinate{-91.6475, 35.7261}}, // Batesville Regional Airport
    Airport{IataCode{"BVY"}, CountryId{"US"}, Coordinate{-70.9165, 42.5842}}, // Beverly Municipal Airport
    Airport{IataCode{"BVZ"}, CountryId{"AU"}, Coordinate{125.433, -16.7333}}, // Beverley Springs Airport
    Airport{IataCode{"BWA"}, CountryId{"NP"}, Coordinate{83.4192, 27.5072}}, // Gautam Buddha Airport
    Airport{IataCode{"BWB"}, CountryId{"AU"}, Coordinate{115.406, -20.8659}}, // Barrow Island Airport
    Airport{IataCode{"BWC"}, CountryId{"US"}, Coordinate{-115.517, 32.9931}}, // Brawley Municipal Airport
    Airport{IataCode{"BWD"}, CountryId{"US"}, Coordinate{-98.9564, 31.7936}}, // Brownwood Regional Airport
    Airport{IataCode{"BWE"}, CountryId{"DE"}, Coordinate{10.56, 52.3164}}, // Braunschweig Airport
    Airport{IataCode{"BWF"}, CountryId{"GB"}, Coordinate{-3.25995, 54.1252}}, // Barrow/Walney Island Airport
    Airport{IataCode{"BWG"}, CountryId{"US"}, Coordinate{-86.427, 36.9623}}, // Bowling Green-Warren County Regional Airport
    Airport{IataCode{"BWI"}, CountryId{"US"}, Coordinate{-76.6698, 39.1828}}, // Baltimore/Washington International Thurgood Marshall Airport
    Airport{IataCode{"BWJ"}, CountryId{"PG"}, Coordinate{146.9, -6.4}}, // Bawan
    Airport{IataCode{"BWK"}, CountryId{"HR"}, Coordinate{16.6791, 43.2887}}, // Bol Airport
    Airport{IataCode{"BWL"}, CountryId{"US"}, Coordinate{-97.3494, 36.745}}, // Blackwell–Tonkawa Municipal Airport
    Airport{IataCode{"BWN"}, CountryId{"BN"}, Coordinate{114.934, 4.94564}}, // Brunei International Airport
    Airport{IataCode{"BWO"}, CountryId{"RU"}, Coordinate{47.75, 51.85}}, // Balakovo Airport
    Airport{IataCode{"BWP"}, CountryId{"PG"}, Coordinate{141.165, -3.02218}}, // Bewani Airport
    Airport{IataCode{"BWQ"}, CountryId{"AU"}, Coordinate{146.817, -29.9733}}, // Brewarrina Airport
    Airport{IataCode{"BWT"}, CountryId{"AU"}, Coordinate{145.726, -40.9935}}, // Burnie Airport
    Airport{IataCode{"BWU"}, CountryId{"AU"}, Coordinate{150.984, -33.9233}}, // Bankstown Airport
    Airport{IataCode{"BWW"}, CountryId{"CU"}, Coordinate{-79.1469, 22.6195}}, // Las Brujas Airport
    Airport{IataCode{"BWX"}, CountryId{"ID"}, Coordinate{114.341, -8.31289}}, // Blimbingsari Airport
    Airport{IataCode{"BXB"}, CountryId{"ID"}, Coordinate{133.417, -2.55}}, // Babo Airport
    Airport{IataCode{"BXD"}, CountryId{"ID"}, Coordinate{139.583, -7.16667}}, // Bade Airport
    Airport{IataCode{"BXE"}, CountryId{"SN"}, Coordinate{-12.4833, 14.8472}}, // Bakel Airport
    Airport{IataCode{"BXG"}, CountryId{"AU"}, Coordinate{144.326, -36.7389}}, // Bendigo Airport
    Airport{IataCode{"BXH"}, CountryId{"KZ"}, Coordinate{75.005, 46.8933}}, // Balkhash Airport
    Airport{IataCode{"BXI"}, CountryId{"CI"}, Coordinate{-6.467, 9.533}}, // Boundiali Airport
    Airport{IataCode{"BXJ"}, CountryId{"KZ"}, Coordinate{76.8764, 43.3556}}, // Boraldai Airport
    Airport{IataCode{"BXK"}, CountryId{"US"}, Coordinate{-112.686, 33.4206}}, // Buckeye Municipal Airport
    Airport{IataCode{"BXM"}, CountryId{"ID"}, Coordinate{140.882, -4.44294}}, // Batom Airport
    Airport{IataCode{"BXN"}, CountryId{"TR"}, Coordinate{27.6556, 37.1361}}, // Bodrum-Imsik Airport
    Airport{IataCode{"BXO"}, CountryId{"CH"}, Coordinate{8.39694, 46.9744}}, // Buochs Airport
    Airport{IataCode{"BXP"}, CountryId{"PL"}, Coordinate{23.1454, 52.0055}}, // Biała Podlaska Airport
    Airport{IataCode{"BXR"}, CountryId{"IR"}, Coordinate{58.4486, 29.0809}}, // Bam Airport
    Airport{IataCode{"BXS"}, CountryId{"US"}, Coordinate{-116.325, 33.2574}}, // Borrego Valley Airport
    Airport{IataCode{"BXT"}, CountryId{"ID"}, Coordinate{117.473, 0.119247}}, // Bontang Airport
    Airport{IataCode{"BXU"}, CountryId{"PH"}, Coordinate{125.481, 8.94803}}, // Bancasi Airport
    Airport{IataCode{"BXV"}, CountryId{"IS"}, Coordinate{-14.0228, 64.79}}, // Breiðdalsvík Airport
    Airport{IataCode{"BXW"}, CountryId{"ID"}, Coordinate{112.679, -5.72361}}, // Bawean Airport
    Airport{IataCode{"BXX"}, CountryId{"SO"}, Coordinate{43.1508, 9.94556}}, // Boorama Airport
    Airport{IataCode{"BXY"}, CountryId{"KZ"}, Coordinate{63.2144, 45.6183}}, // Krayniy Airport
    Airport{IataCode{"BXZ"}, CountryId{"PG"}, Coordinate{147.9, -5.717}}, // Bunsil
    Airport{IataCode{"BYB"}, CountryId{"OM"}, Coordinate{56.2478, 25.6157}}, // Dibba Airport
    Airport{IataCode{"BYC"}, CountryId{"BO"}, Coordinate{-63.6517, -21.9608}}, // Yacuiba Airport
    Airport{IataCode{"BYD"}, CountryId{"YE"}, Coordinate{45.44, 14.1056}}, // Al Bayda' Airport
    Airport{IataCode{"BYF"}, CountryId{"FR"}, Coordinate{2.693, 49.9731}}, // Albert – Picardie Airport
    Airport{IataCode{"BYH"}, CountryId{"US"}, Coordinate{-89.9439, 35.9644}}, // Arkansas International Airport
    Airport{IataCode{"BYI"}, CountryId{"US"}, Coordinate{-113.772, 42.5425}}, // Burley Municipal Airport
    Airport{IataCode{"BYJ"}, CountryId{"PT"}, Coordinate{-7.9325, 38.0789}}, // Beja Airport
    Airport{IataCode{"BYK"}, CountryId{"CI"}, Coordinate{-5.06886, 7.73601}}, // Bouaké Airport
    Airport{IataCode{"BYL"}, CountryId{"LR"}, Coordinate{-9.59, 7.22}}, // Belle Yella aerodrome
    Airport{IataCode{"BYM"}, CountryId{"CU"}, Coordinate{-76.6221, 20.3938}}, // Carlos Manuel de Céspedes Airport
    Airport{IataCode{"BYN"}, CountryId{"MN"}, Coordinate{100.707, 46.1747}}, // Bayankhongor Airport
    Airport{IataCode{"BYO"}, CountryId{"BR"}, Coordinate{-56.4525, -21.2472}}, // Bonito Airport
    Airport{IataCode{"BYP"}, CountryId{"AU"}, Coordinate{119.166, -22.6726}}, // Barimunya Airport
    Airport{IataCode{"BYR"}, CountryId{"DK"}, Coordinate{10.9997, 57.2769}}, // Læsø Airport
    Airport{IataCode{"BYT"}, CountryId{"IE"}, Coordinate{-9.48444, 51.6689}}, // Bantry Aerodrome
    Airport{IataCode{"BZB"}, CountryId{"MZ"}, Coordinate{35.4728, -21.5428}}, // Bazaruto Island Airport
    Airport{IataCode{"BZC"}, CountryId{"BR"}, Coordinate{-41.9656, -22.7711}}, // Armação dos Búzios Airport
    Airport{IataCode{"BZD"}, CountryId{"AU"}, Coordinate{143.568, -34.615}}, // Balranald Airport
    Airport{IataCode{"BZE"}, CountryId{"BZ"}, Coordinate{-88.308, 17.5362}}, // Philip S. W. Goldson International Airport
    Airport{IataCode{"BZF"}, CountryId{"US"}, Coordinate{-122.408, 40.5742}}, // Benton Field
    Airport{IataCode{"BZG"}, CountryId{"PL"}, Coordinate{17.9974, 53.094}}, // Bydgoszcz Ignacy Jan Paderewski Airport
    Airport{IataCode{"BZK"}, CountryId{"RU"}, Coordinate{34.1828, 53.2135}}, // Bryansk International Airport
    Airport{IataCode{"BZL"}, CountryId{"BD"}, Coordinate{90.3012, 22.801}}, // Barisal Airport
    Airport{IataCode{"BZN"}, CountryId{"US"}, Coordinate{-111.161, 45.7781}}, // Bozeman Yellowstone International Airport
    Airport{IataCode{"BZO"}, CountryId{"IT"}, Coordinate{11.3304, 46.4623}}, // Bolzano airport
    Airport{IataCode{"BZR"}, CountryId{"FR"}, Coordinate{3.35343, 43.3207}}, // Béziers Cap d'Agde Airport
    Airport{IataCode{"BZU"}, CountryId{"CD"}, Coordinate{24.7833, 2.81667}}, // Buta Zega Airport
    Airport{IataCode{"BZV"}, CountryId{"CG"}, Coordinate{15.2514, -4.25859}}, // Maya-Maya Airport
    Airport{IataCode{"BZX"}, CountryId{"CN"}, Coordinate{106.633, 30.7}}, // Bazhong Enyang Airport
    Airport{IataCode{"BZY"}, CountryId{"MD"}, Coordinate{27.7772, 47.8431}}, // Bălți International Airport
    Airport{IataCode{"CAA"}, CountryId{"HN"}, Coordinate{-85.9, 14.8756}}, // El Aguacate Airport
    Airport{IataCode{"CAB"}, CountryId{"AO"}, Coordinate{12.1897, -5.58595}}, // Cabinda Airport
    Airport{IataCode{"CAD"}, CountryId{"US"}, Coordinate{-85.4189, 44.2753}}, // Wexford County Airport
    Airport{IataCode{"CAE"}, CountryId{"US"}, Coordinate{-81.1252, 33.9459}}, // Columbia Metropolitan Airport
    Airport{IataCode{"CAF"}, CountryId{"BR"}, Coordinate{-66.8975, -4.87139}}, // Carauari Airport
    Airport{IataCode{"CAG"}, CountryId{"IT"}, Coordinate{9.06054, 39.2547}}, // Cagliari Elmas Airport
    Airport{IataCode{"CAH"}, CountryId{"VN"}, Coordinate{105.179, 9.17556}}, // Cà Mau Airport
    Airport{IataCode{"CAI"}, CountryId{"EG"}, Coordinate{31.4012, 30.1286}}, // Cairo International Airport
    Airport{IataCode{"CAJ"}, CountryId{"VE"}, Coordinate{-62.8551, 6.24115}}, // Canaima Airport
    Airport{IataCode{"CAK"}, CountryId{"US"}, Coordinate{-81.4369, 40.9148}}, // Akron-Canton Airport
    Airport{IataCode{"CAL"}, CountryId{"GB"}, Coordinate{-5.68639, 55.4372}}, // Campbeltown Airport
    Airport{IataCode{"CAN"}, CountryId{"CN"}, Coordinate{113.299, 23.3924}}, // Guangzhou Baiyun International Airport
    Airport{IataCode{"CAO"}, CountryId{"US"}, Coordinate{-103.15, 36.4464}}, // Clayton Municipal Airpark
    Airport{IataCode{"CAP"}, CountryId{"HT"}, Coordinate{-72.1942, 19.7371}}, // Cap-Haitien International Airport
    Airport{IataCode{"CAQ"}, CountryId{"CO"}, Coordinate{-75.1995, 7.96593}}, // Juan H. White Airport
    Airport{IataCode{"CAR"}, CountryId{"US"}, Coordinate{-68.0179, 46.8715}}, // Caribou Municipal Airport
    Airport{IataCode{"CAT"}, CountryId{"PT"}, Coordinate{-9.35787, 38.7244}}, // Cascais Municipal Aerodrome
    Airport{IataCode{"CAU"}, CountryId{"BR"}, Coordinate{-36.0108, -8.28444}}, // Caruaru Airport
    Airport{IataCode{"CAV"}, CountryId{"AO"}, Coordinate{22.916, -11.8929}}, // Cazombo Airport
    Airport{IataCode{"CAW"}, CountryId{"BR"}, Coordinate{-41.3027, -21.7053}}, // Bartolomeu Lysandro Airport
    Airport{IataCode{"CAX"}, CountryId{"GB"}, Coordinate{-2.80644, 54.9383}}, // Carlisle Lake District Airport
    Airport{IataCode{"CAY"}, CountryId{"FR"}, Coordinate{-52.3639, 4.8223}}, // Cayenne – Félix Eboué Airport
    Airport{IataCode{"CAZ"}, CountryId{"AU"}, Coordinate{145.793, -31.5383}}, // Cobar Airport
    Airport{IataCode{"CBB"}, CountryId{"BO"}, Coordinate{-66.1789, -17.4143}}, // Jorge Wilstermann International Airport
    Airport{IataCode{"CBC"}, CountryId{"AU"}, Coordinate{125.367, -18.6667}}, // Cherrabun
    Airport{IataCode{"CBE"}, CountryId{"US"}, Coordinate{-78.7608, 39.6156}}, // Greater Cumberland Regional Airport
    Airport{IataCode{"CBF"}, CountryId{"US"}, Coordinate{-95.7659, 41.2568}}, // Council Bluffs Municipal Airport
    Airport{IataCode{"CBG"}, CountryId{"GB"}, Coordinate{0.175229, 52.2099}}, // Cambridge City Airport
    Airport{IataCode{"CBH"}, CountryId{"DZ"}, Coordinate{-2.26119, 31.6547}}, // Boudghene Ben Ali Lotfi Airport
    Airport{IataCode{"CBJ"}, CountryId{"DO"}, Coordinate{-71.6447, 17.9289}}, // Cabo Rojo Airport
    Airport{IataCode{"CBK"}, CountryId{"US"}, Coordinate{-101.047, 39.4275}}, // Colby Municipal Airport
    Airport{IataCode{"CBL"}, CountryId{"VE"}, Coordinate{-63.5379, 8.12624}}, // Tomás de Heres Airport
    Airport{IataCode{"CBN"}, CountryId{"ID"}, Coordinate{108.54, -6.75614}}, // Penggung Airport
    Airport{IataCode{"CBO"}, CountryId{"PH"}, Coordinate{124.215, 7.16171}}, // Awang Airport
    Airport{IataCode{"CBP"}, CountryId{"PT"}, Coordinate{-8.46749, 40.1569}}, // Coimbra Airport
    Airport{IataCode{"CBQ"}, CountryId{"NG"}, Coordinate{8.34718, 4.96954}}, // Margaret Ekpo International Airport
    Airport{IataCode{"CBR"}, CountryId{"AU"}, Coordinate{149.195, -35.3069}}, // Canberra International Airport
    Airport{IataCode{"CBS"}, CountryId{"VE"}, Coordinate{-71.3225, 10.33}}, // Oro Negro Airport
    Airport{IataCode{"CBT"}, CountryId{"AO"}, Coordinate{13.4908, -12.487}}, // Catumbela Airport
    Airport{IataCode{"CBV"}, CountryId{"GT"}, Coordinate{-90.4067, 15.4689}}, // Cobán Airport
    Airport{IataCode{"CBX"}, CountryId{"AU"}, Coordinate{147.201, -33.065}}, // Condobolin Airport
    Airport{IataCode{"CCA"}, CountryId{"BO"}, Coordinate{-65.1512, -16.9694}}, // Chimore Airport
    Airport{IataCode{"CCB"}, CountryId{"US"}, Coordinate{-117.688, 34.1117}}, // Cable Airport
    Airport{IataCode{"CCC"}, CountryId{"CU"}, Coordinate{-78.3294, 22.466}}, // Jardines del Rey Airport
    Airport{IataCode{"CCE"}, CountryId{"EG"}, Coordinate{31.8382, 30.0553}}, // Capital International Airport
    Airport{IataCode{"CCF"}, CountryId{"FR"}, Coordinate{2.30842, 43.214}}, // Carcassonne Airport
    Airport{IataCode{"CCH"}, CountryId{"CL"}, Coordinate{-71.6924, -46.5811}}, // Chile Chico Airport
    Airport{IataCode{"CCI"}, CountryId{"BR"}, Coordinate{-52.0511, -27.1806}}, // Concórdia Airport
    Airport{IataCode{"CCJ"}, CountryId{"IN"}, Coordinate{75.9509, 11.1397}}, // Calicut International Airport
    Airport{IataCode{"CCK"}, CountryId{"AU"}, Coordinate{96.8339, -12.1883}}, // Cocos (Keeling) Islands Airport
    Airport{IataCode{"CCL"}, CountryId{"AU"}, Coordinate{150.617, -26.775}}, // Chinchilla Airport
    Airport{IataCode{"CCM"}, CountryId{"BR"}, Coordinate{-49.4214, -28.7244}}, // Diomício Freitas Airport
    Airport{IataCode{"CCN"}, CountryId{"AF"}, Coordinate{65.2664, 34.5266}}, // Chaghcharan Airport
    Airport{IataCode{"CCP"}, CountryId{"CL"}, Coordinate{-73.0595, -36.7769}}, // Carriel Sur International Airport
    Airport{IataCode{"CCR"}, CountryId{"US"}, Coordinate{-122.061, 37.9886}}, // Buchanan Field Airport
    Airport{IataCode{"CCS"}, CountryId{"VE"}, Coordinate{-67.0001, 10.5974}}, // Simón Bolívar International Airport
    Airport{IataCode{"CCT"}, CountryId{"AR"}, Coordinate{-67.8346, -37.9086}}, // Colonia Catriel Airport
    Airport{IataCode{"CCU"}, CountryId{"IN"}, Coordinate{88.439, 22.6451}}, // Netaji Subhas Chandra Bose International Airport
    Airport{IataCode{"CCV"}, CountryId{"VU"}, Coordinate{167.924, -16.265}}, // Craig Cove Airport
    Airport{IataCode{"CCW"}, CountryId{"AU"}, Coordinate{136.892, -33.6667}}, // Cowell Airport
    Airport{IataCode{"CCY"}, CountryId{"US"}, Coordinate{-92.6074, 43.0688}}, // Northeast Iowa Regional Airport
    Airport{IataCode{"CCZ"}, CountryId{"BS"}, Coordinate{-77.8833, 25.4167}}, // Chub Cay International Airport
    Airport{IataCode{"CDB"}, CountryId{"US"}, Coordinate{-162.724, 55.2053}}, // Cold Bay Airport
    Airport{IataCode{"CDC"}, CountryId{"US"}, Coordinate{-113.099, 37.7008}}, // Cedar City Regional Airport
    Airport{IataCode{"CDD"}, CountryId{"HN"}, Coordinate{-83.5917, 15.3167}}, // Cauquira Airport
    Airport{IataCode{"CDE"}, CountryId{"CN"}, Coordinate{118.072, 41.1219}}, // Chengde Airport
    Airport{IataCode{"CDG"}, CountryId{"FR"}, Coordinate{2.54778, 49.0097}}, // Paris-Charles de Gaulle Airport
    Airport{IataCode{"CDH"}, CountryId{"US"}, Coordinate{-92.7633, 33.6228}}, // Harrell Field
    Airport{IataCode{"CDI"}, CountryId{"BR"}, Coordinate{-41.1864, -20.8353}}, // Cachoeiro de Itapemirim Airport
    Airport{IataCode{"CDJ"}, CountryId{"BR"}, Coordinate{-49.3031, -8.34861}}, // Conceição do Araguaia Airport
    Airport{IataCode{"CDK"}, CountryId{"US"}, Coordinate{-83.0506, 29.1342}}, // George T. Lewis Airport
    Airport{IataCode{"CDN"}, CountryId{"US"}, Coordinate{-80.565, 34.2836}}, // Woodward Field (airport)
    Airport{IataCode{"CDP"}, CountryId{"IN"}, Coordinate{78.768, 14.5184}}, // Kadapa Airport
    Airport{IataCode{"CDQ"}, CountryId{"AU"}, Coordinate{142.258, -18.225}}, // Croydon Airport
    Airport{IataCode{"CDR"}, CountryId{"US"}, Coordinate{-103.097, 42.8289}}, // Chadron Municipal Airport
    Airport{IataCode{"CDS"}, CountryId{"US"}, Coordinate{-100.288, 34.4339}}, // Childress Municipal Airport
    Airport{IataCode{"CDT"}, CountryId{"ES"}, Coordinate{0.0669373, 40.2054}}, // Castellón-Costa Azahar Airport
    Airport{IataCode{"CDU"}, CountryId{"AU"}, Coordinate{150.684, -34.0483}}, // Camden Airport
    Airport{IataCode{"CDV"}, CountryId{"US"}, Coordinate{-145.472, 60.4944}}, // Merle K. (Mudhole) Smith Airport
    Airport{IataCode{"CDW"}, CountryId{"US"}, Coordinate{-74.2814, 40.8753}}, // Essex County Airport
    Airport{IataCode{"CDY"}, CountryId{"PH"}, Coordinate{118.495, 7.01273}}, // Cagayan de Sulu Airport
    Airport{IataCode{"CEA"}, CountryId{"US"}, Coordinate{-97.2506, 37.6486}}, // Cessna Aircraft Field
    Airport{IataCode{"CEB"}, CountryId{"PH"}, Coordinate{123.976, 10.3136}}, // Mactan–Cebu International Airport
    Airport{IataCode{"CEC"}, CountryId{"US"}, Coordinate{-124.237, 41.7803}}, // Del Norte County Airport
    Airport{IataCode{"CED"}, CountryId{"AU"}, Coordinate{133.71, -32.1306}}, // Ceduna Airport
    Airport{IataCode{"CEE"}, CountryId{"RU"}, Coordinate{38.0209, 59.2815}}, // Cherepovets Airport
    Airport{IataCode{"CEF"}, CountryId{"US"}, Coordinate{-72.5558, 42.1795}}, // Westover Metropolitan Airport
    Airport{IataCode{"CEG"}, CountryId{"GB"}, Coordinate{-2.97778, 53.1781}}, // Hawarden Airport
    Airport{IataCode{"CEH"}, CountryId{"MW"}, Coordinate{33.8, -10.55}}, // Chelinda Airport
    Airport{IataCode{"CEI"}, CountryId{"TH"}, Coordinate{99.8792, 19.9543}}, // Mae Fah Luang – Chiang Rai International Airport
    Airport{IataCode{"CEJ"}, CountryId{"UA"}, Coordinate{31.16, 51.4033}}, // Chernihiv Shestovitsa Airport
    Airport{IataCode{"CEK"}, CountryId{"RU"}, Coordinate{61.5117, 55.2981}}, // Chelyabinsk Airport
    Airport{IataCode{"CEL"}, CountryId{"BS"}, Coordinate{-76.2947, 24.7903}}, // Cape Eleuthera Airport
    Airport{IataCode{"CEM"}, CountryId{"US"}, Coordinate{-144.781, 65.5739}}, // Central Airport
    Airport{IataCode{"CEN"}, CountryId{"MX"}, Coordinate{-109.833, 27.3981}}, // Ciudad Obregón International Airport
    Airport{IataCode{"CEO"}, CountryId{"AO"}, Coordinate{15.1014, -11.4264}}, // Waco Kungo Airport
    Airport{IataCode{"CEP"}, CountryId{"BO"}, Coordinate{-62.026, -16.1472}}, // Concepcion Airport
    Airport{IataCode{"CEQ"}, CountryId{"FR"}, Coordinate{6.95417, 43.5464}}, // Cannes – Mandelieu Airport
    Airport{IataCode{"CER"}, CountryId{"FR"}, Coordinate{-1.47673, 49.647}}, // Cherbourg – Maupertus Airport
    Airport{IataCode{"CES"}, CountryId{"AU"}, Coordinate{151.343, -32.7814}}, // Cessnock Airport
    Airport{IataCode{"CEU"}, CountryId{"US"}, Coordinate{-82.8868, 34.6719}}, // Oconee County Regional Airport
    Airport{IataCode{"CEV"}, CountryId{"US"}, Coordinate{-85.1311, 39.6983}}, // Mettel Field
    Airport{IataCode{"CEW"}, CountryId{"US"}, Coordinate{-86.5241, 30.7755}}, // Bob Sikes Airport
    Airport{IataCode{"CEY"}, CountryId{"US"}, Coordinate{-88.3728, 36.6644}}, // Murray-Calloway County Airport
    Airport{IataCode{"CEZ"}, CountryId{"US"}, Coordinate{-108.628, 37.3031}}, // Cortez Municipal Airport
    Airport{IataCode{"CFB"}, CountryId{"BR"}, Coordinate{-42.0794, -22.9257}}, // Cabo Frio International Airport
    Airport{IataCode{"CFC"}, CountryId{"BR"}, Coordinate{-50.9397, -26.7897}}, // Caçador Airport
    Airport{IataCode{"CFD"}, CountryId{"US"}, Coordinate{-96.3314, 30.7156}}, // Coulter Field
    Airport{IataCode{"CFE"}, CountryId{"FR"}, Coordinate{3.15813, 45.7897}}, // Clermont-Ferrand Auvergne Airport
    Airport{IataCode{"CFF"}, CountryId{"AO"}, Coordinate{17.9897, -8.78361}}, // Cafunfo Airport
    Airport{IataCode{"CFG"}, CountryId{"CU"}, Coordinate{-80.3975, 22.15}}, // Jaime González Airport
    Airport{IataCode{"CFM"}, CountryId{"CA"}, Coordinate{-111.279, 55.6961}}, // Conklin (Leismer) Airport
    Airport{IataCode{"CFN"}, CountryId{"IE"}, Coordinate{-8.34253, 55.0381}}, // Donegal Airport
    Airport{IataCode{"CFO"}, CountryId{"BR"}, Coordinate{-51.5638, -10.635}}, // Confresa Airport
    Airport{IataCode{"CFQ"}, CountryId{"CA"}, Coordinate{-116.498, 49.0367}}, // Creston Aerodrome
    Airport{IataCode{"CFR"}, CountryId{"FR"}, Coordinate{-0.459344, 49.1832}}, // Caen – Carpiquet Airport
    Airport{IataCode{"CFS"}, CountryId{"AU"}, Coordinate{153.116, -30.3231}}, // Coffs Harbour Airport
    Airport{IataCode{"CFT"}, CountryId{"US"}, Coordinate{-109.211, 32.9569}}, // Greenlee County Airport
    Airport{IataCode{"CFU"}, CountryId{"GR"}, Coordinate{19.9146, 39.6072}}, // Corfu International Airport
    Airport{IataCode{"CFV"}, CountryId{"US"}, Coordinate{-95.5719, 37.0942}}, // Coffeyville Municipal Airport
    Airport{IataCode{"CGB"}, CountryId{"BR"}, Coordinate{-56.1203, -15.651}}, // Marechal Rondon International Airport
    Airport{IataCode{"CGC"}, CountryId{"PG"}, Coordinate{148.432, -5.45917}}, // Cape Gloucester Airport
    Airport{IataCode{"CGD"}, CountryId{"CN"}, Coordinate{111.636, 28.9227}}, // Changde Taohuayuan Airport
    Airport{IataCode{"CGE"}, CountryId{"US"}, Coordinate{-76.0358, 38.5428}}, // Cambridge–Dorchester Airport
    Airport{IataCode{"CGF"}, CountryId{"US"}, Coordinate{-81.4864, 41.565}}, // Cuyahoga County Airport
    Airport{IataCode{"CGH"}, CountryId{"BR"}, Coordinate{-46.6598, -23.6253}}, // Congonhas-São Paulo Airport
    Airport{IataCode{"CGI"}, CountryId{"US"}, Coordinate{-89.5648, 37.2269}}, // Cape Girardeau Regional Airport
    Airport{IataCode{"CGJ"}, CountryId{"ZM"}, Coordinate{27.85, -12.5728}}, // Kasompe Airport
    Airport{IataCode{"CGK"}, CountryId{"ID"}, Coordinate{106.654, -6.12736}}, // Soekarno–Hatta International Airport
    Airport{IataCode{"CGM"}, CountryId{"PH"}, Coordinate{124.705, 9.25108}}, // Camiguin Airport
    Airport{IataCode{"CGN"}, CountryId{"DE"}, Coordinate{7.11936, 50.8791}}, // Cologne Bonn Airport
    Airport{IataCode{"CGO"}, CountryId{"CN"}, Coordinate{113.847, 34.5271}}, // Zhengzhou Xinzheng International Airport
    Airport{IataCode{"CGP"}, CountryId{"BD"}, Coordinate{91.819, 22.2498}}, // Shah Amanat International Airport
    Airport{IataCode{"CGQ"}, CountryId{"CN"}, Coordinate{125.201, 43.9057}}, // Changchun Longjia International Airport
    Airport{IataCode{"CGR"}, CountryId{"BR"}, Coordinate{-54.669, -20.4573}}, // Campo Grande International Airport
    Airport{IataCode{"CGS"}, CountryId{"US"}, Coordinate{-76.9223, 38.9806}}, // College Park Airport
    Airport{IataCode{"CGT"}, CountryId{"MR"}, Coordinate{-12.3833, 20.4833}}, // Chinguetti Airport
    Airport{IataCode{"CGY"}, CountryId{"PH"}, Coordinate{124.459, 8.60853}}, // Laguindingan International Airport
    Airport{IataCode{"CGZ"}, CountryId{"US"}, Coordinate{-111.767, 32.955}}, // Casa Grande Municipal Airport
    Airport{IataCode{"CHA"}, CountryId{"US"}, Coordinate{-85.2068, 35.0329}}, // Chattanooga Metropolitan Airport
    Airport{IataCode{"CHB"}, CountryId{"PK"}, Coordinate{74.085, 35.4269}}, // Chilas Airport
    Airport{IataCode{"CHC"}, CountryId{"NZ"}, Coordinate{172.543, -43.489}}, // Christchurch International Airport
    Airport{IataCode{"CHF"}, CountryId{"KR"}, Coordinate{128.696, 35.1411}}, // Jinhae Airport
    Airport{IataCode{"CHG"}, CountryId{"CN"}, Coordinate{120.436, 41.5445}}, // Chaoyang Airport
    Airport{IataCode{"CHH"}, CountryId{"PE"}, Coordinate{-77.8561, -6.20194}}, // Chachapoyas Airport
    Airport{IataCode{"CHJ"}, CountryId{"ZW"}, Coordinate{32.6283, -20.2067}}, // Chipinge Airport
    Airport{IataCode{"CHK"}, CountryId{"US"}, Coordinate{-97.9678, 35.0972}}, // Chickasaw Municipal Airport
    Airport{IataCode{"CHL"}, CountryId{"US"}, Coordinate{-114.218, 44.5236}}, // Challis Airport
    Airport{IataCode{"CHM"}, CountryId{"PE"}, Coordinate{-78.5239, -9.14972}}, // Tnte. FAP Jaime Montreuil Morales Airport
    Airport{IataCode{"CHN"}, CountryId{"KR"}, Coordinate{127.119, 35.8783}}, // Jeonju Airport
    Airport{IataCode{"CHO"}, CountryId{"US"}, Coordinate{-78.4494, 38.1395}}, // Charlottesville Albemarle Airport
    Airport{IataCode{"CHP"}, CountryId{"US"}, Coordinate{-144.611, 65.4856}}, // Circle Hot Springs Airport
    Airport{IataCode{"CHQ"}, CountryId{"GR"}, Coordinate{24.1402, 35.5398}}, // Chania International Airport
    Airport{IataCode{"CHR"}, CountryId{"FR"}, Coordinate{1.72, 46.8599}}, // Châteauroux-Centre "Marcel Dassault" Airport
    Airport{IataCode{"CHS"}, CountryId{"US"}, Coordinate{-80.0369, 32.8844}}, // Charleston International Airport
    Airport{IataCode{"CHT"}, CountryId{"NZ"}, Coordinate{-176.474, -43.8161}}, // Chatham Islands / Tuuta Airport
    Airport{IataCode{"CHU"}, CountryId{"US"}, Coordinate{-159.216, 61.5792}}, // Chuathbaluk Airport
    Airport{IataCode{"CHV"}, CountryId{"PT"}, Coordinate{-7.46315, 41.7223}}, // Chaves Airport
    Airport{IataCode{"CHX"}, CountryId{"PA"}, Coordinate{-82.5174, 9.45647}}, // Changuinola "Capitán Manuel Niño" International Airport
    Airport{IataCode{"CHY"}, CountryId{"SB"}, Coordinate{156.396, -6.71194}}, // Choiseul Bay Airport
    Airport{IataCode{"CHZ"}, CountryId{"US"}, Coordinate{-121.876, 42.5831}}, // Chiloquin State Airport
    Airport{IataCode{"CIA"}, CountryId{"IT"}, Coordinate{12.5907, 41.7987}}, // Ciampino–G.B. Pastine International Airport
    Airport{IataCode{"CIC"}, CountryId{"US"}, Coordinate{-121.855, 39.799}}, // Chico Municipal Airport
    Airport{IataCode{"CID"}, CountryId{"US"}, Coordinate{-91.7004, 41.8886}}, // The Eastern Iowa Airport
    Airport{IataCode{"CIF"}, CountryId{"CN"}, Coordinate{118.908, 42.235}}, // Chifeng Yulong Airport
    Airport{IataCode{"CIG"}, CountryId{"US"}, Coordinate{-107.522, 40.4953}}, // Craig–Moffat Airport
    Airport{IataCode{"CIH"}, CountryId{"CN"}, Coordinate{113.126, 36.2475}}, // Changzhi Wangcun Airport
    Airport{IataCode{"CII"}, CountryId{"TR"}, Coordinate{27.8885, 37.815}}, // Aydın Airport
    Airport{IataCode{"CIJ"}, CountryId{"BO"}, Coordinate{-68.7803, -11.041}}, // Captain Aníbal Arab Airport
    Airport{IataCode{"CIK"}, CountryId{"US"}, Coordinate{-143.74, 66.645}}, // Chalkyitsik Airport
    Airport{IataCode{"CIL"}, CountryId{"US"}, Coordinate{-163.703, 64.8978}}, // Council Airport
    Airport{IataCode{"CIM"}, CountryId{"CO"}, Coordinate{-73.9706, 6.36667}}, // Cimitarra Airport
    Airport{IataCode{"CIN"}, CountryId{"US"}, Coordinate{-94.7889, 42.0461}}, // Arthur N. Neu Airport
    Airport{IataCode{"CIO"}, CountryId{"PY"}, Coordinate{-57.4272, -23.4417}}, // Concepcion
    Airport{IataCode{"CIP"}, CountryId{"ZM"}, Coordinate{32.5869, -13.5569}}, // Chipata Airport
    Airport{IataCode{"CIQ"}, CountryId{"GT"}, Coordinate{-89.5208, 14.8311}}, // Chiquimula Airport
    Airport{IataCode{"CIR"}, CountryId{"US"}, Coordinate{-89.2194, 37.0639}}, // Cairo Airport
    Airport{IataCode{"CIS"}, CountryId{"KI"}, Coordinate{-171.705, -2.76917}}, // Canton Island Airport
    Airport{IataCode{"CIT"}, CountryId{"KZ"}, Coordinate{69.4932, 42.3662}}, // Shymkent International Airport
    Airport{IataCode{"CIU"}, CountryId{"US"}, Coordinate{-84.4744, 46.2578}}, // Chippewa County International Airport
    Airport{IataCode{"CIW"}, CountryId{"VC"}, Coordinate{-61.3452, 12.699}}, // Canouan Airport
    Airport{IataCode{"CIX"}, CountryId{"PE"}, Coordinate{-79.8292, -6.7773}}, // Cap. FAP José A. Quiñones Gonzáles International Airport
    Airport{IataCode{"CIY"}, CountryId{"IT"}, Coordinate{14.6071, 36.9983}}, // Comiso Airport
    Airport{IataCode{"CIZ"}, CountryId{"BR"}, Coordinate{-63.1311, -4.13389}}, // Coari Airport
    Airport{IataCode{"CJA"}, CountryId{"PE"}, Coordinate{-78.4892, -7.13917}}, // Mayor General FAP Armando Revoredo Iglesias Airport
    Airport{IataCode{"CJB"}, CountryId{"IN"}, Coordinate{77.0391, 11.0305}}, // Coimbatore Airport
    Airport{IataCode{"CJC"}, CountryId{"CL"}, Coordinate{-68.9036, -22.4897}}, // El Loa Airport
    Airport{IataCode{"CJF"}, CountryId{"AU"}, Coordinate{118.802, -22.9667}}, // Coondewanna Airport
    Airport{IataCode{"CJH"}, CountryId{"CA"}, Coordinate{-124.142, 51.6261}}, // Chilko Lake (Tsylos Park Lodge) Aerodrome
    Airport{IataCode{"CJJ"}, CountryId{"KR"}, Coordinate{127.496, 36.7219}}, // Cheongju International Airport
    Airport{IataCode{"CJL"}, CountryId{"PK"}, Coordinate{71.7986, 35.8815}}, // Chitral Airport
    Airport{IataCode{"CJM"}, CountryId{"TH"}, Coordinate{99.3592, 10.7142}}, // Chumphon Airport
    Airport{IataCode{"CJN"}, CountryId{"ID"}, Coordinate{108.49, -7.72039}}, // Nusawiru Airport
    Airport{IataCode{"CJS"}, CountryId{"MX"}, Coordinate{-106.435, 31.6368}}, // Abraham González Airport
    Airport{IataCode{"CJT"}, CountryId{"MX"}, Coordinate{-92.0483, 16.175}}, // Comitán Airport
    Airport{IataCode{"CJU"}, CountryId{"KR"}, Coordinate{126.493, 33.5063}}, // Jeju International Airport
    Airport{IataCode{"CKB"}, CountryId{"US"}, Coordinate{-80.2311, 39.2967}}, // North Central West Virginia Airport
    Airport{IataCode{"CKC"}, CountryId{"UA"}, Coordinate{32.0124, 49.4025}}, // Cherkasy International Airport
    Airport{IataCode{"CKD"}, CountryId{"US"}, Coordinate{-158.135, 61.8678}}, // Crooked Creek Airport
    Airport{IataCode{"CKE"}, CountryId{"US"}, Coordinate{-122.901, 38.9906}}, // Lampson Field
    Airport{IataCode{"CKG"}, CountryId{"CN"}, Coordinate{106.642, 29.7192}}, // Chongqing Jiangbei International Airport
    Airport{IataCode{"CKH"}, CountryId{"RU"}, Coordinate{147.901, 70.623}}, // Chokurdakh Airport
    Airport{IataCode{"CKI"}, CountryId{"AU"}, Coordinate{132.483, -11.165}}, // Croker Island Airport
    Airport{IataCode{"CKK"}, CountryId{"US"}, Coordinate{-91.5628, 36.265}}, // Sharp County Regional Airport
    Airport{IataCode{"CKM"}, CountryId{"US"}, Coordinate{-90.5122, 34.2997}}, // Fletcher Field Airport
    Airport{IataCode{"CKN"}, CountryId{"US"}, Coordinate{-96.6217, 47.8408}}, // Crookston Municipal Airport
    Airport{IataCode{"CKO"}, CountryId{"BR"}, Coordinate{-50.6028, -23.1528}}, // Cornélio Procópio Airport
    Airport{IataCode{"CKS"}, CountryId{"BR"}, Coordinate{-50.0011, -6.11449}}, // Carajás Airport
    Airport{IataCode{"CKT"}, CountryId{"IR"}, Coordinate{61.07, 36.4881}}, // Sarakhs Airport
    Airport{IataCode{"CKU"}, CountryId{"US"}, Coordinate{-145.727, 60.4889}}, // Cordova Municipal Airport
    Airport{IataCode{"CKV"}, CountryId{"US"}, Coordinate{-87.4191, 36.6218}}, // Clarksville-Montgomery County Regional Airport
    Airport{IataCode{"CKW"}, CountryId{"AU"}, Coordinate{119.652, -22.3556}}, // Graeme Rowley Aerodrome
    Airport{IataCode{"CKX"}, CountryId{"US"}, Coordinate{-141.952, 64.0714}}, // Chicken Airport
    Airport{IataCode{"CKY"}, CountryId{"GN"}, Coordinate{-13.6198, 9.57518}}, // Conakry International Airport
    Airport{IataCode{"CLA"}, CountryId{"BD"}, Coordinate{91.1899, 23.4368}}, // Comilla Airport
    Airport{IataCode{"CLD"}, CountryId{"US"}, Coordinate{-117.278, 33.1263}}, // McClellan–Palomar Airport
    Airport{IataCode{"CLE"}, CountryId{"US"}, Coordinate{-81.8382, 41.4111}}, // Cleveland Hopkins International Airport
    Airport{IataCode{"CLG"}, CountryId{"US"}, Coordinate{-120.294, 36.1631}}, // New Coalinga Municipal Airport
    Airport{IataCode{"CLH"}, CountryId{"AU"}, Coordinate{149.61, -31.7733}}, // Coolah Airport
    Airport{IataCode{"CLI"}, CountryId{"US"}, Coordinate{-88.7308, 44.6133}}, // Clintonville Municipal Airport
    Airport{IataCode{"CLJ"}, CountryId{"RO"}, Coordinate{23.6885, 46.7825}}, // Cluj International Airport
    Airport{IataCode{"CLK"}, CountryId{"US"}, Coordinate{-98.9328, 35.5383}}, // Clinton Regional Airport
    Airport{IataCode{"CLL"}, CountryId{"US"}, Coordinate{-96.3627, 30.5918}}, // Easterwood Airport
    Airport{IataCode{"CLM"}, CountryId{"US"}, Coordinate{-123.5, 48.1203}}, // William R. Fairchild International Airport
    Airport{IataCode{"CLO"}, CountryId{"CO"}, Coordinate{-76.3874, 3.53829}}, // Alfonso Bonilla Aragón International Airport
    Airport{IataCode{"CLP"}, CountryId{"US"}, Coordinate{-158.529, 58.8336}}, // Clarks Point Airport
    Airport{IataCode{"CLQ"}, CountryId{"MX"}, Coordinate{-103.577, 19.2805}}, // Lic. Miguel de la Madrid Airport
    Airport{IataCode{"CLR"}, CountryId{"US"}, Coordinate{-115.521, 33.1314}}, // Cliff Hatfield Memorial Airport
    Airport{IataCode{"CLS"}, CountryId{"US"}, Coordinate{-122.986, 46.4062}}, // Chehalis–Centralia Airport
    Airport{IataCode{"CLU"}, CountryId{"US"}, Coordinate{-85.8965, 39.2555}}, // Columbus Municipal Airport
    Airport{IataCode{"CLV"}, CountryId{"BR"}, Coordinate{-48.61, -17.7247}}, // Caldas Novas Airport
    Airport{IataCode{"CLW"}, CountryId{"US"}, Coordinate{-82.7586, 27.9767}}, // Clearwater Air Park
    Airport{IataCode{"CLX"}, CountryId{"AR"}, Coordinate{-57.7348, -25.3048}}, // Clorinda Airport
    Airport{IataCode{"CLY"}, CountryId{"FR"}, Coordinate{8.79014, 42.5253}}, // Calvi – Sainte-Catherine Airport
    Airport{IataCode{"CLZ"}, CountryId{"VE"}, Coordinate{-67.4142, 8.9276}}, // Calabozo Airport
    Airport{IataCode{"CMA"}, CountryId{"AU"}, Coordinate{145.622, -28.03}}, // Cunnamulla Airport
    Airport{IataCode{"CMB"}, CountryId{"LK"}, Coordinate{79.886, 7.17507}}, // Bandaranaike International Airport
    Airport{IataCode{"CMD"}, CountryId{"AU"}, Coordinate{148.034, -34.6317}}, // Cootamundra Airport
    Airport{IataCode{"CME"}, CountryId{"MX"}, Coordinate{-91.8014, 18.6496}}, // Ciudad del Carmen International Airport
    Airport{IataCode{"CMF"}, CountryId{"FR"}, Coordinate{5.88404, 45.6379}}, // Chambéry Airport
    Airport{IataCode{"CMG"}, CountryId{"BR"}, Coordinate{-57.6636, -19.0141}}, // Corumbá International Airport
    Airport{IataCode{"CMH"}, CountryId{"US"}, Coordinate{-82.8838, 39.998}}, // John Glenn Columbus International Airport
    Airport{IataCode{"CMI"}, CountryId{"US"}, Coordinate{-88.264, 40.0364}}, // University of Illinois Willard Airport
    Airport{IataCode{"CMJ"}, CountryId{"TW"}, Coordinate{119.418, 23.2117}}, // Qimei Airport
    Airport{IataCode{"CMK"}, CountryId{"MW"}, Coordinate{35.1325, -14.3069}}, // Club Makokola Airport
    Airport{IataCode{"CML"}, CountryId{"AU"}, Coordinate{138.125, -19.9117}}, // Camooweal Airport
    Airport{IataCode{"CMM"}, CountryId{"GT"}, Coordinate{-90.0528, 17.45}}, // Carmelita Airport
    Airport{IataCode{"CMN"}, CountryId{"MA"}, Coordinate{-7.58071, 33.3713}}, // Mohammed V International Airport
    Airport{IataCode{"CMO"}, CountryId{"SO"}, Coordinate{48.5256, 5.35}}, // Obbia Airport
    Airport{IataCode{"CMP"}, CountryId{"BR"}, Coordinate{-50.3279, -9.32206}}, // Santana do Araguaia Airport
    Airport{IataCode{"CMQ"}, CountryId{"AU"}, Coordinate{147.62, -22.7733}}, // Clermont Airport
    Airport{IataCode{"CMR"}, CountryId{"FR"}, Coordinate{7.36238, 48.1094}}, // Colmar Airport
    Airport{IataCode{"CMS"}, CountryId{"SO"}, Coordinate{50.2056, 10.3}}, // Scusciuban Airport
    Airport{IataCode{"CMU"}, CountryId{"PG"}, Coordinate{144.97, -6.02417}}, // Chimbu Airport
    Airport{IataCode{"CMV"}, CountryId{"NZ"}, Coordinate{175.509, -36.7917}}, // Coromandel Aerodrome
    Airport{IataCode{"CMW"}, CountryId{"CU"}, Coordinate{-77.8447, 21.4259}}, // Ignacio Agramonte International Airport
    Airport{IataCode{"CMX"}, CountryId{"US"}, Coordinate{-88.494, 47.1687}}, // Houghton County Memorial Airport
    Airport{IataCode{"CMY"}, CountryId{"US"}, Coordinate{-90.7378, 43.9583}}, // Sparta/Fort McCoy Airport
    Airport{IataCode{"CNA"}, CountryId{"MX"}, Coordinate{-110.267, 31}}, // Cananea Airport
    Airport{IataCode{"CNB"}, CountryId{"AU"}, Coordinate{148.375, -30.9833}}, // Coonamble Airport
    Airport{IataCode{"CNC"}, CountryId{"AU"}, Coordinate{143.067, -10.05}}, // Coconut Island Airport
    Airport{IataCode{"CND"}, CountryId{"RO"}, Coordinate{28.4819, 44.3495}}, // Mihail Kogălniceanu International Airport
    Airport{IataCode{"CNF"}, CountryId{"BR"}, Coordinate{-43.966, -19.6299}}, // Tancredo Neves International Airport
    Airport{IataCode{"CNH"}, CountryId{"US"}, Coordinate{-72.3686, 43.3706}}, // Claremont Municipal Airport
    Airport{IataCode{"CNI"}, CountryId{"CN"}, Coordinate{122.667, 39.2664}}, // Changhai Airport
    Airport{IataCode{"CNJ"}, CountryId{"AU"}, Coordinate{140.504, -20.6686}}, // Cloncurry Airport
    Airport{IataCode{"CNK"}, CountryId{"US"}, Coordinate{-97.6522, 39.5492}}, // Blosser Municipal Airport
    Airport{IataCode{"CNL"}, CountryId{"DK"}, Coordinate{10.2228, 57.5046}}, // Sindal Airport
    Airport{IataCode{"CNM"}, CountryId{"US"}, Coordinate{-104.253, 32.3456}}, // Cavern City Air Terminal
    Airport{IataCode{"CNN"}, CountryId{"IN"}, Coordinate{75.5486, 11.914}}, // Kannur International Airport
    Airport{IataCode{"CNO"}, CountryId{"US"}, Coordinate{-117.637, 33.9747}}, // Chino Airport
    Airport{IataCode{"CNP"}, CountryId{"GL"}, Coordinate{-22.6465, 70.7427}}, // Nerlerit Inaat Airport
    Airport{IataCode{"CNQ"}, CountryId{"AR"}, Coordinate{-58.7619, -27.4456}}, // Doctor Fernando Piragine Niveyro International Airport
    Airport{IataCode{"CNR"}, CountryId{"CL"}, Coordinate{-70.6074, -26.3344}}, // Chanaral Airport
    Airport{IataCode{"CNS"}, CountryId{"AU"}, Coordinate{145.755, -16.875}}, // Cairns Airport
    Airport{IataCode{"CNT"}, CountryId{"AR"}, Coordinate{-61.2103, -27.2167}}, // Charata Airport
    Airport{IataCode{"CNU"}, CountryId{"US"}, Coordinate{-95.485, 37.6689}}, // Chanute Martin Johnson Airport
    Airport{IataCode{"CNW"}, CountryId{"US"}, Coordinate{-97.0742, 31.6378}}, // TSTC Waco Airport
    Airport{IataCode{"CNX"}, CountryId{"TH"}, Coordinate{98.9681, 18.769}}, // Chiang Mai International Airport
    Airport{IataCode{"CNY"}, CountryId{"US"}, Coordinate{-109.755, 38.755}}, // Canyonlands Field
    Airport{IataCode{"COA"}, CountryId{"US"}, Coordinate{-120.414, 38.0306}}, // Columbia Airport
    Airport{IataCode{"COC"}, CountryId{"AR"}, Coordinate{-57.9967, -31.2969}}, // Comodoro Pierrestegui Airport
    Airport{IataCode{"COD"}, CountryId{"US"}, Coordinate{-109.023, 44.5173}}, // Yellowstone Regional Airport
    Airport{IataCode{"COE"}, CountryId{"US"}, Coordinate{-116.819, 47.7744}}, // Coeur d'Alene Airport
    Airport{IataCode{"COG"}, CountryId{"CO"}, Coordinate{-76.6833, 5.07119}}, // Mandinga Airport
    Airport{IataCode{"COH"}, CountryId{"IN"}, Coordinate{89.4698, 26.3297}}, // Cooch Behar Airport
    Airport{IataCode{"COI"}, CountryId{"US"}, Coordinate{-80.6856, 28.3417}}, // Merritt Island Airport
    Airport{IataCode{"COJ"}, CountryId{"AU"}, Coordinate{149.268, -31.3317}}, // Coonabarabran Airport
    Airport{IataCode{"COK"}, CountryId{"IN"}, Coordinate{76.3924, 10.1565}}, // Cochin International Airport
    Airport{IataCode{"COM"}, CountryId{"US"}, Coordinate{-99.4033, 31.8411}}, // Coleman Municipal Airport
    Airport{IataCode{"CON"}, CountryId{"US"}, Coordinate{-71.5022, 43.2028}}, // Concord Municipal Airport
    Airport{IataCode{"COO"}, CountryId{"BJ"}, Coordinate{2.38482, 6.35306}}, // Cadjehoun Airport
    Airport{IataCode{"COP"}, CountryId{"US"}, Coordinate{-74.8911, 42.6292}}, // Cooperstown-Westville Airport
    Airport{IataCode{"COQ"}, CountryId{"MN"}, Coordinate{114.632, 48.1355}}, // Choibalsan Airport
    Airport{IataCode{"COR"}, CountryId{"AR"}, Coordinate{-64.213, -31.3158}}, // Ingeniero Aeronáutico Ambrosio L.V. Taravella International Airport
    Airport{IataCode{"COS"}, CountryId{"US"}, Coordinate{-104.7, 38.7984}}, // Colorado Springs Airport
    Airport{IataCode{"COT"}, CountryId{"US"}, Coordinate{-99.2183, 28.4567}}, // Cotulla–La Salle County Airport
    Airport{IataCode{"COU"}, CountryId{"US"}, Coordinate{-92.2197, 38.8181}}, // Columbia Regional Airport
    Airport{IataCode{"COY"}, CountryId{"AU"}, Coordinate{117.759, -21.7942}}, // Coolawanyah Station Airport
    Airport{IataCode{"COZ"}, CountryId{"DO"}, Coordinate{-70.7197, 18.9075}}, // Constanza Airport
    Airport{IataCode{"CPA"}, CountryId{"LR"}, Coordinate{-7.70012, 4.36764}}, // Cape Palmas Airport
    Airport{IataCode{"CPB"}, CountryId{"CO"}, Coordinate{-77.3495, 8.63414}}, // Capurganá Airport
    Airport{IataCode{"CPC"}, CountryId{"AR"}, Coordinate{-71.1431, -40.081}}, // Aviador Carlos Campos Airport
    Airport{IataCode{"CPD"}, CountryId{"AU"}, Coordinate{134.723, -29.0354}}, // Coober Pedy Airport
    Airport{IataCode{"CPE"}, CountryId{"MX"}, Coordinate{-90.5037, 19.814}}, // Ing. Alberto Acuña Ongay International Airport
    Airport{IataCode{"CPF"}, CountryId{"ID"}, Coordinate{111.548, -7.19472}}, // Ngloram Airport
    Airport{IataCode{"CPG"}, CountryId{"AR"}, Coordinate{-62.9848, -40.785}}, // Carmen de Patagones
    Airport{IataCode{"CPH"}, CountryId{"DK"}, Coordinate{12.6494, 55.6296}}, // Copenhagen Airport
    Airport{IataCode{"CPI"}, CountryId{"PG"}, Coordinate{152.083, -5.43333}}, // Cape Orford
    Airport{IataCode{"CPM"}, CountryId{"US"}, Coordinate{-118.239, 33.8888}}, // Compton/Woodley Airport
    Airport{IataCode{"CPN"}, CountryId{"PG"}, Coordinate{148.4, -10.18}}, // Cape Rodney
    Airport{IataCode{"CPO"}, CountryId{"CL"}, Coordinate{-70.7741, -27.2644}}, // Desierto de Atacama Airport
    Airport{IataCode{"CPQ"}, CountryId{"BR"}, Coordinate{-47.1081, -22.8592}}, // Campo dos Amarais Airport
    Airport{IataCode{"CPR"}, CountryId{"US"}, Coordinate{-106.465, 42.8972}}, // Casper–Natrona County International Airport
    Airport{IataCode{"CPS"}, CountryId{"US"}, Coordinate{-90.1561, 38.5708}}, // St. Louis Downtown Airport
    Airport{IataCode{"CPT"}, CountryId{"ZA"}, Coordinate{18.5972, -33.9694}}, // Cape Town International Airport
    Airport{IataCode{"CPV"}, CountryId{"BR"}, Coordinate{-35.894, -7.26878}}, // Campina Grande Airport
    Airport{IataCode{"CPX"}, CountryId{"US"}, Coordinate{-65.3035, 18.3116}}, // Benjamín Rivera Noriega Airport
    Airport{IataCode{"CQA"}, CountryId{"BR"}, Coordinate{-52.2706, -13.5744}}, // Canarana Airport
    Airport{IataCode{"CQD"}, CountryId{"IR"}, Coordinate{50.8377, 32.2945}}, // Shahrekord Airport
    Airport{IataCode{"CQF"}, CountryId{"FR"}, Coordinate{1.95526, 50.9581}}, // Calais–Dunkerque Airport
    Airport{IataCode{"CRA"}, CountryId{"RO"}, Coordinate{23.8786, 44.3127}}, // Craiova Airport
    Airport{IataCode{"CRB"}, CountryId{"AU"}, Coordinate{148.568, -29.515}}, // Collarenebri Airport
    Airport{IataCode{"CRC"}, CountryId{"CO"}, Coordinate{-75.953, 4.76028}}, // Santa Ana Airport
    Airport{IataCode{"CRD"}, CountryId{"AR"}, Coordinate{-67.4687, -45.79}}, // General Enrique Mosconi International Airport
    Airport{IataCode{"CRE"}, CountryId{"US"}, Coordinate{-78.7239, 33.8117}}, // Grand Strand Airport
    Airport{IataCode{"CRF"}, CountryId{"CF"}, Coordinate{15.9, 4.93333}}, // Carnot Airport
    Airport{IataCode{"CRG"}, CountryId{"US"}, Coordinate{-81.5144, 30.3364}}, // Jacksonville Executive at Craig Airport
    Airport{IataCode{"CRI"}, CountryId{"BS"}, Coordinate{-74.1822, 22.7456}}, // Colonel Hill Airport
    Airport{IataCode{"CRK"}, CountryId{"PH"}, Coordinate{120.549, 15.1875}}, // Clark International Airport
    Airport{IataCode{"CRL"}, CountryId{"BE"}, Coordinate{4.47185, 50.4695}}, // Brussels South Charleroi Airport
    Airport{IataCode{"CRM"}, CountryId{"PH"}, Coordinate{124.636, 12.5052}}, // Catarman National Airport
    Airport{IataCode{"CRP"}, CountryId{"US"}, Coordinate{-97.5026, 27.7742}}, // Corpus Christi International Airport
    Airport{IataCode{"CRR"}, CountryId{"AR"}, Coordinate{-61.927, -29.8716}}, // Ceres Airport
    Airport{IataCode{"CRS"}, CountryId{"US"}, Coordinate{-96.4006, 32.0281}}, // C. David Campbell Field
    Airport{IataCode{"CRT"}, CountryId{"US"}, Coordinate{-91.8803, 33.1783}}, // Z. M. Jack Stell Field
    Airport{IataCode{"CRU"}, CountryId{"GD"}, Coordinate{-61.4717, 12.4773}}, // Lauriston Airport
    Airport{IataCode{"CRV"}, CountryId{"IT"}, Coordinate{17.0773, 38.9943}}, // Crotone Airport
    Airport{IataCode{"CRW"}, CountryId{"US"}, Coordinate{-81.5939, 38.3679}}, // Yeager Airport
    Airport{IataCode{"CRX"}, CountryId{"US"}, Coordinate{-88.6036, 34.915}}, // Roscoe Turner Airport
    Airport{IataCode{"CRZ"}, CountryId{"TM"}, Coordinate{63.6133, 39.0833}}, // Turkmenabat Airport
    Airport{IataCode{"CSB"}, CountryId{"RO"}, Coordinate{22.2522, 45.4202}}, // Caransebeș Airport
    Airport{IataCode{"CSC"}, CountryId{"CR"}, Coordinate{-83.5931, 10.1606}}, // Codela Airport
    Airport{IataCode{"CSG"}, CountryId{"US"}, Coordinate{-84.9399, 32.5182}}, // Columbus Airport
    Airport{IataCode{"CSH"}, CountryId{"RU"}, Coordinate{35.7232, 65.0299}}, // Solovki Airport
    Airport{IataCode{"CSI"}, CountryId{"AU"}, Coordinate{153.051, -28.8817}}, // Casino Airport
    Airport{IataCode{"CSK"}, CountryId{"SN"}, Coordinate{-16.7432, 12.3878}}, // Cap Skirring Airport
    Airport{IataCode{"CSM"}, CountryId{"US"}, Coordinate{-99.2006, 35.3397}}, // Clinton-Sherman Industrial Airpark
    Airport{IataCode{"CSN"}, CountryId{"US"}, Coordinate{-119.738, 39.1912}}, // Carson Airport
    Airport{IataCode{"CSO"}, CountryId{"DE"}, Coordinate{11.4238, 51.8599}}, // Magdeburg-Cochstedt Airport
    Airport{IataCode{"CSQ"}, CountryId{"US"}, Coordinate{-94.3633, 41.0214}}, // Creston Municipal Airport
    Airport{IataCode{"CSU"}, CountryId{"BR"}, Coordinate{-52.4122, -29.6836}}, // Santa Cruz do Sul Airport
    Airport{IataCode{"CSX"}, CountryId{"CN"}, Coordinate{113.215, 28.1926}}, // Changsha Huanghua International Airport
    Airport{IataCode{"CSY"}, CountryId{"RU"}, Coordinate{47.3202, 56.0826}}, // Cheboksary Airport
    Airport{IataCode{"CSZ"}, CountryId{"AR"}, Coordinate{-61.8893, -37.4461}}, // Brigadier Hector Eduardo Ruiz Airport
    Airport{IataCode{"CTA"}, CountryId{"IT"}, Coordinate{15.0666, 37.4702}}, // Catania-Fontanarossa Airport
    Airport{IataCode{"CTB"}, CountryId{"US"}, Coordinate{-112.376, 48.6083}}, // Cut Bank Municipal Airport
    Airport{IataCode{"CTC"}, CountryId{"AR"}, Coordinate{-65.7549, -28.5926}}, // Coronel Felipe Varela International Airport
    Airport{IataCode{"CTD"}, CountryId{"PA"}, Coordinate{-80.4097, 7.98778}}, // Chitré Alonso Valderrama Airport
    Airport{IataCode{"CTE"}, CountryId{"PA"}, Coordinate{-78.9782, 9.4541}}, // San Blas Airport
    Airport{IataCode{"CTF"}, CountryId{"GT"}, Coordinate{-91.8794, 14.6946}}, // Coatepeque Airport
    Airport{IataCode{"CTG"}, CountryId{"CO"}, Coordinate{-75.5161, 10.4459}}, // Rafael Núñez International Airport
    Airport{IataCode{"CTH"}, CountryId{"US"}, Coordinate{-75.8656, 39.9789}}, // Chester County G. O. Carlson Airport
    Airport{IataCode{"CTI"}, CountryId{"AO"}, Coordinate{19.1662, -15.162}}, // Cuito Cuanavale Airport
    Airport{IataCode{"CTK"}, CountryId{"US"}, Coordinate{-96.5712, 43.309}}, // Canton Municipal Airport
    Airport{IataCode{"CTL"}, CountryId{"AU"}, Coordinate{146.262, -26.4133}}, // Charleville Airport
    Airport{IataCode{"CTM"}, CountryId{"MX"}, Coordinate{-88.3269, 18.5047}}, // Chetumal International Airport
    Airport{IataCode{"CTN"}, CountryId{"AU"}, Coordinate{145.184, -15.4447}}, // Cooktown Airport
    Airport{IataCode{"CTO"}, CountryId{"US"}, Coordinate{-72.7932, 40.9134}}, // Calverton Executive Airpark
    Airport{IataCode{"CTQ"}, CountryId{"BR"}, Coordinate{-53.3442, -33.5022}}, // Santa Vitória do Palmar Airport
    Airport{IataCode{"CTS"}, CountryId{"JP"}, Coordinate{141.681, 42.7878}}, // New Chitose Airport
    Airport{IataCode{"CTT"}, CountryId{"FR"}, Coordinate{5.78447, 43.2511}}, // Le Castellet airport
    Airport{IataCode{"CTU"}, CountryId{"CN"}, Coordinate{103.954, 30.5768}}, // Chengdu Shuangliu International Airport
    Airport{IataCode{"CTX"}, CountryId{"US"}, Coordinate{-76.2147, 42.5925}}, // Cortland County Airport
    Airport{IataCode{"CTY"}, CountryId{"US"}, Coordinate{-83.1047, 29.6356}}, // Cross City Airport
    Airport{IataCode{"CTZ"}, CountryId{"US"}, Coordinate{-78.3656, 34.975}}, // Clinton-Sampson County Airport
    Airport{IataCode{"CUA"}, CountryId{"MX"}, Coordinate{-111.615, 25.0539}}, // Ciudad Constitución Airport
    Airport{IataCode{"CUB"}, CountryId{"US"}, Coordinate{-80.9953, 33.9706}}, // Jim Hamilton – L.B. Owens Airport
    Airport{IataCode{"CUC"}, CountryId{"CO"}, Coordinate{-72.5083, 7.92684}}, // Camilo Daza International Airport
    Airport{IataCode{"CUD"}, CountryId{"AU"}, Coordinate{153.105, -26.8017}}, // Caloundra Airport
    Airport{IataCode{"CUE"}, CountryId{"EC"}, Coordinate{-78.9874, -2.8899}}, // Mariscal Lamar International Airport
    Airport{IataCode{"CUF"}, CountryId{"IT"}, Coordinate{7.61854, 44.5475}}, // Cuneo International Airport
    Airport{IataCode{"CUH"}, CountryId{"US"}, Coordinate{-96.7733, 35.95}}, // Cushing Municipal Airport
    Airport{IataCode{"CUK"}, CountryId{"BZ"}, Coordinate{-88.0283, 17.7355}}, // Caye Caulker Airport
    Airport{IataCode{"CUL"}, CountryId{"MX"}, Coordinate{-107.474, 24.7644}}, // Federal de Bachigualato International Airport
    Airport{IataCode{"CUM"}, CountryId{"VE"}, Coordinate{-64.1334, 10.4526}}, // Antonio José de Sucre Airport
    Airport{IataCode{"CUN"}, CountryId{"MX"}, Coordinate{-86.8793, 21.0429}}, // Cancún International Airport
    Airport{IataCode{"CUO"}, CountryId{"CO"}, Coordinate{-71.2972, 0.925}}, // Caruru Airport
    Airport{IataCode{"CUP"}, CountryId{"VE"}, Coordinate{-63.2592, 10.6565}}, // General José Francisco Bermúdez Airport
    Airport{IataCode{"CUQ"}, CountryId{"AU"}, Coordinate{143.114, -13.7619}}, // Coen Airport
    Airport{IataCode{"CUR"}, CountryId{"NL"}, Coordinate{-68.9569, 12.1846}}, // Hato International Airport
    Airport{IataCode{"CUS"}, CountryId{"US"}, Coordinate{-107.662, 31.8081}}, // Columbus Municipal Airport
    Airport{IataCode{"CUT"}, CountryId{"AR"}, Coordinate{-69.265, -38.9397}}, // Cutral Có Airport
    Airport{IataCode{"CUU"}, CountryId{"MX"}, Coordinate{-105.969, 28.7039}}, // General Roberto Fierro Villalobos International Airport
    Airport{IataCode{"CUV"}, CountryId{"VE"}, Coordinate{-72.5366, 8.75639}}, // El Cubo Airport
    Airport{IataCode{"CUY"}, CountryId{"AU"}, Coordinate{117.918, -27.4467}}, // Cue Airport
    Airport{IataCode{"CUZ"}, CountryId{"PE"}, Coordinate{-71.9436, -13.5384}}, // Alejandro Velasco Astete International Airport
    Airport{IataCode{"CVB"}, CountryId{"PG"}, Coordinate{144.715, -4.80662}}, // Chungribu Airport
    Airport{IataCode{"CVC"}, CountryId{"AU"}, Coordinate{136.501, -33.7085}}, // Cleve Airport
    Airport{IataCode{"CVE"}, CountryId{"CO"}, Coordinate{-75.7, 9.4}}, // Coveñas Airport
    Airport{IataCode{"CVF"}, CountryId{"FR"}, Coordinate{6.62717, 45.3974}}, // Courchevel Airport
    Airport{IataCode{"CVG"}, CountryId{"US"}, Coordinate{-84.6562, 39.0557}}, // Cincinnati/Northern Kentucky International Airport
    Airport{IataCode{"CVJ"}, CountryId{"MX"}, Coordinate{-99.2613, 18.8316}}, // General Mariano Matamoros Airport
    Airport{IataCode{"CVL"}, CountryId{"PG"}, Coordinate{150.02, -9.67}}, // Cape Vogel Airport
    Airport{IataCode{"CVM"}, CountryId{"MX"}, Coordinate{-98.9556, 23.7116}}, // General Pedro J. Méndez International Airport
    Airport{IataCode{"CVN"}, CountryId{"US"}, Coordinate{-103.083, 34.4268}}, // Clovis Municipal Airport
    Airport{IataCode{"CVO"}, CountryId{"US"}, Coordinate{-123.285, 44.5033}}, // Corvallis Municipal Airport
    Airport{IataCode{"CVQ"}, CountryId{"AU"}, Coordinate{113.672, -24.8806}}, // Carnarvon Airport
    Airport{IataCode{"CVT"}, CountryId{"GB"}, Coordinate{-1.47408, 52.368}}, // Coventry Airport
    Airport{IataCode{"CVU"}, CountryId{"PT"}, Coordinate{-31.1133, 39.6706}}, // Corvo Airport
    Airport{IataCode{"CWA"}, CountryId{"US"}, Coordinate{-89.6724, 44.7838}}, // Central Wisconsin Airport
    Airport{IataCode{"CWB"}, CountryId{"BR"}, Coordinate{-49.1721, -25.5368}}, // Afonso Pena International Airport
    Airport{IataCode{"CWC"}, CountryId{"UA"}, Coordinate{25.9672, 48.2668}}, // Chernivtsi International Airport
    Airport{IataCode{"CWI"}, CountryId{"US"}, Coordinate{-90.3292, 41.8311}}, // Clinton Municipal Airport
    Airport{IataCode{"CWJ"}, CountryId{"CN"}, Coordinate{99.3704, 23.2739}}, // Cangyuan Washan Airport
    Airport{IataCode{"CWL"}, CountryId{"GB"}, Coordinate{-3.34333, 51.3967}}, // Cardiff Airport
    Airport{IataCode{"CWS"}, CountryId{"US"}, Coordinate{-122.832, 48.49}}, // Center Island Airport
    Airport{IataCode{"CWT"}, CountryId{"AU"}, Coordinate{148.648, -33.845}}, // Cowra Airport
    Airport{IataCode{"CWW"}, CountryId{"AU"}, Coordinate{146.352, -35.99}}, // Corowa Airport
    Airport{IataCode{"CWX"}, CountryId{"US"}, Coordinate{-109.895, 32.2456}}, // Cochise County Airport
    Airport{IataCode{"CXA"}, CountryId{"VE"}, Coordinate{-66.1653, 7.61921}}, // Caicara del Orinoco Airport
    Airport{IataCode{"CXB"}, CountryId{"BD"}, Coordinate{91.9664, 21.4511}}, // Cox's Bazar Airport
    Airport{IataCode{"CXF"}, CountryId{"US"}, Coordinate{-150.204, 67.2522}}, // Coldfoot Airport
    Airport{IataCode{"CXI"}, CountryId{"KI"}, Coordinate{-157.35, 1.98611}}, // Cassidy International Airport
    Airport{IataCode{"CXJ"}, CountryId{"BR"}, Coordinate{-51.1872, -29.1948}}, // Caxias do Sul Airport
    Airport{IataCode{"CXL"}, CountryId{"US"}, Coordinate{-115.513, 32.6694}}, // Calexico International Airport
    Airport{IataCode{"CXM"}, CountryId{"AO"}, Coordinate{18.9238, -8.37311}}, // Camaxilo Airport
    Airport{IataCode{"CXN"}, CountryId{"SO"}, Coordinate{49.9086, 11.4944}}, // Candala Airport
    Airport{IataCode{"CXO"}, CountryId{"US"}, Coordinate{-95.4144, 30.3525}}, // Lone Star Executive Airport
    Airport{IataCode{"CXP"}, CountryId{"ID"}, Coordinate{109.05, -7.63333}}, // Tunggul Wulung Airport
    Airport{IataCode{"CXQ"}, CountryId{"AU"}, Coordinate{125.917, -18.8833}}, // Christmas Creek Airport
    Airport{IataCode{"CXR"}, CountryId{"VN"}, Coordinate{109.217, 12.009}}, // Cam Ranh International Airport
    Airport{IataCode{"CXT"}, CountryId{"AU"}, Coordinate{146.273, -20.0433}}, // Charters Towers Airport
    Airport{IataCode{"CXY"}, CountryId{"BS"}, Coordinate{-79.2761, 25.5553}}, // Cat Cay Airport
    Airport{IataCode{"CYA"}, CountryId{"HT"}, Coordinate{-73.7883, 18.2667}}, // Antoine-Simon Airport
    Airport{IataCode{"CYB"}, CountryId{"KY"}, Coordinate{-79.8794, 19.6899}}, // Charles Kirkconnell International Airport
    Airport{IataCode{"CYC"}, CountryId{"BZ"}, Coordinate{-88.0411, 17.7008}}, // Caye Chapel Airport
    Airport{IataCode{"CYF"}, CountryId{"US"}, Coordinate{-164.286, 60.1492}}, // Chefornak Airport
    Airport{IataCode{"CYG"}, CountryId{"AU"}, Coordinate{147.888, -36.1828}}, // Corryong Airport
    Airport{IataCode{"CYI"}, CountryId{"TW"}, Coordinate{120.393, 23.4617}}, // Chiayi Airport
    Airport{IataCode{"CYL"}, CountryId{"HN"}, Coordinate{-86.6833, 15.4458}}, // Coyoles Airport
    Airport{IataCode{"CYO"}, CountryId{"CU"}, Coordinate{-81.5538, 21.6233}}, // Vilo Acuña Airport
    Airport{IataCode{"CYP"}, CountryId{"PH"}, Coordinate{124.546, 12.0781}}, // Calbayog Airport
    Airport{IataCode{"CYR"}, CountryId{"UY"}, Coordinate{-57.7706, -34.4564}}, // Colonia Airport
    Airport{IataCode{"CYS"}, CountryId{"US"}, Coordinate{-104.819, 41.1532}}, // Cheyenne Regional Airport
    Airport{IataCode{"CYU"}, CountryId{"PH"}, Coordinate{121.068, 10.8581}}, // Cuyo Airport
    Airport{IataCode{"CYW"}, CountryId{"MX"}, Coordinate{-100.886, 20.5458}}, // Captain Rogelio Castillo National Airport
    Airport{IataCode{"CYX"}, CountryId{"RU"}, Coordinate{161.337, 68.7433}}, // Chersky Airport
    Airport{IataCode{"CYZ"}, CountryId{"PH"}, Coordinate{121.718, 16.93}}, // Cauayan Airport
    Airport{IataCode{"CZA"}, CountryId{"MX"}, Coordinate{-88.4489, 20.6386}}, // Chichen Itza International Airport
    Airport{IataCode{"CZC"}, CountryId{"US"}, Coordinate{-145.294, 61.9411}}, // Copper Center Airport
    Airport{IataCode{"CZE"}, CountryId{"VE"}, Coordinate{-69.6817, 11.415}}, // José Leonardo Chirino Airport
    Airport{IataCode{"CZF"}, CountryId{"US"}, Coordinate{-166.037, 61.7819}}, // Cape Romanzof LRRS Airport
    Airport{IataCode{"CZH"}, CountryId{"BZ"}, Coordinate{-88.4115, 18.3817}}, // Corozal Airport
    Airport{IataCode{"CZJ"}, CountryId{"PA"}, Coordinate{-78.5829, 9.44648}}, // Corazon de Jesus Airport
    Airport{IataCode{"CZK"}, CountryId{"US"}, Coordinate{-121.879, 45.6769}}, // Cascade Locks State Airport
    Airport{IataCode{"CZL"}, CountryId{"DZ"}, Coordinate{6.62034, 36.2847}}, // Mohamed Boudiaf International Airport
    Airport{IataCode{"CZM"}, CountryId{"MX"}, Coordinate{-86.9289, 20.515}}, // Cozumel International Airport
    Airport{IataCode{"CZN"}, CountryId{"US"}, Coordinate{-142.048, 62.0711}}, // Chisana Airport
    Airport{IataCode{"CZS"}, CountryId{"BR"}, Coordinate{-72.7736, -7.59618}}, // Cruzeiro do Sul International Airport
    Airport{IataCode{"CZU"}, CountryId{"CO"}, Coordinate{-75.2836, 9.33249}}, // Las Brujas Airport
    Airport{IataCode{"CZW"}, CountryId{"PL"}, Coordinate{19.2022, 50.8847}}, // Lądowisko Częstochowa-Rudniki
    Airport{IataCode{"CZX"}, CountryId{"CN"}, Coordinate{119.781, 31.9136}}, // Changzhou Benniu Airport
    Airport{IataCode{"DAB"}, CountryId{"US"}, Coordinate{-81.0606, 29.1847}}, // Daytona Beach International Airport
    Airport{IataCode{"DAC"}, CountryId{"BD"}, Coordinate{90.4052, 23.8473}}, // Shahjalal International Airport
    Airport{IataCode{"DAD"}, CountryId{"VN"}, Coordinate{108.202, 16.0549}}, // Da Nang International Airport
    Airport{IataCode{"DAG"}, CountryId{"US"}, Coordinate{-116.787, 34.8536}}, // Barstow-Daggett Airport
    Airport{IataCode{"DAK"}, CountryId{"EG"}, Coordinate{29.001, 25.4209}}, // Dakhla Oasis Airport
    Airport{IataCode{"DAL"}, CountryId{"US"}, Coordinate{-96.8499, 32.8448}}, // Dallas Love Field
    Airport{IataCode{"DAM"}, CountryId{"SY"}, Coordinate{36.5134, 33.4116}}, // Damascus International Airport
    Airport{IataCode{"DAN"}, CountryId{"US"}, Coordinate{-79.3361, 36.5728}}, // Danville Regional Airport
    Airport{IataCode{"DAP"}, CountryId{"NP"}, Coordinate{80.5484, 29.6692}}, // Darchula Airport
    Airport{IataCode{"DAR"}, CountryId{"TZ"}, Coordinate{39.2075, -6.86794}}, // Julius Nyerere International Airport
    Airport{IataCode{"DAS"}, CountryId{"CA"}, Coordinate{-119.717, 66.7031}}, // Great Bear Lake Airport
    Airport{IataCode{"DAT"}, CountryId{"CN"}, Coordinate{113.48, 40.0567}}, // Datong Yungang Airport
    Airport{IataCode{"DAU"}, CountryId{"PG"}, Coordinate{143.208, -9.08667}}, // Daru Airport
    Airport{IataCode{"DAV"}, CountryId{"PA"}, Coordinate{-82.435, 8.39111}}, // Enrique Malek International Airport
    Airport{IataCode{"DAX"}, CountryId{"CN"}, Coordinate{107.5, 31.3}}, // Dazhou Heshi Airport
    Airport{IataCode{"DAY"}, CountryId{"US"}, Coordinate{-84.22, 39.8993}}, // Dayton International Airport
    Airport{IataCode{"DAZ"}, CountryId{"AF"}, Coordinate{70.8818, 38.4617}}, // Darwaz Airport
    Airport{IataCode{"DBA"}, CountryId{"PK"}, Coordinate{64.4044, 28.875}}, // Dalbandin Airport
    Airport{IataCode{"DBB"}, CountryId{"EG"}, Coordinate{28.4631, 30.9304}}, // El Alamein International Airport
    Airport{IataCode{"DBC"}, CountryId{"CN"}, Coordinate{123.019, 45.5053}}, // Baicheng Chang'an Airport
    Airport{IataCode{"DBD"}, CountryId{"IN"}, Coordinate{86.4305, 23.835}}, // Dhanbad Airport
    Airport{IataCode{"DBM"}, CountryId{"ET"}, Coordinate{37.7333, 10.3167}}, // Debre Marqos Airport
    Airport{IataCode{"DBN"}, CountryId{"US"}, Coordinate{-82.9853, 32.5644}}, // W. H. 'Bud' Barron Airport
    Airport{IataCode{"DBO"}, CountryId{"AU"}, Coordinate{148.57, -32.2189}}, // Dubbo City Regional Airport
    Airport{IataCode{"DBP"}, CountryId{"PG"}, Coordinate{141.9, -6.28333}}, // Debepare
    Airport{IataCode{"DBQ"}, CountryId{"US"}, Coordinate{-90.7055, 42.3972}}, // Dubuque Regional Airport
    Airport{IataCode{"DBS"}, CountryId{"US"}, Coordinate{-112.221, 44.1622}}, // Dubois Municipal Airport
    Airport{IataCode{"DBT"}, CountryId{"ET"}, Coordinate{38, 11.9667}}, // Debre Tabor Airport
    Airport{IataCode{"DBV"}, CountryId{"HR"}, Coordinate{18.2617, 42.5606}}, // Dubrovnik Airport
    Airport{IataCode{"DBY"}, CountryId{"AU"}, Coordinate{151.267, -27.1553}}, // Dalby Airport
    Airport{IataCode{"DCA"}, CountryId{"US"}, Coordinate{-77.044, 38.8534}}, // Ronald Reagan Washington National Airport
    Airport{IataCode{"DCF"}, CountryId{"DM"}, Coordinate{-61.3922, 15.3367}}, // Canefield Airport
    Airport{IataCode{"DCK"}, CountryId{"US"}, Coordinate{-156.905, 66.9433}}, // Dahl Creek Airport
    Airport{IataCode{"DCM"}, CountryId{"FR"}, Coordinate{2.28915, 43.5538}}, // Castres–Mazamet Airport
    Airport{IataCode{"DCT"}, CountryId{"BS"}, Coordinate{-75.7333, 22.1817}}, // Duncan Town Airport
    Airport{IataCode{"DCU"}, CountryId{"US"}, Coordinate{-86.948, 34.6589}}, // Pryor Field Regional Airport
    Airport{IataCode{"DCY"}, CountryId{"CN"}, Coordinate{100.053, 29.3231}}, // Daocheng Yading Airport
    Airport{IataCode{"DDC"}, CountryId{"US"}, Coordinate{-99.9656, 37.7631}}, // Dodge City Regional Airport
    Airport{IataCode{"DDD"}, CountryId{"MV"}, Coordinate{72.8929, 2.66732}}, // Dhaalu Airport
    Airport{IataCode{"DDG"}, CountryId{"CN"}, Coordinate{124.281, 40.0302}}, // Dandong Langtou Airport
    Airport{IataCode{"DDM"}, CountryId{"PG"}, Coordinate{147.45, -8.75}}, // Dodoima
    Airport{IataCode{"DDU"}, CountryId{"PK"}, Coordinate{67.6666, 26.7408}}, // Dadu Airport
    Airport{IataCode{"DEA"}, CountryId{"PK"}, Coordinate{70.489, 29.961}}, // Dera Ghazi Khan International Airport
    Airport{IataCode{"DEB"}, CountryId{"HU"}, Coordinate{21.6093, 47.4913}}, // Debrecen International Airport
    Airport{IataCode{"DEC"}, CountryId{"US"}, Coordinate{-88.8772, 39.8331}}, // Decatur Airport
    Airport{IataCode{"DED"}, CountryId{"IN"}, Coordinate{78.1921, 30.195}}, // Jolly Grant Airport
    Airport{IataCode{"DEE"}, CountryId{"RU"}, Coordinate{145.85, 44.0333}}, // Yuzhno-Kurilsk Mendeleyevo Airport
    Airport{IataCode{"DEF"}, CountryId{"IR"}, Coordinate{48.3833, 32.4333}}, // Dezful Airport
    Airport{IataCode{"DEH"}, CountryId{"US"}, Coordinate{-91.7394, 43.2756}}, // Decorah Municipal Airport
    Airport{IataCode{"DEI"}, CountryId{"SC"}, Coordinate{55.6645, -3.80222}}, // Denis Island Airport
    Airport{IataCode{"DEL"}, CountryId{"IN"}, Coordinate{77.0868, 28.5568}}, // Indira Gandhi International Airport
    Airport{IataCode{"DEN"}, CountryId{"US"}, Coordinate{-104.674, 39.8469}}, // Denver International Airport
    Airport{IataCode{"DEP"}, CountryId{"IN"}, Coordinate{94.2233, 27.9889}}, // Daporijo Airport
    Airport{IataCode{"DEQ"}, CountryId{"CN"}, Coordinate{120.107, 30.5042}}, // Deqing Moganshan Airport
    Airport{IataCode{"DES"}, CountryId{"SC"}, Coordinate{53.6505, -5.69483}}, // Desroches Airport
    Airport{IataCode{"DET"}, CountryId{"US"}, Coordinate{-83.0015, 42.4068}}, // Coleman A. Young International Airport
    Airport{IataCode{"DEZ"}, CountryId{"SY"}, Coordinate{40.1758, 35.2853}}, // Deir ez-Zor Airport
    Airport{IataCode{"DFI"}, CountryId{"US"}, Coordinate{-84.4289, 41.3375}}, // Defiance Memorial Airport
    Airport{IataCode{"DFW"}, CountryId{"US"}, Coordinate{-97.0413, 32.9063}}, // Dallas/Fort Worth International Airport
    Airport{IataCode{"DGA"}, CountryId{"BZ"}, Coordinate{-88.2586, 16.9825}}, // Dangriga Airport
    Airport{IataCode{"DGE"}, CountryId{"AU"}, Coordinate{149.616, -32.5638}}, // Mudgee Airport
    Airport{IataCode{"DGF"}, CountryId{"CA"}, Coordinate{-120.183, 50.1667}}, // Douglas Lake Airport
    Airport{IataCode{"DGL"}, CountryId{"US"}, Coordinate{-109.506, 31.3425}}, // Douglas Municipal Airport
    Airport{IataCode{"DGO"}, CountryId{"MX"}, Coordinate{-104.534, 24.1261}}, // General Guadalupe Victoria International Airport
    Airport{IataCode{"DGP"}, CountryId{"LV"}, Coordinate{26.665, 55.9447}}, // Daugavpils International Airport
    Airport{IataCode{"DGR"}, CountryId{"NZ"}, Coordinate{173.894, -35.9397}}, // Dargaville Aerodrome
    Airport{IataCode{"DGT"}, CountryId{"PH"}, Coordinate{123.296, 9.33275}}, // Sibulan Airport
    Airport{IataCode{"DGU"}, CountryId{"BF"}, Coordinate{-3.49, 12.459}}, // Dedougou Airport
    Airport{IataCode{"DGW"}, CountryId{"US"}, Coordinate{-105.384, 42.7984}}, // Converse County Airport
    Airport{IataCode{"DHI"}, CountryId{"NP"}, Coordinate{80.5819, 28.7533}}, // Dhangadhi Airport
    Airport{IataCode{"DHL"}, CountryId{"YE"}, Coordinate{44.7167, 13.7333}}, // Dhala
    Airport{IataCode{"DHM"}, CountryId{"IN"}, Coordinate{76.2599, 32.1649}}, // Gaggal Airport
    Airport{IataCode{"DHN"}, CountryId{"US"}, Coordinate{-85.4484, 31.3149}}, // Dothan Regional Airport
    Airport{IataCode{"DHR"}, CountryId{"NL"}, Coordinate{4.784, 52.9208}}, // De Kooy Airfield
    Airport{IataCode{"DHT"}, CountryId{"US"}, Coordinate{-102.547, 36.0225}}, // Dalhart Municipal Airport
    Airport{IataCode{"DIB"}, CountryId{"IN"}, Coordinate{95.018, 27.481}}, // Dibrugarh Airport
    Airport{IataCode{"DIE"}, CountryId{"MG"}, Coordinate{49.2953, -12.3498}}, // Arrachart Airport
    Airport{IataCode{"DIG"}, CountryId{"CN"}, Coordinate{99.6819, 27.7964}}, // Dêqên Shangri-La Airport
    Airport{IataCode{"DIJ"}, CountryId{"FR"}, Coordinate{5.0907, 47.2664}}, // Dijon-Bourgogne Airport
    Airport{IataCode{"DIK"}, CountryId{"US"}, Coordinate{-102.793, 46.8017}}, // Dickinson Theodore Roosevelt Regional Airport
    Airport{IataCode{"DIL"}, CountryId{"TL"}, Coordinate{125.525, -8.54904}}, // Presidente Nicolau Lobato International Airport
    Airport{IataCode{"DIM"}, CountryId{"CI"}, Coordinate{-4.6411, 6.6}}, // Dimbokro Airport
    Airport{IataCode{"DIN"}, CountryId{"VN"}, Coordinate{103.006, 21.4009}}, // Dien Bien Phu Airport
    Airport{IataCode{"DIP"}, CountryId{"BF"}, Coordinate{1.783, 12.05}}, // Diapaga Airport
    Airport{IataCode{"DIQ"}, CountryId{"BR"}, Coordinate{-44.87, -20.1819}}, // Divinópolis Airport
    Airport{IataCode{"DIR"}, CountryId{"ET"}, Coordinate{41.8579, 9.61277}}, // Aba Tenna Dejazmach Yilma International Airport
    Airport{IataCode{"DIS"}, CountryId{"CG"}, Coordinate{12.6676, -4.21084}}, // Dolisie Airport
    Airport{IataCode{"DIU"}, CountryId{"IN"}, Coordinate{70.925, 20.7134}}, // Diu Airport
    Airport{IataCode{"DIV"}, CountryId{"CI"}, Coordinate{-5.35444, 5.79306}}, // Divo Airport
    Airport{IataCode{"DIY"}, CountryId{"TR"}, Coordinate{40.1849, 37.9007}}, // Diyarbakır Airport
    Airport{IataCode{"DJA"}, CountryId{"BJ"}, Coordinate{1.6376, 9.692}}, // Djougou Airport
    Airport{IataCode{"DJB"}, CountryId{"ID"}, Coordinate{103.641, -1.63194}}, // Sultan Thaha Airport
    Airport{IataCode{"DJE"}, CountryId{"TN"}, Coordinate{10.7753, 33.8717}}, // Djerba–Zarzis International Airport
    Airport{IataCode{"DJG"}, CountryId{"DZ"}, Coordinate{9.46575, 24.2894}}, // Djanet Inedbirene Airport
    Airport{IataCode{"DJJ"}, CountryId{"ID"}, Coordinate{140.513, -2.57025}}, // Sentani Airport
    Airport{IataCode{"DJM"}, CountryId{"CG"}, Coordinate{14.75, -2.56333}}, // Djambala Airport
    Airport{IataCode{"DJN"}, CountryId{"US"}, Coordinate{-145.717, 64.0506}}, // Delta Junction Airport
    Airport{IataCode{"DJO"}, CountryId{"CI"}, Coordinate{-6.47319, 6.79281}}, // Daloa Airport
    Airport{IataCode{"DKA"}, CountryId{"NG"}, Coordinate{7.66071, 13.0038}}, // Katsina Airport
    Airport{IataCode{"DKI"}, CountryId{"AU"}, Coordinate{146.14, -17.9417}}, // Dunk Island Airport
    Airport{IataCode{"DKK"}, CountryId{"US"}, Coordinate{-79.2719, 42.4933}}, // Chautauqua County/Dunkirk Airport
    Airport{IataCode{"DKR"}, CountryId{"SN"}, Coordinate{-17.4793, 14.7438}}, // Léopold Sédar Senghor International Airport
    Airport{IataCode{"DKS"}, CountryId{"RU"}, Coordinate{80.3817, 73.5167}}, // Dikson Airport
    Airport{IataCode{"DLA"}, CountryId{"CM"}, Coordinate{9.7164, 4.01214}}, // Douala International Airport
    Airport{IataCode{"DLC"}, CountryId{"CN"}, Coordinate{121.535, 38.9611}}, // Dalian Zhoushuizi International Airport
    Airport{IataCode{"DLD"}, CountryId{"NO"}, Coordinate{8.51278, 60.4167}}, // Geilo Airport
    Airport{IataCode{"DLE"}, CountryId{"FR"}, Coordinate{5.42497, 47.0438}}, // Dole–Jura Airport
    Airport{IataCode{"DLG"}, CountryId{"US"}, Coordinate{-158.506, 59.0447}}, // Dillingham Airport
    Airport{IataCode{"DLH"}, CountryId{"US"}, Coordinate{-92.1801, 46.8384}}, // Duluth International Airport
    Airport{IataCode{"DLI"}, CountryId{"VN"}, Coordinate{108.368, 11.7491}}, // Lien Khuong Airport
    Airport{IataCode{"DLL"}, CountryId{"US"}, Coordinate{-79.3686, 34.4492}}, // Dillon County Airport
    Airport{IataCode{"DLM"}, CountryId{"TR"}, Coordinate{28.788, 36.7201}}, // Dalaman Airport
    Airport{IataCode{"DLN"}, CountryId{"US"}, Coordinate{-112.552, 45.2553}}, // Dillon Airport
    Airport{IataCode{"DLS"}, CountryId{"US"}, Coordinate{-121.173, 45.6184}}, // Columbia Gorge Regional Airport
    Airport{IataCode{"DLU"}, CountryId{"CN"}, Coordinate{100.322, 25.6497}}, // Dali Airport
    Airport{IataCode{"DLY"}, CountryId{"VU"}, Coordinate{169.004, -18.7696}}, // Dillon's Bay Airport
    Airport{IataCode{"DLZ"}, CountryId{"MN"}, Coordinate{104.367, 43.6086}}, // Dalanzadgad Airport
    Airport{IataCode{"DMB"}, CountryId{"KZ"}, Coordinate{71.2932, 42.8664}}, // Taraz Airport
    Airport{IataCode{"DMD"}, CountryId{"AU"}, Coordinate{138.822, -17.9403}}, // Doomadgee Airport
    Airport{IataCode{"DME"}, CountryId{"RU"}, Coordinate{37.8968, 55.4151}}, // Domodedovo International Airport
    Airport{IataCode{"DMK"}, CountryId{"TH"}, Coordinate{100.602, 13.9177}}, // Don Mueang International Airport
    Airport{IataCode{"DMM"}, CountryId{"SA"}, Coordinate{49.7978, 26.4711}}, // King Fahd International Airport
    Airport{IataCode{"DMN"}, CountryId{"US"}, Coordinate{-107.721, 32.2622}}, // Deming Municipal Airport
    Airport{IataCode{"DMO"}, CountryId{"US"}, Coordinate{-93.1758, 38.7075}}, // Sedalia Regional Airport
    Airport{IataCode{"DMT"}, CountryId{"BR"}, Coordinate{-56.4006, -14.3769}}, // Diamantino Airport
    Airport{IataCode{"DMU"}, CountryId{"IN"}, Coordinate{93.7731, 25.8802}}, // Dimapur Airport
    Airport{IataCode{"DND"}, CountryId{"GB"}, Coordinate{-3.01575, 56.4537}}, // Dundee Airport
    Airport{IataCode{"DNH"}, CountryId{"CN"}, Coordinate{94.8056, 40.1659}}, // Dunhuang Airport
    Airport{IataCode{"DNI"}, CountryId{"SD"}, Coordinate{36.3289, 15.3875}}, // Wad Medani Airport
    Airport{IataCode{"DNK"}, CountryId{"UA"}, Coordinate{35.0942, 48.3679}}, // Dnipropetrovsk International Airport
    Airport{IataCode{"DNL"}, CountryId{"US"}, Coordinate{-82.0394, 33.4664}}, // Daniel Field
    Airport{IataCode{"DNN"}, CountryId{"US"}, Coordinate{-84.8703, 34.7231}}, // Dalton Municipal Airport
    Airport{IataCode{"DNP"}, CountryId{"NP"}, Coordinate{82.2942, 28.1108}}, // Tribhuvannagar Airport
    Airport{IataCode{"DNQ"}, CountryId{"AU"}, Coordinate{144.947, -35.56}}, // Deniliquin Airport
    Airport{IataCode{"DNR"}, CountryId{"FR"}, Coordinate{-2.07588, 48.5898}}, // Dinard–Pleurtuit–Saint-Malo Airport
    Airport{IataCode{"DNS"}, CountryId{"US"}, Coordinate{-95.3806, 41.9867}}, // Denison Municipal Airport
    Airport{IataCode{"DNU"}, CountryId{"PG"}, Coordinate{146.667, -6.15}}, // Dinangat
    Airport{IataCode{"DNV"}, CountryId{"US"}, Coordinate{-87.5956, 40.1992}}, // Vermilion Regional Airport
    Airport{IataCode{"DNX"}, CountryId{"SD"}, Coordinate{35.067, 12.533}}, // Galegu Airport
    Airport{IataCode{"DOB"}, CountryId{"ID"}, Coordinate{134.212, -5.77167}}, // Dobo Airport
    Airport{IataCode{"DOD"}, CountryId{"TZ"}, Coordinate{35.7492, -6.16919}}, // Dodoma Airport
    Airport{IataCode{"DOE"}, CountryId{"SR"}, Coordinate{-55.4816, 4.00571}}, // Djoemoe Airstrip
    Airport{IataCode{"DOG"}, CountryId{"SD"}, Coordinate{30.43, 19.1536}}, // Dongola Airport
    Airport{IataCode{"DOH"}, CountryId{"QA"}, Coordinate{51.615, 25.262}}, // Hamad International Airport
    Airport{IataCode{"DOI"}, CountryId{"PG"}, Coordinate{150.717, -10.7167}}, // Doini
    Airport{IataCode{"DOL"}, CountryId{"FR"}, Coordinate{0.158161, 49.3611}}, // Deauville – Saint-Gatien Airport
    Airport{IataCode{"DOM"}, CountryId{"DM"}, Coordinate{-61.3003, 15.5456}}, // Douglas–Charles Airport
    Airport{IataCode{"DON"}, CountryId{"GT"}, Coordinate{-89.6884, 17.6124}}, // Dos Lagunas Airport
    Airport{IataCode{"DOO"}, CountryId{"PG"}, Coordinate{147.8, -9.5}}, // Dorobisoro
    Airport{IataCode{"DOP"}, CountryId{"NP"}, Coordinate{82.8192, 28.9858}}, // Dolpa Airport
    Airport{IataCode{"DOR"}, CountryId{"BF"}, Coordinate{-0.066667, 14.0333}}, // Dori Airport
    Airport{IataCode{"DOU"}, CountryId{"BR"}, Coordinate{-54.925, -22.1971}}, // Dourados Airport
    Airport{IataCode{"DOY"}, CountryId{"CN"}, Coordinate{118.784, 37.5064}}, // Dongying Shengli Airport
    Airport{IataCode{"DPA"}, CountryId{"US"}, Coordinate{-88.2551, 41.9068}}, // DuPage Airport
    Airport{IataCode{"DPL"}, CountryId{"PH"}, Coordinate{123.334, 8.60139}}, // Dipolog Airport
    Airport{IataCode{"DPO"}, CountryId{"AU"}, Coordinate{146.428, -41.1718}}, // Devonport Airport
    Airport{IataCode{"DPS"}, CountryId{"ID"}, Coordinate{115.168, -8.74806}}, // Ngurah Rai International Airport
    Airport{IataCode{"DPT"}, CountryId{"RU"}, Coordinate{139.902, 69.3925}}, // Deputatsky Airport
    Airport{IataCode{"DQA"}, CountryId{"CN"}, Coordinate{125.228, 46.5872}}, // Daqing Sartu Airport
    Airport{IataCode{"DQH"}, CountryId{"US"}, Coordinate{-150.945, 70.3443}}, // Alpine Airstrip
    Airport{IataCode{"DQM"}, CountryId{"OM"}, Coordinate{57.637, 19.5032}}, // Duqm Jaaluni Airport
    Airport{IataCode{"DRA"}, CountryId{"US"}, Coordinate{-116.032, 36.6199}}, // Desert Rock Airport
    Airport{IataCode{"DRB"}, CountryId{"AU"}, Coordinate{123.661, -17.37}}, // Derby Airport
    Airport{IataCode{"DRC"}, CountryId{"AO"}, Coordinate{20.7663, -17.9815}}, // Dirico Airport
    Airport{IataCode{"DRE"}, CountryId{"US"}, Coordinate{-83.7439, 46.0094}}, // Drummond Island Airport
    Airport{IataCode{"DRG"}, CountryId{"US"}, Coordinate{-162.766, 66.0694}}, // Deering Airport
    Airport{IataCode{"DRH"}, CountryId{"ID"}, Coordinate{138.317, -2.8}}, // Dabra Airport
    Airport{IataCode{"DRI"}, CountryId{"US"}, Coordinate{-93.34, 30.8317}}, // Beauregard Regional Airport
    Airport{IataCode{"DRJ"}, CountryId{"SR"}, Coordinate{-54.6667, 4.11667}}, // Drietabbetje Airstrip
    Airport{IataCode{"DRK"}, CountryId{"CR"}, Coordinate{-83.65, 8.73333}}, // Drake Bay Airport
    Airport{IataCode{"DRN"}, CountryId{"AU"}, Coordinate{148.217, -28.5917}}, // Dirranbandi Airport
    Airport{IataCode{"DRO"}, CountryId{"US"}, Coordinate{-107.751, 37.1597}}, // Durango–La Plata County Airport
    Airport{IataCode{"DRS"}, CountryId{"DE"}, Coordinate{13.766, 51.1246}}, // Dresden Airport
    Airport{IataCode{"DRT"}, CountryId{"US"}, Coordinate{-100.92, 29.3706}}, // Del Rio International Airport
    Airport{IataCode{"DRV"}, CountryId{"MV"}, Coordinate{73.1306, 5.15667}}, // Dharavandhoo Airport
    Airport{IataCode{"DSA"}, CountryId{"GB"}, Coordinate{-1.01083, 53.4808}}, // Doncaster Sheffield Airport
    Airport{IataCode{"DSC"}, CountryId{"CM"}, Coordinate{10.0641, 5.44809}}, // Dschang Airport
    Airport{IataCode{"DSD"}, CountryId{"FR"}, Coordinate{-61.0844, 16.2969}}, // La Désirade Airport
    Airport{IataCode{"DSE"}, CountryId{"ET"}, Coordinate{39.7114, 11.0825}}, // Combolcha Airport
    Airport{IataCode{"DSI"}, CountryId{"US"}, Coordinate{-86.4714, 30.4}}, // Destin Executive Airport
    Airport{IataCode{"DSK"}, CountryId{"PK"}, Coordinate{70.8878, 31.9098}}, // Dera Ismail Khan Airport
    Airport{IataCode{"DSM"}, CountryId{"US"}, Coordinate{-93.6493, 41.5332}}, // Des Moines International Airport
    Airport{IataCode{"DSN"}, CountryId{"CN"}, Coordinate{109.862, 39.4972}}, // Ordos Ejin Horo Airport
    Airport{IataCode{"DSO"}, CountryId{"KP"}, Coordinate{127.475, 39.6778}}, // Sondok Airport
    Airport{IataCode{"DSS"}, CountryId{"SN"}, Coordinate{-17.0689, 14.6708}}, // Blaise Diagne International Airport
    Airport{IataCode{"DSV"}, CountryId{"US"}, Coordinate{-77.7131, 42.5708}}, // Dansville Municipal Airport
    Airport{IataCode{"DSX"}, CountryId{"TW"}, Coordinate{116.717, 20.7}}, // Dongsha Island Airport
    Airport{IataCode{"DTA"}, CountryId{"US"}, Coordinate{-112.508, 39.3806}}, // Delta Municipal Airport
    Airport{IataCode{"DTB"}, CountryId{"ID"}, Coordinate{98.9876, 2.26248}}, // Silangit Airport
    Airport{IataCode{"DTD"}, CountryId{"ID"}, Coordinate{116.48, 0.72}}, // Datadawai Airport
    Airport{IataCode{"DTE"}, CountryId{"PH"}, Coordinate{122.979, 14.1262}}, // Bagasbas Airport
    Airport{IataCode{"DTH"}, CountryId{"US"}, Coordinate{-116.881, 36.4639}}, // Furnace Creek Airport
    Airport{IataCode{"DTI"}, CountryId{"BR"}, Coordinate{-43.6511, -18.2333}}, // Diamantina Airport
    Airport{IataCode{"DTL"}, CountryId{"US"}, Coordinate{-95.8847, 46.8253}}, // Detroit Lakes Airport
    Airport{IataCode{"DTM"}, CountryId{"DE"}, Coordinate{7.61257, 51.5149}}, // Dortmund Airport
    Airport{IataCode{"DTN"}, CountryId{"US"}, Coordinate{-93.7489, 32.5402}}, // Shreveport Downtown Airport
    Airport{IataCode{"DTU"}, CountryId{"CN"}, Coordinate{126.133, 48.445}}, // Wudalianchi Airport
    Airport{IataCode{"DTW"}, CountryId{"US"}, Coordinate{-83.3561, 42.2078}}, // Detroit Metropolitan Wayne County Airport
    Airport{IataCode{"DUA"}, CountryId{"US"}, Coordinate{-96.398, 33.9421}}, // Durant Regional Airport – Eaker Field
    Airport{IataCode{"DUB"}, CountryId{"IE"}, Coordinate{-6.2442, 53.4266}}, // Dublin Airport
    Airport{IataCode{"DUC"}, CountryId{"US"}, Coordinate{-97.96, 34.4708}}, // Halliburton Field (airport)
    Airport{IataCode{"DUD"}, CountryId{"NZ"}, Coordinate{170.2, -45.924}}, // Dunedin International Airport
    Airport{IataCode{"DUE"}, CountryId{"AO"}, Coordinate{20.8185, -7.40064}}, // Dundo Airport
    Airport{IataCode{"DUF"}, CountryId{"US"}, Coordinate{-75.7886, 36.2533}}, // Pine Island Airport
    Airport{IataCode{"DUG"}, CountryId{"US"}, Coordinate{-109.604, 31.4689}}, // Bisbee-Douglas International Airport
    Airport{IataCode{"DUJ"}, CountryId{"US"}, Coordinate{-78.8986, 41.1783}}, // DuBois Regional Airport
    Airport{IataCode{"DUM"}, CountryId{"ID"}, Coordinate{101.433, 1.6123}}, // Pinang Kampai Airport
    Airport{IataCode{"DUQ"}, CountryId{"CA"}, Coordinate{-123.717, 48.7583}}, // Duncan Airport
    Airport{IataCode{"DUR"}, CountryId{"ZA"}, Coordinate{31.1096, -29.6141}}, // King Shaka International Airport
    Airport{IataCode{"DUS"}, CountryId{"DE"}, Coordinate{6.76684, 51.2782}}, // Düsseldorf Airport
    Airport{IataCode{"DUT"}, CountryId{"US"}, Coordinate{-166.545, 53.8989}}, // Unalaska Airport
    Airport{IataCode{"DVD"}, CountryId{"MG"}, Coordinate{43.2706, -22.1111}}, // Andavadoaka Airport
    Airport{IataCode{"DVK"}, CountryId{"CA"}, Coordinate{-110.29, 64.5114}}, // Diavik Airport
    Airport{IataCode{"DVL"}, CountryId{"US"}, Coordinate{-98.9083, 48.1144}}, // Devils Lake Regional Airport
    Airport{IataCode{"DVN"}, CountryId{"US"}, Coordinate{-90.5883, 41.6103}}, // Davenport Municipal Airport
    Airport{IataCode{"DVO"}, CountryId{"PH"}, Coordinate{125.645, 7.13067}}, // Francisco Bangoy International Airport
    Airport{IataCode{"DVT"}, CountryId{"US"}, Coordinate{-112.083, 33.6855}}, // Phoenix Deer Valley Airport
    Airport{IataCode{"DWA"}, CountryId{"MW"}, Coordinate{34.1319, -12.5183}}, // Dwangwa Airport
    Airport{IataCode{"DWB"}, CountryId{"MG"}, Coordinate{45.3667, -16.1}}, // Soalala Airport
    Airport{IataCode{"DWC"}, CountryId{"AE"}, Coordinate{55.1592, 24.8862}}, // Al Maktoum International Airport
    Airport{IataCode{"DWD"}, CountryId{"SA"}, Coordinate{44.1211, 24.4497}}, // Dawadmi Domestic Airport
    Airport{IataCode{"DWH"}, CountryId{"US"}, Coordinate{-95.5528, 30.0619}}, // David Wayne Hooks Memorial Airport
    Airport{IataCode{"DWS"}, CountryId{"US"}, Coordinate{-81.5715, 28.4}}, // Walt Disney World Airport
    Airport{IataCode{"DXB"}, CountryId{"AE"}, Coordinate{55.3644, 25.2528}}, // Dubai International Airport
    Airport{IataCode{"DXE"}, CountryId{"US"}, Coordinate{-90.1031, 32.4386}}, // Bruce Campbell Field
    Airport{IataCode{"DXR"}, CountryId{"US"}, Coordinate{-73.4822, 41.3717}}, // Danbury Municipal Airport
    Airport{IataCode{"DYA"}, CountryId{"AU"}, Coordinate{148.364, -22.6222}}, // Dysart Airport
    Airport{IataCode{"DYG"}, CountryId{"CN"}, Coordinate{110.44, 29.1073}}, // Zhangjiajie Hehua Airport
    Airport{IataCode{"DYL"}, CountryId{"US"}, Coordinate{-75.1219, 40.3331}}, // Doylestown Airport
    Airport{IataCode{"DYM"}, CountryId{"AU"}, Coordinate{141.145, -23.7617}}, // Diamantina Lakes Airport
    Airport{IataCode{"DYR"}, CountryId{"RU"}, Coordinate{177.737, 64.7137}}, // Ugolny Airport
    Airport{IataCode{"DYU"}, CountryId{"TJ"}, Coordinate{68.8156, 38.5486}}, // Dushanbe International Airport
    Airport{IataCode{"DZA"}, CountryId{"FR"}, Coordinate{45.2806, -12.8067}}, // Dzaoudzi Pamandzi International Airport
    Airport{IataCode{"DZN"}, CountryId{"KZ"}, Coordinate{67.7366, 47.7137}}, // Zhezkazgan Airport
    Airport{IataCode{"DZO"}, CountryId{"UY"}, Coordinate{-56.4992, -33.3586}}, // Santa Bernardina International Airport
    Airport{IataCode{"DZU"}, CountryId{"CN"}, Coordinate{105.774, 29.6364}}, // Dazu
    Airport{IataCode{"EAA"}, CountryId{"US"}, Coordinate{-141.15, 64.7781}}, // Eagle Airport
    Airport{IataCode{"EAB"}, CountryId{"YE"}, Coordinate{43.1778, 16.0111}}, // Abbs Airport
    Airport{IataCode{"EAE"}, CountryId{"VU"}, Coordinate{168.342, -17.0892}}, // Siwo Airport
    Airport{IataCode{"EAL"}, CountryId{"MH"}, Coordinate{167.333, 9.08333}}, // Elenak Airport
    Airport{IataCode{"EAM"}, CountryId{"SA"}, Coordinate{44.4195, 17.6168}}, // Najran Domestic Airport
    Airport{IataCode{"EAP"}, CountryId{"FR"}, Coordinate{7.53004, 47.5989}}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"EAR"}, CountryId{"US"}, Coordinate{-99.0122, 40.7274}}, // Kearney Regional Airport
    Airport{IataCode{"EAS"}, CountryId{"ES"}, Coordinate{-1.79308, 43.3563}}, // San Sebastián Airport
    Airport{IataCode{"EAT"}, CountryId{"US"}, Coordinate{-120.21, 47.4045}}, // Pangborn Memorial Airport
    Airport{IataCode{"EAU"}, CountryId{"US"}, Coordinate{-91.4821, 44.863}}, // Chippewa Valley Regional Airport
    Airport{IataCode{"EBA"}, CountryId{"IT"}, Coordinate{10.2375, 42.7628}}, // Marina di Campo Airport
    Airport{IataCode{"EBB"}, CountryId{"UG"}, Coordinate{32.4429, 0.045318}}, // Entebbe International Airport
    Airport{IataCode{"EBD"}, CountryId{"SD"}, Coordinate{30.2325, 13.1531}}, // El Obeid Airport
    Airport{IataCode{"EBG"}, CountryId{"CO"}, Coordinate{-74.8101, 7.59688}}, // El Bagre Airport
    Airport{IataCode{"EBH"}, CountryId{"DZ"}, Coordinate{1.09328, 33.718}}, // El Bayadh Airport
    Airport{IataCode{"EBJ"}, CountryId{"DK"}, Coordinate{8.54901, 55.5215}}, // Esbjerg Airport
    Airport{IataCode{"EBL"}, CountryId{"IQ"}, Coordinate{43.9493, 36.2353}}, // Erbil International Airport
    Airport{IataCode{"EBN"}, CountryId{"MH"}, Coordinate{166.82, 9.33056}}, // Ebadon aerodrome
    Airport{IataCode{"EBO"}, CountryId{"MH"}, Coordinate{168.753, 4.59889}}, // Ebon Airport
    Airport{IataCode{"EBS"}, CountryId{"US"}, Coordinate{-93.8692, 42.4364}}, // Webster City Municipal Airport
    Airport{IataCode{"EBU"}, CountryId{"FR"}, Coordinate{4.294, 45.5319}}, // Saint-Étienne – Bouthéon Airport
    Airport{IataCode{"EBW"}, CountryId{"CM"}, Coordinate{11.185, 2.876}}, // Ebolowa Airport
    Airport{IataCode{"ECG"}, CountryId{"US"}, Coordinate{-76.1744, 36.2606}}, // Elizabeth City Regional Airport
    Airport{IataCode{"ECH"}, CountryId{"AU"}, Coordinate{144.764, -36.1641}}, // Echuca Airport
    Airport{IataCode{"ECI"}, CountryId{"NI"}, Coordinate{-85.9333, 11.4333}}, // Costa Esmeralda Airport
    Airport{IataCode{"ECN"}, CountryId{}, Coordinate{33.5033, 35.1577}}, // Ercan International Airport
    Airport{IataCode{"ECP"}, CountryId{"US"}, Coordinate{-85.7974, 30.3498}}, // Northwest Florida Beaches International Airport
    Airport{IataCode{"ECR"}, CountryId{"CO"}, Coordinate{-78.1, 2.44083}}, // El Charco
    Airport{IataCode{"EDB"}, CountryId{"SD"}, Coordinate{30.95, 18.025}}, // El Debba Airport
    Airport{IataCode{"EDE"}, CountryId{"US"}, Coordinate{-76.5673, 36.0198}}, // Northeastern Regional Airport
    Airport{IataCode{"EDI"}, CountryId{"GB"}, Coordinate{-3.3603, 55.9475}}, // Edinburgh Airport
    Airport{IataCode{"EDK"}, CountryId{"US"}, Coordinate{-96.8175, 37.7742}}, // El Dorado/Captain Jack Thomas Memorial Airport
    Airport{IataCode{"EDL"}, CountryId{"KE"}, Coordinate{35.2238, 0.405086}}, // Eldoret International Airport
    Airport{IataCode{"EDM"}, CountryId{"FR"}, Coordinate{-1.38167, 46.7025}}, // La Roche-sur-Yon - Les Ajoncs Airport
    Airport{IataCode{"EDO"}, CountryId{"TR"}, Coordinate{27.0122, 39.5484}}, // Balıkesir Koca Seyit Airport
    Airport{IataCode{"EDQ"}, CountryId{"HN"}, Coordinate{-88.4375, 14.13}}, // Erandique Airport
    Airport{IataCode{"EDR"}, CountryId{"AU"}, Coordinate{141.609, -14.8967}}, // Edward River Airport
    Airport{IataCode{"EED"}, CountryId{"US"}, Coordinate{-114.623, 34.7664}}, // Needles Airport
    Airport{IataCode{"EEK"}, CountryId{"US"}, Coordinate{-162.044, 60.2136}}, // Eek Airport
    Airport{IataCode{"EEN"}, CountryId{"US"}, Coordinate{-72.2708, 42.8983}}, // Dillant–Hopkins Airport
    Airport{IataCode{"EFD"}, CountryId{"US"}, Coordinate{-95.1589, 29.6072}}, // Ellington International Airport
    Airport{IataCode{"EFG"}, CountryId{"PG"}, Coordinate{147.66, -9.15567}}, // Efogi Airport
    Airport{IataCode{"EFK"}, CountryId{"US"}, Coordinate{-72.2292, 44.8889}}, // Newport State Airport (Vermont)
    Airport{IataCode{"EFL"}, CountryId{"GR"}, Coordinate{20.5049, 38.1195}}, // Kefalonia International Airport
    Airport{IataCode{"EGA"}, CountryId{"PG"}, Coordinate{146.1, -6.91667}}, // Engati
    Airport{IataCode{"EGC"}, CountryId{"FR"}, Coordinate{0.513348, 44.8224}}, // Bergerac Dordogne Périgord Airport
    Airport{IataCode{"EGE"}, CountryId{"US"}, Coordinate{-106.913, 39.6402}}, // Eagle County Regional Airport
    Airport{IataCode{"EGH"}, CountryId{"EG"}, Coordinate{34.1292, 31.0689}}, // El Gora Airport
    Airport{IataCode{"EGI"}, CountryId{"US"}, Coordinate{-86.5228, 30.6503}}, // Duke Field
    Airport{IataCode{"EGL"}, CountryId{"ET"}, Coordinate{39.75, 5.28333}}, // Neghelle Airport
    Airport{IataCode{"EGM"}, CountryId{"SB"}, Coordinate{157.875, -8.578}}, // Seghe Airport
    Airport{IataCode{"EGN"}, CountryId{"SD"}, Coordinate{22.4672, 13.4817}}, // Geneina Airport
    Airport{IataCode{"EGO"}, CountryId{"RU"}, Coordinate{36.5704, 50.6452}}, // Belgorod International Airport
    Airport{IataCode{"EGP"}, CountryId{"US"}, Coordinate{-100.513, 28.8572}}, // Maverick County Memorial International Airport
    Airport{IataCode{"EGS"}, CountryId{"IS"}, Coordinate{-14.4064, 65.2747}}, // Egilsstaðir Airport
    Airport{IataCode{"EGV"}, CountryId{"US"}, Coordinate{-89.2683, 45.9322}}, // Eagle River Union Airport
    Airport{IataCode{"EGX"}, CountryId{"US"}, Coordinate{-157.376, 58.1856}}, // Egegik Airport
    Airport{IataCode{"EHL"}, CountryId{"AR"}, Coordinate{-71.5322, -41.9433}}, // El Bolsón Airport
    Airport{IataCode{"EHM"}, CountryId{"US"}, Coordinate{-162.063, 58.6464}}, // Cape Newenham LRRS Airport
    Airport{IataCode{"EIA"}, CountryId{"PG"}, Coordinate{147.632, -8.11676}}, // Papondetta Airport
    Airport{IataCode{"EIE"}, CountryId{"RU"}, Coordinate{92.0987, 58.464}}, // Yeniseysk Airport
    Airport{IataCode{"EIN"}, CountryId{"NL"}, Coordinate{5.39189, 51.4586}}, // Eindhoven Airport
    Airport{IataCode{"EIS"}, CountryId{"GB"}, Coordinate{-64.5372, 18.4445}}, // Terrance B. Lettsome International Airport
    Airport{IataCode{"EIY"}, CountryId{"IL"}, Coordinate{35.2032, 30.6215}}, // Ein Yahav Airfield
    Airport{IataCode{"EJA"}, CountryId{"CO"}, Coordinate{-73.8088, 7.025}}, // Yariguíes Airport
    Airport{IataCode{"EJH"}, CountryId{"SA"}, Coordinate{36.4748, 26.2076}}, // Al Wajh Domestic Airport
    Airport{IataCode{"EJN"}, CountryId{"CN"}, Coordinate{101.001, 42.0117}}, // Ejin Banner Taolai Airport
    Airport{IataCode{"EJT"}, CountryId{"MH"}, Coordinate{171.984, 6.04028}}, // Enejit Airport
    Airport{IataCode{"EKA"}, CountryId{"US"}, Coordinate{-124.113, 40.8033}}, // Murray Field
    Airport{IataCode{"EKB"}, CountryId{"KZ"}, Coordinate{75.2167, 51.5833}}, // Ekibastuz Airport
    Airport{IataCode{"EKI"}, CountryId{"US"}, Coordinate{-86.0033, 41.7194}}, // Elkhart Municipal Airport
    Airport{IataCode{"EKO"}, CountryId{"US"}, Coordinate{-115.786, 40.8276}}, // Elko Regional Airport
    Airport{IataCode{"EKS"}, CountryId{"RU"}, Coordinate{142.078, 49.1907}}, // Shakhtersk
    Airport{IataCode{"EKT"}, CountryId{"SE"}, Coordinate{16.7083, 59.35}}, // Eskilstuna Airport
    Airport{IataCode{"EKX"}, CountryId{"US"}, Coordinate{-85.925, 37.6861}}, // Elizabethtown Regional Airport
    Airport{IataCode{"ELB"}, CountryId{"CO"}, Coordinate{-73.9756, 9.04279}}, // El Banco Apt. Airport
    Airport{IataCode{"ELC"}, CountryId{"AU"}, Coordinate{135.571, -12.0193}}, // Elcho Island Airport
    Airport{IataCode{"ELD"}, CountryId{"US"}, Coordinate{-92.8133, 33.2211}}, // South Arkansas Regional Airport at Goodwin Field
    Airport{IataCode{"ELE"}, CountryId{"PA"}, Coordinate{-77.7, 8.13333}}, // El Real Airport
    Airport{IataCode{"ELF"}, CountryId{"SD"}, Coordinate{25.3244, 13.6147}}, // El Fasher Airport
    Airport{IataCode{"ELG"}, CountryId{"DZ"}, Coordinate{2.8687, 30.5715}}, // El Golea Airport
    Airport{IataCode{"ELH"}, CountryId{"BS"}, Coordinate{-76.6818, 25.4767}}, // North Eleuthera Airport
    Airport{IataCode{"ELI"}, CountryId{"US"}, Coordinate{-162.271, 64.615}}, // Elim Airport
    Airport{IataCode{"ELK"}, CountryId{"US"}, Coordinate{-99.3943, 35.4308}}, // Elk City Regional Business Airport
    Airport{IataCode{"ELM"}, CountryId{"US"}, Coordinate{-76.8956, 42.1628}}, // Elmira Corning Regional Airport
    Airport{IataCode{"ELN"}, CountryId{"US"}, Coordinate{-120.531, 47.0331}}, // Bowers Airport
    Airport{IataCode{"ELO"}, CountryId{"AR"}, Coordinate{-54.5747, -26.3969}}, // El Dorado Airport, Argentina
    Airport{IataCode{"ELP"}, CountryId{"US"}, Coordinate{-106.395, 31.7998}}, // El Paso International Airport
    Airport{IataCode{"ELQ"}, CountryId{"SA"}, Coordinate{43.7693, 26.3036}}, // Prince Nayef bin Abdulaziz Regional Airport
    Airport{IataCode{"ELS"}, CountryId{"ZA"}, Coordinate{27.8289, -33.0382}}, // East London Airport
    Airport{IataCode{"ELT"}, CountryId{"EG"}, Coordinate{33.6353, 28.2151}}, // El Tor Airport
    Airport{IataCode{"ELU"}, CountryId{"DZ"}, Coordinate{6.78486, 33.5071}}, // Guemar Airport
    Airport{IataCode{"ELX"}, CountryId{"VE"}, Coordinate{-64.2106, 8.83278}}, // El Tigre Airport
    Airport{IataCode{"ELY"}, CountryId{"US"}, Coordinate{-114.835, 39.3004}}, // Ely Airport
    Airport{IataCode{"ELZ"}, CountryId{"US"}, Coordinate{-77.99, 42.1094}}, // Wellsville Municipal Airport
    Airport{IataCode{"EMA"}, CountryId{"GB"}, Coordinate{-1.33087, 52.826}}, // East Midlands Airport
    Airport{IataCode{"EMD"}, CountryId{"AU"}, Coordinate{148.174, -23.5691}}, // Emerald Airport
    Airport{IataCode{"EMK"}, CountryId{"US"}, Coordinate{-164.491, 62.7861}}, // Emmonak Airport
    Airport{IataCode{"EMM"}, CountryId{"US"}, Coordinate{-110.555, 41.8214}}, // Kemmerer Municipal Airport
    Airport{IataCode{"EMN"}, CountryId{"MR"}, Coordinate{-7.31492, 16.6193}}, // Néma Airport
    Airport{IataCode{"EMO"}, CountryId{"PG"}, Coordinate{147.783, -8.73333}}, // Emo
    Airport{IataCode{"EMP"}, CountryId{"US"}, Coordinate{-96.1911, 38.3322}}, // Emporia Municipal Airport
    Airport{IataCode{"EMT"}, CountryId{"US"}, Coordinate{-118.035, 34.0861}}, // San Gabriel Valley Airport
    Airport{IataCode{"EMX"}, CountryId{"AR"}, Coordinate{-71.1708, -42.0333}}, // El Maitén Airport
    Airport{IataCode{"ENA"}, CountryId{"US"}, Coordinate{-151.245, 60.5733}}, // Kenai Municipal Airport
    Airport{IataCode{"ENB"}, CountryId{"AU"}, Coordinate{115.246, -29.8325}}, // Eneabba Airport
    Airport{IataCode{"ENC"}, CountryId{"FR"}, Coordinate{6.22611, 48.6922}}, // Nancy-Essey Airport
    Airport{IataCode{"ENE"}, CountryId{"ID"}, Coordinate{121.664, -8.84813}}, // H. Hasan Aroeboesman Airport
    Airport{IataCode{"ENF"}, CountryId{"FI"}, Coordinate{23.4275, 68.3644}}, // Enontekiö Airport
    Airport{IataCode{"ENH"}, CountryId{"CN"}, Coordinate{109.482, 30.3229}}, // Enshi Xujiaping Airport
    Airport{IataCode{"ENI"}, CountryId{"PH"}, Coordinate{119.416, 11.2025}}, // El Nido Airport
    Airport{IataCode{"ENJ"}, CountryId{"GT"}, Coordinate{-90.8167, 14.0833}}, // El Naranjo Airport
    Airport{IataCode{"ENK"}, CountryId{"GB"}, Coordinate{-7.64427, 54.3957}}, // Enniskillen/St Angelo Airport
    Airport{IataCode{"ENL"}, CountryId{"US"}, Coordinate{-89.092, 38.5148}}, // Centralia Municipal Airport
    Airport{IataCode{"ENN"}, CountryId{"US"}, Coordinate{-149.074, 64.5472}}, // Nenana Municipal Airport
    Airport{IataCode{"ENO"}, CountryId{"PY"}, Coordinate{-55.8338, -27.2216}}, // Teniente Amin Ayub Gonzalez Airport
    Airport{IataCode{"ENS"}, CountryId{"NL"}, Coordinate{6.89306, 52.2792}}, // Enschede Airport Twente
    Airport{IataCode{"ENT"}, CountryId{"MH"}, Coordinate{162.328, 11.3417}}, // Enewetak Auxiliary Airfield
    Airport{IataCode{"ENU"}, CountryId{"NG"}, Coordinate{7.56498, 6.4712}}, // Akanu Ibiam International Airport
    Airport{IataCode{"ENV"}, CountryId{"US"}, Coordinate{-114.041, 40.7283}}, // Wendover Airport
    Airport{IataCode{"ENW"}, CountryId{"US"}, Coordinate{-87.9278, 42.5956}}, // Kenosha Regional Airport
    Airport{IataCode{"ENY"}, CountryId{"CN"}, Coordinate{109.465, 36.4764}}, // Yan'an Nanniwan Airport
    Airport{IataCode{"EOH"}, CountryId{"CO"}, Coordinate{-75.5869, 6.21887}}, // Enrique Olaya Herrera Airport
    Airport{IataCode{"EOK"}, CountryId{"US"}, Coordinate{-91.4286, 40.46}}, // Keokuk Municipal Airport
    Airport{IataCode{"EOR"}, CountryId{"VE"}, Coordinate{-61.6389, 6.71583}}, // El Dorado, Venezuela Airport
    Airport{IataCode{"EOS"}, CountryId{"US"}, Coordinate{-94.3917, 36.8108}}, // Neosho Hugh Robinson Airport
    Airport{IataCode{"EOZ"}, CountryId{"VE"}, Coordinate{-69.4967, 7.05972}}, // Elorza Airport
    Airport{IataCode{"EPA"}, CountryId{"AR"}, Coordinate{-58.6125, -34.61}}, // El Palomar Airport
    Airport{IataCode{"EPH"}, CountryId{"US"}, Coordinate{-119.517, 47.3081}}, // Ephrata Municipal Airport
    Airport{IataCode{"EPK"}, CountryId{"CY"}, Coordinate{32.9047, 34.6725}}, // Q11824372
    Airport{IataCode{"EPL"}, CountryId{"FR"}, Coordinate{6.06298, 48.3212}}, // Épinal – Mirecourt Airport
    Airport{IataCode{"EPR"}, CountryId{"AU"}, Coordinate{121.83, -33.6828}}, // Esperance Airport
    Airport{IataCode{"EPS"}, CountryId{"DO"}, Coordinate{-69.4297, 19.1986}}, // Arroyo Barril Airport
    Airport{IataCode{"EPT"}, CountryId{"PG"}, Coordinate{141.667, -5.03333}}, // Eliptamin
    Airport{IataCode{"EPU"}, CountryId{"EE"}, Coordinate{24.4662, 58.4214}}, // Pärnu Airport
    Airport{IataCode{"EQS"}, CountryId{"AR"}, Coordinate{-71.1468, -42.9061}}, // Esquel Airport
    Airport{IataCode{"ERA"}, CountryId{"SO"}, Coordinate{47.3881, 10.6422}}, // Erigavo Airport
    Airport{IataCode{"ERC"}, CountryId{"TR"}, Coordinate{39.5219, 39.7171}}, // Erzincan Airport
    Airport{IataCode{"ERD"}, CountryId{"UA"}, Coordinate{36.7581, 46.8147}}, // Berdyansk Airport
    Airport{IataCode{"ERE"}, CountryId{"PG"}, Coordinate{143.901, -6.60706}}, // Erave Airport
    Airport{IataCode{"ERF"}, CountryId{"DE"}, Coordinate{10.9619, 50.9747}}, // Erfurt-Weimar Airport
    Airport{IataCode{"ERG"}, CountryId{"RU"}, Coordinate{108.02, 61.2748}}, // Erbogachen Airport
    Airport{IataCode{"ERH"}, CountryId{"MA"}, Coordinate{-4.40066, 31.9475}}, // Moulay Ali Cherif Airport
    Airport{IataCode{"ERI"}, CountryId{"US"}, Coordinate{-80.1808, 42.085}}, // Erie International Airport
    Airport{IataCode{"ERL"}, CountryId{"CN"}, Coordinate{112.096, 43.427}}, // Erenhot Saiwusu International Airport
    Airport{IataCode{"ERM"}, CountryId{"BR"}, Coordinate{-52.2763, -27.6596}}, // Erechim Airport
    Airport{IataCode{"ERN"}, CountryId{"BR"}, Coordinate{-69.8831, -6.6375}}, // Eirunepé Airport
    Airport{IataCode{"ERQ"}, CountryId{"AU"}, Coordinate{141.007, -20.9767}}, // Elrose Airport
    Airport{IataCode{"ERR"}, CountryId{"US"}, Coordinate{-71.1645, 44.7922}}, // Errol Airport
    Airport{IataCode{"ERS"}, CountryId{"NA"}, Coordinate{17.0814, -22.6017}}, // Eros Airport
    Airport{IataCode{"ERU"}, CountryId{"PG"}, Coordinate{147.083, -8.41667}}, // Erume
    Airport{IataCode{"ERV"}, CountryId{"US"}, Coordinate{-99.0848, 29.9782}}, // Kerrville Municipal Airport
    Airport{IataCode{"ERZ"}, CountryId{"TR"}, Coordinate{41.1792, 39.9612}}, // Erzurum Airport
    Airport{IataCode{"ESB"}, CountryId{"TR"}, Coordinate{32.9927, 40.1146}}, // Ankara Esenboğa Airport
    Airport{IataCode{"ESC"}, CountryId{"US"}, Coordinate{-87.0946, 45.718}}, // Delta County Airport
    Airport{IataCode{"ESD"}, CountryId{"US"}, Coordinate{-122.909, 48.7051}}, // Orcas Island Airport
    Airport{IataCode{"ESG"}, CountryId{"PY"}, Coordinate{-60.6217, -22.045}}, // Dr. Luis María Argaña International Airport
    Airport{IataCode{"ESH"}, CountryId{"GB"}, Coordinate{-0.290612, 50.8335}}, // Brighton City Airport
    Airport{IataCode{"ESL"}, CountryId{"RU"}, Coordinate{44.3308, 46.3695}}, // Elista Airport
    Airport{IataCode{"ESM"}, CountryId{"EC"}, Coordinate{-79.6248, 0.973957}}, // Colonel Carlos Concha Torres Airport
    Airport{IataCode{"ESN"}, CountryId{"US"}, Coordinate{-76.0648, 38.8113}}, // Easton Airport
    Airport{IataCode{"ESO"}, CountryId{"US"}, Coordinate{-106.045, 36.0261}}, // Ohkay Owingeh Airport
    Airport{IataCode{"ESP"}, CountryId{"US"}, Coordinate{-75.1606, 41.0358}}, // Stroudsburg-Pocono Airport
    Airport{IataCode{"ESR"}, CountryId{"CL"}, Coordinate{-69.7523, -26.3133}}, // Ricardo García Posada Airport
    Airport{IataCode{"ESS"}, CountryId{"DE"}, Coordinate{6.93899, 51.4068}}, // Verkehrslandeplatz Essen/Mülheim
    Airport{IataCode{"ESU"}, CountryId{"MA"}, Coordinate{-9.68823, 31.4033}}, // Mogador Airport
    Airport{IataCode{"ESW"}, CountryId{"US"}, Coordinate{-121.186, 47.2542}}, // Easton State Airport
    Airport{IataCode{"ETB"}, CountryId{"US"}, Coordinate{-88.1278, 43.4222}}, // West Bend Municipal Airport
    Airport{IataCode{"ETH"}, CountryId{"IL"}, Coordinate{34.9592, 29.5594}}, // Eilat Airport
    Airport{IataCode{"ETM"}, CountryId{"IL"}, Coordinate{34.9983, 29.7272}}, // Ramon Airport
    Airport{IataCode{"ETR"}, CountryId{"EC"}, Coordinate{-79.9778, -3.43528}}, // Santa Rosa Airport
    Airport{IataCode{"ETS"}, CountryId{"US"}, Coordinate{-85.8997, 31.2997}}, // Enterprise Municipal Airport
    Airport{IataCode{"ETZ"}, CountryId{"FR"}, Coordinate{6.24351, 48.9813}}, // Metz-Nancy-Lorraine Airport
    Airport{IataCode{"EUA"}, CountryId{"TO"}, Coordinate{-174.95, -21.3833}}, // 'Eua Airport
    Airport{IataCode{"EUC"}, CountryId{"AU"}, Coordinate{128.877, -31.7067}}, // Eucla Airport
    Airport{IataCode{"EUE"}, CountryId{"US"}, Coordinate{-116.005, 39.6042}}, // Eureka Airport
    Airport{IataCode{"EUF"}, CountryId{"US"}, Coordinate{-85.1289, 31.9514}}, // Weedon Field
    Airport{IataCode{"EUG"}, CountryId{"US"}, Coordinate{-123.213, 44.1192}}, // Eugene Airport
    Airport{IataCode{"EUN"}, CountryId{"MA"}, Coordinate{-13.2182, 27.1539}}, // Hassan I Airport
    Airport{IataCode{"EUQ"}, CountryId{"PH"}, Coordinate{121.934, 10.7676}}, // Evelio Javier Airport
    Airport{IataCode{"EUX"}, CountryId{"NL"}, Coordinate{-62.9811, 17.4932}}, // F.D. Roosevelt Airport
    Airport{IataCode{"EVE"}, CountryId{"NO"}, Coordinate{16.6865, 68.4902}}, // Harstad/Narvik Airport
    Airport{IataCode{"EVG"}, CountryId{"SE"}, Coordinate{14.4186, 62.0464}}, // Härjedalen Sveg Airport
    Airport{IataCode{"EVH"}, CountryId{"AU"}, Coordinate{153.42, -29.0933}}, // Evans Head Memorial Aerodrome
    Airport{IataCode{"EVN"}, CountryId{"AM"}, Coordinate{44.4055, 40.1521}}, // Zvartnots International Airport
    Airport{IataCode{"EVV"}, CountryId{"US"}, Coordinate{-87.5275, 38.0459}}, // Evansville Regional Airport
    Airport{IataCode{"EWB"}, CountryId{"US"}, Coordinate{-70.9569, 41.6761}}, // New Bedford Regional Airport
    Airport{IataCode{"EWE"}, CountryId{"ID"}, Coordinate{138.067, -5.48333}}, // Ewer Airport
    Airport{IataCode{"EWI"}, CountryId{"ID"}, Coordinate{136.378, -3.92583}}, // Enarotali Airport
    Airport{IataCode{"EWK"}, CountryId{"US"}, Coordinate{-97.2744, 38.0583}}, // Newton City/County Airport
    Airport{IataCode{"EWN"}, CountryId{"US"}, Coordinate{-77.0349, 35.0786}}, // Coastal Carolina Regional Airport
    Airport{IataCode{"EWO"}, CountryId{"CG"}, Coordinate{14.8, -0.898056}}, // Ewo Airport
    Airport{IataCode{"EWR"}, CountryId{"US"}, Coordinate{-74.1804, 40.6899}}, // Newark Liberty International Airport
    Airport{IataCode{"EXM"}, CountryId{"AU"}, Coordinate{114.1, -22.0333}}, // Exmouth Gulf Airport
    Airport{IataCode{"EXT"}, CountryId{"GB"}, Coordinate{-3.41664, 50.7312}}, // Exeter Airport
    Airport{IataCode{"EYK"}, CountryId{"RU"}, Coordinate{66.6831, 63.6831}}, // Beloyarsk Airport
    Airport{IataCode{"EYL"}, CountryId{"ML"}, Coordinate{-10.567, 15.133}}, // Yélimané Airport
    Airport{IataCode{"EYP"}, CountryId{"CO"}, Coordinate{-72.3845, 5.32258}}, // El Alcaraván Airport
    Airport{IataCode{"EYR"}, CountryId{"US"}, Coordinate{-119.158, 39.0042}}, // Yerington Municipal Airport
    Airport{IataCode{"EYS"}, CountryId{"KE"}, Coordinate{35.9744, 3.23639}}, // Eliye Springs Airport
    Airport{IataCode{"EYW"}, CountryId{"US"}, Coordinate{-81.7551, 24.5538}}, // Key West International Airport
    Airport{IataCode{"EZE"}, CountryId{"AR"}, Coordinate{-58.5407, -34.814}}, // Ministro Pistarini International Airport
    Airport{IataCode{"EZS"}, CountryId{"TR"}, Coordinate{39.268, 38.6002}}, // Elazığ Airport
    Airport{IataCode{"FAA"}, CountryId{"GN"}, Coordinate{-10.7698, 10.0355}}, // Faranah Airport
    Airport{IataCode{"FAC"}, CountryId{"FR"}, Coordinate{-145.333, -16.6876}}, // Faaite Airport
    Airport{IataCode{"FAE"}, CountryId{"FO"}, Coordinate{-7.27804, 62.0673}}, // Vágar Airport
    Airport{IataCode{"FAG"}, CountryId{"IS"}, Coordinate{-16.6417, 63.875}}, // Fagurhólsmýri Airport
    Airport{IataCode{"FAH"}, CountryId{"AF"}, Coordinate{62.1655, 32.3662}}, // Farah Airport
    Airport{IataCode{"FAI"}, CountryId{"US"}, Coordinate{-147.856, 64.815}}, // Fairbanks International Airport
    Airport{IataCode{"FAN"}, CountryId{"NO"}, Coordinate{6.625, 58.1003}}, // Farsund Airport
    Airport{IataCode{"FAO"}, CountryId{"PT"}, Coordinate{-7.96826, 37.02}}, // Faro Airport
    Airport{IataCode{"FAQ"}, CountryId{"PG"}, Coordinate{141.96, -4.609}}, // Frieda River Airport
    Airport{IataCode{"FAR"}, CountryId{"US"}, Coordinate{-96.8257, 46.9199}}, // Hector International Airport
    Airport{IataCode{"FAS"}, CountryId{"IS"}, Coordinate{-14.05, 64.9319}}, // Fáskrúðsfjörður Airport
    Airport{IataCode{"FAT"}, CountryId{"US"}, Coordinate{-119.719, 36.7705}}, // Fresno Yosemite International Airport
    Airport{IataCode{"FAV"}, CountryId{"FR"}, Coordinate{-145.653, -16.0534}}, // Fakarava Airport
    Airport{IataCode{"FAY"}, CountryId{"US"}, Coordinate{-78.8872, 34.991}}, // Fayetteville Regional Airport
    Airport{IataCode{"FAZ"}, CountryId{"IR"}, Coordinate{53.7233, 28.8917}}, // Fasa Airport
    Airport{IataCode{"FBA"}, CountryId{"BR"}, Coordinate{-66.0672, -2.53361}}, // Fonte Boa Airport
    Airport{IataCode{"FBD"}, CountryId{"AF"}, Coordinate{70.5183, 37.1194}}, // Fayzabad Airport
    Airport{IataCode{"FBE"}, CountryId{"BR"}, Coordinate{-53.0639, -26.0594}}, // Francisco Beltrão Airport
    Airport{IataCode{"FBM"}, CountryId{"CD"}, Coordinate{27.5313, -11.588}}, // Lubumbashi International Airport
    Airport{IataCode{"FCA"}, CountryId{"US"}, Coordinate{-114.253, 48.3076}}, // Glacier Park International Airport
    Airport{IataCode{"FCB"}, CountryId{"ZA"}, Coordinate{27.9089, -28.8231}}, // Ficksburg Sentraoes Airport
    Airport{IataCode{"FCH"}, CountryId{"US"}, Coordinate{-119.82, 36.7322}}, // Fresno Chandler Executive Airport
    Airport{IataCode{"FCM"}, CountryId{"US"}, Coordinate{-93.4465, 44.8282}}, // Flying Cloud Airport
    Airport{IataCode{"FCN"}, CountryId{"DE"}, Coordinate{8.66417, 53.7683}}, // Sea-Airport Cuxhaven/Nordholz
    Airport{IataCode{"FCO"}, CountryId{"IT"}, Coordinate{12.2519, 41.7934}}, // Leonardo da Vinci–Fiumicino Airport
    Airport{IataCode{"FCY"}, CountryId{"US"}, Coordinate{-90.775, 34.9419}}, // Forrest City Municipal Airport
    Airport{IataCode{"FDE"}, CountryId{"NO"}, Coordinate{5.76426, 61.3911}}, // Førde Airport
    Airport{IataCode{"FDF"}, CountryId{"FR"}, Coordinate{-61.0003, 14.5954}}, // Martinique Aimé Césaire International Airport
    Airport{IataCode{"FDH"}, CountryId{"DE"}, Coordinate{9.52386, 47.6723}}, // Friedrichshafen Airport
    Airport{IataCode{"FDK"}, CountryId{"US"}, Coordinate{-77.3796, 39.417}}, // Frederick Municipal Airport
    Airport{IataCode{"FDO"}, CountryId{"AR"}, Coordinate{-58.584, -34.4559}}, // San Fernando Airport
    Airport{IataCode{"FDR"}, CountryId{"US"}, Coordinate{-98.9839, 34.3522}}, // Frederick Regional Airport
    Airport{IataCode{"FDU"}, CountryId{"CD"}, Coordinate{17.3817, -3.31139}}, // Bandundu Airport
    Airport{IataCode{"FDY"}, CountryId{"US"}, Coordinate{-83.6692, 41.0202}}, // Findlay Airport
    Airport{IataCode{"FEB"}, CountryId{"NP"}, Coordinate{81.2167, 29.2333}}, // Sanfebagar Airport
    Airport{IataCode{"FEG"}, CountryId{"UZ"}, Coordinate{71.7518, 40.3759}}, // Fergana International Airport
    Airport{IataCode{"FEJ"}, CountryId{"BR"}, Coordinate{-70.3472, -8.14083}}, // Feijó Airport
    Airport{IataCode{"FEK"}, CountryId{"CI"}, Coordinate{-5.2, 9.6}}, // Ferkessédougou Airport
    Airport{IataCode{"FEN"}, CountryId{"BR"}, Coordinate{-32.4286, -3.85646}}, // Fernando de Noronha Airport
    Airport{IataCode{"FEP"}, CountryId{"US"}, Coordinate{-89.5819, 42.2461}}, // Albertus Airport
    Airport{IataCode{"FET"}, CountryId{"US"}, Coordinate{-96.5203, 41.4492}}, // Fremont Municipal Airport
    Airport{IataCode{"FEZ"}, CountryId{"MA"}, Coordinate{-4.98344, 33.9306}}, // Fes-Saïss Airport
    Airport{IataCode{"FFA"}, CountryId{"US"}, Coordinate{-75.6714, 36.0183}}, // First Flight Airport
    Airport{IataCode{"FFL"}, CountryId{"US"}, Coordinate{-91.9808, 41.0558}}, // Fairfield Municipal Airport
    Airport{IataCode{"FFM"}, CountryId{"US"}, Coordinate{-96.1567, 46.2844}}, // Fergus Falls Municipal Airport
    Airport{IataCode{"FFT"}, CountryId{"US"}, Coordinate{-84.9061, 38.1819}}, // Capital City Airport
    Airport{IataCode{"FFU"}, CountryId{"CL"}, Coordinate{-71.8544, -43.1886}}, // Futaleufu Airport
    Airport{IataCode{"FGD"}, CountryId{"MR"}, Coordinate{-12.733, 22.667}}, // Fderik Airport
    Airport{IataCode{"FGI"}, CountryId{"WS"}, Coordinate{-171.742, -13.8478}}, // Fagali'i Airport
    Airport{IataCode{"FGL"}, CountryId{"NZ"}, Coordinate{170.02, -43.4621}}, // Fox Glacier Heliport
    Airport{IataCode{"FGU"}, CountryId{"FR"}, Coordinate{-140.887, -15.8197}}, // Fangatau Airport
    Airport{IataCode{"FHZ"}, CountryId{"FR"}, Coordinate{-140.165, -15.9922}}, // Fakahina Airport
    Airport{IataCode{"FID"}, CountryId{"US"}, Coordinate{-72.0317, 41.2514}}, // Elizabeth Field
    Airport{IataCode{"FIG"}, CountryId{"GN"}, Coordinate{-13.5692, 10.3506}}, // Fria Airport
    Airport{IataCode{"FIH"}, CountryId{"CD"}, Coordinate{15.445, -4.39161}}, // N'djili Airport
    Airport{IataCode{"FIL"}, CountryId{"US"}, Coordinate{-112.363, 38.9581}}, // Fillmore Municipal Airport
    Airport{IataCode{"FIN"}, CountryId{"PG"}, Coordinate{147.854, -6.62229}}, // Finschhafen Airport
    Airport{IataCode{"FIZ"}, CountryId{"AU"}, Coordinate{125.559, -18.182}}, // Fitzroy Crossing Airport
    Airport{IataCode{"FJR"}, CountryId{"AE"}, Coordinate{56.3336, 25.1122}}, // Fujairah International Airport
    Airport{IataCode{"FKB"}, CountryId{"DE"}, Coordinate{8.08742, 48.7782}}, // Baden Airport
    Airport{IataCode{"FKI"}, CountryId{"CD"}, Coordinate{25.3302, 0.492208}}, // Bangoka International Airport
    Airport{IataCode{"FKJ"}, CountryId{"JP"}, Coordinate{136.224, 36.1428}}, // Fukui Airport
    Airport{IataCode{"FKL"}, CountryId{"US"}, Coordinate{-79.8603, 41.3778}}, // Venango Regional Airport
    Airport{IataCode{"FKN"}, CountryId{"US"}, Coordinate{-76.9001, 36.6943}}, // Franklin Municipal-John Beverly Rose Airport
    Airport{IataCode{"FKQ"}, CountryId{"ID"}, Coordinate{132.267, -2.92}}, // Fakfak Airport
    Airport{IataCode{"FKS"}, CountryId{"JP"}, Coordinate{140.428, 37.2275}}, // Fukushima Airport
    Airport{IataCode{"FLA"}, CountryId{"CO"}, Coordinate{-75.5605, 1.5892}}, // Gustavo Artunduaga Paredes Airport
    Airport{IataCode{"FLB"}, CountryId{"BR"}, Coordinate{-43.0781, -6.84611}}, // Floriano Airport
    Airport{IataCode{"FLD"}, CountryId{"US"}, Coordinate{-88.4843, 43.7697}}, // Fond du Lac County Airport
    Airport{IataCode{"FLG"}, CountryId{"US"}, Coordinate{-111.675, 35.1389}}, // Flagstaff Pulliam Airport
    Airport{IataCode{"FLL"}, CountryId{"US"}, Coordinate{-80.1528, 26.0725}}, // Fort Lauderdale–Hollywood International Airport
    Airport{IataCode{"FLN"}, CountryId{"BR"}, Coordinate{-48.5428, -27.6695}}, // Florianópolis International Airport
    Airport{IataCode{"FLO"}, CountryId{"US"}, Coordinate{-79.7284, 34.1931}}, // Florence Regional Airport
    Airport{IataCode{"FLP"}, CountryId{"US"}, Coordinate{-92.5903, 36.2908}}, // Marion County Regional Airport
    Airport{IataCode{"FLR"}, CountryId{"IT"}, Coordinate{11.2006, 43.8022}}, // Florence Airport, Peretola
    Airport{IataCode{"FLS"}, CountryId{"AU"}, Coordinate{148.005, -40.0914}}, // Flinders Island Airport
    Airport{IataCode{"FLT"}, CountryId{"HT"}, Coordinate{-71.9003, 19.6775}}, // Phaeton Airport
    Airport{IataCode{"FLU"}, CountryId{"US"}, Coordinate{-73.8333, 40.7792}}, // Flushing Airport
    Airport{IataCode{"FLW"}, CountryId{"PT"}, Coordinate{-31.1312, 39.459}}, // Flores Airport
    Airport{IataCode{"FLX"}, CountryId{"US"}, Coordinate{-118.749, 39.4992}}, // Fallon Municipal Airport
    Airport{IataCode{"FLY"}, CountryId{"US"}, Coordinate{-104.57, 38.9458}}, // Meadow Lake Airport
    Airport{IataCode{"FMA"}, CountryId{"AR"}, Coordinate{-58.2306, -26.2142}}, // Formosa International Airport
    Airport{IataCode{"FME"}, CountryId{"US"}, Coordinate{-76.7594, 39.0853}}, // Tipton Airport
    Airport{IataCode{"FMI"}, CountryId{"CD"}, Coordinate{29.25, -5.87556}}, // Kalemie Airport
    Airport{IataCode{"FMM"}, CountryId{"DE"}, Coordinate{10.2325, 47.9895}}, // Memmingen Airport
    Airport{IataCode{"FMN"}, CountryId{"US"}, Coordinate{-108.23, 36.7411}}, // Four Corners Regional Airport
    Airport{IataCode{"FMO"}, CountryId{"DE"}, Coordinate{7.69321, 52.131}}, // Münster Osnabrück International Airport
    Airport{IataCode{"FMU"}, CountryId{"US"}, Coordinate{-124.111, 43.9828}}, // Florence Municipal Airport
    Airport{IataCode{"FMY"}, CountryId{"US"}, Coordinate{-81.8633, 26.5867}}, // Page Field
    Airport{IataCode{"FNA"}, CountryId{"SL"}, Coordinate{-13.2006, 8.61538}}, // Lungi International Airport
    Airport{IataCode{"FNB"}, CountryId{"DE"}, Coordinate{13.2995, 53.6045}}, // Neubrandenburg Airport
    Airport{IataCode{"FNC"}, CountryId{"PT"}, Coordinate{-16.7755, 32.6934}}, // Madeira Airport
    Airport{IataCode{"FND"}, CountryId{"MV"}, Coordinate{73.2872, 6.16111}}, // Funadhoo Airport
    Airport{IataCode{"FNE"}, CountryId{"PG"}, Coordinate{147.085, -8.6}}, // Fane Airport
    Airport{IataCode{"FNG"}, CountryId{"BF"}, Coordinate{0.35, 12.033}}, // Fada N'gourma Airport
    Airport{IataCode{"FNH"}, CountryId{"ET"}, Coordinate{37.3764, 9.58333}}, // Fincha Airport
    Airport{IataCode{"FNI"}, CountryId{"FR"}, Coordinate{4.42148, 43.763}}, // Nîmes-Alès-Camargue-Cévennes Airport
    Airport{IataCode{"FNJ"}, CountryId{"KP"}, Coordinate{125.677, 39.201}}, // Pyongyang International Airport
    Airport{IataCode{"FNL"}, CountryId{"US"}, Coordinate{-105.008, 40.45}}, // Fort Collins–Loveland Municipal Airport
    Airport{IataCode{"FNT"}, CountryId{"US"}, Coordinate{-83.7388, 42.973}}, // Bishop International Airport
    Airport{IataCode{"FNU"}, CountryId{"IT"}, Coordinate{8.64079, 39.8988}}, // Oristano-Fenosu Airport
    Airport{IataCode{"FOC"}, CountryId{"CN"}, Coordinate{119.668, 25.933}}, // Fuzhou Changle International Airport
    Airport{IataCode{"FOD"}, CountryId{"US"}, Coordinate{-94.183, 42.5521}}, // Fort Dodge Regional Airport
    Airport{IataCode{"FOG"}, CountryId{"IT"}, Coordinate{15.544, 41.434}}, // Foggia "Gino Lisa" Airport
    Airport{IataCode{"FOK"}, CountryId{"US"}, Coordinate{-72.6409, 40.8432}}, // Francis S. Gabreski Airport
    Airport{IataCode{"FON"}, CountryId{"CR"}, Coordinate{-84.5817, 10.4695}}, // El Tanque Airport
    Airport{IataCode{"FOO"}, CountryId{"ID"}, Coordinate{134.872, -0.936389}}, // Kornasoren Airport
    Airport{IataCode{"FOR"}, CountryId{"BR"}, Coordinate{-38.5383, -3.77634}}, // Pinto Martins – Fortaleza International Airport
    Airport{IataCode{"FOS"}, CountryId{"AU"}, Coordinate{128.115, -30.8383}}, // Forrest Airport
    Airport{IataCode{"FOT"}, CountryId{"AU"}, Coordinate{152.479, -32.2042}}, // Forster airport
    Airport{IataCode{"FOY"}, CountryId{"LR"}, Coordinate{-10.2264, 8.35222}}, // Foya Airport
    Airport{IataCode{"FPO"}, CountryId{"BS"}, Coordinate{-78.7037, 26.548}}, // Grand Bahama International Airport
    Airport{IataCode{"FPR"}, CountryId{"US"}, Coordinate{-80.3656, 27.4883}}, // Treasure Coast International Airport
    Airport{IataCode{"FPY"}, CountryId{"US"}, Coordinate{-83.5748, 30.0776}}, // Perry-Foley Airport
    Airport{IataCode{"FRA"}, CountryId{"DE"}, Coordinate{8.57175, 50.0513}}, // Frankfurt Airport
    Airport{IataCode{"FRB"}, CountryId{"AU"}, Coordinate{147.935, -33.3633}}, // Forbes Airport
    Airport{IataCode{"FRC"}, CountryId{"BR"}, Coordinate{-47.3825, -20.5903}}, // Franca Airport
    Airport{IataCode{"FRD"}, CountryId{"US"}, Coordinate{-123.026, 48.5248}}, // Friday Harbor Airport
    Airport{IataCode{"FRE"}, CountryId{"SB"}, Coordinate{159.577, -8.10722}}, // Fera Airport
    Airport{IataCode{"FRG"}, CountryId{"US"}, Coordinate{-73.4213, 40.7295}}, // Republic Airport
    Airport{IataCode{"FRH"}, CountryId{"US"}, Coordinate{-86.64, 38.5035}}, // French Lick Municipal Airport
    Airport{IataCode{"FRJ"}, CountryId{"FR"}, Coordinate{6.73556, 43.4172}}, // Frejus Airport
    Airport{IataCode{"FRK"}, CountryId{"SC"}, Coordinate{55.9463, -4.58389}}, // Frégate Island Airport
    Airport{IataCode{"FRL"}, CountryId{"IT"}, Coordinate{12.0715, 44.198}}, // Forlì Airport
    Airport{IataCode{"FRM"}, CountryId{"US"}, Coordinate{-94.4156, 43.6439}}, // Fairmont Municipal Airport
    Airport{IataCode{"FRO"}, CountryId{"NO"}, Coordinate{5.02472, 61.5836}}, // Florø Airport
    Airport{IataCode{"FRQ"}, CountryId{"PG"}, Coordinate{141.699, -5.20836}}, // Feramin Airport
    Airport{IataCode{"FRR"}, CountryId{"US"}, Coordinate{-78.2533, 38.9175}}, // Front Royal-Warren County Airport
    Airport{IataCode{"FRS"}, CountryId{"GT"}, Coordinate{-89.8774, 16.9148}}, // Mundo Maya International Airport
    Airport{IataCode{"FRT"}, CountryId{"CL"}, Coordinate{-73.065, -41.128}}, // Frutillar Airport
    Airport{IataCode{"FRU"}, CountryId{"KG"}, Coordinate{74.4689, 43.0538}}, // Manas International Airport
    Airport{IataCode{"FRW"}, CountryId{"BW"}, Coordinate{27.4802, -21.1583}}, // Francistown Airport
    Airport{IataCode{"FRY"}, CountryId{"US"}, Coordinate{-70.9478, 43.9911}}, // Eastern Slopes Regional Airport
    Airport{IataCode{"FSC"}, CountryId{"FR"}, Coordinate{9.09815, 41.4989}}, // Figari Sud-Corse Airport
    Airport{IataCode{"FSD"}, CountryId{"US"}, Coordinate{-96.7322, 43.5801}}, // Sioux Falls Regional Airport
    Airport{IataCode{"FSK"}, CountryId{"US"}, Coordinate{-94.7694, 37.7983}}, // Fort Scott Municipal Airport
    Airport{IataCode{"FSM"}, CountryId{"US"}, Coordinate{-94.3588, 35.3407}}, // Fort Smith Regional Airport
    Airport{IataCode{"FSP"}, CountryId{"FR"}, Coordinate{-56.1793, 46.7649}}, // Saint-Pierre Airport
    Airport{IataCode{"FST"}, CountryId{"US"}, Coordinate{-102.913, 30.9094}}, // Fort Stockton-Pecos County Airport
    Airport{IataCode{"FSU"}, CountryId{"US"}, Coordinate{-104.216, 34.4878}}, // Fort Sumner Municipal Airport
    Airport{IataCode{"FSZ"}, CountryId{"JP"}, Coordinate{138.179, 34.7953}}, // Shizuoka Airport
    Airport{IataCode{"FTA"}, CountryId{"VU"}, Coordinate{170.232, -19.5164}}, // Futuna Airport
    Airport{IataCode{"FTE"}, CountryId{"AR"}, Coordinate{-72.0538, -50.2839}}, // Comandante Armando Tola International Airport
    Airport{IataCode{"FTI"}, CountryId{"US"}, Coordinate{-169.424, -14.2161}}, // Fitiuta Airport
    Airport{IataCode{"FTU"}, CountryId{"MG"}, Coordinate{46.9545, -25.0365}}, // Tôlanaro Airport
    Airport{IataCode{"FTW"}, CountryId{"US"}, Coordinate{-97.3543, 32.8221}}, // Fort Worth Meacham International Airport
    Airport{IataCode{"FTX"}, CountryId{"CG"}, Coordinate{15.95, -0.531389}}, // Owando Airport
    Airport{IataCode{"FTY"}, CountryId{"US"}, Coordinate{-84.5214, 33.7792}}, // Fulton County Airport
    Airport{IataCode{"FUE"}, CountryId{"ES"}, Coordinate{-13.8694, 28.4495}}, // Fuerteventura Airport
    Airport{IataCode{"FUG"}, CountryId{"CN"}, Coordinate{115.738, 32.8792}}, // Fuyang Xiguan Airport
    Airport{IataCode{"FUJ"}, CountryId{"JP"}, Coordinate{128.837, 32.6683}}, // Fukue Airport
    Airport{IataCode{"FUK"}, CountryId{"JP"}, Coordinate{130.448, 33.5973}}, // Fukuoka Airport
    Airport{IataCode{"FUL"}, CountryId{"US"}, Coordinate{-117.98, 33.872}}, // Fullerton Municipal Airport
    Airport{IataCode{"FUM"}, CountryId{"PG"}, Coordinate{142.433, -6.38333}}, // Fuma
    Airport{IataCode{"FUN"}, CountryId{"TV"}, Coordinate{179.195, -8.52458}}, // Funafuti International Airport
    Airport{IataCode{"FUO"}, CountryId{"CN"}, Coordinate{113.071, 23.0825}}, // Foshan Shadi Airport
    Airport{IataCode{"FUT"}, CountryId{"FR"}, Coordinate{-178.069, -14.3111}}, // Pointe Vele Airport
    Airport{IataCode{"FVM"}, CountryId{"MV"}, Coordinate{73.4325, -0.309444}}, // Fuvahmulah Airport
    Airport{IataCode{"FWA"}, CountryId{"US"}, Coordinate{-85.1877, 40.9866}}, // Fort Wayne International Airport
    Airport{IataCode{"FXE"}, CountryId{"US"}, Coordinate{-80.1708, 26.1972}}, // Fort Lauderdale Executive Airport
    Airport{IataCode{"FXO"}, CountryId{"MZ"}, Coordinate{36.5283, -14.8175}}, // Cuamba Airport
    Airport{IataCode{"FXY"}, CountryId{"US"}, Coordinate{-93.6242, 43.2347}}, // Forest City Municipal Airport
    Airport{IataCode{"FYJ"}, CountryId{"CN"}, Coordinate{134.364, 48.2028}}, // Fuyuan Dongji Airport
    Airport{IataCode{"FYM"}, CountryId{"US"}, Coordinate{-86.5639, 35.0597}}, // Fayetteville Municipal Airport
    Airport{IataCode{"FYN"}, CountryId{"CN"}, Coordinate{89.5079, 46.8011}}, // Fuyun Koktokay Airport
    Airport{IataCode{"FYT"}, CountryId{"TD"}, Coordinate{19.1108, 17.9143}}, // Faya-Largeau Airport
    Airport{IataCode{"FYU"}, CountryId{"US"}, Coordinate{-145.246, 66.5725}}, // Fort Yukon Airport
    Airport{IataCode{"FYV"}, CountryId{"US"}, Coordinate{-94.172, 36.0034}}, // Drake Field
    Airport{IataCode{"FZD"}, CountryId{"IN"}, Coordinate{82.155, 26.7511}}, // Faizabad Airport
    Airport{IataCode{"FZO"}, CountryId{"GB"}, Coordinate{-2.59361, 51.5194}}, // Bristol Filton Airport
    Airport{IataCode{"GAA"}, CountryId{"CO"}, Coordinate{-74.2223, 9.15227}}, // Guamal Airport
    Airport{IataCode{"GAB"}, CountryId{"US"}, Coordinate{-117.959, 38.9242}}, // Gabbs Airport
    Airport{IataCode{"GAC"}, CountryId{"HN"}, Coordinate{-88.5958, 14.5736}}, // Celaque Airport (Gracias Airstrip)
    Airport{IataCode{"GAD"}, CountryId{"US"}, Coordinate{-86.0821, 33.9719}}, // Northeast Alabama Regional Airport
    Airport{IataCode{"GAE"}, CountryId{"TN"}, Coordinate{9.92103, 33.74}}, // Gabès – Matmata International Airport
    Airport{IataCode{"GAF"}, CountryId{"TN"}, Coordinate{8.81983, 34.4274}}, // Gafsa – Ksar International Airport
    Airport{IataCode{"GAG"}, CountryId{"US"}, Coordinate{-99.7764, 36.2956}}, // Gage Airport
    Airport{IataCode{"GAH"}, CountryId{"AU"}, Coordinate{151.62, -25.6153}}, // Gayndah Airport
    Airport{IataCode{"GAI"}, CountryId{"US"}, Coordinate{-77.1614, 39.1673}}, // Montgomery County Airpark
    Airport{IataCode{"GAJ"}, CountryId{"JP"}, Coordinate{140.371, 38.4119}}, // Yamagata Airport
    Airport{IataCode{"GAL"}, CountryId{"US"}, Coordinate{-156.938, 64.7361}}, // Edward G. Pitka Sr. Airport
    Airport{IataCode{"GAM"}, CountryId{"US"}, Coordinate{-171.733, 63.7667}}, // Gambell Airport
    Airport{IataCode{"GAN"}, CountryId{"MV"}, Coordinate{73.1563, -0.690309}}, // Gan International Airport
    Airport{IataCode{"GAO"}, CountryId{"CU"}, Coordinate{-75.1577, 20.0785}}, // Mariana Grajales Airport
    Airport{IataCode{"GAP"}, CountryId{"PG"}, Coordinate{145.964, -6.05609}}, // Gusap Airport
    Airport{IataCode{"GAQ"}, CountryId{"ML"}, Coordinate{-0.0064189, 16.2516}}, // Gao International Airport
    Airport{IataCode{"GAR"}, CountryId{"PG"}, Coordinate{147.1, -7.87}}, // Garaina
    Airport{IataCode{"GAS"}, CountryId{"KE"}, Coordinate{39.6483, -0.463428}}, // Garissa Airport
    Airport{IataCode{"GAT"}, CountryId{"FR"}, Coordinate{6.03667, 44.4539}}, // Gap – Tallard Airport
    Airport{IataCode{"GAW"}, CountryId{"MM"}, Coordinate{94.1344, 22.1747}}, // Gangaw airport
    Airport{IataCode{"GAX"}, CountryId{"GA"}, Coordinate{9.99583, -2.76583}}, // Gamba Airport
    Airport{IataCode{"GAY"}, CountryId{"IN"}, Coordinate{84.9438, 24.7489}}, // Gaya Airport
    Airport{IataCode{"GAZ"}, CountryId{"PG"}, Coordinate{152.95, -9.23333}}, // Guasopa Airport
    Airport{IataCode{"GBB"}, CountryId{"AZ"}, Coordinate{47.7125, 40.8267}}, // Qabala Airport
    Airport{IataCode{"GBC"}, CountryId{"PG"}, Coordinate{141.733, -6.1}}, // Gasuke
    Airport{IataCode{"GBD"}, CountryId{"US"}, Coordinate{-98.8592, 38.3442}}, // Great Bend Municipal Airport
    Airport{IataCode{"GBE"}, CountryId{"BW"}, Coordinate{25.9239, -24.5575}}, // Sir Seretse Khama International Airport
    Airport{IataCode{"GBF"}, CountryId{"PG"}, Coordinate{144.667, -6.58333}}, // Negarbo
    Airport{IataCode{"GBG"}, CountryId{"US"}, Coordinate{-90.4301, 40.9446}}, // Galesburg Municipal Airport
    Airport{IataCode{"GBH"}, CountryId{"US"}, Coordinate{-149.49, 68.4797}}, // Galbraith Lake Airport
    Airport{IataCode{"GBI"}, CountryId{"IN"}, Coordinate{76.9517, 17.3069}}, // Gulbarga Airport
    Airport{IataCode{"GBJ"}, CountryId{"FR"}, Coordinate{-61.2725, 15.8695}}, // Marie-Galante Airport
    Airport{IataCode{"GBK"}, CountryId{"SL"}, Coordinate{-12.3833, 7.76667}}, // Gbangbatoke Airport
    Airport{IataCode{"GBL"}, CountryId{"AU"}, Coordinate{133.382, -11.65}}, // South Goulburn Island Airport
    Airport{IataCode{"GBM"}, CountryId{"SO"}, Coordinate{42.2131, 3.32278}}, // Garbaharey Airport
    Airport{IataCode{"GBR"}, CountryId{"US"}, Coordinate{-73.4032, 42.1842}}, // Walter J. Koladza Airport
    Airport{IataCode{"GBT"}, CountryId{"IR"}, Coordinate{54.4099, 36.9081}}, // Gorgan Airport
    Airport{IataCode{"GBU"}, CountryId{"SD"}, Coordinate{35.878, 14.925}}, // Khashm El Girba Airport
    Airport{IataCode{"GBZ"}, CountryId{"NZ"}, Coordinate{175.468, -36.241}}, // Great Barrier Aerodrome
    Airport{IataCode{"GCC"}, CountryId{"US"}, Coordinate{-105.533, 44.3463}}, // Gillette–Campbell County Airport
    Airport{IataCode{"GCH"}, CountryId{"IR"}, Coordinate{50.8281, 30.3375}}, // Gachsaran Airport
    Airport{IataCode{"GCI"}, CountryId{"GB"}, Coordinate{-2.59554, 49.4322}}, // Guernsey Airport
    Airport{IataCode{"GCJ"}, CountryId{"ZA"}, Coordinate{28.14, -25.9871}}, // Grand Central Airport
    Airport{IataCode{"GCK"}, CountryId{"US"}, Coordinate{-100.72, 37.9269}}, // Garden City Regional Airport
    Airport{IataCode{"GCM"}, CountryId{"GB"}, Coordinate{-81.3577, 19.2959}}, // Owen Roberts International Airport
    Airport{IataCode{"GCN"}, CountryId{"US"}, Coordinate{-112.133, 35.961}}, // Grand Canyon National Park Airport
    Airport{IataCode{"GCT"}, CountryId{"US"}, Coordinate{-113.231, 36.258}}, // Grand Canyon Bar 10 Airport
    Airport{IataCode{"GCW"}, CountryId{"US"}, Coordinate{-113.816, 35.9903}}, // Grand Canyon West Airport
    Airport{IataCode{"GCY"}, CountryId{"US"}, Coordinate{-82.815, 36.1931}}, // Greeneville-Greene County Municipal Airport
    Airport{IataCode{"GDC"}, CountryId{"US"}, Coordinate{-82.3764, 34.7566}}, // Donaldson Center Airport
    Airport{IataCode{"GDE"}, CountryId{"ET"}, Coordinate{43.5786, 5.93528}}, // Gode Airport
    Airport{IataCode{"GDG"}, CountryId{"RU"}, Coordinate{125.8, 53.4667}}, // Magdagachi Airport
    Airport{IataCode{"GDJ"}, CountryId{"CD"}, Coordinate{23.95, -6.73333}}, // Gandajika Airport
    Airport{IataCode{"GDL"}, CountryId{"MX"}, Coordinate{-103.302, 20.5253}}, // Miguel Hidalgo y Costilla Guadalajara International Airport
    Airport{IataCode{"GDM"}, CountryId{"US"}, Coordinate{-72.0161, 42.55}}, // Gardner Municipal Airport
    Airport{IataCode{"GDN"}, CountryId{"PL"}, Coordinate{18.4653, 54.383}}, // Gdańsk Lech Wałęsa Airport
    Airport{IataCode{"GDO"}, CountryId{"VE"}, Coordinate{-70.7582, 7.21}}, // Guasdualito Airport
    Airport{IataCode{"GDP"}, CountryId{"BR"}, Coordinate{-43.5822, -6.78222}}, // Guadalupe Airport
    Airport{IataCode{"GDQ"}, CountryId{"ET"}, Coordinate{37.4309, 12.5164}}, // Gondar Airport
    Airport{IataCode{"GDT"}, CountryId{"TC"}, Coordinate{-71.1462, 21.4421}}, // JAGS McCartney International Airport
    Airport{IataCode{"GDV"}, CountryId{"US"}, Coordinate{-104.809, 47.1362}}, // Dawson Community Airport
    Airport{IataCode{"GDW"}, CountryId{"US"}, Coordinate{-84.475, 43.9706}}, // Gladwin Zettel Memorial Airport
    Airport{IataCode{"GDX"}, CountryId{"RU"}, Coordinate{150.731, 59.9143}}, // Sokol Airport
    Airport{IataCode{"GDZ"}, CountryId{"RU"}, Coordinate{38.0253, 44.5938}}, // Gelendzhik Airport
    Airport{IataCode{"GEA"}, CountryId{"FR"}, Coordinate{166.471, -22.2609}}, // Nouméa Magenta Airport
    Airport{IataCode{"GED"}, CountryId{"US"}, Coordinate{-75.3589, 38.6892}}, // Delaware Coastal Airport
    Airport{IataCode{"GEE"}, CountryId{"AU"}, Coordinate{146.84, -41.08}}, // George Town Aerodrome
    Airport{IataCode{"GEL"}, CountryId{"BR"}, Coordinate{-54.171, -28.2804}}, // Santo Ângelo Airport
    Airport{IataCode{"GEO"}, CountryId{"GY"}, Coordinate{-58.2527, 6.50402}}, // Cheddi Jagan International Airport
    Airport{IataCode{"GER"}, CountryId{"CU"}, Coordinate{-82.7817, 21.8387}}, // Rafael Cabrera Mustelier Airport
    Airport{IataCode{"GES"}, CountryId{"PH"}, Coordinate{125.1, 6.05756}}, // General Santos International Airport
    Airport{IataCode{"GET"}, CountryId{"AU"}, Coordinate{114.702, -28.7961}}, // Geraldton Airport
    Airport{IataCode{"GEV"}, CountryId{"SE"}, Coordinate{20.8122, 67.1331}}, // Gällivare Airport
    Airport{IataCode{"GEX"}, CountryId{"AU"}, Coordinate{144.333, -38.2253}}, // Geelong Airport
    Airport{IataCode{"GFD"}, CountryId{"US"}, Coordinate{-85.7361, 39.7903}}, // Pope Field
    Airport{IataCode{"GFF"}, CountryId{"AU"}, Coordinate{146.062, -34.2553}}, // Griffith Airport
    Airport{IataCode{"GFK"}, CountryId{"US"}, Coordinate{-97.1767, 47.9429}}, // Grand Forks International Airport
    Airport{IataCode{"GFL"}, CountryId{"US"}, Coordinate{-73.6103, 43.3411}}, // Floyd Bennett Memorial Airport
    Airport{IataCode{"GFN"}, CountryId{"AU"}, Coordinate{152.918, -29.7483}}, // Clarence Valley Regional Airport
    Airport{IataCode{"GFO"}, CountryId{"GY"}, Coordinate{-58.6541, 6.36018}}, // Bartica Airport
    Airport{IataCode{"GFY"}, CountryId{"NA"}, Coordinate{18.1228, -19.6022}}, // Grootfontein Airport
    Airport{IataCode{"GGC"}, CountryId{"AO"}, Coordinate{21.4503, -14.1051}}, // Lumbala Airport
    Airport{IataCode{"GGE"}, CountryId{"US"}, Coordinate{-79.3203, 33.3114}}, // Georgetown County Airport
    Airport{IataCode{"GGF"}, CountryId{"BR"}, Coordinate{-52.5781, -1.47917}}, // Almeirim Airport
    Airport{IataCode{"GGG"}, CountryId{"US"}, Coordinate{-94.7192, 32.3877}}, // East Texas Regional Airport
    Airport{IataCode{"GGH"}, CountryId{"BR"}, Coordinate{-52.6422, -23.6917}}, // Cianorte Airport
    Airport{IataCode{"GGN"}, CountryId{"CI"}, Coordinate{-5.98694, 6.10333}}, // Gagnoa Airport
    Airport{IataCode{"GGO"}, CountryId{"CI"}, Coordinate{-7.47861, 6.52499}}, // Guiglo Airport
    Airport{IataCode{"GGR"}, CountryId{"SO"}, Coordinate{48.4833, 8.4}}, // Garowe International Airport
    Airport{IataCode{"GGS"}, CountryId{"AR"}, Coordinate{-70.162, -48.7833}}, // Gobernador Gregores Airport
    Airport{IataCode{"GGT"}, CountryId{"BS"}, Coordinate{-75.8726, 23.5638}}, // Exuma International Airport
    Airport{IataCode{"GGW"}, CountryId{"US"}, Coordinate{-106.615, 48.2125}}, // Glasgow Valley County Airport
    Airport{IataCode{"GHA"}, CountryId{"DZ"}, Coordinate{3.80009, 32.3777}}, // Noumérat – Moufdi Zakaria Airport
    Airport{IataCode{"GHB"}, CountryId{"BS"}, Coordinate{-76.3237, 25.2792}}, // Governor's Harbour Airport
    Airport{IataCode{"GHC"}, CountryId{"BS"}, Coordinate{-77.85, 25.7383}}, // Great Harbour Cay Airport
    Airport{IataCode{"GHE"}, CountryId{"PA"}, Coordinate{-78.3667, 8.06667}}, // Garachiné Airport
    Airport{IataCode{"GHM"}, CountryId{"US"}, Coordinate{-87.4453, 35.8375}}, // Centerville Municipal Airport
    Airport{IataCode{"GHN"}, CountryId{"CN"}, Coordinate{104.33, 30.9478}}, // Kwanghan Airfield
    Airport{IataCode{"GHS"}, CountryId{"ID"}, Coordinate{115.76, 0.203767}}, // West Kutai Melalan Airport
    Airport{IataCode{"GHT"}, CountryId{"LY"}, Coordinate{10.1425, 25.1456}}, // Ghat Airport
    Airport{IataCode{"GHU"}, CountryId{"AR"}, Coordinate{-58.6128, -33.0056}}, // Gualeguaychú Airport
    Airport{IataCode{"GIB"}, CountryId{"GB"}, Coordinate{-5.34625, 36.1541}}, // Gibraltar International Airport
    Airport{IataCode{"GIC"}, CountryId{"AU"}, Coordinate{142.219, -9.23213}}, // Boigu Island Airport
    Airport{IataCode{"GID"}, CountryId{"BI"}, Coordinate{29.8941, -3.43333}}, // Gitega Airport
    Airport{IataCode{"GIF"}, CountryId{"US"}, Coordinate{-81.7533, 28.0628}}, // Winter Haven's Gilbert Airport
    Airport{IataCode{"GIG"}, CountryId{"BR"}, Coordinate{-43.2506, -22.81}}, // Rio de Janeiro/Galeão – Antonio Carlos Jobim International Airport
    Airport{IataCode{"GII"}, CountryId{"GN"}, Coordinate{-9.167, 11.433}}, // Siguiri Airport
    Airport{IataCode{"GIL"}, CountryId{"PK"}, Coordinate{74.3336, 35.9186}}, // Gilgit Airport
    Airport{IataCode{"GIR"}, CountryId{"CO"}, Coordinate{-74.7982, 4.27674}}, // Santiago Vila Airport
    Airport{IataCode{"GIS"}, CountryId{"NZ"}, Coordinate{177.982, -38.6621}}, // Gisborne Airport
    Airport{IataCode{"GIT"}, CountryId{"TZ"}, Coordinate{32.1717, -2.87136}}, // Geita Airport
    Airport{IataCode{"GIZ"}, CountryId{"SA"}, Coordinate{42.5826, 16.899}}, // Jizan Regional Airport
    Airport{IataCode{"GJA"}, CountryId{"HN"}, Coordinate{-85.9067, 16.4453}}, // Guanaja Airport
    Airport{IataCode{"GJL"}, CountryId{"DZ"}, Coordinate{5.87822, 36.7927}}, // Jijel Ferhat Abbas Airport
    Airport{IataCode{"GJM"}, CountryId{"BR"}, Coordinate{-65.2817, -10.7883}}, // Guajará-Mirim Airport
    Airport{IataCode{"GJR"}, CountryId{"IS"}, Coordinate{-21.3296, 65.9933}}, // Gjögur Airport
    Airport{IataCode{"GJT"}, CountryId{"US"}, Coordinate{-108.529, 39.1226}}, // Grand Junction Regional Airport
    Airport{IataCode{"GKA"}, CountryId{"PG"}, Coordinate{145.393, -6.07507}}, // Goroka Airport
    Airport{IataCode{"GKD"}, CountryId{"TR"}, Coordinate{25.8867, 40.1999}}, // Gökçeada Airport
    Airport{IataCode{"GKH"}, CountryId{"NP"}, Coordinate{84.4662, 28.0387}}, // Gorkha Airport
    Airport{IataCode{"GKK"}, CountryId{"MV"}, Coordinate{73.4331, 0.730833}}, // Kooddoo Airport
    Airport{IataCode{"GKN"}, CountryId{"US"}, Coordinate{-145.454, 62.155}}, // Gulkana Airport
    Airport{IataCode{"GKT"}, CountryId{"US"}, Coordinate{-83.5286, 35.8578}}, // Gatlinburg-Pigeon Forge Airport
    Airport{IataCode{"GLA"}, CountryId{"GB"}, Coordinate{-4.43306, 55.8719}}, // Glasgow Airport
    Airport{IataCode{"GLB"}, CountryId{"US"}, Coordinate{-110.667, 33.3531}}, // San Carlos Apache Airport
    Airport{IataCode{"GLD"}, CountryId{"US"}, Coordinate{-101.699, 39.3706}}, // Goodland Municipal Airport
    Airport{IataCode{"GLE"}, CountryId{"US"}, Coordinate{-97.1969, 33.6514}}, // Gainesville Municipal Airport
    Airport{IataCode{"GLF"}, CountryId{"CR"}, Coordinate{-83.1777, 8.64922}}, // Golfito Airport
    Airport{IataCode{"GLH"}, CountryId{"US"}, Coordinate{-90.9856, 33.4828}}, // Mid Delta Regional Airport
    Airport{IataCode{"GLI"}, CountryId{"AU"}, Coordinate{151.684, -29.665}}, // Glen Innes Airport
    Airport{IataCode{"GLK"}, CountryId{"SO"}, Coordinate{47.4333, 6.76667}}, // Abdullahi Yusuf International Airport
    Airport{IataCode{"GLL"}, CountryId{"NO"}, Coordinate{9.05056, 60.7908}}, // Gol Airport
    Airport{IataCode{"GLN"}, CountryId{"MA"}, Coordinate{-10.0503, 29.0267}}, // Guelmim Airport
    Airport{IataCode{"GLO"}, CountryId{"GB"}, Coordinate{-2.16722, 51.8942}}, // Gloucestershire Airport
    Airport{IataCode{"GLP"}, CountryId{"PG"}, Coordinate{141.517, -5.28333}}, // Gulgubip
    Airport{IataCode{"GLR"}, CountryId{"US"}, Coordinate{-84.7033, 45.0131}}, // Gaylord Regional Airport
    Airport{IataCode{"GLS"}, CountryId{"US"}, Coordinate{-94.8553, 29.2682}}, // Scholes International Airport at Galveston
    Airport{IataCode{"GLT"}, CountryId{"AU"}, Coordinate{151.223, -23.8697}}, // Gladstone Airport
    Airport{IataCode{"GLU"}, CountryId{"BT"}, Coordinate{90.4653, 26.8686}}, // Gelephu Airport
    Airport{IataCode{"GLV"}, CountryId{"US"}, Coordinate{-163.007, 64.5506}}, // Golovin Airport
    Airport{IataCode{"GLW"}, CountryId{"US"}, Coordinate{-85.9539, 37.0317}}, // Glasgow Municipal Airport
    Airport{IataCode{"GLX"}, CountryId{"ID"}, Coordinate{127.787, 1.83831}}, // Gamar Malamo Airport
    Airport{IataCode{"GMA"}, CountryId{"CD"}, Coordinate{19.7667, 3.23528}}, // Gemena Airport
    Airport{IataCode{"GMB"}, CountryId{"ET"}, Coordinate{34.5676, 8.13146}}, // Gambela Airport
    Airport{IataCode{"GMD"}, CountryId{"MA"}, Coordinate{-7.22139, 33.6556}}, // Ben Slimane Airport
    Airport{IataCode{"GME"}, CountryId{"BY"}, Coordinate{31.0171, 52.5232}}, // Gomel Airport
    Airport{IataCode{"GMI"}, CountryId{"PG"}, Coordinate{150.333, -6.275}}, // Gasmata Airport
    Airport{IataCode{"GML"}, CountryId{"UA"}, Coordinate{30.1919, 50.6036}}, // Gostomel Airport
    Airport{IataCode{"GMM"}, CountryId{"CG"}, Coordinate{15.8667, -1.86667}}, // Gamboma Airport
    Airport{IataCode{"GMN"}, CountryId{"NZ"}, Coordinate{171.19, -42.4617}}, // Greymouth Airport
    Airport{IataCode{"GMO"}, CountryId{"NG"}, Coordinate{10.9076, 10.3069}}, // Gombe Lawanti International Airport
    Airport{IataCode{"GMP"}, CountryId{"KR"}, Coordinate{126.798, 37.5569}}, // Gimpo International Airport
    Airport{IataCode{"GMQ"}, CountryId{"CN"}, Coordinate{100.302, 34.4213}}, // Golog Airport
    Airport{IataCode{"GMR"}, CountryId{"FR"}, Coordinate{-134.883, -23.0833}}, // Totegegie Airport
    Airport{IataCode{"GMU"}, CountryId{"US"}, Coordinate{-82.35, 34.8481}}, // Greenville Downtown Airport
    Airport{IataCode{"GMZ"}, CountryId{"ES"}, Coordinate{-17.212, 28.0316}}, // La Gomera Airport
    Airport{IataCode{"GNA"}, CountryId{"BY"}, Coordinate{24.0465, 53.6048}}, // Hrodna Airport
    Airport{IataCode{"GNB"}, CountryId{"FR"}, Coordinate{5.33239, 45.3593}}, // Grenoble-Isère Airport
    Airport{IataCode{"GND"}, CountryId{"GD"}, Coordinate{-61.7858, 12.0072}}, // Maurice Bishop International Airport
    Airport{IataCode{"GNF"}, CountryId{"US"}, Coordinate{-120.945, 39.9439}}, // Gansner Field
    Airport{IataCode{"GNI"}, CountryId{"TW"}, Coordinate{121.467, 22.6726}}, // Lyudao Airport
    Airport{IataCode{"GNM"}, CountryId{"BR"}, Coordinate{-42.7491, -14.209}}, // Guanambi Airport
    Airport{IataCode{"GNN"}, CountryId{"ET"}, Coordinate{40.7167, 7.15}}, // Ghinnir Airport
    Airport{IataCode{"GNR"}, CountryId{"AR"}, Coordinate{-67.6103, -39.0035}}, // Dr. Arturo Umberto Illia Airport
    Airport{IataCode{"GNS"}, CountryId{"ID"}, Coordinate{97.7044, 1.16434}}, // Binaka Airport
    Airport{IataCode{"GNT"}, CountryId{"US"}, Coordinate{-107.902, 35.1672}}, // Grants-Milan Municipal Airport
    Airport{IataCode{"GNU"}, CountryId{"US"}, Coordinate{-161.577, 59.1175}}, // Goodnews Airport
    Airport{IataCode{"GNV"}, CountryId{"US"}, Coordinate{-82.2768, 29.6865}}, // Gainesville Regional Airport
    Airport{IataCode{"GNY"}, CountryId{"TR"}, Coordinate{38.9044, 37.4455}}, // Şanlıurfa GAP Airport
    Airport{IataCode{"GNZ"}, CountryId{"BW"}, Coordinate{21.6578, -21.7}}, // Ghanzi Airport
    Airport{IataCode{"GOA"}, CountryId{"IT"}, Coordinate{8.85029, 44.4149}}, // Genoa Cristoforo Colombo Airport
    Airport{IataCode{"GOB"}, CountryId{"ET"}, Coordinate{40.045, 7.11889}}, // Robe Airport
    Airport{IataCode{"GOC"}, CountryId{"PG"}, Coordinate{147.667, -8.41667}}, // Gora
    Airport{IataCode{"GOG"}, CountryId{"NA"}, Coordinate{18.9747, -22.5047}}, // Gobabis Airport
    Airport{IataCode{"GOH"}, CountryId{"GL"}, Coordinate{-51.674, 64.1917}}, // Nuuk Airport
    Airport{IataCode{"GOI"}, CountryId{"IN"}, Coordinate{73.838, 15.3846}}, // Dabolim Airport
    Airport{IataCode{"GOJ"}, CountryId{"RU"}, Coordinate{43.7902, 56.2192}}, // Nizhny Novgorod International Airport
    Airport{IataCode{"GOK"}, CountryId{"US"}, Coordinate{-97.4161, 35.8514}}, // Guthrie–Edmond Regional Airport
    Airport{IataCode{"GOL"}, CountryId{"US"}, Coordinate{-124.425, 42.4153}}, // Gold Beach Municipal Airport
    Airport{IataCode{"GOM"}, CountryId{"CD"}, Coordinate{29.2401, -1.65832}}, // Goma International Airport
    Airport{IataCode{"GOO"}, CountryId{"AU"}, Coordinate{150.325, -28.5209}}, // Goondiwindi Airport
    Airport{IataCode{"GOP"}, CountryId{"IN"}, Coordinate{83.45, 26.74}}, // Gorakhpur Airport
    Airport{IataCode{"GOQ"}, CountryId{"CN"}, Coordinate{94.7894, 36.4038}}, // Golmud Airport
    Airport{IataCode{"GOT"}, CountryId{"SE"}, Coordinate{12.2952, 57.6687}}, // Gothenburg-Landvetter Airport
    Airport{IataCode{"GOU"}, CountryId{"CM"}, Coordinate{13.3774, 9.33162}}, // Garoua International Airport
    Airport{IataCode{"GOV"}, CountryId{"AU"}, Coordinate{136.818, -12.27}}, // Gove Airport
    Airport{IataCode{"GOZ"}, CountryId{"BG"}, Coordinate{25.7196, 43.146}}, // Gorna Oryahovitsa Airport
    Airport{IataCode{"GPA"}, CountryId{"GR"}, Coordinate{21.4143, 38.1507}}, // Araxos Airport
    Airport{IataCode{"GPB"}, CountryId{"BR"}, Coordinate{-51.5193, -25.3884}}, // Guarapuava Airport
    Airport{IataCode{"GPD"}, CountryId{"AU"}, Coordinate{139.407, -19.775}}, // Mount Gordon Airport
    Airport{IataCode{"GPI"}, CountryId{"CO"}, Coordinate{-77.8948, 2.57501}}, // Guapi Airport
    Airport{IataCode{"GPL"}, CountryId{"CR"}, Coordinate{-83.8, 10.2167}}, // Guápiles Airport
    Airport{IataCode{"GPN"}, CountryId{"AU"}, Coordinate{130.425, -11.3992}}, // Garden Point Airport
    Airport{IataCode{"GPO"}, CountryId{"AR"}, Coordinate{-63.7583, -35.6893}}, // General Pico Airport
    Airport{IataCode{"GPS"}, CountryId{"EC"}, Coordinate{-90.2696, -0.44575}}, // Seymour Airport
    Airport{IataCode{"GPT"}, CountryId{"US"}, Coordinate{-89.0725, 30.4128}}, // Gulfport-Biloxi International Airport
    Airport{IataCode{"GPZ"}, CountryId{"US"}, Coordinate{-93.5156, 47.2122}}, // Grand Rapids – Itasca County Airport
    Airport{IataCode{"GQQ"}, CountryId{"US"}, Coordinate{-82.7239, 40.7533}}, // Galion Municipal Airport
    Airport{IataCode{"GRB"}, CountryId{"US"}, Coordinate{-88.1282, 44.4916}}, // Green Bay–Austin Straubel International Airport
    Airport{IataCode{"GRC"}, CountryId{"LR"}, Coordinate{-8.13, 4.34}}, // Grand Cess aerodrome
    Airport{IataCode{"GRD"}, CountryId{"US"}, Coordinate{-82.1533, 34.2467}}, // Greenwood County Airport
    Airport{IataCode{"GRE"}, CountryId{"US"}, Coordinate{-89.3783, 38.8361}}, // Greenville Airport
    Airport{IataCode{"GRH"}, CountryId{"PG"}, Coordinate{150.683, -10.3167}}, // Garuahi
    Airport{IataCode{"GRI"}, CountryId{"US"}, Coordinate{-98.3186, 40.9694}}, // Central Nebraska Regional Airport
    Airport{IataCode{"GRJ"}, CountryId{"ZA"}, Coordinate{22.3819, -34.0015}}, // George Airport
    Airport{IataCode{"GRK"}, CountryId{"US"}, Coordinate{-97.821, 31.0616}}, // Killeen–Fort Hood Regional Airport
    Airport{IataCode{"GRL"}, CountryId{"PG"}, Coordinate{147.2, -7.95}}, // Garasa
    Airport{IataCode{"GRM"}, CountryId{"US"}, Coordinate{-90.3831, 47.8383}}, // Grand Marais/Cook County Airport
    Airport{IataCode{"GRO"}, CountryId{"ES"}, Coordinate{2.76585, 41.8981}}, // Girona-Costa Brava Airport
    Airport{IataCode{"GRQ"}, CountryId{"NL"}, Coordinate{6.58646, 53.1295}}, // Groningen Airport Eelde
    Airport{IataCode{"GRR"}, CountryId{"US"}, Coordinate{-85.5286, 42.8843}}, // Gerald R. Ford International Airport
    Airport{IataCode{"GRS"}, CountryId{"IT"}, Coordinate{11.0717, 42.7597}}, // Grosseto Airport
    Airport{IataCode{"GRU"}, CountryId{"BR"}, Coordinate{-46.4813, -23.4272}}, // São Paulo-Guarulhos International Airport
    Airport{IataCode{"GRV"}, CountryId{"RU"}, Coordinate{45.6999, 43.3846}}, // Grozny Airport
    Airport{IataCode{"GRW"}, CountryId{"PT"}, Coordinate{-28.0282, 39.0909}}, // Graciosa Airport
    Airport{IataCode{"GRX"}, CountryId{"ES"}, Coordinate{-3.77707, 37.1851}}, // Federico García Lorca Granada Airport
    Airport{IataCode{"GRY"}, CountryId{"IS"}, Coordinate{-18.0208, 66.5479}}, // Grímsey Airport
    Airport{IataCode{"GRZ"}, CountryId{"AT"}, Coordinate{15.4445, 46.9961}}, // Graz Airport
    Airport{IataCode{"GSA"}, CountryId{"MY"}, Coordinate{115.719, 4.40944}}, // Long Pasia Airport
    Airport{IataCode{"GSC"}, CountryId{"AU"}, Coordinate{115.201, -25.0538}}, // Gascoyne Junction Airport
    Airport{IataCode{"GSE"}, CountryId{"SE"}, Coordinate{11.8648, 57.7777}}, // Gothenburg City Airport
    Airport{IataCode{"GSH"}, CountryId{"US"}, Coordinate{-85.7942, 41.5231}}, // Goshen Municipal Airport
    Airport{IataCode{"GSI"}, CountryId{"FR"}, Coordinate{-54.3808, 4.28289}}, // Grand-Santi Airport
    Airport{IataCode{"GSJ"}, CountryId{"GT"}, Coordinate{-90.8358, 13.9361}}, // San José Airport
    Airport{IataCode{"GSL"}, CountryId{"CA"}, Coordinate{-111.541, 62.5972}}, // Taltheilei Narrows Airport
    Airport{IataCode{"GSM"}, CountryId{"IR"}, Coordinate{55.9024, 26.7546}}, // Dayrestan Airport
    Airport{IataCode{"GSN"}, CountryId{"AU"}, Coordinate{137.174, -31.4597}}, // Mount Gunson Airport
    Airport{IataCode{"GSO"}, CountryId{"US"}, Coordinate{-79.9358, 36.1048}}, // Piedmont Triad International Airport
    Airport{IataCode{"GSP"}, CountryId{"US"}, Coordinate{-82.217, 34.8915}}, // Greenville-Spartanburg International Airport
    Airport{IataCode{"GSQ"}, CountryId{"EG"}, Coordinate{28.7205, 22.581}}, // Sharq Al-Owainat Airport
    Airport{IataCode{"GSR"}, CountryId{"SO"}, Coordinate{49.0833, 9.51667}}, // Gardo Airport
    Airport{IataCode{"GST"}, CountryId{"US"}, Coordinate{-135.708, 58.4253}}, // Gustavus Airport
    Airport{IataCode{"GSU"}, CountryId{"SD"}, Coordinate{35.3169, 14.13}}, // Gedaref Airport
    Airport{IataCode{"GSV"}, CountryId{"RU"}, Coordinate{46.17, 51.7181}}, // Gagarin International Airport
    Airport{IataCode{"GTA"}, CountryId{"SB"}, Coordinate{158.203, -8.73917}}, // Gatokae Aerodrome
    Airport{IataCode{"GTE"}, CountryId{"AU"}, Coordinate{136.46, -13.975}}, // Groote Eylandt Airport
    Airport{IataCode{"GTF"}, CountryId{"US"}, Coordinate{-111.357, 47.4824}}, // Great Falls International Airport
    Airport{IataCode{"GTG"}, CountryId{"US"}, Coordinate{-92.6644, 45.7981}}, // Grantsburg Municipal Airport
    Airport{IataCode{"GTN"}, CountryId{"NZ"}, Coordinate{170.136, -43.7668}}, // Mount Cook Aerodrome
    Airport{IataCode{"GTO"}, CountryId{"ID"}, Coordinate{122.851, 0.639095}}, // Jalaluddin Airport
    Airport{IataCode{"GTP"}, CountryId{"US"}, Coordinate{-123.388, 42.5101}}, // Grants Pass Airport
    Airport{IataCode{"GTR"}, CountryId{"US"}, Coordinate{-88.5914, 33.4483}}, // Golden Triangle Regional Airport
    Airport{IataCode{"GTS"}, CountryId{"AU"}, Coordinate{130.35, -20.5483}}, // The Granites Airport
    Airport{IataCode{"GTT"}, CountryId{"AU"}, Coordinate{143.53, -18.305}}, // Georgetown Airport
    Airport{IataCode{"GTY"}, CountryId{"US"}, Coordinate{-77.2742, 39.8408}}, // Gettysburg Regional Airport
    Airport{IataCode{"GTZ"}, CountryId{"TZ"}, Coordinate{34.2217, -2.15948}}, // Grumeti River
    Airport{IataCode{"GUA"}, CountryId{"GT"}, Coordinate{-90.5297, 14.5893}}, // La Aurora International Airport
    Airport{IataCode{"GUB"}, CountryId{"MX"}, Coordinate{-114.024, 28.0258}}, // Guerrero Negro Airport
    Airport{IataCode{"GUC"}, CountryId{"US"}, Coordinate{-106.936, 38.5369}}, // Gunnison–Crested Butte Regional Airport
    Airport{IataCode{"GUD"}, CountryId{"ML"}, Coordinate{-3.6, 16.35}}, // Goundam Airport
    Airport{IataCode{"GUF"}, CountryId{"US"}, Coordinate{-87.6793, 30.2875}}, // Jack Edwards Airport
    Airport{IataCode{"GUG"}, CountryId{"PG"}, Coordinate{146.9, -8.1}}, // Guari
    Airport{IataCode{"GUH"}, CountryId{"AU"}, Coordinate{150.25, -30.9617}}, // Gunnedah Airport
    Airport{IataCode{"GUI"}, CountryId{"VE"}, Coordinate{-62.3125, 10.5739}}, // Güiria Airport
    Airport{IataCode{"GUL"}, CountryId{"AU"}, Coordinate{149.734, -34.8067}}, // Goulburn Airport
    Airport{IataCode{"GUM"}, CountryId{"US"}, Coordinate{144.805, 13.4916}}, // Antonio B. Won Pat International Airport
    Airport{IataCode{"GUP"}, CountryId{"US"}, Coordinate{-108.789, 35.5111}}, // Gallup Municipal Airport
    Airport{IataCode{"GUQ"}, CountryId{"VE"}, Coordinate{-69.7558, 9.02942}}, // Guanare Airport
    Airport{IataCode{"GUR"}, CountryId{"PG"}, Coordinate{150.339, -10.3098}}, // Gurney Airport
    Airport{IataCode{"GUS"}, CountryId{"US"}, Coordinate{-86.1522, 40.6481}}, // Grissom Aeroplex
    Airport{IataCode{"GUU"}, CountryId{"IS"}, Coordinate{-23.2222, 64.9917}}, // Grundarfjörður Airport
    Airport{IataCode{"GUV"}, CountryId{"PG"}, Coordinate{142.421, -6.28177}}, // Mougulu Airport
    Airport{IataCode{"GUW"}, CountryId{"KZ"}, Coordinate{51.8294, 47.1222}}, // Atyrau Airport
    Airport{IataCode{"GUY"}, CountryId{"US"}, Coordinate{-101.507, 36.6783}}, // Guymon Municipal Airport
    Airport{IataCode{"GUZ"}, CountryId{"BR"}, Coordinate{-40.49, -20.6471}}, // Guarapari Airport
    Airport{IataCode{"GVA"}, CountryId{"CH"}, Coordinate{6.11027, 46.2313}}, // Geneva International Airport
    Airport{IataCode{"GVI"}, CountryId{"PG"}, Coordinate{141.171, -3.90224}}, // GVI
    Airport{IataCode{"GVL"}, CountryId{"US"}, Coordinate{-83.8347, 34.2731}}, // Lee Gilmer Memorial Airport
    Airport{IataCode{"GVN"}, CountryId{"RU"}, Coordinate{140.036, 48.9183}}, // Sovetskaya Gavan - May-Gatka
    Airport{IataCode{"GVR"}, CountryId{"BR"}, Coordinate{-41.9861, -18.8969}}, // Governador Valadares Airport
    Airport{IataCode{"GVT"}, CountryId{"US"}, Coordinate{-96.0653, 33.0678}}, // Majors Airport
    Airport{IataCode{"GVX"}, CountryId{"SE"}, Coordinate{16.9582, 60.5945}}, // Gävle-Sandviken Airport
    Airport{IataCode{"GWA"}, CountryId{"MM"}, Coordinate{94.5833, 17.6}}, // Gwa Airport
    Airport{IataCode{"GWD"}, CountryId{"PK"}, Coordinate{62.3294, 25.2331}}, // Gwadar International Airport
    Airport{IataCode{"GWL"}, CountryId{"IN"}, Coordinate{78.2278, 26.2933}}, // Gwalior Airport
    Airport{IataCode{"GWN"}, CountryId{"PG"}, Coordinate{146.25, -6.56667}}, // Gnarowein
    Airport{IataCode{"GWO"}, CountryId{"US"}, Coordinate{-90.0692, 33.6464}}, // Greenwood-Leflore Airport
    Airport{IataCode{"GWT"}, CountryId{"DE"}, Coordinate{8.33048, 54.9139}}, // Sylt Airport
    Airport{IataCode{"GWW"}, CountryId{"US"}, Coordinate{-77.965, 35.4606}}, // Wayne Executive Jetport
    Airport{IataCode{"GWY"}, CountryId{"IE"}, Coordinate{-8.94052, 53.3019}}, // Galway Airport
    Airport{IataCode{"GXA"}, CountryId{"ID"}, Coordinate{114.894, -0.942778}}, // Beringin Airport
    Airport{IataCode{"GXF"}, CountryId{"YE"}, Coordinate{48.7881, 15.9661}}, // Sayun Airport
    Airport{IataCode{"GXG"}, CountryId{"AO"}, Coordinate{15.2876, -7.75431}}, // Negage Airport
    Airport{IataCode{"GXH"}, CountryId{"CN"}, Coordinate{102.645, 34.8106}}, // Gannan Xiahe Airport
    Airport{IataCode{"GXQ"}, CountryId{"CL"}, Coordinate{-72.1112, -45.5954}}, // Teniente Vidal Airport
    Airport{IataCode{"GXX"}, CountryId{"CM"}, Coordinate{15.2437, 10.3531}}, // Yagoua Airport
    Airport{IataCode{"GXY"}, CountryId{"US"}, Coordinate{-104.637, 40.4264}}, // Greeley–Weld County Airport
    Airport{IataCode{"GYA"}, CountryId{"BO"}, Coordinate{-65.3804, -10.8844}}, // Guayaramerín Airport
    Airport{IataCode{"GYD"}, CountryId{"AZ"}, Coordinate{50.0576, 40.4612}}, // Heydar Aliyev International Airport
    Airport{IataCode{"GYE"}, CountryId{"EC"}, Coordinate{-79.8841, -2.1486}}, // José Joaquín de Olmedo International Airport
    Airport{IataCode{"GYG"}, CountryId{"RU"}, Coordinate{129.563, 62.1083}}, // Magan Airport
    Airport{IataCode{"GYI"}, CountryId{"RW"}, Coordinate{29.2583, -1.68}}, // Gisenyi Airport
    Airport{IataCode{"GYL"}, CountryId{"AU"}, Coordinate{128.451, -16.6369}}, // Argyle Airport
    Airport{IataCode{"GYM"}, CountryId{"MX"}, Coordinate{-110.924, 27.9692}}, // General José María Yáñez International Airport
    Airport{IataCode{"GYN"}, CountryId{"BR"}, Coordinate{-49.2267, -16.6297}}, // Santa Genoveva Airport
    Airport{IataCode{"GYP"}, CountryId{"AU"}, Coordinate{152.702, -26.2833}}, // Gympie Airport
    Airport{IataCode{"GYR"}, CountryId{"US"}, Coordinate{-112.367, 33.4286}}, // Phoenix Goodyear Airport
    Airport{IataCode{"GYS"}, CountryId{"CN"}, Coordinate{105.701, 32.3948}}, // Guangyuan Panlong Airport
    Airport{IataCode{"GYU"}, CountryId{"CN"}, Coordinate{106.222, 36.0767}}, // Guyuan Liupanshan Airport
    Airport{IataCode{"GZG"}, CountryId{"CN"}, Coordinate{99.5536, 31.755}}, // Garzê Gesar Airport
    Airport{IataCode{"GZI"}, CountryId{"AF"}, Coordinate{68.4123, 33.5308}}, // Ghazni Airport
    Airport{IataCode{"GZO"}, CountryId{"SB"}, Coordinate{156.862, -8.09719}}, // Nusatupe Airport
    Airport{IataCode{"GZP"}, CountryId{"TR"}, Coordinate{32.3017, 36.2975}}, // Antalya Gazipasa-Alanya Airport
    Airport{IataCode{"GZT"}, CountryId{"TR"}, Coordinate{37.4738, 36.9454}}, // Oğuzeli Airport
    Airport{IataCode{"GZW"}, CountryId{"IR"}, Coordinate{50.0333, 36.2333}}, // Qazvin Airport
    Airport{IataCode{"HAA"}, CountryId{"NO"}, Coordinate{22.147, 70.4864}}, // Hasvik Airport
    Airport{IataCode{"HAB"}, CountryId{"US"}, Coordinate{-87.9983, 34.1175}}, // Marion County – Rankin Fite Airport
    Airport{IataCode{"HAC"}, CountryId{"JP"}, Coordinate{139.786, 33.115}}, // Hachijojima Airport
    Airport{IataCode{"HAD"}, CountryId{"SE"}, Coordinate{12.815, 56.6811}}, // Halmstad Airport
    Airport{IataCode{"HAE"}, CountryId{"KP"}, Coordinate{125.779, 38.0054}}, // Haeju Airport
    Airport{IataCode{"HAF"}, CountryId{"US"}, Coordinate{-122.501, 37.5133}}, // Half Moon Bay Airport
    Airport{IataCode{"HAH"}, CountryId{"KM"}, Coordinate{43.2714, -11.5367}}, // Prince Said Ibrahim International Airport
    Airport{IataCode{"HAJ"}, CountryId{"DE"}, Coordinate{9.6988, 52.4586}}, // Hannover Airport
    Airport{IataCode{"HAK"}, CountryId{"CN"}, Coordinate{110.457, 19.9444}}, // Haikou Meilan International Airport
    Airport{IataCode{"HAL"}, CountryId{"NA"}, Coordinate{16.4583, -19.0314}}, // Halali aerodrome
    Airport{IataCode{"HAM"}, CountryId{"DE"}, Coordinate{10.0067, 53.6326}}, // Hamburg Airport
    Airport{IataCode{"HAN"}, CountryId{"VN"}, Coordinate{105.797, 21.2166}}, // Noi Bai International Airport
    Airport{IataCode{"HAO"}, CountryId{"US"}, Coordinate{-84.5219, 39.3638}}, // Butler County Regional Airport
    Airport{IataCode{"HAQ"}, CountryId{"MV"}, Coordinate{73.1572, 6.73111}}, // Hanimaadhoo Airport
    Airport{IataCode{"HAR"}, CountryId{"US"}, Coordinate{-76.8536, 40.2207}}, // Capital City Airport
    Airport{IataCode{"HAS"}, CountryId{"SA"}, Coordinate{41.6901, 27.4384}}, // Ha'il Regional Airport
    Airport{IataCode{"HAU"}, CountryId{"NO"}, Coordinate{5.21695, 59.3444}}, // Haugesund Airport, Karmøy
    Airport{IataCode{"HAV"}, CountryId{"CU"}, Coordinate{-82.4089, 22.9889}}, // José Martí International Airport
    Airport{IataCode{"HAW"}, CountryId{"GB"}, Coordinate{-4.96111, 51.8331}}, // Haverfordwest Aerodrome
    Airport{IataCode{"HAY"}, CountryId{"CO"}, Coordinate{-73.5821, 8.24704}}, // Hacaritama Airport
    Airport{IataCode{"HAZ"}, CountryId{"PG"}, Coordinate{145.167, -4.33333}}, // Hatzfeldthaven
    Airport{IataCode{"HBA"}, CountryId{"AU"}, Coordinate{147.505, -42.8371}}, // Hobart International Airport
    Airport{IataCode{"HBE"}, CountryId{"EG"}, Coordinate{29.6962, 30.9324}}, // Borg El Arab Airport
    Airport{IataCode{"HBG"}, CountryId{"US"}, Coordinate{-89.2541, 31.2698}}, // Hattiesburg Bobby L. Chain Municipal Airport
    Airport{IataCode{"HBK"}, CountryId{"US"}, Coordinate{-110.142, 34.9349}}, // Holbrook Municipal Airport
    Airport{IataCode{"HBQ"}, CountryId{"CN"}, Coordinate{100.644, 38.012}}, // Qilian Airport
    Airport{IataCode{"HBR"}, CountryId{"US"}, Coordinate{-99.0514, 34.9914}}, // Hobart Regional Airport
    Airport{IataCode{"HBU"}, CountryId{"MN"}, Coordinate{91.5819, 46.1017}}, // Bulgan Airport
    Airport{IataCode{"HBX"}, CountryId{"IN"}, Coordinate{75.0853, 15.358}}, // Hubli Airport
    Airport{IataCode{"HCA"}, CountryId{"US"}, Coordinate{-101.527, 32.2147}}, // Big Spring McMahon-Wrinkle Airport
    Airport{IataCode{"HCC"}, CountryId{"US"}, Coordinate{-73.7103, 42.2914}}, // Columbia County Airport
    Airport{IataCode{"HCJ"}, CountryId{"CN"}, Coordinate{107.7, 24.7839}}, // Hechi Jinchengjiang Airport
    Airport{IataCode{"HCM"}, CountryId{"SO"}, Coordinate{49.8, 7.91667}}, // Eyl Airport
    Airport{IataCode{"HCN"}, CountryId{"TW"}, Coordinate{120.73, 22.0381}}, // Hengchun Airport
    Airport{IataCode{"HCQ"}, CountryId{"AU"}, Coordinate{127.67, -18.2339}}, // Halls Creek Airport
    Airport{IataCode{"HCR"}, CountryId{"US"}, Coordinate{-159.775, 62.1883}}, // Holy Cross Airport
    Airport{IataCode{"HCW"}, CountryId{"US"}, Coordinate{-79.9569, 34.7128}}, // Cheraw Municipal Airport
    Airport{IataCode{"HDD"}, CountryId{"PK"}, Coordinate{68.3635, 25.3194}}, // Hyderabad Airport
    Airport{IataCode{"HDF"}, CountryId{"DE"}, Coordinate{14.1389, 53.8785}}, // Heringsdorf Airport
    Airport{IataCode{"HDG"}, CountryId{"CN"}, Coordinate{114.427, 36.5226}}, // Handan Airport
    Airport{IataCode{"HDM"}, CountryId{"IR"}, Coordinate{48.5378, 34.8672}}, // Hamadan Airport
    Airport{IataCode{"HDN"}, CountryId{"US"}, Coordinate{-107.218, 40.4811}}, // Yampa Valley Airport
    Airport{IataCode{"HDY"}, CountryId{"TH"}, Coordinate{100.393, 6.93306}}, // Hat Yai International Airport
    Airport{IataCode{"HEA"}, CountryId{"AF"}, Coordinate{62.2279, 34.2101}}, // Herat International Airport
    Airport{IataCode{"HEE"}, CountryId{"US"}, Coordinate{-90.6758, 34.5764}}, // Thompson-Robbins Airport
    Airport{IataCode{"HEG"}, CountryId{"US"}, Coordinate{-81.8058, 30.2778}}, // Herlong Recreational Airport
    Airport{IataCode{"HEH"}, CountryId{"MM"}, Coordinate{96.7932, 20.7438}}, // Heho Airport
    Airport{IataCode{"HEK"}, CountryId{"CN"}, Coordinate{127.312, 50.1776}}, // Heihe Aihui Airport
    Airport{IataCode{"HEL"}, CountryId{"FI"}, Coordinate{24.9686, 60.3158}}, // Helsinki Airport
    Airport{IataCode{"HEO"}, CountryId{"PG"}, Coordinate{147.6, -9.1375}}, // Haelogo Airport
    Airport{IataCode{"HER"}, CountryId{"GR"}, Coordinate{25.1741, 35.3371}}, // Heraklion International Airport
    Airport{IataCode{"HES"}, CountryId{"US"}, Coordinate{-119.259, 45.8283}}, // Hermiston Municipal Airport
    Airport{IataCode{"HET"}, CountryId{"CN"}, Coordinate{111.817, 40.8541}}, // Hohhot Baita International Airport
    Airport{IataCode{"HEZ"}, CountryId{"US"}, Coordinate{-91.2931, 31.615}}, // Natchez-Adams County Airport
    Airport{IataCode{"HFA"}, CountryId{"IL"}, Coordinate{35.0404, 32.8115}}, // Haifa International Airport
    Airport{IataCode{"HFD"}, CountryId{"US"}, Coordinate{-72.6494, 41.7367}}, // Hartford-Brainard Airport
    Airport{IataCode{"HFE"}, CountryId{"CN"}, Coordinate{116.965, 31.9884}}, // Hefei Xinqiao International Airport
    Airport{IataCode{"HFF"}, CountryId{"US"}, Coordinate{-79.4975, 35.0364}}, // Camp Mackall
    Airport{IataCode{"HFN"}, CountryId{"IS"}, Coordinate{-15.2265, 64.3021}}, // Hornafjörður Airport
    Airport{IataCode{"HFS"}, CountryId{"SE"}, Coordinate{13.5815, 60.026}}, // Hagfors Airport
    Airport{IataCode{"HFT"}, CountryId{"NO"}, Coordinate{23.6771, 70.6803}}, // Hammerfest Airport
    Airport{IataCode{"HGA"}, CountryId{}, Coordinate{44.0837, 9.51801}}, // Hargeisa International Airport
    Airport{IataCode{"HGD"}, CountryId{"AU"}, Coordinate{144.225, -20.815}}, // Hughenden Airport
    Airport{IataCode{"HGE"}, CountryId{"VE"}, Coordinate{-66.0998, 10.4623}}, // Higuerote Airport
    Airport{IataCode{"HGH"}, CountryId{"CN"}, Coordinate{120.427, 30.2376}}, // Hangzhou Xiaoshan International Airport
    Airport{IataCode{"HGI"}, CountryId{"SS"}, Coordinate{32.5006, 10.5292}}, // Paloich Airport
    Airport{IataCode{"HGN"}, CountryId{"TH"}, Coordinate{97.9754, 19.3}}, // Mae Hong Son Airport
    Airport{IataCode{"HGO"}, CountryId{"CI"}, Coordinate{-5.55469, 9.39022}}, // Korhogo Airport
    Airport{IataCode{"HGR"}, CountryId{"US"}, Coordinate{-77.7313, 39.7051}}, // Hagerstown Regional Airport
    Airport{IataCode{"HGS"}, CountryId{"SL"}, Coordinate{-13.1291, 8.3943}}, // Hastings Airport
    Airport{IataCode{"HGU"}, CountryId{"PG"}, Coordinate{144.297, -5.8294}}, // Mount Hagen Airport
    Airport{IataCode{"HHH"}, CountryId{"US"}, Coordinate{-80.6988, 32.2266}}, // Hilton Head Airport
    Airport{IataCode{"HHN"}, CountryId{"DE"}, Coordinate{7.26996, 49.9464}}, // Frankfurt-Hahn Airport
    Airport{IataCode{"HHQ"}, CountryId{"TH"}, Coordinate{99.9516, 12.6275}}, // Hua Hin Airport
    Airport{IataCode{"HHR"}, CountryId{"US"}, Coordinate{-118.335, 33.9228}}, // Hawthorne Municipal Airport
    Airport{IataCode{"HHZ"}, CountryId{"FR"}, Coordinate{-142.613, -17.5478}}, // Hikueru Airport
    Airport{IataCode{"HIA"}, CountryId{"CN"}, Coordinate{119.148, 33.7772}}, // Huai'an Lianshui Airport
    Airport{IataCode{"HIB"}, CountryId{"US"}, Coordinate{-92.8424, 47.3924}}, // Range Regional Airport
    Airport{IataCode{"HID"}, CountryId{"AU"}, Coordinate{142.295, -10.591}}, // Horn Island Airport
    Airport{IataCode{"HIE"}, CountryId{"US"}, Coordinate{-71.5445, 44.3676}}, // Mount Washington Regional Airport
    Airport{IataCode{"HII"}, CountryId{"US"}, Coordinate{-114.358, 34.5711}}, // Lake Havasu City Airport
    Airport{IataCode{"HIJ"}, CountryId{"JP"}, Coordinate{132.919, 34.4399}}, // Hiroshima Airport
    Airport{IataCode{"HIL"}, CountryId{"ET"}, Coordinate{44.7639, 6.07778}}, // Shilavo Airport
    Airport{IataCode{"HIM"}, CountryId{"LK"}, Coordinate{80.9817, 8.053}}, // SLAF Hingurakgoda
    Airport{IataCode{"HIN"}, CountryId{"KR"}, Coordinate{128.087, 35.0922}}, // Sacheon Airport
    Airport{IataCode{"HIO"}, CountryId{"US"}, Coordinate{-122.948, 45.5331}}, // Hillsboro Airport
    Airport{IataCode{"HIR"}, CountryId{"SB"}, Coordinate{160.046, -9.42751}}, // Honiara International Airport
    Airport{IataCode{"HIT"}, CountryId{"PG"}, Coordinate{143.067, -6.93333}}, // Hivaro
    Airport{IataCode{"HIW"}, CountryId{"JP"}, Coordinate{132.414, 34.3669}}, // Hiroshima-Nishi Airport
    Airport{IataCode{"HJJ"}, CountryId{"CN"}, Coordinate{109.701, 27.4442}}, // Huaihua Zhijiang Airport
    Airport{IataCode{"HJR"}, CountryId{"IN"}, Coordinate{79.9146, 24.8144}}, // Khajuraho Airport
    Airport{IataCode{"HJT"}, CountryId{"MN"}, Coordinate{102.778, 46.9253}}, // Khujirt Airport
    Airport{IataCode{"HKA"}, CountryId{"US"}, Coordinate{-89.8322, 35.9369}}, // Blytheville Municipal Airport
    Airport{IataCode{"HKB"}, CountryId{"US"}, Coordinate{-144.693, 63.9958}}, // Healy Lake Airport
    Airport{IataCode{"HKD"}, CountryId{"JP"}, Coordinate{140.822, 41.77}}, // Hakodate Airport
    Airport{IataCode{"HKG"}, CountryId{"CN"}, Coordinate{113.937, 22.3159}}, // Hong Kong International Airport
    Airport{IataCode{"HKK"}, CountryId{"NZ"}, Coordinate{170.985, -42.714}}, // Hokitika Airport
    Airport{IataCode{"HKN"}, CountryId{"PG"}, Coordinate{150.403, -5.45727}}, // Hoskins Airport
    Airport{IataCode{"HKS"}, CountryId{"US"}, Coordinate{-90.2225, 32.3347}}, // Hawkins Field
    Airport{IataCode{"HKT"}, CountryId{"TH"}, Coordinate{98.3058, 8.1068}}, // Phuket International Airport
    Airport{IataCode{"HKY"}, CountryId{"US"}, Coordinate{-81.3894, 35.7425}}, // Hickory Regional Airport
    Airport{IataCode{"HLA"}, CountryId{"ZA"}, Coordinate{27.9252, -25.9344}}, // Lanseria International Airport
    Airport{IataCode{"HLC"}, CountryId{"US"}, Coordinate{-99.8314, 39.3803}}, // Hill City Municipal Airport
    Airport{IataCode{"HLD"}, CountryId{"CN"}, Coordinate{119.819, 49.2109}}, // Hulunbuir Hailar Airport
    Airport{IataCode{"HLE"}, CountryId{"GB"}, Coordinate{-5.64883, -15.9622}}, // Saint Helena Airport
    Airport{IataCode{"HLF"}, CountryId{"SE"}, Coordinate{15.8337, 57.5214}}, // Hultsfred Airport
    Airport{IataCode{"HLG"}, CountryId{"US"}, Coordinate{-80.6464, 40.175}}, // Wheeling Ohio County Airport
    Airport{IataCode{"HLH"}, CountryId{"CN"}, Coordinate{122.002, 46.1938}}, // Ulanhot Airport
    Airport{IataCode{"HLI"}, CountryId{"US"}, Coordinate{-121.41, 36.8933}}, // Hollister Municipal Airport
    Airport{IataCode{"HLJ"}, CountryId{"LT"}, Coordinate{23.5581, 56.0706}}, // Barysiai Airport
    Airport{IataCode{"HLM"}, CountryId{"US"}, Coordinate{-86.1619, 42.7958}}, // Park Township Airport
    Airport{IataCode{"HLN"}, CountryId{"US"}, Coordinate{-111.99, 46.6102}}, // Helena Regional Airport
    Airport{IataCode{"HLP"}, CountryId{"ID"}, Coordinate{106.891, -6.26639}}, // Halim Perdanakusuma Airport
    Airport{IataCode{"HLS"}, CountryId{"AU"}, Coordinate{148.282, -41.3367}}, // St Helens Airport
    Airport{IataCode{"HLT"}, CountryId{"AU"}, Coordinate{142.059, -37.6482}}, // Hamilton Airport
    Airport{IataCode{"HLW"}, CountryId{"ZA"}, Coordinate{32.275, -28.0083}}, // Hluhluwe Airport
    Airport{IataCode{"HLZ"}, CountryId{"NZ"}, Coordinate{175.336, -37.8659}}, // Hamilton International Airport
    Airport{IataCode{"HMA"}, CountryId{"RU"}, Coordinate{69.0965, 61.0262}}, // Khanty-Mansiysk Airport
    Airport{IataCode{"HMB"}, CountryId{"EG"}, Coordinate{31.7377, 26.3391}}, // Sohag International Airport
    Airport{IataCode{"HME"}, CountryId{"DZ"}, Coordinate{6.14456, 31.6753}}, // Oued Irara–Krim Belkacem Airport
    Airport{IataCode{"HMI"}, CountryId{"CN"}, Coordinate{93.6558, 42.8397}}, // Hami Airport
    Airport{IataCode{"HMJ"}, CountryId{"UA"}, Coordinate{26.9376, 49.36}}, // Khmelnytskyi Airport
    Airport{IataCode{"HMO"}, CountryId{"MX"}, Coordinate{-111.05, 29.0911}}, // General Ignacio Pesqueira García International Airport
    Airport{IataCode{"HMT"}, CountryId{"US"}, Coordinate{-117.022, 33.7339}}, // Hemet-Ryan Airport
    Airport{IataCode{"HNA"}, CountryId{"JP"}, Coordinate{141.139, 39.4215}}, // Hanamaki Airport
    Airport{IataCode{"HNB"}, CountryId{"US"}, Coordinate{-86.9536, 38.2489}}, // Huntingburg Airport
    Airport{IataCode{"HNC"}, CountryId{"US"}, Coordinate{-75.6178, 35.2328}}, // Billy Mitchell Airport
    Airport{IataCode{"HND"}, CountryId{"JP"}, Coordinate{139.781, 35.5533}}, // Tokyo International Airport
    Airport{IataCode{"HNH"}, CountryId{"US"}, Coordinate{-135.41, 58.0961}}, // Hoonah Airport
    Airport{IataCode{"HNI"}, CountryId{"PG"}, Coordinate{146.5, -7.4}}, // Heiweni
    Airport{IataCode{"HNL"}, CountryId{"US"}, Coordinate{-157.921, 21.3337}}, // Daniel K. Inouye International Airport
    Airport{IataCode{"HNM"}, CountryId{"US"}, Coordinate{-156.014, 20.7945}}, // Hana Airport
    Airport{IataCode{"HNN"}, CountryId{"PG"}, Coordinate{142.177, -6.24649}}, // Honinabi Airport
    Airport{IataCode{"HNO"}, CountryId{"ME"}, Coordinate{18.533, 42.4497}}, // Herceg Novi
    Airport{IataCode{"HNS"}, CountryId{"US"}, Coordinate{-135.524, 59.2439}}, // Haines Airport
    Airport{IataCode{"HNY"}, CountryId{"CN"}, Coordinate{112.618, 26.7239}}, // Hengyang Nanyue Airport
    Airport{IataCode{"HOA"}, CountryId{"KE"}, Coordinate{40.0039, -1.52}}, // Hola Airport
    Airport{IataCode{"HOB"}, CountryId{"US"}, Coordinate{-103.214, 32.6924}}, // Lea County Regional Airport
    Airport{IataCode{"HOD"}, CountryId{"YE"}, Coordinate{42.9711, 14.7552}}, // Hodeida International Airport
    Airport{IataCode{"HOE"}, CountryId{"LA"}, Coordinate{100.426, 20.2578}}, // Ban Huoeisay Airport
    Airport{IataCode{"HOF"}, CountryId{"SA"}, Coordinate{49.4852, 25.2853}}, // Al-Ahsa Domestic Airport
    Airport{IataCode{"HOG"}, CountryId{"CU"}, Coordinate{-76.3048, 20.7898}}, // Frank País Airport
    Airport{IataCode{"HOH"}, CountryId{"AT"}, Coordinate{9.7, 47.385}}, // Hohenems-Dornbirn Airport
    Airport{IataCode{"HOI"}, CountryId{"FR"}, Coordinate{-140.946, -18.0747}}, // Hao Airport
    Airport{IataCode{"HOK"}, CountryId{"AU"}, Coordinate{130.643, -18.3367}}, // Hooker Creek Airport
    Airport{IataCode{"HOM"}, CountryId{"US"}, Coordinate{-151.487, 59.6425}}, // Homer Airport
    Airport{IataCode{"HON"}, CountryId{"US"}, Coordinate{-98.223, 44.385}}, // Huron Regional Airport
    Airport{IataCode{"HOO"}, CountryId{"VN"}, Coordinate{106.591, 17.0153}}, // Quang Tri Airport
    Airport{IataCode{"HOR"}, CountryId{"PT"}, Coordinate{-28.7162, 38.5215}}, // Horta Airport
    Airport{IataCode{"HOS"}, CountryId{"AR"}, Coordinate{-70.2258, -37.4411}}, // Chos Malal Airport
    Airport{IataCode{"HOT"}, CountryId{"US"}, Coordinate{-93.0961, 34.4781}}, // Memorial Field Airport
    Airport{IataCode{"HOU"}, CountryId{"US"}, Coordinate{-95.2773, 29.6538}}, // William P. Hobby Airport
    Airport{IataCode{"HOV"}, CountryId{"NO"}, Coordinate{6.07989, 62.1801}}, // Ørsta-Volda Airport
    Airport{IataCode{"HPA"}, CountryId{"TO"}, Coordinate{-174.341, -19.7785}}, // Lifuka Island Airport
    Airport{IataCode{"HPB"}, CountryId{"US"}, Coordinate{-166.147, 61.5239}}, // Hooper Bay Airport
    Airport{IataCode{"HPG"}, CountryId{"CN"}, Coordinate{110.338, 31.6205}}, // Shennongjia Airport
    Airport{IataCode{"HPH"}, CountryId{"VN"}, Coordinate{106.726, 20.8225}}, // Cat Bi International Airport
    Airport{IataCode{"HPN"}, CountryId{"US"}, Coordinate{-73.7044, 41.0686}}, // Westchester County Airport
    Airport{IataCode{"HPV"}, CountryId{"US"}, Coordinate{-159.443, 22.2109}}, // Princeville Airport
    Airport{IataCode{"HPY"}, CountryId{"US"}, Coordinate{-94.9528, 29.7861}}, // Baytown Airport
    Airport{IataCode{"HQM"}, CountryId{"US"}, Coordinate{-123.937, 46.9711}}, // Bowerman Airport
    Airport{IataCode{"HRB"}, CountryId{"CN"}, Coordinate{126.24, 45.6229}}, // Harbin Taiping International Airport
    Airport{IataCode{"HRE"}, CountryId{"ZW"}, Coordinate{31.0991, -17.9189}}, // Harare International Airport
    Airport{IataCode{"HRG"}, CountryId{"EG"}, Coordinate{33.8062, 27.1836}}, // Hurghada International Airport
    Airport{IataCode{"HRI"}, CountryId{"LK"}, Coordinate{81.1215, 6.29131}}, // Mattala Rajapaksa International Airport
    Airport{IataCode{"HRK"}, CountryId{"UA"}, Coordinate{36.2796, 49.9217}}, // Kharkiv International Airport
    Airport{IataCode{"HRL"}, CountryId{"US"}, Coordinate{-97.6619, 26.224}}, // Valley International Airport
    Airport{IataCode{"HRM"}, CountryId{"DZ"}, Coordinate{3.30097, 32.9347}}, // Hassi R'Mel Airport
    Airport{IataCode{"HRO"}, CountryId{"US"}, Coordinate{-93.1515, 36.264}}, // Boone County Airport
    Airport{IataCode{"HRS"}, CountryId{"ZA"}, Coordinate{29.1061, -28.2351}}, // Harrismith Airport
    Airport{IataCode{"HRZ"}, CountryId{"BR"}, Coordinate{-54.3378, -27.6413}}, // Horizontina Airport
    Airport{IataCode{"HSC"}, CountryId{"CN"}, Coordinate{113.421, 24.9786}}, // Shaoguan Guitou Airport
    Airport{IataCode{"HSG"}, CountryId{"JP"}, Coordinate{130.303, 33.1534}}, // Saga Airport
    Airport{IataCode{"HSH"}, CountryId{"US"}, Coordinate{-115.139, 35.9772}}, // Henderson Executive Airport
    Airport{IataCode{"HSI"}, CountryId{"US"}, Coordinate{-98.4278, 40.6053}}, // Hastings Municipal Airport
    Airport{IataCode{"HSJ"}, CountryId{"CN"}, Coordinate{113.277, 34.8376}}, // Zhengzhou Shangjie Airport
    Airport{IataCode{"HSK"}, CountryId{"ES"}, Coordinate{-0.322551, 42.0823}}, // Huesca-Pirineos Airport
    Airport{IataCode{"HSM"}, CountryId{"AU"}, Coordinate{142.171, -36.6705}}, // Horsham Airport
    Airport{IataCode{"HSN"}, CountryId{"CN"}, Coordinate{122.357, 29.9365}}, // Zhoushan Putuoshan Airport
    Airport{IataCode{"HSS"}, CountryId{"IN"}, Coordinate{75.7553, 29.1792}}, // Hisar Airport
    Airport{IataCode{"HSV"}, CountryId{"US"}, Coordinate{-86.7746, 34.6472}}, // Huntsville International Airport
    Airport{IataCode{"HTA"}, CountryId{"RU"}, Coordinate{113.308, 52.0203}}, // Kadala Airport
    Airport{IataCode{"HTG"}, CountryId{"RU"}, Coordinate{102.487, 71.9683}}, // Khatanga Airport
    Airport{IataCode{"HTH"}, CountryId{"US"}, Coordinate{-118.634, 38.5444}}, // Hawthorne Industrial Airport
    Airport{IataCode{"HTI"}, CountryId{"AU"}, Coordinate{148.949, -20.3517}}, // Great Barrier Reef Airport
    Airport{IataCode{"HTL"}, CountryId{"US"}, Coordinate{-84.6711, 44.3597}}, // Roscommon County – Blodgett Memorial Airport
    Airport{IataCode{"HTM"}, CountryId{"MN"}, Coordinate{100.137, 50.4394}}, // Khatgal Airport
    Airport{IataCode{"HTN"}, CountryId{"CN"}, Coordinate{79.8734, 37.0397}}, // Hotan Airport
    Airport{IataCode{"HTO"}, CountryId{"US"}, Coordinate{-72.2517, 40.9594}}, // East Hampton Airport
    Airport{IataCode{"HTR"}, CountryId{"JP"}, Coordinate{123.804, 24.0583}}, // Hateruma Airport
    Airport{IataCode{"HTS"}, CountryId{"US"}, Coordinate{-82.5559, 38.3694}}, // Tri-State Airport
    Airport{IataCode{"HTT"}, CountryId{"CN"}, Coordinate{90.8417, 38.2033}}, // Huatugou Airport
    Airport{IataCode{"HTU"}, CountryId{"AU"}, Coordinate{142.36, -35.715}}, // Hopetoun Airport
    Airport{IataCode{"HTV"}, CountryId{"US"}, Coordinate{-95.5872, 30.7469}}, // Huntsville Regional Airport
    Airport{IataCode{"HTW"}, CountryId{"US"}, Coordinate{-82.4944, 38.4192}}, // Lawrence County Airpark
    Airport{IataCode{"HTY"}, CountryId{"TR"}, Coordinate{36.2819, 36.3633}}, // Hatay Airport
    Airport{IataCode{"HTZ"}, CountryId{"CO"}, Coordinate{-71.7625, 6.15278}}, // Hato Corozal Airport
    Airport{IataCode{"HUC"}, CountryId{"US"}, Coordinate{-65.8008, 18.1381}}, // Humacao Airport
    Airport{IataCode{"HUD"}, CountryId{"US"}, Coordinate{-94.2453, 42.7361}}, // Humboldt Municipal Airport
    Airport{IataCode{"HUE"}, CountryId{"ET"}, Coordinate{36.8817, 13.8303}}, // Humera Airport
    Airport{IataCode{"HUG"}, CountryId{"GT"}, Coordinate{-91.505, 15.3164}}, // Huehuetenango Airport
    Airport{IataCode{"HUH"}, CountryId{"FR"}, Coordinate{-151.022, -16.6872}}, // Huahine – Fare Airport
    Airport{IataCode{"HUI"}, CountryId{"VN"}, Coordinate{107.7, 16.3979}}, // Phu Bai International Airport
    Airport{IataCode{"HUJ"}, CountryId{"US"}, Coordinate{-95.5419, 34.0347}}, // Stan Stamper Municipal Airport
    Airport{IataCode{"HUK"}, CountryId{"BW"}, Coordinate{21.7581, -23.9897}}, // Hukuntsi Airport
    Airport{IataCode{"HUL"}, CountryId{"US"}, Coordinate{-67.7919, 46.1231}}, // Houlton International Airport
    Airport{IataCode{"HUM"}, CountryId{"US"}, Coordinate{-90.6606, 29.5664}}, // Houma-Terrebonne Airport
    Airport{IataCode{"HUN"}, CountryId{"TW"}, Coordinate{121.618, 24.0231}}, // Hualien Airport
    Airport{IataCode{"HUO"}, CountryId{"CN"}, Coordinate{119.409, 45.4867}}, // Huolinhe Airport
    Airport{IataCode{"HUQ"}, CountryId{"LY"}, Coordinate{15.95, 29.11}}, // Hun Airport
    Airport{IataCode{"HUS"}, CountryId{"US"}, Coordinate{-154.265, 66.0392}}, // Hughes Airport
    Airport{IataCode{"HUT"}, CountryId{"US"}, Coordinate{-97.8661, 38.0634}}, // Hutchinson Municipal Airport
    Airport{IataCode{"HUU"}, CountryId{"PE"}, Coordinate{-76.2048, -9.87881}}, // Alférez FAP David Figueroa Fernandini Airport
    Airport{IataCode{"HUV"}, CountryId{"SE"}, Coordinate{17.0806, 61.7683}}, // Hudiksvall Airport
    Airport{IataCode{"HUW"}, CountryId{"BR"}, Coordinate{-63.0506, -7.53361}}, // Humaitá Airport
    Airport{IataCode{"HUX"}, CountryId{"MX"}, Coordinate{-96.2585, 15.7723}}, // Bahías de Huatulco International Airport
    Airport{IataCode{"HUY"}, CountryId{"GB"}, Coordinate{-0.348614, 53.5831}}, // Humberside Airport
    Airport{IataCode{"HUZ"}, CountryId{"CN"}, Coordinate{114.6, 23.0483}}, // Huizhou Airport
    Airport{IataCode{"HVA"}, CountryId{"MG"}, Coordinate{47.7625, -14.6333}}, // Analalava Airport
    Airport{IataCode{"HVB"}, CountryId{"AU"}, Coordinate{152.885, -25.3201}}, // Hervey Bay Airport
    Airport{IataCode{"HVD"}, CountryId{"MN"}, Coordinate{91.6258, 47.9614}}, // Khovd Airport
    Airport{IataCode{"HVG"}, CountryId{"NO"}, Coordinate{25.9773, 71.0087}}, // Honningsvåg Airport, Valan
    Airport{IataCode{"HVK"}, CountryId{"IS"}, Coordinate{-21.6992, 65.7012}}, // Hólmavík Airport
    Airport{IataCode{"HVN"}, CountryId{"US"}, Coordinate{-72.891, 41.2691}}, // Tweed-New Haven Regional Airport
    Airport{IataCode{"HVR"}, CountryId{"US"}, Coordinate{-109.762, 48.5431}}, // Havre City-County Airport
    Airport{IataCode{"HVS"}, CountryId{"US"}, Coordinate{-80.1192, 34.4031}}, // Hartsville Regional Airport
    Airport{IataCode{"HWA"}, CountryId{"PG"}, Coordinate{145.967, -7.43333}}, // Hawabango
    Airport{IataCode{"HWN"}, CountryId{"ZW"}, Coordinate{27.0002, -18.6351}}, // Hwange National Park Airport
    Airport{IataCode{"HWO"}, CountryId{"US"}, Coordinate{-80.2408, 26.0011}}, // North Perry Airport
    Airport{IataCode{"HXD"}, CountryId{"CN"}, Coordinate{97.2686, 37.125}}, // Delingha Airport
    Airport{IataCode{"HXX"}, CountryId{"AU"}, Coordinate{144.83, -34.5314}}, // Hay Airport
    Airport{IataCode{"HYA"}, CountryId{"US"}, Coordinate{-70.2803, 41.6694}}, // Barnstable Municipal Airport
    Airport{IataCode{"HYC"}, CountryId{"GB"}, Coordinate{-0.808333, 51.6117}}, // Wycombe Air Park
    Airport{IataCode{"HYD"}, CountryId{"IN"}, Coordinate{78.4281, 17.24}}, // Rajiv Gandhi International Airport
    Airport{IataCode{"HYF"}, CountryId{"PG"}, Coordinate{143.058, -3.69878}}, // Hayfields Airport
    Airport{IataCode{"HYN"}, CountryId{"CN"}, Coordinate{121.429, 28.5622}}, // Taizhou Luqiao Airport
    Airport{IataCode{"HYR"}, CountryId{"US"}, Coordinate{-91.4442, 46.0253}}, // Sawyer County Airport
    Airport{IataCode{"HYS"}, CountryId{"US"}, Coordinate{-99.2731, 38.8422}}, // Hays Regional Airport
    Airport{IataCode{"HZG"}, CountryId{"CN"}, Coordinate{107.202, 33.1367}}, // Hanzhong Chenggu Airport
    Airport{IataCode{"HZH"}, CountryId{"CN"}, Coordinate{109.154, 26.3205}}, // Liping Airport
    Airport{IataCode{"HZK"}, CountryId{"IS"}, Coordinate{-17.4191, 65.9558}}, // Húsavík Airport
    Airport{IataCode{"HZL"}, CountryId{"US"}, Coordinate{-75.995, 40.9867}}, // Hazleton Municipal Airport
    Airport{IataCode{"HZP"}, CountryId{"CA"}, Coordinate{-111.701, 57.3817}}, // Fort MacKay/Horizon Airport
    Airport{IataCode{"IAA"}, CountryId{"RU"}, Coordinate{86.6217, 67.4367}}, // Igarka Airport
    Airport{IataCode{"IAD"}, CountryId{"US"}, Coordinate{-77.4475, 38.949}}, // Washington Dulles International Airport
    Airport{IataCode{"IAG"}, CountryId{"US"}, Coordinate{-78.941, 43.1013}}, // Niagara Falls International Airport
    Airport{IataCode{"IAH"}, CountryId{"US"}, Coordinate{-95.3414, 29.9844}}, // George Bush Intercontinental Airport
    Airport{IataCode{"IAM"}, CountryId{"DZ"}, Coordinate{9.638, 28.0516}}, // In Aménas Airport
    Airport{IataCode{"IAN"}, CountryId{"US"}, Coordinate{-160.437, 66.9758}}, // Bob Baker Memorial Airport
    Airport{IataCode{"IAO"}, CountryId{"PH"}, Coordinate{126.016, 9.85697}}, // Sayak Airport
    Airport{IataCode{"IAR"}, CountryId{"RU"}, Coordinate{40.1702, 57.5622}}, // Tunoshna Airport
    Airport{IataCode{"IAS"}, CountryId{"RO"}, Coordinate{27.6179, 47.1766}}, // Iași International Airport
    Airport{IataCode{"IBA"}, CountryId{"NG"}, Coordinate{3.97296, 7.36048}}, // Ibadan Airport
    Airport{IataCode{"IBE"}, CountryId{"CO"}, Coordinate{-75.1408, 4.42526}}, // Perales Airport
    Airport{IataCode{"IBI"}, CountryId{"PG"}, Coordinate{146.267, -8.4}}, // Iboki
    Airport{IataCode{"IBL"}, CountryId{"MZ"}, Coordinate{35.4522, -21.7072}}, // Indigo Bay Lodge Airport
    Airport{IataCode{"IBP"}, CountryId{"PE"}, Coordinate{-69.4889, -11.4117}}, // Iberia Airport
    Airport{IataCode{"IBZ"}, CountryId{"ES"}, Coordinate{1.36809, 38.8762}}, // Ibiza Airport
    Airport{IataCode{"ICA"}, CountryId{"VE"}, Coordinate{-61.7407, 4.33337}}, // Icabaru Airport
    Airport{IataCode{"ICC"}, CountryId{"VE"}, Coordinate{-63.9814, 10.7942}}, // Andrés Miguel Salazar Marcano Airport
    Airport{IataCode{"ICI"}, CountryId{"FJ"}, Coordinate{-179.341, -17.7396}}, // Cicia Airport
    Airport{IataCode{"ICK"}, CountryId{"SR"}, Coordinate{-57.0404, 5.95635}}, // Majoor Henk Fernandes Airport
    Airport{IataCode{"ICN"}, CountryId{"KR"}, Coordinate{126.439, 37.4625}}, // Incheon International Airport
    Airport{IataCode{"ICR"}, CountryId{"CU"}, Coordinate{-75.5333, 20.6833}}, // Nicaro Airport
    Airport{IataCode{"ICT"}, CountryId{"US"}, Coordinate{-97.431, 37.6533}}, // Wichita Dwight D. Eisenhower National Airport
    Airport{IataCode{"ICY"}, CountryId{"US"}, Coordinate{-141.662, 59.969}}, // Icy Bay Airport
    Airport{IataCode{"IDA"}, CountryId{"US"}, Coordinate{-112.068, 43.515}}, // Idaho Falls Regional Airport
    Airport{IataCode{"IDF"}, CountryId{"CD"}, Coordinate{19.6, -5}}, // Idiofa Airport
    Airport{IataCode{"IDH"}, CountryId{"US"}, Coordinate{-116.123, 45.9425}}, // Idaho County Airport
    Airport{IataCode{"IDI"}, CountryId{"US"}, Coordinate{-79.1027, 40.6348}}, // Indiana County-Jimmy Stewart Airport
    Airport{IataCode{"IDP"}, CountryId{"US"}, Coordinate{-95.7783, 37.1583}}, // Independence Municipal Airport
    Airport{IataCode{"IDR"}, CountryId{"IN"}, Coordinate{75.8068, 22.7277}}, // Devi Ahilyabai Holkar Airport
    Airport{IataCode{"IDY"}, CountryId{"FR"}, Coordinate{-2.38942, 46.7176}}, // Île d'Yeu Aerodrome
    Airport{IataCode{"IEG"}, CountryId{"PL"}, Coordinate{15.7779, 52.1371}}, // Zielona Góra Airport
    Airport{IataCode{"IEJ"}, CountryId{"JP"}, Coordinate{127.787, 26.7225}}, // Iejima Airport
    Airport{IataCode{"IEV"}, CountryId{"UA"}, Coordinate{30.4435, 50.4115}}, // Kyiv Zhuliany International Airport
    Airport{IataCode{"IFJ"}, CountryId{"IS"}, Coordinate{-23.1425, 66.0553}}, // Ísafjörður Airport
    Airport{IataCode{"IFL"}, CountryId{"AU"}, Coordinate{146.012, -17.5586}}, // Innisfail Airport
    Airport{IataCode{"IFN"}, CountryId{"IR"}, Coordinate{51.8611, 32.7508}}, // Isfahan International Airport
    Airport{IataCode{"IFO"}, CountryId{"UA"}, Coordinate{24.707, 48.8873}}, // Ivano-Frankivsk International Airport
    Airport{IataCode{"IFP"}, CountryId{"US"}, Coordinate{-114.556, 35.1652}}, // Laughlin/Bullhead International Airport
    Airport{IataCode{"IGA"}, CountryId{"BS"}, Coordinate{-73.6751, 20.9744}}, // Inagua Airport
    Airport{IataCode{"IGB"}, CountryId{"AR"}, Coordinate{-69.5719, -41.3224}}, // Ingeniero Jacobacci Airport
    Airport{IataCode{"IGD"}, CountryId{"TR"}, Coordinate{43.8786, 39.9801}}, // Iğdır Airport
    Airport{IataCode{"IGE"}, CountryId{"GA"}, Coordinate{9.31389, -1.93333}}, // Tchongorove Airport
    Airport{IataCode{"IGG"}, CountryId{"US"}, Coordinate{-155.902, 59.3242}}, // Igiugig Airport
    Airport{IataCode{"IGH"}, CountryId{"AU"}, Coordinate{146.152, -18.6606}}, // Ingham Airport
    Airport{IataCode{"IGM"}, CountryId{"US"}, Coordinate{-113.938, 35.2594}}, // Kingman Airport
    Airport{IataCode{"IGN"}, CountryId{"PH"}, Coordinate{124.212, 8.12614}}, // Maria Cristina Airport
    Airport{IataCode{"IGO"}, CountryId{"CO"}, Coordinate{-76.6865, 7.67719}}, // Chigorodó Airport
    Airport{IataCode{"IGR"}, CountryId{"AR"}, Coordinate{-54.476, -25.7313}}, // Cataratas del Iguazú International Airport
    Airport{IataCode{"IGT"}, CountryId{"RU"}, Coordinate{45.013, 43.3193}}, // Magas Airport
    Airport{IataCode{"IGU"}, CountryId{"BR"}, Coordinate{-54.4886, -25.5977}}, // Foz do Iguaçu International Airport
    Airport{IataCode{"IHC"}, CountryId{"MZ"}, Coordinate{32.9292, -25.9978}}, // Inhaca Airport
    Airport{IataCode{"IHN"}, CountryId{"YE"}, Coordinate{51.683, 15.4167}}, // Qishn Airport
    Airport{IataCode{"IHO"}, CountryId{"MG"}, Coordinate{46.1651, -22.4061}}, // Ihosy Airport
    Airport{IataCode{"IHR"}, CountryId{"IR"}, Coordinate{60.7185, 27.2286}}, // Iranshahr Airport
    Airport{IataCode{"IHU"}, CountryId{"PG"}, Coordinate{145.4, -7.90017}}, // Ihu Airport
    Airport{IataCode{"IIA"}, CountryId{"IE"}, Coordinate{-9.57, 53.0919}}, // Inishmaan Aerodrome
    Airport{IataCode{"IIL"}, CountryId{"IR"}, Coordinate{46.3993, 33.5865}}, // Ilam Airport
    Airport{IataCode{"IIS"}, CountryId{"PG"}, Coordinate{154.227, -4.5}}, // Nissan Island Airport
    Airport{IataCode{"IJK"}, CountryId{"RU"}, Coordinate{53.4506, 56.8308}}, // Izhevsk Airport
    Airport{IataCode{"IJU"}, CountryId{"BR"}, Coordinate{-53.8456, -28.37}}, // Ijuí Airport
    Airport{IataCode{"IKA"}, CountryId{"IR"}, Coordinate{51.1522, 35.4161}}, // Tehran Imam Khomeini International Airport
    Airport{IataCode{"IKB"}, CountryId{"US"}, Coordinate{-81.0983, 36.2228}}, // Wilkes County Airport
    Airport{IataCode{"IKI"}, CountryId{"JP"}, Coordinate{129.786, 33.7492}}, // Iki Airport
    Airport{IataCode{"IKK"}, CountryId{"US"}, Coordinate{-87.8464, 41.0714}}, // Greater Kankakee Airport
    Airport{IataCode{"IKL"}, CountryId{"CD"}, Coordinate{23.2833, -1.2}}, // Ikela Airport
    Airport{IataCode{"IKS"}, CountryId{"RU"}, Coordinate{128.888, 71.6985}}, // Tiksi Airport
    Airport{IataCode{"IKT"}, CountryId{"RU"}, Coordinate{104.353, 52.2729}}, // Irkutsk International Airport
    Airport{IataCode{"IKU"}, CountryId{"KG"}, Coordinate{76.7133, 42.5883}}, // Tamchy Airport
    Airport{IataCode{"ILD"}, CountryId{"ES"}, Coordinate{0.542506, 41.7293}}, // Lleida-Alguaire Airport
    Airport{IataCode{"ILE"}, CountryId{"US"}, Coordinate{-97.6833, 31.0874}}, // Skylark Field
    Airport{IataCode{"ILF"}, CountryId{"CA"}, Coordinate{-95.6181, 56.0517}}, // Ilford Airport
    Airport{IataCode{"ILG"}, CountryId{"US"}, Coordinate{-75.6067, 39.6786}}, // New Castle Airport
    Airport{IataCode{"ILI"}, CountryId{"US"}, Coordinate{-154.911, 59.7539}}, // Iliamna Airport
    Airport{IataCode{"ILK"}, CountryId{"MG"}, Coordinate{48.8, -19.5833}}, // Atsinanana Airport
    Airport{IataCode{"ILL"}, CountryId{"US"}, Coordinate{-95.1325, 45.1146}}, // Willmar Municipal Airport
    Airport{IataCode{"ILM"}, CountryId{"US"}, Coordinate{-77.9025, 34.2706}}, // Wilmington International Airport
    Airport{IataCode{"ILN"}, CountryId{"US"}, Coordinate{-83.7848, 39.4358}}, // Wilmington Air Park
    Airport{IataCode{"ILO"}, CountryId{"PH"}, Coordinate{122.493, 10.7147}}, // Iloilo International Airport
    Airport{IataCode{"ILP"}, CountryId{"FR"}, Coordinate{167.451, -22.5869}}, // Île des Pins Airport
    Airport{IataCode{"ILQ"}, CountryId{"PE"}, Coordinate{-71.3606, -17.695}}, // Ilo Airport
    Airport{IataCode{"ILR"}, CountryId{"NG"}, Coordinate{4.49491, 8.43543}}, // Ilorin International Airport
    Airport{IataCode{"ILS"}, CountryId{"SV"}, Coordinate{-89.1256, 13.6917}}, // Ilopango International Airport
    Airport{IataCode{"ILU"}, CountryId{"KE"}, Coordinate{38.0675, -2.91914}}, // Kilaguni Airport
    Airport{IataCode{"ILX"}, CountryId{"PG"}, Coordinate{145.833, -5.48333}}, // Ileg
    Airport{IataCode{"ILY"}, CountryId{"GB"}, Coordinate{-6.24831, 55.6836}}, // Islay Airport
    Airport{IataCode{"ILZ"}, CountryId{"SK"}, Coordinate{18.6166, 49.2321}}, // Žilina Airport
    Airport{IataCode{"IMA"}, CountryId{"PG"}, Coordinate{150.5, -9.5}}, // Iamalele
    Airport{IataCode{"IMB"}, CountryId{"GY"}, Coordinate{-60.2833, 5.71667}}, // Imbaimadai Airport
    Airport{IataCode{"IMI"}, CountryId{"MH"}, Coordinate{171.483, 7.01667}}, // Ine Airport
    Airport{IataCode{"IMK"}, CountryId{"NP"}, Coordinate{81.8189, 29.9711}}, // Simikot Airport
    Airport{IataCode{"IMM"}, CountryId{"US"}, Coordinate{-81.4028, 26.4325}}, // Immokalee Airport
    Airport{IataCode{"IMO"}, CountryId{"CF"}, Coordinate{25.1056, 5}}, // Zemio Airport
    Airport{IataCode{"IMP"}, CountryId{"BR"}, Coordinate{-47.4562, -5.53173}}, // Imperatriz Airport
    Airport{IataCode{"IMQ"}, CountryId{"IR"}, Coordinate{44.9237, 39.1897}}, // Maku International Airport
    Airport{IataCode{"IMS"}, CountryId{"US"}, Coordinate{-85.4647, 38.76}}, // Madison Municipal Airport
    Airport{IataCode{"IMT"}, CountryId{"US"}, Coordinate{-88.1177, 45.815}}, // Ford Airport
    Airport{IataCode{"INA"}, CountryId{"RU"}, Coordinate{60.1184, 66.0531}}, // Inta Airport
    Airport{IataCode{"INB"}, CountryId{"BZ"}, Coordinate{-88.4106, 16.5219}}, // Independence Airport (Belize)
    Airport{IataCode{"INC"}, CountryId{"CN"}, Coordinate{106.384, 38.3216}}, // Yinchuan Hedong International Airport
    Airport{IataCode{"IND"}, CountryId{"US"}, Coordinate{-86.2944, 39.7172}}, // Indianapolis International Airport
    Airport{IataCode{"INE"}, CountryId{"MZ"}, Coordinate{36.4333, -18.5833}}, // Chinde Airport
    Airport{IataCode{"INF"}, CountryId{"DZ"}, Coordinate{5.74889, 19.5689}}, // In Guezzam Airport
    Airport{IataCode{"INH"}, CountryId{"MZ"}, Coordinate{35.4049, -23.877}}, // Inhambane Airport
    Airport{IataCode{"INI"}, CountryId{"RS"}, Coordinate{21.8664, 43.3378}}, // Niš Constantine the Great Airport
    Airport{IataCode{"INJ"}, CountryId{"US"}, Coordinate{-97.0972, 32.0833}}, // Hillsboro Municipal Airport
    Airport{IataCode{"INK"}, CountryId{"US"}, Coordinate{-103.195, 31.7828}}, // Winkler County Airport
    Airport{IataCode{"INL"}, CountryId{"US"}, Coordinate{-93.398, 48.566}}, // Falls International Airport
    Airport{IataCode{"INN"}, CountryId{"AT"}, Coordinate{11.3523, 47.2576}}, // Innsbruck Airport
    Airport{IataCode{"INO"}, CountryId{"CD"}, Coordinate{18.2858, -1.94722}}, // Inongo Airport
    Airport{IataCode{"INQ"}, CountryId{"IE"}, Coordinate{-9.51111, 53.0586}}, // Inisheer Aerodrome
    Airport{IataCode{"INT"}, CountryId{"US"}, Coordinate{-80.2284, 36.1371}}, // Smith Reynolds Airport
    Airport{IataCode{"INU"}, CountryId{"NR"}, Coordinate{166.918, -0.544762}}, // Nauru International Airport
    Airport{IataCode{"INV"}, CountryId{"GB"}, Coordinate{-4.06358, 57.5395}}, // Inverness Airport
    Airport{IataCode{"INW"}, CountryId{"US"}, Coordinate{-110.716, 35.022}}, // Winslow-Lindbergh Regional Airport
    Airport{IataCode{"INZ"}, CountryId{"DZ"}, Coordinate{2.50885, 27.2518}}, // In Salah Airport
    Airport{IataCode{"IOA"}, CountryId{"GR"}, Coordinate{20.8228, 39.6925}}, // Ioannina National Airport
    Airport{IataCode{"IOM"}, CountryId{"IM"}, Coordinate{-4.63428, 54.0868}}, // Isle of Man Airport
    Airport{IataCode{"ION"}, CountryId{"CG"}, Coordinate{18.045, 1.58333}}, // Impfondo Airport
    Airport{IataCode{"IOR"}, CountryId{"IE"}, Coordinate{-9.65389, 53.1062}}, // Inishmore Aerodrome
    Airport{IataCode{"IOS"}, CountryId{"BR"}, Coordinate{-39.0333, -14.815}}, // Ilhéus Jorge Amado Airport
    Airport{IataCode{"IOW"}, CountryId{"US"}, Coordinate{-91.5418, 41.6396}}, // Iowa City Municipal Airport
    Airport{IataCode{"IPA"}, CountryId{"VU"}, Coordinate{169.283, -18.8564}}, // Ipota Airport
    Airport{IataCode{"IPC"}, CountryId{"CL"}, Coordinate{-109.43, -27.1589}}, // Mataveri International Airport
    Airport{IataCode{"IPE"}, CountryId{"PH"}, Coordinate{122.601, 7.78614}}, // Ipil Airport
    Airport{IataCode{"IPG"}, CountryId{"BR"}, Coordinate{-69.6947, -2.93361}}, // Ipiranga Airport
    Airport{IataCode{"IPH"}, CountryId{"MY"}, Coordinate{101.098, 4.57024}}, // Sultan Azlan Shah Airport
    Airport{IataCode{"IPI"}, CountryId{"CO"}, Coordinate{-77.6755, 0.858464}}, // San Luis Airport
    Airport{IataCode{"IPL"}, CountryId{"US"}, Coordinate{-115.579, 32.8342}}, // Imperial County Airport
    Airport{IataCode{"IPN"}, CountryId{"BR"}, Coordinate{-42.4878, -19.4742}}, // Ipatinga Airport
    Airport{IataCode{"IPT"}, CountryId{"US"}, Coordinate{-76.9217, 41.2417}}, // Williamsport Regional Airport
    Airport{IataCode{"IQN"}, CountryId{"CN"}, Coordinate{107.605, 35.802}}, // Qingyang Airport
    Airport{IataCode{"IQQ"}, CountryId{"CL"}, Coordinate{-70.1787, -20.5477}}, // Diego Aracena International Airport
    Airport{IataCode{"IQT"}, CountryId{"PE"}, Coordinate{-73.3086, -3.78472}}, // Crnl. FAP Francisco Secada Vignetta International Airport
    Airport{IataCode{"IRA"}, CountryId{"SB"}, Coordinate{161.898, -10.4494}}, // Kirakira Airport
    Airport{IataCode{"IRC"}, CountryId{"US"}, Coordinate{-144.076, 65.8278}}, // Circle City Airport
    Airport{IataCode{"IRD"}, CountryId{"BD"}, Coordinate{89.0486, 24.1532}}, // Ishurdi Airport
    Airport{IataCode{"IRG"}, CountryId{"AU"}, Coordinate{143.305, -12.7869}}, // Lockhart River Airport
    Airport{IataCode{"IRI"}, CountryId{"TZ"}, Coordinate{35.7519, -7.66944}}, // Iringa Airport
    Airport{IataCode{"IRJ"}, CountryId{"AR"}, Coordinate{-66.7942, -29.3838}}, // Capitán Vicente Almandos Almonacid Airport
    Airport{IataCode{"IRK"}, CountryId{"US"}, Coordinate{-92.5406, 40.0933}}, // Kirksville Regional Airport
    Airport{IataCode{"IRN"}, CountryId{"HN"}, Coordinate{-85.1833, 15.95}}, // Iriona
    Airport{IataCode{"IRO"}, CountryId{"CF"}, Coordinate{22.7169, 10.2364}}, // Birao Airport
    Airport{IataCode{"IRP"}, CountryId{"CD"}, Coordinate{27.598, 2.82292}}, // Matari Airport
    Airport{IataCode{"IRZ"}, CountryId{"BR"}, Coordinate{-65.0339, -0.41694}}, // Tapuruquara Airport
    Airport{IataCode{"ISA"}, CountryId{"AU"}, Coordinate{139.489, -20.6639}}, // Mount Isa Airport
    Airport{IataCode{"ISB"}, CountryId{"PK"}, Coordinate{72.8331, 33.5563}}, // Islamabad International Airport
    Airport{IataCode{"ISC"}, CountryId{"GB"}, Coordinate{-6.29485, 49.9142}}, // St Mary's Airport
    Airport{IataCode{"ISE"}, CountryId{"TR"}, Coordinate{30.3819, 37.865}}, // Isparta Süleyman Demirel Airport
    Airport{IataCode{"ISG"}, CountryId{"JP"}, Coordinate{124.246, 24.3909}}, // New Ishigaki Airport
    Airport{IataCode{"ISI"}, CountryId{"AU"}, Coordinate{144.425, -24.2583}}, // Isisford Airport
    Airport{IataCode{"ISJ"}, CountryId{"MX"}, Coordinate{-86.7403, 21.2456}}, // Isla Mujeres Airport
    Airport{IataCode{"ISK"}, CountryId{"IN"}, Coordinate{73.9131, 20.1192}}, // Ozar Airport
    Airport{IataCode{"ISL"}, CountryId{"TR"}, Coordinate{28.8211, 40.9797}}, // Atatürk International Airport
    Airport{IataCode{"ISM"}, CountryId{"US"}, Coordinate{-81.4372, 28.2897}}, // Kissimmee Gateway Airport
    Airport{IataCode{"ISO"}, CountryId{"US"}, Coordinate{-77.6117, 35.3233}}, // Kinston Regional Jetport
    Airport{IataCode{"ISP"}, CountryId{"US"}, Coordinate{-73.0966, 40.7897}}, // Long Island MacArthur Airport
    Airport{IataCode{"ISQ"}, CountryId{"US"}, Coordinate{-86.1717, 45.9744}}, // Schoolcraft County Airport
    Airport{IataCode{"ISS"}, CountryId{"US"}, Coordinate{-69.7106, 43.964}}, // Wiscasset Airport
    Airport{IataCode{"IST"}, CountryId{"TR"}, Coordinate{28.7424, 41.2626}}, // Istanbul Airport
    Airport{IataCode{"ISU"}, CountryId{"IQ"}, Coordinate{45.3256, 35.5598}}, // Sulaimaniyah International Airport
    Airport{IataCode{"ISW"}, CountryId{"US"}, Coordinate{-89.8338, 44.3619}}, // South Wood County Airport
    Airport{IataCode{"ITA"}, CountryId{"BR"}, Coordinate{-58.4817, -3.12639}}, // Itacoatiara Airport
    Airport{IataCode{"ITB"}, CountryId{"BR"}, Coordinate{-56.0008, -4.24222}}, // Itaituba Airport
    Airport{IataCode{"ITH"}, CountryId{"US"}, Coordinate{-76.4586, 42.4914}}, // Ithaca Tompkins Regional Airport
    Airport{IataCode{"ITK"}, CountryId{"PG"}, Coordinate{147.3, -9.51667}}, // Itokama
    Airport{IataCode{"ITM"}, CountryId{"JP"}, Coordinate{135.44, 34.7905}}, // Osaka International Airport
    Airport{IataCode{"ITO"}, CountryId{"US"}, Coordinate{-155.04, 19.7148}}, // Hilo International Airport
    Airport{IataCode{"ITQ"}, CountryId{"BR"}, Coordinate{-56.5367, -29.1731}}, // Itaqui Airport
    Airport{IataCode{"ITR"}, CountryId{"BR"}, Coordinate{-49.2142, -18.445}}, // Itumbiara Airport
    Airport{IataCode{"ITU"}, CountryId{"RU"}, Coordinate{147.955, 45.2599}}, // Iturup Airport
    Airport{IataCode{"IUE"}, CountryId{"NU"}, Coordinate{-169.926, -19.0768}}, // Niue International Airport
    Airport{IataCode{"IUS"}, CountryId{"PG"}, Coordinate{155.15, -5.8613}}, // Inus Airport
    Airport{IataCode{"IVA"}, CountryId{"MG"}, Coordinate{48.6328, -13.485}}, // Ampapamena Airport
    Airport{IataCode{"IVC"}, CountryId{"NZ"}, Coordinate{168.322, -46.4156}}, // Invercargill Airport
    Airport{IataCode{"IVL"}, CountryId{"FI"}, Coordinate{27.4139, 68.6108}}, // Ivalo Airport
    Airport{IataCode{"IVR"}, CountryId{"AU"}, Coordinate{151.141, -29.8838}}, // Inverell Airport
    Airport{IataCode{"IWA"}, CountryId{"RU"}, Coordinate{40.9437, 56.9423}}, // Ivanovo Yuzhny Airport
    Airport{IataCode{"IWD"}, CountryId{"US"}, Coordinate{-90.1314, 46.5275}}, // Gogebic-Iron County Airport
    Airport{IataCode{"IWJ"}, CountryId{"JP"}, Coordinate{131.797, 34.6784}}, // Iwami Airport
    Airport{IataCode{"IWS"}, CountryId{"US"}, Coordinate{-95.6737, 29.8156}}, // West Houston Airport
    Airport{IataCode{"IXA"}, CountryId{"IN"}, Coordinate{91.2441, 23.8928}}, // Agartala Airport
    Airport{IataCode{"IXB"}, CountryId{"IN"}, Coordinate{88.3286, 26.6811}}, // Bagdogra Airport
    Airport{IataCode{"IXD"}, CountryId{"IN"}, Coordinate{81.7326, 25.4441}}, // Allahabad Airport
    Airport{IataCode{"IXE"}, CountryId{"IN"}, Coordinate{74.8897, 12.9619}}, // Mangalore Airport
    Airport{IataCode{"IXG"}, CountryId{"IN"}, Coordinate{74.6111, 15.863}}, // Belgaum Airport
    Airport{IataCode{"IXH"}, CountryId{"IN"}, Coordinate{92.0062, 24.3092}}, // Kailashahar Airport
    Airport{IataCode{"IXI"}, CountryId{"IN"}, Coordinate{94.0928, 27.2875}}, // Lilabari Airport
    Airport{IataCode{"IXJ"}, CountryId{"IN"}, Coordinate{74.8422, 32.681}}, // Jammu Airport
    Airport{IataCode{"IXK"}, CountryId{"IN"}, Coordinate{70.2671, 21.318}}, // Keshod Airport
    Airport{IataCode{"IXL"}, CountryId{"IN"}, Coordinate{77.5557, 34.1425}}, // Kushok Bakula Rimpochee Airport
    Airport{IataCode{"IXM"}, CountryId{"IN"}, Coordinate{78.0894, 9.83859}}, // Madurai International Airport
    Airport{IataCode{"IXN"}, CountryId{"IN"}, Coordinate{91.6039, 24.0617}}, // Khowai Airport
    Airport{IataCode{"IXP"}, CountryId{"IN"}, Coordinate{75.6344, 32.2336}}, // Pathankot Airport
    Airport{IataCode{"IXQ"}, CountryId{"IN"}, Coordinate{91.8142, 24.1317}}, // Kamalpur Airport
    Airport{IataCode{"IXR"}, CountryId{"IN"}, Coordinate{85.3252, 23.3171}}, // Birsa Munda Airport
    Airport{IataCode{"IXS"}, CountryId{"IN"}, Coordinate{92.9797, 24.916}}, // Silchar Airport
    Airport{IataCode{"IXT"}, CountryId{"IN"}, Coordinate{95.3833, 28.1}}, // Pasighat Airport
    Airport{IataCode{"IXU"}, CountryId{"IN"}, Coordinate{75.3963, 19.8669}}, // Aurangabad Airport
    Airport{IataCode{"IXV"}, CountryId{"IN"}, Coordinate{94.8019, 28.1753}}, // Along Airport
    Airport{IataCode{"IXW"}, CountryId{"IN"}, Coordinate{86.1722, 22.8153}}, // Sonari Airport
    Airport{IataCode{"IXY"}, CountryId{"IN"}, Coordinate{70.104, 23.1116}}, // Kandla Airport
    Airport{IataCode{"IXZ"}, CountryId{"IN"}, Coordinate{92.7329, 11.6502}}, // Veer Savarkar International Airport
    Airport{IataCode{"IYK"}, CountryId{"US"}, Coordinate{-117.827, 35.6527}}, // Inyokern Airport
    Airport{IataCode{"IZA"}, CountryId{"BR"}, Coordinate{-43.1622, -21.5102}}, // Zona da Mata Regional Airport
    Airport{IataCode{"IZL"}, CountryId{"UA"}, Coordinate{28.8014, 45.3922}}, // Izmail International Airport
    Airport{IataCode{"IZO"}, CountryId{"JP"}, Coordinate{132.886, 35.4148}}, // Izumo Airport
    Airport{IataCode{"IZT"}, CountryId{"MX"}, Coordinate{-95.0903, 16.439}}, // Ixtepec Airport
    Airport{IataCode{"JAA"}, CountryId{"AF"}, Coordinate{70.4985, 34.3997}}, // Jalalabad Airport
    Airport{IataCode{"JAB"}, CountryId{"AU"}, Coordinate{132.893, -12.6583}}, // Jabiru Airport
    Airport{IataCode{"JAC"}, CountryId{"US"}, Coordinate{-110.736, 43.6034}}, // Jackson Hole Airport
    Airport{IataCode{"JAD"}, CountryId{"AU"}, Coordinate{115.88, -32.093}}, // Jandakot Airport
    Airport{IataCode{"JAE"}, CountryId{"PE"}, Coordinate{-78.7742, -5.59528}}, // Shumba Airport
    Airport{IataCode{"JAI"}, CountryId{"IN"}, Coordinate{75.8059, 26.8278}}, // Jaipur International Airport
    Airport{IataCode{"JAK"}, CountryId{"HT"}, Coordinate{-72.5186, 18.2411}}, // Jacmel Airport
    Airport{IataCode{"JAL"}, CountryId{"MX"}, Coordinate{-96.7975, 19.475}}, // El Lencero Airport
    Airport{IataCode{"JAN"}, CountryId{"US"}, Coordinate{-90.0757, 32.3103}}, // Jackson-Evers International Airport
    Airport{IataCode{"JAP"}, CountryId{"CR"}, Coordinate{-84.7833, 9.98141}}, // Chacarita Airport
    Airport{IataCode{"JAQ"}, CountryId{"PG"}, Coordinate{151.507, -5.6525}}, // Jacquinot Bay Airport
    Airport{IataCode{"JAR"}, CountryId{"IR"}, Coordinate{53.5333, 28.4833}}, // Jahrom Airport
    Airport{IataCode{"JAT"}, CountryId{"MH"}, Coordinate{168.978, 7.75}}, // Jabot Airport
    Airport{IataCode{"JAU"}, CountryId{"PE"}, Coordinate{-75.4733, -11.7831}}, // Francisco Carle Airport
    Airport{IataCode{"JAV"}, CountryId{"GL"}, Coordinate{-51.0661, 69.2406}}, // Ilulissat Airport
    Airport{IataCode{"JAX"}, CountryId{"US"}, Coordinate{-81.6848, 30.4918}}, // Jacksonville International Airport
    Airport{IataCode{"JBB"}, CountryId{"ID"}, Coordinate{113.696, -8.24327}}, // Notohadinegoro Airport
    Airport{IataCode{"JBQ"}, CountryId{"DO"}, Coordinate{-69.9818, 18.5758}}, // La Isabela International Airport
    Airport{IataCode{"JBR"}, CountryId{"US"}, Coordinate{-90.6464, 35.8317}}, // Jonesboro Municipal Airport
    Airport{IataCode{"JBS"}, CountryId{"BR"}, Coordinate{-56.0328, -28.6531}}, // São Borja Airport
    Airport{IataCode{"JCB"}, CountryId{"BR"}, Coordinate{-51.5517, -27.1728}}, // Joaçaba Airport
    Airport{IataCode{"JCI"}, CountryId{"US"}, Coordinate{-94.8903, 38.8308}}, // New Century AirCenter
    Airport{IataCode{"JCK"}, CountryId{"AU"}, Coordinate{141.722, -20.6683}}, // Julia Creek Airport
    Airport{IataCode{"JCU"}, CountryId{"ES"}, Coordinate{-5.30639, 35.8928}}, // Ceuta Heliport
    Airport{IataCode{"JDA"}, CountryId{"US"}, Coordinate{-118.968, 44.4028}}, // Grant County Regional Airport
    Airport{IataCode{"JDF"}, CountryId{"BR"}, Coordinate{-43.3846, -21.793}}, // Juiz de Fora Airport
    Airport{IataCode{"JDG"}, CountryId{"KR"}, Coordinate{126.713, 33.3983}}, // Jungseok Airport
    Airport{IataCode{"JDH"}, CountryId{"IN"}, Coordinate{73.0503, 26.2637}}, // Jodhpur Airport
    Airport{IataCode{"JDN"}, CountryId{"US"}, Coordinate{-106.953, 47.3289}}, // Jordan Airport
    Airport{IataCode{"JDO"}, CountryId{"BR"}, Coordinate{-39.2723, -7.21519}}, // Juazeiro do Norte Airport
    Airport{IataCode{"JDZ"}, CountryId{"CN"}, Coordinate{117.176, 29.3386}}, // Jingdezhen Luojia Airport
    Airport{IataCode{"JED"}, CountryId{"SA"}, Coordinate{39.1738, 21.6605}}, // King Abdulaziz International Airport
    Airport{IataCode{"JEE"}, CountryId{"HT"}, Coordinate{-74.1709, 18.6627}}, // Jérémie Airport
    Airport{IataCode{"JEF"}, CountryId{"US"}, Coordinate{-92.1649, 38.5934}}, // Jefferson City Memorial Airport
    Airport{IataCode{"JEG"}, CountryId{"GL"}, Coordinate{-52.7924, 68.7199}}, // Aasiaat Airport
    Airport{IataCode{"JEJ"}, CountryId{"MH"}, Coordinate{168.962, 7.565}}, // Jeh Airport
    Airport{IataCode{"JEQ"}, CountryId{"BR"}, Coordinate{-40.0714, -13.8778}}, // Jequié Airport
    Airport{IataCode{"JER"}, CountryId{"GB"}, Coordinate{-2.19498, 49.2048}}, // Jersey Airport
    Airport{IataCode{"JFK"}, CountryId{"US"}, Coordinate{-73.7789, 40.6397}}, // John F. Kennedy International Airport
    Airport{IataCode{"JFN"}, CountryId{"US"}, Coordinate{-80.6956, 41.7781}}, // Northeast Ohio Regional Airport
    Airport{IataCode{"JFR"}, CountryId{"GL"}, Coordinate{-49.67, 62.0121}}, // Paamiut Airport
    Airport{IataCode{"JGA"}, CountryId{"IN"}, Coordinate{70.0159, 22.4608}}, // Jamnagar Airport
    Airport{IataCode{"JGB"}, CountryId{"IN"}, Coordinate{82.0366, 19.0761}}, // Jagdalpur Airport
    Airport{IataCode{"JGD"}, CountryId{"CN"}, Coordinate{124.111, 50.3734}}, // Jiagedaqi Airport
    Airport{IataCode{"JGN"}, CountryId{"CN"}, Coordinate{98.3403, 39.8636}}, // Jiayuguan Airport
    Airport{IataCode{"JGS"}, CountryId{"CN"}, Coordinate{114.737, 26.8575}}, // Jinggangshan Airport
    Airport{IataCode{"JHB"}, CountryId{"MY"}, Coordinate{103.666, 1.63581}}, // Senai International Airport
    Airport{IataCode{"JHG"}, CountryId{"CN"}, Coordinate{100.766, 21.9778}}, // Xishuangbanna Gasa International Airport
    Airport{IataCode{"JHL"}, CountryId{"CA"}, Coordinate{-111.419, 57.2239}}, // Fort MacKay/Albian Aerodrome
    Airport{IataCode{"JHM"}, CountryId{"US"}, Coordinate{-156.675, 20.9621}}, // Kapalua Airport
    Airport{IataCode{"JHQ"}, CountryId{"AU"}, Coordinate{148.755, -20.2767}}, // Whitsunday Airport
    Airport{IataCode{"JHS"}, CountryId{"GL"}, Coordinate{-53.7224, 66.952}}, // Sisimiut Airport
    Airport{IataCode{"JHW"}, CountryId{"US"}, Coordinate{-79.2581, 42.1533}}, // Chautauqua County-Jamestown Airport
    Airport{IataCode{"JIA"}, CountryId{"BR"}, Coordinate{-58.7114, -11.4186}}, // Juína Airport
    Airport{IataCode{"JIB"}, CountryId{"DJ"}, Coordinate{43.1497, 11.5522}}, // Djibouti-Ambouli International Airport
    Airport{IataCode{"JIC"}, CountryId{"CN"}, Coordinate{102.344, 38.5399}}, // Jinchang Jinchuan Airport
    Airport{IataCode{"JIJ"}, CountryId{"ET"}, Coordinate{42.9083, 9.33174}}, // Jijiga Airport
    Airport{IataCode{"JIK"}, CountryId{"GR"}, Coordinate{26.3443, 37.6831}}, // Ikaria Island National Airport
    Airport{IataCode{"JIM"}, CountryId{"ET"}, Coordinate{36.8207, 7.6663}}, // Aba Segud Airport
    Airport{IataCode{"JIN"}, CountryId{"UG"}, Coordinate{33.1946, 0.45019}}, // Jinja Airport
    Airport{IataCode{"JIO"}, CountryId{"ID"}, Coordinate{127.909, -8.14056}}, // Moa Airport
    Airport{IataCode{"JIP"}, CountryId{"EC"}, Coordinate{-80.6667, -1}}, // Jipijapa Airport
    Airport{IataCode{"JIQ"}, CountryId{"CN"}, Coordinate{108.829, 29.5173}}, // Qianjiang Wulingshan Airport
    Airport{IataCode{"JIR"}, CountryId{"NP"}, Coordinate{86.2304, 27.6267}}, // Jiri Airport
    Airport{IataCode{"JIU"}, CountryId{"CN"}, Coordinate{115.801, 29.4769}}, // Jiujiang Lushan Airport
    Airport{IataCode{"JIW"}, CountryId{"PK"}, Coordinate{61.8056, 25.0678}}, // Jiwani Airport
    Airport{IataCode{"JJI"}, CountryId{"PE"}, Coordinate{-76.7292, -7.16972}}, // Juanjuí Airport
    Airport{IataCode{"JJM"}, CountryId{"KE"}, Coordinate{38.1706, 0.230278}}, // Mulika Lodge Airport
    Airport{IataCode{"JJN"}, CountryId{"CN"}, Coordinate{118.588, 24.8039}}, // Quanzhou Jinjiang Airport
    Airport{IataCode{"JKG"}, CountryId{"SE"}, Coordinate{14.0704, 57.7504}}, // Jönköping Airport
    Airport{IataCode{"JKH"}, CountryId{"GR"}, Coordinate{26.1425, 38.3452}}, // Chios Island National Airport
    Airport{IataCode{"JKL"}, CountryId{"GR"}, Coordinate{26.9406, 36.9633}}, // Kalymnos Island National Airport
    Airport{IataCode{"JKR"}, CountryId{"NP"}, Coordinate{85.9239, 26.7113}}, // Janakpur Airport
    Airport{IataCode{"JKV"}, CountryId{"US"}, Coordinate{-95.2175, 31.8694}}, // Cherokee County Airport
    Airport{IataCode{"JLN"}, CountryId{"US"}, Coordinate{-94.5016, 37.1574}}, // Joplin Regional Airport
    Airport{IataCode{"JLR"}, CountryId{"IN"}, Coordinate{80.0587, 23.1846}}, // Jabalpur Airport
    Airport{IataCode{"JMB"}, CountryId{"AO"}, Coordinate{16.0653, -14.6986}}, // Jamba Airport
    Airport{IataCode{"JMJ"}, CountryId{"CN"}, Coordinate{99.7834, 22.4142}}, // Lancang Airport
    Airport{IataCode{"JMK"}, CountryId{"GR"}, Coordinate{25.3461, 37.434}}, // Mykonos Island National Airport
    Airport{IataCode{"JMO"}, CountryId{"NP"}, Coordinate{83.7233, 28.7819}}, // Jomsom Airport
    Airport{IataCode{"JMS"}, CountryId{"US"}, Coordinate{-98.679, 46.9264}}, // Jamestown Regional Airport
    Airport{IataCode{"JMU"}, CountryId{"CN"}, Coordinate{130.456, 46.8446}}, // Jiamusi Dongjiao Airport
    Airport{IataCode{"JNA"}, CountryId{"BR"}, Coordinate{-44.3864, -15.4747}}, // Januaria Airport
    Airport{IataCode{"JNB"}, CountryId{"ZA"}, Coordinate{28.2311, -26.1322}}, // OR Tambo International Airport
    Airport{IataCode{"JNG"}, CountryId{"CN"}, Coordinate{116.351, 35.2975}}, // Jining Qufu Airport
    Airport{IataCode{"JNI"}, CountryId{"AR"}, Coordinate{-60.9317, -34.5522}}, // Junín Airport
    Airport{IataCode{"JNU"}, CountryId{"US"}, Coordinate{-134.583, 58.3593}}, // Juneau International Airport
    Airport{IataCode{"JNX"}, CountryId{"GR"}, Coordinate{25.3697, 37.081}}, // Naxos Island National Airport
    Airport{IataCode{"JNZ"}, CountryId{"CN"}, Coordinate{121.281, 40.931}}, // Jinzhou Bay Airport
    Airport{IataCode{"JOE"}, CountryId{"FI"}, Coordinate{29.6138, 62.6577}}, // Joensuu Airport
    Airport{IataCode{"JOG"}, CountryId{"ID"}, Coordinate{110.437, -7.78494}}, // Adisucipto International Airport
    Airport{IataCode{"JOI"}, CountryId{"BR"}, Coordinate{-48.8016, -26.2243}}, // Joinville-Lauro Carneiro de Loyola Airport
    Airport{IataCode{"JOJ"}, CountryId{"CA"}, Coordinate{-106.585, 68.1253}}, // Doris Lake Aerodrome
    Airport{IataCode{"JOK"}, CountryId{"RU"}, Coordinate{47.9068, 56.7002}}, // Yoshkar-Ola Airport
    Airport{IataCode{"JOL"}, CountryId{"PH"}, Coordinate{121.005, 6.05303}}, // Jolo Airport
    Airport{IataCode{"JOS"}, CountryId{"NG"}, Coordinate{8.87065, 9.63682}}, // Yakubu Gowon Airport
    Airport{IataCode{"JOT"}, CountryId{"US"}, Coordinate{-88.1786, 41.5203}}, // Joliet Regional Airport
    Airport{IataCode{"JPA"}, CountryId{"BR"}, Coordinate{-34.9486, -7.14583}}, // Presidente Castro Pinto International Airport
    Airport{IataCode{"JPR"}, CountryId{"BR"}, Coordinate{-61.8467, -10.8706}}, // Ji-Paraná Airport
    Airport{IataCode{"JQA"}, CountryId{"GL"}, Coordinate{-52.6961, 70.7342}}, // Qaarsut Airport
    Airport{IataCode{"JQE"}, CountryId{"PA"}, Coordinate{-78.1572, 7.51778}}, // Jaqué Airport
    Airport{IataCode{"JRF"}, CountryId{"US"}, Coordinate{-158.07, 21.3072}}, // Kalaeloa Airport
    Airport{IataCode{"JRG"}, CountryId{"IN"}, Coordinate{84.0465, 21.916}}, // Jharsuguda Airport
    Airport{IataCode{"JRH"}, CountryId{"IN"}, Coordinate{94.1756, 26.7317}}, // Jorhat Airport
    Airport{IataCode{"JRN"}, CountryId{"BR"}, Coordinate{-58.4894, -11.5433}}, // Juruena Airport
    Airport{IataCode{"JRO"}, CountryId{"TZ"}, Coordinate{37.0652, -3.42447}}, // Kilimanjaro International Airport
    Airport{IataCode{"JSA"}, CountryId{"IN"}, Coordinate{70.856, 26.8706}}, // Jaisalmer Airport
    Airport{IataCode{"JSH"}, CountryId{"GR"}, Coordinate{26.0974, 35.2172}}, // Sitia Public Airport
    Airport{IataCode{"JSI"}, CountryId{"GR"}, Coordinate{23.5012, 39.1763}}, // Skiathos Island National Airport
    Airport{IataCode{"JSJ"}, CountryId{"CN"}, Coordinate{132.66, 47.11}}, // Jiansanjiang Shidi Airport
    Airport{IataCode{"JSM"}, CountryId{"AR"}, Coordinate{-70.4589, -44.0583}}, // José de San Martín Airport
    Airport{IataCode{"JSR"}, CountryId{"BD"}, Coordinate{89.1608, 23.1771}}, // Jessore Airport
    Airport{IataCode{"JST"}, CountryId{"US"}, Coordinate{-78.833, 40.3195}}, // Johnstown–Cambria County Airport
    Airport{IataCode{"JSU"}, CountryId{"GL"}, Coordinate{-52.9321, 65.4116}}, // Maniitsoq Airport
    Airport{IataCode{"JSY"}, CountryId{"GR"}, Coordinate{24.9477, 37.422}}, // Syros Island National Airport
    Airport{IataCode{"JTC"}, CountryId{"BR"}, Coordinate{-49.0722, -22.1659}}, // Bauru-Arealva Airport
    Airport{IataCode{"JTI"}, CountryId{"BR"}, Coordinate{-51.7746, -17.8307}}, // Jataí Airport
    Airport{IataCode{"JTR"}, CountryId{"GR"}, Coordinate{25.4793, 36.3992}}, // Santorini (Thira) National Airport
    Airport{IataCode{"JTY"}, CountryId{"GR"}, Coordinate{26.3747, 36.5822}}, // Astypalaia Island National Airport
    Airport{IataCode{"JUA"}, CountryId{"BR"}, Coordinate{-57.5452, -11.2987}}, // Juara Airport
    Airport{IataCode{"JUB"}, CountryId{"SS"}, Coordinate{31.6015, 4.86706}}, // Juba International Airport
    Airport{IataCode{"JUH"}, CountryId{"CN"}, Coordinate{117.687, 30.7403}}, // Chizhou Jiuhuashan Airport
    Airport{IataCode{"JUJ"}, CountryId{"AR"}, Coordinate{-65.0941, -24.3859}}, // Gobernador Horacio Guzmán International Airport
    Airport{IataCode{"JUL"}, CountryId{"PE"}, Coordinate{-70.1565, -15.4707}}, // Inca Manco Cápac International Airport
    Airport{IataCode{"JUM"}, CountryId{"NP"}, Coordinate{82.1933, 29.2744}}, // Jumla Airport
    Airport{IataCode{"JUR"}, CountryId{"AU"}, Coordinate{115.055, -30.3033}}, // Jurien Bay Airport
    Airport{IataCode{"JUT"}, CountryId{"HN"}, Coordinate{-86.3, 14.6526}}, // Jutigalpa airport
    Airport{IataCode{"JUV"}, CountryId{"GL"}, Coordinate{-56.1295, 72.7868}}, // Upernavik Airport
    Airport{IataCode{"JUZ"}, CountryId{"CN"}, Coordinate{118.899, 28.9658}}, // Quzhou Airport
    Airport{IataCode{"JVA"}, CountryId{"MG"}, Coordinate{45.2739, -18.8058}}, // Ankavandra Airport
    Airport{IataCode{"JVI"}, CountryId{"US"}, Coordinate{-74.5946, 40.5274}}, // Central Jersey Regional Airport
    Airport{IataCode{"JVL"}, CountryId{"US"}, Coordinate{-89.0414, 42.6156}}, // Southern Wisconsin Regional Airport
    Airport{IataCode{"JWA"}, CountryId{"BW"}, Coordinate{24.691, -24.6023}}, // Jwaneng Airport
    Airport{IataCode{"JWN"}, CountryId{"IR"}, Coordinate{48.369, 36.7733}}, // Zanjan Airport
    Airport{IataCode{"JXA"}, CountryId{"CN"}, Coordinate{130.997, 45.3061}}, // Jixi Xingkaihu Airport
    Airport{IataCode{"JXN"}, CountryId{"US"}, Coordinate{-84.4606, 42.2606}}, // Jackson County Airport
    Airport{IataCode{"JYR"}, CountryId{"IR"}, Coordinate{57.6703, 28.7269}}, // Jiroft Airport
    Airport{IataCode{"JYV"}, CountryId{"FI"}, Coordinate{25.6808, 62.4036}}, // Jyväskylä Airport
    Airport{IataCode{"JZH"}, CountryId{"CN"}, Coordinate{103.686, 32.8534}}, // Jiuzhai Huanglong Airport
    Airport{IataCode{"KAA"}, CountryId{"ZM"}, Coordinate{31.1333, -10.2172}}, // Kasama Airport
    Airport{IataCode{"KAB"}, CountryId{"ZW"}, Coordinate{28.8871, -16.5177}}, // Kariba Airport
    Airport{IataCode{"KAC"}, CountryId{"SY"}, Coordinate{41.205, 37.0317}}, // Qamishli Airport
    Airport{IataCode{"KAD"}, CountryId{"NG"}, Coordinate{7.32537, 10.6946}}, // Kaduna Airport
    Airport{IataCode{"KAF"}, CountryId{"PG"}, Coordinate{155.4, -6.283}}, // Karato Airport
    Airport{IataCode{"KAI"}, CountryId{"GY"}, Coordinate{-59.4914, 5.1725}}, // Kaieteur International Airport
    Airport{IataCode{"KAJ"}, CountryId{"FI"}, Coordinate{27.6875, 64.2842}}, // Kajaani Airport
    Airport{IataCode{"KAL"}, CountryId{"US"}, Coordinate{-158.741, 64.3189}}, // Kaltag Airport
    Airport{IataCode{"KAM"}, CountryId{"YE"}, Coordinate{42.6111, 15.3611}}, // Kamaran Airport
    Airport{IataCode{"KAN"}, CountryId{"NG"}, Coordinate{8.51818, 12.0432}}, // Mallam Aminu Kano International Airport
    Airport{IataCode{"KAO"}, CountryId{"FI"}, Coordinate{29.2271, 65.9962}}, // Kuusamo Airport
    Airport{IataCode{"KAP"}, CountryId{"CD"}, Coordinate{22.65, -8.35}}, // Kapanga Airport
    Airport{IataCode{"KAR"}, CountryId{"GY"}, Coordinate{-60.6167, 5.86417}}, // Kamarang Airport
    Airport{IataCode{"KAS"}, CountryId{"NA"}, Coordinate{18.7333, -28.0333}}, // Karasburg Airport
    Airport{IataCode{"KAT"}, CountryId{"NZ"}, Coordinate{173.285, -35.07}}, // Kaitaia Airport
    Airport{IataCode{"KAU"}, CountryId{"FI"}, Coordinate{23.0514, 63.1242}}, // Kauhava Airfield
    Airport{IataCode{"KAV"}, CountryId{"VE"}, Coordinate{-61.7633, 5.59306}}, // Kavanayén Airport
    Airport{IataCode{"KAW"}, CountryId{"MM"}, Coordinate{98.5406, 10.0518}}, // Kawthaung Airport
    Airport{IataCode{"KAX"}, CountryId{"AU"}, Coordinate{114.26, -27.6917}}, // Kalbarri Airport
    Airport{IataCode{"KAY"}, CountryId{"FJ"}, Coordinate{179.01, -17.6297}}, // Wakaya Island Airport
    Airport{IataCode{"KAZ"}, CountryId{"ID"}, Coordinate{127.894, 1.18748}}, // Kuabang Airport
    Airport{IataCode{"KBA"}, CountryId{"SL"}, Coordinate{-11.55, 9.583}}, // Kabala Airport
    Airport{IataCode{"KBC"}, CountryId{"US"}, Coordinate{-145.824, 66.2739}}, // Birch Creek Airport
    Airport{IataCode{"KBG"}, CountryId{"UG"}, Coordinate{31.4978, 2.32639}}, // Kabalega Falls Airport
    Airport{IataCode{"KBI"}, CountryId{"CM"}, Coordinate{9.97722, 2.87278}}, // Kribi Airport
    Airport{IataCode{"KBL"}, CountryId{"AF"}, Coordinate{69.2109, 34.5613}}, // Hamid Karzai International Airport
    Airport{IataCode{"KBM"}, CountryId{"PG"}, Coordinate{147.278, -6.13936}}, // Kabwum Airport
    Airport{IataCode{"KBN"}, CountryId{"CD"}, Coordinate{24.5461, -6.12056}}, // Tunta Airport
    Airport{IataCode{"KBO"}, CountryId{"CD"}, Coordinate{26.9167, -6.08333}}, // Kabalo Airport
    Airport{IataCode{"KBP"}, CountryId{"UA"}, Coordinate{30.8973, 50.354}}, // Boryspil International Airport
    Airport{IataCode{"KBQ"}, CountryId{"MW"}, Coordinate{33.4663, -13.0164}}, // Kasungu Airport
    Airport{IataCode{"KBR"}, CountryId{"MY"}, Coordinate{102.293, 6.16969}}, // Sultan Ismail Petra Airport
    Airport{IataCode{"KBS"}, CountryId{"SL"}, Coordinate{-11.7617, 7.94389}}, // Bo Airport
    Airport{IataCode{"KBT"}, CountryId{"MH"}, Coordinate{170.844, 8.90056}}, // Kaben Airport
    Airport{IataCode{"KBU"}, CountryId{"ID"}, Coordinate{116.163, -3.29278}}, // Gusti Syamsir Alam Airport
    Airport{IataCode{"KBV"}, CountryId{"TH"}, Coordinate{98.9818, 8.09746}}, // Krabi Airport
    Airport{IataCode{"KBX"}, CountryId{"ID"}, Coordinate{132.289, -1.31389}}, // Q25470163
    Airport{IataCode{"KBY"}, CountryId{"AU"}, Coordinate{134.293, -32.8358}}, // Streaky Bay Airport
    Airport{IataCode{"KBZ"}, CountryId{"NZ"}, Coordinate{173.6, -42.4257}}, // Kaikoura Aerodrome
    Airport{IataCode{"KCA"}, CountryId{"CN"}, Coordinate{82.9869, 41.7181}}, // Kuqa Qiuci Airport
    Airport{IataCode{"KCB"}, CountryId{"SR"}, Coordinate{-55.7167, 3.15}}, // Tepoe Airstrip
    Airport{IataCode{"KCF"}, CountryId{"PK"}, Coordinate{69.1535, 27.1992}}, // Kadanwari Airport
    Airport{IataCode{"KCH"}, CountryId{"MY"}, Coordinate{110.341, 1.4861}}, // Kuching International Airport
    Airport{IataCode{"KCK"}, CountryId{"RU"}, Coordinate{108.061, 57.7728}}, // Kirensk Airport
    Airport{IataCode{"KCL"}, CountryId{"US"}, Coordinate{-158.534, 56.3111}}, // Chignik Lagoon Airport
    Airport{IataCode{"KCM"}, CountryId{"TR"}, Coordinate{36.9591, 37.5366}}, // Kahramanmaraş Airport
    Airport{IataCode{"KCQ"}, CountryId{"US"}, Coordinate{-158.775, 56.255}}, // Chignik Lake Airport
    Airport{IataCode{"KCT"}, CountryId{"LK"}, Coordinate{80.3206, 5.99389}}, // SLAF Koggala
    Airport{IataCode{"KCU"}, CountryId{"UG"}, Coordinate{31.7367, 1.755}}, // Masindi Airport
    Airport{IataCode{"KCZ"}, CountryId{"JP"}, Coordinate{133.674, 33.5475}}, // Kōchi Airport
    Airport{IataCode{"KDB"}, CountryId{"AU"}, Coordinate{121.598, -31.19}}, // Kambalda Airport
    Airport{IataCode{"KDC"}, CountryId{"BJ"}, Coordinate{2.933, 11.133}}, // Kandi Airport
    Airport{IataCode{"KDD"}, CountryId{"PK"}, Coordinate{66.6393, 27.7969}}, // Khuzdar Airport
    Airport{IataCode{"KDE"}, CountryId{"PG"}, Coordinate{142.745, -5.69559}}, // Koroba Airport
    Airport{IataCode{"KDH"}, CountryId{"AF"}, Coordinate{65.8503, 31.5072}}, // Kandahar International Airport
    Airport{IataCode{"KDI"}, CountryId{"ID"}, Coordinate{122.417, -4.07721}}, // Haluoleo Airport
    Airport{IataCode{"KDJ"}, CountryId{"GA"}, Coordinate{10.75, -0.188889}}, // Ndjolé Ville Airport
    Airport{IataCode{"KDK"}, CountryId{"US"}, Coordinate{-152.374, 57.8058}}, // Kodiak Municipal Airport
    Airport{IataCode{"KDL"}, CountryId{"EE"}, Coordinate{22.8228, 58.9942}}, // Kärdla Airport
    Airport{IataCode{"KDM"}, CountryId{"MV"}, Coordinate{72.9969, 0.488056}}, // Kaadedhdhoo Airport
    Airport{IataCode{"KDO"}, CountryId{"MV"}, Coordinate{73.5191, 1.85763}}, // Kadhdhoo Airport
    Airport{IataCode{"KDP"}, CountryId{"PG"}, Coordinate{143.507, -5.84085}}, // Kandep Airport
    Airport{IataCode{"KDQ"}, CountryId{"PG"}, Coordinate{141.052, -3.6005}}, // Kamberatoro Airport
    Airport{IataCode{"KDR"}, CountryId{"PG"}, Coordinate{149.542, -6.20833}}, // Kandrian Airport
    Airport{IataCode{"KDU"}, CountryId{"PK"}, Coordinate{75.5293, 35.3285}}, // Skardu Airport
    Airport{IataCode{"KDV"}, CountryId{"FJ"}, Coordinate{178.157, -19.0581}}, // Vunisea Airport
    Airport{IataCode{"KDX"}, CountryId{"SD"}, Coordinate{29.6992, 11.1371}}, // Kadugli Airport
    Airport{IataCode{"KDY"}, CountryId{"RU"}, Coordinate{136.842, 62.7861}}, // Teply Klyuch Airport
    Airport{IataCode{"KEB"}, CountryId{"US"}, Coordinate{-151.925, 59.3522}}, // Nanwalek Airport
    Airport{IataCode{"KED"}, CountryId{"MR"}, Coordinate{-13.5167, 16.15}}, // Kaédi Airport
    Airport{IataCode{"KEE"}, CountryId{"CG"}, Coordinate{14.5333, -0.0833333}}, // Kelle Airport
    Airport{IataCode{"KEF"}, CountryId{"IS"}, Coordinate{-22.6244, 63.995}}, // Keflavík Airport
    Airport{IataCode{"KEG"}, CountryId{"PG"}, Coordinate{145.097, -5.83252}}, // Keglsugl Airport
    Airport{IataCode{"KEJ"}, CountryId{"RU"}, Coordinate{86.1184, 55.2816}}, // Kemerovo International Airport
    Airport{IataCode{"KEK"}, CountryId{"US"}, Coordinate{-157.472, 59.3547}}, // Ekwok Airport
    Airport{IataCode{"KEM"}, CountryId{"FI"}, Coordinate{24.5762, 65.7809}}, // Kemi-Tornio Airport
    Airport{IataCode{"KEN"}, CountryId{"SL"}, Coordinate{-11.1766, 7.8913}}, // Kenema Airport
    Airport{IataCode{"KEO"}, CountryId{"CI"}, Coordinate{-7.567, 9.5}}, // Odienné Airport
    Airport{IataCode{"KEP"}, CountryId{"NP"}, Coordinate{81.6669, 28.1036}}, // Nepalgunj Airport
    Airport{IataCode{"KER"}, CountryId{"IR"}, Coordinate{56.9613, 30.2594}}, // Kerman Airport
    Airport{IataCode{"KES"}, CountryId{"CA"}, Coordinate{-96.5061, 56.0367}}, // Kelsey Airport
    Airport{IataCode{"KET"}, CountryId{"MM"}, Coordinate{99.6304, 21.3034}}, // Kengtung Airport
    Airport{IataCode{"KEW"}, CountryId{"CA"}, Coordinate{-92.8326, 52.9914}}, // Keewaywin Airport
    Airport{IataCode{"KEX"}, CountryId{"PG"}, Coordinate{145.904, -7.53783}}, // Kanabea Airport
    Airport{IataCode{"KEY"}, CountryId{"KE"}, Coordinate{35.2508, -0.413778}}, // Kericho Airport
    Airport{IataCode{"KFA"}, CountryId{"MR"}, Coordinate{-11.4061, 16.5833}}, // Kiffa Airport
    Airport{IataCode{"KFE"}, CountryId{"AU"}, Coordinate{119.437, -22.2919}}, // Fortescue Dave Forrest Airport
    Airport{IataCode{"KFG"}, CountryId{"AU"}, Coordinate{130.808, -17.4319}}, // Kalkgurung Airport
    Airport{IataCode{"KFP"}, CountryId{"US"}, Coordinate{-163.41, 54.8475}}, // False Pass Airport
    Airport{IataCode{"KFS"}, CountryId{"TR"}, Coordinate{33.7908, 41.3047}}, // Kastamonu Airport
    Airport{IataCode{"KGA"}, CountryId{"CD"}, Coordinate{22.4667, -5.9}}, // Kananga Airport
    Airport{IataCode{"KGB"}, CountryId{"PG"}, Coordinate{147.65, -6.13333}}, // Konge
    Airport{IataCode{"KGC"}, CountryId{"AU"}, Coordinate{137.523, -35.7095}}, // Kingscote Airport
    Airport{IataCode{"KGD"}, CountryId{"RU"}, Coordinate{20.5788, 54.8858}}, // Khrabrovo Airport
    Airport{IataCode{"KGE"}, CountryId{"SB"}, Coordinate{157.587, -7.33278}}, // Kaghau Airport
    Airport{IataCode{"KGF"}, CountryId{"KZ"}, Coordinate{73.3285, 49.6746}}, // Sary-Arka Airport
    Airport{IataCode{"KGG"}, CountryId{"SN"}, Coordinate{-12.2203, 12.5667}}, // Kédougou Airport
    Airport{IataCode{"KGH"}, CountryId{"PG"}, Coordinate{147.5, -8.58333}}, // Yongai Airport
    Airport{IataCode{"KGI"}, CountryId{"AU"}, Coordinate{121.458, -30.7855}}, // Kalgoorlie-Boulder Airport
    Airport{IataCode{"KGJ"}, CountryId{"MW"}, Coordinate{33.8928, -9.95494}}, // Karonga Airport
    Airport{IataCode{"KGK"}, CountryId{"US"}, Coordinate{-157.259, 59.7267}}, // Koliganek Airport
    Airport{IataCode{"KGL"}, CountryId{"RW"}, Coordinate{30.1348, -1.96364}}, // Kigali International Airport
    Airport{IataCode{"KGM"}, CountryId{"PG"}, Coordinate{141.03, -5.66998}}, // Kungim Airstrip
    Airport{IataCode{"KGP"}, CountryId{"RU"}, Coordinate{74.5294, 62.1957}}, // Kogalym International Airport
    Airport{IataCode{"KGS"}, CountryId{"GR"}, Coordinate{27.0901, 36.8015}}, // Kos Island International Airport
    Airport{IataCode{"KGT"}, CountryId{"CN"}, Coordinate{101.735, 30.1575}}, // Kangding Airport
    Airport{IataCode{"KGW"}, CountryId{"PG"}, Coordinate{147.669, -9.13587}}, // Kagi Airstrip
    Airport{IataCode{"KGX"}, CountryId{"US"}, Coordinate{-160.065, 62.8944}}, // Grayling Airport
    Airport{IataCode{"KGY"}, CountryId{"AU"}, Coordinate{151.841, -26.5808}}, // Kingaroy Airport
    Airport{IataCode{"KHC"}, CountryId{"RU"}, Coordinate{36.4014, 45.3725}}, // Kerch Airport
    Airport{IataCode{"KHD"}, CountryId{"IR"}, Coordinate{48.2858, 33.4382}}, // Khorramabad Airport
    Airport{IataCode{"KHE"}, CountryId{"UA"}, Coordinate{32.5085, 46.6722}}, // Kherson International Airport
    Airport{IataCode{"KHG"}, CountryId{"CN"}, Coordinate{76.0103, 39.5369}}, // Kashgar Airport
    Airport{IataCode{"KHH"}, CountryId{"TW"}, Coordinate{120.343, 22.5701}}, // Kaohsiung International Airport
    Airport{IataCode{"KHI"}, CountryId{"PK"}, Coordinate{67.1605, 24.9003}}, // Jinnah International Airport
    Airport{IataCode{"KHK"}, CountryId{"IR"}, Coordinate{50.3264, 29.254}}, // Khark Airport
    Airport{IataCode{"KHM"}, CountryId{"MM"}, Coordinate{95.6774, 25.991}}, // Khamti Airport
    Airport{IataCode{"KHN"}, CountryId{"CN"}, Coordinate{115.911, 28.8631}}, // Nanchang Changbei International Airport
    Airport{IataCode{"KHR"}, CountryId{"MN"}, Coordinate{102.829, 47.245}}, // Kharkhorin Airport
    Airport{IataCode{"KHS"}, CountryId{"OM"}, Coordinate{56.2333, 26.1708}}, // Khasab Airport
    Airport{IataCode{"KHT"}, CountryId{"AF"}, Coordinate{69.9517, 33.3336}}, // Khost Airfield
    Airport{IataCode{"KHU"}, CountryId{"UA"}, Coordinate{33.4753, 49.1308}}, // Kremenchuk Airport
    Airport{IataCode{"KHV"}, CountryId{"RU"}, Coordinate{135.171, 48.5262}}, // Khabarovsk Novy Airport
    Airport{IataCode{"KHW"}, CountryId{"BW"}, Coordinate{23.7878, -19.1494}}, // Khwai River Airport
    Airport{IataCode{"KHY"}, CountryId{"IR"}, Coordinate{44.973, 38.421}}, // Khoy Airport
    Airport{IataCode{"KHZ"}, CountryId{"FR"}, Coordinate{-146.257, -15.7808}}, // Kauehi aerodrome
    Airport{IataCode{"KIC"}, CountryId{"US"}, Coordinate{-121.121, 36.2286}}, // Mesa Del Rey Airport
    Airport{IataCode{"KID"}, CountryId{"SE"}, Coordinate{14.0814, 55.9242}}, // Kristianstad Airport
    Airport{IataCode{"KIF"}, CountryId{"CA"}, Coordinate{-89.8553, 53.0125}}, // Kingfisher Lake Airport
    Airport{IataCode{"KIH"}, CountryId{"IR"}, Coordinate{53.9711, 26.5321}}, // Kish International Airport
    Airport{IataCode{"KIJ"}, CountryId{"JP"}, Coordinate{139.112, 37.9558}}, // Niigata Airport
    Airport{IataCode{"KIM"}, CountryId{"ZA"}, Coordinate{24.7732, -28.7947}}, // Kimberley Airport
    Airport{IataCode{"KIN"}, CountryId{"JM"}, Coordinate{-76.7875, 17.9356}}, // Norman Manley International Airport
    Airport{IataCode{"KIO"}, CountryId{"MH"}, Coordinate{169.128, 5.64617}}, // Kili Airport
    Airport{IataCode{"KIP"}, CountryId{"US"}, Coordinate{-98.4903, 33.8606}}, // Kickapoo Downtown Airport
    Airport{IataCode{"KIQ"}, CountryId{"PG"}, Coordinate{147.1, -7.633}}, // Kira
    Airport{IataCode{"KIR"}, CountryId{"IE"}, Coordinate{-9.53694, 52.1813}}, // Kerry Airport
    Airport{IataCode{"KIS"}, CountryId{"KE"}, Coordinate{34.7286, -0.081903}}, // Kisumu International Airport
    Airport{IataCode{"KIT"}, CountryId{"GR"}, Coordinate{23.0148, 36.2756}}, // Kithira Island National Airport "Alexandros Aristotelous Onassis"
    Airport{IataCode{"KIV"}, CountryId{"MD"}, Coordinate{28.935, 46.9351}}, // Chișinău International Airport
    Airport{IataCode{"KIW"}, CountryId{"ZM"}, Coordinate{28.1475, -12.8976}}, // Southdowns Airport
    Airport{IataCode{"KIX"}, CountryId{"JP"}, Coordinate{135.244, 34.4359}}, // Kansai International Airport
    Airport{IataCode{"KIY"}, CountryId{"TZ"}, Coordinate{39.5086, -8.91111}}, // Kilwa Masoko Airport
    Airport{IataCode{"KJA"}, CountryId{"RU"}, Coordinate{92.486, 56.1804}}, // Krasnoyarsk International Airport
    Airport{IataCode{"KJH"}, CountryId{"CN"}, Coordinate{107.981, 26.9742}}, // Kaili Huangping Airport
    Airport{IataCode{"KJI"}, CountryId{"CN"}, Coordinate{87.0024, 48.2233}}, // Kanas Airport
    Airport{IataCode{"KJK"}, CountryId{"BE"}, Coordinate{3.21752, 50.8203}}, // Kortrijk-Wevelgem International Airport
    Airport{IataCode{"KJP"}, CountryId{"JP"}, Coordinate{127.293, 26.1683}}, // Kerama Airport
    Airport{IataCode{"KJT"}, CountryId{"ID"}, Coordinate{108.191, -6.66917}}, // Kertajati International Airport
    Airport{IataCode{"KJX"}, CountryId{"ID"}, Coordinate{96.7911, 3.73444}}, // Blangpidie Airport
    Airport{IataCode{"KKA"}, CountryId{"US"}, Coordinate{-161.154, 64.9394}}, // Koyuk Alfred Adams Airport
    Airport{IataCode{"KKC"}, CountryId{"TH"}, Coordinate{102.787, 16.4651}}, // Khon Kaen Airport
    Airport{IataCode{"KKD"}, CountryId{"PG"}, Coordinate{147.733, -8.88306}}, // Kokoda Airport
    Airport{IataCode{"KKE"}, CountryId{"NZ"}, Coordinate{173.913, -35.2631}}, // Kerikeri Airport
    Airport{IataCode{"KKH"}, CountryId{"US"}, Coordinate{-162.881, 59.9608}}, // Kongiganak Airport
    Airport{IataCode{"KKJ"}, CountryId{"JP"}, Coordinate{131.035, 33.8456}}, // Kitakyushu Airport
    Airport{IataCode{"KKN"}, CountryId{"NO"}, Coordinate{29.8831, 69.7214}}, // Kirkenes Airport, Høybuktmoen
    Airport{IataCode{"KKO"}, CountryId{"NZ"}, Coordinate{173.817, -35.4528}}, // Kaikohe Aerodrome
    Airport{IataCode{"KKR"}, CountryId{"FR"}, Coordinate{-146.885, -15.6679}}, // Kaukura Airport
    Airport{IataCode{"KKS"}, CountryId{"IR"}, Coordinate{51.577, 33.8953}}, // Kashan Airport
    Airport{IataCode{"KKT"}, CountryId{"US"}, Coordinate{-87.4283, 40.7586}}, // Kentland Municipal Airport
    Airport{IataCode{"KKW"}, CountryId{"CD"}, Coordinate{18.7833, -5.03583}}, // Kikwit Airport
    Airport{IataCode{"KKX"}, CountryId{"JP"}, Coordinate{129.928, 28.3197}}, // Kikai Airport
    Airport{IataCode{"KKY"}, CountryId{"IE"}, Coordinate{-7.29611, 52.6508}}, // Kilkenny Airport
    Airport{IataCode{"KKZ"}, CountryId{"KH"}, Coordinate{102.996, 11.6131}}, // Koh Kong Airport
    Airport{IataCode{"KLA"}, CountryId{"UG"}, Coordinate{32.5925, 0.326111}}, // Kampala Airport
    Airport{IataCode{"KLB"}, CountryId{"ZM"}, Coordinate{22.6454, -14.9983}}, // Kalabo Airport
    Airport{IataCode{"KLC"}, CountryId{"SN"}, Coordinate{-16.0537, 14.1441}}, // Kaolack Airport
    Airport{IataCode{"KLD"}, CountryId{"RU"}, Coordinate{35.76, 56.825}}, // Migalovo
    Airport{IataCode{"KLE"}, CountryId{"CM"}, Coordinate{14.4456, 10.0925}}, // Kaélé Airport
    Airport{IataCode{"KLF"}, CountryId{"RU"}, Coordinate{36.3666, 54.5472}}, // "Kaluga" (Grabtsevo) Airport
    Airport{IataCode{"KLG"}, CountryId{"US"}, Coordinate{-160.341, 61.5364}}, // Kalskag Airport
    Airport{IataCode{"KLH"}, CountryId{"IN"}, Coordinate{74.2894, 16.6647}}, // Kolhapur Airport
    Airport{IataCode{"KLK"}, CountryId{"KE"}, Coordinate{35.8342, 3.48036}}, // Kalokol Airport
    Airport{IataCode{"KLL"}, CountryId{"US"}, Coordinate{-156.859, 59.1281}}, // Levelock Airport
    Airport{IataCode{"KLM"}, CountryId{"IR"}, Coordinate{55.4519, 37.375}}, // Kalaleh Airport
    Airport{IataCode{"KLN"}, CountryId{"US"}, Coordinate{-153.977, 57.535}}, // Larsen Bay Airport
    Airport{IataCode{"KLO"}, CountryId{"PH"}, Coordinate{122.381, 11.6859}}, // Kalibo International Airport
    Airport{IataCode{"KLP"}, CountryId{"ID"}, Coordinate{112.541, -3.37814}}, // Seruyan Kuala Pembuang Airport
    Airport{IataCode{"KLR"}, CountryId{"SE"}, Coordinate{16.2878, 56.6776}}, // Kalmar Airport
    Airport{IataCode{"KLS"}, CountryId{"US"}, Coordinate{-122.898, 46.1181}}, // Southwest Washington Regional Airport
    Airport{IataCode{"KLU"}, CountryId{"AT"}, Coordinate{14.3252, 46.6499}}, // Klagenfurt Airport
    Airport{IataCode{"KLV"}, CountryId{"CZ"}, Coordinate{12.915, 50.2031}}, // Karlovy Vary Airport
    Airport{IataCode{"KLW"}, CountryId{"US"}, Coordinate{-133.076, 55.5792}}, // Klawock Airport
    Airport{IataCode{"KLX"}, CountryId{"GR"}, Coordinate{22.0256, 37.0684}}, // Kalamata International Airport
    Airport{IataCode{"KLY"}, CountryId{"CD"}, Coordinate{26.7333, -2.58333}}, // Kalima Airport
    Airport{IataCode{"KLZ"}, CountryId{"ZA"}, Coordinate{17.0933, -29.6884}}, // Kleinzee Airport
    Airport{IataCode{"KMA"}, CountryId{"PG"}, Coordinate{145.771, -7.9629}}, // Kerema Airport
    Airport{IataCode{"KMB"}, CountryId{"PG"}, Coordinate{144.633, -5.5}}, // Koinambe Airport
    Airport{IataCode{"KMC"}, CountryId{"SA"}, Coordinate{45.5281, 27.9008}}, // Hafar Al-Batin Domestic Airport
    Airport{IataCode{"KME"}, CountryId{"RW"}, Coordinate{28.9083, -2.45929}}, // Kamembe Airport
    Airport{IataCode{"KMG"}, CountryId{"CN"}, Coordinate{102.926, 25.0986}}, // Kunming Changshui International Airport
    Airport{IataCode{"KMH"}, CountryId{"ZA"}, Coordinate{23.4114, -27.4597}}, // Johan Pienaar Airport
    Airport{IataCode{"KMI"}, CountryId{"JP"}, Coordinate{131.44, 31.8724}}, // Miyazaki Airport
    Airport{IataCode{"KMJ"}, CountryId{"JP"}, Coordinate{130.861, 32.8356}}, // Kumamoto Airport
    Airport{IataCode{"KMK"}, CountryId{"CG"}, Coordinate{12.6167, -3.48333}}, // Makabana Airport
    Airport{IataCode{"KMN"}, CountryId{"CD"}, Coordinate{24.9833, -8.73333}}, // Kamina Airport
    Airport{IataCode{"KMO"}, CountryId{"US"}, Coordinate{-159.05, 58.9903}}, // Manokotak Airport
    Airport{IataCode{"KMP"}, CountryId{"NA"}, Coordinate{18.109, -26.539}}, // Keetmanshoop Airport
    Airport{IataCode{"KMQ"}, CountryId{"JP"}, Coordinate{136.408, 36.3939}}, // Komatsu Airport
    Airport{IataCode{"KMS"}, CountryId{"GH"}, Coordinate{-1.59254, 6.71465}}, // Kumasi Airport
    Airport{IataCode{"KMT"}, CountryId{"KH"}, Coordinate{104.162, 10.6333}}, // Kampot Airport
    Airport{IataCode{"KMU"}, CountryId{"SO"}, Coordinate{42.4615, -0.379237}}, // Kismayo Airport
    Airport{IataCode{"KMV"}, CountryId{"MM"}, Coordinate{94.0508, 23.1875}}, // Kalaymyo Airport
    Airport{IataCode{"KMW"}, CountryId{"RU"}, Coordinate{41.0134, 57.8077}}, // Kostroma Airport
    Airport{IataCode{"KMZ"}, CountryId{"ZM"}, Coordinate{24.7833, -14.8}}, // Kaoma Airport
    Airport{IataCode{"KNA"}, CountryId{"CL"}, Coordinate{-71.4786, -32.9497}}, // Viña del Mar Airport
    Airport{IataCode{"KNB"}, CountryId{"US"}, Coordinate{-112.529, 37.0094}}, // Kanab Municipal Airport
    Airport{IataCode{"KND"}, CountryId{"CD"}, Coordinate{25.9129, -2.92628}}, // Kindu Airport
    Airport{IataCode{"KNE"}, CountryId{"PG"}, Coordinate{144.7, -5.28333}}, // Kanainj
    Airport{IataCode{"KNG"}, CountryId{"ID"}, Coordinate{133.695, -3.64444}}, // Kaimana Airport
    Airport{IataCode{"KNH"}, CountryId{"TW"}, Coordinate{118.368, 24.4357}}, // Kinmen Airport
    Airport{IataCode{"KNI"}, CountryId{"AU"}, Coordinate{117.653, -33.7}}, // Katanning Airport
    Airport{IataCode{"KNJ"}, CountryId{"CG"}, Coordinate{14.5167, -3.95}}, // Kindamba Airport
    Airport{IataCode{"KNK"}, CountryId{"US"}, Coordinate{-154.803, 59.4331}}, // Kokhanok Airport
    Airport{IataCode{"KNM"}, CountryId{"CD"}, Coordinate{24.15, -7.60139}}, // Kaniama, Kaniama Airport
    Airport{IataCode{"KNN"}, CountryId{"GN"}, Coordinate{-9.22733, 10.4485}}, // Kankan Airport
    Airport{IataCode{"KNO"}, CountryId{"ID"}, Coordinate{98.878, 3.6344}}, // Kualanamu International Airport
    Airport{IataCode{"KNP"}, CountryId{"AO"}, Coordinate{15.4565, -9.77078}}, // Kapanda Airport
    Airport{IataCode{"KNQ"}, CountryId{"FR"}, Coordinate{164.838, -21.0533}}, // Koné Airport
    Airport{IataCode{"KNR"}, CountryId{"IR"}, Coordinate{52.3519, 27.8203}}, // Jam Airport
    Airport{IataCode{"KNS"}, CountryId{"AU"}, Coordinate{143.882, -39.8796}}, // King Island Airport
    Airport{IataCode{"KNT"}, CountryId{"US"}, Coordinate{-90.0367, 36.2258}}, // Kennett Memorial Airport
    Airport{IataCode{"KNU"}, CountryId{"IN"}, Coordinate{80.4122, 26.4028}}, // Kanpur Airport
    Airport{IataCode{"KNW"}, CountryId{"US"}, Coordinate{-157.373, 59.4517}}, // New Stuyahok Airport
    Airport{IataCode{"KNX"}, CountryId{"AU"}, Coordinate{128.713, -15.7838}}, // Kununurra Airport
    Airport{IataCode{"KNZ"}, CountryId{"ML"}, Coordinate{-11.2528, 12.8333}}, // Kéniéba Airport
    Airport{IataCode{"KOA"}, CountryId{"US"}, Coordinate{-156.041, 19.7362}}, // Ellison Onizuka Kona International Airport
    Airport{IataCode{"KOE"}, CountryId{"ID"}, Coordinate{123.668, -10.1688}}, // El Tari Airport
    Airport{IataCode{"KOG"}, CountryId{"LA"}, Coordinate{105.85, 14.1167}}, // Khong
    Airport{IataCode{"KOI"}, CountryId{"GB"}, Coordinate{-2.90249, 58.9536}}, // Kirkwall Airport
    Airport{IataCode{"KOJ"}, CountryId{"JP"}, Coordinate{130.717, 31.8033}}, // Kagoshima Airport
    Airport{IataCode{"KOK"}, CountryId{"FI"}, Coordinate{23.1338, 63.7193}}, // Kokkola-Pietarsaari Airport
    Airport{IataCode{"KOL"}, CountryId{"CF"}, Coordinate{21.25, 8.5}}, // Koumala Airport
    Airport{IataCode{"KOO"}, CountryId{"CD"}, Coordinate{26.99, -5.4}}, // Kongolo Airport
    Airport{IataCode{"KOP"}, CountryId{"TH"}, Coordinate{104.642, 17.3839}}, // Nakhon Phanom Airport
    Airport{IataCode{"KOR"}, CountryId{"PG"}, Coordinate{146.6, -7.817}}, // Kokoro
    Airport{IataCode{"KOS"}, CountryId{"KH"}, Coordinate{103.64, 10.58}}, // Sihanouk International Airport
    Airport{IataCode{"KOT"}, CountryId{"US"}, Coordinate{-163.533, 63.0306}}, // Kotlik Airport
    Airport{IataCode{"KOU"}, CountryId{"GA"}, Coordinate{12.4411, -1.18444}}, // Koulamoutou Airport
    Airport{IataCode{"KOV"}, CountryId{"KZ"}, Coordinate{69.5909, 53.3334}}, // Kokshetau International Airport
    Airport{IataCode{"KOW"}, CountryId{"CN"}, Coordinate{114.781, 25.8487}}, // Ganzhou Huangjin Airport
    Airport{IataCode{"KOZ"}, CountryId{"US"}, Coordinate{-152.501, 57.9229}}, // Ouzinkie Airport
    Airport{IataCode{"KPA"}, CountryId{"PG"}, Coordinate{145.417, -5.58333}}, // Kopiago
    Airport{IataCode{"KPC"}, CountryId{"US"}, Coordinate{-166.859, 65.2536}}, // Port Clarence Coast Guard Station
    Airport{IataCode{"KPE"}, CountryId{"PG"}, Coordinate{141.1, -4.63333}}, // Yapsiei
    Airport{IataCode{"KPI"}, CountryId{"MY"}, Coordinate{112.843, 2.00833}}, // Kapit Airport
    Airport{IataCode{"KPL"}, CountryId{"PG"}, Coordinate{142.822, -8.62855}}, // Kapal Airport
    Airport{IataCode{"KPM"}, CountryId{"PG"}, Coordinate{143.925, -5.38146}}, // Kompiam Airport
    Airport{IataCode{"KPN"}, CountryId{"US"}, Coordinate{-164.031, 59.9331}}, // Kipnuk Airport
    Airport{IataCode{"KPO"}, CountryId{"KR"}, Coordinate{129.434, 35.9841}}, // Pohang Airport
    Airport{IataCode{"KPS"}, CountryId{"AU"}, Coordinate{152.768, -31.065}}, // Kempsey Airport
    Airport{IataCode{"KPT"}, CountryId{"US"}, Coordinate{-114.658, 41.9761}}, // Jackpot Airport
    Airport{IataCode{"KPV"}, CountryId{"US"}, Coordinate{-159.161, 55.9067}}, // Perryville Airport
    Airport{IataCode{"KPX"}, CountryId{"RU"}, Coordinate{169.56, 66.9017}}, // Kupol Airport
    Airport{IataCode{"KQA"}, CountryId{"US"}, Coordinate{-165.604, 54.1447}}, // Akutan Airport
    Airport{IataCode{"KQH"}, CountryId{"IN"}, Coordinate{74.817, 26.5895}}, // Kishangarh Airport
    Airport{IataCode{"KQR"}, CountryId{"AU"}, Coordinate{116.687, -29.2167}}, // Karara Airport
    Airport{IataCode{"KQT"}, CountryId{"TJ"}, Coordinate{68.8628, 37.8622}}, // Qurghonteppa International Airport
    Airport{IataCode{"KRA"}, CountryId{"AU"}, Coordinate{143.94, -35.7517}}, // Kerang Airport
    Airport{IataCode{"KRB"}, CountryId{"AU"}, Coordinate{140.832, -17.4558}}, // Karumba Airport
    Airport{IataCode{"KRC"}, CountryId{"ID"}, Coordinate{101.462, -2.09126}}, // Depati Parbo Airport
    Airport{IataCode{"KRE"}, CountryId{"BI"}, Coordinate{30.0942, -2.54722}}, // Kirundo Airport
    Airport{IataCode{"KRF"}, CountryId{"SE"}, Coordinate{17.7634, 63.048}}, // Kramfors-Sollefteå Airport
    Airport{IataCode{"KRG"}, CountryId{"GY"}, Coordinate{-59.5333, 4.01667}}, // Karasabai Airport
    Airport{IataCode{"KRI"}, CountryId{"PG"}, Coordinate{144.25, -7.42472}}, // Kikori Airport
    Airport{IataCode{"KRJ"}, CountryId{"PG"}, Coordinate{147.483, -8.75}}, // Karawari
    Airport{IataCode{"KRK"}, CountryId{"PL"}, Coordinate{19.8015, 50.0725}}, // John Paul II International Airport Kraków-Balice
    Airport{IataCode{"KRL"}, CountryId{"CN"}, Coordinate{86.141, 41.6213}}, // Korla Airport
    Airport{IataCode{"KRM"}, CountryId{"GY"}, Coordinate{-59.3097, 3.75194}}, // Karanambo Airport
    Airport{IataCode{"KRN"}, CountryId{"SE"}, Coordinate{20.3356, 67.8214}}, // Kiruna Airport
    Airport{IataCode{"KRO"}, CountryId{"RU"}, Coordinate{65.4114, 55.4628}}, // Kurgan Airport
    Airport{IataCode{"KRP"}, CountryId{"DK"}, Coordinate{9.12472, 56.2975}}, // Karup Airport
    Airport{IataCode{"KRQ"}, CountryId{"UA"}, Coordinate{37.6289, 48.7056}}, // Kramatorsk Airport
    Airport{IataCode{"KRR"}, CountryId{"RU"}, Coordinate{39.1398, 45.0347}}, // Krasnodar International Airport
    Airport{IataCode{"KRS"}, CountryId{"NO"}, Coordinate{8.07397, 58.2024}}, // Kristiansand Airport, Kjevik
    Airport{IataCode{"KRT"}, CountryId{"SD"}, Coordinate{32.5495, 15.5949}}, // Khartoum International Airport
    Airport{IataCode{"KRU"}, CountryId{"PG"}, Coordinate{147.1, -8.3}}, // Kerau
    Airport{IataCode{"KRV"}, CountryId{"KE"}, Coordinate{35.665, 0.32}}, // Kimwarer Airport
    Airport{IataCode{"KRW"}, CountryId{"TM"}, Coordinate{52.994, 40.0437}}, // Turkmenbashi Airport
    Airport{IataCode{"KRX"}, CountryId{"PG"}, Coordinate{145.667, -4.83333}}, // Kar Kar
    Airport{IataCode{"KRY"}, CountryId{"CN"}, Coordinate{84.9525, 45.4664}}, // Karamay Airport
    Airport{IataCode{"KRZ"}, CountryId{"CD"}, Coordinate{19, -1.45}}, // Basango Mboliasa Airport
    Airport{IataCode{"KSA"}, CountryId{"FM"}, Coordinate{162.958, 5.35694}}, // Kosrae International Airport
    Airport{IataCode{"KSC"}, CountryId{"SK"}, Coordinate{21.2374, 48.6729}}, // Košice International Airport
    Airport{IataCode{"KSD"}, CountryId{"SE"}, Coordinate{13.3448, 59.4438}}, // Karlstad Airport
    Airport{IataCode{"KSE"}, CountryId{"UG"}, Coordinate{30.1025, 0.19}}, // Kasese Airport
    Airport{IataCode{"KSF"}, CountryId{"DE"}, Coordinate{9.38974, 51.4168}}, // Kassel Airport
    Airport{IataCode{"KSG"}, CountryId{"PG"}, Coordinate{146.717, -6.35}}, // Kisengan
    Airport{IataCode{"KSH"}, CountryId{"IR"}, Coordinate{47.1467, 34.355}}, // Kermanshah Airport
    Airport{IataCode{"KSI"}, CountryId{"GN"}, Coordinate{-10.1244, 9.16056}}, // Kissidougou Airport
    Airport{IataCode{"KSJ"}, CountryId{"GR"}, Coordinate{26.91, 35.4214}}, // Kassos Island Public Airport
    Airport{IataCode{"KSK"}, CountryId{"SE"}, Coordinate{14.4947, 59.3333}}, // Karlskoga Airport
    Airport{IataCode{"KSL"}, CountryId{"SD"}, Coordinate{36.3305, 15.3868}}, // Kassala Airport
    Airport{IataCode{"KSM"}, CountryId{"US"}, Coordinate{-163.302, 62.0608}}, // St. Mary's Airport
    Airport{IataCode{"KSN"}, CountryId{"KZ"}, Coordinate{63.5539, 53.2206}}, // Kostanay Airport
    Airport{IataCode{"KSO"}, CountryId{"GR"}, Coordinate{21.2728, 40.4489}}, // Kastoria National Airport
    Airport{IataCode{"KSQ"}, CountryId{"UZ"}, Coordinate{65.7741, 38.8112}}, // Karshi Airport
    Airport{IataCode{"KSR"}, CountryId{"ID"}, Coordinate{120.437, -6.17567}}, // H. Aroeppala Airport
    Airport{IataCode{"KSS"}, CountryId{"ML"}, Coordinate{-5.7989, 11.327}}, // Sikasso Airport
    Airport{IataCode{"KST"}, CountryId{"SD"}, Coordinate{32.6981, 13.1894}}, // Rabak Airport
    Airport{IataCode{"KSU"}, CountryId{"NO"}, Coordinate{7.82722, 63.114}}, // Kristiansund Airport, Kvernberget
    Airport{IataCode{"KSV"}, CountryId{"AU"}, Coordinate{140.703, -23.5431}}, // Springvale Airport
    Airport{IataCode{"KSX"}, CountryId{"PG"}, Coordinate{146.183, -6.6}}, // Yasuru
    Airport{IataCode{"KSY"}, CountryId{"TR"}, Coordinate{43.1105, 40.5658}}, // Kars Airport
    Airport{IataCode{"KSZ"}, CountryId{"RU"}, Coordinate{46.6967, 61.2367}}, // Kotlas Airport
    Airport{IataCode{"KTA"}, CountryId{"AU"}, Coordinate{116.77, -20.7087}}, // Karratha Airport
    Airport{IataCode{"KTC"}, CountryId{"CI"}, Coordinate{-5.0654, 8.1344}}, // Katiola Airport
    Airport{IataCode{"KTD"}, CountryId{"JP"}, Coordinate{131.327, 25.9447}}, // Kitadaito Airport
    Airport{IataCode{"KTE"}, CountryId{"MY"}, Coordinate{103.429, 4.54096}}, // Kerteh Airport
    Airport{IataCode{"KTF"}, CountryId{"NZ"}, Coordinate{172.775, -40.9038}}, // Takaka Aerodrome
    Airport{IataCode{"KTG"}, CountryId{"ID"}, Coordinate{109.962, -1.81682}}, // Ketapang Airport
    Airport{IataCode{"KTI"}, CountryId{"KH"}, Coordinate{106.055, 12.4852}}, // Kratié Airport
    Airport{IataCode{"KTK"}, CountryId{"PG"}, Coordinate{154.75, -5.33889}}, // Kanua
    Airport{IataCode{"KTL"}, CountryId{"KE"}, Coordinate{34.9508, 0.897222}}, // Kitale Airport
    Airport{IataCode{"KTM"}, CountryId{"NP"}, Coordinate{85.3578, 27.6972}}, // Tribhuvan International Airport
    Airport{IataCode{"KTN"}, CountryId{"US"}, Coordinate{-131.71, 55.3569}}, // Ketchikan International Airport
    Airport{IataCode{"KTO"}, CountryId{"GY"}, Coordinate{-59.8322, 4.64917}}, // Kato Airport
    Airport{IataCode{"KTP"}, CountryId{"JM"}, Coordinate{-76.8236, 17.9883}}, // Tinson Pen Aerodrome
    Airport{IataCode{"KTS"}, CountryId{"US"}, Coordinate{-166.466, 65.3314}}, // Brevig Mission Airport
    Airport{IataCode{"KTT"}, CountryId{"FI"}, Coordinate{24.8481, 67.6986}}, // Kittilä Airport
    Airport{IataCode{"KTU"}, CountryId{"IN"}, Coordinate{75.8505, 25.1634}}, // Kota Airport
    Airport{IataCode{"KTV"}, CountryId{"VE"}, Coordinate{-62.416, 5.71667}}, // Kamarata Airport
    Airport{IataCode{"KTW"}, CountryId{"PL"}, Coordinate{19.0833, 50.4705}}, // Katowice International Airport
    Airport{IataCode{"KTX"}, CountryId{"ML"}, Coordinate{-5.467, 12.35}}, // Koutiala Airport
    Airport{IataCode{"KUA"}, CountryId{"MY"}, Coordinate{103.215, 3.78076}}, // Sultan Haji Ahmad Shah Airport
    Airport{IataCode{"KUC"}, CountryId{"KI"}, Coordinate{173.439, 0.219529}}, // Kuria Airport
    Airport{IataCode{"KUD"}, CountryId{"MY"}, Coordinate{116.831, 6.92417}}, // Kudat Airport
    Airport{IataCode{"KUE"}, CountryId{"SB"}, Coordinate{157.595, -8.02403}}, // Kukudu Airport
    Airport{IataCode{"KUF"}, CountryId{"RU"}, Coordinate{50.1521, 53.5107}}, // Kurumoch International Airport
    Airport{IataCode{"KUH"}, CountryId{"JP"}, Coordinate{144.196, 43.0453}}, // Kushiro Airport
    Airport{IataCode{"KUK"}, CountryId{"US"}, Coordinate{-162.524, 60.8733}}, // Kasigluk Airport
    Airport{IataCode{"KUL"}, CountryId{"MY"}, Coordinate{101.71, 2.74556}}, // Kuala Lumpur International Airport
    Airport{IataCode{"KUM"}, CountryId{"JP"}, Coordinate{130.659, 30.3835}}, // Yakushima Airport
    Airport{IataCode{"KUN"}, CountryId{"LT"}, Coordinate{24.0847, 54.9639}}, // Kaunas Airport
    Airport{IataCode{"KUO"}, CountryId{"FI"}, Coordinate{27.7892, 63.0088}}, // Kuopio Airport
    Airport{IataCode{"KUP"}, CountryId{"PG"}, Coordinate{148.217, -10.0732}}, // Kupiano Airport
    Airport{IataCode{"KUQ"}, CountryId{"PG"}, Coordinate{148.2, -10.07}}, // Kuri Airport
    Airport{IataCode{"KUS"}, CountryId{"GL"}, Coordinate{-37.1346, 65.5744}}, // Kulusuk Airport
    Airport{IataCode{"KUT"}, CountryId{"GE"}, Coordinate{42.4657, 42.182}}, // Kutaisi International Airport
    Airport{IataCode{"KUU"}, CountryId{"IN"}, Coordinate{77.1518, 31.879}}, // Bhuntar Airport
    Airport{IataCode{"KUV"}, CountryId{"KR"}, Coordinate{126.616, 35.9039}}, // Gunsan Airport
    Airport{IataCode{"KUX"}, CountryId{"PG"}, Coordinate{141.624, -5.37236}}, // Kuyol Airport
    Airport{IataCode{"KUY"}, CountryId{"PG"}, Coordinate{143.122, -7.4196}}, // Kamusi Airport
    Airport{IataCode{"KVA"}, CountryId{"GR"}, Coordinate{24.623, 40.9219}}, // Kavala International Airport
    Airport{IataCode{"KVB"}, CountryId{"SE"}, Coordinate{13.9728, 58.4561}}, // Skövde Airport
    Airport{IataCode{"KVC"}, CountryId{"US"}, Coordinate{-162.266, 55.1164}}, // King Cove Airport
    Airport{IataCode{"KVE"}, CountryId{"PG"}, Coordinate{148.7, -10.17}}, // Kitava
    Airport{IataCode{"KVG"}, CountryId{"PG"}, Coordinate{150.807, -2.58062}}, // Kavieng Airport
    Airport{IataCode{"KVK"}, CountryId{"RU"}, Coordinate{33.5817, 67.4597}}, // Kirovsk-Apatity Airport
    Airport{IataCode{"KVL"}, CountryId{"US"}, Coordinate{-164.564, 67.7361}}, // Kivalina Airport
    Airport{IataCode{"KVM"}, CountryId{"RU"}, Coordinate{170.414, 64.6653}}, // Markovo Airport
    Airport{IataCode{"KVO"}, CountryId{"RS"}, Coordinate{20.5853, 43.8186}}, // Morava Airport
    Airport{IataCode{"KVX"}, CountryId{"RU"}, Coordinate{49.3465, 58.4972}}, // Pobedilovo Airport
    Airport{IataCode{"KWB"}, CountryId{"ID"}, Coordinate{110.478, -5.80242}}, // Dewadaru Airport
    Airport{IataCode{"KWE"}, CountryId{"CN"}, Coordinate{106.796, 26.5455}}, // Guiyang Longdongbao International Airport
    Airport{IataCode{"KWG"}, CountryId{"UA"}, Coordinate{33.2142, 48.0459}}, // Kryvyi Rih International Airport
    Airport{IataCode{"KWH"}, CountryId{"AF"}, Coordinate{70.2033, 37.8917}}, // Khwahan Airport
    Airport{IataCode{"KWI"}, CountryId{"KW"}, Coordinate{47.98, 29.2268}}, // Kuwait International Airport
    Airport{IataCode{"KWJ"}, CountryId{"KR"}, Coordinate{126.811, 35.14}}, // Gwangju Airport
    Airport{IataCode{"KWK"}, CountryId{"US"}, Coordinate{-163.169, 59.8764}}, // Kwigillingok Airport
    Airport{IataCode{"KWL"}, CountryId{"CN"}, Coordinate{110.045, 25.2156}}, // Guilin Liangjiang International Airport
    Airport{IataCode{"KWM"}, CountryId{"AU"}, Coordinate{141.751, -15.4856}}, // Kowanyama Airport
    Airport{IataCode{"KWN"}, CountryId{"US"}, Coordinate{-161.845, 59.755}}, // Quinhagak Airport
    Airport{IataCode{"KWO"}, CountryId{"PG"}, Coordinate{142.824, -7.98048}}, // Kawito Airport
    Airport{IataCode{"KWS"}, CountryId{"IL"}, Coordinate{35.5967, 33.2167}}, // Kiryat Shmona Airport
    Airport{IataCode{"KWT"}, CountryId{"US"}, Coordinate{-161.444, 60.7903}}, // Kwethluk Airport
    Airport{IataCode{"KWV"}, CountryId{"PG"}, Coordinate{155.3, -6.183}}, // Kurwina Airport
    Airport{IataCode{"KWY"}, CountryId{"KE"}, Coordinate{41.2975, -1.96056}}, // Kiwayu Airport
    Airport{IataCode{"KWZ"}, CountryId{"CD"}, Coordinate{25.5, -10.7667}}, // Kolwezi Airport
    Airport{IataCode{"KXE"}, CountryId{"ZA"}, Coordinate{26.7146, -26.8676}}, // P.C. Pelser Airport
    Airport{IataCode{"KXK"}, CountryId{"RU"}, Coordinate{136.929, 50.4033}}, // Komsomolsk-on-Amur Airport
    Airport{IataCode{"KXR"}, CountryId{"PG"}, Coordinate{154.599, -5.27714}}, // Karoola Airport
    Airport{IataCode{"KYD"}, CountryId{"TW"}, Coordinate{121.536, 22.0278}}, // Lanyu Airport
    Airport{IataCode{"KYF"}, CountryId{"AU"}, Coordinate{120.096, -27.2769}}, // Yeelirrie Airport
    Airport{IataCode{"KYK"}, CountryId{"US"}, Coordinate{-154.454, 57.5661}}, // Karluk Airport
    Airport{IataCode{"KYP"}, CountryId{"MM"}, Coordinate{93.5362, 19.4292}}, // Kyaukpyu Airport
    Airport{IataCode{"KYS"}, CountryId{"ML"}, Coordinate{-11.4037, 14.4789}}, // Kayes Airport
    Airport{IataCode{"KYT"}, CountryId{"MM"}, Coordinate{94.1333, 21.4}}, // Kyauktu Airport
    Airport{IataCode{"KYU"}, CountryId{"US"}, Coordinate{-157.731, 64.8758}}, // Koyukuk Airport
    Airport{IataCode{"KYX"}, CountryId{"PG"}, Coordinate{146.6, -6.13333}}, // Yalumet
    Airport{IataCode{"KYZ"}, CountryId{"RU"}, Coordinate{94.4051, 51.676}}, // Kyzyl Airport
    Airport{IataCode{"KZB"}, CountryId{"US"}, Coordinate{-153.746, 57.5533}}, // Zachar Bay Seaplane Base
    Airport{IataCode{"KZC"}, CountryId{"KH"}, Coordinate{104.568, 12.2539}}, // Kampong Chhnang Airport
    Airport{IataCode{"KZD"}, CountryId{"KH"}, Coordinate{104.148, 12.5333}}, // Krakor Airport
    Airport{IataCode{"KZI"}, CountryId{"GR"}, Coordinate{21.8408, 40.2858}}, // Kozani National Airport
    Airport{IataCode{"KZN"}, CountryId{"RU"}, Coordinate{49.2994, 55.6094}}, // Kazan International Airport
    Airport{IataCode{"KZO"}, CountryId{"KZ"}, Coordinate{65.5931, 44.7121}}, // Kyzylorda Airport
    Airport{IataCode{"KZR"}, CountryId{"TR"}, Coordinate{30.1325, 39.1169}}, // Zafer Airport
    Airport{IataCode{"KZS"}, CountryId{"GR"}, Coordinate{29.5764, 36.1417}}, // Kastellorizo Airport
    Airport{IataCode{"LAA"}, CountryId{"US"}, Coordinate{-102.689, 38.0697}}, // Lamar Municipal Airport (Colorado)
    Airport{IataCode{"LAD"}, CountryId{"AO"}, Coordinate{13.2346, -8.84814}}, // Quatro de Fevereiro Airport
    Airport{IataCode{"LAE"}, CountryId{"PG"}, Coordinate{146.729, -6.56546}}, // Lae Nadzab Airport
    Airport{IataCode{"LAF"}, CountryId{"US"}, Coordinate{-86.9369, 40.4122}}, // Purdue University Airport
    Airport{IataCode{"LAH"}, CountryId{"ID"}, Coordinate{127.501, -0.637222}}, // Oesman Sadik Airport
    Airport{IataCode{"LAI"}, CountryId{"FR"}, Coordinate{-3.47082, 48.7568}}, // Lannion – Côte de Granit Airport
    Airport{IataCode{"LAJ"}, CountryId{"BR"}, Coordinate{-50.2793, -27.7819}}, // Lages Airport
    Airport{IataCode{"LAK"}, CountryId{"CA"}, Coordinate{-135.006, 68.2233}}, // Aklavik/Freddie Carmichael Airport
    Airport{IataCode{"LAL"}, CountryId{"US"}, Coordinate{-82.0143, 27.9944}}, // Lakeland Linder Regional Airport
    Airport{IataCode{"LAM"}, CountryId{"US"}, Coordinate{-106.275, 35.8818}}, // Los Alamos County Airport
    Airport{IataCode{"LAN"}, CountryId{"US"}, Coordinate{-84.5895, 42.7751}}, // Capital Region International Airport
    Airport{IataCode{"LAO"}, CountryId{"PH"}, Coordinate{120.534, 18.1819}}, // Laoag International Airport
    Airport{IataCode{"LAP"}, CountryId{"MX"}, Coordinate{-110.367, 24.0759}}, // Manuel Márquez de León International Airport
    Airport{IataCode{"LAQ"}, CountryId{"LY"}, Coordinate{21.9671, 32.7958}}, // Al Abraq International Airport
    Airport{IataCode{"LAR"}, CountryId{"US"}, Coordinate{-105.671, 41.3191}}, // Laramie Regional Airport
    Airport{IataCode{"LAS"}, CountryId{"US"}, Coordinate{-115.152, 36.08}}, // McCarran International Airport
    Airport{IataCode{"LAU"}, CountryId{"KE"}, Coordinate{40.9109, -2.25692}}, // Manda Airport
    Airport{IataCode{"LAW"}, CountryId{"US"}, Coordinate{-98.4138, 34.573}}, // Lawton–Fort Sill Regional Airport
    Airport{IataCode{"LAX"}, CountryId{"US"}, Coordinate{-118.408, 33.9425}}, // Los Angeles International Airport
    Airport{IataCode{"LAY"}, CountryId{"ZA"}, Coordinate{29.7514, -28.5816}}, // Ladysmith Airport
    Airport{IataCode{"LAZ"}, CountryId{"BR"}, Coordinate{-43.4075, -13.2614}}, // Bom Jesus da Lapa Airport
    Airport{IataCode{"LBA"}, CountryId{"GB"}, Coordinate{-1.65767, 53.8694}}, // Leeds Bradford Airport
    Airport{IataCode{"LBB"}, CountryId{"US"}, Coordinate{-101.819, 33.6567}}, // Lubbock Preston Smith International Airport
    Airport{IataCode{"LBC"}, CountryId{"DE"}, Coordinate{10.7018, 53.8051}}, // Lübeck Airport
    Airport{IataCode{"LBD"}, CountryId{"TJ"}, Coordinate{69.6968, 40.2195}}, // Khujand Airport
    Airport{IataCode{"LBE"}, CountryId{"US"}, Coordinate{-79.4057, 40.273}}, // Arnold Palmer Regional Airport
    Airport{IataCode{"LBF"}, CountryId{"US"}, Coordinate{-100.698, 41.1327}}, // North Platte Regional Airport
    Airport{IataCode{"LBG"}, CountryId{"FR"}, Coordinate{2.44181, 48.9549}}, // Paris–Le Bourget Airport
    Airport{IataCode{"LBJ"}, CountryId{"ID"}, Coordinate{119.889, -8.48667}}, // Komodo Airport
    Airport{IataCode{"LBK"}, CountryId{"KE"}, Coordinate{40.8817, 0.34833}}, // Liboi Airport
    Airport{IataCode{"LBL"}, CountryId{"US"}, Coordinate{-100.952, 37.0446}}, // Liberal Mid-America Regional Airport
    Airport{IataCode{"LBN"}, CountryId{"KE"}, Coordinate{36.0129, 0.6027}}, // Lake Baringo Airport
    Airport{IataCode{"LBO"}, CountryId{"CD"}, Coordinate{23.3783, -4.96667}}, // Lusambo Airport
    Airport{IataCode{"LBP"}, CountryId{"MY"}, Coordinate{115.45, 3.18333}}, // Long Banga Airport
    Airport{IataCode{"LBQ"}, CountryId{"GA"}, Coordinate{10.2435, -0.703092}}, // Lambaréné Airport
    Airport{IataCode{"LBR"}, CountryId{"BR"}, Coordinate{-64.7839, -7.25028}}, // Lábrea Airport
    Airport{IataCode{"LBS"}, CountryId{"FJ"}, Coordinate{179.34, -16.4667}}, // Labasa Airport
    Airport{IataCode{"LBT"}, CountryId{"US"}, Coordinate{-79.06, 34.6139}}, // Lumberton Municipal Airport
    Airport{IataCode{"LBU"}, CountryId{"MY"}, Coordinate{115.25, 5.30056}}, // Labuan Airport
    Airport{IataCode{"LBV"}, CountryId{"GA"}, Coordinate{9.40977, 0.458275}}, // Libreville International Airport
    Airport{IataCode{"LBW"}, CountryId{"ID"}, Coordinate{115.683, 3.86667}}, // Juvai Semaring Airport
    Airport{IataCode{"LBX"}, CountryId{"PH"}, Coordinate{120.103, 13.8565}}, // Lubang Airport
    Airport{IataCode{"LBZ"}, CountryId{"AO"}, Coordinate{20.7328, -8.44153}}, // Lucapa Airport
    Airport{IataCode{"LCA"}, CountryId{"CY"}, Coordinate{33.6172, 34.8749}}, // Larnaca International Airport
    Airport{IataCode{"LCE"}, CountryId{"HN"}, Coordinate{-86.8513, 15.7453}}, // Golosón International Airport
    Airport{IataCode{"LCF"}, CountryId{"GT"}, Coordinate{-88.9611, 15.6681}}, // Río Dulce Airport
    Airport{IataCode{"LCG"}, CountryId{"ES"}, Coordinate{-8.38122, 43.3023}}, // A Coruña Airport
    Airport{IataCode{"LCH"}, CountryId{"US"}, Coordinate{-93.2233, 30.1261}}, // Lake Charles Regional Airport
    Airport{IataCode{"LCI"}, CountryId{"US"}, Coordinate{-71.4255, 43.5732}}, // Laconia Municipal Airport
    Airport{IataCode{"LCJ"}, CountryId{"PL"}, Coordinate{19.402, 51.7269}}, // Łódź Władysław Reymont Airport
    Airport{IataCode{"LCK"}, CountryId{"US"}, Coordinate{-82.9361, 39.8172}}, // Rickenbacker International Airport
    Airport{IataCode{"LCL"}, CountryId{"CU"}, Coordinate{-83.6369, 22.3414}}, // La Coloma Airport
    Airport{IataCode{"LCM"}, CountryId{"AR"}, Coordinate{-64.5333, -31.0086}}, // La Cumbre Airport
    Airport{IataCode{"LCO"}, CountryId{"CG"}, Coordinate{14.5333, -2.45}}, // Lague Airport
    Airport{IataCode{"LCP"}, CountryId{"AR"}, Coordinate{-70.6678, -38.0828}}, // Loncopue Airport
    Airport{IataCode{"LCQ"}, CountryId{"US"}, Coordinate{-82.5769, 30.1819}}, // Lake City Gateway Airport
    Airport{IataCode{"LCR"}, CountryId{"CO"}, Coordinate{-72.8023, -1.45789}}, // La Chorrera Airport
    Airport{IataCode{"LCV"}, CountryId{"IT"}, Coordinate{10.5764, 43.8256}}, // Lucca-Tassignano Airport
    Airport{IataCode{"LCX"}, CountryId{"CN"}, Coordinate{116.746, 25.6742}}, // Longyan Guanzhishan Airport
    Airport{IataCode{"LCY"}, CountryId{"GB"}, Coordinate{0.0484205, 51.5036}}, // London City Airport
    Airport{IataCode{"LDA"}, CountryId{"IN"}, Coordinate{88.1235, 25.0104}}, // Malda Airport
    Airport{IataCode{"LDB"}, CountryId{"BR"}, Coordinate{-51.1376, -23.3287}}, // Londrina Airport
    Airport{IataCode{"LDE"}, CountryId{"FR"}, Coordinate{0.0029792, 43.1857}}, // Tarbes-Lourdes-Pyrénées Airport
    Airport{IataCode{"LDG"}, CountryId{"RU"}, Coordinate{45.7228, 64.8958}}, // Leshukonskoye Airport
    Airport{IataCode{"LDH"}, CountryId{"AU"}, Coordinate{159.078, -31.5407}}, // Lord Howe Island Airport
    Airport{IataCode{"LDI"}, CountryId{"TZ"}, Coordinate{39.7586, -9.85}}, // Lindi Airport
    Airport{IataCode{"LDJ"}, CountryId{"US"}, Coordinate{-74.2447, 40.6175}}, // Linden Airport
    Airport{IataCode{"LDK"}, CountryId{"SE"}, Coordinate{13.1667, 58.45}}, // Lidköping-Hovby Airport
    Airport{IataCode{"LDM"}, CountryId{"US"}, Coordinate{-86.4078, 43.9625}}, // Mason County Airport
    Airport{IataCode{"LDN"}, CountryId{"NP"}, Coordinate{86.67, 27.2531}}, // Lamidanda Airport
    Airport{IataCode{"LDO"}, CountryId{"SR"}, Coordinate{-55.4071, 4.37611}}, // Laduani Airstrip
    Airport{IataCode{"LDS"}, CountryId{"CN"}, Coordinate{129.015, 47.7492}}, // Yichun Lindu Airport
    Airport{IataCode{"LDU"}, CountryId{"MY"}, Coordinate{118.324, 5.03222}}, // Lahad Datu Airport
    Airport{IataCode{"LDX"}, CountryId{"FR"}, Coordinate{-54.0344, 5.48306}}, // Saint-Laurent-du-Maroni Airport
    Airport{IataCode{"LDY"}, CountryId{"GB"}, Coordinate{-7.15581, 55.0398}}, // City of Derry Airport
    Airport{IataCode{"LEB"}, CountryId{"US"}, Coordinate{-72.3095, 43.6267}}, // Lebanon Municipal Airport
    Airport{IataCode{"LED"}, CountryId{"RU"}, Coordinate{30.2881, 59.8014}}, // Pulkovo Airport
    Airport{IataCode{"LEE"}, CountryId{"US"}, Coordinate{-81.8087, 28.8231}}, // Leesburg International Airport
    Airport{IataCode{"LEF"}, CountryId{"LS"}, Coordinate{28.6556, -29.8908}}, // Lebakeng Airport
    Airport{IataCode{"LEH"}, CountryId{"FR"}, Coordinate{0.0921407, 49.5313}}, // Le Havre – Octeville Airport
    Airport{IataCode{"LEI"}, CountryId{"ES"}, Coordinate{-2.37211, 36.8474}}, // Almería Airport
    Airport{IataCode{"LEJ"}, CountryId{"DE"}, Coordinate{12.2236, 51.4233}}, // Leipzig/Halle Airport
    Airport{IataCode{"LEK"}, CountryId{"GN"}, Coordinate{-12.29, 11.3382}}, // Tata Airport
    Airport{IataCode{"LEL"}, CountryId{"AU"}, Coordinate{135.805, -12.4983}}, // Lake Evella Airport
    Airport{IataCode{"LEN"}, CountryId{"ES"}, Coordinate{-5.65556, 42.5889}}, // León Airport
    Airport{IataCode{"LEP"}, CountryId{"BR"}, Coordinate{-42.7331, -21.4719}}, // Leopoldina Airport
    Airport{IataCode{"LEQ"}, CountryId{"GB"}, Coordinate{-5.66815, 50.1024}}, // Land's End Airport
    Airport{IataCode{"LER"}, CountryId{"AU"}, Coordinate{120.703, -27.8433}}, // Leinster Airport
    Airport{IataCode{"LES"}, CountryId{"LS"}, Coordinate{28.3167, -29.7833}}, // Lesobeng Airport
    Airport{IataCode{"LET"}, CountryId{"CO"}, Coordinate{-69.9415, -4.19747}}, // Alfredo Vásquez Cobo International Airport
    Airport{IataCode{"LEU"}, CountryId{"ES"}, Coordinate{1.40917, 42.3386}}, // La Seu d'Urgell Airport
    Airport{IataCode{"LEV"}, CountryId{"FJ"}, Coordinate{178.759, -17.7111}}, // Levuka Airfield
    Airport{IataCode{"LEW"}, CountryId{"US"}, Coordinate{-70.2836, 44.0486}}, // Auburn/Lewiston Municipal Airport
    Airport{IataCode{"LEX"}, CountryId{"US"}, Coordinate{-84.5982, 38.0356}}, // Blue Grass Airport
    Airport{IataCode{"LEY"}, CountryId{"NL"}, Coordinate{5.52139, 52.462}}, // Lelystad Airport
    Airport{IataCode{"LEZ"}, CountryId{"HN"}, Coordinate{-88.175, 14.2}}, // La Esperanza Airport, Intibucá
    Airport{IataCode{"LFB"}, CountryId{"MZ"}, Coordinate{40.6667, -15.0333}}, // Lumbo Airport
    Airport{IataCode{"LFK"}, CountryId{"US"}, Coordinate{-94.75, 31.2339}}, // Angelina County Airport
    Airport{IataCode{"LFM"}, CountryId{"IR"}, Coordinate{53.1947, 27.3686}}, // Lamerd Airport
    Airport{IataCode{"LFN"}, CountryId{"US"}, Coordinate{-78.3303, 36.0233}}, // Triangle North Executive Airport
    Airport{IataCode{"LFO"}, CountryId{"ET"}, Coordinate{44.35, 5.657}}, // Kelafo East Airport
    Airport{IataCode{"LFQ"}, CountryId{"CN"}, Coordinate{111.497, 36.0431}}, // Linfen Qiaoli Airport
    Airport{IataCode{"LFR"}, CountryId{"VE"}, Coordinate{-72.2674, 8.23732}}, // La Fría Airport
    Airport{IataCode{"LFT"}, CountryId{"US"}, Coordinate{-91.994, 30.2085}}, // Lafayette Regional Airport
    Airport{IataCode{"LFW"}, CountryId{"TG"}, Coordinate{1.25217, 6.16892}}, // Lomé-Tokoin Airport
    Airport{IataCode{"LGA"}, CountryId{"US"}, Coordinate{-73.872, 40.772}}, // LaGuardia Airport
    Airport{IataCode{"LGB"}, CountryId{"US"}, Coordinate{-118.147, 33.8153}}, // Long Beach Airport
    Airport{IataCode{"LGC"}, CountryId{"US"}, Coordinate{-85.0725, 33.0089}}, // LaGrange-Callaway Airport
    Airport{IataCode{"LGD"}, CountryId{"US"}, Coordinate{-118.007, 45.2903}}, // La Grande/Union County Airport
    Airport{IataCode{"LGG"}, CountryId{"BE"}, Coordinate{5.46107, 50.6433}}, // Liege Airport
    Airport{IataCode{"LGH"}, CountryId{"AU"}, Coordinate{138.427, -30.9983}}, // Leigh Creek Airport
    Airport{IataCode{"LGI"}, CountryId{"BS"}, Coordinate{-75.0942, 23.1789}}, // Deadman's Cay Airport
    Airport{IataCode{"LGK"}, CountryId{"MY"}, Coordinate{99.7318, 6.34201}}, // Langkawi International Airport
    Airport{IataCode{"LGL"}, CountryId{"MY"}, Coordinate{115.179, 3.45944}}, // Long Lellang Airport
    Airport{IataCode{"LGN"}, CountryId{"PG"}, Coordinate{149.417, -5.68333}}, // Linga Linga
    Airport{IataCode{"LGP"}, CountryId{"PH"}, Coordinate{123.723, 13.1569}}, // Legazpi Airport
    Airport{IataCode{"LGQ"}, CountryId{"EC"}, Coordinate{-76.8694, 0.0925}}, // Lago Agrio Airport
    Airport{IataCode{"LGR"}, CountryId{"CL"}, Coordinate{-72.5852, -47.2446}}, // Cochrane, Chile Airport
    Airport{IataCode{"LGS"}, CountryId{"AR"}, Coordinate{-69.5846, -35.4834}}, // Comodoro D. Ricardo Salomón Airport
    Airport{IataCode{"LGT"}, CountryId{"CO"}, Coordinate{-70.9264, 4.55}}, // Las Gaviotas Airport
    Airport{IataCode{"LGU"}, CountryId{"US"}, Coordinate{-111.852, 41.7912}}, // Logan-Cache Airport
    Airport{IataCode{"LGW"}, CountryId{"GB"}, Coordinate{-0.161019, 51.1567}}, // Gatwick Airport
    Airport{IataCode{"LGX"}, CountryId{"SO"}, Coordinate{42.5458, 3.8125}}, // Lugh Ganane Airport
    Airport{IataCode{"LHA"}, CountryId{"DE"}, Coordinate{7.82772, 48.3693}}, // Flughafen Lahr
    Airport{IataCode{"LHC"}, CountryId{"PE"}, Coordinate{-70.5083, -3.91686}}, // Caballococha Airport
    Airport{IataCode{"LHE"}, CountryId{"PK"}, Coordinate{74.4105, 31.5206}}, // Allama Iqbal International Airport
    Airport{IataCode{"LHG"}, CountryId{"AU"}, Coordinate{147.985, -29.4567}}, // Lightning Ridge Airport
    Airport{IataCode{"LHP"}, CountryId{"PG"}, Coordinate{155.7, -6.417}}, // Lehu
    Airport{IataCode{"LHR"}, CountryId{"GB"}, Coordinate{-0.465675, 51.4661}}, // Heathrow Airport
    Airport{IataCode{"LHS"}, CountryId{"AR"}, Coordinate{-68.9658, -46.5385}}, // Colonia Las Heras Airport
    Airport{IataCode{"LHV"}, CountryId{"US"}, Coordinate{-77.4222, 41.1358}}, // William T. Piper Memorial Airport
    Airport{IataCode{"LHW"}, CountryId{"CN"}, Coordinate{103.615, 36.5079}}, // Lanzhou Zhongchuan International Airport
    Airport{IataCode{"LIE"}, CountryId{"CD"}, Coordinate{18.6333, 3.63333}}, // Libenge Airport
    Airport{IataCode{"LIF"}, CountryId{"FR"}, Coordinate{167.24, -20.7748}}, // Lifou Airport
    Airport{IataCode{"LIG"}, CountryId{"FR"}, Coordinate{1.17661, 45.862}}, // Limoges – Bellegarde Airport
    Airport{IataCode{"LIH"}, CountryId{"US"}, Coordinate{-159.347, 21.9793}}, // Lihue Airport
    Airport{IataCode{"LIK"}, CountryId{"MH"}, Coordinate{169.309, 9.82333}}, // Likiep Airport
    Airport{IataCode{"LIL"}, CountryId{"FR"}, Coordinate{3.10073, 50.5703}}, // Lille Airport
    Airport{IataCode{"LIM"}, CountryId{"PE"}, Coordinate{-77.1049, -12.0303}}, // Jorge Chávez International Airport
    Airport{IataCode{"LIN"}, CountryId{"IT"}, Coordinate{9.28, 45.4609}}, // Linate Airport
    Airport{IataCode{"LIO"}, CountryId{"CR"}, Coordinate{-83.0259, 9.96261}}, // Limón International Airport
    Airport{IataCode{"LIP"}, CountryId{"BR"}, Coordinate{-49.7326, -21.6638}}, // Lins Airport
    Airport{IataCode{"LIQ"}, CountryId{"CD"}, Coordinate{21.4833, 2.16667}}, // Lisala Airport
    Airport{IataCode{"LIR"}, CountryId{"CR"}, Coordinate{-85.5363, 10.6006}}, // Daniel Oduber Quirós International Airport
    Airport{IataCode{"LIS"}, CountryId{"PT"}, Coordinate{-9.12827, 38.7686}}, // Lisbon Airport
    Airport{IataCode{"LIT"}, CountryId{"US"}, Coordinate{-92.22, 34.73}}, // Bill and Hillary Clinton National Airport
    Airport{IataCode{"LIW"}, CountryId{"MM"}, Coordinate{97.2147, 19.6914}}, // Loikaw Airport
    Airport{IataCode{"LIX"}, CountryId{"MW"}, Coordinate{34.7333, -12.0833}}, // Likoma Airport
    Airport{IataCode{"LIZ"}, CountryId{"US"}, Coordinate{-67.8858, 46.9504}}, // Loring International Airport
    Airport{IataCode{"LJA"}, CountryId{"CD"}, Coordinate{23.4444, -3.41866}}, // Lodja Airport
    Airport{IataCode{"LJG"}, CountryId{"CN"}, Coordinate{100.246, 26.6711}}, // Lijiang Sanyi Airport
    Airport{IataCode{"LJN"}, CountryId{"US"}, Coordinate{-95.4622, 29.1086}}, // Texas Gulf Coast Regional Airport
    Airport{IataCode{"LJU"}, CountryId{"SI"}, Coordinate{14.4545, 46.2307}}, // Ljubljana Jože Pučnik Airport
    Airport{IataCode{"LKA"}, CountryId{"ID"}, Coordinate{123.002, -8.27454}}, // Gewayantana Airport
    Airport{IataCode{"LKB"}, CountryId{"FJ"}, Coordinate{-178.814, -18.2035}}, // Lakeba Airport
    Airport{IataCode{"LKG"}, CountryId{"KE"}, Coordinate{34.3496, 4.20262}}, // Lokichogio Airport
    Airport{IataCode{"LKH"}, CountryId{"MY"}, Coordinate{114.783, 3.31306}}, // Long Akah Airport
    Airport{IataCode{"LKK"}, CountryId{"US"}, Coordinate{-155.121, 58.9819}}, // Kulik Lake Airport
    Airport{IataCode{"LKL"}, CountryId{"NO"}, Coordinate{24.9819, 70.0662}}, // Lakselv Airport, Banak
    Airport{IataCode{"LKN"}, CountryId{"NO"}, Coordinate{13.6142, 68.1535}}, // Leknes Airport
    Airport{IataCode{"LKO"}, CountryId{"IN"}, Coordinate{80.8832, 26.7646}}, // Chaudhary Charan Singh Airport
    Airport{IataCode{"LKP"}, CountryId{"US"}, Coordinate{-73.9665, 44.264}}, // Lake Placid Airport
    Airport{IataCode{"LKU"}, CountryId{"KE"}, Coordinate{35.8833, 3.41667}}, // Lake Rudolf Airport
    Airport{IataCode{"LKV"}, CountryId{"US"}, Coordinate{-120.399, 42.1611}}, // Lake County Airport
    Airport{IataCode{"LKW"}, CountryId{"OM"}, Coordinate{55.3658, 22.8047}}, // Lekhwair Airport
    Airport{IataCode{"LKY"}, CountryId{"TZ"}, Coordinate{35.8163, -3.37395}}, // Lake Manyara Airport
    Airport{IataCode{"LLA"}, CountryId{"SE"}, Coordinate{22.123, 65.549}}, // Luleå-Kallax Airport
    Airport{IataCode{"LLB"}, CountryId{"CN"}, Coordinate{107.964, 25.4467}}, // Libo Airport
    Airport{IataCode{"LLC"}, CountryId{"PH"}, Coordinate{121.748, 18.1811}}, // Cagayan North International Airport
    Airport{IataCode{"LLE"}, CountryId{"ZA"}, Coordinate{31.5658, -25.4736}}, // Malelane Airport
    Airport{IataCode{"LLF"}, CountryId{"CN"}, Coordinate{111.613, 26.3447}}, // Yongzhou Lingling Airport
    Airport{IataCode{"LLG"}, CountryId{"AU"}, Coordinate{144.529, -17.1428}}, // Chillagoe Airport
    Airport{IataCode{"LLH"}, CountryId{"HN"}, Coordinate{-87.8986, 15.4431}}, // La Lima Airport
    Airport{IataCode{"LLI"}, CountryId{"ET"}, Coordinate{38.9842, 11.978}}, // Lalibela Airport
    Airport{IataCode{"LLJ"}, CountryId{"ID"}, Coordinate{102.917, -3.28}}, // Silampari Airport
    Airport{IataCode{"LLK"}, CountryId{"AZ"}, Coordinate{48.8238, 38.7422}}, // Lankaran International Airport
    Airport{IataCode{"LLO"}, CountryId{"ID"}, Coordinate{120.242, -3.08589}}, // Palopo Lagaligo Airport
    Airport{IataCode{"LLS"}, CountryId{"AR"}, Coordinate{-60.5491, -24.7214}}, // Alférez Armando Rodríguez Airport
    Airport{IataCode{"LLT"}, CountryId{"AO"}, Coordinate{13.5333, -12.3667}}, // Lobito Airport
    Airport{IataCode{"LLV"}, CountryId{"CN"}, Coordinate{111.138, 37.6844}}, // Lüliang Airport
    Airport{IataCode{"LLW"}, CountryId{"MW"}, Coordinate{33.7, -13.9667}}, // Lilongwe International Airport
    Airport{IataCode{"LLX"}, CountryId{"US"}, Coordinate{-72.0181, 44.5692}}, // Caledonia County Airport
    Airport{IataCode{"LLY"}, CountryId{"US"}, Coordinate{-74.8458, 39.9428}}, // South Jersey Regional Airport
    Airport{IataCode{"LMA"}, CountryId{"US"}, Coordinate{-152.302, 63.8861}}, // Minchumina Airport
    Airport{IataCode{"LMB"}, CountryId{"MW"}, Coordinate{34.5831, -13.7569}}, // Salima Airport
    Airport{IataCode{"LMC"}, CountryId{"CO"}, Coordinate{-73.7875, 2.17364}}, // La Macarena Airport
    Airport{IataCode{"LMD"}, CountryId{"AR"}, Coordinate{-68.0747, -40.8177}}, // Los Menucos Airport
    Airport{IataCode{"LME"}, CountryId{"FR"}, Coordinate{0.201667, 47.9486}}, // Airport Le Mans-Arnage
    Airport{IataCode{"LMH"}, CountryId{"HN"}, Coordinate{-85.55, 15.8667}}, // Limón, Colón, Honduras
    Airport{IataCode{"LMI"}, CountryId{"PG"}, Coordinate{142.03, -3.4856}}, // Lumi Airport
    Airport{IataCode{"LML"}, CountryId{"MH"}, Coordinate{166.266, 8.92167}}, // Lae Airport
    Airport{IataCode{"LMM"}, CountryId{"MX"}, Coordinate{-109.083, 25.6896}}, // Valle del Fuerte Federal International Airport
    Airport{IataCode{"LMN"}, CountryId{"MY"}, Coordinate{115.008, 4.80992}}, // Limbang Airport
    Airport{IataCode{"LMP"}, CountryId{"IT"}, Coordinate{12.6171, 35.5003}}, // Lampedusa Airport
    Airport{IataCode{"LMQ"}, CountryId{"LY"}, Coordinate{19.5764, 30.3781}}, // Marsa Brega Airport
    Airport{IataCode{"LMR"}, CountryId{"ZA"}, Coordinate{23.4391, -28.3601}}, // Lime Acres Finsch Mine Airport
    Airport{IataCode{"LMS"}, CountryId{"US"}, Coordinate{-89.0625, 33.1447}}, // Louisville Winston County Airport
    Airport{IataCode{"LMT"}, CountryId{"US"}, Coordinate{-121.744, 42.164}}, // Klamath Falls Airport
    Airport{IataCode{"LMY"}, CountryId{"PG"}, Coordinate{141.493, -7.0094}}, // Lake Murray Airport
    Airport{IataCode{"LNA"}, CountryId{"US"}, Coordinate{-80.085, 26.5931}}, // Palm Beach County Park Airport
    Airport{IataCode{"LNB"}, CountryId{"VU"}, Coordinate{168.16, -16.585}}, // Lamen Bay Airport
    Airport{IataCode{"LNC"}, CountryId{"US"}, Coordinate{-96.7175, 32.5775}}, // Lancaster Airport
    Airport{IataCode{"LND"}, CountryId{"US"}, Coordinate{-108.728, 42.8156}}, // Hunt Field
    Airport{IataCode{"LNE"}, CountryId{"VU"}, Coordinate{168.171, -15.8614}}, // Lonorore Airport
    Airport{IataCode{"LNF"}, CountryId{"PG"}, Coordinate{141.217, -4.86667}}, // Munbil
    Airport{IataCode{"LNG"}, CountryId{"PG"}, Coordinate{146.117, -8.16667}}, // Lese
    Airport{IataCode{"LNJ"}, CountryId{"CN"}, Coordinate{100.025, 23.744}}, // Lincang Airport
    Airport{IataCode{"LNL"}, CountryId{"CN"}, Coordinate{105.797, 33.7872}}, // Longnan Chengzhou Airport
    Airport{IataCode{"LNM"}, CountryId{"PG"}, Coordinate{146.2, -7.217}}, // Langimar
    Airport{IataCode{"LNN"}, CountryId{"US"}, Coordinate{-81.3897, 41.6839}}, // Willoughby Lost Nation Municipal Airport
    Airport{IataCode{"LNO"}, CountryId{"AU"}, Coordinate{121.315, -28.8781}}, // Leonora Airport
    Airport{IataCode{"LNP"}, CountryId{"US"}, Coordinate{-82.53, 36.9875}}, // Lonesome Pine Airport
    Airport{IataCode{"LNR"}, CountryId{"US"}, Coordinate{-90.1797, 43.2119}}, // Tri-County Regional Airport
    Airport{IataCode{"LNS"}, CountryId{"US"}, Coordinate{-76.2993, 40.1188}}, // Lancaster Airport
    Airport{IataCode{"LNU"}, CountryId{"ID"}, Coordinate{116.618, 3.57644}}, // Robert Atty Bessing Airport
    Airport{IataCode{"LNV"}, CountryId{"PG"}, Coordinate{152.627, -3.04308}}, // Lihir Island Airport
    Airport{IataCode{"LNX"}, CountryId{"RU"}, Coordinate{32.065, 54.745}}, // Smolensk South Airport
    Airport{IataCode{"LNY"}, CountryId{"US"}, Coordinate{-156.95, 20.7906}}, // Lanai Airport
    Airport{IataCode{"LNZ"}, CountryId{"AT"}, Coordinate{14.1926, 48.2395}}, // Linz Airport
    Airport{IataCode{"LOB"}, CountryId{"CL"}, Coordinate{-70.6481, -32.8144}}, // San Rafael Airport (Chile)
    Airport{IataCode{"LOD"}, CountryId{"VU"}, Coordinate{167.969, -15.3061}}, // Longana Airport
    Airport{IataCode{"LOE"}, CountryId{"TH"}, Coordinate{101.722, 17.4392}}, // Loei Airport
    Airport{IataCode{"LOH"}, CountryId{"EC"}, Coordinate{-79.3699, -3.99682}}, // Camilo Ponce Enríquez Airport - Ciudad de Catamayo
    Airport{IataCode{"LOI"}, CountryId{"BR"}, Coordinate{-49.5433, -27.1603}}, // Lontras Airport
    Airport{IataCode{"LOK"}, CountryId{"KE"}, Coordinate{35.6047, 3.12038}}, // Lodwar Airport
    Airport{IataCode{"LOL"}, CountryId{"US"}, Coordinate{-118.565, 40.0664}}, // Derby Field
    Airport{IataCode{"LOM"}, CountryId{"MX"}, Coordinate{-101.944, 21.2592}}, // Francisco Primo de Verdad National Airport
    Airport{IataCode{"LOO"}, CountryId{"DZ"}, Coordinate{2.94179, 33.7609}}, // L'Mekrareg Airport
    Airport{IataCode{"LOP"}, CountryId{"ID"}, Coordinate{116.277, -8.75732}}, // Lombok International Airport
    Airport{IataCode{"LOQ"}, CountryId{"BW"}, Coordinate{25.7139, -25.1975}}, // Lobatse Airport
    Airport{IataCode{"LOS"}, CountryId{"NG"}, Coordinate{3.32111, 6.57722}}, // Murtala Muhammed International Airport
    Airport{IataCode{"LOT"}, CountryId{"US"}, Coordinate{-88.0924, 41.6049}}, // Lewis University Airport
    Airport{IataCode{"LOU"}, CountryId{"US"}, Coordinate{-85.6636, 38.2281}}, // Bowman Field
    Airport{IataCode{"LOV"}, CountryId{"MX"}, Coordinate{-101.47, 26.9558}}, // Venustiano Carranza International Airport
    Airport{IataCode{"LOW"}, CountryId{"US"}, Coordinate{-77.97, 38.0097}}, // Louisa County Airport
    Airport{IataCode{"LOX"}, CountryId{"GT"}, Coordinate{-90.1667, 14.9667}}, // Los Tablones
    Airport{IataCode{"LOY"}, CountryId{"KE"}, Coordinate{36.7167, 2.74706}}, // Loiyangalani Airport
    Airport{IataCode{"LOZ"}, CountryId{"US"}, Coordinate{-84.0775, 37.0869}}, // London-Corbin Airport
    Airport{IataCode{"LPA"}, CountryId{"ES"}, Coordinate{-15.389, 27.9384}}, // Gran Canaria Airport
    Airport{IataCode{"LPB"}, CountryId{"BO"}, Coordinate{-68.1769, -16.5085}}, // El Alto International Airport
    Airport{IataCode{"LPC"}, CountryId{"US"}, Coordinate{-120.468, 34.6656}}, // Lompoc Airport
    Airport{IataCode{"LPD"}, CountryId{"CO"}, Coordinate{-69.5816, -1.33167}}, // La Pedrera Airport
    Airport{IataCode{"LPE"}, CountryId{"CO"}, Coordinate{-70.4212, 5.47917}}, // La Primavera
    Airport{IataCode{"LPF"}, CountryId{"CN"}, Coordinate{104.97, 26.6063}}, // Liupanshui Yuezhao Airport
    Airport{IataCode{"LPG"}, CountryId{"AR"}, Coordinate{-57.8954, -34.9655}}, // La Plata Airport
    Airport{IataCode{"LPI"}, CountryId{"SE"}, Coordinate{15.6577, 58.4076}}, // Linköping/Saab Airport
    Airport{IataCode{"LPK"}, CountryId{"RU"}, Coordinate{39.5245, 52.6981}}, // Lipetsk Airport
    Airport{IataCode{"LPL"}, CountryId{"GB"}, Coordinate{-2.85561, 53.3376}}, // Liverpool John Lennon Airport
    Airport{IataCode{"LPM"}, CountryId{"VU"}, Coordinate{167.817, -16.45}}, // Malekoula Airport
    Airport{IataCode{"LPN"}, CountryId{"PG"}, Coordinate{146.343, -6.39233}}, // Leron Plains Airport
    Airport{IataCode{"LPO"}, CountryId{"US"}, Coordinate{-86.7344, 41.5725}}, // La Porte Municipal Airport
    Airport{IataCode{"LPP"}, CountryId{"FI"}, Coordinate{28.1562, 61.044}}, // Lappeenranta Airport
    Airport{IataCode{"LPQ"}, CountryId{"LA"}, Coordinate{102.168, 19.9014}}, // Luang Prabang International Airport
    Airport{IataCode{"LPT"}, CountryId{"TH"}, Coordinate{99.5042, 18.2709}}, // Lampang Airport
    Airport{IataCode{"LPU"}, CountryId{"ID"}, Coordinate{114.97, 1.70361}}, // Long Apung Airport
    Airport{IataCode{"LPX"}, CountryId{"LV"}, Coordinate{21.0974, 56.5206}}, // Liepāja International Airport
    Airport{IataCode{"LPY"}, CountryId{"FR"}, Coordinate{3.76292, 45.0752}}, // Le Puy – Loudes Airport
    Airport{IataCode{"LQK"}, CountryId{"US"}, Coordinate{-82.7028, 34.81}}, // Pickens County Airport
    Airport{IataCode{"LQM"}, CountryId{"CO"}, Coordinate{-74.7726, -0.182503}}, // Caucayá Airport
    Airport{IataCode{"LQN"}, CountryId{"AF"}, Coordinate{63.1176, 34.9857}}, // Qala i Naw Airport
    Airport{IataCode{"LRB"}, CountryId{"LS"}, Coordinate{28.0528, -28.8556}}, // Leribe Airport
    Airport{IataCode{"LRD"}, CountryId{"US"}, Coordinate{-99.4557, 27.5437}}, // Laredo International Airport
    Airport{IataCode{"LRE"}, CountryId{"AU"}, Coordinate{144.28, -23.4342}}, // Longreach Airport
    Airport{IataCode{"LRG"}, CountryId{"US"}, Coordinate{-68.5347, 45.3622}}, // Lincoln Regional Airport
    Airport{IataCode{"LRH"}, CountryId{"FR"}, Coordinate{-1.19452, 46.176}}, // La Rochelle – Île de Ré Airport
    Airport{IataCode{"LRI"}, CountryId{"CO"}, Coordinate{-75.7, 9.03333}}, // Lorica
    Airport{IataCode{"LRJ"}, CountryId{"US"}, Coordinate{-96.1936, 42.7781}}, // Le Mars Municipal Airport
    Airport{IataCode{"LRL"}, CountryId{"TG"}, Coordinate{1.09932, 9.77549}}, // Niamtougou International Airport
    Airport{IataCode{"LRM"}, CountryId{"DO"}, Coordinate{-68.912, 18.4485}}, // La Romana International Airport
    Airport{IataCode{"LRO"}, CountryId{"US"}, Coordinate{-79.7828, 32.8978}}, // Mount Pleasant Regional Airport
    Airport{IataCode{"LRQ"}, CountryId{"CA"}, Coordinate{-101.304, 56.2486}}, // Laurie River Airport
    Airport{IataCode{"LRR"}, CountryId{"IR"}, Coordinate{54.3829, 27.67}}, // Larestan International Airport
    Airport{IataCode{"LRS"}, CountryId{"GR"}, Coordinate{26.8003, 37.1847}}, // Leros Island National Airport
    Airport{IataCode{"LRT"}, CountryId{"FR"}, Coordinate{-3.44, 47.7606}}, // Lorient South Brittany Airport
    Airport{IataCode{"LRU"}, CountryId{"US"}, Coordinate{-106.922, 32.2894}}, // Las Cruces International Airport
    Airport{IataCode{"LRV"}, CountryId{"VE"}, Coordinate{-66.6666, 11.9467}}, // Los Roques Airport
    Airport{IataCode{"LSA"}, CountryId{"PG"}, Coordinate{151.085, -8.50848}}, // Losuia Airport
    Airport{IataCode{"LSC"}, CountryId{"CL"}, Coordinate{-71.2028, -29.9174}}, // La Florida Airport
    Airport{IataCode{"LSE"}, CountryId{"US"}, Coordinate{-91.2635, 43.8753}}, // La Crosse Regional Airport
    Airport{IataCode{"LSH"}, CountryId{"MM"}, Coordinate{97.7525, 22.9758}}, // Lashio Airport
    Airport{IataCode{"LSI"}, CountryId{"GB"}, Coordinate{-1.28902, 59.8776}}, // Sumburgh Airport
    Airport{IataCode{"LSL"}, CountryId{"CR"}, Coordinate{-84.7, 11.0333}}, // Los Chiles Airport
    Airport{IataCode{"LSM"}, CountryId{"MY"}, Coordinate{115.583, 4.21639}}, // Long Semado Airport
    Airport{IataCode{"LSN"}, CountryId{"US"}, Coordinate{-120.869, 37.0628}}, // Los Banos Municipal Airport
    Airport{IataCode{"LSP"}, CountryId{"VE"}, Coordinate{-70.1495, 11.7774}}, // Josefa Camejo International Airport
    Airport{IataCode{"LSQ"}, CountryId{"CL"}, Coordinate{-72.4224, -37.4023}}, // María Dolores Airport
    Airport{IataCode{"LST"}, CountryId{"AU"}, Coordinate{147.206, -41.5431}}, // Launceston Airport
    Airport{IataCode{"LSU"}, CountryId{"MY"}, Coordinate{115.494, 4.55222}}, // Long Sukang Airport
    Airport{IataCode{"LSW"}, CountryId{"ID"}, Coordinate{96.9493, 5.22884}}, // Malikus Saleh Airport
    Airport{IataCode{"LSX"}, CountryId{"ID"}, Coordinate{96.9503, 5.22667}}, // Lhok Sukon Airport
    Airport{IataCode{"LSY"}, CountryId{"AU"}, Coordinate{153.263, -28.8366}}, // Lismore Airport
    Airport{IataCode{"LSZ"}, CountryId{"HR"}, Coordinate{14.3916, 44.5677}}, // Lošinj Airport
    Airport{IataCode{"LTA"}, CountryId{"ZA"}, Coordinate{30.3293, -23.8244}}, // Tzaneen Airport
    Airport{IataCode{"LTC"}, CountryId{"TD"}, Coordinate{16.3125, 9.39778}}, // Laï Airport
    Airport{IataCode{"LTD"}, CountryId{"LY"}, Coordinate{9.70246, 30.1522}}, // Ghadames Airport
    Airport{IataCode{"LTG"}, CountryId{"NP"}, Coordinate{85.583, 28.2}}, // Langtang Airport
    Airport{IataCode{"LTI"}, CountryId{"MN"}, Coordinate{96.2223, 46.3803}}, // Altai Airport
    Airport{IataCode{"LTK"}, CountryId{"SY"}, Coordinate{35.9486, 35.4008}}, // Bassel Al-Assad International Airport
    Airport{IataCode{"LTM"}, CountryId{"GY"}, Coordinate{-59.7961, 3.36889}}, // Lethem Airport
    Airport{IataCode{"LTN"}, CountryId{"GB"}, Coordinate{-0.37476, 51.8798}}, // London Luton Airport
    Airport{IataCode{"LTO"}, CountryId{"MX"}, Coordinate{-111.348, 25.9892}}, // Loreto International Airport
    Airport{IataCode{"LTQ"}, CountryId{"FR"}, Coordinate{1.6275, 50.5147}}, // Le Touquet – Côte d'Opale Airport
    Airport{IataCode{"LTT"}, CountryId{"FR"}, Coordinate{6.4816, 43.2054}}, // La Môle – Saint-Tropez Airport
    Airport{IataCode{"LTU"}, CountryId{"IN"}, Coordinate{76.4642, 18.4117}}, // Latur Airport
    Airport{IataCode{"LTW"}, CountryId{"US"}, Coordinate{-76.5499, 38.3136}}, // St. Mary's County Regional Airport
    Airport{IataCode{"LTX"}, CountryId{"EC"}, Coordinate{-78.619, -0.919234}}, // Cotopaxi International Airport
    Airport{IataCode{"LUA"}, CountryId{"NP"}, Coordinate{86.732, 27.6872}}, // Tenzing-Hillary Airport
    Airport{IataCode{"LUB"}, CountryId{"GY"}, Coordinate{-59.4408, 2.4}}, // Lumid Pau Airport
    Airport{IataCode{"LUC"}, CountryId{"FJ"}, Coordinate{-179.667, -16.7481}}, // Laucala Airport
    Airport{IataCode{"LUD"}, CountryId{"NA"}, Coordinate{15.2428, -26.6875}}, // Lüderitz Airport
    Airport{IataCode{"LUE"}, CountryId{"SK"}, Coordinate{19.7358, 48.3394}}, // Boľkovce-Lucenec
    Airport{IataCode{"LUG"}, CountryId{"CH"}, Coordinate{8.9078, 46.0037}}, // Lugano Airport
    Airport{IataCode{"LUH"}, CountryId{"IN"}, Coordinate{75.9525, 30.8547}}, // Sahnewal Airport
    Airport{IataCode{"LUI"}, CountryId{"HN"}, Coordinate{-86.6925, 15.0333}}, // La Unión Airport
    Airport{IataCode{"LUK"}, CountryId{"US"}, Coordinate{-84.4294, 39.1038}}, // Cincinnati Municipal Lunken Airport
    Airport{IataCode{"LUL"}, CountryId{"US"}, Coordinate{-89.1728, 31.6731}}, // Hesler-Noble Field
    Airport{IataCode{"LUM"}, CountryId{"CN"}, Coordinate{98.5478, 24.4}}, // Dehong Mangshi Airport
    Airport{IataCode{"LUN"}, CountryId{"ZM"}, Coordinate{28.4427, -15.3246}}, // Kenneth Kaunda International Airport
    Airport{IataCode{"LUO"}, CountryId{"AO"}, Coordinate{19.8974, -11.7682}}, // Luena Airport
    Airport{IataCode{"LUP"}, CountryId{"US"}, Coordinate{-156.974, 21.2111}}, // Kalaupapa Airport
    Airport{IataCode{"LUQ"}, CountryId{"AR"}, Coordinate{-66.3508, -33.2751}}, // Brigadier Mayor César Raúl Ojeda Airport
    Airport{IataCode{"LUS"}, CountryId{"CD"}, Coordinate{18.7167, -4.8}}, // Lusanga Airport
    Airport{IataCode{"LUU"}, CountryId{"AU"}, Coordinate{144.45, -15.55}}, // Laura Airport
    Airport{IataCode{"LUV"}, CountryId{"ID"}, Coordinate{132.76, -5.75612}}, // Karel Sadsuitubun Airport
    Airport{IataCode{"LUW"}, CountryId{"ID"}, Coordinate{122.761, -1.03778}}, // Syukuran Aminuddin Amir Airport
    Airport{IataCode{"LUX"}, CountryId{"LU"}, Coordinate{6.21549, 49.6334}}, // Luxembourg Airport
    Airport{IataCode{"LUZ"}, CountryId{"PL"}, Coordinate{22.6903, 51.2319}}, // Lublin Airport
    Airport{IataCode{"LVA"}, CountryId{"FR"}, Coordinate{-0.743, 48.032}}, // Laval - Entrammes Airport
    Airport{IataCode{"LVB"}, CountryId{"BR"}, Coordinate{-55.6247, -30.8358}}, // Santana do Livramento Airport
    Airport{IataCode{"LVI"}, CountryId{"ZM"}, Coordinate{25.8186, -17.8217}}, // Harry Mwanga Nkumbula International Airport
    Airport{IataCode{"LVK"}, CountryId{"US"}, Coordinate{-121.82, 37.6934}}, // Livermore Municipal Airport
    Airport{IataCode{"LVM"}, CountryId{"US"}, Coordinate{-110.449, 45.6991}}, // Mission Field
    Airport{IataCode{"LVO"}, CountryId{"AU"}, Coordinate{122.423, -28.6136}}, // Laverton Airport
    Airport{IataCode{"LVP"}, CountryId{"IR"}, Coordinate{53.3512, 26.8088}}, // Lavan Airport
    Airport{IataCode{"LVR"}, CountryId{"BR"}, Coordinate{-55.9422, -13.0372}}, // Lucas do Rio Verde Airport
    Airport{IataCode{"LVS"}, CountryId{"US"}, Coordinate{-105.143, 35.6542}}, // Las Vegas Municipal Airport
    Airport{IataCode{"LWB"}, CountryId{"US"}, Coordinate{-80.3994, 37.8583}}, // Greenbrier Valley Airport
    Airport{IataCode{"LWC"}, CountryId{"US"}, Coordinate{-95.2164, 39.0111}}, // Lawrence Municipal Airport
    Airport{IataCode{"LWE"}, CountryId{"ID"}, Coordinate{122.237, -8.64056}}, // Wonopito Airport
    Airport{IataCode{"LWL"}, CountryId{"US"}, Coordinate{-114.922, 41.1172}}, // Wells Municipal Airport
    Airport{IataCode{"LWM"}, CountryId{"US"}, Coordinate{-71.1213, 42.7144}}, // Lawrence Municipal Airport
    Airport{IataCode{"LWN"}, CountryId{"AM"}, Coordinate{43.8543, 40.7512}}, // Shirak International Airport
    Airport{IataCode{"LWO"}, CountryId{"UA"}, Coordinate{23.9561, 49.8125}}, // Lviv Danylo Halytskyi International Airport
    Airport{IataCode{"LWS"}, CountryId{"US"}, Coordinate{-117.011, 46.3772}}, // Lewiston – Nez Perce County Airport
    Airport{IataCode{"LWT"}, CountryId{"US"}, Coordinate{-109.467, 47.0492}}, // Lewistown Municipal Airport
    Airport{IataCode{"LWV"}, CountryId{"US"}, Coordinate{-87.6056, 38.7642}}, // Lawrenceville-Vincennes International Airport
    Airport{IataCode{"LWY"}, CountryId{"MY"}, Coordinate{115.403, 4.84917}}, // Lawas Airport
    Airport{IataCode{"LXA"}, CountryId{"CN"}, Coordinate{90.8968, 29.2917}}, // Lhasa Gonggar Airport
    Airport{IataCode{"LXG"}, CountryId{"LA"}, Coordinate{101.401, 20.9543}}, // Louangnamtha Airport
    Airport{IataCode{"LXN"}, CountryId{"US"}, Coordinate{-99.7758, 40.7906}}, // Jim Kelly Field
    Airport{IataCode{"LXR"}, CountryId{"EG"}, Coordinate{32.7004, 25.6742}}, // Luxor International Airport
    Airport{IataCode{"LXS"}, CountryId{"GR"}, Coordinate{25.2363, 39.9171}}, // Lemnos International Airport
    Airport{IataCode{"LXU"}, CountryId{"ZM"}, Coordinate{23.2486, -14.3758}}, // Lukulu Airport
    Airport{IataCode{"LXV"}, CountryId{"US"}, Coordinate{-106.317, 39.2203}}, // Lake County Airport
    Airport{IataCode{"LYA"}, CountryId{"CN"}, Coordinate{112.388, 34.7413}}, // Luoyang Beijiao Airport
    Airport{IataCode{"LYB"}, CountryId{"GB"}, Coordinate{-80.1, 19.6667}}, // Edward Bodden Airfield
    Airport{IataCode{"LYC"}, CountryId{"SE"}, Coordinate{18.7161, 64.5481}}, // Lycksele Airport
    Airport{IataCode{"LYE"}, CountryId{"GB"}, Coordinate{-1.99333, 51.5053}}, // MoD Lyneham
    Airport{IataCode{"LYG"}, CountryId{"CN"}, Coordinate{118.876, 34.5657}}, // Lianyungang Airport
    Airport{IataCode{"LYH"}, CountryId{"US"}, Coordinate{-79.1939, 37.3304}}, // Lynchburg Regional Airport
    Airport{IataCode{"LYI"}, CountryId{"CN"}, Coordinate{118.407, 35.0485}}, // Linyi Qiyang Airport
    Airport{IataCode{"LYN"}, CountryId{"FR"}, Coordinate{4.93806, 45.7303}}, // Lyon-Bron Airport
    Airport{IataCode{"LYP"}, CountryId{"PK"}, Coordinate{72.9878, 31.3628}}, // Faisalabad International Airport
    Airport{IataCode{"LYR"}, CountryId{"NO"}, Coordinate{15.4919, 78.2468}}, // Svalbard Airport
    Airport{IataCode{"LYS"}, CountryId{"FR"}, Coordinate{5.07972, 45.7201}}, // Lyon-Saint Exupéry Airport
    Airport{IataCode{"LYU"}, CountryId{"US"}, Coordinate{-91.8308, 47.8244}}, // Ely Municipal Airport
    Airport{IataCode{"LYX"}, CountryId{"GB"}, Coordinate{0.939167, 50.9561}}, // Lydd Airport
    Airport{IataCode{"LZA"}, CountryId{"CD"}, Coordinate{22.4, -7.18333}}, // Luiza Airport
    Airport{IataCode{"LZC"}, CountryId{"MX"}, Coordinate{-102.224, 17.9959}}, // Lázaro Cárdenas Airport
    Airport{IataCode{"LZH"}, CountryId{"CN"}, Coordinate{109.399, 24.2043}}, // Liuzhou Bailian Airport
    Airport{IataCode{"LZM"}, CountryId{"AO"}, Coordinate{18.0493, -9.11596}}, // Luzamba Airport
    Airport{IataCode{"LZN"}, CountryId{"TW"}, Coordinate{119.956, 26.1579}}, // Matsu Nangan Airport
    Airport{IataCode{"LZO"}, CountryId{"CN"}, Coordinate{105.462, 29.0236}}, // Luzhou Yunlong Airport
    Airport{IataCode{"LZR"}, CountryId{"AU"}, Coordinate{145.453, -14.6767}}, // Lizard Island Airport
    Airport{IataCode{"LZU"}, CountryId{"US"}, Coordinate{-83.9625, 33.9781}}, // Gwinnett County Airport
    Airport{IataCode{"LZY"}, CountryId{"CN"}, Coordinate{94.3362, 29.3088}}, // Nyingchi Mainling Airport
    Airport{IataCode{"MAA"}, CountryId{"IN"}, Coordinate{80.1642, 12.9808}}, // Chennai International Airport
    Airport{IataCode{"MAB"}, CountryId{"BR"}, Coordinate{-49.137, -5.37167}}, // Marabá Airport
    Airport{IataCode{"MAC"}, CountryId{"US"}, Coordinate{-83.5619, 32.8222}}, // Macon Downtown Airport
    Airport{IataCode{"MAD"}, CountryId{"ES"}, Coordinate{-3.57176, 40.4679}}, // Adolfo Suarez Madrid-Barajas Airport
    Airport{IataCode{"MAE"}, CountryId{"US"}, Coordinate{-120.113, 36.9886}}, // Madera Municipal Airport
    Airport{IataCode{"MAF"}, CountryId{"US"}, Coordinate{-102.208, 31.9371}}, // Midland International Airport
    Airport{IataCode{"MAG"}, CountryId{"PG"}, Coordinate{145.783, -5.20833}}, // Madang Airport
    Airport{IataCode{"MAH"}, CountryId{"ES"}, Coordinate{4.21861, 39.8625}}, // Menorca Airport
    Airport{IataCode{"MAI"}, CountryId{"MW"}, Coordinate{35.2625, -14.4889}}, // Mangochi Airport
    Airport{IataCode{"MAJ"}, CountryId{"MH"}, Coordinate{171.283, 7.06907}}, // Marshall Islands International Airport
    Airport{IataCode{"MAK"}, CountryId{"SS"}, Coordinate{31.6525, 9.55523}}, // Malakal Airport
    Airport{IataCode{"MAL"}, CountryId{"US"}, Coordinate{-74.3289, 44.8536}}, // Malone-Dufort Airport
    Airport{IataCode{"MAM"}, CountryId{"MX"}, Coordinate{-97.5253, 25.7699}}, // General Servando Canales International Airport
    Airport{IataCode{"MAN"}, CountryId{"GB"}, Coordinate{-2.27204, 53.3652}}, // Manchester Airport
    Airport{IataCode{"MAO"}, CountryId{"BR"}, Coordinate{-60.0461, -3.03182}}, // Manaus International Airport
    Airport{IataCode{"MAP"}, CountryId{"PG"}, Coordinate{149.5, -10.3}}, // Mamai
    Airport{IataCode{"MAQ"}, CountryId{"TH"}, Coordinate{98.5448, 16.7025}}, // Mae Sot Airport
    Airport{IataCode{"MAR"}, CountryId{"VE"}, Coordinate{-71.7242, 10.5557}}, // La Chinita International Airport
    Airport{IataCode{"MAS"}, CountryId{"PG"}, Coordinate{147.424, -2.06194}}, // Momote Airport
    Airport{IataCode{"MAT"}, CountryId{"CD"}, Coordinate{13.4401, -5.7947}}, // Tshimpi Airport
    Airport{IataCode{"MAU"}, CountryId{"FR"}, Coordinate{-152.243, -16.4264}}, // Maupiti Airport
    Airport{IataCode{"MAV"}, CountryId{"MH"}, Coordinate{171.231, 8.705}}, // Maloelap Airport
    Airport{IataCode{"MAW"}, CountryId{"US"}, Coordinate{-89.9925, 36.5983}}, // Malden Regional Airport
    Airport{IataCode{"MAY"}, CountryId{"BS"}, Coordinate{-77.6847, 24.2833}}, // Clarence A. Bain Airport
    Airport{IataCode{"MAZ"}, CountryId{"US"}, Coordinate{-67.1494, 18.2537}}, // Eugenio María de Hostos Airport
    Airport{IataCode{"MBA"}, CountryId{"KE"}, Coordinate{39.603, -4.03031}}, // Moi International Airport
    Airport{IataCode{"MBC"}, CountryId{"GA"}, Coordinate{11.9125, -1.89306}}, // Mbigou Airport
    Airport{IataCode{"MBD"}, CountryId{"ZA"}, Coordinate{25.5399, -25.8037}}, // Mafikeng Airport
    Airport{IataCode{"MBE"}, CountryId{"JP"}, Coordinate{143.404, 44.3042}}, // Monbetsu Airport
    Airport{IataCode{"MBG"}, CountryId{"US"}, Coordinate{-100.406, 45.5464}}, // Mobridge Municipal Airport
    Airport{IataCode{"MBH"}, CountryId{"AU"}, Coordinate{152.715, -25.5133}}, // Maryborough Airport
    Airport{IataCode{"MBI"}, CountryId{"TZ"}, Coordinate{33.4576, -8.91423}}, // Mbeya Airport
    Airport{IataCode{"MBJ"}, CountryId{"JM"}, Coordinate{-77.9162, 18.4985}}, // Sangster International Airport
    Airport{IataCode{"MBK"}, CountryId{"BR"}, Coordinate{-54.9528, -10.1703}}, // Matupá Airport
    Airport{IataCode{"MBL"}, CountryId{"US"}, Coordinate{-86.2562, 44.2754}}, // Manistee County Blacker Airport
    Airport{IataCode{"MBO"}, CountryId{"PH"}, Coordinate{120.603, 13.2116}}, // Mamburao Airport
    Airport{IataCode{"MBP"}, CountryId{"PE"}, Coordinate{-76.9873, -6.0237}}, // Moyobamba Airport
    Airport{IataCode{"MBQ"}, CountryId{"UG"}, Coordinate{30.6, -0.555}}, // Mbarara Airport
    Airport{IataCode{"MBS"}, CountryId{"US"}, Coordinate{-84.0821, 43.5382}}, // MBS International Airport
    Airport{IataCode{"MBT"}, CountryId{"PH"}, Coordinate{123.627, 12.3668}}, // Moises R. Espinosa Airport
    Airport{IataCode{"MBU"}, CountryId{"SB"}, Coordinate{159.839, -9.7475}}, // Mbambanakira Airport
    Airport{IataCode{"MBW"}, CountryId{"AU"}, Coordinate{145.095, -37.9761}}, // Moorabbin Airport
    Airport{IataCode{"MBX"}, CountryId{"SI"}, Coordinate{15.6822, 46.478}}, // Maribor Edvard Rusjan Airport
    Airport{IataCode{"MBZ"}, CountryId{"BR"}, Coordinate{-57.7122, -3.35694}}, // Maués Airport
    Airport{IataCode{"MCA"}, CountryId{"GN"}, Coordinate{-9.467, 8.533}}, // Macenta Airport
    Airport{IataCode{"MCB"}, CountryId{"US"}, Coordinate{-90.4719, 31.1783}}, // McComb-Pike County Airport
    Airport{IataCode{"MCC"}, CountryId{"US"}, Coordinate{-121.401, 38.6678}}, // McClellan Airfield
    Airport{IataCode{"MCD"}, CountryId{"US"}, Coordinate{-84.6372, 45.865}}, // Mackinac Island Airport
    Airport{IataCode{"MCE"}, CountryId{"US"}, Coordinate{-120.516, 37.2885}}, // Merced Regional Airport
    Airport{IataCode{"MCG"}, CountryId{"US"}, Coordinate{-155.606, 62.9528}}, // McGrath Airport
    Airport{IataCode{"MCH"}, CountryId{"EC"}, Coordinate{-79.9614, -3.26889}}, // General Manuel Serrano Airport
    Airport{IataCode{"MCI"}, CountryId{"US"}, Coordinate{-94.7163, 39.2945}}, // Kansas City International Airport
    Airport{IataCode{"MCJ"}, CountryId{"CO"}, Coordinate{-72.4911, 11.2354}}, // Jorge Isaacs Airport
    Airport{IataCode{"MCK"}, CountryId{"US"}, Coordinate{-100.597, 40.2078}}, // McCook Ben Nelson Regional Airport
    Airport{IataCode{"MCL"}, CountryId{"US"}, Coordinate{-148.911, 63.7325}}, // McKinley National Park Airport
    Airport{IataCode{"MCM"}, CountryId{"MC"}, Coordinate{7.41915, 43.7257}}, // Monaco Heliport
    Airport{IataCode{"MCN"}, CountryId{"US"}, Coordinate{-83.6502, 32.7015}}, // Middle Georgia Regional Airport
    Airport{IataCode{"MCO"}, CountryId{"US"}, Coordinate{-81.3089, 28.4294}}, // Orlando International Airport
    Airport{IataCode{"MCP"}, CountryId{"BR"}, Coordinate{-51.0673, 0.0500715}}, // Macapá International Airport
    Airport{IataCode{"MCQ"}, CountryId{"HU"}, Coordinate{20.7933, 48.1308}}, // Miskolc Airport
    Airport{IataCode{"MCS"}, CountryId{"AR"}, Coordinate{-57.6394, -30.2703}}, // Monte Caseros Airport
    Airport{IataCode{"MCT"}, CountryId{"OM"}, Coordinate{58.2869, 23.6009}}, // Muscat International Airport
    Airport{IataCode{"MCV"}, CountryId{"AU"}, Coordinate{136.075, -16.445}}, // McArthur River Mine Airport
    Airport{IataCode{"MCW"}, CountryId{"US"}, Coordinate{-93.3362, 43.1531}}, // Mason City Municipal Airport
    Airport{IataCode{"MCX"}, CountryId{"RU"}, Coordinate{47.6559, 42.8209}}, // Uytash Airport
    Airport{IataCode{"MCY"}, CountryId{"AU"}, Coordinate{153.089, -26.6053}}, // Sunshine Coast Airport
    Airport{IataCode{"MCZ"}, CountryId{"BR"}, Coordinate{-35.7836, -9.51722}}, // Zumbi dos Palmares International Airport
    Airport{IataCode{"MDB"}, CountryId{"BZ"}, Coordinate{-88.3042, 17.0045}}, // Melinda Airport
    Airport{IataCode{"MDC"}, CountryId{"ID"}, Coordinate{124.923, 1.5435}}, // Sam Ratulangi International Airport
    Airport{IataCode{"MDD"}, CountryId{"US"}, Coordinate{-102.101, 32.0367}}, // Midland Airpark
    Airport{IataCode{"MDE"}, CountryId{"CO"}, Coordinate{-75.4284, 6.1713}}, // José María Córdova International Airport
    Airport{IataCode{"MDF"}, CountryId{"US"}, Coordinate{-90.3083, 45.1046}}, // Taylor County Airport
    Airport{IataCode{"MDG"}, CountryId{"CN"}, Coordinate{129.581, 44.5352}}, // Mudanjiang Hailang International Airport
    Airport{IataCode{"MDH"}, CountryId{"US"}, Coordinate{-89.2519, 37.7781}}, // Southern Illinois Airport
    Airport{IataCode{"MDI"}, CountryId{"NG"}, Coordinate{8.61389, 7.70361}}, // Makurdi Airport
    Airport{IataCode{"MDJ"}, CountryId{"US"}, Coordinate{-121.155, 44.6703}}, // Madras Municipal Airport
    Airport{IataCode{"MDK"}, CountryId{"CD"}, Coordinate{18.2886, 0.0225}}, // Mbandaka Airport
    Airport{IataCode{"MDL"}, CountryId{"MM"}, Coordinate{95.9704, 21.7056}}, // Mandalay International Airport
    Airport{IataCode{"MDM"}, CountryId{"PG"}, Coordinate{143.5, -4.633}}, // Munduku
    Airport{IataCode{"MDO"}, CountryId{"US"}, Coordinate{-146.307, 59.4497}}, // Middleton Island Airport
    Airport{IataCode{"MDQ"}, CountryId{"AR"}, Coordinate{-57.5815, -37.9333}}, // Astor Piazzolla International Airport
    Airport{IataCode{"MDS"}, CountryId{"GB"}, Coordinate{-71.8025, 21.8258}}, // Middle Caicos Airport
    Airport{IataCode{"MDT"}, CountryId{"US"}, Coordinate{-76.7556, 40.1958}}, // Harrisburg International Airport
    Airport{IataCode{"MDU"}, CountryId{"PG"}, Coordinate{143.658, -6.1446}}, // Mendi Airport
    Airport{IataCode{"MDV"}, CountryId{"GA"}, Coordinate{10.7556, 1.00694}}, // Médouneu Airport
    Airport{IataCode{"MDW"}, CountryId{"US"}, Coordinate{-87.7431, 41.7865}}, // Midway International Airport
    Airport{IataCode{"MDX"}, CountryId{"AR"}, Coordinate{-58.0881, -29.2222}}, // Mercedes Airport
    Airport{IataCode{"MDY"}, CountryId{"US"}, Coordinate{-177.381, 28.2014}}, // Henderson Field
    Airport{IataCode{"MDZ"}, CountryId{"AR"}, Coordinate{-68.7985, -32.8278}}, // Governor Francisco Gabrielli International Airport
    Airport{IataCode{"MEA"}, CountryId{"BR"}, Coordinate{-41.7639, -22.3428}}, // Macaé Airport
    Airport{IataCode{"MEB"}, CountryId{"AU"}, Coordinate{144.898, -37.7275}}, // Essendon Airport
    Airport{IataCode{"MEC"}, CountryId{"EC"}, Coordinate{-80.684, -0.953183}}, // Eloy Alfaro International Airport
    Airport{IataCode{"MED"}, CountryId{"SA"}, Coordinate{39.7058, 24.5503}}, // Prince Mohammad Bin Abdulaziz International Airport
    Airport{IataCode{"MEE"}, CountryId{"FR"}, Coordinate{168.038, -21.4814}}, // Maré Airport
    Airport{IataCode{"MEF"}, CountryId{"TD"}, Coordinate{17.95, 11.05}}, // Melfi Airport
    Airport{IataCode{"MEG"}, CountryId{"AO"}, Coordinate{16.3124, -9.52492}}, // Malanje Airport
    Airport{IataCode{"MEH"}, CountryId{"NO"}, Coordinate{27.8264, 71.0289}}, // Mehamn Airport
    Airport{IataCode{"MEI"}, CountryId{"US"}, Coordinate{-88.7451, 32.3336}}, // Meridian Regional Airport
    Airport{IataCode{"MEJ"}, CountryId{"US"}, Coordinate{-80.2147, 41.6267}}, // Port Meadville Airport
    Airport{IataCode{"MEL"}, CountryId{"AU"}, Coordinate{144.849, -37.678}}, // Melbourne Airport
    Airport{IataCode{"MEM"}, CountryId{"US"}, Coordinate{-89.9816, 35.0435}}, // Memphis International Airport
    Airport{IataCode{"MEO"}, CountryId{"US"}, Coordinate{-75.7003, 35.9171}}, // Dare County Regional Airport
    Airport{IataCode{"MEP"}, CountryId{"MY"}, Coordinate{103.876, 2.3864}}, // Mersing Airport
    Airport{IataCode{"MEQ"}, CountryId{"ID"}, Coordinate{96.2506, 4.04732}}, // Cut Nyak Dhien Airport
    Airport{IataCode{"MER"}, CountryId{"US"}, Coordinate{-120.57, 37.3724}}, // Castle Airport
    Airport{IataCode{"MEU"}, CountryId{"BR"}, Coordinate{-52.5999, -0.884942}}, // Monte Dourado Airport
    Airport{IataCode{"MEV"}, CountryId{"US"}, Coordinate{-119.752, 39.0008}}, // Minden-Tahoe Airport
    Airport{IataCode{"MEW"}, CountryId{"CD"}, Coordinate{21.5417, -4.855}}, // Mweka Airport
    Airport{IataCode{"MEX"}, CountryId{"MX"}, Coordinate{-99.0821, 19.4296}}, // Mexico City International Airport
    Airport{IataCode{"MEY"}, CountryId{"NP"}, Coordinate{84.2289, 27.5772}}, // Meghauli Airport
    Airport{IataCode{"MEZ"}, CountryId{"ZA"}, Coordinate{29.9866, -22.3561}}, // Messina Airport
    Airport{IataCode{"MFA"}, CountryId{"TZ"}, Coordinate{39.664, -7.91187}}, // Mafia Airport
    Airport{IataCode{"MFC"}, CountryId{"LS"}, Coordinate{27.2433, -29.8289}}, // Mafeteng Airport
    Airport{IataCode{"MFD"}, CountryId{"US"}, Coordinate{-82.5167, 40.8214}}, // Mansfield Lahm Regional Airport
    Airport{IataCode{"MFE"}, CountryId{"US"}, Coordinate{-98.24, 26.1805}}, // McAllen-Miller International Airport
    Airport{IataCode{"MFF"}, CountryId{"GA"}, Coordinate{13.2694, -1.53778}}, // Moanda Airport
    Airport{IataCode{"MFG"}, CountryId{"PK"}, Coordinate{73.5057, 34.3424}}, // Muzaffarabad Airport
    Airport{IataCode{"MFH"}, CountryId{"US"}, Coordinate{-114.055, 36.835}}, // Mesquite Airport
    Airport{IataCode{"MFI"}, CountryId{"US"}, Coordinate{-90.1884, 44.6408}}, // Marshfield Municipal Airport
    Airport{IataCode{"MFJ"}, CountryId{"FJ"}, Coordinate{179.951, -18.5669}}, // Moala Airport
    Airport{IataCode{"MFK"}, CountryId{"TW"}, Coordinate{119.999, 26.2236}}, // Matsu Beigan Airport
    Airport{IataCode{"MFM"}, CountryId{"CN"}, Coordinate{113.575, 22.1594}}, // Macau International Airport
    Airport{IataCode{"MFN"}, CountryId{"NZ"}, Coordinate{167.923, -44.6733}}, // Milford Sound Airport
    Airport{IataCode{"MFO"}, CountryId{"PG"}, Coordinate{151.792, -5.5825}}, // Manguna Airport
    Airport{IataCode{"MFQ"}, CountryId{"NE"}, Coordinate{7.1202, 13.5008}}, // Maradi Airport
    Airport{IataCode{"MFR"}, CountryId{"US"}, Coordinate{-122.874, 42.3685}}, // Rogue Valley International-Medford Airport
    Airport{IataCode{"MFS"}, CountryId{"CO"}, Coordinate{-71.9521, 1.33771}}, // Miraflores Airport
    Airport{IataCode{"MFU"}, CountryId{"ZM"}, Coordinate{31.9333, -13.2667}}, // Mfuwe Airport
    Airport{IataCode{"MFV"}, CountryId{"US"}, Coordinate{-75.7609, 37.6427}}, // Accomack County Airport
    Airport{IataCode{"MFY"}, CountryId{"YE"}, Coordinate{47.5667, 14.3}}, // Mayfa'ah,
    Airport{IataCode{"MFZ"}, CountryId{"PG"}, Coordinate{149.117, -6.1368}}, // Meselia Airport
    Airport{IataCode{"MGA"}, CountryId{"NI"}, Coordinate{-86.1717, 12.1448}}, // Augusto C. Sandino International Airport
    Airport{IataCode{"MGB"}, CountryId{"AU"}, Coordinate{140.783, -37.7444}}, // Mount Gambier Airport
    Airport{IataCode{"MGC"}, CountryId{"US"}, Coordinate{-86.8211, 41.7033}}, // Michigan City Municipal Airport
    Airport{IataCode{"MGD"}, CountryId{"BO"}, Coordinate{-64.1366, -13.3084}}, // Magdalena Airport
    Airport{IataCode{"MGF"}, CountryId{"BR"}, Coordinate{-52.0122, -23.4794}}, // Maringá Regional Airport
    Airport{IataCode{"MGG"}, CountryId{"PG"}, Coordinate{143.359, -5.97881}}, // Margarima Airport
    Airport{IataCode{"MGH"}, CountryId{"ZA"}, Coordinate{30.3434, -30.8602}}, // Margate Airport
    Airport{IataCode{"MGJ"}, CountryId{"US"}, Coordinate{-74.2647, 41.51}}, // Orange County Airport
    Airport{IataCode{"MGM"}, CountryId{"US"}, Coordinate{-86.3905, 32.3046}}, // Montgomery Regional Airport
    Airport{IataCode{"MGN"}, CountryId{"CO"}, Coordinate{-74.8667, 9.11807}}, // Baracoa Regional Airport
    Airport{IataCode{"MGP"}, CountryId{"PG"}, Coordinate{153.017, -4.15}}, // Manga Airport
    Airport{IataCode{"MGQ"}, CountryId{"SO"}, Coordinate{45.3038, 2.01787}}, // Aden Adde International Airport
    Airport{IataCode{"MGR"}, CountryId{"US"}, Coordinate{-83.8033, 31.085}}, // Moultrie Municipal Airport
    Airport{IataCode{"MGS"}, CountryId{"NZ"}, Coordinate{-157.907, -21.8958}}, // Mangaia Airport
    Airport{IataCode{"MGT"}, CountryId{"AU"}, Coordinate{134.894, -12.0944}}, // Milingimbi Airport
    Airport{IataCode{"MGU"}, CountryId{"MM"}, Coordinate{93.6889, 18.8458}}, // Manaung Airport
    Airport{IataCode{"MGW"}, CountryId{"US"}, Coordinate{-79.92, 39.6438}}, // Morgantown Municipal Airport
    Airport{IataCode{"MGX"}, CountryId{"GA"}, Coordinate{11, -2.43333}}, // Moabi Airport
    Airport{IataCode{"MGY"}, CountryId{"US"}, Coordinate{-84.2284, 39.5913}}, // Dayton–Wright Brothers Airport
    Airport{IataCode{"MGZ"}, CountryId{"MM"}, Coordinate{98.6214, 12.4397}}, // Myeik Airport
    Airport{IataCode{"MHA"}, CountryId{"GY"}, Coordinate{-59.152, 5.27683}}, // Mahdia Airport
    Airport{IataCode{"MHC"}, CountryId{"CL"}, Coordinate{-73.7214, -42.3485}}, // Mocopulli Airport
    Airport{IataCode{"MHD"}, CountryId{"IR"}, Coordinate{59.6406, 36.2283}}, // Mashhad International Airport
    Airport{IataCode{"MHE"}, CountryId{"US"}, Coordinate{-98.0386, 43.7747}}, // Mitchell Municipal Airport
    Airport{IataCode{"MHH"}, CountryId{"BS"}, Coordinate{-77.0782, 26.5135}}, // Leonard M. Thompson International Airport
    Airport{IataCode{"MHI"}, CountryId{"DJ"}, Coordinate{43.2, 11.7167}}, // Moucha Airport
    Airport{IataCode{"MHK"}, CountryId{"US"}, Coordinate{-96.6701, 39.137}}, // Manhattan Regional Airport
    Airport{IataCode{"MHL"}, CountryId{"US"}, Coordinate{-93.1987, 39.098}}, // Marshall Memorial Municipal Airport
    Airport{IataCode{"MHQ"}, CountryId{"FI"}, Coordinate{19.9075, 60.1248}}, // Mariehamn Airport
    Airport{IataCode{"MHR"}, CountryId{"US"}, Coordinate{-121.297, 38.5644}}, // Sacramento Mather Airport
    Airport{IataCode{"MHS"}, CountryId{"US"}, Coordinate{-122.272, 41.2631}}, // Dunsmuir Municipal-Mott Airport
    Airport{IataCode{"MHT"}, CountryId{"US"}, Coordinate{-71.4385, 42.9277}}, // Manchester–Boston Regional Airport
    Airport{IataCode{"MHU"}, CountryId{"AU"}, Coordinate{147.338, -37.0517}}, // Mount Hotham Airport
    Airport{IataCode{"MHW"}, CountryId{"BO"}, Coordinate{-63.9624, -19.8238}}, // Monteagudo Airport
    Airport{IataCode{"MHX"}, CountryId{"NZ"}, Coordinate{-161, -10.3806}}, // Manihiki Island Airport
    Airport{IataCode{"MHY"}, CountryId{"PG"}, Coordinate{141.4, -9}}, // Morehead
    Airport{IataCode{"MIA"}, CountryId{"US"}, Coordinate{-80.277, 25.7951}}, // Miami International Airport
    Airport{IataCode{"MIC"}, CountryId{"US"}, Coordinate{-93.3539, 45.0619}}, // Crystal Airport
    Airport{IataCode{"MID"}, CountryId{"MX"}, Coordinate{-89.6627, 20.9339}}, // Manuel Crescencio Rejón International Airport
    Airport{IataCode{"MIE"}, CountryId{"US"}, Coordinate{-85.3912, 40.2402}}, // Delaware County Airport
    Airport{IataCode{"MIG"}, CountryId{"CN"}, Coordinate{104.747, 31.4276}}, // Mianyang Nanjiao Airport
    Airport{IataCode{"MII"}, CountryId{"BR"}, Coordinate{-49.9269, -22.1956}}, // Marília Airport
    Airport{IataCode{"MIJ"}, CountryId{"MH"}, Coordinate{171.731, 6.085}}, // Mili Airport
    Airport{IataCode{"MIK"}, CountryId{"FI"}, Coordinate{27.2068, 61.6876}}, // Mikkeli Airport
    Airport{IataCode{"MIM"}, CountryId{"AU"}, Coordinate{149.902, -36.9096}}, // Merimbula Airport
    Airport{IataCode{"MIO"}, CountryId{"US"}, Coordinate{-94.8898, 36.9077}}, // Miami Municipal Airport
    Airport{IataCode{"MIP"}, CountryId{"IL"}, Coordinate{34.8067, 30.6522}}, // Mitzpe Ramon Airfield
    Airport{IataCode{"MIQ"}, CountryId{"US"}, Coordinate{-96.1122, 41.1961}}, // Millard Airport
    Airport{IataCode{"MIR"}, CountryId{"TN"}, Coordinate{10.7518, 35.7604}}, // Monastir Habib Bourguiba International Airport
    Airport{IataCode{"MIS"}, CountryId{"PG"}, Coordinate{152.835, -10.6899}}, // Misima Airport
    Airport{IataCode{"MIT"}, CountryId{"US"}, Coordinate{-119.192, 35.5058}}, // Shafter Airport
    Airport{IataCode{"MIU"}, CountryId{"NG"}, Coordinate{13.0851, 11.8534}}, // Maiduguri International Airport
    Airport{IataCode{"MIV"}, CountryId{"US"}, Coordinate{-75.0722, 39.3678}}, // Millville Municipal Airport
    Airport{IataCode{"MJA"}, CountryId{"MG"}, Coordinate{44.3158, -21.4264}}, // Manja Airport
    Airport{IataCode{"MJB"}, CountryId{"MH"}, Coordinate{170.869, 10.2833}}, // Mejit Airport
    Airport{IataCode{"MJC"}, CountryId{"CI"}, Coordinate{-7.59044, 7.27166}}, // Man Airport
    Airport{IataCode{"MJD"}, CountryId{"PK"}, Coordinate{68.1431, 27.3353}}, // Moenjodaro Airport
    Airport{IataCode{"MJE"}, CountryId{"MH"}, Coordinate{168.264, 7.76222}}, // Majkin Airport
    Airport{IataCode{"MJF"}, CountryId{"NO"}, Coordinate{13.2169, 65.7845}}, // Mosjøen Airport
    Airport{IataCode{"MJI"}, CountryId{"LY"}, Coordinate{13.2812, 32.9}}, // Mitiga International Airport
    Airport{IataCode{"MJJ"}, CountryId{"PG"}, Coordinate{145.25, -5.7}}, // Moki
    Airport{IataCode{"MJK"}, CountryId{"AU"}, Coordinate{113.577, -25.8933}}, // Shark Bay Airport
    Airport{IataCode{"MJL"}, CountryId{"GA"}, Coordinate{11.0542, -1.84664}}, // Mouila Airport
    Airport{IataCode{"MJM"}, CountryId{"CD"}, Coordinate{23.5721, -6.12492}}, // Mbuji Mayi Airport
    Airport{IataCode{"MJN"}, CountryId{"MG"}, Coordinate{46.349, -15.6694}}, // Amborovy Airport
    Airport{IataCode{"MJO"}, CountryId{"NA"}, Coordinate{16.4528, -21.0231}}, // Mount Etjo Airport
    Airport{IataCode{"MJP"}, CountryId{"AU"}, Coordinate{116.14, -34.2653}}, // Manjimup Airport
    Airport{IataCode{"MJQ"}, CountryId{"US"}, Coordinate{-94.9867, 43.65}}, // Jackson Municipal Airport
    Airport{IataCode{"MJR"}, CountryId{"AR"}, Coordinate{-57.8708, -38.2261}}, // Miramar Airport
    Airport{IataCode{"MJT"}, CountryId{"GR"}, Coordinate{26.5979, 39.0567}}, // Mytilene International Airport
    Airport{IataCode{"MJU"}, CountryId{"ID"}, Coordinate{119.03, -2.58673}}, // Tampa Padang Airport
    Airport{IataCode{"MJV"}, CountryId{"ES"}, Coordinate{-0.818252, 37.7753}}, // Murcia-San Javier Airport
    Airport{IataCode{"MJX"}, CountryId{"US"}, Coordinate{-74.2925, 39.9275}}, // Robert J. Miller Air Park
    Airport{IataCode{"MJZ"}, CountryId{"RU"}, Coordinate{114.021, 62.5313}}, // Mirny Airport
    Airport{IataCode{"MKA"}, CountryId{"CZ"}, Coordinate{12.7166, 49.9275}}, // Marianske Lazne Airport
    Airport{IataCode{"MKB"}, CountryId{"GA"}, Coordinate{13.9686, 0.9766}}, // Mekambo Airport
    Airport{IataCode{"MKC"}, CountryId{"US"}, Coordinate{-94.5928, 39.1233}}, // Charles B. Wheeler Downtown Airport
    Airport{IataCode{"MKE"}, CountryId{"US"}, Coordinate{-87.9042, 42.9507}}, // Milwaukee Mitchell International Airport
    Airport{IataCode{"MKG"}, CountryId{"US"}, Coordinate{-86.2356, 43.1678}}, // Muskegon County Airport
    Airport{IataCode{"MKH"}, CountryId{"LS"}, Coordinate{29.0722, -29.2817}}, // Mokhotlong Airport
    Airport{IataCode{"MKI"}, CountryId{"CF"}, Coordinate{25.9294, 5.33306}}, // M'Boki Airport
    Airport{IataCode{"MKJ"}, CountryId{"CG"}, Coordinate{15.5821, -0.019055}}, // Makoua Airport
    Airport{IataCode{"MKK"}, CountryId{"US"}, Coordinate{-157.096, 21.1528}}, // Molokai Airport
    Airport{IataCode{"MKL"}, CountryId{"US"}, Coordinate{-88.9156, 35.5997}}, // McKellar-Sipes Regional Airport
    Airport{IataCode{"MKM"}, CountryId{"MY"}, Coordinate{112.064, 2.89985}}, // Mukah Airport
    Airport{IataCode{"MKN"}, CountryId{"US"}, Coordinate{-98.5992, 31.9203}}, // Comanche County-City Airport
    Airport{IataCode{"MKO"}, CountryId{"US"}, Coordinate{-95.3617, 35.6578}}, // Davis Field
    Airport{IataCode{"MKP"}, CountryId{"FR"}, Coordinate{-143.655, -16.588}}, // Makemo Airport
    Airport{IataCode{"MKQ"}, CountryId{"ID"}, Coordinate{140.418, -8.52028}}, // Mopah Airport
    Airport{IataCode{"MKR"}, CountryId{"AU"}, Coordinate{118.548, -26.6117}}, // Meekatharra Airport
    Airport{IataCode{"MKS"}, CountryId{"ET"}, Coordinate{38.7414, 10.7244}}, // Mekane Selam Airport
    Airport{IataCode{"MKT"}, CountryId{"US"}, Coordinate{-93.9214, 44.2215}}, // Mankato Regional Airport
    Airport{IataCode{"MKU"}, CountryId{"GA"}, Coordinate{12.8893, 0.580732}}, // Makokou Airport
    Airport{IataCode{"MKW"}, CountryId{"ID"}, Coordinate{134.05, -0.893623}}, // Rendani Airport
    Airport{IataCode{"MKY"}, CountryId{"AU"}, Coordinate{149.18, -21.1717}}, // Mackay Airport
    Airport{IataCode{"MKZ"}, CountryId{"MY"}, Coordinate{102.251, 2.25562}}, // Melaka International Airport
    Airport{IataCode{"MLA"}, CountryId{"MT"}, Coordinate{14.4902, 35.852}}, // Malta International Airport
    Airport{IataCode{"MLB"}, CountryId{"US"}, Coordinate{-80.6312, 28.0982}}, // Melbourne International Airport
    Airport{IataCode{"MLC"}, CountryId{"US"}, Coordinate{-95.7833, 34.8825}}, // McAlester Regional Airport
    Airport{IataCode{"MLE"}, CountryId{"MV"}, Coordinate{73.527, 4.18908}}, // Velana International Airport
    Airport{IataCode{"MLG"}, CountryId{"ID"}, Coordinate{112.712, -7.9375}}, // Abdul Rachman Saleh Airport
    Airport{IataCode{"MLH"}, CountryId{"FR"}, Coordinate{7.53004, 47.5989}}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"MLI"}, CountryId{"US"}, Coordinate{-90.5067, 41.4535}}, // Quad City International Airport
    Airport{IataCode{"MLJ"}, CountryId{"US"}, Coordinate{-83.2414, 33.1542}}, // Baldwin County Airport
    Airport{IataCode{"MLL"}, CountryId{"US"}, Coordinate{-162.026, 61.8642}}, // Marshall Don Hunter Sr. Airport
    Airport{IataCode{"MLM"}, CountryId{"MX"}, Coordinate{-101.027, 19.8438}}, // General Francisco J. Mujica International Airport
    Airport{IataCode{"MLN"}, CountryId{"ES"}, Coordinate{-2.95717, 35.277}}, // Melilla Airport
    Airport{IataCode{"MLO"}, CountryId{"GR"}, Coordinate{24.4698, 36.6979}}, // Milos Island National Airport
    Airport{IataCode{"MLP"}, CountryId{"PH"}, Coordinate{124.056, 7.61667}}, // Malabang Airport
    Airport{IataCode{"MLS"}, CountryId{"US"}, Coordinate{-105.886, 46.4281}}, // Miles City Airport
    Airport{IataCode{"MLT"}, CountryId{"US"}, Coordinate{-68.6856, 45.6478}}, // Millinocket Municipal Airport
    Airport{IataCode{"MLU"}, CountryId{"US"}, Coordinate{-92.0377, 32.5109}}, // Monroe Regional Airport
    Airport{IataCode{"MLW"}, CountryId{"LR"}, Coordinate{-10.7586, 6.28917}}, // Spriggs Payne Airport
    Airport{IataCode{"MLY"}, CountryId{"US"}, Coordinate{-150.644, 64.9975}}, // Manley Hot Springs Airport
    Airport{IataCode{"MLZ"}, CountryId{"UY"}, Coordinate{-54.2217, -32.3425}}, // Cerro Largo International Airport
    Airport{IataCode{"MMB"}, CountryId{"JP"}, Coordinate{144.159, 43.8814}}, // Memanbetsu Airport
    Airport{IataCode{"MMC"}, CountryId{"MX"}, Coordinate{-99.0165, 22.7476}}, // Ciudad Mante National Airport
    Airport{IataCode{"MMD"}, CountryId{"JP"}, Coordinate{131.264, 25.8467}}, // Minami-Daito Airport
    Airport{IataCode{"MME"}, CountryId{"GB"}, Coordinate{-1.43351, 54.5118}}, // Durham Tees Valley Airport
    Airport{IataCode{"MMF"}, CountryId{"CM"}, Coordinate{9.30361, 5.70417}}, // Mamfe Airport
    Airport{IataCode{"MMG"}, CountryId{"AU"}, Coordinate{117.842, -28.1161}}, // Mount Magnet Airport
    Airport{IataCode{"MMH"}, CountryId{"US"}, Coordinate{-118.841, 37.6271}}, // Mammoth Yosemite Airport
    Airport{IataCode{"MMI"}, CountryId{"US"}, Coordinate{-84.5625, 35.3972}}, // McMinn County Airport
    Airport{IataCode{"MMJ"}, CountryId{"JP"}, Coordinate{137.926, 36.1647}}, // Matsumoto Airport
    Airport{IataCode{"MMK"}, CountryId{"RU"}, Coordinate{32.7585, 68.7847}}, // Murmansk Airport
    Airport{IataCode{"MML"}, CountryId{"US"}, Coordinate{-95.8205, 44.445}}, // Southwest Minnesota Regional Airport
    Airport{IataCode{"MMM"}, CountryId{"AU"}, Coordinate{148.705, -22.8033}}, // Middlemount Airport
    Airport{IataCode{"MMN"}, CountryId{"US"}, Coordinate{-71.5178, 42.4606}}, // Minute Man Air Field
    Airport{IataCode{"MMO"}, CountryId{"CV"}, Coordinate{-23.2151, 15.158}}, // Maio Airport
    Airport{IataCode{"MMQ"}, CountryId{"ZM"}, Coordinate{31.3333, -8.85917}}, // Mbala Airport
    Airport{IataCode{"MMT"}, CountryId{"US"}, Coordinate{-80.8011, 33.9208}}, // McEntire Joint National Guard Base
    Airport{IataCode{"MMU"}, CountryId{"US"}, Coordinate{-74.4213, 40.7957}}, // Morristown Municipal Airport
    Airport{IataCode{"MMV"}, CountryId{"US"}, Coordinate{-123.136, 45.1944}}, // McMinnville Municipal Airport
    Airport{IataCode{"MMX"}, CountryId{"SE"}, Coordinate{13.3669, 55.5403}}, // Malmö Airport
    Airport{IataCode{"MMY"}, CountryId{"JP"}, Coordinate{125.295, 24.7828}}, // Miyako Airport
    Airport{IataCode{"MMZ"}, CountryId{"AF"}, Coordinate{64.75, 35.933}}, // Maymana Airport
    Airport{IataCode{"MNA"}, CountryId{"ID"}, Coordinate{126.673, 4.00694}}, // Melonguane Airport
    Airport{IataCode{"MNB"}, CountryId{"CD"}, Coordinate{12.35, -5.93333}}, // Muanda Airport
    Airport{IataCode{"MNC"}, CountryId{"MZ"}, Coordinate{40.7062, -14.4934}}, // Nacala Airport
    Airport{IataCode{"MNF"}, CountryId{"FJ"}, Coordinate{177.098, -17.6731}}, // Mana Island Airport
    Airport{IataCode{"MNG"}, CountryId{"AU"}, Coordinate{134.234, -12.0561}}, // Maningrida Airport
    Airport{IataCode{"MNH"}, CountryId{"OM"}, Coordinate{57.482, 23.6389}}, // Rustaq Airport
    Airport{IataCode{"MNI"}, CountryId{"GB"}, Coordinate{-62.1938, 16.7927}}, // John A. Osborne Airport
    Airport{IataCode{"MNJ"}, CountryId{"MG"}, Coordinate{48.3556, -21.2068}}, // Mananjary Airport
    Airport{IataCode{"MNK"}, CountryId{"KI"}, Coordinate{173.031, 1.00359}}, // Maiana Airport
    Airport{IataCode{"MNL"}, CountryId{"PH"}, Coordinate{121.009, 14.5146}}, // Ninoy Aquino International Airport
    Airport{IataCode{"MNM"}, CountryId{"US"}, Coordinate{-87.6383, 45.1267}}, // Menominee-Marinette Twin County Airport
    Airport{IataCode{"MNN"}, CountryId{"US"}, Coordinate{-83.0685, 40.6166}}, // Marion Municipal Airport
    Airport{IataCode{"MNQ"}, CountryId{"AU"}, Coordinate{151.1, -24.8867}}, // Monto Airport
    Airport{IataCode{"MNR"}, CountryId{"ZM"}, Coordinate{23.1528, -15.2544}}, // Mongu Airport
    Airport{IataCode{"MNS"}, CountryId{"ZM"}, Coordinate{28.857, -11.1386}}, // Mansa Airport
    Airport{IataCode{"MNT"}, CountryId{"US"}, Coordinate{-149.369, 65.1481}}, // Minto Al Wright Airport
    Airport{IataCode{"MNU"}, CountryId{"MM"}, Coordinate{97.6574, 16.442}}, // Mawlamyaing Airport
    Airport{IataCode{"MNX"}, CountryId{"BR"}, Coordinate{-61.2839, -5.81694}}, // Manicoré Airport
    Airport{IataCode{"MNY"}, CountryId{"SB"}, Coordinate{155.565, -7.41611}}, // Mono Airport
    Airport{IataCode{"MNZ"}, CountryId{"US"}, Coordinate{-77.5156, 38.7214}}, // Manassas Regional Airport
    Airport{IataCode{"MOA"}, CountryId{"CU"}, Coordinate{-74.9295, 20.6485}}, // Orestes Acosta Airport
    Airport{IataCode{"MOB"}, CountryId{"US"}, Coordinate{-88.2465, 30.6819}}, // Mobile Regional Airport
    Airport{IataCode{"MOC"}, CountryId{"BR"}, Coordinate{-43.8219, -16.7061}}, // Montes Claros Airport
    Airport{IataCode{"MOD"}, CountryId{"US"}, Coordinate{-120.954, 37.6258}}, // Modesto City-County Airport
    Airport{IataCode{"MOE"}, CountryId{"MM"}, Coordinate{96.6453, 23.0919}}, // Momeik Airport
    Airport{IataCode{"MOF"}, CountryId{"ID"}, Coordinate{120.833, -8.64056}}, // Frans Seda Airport
    Airport{IataCode{"MOG"}, CountryId{"MM"}, Coordinate{99.2567, 20.5167}}, // Monghsat Airport
    Airport{IataCode{"MOI"}, CountryId{"NZ"}, Coordinate{-157.703, -19.8427}}, // Mitiaro Airport
    Airport{IataCode{"MOJ"}, CountryId{"SR"}, Coordinate{-54.4003, 5.6076}}, // Moengo Airstrip
    Airport{IataCode{"MOL"}, CountryId{"NO"}, Coordinate{7.26114, 62.7465}}, // Molde Airport
    Airport{IataCode{"MOM"}, CountryId{"MR"}, Coordinate{-12.5, 17.75}}, // Letfotar Airport
    Airport{IataCode{"MON"}, CountryId{"NZ"}, Coordinate{170.128, -43.9067}}, // Glentanner Aerodrome
    Airport{IataCode{"MOO"}, CountryId{"AU"}, Coordinate{140.198, -28.1015}}, // Moomba Airport
    Airport{IataCode{"MOP"}, CountryId{"US"}, Coordinate{-84.7375, 43.6217}}, // Mount Pleasant Municipal Airport
    Airport{IataCode{"MOQ"}, CountryId{"MG"}, Coordinate{44.3174, -20.2848}}, // Morondava Airport
    Airport{IataCode{"MOR"}, CountryId{"US"}, Coordinate{-83.3756, 36.1794}}, // Morristown Regional Airport
    Airport{IataCode{"MOS"}, CountryId{"US"}, Coordinate{-162.057, 64.6981}}, // Moses Point Airport
    Airport{IataCode{"MOT"}, CountryId{"US"}, Coordinate{-101.291, 48.2588}}, // Minot International Airport
    Airport{IataCode{"MOU"}, CountryId{"US"}, Coordinate{-163.682, 62.0953}}, // Mountain Village Airport
    Airport{IataCode{"MOV"}, CountryId{"AU"}, Coordinate{148.074, -22.0597}}, // Moranbah Airport
    Airport{IataCode{"MOZ"}, CountryId{"FR"}, Coordinate{-149.763, -17.4905}}, // Moorea Airport
    Airport{IataCode{"MPA"}, CountryId{"NA"}, Coordinate{24.1772, -17.6311}}, // Katima Mulilo Airport
    Airport{IataCode{"MPC"}, CountryId{"ID"}, Coordinate{101.091, -2.54328}}, // Mukomuko Airport
    Airport{IataCode{"MPD"}, CountryId{"PK"}, Coordinate{69.0333, 25.6836}}, // Sindhri Airport
    Airport{IataCode{"MPF"}, CountryId{"PG"}, Coordinate{147.717, -6.53333}}, // Mapoda
    Airport{IataCode{"MPG"}, CountryId{"PG"}, Coordinate{147.717, -6.53333}}, // Makini
    Airport{IataCode{"MPH"}, CountryId{"PH"}, Coordinate{121.953, 11.9252}}, // Godofredo P. Ramos Airport
    Airport{IataCode{"MPJ"}, CountryId{"US"}, Coordinate{-92.9092, 35.1389}}, // Petit Jean Park Airport
    Airport{IataCode{"MPK"}, CountryId{"KR"}, Coordinate{126.38, 34.7589}}, // Mokpo Airport
    Airport{IataCode{"MPL"}, CountryId{"FR"}, Coordinate{3.95914, 43.5788}}, // Montpellier – Méditerranée Airport
    Airport{IataCode{"MPM"}, CountryId{"MZ"}, Coordinate{32.5749, -25.9242}}, // Maputo International Airport
    Airport{IataCode{"MPO"}, CountryId{"US"}, Coordinate{-75.3749, 41.1382}}, // Pocono Mountains Municipal Airport
    Airport{IataCode{"MPP"}, CountryId{"PA"}, Coordinate{-77.7331, 8.94528}}, // Mulatupo Airport
    Airport{IataCode{"MPQ"}, CountryId{"JO"}, Coordinate{35.7925, 30.1728}}, // Ma'an
    Airport{IataCode{"MPS"}, CountryId{"US"}, Coordinate{-94.9617, 33.0969}}, // Mount Pleasant Regional Airport
    Airport{IataCode{"MPV"}, CountryId{"US"}, Coordinate{-72.5619, 44.2014}}, // Edward F. Knapp State Airport
    Airport{IataCode{"MPW"}, CountryId{"UA"}, Coordinate{37.4591, 47.0783}}, // Mariupol International Airport
    Airport{IataCode{"MPX"}, CountryId{"PG"}, Coordinate{141.617, -4.9}}, // Miyanmin
    Airport{IataCode{"MPY"}, CountryId{"FR"}, Coordinate{-54.0365, 3.65627}}, // Maripasoula Airport
    Airport{IataCode{"MPZ"}, CountryId{"US"}, Coordinate{-91.5111, 40.9467}}, // Mount Pleasant Municipal Airport
    Airport{IataCode{"MQB"}, CountryId{"US"}, Coordinate{-90.6525, 40.52}}, // Macomb Municipal Airport
    Airport{IataCode{"MQC"}, CountryId{"FR"}, Coordinate{-56.3842, 47.0973}}, // Miquelon Airport
    Airport{IataCode{"MQD"}, CountryId{"AR"}, Coordinate{-68.7333, -41.25}}, // Maquinchao Airport
    Airport{IataCode{"MQF"}, CountryId{"RU"}, Coordinate{58.7614, 53.391}}, // Magnitogorsk International Airport
    Airport{IataCode{"MQJ"}, CountryId{"RU"}, Coordinate{143.252, 66.4519}}, // Moma Airport
    Airport{IataCode{"MQK"}, CountryId{"BO"}, Coordinate{-58.4015, -16.3379}}, // San Matías Airport
    Airport{IataCode{"MQL"}, CountryId{"AU"}, Coordinate{142.085, -34.2307}}, // Mildura Airport
    Airport{IataCode{"MQM"}, CountryId{"TR"}, Coordinate{40.637, 37.2345}}, // Mardin Airport
    Airport{IataCode{"MQN"}, CountryId{"NO"}, Coordinate{14.3024, 66.3649}}, // Mo i Rana Airport
    Airport{IataCode{"MQP"}, CountryId{"ZA"}, Coordinate{31.0987, -25.3851}}, // Kruger Mpumalanga International Airport
    Airport{IataCode{"MQQ"}, CountryId{"TD"}, Coordinate{16.0711, 8.61843}}, // Moundou Airport
    Airport{IataCode{"MQS"}, CountryId{"VC"}, Coordinate{-61.1803, 12.8881}}, // Mustique Airport
    Airport{IataCode{"MQT"}, CountryId{"US"}, Coordinate{-87.3882, 46.3446}}, // Sawyer International Airport
    Airport{IataCode{"MQU"}, CountryId{"CO"}, Coordinate{-74.8836, 5.2125}}, // Mariquita Airport
    Airport{IataCode{"MQV"}, CountryId{"DZ"}, Coordinate{0.148997, 35.9089}}, // Mostaganem Airport
    Airport{IataCode{"MQW"}, CountryId{"US"}, Coordinate{-82.8827, 32.0935}}, // Telfair-Wheeler Airport
    Airport{IataCode{"MQX"}, CountryId{"ET"}, Coordinate{39.5305, 13.4733}}, // Alula Aba Nega Airport
    Airport{IataCode{"MQY"}, CountryId{"US"}, Coordinate{-86.52, 36.0089}}, // Smyrna Airport
    Airport{IataCode{"MQZ"}, CountryId{"AU"}, Coordinate{115.099, -33.9304}}, // Margaret River Airport
    Airport{IataCode{"MRA"}, CountryId{"LY"}, Coordinate{15.0498, 32.3318}}, // Misrata Airport
    Airport{IataCode{"MRB"}, CountryId{"US"}, Coordinate{-77.9847, 39.4019}}, // Eastern WV Regional Airport
    Airport{IataCode{"MRC"}, CountryId{"US"}, Coordinate{-87.1792, 35.5544}}, // Maury County Airport
    Airport{IataCode{"MRD"}, CountryId{"VE"}, Coordinate{-71.1611, 8.58222}}, // Alberto Carnevalli Airport
    Airport{IataCode{"MRE"}, CountryId{"KE"}, Coordinate{35.0081, -1.40611}}, // Mara Serena Airport
    Airport{IataCode{"MRG"}, CountryId{"AU"}, Coordinate{145.419, -17.0692}}, // Mareeba Airfield
    Airport{IataCode{"MRI"}, CountryId{"US"}, Coordinate{-149.844, 61.2136}}, // Merrill Field
    Airport{IataCode{"MRJ"}, CountryId{"HN"}, Coordinate{-88.0333, 14.15}}, // Marcala Airport
    Airport{IataCode{"MRK"}, CountryId{"US"}, Coordinate{-81.6725, 25.995}}, // Marco Island Airport
    Airport{IataCode{"MRM"}, CountryId{"PG"}, Coordinate{147.6, -9.2}}, // Manare
    Airport{IataCode{"MRN"}, CountryId{"US"}, Coordinate{-81.6114, 35.8203}}, // Foothills Regional Airport
    Airport{IataCode{"MRO"}, CountryId{"NZ"}, Coordinate{175.64, -40.972}}, // Hood Aerodrome
    Airport{IataCode{"MRQ"}, CountryId{"PH"}, Coordinate{121.825, 13.36}}, // Marinduque Airport
    Airport{IataCode{"MRR"}, CountryId{"EC"}, Coordinate{-79.942, -4.37925}}, // José María Velasco Ibarra Airport
    Airport{IataCode{"MRS"}, CountryId{"FR"}, Coordinate{5.2187, 43.442}}, // Marseille Provence Airport
    Airport{IataCode{"MRT"}, CountryId{"AU"}, Coordinate{133.7, -14.82}}, // Moroak Airport
    Airport{IataCode{"MRU"}, CountryId{"MU"}, Coordinate{57.6786, -20.4332}}, // Sir Seewoosagur Ramgoolam International Airport
    Airport{IataCode{"MRV"}, CountryId{"RU"}, Coordinate{43.0879, 44.2178}}, // Mineralnye Vody Airport
    Airport{IataCode{"MRW"}, CountryId{"DK"}, Coordinate{11.44, 54.6994}}, // Lolland Falster Airport
    Airport{IataCode{"MRX"}, CountryId{"IR"}, Coordinate{49.1531, 30.5497}}, // Mahshahr Airport
    Airport{IataCode{"MRY"}, CountryId{"US"}, Coordinate{-121.85, 36.5873}}, // Monterey Regional Airport
    Airport{IataCode{"MRZ"}, CountryId{"AU"}, Coordinate{149.85, -29.4964}}, // Moree Airport
    Airport{IataCode{"MSA"}, CountryId{"CA"}, Coordinate{-91.7628, 53.4414}}, // Muskrat Dam Airport
    Airport{IataCode{"MSC"}, CountryId{"US"}, Coordinate{-111.727, 33.4574}}, // Falcon Field
    Airport{IataCode{"MSF"}, CountryId{"AU"}, Coordinate{134.917, -22.6667}}, // Mount Swan Airport
    Airport{IataCode{"MSG"}, CountryId{"LS"}, Coordinate{28.8092, -29.8136}}, // Matsaile Airport
    Airport{IataCode{"MSJ"}, CountryId{"JP"}, Coordinate{141.388, 40.6965}}, // Misawa Airport
    Airport{IataCode{"MSL"}, CountryId{"US"}, Coordinate{-87.6191, 34.7455}}, // Northwest Alabama Regional Airport
    Airport{IataCode{"MSM"}, CountryId{"CD"}, Coordinate{17.85, -4.78333}}, // Masi-Manimba Airport
    Airport{IataCode{"MSN"}, CountryId{"US"}, Coordinate{-89.3456, 43.136}}, // Dane County Regional Airport
    Airport{IataCode{"MSO"}, CountryId{"US"}, Coordinate{-114.084, 46.9191}}, // Missoula International Airport
    Airport{IataCode{"MSP"}, CountryId{"US"}, Coordinate{-93.2217, 44.8819}}, // Minneapolis–Saint Paul International Airport
    Airport{IataCode{"MSQ"}, CountryId{"BY"}, Coordinate{28.0563, 53.8837}}, // Minsk National Airport
    Airport{IataCode{"MSS"}, CountryId{"US"}, Coordinate{-74.8456, 44.9358}}, // Massena International Airport
    Airport{IataCode{"MST"}, CountryId{"NL"}, Coordinate{5.76936, 50.9155}}, // Maastricht Aachen Airport
    Airport{IataCode{"MSU"}, CountryId{"LS"}, Coordinate{27.5591, -29.4554}}, // Moshoeshoe I International Airport
    Airport{IataCode{"MSV"}, CountryId{"US"}, Coordinate{-74.795, 41.7017}}, // Sullivan County International Airport
    Airport{IataCode{"MSW"}, CountryId{"ER"}, Coordinate{39.3675, 15.6757}}, // Massawa International Airport
    Airport{IataCode{"MSX"}, CountryId{"CG"}, Coordinate{12.7, -2.95}}, // Mossendjo Airport
    Airport{IataCode{"MSY"}, CountryId{"US"}, Coordinate{-90.2551, 29.9969}}, // Louis Armstrong New Orleans International Airport
    Airport{IataCode{"MSZ"}, CountryId{"AO"}, Coordinate{12.1519, -15.2567}}, // Welwitschia Mirabilis International Airport
    Airport{IataCode{"MTA"}, CountryId{"NZ"}, Coordinate{175.74, -37.7344}}, // Matamata Airport
    Airport{IataCode{"MTB"}, CountryId{"CO"}, Coordinate{-75.4413, 7.97333}}, // El Pindo Airport
    Airport{IataCode{"MTF"}, CountryId{"ET"}, Coordinate{35.5333, 6.96667}}, // Mizan Teferi Airport
    Airport{IataCode{"MTH"}, CountryId{"US"}, Coordinate{-81.0514, 24.7261}}, // Florida Keys Marathon Airport
    Airport{IataCode{"MTJ"}, CountryId{"US"}, Coordinate{-107.898, 38.4994}}, // Montrose Regional Airport
    Airport{IataCode{"MTK"}, CountryId{"KI"}, Coordinate{172.992, 3.37411}}, // Makin Airfield
    Airport{IataCode{"MTL"}, CountryId{"AU"}, Coordinate{151.488, -32.7033}}, // Maitland Airport
    Airport{IataCode{"MTN"}, CountryId{"US"}, Coordinate{-76.4139, 39.3256}}, // Martin State Airport
    Airport{IataCode{"MTO"}, CountryId{"US"}, Coordinate{-88.2831, 39.4825}}, // Coles County Memorial Airport
    Airport{IataCode{"MTP"}, CountryId{"US"}, Coordinate{-71.9206, 41.0767}}, // Montauk Airport
    Airport{IataCode{"MTQ"}, CountryId{"AU"}, Coordinate{147.937, -26.4833}}, // Mitchell Airport
    Airport{IataCode{"MTR"}, CountryId{"CO"}, Coordinate{-75.8242, 8.82511}}, // Los Garzones Airport
    Airport{IataCode{"MTS"}, CountryId{"SZ"}, Coordinate{31.3149, -26.5207}}, // Matsapha Airport
    Airport{IataCode{"MTT"}, CountryId{"MX"}, Coordinate{-94.5772, 18.1024}}, // Minatitlán/Coatzacoalcos National Airport
    Airport{IataCode{"MTV"}, CountryId{"VU"}, Coordinate{167.711, -13.6658}}, // Mota Lava Airport
    Airport{IataCode{"MTW"}, CountryId{"US"}, Coordinate{-87.6806, 44.1289}}, // Manitowoc County Airport
    Airport{IataCode{"MTY"}, CountryId{"MX"}, Coordinate{-100.115, 25.7771}}, // Monterrey International Airport
    Airport{IataCode{"MTZ"}, CountryId{"IL"}, Coordinate{35.3886, 31.3282}}, // Bar Yehuda Airfield
    Airport{IataCode{"MUA"}, CountryId{"SB"}, Coordinate{157.263, -8.32797}}, // Munda Airport
    Airport{IataCode{"MUB"}, CountryId{"BW"}, Coordinate{23.4281, -19.9757}}, // Maun Airport
    Airport{IataCode{"MUC"}, CountryId{"DE"}, Coordinate{11.7861, 48.3539}}, // Munich Airport
    Airport{IataCode{"MUD"}, CountryId{"MZ"}, Coordinate{39.5631, -11.6731}}, // Mueda Airport
    Airport{IataCode{"MUE"}, CountryId{"US"}, Coordinate{-155.674, 19.9986}}, // Waimea-Kohala Airport
    Airport{IataCode{"MUG"}, CountryId{"MX"}, Coordinate{-111.971, 26.9058}}, // Mulegé Airstrip
    Airport{IataCode{"MUH"}, CountryId{"EG"}, Coordinate{27.2165, 31.3384}}, // Marsa Matruh International Airport
    Airport{IataCode{"MUJ"}, CountryId{"ET"}, Coordinate{35.7486, 5.86389}}, // Mui Airport
    Airport{IataCode{"MUK"}, CountryId{"NZ"}, Coordinate{-157.344, -20.1375}}, // Mauke Airport
    Airport{IataCode{"MUL"}, CountryId{"US"}, Coordinate{-83.7042, 31.1378}}, // Spence Airport
    Airport{IataCode{"MUN"}, CountryId{"VE"}, Coordinate{-63.1566, 9.74926}}, // José Tadeo Monagas International Airport
    Airport{IataCode{"MUR"}, CountryId{"MY"}, Coordinate{114.322, 4.1775}}, // Marudi Airport
    Airport{IataCode{"MUS"}, CountryId{"JP"}, Coordinate{153.979, 24.2897}}, // Minami Torishima Airport
    Airport{IataCode{"MUT"}, CountryId{"US"}, Coordinate{-91.1483, 41.3678}}, // Muscatine Municipal Airport
    Airport{IataCode{"MUW"}, CountryId{"DZ"}, Coordinate{0.153725, 35.2062}}, // Ghriss Airport
    Airport{IataCode{"MUX"}, CountryId{"PK"}, Coordinate{71.4245, 30.1952}}, // Multan International Airport
    Airport{IataCode{"MUY"}, CountryId{"CG"}, Coordinate{13.9664, -4.01472}}, // Mouyondzi Airport
    Airport{IataCode{"MUZ"}, CountryId{"TZ"}, Coordinate{33.8028, -1.49702}}, // Musoma Airport
    Airport{IataCode{"MVA"}, CountryId{"IS"}, Coordinate{-16.9181, 65.6558}}, // Mývatn Airport
    Airport{IataCode{"MVB"}, CountryId{"GA"}, Coordinate{13.4312, -1.65386}}, // M'Vengue El Hadj Omar Bongo Ondimba International Airport
    Airport{IataCode{"MVC"}, CountryId{"US"}, Coordinate{-87.3511, 31.4581}}, // Monroe County Airport
    Airport{IataCode{"MVD"}, CountryId{"UY"}, Coordinate{-56.0164, -34.837}}, // Carrasco International Airport
    Airport{IataCode{"MVE"}, CountryId{"US"}, Coordinate{-95.712, 44.9714}}, // Montevideo–Chippewa County Airport
    Airport{IataCode{"MVI"}, CountryId{"PG"}, Coordinate{155.3, -6}}, // Manetai Airport
    Airport{IataCode{"MVJ"}, CountryId{"JM"}, Coordinate{-77.4856, 18.0233}}, // Marlboro Airport
    Airport{IataCode{"MVL"}, CountryId{"US"}, Coordinate{-72.6157, 44.5368}}, // Morrisville-Stowe State Airport
    Airport{IataCode{"MVM"}, CountryId{"US"}, Coordinate{-110.228, 36.7164}}, // Kayenta Airport
    Airport{IataCode{"MVN"}, CountryId{"US"}, Coordinate{-88.8547, 38.3219}}, // Mount Vernon Airport
    Airport{IataCode{"MVO"}, CountryId{"TD"}, Coordinate{18.6775, 12.1719}}, // Mongo Airport
    Airport{IataCode{"MVP"}, CountryId{"CO"}, Coordinate{-70.232, 1.25678}}, // Fabio Alberto León Bentley Airport
    Airport{IataCode{"MVQ"}, CountryId{"BY"}, Coordinate{30.095, 53.955}}, // Mogilev Airport
    Airport{IataCode{"MVR"}, CountryId{"CM"}, Coordinate{14.2531, 10.4514}}, // Salak Airport
    Airport{IataCode{"MVS"}, CountryId{"BR"}, Coordinate{-39.8642, -18.0494}}, // Mucuri Airport
    Airport{IataCode{"MVV"}, CountryId{"FR"}, Coordinate{6.64999, 45.8223}}, // Megève Aerodrome
    Airport{IataCode{"MVW"}, CountryId{"US"}, Coordinate{-122.421, 48.4708}}, // Skagit Regional Airport
    Airport{IataCode{"MVX"}, CountryId{"GA"}, Coordinate{12.1167, 2.15}}, // Minvoul Airport
    Airport{IataCode{"MVY"}, CountryId{"US"}, Coordinate{-70.6121, 41.3895}}, // Martha's Vineyard Airport
    Airport{IataCode{"MVZ"}, CountryId{"ZW"}, Coordinate{30.8589, -20.0553}}, // Masvingo Airport
    Airport{IataCode{"MWA"}, CountryId{"US"}, Coordinate{-89.0111, 37.755}}, // Veterans Airport of Southern Illinois
    Airport{IataCode{"MWB"}, CountryId{"AU"}, Coordinate{116.022, -29.2014}}, // Morawa Airport
    Airport{IataCode{"MWC"}, CountryId{"US"}, Coordinate{-88.0344, 43.1103}}, // Lawrence J. Timmerman Airport
    Airport{IataCode{"MWE"}, CountryId{"SD"}, Coordinate{31.833, 18.45}}, // Merowe Airport
    Airport{IataCode{"MWF"}, CountryId{"VU"}, Coordinate{168.079, -14.9944}}, // Maewo-Naone Airport
    Airport{IataCode{"MWG"}, CountryId{"PG"}, Coordinate{145.9, -6.967}}, // Marawaka
    Airport{IataCode{"MWH"}, CountryId{"US"}, Coordinate{-119.323, 47.19}}, // Grant County International Airport
    Airport{IataCode{"MWI"}, CountryId{"PG"}, Coordinate{143.485, -5.1283}}, // Maramuni Airport
    Airport{IataCode{"MWJ"}, CountryId{"GY"}, Coordinate{-60.1833, 7.48333}}, // Matthews Ridge
    Airport{IataCode{"MWK"}, CountryId{"ID"}, Coordinate{106.258, 3.34812}}, // Matak Airport
    Airport{IataCode{"MWL"}, CountryId{"US"}, Coordinate{-98.0603, 32.7817}}, // Mineral Wells Airport
    Airport{IataCode{"MWN"}, CountryId{"TZ"}, Coordinate{33.6167, -3.5}}, // Mwadui Airport
    Airport{IataCode{"MWO"}, CountryId{"US"}, Coordinate{-84.3964, 39.5317}}, // Middletown Regional Airport
    Airport{IataCode{"MWQ"}, CountryId{"MM"}, Coordinate{94.9729, 20.1579}}, // Magway Airport
    Airport{IataCode{"MWV"}, CountryId{"KH"}, Coordinate{107.187, 12.4606}}, // Mondulkiri Airport
    Airport{IataCode{"MWX"}, CountryId{"KR"}, Coordinate{126.388, 34.9937}}, // Muan International Airport
    Airport{IataCode{"MWZ"}, CountryId{"TZ"}, Coordinate{32.9231, -2.44103}}, // Mwanza Airport
    Airport{IataCode{"MXA"}, CountryId{"US"}, Coordinate{-90.1565, 35.8899}}, // Manila Municipal Airport
    Airport{IataCode{"MXB"}, CountryId{"ID"}, Coordinate{120.331, -2.55972}}, // Andi Jemma Airport
    Airport{IataCode{"MXC"}, CountryId{"US"}, Coordinate{-109.341, 37.9325}}, // Monticello Airport
    Airport{IataCode{"MXE"}, CountryId{"US"}, Coordinate{-79.3658, 34.7919}}, // Laurinburg-Maxton Airport
    Airport{IataCode{"MXG"}, CountryId{"US"}, Coordinate{-71.509, 42.3432}}, // Marlboro Airport
    Airport{IataCode{"MXH"}, CountryId{"PG"}, Coordinate{143.238, -6.36333}}, // Moro Airport
    Airport{IataCode{"MXI"}, CountryId{"PH"}, Coordinate{126.216, 6.95028}}, // Imelda R. Marcos Airport
    Airport{IataCode{"MXJ"}, CountryId{"NG"}, Coordinate{6.46629, 9.6603}}, // Minna Airport
    Airport{IataCode{"MXL"}, CountryId{"MX"}, Coordinate{-115.248, 32.6287}}, // General Rodolfo Sánchez Taboada International Airport
    Airport{IataCode{"MXM"}, CountryId{"MG"}, Coordinate{43.3667, -21.7539}}, // Morombe Airport
    Airport{IataCode{"MXN"}, CountryId{"FR"}, Coordinate{-3.81662, 48.6}}, // Morlaix – Ploujean Airport
    Airport{IataCode{"MXO"}, CountryId{"US"}, Coordinate{-91.1641, 42.227}}, // Monticello Regional Airport
    Airport{IataCode{"MXP"}, CountryId{"IT"}, Coordinate{8.72306, 45.63}}, // Milan–Malpensa Airport
    Airport{IataCode{"MXS"}, CountryId{"WS"}, Coordinate{-172.259, -13.743}}, // Maota Airport
    Airport{IataCode{"MXT"}, CountryId{"MG"}, Coordinate{44.0322, -18.0508}}, // Maintirano Airport
    Airport{IataCode{"MXU"}, CountryId{"AU"}, Coordinate{115.518, -28.4739}}, // Mullewa Airport
    Airport{IataCode{"MXV"}, CountryId{"MN"}, Coordinate{100.099, 49.6631}}, // Mörön Airport
    Airport{IataCode{"MXW"}, CountryId{"MN"}, Coordinate{106.283, 45.7667}}, // Mandalgovi Airport
    Airport{IataCode{"MXX"}, CountryId{"SE"}, Coordinate{14.5111, 60.9586}}, // Mora-Siljan Airport
    Airport{IataCode{"MXY"}, CountryId{"US"}, Coordinate{-142.904, 61.4369}}, // McCarthy Airport
    Airport{IataCode{"MXZ"}, CountryId{"CN"}, Coordinate{116.133, 24.35}}, // Meixian Airport
    Airport{IataCode{"MYA"}, CountryId{"AU"}, Coordinate{150.147, -35.9025}}, // Moruya Airport
    Airport{IataCode{"MYB"}, CountryId{"GA"}, Coordinate{10.65, -3.46056}}, // Mayumba Airport
    Airport{IataCode{"MYC"}, CountryId{"VE"}, Coordinate{-67.6494, 10.25}}, // Mariscal Sucre Airport
    Airport{IataCode{"MYD"}, CountryId{"KE"}, Coordinate{40.1003, -3.23067}}, // Malindi Airport
    Airport{IataCode{"MYE"}, CountryId{"JP"}, Coordinate{139.56, 34.0736}}, // Miyakejima Airport
    Airport{IataCode{"MYF"}, CountryId{"US"}, Coordinate{-117.139, 32.8158}}, // Montgomery-Gibbs Executive Airport
    Airport{IataCode{"MYG"}, CountryId{"BS"}, Coordinate{-73.0136, 22.3794}}, // Mayaguana Airport
    Airport{IataCode{"MYH"}, CountryId{"US"}, Coordinate{-111.644, 36.8113}}, // Marble Canyon Airport
    Airport{IataCode{"MYI"}, CountryId{"AU"}, Coordinate{144.054, -9.91667}}, // Murray Island Airport
    Airport{IataCode{"MYJ"}, CountryId{"JP"}, Coordinate{132.704, 33.829}}, // Matsuyama Airport
    Airport{IataCode{"MYK"}, CountryId{"US"}, Coordinate{-142.687, 61.3356}}, // May Creek Airport
    Airport{IataCode{"MYL"}, CountryId{"US"}, Coordinate{-116.102, 44.8886}}, // McCall Municipal Airport
    Airport{IataCode{"MYM"}, CountryId{"GY"}, Coordinate{-59.6333, 4.6}}, // Monkey Mountain Airport
    Airport{IataCode{"MYN"}, CountryId{"YE"}, Coordinate{45.3256, 15.4692}}, // Marib Airport
    Airport{IataCode{"MYP"}, CountryId{"TM"}, Coordinate{61.9016, 37.607}}, // Mary Airport
    Airport{IataCode{"MYQ"}, CountryId{"IN"}, Coordinate{76.6582, 12.2279}}, // Mysore Airport
    Airport{IataCode{"MYR"}, CountryId{"US"}, Coordinate{-78.9234, 33.6815}}, // Myrtle Beach International Airport
    Airport{IataCode{"MYT"}, CountryId{"MM"}, Coordinate{97.3545, 25.3816}}, // Myitkyina Airport
    Airport{IataCode{"MYU"}, CountryId{"US"}, Coordinate{-166.271, 60.3714}}, // Mekoryuk Airport
    Airport{IataCode{"MYV"}, CountryId{"US"}, Coordinate{-121.57, 39.0978}}, // Yuba County Airport
    Airport{IataCode{"MYW"}, CountryId{"TZ"}, Coordinate{40.1819, -10.3361}}, // Mtwara Airport
    Airport{IataCode{"MYY"}, CountryId{"MY"}, Coordinate{113.986, 4.32912}}, // Miri Airport
    Airport{IataCode{"MYZ"}, CountryId{"MW"}, Coordinate{34.9167, -14.1}}, // Monkey Bay Airport
    Airport{IataCode{"MZA"}, CountryId{"PE"}, Coordinate{-74.5358, -11.3257}}, // Manuel Prado Airport
    Airport{IataCode{"MZB"}, CountryId{"MZ"}, Coordinate{40.35, -11.3617}}, // Mocímboa da Praia Airport
    Airport{IataCode{"MZE"}, CountryId{"BZ"}, Coordinate{-89.019, 17.2794}}, // Manatee Airport
    Airport{IataCode{"MZI"}, CountryId{"ML"}, Coordinate{-4.07944, 14.5128}}, // Mopti Airport
    Airport{IataCode{"MZJ"}, CountryId{"US"}, Coordinate{-111.324, 32.5111}}, // Pinal Airpark
    Airport{IataCode{"MZK"}, CountryId{"KI"}, Coordinate{173.267, 2.05028}}, // Marakei Airport
    Airport{IataCode{"MZL"}, CountryId{"CO"}, Coordinate{-75.4692, 5.02887}}, // La Nubia Airport
    Airport{IataCode{"MZN"}, CountryId{"PG"}, Coordinate{144.688, -5.90151}}, // Minj Airport
    Airport{IataCode{"MZO"}, CountryId{"CU"}, Coordinate{-77.0966, 20.2823}}, // Sierra Maestra Airport
    Airport{IataCode{"MZP"}, CountryId{"NZ"}, Coordinate{172.994, -41.1233}}, // Motueka Aerodrome
    Airport{IataCode{"MZR"}, CountryId{"AF"}, Coordinate{67.2087, 36.709}}, // Mazar-i-Sharif Airport
    Airport{IataCode{"MZT"}, CountryId{"MX"}, Coordinate{-106.27, 23.1666}}, // General Rafael Buelna International Airport
    Airport{IataCode{"MZU"}, CountryId{"IN"}, Coordinate{85.3136, 26.1192}}, // Muzzafarpur Airport
    Airport{IataCode{"MZV"}, CountryId{"MY"}, Coordinate{114.809, 4.05056}}, // Mulu Airport
    Airport{IataCode{"MZW"}, CountryId{"DZ"}, Coordinate{-0.256226, 33.5318}}, // Mécheria Airport
    Airport{IataCode{"MZZ"}, CountryId{"US"}, Coordinate{-85.6797, 40.49}}, // Marion Municipal Airport
    Airport{IataCode{"NAA"}, CountryId{"AU"}, Coordinate{149.827, -30.3192}}, // Narrabri Airport
    Airport{IataCode{"NAC"}, CountryId{"AU"}, Coordinate{140.725, -36.985}}, // Naracoorte Airport
    Airport{IataCode{"NAE"}, CountryId{"BJ"}, Coordinate{1.35915, 10.3772}}, // Natitingou Airport
    Airport{IataCode{"NAG"}, CountryId{"IN"}, Coordinate{79.0547, 21.0909}}, // Dr. Babasaheb Ambedkar International Airport
    Airport{IataCode{"NAH"}, CountryId{"ID"}, Coordinate{125.528, 3.68306}}, // Naha Airport
    Airport{IataCode{"NAI"}, CountryId{"GY"}, Coordinate{-59.1242, 3.95944}}, // Annai Airport
    Airport{IataCode{"NAJ"}, CountryId{"AZ"}, Coordinate{45.4583, 39.1886}}, // Nakhchivan Airport
    Airport{IataCode{"NAK"}, CountryId{"TH"}, Coordinate{102.313, 14.9494}}, // Nakhon Ratchasima Airport
    Airport{IataCode{"NAL"}, CountryId{"RU"}, Coordinate{43.6359, 43.5082}}, // Nalchik Airport
    Airport{IataCode{"NAM"}, CountryId{"ID"}, Coordinate{127.083, -3.25}}, // Namlea Airport
    Airport{IataCode{"NAN"}, CountryId{"FJ"}, Coordinate{177.448, -17.7547}}, // Nadi International Airport
    Airport{IataCode{"NAO"}, CountryId{"CN"}, Coordinate{106.162, 30.7907}}, // Nanchong Gaoping Airport
    Airport{IataCode{"NAP"}, CountryId{"IT"}, Coordinate{14.2826, 40.878}}, // Naples International Airport
    Airport{IataCode{"NAQ"}, CountryId{"GL"}, Coordinate{-69.3886, 77.4886}}, // Qaanaaq Airport
    Airport{IataCode{"NAR"}, CountryId{"CO"}, Coordinate{-74.5906, 6.21002}}, // Puerto Nare Airport
    Airport{IataCode{"NAS"}, CountryId{"BS"}, Coordinate{-77.4661, 25.0389}}, // Lynden Pindling International Airport
    Airport{IataCode{"NAT"}, CountryId{"BR"}, Coordinate{-35.3704, -5.76362}}, // Greater Natal International Airport
    Airport{IataCode{"NAU"}, CountryId{"FR"}, Coordinate{-141.267, -14.1767}}, // Napuka Airport
    Airport{IataCode{"NAV"}, CountryId{"TR"}, Coordinate{34.5247, 38.7719}}, // Nevşehir Kapadokya Airport
    Airport{IataCode{"NAW"}, CountryId{"TH"}, Coordinate{101.749, 6.52311}}, // Narathiwat Airport
    Airport{IataCode{"NAY"}, CountryId{"CN"}, Coordinate{116.391, 39.7897}}, // Beijing Nanyuan Airport
    Airport{IataCode{"NBB"}, CountryId{"CO"}, Coordinate{-69.8097, 3.48333}}, // Barranco Minas Airport
    Airport{IataCode{"NBC"}, CountryId{"RU"}, Coordinate{52.1019, 55.5648}}, // Begishevo Airport
    Airport{IataCode{"NBE"}, CountryId{"TN"}, Coordinate{10.4387, 36.0827}}, // Enfidha – Hammamet International Airport
    Airport{IataCode{"NBL"}, CountryId{"PA"}, Coordinate{-78.1389, 9.25028}}, // Wannukandi Airport
    Airport{IataCode{"NBN"}, CountryId{"GQ"}, Coordinate{5.62231, -1.40851}}, // Annobon Airport
    Airport{IataCode{"NBO"}, CountryId{"KE"}, Coordinate{36.9259, -1.33119}}, // Jomo Kenyatta International Airport
    Airport{IataCode{"NBS"}, CountryId{"CN"}, Coordinate{127.549, 42.0881}}, // Changbaishan Airport
    Airport{IataCode{"NBW"}, CountryId{"CU"}, Coordinate{-75.2069, 19.9064}}, // Leeward Point Field
    Airport{IataCode{"NBX"}, CountryId{"ID"}, Coordinate{135.496, -3.37028}}, // Nabire Airport
    Airport{IataCode{"NCA"}, CountryId{"GB"}, Coordinate{-71.9394, 21.9175}}, // North Caicos Airport
    Airport{IataCode{"NCE"}, CountryId{"FR"}, Coordinate{7.215, 43.6653}}, // Nice Côte d'Azur Airport
    Airport{IataCode{"NCG"}, CountryId{"MX"}, Coordinate{-107.883, 30.4}}, // Nuevo Casas Grandes Airport
    Airport{IataCode{"NCH"}, CountryId{"TZ"}, Coordinate{38.78, -10.3583}}, // Nachingwea Airport
    Airport{IataCode{"NCI"}, CountryId{"CO"}, Coordinate{-76.7833, 8.45}}, // Necocli Airport
    Airport{IataCode{"NCJ"}, CountryId{"AR"}, Coordinate{-61.5289, -30.9572}}, // Sunchales Airport
    Airport{IataCode{"NCL"}, CountryId{"GB"}, Coordinate{-1.7111, 55.0356}}, // Newcastle International Airport
    Airport{IataCode{"NCN"}, CountryId{"US"}, Coordinate{-147.992, 60.0772}}, // Chenega Bay Airport
    Airport{IataCode{"NCR"}, CountryId{"NI"}, Coordinate{-84.7656, 11.1331}}, // San Carlos Airport
    Airport{IataCode{"NCS"}, CountryId{"ZA"}, Coordinate{29.9764, -27.7729}}, // Newcastle Airport
    Airport{IataCode{"NCT"}, CountryId{"CR"}, Coordinate{-85.45, 10.1333}}, // Nicoya Airport
    Airport{IataCode{"NCU"}, CountryId{"UZ"}, Coordinate{59.6174, 42.4818}}, // Nukus Airport
    Airport{IataCode{"NCY"}, CountryId{"FR"}, Coordinate{6.10672, 45.9311}}, // Annecy – Haute-Savoie – Mont Blanc Airport
    Airport{IataCode{"NDA"}, CountryId{"ID"}, Coordinate{129.904, -4.52238}}, // Bandanaira Airport
    Airport{IataCode{"NDB"}, CountryId{"MR"}, Coordinate{-17.0311, 20.9284}}, // Nouadhibou International Airport
    Airport{IataCode{"NDC"}, CountryId{"IN"}, Coordinate{77.3351, 19.1833}}, // Shri Guru Gobind Singh Ji Airport
    Airport{IataCode{"NDD"}, CountryId{"AO"}, Coordinate{13.8478, -11.168}}, // Sumbe Airport
    Airport{IataCode{"NDE"}, CountryId{"KE"}, Coordinate{41.8444, 3.93396}}, // Mandera Airport
    Airport{IataCode{"NDF"}, CountryId{"AO"}, Coordinate{14.9847, -9.28183}}, // N'dalatando Airport
    Airport{IataCode{"NDG"}, CountryId{"CN"}, Coordinate{123.917, 47.252}}, // Qiqihar Sanjiazi Airport
    Airport{IataCode{"NDJ"}, CountryId{"TD"}, Coordinate{15.0339, 12.1293}}, // N'Djamena International Airport
    Airport{IataCode{"NDK"}, CountryId{"MH"}, Coordinate{168.126, 5.63306}}, // Namorik Airport
    Airport{IataCode{"NDL"}, CountryId{"CF"}, Coordinate{20.6344, 8.43}}, // N'Délé Airport
    Airport{IataCode{"NDM"}, CountryId{"ET"}, Coordinate{35.1, 9.76667}}, // Mendi, Ethiopia Airport
    Airport{IataCode{"NDN"}, CountryId{"PG"}, Coordinate{147.683, -9.13333}}, // Nadunumu
    Airport{IataCode{"NDR"}, CountryId{"MA"}, Coordinate{-3.02896, 34.9932}}, // Nador International Airport
    Airport{IataCode{"NDU"}, CountryId{"NA"}, Coordinate{19.7267, -17.959}}, // Rundu Airport
    Airport{IataCode{"NEC"}, CountryId{"AR"}, Coordinate{-58.8163, -38.4895}}, // Necochea Airport
    Airport{IataCode{"NEF"}, CountryId{"RU"}, Coordinate{54.3437, 56.1088}}, // Neftekamsk Airport
    Airport{IataCode{"NEG"}, CountryId{"JM"}, Coordinate{-78.3356, 18.34}}, // Negril Aerodrome
    Airport{IataCode{"NEK"}, CountryId{"ET"}, Coordinate{36.6, 9.05}}, // Nekemte Airport
    Airport{IataCode{"NER"}, CountryId{"RU"}, Coordinate{124.9, 56.9055}}, // Chulman Airport
    Airport{IataCode{"NEU"}, CountryId{"LA"}, Coordinate{104.066, 20.4183}}, // Sam Neua
    Airport{IataCode{"NEV"}, CountryId{"KN"}, Coordinate{-62.5923, 17.2044}}, // Vance W. Amory International Airport
    Airport{IataCode{"NFG"}, CountryId{"RU"}, Coordinate{72.65, 61.1083}}, // Nefteyugansk Airport
    Airport{IataCode{"NFO"}, CountryId{"TO"}, Coordinate{-175.629, -15.5718}}, // Niuafoʻou Airport
    Airport{IataCode{"NGA"}, CountryId{"AU"}, Coordinate{148.248, -34.2556}}, // Young Airport
    Airport{IataCode{"NGB"}, CountryId{"CN"}, Coordinate{121.459, 29.8228}}, // Ningbo Lishe International Airport
    Airport{IataCode{"NGD"}, CountryId{"GB"}, Coordinate{-64.3305, 18.728}}, // Auguste George Airport
    Airport{IataCode{"NGE"}, CountryId{"CM"}, Coordinate{13.5633, 7.35857}}, // Ngaoundéré Airport
    Airport{IataCode{"NGI"}, CountryId{"FJ"}, Coordinate{179.34, -18.1156}}, // Ngau Airport
    Airport{IataCode{"NGK"}, CountryId{"RU"}, Coordinate{143.141, 51.7884}}, // Nogliki Airport
    Airport{IataCode{"NGN"}, CountryId{"PA"}, Coordinate{-78.5886, 9.44485}}, // Nargana Airport
    Airport{IataCode{"NGO"}, CountryId{"JP"}, Coordinate{136.816, 34.8594}}, // Chubu Centrair International Airport
    Airport{IataCode{"NGQ"}, CountryId{"CN"}, Coordinate{80.056, 32.1046}}, // Ngari Günsa Airport
    Airport{IataCode{"NGR"}, CountryId{"PG"}, Coordinate{141.127, -5.6733}}, // Ningerum Airport
    Airport{IataCode{"NGS"}, CountryId{"JP"}, Coordinate{129.923, 32.9136}}, // Nagasaki Airport
    Airport{IataCode{"NGX"}, CountryId{"NP"}, Coordinate{84, 28.6333}}, // Manang Airport
    Airport{IataCode{"NHF"}, CountryId{"SD"}, Coordinate{35.7278, 15.3556}}, // New Halfa Airport
    Airport{IataCode{"NHV"}, CountryId{"FR"}, Coordinate{-140.222, -8.7951}}, // Nuku Hiva Airport
    Airport{IataCode{"NHZ"}, CountryId{"US"}, Coordinate{-69.9341, 43.8983}}, // Brunswick Executive Airport
    Airport{IataCode{"NIA"}, CountryId{"LR"}, Coordinate{-8.60013, 7.5}}, // Nimba Airport
    Airport{IataCode{"NIB"}, CountryId{"US"}, Coordinate{-154.358, 63.0186}}, // Nikolai Airport
    Airport{IataCode{"NIF"}, CountryId{"AU"}, Coordinate{121.595, -21.6737}}, // Nifty Airport
    Airport{IataCode{"NIG"}, CountryId{"KI"}, Coordinate{176.409, -1.31509}}, // Nikunau Airport
    Airport{IataCode{"NIM"}, CountryId{"NE"}, Coordinate{2.17725, 13.477}}, // Diori Hamani International Airport
    Airport{IataCode{"NIO"}, CountryId{"CD"}, Coordinate{17.6847, -2.7175}}, // Nioki Airport
    Airport{IataCode{"NIU"}, CountryId{"FR"}, Coordinate{-146.373, -16.1222}}, // Niau Airport
    Airport{IataCode{"NIX"}, CountryId{"ML"}, Coordinate{-9.58333, 15.2333}}, // Nioro Airport
    Airport{IataCode{"NJC"}, CountryId{"RU"}, Coordinate{76.4954, 60.9512}}, // Nizhnevartovsk Airport
    Airport{IataCode{"NJF"}, CountryId{"IQ"}, Coordinate{44.4043, 31.9899}}, // Al Najaf International Airport
    Airport{IataCode{"NKC"}, CountryId{"MR"}, Coordinate{-15.963, 18.3086}}, // Nouakchott–Oumtounsy International Airport
    Airport{IataCode{"NKG"}, CountryId{"CN"}, Coordinate{118.87, 31.7332}}, // Nanjing Lukou International Airport
    Airport{IataCode{"NKL"}, CountryId{"CD"}, Coordinate{14.8167, -5.45}}, // Nkolo Fuma Airport
    Airport{IataCode{"NKM"}, CountryId{"JP"}, Coordinate{136.924, 35.255}}, // Nagoya Airfield
    Airport{IataCode{"NKN"}, CountryId{"PG"}, Coordinate{146.45, -5.83333}}, // Nankina
    Airport{IataCode{"NKS"}, CountryId{"CM"}, Coordinate{9.93333, 4.95}}, // Nkongsamba Airport
    Airport{IataCode{"NKT"}, CountryId{"TR"}, Coordinate{42.0574, 37.3609}}, // Şırnak Airport
    Airport{IataCode{"NKU"}, CountryId{"LS"}, Coordinate{28.1969, -30.0217}}, // Nkaus Airport
    Airport{IataCode{"NKY"}, CountryId{"CG"}, Coordinate{13.2833, -4.21667}}, // Yokangassi Airport
    Airport{IataCode{"NLA"}, CountryId{"ZM"}, Coordinate{28.6587, -12.9943}}, // Simon Mwansa Kapwepwe International Airport
    Airport{IataCode{"NLD"}, CountryId{"MX"}, Coordinate{-99.568, 27.4498}}, // Quetzalcóatl International Airport
    Airport{IataCode{"NLE"}, CountryId{"US"}, Coordinate{-86.2259, 41.8407}}, // Jerry Tyler Memorial Airport
    Airport{IataCode{"NLF"}, CountryId{"AU"}, Coordinate{143.78, -9.57833}}, // Darnley Island Airport
    Airport{IataCode{"NLG"}, CountryId{"US"}, Coordinate{-161.16, 56.0075}}, // Nelson Lagoon Airport
    Airport{IataCode{"NLH"}, CountryId{"CN"}, Coordinate{100.757, 27.5438}}, // Lugu Lake Airport
    Airport{IataCode{"NLI"}, CountryId{"RU"}, Coordinate{140.663, 53.1499}}, // Nikolayevsk-on-Amur Airport
    Airport{IataCode{"NLK"}, CountryId{"AU"}, Coordinate{167.943, -29.0353}}, // Norfolk Island Airport
    Airport{IataCode{"NLN"}, CountryId{"US"}, Coordinate{-123.927, 40.7192}}, // Kneeland Airport
    Airport{IataCode{"NLO"}, CountryId{"CD"}, Coordinate{15.3272, -4.32667}}, // N'Dolo Airport
    Airport{IataCode{"NLP"}, CountryId{"ZA"}, Coordinate{30.9118, -25.5022}}, // Nelspruit Airport
    Airport{IataCode{"NLT"}, CountryId{"CN"}, Coordinate{83.3759, 43.4286}}, // Nalati Airport
    Airport{IataCode{"NLV"}, CountryId{"UA"}, Coordinate{31.9202, 47.0538}}, // Mykolaiv Airport
    Airport{IataCode{"NMA"}, CountryId{"UZ"}, Coordinate{71.5748, 40.9835}}, // Namangan Airport
    Airport{IataCode{"NMB"}, CountryId{"IN"}, Coordinate{72.8433, 20.4344}}, // Daman Airport
    Airport{IataCode{"NMC"}, CountryId{"BS"}, Coordinate{-76.8212, 24.5915}}, // Norman's Cay Airport
    Airport{IataCode{"NME"}, CountryId{"US"}, Coordinate{-164.701, 60.4711}}, // Nightmute Airport
    Airport{IataCode{"NMF"}, CountryId{"MV"}, Coordinate{73.4747, 5.82222}}, // Maafaru International Airport
    Airport{IataCode{"NMG"}, CountryId{"PA"}, Coordinate{-78.9333, 8.45694}}, // San Miguel Airport
    Airport{IataCode{"NML"}, CountryId{"CA"}, Coordinate{-111.574, 57.0556}}, // Fort McMurray/Mildred Lake Airport
    Airport{IataCode{"NMS"}, CountryId{"MM"}, Coordinate{97.7369, 20.8856}}, // Namsang Airport
    Airport{IataCode{"NMT"}, CountryId{"MM"}, Coordinate{97.383, 23.083}}, // Namtu Airport
    Airport{IataCode{"NNB"}, CountryId{"SB"}, Coordinate{162.454, -10.8481}}, // Santa Ana Airport
    Airport{IataCode{"NNG"}, CountryId{"CN"}, Coordinate{108.172, 22.6083}}, // Nanning Wuxu International Airport
    Airport{IataCode{"NNI"}, CountryId{"NA"}, Coordinate{16.925, -18.8111}}, // Namutoni Airport
    Airport{IataCode{"NNK"}, CountryId{"US"}, Coordinate{-157.02, 58.7328}}, // Naknek Airport
    Airport{IataCode{"NNL"}, CountryId{"US"}, Coordinate{-154.839, 59.9803}}, // Nondalton Airport
    Airport{IataCode{"NNM"}, CountryId{"RU"}, Coordinate{53.0855, 67.6335}}, // Naryan-Mar Airport
    Airport{IataCode{"NNN"}, CountryId{"UA"}, Coordinate{30.385, 50.4783}}, // Sviatoshyn Airfield
    Airport{IataCode{"NNR"}, CountryId{"IE"}, Coordinate{-9.46952, 53.2322}}, // Connemara Airport
    Airport{IataCode{"NNS"}, CountryId{"IN"}, Coordinate{80.2418, 29.5925}}, // Naini Saini Airport
    Airport{IataCode{"NNT"}, CountryId{"TH"}, Coordinate{100.783, 18.8078}}, // Nan Nakhon Airport
    Airport{IataCode{"NNU"}, CountryId{"BR"}, Coordinate{-40.3297, -17.8231}}, // Jorge Schieber Airport
    Airport{IataCode{"NNX"}, CountryId{"ID"}, Coordinate{117.665, 4.13614}}, // Nunukan Airport
    Airport{IataCode{"NNY"}, CountryId{"CN"}, Coordinate{112.614, 32.9839}}, // Nanyang Jiangying Airport
    Airport{IataCode{"NOB"}, CountryId{"CR"}, Coordinate{-85.6531, 9.96667}}, // Nosara Airport
    Airport{IataCode{"NOC"}, CountryId{"IE"}, Coordinate{-8.81119, 53.9139}}, // Ireland West Airport Knock
    Airport{IataCode{"NOG"}, CountryId{"MX"}, Coordinate{-110.973, 31.2255}}, // Nogales International Airport
    Airport{IataCode{"NOJ"}, CountryId{"RU"}, Coordinate{75.2746, 63.182}}, // Noyabrsk Airport
    Airport{IataCode{"NOK"}, CountryId{"BR"}, Coordinate{-52.3469, -14.6973}}, // Nova Xavantina Airport
    Airport{IataCode{"NOM"}, CountryId{"PG"}, Coordinate{142.117, -6.65}}, // Nomad River airport
    Airport{IataCode{"NON"}, CountryId{"KI"}, Coordinate{174.428, -0.639667}}, // Nonouti Airport
    Airport{IataCode{"NOP"}, CountryId{"TR"}, Coordinate{35.0791, 42.0187}}, // Sinop Airport
    Airport{IataCode{"NOR"}, CountryId{"IS"}, Coordinate{-13.7464, 65.1319}}, // Norðfjörður Airport
    Airport{IataCode{"NOS"}, CountryId{"MG"}, Coordinate{48.3092, -13.3181}}, // Fascene Airport
    Airport{IataCode{"NOT"}, CountryId{"US"}, Coordinate{-122.556, 38.1436}}, // Marin County Airport
    Airport{IataCode{"NOU"}, CountryId{"FR"}, Coordinate{166.217, -22.0133}}, // La Tontouta International Airport
    Airport{IataCode{"NOV"}, CountryId{"AO"}, Coordinate{15.7606, -12.8089}}, // Albano Machado Airport
    Airport{IataCode{"NOZ"}, CountryId{"RU"}, Coordinate{86.8642, 53.8053}}, // Spichenkovo Airport
    Airport{IataCode{"NPE"}, CountryId{"NZ"}, Coordinate{176.872, -39.4665}}, // Hawke's Bay Airport
    Airport{IataCode{"NPL"}, CountryId{"NZ"}, Coordinate{174.179, -39.0098}}, // New Plymouth Airport
    Airport{IataCode{"NPO"}, CountryId{"ID"}, Coordinate{111.473, 0.06362}}, // Nanga Pinoh Airport
    Airport{IataCode{"NPR"}, CountryId{"BR"}, Coordinate{-55.4008, -7.12583}}, // Novo Progresso Airport
    Airport{IataCode{"NPT"}, CountryId{"US"}, Coordinate{-71.2832, 41.5314}}, // Newport State Airport
    Airport{IataCode{"NPY"}, CountryId{"TZ"}, Coordinate{31.0825, -6.35533}}, // Mpanda Airport
    Airport{IataCode{"NQA"}, CountryId{"US"}, Coordinate{-89.8703, 35.3567}}, // Millington Regional Jetport
    Airport{IataCode{"NQL"}, CountryId{"BR"}, Coordinate{-48.4919, -14.4364}}, // Niquelândia Airport
    Airport{IataCode{"NQN"}, CountryId{"AR"}, Coordinate{-68.1403, -38.9521}}, // Presidente Perón International Airport
    Airport{IataCode{"NQU"}, CountryId{"CO"}, Coordinate{-77.2658, 5.70815}}, // Reyes Murillo Airport
    Airport{IataCode{"NQY"}, CountryId{"GB"}, Coordinate{-5.00375, 50.4469}}, // Cornwall Airport Newquay
    Airport{IataCode{"NQZ"}, CountryId{"KZ"}, Coordinate{71.4669, 51.0222}}, // Nursultan Nazarbayev International Airport
    Airport{IataCode{"NRA"}, CountryId{"AU"}, Coordinate{146.518, -34.6983}}, // Narrandera Airport
    Airport{IataCode{"NRE"}, CountryId{"ID"}, Coordinate{126.7, -3.85583}}, // Namrole Airport
    Airport{IataCode{"NRG"}, CountryId{"AU"}, Coordinate{117.08, -32.93}}, // Narrogin Airport
    Airport{IataCode{"NRI"}, CountryId{"US"}, Coordinate{-94.8619, 36.5775}}, // Grand Lake Regional Airport
    Airport{IataCode{"NRK"}, CountryId{"SE"}, Coordinate{16.2317, 58.5861}}, // Norrköping Airport
    Airport{IataCode{"NRM"}, CountryId{"ML"}, Coordinate{-7.26667, 15.2287}}, // Keibane Airport
    Airport{IataCode{"NRN"}, CountryId{"DE"}, Coordinate{6.15037, 51.5995}}, // Weeze Airport
    Airport{IataCode{"NRR"}, CountryId{"US"}, Coordinate{-65.6433, 18.2453}}, // José Aponte de la Torre Airport
    Airport{IataCode{"NRT"}, CountryId{"JP"}, Coordinate{140.386, 35.7654}}, // Narita International Airport
    Airport{IataCode{"NSH"}, CountryId{"IR"}, Coordinate{51.4647, 36.6633}}, // Noshahr Airport
    Airport{IataCode{"NSI"}, CountryId{"CM"}, Coordinate{11.5479, 3.71485}}, // Yaoundé Nsimalen International Airport
    Airport{IataCode{"NSK"}, CountryId{"RU"}, Coordinate{87.3418, 69.3252}}, // Alykel Airport
    Airport{IataCode{"NSM"}, CountryId{"AU"}, Coordinate{121.754, -32.2114}}, // Norseman Airport
    Airport{IataCode{"NSN"}, CountryId{"NZ"}, Coordinate{173.225, -41.3}}, // Nelson Airport, New Zealand
    Airport{IataCode{"NST"}, CountryId{"TH"}, Coordinate{99.9447, 8.53944}}, // Nakhon Si Thammarat Airport
    Airport{IataCode{"NSX"}, CountryId{"GB"}, Coordinate{-64.3931, 18.4947}}, // North Sound Water Aerodrome
    Airport{IataCode{"NTB"}, CountryId{"NO"}, Coordinate{9.21857, 59.5654}}, // Notodden Airport
    Airport{IataCode{"NTE"}, CountryId{"FR"}, Coordinate{-1.60184, 47.1579}}, // Nantes Atlantique Airport
    Airport{IataCode{"NTG"}, CountryId{"CN"}, Coordinate{120.976, 32.0708}}, // Nantong Xingdong Airport
    Airport{IataCode{"NTN"}, CountryId{"AU"}, Coordinate{141.07, -17.685}}, // Normanton Airport
    Airport{IataCode{"NTQ"}, CountryId{"JP"}, Coordinate{136.957, 37.2953}}, // Noto Airport
    Airport{IataCode{"NTR"}, CountryId{"MX"}, Coordinate{-100.238, 25.86}}, // Del Norte International Airport
    Airport{IataCode{"NTT"}, CountryId{"TO"}, Coordinate{-173.792, -15.9777}}, // Niuatoputapu Airport
    Airport{IataCode{"NTY"}, CountryId{"ZA"}, Coordinate{27.1697, -25.3353}}, // Pilanesberg International Airport
    Airport{IataCode{"NUB"}, CountryId{"AU"}, Coordinate{135.717, -14.2717}}, // Numbulwar Airport
    Airport{IataCode{"NUD"}, CountryId{"SD"}, Coordinate{28.333, 12.6667}}, // En Nahud Airport
    Airport{IataCode{"NUE"}, CountryId{"DE"}, Coordinate{11.0784, 49.4939}}, // Nuremberg Airport
    Airport{IataCode{"NUG"}, CountryId{"PG"}, Coordinate{154.8, -3.333}}, // Nuguria
    Airport{IataCode{"NUI"}, CountryId{"US"}, Coordinate{-151.006, 70.21}}, // Nuiqsut Airport
    Airport{IataCode{"NUK"}, CountryId{"FR"}, Coordinate{-138.772, -19.285}}, // Nukutavake Airport
    Airport{IataCode{"NUL"}, CountryId{"US"}, Coordinate{-158.074, 64.7294}}, // Nulato Airport
    Airport{IataCode{"NUM"}, CountryId{"SA"}, Coordinate{35.2961, 27.9286}}, // Neom Airport
    Airport{IataCode{"NUP"}, CountryId{"US"}, Coordinate{-162.439, 60.9058}}, // Nunapitchuk Airport
    Airport{IataCode{"NUS"}, CountryId{"VU"}, Coordinate{167.401, -16.0797}}, // Norsup Airport
    Airport{IataCode{"NUT"}, CountryId{"PG"}, Coordinate{151.383, -5.63333}}, // Nutuve
    Airport{IataCode{"NUU"}, CountryId{"KE"}, Coordinate{36.1508, -0.302778}}, // Nakuru Airport
    Airport{IataCode{"NUX"}, CountryId{"RU"}, Coordinate{76.5208, 66.073}}, // Novy Urengoy Airport
    Airport{IataCode{"NVA"}, CountryId{"CO"}, Coordinate{-75.2928, 2.94728}}, // Benito Salas Airport
    Airport{IataCode{"NVG"}, CountryId{"NI"}, Coordinate{-84.4547, 11.6667}}, // Nueva Guinea Airport
    Airport{IataCode{"NVI"}, CountryId{"UZ"}, Coordinate{65.1669, 40.1229}}, // Navoi International Airport
    Airport{IataCode{"NVN"}, CountryId{"US"}, Coordinate{-120.353, 39.8186}}, // Nervino Airport
    Airport{IataCode{"NVR"}, CountryId{"RU"}, Coordinate{31.2417, 58.4933}}, // Novgorod Airport
    Airport{IataCode{"NVS"}, CountryId{"FR"}, Coordinate{3.11073, 46.9989}}, // Nevers-Fourchambault Airport
    Airport{IataCode{"NVT"}, CountryId{"BR"}, Coordinate{-48.6492, -26.8806}}, // Ministro Victor Konder International Airport
    Airport{IataCode{"NWA"}, CountryId{"KM"}, Coordinate{43.7664, -12.2981}}, // Mohéli Bandar Es Eslam Airport
    Airport{IataCode{"NWH"}, CountryId{"US"}, Coordinate{-72.1893, 43.3881}}, // Parlin Field
    Airport{IataCode{"NWI"}, CountryId{"GB"}, Coordinate{1.27729, 52.6697}}, // Norwich International Airport
    Airport{IataCode{"NWT"}, CountryId{"PG"}, Coordinate{143.167, -8.5}}, // Nowata
    Airport{IataCode{"NYA"}, CountryId{"RU"}, Coordinate{65.6059, 62.1018}}, // Nyagan Airport
    Airport{IataCode{"NYE"}, CountryId{"KE"}, Coordinate{36.9667, -0.371389}}, // Nyeri Airport
    Airport{IataCode{"NYI"}, CountryId{"GH"}, Coordinate{-2.32927, 7.35949}}, // Sunyani Airport
    Airport{IataCode{"NYK"}, CountryId{"KE"}, Coordinate{37.0342, -0.069444}}, // Nanyuki Airport
    Airport{IataCode{"NYM"}, CountryId{"RU"}, Coordinate{72.6917, 65.4801}}, // Nadym Airport
    Airport{IataCode{"NYN"}, CountryId{"AU"}, Coordinate{147.203, -31.5517}}, // Nyngan Airport
    Airport{IataCode{"NYO"}, CountryId{"SE"}, Coordinate{16.9122, 58.7886}}, // Stockholm Skavsta Airport
    Airport{IataCode{"NYR"}, CountryId{"RU"}, Coordinate{118.347, 63.2972}}, // Nyurba Airport
    Airport{IataCode{"NYT"}, CountryId{"MM"}, Coordinate{96.2068, 19.6166}}, // Nay Pyi Taw International Airport
    Airport{IataCode{"NYU"}, CountryId{"MM"}, Coordinate{94.9287, 21.1755}}, // Nyaung U Airport
    Airport{IataCode{"NZA"}, CountryId{"AO"}, Coordinate{21.3579, -7.71653}}, // Nzagi Airport
    Airport{IataCode{"NZC"}, CountryId{"PE"}, Coordinate{-74.9618, -14.8542}}, // Maria Reiche Neuman Airport
    Airport{IataCode{"NZE"}, CountryId{"GN"}, Coordinate{-8.7026, 7.8132}}, // Nzérékoré Airport
    Airport{IataCode{"NZH"}, CountryId{"CN"}, Coordinate{117.33, 49.5704}}, // Manzhouli Xijiao Airport
    Airport{IataCode{"NZL"}, CountryId{"CN"}, Coordinate{122.768, 47.8658}}, // Zhalantun Chengjisihan Airport
    Airport{IataCode{"OAG"}, CountryId{"AU"}, Coordinate{149.125, -33.3816}}, // Orange Airport
    Airport{IataCode{"OAJ"}, CountryId{"US"}, Coordinate{-77.607, 34.829}}, // Albert J. Ellis Airport
    Airport{IataCode{"OAK"}, CountryId{"US"}, Coordinate{-122.214, 37.7113}}, // Oakland International Airport
    Airport{IataCode{"OAL"}, CountryId{"BR"}, Coordinate{-61.4508, -11.4956}}, // Cacoal Airport
    Airport{IataCode{"OAM"}, CountryId{"NZ"}, Coordinate{171.082, -44.9707}}, // Oamaru Airport
    Airport{IataCode{"OAN"}, CountryId{"HN"}, Coordinate{-86.5735, 15.5}}, // Olanchito
    Airport{IataCode{"OAR"}, CountryId{"US"}, Coordinate{-121.762, 36.6814}}, // Marina Municipal Airport
    Airport{IataCode{"OAX"}, CountryId{"MX"}, Coordinate{-96.7219, 17.0008}}, // Xoxocotlán International Airport
    Airport{IataCode{"OBC"}, CountryId{"DJ"}, Coordinate{43.2786, 11.9683}}, // Obock Airport
    Airport{IataCode{"OBE"}, CountryId{"US"}, Coordinate{-80.8511, 27.266}}, // Okeechobee County Airport
    Airport{IataCode{"OBF"}, CountryId{"DE"}, Coordinate{11.2855, 48.0899}}, // Oberpfaffenhofen Airport
    Airport{IataCode{"OBI"}, CountryId{"BR"}, Coordinate{-55.9467, 2.22347}}, // Tirios Airport
    Airport{IataCode{"OBN"}, CountryId{"GB"}, Coordinate{-5.39765, 56.4655}}, // Oban Airport
    Airport{IataCode{"OBO"}, CountryId{"JP"}, Coordinate{143.213, 42.7325}}, // Tokachi-Obihiro Airport
    Airport{IataCode{"OBU"}, CountryId{"US"}, Coordinate{-156.897, 66.9122}}, // Kobuk Airport
    Airport{IataCode{"OBX"}, CountryId{"PG"}, Coordinate{141.324, -7.59053}}, // Obo Airport
    Airport{IataCode{"OCA"}, CountryId{"US"}, Coordinate{-80.2756, 25.3243}}, // Ocean Reef Club Airport
    Airport{IataCode{"OCC"}, CountryId{"EC"}, Coordinate{-76.986, -0.462479}}, // Francisco de Orellana Airport
    Airport{IataCode{"OCE"}, CountryId{"US"}, Coordinate{-75.1187, 38.3109}}, // Ocean City Municipal Airport
    Airport{IataCode{"OCF"}, CountryId{"US"}, Coordinate{-82.2242, 29.1725}}, // Ocala International Airport
    Airport{IataCode{"OCJ"}, CountryId{"JM"}, Coordinate{-76.9689, 18.4042}}, // Ian Fleming International Airport
    Airport{IataCode{"OCM"}, CountryId{"AU"}, Coordinate{117.28, -22.5425}}, // Boolgeeda Airport
    Airport{IataCode{"OCN"}, CountryId{"US"}, Coordinate{-117.351, 33.2181}}, // Oceanside Municipal Airport
    Airport{IataCode{"OCS"}, CountryId{"GQ"}, Coordinate{9.32656, 0.913064}}, // Corisco International Airport
    Airport{IataCode{"OCV"}, CountryId{"CO"}, Coordinate{-73.3583, 8.315}}, // Aguas Claras Airport
    Airport{IataCode{"ODA"}, CountryId{"CF"}, Coordinate{22.4, 8.01667}}, // Ouadda Airport
    Airport{IataCode{"ODB"}, CountryId{"ES"}, Coordinate{-4.84378, 37.8445}}, // Córdoba Airport
    Airport{IataCode{"ODC"}, CountryId{"US"}, Coordinate{-120.8, 37.7564}}, // Oakdale Airport
    Airport{IataCode{"ODE"}, CountryId{"DK"}, Coordinate{10.3296, 55.4738}}, // Hans Christian Andersen Airport
    Airport{IataCode{"ODJ"}, CountryId{"CF"}, Coordinate{22.7833, 8.9}}, // Ouanda Djallé Airport
    Airport{IataCode{"ODM"}, CountryId{"US"}, Coordinate{-79.3379, 39.5819}}, // Garrett County Airport
    Airport{IataCode{"ODN"}, CountryId{"MY"}, Coordinate{115.063, 3.97611}}, // Long Seridan Airport
    Airport{IataCode{"ODO"}, CountryId{"RU"}, Coordinate{114.226, 57.858}}, // Bodaybo Airport
    Airport{IataCode{"ODS"}, CountryId{"UA"}, Coordinate{30.6763, 46.4416}}, // Odessa International Airport
    Airport{IataCode{"ODW"}, CountryId{"US"}, Coordinate{-122.674, 48.2517}}, // A.J. Eisenberg Airport
    Airport{IataCode{"ODY"}, CountryId{"LA"}, Coordinate{101.992, 20.6839}}, // Oudomsay Airport
    Airport{IataCode{"OEC"}, CountryId{"TL"}, Coordinate{124.352, -9.19833}}, // Oecusse Airport
    Airport{IataCode{"OEL"}, CountryId{"RU"}, Coordinate{36.0017, 52.935}}, // Oryol Yuzhny Airport
    Airport{IataCode{"OEM"}, CountryId{"SR"}, Coordinate{-55.4417, 3.34611}}, // Vincent Fayks Airport
    Airport{IataCode{"OEO"}, CountryId{"US"}, Coordinate{-92.69, 45.3094}}, // L.O. Simenstad Municipal Airport
    Airport{IataCode{"OER"}, CountryId{"SE"}, Coordinate{18.99, 63.4078}}, // Örnsköldsvik Airport
    Airport{IataCode{"OFI"}, CountryId{"CI"}, Coordinate{-4.05, 9.6}}, // Ouango Fitini Airport
    Airport{IataCode{"OFJ"}, CountryId{"IS"}, Coordinate{-18.6667, 66.0736}}, // Ólafsfjörður Airport
    Airport{IataCode{"OFK"}, CountryId{"US"}, Coordinate{-97.4301, 41.9846}}, // Norfolk Regional Airport
    Airport{IataCode{"OFP"}, CountryId{"US"}, Coordinate{-77.4364, 37.7089}}, // Hanover County Municipal Airport
    Airport{IataCode{"OFU"}, CountryId{"US"}, Coordinate{-169.67, -14.1844}}, // Ofu Airport
    Airport{IataCode{"OGB"}, CountryId{"US"}, Coordinate{-80.8594, 33.4569}}, // Orangeburg Municipal Airport
    Airport{IataCode{"OGD"}, CountryId{"US"}, Coordinate{-112.013, 41.1956}}, // Ogden-Hinckley Airport
    Airport{IataCode{"OGE"}, CountryId{"PG"}, Coordinate{147.333, -6.43333}}, // Ogeranang
    Airport{IataCode{"OGG"}, CountryId{"US"}, Coordinate{-156.437, 20.8938}}, // Kahului Airport
    Airport{IataCode{"OGL"}, CountryId{"GY"}, Coordinate{-58.1036, 6.80693}}, // Eugene F. Correia International Airport - Ogle
    Airport{IataCode{"OGM"}, CountryId{"PA"}, Coordinate{-77.9819, 9.12727}}, // Ustupu-Ogobsucum Airport
    Airport{IataCode{"OGN"}, CountryId{"JP"}, Coordinate{122.98, 24.4653}}, // Yonaguni Airport
    Airport{IataCode{"OGR"}, CountryId{"TD"}, Coordinate{15.3797, 10.2883}}, // Bongor Airport
    Airport{IataCode{"OGS"}, CountryId{"US"}, Coordinate{-75.4656, 44.6819}}, // Ogdensburg International Airport
    Airport{IataCode{"OGU"}, CountryId{"TR"}, Coordinate{38.0802, 40.9639}}, // Ordu Giresun Airport
    Airport{IataCode{"OGX"}, CountryId{"DZ"}, Coordinate{5.40667, 31.9314}}, // Ain Beida Airport
    Airport{IataCode{"OGZ"}, CountryId{"RU"}, Coordinate{44.6045, 43.2017}}, // Beslan Airport
    Airport{IataCode{"OHA"}, CountryId{"NZ"}, Coordinate{175.388, -40.2061}}, // RNZAF Base Ohakea
    Airport{IataCode{"OHD"}, CountryId{"MK"}, Coordinate{20.7452, 41.1811}}, // Ohrid "St. Paul the Apostle" Airport
    Airport{IataCode{"OHE"}, CountryId{"CN"}, Coordinate{122.419, 52.9241}}, // Mohe Gulian Airport
    Airport{IataCode{"OHH"}, CountryId{"RU"}, Coordinate{142.89, 53.518}}, // Okha Airport
    Airport{IataCode{"OHI"}, CountryId{"NA"}, Coordinate{15.6959, -17.7972}}, // Oshakati
    Airport{IataCode{"OHS"}, CountryId{"OM"}, Coordinate{56.6146, 24.396}}, // Sohar Airport
    Airport{IataCode{"OIC"}, CountryId{"US"}, Coordinate{-75.5242, 42.5664}}, // Lt. Warren Eaton Airport
    Airport{IataCode{"OIM"}, CountryId{"JP"}, Coordinate{139.36, 34.7819}}, // Oshima Airport
    Airport{IataCode{"OIR"}, CountryId{"JP"}, Coordinate{139.436, 42.0727}}, // Okushiri Airport
    Airport{IataCode{"OIT"}, CountryId{"JP"}, Coordinate{131.737, 33.4794}}, // Oita Airport
    Airport{IataCode{"OJA"}, CountryId{"US"}, Coordinate{-98.6686, 35.5458}}, // Thomas P. Stafford Airport
    Airport{IataCode{"OJC"}, CountryId{"US"}, Coordinate{-94.7375, 38.8475}}, // Johnson County Executive Airport
    Airport{IataCode{"OJU"}, CountryId{"ID"}, Coordinate{121.416, -0.863611}}, // Tanjung Api Airport
    Airport{IataCode{"OKA"}, CountryId{"JP"}, Coordinate{127.65, 26.208}}, // Naha Airport
    Airport{IataCode{"OKC"}, CountryId{"US"}, Coordinate{-97.6008, 35.3931}}, // Will Rogers World Airport
    Airport{IataCode{"OKD"}, CountryId{"JP"}, Coordinate{141.382, 43.1106}}, // Okadama Airport
    Airport{IataCode{"OKE"}, CountryId{"JP"}, Coordinate{128.706, 27.4317}}, // Okinoerabu Airport
    Airport{IataCode{"OKF"}, CountryId{"NA"}, Coordinate{15.9117, -19.15}}, // Okaukuejo Airport
    Airport{IataCode{"OKG"}, CountryId{"CG"}, Coordinate{15.0733, -1.44833}}, // Okoyo Airport
    Airport{IataCode{"OKI"}, CountryId{"JP"}, Coordinate{133.33, 36.1777}}, // Oki Airport
    Airport{IataCode{"OKJ"}, CountryId{"JP"}, Coordinate{133.853, 34.7602}}, // Okayama Airport
    Airport{IataCode{"OKK"}, CountryId{"US"}, Coordinate{-86.0589, 40.5281}}, // Kokomo Municipal Airport
    Airport{IataCode{"OKL"}, CountryId{"ID"}, Coordinate{140.664, -5.10161}}, // Oksibil Airport
    Airport{IataCode{"OKM"}, CountryId{"US"}, Coordinate{-95.9486, 35.6681}}, // Okmulgee Regional Airport
    Airport{IataCode{"OKN"}, CountryId{"GA"}, Coordinate{13.6728, -0.664167}}, // Okondja Airport
    Airport{IataCode{"OKP"}, CountryId{"PG"}, Coordinate{141.567, -5.46667}}, // Oksapmin
    Airport{IataCode{"OKR"}, CountryId{"AU"}, Coordinate{143.404, -9.75333}}, // Yorke Island Airport
    Airport{IataCode{"OKT"}, CountryId{"RU"}, Coordinate{53.3835, 54.4414}}, // Oktyabrsky Airport
    Airport{IataCode{"OKU"}, CountryId{"NA"}, Coordinate{17.0519, -18.8144}}, // Mokuti Lodge Airport
    Airport{IataCode{"OKV"}, CountryId{"PG"}, Coordinate{141.033, -5.55636}}, // Okao Airport
    Airport{IataCode{"OLA"}, CountryId{"NO"}, Coordinate{9.60389, 63.6992}}, // Ørland Airport
    Airport{IataCode{"OLB"}, CountryId{"IT"}, Coordinate{9.50986, 40.9}}, // Olbia Costa Smeralda Airport
    Airport{IataCode{"OLD"}, CountryId{"US"}, Coordinate{-68.6705, 44.9511}}, // Old Town Municipal Airport and Seaplane Base
    Airport{IataCode{"OLE"}, CountryId{"US"}, Coordinate{-78.3714, 42.2411}}, // Cattaraugus County-Olean Airport
    Airport{IataCode{"OLF"}, CountryId{"US"}, Coordinate{-105.575, 48.0944}}, // L. M. Clayton Airport
    Airport{IataCode{"OLH"}, CountryId{"US"}, Coordinate{-153.269, 57.2183}}, // Old Harbor Airport
    Airport{IataCode{"OLI"}, CountryId{"IS"}, Coordinate{-23.8198, 64.9127}}, // Rif Airport
    Airport{IataCode{"OLJ"}, CountryId{"VU"}, Coordinate{166.558, -14.8817}}, // Olpoi Airport
    Airport{IataCode{"OLK"}, CountryId{"PY"}, Coordinate{-57.8828, -21.0458}}, // Fuerte Olimpo Airport
    Airport{IataCode{"OLL"}, CountryId{"CG"}, Coordinate{15.9142, -1.21861}}, // Oyo Ollombo Airport
    Airport{IataCode{"OLM"}, CountryId{"US"}, Coordinate{-122.902, 46.9694}}, // Olympia Regional Airport
    Airport{IataCode{"OLO"}, CountryId{"CZ"}, Coordinate{17.2108, 49.5878}}, // Olomouc Airport
    Airport{IataCode{"OLP"}, CountryId{"AU"}, Coordinate{136.877, -30.485}}, // Olympic Dam Airport
    Airport{IataCode{"OLS"}, CountryId{"US"}, Coordinate{-110.848, 31.4178}}, // Nogales International Airport
    Airport{IataCode{"OLU"}, CountryId{"US"}, Coordinate{-97.3428, 41.4481}}, // Columbus Municipal Airport
    Airport{IataCode{"OLV"}, CountryId{"US"}, Coordinate{-89.7869, 34.9789}}, // Olive Branch Airport
    Airport{IataCode{"OLZ"}, CountryId{"RU"}, Coordinate{120.464, 60.3992}}, // Olyokminsk Airport
    Airport{IataCode{"OMA"}, CountryId{"US"}, Coordinate{-95.8988, 41.2995}}, // Eppley Airfield
    Airport{IataCode{"OMB"}, CountryId{"GA"}, Coordinate{9.26278, -1.58333}}, // Omboue Hospital Airport
    Airport{IataCode{"OMC"}, CountryId{"PH"}, Coordinate{124.566, 11.0562}}, // Ormoc Airport
    Airport{IataCode{"OMD"}, CountryId{"NA"}, Coordinate{16.4467, -28.5847}}, // Oranjemund Airport
    Airport{IataCode{"OME"}, CountryId{"US"}, Coordinate{-165.442, 64.5075}}, // Nome Airport
    Airport{IataCode{"OMG"}, CountryId{"NA"}, Coordinate{22.1889, -18.0303}}, // Omega Airport
    Airport{IataCode{"OMH"}, CountryId{"IR"}, Coordinate{45.0593, 37.6624}}, // Urmia Airport
    Airport{IataCode{"OMK"}, CountryId{"US"}, Coordinate{-119.518, 48.4642}}, // Omak Airport
    Airport{IataCode{"OMM"}, CountryId{"OM"}, Coordinate{55.1818, 18.1403}}, // Marmul, OOMX Airport
    Airport{IataCode{"OMO"}, CountryId{"BA"}, Coordinate{17.8362, 43.2901}}, // Mostar International Airport
    Airport{IataCode{"OMR"}, CountryId{"RO"}, Coordinate{21.8975, 47.0258}}, // Oradea International Airport
    Airport{IataCode{"OMS"}, CountryId{"RU"}, Coordinate{73.3159, 54.9575}}, // Omsk Tsentralny Airport
    Airport{IataCode{"OMY"}, CountryId{"KH"}, Coordinate{104.972, 13.7606}}, // Thbeng Meanchey Airport
    Airport{IataCode{"ONA"}, CountryId{"US"}, Coordinate{-91.706, 44.0732}}, // Winona Municipal Airport
    Airport{IataCode{"OND"}, CountryId{"NA"}, Coordinate{15.95, -17.8781}}, // Ondangwa Airport
    Airport{IataCode{"ONG"}, CountryId{"AU"}, Coordinate{139.17, -16.6627}}, // Mornington Island Airport
    Airport{IataCode{"ONH"}, CountryId{"US"}, Coordinate{-75.0644, 42.5247}}, // Oneonta Municipal Airport
    Airport{IataCode{"ONJ"}, CountryId{"JP"}, Coordinate{140.372, 40.1955}}, // Odate-Noshiro Airport
    Airport{IataCode{"ONK"}, CountryId{"RU"}, Coordinate{112.479, 68.5156}}, // Olenyok Airport
    Airport{IataCode{"ONL"}, CountryId{"US"}, Coordinate{-98.6872, 42.4694}}, // O'Neill Municipal Airport
    Airport{IataCode{"ONO"}, CountryId{"US"}, Coordinate{-117.013, 44.0194}}, // Ontario Municipal Airport
    Airport{IataCode{"ONP"}, CountryId{"US"}, Coordinate{-124.058, 44.5803}}, // Newport Municipal Airport
    Airport{IataCode{"ONQ"}, CountryId{"TR"}, Coordinate{32.0905, 41.5068}}, // Zonguldak Airport
    Airport{IataCode{"ONS"}, CountryId{"AU"}, Coordinate{115.113, -21.6683}}, // Onslow Airport
    Airport{IataCode{"ONT"}, CountryId{"US"}, Coordinate{-117.601, 34.0561}}, // LA/Ontario International Airport
    Airport{IataCode{"ONU"}, CountryId{"FJ"}, Coordinate{-178.741, -20.6598}}, // Ono-I-Lau Airport
    Airport{IataCode{"ONX"}, CountryId{"PA"}, Coordinate{-79.8675, 9.35667}}, // Enrique Adolfo Jiménez Airport
    Airport{IataCode{"ONZ"}, CountryId{"US"}, Coordinate{-83.1614, 42.0992}}, // Grosse Ile Municipal Airport
    Airport{IataCode{"OOD"}, CountryId{"AU"}, Coordinate{135.445, -27.56}}, // Oodnadatta Airport
    Airport{IataCode{"OOK"}, CountryId{"US"}, Coordinate{-165.087, 60.5414}}, // Toksook Bay Airport
    Airport{IataCode{"OOL"}, CountryId{"AU"}, Coordinate{153.513, -28.1667}}, // Gold Coast Airport
    Airport{IataCode{"OOM"}, CountryId{"AU"}, Coordinate{148.973, -36.3}}, // Cooma – Snowy Mountains Airport
    Airport{IataCode{"OOT"}, CountryId{"KI"}, Coordinate{175.526, -1.79639}}, // Onotoa Airport
    Airport{IataCode{"OPA"}, CountryId{"IS"}, Coordinate{-16.4667, 66.3108}}, // Kópasker Airport
    Airport{IataCode{"OPB"}, CountryId{"PG"}, Coordinate{151.667, -4.93333}}, // Open Bay
    Airport{IataCode{"OPF"}, CountryId{"US"}, Coordinate{-80.2693, 25.9079}}, // Opa-locka Airport
    Airport{IataCode{"OPI"}, CountryId{"AU"}, Coordinate{133.005, -12.3253}}, // Oenpelli Airport
    Airport{IataCode{"OPL"}, CountryId{"US"}, Coordinate{-92.0994, 30.5269}}, // St. Landry Parish Airport
    Airport{IataCode{"OPO"}, CountryId{"PT"}, Coordinate{-8.6696, 41.2371}}, // Francisco de Sá Carneiro Airport
    Airport{IataCode{"OPU"}, CountryId{"PG"}, Coordinate{142.94, -8.05117}}, // Balimo Airport
    Airport{IataCode{"OPW"}, CountryId{"NA"}, Coordinate{13.83, -18.07}}, // Opuwa Airport
    Airport{IataCode{"OQN"}, CountryId{"US"}, Coordinate{-75.5819, 39.99}}, // Brandywine Airport
    Airport{IataCode{"OQU"}, CountryId{"US"}, Coordinate{-71.4122, 41.5972}}, // Quonset State Airport
    Airport{IataCode{"ORA"}, CountryId{"AR"}, Coordinate{-64.3292, -23.1528}}, // Orán Airport
    Airport{IataCode{"ORB"}, CountryId{"SE"}, Coordinate{15.0462, 59.2275}}, // Örebro Airport
    Airport{IataCode{"ORC"}, CountryId{"CO"}, Coordinate{-71.3564, 4.78972}}, // Orocue Airport
    Airport{IataCode{"ORD"}, CountryId{"US"}, Coordinate{-87.9031, 41.9779}}, // O'Hare International Airport
    Airport{IataCode{"ORE"}, CountryId{"FR"}, Coordinate{2.16417, 47.8975}}, // Orléans – Saint-Denis-de-l'Hôtel Airport
    Airport{IataCode{"ORF"}, CountryId{"US"}, Coordinate{-76.2045, 36.8982}}, // Norfolk International Airport
    Airport{IataCode{"ORG"}, CountryId{"SR"}, Coordinate{-55.1901, 5.81147}}, // Zorg en Hoop Airport
    Airport{IataCode{"ORH"}, CountryId{"US"}, Coordinate{-71.871, 42.2707}}, // Worcester Regional Airport
    Airport{IataCode{"ORI"}, CountryId{"US"}, Coordinate{-152.846, 57.8853}}, // Port Lions Airport
    Airport{IataCode{"ORJ"}, CountryId{"GY"}, Coordinate{-60.035, 4.72528}}, // Orinduik Airport
    Airport{IataCode{"ORK"}, CountryId{"IE"}, Coordinate{-8.49005, 51.8491}}, // Cork Airport
    Airport{IataCode{"ORN"}, CountryId{"DZ"}, Coordinate{-0.604872, 35.6212}}, // Oran Ahmed Ben Bella Airport
    Airport{IataCode{"ORO"}, CountryId{"HN"}, Coordinate{-87.1356, 15.1167}}, // Yoro Airport
    Airport{IataCode{"ORP"}, CountryId{"BW"}, Coordinate{25.3178, -21.2672}}, // Orapa Airport
    Airport{IataCode{"ORT"}, CountryId{"US"}, Coordinate{-141.928, 62.9611}}, // Northway Airport
    Airport{IataCode{"ORU"}, CountryId{"BO"}, Coordinate{-67.0793, -17.9625}}, // Juan Mendoza Airport
    Airport{IataCode{"ORV"}, CountryId{"US"}, Coordinate{-161.022, 66.8175}}, // Robert (Bob) Curtis Memorial Airport
    Airport{IataCode{"ORW"}, CountryId{"PK"}, Coordinate{64.5861, 25.2747}}, // Ormara Airport
    Airport{IataCode{"ORX"}, CountryId{"BR"}, Coordinate{-55.8358, -1.71361}}, // Oriximiná Airport
    Airport{IataCode{"ORY"}, CountryId{"FR"}, Coordinate{2.36598, 48.7288}}, // Orly Airport
    Airport{IataCode{"ORZ"}, CountryId{"BZ"}, Coordinate{-88.5667, 18.0667}}, // Orange Walk Airport
    Airport{IataCode{"OSC"}, CountryId{"US"}, Coordinate{-83.3942, 44.4517}}, // Oscoda-Wurtsmith Airport
    Airport{IataCode{"OSE"}, CountryId{"PG"}, Coordinate{147.1, -7.833}}, // Omora
    Airport{IataCode{"OSF"}, CountryId{"RU"}, Coordinate{37.5107, 55.5029}}, // Ostafyevo International Airport
    Airport{IataCode{"OSH"}, CountryId{"US"}, Coordinate{-88.5516, 43.9942}}, // Wittman Regional Airport
    Airport{IataCode{"OSI"}, CountryId{"HR"}, Coordinate{18.8073, 45.4663}}, // Osijek Airport
    Airport{IataCode{"OSL"}, CountryId{"NO"}, Coordinate{11.0968, 60.1931}}, // Oslo Airport, Gardermoen
    Airport{IataCode{"OSM"}, CountryId{"IQ"}, Coordinate{43.1482, 36.2956}}, // Mosul International Airport
    Airport{IataCode{"OSO"}, CountryId{"AU"}, Coordinate{140.557, -22.0817}}, // Osborne Mine Airport
    Airport{IataCode{"OSP"}, CountryId{"PL"}, Coordinate{17.1075, 54.4789}}, // Słupsk-Redzikowo Airport
    Airport{IataCode{"OSR"}, CountryId{"CZ"}, Coordinate{18.119, 49.6936}}, // Leoš Janáček Airport Ostrava
    Airport{IataCode{"OSS"}, CountryId{"KG"}, Coordinate{72.7868, 40.6082}}, // Osh Airport
    Airport{IataCode{"OST"}, CountryId{"BE"}, Coordinate{2.86989, 51.2042}}, // Ostend-Bruges International Airport
    Airport{IataCode{"OSU"}, CountryId{"US"}, Coordinate{-83.0751, 40.0752}}, // Ohio State University Airport
    Airport{IataCode{"OSW"}, CountryId{"RU"}, Coordinate{58.5939, 51.0768}}, // Orsk Airport
    Airport{IataCode{"OSY"}, CountryId{"NO"}, Coordinate{11.6, 64.4667}}, // Namsos Airport
    Airport{IataCode{"OSZ"}, CountryId{"PL"}, Coordinate{16.2642, 54.0422}}, // Koszalin-Zegrze Pomorskie Airport
    Airport{IataCode{"OTC"}, CountryId{"TD"}, Coordinate{14.7393, 13.4433}}, // Bol Airport
    Airport{IataCode{"OTD"}, CountryId{"PA"}, Coordinate{-79.0333, 8.61667}}, // Contadora Airport
    Airport{IataCode{"OTH"}, CountryId{"US"}, Coordinate{-124.249, 43.4163}}, // Southwest Oregon Regional Airport
    Airport{IataCode{"OTI"}, CountryId{"ID"}, Coordinate{128.323, 2.04294}}, // Pitu Airport
    Airport{IataCode{"OTJ"}, CountryId{"NA"}, Coordinate{16.65, -20.4306}}, // Otjiwarongo Airport
    Airport{IataCode{"OTK"}, CountryId{"US"}, Coordinate{-123.818, 45.419}}, // Tillamook Airport
    Airport{IataCode{"OTL"}, CountryId{"MR"}, Coordinate{-14.7167, 17.533}}, // Boutilimit Airport
    Airport{IataCode{"OTM"}, CountryId{"US"}, Coordinate{-92.4445, 41.1065}}, // Ottumwa Regional Airport
    Airport{IataCode{"OTN"}, CountryId{"US"}, Coordinate{-87.4997, 38.8514}}, // Ed-Air Airport
    Airport{IataCode{"OTP"}, CountryId{"RO"}, Coordinate{26.0793, 44.5695}}, // Henri Coandă International Airport
    Airport{IataCode{"OTR"}, CountryId{"CR"}, Coordinate{-82.9667, 8.6}}, // Coto 47 Airport
    Airport{IataCode{"OTS"}, CountryId{"US"}, Coordinate{-122.662, 48.4989}}, // Anacortes Airport
    Airport{IataCode{"OTU"}, CountryId{"CO"}, Coordinate{-74.7183, 7.01056}}, // Otú Airport
    Airport{IataCode{"OTY"}, CountryId{"PG"}, Coordinate{155.7, -6.583}}, // Oria
    Airport{IataCode{"OTZ"}, CountryId{"US"}, Coordinate{-162.602, 66.8911}}, // Ralph Wien Memorial Airport
    Airport{IataCode{"OUA"}, CountryId{"BF"}, Coordinate{-1.51432, 12.3546}}, // Ouagadougou Airport
    Airport{IataCode{"OUD"}, CountryId{"MA"}, Coordinate{-1.94163, 34.7857}}, // Angads Airport
    Airport{IataCode{"OUE"}, CountryId{"CG"}, Coordinate{16.0398, 1.60863}}, // Ouésso Airport
    Airport{IataCode{"OUG"}, CountryId{"BF"}, Coordinate{-2.417, 13.567}}, // Ouahigouya Airport
    Airport{IataCode{"OUL"}, CountryId{"FI"}, Coordinate{25.3737, 64.9285}}, // Oulu Airport
    Airport{IataCode{"OUM"}, CountryId{"TD"}, Coordinate{19.2333, 13.2667}}, // Oum Hadjer Airport
    Airport{IataCode{"OUN"}, CountryId{"US"}, Coordinate{-97.4681, 35.241}}, // University of Oklahoma Westheimer Airport
    Airport{IataCode{"OUS"}, CountryId{"BR"}, Coordinate{-49.9114, -22.9736}}, // Ourinhos Airport
    Airport{IataCode{"OUT"}, CountryId{"TD"}, Coordinate{16.717, 10.483}}, // Bousso Airport
    Airport{IataCode{"OUZ"}, CountryId{"MR"}, Coordinate{-12.4719, 22.7512}}, // Tazadit Airport
    Airport{IataCode{"OVB"}, CountryId{"RU"}, Coordinate{82.6693, 55.0096}}, // Tolmachevo Airport
    Airport{IataCode{"OVD"}, CountryId{"ES"}, Coordinate{-6.03182, 43.5588}}, // Asturias Airport
    Airport{IataCode{"OVE"}, CountryId{"US"}, Coordinate{-121.622, 39.4878}}, // Oroville Municipal Airport
    Airport{IataCode{"OVL"}, CountryId{"CL"}, Coordinate{-71.1761, -30.5594}}, // El Tuqui Airport
    Airport{IataCode{"OVR"}, CountryId{"AR"}, Coordinate{-60.2231, -36.8911}}, // Olavarría Airport
    Airport{IataCode{"OVS"}, CountryId{"RU"}, Coordinate{63.6007, 61.3318}}, // Sovetsky Airport
    Airport{IataCode{"OWB"}, CountryId{"US"}, Coordinate{-87.1632, 37.7422}}, // Owensboro-Daviess County Regional Airport
    Airport{IataCode{"OWD"}, CountryId{"US"}, Coordinate{-71.1768, 42.1864}}, // Norwood Memorial Airport
    Airport{IataCode{"OWI"}, CountryId{"US"}, Coordinate{-95.2519, 38.5392}}, // Ottawa Municipal Airport
    Airport{IataCode{"OWK"}, CountryId{"US"}, Coordinate{-69.8632, 44.7178}}, // Central Maine Airport of Norridgewock
    Airport{IataCode{"OWP"}, CountryId{"US"}, Coordinate{-96.1519, 36.1753}}, // William R. Pogue Municipal Airport
    Airport{IataCode{"OXB"}, CountryId{"GW"}, Coordinate{-15.6512, 11.8889}}, // Osvaldo Vieira International Airport
    Airport{IataCode{"OXC"}, CountryId{"US"}, Coordinate{-73.1353, 41.4786}}, // Waterbury-Oxford Airport
    Airport{IataCode{"OXD"}, CountryId{"US"}, Coordinate{-84.7844, 39.5022}}, // Miami University Airport
    Airport{IataCode{"OXF"}, CountryId{"GB"}, Coordinate{-1.31578, 51.8328}}, // London Oxford Airport
    Airport{IataCode{"OYA"}, CountryId{"AR"}, Coordinate{-59.2187, -29.1059}}, // Goya Airport
    Airport{IataCode{"OYE"}, CountryId{"GA"}, Coordinate{11.5779, 1.53814}}, // Oyem Airport
    Airport{IataCode{"OYG"}, CountryId{"UG"}, Coordinate{31.7644, 3.64889}}, // Moyo Airport
    Airport{IataCode{"OYL"}, CountryId{"KE"}, Coordinate{39.102, 3.465}}, // Moyale Airport
    Airport{IataCode{"OYN"}, CountryId{"AU"}, Coordinate{142.3, -32.07}}, // Ouyen
    Airport{IataCode{"OYO"}, CountryId{"AR"}, Coordinate{-60.3275, -38.3856}}, // Tres Arroyos Airport
    Airport{IataCode{"OYP"}, CountryId{"FR"}, Coordinate{-51.8056, 3.89333}}, // Saint-Georges-de-l'Oyapock Airport
    Airport{IataCode{"OZC"}, CountryId{"PH"}, Coordinate{123.841, 8.17852}}, // Labo Airport
    Airport{IataCode{"OZG"}, CountryId{"MA"}, Coordinate{-5.85219, 30.2669}}, // Zagora Airport
    Airport{IataCode{"OZH"}, CountryId{"UA"}, Coordinate{35.302, 47.8731}}, // Zaporizhzhia International Airport
    Airport{IataCode{"OZS"}, CountryId{"US"}, Coordinate{-92.6911, 37.9739}}, // Camdenton Memorial Airport
    Airport{IataCode{"OZW"}, CountryId{"US"}, Coordinate{-83.9822, 42.6294}}, // Livingston County Spencer J. Hardy Airport
    Airport{IataCode{"OZZ"}, CountryId{"MA"}, Coordinate{-6.90836, 30.9353}}, // Ouarzazate Airport
    Airport{IataCode{"PAA"}, CountryId{"MM"}, Coordinate{97.6748, 16.8913}}, // Hpa-An Airport
    Airport{IataCode{"PAB"}, CountryId{"IN"}, Coordinate{82.1111, 21.9883}}, // Bilaspur Airport
    Airport{IataCode{"PAC"}, CountryId{"PA"}, Coordinate{-79.5599, 8.97054}}, // Albrook "Marcos A. Gelabert" International Airport
    Airport{IataCode{"PAD"}, CountryId{"DE"}, Coordinate{8.61838, 51.61}}, // Paderborn Lippstadt Airport
    Airport{IataCode{"PAE"}, CountryId{"US"}, Coordinate{-122.278, 47.9081}}, // Paine Field
    Airport{IataCode{"PAF"}, CountryId{"UG"}, Coordinate{31.5544, 2.20222}}, // Pakuba Airport
    Airport{IataCode{"PAG"}, CountryId{"PH"}, Coordinate{123.463, 7.83055}}, // Pagadian Airport
    Airport{IataCode{"PAH"}, CountryId{"US"}, Coordinate{-88.7731, 37.0603}}, // Barkley Regional Airport
    Airport{IataCode{"PAJ"}, CountryId{"PK"}, Coordinate{70.0717, 33.9057}}, // Parachinar Airport
    Airport{IataCode{"PAK"}, CountryId{"US"}, Coordinate{-159.603, 21.8969}}, // Port Allen Airport
    Airport{IataCode{"PAN"}, CountryId{"TH"}, Coordinate{101.154, 6.78546}}, // Pattani Airport
    Airport{IataCode{"PAO"}, CountryId{"US"}, Coordinate{-122.111, 37.4549}}, // Palo Alto Airport of Santa Clara County
    Airport{IataCode{"PAP"}, CountryId{"HT"}, Coordinate{-72.2901, 18.5764}}, // Toussaint Louverture International Airport
    Airport{IataCode{"PAQ"}, CountryId{"US"}, Coordinate{-149.092, 61.595}}, // Palmer Municipal Airport
    Airport{IataCode{"PAT"}, CountryId{"IN"}, Coordinate{85.091, 25.5945}}, // Lok Nayak Jayaprakash Airport
    Airport{IataCode{"PAU"}, CountryId{"MM"}, Coordinate{94.4864, 21.4489}}, // Pauk Airport
    Airport{IataCode{"PAV"}, CountryId{"BR"}, Coordinate{-38.2491, -9.39921}}, // Paulo Afonso Airport
    Airport{IataCode{"PAW"}, CountryId{"PG"}, Coordinate{151.1, -10.58}}, // Pambwa
    Airport{IataCode{"PAX"}, CountryId{"HT"}, Coordinate{-72.85, 19.9333}}, // Port-de-Paix Airport
    Airport{IataCode{"PAY"}, CountryId{"MY"}, Coordinate{117.4, 5.9993}}, // Pamol Airport
    Airport{IataCode{"PAZ"}, CountryId{"MX"}, Coordinate{-97.4606, 20.5994}}, // El Tajín National Airport
    Airport{IataCode{"PBC"}, CountryId{"MX"}, Coordinate{-98.3758, 19.1638}}, // Hermanos Serdán International Airport
    Airport{IataCode{"PBD"}, CountryId{"IN"}, Coordinate{69.661, 21.6477}}, // Porbandar Airport
    Airport{IataCode{"PBE"}, CountryId{"CO"}, Coordinate{-74.4123, 6.46414}}, // Puerto Berrio Airport
    Airport{IataCode{"PBF"}, CountryId{"US"}, Coordinate{-91.9356, 34.1744}}, // Grider Field
    Airport{IataCode{"PBG"}, CountryId{"US"}, Coordinate{-73.472, 44.6689}}, // Plattsburgh International Airport
    Airport{IataCode{"PBH"}, CountryId{"BT"}, Coordinate{89.421, 27.4052}}, // Paro Airport
    Airport{IataCode{"PBI"}, CountryId{"US"}, Coordinate{-80.0912, 26.6874}}, // Palm Beach International Airport
    Airport{IataCode{"PBJ"}, CountryId{"VU"}, Coordinate{168.236, -16.4325}}, // Paama Airport
    Airport{IataCode{"PBM"}, CountryId{"SR"}, Coordinate{-55.1998, 5.45637}}, // Johan Adolf Pengel International Airport
    Airport{IataCode{"PBN"}, CountryId{"AO"}, Coordinate{13.7657, -10.722}}, // Porto Amboim Airport
    Airport{IataCode{"PBO"}, CountryId{"AU"}, Coordinate{117.748, -23.1738}}, // Paraburdoo Airport
    Airport{IataCode{"PBP"}, CountryId{"CR"}, Coordinate{-85.3667, 9.85}}, // Punta Islita Airport
    Airport{IataCode{"PBQ"}, CountryId{"BR"}, Coordinate{-61.1811, -11.6417}}, // Pimenta Bueno Airport
    Airport{IataCode{"PBR"}, CountryId{"GT"}, Coordinate{-88.585, 15.7308}}, // Puerto Barrios Airport
    Airport{IataCode{"PBU"}, CountryId{"MM"}, Coordinate{97.4264, 27.3197}}, // Putao Airport
    Airport{IataCode{"PCA"}, CountryId{"US"}, Coordinate{-157.711, 58.9064}}, // Portage Creek Airport
    Airport{IataCode{"PCB"}, CountryId{"ID"}, Coordinate{106.765, -6.3368}}, // Pondok Cabe Airport
    Airport{IataCode{"PCC"}, CountryId{"CO"}, Coordinate{-75.1576, 1.875}}, // Puerto Rico Airport
    Airport{IataCode{"PCD"}, CountryId{"US"}, Coordinate{-91.1236, 43.0192}}, // Prairie du Chien Municipal Airport
    Airport{IataCode{"PCE"}, CountryId{"CO"}, Coordinate{-69.7815, 4.44637}}, // Cumaribo Airport
    Airport{IataCode{"PCH"}, CountryId{"HN"}, Coordinate{-84.9403, 15.9542}}, // Palacios Airport
    Airport{IataCode{"PCL"}, CountryId{"PE"}, Coordinate{-74.5739, -8.38465}}, // FAP Captain David Abensur Rengifo International Airport
    Airport{IataCode{"PCN"}, CountryId{"NZ"}, Coordinate{173.96, -41.3424}}, // Picton Aerodrome
    Airport{IataCode{"PCO"}, CountryId{"MX"}, Coordinate{-109.536, 23.575}}, // Punta Colorada Airstrip
    Airport{IataCode{"PCP"}, CountryId{"ST"}, Coordinate{7.41263, 1.66513}}, // Príncipe Airport
    Airport{IataCode{"PCR"}, CountryId{"CO"}, Coordinate{-67.4905, 6.18383}}, // Germán Olano Airport
    Airport{IataCode{"PCS"}, CountryId{"BR"}, Coordinate{-41.5194, -7.06528}}, // Picos Airport
    Airport{IataCode{"PCT"}, CountryId{"US"}, Coordinate{-74.6589, 40.3992}}, // Princeton Airport
    Airport{IataCode{"PCW"}, CountryId{"US"}, Coordinate{-82.8694, 41.5164}}, // Erie-Ottawa International Airport
    Airport{IataCode{"PCZ"}, CountryId{"US"}, Coordinate{-89.0148, 44.3299}}, // Waupaca Municipal Airport
    Airport{IataCode{"PDA"}, CountryId{"CO"}, Coordinate{-67.9077, 3.85168}}, // César Gaviria Trujillo Airport
    Airport{IataCode{"PDB"}, CountryId{"US"}, Coordinate{-154.13, 59.7972}}, // Pedro Bay Airport
    Airport{IataCode{"PDC"}, CountryId{"FR"}, Coordinate{164.999, -21.3164}}, // Mueo Airport
    Airport{IataCode{"PDD"}, CountryId{"MZ"}, Coordinate{32.8383, -26.8267}}, // Ponta do Ouro Airport
    Airport{IataCode{"PDG"}, CountryId{"ID"}, Coordinate{100.286, -0.786583}}, // Minangkabau International Airport
    Airport{IataCode{"PDK"}, CountryId{"US"}, Coordinate{-84.3019, 33.8756}}, // DeKalb-Peachtree Airport
    Airport{IataCode{"PDL"}, CountryId{"PT"}, Coordinate{-25.7032, 37.7462}}, // João Paulo II Airport
    Airport{IataCode{"PDO"}, CountryId{"ID"}, Coordinate{103.88, -3.28607}}, // Pendopo Airport
    Airport{IataCode{"PDP"}, CountryId{"UY"}, Coordinate{-55.0983, -34.8608}}, // Capitán de Corbeta Carlos A. Curbelo International Airport
    Airport{IataCode{"PDR"}, CountryId{"BR"}, Coordinate{-52.1517, -7.81278}}, // Presidente Dutra
    Airport{IataCode{"PDS"}, CountryId{"MX"}, Coordinate{-100.544, 28.6293}}, // Piedras Negras International Airport
    Airport{IataCode{"PDU"}, CountryId{"UY"}, Coordinate{-58.0622, -32.3633}}, // Paysandú Airport
    Airport{IataCode{"PDX"}, CountryId{"US"}, Coordinate{-122.593, 45.5874}}, // Portland International Airport
    Airport{IataCode{"PDZ"}, CountryId{"VE"}, Coordinate{-62.2333, 9.97778}}, // Pedernales Airport
    Airport{IataCode{"PED"}, CountryId{"CZ"}, Coordinate{15.7386, 50.0133}}, // Pardubice Airport
    Airport{IataCode{"PEE"}, CountryId{"RU"}, Coordinate{56.0146, 57.9176}}, // Bolshoye Savino Airport
    Airport{IataCode{"PEG"}, CountryId{"IT"}, Coordinate{12.5029, 43.0951}}, // Perugia San Francesco d'Assisi – Umbria International Airport
    Airport{IataCode{"PEH"}, CountryId{"AR"}, Coordinate{-61.8575, -35.8447}}, // Comodoro P. Zanni Airport
    Airport{IataCode{"PEI"}, CountryId{"CO"}, Coordinate{-75.7364, 4.81576}}, // Matecaña International Airport
    Airport{IataCode{"PEK"}, CountryId{"CN"}, Coordinate{116.587, 40.078}}, // Beijing Capital International Airport
    Airport{IataCode{"PEL"}, CountryId{"LS"}, Coordinate{28.4972, -29.1167}}, // Pelaneng Airport
    Airport{IataCode{"PEM"}, CountryId{"PE"}, Coordinate{-69.2215, -12.6037}}, // Padre Aldamiz International Airport
    Airport{IataCode{"PEN"}, CountryId{"MY"}, Coordinate{100.266, 5.29266}}, // Penang International Airport
    Airport{IataCode{"PEO"}, CountryId{"US"}, Coordinate{-77.0528, 42.6372}}, // Penn Yan Airport
    Airport{IataCode{"PEQ"}, CountryId{"US"}, Coordinate{-103.511, 31.3825}}, // Pecos Municipal Airport
    Airport{IataCode{"PER"}, CountryId{"AU"}, Coordinate{115.967, -31.9403}}, // Perth Airport
    Airport{IataCode{"PES"}, CountryId{"RU"}, Coordinate{34.1553, 61.8772}}, // Petrozavodsk Airport
    Airport{IataCode{"PET"}, CountryId{"BR"}, Coordinate{-52.3307, -31.7158}}, // Pelotas International Airport
    Airport{IataCode{"PEU"}, CountryId{"HN"}, Coordinate{-83.7831, 15.2667}}, // Puerto Lempira Airport
    Airport{IataCode{"PEV"}, CountryId{"HU"}, Coordinate{18.2335, 45.9944}}, // Pécs-Pogány International Airport
    Airport{IataCode{"PEW"}, CountryId{"PK"}, Coordinate{71.5187, 33.9897}}, // Bacha Khan International Airport
    Airport{IataCode{"PEX"}, CountryId{"RU"}, Coordinate{57.1427, 65.117}}, // Pechora Airport
    Airport{IataCode{"PEZ"}, CountryId{"RU"}, Coordinate{45.023, 53.1182}}, // Penza Airport
    Airport{IataCode{"PFB"}, CountryId{"BR"}, Coordinate{-52.3297, -28.2426}}, // Lauro Kurtz Airport
    Airport{IataCode{"PFC"}, CountryId{"US"}, Coordinate{-123.962, 45.1997}}, // Pacific City State Airport
    Airport{IataCode{"PFJ"}, CountryId{"IS"}, Coordinate{-23.9701, 65.5555}}, // Patreksfjörður Airport
    Airport{IataCode{"PFO"}, CountryId{"CY"}, Coordinate{32.4865, 34.7121}}, // Paphos International Airport
    Airport{IataCode{"PFQ"}, CountryId{"IR"}, Coordinate{47.8547, 39.6036}}, // Parsabad-Moghan Airport
    Airport{IataCode{"PFR"}, CountryId{"CD"}, Coordinate{20.6, -4.33}}, // Ilebo Airport
    Airport{IataCode{"PGA"}, CountryId{"US"}, Coordinate{-111.449, 36.9228}}, // Page Municipal Airport
    Airport{IataCode{"PGB"}, CountryId{"RS"}, Coordinate{20.1808, 44.723}}, // Progar Airport
    Airport{IataCode{"PGC"}, CountryId{"US"}, Coordinate{-79.1458, 38.995}}, // Grant County Airport
    Airport{IataCode{"PGD"}, CountryId{"US"}, Coordinate{-81.9908, 26.9189}}, // Punta Gorda Airport
    Airport{IataCode{"PGE"}, CountryId{"PG"}, Coordinate{146.15, -7.13333}}, // Yegepa
    Airport{IataCode{"PGF"}, CountryId{"FR"}, Coordinate{2.86852, 42.7408}}, // Perpignan–Rivesaltes Airport
    Airport{IataCode{"PGH"}, CountryId{"IN"}, Coordinate{79.4734, 29.031}}, // Pantnagar Airport
    Airport{IataCode{"PGI"}, CountryId{"AO"}, Coordinate{20.8035, -7.35756}}, // Chitato Airport
    Airport{IataCode{"PGK"}, CountryId{"ID"}, Coordinate{106.139, -2.16194}}, // Depati Amir Airport
    Airport{IataCode{"PGL"}, CountryId{"US"}, Coordinate{-88.527, 30.4637}}, // Trent Lott International Airport
    Airport{IataCode{"PGM"}, CountryId{"US"}, Coordinate{-151.832, 59.3483}}, // Port Graham Airport
    Airport{IataCode{"PGN"}, CountryId{"HT"}, Coordinate{-72.1186, 19.3214}}, // Pignon Airport
    Airport{IataCode{"PGO"}, CountryId{"US"}, Coordinate{-107.055, 37.2881}}, // Stevens Field
    Airport{IataCode{"PGQ"}, CountryId{"ID"}, Coordinate{128.275, 0.894141}}, // Buli Airport
    Airport{IataCode{"PGR"}, CountryId{"US"}, Coordinate{-90.5092, 36.0639}}, // Kirk Field
    Airport{IataCode{"PGS"}, CountryId{"US"}, Coordinate{-113.247, 35.5269}}, // Grand Canyon Caverns Airport
    Airport{IataCode{"PGU"}, CountryId{"IR"}, Coordinate{52.7337, 27.3868}}, // Persian Gulf Airport
    Airport{IataCode{"PGX"}, CountryId{"FR"}, Coordinate{0.812609, 45.1963}}, // Périgueux Bassillac Airport
    Airport{IataCode{"PHB"}, CountryId{"BR"}, Coordinate{-41.7299, -2.89516}}, // Parnaíba-Prefeito Dr. João Silva Filho International Airport
    Airport{IataCode{"PHC"}, CountryId{"NG"}, Coordinate{6.94944, 5.01528}}, // Port Harcourt International Airport
    Airport{IataCode{"PHD"}, CountryId{"US"}, Coordinate{-81.42, 40.4703}}, // Harry Clever Field
    Airport{IataCode{"PHE"}, CountryId{"AU"}, Coordinate{118.632, -20.3782}}, // Port Hedland International Airport
    Airport{IataCode{"PHF"}, CountryId{"US"}, Coordinate{-76.5017, 37.1321}}, // Newport News/Williamsburg International Airport
    Airport{IataCode{"PHI"}, CountryId{"BR"}, Coordinate{-45.0672, -2.48361}}, // Pinheiro Airport
    Airport{IataCode{"PHK"}, CountryId{"US"}, Coordinate{-80.6933, 26.785}}, // Palm Beach County Glades Airport
    Airport{IataCode{"PHL"}, CountryId{"US"}, Coordinate{-75.2441, 39.8774}}, // Philadelphia International Airport
    Airport{IataCode{"PHN"}, CountryId{"US"}, Coordinate{-82.5289, 42.9108}}, // St. Clair County International Airport
    Airport{IataCode{"PHO"}, CountryId{"US"}, Coordinate{-166.799, 68.3489}}, // Point Hope Airport
    Airport{IataCode{"PHQ"}, CountryId{"AU"}, Coordinate{139.923, -21.8117}}, // The Monument Airport
    Airport{IataCode{"PHR"}, CountryId{"FJ"}, Coordinate{178.05, -18.2565}}, // Pacific Harbour Airport
    Airport{IataCode{"PHS"}, CountryId{"TH"}, Coordinate{100.281, 16.7716}}, // Phitsanulok Airport
    Airport{IataCode{"PHT"}, CountryId{"US"}, Coordinate{-88.3828, 36.3383}}, // Henry County Airport
    Airport{IataCode{"PHW"}, CountryId{"ZA"}, Coordinate{31.1545, -23.9371}}, // Hendrik Van Eck Airport
    Airport{IataCode{"PHX"}, CountryId{"US"}, Coordinate{-112.012, 33.4342}}, // Phoenix Sky Harbor International Airport
    Airport{IataCode{"PHY"}, CountryId{"TH"}, Coordinate{101.195, 16.6758}}, // Phetchabun Airport
    Airport{IataCode{"PIA"}, CountryId{"US"}, Coordinate{-89.6915, 40.6663}}, // Peoria International Airport
    Airport{IataCode{"PIB"}, CountryId{"US"}, Coordinate{-89.3369, 31.4672}}, // Hattiesburg-Laurel Regional Airport
    Airport{IataCode{"PIC"}, CountryId{"GB"}, Coordinate{-72.1011, 21.8779}}, // Pine Cay Airport
    Airport{IataCode{"PID"}, CountryId{"BS"}, Coordinate{-77.2933, 25.0792}}, // New Providence Airport
    Airport{IataCode{"PIE"}, CountryId{"US"}, Coordinate{-82.6917, 27.9068}}, // St. Petersburg–Clearwater International Airport
    Airport{IataCode{"PIF"}, CountryId{"TW"}, Coordinate{120.478, 22.6953}}, // Pingtung Airport
    Airport{IataCode{"PIG"}, CountryId{"AR"}, Coordinate{-62.3819, -37.6061}}, // Pigue Airport
    Airport{IataCode{"PIH"}, CountryId{"US"}, Coordinate{-112.589, 42.9057}}, // Pocatello Regional Airport
    Airport{IataCode{"PIK"}, CountryId{"GB"}, Coordinate{-4.61056, 55.5097}}, // Glasgow Prestwick Airport
    Airport{IataCode{"PIL"}, CountryId{"PY"}, Coordinate{-58.318, -26.8815}}, // Carlos Miguel Jiménez Airport
    Airport{IataCode{"PIM"}, CountryId{"US"}, Coordinate{-84.8825, 32.8406}}, // Harris County Airport
    Airport{IataCode{"PIN"}, CountryId{"BR"}, Coordinate{-56.7711, -2.66944}}, // Parintins Airport
    Airport{IataCode{"PIO"}, CountryId{"PE"}, Coordinate{-76.2205, -13.7396}}, // Capitán FAP Renán Elías Olivera Airport
    Airport{IataCode{"PIP"}, CountryId{"US"}, Coordinate{-157.572, 57.5803}}, // Pilot Point Airport
    Airport{IataCode{"PIR"}, CountryId{"US"}, Coordinate{-100.297, 44.3831}}, // Pierre Regional Airport
    Airport{IataCode{"PIS"}, CountryId{"FR"}, Coordinate{0.31143, 46.5858}}, // Poitiers – Biard Airport
    Airport{IataCode{"PIT"}, CountryId{"US"}, Coordinate{-80.2567, 40.496}}, // Pittsburgh International Airport
    Airport{IataCode{"PIU"}, CountryId{"PE"}, Coordinate{-80.6184, -5.20622}}, // Cap. FAP Guillermo Concha Iberico International Airport
    Airport{IataCode{"PIW"}, CountryId{"CA"}, Coordinate{-97.1636, 55.5894}}, // Pikwitonei Airport
    Airport{IataCode{"PIX"}, CountryId{"PT"}, Coordinate{-28.4435, 38.5523}}, // Pico Airport
    Airport{IataCode{"PIZ"}, CountryId{"US"}, Coordinate{-163.011, 69.7322}}, // Point Lay LRRS Airport
    Airport{IataCode{"PJA"}, CountryId{"SE"}, Coordinate{23.0689, 67.2458}}, // Pajala Airport
    Airport{IataCode{"PJB"}, CountryId{"US"}, Coordinate{-111.339, 34.2569}}, // Payson Airport
    Airport{IataCode{"PJC"}, CountryId{"PY"}, Coordinate{-55.8326, -22.6408}}, // Dr. Augusto Roberto Fuster International Airport
    Airport{IataCode{"PJG"}, CountryId{"PK"}, Coordinate{64.1325, 26.9547}}, // Panjgur Airport
    Airport{IataCode{"PJM"}, CountryId{"CR"}, Coordinate{-83.3, 8.53333}}, // Puerto Jiménez Airport
    Airport{IataCode{"PKA"}, CountryId{"US"}, Coordinate{-161.778, 60.7028}}, // Napaskiak Airport
    Airport{IataCode{"PKB"}, CountryId{"US"}, Coordinate{-81.4358, 39.3448}}, // Mid-Ohio Valley Regional Airport
    Airport{IataCode{"PKC"}, CountryId{"RU"}, Coordinate{158.426, 53.1684}}, // Petropavlovsk-Kamchatsky Airport
    Airport{IataCode{"PKE"}, CountryId{"AU"}, Coordinate{148.234, -33.1317}}, // Parkes Regional Airport
    Airport{IataCode{"PKF"}, CountryId{"US"}, Coordinate{-90.4244, 45.955}}, // Park Falls Municipal Airport
    Airport{IataCode{"PKG"}, CountryId{"MY"}, Coordinate{100.554, 4.24651}}, // Pangkor Airport
    Airport{IataCode{"PKH"}, CountryId{"GR"}, Coordinate{23.149, 37.2988}}, // Porto Cheli Airport
    Airport{IataCode{"PKJ"}, CountryId{"GT"}, Coordinate{-90.7417, 15.9975}}, // Playa Grande Airport
    Airport{IataCode{"PKK"}, CountryId{"MM"}, Coordinate{95.1023, 21.3445}}, // Pakokku Airport
    Airport{IataCode{"PKN"}, CountryId{"ID"}, Coordinate{111.673, -2.705}}, // Iskandar Airport
    Airport{IataCode{"PKO"}, CountryId{"BJ"}, Coordinate{2.60917, 9.35722}}, // Parakou Airport
    Airport{IataCode{"PKP"}, CountryId{"FR"}, Coordinate{-138.811, -14.8093}}, // Puka-Puka Airport
    Airport{IataCode{"PKR"}, CountryId{"NP"}, Coordinate{83.9783, 28.1994}}, // Pokhara Airport
    Airport{IataCode{"PKT"}, CountryId{"AU"}, Coordinate{129.528, -14.2483}}, // Port Keats Airfield
    Airport{IataCode{"PKU"}, CountryId{"ID"}, Coordinate{101.448, 0.464538}}, // Sultan Syarif Kasim II Airport
    Airport{IataCode{"PKV"}, CountryId{"RU"}, Coordinate{28.3918, 57.7974}}, // Pskov Airport
    Airport{IataCode{"PKW"}, CountryId{"BW"}, Coordinate{27.8205, -22.0572}}, // Selebi-Phikwe Airport
    Airport{IataCode{"PKX"}, CountryId{"CN"}, Coordinate{116.411, 39.5092}}, // Beijing Daxing International Airport
    Airport{IataCode{"PKY"}, CountryId{"ID"}, Coordinate{113.947, -2.22806}}, // Tjilik Riwut Airport
    Airport{IataCode{"PKZ"}, CountryId{"LA"}, Coordinate{105.781, 15.1361}}, // Pakse International Airport
    Airport{IataCode{"PLD"}, CountryId{"CR"}, Coordinate{-85.4833, 9.86667}}, // Carrillo Airport
    Airport{IataCode{"PLE"}, CountryId{"PG"}, Coordinate{142.976, -5.37211}}, // Paiela Airport
    Airport{IataCode{"PLF"}, CountryId{"TD"}, Coordinate{14.925, 9.37806}}, // Pala Airport
    Airport{IataCode{"PLJ"}, CountryId{"BZ"}, Coordinate{-88.3615, 16.5375}}, // Placencia Airport
    Airport{IataCode{"PLK"}, CountryId{"US"}, Coordinate{-93.2262, 36.6229}}, // M. Graham Clark Field, Taney County Airport
    Airport{IataCode{"PLM"}, CountryId{"ID"}, Coordinate{104.705, -2.89523}}, // Sultan Mahmud Badaruddin II International Airport
    Airport{IataCode{"PLN"}, CountryId{"US"}, Coordinate{-84.786, 45.5715}}, // Pellston Regional Airport
    Airport{IataCode{"PLO"}, CountryId{"AU"}, Coordinate{135.875, -34.6037}}, // Port Lincoln Airport
    Airport{IataCode{"PLP"}, CountryId{"PA"}, Coordinate{-78.1417, 8.40667}}, // Captain Ramon Xatruch Airport
    Airport{IataCode{"PLQ"}, CountryId{"LT"}, Coordinate{21.0973, 55.9713}}, // Palanga International Airport
    Airport{IataCode{"PLR"}, CountryId{"US"}, Coordinate{-86.2492, 33.5589}}, // St. Clair County Airport
    Airport{IataCode{"PLS"}, CountryId{"TC"}, Coordinate{-72.2653, 21.7759}}, // Providenciales International Airport
    Airport{IataCode{"PLT"}, CountryId{"CO"}, Coordinate{-74.7861, 9.79852}}, // Plato Airport
    Airport{IataCode{"PLU"}, CountryId{"BR"}, Coordinate{-43.9555, -19.8515}}, // Belo Horizonte/Pampulha – Carlos Drummond de Andrade Airport
    Airport{IataCode{"PLV"}, CountryId{"UA"}, Coordinate{34.3981, 49.5743}}, // Poltava Airport
    Airport{IataCode{"PLW"}, CountryId{"ID"}, Coordinate{119.906, -0.918548}}, // Mutiara Airport
    Airport{IataCode{"PLX"}, CountryId{"KZ"}, Coordinate{80.2173, 50.3451}}, // Semey Airport
    Airport{IataCode{"PLY"}, CountryId{"US"}, Coordinate{-86.3003, 41.365}}, // Plymouth Municipal Airport (Indiana)
    Airport{IataCode{"PLZ"}, CountryId{"ZA"}, Coordinate{25.6112, -33.9842}}, // Port Elizabeth Airport
    Airport{IataCode{"PMA"}, CountryId{"TZ"}, Coordinate{39.8114, -5.25722}}, // Pemba Airport
    Airport{IataCode{"PMB"}, CountryId{"US"}, Coordinate{-97.2408, 48.9425}}, // Pembina Municipal Airport
    Airport{IataCode{"PMC"}, CountryId{"CL"}, Coordinate{-73.098, -41.4344}}, // El Tepual Airport
    Airport{IataCode{"PMD"}, CountryId{"US"}, Coordinate{-118.084, 34.6294}}, // LA/Palmdale Regional Airport
    Airport{IataCode{"PMF"}, CountryId{"IT"}, Coordinate{10.2976, 44.8214}}, // Parma Airport
    Airport{IataCode{"PMG"}, CountryId{"BR"}, Coordinate{-55.7061, -22.5518}}, // Ponta Porã International Airport
    Airport{IataCode{"PMH"}, CountryId{"US"}, Coordinate{-82.8472, 38.8406}}, // Greater Portsmouth Regional Airport
    Airport{IataCode{"PMI"}, CountryId{"ES"}, Coordinate{2.73269, 39.548}}, // Palma de Mallorca Airport
    Airport{IataCode{"PMK"}, CountryId{"AU"}, Coordinate{146.58, -18.752}}, // Palm Island Airport
    Airport{IataCode{"PML"}, CountryId{"US"}, Coordinate{-160.561, 56.006}}, // Port Moller Airport
    Airport{IataCode{"PMN"}, CountryId{"PG"}, Coordinate{149.467, -9.81667}}, // Pumani
    Airport{IataCode{"PMO"}, CountryId{"IT"}, Coordinate{13.1057, 38.1873}}, // Falcone–Borsellino Airport
    Airport{IataCode{"PMP"}, CountryId{"PG"}, Coordinate{143.545, -6.36426}}, // Pimaga Airport
    Airport{IataCode{"PMQ"}, CountryId{"AR"}, Coordinate{-70.9788, -46.5384}}, // Perito Moreno Airport
    Airport{IataCode{"PMR"}, CountryId{"NZ"}, Coordinate{175.621, -40.3233}}, // Palmerston North International Airport
    Airport{IataCode{"PMS"}, CountryId{"SY"}, Coordinate{38.3, 34.55}}, // Palmyra Airport
    Airport{IataCode{"PMV"}, CountryId{"VE"}, Coordinate{-63.9689, 10.9166}}, // Santiago Mariño Caribbean International Airport
    Airport{IataCode{"PMW"}, CountryId{"BR"}, Coordinate{-48.3578, -10.29}}, // Palmas Airport (Tocantins)
    Airport{IataCode{"PMY"}, CountryId{"AR"}, Coordinate{-65.1006, -42.7551}}, // El Tehuelche Airport
    Airport{IataCode{"PMZ"}, CountryId{"CR"}, Coordinate{-83.4686, 8.95111}}, // Palmar Sur Airport
    Airport{IataCode{"PNA"}, CountryId{"ES"}, Coordinate{-1.64022, 42.7686}}, // Pamplona Airport
    Airport{IataCode{"PNB"}, CountryId{"BR"}, Coordinate{-48.4003, -10.7169}}, // Porto Nacional Airport
    Airport{IataCode{"PNC"}, CountryId{"US"}, Coordinate{-97.0997, 36.7319}}, // Ponca City Regional Airport
    Airport{IataCode{"PND"}, CountryId{"BZ"}, Coordinate{-88.8077, 16.1021}}, // Punta Gorda Airport
    Airport{IataCode{"PNE"}, CountryId{"US"}, Coordinate{-75.0097, 40.0755}}, // Northeast Philadelphia Airport
    Airport{IataCode{"PNH"}, CountryId{"KH"}, Coordinate{104.844, 11.5535}}, // Phnom Penh International Airport
    Airport{IataCode{"PNI"}, CountryId{"FM"}, Coordinate{158.204, 6.98136}}, // Pohnpei International Airport
    Airport{IataCode{"PNK"}, CountryId{"ID"}, Coordinate{109.405, -0.147249}}, // Supadio Airport
    Airport{IataCode{"PNL"}, CountryId{"IT"}, Coordinate{11.967, 36.8183}}, // Pantelleria Airport
    Airport{IataCode{"PNM"}, CountryId{"US"}, Coordinate{-93.6083, 45.56}}, // Princeton Municipal Airport
    Airport{IataCode{"PNN"}, CountryId{"US"}, Coordinate{-67.5644, 45.2006}}, // Princeton Municipal Airport (Maine)
    Airport{IataCode{"PNP"}, CountryId{"PG"}, Coordinate{148.309, -8.80444}}, // Girua Airport
    Airport{IataCode{"PNQ"}, CountryId{"IN"}, Coordinate{73.9197, 18.5822}}, // Pune Airport
    Airport{IataCode{"PNR"}, CountryId{"CG"}, Coordinate{11.883, -4.81588}}, // Pointe Noire Airport
    Airport{IataCode{"PNS"}, CountryId{"US"}, Coordinate{-87.1866, 30.4734}}, // Pensacola International Airport
    Airport{IataCode{"PNT"}, CountryId{"CL"}, Coordinate{-72.5288, -51.668}}, // Teniente Julio Gallardo Airport
    Airport{IataCode{"PNU"}, CountryId{"US"}, Coordinate{-112.392, 37.8453}}, // Panguitch Municipal Airport
    Airport{IataCode{"PNX"}, CountryId{"US"}, Coordinate{-96.6736, 33.7142}}, // North Texas Regional Airport
    Airport{IataCode{"PNY"}, CountryId{"IN"}, Coordinate{79.815, 11.9655}}, // Pondicherry Airport
    Airport{IataCode{"PNZ"}, CountryId{"BR"}, Coordinate{-40.5656, -9.36666}}, // Petrolina Airport
    Airport{IataCode{"POA"}, CountryId{"BR"}, Coordinate{-51.1758, -29.9896}}, // Salgado Filho International Airport
    Airport{IataCode{"POC"}, CountryId{"US"}, Coordinate{-117.782, 34.0916}}, // Brackett Field
    Airport{IataCode{"POG"}, CountryId{"GA"}, Coordinate{8.75341, -0.72014}}, // Port-Gentil International Airport
    Airport{IataCode{"POI"}, CountryId{"BO"}, Coordinate{-65.7196, -19.5436}}, // Captain Nicolas Rojas Airport
    Airport{IataCode{"POJ"}, CountryId{"BR"}, Coordinate{-46.4914, -18.6722}}, // Patos de Minas Airport
    Airport{IataCode{"POL"}, CountryId{"MZ"}, Coordinate{40.5266, -12.9901}}, // Pemba Airport
    Airport{IataCode{"POM"}, CountryId{"PG"}, Coordinate{147.215, -9.43719}}, // Jacksons International Airport
    Airport{IataCode{"PON"}, CountryId{"GT"}, Coordinate{-89.4269, 16.3247}}, // Poptún Airport
    Airport{IataCode{"POP"}, CountryId{"DO"}, Coordinate{-70.5638, 19.7554}}, // Gregorio Luperón International Airport
    Airport{IataCode{"POR"}, CountryId{"FI"}, Coordinate{21.7978, 61.4614}}, // Pori Airport
    Airport{IataCode{"POS"}, CountryId{"TT"}, Coordinate{-61.3414, 10.5967}}, // Piarco International Airport
    Airport{IataCode{"POT"}, CountryId{"JM"}, Coordinate{-76.5344, 18.1986}}, // Ken Jones Aerodrome
    Airport{IataCode{"POU"}, CountryId{"US"}, Coordinate{-73.8827, 41.6244}}, // Hudson Valley Regional Airport
    Airport{IataCode{"POV"}, CountryId{"US"}, Coordinate{-81.2517, 41.2103}}, // Portage County Regional Airport
    Airport{IataCode{"POW"}, CountryId{"SI"}, Coordinate{13.6166, 45.4745}}, // Portorož Airport
    Airport{IataCode{"POX"}, CountryId{"FR"}, Coordinate{2.04228, 49.0927}}, // Pontoise – Cormeilles Aerodrome
    Airport{IataCode{"POZ"}, CountryId{"PL"}, Coordinate{16.8286, 52.4144}}, // Poznań-Ławica Airport
    Airport{IataCode{"PPB"}, CountryId{"BR"}, Coordinate{-51.4177, -22.1783}}, // Presidente Prudente Airport
    Airport{IataCode{"PPC"}, CountryId{"US"}, Coordinate{-150.644, 66.8142}}, // Prospect Creek Airport
    Airport{IataCode{"PPE"}, CountryId{"MX"}, Coordinate{-113.306, 31.352}}, // Mar de Cortés International Airport
    Airport{IataCode{"PPF"}, CountryId{"US"}, Coordinate{-95.5061, 37.3308}}, // Tri-City Airport (Kansas)
    Airport{IataCode{"PPG"}, CountryId{"US"}, Coordinate{-170.711, -14.3317}}, // Pago Pago International Airport
    Airport{IataCode{"PPI"}, CountryId{"AU"}, Coordinate{137.995, -33.2389}}, // Port Pirie Airport
    Airport{IataCode{"PPK"}, CountryId{"KZ"}, Coordinate{69.1804, 54.7785}}, // Petropavl Airport
    Airport{IataCode{"PPL"}, CountryId{"NP"}, Coordinate{86.5845, 27.5158}}, // Phaplu Airport
    Airport{IataCode{"PPM"}, CountryId{"US"}, Coordinate{-80.1111, 26.2472}}, // Pompano Beach Airpark
    Airport{IataCode{"PPN"}, CountryId{"CO"}, Coordinate{-76.6095, 2.45256}}, // Guillermo León Valencia Airport
    Airport{IataCode{"PPP"}, CountryId{"AU"}, Coordinate{148.552, -20.4893}}, // Whitsunday Coast Airport
    Airport{IataCode{"PPQ"}, CountryId{"NZ"}, Coordinate{174.988, -40.9002}}, // Kapiti Coast Airport
    Airport{IataCode{"PPS"}, CountryId{"PH"}, Coordinate{118.753, 9.74319}}, // Puerto Princesa International Airport
    Airport{IataCode{"PPT"}, CountryId{"FR"}, Coordinate{-149.611, -17.5567}}, // Faa'a International Airport
    Airport{IataCode{"PPX"}, CountryId{"PG"}, Coordinate{149.6, -9.983}}, // Param
    Airport{IataCode{"PPY"}, CountryId{"BR"}, Coordinate{-45.9205, -22.2883}}, // Pouso Alegre Airport
    Airport{IataCode{"PPZ"}, CountryId{"VE"}, Coordinate{-67.4497, 6.21944}}, // Puerto Páez Airport
    Airport{IataCode{"PQC"}, CountryId{"VN"}, Coordinate{103.998, 10.1632}}, // Phu Quoc International Airport
    Airport{IataCode{"PQM"}, CountryId{"MX"}, Coordinate{-92.0156, 17.533}}, // Palenque International Airport
    Airport{IataCode{"PQQ"}, CountryId{"AU"}, Coordinate{152.867, -31.4313}}, // Port Macquarie Airport
    Airport{IataCode{"PQS"}, CountryId{"US"}, Coordinate{-162.899, 61.9344}}, // Pilot Station Airport
    Airport{IataCode{"PRA"}, CountryId{"AR"}, Coordinate{-60.4839, -31.7894}}, // General Justo José de Urquiza Airport
    Airport{IataCode{"PRB"}, CountryId{"US"}, Coordinate{-120.627, 35.6728}}, // Paso Robles Municipal Airport
    Airport{IataCode{"PRC"}, CountryId{"US"}, Coordinate{-112.427, 34.6496}}, // Ernest A. Love Field
    Airport{IataCode{"PRG"}, CountryId{"CZ"}, Coordinate{14.2748, 50.1043}}, // Prague Václav Havel Airport
    Airport{IataCode{"PRH"}, CountryId{"TH"}, Coordinate{100.165, 18.1317}}, // Phrae Airport
    Airport{IataCode{"PRI"}, CountryId{"SC"}, Coordinate{55.6916, -4.31924}}, // Praslin Island Airport
    Airport{IataCode{"PRM"}, CountryId{"PT"}, Coordinate{-8.58003, 37.1476}}, // Portimão Airport
    Airport{IataCode{"PRN"}, CountryId{"XK"}, Coordinate{21.0296, 42.5746}}, // Pristina International Airport Adem Jashari
    Airport{IataCode{"PRO"}, CountryId{"US"}, Coordinate{-94.1597, 41.8281}}, // Perry Municipal Airport
    Airport{IataCode{"PRQ"}, CountryId{"AR"}, Coordinate{-60.4933, -26.7556}}, // Primer Teniente Jorge Eduardo Casco Airport
    Airport{IataCode{"PRR"}, CountryId{"GY"}, Coordinate{-61.0556, 5.81545}}, // Paruima Airport
    Airport{IataCode{"PRS"}, CountryId{"SB"}, Coordinate{161.425, -9.64167}}, // Marau Sound Airport
    Airport{IataCode{"PRV"}, CountryId{"CZ"}, Coordinate{17.4047, 49.4258}}, // Přerov Airport
    Airport{IataCode{"PRW"}, CountryId{"US"}, Coordinate{-90.2758, 45.5386}}, // Prentice Airport
    Airport{IataCode{"PRX"}, CountryId{"US"}, Coordinate{-95.4508, 33.6367}}, // Cox Field
    Airport{IataCode{"PRY"}, CountryId{"ZA"}, Coordinate{28.2148, -25.6574}}, // Wonderboom Airport
    Airport{IataCode{"PRZ"}, CountryId{"US"}, Coordinate{-120.904, 44.2869}}, // Prineville Airport
    Airport{IataCode{"PSA"}, CountryId{"IT"}, Coordinate{10.3976, 43.6987}}, // Pisa International Airport
    Airport{IataCode{"PSB"}, CountryId{"US"}, Coordinate{-78.0872, 40.8833}}, // Mid-State Regional Airport
    Airport{IataCode{"PSC"}, CountryId{"US"}, Coordinate{-119.115, 46.2594}}, // Tri-Cities Airport
    Airport{IataCode{"PSD"}, CountryId{"EG"}, Coordinate{32.2422, 31.2809}}, // Port Said Airport
    Airport{IataCode{"PSE"}, CountryId{"US"}, Coordinate{-66.5632, 18.0107}}, // Mercedita Airport
    Airport{IataCode{"PSF"}, CountryId{"US"}, Coordinate{-73.2929, 42.4268}}, // Pittsfield Municipal Airport
    Airport{IataCode{"PSG"}, CountryId{"US"}, Coordinate{-132.946, 56.8014}}, // Petersburg James A. Johnson Airport
    Airport{IataCode{"PSI"}, CountryId{"PK"}, Coordinate{63.3453, 25.2906}}, // Pasni Airport
    Airport{IataCode{"PSJ"}, CountryId{"ID"}, Coordinate{120.658, -1.41904}}, // Kasiguncu Airport
    Airport{IataCode{"PSK"}, CountryId{"US"}, Coordinate{-80.6786, 37.1372}}, // New River Valley Airport
    Airport{IataCode{"PSM"}, CountryId{"US"}, Coordinate{-70.8134, 43.0757}}, // Portsmouth International Airport at Pease
    Airport{IataCode{"PSO"}, CountryId{"CO"}, Coordinate{-77.2897, 1.39573}}, // Antonio Nariño Airport
    Airport{IataCode{"PSP"}, CountryId{"US"}, Coordinate{-116.503, 33.8239}}, // Palm Springs International Airport
    Airport{IataCode{"PSR"}, CountryId{"IT"}, Coordinate{14.1872, 42.4372}}, // Abruzzo Airport
    Airport{IataCode{"PSS"}, CountryId{"AR"}, Coordinate{-55.9665, -27.3916}}, // Libertador General José de San Martín Airport
    Airport{IataCode{"PST"}, CountryId{"CU"}, Coordinate{-75.6572, 20.7342}}, // Preston Airport
    Airport{IataCode{"PSU"}, CountryId{"ID"}, Coordinate{112.935, 0.838689}}, // Pangsuma Airport
    Airport{IataCode{"PSX"}, CountryId{"US"}, Coordinate{-96.2508, 28.7275}}, // Palacios Municipal Airport
    Airport{IataCode{"PSY"}, CountryId{"GB"}, Coordinate{-57.7776, -51.6857}}, // Port Stanley Airport
    Airport{IataCode{"PSZ"}, CountryId{"BO"}, Coordinate{-57.8211, -18.9815}}, // Puerto Suárez International Airport
    Airport{IataCode{"PTA"}, CountryId{"US"}, Coordinate{-154.319, 60.2044}}, // Port Alsworth Airport
    Airport{IataCode{"PTF"}, CountryId{"FJ"}, Coordinate{177.216, -17.7831}}, // Malolo Lailai Airport
    Airport{IataCode{"PTG"}, CountryId{"ZA"}, Coordinate{29.4535, -23.8588}}, // Polokwane International Airport
    Airport{IataCode{"PTH"}, CountryId{"US"}, Coordinate{-158.633, 56.9592}}, // Port Heiden Airport
    Airport{IataCode{"PTJ"}, CountryId{"AU"}, Coordinate{141.47, -38.3165}}, // Portland Airport, Australia
    Airport{IataCode{"PTK"}, CountryId{"US"}, Coordinate{-83.4236, 42.6625}}, // Oakland County International Airport
    Airport{IataCode{"PTM"}, CountryId{"VE"}, Coordinate{-70.1832, 7.56671}}, // Palmarito Airport
    Airport{IataCode{"PTN"}, CountryId{"US"}, Coordinate{-91.3389, 29.7094}}, // Harry P. Williams Memorial Airport
    Airport{IataCode{"PTO"}, CountryId{"BR"}, Coordinate{-52.6942, -26.2178}}, // Pato Branco Airport
    Airport{IataCode{"PTP"}, CountryId{"FR"}, Coordinate{-61.525, 16.2696}}, // Pointe-à-Pitre International Airport
    Airport{IataCode{"PTS"}, CountryId{"US"}, Coordinate{-94.7311, 37.4494}}, // Atkinson Municipal Airport
    Airport{IataCode{"PTT"}, CountryId{"US"}, Coordinate{-98.7469, 37.7025}}, // Pratt Regional Airport
    Airport{IataCode{"PTU"}, CountryId{"US"}, Coordinate{-161.819, 59.0114}}, // Platinum Airport
    Airport{IataCode{"PTV"}, CountryId{"US"}, Coordinate{-119.063, 36.0297}}, // Porterville Municipal Airport
    Airport{IataCode{"PTW"}, CountryId{"US"}, Coordinate{-75.5567, 40.2394}}, // Heritage Field Airport
    Airport{IataCode{"PTX"}, CountryId{"CO"}, Coordinate{-76.0875, 1.85694}}, // Contador Airport
    Airport{IataCode{"PTY"}, CountryId{"PA"}, Coordinate{-79.3836, 9.07139}}, // Tocumen International Airport
    Airport{IataCode{"PUB"}, CountryId{"US"}, Coordinate{-104.496, 38.2839}}, // Pueblo Memorial Airport
    Airport{IataCode{"PUD"}, CountryId{"AR"}, Coordinate{-65.9164, -47.7356}}, // Puerto Deseado Airport
    Airport{IataCode{"PUE"}, CountryId{"PA"}, Coordinate{-77.4174, 8.66708}}, // Puerto Obaldia Airport
    Airport{IataCode{"PUF"}, CountryId{"FR"}, Coordinate{-0.413904, 43.382}}, // Pau Pyrénées Airport
    Airport{IataCode{"PUG"}, CountryId{"AU"}, Coordinate{137.719, -32.509}}, // Port Augusta Airport
    Airport{IataCode{"PUJ"}, CountryId{"DO"}, Coordinate{-68.3656, 18.5632}}, // Punta Cana International Airport
    Airport{IataCode{"PUK"}, CountryId{"FR"}, Coordinate{-137.017, -18.2956}}, // Pukarua Airport
    Airport{IataCode{"PUM"}, CountryId{"ID"}, Coordinate{121.524, -4.34359}}, // Sangia Nibandera Airport
    Airport{IataCode{"PUN"}, CountryId{"CD"}, Coordinate{26.3333, -1.36667}}, // Punia Airport
    Airport{IataCode{"PUP"}, CountryId{"BF"}, Coordinate{-1.14847, 11.1791}}, // Pô Airport
    Airport{IataCode{"PUQ"}, CountryId{"CL"}, Coordinate{-70.8464, -53.0052}}, // Presidente Carlos Ibáñez del Campo International Airport
    Airport{IataCode{"PUR"}, CountryId{"BO"}, Coordinate{-67.5483, -11.1075}}, // Puerto Rico Airport
    Airport{IataCode{"PUS"}, CountryId{"KR"}, Coordinate{128.947, 35.1735}}, // Gimhae International Airport
    Airport{IataCode{"PUT"}, CountryId{"IN"}, Coordinate{77.7911, 14.1492}}, // Sri Sathya Sai Airport
    Airport{IataCode{"PUU"}, CountryId{"CO"}, Coordinate{-76.5022, 0.502033}}, // Tres de Mayo Airport
    Airport{IataCode{"PUW"}, CountryId{"US"}, Coordinate{-117.114, 46.7442}}, // Pullman-Moscow Regional Airport
    Airport{IataCode{"PUX"}, CountryId{"CL"}, Coordinate{-72.9468, -41.3493}}, // El Mirador Airport
    Airport{IataCode{"PUY"}, CountryId{"HR"}, Coordinate{13.9235, 44.8987}}, // Pula Airport
    Airport{IataCode{"PUZ"}, CountryId{"NI"}, Coordinate{-83.3805, 14.0421}}, // Puerto Cabezas Airport
    Airport{IataCode{"PVA"}, CountryId{"CO"}, Coordinate{-81.3594, 13.3585}}, // El Embrujo Airport
    Airport{IataCode{"PVB"}, CountryId{"US"}, Coordinate{-90.4444, 42.6894}}, // Platteville Municipal Airport
    Airport{IataCode{"PVC"}, CountryId{"US"}, Coordinate{-70.2169, 42.076}}, // Provincetown Municipal Airport
    Airport{IataCode{"PVD"}, CountryId{"US"}, Coordinate{-71.435, 41.7261}}, // T. F. Green Airport
    Airport{IataCode{"PVE"}, CountryId{"PA"}, Coordinate{-78.9533, 9.56528}}, // El Porvenir Airport
    Airport{IataCode{"PVF"}, CountryId{"US"}, Coordinate{-120.758, 38.7235}}, // Placerville Airport
    Airport{IataCode{"PVG"}, CountryId{"CN"}, Coordinate{121.805, 31.1433}}, // Shanghai Pudong International Airport
    Airport{IataCode{"PVH"}, CountryId{"BR"}, Coordinate{-63.8986, -8.71439}}, // Governador Jorge Teixeira de Oliveira International Airport
    Airport{IataCode{"PVI"}, CountryId{"BR"}, Coordinate{-52.4892, -23.0918}}, // Paranavaí Airport
    Airport{IataCode{"PVK"}, CountryId{"GR"}, Coordinate{20.7717, 38.9308}}, // Aktion National Airport
    Airport{IataCode{"PVL"}, CountryId{"US"}, Coordinate{-82.5664, 37.5617}}, // Pike County Airport
    Airport{IataCode{"PVO"}, CountryId{"EC"}, Coordinate{-80.4689, -1.04585}}, // Reales Tamarindos Airport
    Airport{IataCode{"PVR"}, CountryId{"MX"}, Coordinate{-105.254, 20.68}}, // Licenciado Gustavo Díaz Ordaz International Airport
    Airport{IataCode{"PVS"}, CountryId{"RU"}, Coordinate{-173.23, 64.384}}, // Provideniya Bay Airport
    Airport{IataCode{"PVU"}, CountryId{"US"}, Coordinate{-111.719, 40.2193}}, // Provo Municipal Airport
    Airport{IataCode{"PVW"}, CountryId{"US"}, Coordinate{-101.716, 34.1689}}, // Hale County Airport
    Airport{IataCode{"PWA"}, CountryId{"US"}, Coordinate{-97.6469, 35.5342}}, // Wiley Post Airport
    Airport{IataCode{"PWD"}, CountryId{"US"}, Coordinate{-104.523, 48.7889}}, // Sher-Wood Airport
    Airport{IataCode{"PWE"}, CountryId{"RU"}, Coordinate{170.604, 69.7884}}, // Pevek Airport
    Airport{IataCode{"PWK"}, CountryId{"US"}, Coordinate{-87.9017, 42.1142}}, // Chicago Executive Airport
    Airport{IataCode{"PWL"}, CountryId{"ID"}, Coordinate{109.416, -7.46013}}, // Wirasaba Airport
    Airport{IataCode{"PWM"}, CountryId{"US"}, Coordinate{-70.3104, 43.6481}}, // Portland International Jetport
    Airport{IataCode{"PWN"}, CountryId{"BS"}, Coordinate{-74.3464, 22.8297}}, // Pitts Town Airport
    Airport{IataCode{"PWO"}, CountryId{"CD"}, Coordinate{28.8896, -8.46853}}, // Pweto Airport
    Airport{IataCode{"PWQ"}, CountryId{"KZ"}, Coordinate{77.0697, 52.1983}}, // Pavlodar Airport
    Airport{IataCode{"PWT"}, CountryId{"US"}, Coordinate{-122.765, 47.4903}}, // Bremerton National Airport
    Airport{IataCode{"PWY"}, CountryId{"US"}, Coordinate{-109.807, 42.7956}}, // Ralph Wenz Field
    Airport{IataCode{"PXA"}, CountryId{"ID"}, Coordinate{103.381, -4.02439}}, // Atung Bungsu Airport
    Airport{IataCode{"PXE"}, CountryId{"US"}, Coordinate{-83.7672, 32.5106}}, // Perry-Houston County Airport
    Airport{IataCode{"PXH"}, CountryId{"AU"}, Coordinate{135.522, -29.7167}}, // Prominent Hill Airport
    Airport{IataCode{"PXL"}, CountryId{"US"}, Coordinate{-110.423, 35.7917}}, // Polacca Airport
    Airport{IataCode{"PXM"}, CountryId{"MX"}, Coordinate{-97.0918, 15.8749}}, // Puerto Escondido International Airport
    Airport{IataCode{"PXO"}, CountryId{"PT"}, Coordinate{-16.3455, 33.0703}}, // Porto Santo Airport
    Airport{IataCode{"PXR"}, CountryId{"TH"}, Coordinate{103.498, 14.8683}}, // Surin Pakdi Airport
    Airport{IataCode{"PXU"}, CountryId{"VN"}, Coordinate{108.019, 14.006}}, // Pleiku Airport
    Airport{IataCode{"PYA"}, CountryId{"CO"}, Coordinate{-74.457, 5.93861}}, // Velasquez Airport
    Airport{IataCode{"PYB"}, CountryId{"IN"}, Coordinate{82.5539, 18.8804}}, // Jeypore Airport
    Airport{IataCode{"PYC"}, CountryId{"PA"}, Coordinate{-78.2347, 9.30972}}, // Playón Chico Airport
    Airport{IataCode{"PYE"}, CountryId{"NZ"}, Coordinate{-158.033, -9.01444}}, // Tongareva Airport
    Airport{IataCode{"PYG"}, CountryId{"IN"}, Coordinate{88.5877, 27.2268}}, // Pakyong Airport
    Airport{IataCode{"PYH"}, CountryId{"VE"}, Coordinate{-67.6041, 5.6276}}, // Cacique Aramare Airport
    Airport{IataCode{"PYJ"}, CountryId{"RU"}, Coordinate{112.05, 66.4167}}, // Polyarny Airport
    Airport{IataCode{"PYK"}, CountryId{"IR"}, Coordinate{50.8348, 35.766}}, // Payam International Airport
    Airport{IataCode{"PYM"}, CountryId{"US"}, Coordinate{-70.7307, 41.9114}}, // Plymouth Municipal Airport
    Airport{IataCode{"PYO"}, CountryId{"EC"}, Coordinate{-75.9, 0.08333}}, // Putumayo Airport
    Airport{IataCode{"PYP"}, CountryId{"US"}, Coordinate{-85.61, 34.09}}, // Piedmont Airport
    Airport{IataCode{"PYS"}, CountryId{"US"}, Coordinate{-121.616, 39.7106}}, // Paradise Skypark
    Airport{IataCode{"PYX"}, CountryId{"TH"}, Coordinate{100.95, 12.8325}}, // Pattaya Airpark
    Airport{IataCode{"PYY"}, CountryId{"TH"}, Coordinate{98.4359, 19.3704}}, // Pai Airport
    Airport{IataCode{"PZA"}, CountryId{"CO"}, Coordinate{-71.8883, 5.87698}}, // Paz De Ariporo Airport
    Airport{IataCode{"PZB"}, CountryId{"ZA"}, Coordinate{30.3967, -29.6432}}, // Pietermaritzburg Airport
    Airport{IataCode{"PZH"}, CountryId{"PK"}, Coordinate{69.4636, 31.3583}}, // Zhob Airport
    Airport{IataCode{"PZI"}, CountryId{"CN"}, Coordinate{101.794, 26.5384}}, // Panzhihua Bao'anying Airport
    Airport{IataCode{"PZO"}, CountryId{"VE"}, Coordinate{-62.7595, 8.28669}}, // Manuel Carlos Piar Guayana Airport
    Airport{IataCode{"PZS"}, CountryId{"CL"}, Coordinate{-72.6372, -38.7669}}, // Maquehue Airport
    Airport{IataCode{"PZU"}, CountryId{"SD"}, Coordinate{37.2383, 19.4344}}, // Port Sudan New International Airport
    Airport{IataCode{"PZY"}, CountryId{"SK"}, Coordinate{17.8324, 48.6114}}, // Piešťany Airport
    Airport{IataCode{"QAJ"}, CountryId{"AE"}, Coordinate{55.9925, 25.3103}}, // Ajman International Airport
    Airport{IataCode{"QAQ"}, CountryId{"IT"}, Coordinate{13.3103, 42.3806}}, // L'Aquila Preturo Airport
    Airport{IataCode{"QAS"}, CountryId{"DZ"}, Coordinate{1.33564, 36.2148}}, // Chlef International Airport
    Airport{IataCode{"QBC"}, CountryId{"CA"}, Coordinate{-126.596, 52.3875}}, // Bella Coola Airport
    Airport{IataCode{"QBG"}, CountryId{"RS"}, Coordinate{20.6353, 44.9022}}, // Pančevo Airport
    Airport{IataCode{"QBS"}, CountryId{"IT"}, Coordinate{10.9281, 45.4719}}, // Verona Boscomantico
    Airport{IataCode{"QCN"}, CountryId{"BR"}, Coordinate{-50.8276, -29.3689}}, // Canela Airport
    Airport{IataCode{"QDC"}, CountryId{"BR"}, Coordinate{-51.606, -21.4629}}, // Dracena Airport
    Airport{IataCode{"QDF"}, CountryId{"BR"}, Coordinate{-43.7981, -20.7386}}, // Bandeirinhas/Conselheiro Lafaiete Airport
    Airport{IataCode{"QDJ"}, CountryId{"DZ"}, Coordinate{3.349, 34.6671}}, // Tsletsi Airport
    Airport{IataCode{"QDV"}, CountryId{"BR"}, Coordinate{-46.9436, -23.1817}}, // Jundiaí Airport
    Airport{IataCode{"QEO"}, CountryId{"PL"}, Coordinate{19.0019, 49.805}}, // Aleksandrowice Airport
    Airport{IataCode{"QGY"}, CountryId{"HU"}, Coordinate{17.8136, 47.6244}}, // Győr-Pér International Airport
    Airport{IataCode{"QHR"}, CountryId{"ET"}, Coordinate{39.0059, 8.7163}}, // Harar Meda Airport
    Airport{IataCode{"QJB"}, CountryId{"SA"}, Coordinate{49.405, 27.0385}}, // Jubail Airport
    Airport{IataCode{"QKE"}, CountryId{"ZM"}, Coordinate{28.3792, -14.4506}}, // Milliken Airport
    Airport{IataCode{"QKR"}, CountryId{"FR"}, Coordinate{-52.694, 5.17361}}, // Kourou Airport
    Airport{IataCode{"QKX"}, CountryId{"NO"}, Coordinate{23.0342, 69.0403}}, // Kautokeino Airport
    Airport{IataCode{"QLD"}, CountryId{"DZ"}, Coordinate{2.81447, 36.5039}}, // Blida Airport
    Airport{IataCode{"QMF"}, CountryId{"BR"}, Coordinate{-49.8322, -26.1589}}, // Mafra Airport
    Airport{IataCode{"QMH"}, CountryId{"DZ"}, Coordinate{7.25719, 35.8775}}, // Oum el Bouaghi Airport
    Airport{IataCode{"QMJ"}, CountryId{"IR"}, Coordinate{49.2686, 32.0022}}, // Masjed Soleyman Airport
    Airport{IataCode{"QNC"}, CountryId{"CH"}, Coordinate{6.86472, 46.9575}}, // Neuchâtel Airport
    Airport{IataCode{"QND"}, CountryId{"RS"}, Coordinate{19.8339, 45.3857}}, // Novi Sad Airport
    Airport{IataCode{"QNM"}, CountryId{"BE"}, Coordinate{4.76889, 50.4881}}, // Namur-Suarlee Airport
    Airport{IataCode{"QNV"}, CountryId{"BR"}, Coordinate{-57.8672, -22.7467}}, // Aeroclub, Nova Iguacu Airport
    Airport{IataCode{"QOW"}, CountryId{"NG"}, Coordinate{7.20201, 5.4279}}, // Sam Mbakwe Airport
    Airport{IataCode{"QPC"}, CountryId{"PL"}, Coordinate{19.7213, 52.5622}}, // Plock Airport
    Airport{IataCode{"QPD"}, CountryId{"CU"}, Coordinate{-83.6784, 22.4214}}, // Pinar del Río Airport
    Airport{IataCode{"QPH"}, CountryId{"BW"}, Coordinate{27.1333, -22.5636}}, // Palapye Airport
    Airport{IataCode{"QQS"}, CountryId{"US"}, Coordinate{-80.6945, 28.615}}, // Shuttle Landing Facility
    Airport{IataCode{"QRA"}, CountryId{"ZA"}, Coordinate{28.1521, -26.2397}}, // Rand Airport
    Airport{IataCode{"QRC"}, CountryId{"CL"}, Coordinate{-70.7708, -34.1678}}, // Independencia Airport
    Airport{IataCode{"QRI"}, CountryId{"TR"}, Coordinate{40.8303, 41.1736}}, // Rize–Artvin Airport
    Airport{IataCode{"QRM"}, CountryId{"AU"}, Coordinate{148.225, -32.2144}}, // Narromine Airport
    Airport{IataCode{"QRO"}, CountryId{"MX"}, Coordinate{-100.188, 20.6227}}, // Querétaro International Airport
    Airport{IataCode{"QRR"}, CountryId{"AU"}, Coordinate{147.804, -31.7318}}, // Warren Airport
    Airport{IataCode{"QRW"}, CountryId{"NG"}, Coordinate{5.81903, 5.59465}}, // Warri Airport
    Airport{IataCode{"QSA"}, CountryId{"ES"}, Coordinate{2.10503, 41.5209}}, // Sabadell Airport
    Airport{IataCode{"QSC"}, CountryId{"BR"}, Coordinate{-47.9033, -21.8764}}, // São Carlos Airport
    Airport{IataCode{"QSF"}, CountryId{"DZ"}, Coordinate{5.28861, 36.1767}}, // Ain Arnat Airport
    Airport{IataCode{"QSI"}, CountryId{"TZ"}, Coordinate{37.3256, -3.36333}}, // Moshi Airport
    Airport{IataCode{"QSN"}, CountryId{"CU"}, Coordinate{-81.9208, 22.7564}}, // San Nicolás de Bari Airport
    Airport{IataCode{"QSR"}, CountryId{"IT"}, Coordinate{14.921, 40.6204}}, // Salerno Costa d'Amalfi Airport
    Airport{IataCode{"QSX"}, CountryId{"GY"}, Coordinate{-58.5892, 6.4225}}, // New Amsterdam Airport
    Airport{IataCode{"QTR"}, CountryId{"CL"}, Coordinate{-71.5217, -32.7941}}, // Quintero Airport
    Airport{IataCode{"QUB"}, CountryId{"LY"}, Coordinate{12.8231, 26.5672}}, // Ubari Airport
    Airport{IataCode{"QUG"}, CountryId{"GB"}, Coordinate{-0.759167, 50.8594}}, // Chichester/Goodwood Airport
    Airport{IataCode{"QUO"}, CountryId{"NG"}, Coordinate{8.08973, 4.87165}}, // Akwa Ibom Airport
    Airport{IataCode{"QUT"}, CountryId{"JP"}, Coordinate{139.871, 36.5147}}, // Utsunomiya Air Field
    Airport{IataCode{"QVA"}, CountryId{"IT"}, Coordinate{8.88694, 45.7406}}, // Varese-Venegono Airport
    Airport{IataCode{"QVP"}, CountryId{"BR"}, Coordinate{-48.9842, -23.0931}}, // Avaré-Arandu Airport
    Airport{IataCode{"QWG"}, CountryId{"US"}, Coordinate{-80.67, 35.2139}}, // Wilgrove Air Park
    Airport{IataCode{"QWV"}, CountryId{"RS"}, Coordinate{20.0219, 44.2978}}, // Valjevo Airport
    Airport{IataCode{"QYO"}, CountryId{"PL"}, Coordinate{20.415, 53.7731}}, // Dajtki Airport
    Airport{IataCode{"QYR"}, CountryId{"FR"}, Coordinate{4.01949, 48.3263}}, // Troyes – Barberey Airport
    Airport{IataCode{"QYY"}, CountryId{"PL"}, Coordinate{23.1714, 53.1031}}, // Białystok-Krywlany Airport
    Airport{IataCode{"QZD"}, CountryId{"HU"}, Coordinate{20.0892, 46.2486}}, // Szeged Airport
    Airport{IataCode{"QZN"}, CountryId{"DZ"}, Coordinate{0.626956, 35.7517}}, // Relizane Airport
    Airport{IataCode{"RAA"}, CountryId{"PG"}, Coordinate{152.43, -4.21098}}, // Rakanda
    Airport{IataCode{"RAC"}, CountryId{"US"}, Coordinate{-87.8192, 42.7594}}, // John H. Batten Airport
    Airport{IataCode{"RAE"}, CountryId{"SA"}, Coordinate{41.1378, 30.9027}}, // Arar Domestic Airport
    Airport{IataCode{"RAF"}, CountryId{"AR"}, Coordinate{-61.5042, -31.2844}}, // Rafaela Aerodrome
    Airport{IataCode{"RAH"}, CountryId{"SA"}, Coordinate{43.4906, 29.6264}}, // Rafha Domestic Airport
    Airport{IataCode{"RAI"}, CountryId{"CV"}, Coordinate{-23.4864, 14.9446}}, // Praia International Airport
    Airport{IataCode{"RAJ"}, CountryId{"IN"}, Coordinate{70.7822, 22.3089}}, // Rajkot Airport
    Airport{IataCode{"RAK"}, CountryId{"MA"}, Coordinate{-8.02581, 31.6013}}, // Marrakesh Menara Airport
    Airport{IataCode{"RAL"}, CountryId{"US"}, Coordinate{-117.446, 33.9507}}, // Riverside Municipal Airport
    Airport{IataCode{"RAM"}, CountryId{"AU"}, Coordinate{134.898, -12.3567}}, // Ramingining Airport
    Airport{IataCode{"RAN"}, CountryId{"IT"}, Coordinate{12.2174, 44.3606}}, // Ravenna Airport
    Airport{IataCode{"RAO"}, CountryId{"BR"}, Coordinate{-47.7767, -21.1393}}, // Leite Lopes Airport
    Airport{IataCode{"RAP"}, CountryId{"US"}, Coordinate{-103.061, 44.0387}}, // Rapid City Regional Airport
    Airport{IataCode{"RAQ"}, CountryId{"ID"}, Coordinate{122.6, -4.8}}, // Sugimanuru Airport
    Airport{IataCode{"RAR"}, CountryId{"CK"}, Coordinate{-159.798, -21.2001}}, // Rarotonga International Airport
    Airport{IataCode{"RAS"}, CountryId{"IR"}, Coordinate{49.618, 37.3219}}, // Rasht Airport
    Airport{IataCode{"RAT"}, CountryId{"RU"}, Coordinate{77.3319, 62.1472}}, // Raduzhny Airport
    Airport{IataCode{"RAW"}, CountryId{"PG"}, Coordinate{155.57, -6.22196}}, // Arawa Airport
    Airport{IataCode{"RAX"}, CountryId{"PG"}, Coordinate{148, -9.667}}, // Oram
    Airport{IataCode{"RAZ"}, CountryId{"PK"}, Coordinate{73.7991, 33.848}}, // Rawalakot Airport
    Airport{IataCode{"RBB"}, CountryId{"BR"}, Coordinate{-59.5978, -4.40861}}, // Borba Airport
    Airport{IataCode{"RBC"}, CountryId{"AU"}, Coordinate{142.776, -34.6424}}, // Robinvale Airport
    Airport{IataCode{"RBD"}, CountryId{"US"}, Coordinate{-96.8683, 32.6808}}, // Dallas Executive Airport
    Airport{IataCode{"RBE"}, CountryId{"KH"}, Coordinate{106.984, 13.7294}}, // Ratanakiri Airport
    Airport{IataCode{"RBF"}, CountryId{"US"}, Coordinate{-116.856, 34.2639}}, // Big Bear City Airport
    Airport{IataCode{"RBG"}, CountryId{"US"}, Coordinate{-123.356, 43.2389}}, // Roseburg Regional Airport
    Airport{IataCode{"RBI"}, CountryId{"FJ"}, Coordinate{179.975, -16.5335}}, // Rabi Airport
    Airport{IataCode{"RBJ"}, CountryId{"JP"}, Coordinate{141.041, 45.4523}}, // Rebun Airport
    Airport{IataCode{"RBK"}, CountryId{"US"}, Coordinate{-117.129, 33.5742}}, // French Valley Airport
    Airport{IataCode{"RBL"}, CountryId{"US"}, Coordinate{-122.252, 40.1508}}, // Red Bluff Municipal Airport
    Airport{IataCode{"RBO"}, CountryId{"BO"}, Coordinate{-59.7633, -18.3299}}, // Robore Airport
    Airport{IataCode{"RBP"}, CountryId{"PG"}, Coordinate{149.833, -9.98333}}, // Rabaraba
    Airport{IataCode{"RBQ"}, CountryId{"BO"}, Coordinate{-67.5031, -14.4297}}, // Rurrenabaque Airport
    Airport{IataCode{"RBR"}, CountryId{"BR"}, Coordinate{-67.8973, -9.86646}}, // Rio Branco International Airport
    Airport{IataCode{"RBS"}, CountryId{"AU"}, Coordinate{148.61, -37.79}}, // Orbost Airport
    Airport{IataCode{"RBT"}, CountryId{"KE"}, Coordinate{38, 2.345}}, // Marsabit Airport
    Airport{IataCode{"RBV"}, CountryId{"SB"}, Coordinate{157.643, -8.16806}}, // Ramata Airport
    Airport{IataCode{"RBW"}, CountryId{"US"}, Coordinate{-80.6406, 32.9211}}, // Lowcountry Regional Airport
    Airport{IataCode{"RBX"}, CountryId{"SS"}, Coordinate{29.67, 6.83}}, // Rumbek Airport
    Airport{IataCode{"RBY"}, CountryId{"US"}, Coordinate{-155.47, 64.7272}}, // Ruby Airport
    Airport{IataCode{"RCB"}, CountryId{"ZA"}, Coordinate{32.0939, -28.7366}}, // Richards Bay Airport
    Airport{IataCode{"RCH"}, CountryId{"CO"}, Coordinate{-72.9193, 11.5286}}, // Almirante Padilla Airport
    Airport{IataCode{"RCL"}, CountryId{"VU"}, Coordinate{167.832, -15.4693}}, // Redcliffe Airport
    Airport{IataCode{"RCM"}, CountryId{"AU"}, Coordinate{143.115, -20.7019}}, // Richmond Airport
    Airport{IataCode{"RCP"}, CountryId{"US"}, Coordinate{-99.3047, 39.3467}}, // Rooks County Regional Airport
    Airport{IataCode{"RCQ"}, CountryId{"AR"}, Coordinate{-59.68, -29.2103}}, // Reconquista Airport
    Airport{IataCode{"RCR"}, CountryId{"US"}, Coordinate{-86.1817, 41.0656}}, // Fulton County Airport
    Airport{IataCode{"RCS"}, CountryId{"GB"}, Coordinate{0.502778, 51.3519}}, // Rochester Airport
    Airport{IataCode{"RCT"}, CountryId{"US"}, Coordinate{-85.5167, 43.9}}, // Nartron Field
    Airport{IataCode{"RCU"}, CountryId{"AR"}, Coordinate{-64.2778, -33.096}}, // Las Higueras Airport
    Airport{IataCode{"RCX"}, CountryId{"US"}, Coordinate{-91.0006, 45.4969}}, // Rusk County Airport
    Airport{IataCode{"RCY"}, CountryId{"BS"}, Coordinate{-74.8361, 23.6844}}, // Port Nelson Airport
    Airport{IataCode{"RCZ"}, CountryId{"US"}, Coordinate{-79.7597, 34.8914}}, // Richmond County Airport
    Airport{IataCode{"RDA"}, CountryId{"AU"}, Coordinate{135.201, -18.9533}}, // Rockhampton Downs Airport
    Airport{IataCode{"RDB"}, CountryId{"US"}, Coordinate{-162.899, 68.0322}}, // Red Dog Airport
    Airport{IataCode{"RDC"}, CountryId{"BR"}, Coordinate{-49.9797, -8.03111}}, // Redenção Airport
    Airport{IataCode{"RDD"}, CountryId{"US"}, Coordinate{-122.3, 40.5057}}, // Redding Municipal Airport
    Airport{IataCode{"RDG"}, CountryId{"US"}, Coordinate{-75.964, 40.3742}}, // Reading Regional Airport
    Airport{IataCode{"RDK"}, CountryId{"US"}, Coordinate{-95.2589, 41.0108}}, // Red Oak Municipal Airport
    Airport{IataCode{"RDM"}, CountryId{"US"}, Coordinate{-121.16, 44.253}}, // Roberts Field
    Airport{IataCode{"RDN"}, CountryId{"MY"}, Coordinate{103.007, 5.76528}}, // Redang Airport
    Airport{IataCode{"RDO"}, CountryId{"PL"}, Coordinate{21.2136, 51.3892}}, // Radom-Sadków Airport
    Airport{IataCode{"RDP"}, CountryId{"IN"}, Coordinate{87.2401, 23.6179}}, // Kazi Nazrul Islam Airport
    Airport{IataCode{"RDS"}, CountryId{"AR"}, Coordinate{-68.9044, -37.3906}}, // Rincón de los Sauces Airport
    Airport{IataCode{"RDT"}, CountryId{"SN"}, Coordinate{-15.6568, 16.4398}}, // Richard Toll Airport
    Airport{IataCode{"RDU"}, CountryId{"US"}, Coordinate{-78.7927, 35.8764}}, // Raleigh–Durham International Airport
    Airport{IataCode{"RDV"}, CountryId{"US"}, Coordinate{-157.35, 61.7881}}, // Red Devil Airport
    Airport{IataCode{"RDZ"}, CountryId{"FR"}, Coordinate{2.48362, 44.4105}}, // Rodez-Aveyron Airport
    Airport{IataCode{"REA"}, CountryId{"FR"}, Coordinate{-136.44, -18.4659}}, // Reao Airport
    Airport{IataCode{"REC"}, CountryId{"BR"}, Coordinate{-34.9182, -8.13245}}, // Recife/Guararapes–Gilberto Freyre International Airport
    Airport{IataCode{"RED"}, CountryId{"US"}, Coordinate{-77.6269, 40.6775}}, // Mifflin County Airport
    Airport{IataCode{"REG"}, CountryId{"IT"}, Coordinate{15.6536, 38.0741}}, // Reggio Calabria Airport
    Airport{IataCode{"REL"}, CountryId{"AR"}, Coordinate{-65.2832, -43.2097}}, // Almirante Marcos A. Zar Airport
    Airport{IataCode{"REN"}, CountryId{"RU"}, Coordinate{55.4577, 51.7914}}, // Orenburg Tsentralny Airport
    Airport{IataCode{"REO"}, CountryId{"US"}, Coordinate{-117.886, 42.5778}}, // Rome State Airport
    Airport{IataCode{"REP"}, CountryId{"KH"}, Coordinate{103.815, 13.4078}}, // Siem Reap International Airport
    Airport{IataCode{"RER"}, CountryId{"GT"}, Coordinate{-91.6972, 14.5211}}, // Retalhuleu Airport
    Airport{IataCode{"RES"}, CountryId{"AR"}, Coordinate{-59.0487, -27.445}}, // Resistencia International Airport
    Airport{IataCode{"RET"}, CountryId{"NO"}, Coordinate{12.1058, 67.5275}}, // Røst Airport
    Airport{IataCode{"REU"}, CountryId{"ES"}, Coordinate{1.15411, 41.1468}}, // Reus Airport
    Airport{IataCode{"REX"}, CountryId{"MX"}, Coordinate{-98.2286, 26.0089}}, // General Lucio Blanco International Airport
    Airport{IataCode{"REY"}, CountryId{"BO"}, Coordinate{-67.3917, -14.3233}}, // Reyes Airport
    Airport{IataCode{"REZ"}, CountryId{"BR"}, Coordinate{-44.4817, -22.4786}}, // Resende Airport
    Airport{IataCode{"RFA"}, CountryId{"CF"}, Coordinate{23.9281, 4.98957}}, // Rafaï Airport
    Airport{IataCode{"RFD"}, CountryId{"US"}, Coordinate{-89.0971, 42.2013}}, // Chicago Rockford International Airport
    Airport{IataCode{"RFI"}, CountryId{"US"}, Coordinate{-94.8517, 32.1417}}, // Rusk County Airport
    Airport{IataCode{"RFN"}, CountryId{"IS"}, Coordinate{-15.9183, 66.4064}}, // Raufarhöfn Airport
    Airport{IataCode{"RFP"}, CountryId{"FR"}, Coordinate{-151.466, -16.723}}, // Raiatea Airport
    Airport{IataCode{"RFR"}, CountryId{"CR"}, Coordinate{-83.8876, 10.3274}}, // Rio Frio / Progreso Airport
    Airport{IataCode{"RFS"}, CountryId{"NI"}, Coordinate{-84.4086, 13.8897}}, // Rosita Airport
    Airport{IataCode{"RGA"}, CountryId{"AR"}, Coordinate{-67.7535, -53.7816}}, // Rio Grande Airport
    Airport{IataCode{"RGH"}, CountryId{"IN"}, Coordinate{88.7956, 25.2617}}, // Balurghat Airport
    Airport{IataCode{"RGI"}, CountryId{"FR"}, Coordinate{-147.659, -14.9564}}, // Rangiroa Airport
    Airport{IataCode{"RGK"}, CountryId{"RU"}, Coordinate{85.8416, 51.9699}}, // Gorno-Altaysk Airport
    Airport{IataCode{"RGL"}, CountryId{"AR"}, Coordinate{-69.3063, -51.6117}}, // Piloto Civil Norberto Fernández International Airport
    Airport{IataCode{"RGN"}, CountryId{"MM"}, Coordinate{96.1347, 16.9019}}, // Yangon International Airport
    Airport{IataCode{"RGO"}, CountryId{"KP"}, Coordinate{129.649, 41.4297}}, // Chongjin Airport
    Airport{IataCode{"RGS"}, CountryId{"ES"}, Coordinate{-3.6227, 42.3548}}, // Burgos Airport
    Airport{IataCode{"RGT"}, CountryId{"ID"}, Coordinate{102.335, -0.352222}}, // Japura Airport
    Airport{IataCode{"RHD"}, CountryId{"AR"}, Coordinate{-64.9483, -27.5106}}, // Las Termas Airport
    Airport{IataCode{"RHG"}, CountryId{"RW"}, Coordinate{29.6333, -1.5}}, // Ruhengeri Airport
    Airport{IataCode{"RHI"}, CountryId{"US"}, Coordinate{-89.4613, 45.6272}}, // Rhinelander–Oneida County Airport
    Airport{IataCode{"RHO"}, CountryId{"GR"}, Coordinate{28.0861, 36.4053}}, // Rhodes International Airport
    Airport{IataCode{"RHP"}, CountryId{"NP"}, Coordinate{86.0614, 27.3939}}, // Ramechhap Airport
    Airport{IataCode{"RHT"}, CountryId{"CN"}, Coordinate{101.644, 39.2133}}, // Alxa Right Banner Badanjilin Airport
    Airport{IataCode{"RHV"}, CountryId{"US"}, Coordinate{-121.82, 37.336}}, // Reid-Hillview Airport
    Airport{IataCode{"RIB"}, CountryId{"BO"}, Coordinate{-66.1167, -11.0167}}, // Riberalta Airport
    Airport{IataCode{"RIC"}, CountryId{"US"}, Coordinate{-77.3319, 37.5074}}, // Richmond International Airport
    Airport{IataCode{"RID"}, CountryId{"US"}, Coordinate{-84.8428, 39.7561}}, // Richmond Municipal Airport
    Airport{IataCode{"RIE"}, CountryId{"US"}, Coordinate{-91.7719, 45.416}}, // Rice Lake Regional Airport
    Airport{IataCode{"RIH"}, CountryId{"PA"}, Coordinate{-80.1297, 8.38}}, // Río Hato Airport
    Airport{IataCode{"RIJ"}, CountryId{"PE"}, Coordinate{-77.16, -6.06806}}, // Juan Simons Vela Airport
    Airport{IataCode{"RIL"}, CountryId{"US"}, Coordinate{-107.727, 39.5264}}, // Garfield County Regional Airport
    Airport{IataCode{"RIN"}, CountryId{"SB"}, Coordinate{157.143, -8.12639}}, // Ringi Cove Airport
    Airport{IataCode{"RIR"}, CountryId{"US"}, Coordinate{-117.41, 33.9889}}, // Flabob Airport
    Airport{IataCode{"RIS"}, CountryId{"JP"}, Coordinate{141.184, 45.2439}}, // Rishiri Airport
    Airport{IataCode{"RIU"}, CountryId{"US"}, Coordinate{-121.103, 38.4867}}, // Rancho Murieta Airport
    Airport{IataCode{"RIW"}, CountryId{"US"}, Coordinate{-108.46, 43.0642}}, // Riverton Regional Airport
    Airport{IataCode{"RIX"}, CountryId{"LV"}, Coordinate{23.978, 56.9232}}, // Riga International Airport
    Airport{IataCode{"RIY"}, CountryId{"YE"}, Coordinate{49.3739, 14.6668}}, // Riyan Airport
    Airport{IataCode{"RIZ"}, CountryId{"CN"}, Coordinate{119.322, 35.4005}}, // Rizhao Shanzihe Airport
    Airport{IataCode{"RJA"}, CountryId{"IN"}, Coordinate{81.8214, 17.1064}}, // Rajahmundry Airport
    Airport{IataCode{"RJB"}, CountryId{"NP"}, Coordinate{86.75, 26.517}}, // Rajbiraj Airport
    Airport{IataCode{"RJH"}, CountryId{"BD"}, Coordinate{88.6139, 24.4448}}, // Shah Makhdum Airport
    Airport{IataCode{"RJI"}, CountryId{"IN"}, Coordinate{74.3152, 33.3779}}, // Rajouri Airport
    Airport{IataCode{"RJK"}, CountryId{"HR"}, Coordinate{14.5036, 45.2169}}, // Rijeka Airport
    Airport{IataCode{"RJL"}, CountryId{"ES"}, Coordinate{-2.31472, 42.456}}, // Logroño-Agoncillo Airport
    Airport{IataCode{"RJM"}, CountryId{"ID"}, Coordinate{130.776, -0.4255}}, // Marinda Airport
    Airport{IataCode{"RJN"}, CountryId{"IR"}, Coordinate{56.0486, 30.2975}}, // Rafsanjan Airport
    Airport{IataCode{"RKA"}, CountryId{"FR"}, Coordinate{-145.465, -15.4856}}, // Aratika Airport
    Airport{IataCode{"RKD"}, CountryId{"US"}, Coordinate{-69.0992, 44.06}}, // Knox County Regional Airport
    Airport{IataCode{"RKE"}, CountryId{"DK"}, Coordinate{12.1294, 55.5903}}, // Roskilde Airport
    Airport{IataCode{"RKH"}, CountryId{"US"}, Coordinate{-81.0572, 34.9839}}, // Rock Hill/York County Airport
    Airport{IataCode{"RKI"}, CountryId{"ID"}, Coordinate{99.7044, -2.1001}}, // Rokot Airport
    Airport{IataCode{"RKP"}, CountryId{"US"}, Coordinate{-97.0436, 28.0861}}, // Aransas County Airport
    Airport{IataCode{"RKR"}, CountryId{"US"}, Coordinate{-94.6211, 35.0217}}, // Robert S. Kerr Airport
    Airport{IataCode{"RKS"}, CountryId{"US"}, Coordinate{-109.069, 41.5991}}, // Southwest Wyoming Regional Airport
    Airport{IataCode{"RKT"}, CountryId{"AE"}, Coordinate{55.9427, 25.6155}}, // Ras Al Khaimah International Airport
    Airport{IataCode{"RKV"}, CountryId{"IS"}, Coordinate{-21.9463, 64.1321}}, // Reykjavík Airport
    Airport{IataCode{"RKW"}, CountryId{"US"}, Coordinate{-84.6897, 35.9222}}, // Rockwood Municipal Airport
    Airport{IataCode{"RKZ"}, CountryId{"CN"}, Coordinate{89.2982, 29.3492}}, // Shigatse Peace Airport
    Airport{IataCode{"RLD"}, CountryId{"US"}, Coordinate{-119.304, 46.3056}}, // Richland Airport
    Airport{IataCode{"RLG"}, CountryId{"DE"}, Coordinate{12.2865, 53.9139}}, // Rostock Airport
    Airport{IataCode{"RLK"}, CountryId{"CN"}, Coordinate{107.742, 40.9224}}, // Bayannur Tianjitai Airport
    Airport{IataCode{"RLO"}, CountryId{"AR"}, Coordinate{-65.1858, -32.3847}}, // Sta. Rosa De Conlara Airport
    Airport{IataCode{"RLT"}, CountryId{"NE"}, Coordinate{7.36056, 18.7886}}, // Arlit Airport
    Airport{IataCode{"RMA"}, CountryId{"AU"}, Coordinate{148.775, -26.545}}, // Roma Airport
    Airport{IataCode{"RMB"}, CountryId{"OM"}, Coordinate{55.7589, 24.2556}}, // Buraimi Airport
    Airport{IataCode{"RMD"}, CountryId{"IN"}, Coordinate{81.8183, 17.1103}}, // Ramagundam Airport
    Airport{IataCode{"RME"}, CountryId{"US"}, Coordinate{-75.4053, 43.2261}}, // Griffiss International Airport
    Airport{IataCode{"RMF"}, CountryId{"EG"}, Coordinate{34.5924, 25.5556}}, // Marsa Alam International Airport
    Airport{IataCode{"RMG"}, CountryId{"US"}, Coordinate{-85.1586, 34.3508}}, // Richard B. Russell Airport
    Airport{IataCode{"RMI"}, CountryId{"IT"}, Coordinate{12.6192, 44.0226}}, // Federico Fellini International Airport
    Airport{IataCode{"RMK"}, CountryId{"AU"}, Coordinate{140.673, -34.1967}}, // Renmark Airport
    Airport{IataCode{"RML"}, CountryId{"LK"}, Coordinate{79.8862, 6.82199}}, // Ratmalana Airport
    Airport{IataCode{"RMN"}, CountryId{"PG"}, Coordinate{141.264, -5.89646}}, // Rumginae Airport
    Airport{IataCode{"RMP"}, CountryId{"US"}, Coordinate{-150.141, 65.5078}}, // Rampart Airport
    Airport{IataCode{"RMQ"}, CountryId{"TW"}, Coordinate{120.621, 24.265}}, // Taichung Airport
    Airport{IataCode{"RMT"}, CountryId{"FR"}, Coordinate{-152.805, -22.6387}}, // Rimatara Airport
    Airport{IataCode{"RMU"}, CountryId{"ES"}, Coordinate{-1.13099, 37.8043}}, // Región de Murcia International Airport
    Airport{IataCode{"RMY"}, CountryId{"US"}, Coordinate{-120.038, 37.5095}}, // Mariposa-Yosemite Airport
    Airport{IataCode{"RNA"}, CountryId{"SB"}, Coordinate{161.979, -9.85472}}, // Ulawa Airport
    Airport{IataCode{"RNB"}, CountryId{"SE"}, Coordinate{15.2671, 56.2544}}, // Ronneby Airport
    Airport{IataCode{"RNC"}, CountryId{"US"}, Coordinate{-85.8439, 35.6986}}, // Warren County Memorial Airport
    Airport{IataCode{"RNH"}, CountryId{"US"}, Coordinate{-92.5391, 45.1478}}, // New Richmond Regional Airport
    Airport{IataCode{"RNI"}, CountryId{"NI"}, Coordinate{-83.0595, 12.1721}}, // Corn Island Airport
    Airport{IataCode{"RNJ"}, CountryId{"JP"}, Coordinate{128.402, 27.0439}}, // Yoron Airport
    Airport{IataCode{"RNL"}, CountryId{"SB"}, Coordinate{160.071, -11.5583}}, // Rennell/Tingoa Airport
    Airport{IataCode{"RNM"}, CountryId{"OM"}, Coordinate{57.0546, 21.3746}}, // Qarn Alam Airport
    Airport{IataCode{"RNN"}, CountryId{"DK"}, Coordinate{14.7497, 55.0692}}, // Bornholm Airport
    Airport{IataCode{"RNO"}, CountryId{"US"}, Coordinate{-119.774, 39.5059}}, // Reno–Tahoe International Airport
    Airport{IataCode{"RNP"}, CountryId{"MH"}, Coordinate{166.887, 11.1572}}, // Rongelap Airport
    Airport{IataCode{"RNS"}, CountryId{"FR"}, Coordinate{-1.72602, 48.0683}}, // Rennes – Saint-Jacques Airport
    Airport{IataCode{"RNT"}, CountryId{"US"}, Coordinate{-122.216, 47.4931}}, // Renton Municipal Airport
    Airport{IataCode{"RNU"}, CountryId{"MY"}, Coordinate{116.679, 5.95654}}, // Ranau Airport
    Airport{IataCode{"RNV"}, CountryId{"US"}, Coordinate{-90.7578, 33.7611}}, // Cleveland Municipal Airport
    Airport{IataCode{"RNZ"}, CountryId{"US"}, Coordinate{-87.1825, 40.9478}}, // Jasper County Airport
    Airport{IataCode{"ROA"}, CountryId{"US"}, Coordinate{-79.9715, 37.3217}}, // Roanoke–Blacksburg Regional Airport
    Airport{IataCode{"ROB"}, CountryId{"LR"}, Coordinate{-10.3533, 6.24129}}, // Roberts International Airport
    Airport{IataCode{"ROC"}, CountryId{"US"}, Coordinate{-77.6614, 43.1237}}, // Greater Rochester International Airport
    Airport{IataCode{"ROD"}, CountryId{"ZA"}, Coordinate{19.8999, -33.8124}}, // Robertson Airfield
    Airport{IataCode{"ROF"}, CountryId{"US"}, Coordinate{-122.546, 41.7303}}, // Montague Airport
    Airport{IataCode{"ROG"}, CountryId{"US"}, Coordinate{-94.1069, 36.3725}}, // Rogers Municipal Airport
    Airport{IataCode{"ROI"}, CountryId{"TH"}, Coordinate{103.65, 16.0667}}, // Roi Et Airport
    Airport{IataCode{"ROK"}, CountryId{"AU"}, Coordinate{150.478, -23.3781}}, // Rockhampton Airport
    Airport{IataCode{"RON"}, CountryId{"CO"}, Coordinate{-73.1057, 5.76441}}, // Juan José Rondón Airport
    Airport{IataCode{"ROO"}, CountryId{"BR"}, Coordinate{-62.7092, -16.5853}}, // Rondonópolis Airport
    Airport{IataCode{"ROP"}, CountryId{"US"}, Coordinate{145.244, 14.1718}}, // Rota International Airport
    Airport{IataCode{"ROR"}, CountryId{"PW"}, Coordinate{134.533, 7.36456}}, // Roman Tmetuchl International Airport
    Airport{IataCode{"ROS"}, CountryId{"AR"}, Coordinate{-60.7804, -32.9166}}, // Rosario – Islas Malvinas International Airport
    Airport{IataCode{"ROT"}, CountryId{"NZ"}, Coordinate{176.317, -38.1092}}, // Rotorua International Airport
    Airport{IataCode{"ROV"}, CountryId{"RU"}, Coordinate{39.924, 47.4716}}, // Platov International Airport
    Airport{IataCode{"ROW"}, CountryId{"US"}, Coordinate{-104.531, 33.3016}}, // Roswell International Air Center
    Airport{IataCode{"ROY"}, CountryId{"AR"}, Coordinate{-70.2594, -45.7056}}, // Río Mayo Airport
    Airport{IataCode{"RPA"}, CountryId{"NP"}, Coordinate{82.65, 28.7}}, // Rolpa
    Airport{IataCode{"RPB"}, CountryId{"US"}, Coordinate{-97.6597, 39.8178}}, // Belleville Municipal Airport
    Airport{IataCode{"RPJ"}, CountryId{"US"}, Coordinate{-89.0783, 41.8931}}, // Rochelle Municipal Airport
    Airport{IataCode{"RPM"}, CountryId{"AU"}, Coordinate{134.747, -14.7228}}, // Ngukurr Airport
    Airport{IataCode{"RPN"}, CountryId{"IL"}, Coordinate{35.5731, 32.9769}}, // Rosh Pina Airport
    Airport{IataCode{"RPR"}, CountryId{"IN"}, Coordinate{81.7403, 21.186}}, // Swami Vivekananda Airport
    Airport{IataCode{"RPX"}, CountryId{"US"}, Coordinate{-108.543, 46.475}}, // Roundup Airport
    Airport{IataCode{"RQE"}, CountryId{"US"}, Coordinate{-109.067, 35.6519}}, // Window Rock Airport
    Airport{IataCode{"RQO"}, CountryId{"US"}, Coordinate{-98.0058, 35.4728}}, // El Reno Regional Airport
    Airport{IataCode{"RRG"}, CountryId{"MU"}, Coordinate{63.3582, -19.7541}}, // Sir Gaëtan Duval Airport
    Airport{IataCode{"RRK"}, CountryId{"IN"}, Coordinate{84.8165, 22.2536}}, // Rourkela Airport
    Airport{IataCode{"RRL"}, CountryId{"US"}, Coordinate{-89.7128, 45.1989}}, // Merrill Municipal Airport
    Airport{IataCode{"RRR"}, CountryId{"FR"}, Coordinate{-142.476, -16.0449}}, // Raroia Airport
    Airport{IataCode{"RRS"}, CountryId{"NO"}, Coordinate{11.3423, 62.5784}}, // Røros Airport
    Airport{IataCode{"RRT"}, CountryId{"US"}, Coordinate{-95.3483, 48.9414}}, // Warroad International Airport
    Airport{IataCode{"RSA"}, CountryId{"AR"}, Coordinate{-64.2795, -36.5918}}, // Santa Rosa Airport
    Airport{IataCode{"RSD"}, CountryId{"BS"}, Coordinate{-76.1689, 24.8891}}, // Rock Sound International Airport
    Airport{IataCode{"RSE"}, CountryId{"AU"}, Coordinate{151.255, -33.8706}}, // Rose Bay Water Airport
    Airport{IataCode{"RSH"}, CountryId{"US"}, Coordinate{-161.319, 61.775}}, // Russian Mission Airport
    Airport{IataCode{"RSN"}, CountryId{"US"}, Coordinate{-92.5883, 32.5147}}, // Ruston Regional Airport
    Airport{IataCode{"RST"}, CountryId{"US"}, Coordinate{-92.4919, 43.9113}}, // Rochester International Airport
    Airport{IataCode{"RSU"}, CountryId{"KR"}, Coordinate{127.614, 34.8403}}, // Yeosu Airport
    Airport{IataCode{"RSV"}, CountryId{"US"}, Coordinate{-87.6497, 39.0161}}, // Crawford County Airport
    Airport{IataCode{"RSW"}, CountryId{"US"}, Coordinate{-81.7535, 26.5277}}, // Southwest Florida International Airport
    Airport{IataCode{"RTA"}, CountryId{"FJ"}, Coordinate{177.071, -12.482}}, // Rotuma Airport
    Airport{IataCode{"RTB"}, CountryId{"HN"}, Coordinate{-86.5269, 16.318}}, // Juan Manuel Gálvez International Airport
    Airport{IataCode{"RTC"}, CountryId{"IN"}, Coordinate{73.3278, 17.0136}}, // Ratnagiri Airport
    Airport{IataCode{"RTI"}, CountryId{"ID"}, Coordinate{123.074, -10.7664}}, // David Constantijn Saudale Airport
    Airport{IataCode{"RTL"}, CountryId{"US"}, Coordinate{-95.1392, 43.3708}}, // Spirit Lake Municipal Airport
    Airport{IataCode{"RTM"}, CountryId{"NL"}, Coordinate{4.43389, 51.9491}}, // Rotterdam The Hague Airport
    Airport{IataCode{"RTN"}, CountryId{"US"}, Coordinate{-104.502, 36.7417}}, // Raton Municipal Airport
    Airport{IataCode{"RTS"}, CountryId{"AU"}, Coordinate{115.543, -32.0048}}, // Rottnest Island Airport
    Airport{IataCode{"RUA"}, CountryId{"UG"}, Coordinate{30.9122, 3.04722}}, // Arua Airport
    Airport{IataCode{"RUD"}, CountryId{"IR"}, Coordinate{55.0948, 36.4266}}, // Shahroud Airport
    Airport{IataCode{"RUE"}, CountryId{"CD"}, Coordinate{29.3134, 0.116025}}, // Rughenda Airport
    Airport{IataCode{"RUG"}, CountryId{"US"}, Coordinate{-100.024, 48.3903}}, // Rugby Municipal Airport
    Airport{IataCode{"RUH"}, CountryId{"SA"}, Coordinate{46.71, 24.9423}}, // King Khalid International Airport
    Airport{IataCode{"RUI"}, CountryId{"US"}, Coordinate{-105.535, 33.4628}}, // Sierra Blanca Regional Airport
    Airport{IataCode{"RUK"}, CountryId{"NP"}, Coordinate{82.1933, 28.6275}}, // Rukumkot Airport
    Airport{IataCode{"RUL"}, CountryId{"MV"}, Coordinate{73.5114, 0.336667}}, // Maavaarulaa Airport
    Airport{IataCode{"RUM"}, CountryId{"NP"}, Coordinate{86.5506, 27.3036}}, // Rumjatar Airport
    Airport{IataCode{"RUN"}, CountryId{"FR"}, Coordinate{55.5143, -20.8929}}, // Roland Garros Airport
    Airport{IataCode{"RUP"}, CountryId{"IN"}, Coordinate{89.9067, 26.1411}}, // Rupsi Airport
    Airport{IataCode{"RUR"}, CountryId{"FR"}, Coordinate{-151.368, -22.4335}}, // Rurutu Airport
    Airport{IataCode{"RUS"}, CountryId{"SB"}, Coordinate{160.825, -9.86167}}, // Marau Airport
    Airport{IataCode{"RUT"}, CountryId{"US"}, Coordinate{-72.9497, 43.53}}, // Rutland Southern Vermont Regional Airport
    Airport{IataCode{"RUU"}, CountryId{"PG"}, Coordinate{144.25, -5.3}}, // Ruti
    Airport{IataCode{"RUV"}, CountryId{"GT"}, Coordinate{-90.4453, 15.9919}}, // Rubelsanto Airport
    Airport{IataCode{"RUY"}, CountryId{"HN"}, Coordinate{-89.1736, 14.8256}}, // Ruinas de Copan Airport
    Airport{IataCode{"RVA"}, CountryId{"MG"}, Coordinate{47.8203, -22.8067}}, // Farafangana Airport
    Airport{IataCode{"RVD"}, CountryId{"BR"}, Coordinate{-50.9586, -17.8366}}, // Rio Verde Airport
    Airport{IataCode{"RVE"}, CountryId{"CO"}, Coordinate{-71.9, 6.91667}}, // Los Colonizadores Airport
    Airport{IataCode{"RVH"}, CountryId{"RU"}, Coordinate{30.5883, 59.98}}, // Rzhevka Airport
    Airport{IataCode{"RVK"}, CountryId{"NO"}, Coordinate{11.1461, 64.8383}}, // Rørvik Airport
    Airport{IataCode{"RVN"}, CountryId{"FI"}, Coordinate{25.8308, 66.5617}}, // Rovaniemi Airport
    Airport{IataCode{"RVR"}, CountryId{"US"}, Coordinate{-110.228, 38.9614}}, // Green River Municipal Airport
    Airport{IataCode{"RVS"}, CountryId{"US"}, Coordinate{-95.9886, 36.0402}}, // Richard Lloyd Jones Jr. Airport
    Airport{IataCode{"RVT"}, CountryId{"AU"}, Coordinate{120.212, -33.7929}}, // Ravensthorpe Airport
    Airport{IataCode{"RVV"}, CountryId{"FR"}, Coordinate{-147.7, -23.8861}}, // Raivavae Airport
    Airport{IataCode{"RVY"}, CountryId{"UY"}, Coordinate{-55.4738, -30.9692}}, // Rivera International Airport
    Airport{IataCode{"RWI"}, CountryId{"US"}, Coordinate{-77.8919, 35.8564}}, // Rocky Mount-Wilson Regional Airport
    Airport{IataCode{"RWL"}, CountryId{"US"}, Coordinate{-107.2, 41.8056}}, // Rawlins Municipal Airport
    Airport{IataCode{"RWN"}, CountryId{"UA"}, Coordinate{26.1556, 50.5958}}, // Rivne International Airport
    Airport{IataCode{"RWV"}, CountryId{"US"}, Coordinate{-96.7042, 30.5156}}, // Caldwell Municipal Airport
    Airport{IataCode{"RXE"}, CountryId{"US"}, Coordinate{-111.805, 43.8339}}, // Rexburg-Madison County Airport
    Airport{IataCode{"RXS"}, CountryId{"PH"}, Coordinate{122.749, 11.6007}}, // Roxas Airport
    Airport{IataCode{"RYB"}, CountryId{"RU"}, Coordinate{38.925, 58.1017}}, // Staroselye Airport
    Airport{IataCode{"RYG"}, CountryId{"NO"}, Coordinate{10.7856, 59.3789}}, // Moss Airport, Rygge
    Airport{IataCode{"RYK"}, CountryId{"PK"}, Coordinate{70.2864, 28.3918}}, // Shaikh Zayed International Airport
    Airport{IataCode{"RYO"}, CountryId{"AR"}, Coordinate{-72.2277, -51.6041}}, // Rio Turbio Airport
    Airport{IataCode{"RYV"}, CountryId{"US"}, Coordinate{-88.7233, 43.1697}}, // Watertown Municipal Airport
    Airport{IataCode{"RYY"}, CountryId{"US"}, Coordinate{-84.5986, 34.0131}}, // Cobb County Airport
    Airport{IataCode{"RZA"}, CountryId{"AR"}, Coordinate{-68.5777, -50.0214}}, // Santa Cruz Airport, Argentina
    Airport{IataCode{"RZE"}, CountryId{"PL"}, Coordinate{22.0245, 50.1148}}, // Rzeszów-Jasionka Airport
    Airport{IataCode{"RZN"}, CountryId{"RU"}, Coordinate{39.855, 54.555}}, // Turlatovo Airport
    Airport{IataCode{"RZP"}, CountryId{"PH"}, Coordinate{119.508, 10.8189}}, // Taytay Airport
    Airport{IataCode{"RZR"}, CountryId{"IR"}, Coordinate{50.6796, 36.905}}, // Ramsar Airport
    Airport{IataCode{"RZS"}, CountryId{"PK"}, Coordinate{68.8739, 26.9594}}, // Sawan Airport
    Airport{IataCode{"SAA"}, CountryId{"US"}, Coordinate{-106.824, 41.4447}}, // Shively Field
    Airport{IataCode{"SAB"}, CountryId{"NL"}, Coordinate{-63.2207, 17.6447}}, // Juancho E. Yrausquin Airport
    Airport{IataCode{"SAC"}, CountryId{"US"}, Coordinate{-121.493, 38.5125}}, // Sacramento Executive Airport
    Airport{IataCode{"SAD"}, CountryId{"US"}, Coordinate{-109.635, 32.8533}}, // Safford Regional Airport
    Airport{IataCode{"SAF"}, CountryId{"US"}, Coordinate{-106.089, 35.6172}}, // Santa Fe Municipal Airport
    Airport{IataCode{"SAG"}, CountryId{"IN"}, Coordinate{74.3946, 19.694}}, // Shirdi Airport
    Airport{IataCode{"SAH"}, CountryId{"YE"}, Coordinate{44.2197, 15.4764}}, // Sana'a International Airport
    Airport{IataCode{"SAK"}, CountryId{"IS"}, Coordinate{-19.5728, 65.7317}}, // Sauðárkrókur Airport
    Airport{IataCode{"SAL"}, CountryId{"SV"}, Coordinate{-89.0581, 13.4443}}, // Monseñor Óscar Arnulfo Romero International Airport
    Airport{IataCode{"SAM"}, CountryId{"PG"}, Coordinate{150.789, -9.67133}}, // Salamo Airport
    Airport{IataCode{"SAN"}, CountryId{"US"}, Coordinate{-117.201, 32.7327}}, // San Diego International Airport
    Airport{IataCode{"SAP"}, CountryId{"HN"}, Coordinate{-87.9271, 15.4557}}, // Ramón Villeda Morales International Airport
    Airport{IataCode{"SAQ"}, CountryId{"BS"}, Coordinate{-78.05, 25.05}}, // San Andros Airport
    Airport{IataCode{"SAS"}, CountryId{"US"}, Coordinate{-115.952, 33.2411}}, // Salton Sea Airport
    Airport{IataCode{"SAT"}, CountryId{"US"}, Coordinate{-98.472, 29.527}}, // San Antonio International Airport
    Airport{IataCode{"SAU"}, CountryId{"ID"}, Coordinate{121.898, -10.4278}}, // Tardamu Airport
    Airport{IataCode{"SAV"}, CountryId{"US"}, Coordinate{-81.2083, 32.1355}}, // Savannah/Hilton Head International Airport
    Airport{IataCode{"SAW"}, CountryId{"TR"}, Coordinate{29.3115, 40.9066}}, // Istanbul Sabiha Gökçen International Airport
    Airport{IataCode{"SAZ"}, CountryId{"LR"}, Coordinate{-8.43333, 4.66667}}, // Sasstown Airport
    Airport{IataCode{"SBA"}, CountryId{"US"}, Coordinate{-119.837, 34.4247}}, // Santa Barbara Municipal Airport
    Airport{IataCode{"SBB"}, CountryId{"VE"}, Coordinate{-71.1665, 7.80278}}, // Santa Barbara De Barinas Airport
    Airport{IataCode{"SBC"}, CountryId{"PG"}, Coordinate{141.75, -5.31667}}, // Selbang
    Airport{IataCode{"SBD"}, CountryId{"US"}, Coordinate{-117.235, 34.0953}}, // San Bernardino International Airport
    Airport{IataCode{"SBF"}, CountryId{"AF"}, Coordinate{68.6365, 33.321}}, // Sardeh Band Airport
    Airport{IataCode{"SBG"}, CountryId{"ID"}, Coordinate{95.3417, 5.87153}}, // Maimun Saleh Airport
    Airport{IataCode{"SBH"}, CountryId{"FR"}, Coordinate{-62.845, 17.9035}}, // Gustaf III Airport
    Airport{IataCode{"SBI"}, CountryId{"GN"}, Coordinate{-13.3671, 12.5751}}, // Sambailo Airport
    Airport{IataCode{"SBK"}, CountryId{"FR"}, Coordinate{-2.85476, 48.5348}}, // Saint-Brieuc – Armor Airport
    Airport{IataCode{"SBM"}, CountryId{"US"}, Coordinate{-87.8526, 43.7643}}, // Sheboygan County Memorial Airport
    Airport{IataCode{"SBN"}, CountryId{"US"}, Coordinate{-86.311, 41.7008}}, // South Bend Regional Airport
    Airport{IataCode{"SBO"}, CountryId{"US"}, Coordinate{-111.838, 39.0292}}, // Salina-Gunnison Airport
    Airport{IataCode{"SBP"}, CountryId{"US"}, Coordinate{-120.638, 35.2392}}, // San Luis Obispo County Regional Airport
    Airport{IataCode{"SBQ"}, CountryId{"PK"}, Coordinate{67.848, 29.5692}}, // Sibi Airport
    Airport{IataCode{"SBR"}, CountryId{"AU"}, Coordinate{142.625, -9.37833}}, // Saibai Island Airport
    Airport{IataCode{"SBS"}, CountryId{"US"}, Coordinate{-106.866, 40.5161}}, // Steamboat Springs Airport
    Airport{IataCode{"SBT"}, CountryId{"RU"}, Coordinate{72.0471, 71.2192}}, // Sabetta International Airport
    Airport{IataCode{"SBU"}, CountryId{"ZA"}, Coordinate{17.9389, -29.6894}}, // Springbok Airport
    Airport{IataCode{"SBV"}, CountryId{"PG"}, Coordinate{155.05, -5.58333}}, // Sabah
    Airport{IataCode{"SBW"}, CountryId{"MY"}, Coordinate{111.986, 2.25633}}, // Sibu Airport
    Airport{IataCode{"SBX"}, CountryId{"US"}, Coordinate{-111.867, 48.5405}}, // Shelby Airport
    Airport{IataCode{"SBY"}, CountryId{"US"}, Coordinate{-75.5171, 38.3434}}, // Salisbury–Ocean City–Wicomico Regional Airport
    Airport{IataCode{"SBZ"}, CountryId{"RO"}, Coordinate{24.095, 45.7891}}, // Sibiu International Airport
    Airport{IataCode{"SCB"}, CountryId{"US"}, Coordinate{-96.63, 41.6103}}, // Scribner State Airport
    Airport{IataCode{"SCC"}, CountryId{"US"}, Coordinate{-148.465, 70.1947}}, // Deadhorse Airport
    Airport{IataCode{"SCD"}, CountryId{"US"}, Coordinate{-86.3056, 33.1719}}, // Sylacauga Municipal Airport
    Airport{IataCode{"SCE"}, CountryId{"US"}, Coordinate{-77.8508, 40.8513}}, // University Park Airport
    Airport{IataCode{"SCF"}, CountryId{"US"}, Coordinate{-111.911, 33.6228}}, // Scottsdale Airport
    Airport{IataCode{"SCH"}, CountryId{"US"}, Coordinate{-73.9289, 42.8525}}, // Schenectady County Airport
    Airport{IataCode{"SCI"}, CountryId{"VE"}, Coordinate{-72.2029, 7.80132}}, // Paramillo Airport
    Airport{IataCode{"SCK"}, CountryId{"US"}, Coordinate{-121.251, 37.897}}, // Stockton Metropolitan Airport
    Airport{IataCode{"SCL"}, CountryId{"CL"}, Coordinate{-70.7938, -33.3997}}, // Arturo Merino Benítez International Airport
    Airport{IataCode{"SCM"}, CountryId{"US"}, Coordinate{-165.571, 61.8453}}, // Scammon Bay Airport
    Airport{IataCode{"SCN"}, CountryId{"DE"}, Coordinate{7.1128, 49.2195}}, // Saarbrücken Airport
    Airport{IataCode{"SCO"}, CountryId{"KZ"}, Coordinate{51.0883, 43.8562}}, // Aktau Airport
    Airport{IataCode{"SCQ"}, CountryId{"ES"}, Coordinate{-8.42048, 42.8919}}, // Santiago - Rosalia de Castro Airport
    Airport{IataCode{"SCR"}, CountryId{"SE"}, Coordinate{12.8376, 61.1568}}, // Scandinavian Mountains Airport
    Airport{IataCode{"SCS"}, CountryId{"GB"}, Coordinate{-1.29611, 60.4328}}, // Scatsta Airport
    Airport{IataCode{"SCT"}, CountryId{"YE"}, Coordinate{53.9056, 12.6306}}, // Socotra Airport
    Airport{IataCode{"SCU"}, CountryId{"CU"}, Coordinate{-75.8388, 19.9755}}, // Antonio Maceo Airport
    Airport{IataCode{"SCV"}, CountryId{"RO"}, Coordinate{26.3499, 47.6857}}, // Suceava Airport
    Airport{IataCode{"SCW"}, CountryId{"RU"}, Coordinate{50.8383, 61.6417}}, // Syktyvkar Airport
    Airport{IataCode{"SCX"}, CountryId{"MX"}, Coordinate{-95.2014, 16.2125}}, // Salina Cruz Airport
    Airport{IataCode{"SCY"}, CountryId{"EC"}, Coordinate{-89.6162, -0.908717}}, // San Cristóbal Airport
    Airport{IataCode{"SCZ"}, CountryId{"SB"}, Coordinate{165.799, -10.72}}, // Santa Cruz/Graciosa Bay/Luova Airport
    Airport{IataCode{"SDC"}, CountryId{"US"}, Coordinate{-77.1194, 43.2347}}, // Williamson–Sodus Airport
    Airport{IataCode{"SDD"}, CountryId{"AO"}, Coordinate{13.5698, -14.9285}}, // Lubango Airport
    Airport{IataCode{"SDE"}, CountryId{"AR"}, Coordinate{-64.2989, -27.756}}, // Vicecomodoro Ángel de la Paz Aragonés Airport
    Airport{IataCode{"SDF"}, CountryId{"US"}, Coordinate{-85.7426, 38.1858}}, // Louisville International Airport
    Airport{IataCode{"SDG"}, CountryId{"IR"}, Coordinate{47.0135, 35.2515}}, // Sanandaj Airport
    Airport{IataCode{"SDH"}, CountryId{"HN"}, Coordinate{-88.7833, 14.7772}}, // Santa Rosa de Copán Airport
    Airport{IataCode{"SDI"}, CountryId{"PG"}, Coordinate{146.465, -5.62859}}, // Saidor Airport
    Airport{IataCode{"SDJ"}, CountryId{"JP"}, Coordinate{140.929, 38.1373}}, // Sendai Airport
    Airport{IataCode{"SDK"}, CountryId{"MY"}, Coordinate{118.062, 5.89716}}, // Sandakan Airport
    Airport{IataCode{"SDL"}, CountryId{"SE"}, Coordinate{17.4365, 62.5264}}, // Sundsvall-Timrå Airport
    Airport{IataCode{"SDM"}, CountryId{"US"}, Coordinate{-116.98, 32.5722}}, // Brown Field Municipal Airport
    Airport{IataCode{"SDN"}, CountryId{"NO"}, Coordinate{6.10756, 61.8291}}, // Sandane Airport
    Airport{IataCode{"SDO"}, CountryId{"RS"}, Coordinate{20.9629, 44.6447}}, // Smederevo Airport
    Airport{IataCode{"SDP"}, CountryId{"US"}, Coordinate{-160.521, 55.3136}}, // Sand Point Airport
    Airport{IataCode{"SDQ"}, CountryId{"DO"}, Coordinate{-69.6767, 18.4302}}, // Las Américas International Airport
    Airport{IataCode{"SDR"}, CountryId{"ES"}, Coordinate{-3.82426, 43.4233}}, // Santander Airport
    Airport{IataCode{"SDS"}, CountryId{"JP"}, Coordinate{138.414, 38.0611}}, // Sado Airport
    Airport{IataCode{"SDT"}, CountryId{"PK"}, Coordinate{72.3511, 34.8099}}, // Saidu Sharif Airport
    Airport{IataCode{"SDU"}, CountryId{"BR"}, Coordinate{-43.1666, -22.912}}, // Santos Dumont Airport
    Airport{IataCode{"SDX"}, CountryId{"US"}, Coordinate{-111.79, 34.85}}, // Sedona Airport
    Airport{IataCode{"SDY"}, CountryId{"US"}, Coordinate{-104.185, 47.7108}}, // Sidney-Richland Municipal Airport
    Airport{IataCode{"SEA"}, CountryId{"US"}, Coordinate{-122.297, 47.4452}}, // Seattle–Tacoma International Airport
    Airport{IataCode{"SEB"}, CountryId{"LY"}, Coordinate{14.4674, 26.9981}}, // Sabha Airport
    Airport{IataCode{"SEE"}, CountryId{"US"}, Coordinate{-116.973, 32.8261}}, // Gillespie Field
    Airport{IataCode{"SEF"}, CountryId{"US"}, Coordinate{-81.3425, 27.4564}}, // Sebring Regional Airport
    Airport{IataCode{"SEG"}, CountryId{"US"}, Coordinate{-76.8642, 40.8211}}, // Penn Valley Airport
    Airport{IataCode{"SEK"}, CountryId{"RU"}, Coordinate{153.719, 67.4655}}, // Srednekolymsk Airport
    Airport{IataCode{"SEM"}, CountryId{"US"}, Coordinate{-86.9878, 32.3439}}, // Craig Field Airport
    Airport{IataCode{"SEN"}, CountryId{"GB"}, Coordinate{0.701775, 51.5692}}, // London Southend Airport
    Airport{IataCode{"SEO"}, CountryId{"CI"}, Coordinate{-6.64422, 7.96}}, // Séguéla Airport
    Airport{IataCode{"SEQ"}, CountryId{"ID"}, Coordinate{102.14, 1.37127}}, // Sungai Pakning
    Airport{IataCode{"SER"}, CountryId{"US"}, Coordinate{-85.9083, 38.9247}}, // Freeman Municipal Airport
    Airport{IataCode{"SEU"}, CountryId{"TZ"}, Coordinate{34.8214, -2.45694}}, // Seronera Airstrip
    Airport{IataCode{"SEV"}, CountryId{"UA"}, Coordinate{38.5379, 48.8997}}, // Sievierodonetsk Airport
    Airport{IataCode{"SEW"}, CountryId{"EG"}, Coordinate{25.5053, 29.3469}}, // Siwa Oasis North Airport
    Airport{IataCode{"SEY"}, CountryId{"MR"}, Coordinate{-12.2072, 15.1794}}, // Sélibaby Airport
    Airport{IataCode{"SEZ"}, CountryId{"SC"}, Coordinate{55.5116, -4.67074}}, // Seychelles International Airport
    Airport{IataCode{"SFA"}, CountryId{"TN"}, Coordinate{10.6908, 34.7178}}, // Sfax–Thyna International Airport
    Airport{IataCode{"SFB"}, CountryId{"US"}, Coordinate{-81.2439, 28.7759}}, // Orlando Sanford International Airport
    Airport{IataCode{"SFC"}, CountryId{"FR"}, Coordinate{-61.265, 16.255}}, // Saint-François Airport
    Airport{IataCode{"SFD"}, CountryId{"VE"}, Coordinate{-67.4428, 7.88525}}, // Las Flecheras Airport
    Airport{IataCode{"SFE"}, CountryId{"PH"}, Coordinate{120.305, 16.5977}}, // San Fernando Airport
    Airport{IataCode{"SFF"}, CountryId{"US"}, Coordinate{-117.323, 47.6831}}, // Felts Field
    Airport{IataCode{"SFG"}, CountryId{"FR"}, Coordinate{-63.048, 18.1019}}, // L'Espérance Airport
    Airport{IataCode{"SFH"}, CountryId{"MX"}, Coordinate{-114.808, 30.9321}}, // San Felipe International Airport
    Airport{IataCode{"SFK"}, CountryId{"HU"}, Coordinate{18.0936, 46.8603}}, // Siófok-Kiliti Airport
    Airport{IataCode{"SFL"}, CountryId{"CV"}, Coordinate{-24.4851, 14.8882}}, // São Filipe Airport
    Airport{IataCode{"SFM"}, CountryId{"US"}, Coordinate{-70.7081, 43.3939}}, // Sanford Regional Airport
    Airport{IataCode{"SFN"}, CountryId{"AR"}, Coordinate{-60.806, -31.709}}, // Sauce Viejo Airport
    Airport{IataCode{"SFO"}, CountryId{"US"}, Coordinate{-122.392, 37.6162}}, // San Francisco International Airport
    Airport{IataCode{"SFS"}, CountryId{"PH"}, Coordinate{120.283, 14.7956}}, // Subic Bay International Airport
    Airport{IataCode{"SFT"}, CountryId{"SE"}, Coordinate{21.0769, 64.6247}}, // Skellefteå Airport
    Airport{IataCode{"SFU"}, CountryId{"PG"}, Coordinate{148.6, -9.583}}, // Safia
    Airport{IataCode{"SFZ"}, CountryId{"US"}, Coordinate{-71.4914, 41.9208}}, // North Central State Airport
    Airport{IataCode{"SGA"}, CountryId{"AF"}, Coordinate{71.5, 37.5667}}, // Sheghnan Airport
    Airport{IataCode{"SGC"}, CountryId{"RU"}, Coordinate{73.4083, 61.3405}}, // Surgut International Airport
    Airport{IataCode{"SGD"}, CountryId{"DK"}, Coordinate{9.78676, 54.9627}}, // Sønderborg Airport
    Airport{IataCode{"SGE"}, CountryId{"DE"}, Coordinate{8.08306, 50.7078}}, // Siegerland Airport
    Airport{IataCode{"SGF"}, CountryId{"US"}, Coordinate{-93.3968, 37.2394}}, // Springfield-Branson National Airport
    Airport{IataCode{"SGH"}, CountryId{"US"}, Coordinate{-83.8403, 39.8403}}, // Springfield-Beckley Municipal Airport
    Airport{IataCode{"SGJ"}, CountryId{"PG"}, Coordinate{149.833, -10.3833}}, // Sagarai
    Airport{IataCode{"SGK"}, CountryId{"PG"}, Coordinate{144.323, -5.125}}, // Sangapi Airport
    Airport{IataCode{"SGL"}, CountryId{"PH"}, Coordinate{120.895, 14.49}}, // Sangley Point Airport
    Airport{IataCode{"SGM"}, CountryId{"MX"}, Coordinate{-112.939, 27.2969}}, // San Ignacio Airfield
    Airport{IataCode{"SGN"}, CountryId{"VN"}, Coordinate{106.664, 10.8154}}, // Tan Son Nhat International Airport
    Airport{IataCode{"SGO"}, CountryId{"AU"}, Coordinate{148.595, -28.05}}, // St George Airport
    Airport{IataCode{"SGP"}, CountryId{"AU"}, Coordinate{120.14, -20.425}}, // Shay Gap Airport
    Airport{IataCode{"SGR"}, CountryId{"US"}, Coordinate{-95.6528, 29.6271}}, // Sugar Land Regional Airport
    Airport{IataCode{"SGS"}, CountryId{"PH"}, Coordinate{119.743, 5.04694}}, // Sanga-Sanga Airport
    Airport{IataCode{"SGT"}, CountryId{"US"}, Coordinate{-91.575, 34.5995}}, // Stuttgart Municipal Airport
    Airport{IataCode{"SGU"}, CountryId{"US"}, Coordinate{-113.509, 37.0308}}, // St. George Regional Airport
    Airport{IataCode{"SGV"}, CountryId{"AR"}, Coordinate{-65.3503, -41.5917}}, // Sierra Grande Airport
    Airport{IataCode{"SGX"}, CountryId{"TZ"}, Coordinate{35.5834, -10.6812}}, // Songea Airport
    Airport{IataCode{"SGY"}, CountryId{"US"}, Coordinate{-136.323, 59.4553}}, // Skagway Airport
    Airport{IataCode{"SGZ"}, CountryId{"TH"}, Coordinate{100.608, 7.18656}}, // Songkhla Airport
    Airport{IataCode{"SHA"}, CountryId{"CN"}, Coordinate{121.322, 31.1962}}, // Shanghai Hongqiao International Airport
    Airport{IataCode{"SHB"}, CountryId{"JP"}, Coordinate{144.96, 43.5775}}, // Nakashibetsu Airport
    Airport{IataCode{"SHC"}, CountryId{"ET"}, Coordinate{38.2708, 14.0794}}, // Shire Airport
    Airport{IataCode{"SHD"}, CountryId{"US"}, Coordinate{-78.9001, 38.2637}}, // Shenandoah Valley Regional Airport
    Airport{IataCode{"SHE"}, CountryId{"CN"}, Coordinate{123.487, 41.6324}}, // Shenyang Taoxian International Airport
    Airport{IataCode{"SHF"}, CountryId{"CN"}, Coordinate{85.8911, 44.2417}}, // Shihezi Huayuan Airport
    Airport{IataCode{"SHG"}, CountryId{"US"}, Coordinate{-157.163, 66.8881}}, // Shungnak Airport
    Airport{IataCode{"SHH"}, CountryId{"US"}, Coordinate{-166.089, 66.2494}}, // Shishmaref Airport
    Airport{IataCode{"SHI"}, CountryId{"JP"}, Coordinate{125.145, 24.8267}}, // Shimojishima Airport
    Airport{IataCode{"SHJ"}, CountryId{"AE"}, Coordinate{55.522, 25.3211}}, // Sharjah International Airport
    Airport{IataCode{"SHK"}, CountryId{"LS"}, Coordinate{28.7689, -29.7308}}, // Sehonghong Airport
    Airport{IataCode{"SHL"}, CountryId{"IN"}, Coordinate{91.9752, 25.7061}}, // Shillong Airport
    Airport{IataCode{"SHM"}, CountryId{"JP"}, Coordinate{135.361, 33.6623}}, // Nanki-Shirahama Airport
    Airport{IataCode{"SHN"}, CountryId{"US"}, Coordinate{-123.147, 47.2336}}, // Sanderson Field
    Airport{IataCode{"SHO"}, CountryId{"SZ"}, Coordinate{31.7222, -26.3585}}, // King Mswati III International Airport
    Airport{IataCode{"SHQ"}, CountryId{"AU"}, Coordinate{153.372, -27.9217}}, // Southport Airport
    Airport{IataCode{"SHR"}, CountryId{"US"}, Coordinate{-106.97, 44.7739}}, // Sheridan County Airport
    Airport{IataCode{"SHS"}, CountryId{"CN"}, Coordinate{112.279, 30.3222}}, // Shashi Airport
    Airport{IataCode{"SHT"}, CountryId{"AU"}, Coordinate{145.391, -36.4267}}, // Shepparton Airport
    Airport{IataCode{"SHU"}, CountryId{"AU"}, Coordinate{132.158, -11.1328}}, // Smith Point Airport
    Airport{IataCode{"SHV"}, CountryId{"US"}, Coordinate{-93.8295, 32.4539}}, // Shreveport Regional Airport
    Airport{IataCode{"SHW"}, CountryId{"SA"}, Coordinate{47.1123, 17.4693}}, // Sharurah Domestic Airport
    Airport{IataCode{"SHX"}, CountryId{"US"}, Coordinate{-159.569, 62.6922}}, // Shageluk Airport
    Airport{IataCode{"SHY"}, CountryId{"TZ"}, Coordinate{33.5, -3.61}}, // Shinyanga Airport
    Airport{IataCode{"SHZ"}, CountryId{"LS"}, Coordinate{28.5536, -29.2667}}, // Seshutes Airport
    Airport{IataCode{"SIB"}, CountryId{"CG"}, Coordinate{13.35, -3.74639}}, // Sibiti Airport
    Airport{IataCode{"SIC"}, CountryId{"PA"}, Coordinate{-79.078, 8.26246}}, // San José Airport, Las Perlas
    Airport{IataCode{"SID"}, CountryId{"CV"}, Coordinate{-22.9442, 16.7349}}, // Amílcar Cabral International Airport
    Airport{IataCode{"SIF"}, CountryId{"NP"}, Coordinate{84.9797, 27.1637}}, // Simara Airport
    Airport{IataCode{"SIG"}, CountryId{"US"}, Coordinate{-66.0983, 18.4567}}, // Fernando Luis Ribas Dominicci Airport
    Airport{IataCode{"SIH"}, CountryId{"NP"}, Coordinate{80.936, 29.2631}}, // Silgadi Doti Airport
    Airport{IataCode{"SIJ"}, CountryId{"IS"}, Coordinate{-18.9167, 66.1333}}, // Siglufjörður Airport
    Airport{IataCode{"SIK"}, CountryId{"US"}, Coordinate{-89.5617, 36.8989}}, // Sikeston Memorial Municipal Airport
    Airport{IataCode{"SIM"}, CountryId{"PG"}, Coordinate{144.545, -5.2784}}, // Simbai Airport
    Airport{IataCode{"SIN"}, CountryId{"SG"}, Coordinate{103.989, 1.35755}}, // Singapore Changi Airport
    Airport{IataCode{"SIO"}, CountryId{"AU"}, Coordinate{145.083, -40.835}}, // Smithton Airport
    Airport{IataCode{"SIP"}, CountryId{"RU"}, Coordinate{33.9886, 45.0277}}, // Simferopol International Airport
    Airport{IataCode{"SIQ"}, CountryId{"ID"}, Coordinate{104.577, -0.478011}}, // Dabo Singkep Airport
    Airport{IataCode{"SIR"}, CountryId{"CH"}, Coordinate{7.33773, 46.2227}}, // Sion Airport
    Airport{IataCode{"SIS"}, CountryId{"ZA"}, Coordinate{22.9979, -27.6494}}, // Sishen Airport
    Airport{IataCode{"SIT"}, CountryId{"US"}, Coordinate{-135.365, 57.0527}}, // Sitka Rocky Gutierrez Airport
    Airport{IataCode{"SIU"}, CountryId{"NI"}, Coordinate{-84.7769, 13.7167}}, // Siuna Airport
    Airport{IataCode{"SIV"}, CountryId{"US"}, Coordinate{-87.4483, 39.1142}}, // Sullivan County Airport
    Airport{IataCode{"SIW"}, CountryId{"ID"}, Coordinate{98.9322, 2.667}}, // Sibisa Airport
    Airport{IataCode{"SIX"}, CountryId{"ID"}, Coordinate{98.8905, 1.55446}}, // Ferdinand Lumban Tobing Airport
    Airport{IataCode{"SIY"}, CountryId{"US"}, Coordinate{-122.468, 41.7814}}, // Siskiyou County Airport
    Airport{IataCode{"SIZ"}, CountryId{"PG"}, Coordinate{142.05, -3}}, // Sissano
    Airport{IataCode{"SJB"}, CountryId{"BO"}, Coordinate{-64.8167, -13.0667}}, // San Joaquín Airport
    Airport{IataCode{"SJC"}, CountryId{"US"}, Coordinate{-121.929, 37.3628}}, // San Jose International Airport
    Airport{IataCode{"SJD"}, CountryId{"MX"}, Coordinate{-109.717, 23.1596}}, // Los Cabos International Airport
    Airport{IataCode{"SJE"}, CountryId{"CO"}, Coordinate{-72.6385, 2.57156}}, // Jorge Enrique González Torres Airport
    Airport{IataCode{"SJI"}, CountryId{"PH"}, Coordinate{121.045, 12.3602}}, // San Jose Airport
    Airport{IataCode{"SJJ"}, CountryId{"BA"}, Coordinate{18.3367, 43.826}}, // Sarajevo International Airport
    Airport{IataCode{"SJK"}, CountryId{"BR"}, Coordinate{-45.8711, -23.2289}}, // São José dos Campos Airport
    Airport{IataCode{"SJL"}, CountryId{"BR"}, Coordinate{-66.9932, -0.152349}}, // São Gabriel da Cachoeira Airport
    Airport{IataCode{"SJM"}, CountryId{"DO"}, Coordinate{-71.2333, 18.8333}}, // San Juan de la Maguana Airport
    Airport{IataCode{"SJN"}, CountryId{"US"}, Coordinate{-109.379, 34.5186}}, // St. Johns Industrial Air Park
    Airport{IataCode{"SJO"}, CountryId{"CR"}, Coordinate{-84.2042, 9.99815}}, // Juan Santamaría International Airport
    Airport{IataCode{"SJP"}, CountryId{"BR"}, Coordinate{-49.4048, -20.8123}}, // São José do Rio Preto Airport
    Airport{IataCode{"SJQ"}, CountryId{"ZM"}, Coordinate{24.3056, -17.4767}}, // Sesheke Airport
    Airport{IataCode{"SJS"}, CountryId{"BO"}, Coordinate{-60.8, -17.8324}}, // San José de Chiquitos Airport
    Airport{IataCode{"SJT"}, CountryId{"US"}, Coordinate{-100.503, 31.3574}}, // San Angelo Regional Airport
    Airport{IataCode{"SJU"}, CountryId{"US"}, Coordinate{-66.0019, 18.4392}}, // Luis Muñoz Marín International Airport
    Airport{IataCode{"SJV"}, CountryId{"BO"}, Coordinate{-62.4704, -16.2667}}, // San Javier Airport (Bolivia)
    Airport{IataCode{"SJW"}, CountryId{"CN"}, Coordinate{114.689, 38.2815}}, // Shijiazhuang Zhengding International Airport
    Airport{IataCode{"SJX"}, CountryId{"BZ"}, Coordinate{-88.1308, 18.3556}}, // Sarteneja Airport
    Airport{IataCode{"SJY"}, CountryId{"FI"}, Coordinate{22.8246, 62.6929}}, // Seinäjoki Airport
    Airport{IataCode{"SJZ"}, CountryId{"PT"}, Coordinate{-28.1703, 38.6633}}, // São Jorge Airport
    Airport{IataCode{"SKB"}, CountryId{"KN"}, Coordinate{-62.7142, 17.3112}}, // Robert L. Bradshaw International Airport
    Airport{IataCode{"SKC"}, CountryId{"PG"}, Coordinate{141.8, -8.08333}}, // Suki Airport
    Airport{IataCode{"SKD"}, CountryId{"UZ"}, Coordinate{66.991, 39.6967}}, // Samarkand International Airport
    Airport{IataCode{"SKE"}, CountryId{"NO"}, Coordinate{9.56981, 59.1844}}, // Skien Airport, Geiteryggen
    Airport{IataCode{"SKG"}, CountryId{"GR"}, Coordinate{22.9755, 40.5247}}, // Thessaloniki Airport "Makedonia"
    Airport{IataCode{"SKH"}, CountryId{"NP"}, Coordinate{81.6358, 28.5858}}, // Surkhet Airport
    Airport{IataCode{"SKK"}, CountryId{"US"}, Coordinate{-161.224, 64.3711}}, // Shaktoolik Airport
    Airport{IataCode{"SKN"}, CountryId{"NO"}, Coordinate{15.0317, 68.5796}}, // Stokmarknes Airport
    Airport{IataCode{"SKO"}, CountryId{"NG"}, Coordinate{5.20694, 12.9161}}, // Sadiq Abubakar III International Airport
    Airport{IataCode{"SKP"}, CountryId{"MK"}, Coordinate{21.6269, 41.9611}}, // Skopje Airport
    Airport{IataCode{"SKQ"}, CountryId{"LS"}, Coordinate{28.3703, -30.0389}}, // Sekake Airport
    Airport{IataCode{"SKR"}, CountryId{"ET"}, Coordinate{38.97, 5.69167}}, // Shakiso Airport
    Airport{IataCode{"SKS"}, CountryId{"DK"}, Coordinate{9.29078, 55.2219}}, // Vojens Airport
    Airport{IataCode{"SKT"}, CountryId{"PK"}, Coordinate{74.3674, 32.5327}}, // Sialkot International Airport
    Airport{IataCode{"SKU"}, CountryId{"GR"}, Coordinate{24.4872, 38.9675}}, // Skyros Island National Airport
    Airport{IataCode{"SKV"}, CountryId{"EG"}, Coordinate{34.0604, 28.6828}}, // St. Catherine International Airport
    Airport{IataCode{"SKW"}, CountryId{"US"}, Coordinate{-151.191, 61.9653}}, // Skwentna Airport
    Airport{IataCode{"SKX"}, CountryId{"RU"}, Coordinate{45.2192, 54.1427}}, // Saransk Airport
    Airport{IataCode{"SKZ"}, CountryId{"PK"}, Coordinate{68.7957, 27.7231}}, // Sukkur Airport
    Airport{IataCode{"SLA"}, CountryId{"AR"}, Coordinate{-65.4787, -24.8444}}, // Martín Miguel de Güemes International Airport
    Airport{IataCode{"SLB"}, CountryId{"US"}, Coordinate{-95.2407, 42.5972}}, // Storm Lake Municipal Airport
    Airport{IataCode{"SLC"}, CountryId{"US"}, Coordinate{-111.98, 40.7836}}, // Salt Lake City International Airport
    Airport{IataCode{"SLD"}, CountryId{"SK"}, Coordinate{19.1406, 48.6407}}, // Sliač Airport
    Airport{IataCode{"SLG"}, CountryId{"US"}, Coordinate{-94.49, 36.1919}}, // Smith Field
    Airport{IataCode{"SLH"}, CountryId{"VU"}, Coordinate{167.537, -13.8517}}, // Vanua Lava Airport
    Airport{IataCode{"SLI"}, CountryId{"ZM"}, Coordinate{26.3678, -12.1707}}, // Solwezi Airport
    Airport{IataCode{"SLJ"}, CountryId{"AU"}, Coordinate{117.762, -22.2553}}, // Solomon Airport
    Airport{IataCode{"SLK"}, CountryId{"US"}, Coordinate{-74.2035, 44.3805}}, // Adirondack Regional Airport
    Airport{IataCode{"SLL"}, CountryId{"OM"}, Coordinate{54.0922, 17.0389}}, // Salalah Airport
    Airport{IataCode{"SLM"}, CountryId{"ES"}, Coordinate{-5.50223, 40.9403}}, // Salamanca Airport
    Airport{IataCode{"SLN"}, CountryId{"US"}, Coordinate{-97.64, 38.7787}}, // Salina Regional Airport
    Airport{IataCode{"SLO"}, CountryId{"US"}, Coordinate{-88.9642, 38.6428}}, // Salem-Leckrone Airport
    Airport{IataCode{"SLP"}, CountryId{"MX"}, Coordinate{-100.937, 22.2559}}, // San Luis Potosí International Airport
    Airport{IataCode{"SLQ"}, CountryId{"US"}, Coordinate{-157.166, 61.7006}}, // Sleetmute Airport
    Airport{IataCode{"SLR"}, CountryId{"US"}, Coordinate{-95.6211, 33.1597}}, // Sulphur Springs Municipal Airport
    Airport{IataCode{"SLS"}, CountryId{"BG"}, Coordinate{27.1788, 44.055}}, // Silistra Airfield
    Airport{IataCode{"SLT"}, CountryId{"US"}, Coordinate{-106.049, 38.5383}}, // Harriet Alexander Field
    Airport{IataCode{"SLU"}, CountryId{"LC"}, Coordinate{-60.9947, 14.0203}}, // George F. L. Charles Airport
    Airport{IataCode{"SLV"}, CountryId{"IN"}, Coordinate{77.0662, 31.0857}}, // Shimla Airport
    Airport{IataCode{"SLW"}, CountryId{"MX"}, Coordinate{-100.932, 25.5489}}, // Plan de Guadalupe International Airport
    Airport{IataCode{"SLX"}, CountryId{"GB"}, Coordinate{-71.2, 21.3333}}, // Salt Cay Airport
    Airport{IataCode{"SLY"}, CountryId{"RU"}, Coordinate{66.587, 66.5903}}, // Salekhard Airport
    Airport{IataCode{"SLZ"}, CountryId{"BR"}, Coordinate{-44.2365, -2.58362}}, // Marechal Cunha Machado International Airport
    Airport{IataCode{"SMA"}, CountryId{"PT"}, Coordinate{-25.1651, 36.973}}, // Santa Maria Airport
    Airport{IataCode{"SMB"}, CountryId{"CL"}, Coordinate{-69.3336, -52.7367}}, // Franco Bianco Airport
    Airport{IataCode{"SMC"}, CountryId{"RS"}, Coordinate{19.6599, 45.0365}}, // Sremska Mitrovica Airport
    Airport{IataCode{"SMD"}, CountryId{"US"}, Coordinate{-85.1528, 41.1433}}, // Smith Field
    Airport{IataCode{"SME"}, CountryId{"US"}, Coordinate{-84.6156, 37.0536}}, // Lake Cumberland Regional Airport
    Airport{IataCode{"SMF"}, CountryId{"US"}, Coordinate{-121.591, 38.6956}}, // Sacramento International Airport
    Airport{IataCode{"SMG"}, CountryId{"PE"}, Coordinate{-76.7681, -12.4}}, // Santa Maria Airport (Peru)
    Airport{IataCode{"SMH"}, CountryId{"PG"}, Coordinate{146.75, -6.08333}}, // Sapmanga
    Airport{IataCode{"SMI"}, CountryId{"GR"}, Coordinate{26.9149, 37.6911}}, // Samos International Airport
    Airport{IataCode{"SMJ"}, CountryId{"PG"}, Coordinate{146.8, -7.667}}, // Sim
    Airport{IataCode{"SMK"}, CountryId{"US"}, Coordinate{-162.11, 63.49}}, // St. Michael Airport
    Airport{IataCode{"SML"}, CountryId{"BS"}, Coordinate{-75.2793, 23.5901}}, // Stella Maris Airport
    Airport{IataCode{"SMM"}, CountryId{"MY"}, Coordinate{118.596, 4.44972}}, // Semporna Airport
    Airport{IataCode{"SMN"}, CountryId{"US"}, Coordinate{-113.881, 45.1239}}, // Lemhi County Airport
    Airport{IataCode{"SMO"}, CountryId{"US"}, Coordinate{-118.447, 34.0175}}, // Santa Monica Airport
    Airport{IataCode{"SMQ"}, CountryId{"ID"}, Coordinate{112.975, -2.49917}}, // Sampit Airport
    Airport{IataCode{"SMR"}, CountryId{"CO"}, Coordinate{-74.2329, 11.1174}}, // Simón Bolívar International Airport
    Airport{IataCode{"SMS"}, CountryId{"MG"}, Coordinate{49.8166, -17.0897}}, // Sainte Marie Airport
    Airport{IataCode{"SMV"}, CountryId{"CH"}, Coordinate{9.88389, 46.5339}}, // Samedan Airport
    Airport{IataCode{"SMW"}, CountryId{"MA"}, Coordinate{-11.6847, 26.7317}}, // Smara Airport
    Airport{IataCode{"SMX"}, CountryId{"US"}, Coordinate{-120.448, 34.899}}, // Santa Maria Public Airport
    Airport{IataCode{"SMZ"}, CountryId{"SR"}, Coordinate{-54.4162, 4.35025}}, // Stoelmans Eiland Airstrip
    Airport{IataCode{"SNA"}, CountryId{"US"}, Coordinate{-117.864, 33.6767}}, // John Wayne Airport
    Airport{IataCode{"SNB"}, CountryId{"AU"}, Coordinate{130.654, -11.4228}}, // Snake Bay Airport
    Airport{IataCode{"SNC"}, CountryId{"EC"}, Coordinate{-80.9889, -2.205}}, // General Ulpiano Paez Airport
    Airport{IataCode{"SNE"}, CountryId{"CV"}, Coordinate{-24.2861, 16.5901}}, // Preguiça Airport
    Airport{IataCode{"SNF"}, CountryId{"VE"}, Coordinate{-68.7552, 10.2787}}, // Sub Teniente Nestor Arias Airport
    Airport{IataCode{"SNG"}, CountryId{"BO"}, Coordinate{-60.9778, -16.3847}}, // Cap. Av. Juan Cochamanidis San Airport
    Airport{IataCode{"SNH"}, CountryId{"AU"}, Coordinate{151.991, -28.6203}}, // Stanthorpe Airport
    Airport{IataCode{"SNI"}, CountryId{"LR"}, Coordinate{-9.0668, 5.03432}}, // Greenville/Sinoe Airport
    Airport{IataCode{"SNK"}, CountryId{"US"}, Coordinate{-100.948, 32.6996}}, // Winston Field Airport
    Airport{IataCode{"SNL"}, CountryId{"US"}, Coordinate{-96.9428, 35.3572}}, // Shawnee Regional Airport
    Airport{IataCode{"SNM"}, CountryId{"BO"}, Coordinate{-65.6434, -14.9667}}, // San Ignacio de Moxos Airport
    Airport{IataCode{"SNN"}, CountryId{"IE"}, Coordinate{-8.92155, 52.6923}}, // Shannon Airport
    Airport{IataCode{"SNO"}, CountryId{"TH"}, Coordinate{104.116, 17.1968}}, // Sakon Nakhon Airport
    Airport{IataCode{"SNP"}, CountryId{"US"}, Coordinate{-170.221, 57.1672}}, // St. Paul Island Airport
    Airport{IataCode{"SNR"}, CountryId{"FR"}, Coordinate{-2.15856, 47.3144}}, // Saint-Nazaire - Montoir Airport
    Airport{IataCode{"SNS"}, CountryId{"US"}, Coordinate{-121.606, 36.6628}}, // Salinas Municipal Airport
    Airport{IataCode{"SNU"}, CountryId{"CU"}, Coordinate{-79.93, 22.4976}}, // Abel Santamaría Airport
    Airport{IataCode{"SNV"}, CountryId{"VE"}, Coordinate{-61.14, 4.55536}}, // Santa Elena de Uairén Airport
    Airport{IataCode{"SNW"}, CountryId{"MM"}, Coordinate{94.3, 18.4167}}, // Thandwe Airport
    Airport{IataCode{"SNX"}, CountryId{"IR"}, Coordinate{53.4954, 35.5955}}, // Semnan Airport
    Airport{IataCode{"SNY"}, CountryId{"US"}, Coordinate{-102.985, 41.0997}}, // Sidney Municipal Airport
    Airport{IataCode{"SOB"}, CountryId{"HU"}, Coordinate{17.1592, 46.6864}}, // Hévíz–Balaton Airport
    Airport{IataCode{"SOC"}, CountryId{"ID"}, Coordinate{110.748, -7.51348}}, // Adisumarmo International Airport
    Airport{IataCode{"SOD"}, CountryId{"BR"}, Coordinate{-47.4864, -23.4831}}, // Sorocaba Airport
    Airport{IataCode{"SOE"}, CountryId{"CG"}, Coordinate{14.1333, 2}}, // Souanké Airport
    Airport{IataCode{"SOF"}, CountryId{"BG"}, Coordinate{23.4162, 42.688}}, // Sofia Airport
    Airport{IataCode{"SOG"}, CountryId{"NO"}, Coordinate{7.13767, 61.1575}}, // Sogndal Airport, Haukåsen
    Airport{IataCode{"SOJ"}, CountryId{"NO"}, Coordinate{20.958, 69.7851}}, // Sørkjosen Airport
    Airport{IataCode{"SOK"}, CountryId{"LS"}, Coordinate{28.06, -29.8383}}, // Semonkong Airport
    Airport{IataCode{"SOM"}, CountryId{"VE"}, Coordinate{-64.1443, 8.94608}}, // San Tomé Airport
    Airport{IataCode{"SON"}, CountryId{"VU"}, Coordinate{167.219, -15.5083}}, // Santo-Pekoa International Airport
    Airport{IataCode{"SOO"}, CountryId{"SE"}, Coordinate{17.0983, 61.2614}}, // Söderhamn Airport
    Airport{IataCode{"SOP"}, CountryId{"US"}, Coordinate{-79.3976, 35.234}}, // Moore County Airport
    Airport{IataCode{"SOQ"}, CountryId{"ID"}, Coordinate{131.291, -0.890982}}, // Sorong Airport
    Airport{IataCode{"SOU"}, CountryId{"GB"}, Coordinate{-1.36295, 50.9507}}, // Southampton Airport
    Airport{IataCode{"SOV"}, CountryId{"US"}, Coordinate{-151.704, 59.4425}}, // Seldovia Airport
    Airport{IataCode{"SOW"}, CountryId{"US"}, Coordinate{-110.007, 34.2639}}, // Show Low Regional Airport
    Airport{IataCode{"SOX"}, CountryId{"CO"}, Coordinate{-72.9703, 5.67639}}, // Alberto Lleras Camargo Airport
    Airport{IataCode{"SPA"}, CountryId{"US"}, Coordinate{-81.9565, 34.9157}}, // Spartanburg Downtown Memorial Airport
    Airport{IataCode{"SPC"}, CountryId{"ES"}, Coordinate{-17.7529, 28.6218}}, // La Palma Airport
    Airport{IataCode{"SPD"}, CountryId{"BD"}, Coordinate{88.9086, 25.7592}}, // Saidpur Airport
    Airport{IataCode{"SPE"}, CountryId{"MY"}, Coordinate{116.467, 4.733}}, // Sepulot Airport
    Airport{IataCode{"SPF"}, CountryId{"US"}, Coordinate{-103.784, 44.4831}}, // Black Hills Airport
    Airport{IataCode{"SPG"}, CountryId{"US"}, Coordinate{-82.6269, 27.765}}, // Albert Whitted Airport
    Airport{IataCode{"SPH"}, CountryId{"PG"}, Coordinate{147.767, -9}}, // Sopu
    Airport{IataCode{"SPI"}, CountryId{"US"}, Coordinate{-89.6718, 39.8443}}, // Abraham Lincoln Capital Airport
    Airport{IataCode{"SPJ"}, CountryId{"GR"}, Coordinate{22.5167, 36.9667}}, // Sparti Airport
    Airport{IataCode{"SPK"}, CountryId{"US"}, Coordinate{-111.668, 40.145}}, // Spanish Fork-Springville Airport
    Airport{IataCode{"SPL"}, CountryId{"RS"}, Coordinate{20.9596, 44.3499}}, // Smederevska Palanka Airport
    Airport{IataCode{"SPN"}, CountryId{"US"}, Coordinate{145.723, 15.1215}}, // Saipan International Airport
    Airport{IataCode{"SPP"}, CountryId{"AO"}, Coordinate{17.7196, -14.6576}}, // Menongue Airport
    Airport{IataCode{"SPR"}, CountryId{"BZ"}, Coordinate{-87.9647, 17.9176}}, // John Greif II Airport
    Airport{IataCode{"SPS"}, CountryId{"US"}, Coordinate{-98.4919, 33.9889}}, // Wichita Falls Municipal Airport
    Airport{IataCode{"SPT"}, CountryId{"MY"}, Coordinate{115.55, 5.08333}}, // Sipitang Airport
    Airport{IataCode{"SPU"}, CountryId{"HR"}, Coordinate{16.2986, 43.5361}}, // Split Airport
    Airport{IataCode{"SPV"}, CountryId{"PG"}, Coordinate{143.683, -3.9}}, // Sepik Plains
    Airport{IataCode{"SPW"}, CountryId{"US"}, Coordinate{-95.1971, 43.1673}}, // Spencer Municipal Airport
    Airport{IataCode{"SPX"}, CountryId{"EG"}, Coordinate{30.8944, 30.1097}}, // Sphinx International Airport
    Airport{IataCode{"SPY"}, CountryId{"CI"}, Coordinate{-6.65827, 4.74659}}, // San Pédro Airport
    Airport{IataCode{"SPZ"}, CountryId{"US"}, Coordinate{-94.1219, 36.174}}, // Springdale Municipal Airport
    Airport{IataCode{"SQA"}, CountryId{"US"}, Coordinate{-120.076, 34.6069}}, // Santa Ynez Airport
    Airport{IataCode{"SQC"}, CountryId{"AU"}, Coordinate{119.358, -31.2417}}, // Southern Cross Airport
    Airport{IataCode{"SQD"}, CountryId{"CN"}, Coordinate{117.964, 28.3842}}, // Shangrao Sanqingshan Airport
    Airport{IataCode{"SQG"}, CountryId{"ID"}, Coordinate{111.457, -0.041944}}, // Tebelian Airport
    Airport{IataCode{"SQH"}, CountryId{"VN"}, Coordinate{104.035, 21.2147}}, // Nà Sản Airport
    Airport{IataCode{"SQJ"}, CountryId{"CN"}, Coordinate{117.839, 26.4255}}, // Sanming Shaxian Airport
    Airport{IataCode{"SQL"}, CountryId{"US"}, Coordinate{-122.249, 37.5119}}, // San Carlos Airport
    Airport{IataCode{"SQO"}, CountryId{"SE"}, Coordinate{17.7, 64.9556}}, // Storuman Airport
    Airport{IataCode{"SQQ"}, CountryId{"LT"}, Coordinate{23.3947, 55.8939}}, // Šiauliai International Airport
    Airport{IataCode{"SQR"}, CountryId{"ID"}, Coordinate{121.283, -2.5377}}, // Soroako Airport
    Airport{IataCode{"SQS"}, CountryId{"BZ"}, Coordinate{-89.0098, 17.1859}}, // Matthew Spain Airport
    Airport{IataCode{"SQT"}, CountryId{"PG"}, Coordinate{150.683, -10.55}}, // China Straits
    Airport{IataCode{"SQV"}, CountryId{"US"}, Coordinate{-123.187, 48.0981}}, // Sequim Valley Airport
    Airport{IataCode{"SQW"}, CountryId{"DK"}, Coordinate{9.16431, 56.5534}}, // Skive Airport
    Airport{IataCode{"SQX"}, CountryId{"BR"}, Coordinate{-53.5056, -26.7783}}, // Sao Miguel Do Oeste Airport
    Airport{IataCode{"SQY"}, CountryId{"BR"}, Coordinate{-52.0328, -31.3833}}, // São Lourenço do Sul Airport
    Airport{IataCode{"SRA"}, CountryId{"BR"}, Coordinate{-54.5188, -27.9042}}, // Santa Rosa Airport
    Airport{IataCode{"SRB"}, CountryId{"BO"}, Coordinate{-66.7872, -14.0729}}, // Santa Rosa Airport
    Airport{IataCode{"SRC"}, CountryId{"US"}, Coordinate{-91.7375, 35.2106}}, // Searcy Municipal Airport
    Airport{IataCode{"SRD"}, CountryId{"BO"}, Coordinate{-64.7, -13.2833}}, // San Ramón Airport
    Airport{IataCode{"SRE"}, CountryId{"BO"}, Coordinate{-65.1508, -19.2463}}, // Alcantari Airport
    Airport{IataCode{"SRG"}, CountryId{"ID"}, Coordinate{110.375, -6.96704}}, // Achmad Yani International Airport
    Airport{IataCode{"SRJ"}, CountryId{"BO"}, Coordinate{-66.75, -14.8667}}, // Capitán Germán Quiroga Guardia Airport
    Airport{IataCode{"SRL"}, CountryId{"MX"}, Coordinate{-112.099, 27.0931}}, // Palo Verde Airport
    Airport{IataCode{"SRN"}, CountryId{"AU"}, Coordinate{145.291, -42.1556}}, // Strahan Airport
    Airport{IataCode{"SRP"}, CountryId{"NO"}, Coordinate{5.34218, 59.7932}}, // Stord Airport
    Airport{IataCode{"SRT"}, CountryId{"UG"}, Coordinate{33.6187, 1.72231}}, // Soroti Airport
    Airport{IataCode{"SRU"}, CountryId{"MM"}, Coordinate{93.6153, 22.9392}}, // Surbung Airport
    Airport{IataCode{"SRV"}, CountryId{"US"}, Coordinate{-156.589, 61.7897}}, // Stony River Airport
    Airport{IataCode{"SRW"}, CountryId{"US"}, Coordinate{-80.5195, 35.64}}, // Mid-Carolina Regional Airport
    Airport{IataCode{"SRY"}, CountryId{"IR"}, Coordinate{53.1967, 36.6358}}, // Dasht-e Naz Airport
    Airport{IataCode{"SRZ"}, CountryId{"BO"}, Coordinate{-63.1758, -17.8013}}, // Cap Horacio Vasquez , Airport ,El Trompillo
    Airport{IataCode{"SSA"}, CountryId{"BR"}, Coordinate{-38.3338, -12.9154}}, // Deputado Luís Eduardo Magalhães International Airport
    Airport{IataCode{"SSB"}, CountryId{"US"}, Coordinate{-64.7078, 17.747}}, // Christiansted Harbor Seaplane Base
    Airport{IataCode{"SSD"}, CountryId{"CL"}, Coordinate{-70.705, -32.7458}}, // Víctor Lafón Airport
    Airport{IataCode{"SSE"}, CountryId{"IN"}, Coordinate{75.933, 17.6255}}, // Solapur Airport
    Airport{IataCode{"SSF"}, CountryId{"US"}, Coordinate{-98.468, 29.3389}}, // Stinson Municipal Airport
    Airport{IataCode{"SSG"}, CountryId{"GQ"}, Coordinate{8.71606, 3.75785}}, // Malabo International Airport
    Airport{IataCode{"SSH"}, CountryId{"EG"}, Coordinate{34.3873, 27.9801}}, // Sharm el-Sheikh International Airport
    Airport{IataCode{"SSI"}, CountryId{"US"}, Coordinate{-81.3914, 31.1519}}, // Malcolm McKinnon Airport
    Airport{IataCode{"SSJ"}, CountryId{"NO"}, Coordinate{12.4689, 65.9567}}, // Sandnessjøen Airport
    Airport{IataCode{"SSK"}, CountryId{"AU"}, Coordinate{128.174, -19.1664}}, // Sturt Creek Airport
    Airport{IataCode{"SSL"}, CountryId{"CO"}, Coordinate{-70.8718, 5.13056}}, // Santa Rosalía Airport
    Airport{IataCode{"SSM"}, CountryId{"US"}, Coordinate{-84.3683, 46.4792}}, // Sault Ste. Marie Municipal Airport
    Airport{IataCode{"SSO"}, CountryId{"BR"}, Coordinate{-45.0438, -22.0918}}, // São Lourenço Airport
    Airport{IataCode{"SSQ"}, CountryId{"CA"}, Coordinate{-79.1792, 48.9167}}, // La Sarre Airport
    Airport{IataCode{"SSR"}, CountryId{"VU"}, Coordinate{168.153, -15.4715}}, // Sara Airport
    Airport{IataCode{"SSS"}, CountryId{"PG"}, Coordinate{147.95, -5.9}}, // Siassi
    Airport{IataCode{"SST"}, CountryId{"AR"}, Coordinate{-56.72, -36.5408}}, // Santa Teresita Airport
    Airport{IataCode{"SSY"}, CountryId{"AO"}, Coordinate{14.2471, -6.26986}}, // Mbanza Congo Airport
    Airport{IataCode{"STA"}, CountryId{"DK"}, Coordinate{8.35353, 55.9915}}, // Stauning Vestjylland Airport
    Airport{IataCode{"STB"}, CountryId{"VE"}, Coordinate{-71.9428, 8.97417}}, // Miguel Urdaneta Fernández Airport
    Airport{IataCode{"STC"}, CountryId{"US"}, Coordinate{-94.066, 45.5467}}, // St. Cloud Regional Airport
    Airport{IataCode{"STD"}, CountryId{"VE"}, Coordinate{-72.0449, 7.56969}}, // Mayor Buenaventura Vivas Airport
    Airport{IataCode{"STE"}, CountryId{"US"}, Coordinate{-89.536, 44.545}}, // Stevens Point Municipal Airport
    Airport{IataCode{"STF"}, CountryId{"US"}, Coordinate{-88.8486, 33.4331}}, // George M. Bryan Airport
    Airport{IataCode{"STG"}, CountryId{"US"}, Coordinate{-169.664, 56.5772}}, // St. George Airport
    Airport{IataCode{"STH"}, CountryId{"CA"}, Coordinate{-113.56, 51.1342}}, // Strathmore (D.J. Murray) Airport
    Airport{IataCode{"STI"}, CountryId{"DO"}, Coordinate{-70.602, 19.4022}}, // Cibao International Airport
    Airport{IataCode{"STJ"}, CountryId{"US"}, Coordinate{-94.9097, 39.7719}}, // Rosecrans Memorial Airport
    Airport{IataCode{"STM"}, CountryId{"BR"}, Coordinate{-54.7865, -2.42471}}, // Santarém-Maestro Wilson Fonseca Airport
    Airport{IataCode{"STN"}, CountryId{"GB"}, Coordinate{0.262154, 51.8893}}, // London Stansted Airport
    Airport{IataCode{"STP"}, CountryId{"US"}, Coordinate{-93.06, 44.9344}}, // St. Paul Downtown Airport
    Airport{IataCode{"STQ"}, CountryId{"US"}, Coordinate{-78.5025, 41.4125}}, // St. Marys Municipal Airport
    Airport{IataCode{"STR"}, CountryId{"DE"}, Coordinate{9.19314, 48.6907}}, // Stuttgart Airport
    Airport{IataCode{"STT"}, CountryId{"US"}, Coordinate{-64.9718, 18.3348}}, // Cyril E. King Airport
    Airport{IataCode{"STV"}, CountryId{"IN"}, Coordinate{72.7426, 21.1204}}, // Surat Airport
    Airport{IataCode{"STW"}, CountryId{"RU"}, Coordinate{42.1053, 45.1129}}, // Stavropol Shpakovskoye Airport
    Airport{IataCode{"STX"}, CountryId{"US"}, Coordinate{-64.8017, 17.7044}}, // Henry E. Rohlsen Airport
    Airport{IataCode{"STY"}, CountryId{"UY"}, Coordinate{-57.9808, -31.4379}}, // Nueva Hespérides International Airport
    Airport{IataCode{"STZ"}, CountryId{"BR"}, Coordinate{-50.5186, -10.4647}}, // Santa Terezinha Airport
    Airport{IataCode{"SUA"}, CountryId{"US"}, Coordinate{-80.2211, 27.1817}}, // Witham Field
    Airport{IataCode{"SUB"}, CountryId{"ID"}, Coordinate{112.785, -7.38}}, // Juanda International Airport
    Airport{IataCode{"SUD"}, CountryId{"US"}, Coordinate{-96.6556, 35.7894}}, // Stroud Municipal Airport
    Airport{IataCode{"SUE"}, CountryId{"US"}, Coordinate{-87.4252, 44.842}}, // Door County Cherryland Airport
    Airport{IataCode{"SUF"}, CountryId{"IT"}, Coordinate{16.2468, 38.9093}}, // Lamezia Terme International Airport
    Airport{IataCode{"SUG"}, CountryId{"PH"}, Coordinate{125.479, 9.75757}}, // Surigao Airport
    Airport{IataCode{"SUI"}, CountryId{}, Coordinate{41.1201, 42.867}}, // Sukhumi Babushara Airport
    Airport{IataCode{"SUJ"}, CountryId{"RO"}, Coordinate{22.8817, 47.7063}}, // Satu Mare International Airport
    Airport{IataCode{"SUK"}, CountryId{"RU"}, Coordinate{130.391, 67.7919}}, // Sakkyryr Airport
    Airport{IataCode{"SUL"}, CountryId{"PK"}, Coordinate{69.1769, 28.6453}}, // Sui Airport
    Airport{IataCode{"SUM"}, CountryId{"US"}, Coordinate{-80.3614, 33.995}}, // Sumter Airport
    Airport{IataCode{"SUN"}, CountryId{"US"}, Coordinate{-114.301, 43.5066}}, // Friedman Memorial Airport
    Airport{IataCode{"SUO"}, CountryId{"US"}, Coordinate{-121.453, 43.8764}}, // Sunriver Airport
    Airport{IataCode{"SUP"}, CountryId{"ID"}, Coordinate{113.89, -7.02189}}, // Trunojoyo Airport
    Airport{IataCode{"SUQ"}, CountryId{"EC"}, Coordinate{-78.1694, -2.483}}, // Sucua Airport
    Airport{IataCode{"SUR"}, CountryId{"CA"}, Coordinate{-88.5419, 52.7086}}, // Summer Beaver Airport
    Airport{IataCode{"SUS"}, CountryId{"US"}, Coordinate{-90.6449, 38.6636}}, // Spirit of St. Louis Airport
    Airport{IataCode{"SUT"}, CountryId{"TZ"}, Coordinate{31.6103, -7.94889}}, // Sumbawanga Airport
    Airport{IataCode{"SUV"}, CountryId{"FJ"}, Coordinate{178.56, -18.0458}}, // Nausori International Airport
    Airport{IataCode{"SUW"}, CountryId{"US"}, Coordinate{-92.0947, 46.6897}}, // Richard I. Bong Airport
    Airport{IataCode{"SUX"}, CountryId{"US"}, Coordinate{-96.3844, 42.4025}}, // Sioux Gateway Airport
    Airport{IataCode{"SUY"}, CountryId{"RU"}, Coordinate{117.642, 62.1828}}, // Suntar Airport
    Airport{IataCode{"SUZ"}, CountryId{"PG"}, Coordinate{143.917, -7.16667}}, // Suria aerodrome
    Airport{IataCode{"SVA"}, CountryId{"US"}, Coordinate{-170.492, 63.6864}}, // Savoonga Airport
    Airport{IataCode{"SVB"}, CountryId{"MG"}, Coordinate{50.1747, -14.2786}}, // Sambava Airport
    Airport{IataCode{"SVC"}, CountryId{"US"}, Coordinate{-108.156, 32.6367}}, // Grant County Airport
    Airport{IataCode{"SVD"}, CountryId{"VC"}, Coordinate{-61.1503, 13.1564}}, // Argyle International Airport
    Airport{IataCode{"SVE"}, CountryId{"US"}, Coordinate{-120.573, 40.3756}}, // Susanville Municipal Airport
    Airport{IataCode{"SVF"}, CountryId{"BJ"}, Coordinate{2.46458, 8.01817}}, // Save Airport
    Airport{IataCode{"SVG"}, CountryId{"NO"}, Coordinate{5.62544, 58.8818}}, // Stavanger Airport
    Airport{IataCode{"SVI"}, CountryId{"CO"}, Coordinate{-74.7667, 2.10028}}, // Eduardo Falla Solano Airport
    Airport{IataCode{"SVJ"}, CountryId{"NO"}, Coordinate{14.6669, 68.2451}}, // Svolvær Airport
    Airport{IataCode{"SVK"}, CountryId{"BZ"}, Coordinate{-88.3692, 16.7284}}, // Silver Creek Airport
    Airport{IataCode{"SVL"}, CountryId{"FI"}, Coordinate{28.945, 61.9428}}, // Savonlinna Airport
    Airport{IataCode{"SVM"}, CountryId{"AU"}, Coordinate{142.333, -10.1867}}, // St Pauls
    Airport{IataCode{"SVO"}, CountryId{"RU"}, Coordinate{37.4146, 55.9726}}, // Sheremetyevo International Airport
    Airport{IataCode{"SVP"}, CountryId{"AO"}, Coordinate{16.9474, -12.4049}}, // Joaquim Kapango Airport
    Airport{IataCode{"SVQ"}, CountryId{"ES"}, Coordinate{-5.90157, 37.423}}, // San Pablo Airport
    Airport{IataCode{"SVS"}, CountryId{"US"}, Coordinate{-149.054, 66.0169}}, // Stevens Village Airport
    Airport{IataCode{"SVT"}, CountryId{"BW"}, Coordinate{24.0767, -18.5206}}, // Savuti Airport
    Airport{IataCode{"SVU"}, CountryId{"FJ"}, Coordinate{179.339, -16.799}}, // Savusavu Airport
    Airport{IataCode{"SVW"}, CountryId{"US"}, Coordinate{-155.575, 61.0972}}, // Sparrevohn LRRS Airport
    Airport{IataCode{"SVX"}, CountryId{"RU"}, Coordinate{60.7977, 56.7503}}, // Koltsovo Airport
    Airport{IataCode{"SVZ"}, CountryId{"VE"}, Coordinate{-72.4406, 7.839}}, // Juan Vicente Gómez International Airport
    Airport{IataCode{"SWA"}, CountryId{"CN"}, Coordinate{116.415, 23.553}}, // Jieyang Chaoshan Airport
    Airport{IataCode{"SWC"}, CountryId{"AU"}, Coordinate{142.74, -37.0717}}, // Stawell Airport
    Airport{IataCode{"SWD"}, CountryId{"US"}, Coordinate{-149.419, 60.1269}}, // Seward Airport
    Airport{IataCode{"SWF"}, CountryId{"US"}, Coordinate{-74.1047, 41.5042}}, // New York Stewart International Airport
    Airport{IataCode{"SWH"}, CountryId{"AU"}, Coordinate{143.549, -35.3758}}, // Swan Hill Airport
    Airport{IataCode{"SWI"}, CountryId{"US"}, Coordinate{-96.5861, 33.6242}}, // Sherman Municipal Airport
    Airport{IataCode{"SWJ"}, CountryId{"VU"}, Coordinate{167.438, -16.495}}, // South West Bay Airport
    Airport{IataCode{"SWO"}, CountryId{"US"}, Coordinate{-97.084, 36.1579}}, // Stillwater Regional Airport
    Airport{IataCode{"SWP"}, CountryId{"NA"}, Coordinate{14.5646, -22.6568}}, // Swakopmund Airport
    Airport{IataCode{"SWQ"}, CountryId{"ID"}, Coordinate{117.415, -8.48913}}, // Brangbiji Airport
    Airport{IataCode{"SWR"}, CountryId{"PG"}, Coordinate{147.95, -5.88333}}, // Silur
    Airport{IataCode{"SWS"}, CountryId{"GB"}, Coordinate{-4.06646, 51.6025}}, // Swansea Airport
    Airport{IataCode{"SWT"}, CountryId{"RU"}, Coordinate{77.6494, 60.7174}}, // Strezhevoy Airport
    Airport{IataCode{"SWV"}, CountryId{"RU"}, Coordinate{159.231, 61.919}}, // Severo-Evensk Airport
    Airport{IataCode{"SWW"}, CountryId{"US"}, Coordinate{-100.466, 32.4672}}, // Avenger Field
    Airport{IataCode{"SWX"}, CountryId{"BW"}, Coordinate{21.8167, -18.3742}}, // Shakawe Airport
    Airport{IataCode{"SWY"}, CountryId{"MY"}, Coordinate{100.699, 4.21639}}, // Sitiawan Airport
    Airport{IataCode{"SXB"}, CountryId{"FR"}, Coordinate{7.62763, 48.5444}}, // Strasbourg Airport
    Airport{IataCode{"SXE"}, CountryId{"AU"}, Coordinate{146.973, -38.0936}}, // West Sale Airport
    Airport{IataCode{"SXG"}, CountryId{"ZM"}, Coordinate{23.2667, -16.1125}}, // Senanga Airport
    Airport{IataCode{"SXI"}, CountryId{"IR"}, Coordinate{54.5459, 25.9024}}, // Sirri Island Airport
    Airport{IataCode{"SXJ"}, CountryId{"CN"}, Coordinate{90.2475, 42.9117}}, // Shanshan Airport
    Airport{IataCode{"SXK"}, CountryId{"ID"}, Coordinate{131.305, -7.98835}}, // Mathilda Batyaleri Airport
    Airport{IataCode{"SXL"}, CountryId{"IE"}, Coordinate{-8.5989, 54.2788}}, // Sligo Airport
    Airport{IataCode{"SXM"}, CountryId{"NL"}, Coordinate{-63.1094, 18.0408}}, // Princess Juliana International Airport
    Airport{IataCode{"SXN"}, CountryId{"BW"}, Coordinate{26.1156, -20.5534}}, // Sua Pan Airport
    Airport{IataCode{"SXO"}, CountryId{"BR"}, Coordinate{-50.6883, -11.6319}}, // São Félix do Araguaia Airport
    Airport{IataCode{"SXP"}, CountryId{"US"}, Coordinate{-164.848, 62.5206}}, // Sheldon Point Airport
    Airport{IataCode{"SXQ"}, CountryId{"US"}, Coordinate{-151.038, 60.475}}, // Soldotna Airport
    Airport{IataCode{"SXR"}, CountryId{"IN"}, Coordinate{74.7742, 33.9871}}, // Srinagar Airport
    Airport{IataCode{"SXS"}, CountryId{"MY"}, Coordinate{119.094, 5.08778}}, // Sahabat Sahabat 16 Airport
    Airport{IataCode{"SXU"}, CountryId{"ET"}, Coordinate{37.7667, 6.83333}}, // Soddo Airport
    Airport{IataCode{"SXV"}, CountryId{"IN"}, Coordinate{78.0618, 11.7825}}, // Salem Airport
    Airport{IataCode{"SXX"}, CountryId{"BR"}, Coordinate{-51.99, -6.64028}}, // São Félix do Xingu Airport
    Airport{IataCode{"SXY"}, CountryId{"US"}, Coordinate{-75.4161, 42.3025}}, // Sidney Municipal Airport (New York)
    Airport{IataCode{"SXZ"}, CountryId{"TR"}, Coordinate{41.8429, 37.9785}}, // Siirt Airport
    Airport{IataCode{"SYB"}, CountryId{"US"}, Coordinate{-152.202, 58.3717}}, // Seal Bay Seaplane Base
    Airport{IataCode{"SYD"}, CountryId{"AU"}, Coordinate{151.173, -33.9358}}, // Sydney Airport
    Airport{IataCode{"SYE"}, CountryId{"YE"}, Coordinate{43.7306, 16.9674}}, // Saadah Airport
    Airport{IataCode{"SYH"}, CountryId{"NP"}, Coordinate{86.7103, 27.8092}}, // Syangboche Airport
    Airport{IataCode{"SYI"}, CountryId{"US"}, Coordinate{-86.4425, 35.5594}}, // Shelbyville Municipal Airport
    Airport{IataCode{"SYJ"}, CountryId{"IR"}, Coordinate{55.6717, 29.5508}}, // Sirjan Airport
    Airport{IataCode{"SYK"}, CountryId{"IS"}, Coordinate{-22.7942, 65.0581}}, // Stykkishólmur Airport
    Airport{IataCode{"SYM"}, CountryId{"CN"}, Coordinate{100.962, 22.7965}}, // Pu'er Simao Airport
    Airport{IataCode{"SYN"}, CountryId{"US"}, Coordinate{-93.0164, 44.4756}}, // Stanton Airfield
    Airport{IataCode{"SYO"}, CountryId{"JP"}, Coordinate{139.787, 38.8122}}, // Shonai Airport
    Airport{IataCode{"SYP"}, CountryId{"PA"}, Coordinate{-80.9453, 8.08556}}, // Ruben Cantu Airport
    Airport{IataCode{"SYQ"}, CountryId{"CR"}, Coordinate{-84.1387, 9.95832}}, // Tobías Bolaños International Airport
    Airport{IataCode{"SYR"}, CountryId{"US"}, Coordinate{-76.1107, 43.1138}}, // Syracuse Hancock International Airport
    Airport{IataCode{"SYS"}, CountryId{"RU"}, Coordinate{114.082, 71.9289}}, // Saskylakh Airport
    Airport{IataCode{"SYT"}, CountryId{"FR"}, Coordinate{4.02111, 46.4064}}, // Saint-Yan Airport
    Airport{IataCode{"SYU"}, CountryId{"AU"}, Coordinate{142.823, -10.2083}}, // Warraber Island Airport
    Airport{IataCode{"SYW"}, CountryId{"PK"}, Coordinate{67.7178, 26.4742}}, // Sehwan Sharif Airport
    Airport{IataCode{"SYX"}, CountryId{"CN"}, Coordinate{109.413, 18.3085}}, // Sanya Phoenix International Airport
    Airport{IataCode{"SYY"}, CountryId{"GB"}, Coordinate{-6.3218, 58.2139}}, // Stornoway Airport
    Airport{IataCode{"SYZ"}, CountryId{"IR"}, Coordinate{52.59, 29.5459}}, // Shiraz International Airport, Iran
    Airport{IataCode{"SZA"}, CountryId{"AO"}, Coordinate{12.3733, -6.13868}}, // Soyo Airport
    Airport{IataCode{"SZB"}, CountryId{"MY"}, Coordinate{101.553, 3.13298}}, // Sultan Abdul Aziz Shah Airport
    Airport{IataCode{"SZE"}, CountryId{"ET"}, Coordinate{40.9922, 11.7922}}, // Semera Airport
    Airport{IataCode{"SZF"}, CountryId{"TR"}, Coordinate{36.5554, 41.2577}}, // Samsun-Çarşamba Airport
    Airport{IataCode{"SZG"}, CountryId{"AT"}, Coordinate{12.9983, 47.7908}}, // Salzburg Airport
    Airport{IataCode{"SZJ"}, CountryId{"CU"}, Coordinate{-82.955, 21.6425}}, // Siguanea Airport
    Airport{IataCode{"SZK"}, CountryId{"ZA"}, Coordinate{31.5935, -24.9674}}, // Skukuza Airport
    Airport{IataCode{"SZP"}, CountryId{"US"}, Coordinate{-119.062, 34.3469}}, // Santa Paula Airport
    Airport{IataCode{"SZR"}, CountryId{"BG"}, Coordinate{25.6553, 42.3767}}, // Stara Zagora Airport
    Airport{IataCode{"SZW"}, CountryId{"DE"}, Coordinate{11.7834, 53.427}}, // Parchim International Airport
    Airport{IataCode{"SZX"}, CountryId{"CN"}, Coordinate{113.807, 22.631}}, // Shenzhen Bao'an International Airport
    Airport{IataCode{"SZY"}, CountryId{"PL"}, Coordinate{20.9475, 53.4889}}, // Szczytno-Szymany International Airport
    Airport{IataCode{"SZZ"}, CountryId{"PL"}, Coordinate{14.8948, 53.5932}}, // "Solidarity" Szczecin-Goleniów Airport
    Airport{IataCode{"TAB"}, CountryId{"TT"}, Coordinate{-60.8397, 11.1524}}, // Arthur Napoleon Raymond Robinson International Airport
    Airport{IataCode{"TAC"}, CountryId{"PH"}, Coordinate{125.026, 11.2266}}, // Daniel Z. Romualdez Airport
    Airport{IataCode{"TAD"}, CountryId{"US"}, Coordinate{-104.341, 37.2594}}, // Perry Stokes Airport
    Airport{IataCode{"TAE"}, CountryId{"KR"}, Coordinate{128.639, 35.8997}}, // Daegu International Airport
    Airport{IataCode{"TAF"}, CountryId{"DZ"}, Coordinate{-0.533894, 35.5411}}, // Oran Tafraoui Airport
    Airport{IataCode{"TAG"}, CountryId{"PH"}, Coordinate{123.773, 9.5688}}, // Bohol–Panglao International Airport
    Airport{IataCode{"TAH"}, CountryId{"VU"}, Coordinate{169.228, -19.4585}}, // Whitegrass Airport
    Airport{IataCode{"TAI"}, CountryId{"YE"}, Coordinate{44.1347, 13.6855}}, // Ta'izz International Airport
    Airport{IataCode{"TAJ"}, CountryId{"PG"}, Coordinate{142.428, -3.199}}, // Tadji Airport
    Airport{IataCode{"TAK"}, CountryId{"JP"}, Coordinate{134.018, 34.2186}}, // Takamatsu Airport
    Airport{IataCode{"TAL"}, CountryId{"US"}, Coordinate{-152.109, 65.1744}}, // Ralph M. Calhoun Memorial Airport
    Airport{IataCode{"TAM"}, CountryId{"MX"}, Coordinate{-97.8694, 22.2893}}, // General Francisco Javier Mina International Airport
    Airport{IataCode{"TAN"}, CountryId{"US"}, Coordinate{-71.0164, 41.8742}}, // Taunton Municipal Airport
    Airport{IataCode{"TAO"}, CountryId{"CN"}, Coordinate{120.059, 36.3483}}, // Qingdao Jiaodong International Airport
    Airport{IataCode{"TAP"}, CountryId{"MX"}, Coordinate{-92.3685, 14.7907}}, // Tapachula International Airport
    Airport{IataCode{"TAR"}, CountryId{"IT"}, Coordinate{17.3978, 40.5177}}, // Taranto-Grottaglie Airport
    Airport{IataCode{"TAS"}, CountryId{"UZ"}, Coordinate{69.2668, 41.2573}}, // Tashkent International Airport
    Airport{IataCode{"TAT"}, CountryId{"SK"}, Coordinate{20.2481, 49.0688}}, // Poprad-Tatry Airport
    Airport{IataCode{"TAW"}, CountryId{"UY"}, Coordinate{-55.9239, -31.7503}}, // Tacuarembó Airport
    Airport{IataCode{"TAY"}, CountryId{"EE"}, Coordinate{26.691, 58.3103}}, // Tartu Airport
    Airport{IataCode{"TAZ"}, CountryId{"TM"}, Coordinate{59.8331, 41.7647}}, // Daşoguz Airport
    Airport{IataCode{"TBA"}, CountryId{"LK"}, Coordinate{80.4876, 9.30544}}, // SLAF Iranamadu
    Airport{IataCode{"TBB"}, CountryId{"VN"}, Coordinate{109.344, 13.0499}}, // Tuy Hoa Airport
    Airport{IataCode{"TBC"}, CountryId{"US"}, Coordinate{-111.383, 36.0928}}, // Tuba City Airport
    Airport{IataCode{"TBD"}, CountryId{"CO"}, Coordinate{-77.6681, 2.77778}}, // Timbiqui
    Airport{IataCode{"TBF"}, CountryId{"KI"}, Coordinate{174.776, -1.22382}}, // Tabiteuea Nord Aerodrome
    Airport{IataCode{"TBG"}, CountryId{"PG"}, Coordinate{141.226, -5.27861}}, // Tabubil Airport
    Airport{IataCode{"TBH"}, CountryId{"PH"}, Coordinate{122.081, 12.3159}}, // Tugdan Airport
    Airport{IataCode{"TBI"}, CountryId{"BS"}, Coordinate{-75.4522, 24.3153}}, // New Bight Airport
    Airport{IataCode{"TBJ"}, CountryId{"TN"}, Coordinate{8.87668, 36.9761}}, // Tabarka-Ain Draham International Airport
    Airport{IataCode{"TBN"}, CountryId{"US"}, Coordinate{-92.1369, 37.7329}}, // Waynesville-St. Robert Regional Airport
    Airport{IataCode{"TBO"}, CountryId{"TZ"}, Coordinate{32.8306, -5.07611}}, // Tabora Airport
    Airport{IataCode{"TBP"}, CountryId{"PE"}, Coordinate{-80.3844, -3.55093}}, // Cap. FAP Pedro Canga Rodríguez Airport
    Airport{IataCode{"TBR"}, CountryId{"US"}, Coordinate{-81.7372, 32.4828}}, // Statesboro-Bulloch County Airport
    Airport{IataCode{"TBS"}, CountryId{"GE"}, Coordinate{44.9617, 41.6715}}, // Tbilisi International Airport
    Airport{IataCode{"TBT"}, CountryId{"BR"}, Coordinate{-69.9378, -4.25056}}, // Tabatinga International Airport
    Airport{IataCode{"TBU"}, CountryId{"TO"}, Coordinate{-175.139, -21.2427}}, // Fuaʻamotu International Airport
    Airport{IataCode{"TBW"}, CountryId{"RU"}, Coordinate{41.4916, 52.8037}}, // Tambov Donskoye Airport
    Airport{IataCode{"TBY"}, CountryId{"BW"}, Coordinate{22.4014, -26.0667}}, // Tshabong Airport
    Airport{IataCode{"TBZ"}, CountryId{"IR"}, Coordinate{46.2447, 38.1233}}, // Tabriz International Airport
    Airport{IataCode{"TCA"}, CountryId{"AU"}, Coordinate{134.183, -19.6344}}, // Tennant Creek Airport
    Airport{IataCode{"TCB"}, CountryId{"BS"}, Coordinate{-77.3996, 26.7453}}, // Treasure Cay Airport
    Airport{IataCode{"TCC"}, CountryId{"US"}, Coordinate{-103.603, 35.1828}}, // Tucumcari Municipal Airport
    Airport{IataCode{"TCD"}, CountryId{"CO"}, Coordinate{-69.7497, -2.89574}}, // Tarapacá Airport
    Airport{IataCode{"TCE"}, CountryId{"RO"}, Coordinate{28.7144, 45.0628}}, // Tulcea Airport
    Airport{IataCode{"TCG"}, CountryId{"CN"}, Coordinate{83.3408, 46.6725}}, // Tacheng Airport
    Airport{IataCode{"TCH"}, CountryId{"GA"}, Coordinate{11.017, -2.85}}, // Tchibanga Airport
    Airport{IataCode{"TCL"}, CountryId{"US"}, Coordinate{-87.6093, 33.2287}}, // Tuscaloosa National Airport
    Airport{IataCode{"TCN"}, CountryId{"MX"}, Coordinate{-97.4197, 18.4969}}, // Tehuacán Airport
    Airport{IataCode{"TCO"}, CountryId{"CO"}, Coordinate{-78.7544, 1.81293}}, // La Florida Airport
    Airport{IataCode{"TCP"}, CountryId{"EG"}, Coordinate{34.7758, 29.5945}}, // Taba International Airport
    Airport{IataCode{"TCQ"}, CountryId{"PE"}, Coordinate{-70.2758, -18.0533}}, // Crnl. FAP Carlos Ciriani Santa Rosa International Airport
    Airport{IataCode{"TCR"}, CountryId{"IN"}, Coordinate{78.0269, 8.72604}}, // Tuticorin Airport
    Airport{IataCode{"TCS"}, CountryId{"US"}, Coordinate{-107.272, 33.2369}}, // Truth or Consequences Municipal Airport
    Airport{IataCode{"TCT"}, CountryId{"US"}, Coordinate{-156.028, 62.9936}}, // Takotna Airport
    Airport{IataCode{"TCW"}, CountryId{"AU"}, Coordinate{145.603, -35.8108}}, // Tocumwal Airport
    Airport{IataCode{"TCX"}, CountryId{"IR"}, Coordinate{56.8971, 33.6693}}, // Tabas Airport
    Airport{IataCode{"TCY"}, CountryId{"US"}, Coordinate{-121.442, 37.6889}}, // Tracy Municipal Airport
    Airport{IataCode{"TCZ"}, CountryId{"CN"}, Coordinate{98.4824, 24.9386}}, // Tengchong Tuofeng Airport
    Airport{IataCode{"TDA"}, CountryId{"CO"}, Coordinate{-71.6584, 5.43049}}, // Trinidad Airport
    Airport{IataCode{"TDB"}, CountryId{"PG"}, Coordinate{148.083, -9.2}}, // Tetabedi
    Airport{IataCode{"TDD"}, CountryId{"BO"}, Coordinate{-64.9191, -14.8225}}, // Teniente Jorge Henrich Arauz Airport
    Airport{IataCode{"TDF"}, CountryId{"US"}, Coordinate{-78.9847, 36.2847}}, // Person County Airport
    Airport{IataCode{"TDG"}, CountryId{"PH"}, Coordinate{126.17, 9.07271}}, // Tandag Airport
    Airport{IataCode{"TDJ"}, CountryId{"DJ"}, Coordinate{42.9167, 11.7833}}, // Tadjoura Airport
    Airport{IataCode{"TDL"}, CountryId{"AR"}, Coordinate{-59.234, -37.2412}}, // Tandil Airport
    Airport{IataCode{"TDO"}, CountryId{"US"}, Coordinate{-122.806, 46.4772}}, // South Lewis County Airport
    Airport{IataCode{"TDS"}, CountryId{"PG"}, Coordinate{142.869, -7.62278}}, // Sasereme Airport
    Airport{IataCode{"TDW"}, CountryId{"US"}, Coordinate{-101.826, 35.17}}, // Tradewind Airport
    Airport{IataCode{"TDX"}, CountryId{"TH"}, Coordinate{102.319, 12.2746}}, // Trat Airport
    Airport{IataCode{"TDZ"}, CountryId{"US"}, Coordinate{-83.4822, 41.5647}}, // Toledo Executive Airport
    Airport{IataCode{"TEA"}, CountryId{"HN"}, Coordinate{-87.4725, 15.7762}}, // Tela Airport
    Airport{IataCode{"TEB"}, CountryId{"US"}, Coordinate{-74.0661, 40.8534}}, // Teterboro Airport
    Airport{IataCode{"TEC"}, CountryId{"BR"}, Coordinate{-50.6538, -24.3237}}, // Telêmaco Borba Airport
    Airport{IataCode{"TED"}, CountryId{"DK"}, Coordinate{8.69337, 57.072}}, // Thisted Airport
    Airport{IataCode{"TEE"}, CountryId{"DZ"}, Coordinate{8.11858, 35.4274}}, // Cheikh Larbi Tébessi Airport
    Airport{IataCode{"TEF"}, CountryId{"AU"}, Coordinate{122.229, -21.715}}, // Telfer Airport
    Airport{IataCode{"TEG"}, CountryId{"BF"}, Coordinate{-0.367, 11.8}}, // Tenkodogo Airport
    Airport{IataCode{"TEI"}, CountryId{"IN"}, Coordinate{96.1346, 27.9417}}, // Tezu Airport
    Airport{IataCode{"TEK"}, CountryId{"US"}, Coordinate{-146.691, 60.8725}}, // Tatitlek Airport
    Airport{IataCode{"TEL"}, CountryId{"MY"}, Coordinate{117.126, 5.62861}}, // Telupid Airport
    Airport{IataCode{"TEM"}, CountryId{"AU"}, Coordinate{147.512, -34.4217}}, // Temora Airport
    Airport{IataCode{"TEN"}, CountryId{"CN"}, Coordinate{109.305, 27.8842}}, // Tongren Fenghuang Airport
    Airport{IataCode{"TEO"}, CountryId{"PG"}, Coordinate{146.067, -8.08333}}, // Terapo
    Airport{IataCode{"TER"}, CountryId{"PT"}, Coordinate{-27.0871, 38.7542}}, // Lajes Airport
    Airport{IataCode{"TET"}, CountryId{"MZ"}, Coordinate{33.6445, -16.1092}}, // Chingozi Airport
    Airport{IataCode{"TEU"}, CountryId{"NZ"}, Coordinate{167.65, -45.5331}}, // Manapouri Aerodrome
    Airport{IataCode{"TEV"}, CountryId{"ES"}, Coordinate{-1.2175, 40.4119}}, // Teruel Airport
    Airport{IataCode{"TEX"}, CountryId{"US"}, Coordinate{-107.902, 37.9546}}, // Telluride Regional Airport
    Airport{IataCode{"TEZ"}, CountryId{"IN"}, Coordinate{92.7872, 26.7122}}, // Tezpur Airport
    Airport{IataCode{"TFB"}, CountryId{"PG"}, Coordinate{141.418, -5.11745}}, // Tifalmin Airport
    Airport{IataCode{"TFF"}, CountryId{"BR"}, Coordinate{-64.7253, -3.38028}}, // Tefé Airport
    Airport{IataCode{"TFI"}, CountryId{"PG"}, Coordinate{149.32, -9.076}}, // Tufi Airport
    Airport{IataCode{"TFN"}, CountryId{"ES"}, Coordinate{-16.3463, 28.4874}}, // Tenerife North Airport
    Airport{IataCode{"TFS"}, CountryId{"ES"}, Coordinate{-16.5775, 28.0476}}, // Tenerife South Airport
    Airport{IataCode{"TFU"}, CountryId{"CN"}, Coordinate{104.445, 30.319}}, // Chengdu Tianfu International Airport
    Airport{IataCode{"TGC"}, CountryId{"MY"}, Coordinate{111.202, 2.17778}}, // Tanjung Manis Airport
    Airport{IataCode{"TGD"}, CountryId{"ME"}, Coordinate{19.2464, 42.368}}, // Podgorica Airport
    Airport{IataCode{"TGG"}, CountryId{"MY"}, Coordinate{103.105, 5.3792}}, // Sultan Mahmud Airport
    Airport{IataCode{"TGH"}, CountryId{"VU"}, Coordinate{168.551, -16.8911}}, // Tongoa Airport
    Airport{IataCode{"TGI"}, CountryId{"PE"}, Coordinate{-76.0045, -9.29653}}, // Tingo María Airport
    Airport{IataCode{"TGJ"}, CountryId{"FR"}, Coordinate{167.804, -21.0958}}, // Tiga Airport
    Airport{IataCode{"TGL"}, CountryId{"PG"}, Coordinate{153.5, -11.5}}, // Tagula
    Airport{IataCode{"TGM"}, CountryId{"RO"}, Coordinate{24.4239, 46.4674}}, // Târgu Mureș International Airport
    Airport{IataCode{"TGN"}, CountryId{"AU"}, Coordinate{146.47, -38.2072}}, // Latrobe Valley Airport
    Airport{IataCode{"TGO"}, CountryId{"CN"}, Coordinate{122.2, 43.5569}}, // Tongliao Airport
    Airport{IataCode{"TGP"}, CountryId{"RU"}, Coordinate{89.9733, 61.59}}, // Podkamennaya Tunguska Airport
    Airport{IataCode{"TGR"}, CountryId{"DZ"}, Coordinate{6.09161, 33.0657}}, // Sidi Mahdi Airport
    Airport{IataCode{"TGS"}, CountryId{"MZ"}, Coordinate{32.9653, -24.5206}}, // Chókwè airport
    Airport{IataCode{"TGT"}, CountryId{"TZ"}, Coordinate{39.0717, -5.09209}}, // Tanga Airport
    Airport{IataCode{"TGU"}, CountryId{"HN"}, Coordinate{-87.2167, 14.0579}}, // Toncontín International Airport
    Airport{IataCode{"TGV"}, CountryId{"BG"}, Coordinate{26.7001, 43.3068}}, // Targovishte Airport
    Airport{IataCode{"TGZ"}, CountryId{"MX"}, Coordinate{-93.0198, 16.5608}}, // Ángel Albino Corzo International Airport
    Airport{IataCode{"THA"}, CountryId{"US"}, Coordinate{-86.2467, 35.38}}, // Tullahoma Regional Airport
    Airport{IataCode{"THB"}, CountryId{"LS"}, Coordinate{28.6158, -29.5228}}, // Thaba Tseka Airport
    Airport{IataCode{"THC"}, CountryId{"LR"}, Coordinate{-8.13667, 6.06639}}, // Tchien Airport
    Airport{IataCode{"THD"}, CountryId{"VN"}, Coordinate{105.475, 19.8927}}, // Tho Xuan Airport
    Airport{IataCode{"THE"}, CountryId{"BR"}, Coordinate{-42.8213, -5.06348}}, // Teresina Airport
    Airport{IataCode{"THG"}, CountryId{"AU"}, Coordinate{150.579, -24.4939}}, // Thangool Airport
    Airport{IataCode{"THH"}, CountryId{"NZ"}, Coordinate{174.708, -38.1811}}, // Taharoa Aerodrome
    Airport{IataCode{"THI"}, CountryId{"MR"}, Coordinate{-9.517, 18.45}}, // Tichitt Airport
    Airport{IataCode{"THK"}, CountryId{"LA"}, Coordinate{104.8, 17.4}}, // Thakhek
    Airport{IataCode{"THL"}, CountryId{"MM"}, Coordinate{99.9334, 20.4811}}, // Tachilek Airport
    Airport{IataCode{"THM"}, CountryId{"US"}, Coordinate{-115.281, 47.5736}}, // Thompson Falls Airport
    Airport{IataCode{"THN"}, CountryId{"SE"}, Coordinate{12.3364, 58.3242}}, // Trollhättan-Vänersborg Airport
    Airport{IataCode{"THO"}, CountryId{"IS"}, Coordinate{-15.3312, 66.2204}}, // Þórshöfn Airport
    Airport{IataCode{"THQ"}, CountryId{"CN"}, Coordinate{105.865, 34.5565}}, // Tianshui Maijishan Airport
    Airport{IataCode{"THR"}, CountryId{"IR"}, Coordinate{51.3304, 35.6891}}, // Mehrabad International Airport
    Airport{IataCode{"THS"}, CountryId{"TH"}, Coordinate{99.8205, 17.2324}}, // Sukhothai Airport
    Airport{IataCode{"THT"}, CountryId{"MR"}, Coordinate{-10.817, 17.233}}, // Tamchakett Airport
    Airport{IataCode{"THV"}, CountryId{"US"}, Coordinate{-76.8731, 39.9169}}, // York Airport (Pennsylvania)
    Airport{IataCode{"THX"}, CountryId{"RU"}, Coordinate{87.929, 65.795}}, // Turukhansk Airport
    Airport{IataCode{"THZ"}, CountryId{"NE"}, Coordinate{5.26917, 14.8775}}, // Tahoua Airport
    Airport{IataCode{"TIA"}, CountryId{"AL"}, Coordinate{19.7141, 41.4191}}, // Tirana International Airport Nënë Tereza
    Airport{IataCode{"TIB"}, CountryId{"CO"}, Coordinate{-72.7333, 8.63139}}, // Tibu Airport
    Airport{IataCode{"TIC"}, CountryId{"MH"}, Coordinate{171.917, 7.13333}}, // Tinak Airport
    Airport{IataCode{"TID"}, CountryId{"DZ"}, Coordinate{1.46988, 35.3458}}, // Tiaret - Abdelhafid Boussouf Bou Chekif Airport
    Airport{IataCode{"TIE"}, CountryId{"ET"}, Coordinate{35.415, 7.2025}}, // Tippi Airport
    Airport{IataCode{"TIF"}, CountryId{"SA"}, Coordinate{40.5444, 21.4833}}, // Ta’if Regional Airport
    Airport{IataCode{"TIG"}, CountryId{"PG"}, Coordinate{149.8, -2.6}}, // Tingwon
    Airport{IataCode{"TIH"}, CountryId{"FR"}, Coordinate{-148.234, -15.1197}}, // Tikehau Airport
    Airport{IataCode{"TII"}, CountryId{"AF"}, Coordinate{65.8642, 32.6053}}, // Tarin Kowt Airport
    Airport{IataCode{"TIJ"}, CountryId{"MX"}, Coordinate{-116.975, 32.5467}}, // Tijuana International Airport
    Airport{IataCode{"TIL"}, CountryId{"CA"}, Coordinate{-113.624, 51.0575}}, // Cheadle Airport
    Airport{IataCode{"TIM"}, CountryId{"ID"}, Coordinate{136.89, -4.52756}}, // Timika Airport
    Airport{IataCode{"TIN"}, CountryId{"DZ"}, Coordinate{-8.16509, 27.7051}}, // Tindouf Airport
    Airport{IataCode{"TIP"}, CountryId{"LY"}, Coordinate{13.1442, 32.6692}}, // Tripoli International Airport
    Airport{IataCode{"TIQ"}, CountryId{"US"}, Coordinate{145.626, 14.9943}}, // Tinian International Airport
    Airport{IataCode{"TIR"}, CountryId{"IN"}, Coordinate{79.5454, 13.6366}}, // Tirupati Airport
    Airport{IataCode{"TIU"}, CountryId{"NZ"}, Coordinate{171.225, -44.3031}}, // Richard Pearse Airport
    Airport{IataCode{"TIV"}, CountryId{"ME"}, Coordinate{18.718, 42.4121}}, // Tivat Airport
    Airport{IataCode{"TIW"}, CountryId{"US"}, Coordinate{-122.578, 47.2681}}, // Tacoma Narrows Airport
    Airport{IataCode{"TIX"}, CountryId{"US"}, Coordinate{-80.7992, 28.5148}}, // Space Coast Regional Airport
    Airport{IataCode{"TIY"}, CountryId{"MR"}, Coordinate{-11.4333, 18.5667}}, // Tidjikja Airport
    Airport{IataCode{"TIZ"}, CountryId{"PG"}, Coordinate{142.948, -5.845}}, // Tari Airport
    Airport{IataCode{"TJA"}, CountryId{"BO"}, Coordinate{-64.7085, -21.5474}}, // Capitán Oriel Lea Plaza Airport
    Airport{IataCode{"TJB"}, CountryId{"ID"}, Coordinate{103.391, 1.05149}}, // Sei Bati Airport
    Airport{IataCode{"TJG"}, CountryId{"ID"}, Coordinate{115.437, -2.21636}}, // Warukin Airport
    Airport{IataCode{"TJH"}, CountryId{"JP"}, Coordinate{134.787, 35.5128}}, // Tajima Airport
    Airport{IataCode{"TJI"}, CountryId{"HN"}, Coordinate{-85.9383, 15.9269}}, // Trujillo Airport
    Airport{IataCode{"TJK"}, CountryId{"TR"}, Coordinate{36.3736, 40.3117}}, // Tokat Airport
    Airport{IataCode{"TJL"}, CountryId{"BR"}, Coordinate{-51.6802, -20.7548}}, // Três Lagoas Airport
    Airport{IataCode{"TJM"}, CountryId{"RU"}, Coordinate{65.3482, 57.1811}}, // Roshchino International Airport
    Airport{IataCode{"TJN"}, CountryId{"FR"}, Coordinate{-142.267, -15.8545}}, // Takume airport
    Airport{IataCode{"TJQ"}, CountryId{"ID"}, Coordinate{107.753, -2.75391}}, // Buluh Tumbang Airport
    Airport{IataCode{"TJS"}, CountryId{"ID"}, Coordinate{117.373, 2.83889}}, // Tanjung Harapan Airport
    Airport{IataCode{"TJU"}, CountryId{"TJ"}, Coordinate{69.805, 37.9883}}, // Kulob Airport
    Airport{IataCode{"TKA"}, CountryId{"US"}, Coordinate{-150.095, 62.32}}, // Talkeetna Airport
    Airport{IataCode{"TKB"}, CountryId{"PG"}, Coordinate{146.6, -7.667}}, // Tekadu
    Airport{IataCode{"TKC"}, CountryId{"CM"}, Coordinate{9.36028, 4.08917}}, // Tiko Airport
    Airport{IataCode{"TKD"}, CountryId{"GH"}, Coordinate{-1.77354, 4.89413}}, // Takoradi Airport
    Airport{IataCode{"TKF"}, CountryId{"US"}, Coordinate{-120.139, 39.32}}, // Truckee Tahoe Airport
    Airport{IataCode{"TKG"}, CountryId{"ID"}, Coordinate{105.176, -5.2427}}, // Radin Inten II Airport
    Airport{IataCode{"TKH"}, CountryId{"TH"}, Coordinate{100.3, 15.2783}}, // Takhli Airport
    Airport{IataCode{"TKJ"}, CountryId{"US"}, Coordinate{-142.954, 63.3294}}, // Tok Junction Airport
    Airport{IataCode{"TKK"}, CountryId{"FM"}, Coordinate{151.842, 7.45785}}, // Chuuk International Airport
    Airport{IataCode{"TKM"}, CountryId{"GT"}, Coordinate{-89.6103, 17.2262}}, // El Peten Airport
    Airport{IataCode{"TKN"}, CountryId{"JP"}, Coordinate{128.881, 27.8364}}, // Tokunoshima Airport
    Airport{IataCode{"TKO"}, CountryId{"LS"}, Coordinate{28.8847, -29.2394}}, // Tlokoeng Airport
    Airport{IataCode{"TKP"}, CountryId{"FR"}, Coordinate{-145.246, -14.71}}, // Takapoto Airport
    Airport{IataCode{"TKQ"}, CountryId{"TZ"}, Coordinate{29.6679, -4.88627}}, // Kigoma Airport
    Airport{IataCode{"TKR"}, CountryId{"BD"}, Coordinate{88.4036, 26.0164}}, // Thakurgaon STOLport
    Airport{IataCode{"TKS"}, CountryId{"JP"}, Coordinate{134.618, 34.1345}}, // Tokushima Airport
    Airport{IataCode{"TKT"}, CountryId{"TH"}, Coordinate{99.2533, 16.896}}, // Tak Airport
    Airport{IataCode{"TKU"}, CountryId{"FI"}, Coordinate{22.2743, 60.5109}}, // Turku Airport
    Airport{IataCode{"TKV"}, CountryId{"FR"}, Coordinate{-138.445, -17.3553}}, // Tatakoto Airport
    Airport{IataCode{"TKW"}, CountryId{"PG"}, Coordinate{142.15, -5.25}}, // Tekin Airport
    Airport{IataCode{"TKX"}, CountryId{"FR"}, Coordinate{-145.027, -14.4577}}, // Takaroa Airport
    Airport{IataCode{"TKZ"}, CountryId{"NZ"}, Coordinate{175.893, -38.2367}}, // Tokoroa Airport
    Airport{IataCode{"TLA"}, CountryId{"US"}, Coordinate{-166.339, 65.2403}}, // Teller Airport
    Airport{IataCode{"TLB"}, CountryId{"PK"}, Coordinate{72.6114, 33.9861}}, // Tarbela Dam Airport
    Airport{IataCode{"TLC"}, CountryId{"MX"}, Coordinate{-99.5691, 19.3363}}, // Lic. Adolfo López Mateos International Airport
    Airport{IataCode{"TLD"}, CountryId{"BW"}, Coordinate{29.1167, -22.1833}}, // Tuli Lodge Airport
    Airport{IataCode{"TLF"}, CountryId{"US"}, Coordinate{-153.278, 63.3807}}, // Telida Airport
    Airport{IataCode{"TLH"}, CountryId{"US"}, Coordinate{-84.345, 30.3957}}, // Tallahassee International Airport
    Airport{IataCode{"TLI"}, CountryId{"ID"}, Coordinate{120.794, 1.12343}}, // Sultan Bantilan Airport
    Airport{IataCode{"TLJ"}, CountryId{"US"}, Coordinate{-155.976, 62.8944}}, // Tatalina LRRS Airport
    Airport{IataCode{"TLK"}, CountryId{"RU"}, Coordinate{111.039, 59.867}}, // Talakan Airport
    Airport{IataCode{"TLL"}, CountryId{"EE"}, Coordinate{24.8012, 59.4164}}, // Tallinn Airport
    Airport{IataCode{"TLM"}, CountryId{"DZ"}, Coordinate{-1.44794, 35.0124}}, // Zenata – Messali El Hadj Airport
    Airport{IataCode{"TLN"}, CountryId{"FR"}, Coordinate{6.15862, 43.0936}}, // Toulon-Hyères Airport
    Airport{IataCode{"TLO"}, CountryId{"PG"}, Coordinate{152.01, -4.98083}}, // Tol Airport
    Airport{IataCode{"TLP"}, CountryId{"PG"}, Coordinate{141.017, -4.78333}}, // Tumolbil
    Airport{IataCode{"TLQ"}, CountryId{"CN"}, Coordinate{89.1005, 43.0268}}, // Turpan Jiaohe Airport
    Airport{IataCode{"TLR"}, CountryId{"US"}, Coordinate{-119.327, 36.1567}}, // Mefford Field Airport
    Airport{IataCode{"TLS"}, CountryId{"FR"}, Coordinate{1.37438, 43.6313}}, // Toulouse–Blagnac Airport
    Airport{IataCode{"TLT"}, CountryId{"US"}, Coordinate{-160.969, 61.0969}}, // Tuluksak Airport
    Airport{IataCode{"TLU"}, CountryId{"CO"}, Coordinate{-75.586, 9.51409}}, // Golfo de Morrosquillo Airport
    Airport{IataCode{"TLV"}, CountryId{"IL"}, Coordinate{34.8705, 32.0004}}, // Ben Gurion Airport
    Airport{IataCode{"TLX"}, CountryId{"CL"}, Coordinate{-71.6017, -35.3783}}, // Panguilemo Airport
    Airport{IataCode{"TMA"}, CountryId{"US"}, Coordinate{-83.4886, 31.4289}}, // Henry Tift Myers Airport
    Airport{IataCode{"TMB"}, CountryId{"US"}, Coordinate{-80.4328, 25.6478}}, // Miami Executive Airport
    Airport{IataCode{"TMC"}, CountryId{"ID"}, Coordinate{119.246, -9.41223}}, // Tambolaka Airport
    Airport{IataCode{"TMD"}, CountryId{"MR"}, Coordinate{-8.167, 16.233}}, // Timbedra Airport
    Airport{IataCode{"TME"}, CountryId{"CO"}, Coordinate{-71.7597, 6.45111}}, // Gabriel Vargas Santos Airport
    Airport{IataCode{"TMF"}, CountryId{"MV"}, Coordinate{73.2097, 2.20972}}, // Thimarafushi Airport
    Airport{IataCode{"TMG"}, CountryId{"MY"}, Coordinate{118.646, 5.39972}}, // Tommanggong Airport
    Airport{IataCode{"TMI"}, CountryId{"NP"}, Coordinate{87.1933, 27.315}}, // Tumlingtar Airport
    Airport{IataCode{"TMJ"}, CountryId{"UZ"}, Coordinate{67.3188, 37.2809}}, // Termez Airport
    Airport{IataCode{"TML"}, CountryId{"GH"}, Coordinate{-0.863613, 9.55217}}, // Tamale Airport
    Airport{IataCode{"TMM"}, CountryId{"MG"}, Coordinate{49.3955, -18.1144}}, // Toamasina Airport
    Airport{IataCode{"TMN"}, CountryId{"KI"}, Coordinate{175.97, -2.48624}}, // Tamana Airport
    Airport{IataCode{"TMO"}, CountryId{"VE"}, Coordinate{-61.5285, 7.24945}}, // Tumeremo Airport
    Airport{IataCode{"TMP"}, CountryId{"FI"}, Coordinate{23.6162, 61.4204}}, // Tampere-Pirkkala Airport
    Airport{IataCode{"TMQ"}, CountryId{"BF"}, Coordinate{0.0411111, 14.7908}}, // Tambao Airport
    Airport{IataCode{"TMR"}, CountryId{"DZ"}, Coordinate{5.44902, 22.8154}}, // Aguenar–Hadj Bey Akhamok Airport
    Airport{IataCode{"TMS"}, CountryId{"ST"}, Coordinate{6.71278, 0.374813}}, // São Tomé International Airport
    Airport{IataCode{"TMU"}, CountryId{"CR"}, Coordinate{-85.0167, 9.73333}}, // Tambor Airport
    Airport{IataCode{"TMW"}, CountryId{"AU"}, Coordinate{150.849, -31.0844}}, // Tamworth Regional Airport
    Airport{IataCode{"TMX"}, CountryId{"DZ"}, Coordinate{0.281451, 29.2443}}, // Timimoun Airport
    Airport{IataCode{"TMZ"}, CountryId{"NZ"}, Coordinate{175.549, -37.16}}, // Thames Aerodrome
    Airport{IataCode{"TNA"}, CountryId{"CN"}, Coordinate{117.209, 36.8513}}, // Jinan Yaoqiang International Airport
    Airport{IataCode{"TNC"}, CountryId{"US"}, Coordinate{-167.922, 65.5631}}, // Tin City LRRS Airport
    Airport{IataCode{"TND"}, CountryId{"CU"}, Coordinate{-79.9898, 21.7925}}, // Alberto Delgado Airport
    Airport{IataCode{"TNE"}, CountryId{"JP"}, Coordinate{130.992, 30.605}}, // New Tanegashima Airport
    Airport{IataCode{"TNG"}, CountryId{"MA"}, Coordinate{-5.91233, 35.7261}}, // Tangier Ibn Battouta Airport
    Airport{IataCode{"TNH"}, CountryId{"CN"}, Coordinate{125.704, 42.2539}}, // Tonghua Sanyuanpu Airport
    Airport{IataCode{"TNI"}, CountryId{"IN"}, Coordinate{80.852, 24.5645}}, // Satna Airport
    Airport{IataCode{"TNJ"}, CountryId{"ID"}, Coordinate{104.527, 0.921085}}, // Raja Haji Fisabilillah International Airport
    Airport{IataCode{"TNK"}, CountryId{"US"}, Coordinate{-165.272, 60.5756}}, // Tununak Airport
    Airport{IataCode{"TNL"}, CountryId{"UA"}, Coordinate{25.6709, 49.5385}}, // Ternopil Airport
    Airport{IataCode{"TNN"}, CountryId{"TW"}, Coordinate{120.206, 22.9503}}, // Tainan Airport
    Airport{IataCode{"TNO"}, CountryId{"CR"}, Coordinate{-85.8132, 10.3156}}, // Tamarindo Airport
    Airport{IataCode{"TNP"}, CountryId{"US"}, Coordinate{-115.946, 34.1317}}, // Twentynine Palms Airport
    Airport{IataCode{"TNQ"}, CountryId{"KI"}, Coordinate{-160.378, 4.6637}}, // Teraina Airport
    Airport{IataCode{"TNR"}, CountryId{"MG"}, Coordinate{47.4766, -18.7999}}, // Ivato Airport
    Airport{IataCode{"TNS"}, CountryId{"CA"}, Coordinate{-128.203, 61.9569}}, // Tungsten (Cantung) Airport
    Airport{IataCode{"TNT"}, CountryId{"US"}, Coordinate{-80.8969, 25.8617}}, // Dade-Collier Training and Transition Airport
    Airport{IataCode{"TNU"}, CountryId{"US"}, Coordinate{-93.0217, 41.6744}}, // Newton Municipal Airport (Iowa)
    Airport{IataCode{"TNV"}, CountryId{"KI"}, Coordinate{-159.354, 3.84472}}, // Tabuaeran Island Airport
    Airport{IataCode{"TNW"}, CountryId{"EC"}, Coordinate{-77.822, -1.06281}}, // Jumandy Airport
    Airport{IataCode{"TNX"}, CountryId{"KH"}, Coordinate{106.014, 13.5317}}, // Stung Treng Airport
    Airport{IataCode{"TOA"}, CountryId{"US"}, Coordinate{-118.34, 33.8033}}, // Zamperini Field
    Airport{IataCode{"TOB"}, CountryId{"LY"}, Coordinate{23.8375, 32.0961}}, // Tobruk Airport
    Airport{IataCode{"TOC"}, CountryId{"US"}, Coordinate{-83.2964, 34.5928}}, // Toccoa Airport
    Airport{IataCode{"TOE"}, CountryId{"TN"}, Coordinate{8.1114, 33.9353}}, // Tozeur–Nefta International Airport
    Airport{IataCode{"TOF"}, CountryId{"RU"}, Coordinate{85.2092, 56.3878}}, // Bogashevo Airport
    Airport{IataCode{"TOG"}, CountryId{"US"}, Coordinate{-160.397, 59.0536}}, // Togiak Airport
    Airport{IataCode{"TOH"}, CountryId{"VU"}, Coordinate{166.641, -13.3295}}, // Torres Airport
    Airport{IataCode{"TOI"}, CountryId{"US"}, Coordinate{-86.0122, 31.8606}}, // Troy Municipal Airport
    Airport{IataCode{"TOK"}, CountryId{"PG"}, Coordinate{155.062, -6.20114}}, // Torokina Airport
    Airport{IataCode{"TOL"}, CountryId{"US"}, Coordinate{-83.8061, 41.5925}}, // Toledo Express Airport
    Airport{IataCode{"TOM"}, CountryId{"ML"}, Coordinate{-2.997, 16.7317}}, // Timbuktu Airport
    Airport{IataCode{"TON"}, CountryId{"PG"}, Coordinate{155.6, -6.35}}, // Tonu
    Airport{IataCode{"TOO"}, CountryId{"CR"}, Coordinate{-82.9589, 8.81667}}, // San Vito de Java Airport
    Airport{IataCode{"TOP"}, CountryId{"US"}, Coordinate{-95.6225, 39.0686}}, // Philip Billard Municipal Airport
    Airport{IataCode{"TOQ"}, CountryId{"CL"}, Coordinate{-70.0652, -22.1366}}, // Barriles Airport
    Airport{IataCode{"TOR"}, CountryId{"US"}, Coordinate{-104.159, 42.063}}, // Torrington Municipal Airport
    Airport{IataCode{"TOS"}, CountryId{"NO"}, Coordinate{18.908, 69.6795}}, // Tromsø Airport
    Airport{IataCode{"TOT"}, CountryId{"SR"}, Coordinate{-56.3275, 5.86583}}, // Totness Airstrip
    Airport{IataCode{"TOU"}, CountryId{"FR"}, Coordinate{165.259, -20.79}}, // Touho Airport
    Airport{IataCode{"TOV"}, CountryId{"GB"}, Coordinate{-64.6097, 18.4614}}, // Tortola
    Airport{IataCode{"TOY"}, CountryId{"JP"}, Coordinate{137.189, 36.6438}}, // Toyama Airport
    Airport{IataCode{"TOZ"}, CountryId{"CI"}, Coordinate{-7.67361, 8.28972}}, // Mahana Airport
    Airport{IataCode{"TPA"}, CountryId{"US"}, Coordinate{-82.5357, 27.9636}}, // Tampa International Airport
    Airport{IataCode{"TPC"}, CountryId{"EC"}, Coordinate{-76.3375, -0.122778}}, // Tarapoa Airport
    Airport{IataCode{"TPE"}, CountryId{"TW"}, Coordinate{121.235, 25.0792}}, // Taoyuan International Airport
    Airport{IataCode{"TPF"}, CountryId{"US"}, Coordinate{-82.4501, 27.9125}}, // Peter O. Knight Airport
    Airport{IataCode{"TPG"}, CountryId{"MY"}, Coordinate{100.72, 4.86447}}, // Taiping Airport
    Airport{IataCode{"TPH"}, CountryId{"US"}, Coordinate{-117.087, 38.0603}}, // Tonopah Airport
    Airport{IataCode{"TPI"}, CountryId{"PG"}, Coordinate{146.989, -8.35667}}, // Tapini Airport
    Airport{IataCode{"TPJ"}, CountryId{"NP"}, Coordinate{87.6972, 27.3515}}, // Taplejung Airport
    Airport{IataCode{"TPL"}, CountryId{"US"}, Coordinate{-97.4078, 31.1519}}, // Draughon-Miller Central Texas Regional Airport
    Airport{IataCode{"TPN"}, CountryId{"EC"}, Coordinate{-75.5264, -0.78333}}, // Tiputini Airport
    Airport{IataCode{"TPQ"}, CountryId{"MX"}, Coordinate{-104.843, 21.4195}}, // Amado Nervo International Airport
    Airport{IataCode{"TPR"}, CountryId{"AU"}, Coordinate{117.869, -22.7461}}, // Tom Price Airport
    Airport{IataCode{"TPS"}, CountryId{"IT"}, Coordinate{12.4961, 37.9018}}, // Vincenzo Florio Airport Trapani-Birgi
    Airport{IataCode{"TPU"}, CountryId{"NP"}, Coordinate{81.15, 28.5169}}, // Tikapur Airport
    Airport{IataCode{"TQH"}, CountryId{"US"}, Coordinate{-95.0044, 35.9303}}, // Tahlequah Municipal Airport
    Airport{IataCode{"TQN"}, CountryId{"AF"}, Coordinate{69.5324, 36.7707}}, // Taloqan Airport
    Airport{IataCode{"TQP"}, CountryId{"AU"}, Coordinate{140.888, -21.835}}, // Trepell Airport
    Airport{IataCode{"TRA"}, CountryId{"JP"}, Coordinate{124.677, 24.6541}}, // Tarama Airport
    Airport{IataCode{"TRB"}, CountryId{"CO"}, Coordinate{-76.7483, 8.06667}}, // Gonzalo Mejia Airport
    Airport{IataCode{"TRC"}, CountryId{"MX"}, Coordinate{-103.399, 25.5634}}, // Francisco Sarabia International Airport
    Airport{IataCode{"TRD"}, CountryId{"NO"}, Coordinate{10.9139, 63.4541}}, // Trondheim Airport
    Airport{IataCode{"TRE"}, CountryId{"GB"}, Coordinate{-6.87888, 56.4984}}, // Tiree Airport
    Airport{IataCode{"TRF"}, CountryId{"NO"}, Coordinate{10.2586, 59.1867}}, // Sandefjord Airport, Torp
    Airport{IataCode{"TRG"}, CountryId{"NZ"}, Coordinate{176.198, -37.671}}, // Tauranga Airport
    Airport{IataCode{"TRH"}, CountryId{"US"}, Coordinate{-117.327, 35.8125}}, // Trona Airport
    Airport{IataCode{"TRI"}, CountryId{"US"}, Coordinate{-82.4076, 36.4812}}, // Tri-Cities Regional Airport
    Airport{IataCode{"TRJ"}, CountryId{"PG"}, Coordinate{141.043, -5.61428}}, // Tarabits Airport
    Airport{IataCode{"TRK"}, CountryId{"ID"}, Coordinate{117.568, 3.32407}}, // Juwata International Airport
    Airport{IataCode{"TRL"}, CountryId{"US"}, Coordinate{-96.2674, 32.7092}}, // Terrell Municipal Airport
    Airport{IataCode{"TRM"}, CountryId{"US"}, Coordinate{-116.16, 33.6267}}, // Jacqueline Cochran Regional Airport
    Airport{IataCode{"TRN"}, CountryId{"IT"}, Coordinate{7.64309, 45.192}}, // Turin Airport
    Airport{IataCode{"TRO"}, CountryId{"AU"}, Coordinate{152.509, -31.8904}}, // Taree Airport
    Airport{IataCode{"TRQ"}, CountryId{"BR"}, Coordinate{-70.7828, -8.15472}}, // Tarauacá Airport
    Airport{IataCode{"TRS"}, CountryId{"IT"}, Coordinate{13.4845, 45.8209}}, // Trieste – Friuli Venezia Giulia Airport
    Airport{IataCode{"TRU"}, CountryId{"PE"}, Coordinate{-79.1079, -8.08555}}, // Cap. FAP Carlos Martínez de Pinillos International Airport
    Airport{IataCode{"TRV"}, CountryId{"IN"}, Coordinate{76.92, 8.48222}}, // Trivandrum International Airport
    Airport{IataCode{"TRW"}, CountryId{"KI"}, Coordinate{173.146, 1.38026}}, // Bonriki International Airport
    Airport{IataCode{"TRX"}, CountryId{"US"}, Coordinate{-93.5906, 40.0836}}, // Trenton Municipal Airport
    Airport{IataCode{"TRY"}, CountryId{"UG"}, Coordinate{34.1667, 0.68}}, // Tororo Airport
    Airport{IataCode{"TRZ"}, CountryId{"IN"}, Coordinate{78.7084, 10.7612}}, // Tiruchirapalli Airport
    Airport{IataCode{"TSB"}, CountryId{"NA"}, Coordinate{17.7256, -19.2619}}, // Tsumeb Airport
    Airport{IataCode{"TSC"}, CountryId{"EC"}, Coordinate{-77.5031, -2.38167}}, // Taisha Airport
    Airport{IataCode{"TSF"}, CountryId{"IT"}, Coordinate{12.2046, 45.6546}}, // Treviso Airport
    Airport{IataCode{"TSG"}, CountryId{"US"}, Coordinate{-143.336, 63.3744}}, // Tanacross Airport
    Airport{IataCode{"TSH"}, CountryId{"CD"}, Coordinate{20.7947, -6.43833}}, // Tshikapa Airport
    Airport{IataCode{"TSI"}, CountryId{"PG"}, Coordinate{146.35, -6.85}}, // Tsili Tsili
    Airport{IataCode{"TSJ"}, CountryId{"JP"}, Coordinate{129.331, 34.285}}, // Tsushima Airport
    Airport{IataCode{"TSK"}, CountryId{"PG"}, Coordinate{150.417, -2.58333}}, // Taskul
    Airport{IataCode{"TSL"}, CountryId{"MX"}, Coordinate{-98.8067, 22.0378}}, // Tamuín National Airport
    Airport{IataCode{"TSM"}, CountryId{"US"}, Coordinate{-105.673, 36.4581}}, // Taos Regional Airport
    Airport{IataCode{"TSN"}, CountryId{"CN"}, Coordinate{117.355, 39.1319}}, // Tianjin Binhai International Airport
    Airport{IataCode{"TSP"}, CountryId{"US"}, Coordinate{-118.439, 35.135}}, // Tehachapi Municipal Airport
    Airport{IataCode{"TSR"}, CountryId{"RO"}, Coordinate{21.3203, 45.8102}}, // Traian Vuia International Airport
    Airport{IataCode{"TST"}, CountryId{"TH"}, Coordinate{99.6166, 7.50874}}, // Trang Airport
    Airport{IataCode{"TSU"}, CountryId{"KI"}, Coordinate{175.065, -1.47439}}, // Tabiteuea Süd Airport
    Airport{IataCode{"TSV"}, CountryId{"AU"}, Coordinate{146.771, -19.2563}}, // Townsville Airport
    Airport{IataCode{"TSW"}, CountryId{"PG"}, Coordinate{146.033, -6.96712}}, // Tsewi
    Airport{IataCode{"TSY"}, CountryId{"ID"}, Coordinate{108.246, -7.3466}}, // Tasikmalaya Airport
    Airport{IataCode{"TTA"}, CountryId{"MA"}, Coordinate{-11.1591, 28.4454}}, // Tan Tan Airport
    Airport{IataCode{"TTB"}, CountryId{"IT"}, Coordinate{9.67737, 39.9224}}, // Tortolì-Arbatax Airport
    Airport{IataCode{"TTC"}, CountryId{"CL"}, Coordinate{-70.3778, -25.5628}}, // Las Breas Airport
    Airport{IataCode{"TTD"}, CountryId{"US"}, Coordinate{-122.401, 45.5494}}, // Portland-Troutdale Airport
    Airport{IataCode{"TTE"}, CountryId{"ID"}, Coordinate{127.377, 0.833189}}, // Babullah Airport
    Airport{IataCode{"TTG"}, CountryId{"AR"}, Coordinate{-63.8183, -22.6283}}, // Tartagal "General Enrique Mosconi" Airport
    Airport{IataCode{"TTJ"}, CountryId{"JP"}, Coordinate{134.168, 35.5267}}, // Tottori Airport
    Airport{IataCode{"TTM"}, CountryId{"CO"}, Coordinate{-72.1006, 5.72639}}, // Tablón de Tamará Airport
    Airport{IataCode{"TTN"}, CountryId{"US"}, Coordinate{-74.8133, 40.2767}}, // Trenton-Mercer Airport
    Airport{IataCode{"TTO"}, CountryId{"US"}, Coordinate{-97.7428, 45.815}}, // Britton Municipal Airport
    Airport{IataCode{"TTQ"}, CountryId{"CR"}, Coordinate{-83.5167, 10.5667}}, // Tortuguero Airport
    Airport{IataCode{"TTS"}, CountryId{"MG"}, Coordinate{47.6167, -16.75}}, // Tsaratanana Airport
    Airport{IataCode{"TTT"}, CountryId{"TW"}, Coordinate{121.107, 22.7563}}, // Taitung Airport
    Airport{IataCode{"TTU"}, CountryId{"MA"}, Coordinate{-5.33108, 35.5911}}, // Sania Ramel Airport
    Airport{IataCode{"TUA"}, CountryId{"EC"}, Coordinate{-77.7066, 0.812271}}, // Teniente Coronel Luis a Mantilla International Airport
    Airport{IataCode{"TUB"}, CountryId{"FR"}, Coordinate{-149.529, -23.371}}, // Tubuai – Mataura Airport
    Airport{IataCode{"TUC"}, CountryId{"AR"}, Coordinate{-65.1083, -26.8358}}, // Teniente Benjamín Matienzo International Airport
    Airport{IataCode{"TUD"}, CountryId{"SN"}, Coordinate{-13.6593, 13.7342}}, // Tambacounda Airport
    Airport{IataCode{"TUF"}, CountryId{"FR"}, Coordinate{0.7191, 47.4258}}, // Tours Val de Loire Airport
    Airport{IataCode{"TUG"}, CountryId{"PH"}, Coordinate{121.731, 17.6383}}, // Tuguegarao Airport
    Airport{IataCode{"TUI"}, CountryId{"SA"}, Coordinate{38.7339, 31.6889}}, // Turaif Domestic Airport
    Airport{IataCode{"TUK"}, CountryId{"PK"}, Coordinate{63.0279, 25.9888}}, // Turbat International Airport
    Airport{IataCode{"TUL"}, CountryId{"US"}, Coordinate{-95.8881, 36.1983}}, // Tulsa International Airport
    Airport{IataCode{"TUM"}, CountryId{"AU"}, Coordinate{148.241, -35.2628}}, // Tumut Airport
    Airport{IataCode{"TUN"}, CountryId{"TN"}, Coordinate{10.2168, 36.8422}}, // Tunis–Carthage International Airport
    Airport{IataCode{"TUO"}, CountryId{"NZ"}, Coordinate{176.083, -38.7395}}, // Taupo Airport
    Airport{IataCode{"TUP"}, CountryId{"US"}, Coordinate{-88.77, 34.2681}}, // Tupelo Regional Airport
    Airport{IataCode{"TUR"}, CountryId{"BR"}, Coordinate{-49.7167, -3.7812}}, // Tucuruí Airport
    Airport{IataCode{"TUU"}, CountryId{"SA"}, Coordinate{36.5984, 28.3721}}, // Tabuk Regional Airport
    Airport{IataCode{"TUV"}, CountryId{"VE"}, Coordinate{-62.0942, 9.08889}}, // San Rafael Airport (Venezuela)
    Airport{IataCode{"TUX"}, CountryId{"CA"}, Coordinate{-120.931, 55.0272}}, // Tumbler Ridge Airport
    Airport{IataCode{"TVA"}, CountryId{"MG"}, Coordinate{44.9167, -17.8503}}, // Morafenobe Airport
    Airport{IataCode{"TVC"}, CountryId{"US"}, Coordinate{-85.5796, 44.7372}}, // Cherry Capital Airport
    Airport{IataCode{"TVF"}, CountryId{"US"}, Coordinate{-96.185, 48.0656}}, // Thief River Falls Regional Airport
    Airport{IataCode{"TVI"}, CountryId{"US"}, Coordinate{-83.881, 30.8986}}, // Thomasville Regional Airport
    Airport{IataCode{"TVK"}, CountryId{"US"}, Coordinate{-92.9011, 40.6844}}, // Centerville Municipal Airport
    Airport{IataCode{"TVL"}, CountryId{"US"}, Coordinate{-119.999, 38.8925}}, // Lake Tahoe Airport
    Airport{IataCode{"TVS"}, CountryId{"CN"}, Coordinate{117.993, 39.7231}}, // Tangshan Sannühe Airport
    Airport{IataCode{"TVU"}, CountryId{"FJ"}, Coordinate{-179.881, -16.6879}}, // Matei Airport
    Airport{IataCode{"TVY"}, CountryId{"MM"}, Coordinate{98.2029, 14.1003}}, // Dawei Airport
    Airport{IataCode{"TWA"}, CountryId{"US"}, Coordinate{-160.275, 59.0744}}, // Twin Hills Airport
    Airport{IataCode{"TWC"}, CountryId{"CN"}, Coordinate{78.99, 39.8806}}, // Tumxuk Tangwangcheng Airport
    Airport{IataCode{"TWD"}, CountryId{"US"}, Coordinate{-122.811, 48.0539}}, // Jefferson County International Airport
    Airport{IataCode{"TWF"}, CountryId{"US"}, Coordinate{-114.488, 42.4818}}, // Magic Valley Regional Airport
    Airport{IataCode{"TWU"}, CountryId{"MY"}, Coordinate{118.114, 4.31381}}, // Tawau Airport
    Airport{IataCode{"TWY"}, CountryId{"PG"}, Coordinate{146.117, -7.45}}, // Tawa
    Airport{IataCode{"TWZ"}, CountryId{"NZ"}, Coordinate{170.119, -44.2369}}, // Pukaki Airport
    Airport{IataCode{"TXE"}, CountryId{"ID"}, Coordinate{96.8494, 4.72083}}, // Takengon Rembele Airport
    Airport{IataCode{"TXK"}, CountryId{"US"}, Coordinate{-93.9942, 33.4569}}, // Texarkana Regional Airport
    Airport{IataCode{"TXL"}, CountryId{"DE"}, Coordinate{13.2932, 52.5538}}, // Berlin Tegel Airport
    Airport{IataCode{"TXN"}, CountryId{"CN"}, Coordinate{118.253, 29.7303}}, // Huangshan Tunxi International Airport
    Airport{IataCode{"TXU"}, CountryId{"CI"}, Coordinate{-7.36273, 4.43781}}, // Tabou Airport
    Airport{IataCode{"TYB"}, CountryId{"AU"}, Coordinate{142.058, -29.4517}}, // Tibooburra Airport
    Airport{IataCode{"TYD"}, CountryId{"RU"}, Coordinate{124.76, 55.282}}, // Tynda Airport
    Airport{IataCode{"TYE"}, CountryId{"US"}, Coordinate{-151.138, 61.0767}}, // Tyonek Airport
    Airport{IataCode{"TYF"}, CountryId{"SE"}, Coordinate{12.9925, 60.1502}}, // Torsby Airport
    Airport{IataCode{"TYL"}, CountryId{"PE"}, Coordinate{-81.2561, -4.57596}}, // Cap. FAP Víctor Montes Arias Airport
    Airport{IataCode{"TYM"}, CountryId{"BS"}, Coordinate{-76.4403, 24.1625}}, // Staniel Cay Airport
    Airport{IataCode{"TYN"}, CountryId{"CN"}, Coordinate{112.628, 37.7524}}, // Taiyuan Wusu International Airport
    Airport{IataCode{"TYQ"}, CountryId{"US"}, Coordinate{-86.2514, 40.0306}}, // Indianapolis Executive Airport
    Airport{IataCode{"TYR"}, CountryId{"US"}, Coordinate{-95.4095, 32.3511}}, // Tyler Pounds Regional Airport
    Airport{IataCode{"TYS"}, CountryId{"US"}, Coordinate{-83.9907, 35.8063}}, // McGhee Tyson Airport
    Airport{IataCode{"TYT"}, CountryId{"UY"}, Coordinate{-54.3472, -33.195}}, // Treinta y Tres Airport
    Airport{IataCode{"TYZ"}, CountryId{"US"}, Coordinate{-110.115, 34.4528}}, // Taylor Airport
    Airport{IataCode{"TZA"}, CountryId{"BZ"}, Coordinate{-88.1917, 17.5164}}, // Belize City Municipal Airport
    Airport{IataCode{"TZC"}, CountryId{"US"}, Coordinate{-83.4453, 43.4586}}, // Tuscola Area Airport
    Airport{IataCode{"TZL"}, CountryId{"BA"}, Coordinate{18.7103, 44.4639}}, // Tuzla International Airport
    Airport{IataCode{"TZM"}, CountryId{"MX"}, Coordinate{-88.1722, 21.1553}}, // Cupul aerodrome
    Airport{IataCode{"TZN"}, CountryId{"BS"}, Coordinate{-77.5838, 24.1566}}, // South Andros Airport
    Airport{IataCode{"TZR"}, CountryId{"US"}, Coordinate{-83.1369, 39.9011}}, // Bolton Field
    Airport{IataCode{"TZX"}, CountryId{"TR"}, Coordinate{39.7811, 40.9947}}, // Trabzon Airport
    Airport{IataCode{"UAC"}, CountryId{"MX"}, Coordinate{-114.798, 32.4453}}, // San Luis Río Colorado Airport
    Airport{IataCode{"UAE"}, CountryId{"PG"}, Coordinate{144.65, -6.23333}}, // Mount Aue
    Airport{IataCode{"UAH"}, CountryId{"FR"}, Coordinate{-139.555, -8.93525}}, // Ua Huka Airport
    Airport{IataCode{"UAI"}, CountryId{"TL"}, Coordinate{125.283, -9.30216}}, // Suai Airport
    Airport{IataCode{"UAL"}, CountryId{"AO"}, Coordinate{22.2313, -10.7107}}, // Luau Villa Teixeira de Sousa  Airport
    Airport{IataCode{"UAO"}, CountryId{"US"}, Coordinate{-122.77, 45.2472}}, // Aurora State Airport
    Airport{IataCode{"UAP"}, CountryId{"FR"}, Coordinate{-140.078, -9.3522}}, // Ua Pou Airport
    Airport{IataCode{"UAQ"}, CountryId{"AR"}, Coordinate{-68.4226, -31.5717}}, // Domingo Faustino Sarmiento Airport
    Airport{IataCode{"UAR"}, CountryId{"MA"}, Coordinate{-1.97833, 32.5144}}, // Bouarfa Airport
    Airport{IataCode{"UAS"}, CountryId{"KE"}, Coordinate{37.5342, 0.53056}}, // Samburu Airport
    Airport{IataCode{"UAX"}, CountryId{"GT"}, Coordinate{-89.6347, 17.3931}}, // Uaxactun Airport
    Airport{IataCode{"UBA"}, CountryId{"BR"}, Coordinate{-47.9618, -19.7657}}, // Uberaba Airport
    Airport{IataCode{"UBB"}, CountryId{"AU"}, Coordinate{142.197, -9.95167}}, // Mabuiag Island Airport
    Airport{IataCode{"UBJ"}, CountryId{"JP"}, Coordinate{131.275, 33.9329}}, // Yamaguchi Ube Airport
    Airport{IataCode{"UBN"}, CountryId{"MN"}, Coordinate{106.819, 47.6434}}, // New Ulaanbaatar International Airport
    Airport{IataCode{"UBP"}, CountryId{"TH"}, Coordinate{104.871, 15.2469}}, // Ubon Ratchathani Airport
    Airport{IataCode{"UBS"}, CountryId{"US"}, Coordinate{-88.3803, 33.4653}}, // Columbus-Lowndes County Airport
    Airport{IataCode{"UBT"}, CountryId{"BR"}, Coordinate{-45.0761, -23.4414}}, // Ubatuba Airport
    Airport{IataCode{"UCB"}, CountryId{"CN"}, Coordinate{113.11, 41.1265}}, // Ulanqab Jining Airport
    Airport{IataCode{"UCC"}, CountryId{"US"}, Coordinate{-116.038, 36.9458}}, // Yucca Airstrip
    Airport{IataCode{"UCK"}, CountryId{"UA"}, Coordinate{25.4858, 50.6806}}, // Lutsk Airport
    Airport{IataCode{"UCN"}, CountryId{"LR"}, Coordinate{-10.0575, 5.90389}}, // Buchanan Airport
    Airport{IataCode{"UCP"}, CountryId{"US"}, Coordinate{-80.4133, 41.0253}}, // New Castle Municipal Airport
    Airport{IataCode{"UCT"}, CountryId{"RU"}, Coordinate{53.8054, 63.5556}}, // Ukhta Airport
    Airport{IataCode{"UCY"}, CountryId{"US"}, Coordinate{-88.9826, 36.3829}}, // Everett-Stewart Regional Airport
    Airport{IataCode{"UCZ"}, CountryId{"PE"}, Coordinate{-76.35, -8.467}}, // Uchiza Airport
    Airport{IataCode{"UDD"}, CountryId{"US"}, Coordinate{-116.275, 33.7483}}, // Bermuda Dunes Airport
    Airport{IataCode{"UDG"}, CountryId{"US"}, Coordinate{-79.8903, 34.449}}, // Darlington County Jetport
    Airport{IataCode{"UDI"}, CountryId{"BR"}, Coordinate{-48.2307, -18.8895}}, // Uberlândia Airport
    Airport{IataCode{"UDJ"}, CountryId{"UA"}, Coordinate{22.2723, 48.6379}}, // Uzhhorod International Airport
    Airport{IataCode{"UDL"}, CountryId{"ID"}, Coordinate{121.415, 1.10472}}, // Buol Airport
    Airport{IataCode{"UDN"}, CountryId{"IT"}, Coordinate{13.0384, 45.977}}, // Udine-Campoformido Airport
    Airport{IataCode{"UDR"}, CountryId{"IN"}, Coordinate{73.8961, 24.6178}}, // Udaipur Airport
    Airport{IataCode{"UEL"}, CountryId{"MZ"}, Coordinate{36.8667, -17.8764}}, // Quelimane Airport
    Airport{IataCode{"UEO"}, CountryId{"JP"}, Coordinate{126.718, 26.3649}}, // Kumejima Airport
    Airport{IataCode{"UES"}, CountryId{"US"}, Coordinate{-88.2376, 43.0389}}, // Waukesha County Airport
    Airport{IataCode{"UET"}, CountryId{"PK"}, Coordinate{66.9487, 30.249}}, // Quetta International Airport
    Airport{IataCode{"UFA"}, CountryId{"RU"}, Coordinate{55.8844, 54.5651}}, // Ufa International Airport
    Airport{IataCode{"UGA"}, CountryId{"MN"}, Coordinate{103.484, 48.8542}}, // Bulgan Airport
    Airport{IataCode{"UGB"}, CountryId{"US"}, Coordinate{-157.74, 57.4253}}, // Ugashik Bay Airport
    Airport{IataCode{"UGC"}, CountryId{"UZ"}, Coordinate{60.6335, 41.5849}}, // Urgench International Airport
    Airport{IataCode{"UGN"}, CountryId{"US"}, Coordinate{-87.8678, 42.4222}}, // Waukegan Regional Airport
    Airport{IataCode{"UGO"}, CountryId{"AO"}, Coordinate{15.0297, -7.60211}}, // Uíge Airport
    Airport{IataCode{"UGS"}, CountryId{"US"}, Coordinate{-157.396, 57.5233}}, // Ugashik Airport
    Airport{IataCode{"UHE"}, CountryId{"CZ"}, Coordinate{17.4416, 49.0413}}, // Kunovice Airport
    Airport{IataCode{"UIB"}, CountryId{"CO"}, Coordinate{-76.6441, 5.69094}}, // El Caraño Airport
    Airport{IataCode{"UIH"}, CountryId{"VN"}, Coordinate{109.049, 13.9537}}, // Phu Cat Airport
    Airport{IataCode{"UII"}, CountryId{"HN"}, Coordinate{-86.8803, 16.1131}}, // Utila Airport
    Airport{IataCode{"UIK"}, CountryId{"RU"}, Coordinate{102.569, 58.134}}, // Ust-Ilimsk Airport
    Airport{IataCode{"UIL"}, CountryId{"US"}, Coordinate{-124.563, 47.9367}}, // Quillayute Airport
    Airport{IataCode{"UIN"}, CountryId{"US"}, Coordinate{-91.1947, 39.9428}}, // Quincy Regional Airport
    Airport{IataCode{"UIO"}, CountryId{"EC"}, Coordinate{-78.3601, -0.12483}}, // Mariscal Sucre International Airport
    Airport{IataCode{"UIP"}, CountryId{"FR"}, Coordinate{-4.17466, 47.9729}}, // Quimper – Cornouaille Airport
    Airport{IataCode{"UIR"}, CountryId{"AU"}, Coordinate{150.518, -31.4983}}, // Quirindi Airport
    Airport{IataCode{"UIT"}, CountryId{"MH"}, Coordinate{169.637, 5.90917}}, // Jaluit Airport
    Airport{IataCode{"UJE"}, CountryId{"MH"}, Coordinate{165.762, 8.92806}}, // Ujae Airport
    Airport{IataCode{"UJN"}, CountryId{"KR"}, Coordinate{129.465, 36.7788}}, // Uljin Airport
    Airport{IataCode{"UJU"}, CountryId{"KP"}, Coordinate{124.499, 40.1517}}, // Uiju Airfield
    Airport{IataCode{"UKA"}, CountryId{"KE"}, Coordinate{39.5719, -4.29742}}, // Ukunda Airport
    Airport{IataCode{"UKB"}, CountryId{"JP"}, Coordinate{135.229, 34.6373}}, // Kobe Airport
    Airport{IataCode{"UKG"}, CountryId{"RU"}, Coordinate{135.647, 70.0111}}, // Ust-Kuyga Airport
    Airport{IataCode{"UKI"}, CountryId{"US"}, Coordinate{-123.201, 39.1258}}, // Ukiah Municipal Airport
    Airport{IataCode{"UKK"}, CountryId{"KZ"}, Coordinate{82.5061, 50.026}}, // Oskemen Airport
    Airport{IataCode{"UKL"}, CountryId{"US"}, Coordinate{-95.725, 38.3025}}, // Coffey County Airport
    Airport{IataCode{"UKR"}, CountryId{"YE"}, Coordinate{45.65, 13.9333}}, // Mukeiras Airport
    Airport{IataCode{"UKS"}, CountryId{"RU"}, Coordinate{33.5833, 44.6833}}, // Sevastopol International Airport
    Airport{IataCode{"UKT"}, CountryId{"US"}, Coordinate{-75.3803, 40.4364}}, // Quakertown Airport
    Airport{IataCode{"UKU"}, CountryId{"PG"}, Coordinate{142.483, -3.667}}, // Nuku Airport
    Airport{IataCode{"UKX"}, CountryId{"RU"}, Coordinate{105.716, 56.8572}}, // Ust-Kut Airport
    Airport{IataCode{"ULA"}, CountryId{"AR"}, Coordinate{-67.8023, -49.309}}, // Capitán José Daniel Vazquez Airport
    Airport{IataCode{"ULB"}, CountryId{"VU"}, Coordinate{168.283, -16.333}}, // Ulei Airport
    Airport{IataCode{"ULC"}, CountryId{"CL"}, Coordinate{-70.7, -33.4936}}, // Los Cerrillos Airport
    Airport{IataCode{"ULD"}, CountryId{"ZA"}, Coordinate{31.4161, -28.3206}}, // Prince M. Buthelezi Airport
    Airport{IataCode{"ULE"}, CountryId{"PG"}, Coordinate{151.297, -4.97472}}, // Sule Airport
    Airport{IataCode{"ULG"}, CountryId{"MN"}, Coordinate{89.9197, 48.9917}}, // Ölgii Airport
    Airport{IataCode{"ULH"}, CountryId{"SA"}, Coordinate{38.117, 26.478}}, // Prince Abdul Majeed bin Abdul Aziz Domestic Airport
    Airport{IataCode{"ULK"}, CountryId{"RU"}, Coordinate{114.832, 60.7226}}, // Lensk Airport
    Airport{IataCode{"ULM"}, CountryId{"US"}, Coordinate{-94.5007, 44.3231}}, // New Ulm Municipal Airport
    Airport{IataCode{"ULN"}, CountryId{"MN"}, Coordinate{106.763, 47.8528}}, // Chinggis Khaan International Airport
    Airport{IataCode{"ULO"}, CountryId{"MN"}, Coordinate{92.0797, 49.9733}}, // Ulaangom Airport
    Airport{IataCode{"ULP"}, CountryId{"AU"}, Coordinate{144.257, -26.6086}}, // Quilpie Airport
    Airport{IataCode{"ULQ"}, CountryId{"CO"}, Coordinate{-76.2239, 4.08902}}, // Heriberto Gíl Martínez Airport
    Airport{IataCode{"ULU"}, CountryId{"UG"}, Coordinate{32.2725, 2.79022}}, // Gulu Airport
    Airport{IataCode{"ULV"}, CountryId{"RU"}, Coordinate{48.2336, 54.2868}}, // Ulyanovsk Baratayevka Airport
    Airport{IataCode{"ULY"}, CountryId{"RU"}, Coordinate{48.8003, 54.414}}, // Ulyanovsk Vostochny Airport
    Airport{IataCode{"ULZ"}, CountryId{"MN"}, Coordinate{96.5294, 47.7122}}, // Donoi Airport
    Airport{IataCode{"UMC"}, CountryId{"PG"}, Coordinate{145.966, -7.01696}}, // Umba Airport
    Airport{IataCode{"UME"}, CountryId{"SE"}, Coordinate{20.2889, 63.7933}}, // Umeå Airport
    Airport{IataCode{"UMM"}, CountryId{"US"}, Coordinate{-149.127, 63.3314}}, // Summit Airport
    Airport{IataCode{"UMP"}, CountryId{"US"}, Coordinate{-86.045, 39.9353}}, // Indianapolis Metropolitan Airport
    Airport{IataCode{"UMS"}, CountryId{"RU"}, Coordinate{134.449, 60.3639}}, // Ust-Maya Airport
    Airport{IataCode{"UMT"}, CountryId{"US"}, Coordinate{-152.135, 69.3711}}, // Umiat Airport
    Airport{IataCode{"UMU"}, CountryId{"BR"}, Coordinate{-53.3139, -23.7992}}, // Umuarama Airport
    Airport{IataCode{"UMY"}, CountryId{"UA"}, Coordinate{34.7625, 50.8583}}, // Sumy Airport
    Airport{IataCode{"UMZ"}, CountryId{"US"}, Coordinate{-94.2028, 34.5453}}, // Mena Intermountain Municipal Airport
    Airport{IataCode{"UNA"}, CountryId{"BR"}, Coordinate{-38.9972, -15.3533}}, // Una-Comandatuba Airport
    Airport{IataCode{"UNE"}, CountryId{"LS"}, Coordinate{28.6711, -30.1111}}, // Qacha's Nek Airport
    Airport{IataCode{"UNG"}, CountryId{"PG"}, Coordinate{141.286, -6.12555}}, // Kiunga Airport
    Airport{IataCode{"UNI"}, CountryId{"VC"}, Coordinate{-61.4136, 12.6}}, // Union Island Airport
    Airport{IataCode{"UNK"}, CountryId{"US"}, Coordinate{-160.799, 63.8883}}, // Unalakleet Airport
    Airport{IataCode{"UNN"}, CountryId{"TH"}, Coordinate{98.5874, 9.77382}}, // Ranong Airport
    Airport{IataCode{"UNO"}, CountryId{"US"}, Coordinate{-91.9028, 36.8783}}, // West Plains Regional Airport
    Airport{IataCode{"UNU"}, CountryId{"US"}, Coordinate{-88.7039, 43.4264}}, // Dodge County Airport
    Airport{IataCode{"UOS"}, CountryId{"US"}, Coordinate{-85.8981, 35.2053}}, // Franklin County Airport
    Airport{IataCode{"UOX"}, CountryId{"US"}, Coordinate{-89.5367, 34.3844}}, // University-Oxford Airport
    Airport{IataCode{"UPB"}, CountryId{"CU"}, Coordinate{-82.5794, 23.0328}}, // Playa Baracoa Airport
    Airport{IataCode{"UPG"}, CountryId{"ID"}, Coordinate{119.547, -5.06809}}, // Sultan Hasanuddin International Airport
    Airport{IataCode{"UPN"}, CountryId{"MX"}, Coordinate{-102.039, 19.3967}}, // Lic. y Gen. Ignacio López Rayón International Airport
    Airport{IataCode{"UPP"}, CountryId{"US"}, Coordinate{-155.858, 20.2649}}, // Upolu Airport
    Airport{IataCode{"URA"}, CountryId{"KZ"}, Coordinate{51.5382, 51.1535}}, // Oral Ak Zhol Airport
    Airport{IataCode{"URB"}, CountryId{"BR"}, Coordinate{-51.5665, -20.777}}, // Urubupunga Airport
    Airport{IataCode{"URC"}, CountryId{"CN"}, Coordinate{87.4718, 43.9001}}, // Ürümqi Diwopu International Airport
    Airport{IataCode{"URE"}, CountryId{"EE"}, Coordinate{22.5052, 58.2321}}, // Kuressaare Airport
    Airport{IataCode{"URG"}, CountryId{"BR"}, Coordinate{-57.0357, -29.784}}, // Ruben Berta International Airport
    Airport{IataCode{"URJ"}, CountryId{"RU"}, Coordinate{64.8239, 60.1169}}, // Uray Airport
    Airport{IataCode{"URO"}, CountryId{"FR"}, Coordinate{1.18728, 49.3889}}, // Rouen Airport
    Airport{IataCode{"URR"}, CountryId{"CO"}, Coordinate{-76.1406, 6.32771}}, // Urrao Airport
    Airport{IataCode{"URS"}, CountryId{"RU"}, Coordinate{36.2827, 51.7494}}, // Kursk Vostochny Airport
    Airport{IataCode{"URT"}, CountryId{"TH"}, Coordinate{99.1429, 9.13426}}, // Surat Thani Airport
    Airport{IataCode{"URU"}, CountryId{"PG"}, Coordinate{148.567, -9.5}}, // Uroubi
    Airport{IataCode{"URY"}, CountryId{"SA"}, Coordinate{37.2794, 31.4119}}, // Gurayat Domestic Airport
    Airport{IataCode{"USA"}, CountryId{"US"}, Coordinate{-80.7132, 35.383}}, // Concord Regional Airport
    Airport{IataCode{"USH"}, CountryId{"AR"}, Coordinate{-68.3124, -54.8396}}, // Ushuaia – Malvinas Argentinas International Airport
    Airport{IataCode{"USI"}, CountryId{"GY"}, Coordinate{-59.7833, 8.2}}, // Mabaruma Airport
    Airport{IataCode{"USK"}, CountryId{"RU"}, Coordinate{57.3762, 66.0027}}, // Usinsk Airport
    Airport{IataCode{"USM"}, CountryId{"TH"}, Coordinate{100.064, 9.54798}}, // Samui Airport
    Airport{IataCode{"USN"}, CountryId{"KR"}, Coordinate{129.356, 35.5929}}, // Ulsan Airport
    Airport{IataCode{"USQ"}, CountryId{"TR"}, Coordinate{29.4816, 38.6795}}, // Uşak Airport
    Airport{IataCode{"USR"}, CountryId{"RU"}, Coordinate{143.119, 64.5497}}, // Ust-Nera Airport
    Airport{IataCode{"USS"}, CountryId{"CU"}, Coordinate{-79.4451, 21.9696}}, // Sancti Spíritus Airport
    Airport{IataCode{"UST"}, CountryId{"US"}, Coordinate{-81.3414, 29.9565}}, // Northeast Florida Regional Airport
    Airport{IataCode{"USU"}, CountryId{"PH"}, Coordinate{120.099, 12.1197}}, // Francisco B. Reyes Airport
    Airport{IataCode{"UTA"}, CountryId{"ZW"}, Coordinate{32.625, -18.9975}}, // Mutare Airport
    Airport{IataCode{"UTB"}, CountryId{"AU"}, Coordinate{144.529, -22.5831}}, // Muttaburra Airport
    Airport{IataCode{"UTG"}, CountryId{"LS"}, Coordinate{27.6933, -30.4075}}, // Quthing Airport
    Airport{IataCode{"UTH"}, CountryId{"TH"}, Coordinate{102.788, 17.3864}}, // Udon Thani International Airport
    Airport{IataCode{"UTI"}, CountryId{"FI"}, Coordinate{26.9381, 60.8964}}, // Utti Airport
    Airport{IataCode{"UTK"}, CountryId{"MH"}, Coordinate{169.853, 11.2225}}, // Utirik Airport
    Airport{IataCode{"UTM"}, CountryId{"US"}, Coordinate{-90.3478, 34.685}}, // Tunica Municipal Airport
    Airport{IataCode{"UTN"}, CountryId{"ZA"}, Coordinate{21.2561, -28.4088}}, // Upington Airport
    Airport{IataCode{"UTO"}, CountryId{"US"}, Coordinate{-153.704, 65.9928}}, // Indian Mountain LRRS Airport
    Airport{IataCode{"UTP"}, CountryId{"TH"}, Coordinate{100.998, 12.675}}, // U-Tapao International Airport
    Airport{IataCode{"UTS"}, CountryId{"RU"}, Coordinate{52.1989, 65.4333}}, // Ust-Tsylma Airport
    Airport{IataCode{"UTT"}, CountryId{"ZA"}, Coordinate{28.6718, -31.5488}}, // Mthatha Airport
    Airport{IataCode{"UTU"}, CountryId{"PA"}, Coordinate{-77.9347, 9.1379}}, // Ustupo Airport
    Airport{IataCode{"UUA"}, CountryId{"RU"}, Coordinate{52.7903, 54.6341}}, // Bugulma Airport
    Airport{IataCode{"UUD"}, CountryId{"RU"}, Coordinate{107.444, 51.8049}}, // Baikal International Airport
    Airport{IataCode{"UUK"}, CountryId{"US"}, Coordinate{-149.598, 70.3308}}, // Ugnu-Kuparuk Airport
    Airport{IataCode{"UUN"}, CountryId{"MN"}, Coordinate{113.285, 46.6603}}, // Baruun-Urt Airport
    Airport{IataCode{"UUS"}, CountryId{"RU"}, Coordinate{142.724, 46.8869}}, // Yuzhno-Sakhalinsk Airport
    Airport{IataCode{"UUU"}, CountryId{"PG"}, Coordinate{147.6, -8.083}}, // Manumu Airport
    Airport{IataCode{"UVA"}, CountryId{"US"}, Coordinate{-99.7436, 29.2114}}, // Garner Field
    Airport{IataCode{"UVE"}, CountryId{"FR"}, Coordinate{166.573, -20.6417}}, // Ouvéa Airport
    Airport{IataCode{"UVF"}, CountryId{"LC"}, Coordinate{-60.9501, 13.7365}}, // Hewanorra International Airport
    Airport{IataCode{"UVL"}, CountryId{"EG"}, Coordinate{30.5885, 25.4716}}, // El Kharga Airport
    Airport{IataCode{"UWA"}, CountryId{"US"}, Coordinate{-72.2147, 42.282}}, // Ware Airport
    Airport{IataCode{"UXL"}, CountryId{"US"}, Coordinate{-93.3761, 30.1314}}, // Southland Field
    Airport{IataCode{"UYF"}, CountryId{"US"}, Coordinate{-83.4619, 39.9328}}, // Madison County Airport
    Airport{IataCode{"UYL"}, CountryId{"SD"}, Coordinate{24.9, 12.0535}}, // Nyala Airport
    Airport{IataCode{"UYN"}, CountryId{"CN"}, Coordinate{109.73, 38.2742}}, // Yulin Yuyang Airport
    Airport{IataCode{"UYU"}, CountryId{"BO"}, Coordinate{-66.8431, -20.4451}}, // Joya Andina Airport
    Airport{IataCode{"UZM"}, CountryId{"CA"}, Coordinate{-106.614, 68.1639}}, // Hope Bay Aerodrome
    Airport{IataCode{"UZR"}, CountryId{"KZ"}, Coordinate{81.659, 47.0895}}, // Urzhar Airport
    Airport{IataCode{"UZU"}, CountryId{"AR"}, Coordinate{-57.9828, -29.7725}}, // Curuzú Cuatiá Airport
    Airport{IataCode{"VAA"}, CountryId{"FI"}, Coordinate{21.7642, 63.0453}}, // Vaasa Airport
    Airport{IataCode{"VAF"}, CountryId{"FR"}, Coordinate{4.96563, 44.9159}}, // Valence-Chabeuil Airport
    Airport{IataCode{"VAG"}, CountryId{"BR"}, Coordinate{-45.4763, -21.5887}}, // Varginha Airport
    Airport{IataCode{"VAH"}, CountryId{"BO"}, Coordinate{-64.0996, -18.4793}}, // Vallegrande Airport
    Airport{IataCode{"VAI"}, CountryId{"PG"}, Coordinate{141.302, -2.69717}}, // Vanimo Airport
    Airport{IataCode{"VAK"}, CountryId{"US"}, Coordinate{-165.601, 61.5408}}, // Chevak Airport
    Airport{IataCode{"VAL"}, CountryId{"BR"}, Coordinate{-38.9914, -13.3028}}, // Valenca Airport
    Airport{IataCode{"VAM"}, CountryId{"MV"}, Coordinate{72.8358, 3.47056}}, // Maamigili Airport
    Airport{IataCode{"VAN"}, CountryId{"TR"}, Coordinate{43.3377, 38.4689}}, // Van Ferit Melen Airport
    Airport{IataCode{"VAO"}, CountryId{"SB"}, Coordinate{158.731, -7.58583}}, // Suavanao Airport
    Airport{IataCode{"VAP"}, CountryId{"CL"}, Coordinate{-71.3542, -33.3568}}, // Viñamar Airport
    Airport{IataCode{"VAR"}, CountryId{"BG"}, Coordinate{27.8278, 43.237}}, // Varna Airport
    Airport{IataCode{"VAS"}, CountryId{"TR"}, Coordinate{36.9025, 39.7667}}, // Sivas Airport
    Airport{IataCode{"VAT"}, CountryId{"MG"}, Coordinate{48.95, -19.3833}}, // Vatomandry Airport
    Airport{IataCode{"VAU"}, CountryId{"FJ"}, Coordinate{177.842, -17.5}}, // Vatukoula Airport
    Airport{IataCode{"VAV"}, CountryId{"TO"}, Coordinate{-173.968, -18.586}}, // Vava'u International Airport
    Airport{IataCode{"VAW"}, CountryId{"NO"}, Coordinate{31.045, 70.3553}}, // Vardø Airport, Svartnes
    Airport{IataCode{"VBC"}, CountryId{"MM"}, Coordinate{96.0896, 21.9405}}, // Mandalay Chanmyathazi Airport
    Airport{IataCode{"VBP"}, CountryId{"MM"}, Coordinate{98.7355, 11.1511}}, // Bokpyin Airport
    Airport{IataCode{"VBS"}, CountryId{"IT"}, Coordinate{10.3269, 45.4256}}, // Brescia Airport
    Airport{IataCode{"VBT"}, CountryId{"US"}, Coordinate{-94.2194, 36.3458}}, // Bentonville Municipal Airport
    Airport{IataCode{"VBV"}, CountryId{"FJ"}, Coordinate{-178.983, -17.2667}}, // Vanuabalavu Airport
    Airport{IataCode{"VBY"}, CountryId{"SE"}, Coordinate{18.3386, 57.6604}}, // Visby Airport
    Airport{IataCode{"VCA"}, CountryId{"VN"}, Coordinate{105.712, 10.081}}, // Can Tho International Airport
    Airport{IataCode{"VCB"}, CountryId{"US"}, Coordinate{-121.962, 38.3778}}, // Nut Tree Airport
    Airport{IataCode{"VCC"}, CountryId{"CM"}, Coordinate{9.2, 4.01667}}, // Limbe Airport
    Airport{IataCode{"VCD"}, CountryId{"AU"}, Coordinate{131.003, -16.4033}}, // Victoria River Downs Airport
    Airport{IataCode{"VCE"}, CountryId{"IT"}, Coordinate{12.339, 45.5032}}, // Venice Marco Polo Airport
    Airport{IataCode{"VCF"}, CountryId{"AR"}, Coordinate{-66.1772, -40.6997}}, // Valcheta Airport
    Airport{IataCode{"VCH"}, CountryId{"UY"}, Coordinate{-54.6169, -31.7669}}, // Vichadero Airport
    Airport{IataCode{"VCL"}, CountryId{"VN"}, Coordinate{108.704, 15.4144}}, // Chu Lai Airport
    Airport{IataCode{"VCP"}, CountryId{"BR"}, Coordinate{-47.1461, -23.0077}}, // Viracopos International Airport
    Airport{IataCode{"VCR"}, CountryId{"VE"}, Coordinate{-70.0654, 10.1756}}, // Carora Airport
    Airport{IataCode{"VCS"}, CountryId{"VN"}, Coordinate{106.629, 8.7313}}, // Con Dao Airport
    Airport{IataCode{"VCT"}, CountryId{"US"}, Coordinate{-96.92, 28.8453}}, // Victoria Regional Airport
    Airport{IataCode{"VCV"}, CountryId{"US"}, Coordinate{-117.383, 34.5975}}, // Southern California Logistics Airport
    Airport{IataCode{"VDA"}, CountryId{"IL"}, Coordinate{34.9358, 29.9403}}, // Ovda Airport
    Airport{IataCode{"VDB"}, CountryId{"NO"}, Coordinate{9.29473, 61.0066}}, // Fagernes Airport, Leirin
    Airport{IataCode{"VDC"}, CountryId{"BR"}, Coordinate{-40.8625, -14.8665}}, // Vitória da Conquista Airport
    Airport{IataCode{"VDE"}, CountryId{"ES"}, Coordinate{-17.8852, 27.814}}, // El Hierro Airport
    Airport{IataCode{"VDF"}, CountryId{"US"}, Coordinate{-82.3442, 28.0112}}, // Tampa Executive Airport
    Airport{IataCode{"VDH"}, CountryId{"VN"}, Coordinate{106.59, 17.5125}}, // Dong Hoi Airport
    Airport{IataCode{"VDI"}, CountryId{"US"}, Coordinate{-82.3711, 32.1928}}, // Vidalia Regional Airport
    Airport{IataCode{"VDM"}, CountryId{"AR"}, Coordinate{-63.0055, -40.863}}, // Gobernador Edgardo Castello Airport
    Airport{IataCode{"VDO"}, CountryId{"VN"}, Coordinate{107.419, 21.1171}}, // Van Don International Airport
    Airport{IataCode{"VDP"}, CountryId{"VE"}, Coordinate{-65.9933, 9.22194}}, // Valle de la Pascua Airport
    Airport{IataCode{"VDR"}, CountryId{"AR"}, Coordinate{-65.1475, -31.9533}}, // Villa Dolores Airport
    Airport{IataCode{"VDS"}, CountryId{"NO"}, Coordinate{29.839, 70.0641}}, // Vadsø Airport
    Airport{IataCode{"VDY"}, CountryId{"IN"}, Coordinate{76.6341, 15.175}}, // Vidyanagar Airport
    Airport{IataCode{"VDZ"}, CountryId{"US"}, Coordinate{-146.243, 61.1313}}, // Valdez Airport
    Airport{IataCode{"VEE"}, CountryId{"US"}, Coordinate{-146.366, 67.0086}}, // Venetie Airport
    Airport{IataCode{"VEL"}, CountryId{"US"}, Coordinate{-109.514, 40.4426}}, // Vernal Regional Airport
    Airport{IataCode{"VER"}, CountryId{"MX"}, Coordinate{-96.1837, 19.1425}}, // General Heriberto Jara International Airport
    Airport{IataCode{"VES"}, CountryId{"US"}, Coordinate{-84.5319, 40.2044}}, // Darke County Airport
    Airport{IataCode{"VEY"}, CountryId{"IS"}, Coordinate{-20.2694, 63.4252}}, // Vestmannaeyjar Airport
    Airport{IataCode{"VFA"}, CountryId{"ZW"}, Coordinate{25.851, -18.0964}}, // Victoria Falls Airport
    Airport{IataCode{"VGA"}, CountryId{"IN"}, Coordinate{80.7926, 16.526}}, // Vijayawada Airport
    Airport{IataCode{"VGC"}, CountryId{"US"}, Coordinate{-75.5611, 42.8433}}, // Hamilton Municipal Airport
    Airport{IataCode{"VGD"}, CountryId{"RU"}, Coordinate{39.9467, 59.2817}}, // Vologda Airport
    Airport{IataCode{"VGN"}, CountryId{"PH"}, Coordinate{120.356, 17.5547}}, // Mindoro Airport
    Airport{IataCode{"VGO"}, CountryId{"ES"}, Coordinate{-8.63272, 42.225}}, // Vigo-Peinador Airport
    Airport{IataCode{"VGT"}, CountryId{"US"}, Coordinate{-115.194, 36.2106}}, // North Las Vegas Airport
    Airport{IataCode{"VGZ"}, CountryId{"CO"}, Coordinate{-76.6064, 0.978503}}, // Villa Garzón Airport
    Airport{IataCode{"VHC"}, CountryId{"AO"}, Coordinate{20.4234, -9.68828}}, // Saurimo Airport
    Airport{IataCode{"VHM"}, CountryId{"SE"}, Coordinate{16.8357, 64.5802}}, // Vilhelmina Airport
    Airport{IataCode{"VHN"}, CountryId{"US"}, Coordinate{-104.784, 31.0578}}, // Culberson County Airport
    Airport{IataCode{"VHV"}, CountryId{"RU"}, Coordinate{120.276, 63.4592}}, // Verkhnevilyuysk Airport
    Airport{IataCode{"VHY"}, CountryId{"FR"}, Coordinate{3.39904, 46.1657}}, // Vichy – Charmeil Airport
    Airport{IataCode{"VHZ"}, CountryId{"FR"}, Coordinate{-138.853, -18.78}}, // Vahitahi Airport
    Airport{IataCode{"VIA"}, CountryId{"BR"}, Coordinate{-51.1575, -27}}, // Videira Airport
    Airport{IataCode{"VIB"}, CountryId{"MX"}, Coordinate{-111.688, 25.0553}}, // Villa Constitución Airport
    Airport{IataCode{"VID"}, CountryId{"BG"}, Coordinate{22.8158, 44.0222}}, // Vidin Airfield
    Airport{IataCode{"VIE"}, CountryId{"AT"}, Coordinate{16.5643, 48.1202}}, // Wien-Schwechat Airport
    Airport{IataCode{"VIG"}, CountryId{"VE"}, Coordinate{-71.6618, 8.62263}}, // Juan Pablo Pérez Alfonso Airport
    Airport{IataCode{"VIH"}, CountryId{"US"}, Coordinate{-91.7694, 38.1275}}, // Rolla National Airport
    Airport{IataCode{"VII"}, CountryId{"VN"}, Coordinate{105.669, 18.728}}, // Vinh Airport
    Airport{IataCode{"VIJ"}, CountryId{"GB"}, Coordinate{-64.4277, 18.4504}}, // Virgin Gorda Airport
    Airport{IataCode{"VIL"}, CountryId{"MA"}, Coordinate{-15.9282, 23.714}}, // Dakhla Airport
    Airport{IataCode{"VIN"}, CountryId{"UA"}, Coordinate{28.6057, 49.2421}}, // Havryshivka Vinnytsia International Airport
    Airport{IataCode{"VIQ"}, CountryId{"TL"}, Coordinate{126.373, -8.88389}}, // Viqueque Airport
    Airport{IataCode{"VIR"}, CountryId{"ZA"}, Coordinate{31.0567, -29.7719}}, // Virginia Airport
    Airport{IataCode{"VIS"}, CountryId{"US"}, Coordinate{-119.393, 36.3186}}, // Visalia Municipal Airport
    Airport{IataCode{"VIT"}, CountryId{"ES"}, Coordinate{-2.73125, 42.8834}}, // Vitoria Airport
    Airport{IataCode{"VIX"}, CountryId{"BR"}, Coordinate{-40.2827, -20.2658}}, // Eurico de Aguiar Salles Airport
    Airport{IataCode{"VJI"}, CountryId{"US"}, Coordinate{-82.0333, 36.6871}}, // Virginia Highlands Airport
    Airport{IataCode{"VKG"}, CountryId{"VN"}, Coordinate{105.135, 9.96025}}, // Rach Gia Airport
    Airport{IataCode{"VKO"}, CountryId{"RU"}, Coordinate{37.2868, 55.6066}}, // Vnukovo International Airport
    Airport{IataCode{"VKT"}, CountryId{"RU"}, Coordinate{64.0045, 67.4903}}, // Vorkuta Airport
    Airport{IataCode{"VKX"}, CountryId{"US"}, Coordinate{-76.9558, 38.7486}}, // Potomac Airfield
    Airport{IataCode{"VLC"}, CountryId{"ES"}, Coordinate{-0.474374, 39.4922}}, // Valencia Airport
    Airport{IataCode{"VLD"}, CountryId{"US"}, Coordinate{-83.2787, 30.7892}}, // Valdosta Regional Airport
    Airport{IataCode{"VLE"}, CountryId{"US"}, Coordinate{-112.142, 35.6495}}, // Valle Airport
    Airport{IataCode{"VLG"}, CountryId{"AR"}, Coordinate{-57.0211, -37.2345}}, // Villa Gesell Airport
    Airport{IataCode{"VLI"}, CountryId{"VU"}, Coordinate{168.319, -17.7015}}, // Bauerfield International Airport
    Airport{IataCode{"VLL"}, CountryId{"ES"}, Coordinate{-4.84498, 41.706}}, // Valladolid Airport
    Airport{IataCode{"VLM"}, CountryId{"BO"}, Coordinate{-63.4073, -21.2545}}, // Lieutenant Colonel Rafael Pabón Airport
    Airport{IataCode{"VLN"}, CountryId{"VE"}, Coordinate{-67.9225, 10.1539}}, // Arturo Michelena International Airport
    Airport{IataCode{"VLP"}, CountryId{"BR"}, Coordinate{-51.1422, -9.97944}}, // Vila Rica Airport
    Airport{IataCode{"VLR"}, CountryId{"CL"}, Coordinate{-70.7572, -28.5936}}, // Vallenar Airport
    Airport{IataCode{"VLS"}, CountryId{"VU"}, Coordinate{168.177, -16.7961}}, // Valesdir Airport
    Airport{IataCode{"VLU"}, CountryId{"RU"}, Coordinate{30.61, 56.3817}}, // Velikiye Luki Airport
    Airport{IataCode{"VLV"}, CountryId{"VE"}, Coordinate{-70.5842, 9.34083}}, // Dr. Antonio Nicolás Briceño Airport
    Airport{IataCode{"VLY"}, CountryId{"GB"}, Coordinate{-4.53528, 53.2481}}, // Anglesey Airport
    Airport{IataCode{"VME"}, CountryId{"AR"}, Coordinate{-65.3735, -33.7186}}, // Villa Reynolds Airport
    Airport{IataCode{"VMI"}, CountryId{"PY"}, Coordinate{-57.94, -22.16}}, // Dr Juan Plate
    Airport{IataCode{"VMR"}, CountryId{"AR"}, Coordinate{-63.2265, -32.3201}}, // Presidente Néstor Kirchner Airport
    Airport{IataCode{"VMU"}, CountryId{"PG"}, Coordinate{144.823, -7.49483}}, // Baimuru Airport
    Airport{IataCode{"VNC"}, CountryId{"US"}, Coordinate{-82.4403, 27.0717}}, // Venice Municipal Airport
    Airport{IataCode{"VND"}, CountryId{"MG"}, Coordinate{47.5789, -23.3517}}, // Vangaindrano Airport
    Airport{IataCode{"VNE"}, CountryId{"FR"}, Coordinate{-2.72761, 47.7207}}, // Meucon Airport
    Airport{IataCode{"VNO"}, CountryId{"LT"}, Coordinate{25.2811, 54.6431}}, // Vilnius Airport
    Airport{IataCode{"VNR"}, CountryId{"AU"}, Coordinate{141.952, -16.9618}}, // Vanrook Station Airport
    Airport{IataCode{"VNS"}, CountryId{"IN"}, Coordinate{82.8568, 25.4482}}, // Lal Bahadur Shastri Airport
    Airport{IataCode{"VNT"}, CountryId{"LV"}, Coordinate{21.5441, 57.3614}}, // Ventspils International Airport
    Airport{IataCode{"VNX"}, CountryId{"MZ"}, Coordinate{35.3154, -22.0163}}, // Vilankulo Airport
    Airport{IataCode{"VNY"}, CountryId{"US"}, Coordinate{-118.49, 34.2097}}, // Van Nuys Airport
    Airport{IataCode{"VOD"}, CountryId{"CZ"}, Coordinate{14.3956, 50.2167}}, // Vodochody Airport
    Airport{IataCode{"VOG"}, CountryId{"RU"}, Coordinate{44.3579, 48.7929}}, // Volgograd International Airport
    Airport{IataCode{"VOI"}, CountryId{"LR"}, Coordinate{-9.767, 8.4}}, // Voinjama Airport
    Airport{IataCode{"VOL"}, CountryId{"GR"}, Coordinate{22.7684, 39.2224}}, // Nea Anchialos National Airport
    Airport{IataCode{"VOT"}, CountryId{"BR"}, Coordinate{-50.0024, -20.4604}}, // Votuporanga Airport
    Airport{IataCode{"VOZ"}, CountryId{"RU"}, Coordinate{39.2255, 51.8127}}, // Voronezh International Airport
    Airport{IataCode{"VPC"}, CountryId{"US"}, Coordinate{-84.85, 34.1231}}, // Cartersville Airport
    Airport{IataCode{"VPE"}, CountryId{"AO"}, Coordinate{15.6891, -17.0478}}, // Ondjiva Pereira Airport
    Airport{IataCode{"VPG"}, CountryId{"KE"}, Coordinate{39.7972, -3.8103}}, // Vipingo Airport
    Airport{IataCode{"VPN"}, CountryId{"IS"}, Coordinate{-14.8575, 65.7188}}, // Vopnafjörður Airport
    Airport{IataCode{"VPS"}, CountryId{"US"}, Coordinate{-86.5494, 30.4833}}, // Destin–Fort Walton Beach Airport
    Airport{IataCode{"VPY"}, CountryId{"MZ"}, Coordinate{33.4262, -19.1498}}, // Chimoio Airport
    Airport{IataCode{"VPZ"}, CountryId{"US"}, Coordinate{-87.0072, 41.4539}}, // Porter County Regional Airport
    Airport{IataCode{"VQQ"}, CountryId{"US"}, Coordinate{-81.8767, 30.2186}}, // Cecil Airport
    Airport{IataCode{"VQS"}, CountryId{"US"}, Coordinate{-65.4879, 18.1346}}, // Antonio Rivera Rodríguez Airport
    Airport{IataCode{"VRA"}, CountryId{"CU"}, Coordinate{-81.4364, 23.0393}}, // Juan Gualberto Gómez Airport
    Airport{IataCode{"VRB"}, CountryId{"US"}, Coordinate{-80.4179, 27.6556}}, // Vero Beach Municipal Airport
    Airport{IataCode{"VRC"}, CountryId{"PH"}, Coordinate{124.206, 13.5758}}, // Virac Airport
    Airport{IataCode{"VRE"}, CountryId{"ZA"}, Coordinate{18.5396, -31.6431}}, // Vredendal Airport
    Airport{IataCode{"VRI"}, CountryId{"RU"}, Coordinate{58.1986, 68.8478}}, // Varandey Airport
    Airport{IataCode{"VRL"}, CountryId{"PT"}, Coordinate{-7.7188, 41.276}}, // Vila Real Airport
    Airport{IataCode{"VRO"}, CountryId{"CU"}, Coordinate{-81.3036, 23.1228}}, // Kawama Airport
    Airport{IataCode{"VRU"}, CountryId{"ZA"}, Coordinate{24.7283, -26.9808}}, // Vryburg Airport
    Airport{IataCode{"VSA"}, CountryId{"MX"}, Coordinate{-92.8192, 17.993}}, // Carlos Rovirosa Pérez International Airport
    Airport{IataCode{"VSE"}, CountryId{"PT"}, Coordinate{-7.89006, 40.723}}, // Viseu Airport
    Airport{IataCode{"VSF"}, CountryId{"US"}, Coordinate{-72.5172, 43.3436}}, // Hartness State Airport
    Airport{IataCode{"VTB"}, CountryId{"BY"}, Coordinate{30.3517, 55.1267}}, // Vitebsk Vostochny Airport
    Airport{IataCode{"VTE"}, CountryId{"LA"}, Coordinate{102.569, 17.9757}}, // Wattay International Airport
    Airport{IataCode{"VTF"}, CountryId{"FJ"}, Coordinate{177.638, -18.5115}}, // Vatulele Airport
    Airport{IataCode{"VTG"}, CountryId{"VN"}, Coordinate{107.09, 10.372}}, // Vung Tau Airport
    Airport{IataCode{"VTN"}, CountryId{"US"}, Coordinate{-100.549, 42.8567}}, // Miller Field
    Airport{IataCode{"VTU"}, CountryId{"CU"}, Coordinate{-76.94, 20.9858}}, // Hermanos Ameijeiras Airport
    Airport{IataCode{"VTZ"}, CountryId{"IN"}, Coordinate{83.2231, 17.7281}}, // Vishakhapatnam International Airport
    Airport{IataCode{"VUJ"}, CountryId{"US"}, Coordinate{-80.1508, 35.4167}}, // Stanly County Airport
    Airport{IataCode{"VUO"}, CountryId{"US"}, Coordinate{-122.656, 45.6206}}, // Pearson Field
    Airport{IataCode{"VUP"}, CountryId{"CO"}, Coordinate{-73.2478, 10.4337}}, // Alfonso López Pumarejo Airport
    Airport{IataCode{"VUS"}, CountryId{"RU"}, Coordinate{46.26, 60.7883}}, // Veliky Ustyug Airport
    Airport{IataCode{"VVC"}, CountryId{"CO"}, Coordinate{-73.619, 4.16415}}, // La Vanguardia Airport
    Airport{IataCode{"VVI"}, CountryId{"BO"}, Coordinate{-63.1423, -17.6447}}, // Viru Viru International Airport
    Airport{IataCode{"VVO"}, CountryId{"RU"}, Coordinate{132.164, 43.3949}}, // Vladivostok International Airport
    Airport{IataCode{"VVZ"}, CountryId{"DZ"}, Coordinate{8.62247, 26.7236}}, // Takhamalt Airport
    Airport{IataCode{"VXC"}, CountryId{"MZ"}, Coordinate{35.2644, -13.2742}}, // Lichinga Airport
    Airport{IataCode{"VXE"}, CountryId{"CV"}, Coordinate{-25.056, 16.8367}}, // Cesária Évora Airport
    Airport{IataCode{"VXO"}, CountryId{"SE"}, Coordinate{14.7316, 56.9252}}, // Växjö/Kronoberg Airport
    Airport{IataCode{"VYI"}, CountryId{"RU"}, Coordinate{121.692, 63.7548}}, // Vilyuisk Airport
    Airport{IataCode{"VYS"}, CountryId{"US"}, Coordinate{-89.1531, 41.3519}}, // Illinois Valley Regional Airport
    Airport{IataCode{"WAA"}, CountryId{"US"}, Coordinate{-168.095, 65.6225}}, // Wales Airport
    Airport{IataCode{"WAC"}, CountryId{"ET"}, Coordinate{37.167, 7.167}}, // Wacca Airport
    Airport{IataCode{"WAE"}, CountryId{"SA"}, Coordinate{45.2047, 20.4988}}, // Wadi al-Dawasir Domestic Airport
    Airport{IataCode{"WAG"}, CountryId{"NZ"}, Coordinate{175.024, -39.9611}}, // Wanganui Airport
    Airport{IataCode{"WAH"}, CountryId{"US"}, Coordinate{-96.6072, 46.2442}}, // Harry Stern Airport
    Airport{IataCode{"WAI"}, CountryId{"MG"}, Coordinate{46.953, -15.7741}}, // Ambalabe Airport
    Airport{IataCode{"WAJ"}, CountryId{"PG"}, Coordinate{142.65, -6.95}}, // Wawoi Falls
    Airport{IataCode{"WAM"}, CountryId{"MG"}, Coordinate{48.4333, -17.8}}, // Ambatondrazaka Airport
    Airport{IataCode{"WAO"}, CountryId{"PG"}, Coordinate{145, -7.66667}}, // Wabo
    Airport{IataCode{"WAP"}, CountryId{"CL"}, Coordinate{-71.8069, -43.6153}}, // Alto Palena Airport
    Airport{IataCode{"WAQ"}, CountryId{"MG"}, Coordinate{44.6147, -18.7014}}, // Antsalova Airport
    Airport{IataCode{"WAT"}, CountryId{"IE"}, Coordinate{-7.08093, 52.1886}}, // Waterford Airport
    Airport{IataCode{"WAW"}, CountryId{"PL"}, Coordinate{20.9672, 52.1658}}, // Warsaw Chopin Airport
    Airport{IataCode{"WAX"}, CountryId{"LY"}, Coordinate{12.0199, 32.9513}}, // Zuwarah Airport
    Airport{IataCode{"WAY"}, CountryId{"US"}, Coordinate{-80.1306, 39.9011}}, // Greene County Airport
    Airport{IataCode{"WAZ"}, CountryId{"AU"}, Coordinate{151.943, -28.1494}}, // Warwick Airport
    Airport{IataCode{"WBB"}, CountryId{"US"}, Coordinate{-162.278, 63.5158}}, // Stebbins Airport
    Airport{IataCode{"WBC"}, CountryId{"PG"}, Coordinate{150.4, -9.317}}, // Wapolu
    Airport{IataCode{"WBM"}, CountryId{"PG"}, Coordinate{143.895, -5.6433}}, // Wapenamanda Airport
    Airport{IataCode{"WBO"}, CountryId{"MG"}, Coordinate{45.1333, -21.6076}}, // Antsoa Airport
    Airport{IataCode{"WBQ"}, CountryId{"US"}, Coordinate{-147.407, 66.3622}}, // Beaver Airport
    Airport{IataCode{"WBR"}, CountryId{"US"}, Coordinate{-85.5042, 43.7225}}, // Roben-Hood Airport
    Airport{IataCode{"WBU"}, CountryId{"US"}, Coordinate{-105.231, 40.0373}}, // Boulder Municipal Airport
    Airport{IataCode{"WBW"}, CountryId{"US"}, Coordinate{-75.8522, 41.2972}}, // Wilkes-Barre Wyoming Valley Airport
    Airport{IataCode{"WCA"}, CountryId{"CL"}, Coordinate{-73.7667, -42.4833}}, // Gamboa Airport
    Airport{IataCode{"WCH"}, CountryId{"CL"}, Coordinate{-72.8307, -42.7833}}, // Nuevo Chaitén Airport
    Airport{IataCode{"WCR"}, CountryId{"US"}, Coordinate{-148.483, 67.5044}}, // Chandalar Lake Airport
    Airport{IataCode{"WDA"}, CountryId{"YE"}, Coordinate{45.55, 14.8667}}, // Wadi Ain
    Airport{IataCode{"WDG"}, CountryId{"US"}, Coordinate{-97.7876, 36.3836}}, // Enid Woodring Regional Airport
    Airport{IataCode{"WDH"}, CountryId{"NA"}, Coordinate{17.4636, -22.4868}}, // Windhoek Hosea Kutako International Airport
    Airport{IataCode{"WDI"}, CountryId{"AU"}, Coordinate{151.86, -26.2827}}, // Wondai Airport
    Airport{IataCode{"WDR"}, CountryId{"US"}, Coordinate{-83.6681, 33.9822}}, // Barrow County Airport
    Airport{IataCode{"WDS"}, CountryId{"CN"}, Coordinate{110.905, 32.5891}}, // Shiyan Wudangshan Airport
    Airport{IataCode{"WEA"}, CountryId{"US"}, Coordinate{-97.6824, 32.7463}}, // Parker County Airport
    Airport{IataCode{"WEF"}, CountryId{"CN"}, Coordinate{119.114, 36.6409}}, // Weifang Airport
    Airport{IataCode{"WEH"}, CountryId{"CN"}, Coordinate{122.236, 37.1889}}, // Weihai Dashuibo Airport
    Airport{IataCode{"WEI"}, CountryId{"AU"}, Coordinate{141.925, -12.6811}}, // Weipa Airport
    Airport{IataCode{"WEL"}, CountryId{"ZA"}, Coordinate{26.6667, -28}}, // Welkom Airport
    Airport{IataCode{"WFI"}, CountryId{"MG"}, Coordinate{47.1, -21.45}}, // Fianarantsoa Airport
    Airport{IataCode{"WFK"}, CountryId{"US"}, Coordinate{-68.3128, 47.2856}}, // Northern Aroostook Regional Airport
    Airport{IataCode{"WGC"}, CountryId{"IN"}, Coordinate{79.6, 17.9167}}, // Warangal Airport
    Airport{IataCode{"WGE"}, CountryId{"AU"}, Coordinate{148.122, -30.0318}}, // Walgett Airport
    Airport{IataCode{"WGN"}, CountryId{"CN"}, Coordinate{110.642, 26.802}}, // Shaoyang Wugang Airport
    Airport{IataCode{"WGO"}, CountryId{"US"}, Coordinate{-78.1475, 39.1431}}, // Winchester Regional Airport
    Airport{IataCode{"WGP"}, CountryId{"ID"}, Coordinate{120.301, -9.66861}}, // Mau Hau Airport
    Airport{IataCode{"WGT"}, CountryId{"AU"}, Coordinate{146.306, -36.418}}, // Wangaratta Airport
    Airport{IataCode{"WGU"}, CountryId{"PG"}, Coordinate{146.8, -6.8}}, // Wagau
    Airport{IataCode{"WHF"}, CountryId{"SD"}, Coordinate{31.5164, 21.8003}}, // Wadi Halfa Airport
    Airport{IataCode{"WHK"}, CountryId{"NZ"}, Coordinate{176.918, -37.9245}}, // Whakatane Airport
    Airport{IataCode{"WHP"}, CountryId{"US"}, Coordinate{-118.413, 34.2593}}, // Whiteman Airport
    Airport{IataCode{"WHT"}, CountryId{"US"}, Coordinate{-96.1542, 29.2542}}, // Wharton Regional Airport
    Airport{IataCode{"WIB"}, CountryId{"US"}, Coordinate{-99.2839, 34.2256}}, // Wilbarger County Airport
    Airport{IataCode{"WIC"}, CountryId{"GB"}, Coordinate{-3.08747, 58.4534}}, // Wick Airport
    Airport{IataCode{"WIK"}, CountryId{"NZ"}, Coordinate{175.086, -36.8089}}, // Waiheke Island Aerodrome
    Airport{IataCode{"WIL"}, CountryId{"KE"}, Coordinate{36.8148, -1.32172}}, // Wilson Airport
    Airport{IataCode{"WIN"}, CountryId{"AU"}, Coordinate{143.085, -22.3633}}, // Winton Airport
    Airport{IataCode{"WIO"}, CountryId{"AU"}, Coordinate{143.368, -31.4983}}, // Wilcannia Airport
    Airport{IataCode{"WIR"}, CountryId{"NZ"}, Coordinate{177.404, -39.0122}}, // Wairoa Aerodrome
    Airport{IataCode{"WIU"}, CountryId{"PG"}, Coordinate{149.183, -5.56667}}, // Witu
    Airport{IataCode{"WJA"}, CountryId{"MH"}, Coordinate{168.55, 7.45083}}, // Woja Airport
    Airport{IataCode{"WJF"}, CountryId{"US"}, Coordinate{-118.219, 34.7411}}, // General William J. Fox Airfield
    Airport{IataCode{"WJR"}, CountryId{"KE"}, Coordinate{40.09, 1.73}}, // Wajir Airport
    Airport{IataCode{"WJU"}, CountryId{"KR"}, Coordinate{127.96, 37.4381}}, // Wonju Airport
    Airport{IataCode{"WKA"}, CountryId{"NZ"}, Coordinate{169.246, -44.7225}}, // Wanaka Airport
    Airport{IataCode{"WKB"}, CountryId{"AU"}, Coordinate{142.419, -36.3211}}, // Warracknabeal Airport
    Airport{IataCode{"WKI"}, CountryId{"ZW"}, Coordinate{26.52, -18.3631}}, // Hwange Town Airport
    Airport{IataCode{"WKJ"}, CountryId{"JP"}, Coordinate{141.797, 45.3995}}, // Wakkanai Airport
    Airport{IataCode{"WKK"}, CountryId{"US"}, Coordinate{-158.618, 59.2825}}, // Aleknagik Airport
    Airport{IataCode{"WKN"}, CountryId{"PG"}, Coordinate{155.221, -5.86139}}, // Wakunai Airport
    Airport{IataCode{"WKR"}, CountryId{"BS"}, Coordinate{-78.4022, 27.2604}}, // Walkers Cay Airport
    Airport{IataCode{"WLD"}, CountryId{"US"}, Coordinate{-97.0375, 37.1686}}, // Strother Field
    Airport{IataCode{"WLE"}, CountryId{"AU"}, Coordinate{150.165, -26.8092}}, // Miles Airport
    Airport{IataCode{"WLG"}, CountryId{"NZ"}, Coordinate{174.812, -41.329}}, // Wellington International Airport
    Airport{IataCode{"WLH"}, CountryId{"VU"}, Coordinate{167.691, -15.412}}, // Walaha Airport
    Airport{IataCode{"WLK"}, CountryId{"US"}, Coordinate{-159.986, 66.6}}, // Selawik Airport
    Airport{IataCode{"WLP"}, CountryId{"AU"}, Coordinate{118.707, -23.1367}}, // West Angelas Airport
    Airport{IataCode{"WLS"}, CountryId{"FR"}, Coordinate{-176.196, -13.241}}, // Hihifo Airport
    Airport{IataCode{"WLW"}, CountryId{"US"}, Coordinate{-122.217, 39.5158}}, // Willows-Glenn County Airport
    Airport{IataCode{"WMB"}, CountryId{"AU"}, Coordinate{142.449, -38.2993}}, // Warrnambool Airport
    Airport{IataCode{"WMC"}, CountryId{"US"}, Coordinate{-117.805, 40.9038}}, // Winnemucca Municipal Airport
    Airport{IataCode{"WMD"}, CountryId{"MG"}, Coordinate{44.94, -21.0464}}, // Mandabe Airport
    Airport{IataCode{"WME"}, CountryId{"AU"}, Coordinate{120.555, -27.2864}}, // Mount Keith Airport
    Airport{IataCode{"WMH"}, CountryId{"US"}, Coordinate{-92.4706, 36.3689}}, // Ozark Regional Airport
    Airport{IataCode{"WMI"}, CountryId{"PL"}, Coordinate{20.6513, 52.4463}}, // Warsaw-Modlin Mazovia Airport
    Airport{IataCode{"WML"}, CountryId{"NZ"}, Coordinate{172.395, -43.4767}}, // West Melton Aerodrome
    Airport{IataCode{"WMN"}, CountryId{"MG"}, Coordinate{49.6833, -15.4383}}, // Maroantsetra Airport
    Airport{IataCode{"WMO"}, CountryId{"US"}, Coordinate{-163.413, 64.6892}}, // White Mountain Airport
    Airport{IataCode{"WMP"}, CountryId{"MG"}, Coordinate{47.6167, -16.05}}, // Mampikony Airport
    Airport{IataCode{"WMR"}, CountryId{"MG"}, Coordinate{49.7667, -16.1667}}, // Mananara Nord Airport
    Airport{IataCode{"WMT"}, CountryId{"CN"}, Coordinate{106.438, 27.9679}}, // Renhuai Maotai Airport
    Airport{IataCode{"WMX"}, CountryId{"ID"}, Coordinate{138.952, -4.09833}}, // Wamena Airport
    Airport{IataCode{"WNA"}, CountryId{"US"}, Coordinate{-161.979, 60.6903}}, // Napakiak Airport
    Airport{IataCode{"WNH"}, CountryId{"CN"}, Coordinate{104.243, 23.3758}}, // Wenshan Puzhehei Airport
    Airport{IataCode{"WNI"}, CountryId{"ID"}, Coordinate{123.583, -5.31667}}, // Matahora Airport
    Airport{IataCode{"WNN"}, CountryId{"CA"}, Coordinate{-89.2892, 52.8939}}, // Wunnummin Lake Airport
    Airport{IataCode{"WNP"}, CountryId{"PH"}, Coordinate{123.269, 13.5848}}, // Naga Airport
    Airport{IataCode{"WNR"}, CountryId{"AU"}, Coordinate{142.667, -25.4133}}, // Windorah Airport
    Airport{IataCode{"WNS"}, CountryId{"PK"}, Coordinate{68.39, 26.2194}}, // Nawabshah Airport
    Airport{IataCode{"WNZ"}, CountryId{"CN"}, Coordinate{120.843, 27.9091}}, // Wenzhou Longwan International Airport
    Airport{IataCode{"WOA"}, CountryId{"PG"}, Coordinate{145.884, -6.80004}}, // Wonenara Airport
    Airport{IataCode{"WOL"}, CountryId{"AU"}, Coordinate{150.79, -34.5603}}, // Shellharbour Airport
    Airport{IataCode{"WON"}, CountryId{"AU"}, Coordinate{140.894, -18.5727}}, // Wondoola Airport
    Airport{IataCode{"WOS"}, CountryId{"KP"}, Coordinate{127.481, 39.1653}}, // Wonsan Airport
    Airport{IataCode{"WOT"}, CountryId{"TW"}, Coordinate{119.502, 23.3674}}, // Wang-an Airport
    Airport{IataCode{"WOW"}, CountryId{"US"}, Coordinate{-150.052, 61.7542}}, // Willow Airport
    Airport{IataCode{"WPA"}, CountryId{"CL"}, Coordinate{-72.6703, -45.3992}}, // Cabo 1° Juan Román Airport
    Airport{IataCode{"WPB"}, CountryId{"MG"}, Coordinate{47.6167, -15.5833}}, // Port Bergé Airport
    Airport{IataCode{"WPC"}, CountryId{"CA"}, Coordinate{-113.997, 49.5206}}, // Pincher Creek Airport
    Airport{IataCode{"WPK"}, CountryId{"AU"}, Coordinate{144.002, -16.6583}}, // Wrotham Park Airport
    Airport{IataCode{"WPL"}, CountryId{"CA"}, Coordinate{-124.533, 49.8833}}, // Powell Lake Water Aerodrome
    Airport{IataCode{"WPM"}, CountryId{"PG"}, Coordinate{142.883, -8.788}}, // Wipim Airport
    Airport{IataCode{"WPR"}, CountryId{"CL"}, Coordinate{-70.3256, -53.2541}}, // Capitan Fuentes Martinez Airport
    Airport{IataCode{"WPU"}, CountryId{"CL"}, Coordinate{-67.6263, -54.9311}}, // Guardiamarina Zañartu Airport
    Airport{IataCode{"WRE"}, CountryId{"NZ"}, Coordinate{174.365, -35.7673}}, // Whangarei Airport
    Airport{IataCode{"WRG"}, CountryId{"US"}, Coordinate{-132.38, 56.4851}}, // Wrangell Airport
    Airport{IataCode{"WRL"}, CountryId{"US"}, Coordinate{-107.952, 43.9729}}, // Worland Municipal Airport
    Airport{IataCode{"WRN"}, CountryId{"AU"}, Coordinate{119.39, -30.0317}}, // Windarling Airport
    Airport{IataCode{"WRO"}, CountryId{"PL"}, Coordinate{16.8858, 51.1028}}, // Wrocław – Copernicus Airport
    Airport{IataCode{"WRR"}, CountryId{"ID"}, Coordinate{132.191, -0.419444}}, // Werur Airport
    Airport{IataCode{"WRT"}, CountryId{"GB"}, Coordinate{-2.88389, 53.745}}, // Warton Aerodrome
    Airport{IataCode{"WSE"}, CountryId{"EC"}, Coordinate{-76.9917, 0.0708333}}, // Santa Cecilia Airport
    Airport{IataCode{"WSF"}, CountryId{"US"}, Coordinate{-164.914, 54.5824}}, // Cape Sarichef Airport
    Airport{IataCode{"WSG"}, CountryId{"US"}, Coordinate{-80.2903, 40.1364}}, // Washington County Airport
    Airport{IataCode{"WSH"}, CountryId{"US"}, Coordinate{-72.8667, 40.8154}}, // Brookhaven Airport
    Airport{IataCode{"WSK"}, CountryId{"CN"}, Coordinate{109.706, 31.064}}, // Wushan Shennüfeng Airport
    Airport{IataCode{"WSN"}, CountryId{"US"}, Coordinate{-157.003, 58.7022}}, // South Naknek Airport
    Airport{IataCode{"WSO"}, CountryId{"SR"}, Coordinate{-57.1853, 5.21528}}, // Washabo airstrip
    Airport{IataCode{"WSP"}, CountryId{"NI"}, Coordinate{-83.9758, 14.736}}, // Waspam Airport
    Airport{IataCode{"WST"}, CountryId{"US"}, Coordinate{-71.8068, 41.35}}, // Westerly State Airport
    Airport{IataCode{"WSU"}, CountryId{"PG"}, Coordinate{147.3, -6}}, // Wasu
    Airport{IataCode{"WSZ"}, CountryId{"NZ"}, Coordinate{171.581, -41.7381}}, // Westport Airport, New Zealand
    Airport{IataCode{"WTA"}, CountryId{"MG"}, Coordinate{43.9667, -17.4833}}, // Tambohorano Airport
    Airport{IataCode{"WTB"}, CountryId{"AU"}, Coordinate{151.796, -27.5641}}, // Toowoomba Wellcamp Airport
    Airport{IataCode{"WTD"}, CountryId{"BS"}, Coordinate{-78.975, 26.6833}}, // West End Airport
    Airport{IataCode{"WTE"}, CountryId{"MH"}, Coordinate{170.239, 9.45833}}, // Wotje Airport
    Airport{IataCode{"WTK"}, CountryId{"US"}, Coordinate{-162.98, 67.5611}}, // Noatak Airport
    Airport{IataCode{"WTL"}, CountryId{"US"}, Coordinate{-162.667, 60.3353}}, // Tuntutuliak Airport
    Airport{IataCode{"WTO"}, CountryId{"MH"}, Coordinate{166.003, 10.1733}}, // Wotho Airport
    Airport{IataCode{"WTP"}, CountryId{"PG"}, Coordinate{147.253, -8.5625}}, // Woitape Airport
    Airport{IataCode{"WTR"}, CountryId{"US"}, Coordinate{-109.986, 33.8106}}, // Whiteriver Airport
    Airport{IataCode{"WTT"}, CountryId{"PG"}, Coordinate{146.468, -6.13249}}, // Wantoat Airport
    Airport{IataCode{"WTZ"}, CountryId{"NZ"}, Coordinate{175.679, -36.8358}}, // Whitianga Aerodrome
    Airport{IataCode{"WUA"}, CountryId{"CN"}, Coordinate{106.803, 39.7919}}, // Wuhai Airport
    Airport{IataCode{"WUD"}, CountryId{"AU"}, Coordinate{135.453, -33.0444}}, // Wudinna Airport
    Airport{IataCode{"WUG"}, CountryId{"PG"}, Coordinate{146.719, -7.34531}}, // Wau Airport, Papua New Guinea
    Airport{IataCode{"WUH"}, CountryId{"CN"}, Coordinate{114.212, 30.7728}}, // Wuhan Tianhe International Airport
    Airport{IataCode{"WUI"}, CountryId{"AU"}, Coordinate{121.887, -28.7121}}, // Murrin Murrin Airport
    Airport{IataCode{"WUN"}, CountryId{"AU"}, Coordinate{120.22, -26.63}}, // Wiluna Airport
    Airport{IataCode{"WUS"}, CountryId{"CN"}, Coordinate{118, 27.7008}}, // Wuyishan Airport
    Airport{IataCode{"WUT"}, CountryId{"CN"}, Coordinate{112.968, 38.5992}}, // Xinzhou Wutaishan Airport
    Airport{IataCode{"WUU"}, CountryId{"SS"}, Coordinate{27.975, 7.72583}}, // Wau Airport
    Airport{IataCode{"WUV"}, CountryId{"PG"}, Coordinate{142.835, -1.73356}}, // Wuvulu Island Airport
    Airport{IataCode{"WUX"}, CountryId{"CN"}, Coordinate{120.428, 31.5038}}, // Sunan Shuofang International Airport
    Airport{IataCode{"WUZ"}, CountryId{"CN"}, Coordinate{111.102, 23.4}}, // Wuzhou Xijiang Airport
    Airport{IataCode{"WVB"}, CountryId{"NA"}, Coordinate{14.6414, -22.9777}}, // Walvis Bay Airport
    Airport{IataCode{"WVI"}, CountryId{"US"}, Coordinate{-121.79, 36.9358}}, // Watsonville Municipal Airport
    Airport{IataCode{"WVK"}, CountryId{"MG"}, Coordinate{48.0167, -22.1206}}, // Manakara Airport
    Airport{IataCode{"WVL"}, CountryId{"US"}, Coordinate{-69.6756, 44.5333}}, // Waterville Robert LaFleur Airport
    Airport{IataCode{"WWA"}, CountryId{"US"}, Coordinate{-149.539, 61.5719}}, // Wasilla Airport
    Airport{IataCode{"WWD"}, CountryId{"US"}, Coordinate{-74.9083, 39.0086}}, // Cape May Airport
    Airport{IataCode{"WWK"}, CountryId{"PG"}, Coordinate{143.669, -3.58024}}, // Wewak Airport
    Airport{IataCode{"WWR"}, CountryId{"US"}, Coordinate{-99.5228, 36.4381}}, // West Woodward Airport
    Airport{IataCode{"WWT"}, CountryId{"US"}, Coordinate{-164.641, 60.9392}}, // Newtok Airport
    Airport{IataCode{"WWY"}, CountryId{"AU"}, Coordinate{147.192, -33.9367}}, // West Wyalong Airport
    Airport{IataCode{"WXN"}, CountryId{"CN"}, Coordinate{108.427, 30.7999}}, // Wanzhou Wuqiao Airport
    Airport{IataCode{"WYA"}, CountryId{"AU"}, Coordinate{137.522, -33.0524}}, // Whyalla Airport
    Airport{IataCode{"WYE"}, CountryId{"SL"}, Coordinate{-11.0472, 8.61047}}, // Yengema Airport
    Airport{IataCode{"WYK"}, CountryId{"ID"}, Coordinate{104.402, -4.39206}}, // Gatot Subrato Airport
    Airport{IataCode{"WYN"}, CountryId{"AU"}, Coordinate{128.153, -15.5114}}, // Wyndham Airport
    Airport{IataCode{"WYS"}, CountryId{"US"}, Coordinate{-111.115, 44.6867}}, // Yellowstone Airport
    Airport{IataCode{"WZA"}, CountryId{"GH"}, Coordinate{-2.5075, 10.0825}}, // Wa Airport
    Airport{IataCode{"XAI"}, CountryId{"CN"}, Coordinate{114.078, 32.5414}}, // Xinyang Minggang Airport
    Airport{IataCode{"XAP"}, CountryId{"BR"}, Coordinate{-52.6531, -27.1338}}, // Chapecó Airport
    Airport{IataCode{"XAR"}, CountryId{"BF"}, Coordinate{-0.895556, 14.2153}}, // Aribinda Airport
    Airport{IataCode{"XAU"}, CountryId{"FR"}, Coordinate{-53.2042, 3.61361}}, // Saül Airport
    Airport{IataCode{"XBE"}, CountryId{"CA"}, Coordinate{-91.0272, 53.9656}}, // Bearskin Lake Airport
    Airport{IataCode{"XBG"}, CountryId{"BF"}, Coordinate{-0.167, 12.983}}, // Bogande Airport
    Airport{IataCode{"XBJ"}, CountryId{"IR"}, Coordinate{59.2896, 32.8894}}, // Birjand International Airport
    Airport{IataCode{"XBO"}, CountryId{"BF"}, Coordinate{-0.567, 12.65}}, // Boulsa Airport
    Airport{IataCode{"XBP"}, CountryId{"US"}, Coordinate{-97.8283, 33.1753}}, // Bridgeport Municipal Airport
    Airport{IataCode{"XBR"}, CountryId{"CA"}, Coordinate{-75.7503, 44.6394}}, // Brockville-Thousand Islands Regional Tackaberry Airport
    Airport{IataCode{"XCD"}, CountryId{"FR"}, Coordinate{4.8175, 46.8261}}, // Chalon – Champforgeuil Airport
    Airport{IataCode{"XCH"}, CountryId{"AU"}, Coordinate{105.689, -10.451}}, // Christmas Island Airport
    Airport{IataCode{"XCM"}, CountryId{"CA"}, Coordinate{-82.0825, 42.3058}}, // Chatham-Kent Airport
    Airport{IataCode{"XCR"}, CountryId{"FR"}, Coordinate{4.19019, 48.7805}}, // Châlons Vatry Airport
    Airport{IataCode{"XDE"}, CountryId{"BF"}, Coordinate{-3.25, 10.95}}, // Diebougou Airport
    Airport{IataCode{"XDJ"}, CountryId{"BF"}, Coordinate{-1.62472, 14.125}}, // Djibo Airport
    Airport{IataCode{"XES"}, CountryId{"US"}, Coordinate{-88.3944, 42.6131}}, // Grand Geneva Resort Airport
    Airport{IataCode{"XFN"}, CountryId{"CN"}, Coordinate{112.287, 32.1528}}, // Xiangyang Liuji Airport
    Airport{IataCode{"XGA"}, CountryId{"BF"}, Coordinate{-3.25083, 10.2992}}, // Gaoua Airport
    Airport{IataCode{"XGG"}, CountryId{"BF"}, Coordinate{-0.218889, 14.4542}}, // Gorom Gorom Airport
    Airport{IataCode{"XGN"}, CountryId{"AO"}, Coordinate{14.9649, -16.7553}}, // Xangongo Airport
    Airport{IataCode{"XGR"}, CountryId{"CA"}, Coordinate{-65.9928, 58.7114}}, // Kangiqsualujjuaq (Georges River) Airport
    Airport{IataCode{"XIC"}, CountryId{"CN"}, Coordinate{102.19, 27.9799}}, // Xichang Qingshan Airport
    Airport{IataCode{"XIE"}, CountryId{"LA"}, Coordinate{100.833, 19.65}}, // Xienglom
    Airport{IataCode{"XIL"}, CountryId{"CN"}, Coordinate{115.959, 43.9161}}, // Xilinhot Airport
    Airport{IataCode{"XIY"}, CountryId{"CN"}, Coordinate{108.757, 34.4403}}, // Xi'an Xianyang International Airport
    Airport{IataCode{"XJM"}, CountryId{"PK"}, Coordinate{73.6383, 33.05}}, // Mangla Airport
    Airport{IataCode{"XKA"}, CountryId{"BF"}, Coordinate{1.5, 12.467}}, // Kantchari Airport
    Airport{IataCode{"XKH"}, CountryId{"LA"}, Coordinate{103.158, 19.4401}}, // Xieng Khouang Airport
    Airport{IataCode{"XKS"}, CountryId{"CA"}, Coordinate{-88.6431, 53.5247}}, // Kasabonika Airport
    Airport{IataCode{"XKY"}, CountryId{"BF"}, Coordinate{-1.1, 13.067}}, // Kaya Airport
    Airport{IataCode{"XLB"}, CountryId{"CA"}, Coordinate{-101.469, 58.6142}}, // Lac Brochet Airport
    Airport{IataCode{"XLL"}, CountryId{"US"}, Coordinate{-79.9133, 36.2536}}, // Greensboro North Airport
    Airport{IataCode{"XLS"}, CountryId{"SN"}, Coordinate{-16.4611, 16.0498}}, // Saint-Louis Airport
    Airport{IataCode{"XLU"}, CountryId{"BF"}, Coordinate{-2.1, 11.1}}, // Leo Airport
    Airport{IataCode{"XMC"}, CountryId{"AU"}, Coordinate{149.721, -37.5989}}, // Mallacoota Airport
    Airport{IataCode{"XMD"}, CountryId{"US"}, Coordinate{-97.0856, 44.0164}}, // Madison Municipal Airport
    Airport{IataCode{"XMF"}, CountryId{"FR"}, Coordinate{6.79139, 47.4867}}, // Montbéliard – Courcelles Aerodrome
    Airport{IataCode{"XMG"}, CountryId{"NP"}, Coordinate{80.1481, 28.9633}}, // Mahendranagar Airport
    Airport{IataCode{"XMH"}, CountryId{"FR"}, Coordinate{-146.071, -14.4375}}, // Manihi Airport
    Airport{IataCode{"XMI"}, CountryId{"TZ"}, Coordinate{38.7667, -10.7383}}, // Masasi Airport
    Airport{IataCode{"XMN"}, CountryId{"CN"}, Coordinate{118.128, 24.5442}}, // Xiamen Gaoqi International Airport
    Airport{IataCode{"XMP"}, CountryId{"CA"}, Coordinate{-130.202, 63.1765}}, // Macmillian Pass Airport
    Airport{IataCode{"XMS"}, CountryId{"EC"}, Coordinate{-78.1208, -2.29917}}, // Edmundo Carvajal Airport
    Airport{IataCode{"XMY"}, CountryId{"AU"}, Coordinate{142.772, -9.9}}, // Yam Island Airport
    Airport{IataCode{"XNA"}, CountryId{"US"}, Coordinate{-94.2972, 36.2764}}, // Northwest Arkansas Regional Airport
    Airport{IataCode{"XNN"}, CountryId{"CN"}, Coordinate{102.039, 36.525}}, // Xining Caojiabao Airport
    Airport{IataCode{"XNO"}, CountryId{"US"}, Coordinate{-81.0831, 33.6169}}, // North Auxiliary Airfield
    Airport{IataCode{"XNT"}, CountryId{"CN"}, Coordinate{114.429, 36.8828}}, // Xingtai Dalian Airport
    Airport{IataCode{"XNU"}, CountryId{"BF"}, Coordinate{-3.867, 12.75}}, // Nouna Airport
    Airport{IataCode{"XPA"}, CountryId{"BF"}, Coordinate{0.7, 11.25}}, // Pama Airport
    Airport{IataCode{"XPK"}, CountryId{"CA"}, Coordinate{-101.266, 55.7492}}, // Pukatawagan Airport
    Airport{IataCode{"XPP"}, CountryId{"CA"}, Coordinate{-97.2736, 52.9964}}, // Poplar River Airport
    Airport{IataCode{"XPR"}, CountryId{"US"}, Coordinate{-102.511, 43.0225}}, // Pine Ridge Airport
    Airport{IataCode{"XQP"}, CountryId{"CR"}, Coordinate{-84.1333, 9.43957}}, // Quepos La Managua Airport
    Airport{IataCode{"XQU"}, CountryId{"CA"}, Coordinate{-124.394, 49.3372}}, // Qualicum Beach Airport
    Airport{IataCode{"XRQ"}, CountryId{"CN"}, Coordinate{116.938, 48.5761}}, // Xinbarag Youqi Baogede Airport
    Airport{IataCode{"XRR"}, CountryId{"CA"}, Coordinate{-132.422, 61.9706}}, // Ross River Airport
    Airport{IataCode{"XRY"}, CountryId{"ES"}, Coordinate{-6.06403, 36.7504}}, // Jerez Airport
    Airport{IataCode{"XSA"}, CountryId{"US"}, Coordinate{-76.8942, 37.8597}}, // Tappahannock-Essex County Airport
    Airport{IataCode{"XSB"}, CountryId{"AE"}, Coordinate{52.5845, 24.2845}}, // Sir Bani Yas Airport
    Airport{IataCode{"XSC"}, CountryId{"GB"}, Coordinate{-71.5286, 21.5158}}, // South Caicos Airport
    Airport{IataCode{"XSD"}, CountryId{"US"}, Coordinate{-116.779, 37.7947}}, // Tonopah Test Range Airport
    Airport{IataCode{"XSE"}, CountryId{"BF"}, Coordinate{0.503333, 13.4567}}, // Sebba Airport
    Airport{IataCode{"XSI"}, CountryId{"CA"}, Coordinate{-98.9072, 56.7928}}, // South Indian Lake Airport
    Airport{IataCode{"XSJ"}, CountryId{"FR"}, Coordinate{3.02861, 49.8689}}, // Peronne-St Quentin Airport
    Airport{IataCode{"XSP"}, CountryId{"SG"}, Coordinate{103.868, 1.41694}}, // Seletar Airport
    Airport{IataCode{"XTG"}, CountryId{"AU"}, Coordinate{143.811, -27.9864}}, // Thargomindah Airport
    Airport{IataCode{"XTL"}, CountryId{"CA"}, Coordinate{-98.5122, 58.7061}}, // Tadoule Lake Airport
    Airport{IataCode{"XTO"}, CountryId{"AU"}, Coordinate{149.899, -25.8019}}, // Taroom Airport
    Airport{IataCode{"XUZ"}, CountryId{"CN"}, Coordinate{117.555, 34.055}}, // Xuzhou Guanyin Airport
    Airport{IataCode{"XWA"}, CountryId{"US"}, Coordinate{-103.751, 48.2597}}, // Williston Basin International Airport
    Airport{IataCode{"XYA"}, CountryId{"SB"}, Coordinate{159.219, -9.09278}}, // Yandina Airport
    Airport{IataCode{"XYE"}, CountryId{"MM"}, Coordinate{97.8667, 15.3}}, // Ye Airport
    Airport{IataCode{"XYR"}, CountryId{"PG"}, Coordinate{141.783, -3.88333}}, // Yellow River
    Airport{IataCode{"XZA"}, CountryId{"BF"}, Coordinate{-0.616667, 11.1667}}, // Zabré Airport
    Airport{IataCode{"YAA"}, CountryId{"CA"}, Coordinate{-125.304, 52.4514}}, // Anahim Lake Airport
    Airport{IataCode{"YAB"}, CountryId{"CA"}, Coordinate{-85.0472, 73.0064}}, // Arctic Bay Airport
    Airport{IataCode{"YAC"}, CountryId{"CA"}, Coordinate{-91.8244, 51.7272}}, // Cat Lake Airport
    Airport{IataCode{"YAG"}, CountryId{"CA"}, Coordinate{-93.4406, 48.6544}}, // Fort Frances Municipal Airport
    Airport{IataCode{"YAH"}, CountryId{"CA"}, Coordinate{-73.6753, 53.7547}}, // La Grande-4 Airport
    Airport{IataCode{"YAI"}, CountryId{"CL"}, Coordinate{-72.0388, -36.5868}}, // General Bernardo O'Higgins Airport
    Airport{IataCode{"YAK"}, CountryId{"US"}, Coordinate{-139.66, 59.5033}}, // Yakutat Airport
    Airport{IataCode{"YAL"}, CountryId{"CA"}, Coordinate{-126.916, 50.5822}}, // Alert Bay Airport
    Airport{IataCode{"YAM"}, CountryId{"CA"}, Coordinate{-84.5002, 46.4848}}, // Sault Ste. Marie Airport
    Airport{IataCode{"YAN"}, CountryId{"CD"}, Coordinate{24.45, 0.8}}, // Yangambi Airport
    Airport{IataCode{"YAO"}, CountryId{"CM"}, Coordinate{11.5216, 3.83206}}, // Yaoundé Airport
    Airport{IataCode{"YAP"}, CountryId{"FM"}, Coordinate{138.086, 9.49786}}, // Yap International Airport
    Airport{IataCode{"YAR"}, CountryId{"CA"}, Coordinate{-76.1964, 53.5719}}, // La Grande-3 Airport
    Airport{IataCode{"YAS"}, CountryId{"FJ"}, Coordinate{177.546, -16.7583}}, // Yasawa Island Airport
    Airport{IataCode{"YAT"}, CountryId{"CA"}, Coordinate{-82.4319, 52.9275}}, // Attawapiskat Airport
    Airport{IataCode{"YAU"}, CountryId{"CA"}, Coordinate{-73.3214, 61.6622}}, // Kattiniq/Donaldson Airport
    Airport{IataCode{"YAX"}, CountryId{"CA"}, Coordinate{-89.5722, 53.8452}}, // Angling Lake/Wapekeka Airport
    Airport{IataCode{"YAY"}, CountryId{"CA"}, Coordinate{-56.0892, 51.388}}, // St. Anthony Airport
    Airport{IataCode{"YAZ"}, CountryId{"CA"}, Coordinate{-125.767, 49.0786}}, // Tofino/Long Beach Airport
    Airport{IataCode{"YBA"}, CountryId{"CA"}, Coordinate{-115.54, 51.2083}}, // Banff Airport
    Airport{IataCode{"YBB"}, CountryId{"CA"}, Coordinate{-89.7916, 68.538}}, // Kugaaruk Airport
    Airport{IataCode{"YBC"}, CountryId{"CA"}, Coordinate{-68.2005, 49.1367}}, // Baie-Comeau Airport
    Airport{IataCode{"YBE"}, CountryId{"CA"}, Coordinate{-108.481, 59.5614}}, // Uranium City Airport
    Airport{IataCode{"YBF"}, CountryId{"CA"}, Coordinate{-125.137, 48.8342}}, // Bamfield Water Aerodrome
    Airport{IataCode{"YBG"}, CountryId{"CA"}, Coordinate{-70.9964, 48.3306}}, // Bagotville Airport
    Airport{IataCode{"YBI"}, CountryId{"CA"}, Coordinate{-55.7862, 53.4682}}, // Black Tickle Airport
    Airport{IataCode{"YBJ"}, CountryId{"CA"}, Coordinate{-62.8103, 50.2836}}, // Baie-Johan-Beetz Seaplane Base
    Airport{IataCode{"YBK"}, CountryId{"CA"}, Coordinate{-96.076, 64.3043}}, // Baker Lake Airport
    Airport{IataCode{"YBL"}, CountryId{"CA"}, Coordinate{-125.268, 49.9517}}, // Campbell River Airport
    Airport{IataCode{"YBO"}, CountryId{"CA"}, Coordinate{-130.249, 56.9667}}, // Bob Quinn Lake Airport
    Airport{IataCode{"YBP"}, CountryId{"CN"}, Coordinate{104.525, 28.858}}, // Yibin Wuliangye Airport
    Airport{IataCode{"YBR"}, CountryId{"CA"}, Coordinate{-99.9459, 49.9047}}, // Brandon Municipal Airport
    Airport{IataCode{"YBS"}, CountryId{"CA"}, Coordinate{-90.3769, 52.6086}}, // Opapimiskan Lake Airport
    Airport{IataCode{"YBT"}, CountryId{"CA"}, Coordinate{-101.682, 57.8862}}, // Brochet Airport
    Airport{IataCode{"YBV"}, CountryId{"CA"}, Coordinate{-97.0242, 52.36}}, // Berens River Airport
    Airport{IataCode{"YBX"}, CountryId{"CA"}, Coordinate{-57.1886, 51.444}}, // Lourdes-de-Blanc-Sablon Airport
    Airport{IataCode{"YBY"}, CountryId{"CA"}, Coordinate{-110.741, 54.3047}}, // Bonnyville Airport
    Airport{IataCode{"YCA"}, CountryId{"CA"}, Coordinate{-124.982, 49.6794}}, // Courtenay Airpark
    Airport{IataCode{"YCC"}, CountryId{"CA"}, Coordinate{-74.5678, 45.0928}}, // Cornwall Regional Airport
    Airport{IataCode{"YCD"}, CountryId{"CA"}, Coordinate{-123.874, 49.053}}, // Nanaimo Airport
    Airport{IataCode{"YCF"}, CountryId{"CA"}, Coordinate{-124.984, 50.0236}}, // Cortes Island (Hansen Airfield) Airport
    Airport{IataCode{"YCG"}, CountryId{"CA"}, Coordinate{-117.636, 49.3007}}, // West Kootenay Regional Airport
    Airport{IataCode{"YCH"}, CountryId{"CA"}, Coordinate{-65.4569, 47.0058}}, // Miramichi Airport
    Airport{IataCode{"YCK"}, CountryId{"CA"}, Coordinate{-126.129, 67.0211}}, // Colville Lake Airport
    Airport{IataCode{"YCL"}, CountryId{"CA"}, Coordinate{-66.3303, 47.9908}}, // Charlo Airport
    Airport{IataCode{"YCM"}, CountryId{"CA"}, Coordinate{-79.171, 43.1893}}, // St. Catharines/Niagara District Airport
    Airport{IataCode{"YCN"}, CountryId{"CA"}, Coordinate{-81.0153, 49.1067}}, // Cochrane Airport
    Airport{IataCode{"YCO"}, CountryId{"CA"}, Coordinate{-115.135, 67.8171}}, // Kugluktuk Airport
    Airport{IataCode{"YCQ"}, CountryId{"CA"}, Coordinate{-121.627, 55.6872}}, // Chetwynd Airport
    Airport{IataCode{"YCR"}, CountryId{"CA"}, Coordinate{-97.7603, 54.6108}}, // Cross Lake Airport
    Airport{IataCode{"YCS"}, CountryId{"CA"}, Coordinate{-90.7311, 63.3472}}, // Chesterfield Inlet Airport
    Airport{IataCode{"YCT"}, CountryId{"CA"}, Coordinate{-111.445, 52.075}}, // Coronation Airport
    Airport{IataCode{"YCU"}, CountryId{"CN"}, Coordinate{111.038, 35.1142}}, // Yuncheng Guangong Airport
    Airport{IataCode{"YCW"}, CountryId{"CA"}, Coordinate{-121.939, 49.1528}}, // Chilliwack Airport
    Airport{IataCode{"YCY"}, CountryId{"CA"}, Coordinate{-68.5169, 70.4858}}, // Clyde River Airport
    Airport{IataCode{"YCZ"}, CountryId{"CA"}, Coordinate{-115.873, 50.3303}}, // Fairmont Hot Springs Airport
    Airport{IataCode{"YDA"}, CountryId{"CA"}, Coordinate{-139.13, 64.0422}}, // Dawson City Airport
    Airport{IataCode{"YDB"}, CountryId{"CA"}, Coordinate{-139.04, 61.3706}}, // Burwash Airport
    Airport{IataCode{"YDC"}, CountryId{"CA"}, Coordinate{-114.96, 53.2658}}, // Drayton Valley Industrial Airport
    Airport{IataCode{"YDF"}, CountryId{"CA"}, Coordinate{-57.3944, 49.2092}}, // Deer Lake Regional Airport
    Airport{IataCode{"YDG"}, CountryId{"CA"}, Coordinate{-65.7858, 44.5458}}, // Digby/Annapolis Regional Airport
    Airport{IataCode{"YDJ"}, CountryId{"CA"}, Coordinate{-103.538, 58.6625}}, // Hatchet Lake Airport
    Airport{IataCode{"YDL"}, CountryId{"CA"}, Coordinate{-130.018, 58.4263}}, // Dease Lake Airport
    Airport{IataCode{"YDO"}, CountryId{"CA"}, Coordinate{-72.375, 48.7783}}, // Dolbeau-Saint-Félicien Airport
    Airport{IataCode{"YDP"}, CountryId{"CA"}, Coordinate{-61.6822, 56.5506}}, // Nain Airport
    Airport{IataCode{"YDQ"}, CountryId{"CA"}, Coordinate{-120.183, 55.7422}}, // Dawson Creek Airport
    Airport{IataCode{"YDT"}, CountryId{"CA"}, Coordinate{-123.009, 49.0806}}, // Boundary Bay Airport
    Airport{IataCode{"YDU"}, CountryId{"CA"}, Coordinate{-102.502, 60.2919}}, // Kasba Lake Airport
    Airport{IataCode{"YDV"}, CountryId{"CA"}, Coordinate{-96.6922, 51.7844}}, // Bloodvein River Airport
    Airport{IataCode{"YDW"}, CountryId{"CA"}, Coordinate{-103.132, 60.3156}}, // Obre Lake/North of Sixty Airport
    Airport{IataCode{"YEA"}, CountryId{"CA"}, Coordinate{-110, 50.9333}}, // Empress Airport
    Airport{IataCode{"YEB"}, CountryId{"CA"}, Coordinate{-84.0942, 46.4189}}, // Bar River Airport
    Airport{IataCode{"YEE"}, CountryId{"CA"}, Coordinate{-79.9294, 44.6847}}, // Midland/Huronia Airport
    Airport{IataCode{"YEG"}, CountryId{"CA"}, Coordinate{-113.582, 53.307}}, // Edmonton International Airport
    Airport{IataCode{"YEH"}, CountryId{"IR"}, Coordinate{52.6153, 27.4814}}, // Asalouyeh Airport
    Airport{IataCode{"YEK"}, CountryId{"CA"}, Coordinate{-94.0715, 61.0981}}, // Arviat Airport
    Airport{IataCode{"YEL"}, CountryId{"CA"}, Coordinate{-82.5611, 46.3517}}, // Elliot Lake Municipal Airport
    Airport{IataCode{"YEM"}, CountryId{"CA"}, Coordinate{-81.8575, 45.8425}}, // Manitowaning/Manitoulin East Municipal Airport
    Airport{IataCode{"YEN"}, CountryId{"CA"}, Coordinate{-102.966, 49.2103}}, // Estevan Regional Aerodrome
    Airport{IataCode{"YEQ"}, CountryId{"PG"}, Coordinate{143.917, -5.1}}, // Yenkis
    Airport{IataCode{"YER"}, CountryId{"CA"}, Coordinate{-87.6761, 56.0189}}, // Fort Severn Airport
    Airport{IataCode{"YES"}, CountryId{"IR"}, Coordinate{51.5526, 30.6995}}, // Yasuj Airport
    Airport{IataCode{"YET"}, CountryId{"CA"}, Coordinate{-116.465, 53.5789}}, // Edson Airport
    Airport{IataCode{"YEU"}, CountryId{"CA"}, Coordinate{-85.8119, 79.9944}}, // Eureka Aerodrome
    Airport{IataCode{"YEV"}, CountryId{"CA"}, Coordinate{-133.483, 68.3039}}, // Inuvik (Mike Zubko) Airport
    Airport{IataCode{"YEY"}, CountryId{"CA"}, Coordinate{-78.2492, 48.565}}, // Amos/Magny Airport
    Airport{IataCode{"YFA"}, CountryId{"CA"}, Coordinate{-81.6958, 52.2036}}, // Fort Albany Airport
    Airport{IataCode{"YFB"}, CountryId{"CA"}, Coordinate{-68.5414, 63.7545}}, // Iqaluit Airport
    Airport{IataCode{"YFC"}, CountryId{"CA"}, Coordinate{-66.5295, 45.8726}}, // Fredericton International Airport
    Airport{IataCode{"YFD"}, CountryId{"CA"}, Coordinate{-79.6289, 44.1361}}, // Bradford Aerodrome
    Airport{IataCode{"YFE"}, CountryId{"CA"}, Coordinate{-69.0972, 48.7461}}, // Forestville Airport
    Airport{IataCode{"YFG"}, CountryId{"CA"}, Coordinate{-71.1733, 54.5539}}, // Fontages Airport
    Airport{IataCode{"YFH"}, CountryId{"CA"}, Coordinate{-87.9078, 51.5619}}, // Fort Hope Airport
    Airport{IataCode{"YFI"}, CountryId{"CA"}, Coordinate{-110.977, 57.2758}}, // Fort MacKay/Firebag Aerodrome
    Airport{IataCode{"YFJ"}, CountryId{"CA"}, Coordinate{-114.079, 64.1917}}, // Wekweètì Airport
    Airport{IataCode{"YFL"}, CountryId{"CA"}, Coordinate{-109.167, 62.7}}, // Fort Reliance Water Aerodrome
    Airport{IataCode{"YFO"}, CountryId{"CA"}, Coordinate{-101.682, 54.6781}}, // Flin Flon Airport
    Airport{IataCode{"YFR"}, CountryId{"CA"}, Coordinate{-113.69, 61.1808}}, // Fort Resolution Airport
    Airport{IataCode{"YFS"}, CountryId{"CA"}, Coordinate{-121.237, 61.7603}}, // Fort Simpson Airport
    Airport{IataCode{"YFX"}, CountryId{"CA"}, Coordinate{-55.6739, 52.3728}}, // St. Lewis (Fox Harbour) Airport
    Airport{IataCode{"YGB"}, CountryId{"CA"}, Coordinate{-124.518, 49.6942}}, // Texada/Gillies Bay Airport
    Airport{IataCode{"YGC"}, CountryId{"CA"}, Coordinate{-118.874, 53.9169}}, // Grande Cache Airport
    Airport{IataCode{"YGG"}, CountryId{"CA"}, Coordinate{-123.5, 48.85}}, // Ganges Water Aerodrome
    Airport{IataCode{"YGH"}, CountryId{"CA"}, Coordinate{-128.648, 66.2406}}, // Fort Good Hope Airport
    Airport{IataCode{"YGJ"}, CountryId{"JP"}, Coordinate{133.245, 35.5006}}, // Miho-Yonago Airport
    Airport{IataCode{"YGK"}, CountryId{"CA"}, Coordinate{-76.597, 44.2191}}, // Kingston/Norman Rogers Airport
    Airport{IataCode{"YGL"}, CountryId{"CA"}, Coordinate{-77.6947, 53.6263}}, // La Grande Rivière Airport
    Airport{IataCode{"YGM"}, CountryId{"CA"}, Coordinate{-97.0433, 50.6281}}, // Gimli Industrial Park Airport
    Airport{IataCode{"YGO"}, CountryId{"CA"}, Coordinate{-94.4914, 54.5589}}, // Gods Lake Narrows Airport
    Airport{IataCode{"YGP"}, CountryId{"CA"}, Coordinate{-64.4797, 48.7753}}, // Michel-Pouliot Gaspé Airport
    Airport{IataCode{"YGQ"}, CountryId{"CA"}, Coordinate{-86.9386, 49.7786}}, // Geraldton (Greenstone Regional) Airport
    Airport{IataCode{"YGR"}, CountryId{"CA"}, Coordinate{-61.7746, 47.4238}}, // Îles-de-la-Madeleine Airport
    Airport{IataCode{"YGT"}, CountryId{"CA"}, Coordinate{-81.8164, 69.3647}}, // Igloolik Airport
    Airport{IataCode{"YGV"}, CountryId{"CA"}, Coordinate{-63.6037, 50.282}}, // Havre Saint-Pierre Airport
    Airport{IataCode{"YGW"}, CountryId{"CA"}, Coordinate{-77.7653, 55.2819}}, // Kuujjuarapik Airport
    Airport{IataCode{"YGX"}, CountryId{"CA"}, Coordinate{-94.7108, 56.3578}}, // Gillam Airport
    Airport{IataCode{"YGZ"}, CountryId{"CA"}, Coordinate{-82.9094, 76.4261}}, // Grise Fiord Airport
    Airport{IataCode{"YHA"}, CountryId{"CA"}, Coordinate{-56.2853, 52.5281}}, // Port Hope Simpson Airport
    Airport{IataCode{"YHB"}, CountryId{"CA"}, Coordinate{-102.311, 52.8183}}, // Hudson Bay Airport
    Airport{IataCode{"YHD"}, CountryId{"CA"}, Coordinate{-92.7442, 49.8317}}, // Dryden Regional Airport
    Airport{IataCode{"YHE"}, CountryId{"CA"}, Coordinate{-121.498, 49.3683}}, // Hope Aerodrome
    Airport{IataCode{"YHF"}, CountryId{"CA"}, Coordinate{-83.6869, 49.7139}}, // Hearst (René Fontaine) Municipal Airport
    Airport{IataCode{"YHG"}, CountryId{"CA"}, Coordinate{-56.1125, 52.7658}}, // Charlottetown Airport (Labrador)
    Airport{IataCode{"YHH"}, CountryId{"CA"}, Coordinate{-125.25, 50.05}}, // Campbell River Water Aerodrome
    Airport{IataCode{"YHI"}, CountryId{"CA"}, Coordinate{-117.801, 70.7611}}, // Ulukhaktok/Holman Airport
    Airport{IataCode{"YHK"}, CountryId{"CA"}, Coordinate{-95.8503, 68.6356}}, // Gjoa Haven Airport
    Airport{IataCode{"YHM"}, CountryId{"CA"}, Coordinate{-79.9264, 43.1631}}, // John C. Munro Hamilton International Airport
    Airport{IataCode{"YHN"}, CountryId{"CA"}, Coordinate{-84.7589, 49.1931}}, // Hornepayne Municipal Airport
    Airport{IataCode{"YHO"}, CountryId{"CA"}, Coordinate{-60.2281, 55.4489}}, // Hopedale Airport
    Airport{IataCode{"YHP"}, CountryId{"CA"}, Coordinate{-94.2556, 52.1133}}, // Poplar Hill Airport
    Airport{IataCode{"YHR"}, CountryId{"CA"}, Coordinate{-59.6429, 50.4634}}, // Chevery Airport
    Airport{IataCode{"YHS"}, CountryId{"CA"}, Coordinate{-123.719, 49.4606}}, // Sechelt Aerodrome
    Airport{IataCode{"YHT"}, CountryId{"CA"}, Coordinate{-137.545, 60.7894}}, // Haines Junction Airport
    Airport{IataCode{"YHU"}, CountryId{"CA"}, Coordinate{-73.4169, 45.5181}}, // Montréal/Saint-Hubert Airport
    Airport{IataCode{"YHY"}, CountryId{"CA"}, Coordinate{-115.781, 60.8388}}, // Hay River/Merlyn Carter Airport
    Airport{IataCode{"YHZ"}, CountryId{"CA"}, Coordinate{-63.5148, 44.8866}}, // Halifax Stanfield International Airport
    Airport{IataCode{"YIA"}, CountryId{"ID"}, Coordinate{110.059, -7.89968}}, // Yogyakarta International Airport
    Airport{IataCode{"YIB"}, CountryId{"CA"}, Coordinate{-91.6386, 48.7739}}, // Atikokan Municipal Airport
    Airport{IataCode{"YIC"}, CountryId{"CN"}, Coordinate{114.31, 27.8006}}, // Yichun Mingyueshan Airport
    Airport{IataCode{"YIE"}, CountryId{"CN"}, Coordinate{119.916, 47.3078}}, // Arxan Yi'ershi Airport
    Airport{IataCode{"YIF"}, CountryId{"CA"}, Coordinate{-58.6575, 51.2097}}, // Saint-Augustin Airport
    Airport{IataCode{"YIH"}, CountryId{"CN"}, Coordinate{111.48, 30.5501}}, // Yichang Airport
    Airport{IataCode{"YIK"}, CountryId{"CA"}, Coordinate{-77.9253, 62.4155}}, // Ivujivik Airport
    Airport{IataCode{"YIN"}, CountryId{"CN"}, Coordinate{81.3311, 43.9522}}, // Yining Airport
    Airport{IataCode{"YIO"}, CountryId{"CA"}, Coordinate{-77.9689, 72.6894}}, // Pond Inlet Airport
    Airport{IataCode{"YIP"}, CountryId{"US"}, Coordinate{-83.5304, 42.2379}}, // Willow Run Airport
    Airport{IataCode{"YIV"}, CountryId{"CA"}, Coordinate{-94.6536, 53.8572}}, // Island Lake Airport
    Airport{IataCode{"YIW"}, CountryId{"CN"}, Coordinate{120.032, 29.3447}}, // Yiwu Airport
    Airport{IataCode{"YJA"}, CountryId{"CA"}, Coordinate{-118.059, 52.9967}}, // Jasper Airport
    Airport{IataCode{"YJF"}, CountryId{"CA"}, Coordinate{-123.47, 60.2356}}, // Fort Liard Airport
    Airport{IataCode{"YJM"}, CountryId{"CA"}, Coordinate{-124.263, 54.3972}}, // Fort St. James (Perison) Airport
    Airport{IataCode{"YJN"}, CountryId{"CA"}, Coordinate{-73.2817, 45.2944}}, // Saint-Jean Airport
    Airport{IataCode{"YJP"}, CountryId{"CA"}, Coordinate{-117.753, 53.3192}}, // Hinton/Jasper-Hinton Airport
    Airport{IataCode{"YJS"}, CountryId{"KP"}, Coordinate{128.41, 41.9072}}, // Samjiyŏn Airport
    Airport{IataCode{"YJT"}, CountryId{"CA"}, Coordinate{-58.55, 48.5414}}, // Stephenville International Airport
    Airport{IataCode{"YKA"}, CountryId{"CA"}, Coordinate{-120.442, 50.7053}}, // Kamloops Airport
    Airport{IataCode{"YKC"}, CountryId{"CA"}, Coordinate{-103.677, 58.2361}}, // Collins Bay Airport
    Airport{IataCode{"YKD"}, CountryId{"CA"}, Coordinate{-81.5992, 44.2022}}, // Kincardine Airport
    Airport{IataCode{"YKE"}, CountryId{"CA"}, Coordinate{-94.7981, 54.9153}}, // Knee Lake Airport
    Airport{IataCode{"YKF"}, CountryId{"CA"}, Coordinate{-80.3858, 43.4558}}, // Region of Waterloo International Airport
    Airport{IataCode{"YKG"}, CountryId{"CA"}, Coordinate{-70.0037, 60.0233}}, // Kangirsuk Airport
    Airport{IataCode{"YKH"}, CountryId{"CN"}, Coordinate{122.357, 40.5408}}, // Yingkou Lanqi Airport
    Airport{IataCode{"YKJ"}, CountryId{"CA"}, Coordinate{-105.618, 57.2564}}, // Key Lake Airport
    Airport{IataCode{"YKK"}, CountryId{"CA"}, Coordinate{-130.433, 53.8}}, // Kitkatla Water Aerodrome
    Airport{IataCode{"YKL"}, CountryId{"CA"}, Coordinate{-66.807, 54.8023}}, // Schefferville Airport
    Airport{IataCode{"YKM"}, CountryId{"US"}, Coordinate{-120.54, 46.5701}}, // Yakima Air Terminal
    Airport{IataCode{"YKN"}, CountryId{"US"}, Coordinate{-97.3824, 42.9105}}, // Chan Gurney Municipal Airport
    Airport{IataCode{"YKO"}, CountryId{"TR"}, Coordinate{44.2558, 37.5464}}, // Hakkari Yüksekova Airport
    Airport{IataCode{"YKQ"}, CountryId{"CA"}, Coordinate{-78.7583, 51.4733}}, // Waskaganish Airport
    Airport{IataCode{"YKS"}, CountryId{"RU"}, Coordinate{129.751, 62.0867}}, // Yakutsk Airport
    Airport{IataCode{"YKU"}, CountryId{"CA"}, Coordinate{-78.9236, 53.8069}}, // Chisasibi Airport
    Airport{IataCode{"YKX"}, CountryId{"CA"}, Coordinate{-79.9814, 48.2103}}, // Kirkland Lake Airport
    Airport{IataCode{"YKY"}, CountryId{"CA"}, Coordinate{-109.181, 51.5153}}, // Kindersley Regional Airport
    Airport{IataCode{"YKZ"}, CountryId{"CA"}, Coordinate{-79.3701, 43.8657}}, // Buttonville Municipal Airport
    Airport{IataCode{"YLB"}, CountryId{"CA"}, Coordinate{-112.032, 54.7703}}, // Lac La Biche Airport
    Airport{IataCode{"YLC"}, CountryId{"CA"}, Coordinate{-69.8772, 62.8481}}, // Kimmirut Airport
    Airport{IataCode{"YLD"}, CountryId{"CA"}, Coordinate{-83.3469, 47.8203}}, // Chapleau Airport
    Airport{IataCode{"YLE"}, CountryId{"CA"}, Coordinate{-117.246, 63.1317}}, // Whatì Airport
    Airport{IataCode{"YLG"}, CountryId{"AU"}, Coordinate{116.683, -28.3537}}, // Yalgoo Airport
    Airport{IataCode{"YLH"}, CountryId{"CA"}, Coordinate{-87.9342, 52.1956}}, // Lansdowne House Airport
    Airport{IataCode{"YLJ"}, CountryId{"CA"}, Coordinate{-108.523, 54.1253}}, // Meadow Lake Airport
    Airport{IataCode{"YLK"}, CountryId{"CA"}, Coordinate{-79.5556, 44.4861}}, // Lake Simcoe Regional Airport
    Airport{IataCode{"YLL"}, CountryId{"CA"}, Coordinate{-110.073, 53.3122}}, // Lloydminster Airport
    Airport{IataCode{"YLN"}, CountryId{"CN"}, Coordinate{129.6, 46.32}}, // Yilan Airport
    Airport{IataCode{"YLP"}, CountryId{"CA"}, Coordinate{-64.145, 50.29}}, // Mingan Airport
    Airport{IataCode{"YLQ"}, CountryId{"CA"}, Coordinate{-72.7889, 47.4097}}, // La Tuque Airport
    Airport{IataCode{"YLR"}, CountryId{"CA"}, Coordinate{-99.9853, 56.5133}}, // Leaf Rapids Airport
    Airport{IataCode{"YLS"}, CountryId{"CA"}, Coordinate{-77.0172, 49.0303}}, // Lebel-sur-Quévillon Airport
    Airport{IataCode{"YLT"}, CountryId{"CA"}, Coordinate{-62.2806, 82.5178}}, // Alert Airport
    Airport{IataCode{"YLV"}, CountryId{"AZ"}, Coordinate{47.1417, 40.6317}}, // Yevlakh Airport
    Airport{IataCode{"YLW"}, CountryId{"CA"}, Coordinate{-119.381, 49.9513}}, // Kelowna International Airport
    Airport{IataCode{"YLX"}, CountryId{"CN"}, Coordinate{110.119, 22.4386}}, // Yulin Fumian Airport
    Airport{IataCode{"YLY"}, CountryId{"CA"}, Coordinate{-122.631, 49.1008}}, // Langley Regional Airport
    Airport{IataCode{"YMA"}, CountryId{"CA"}, Coordinate{-135.868, 63.6164}}, // Mayo Airport
    Airport{IataCode{"YMB"}, CountryId{"CA"}, Coordinate{-120.747, 50.1228}}, // Merritt Airport
    Airport{IataCode{"YMD"}, CountryId{"CA"}, Coordinate{-119.319, 76.2392}}, // Mould Bay Airport
    Airport{IataCode{"YME"}, CountryId{"CA"}, Coordinate{-67.4603, 48.8526}}, // Matane Airport
    Airport{IataCode{"YMG"}, CountryId{"CA"}, Coordinate{-85.8611, 49.0833}}, // Manitouwadge Airport
    Airport{IataCode{"YMH"}, CountryId{"CA"}, Coordinate{-55.8478, 52.3028}}, // Mary's Harbour Airport
    Airport{IataCode{"YML"}, CountryId{"CA"}, Coordinate{-70.2239, 47.5975}}, // Charlevoix Airport
    Airport{IataCode{"YMM"}, CountryId{"CA"}, Coordinate{-111.227, 56.6526}}, // Fort McMurray International Airport
    Airport{IataCode{"YMN"}, CountryId{"CA"}, Coordinate{-59.1878, 55.0772}}, // Makkovik Airport
    Airport{IataCode{"YMO"}, CountryId{"CA"}, Coordinate{-80.6138, 51.2885}}, // Moosonee Airport
    Airport{IataCode{"YMP"}, CountryId{"CA"}, Coordinate{-127.029, 50.5756}}, // Port McNeill Airport
    Airport{IataCode{"YMS"}, CountryId{"PE"}, Coordinate{-76.1181, -5.89361}}, // Moisés Benzaquén Rengifo Airport
    Airport{IataCode{"YMT"}, CountryId{"CA"}, Coordinate{-74.5286, 49.7784}}, // Chibougamau/Chapais Airport
    Airport{IataCode{"YMU"}, CountryId{"CA"}, Coordinate{-124.983, 50.0667}}, // Mansons Landing Water Aerodrome
    Airport{IataCode{"YMV"}, CountryId{"CA"}, Coordinate{-79.3569, 71.3242}}, // Mary River Aerodrome
    Airport{IataCode{"YMW"}, CountryId{"CA"}, Coordinate{-75.9906, 46.2728}}, // Maniwaki Airport
    Airport{IataCode{"YMX"}, CountryId{"CA"}, Coordinate{-74.0386, 45.6797}}, // Montréal–Mirabel International Airport
    Airport{IataCode{"YNA"}, CountryId{"CA"}, Coordinate{-61.7887, 50.1888}}, // Natashquan Airport
    Airport{IataCode{"YNB"}, CountryId{"SA"}, Coordinate{38.0636, 24.1442}}, // Yanbu Airport
    Airport{IataCode{"YNC"}, CountryId{"CA"}, Coordinate{-78.8311, 53.0106}}, // Wemindji Airport
    Airport{IataCode{"YND"}, CountryId{"CA"}, Coordinate{-75.561, 45.5187}}, // Gatineau-Ottawa Executive Airport
    Airport{IataCode{"YNE"}, CountryId{"CA"}, Coordinate{-97.8442, 53.9583}}, // Norway House Airport
    Airport{IataCode{"YNG"}, CountryId{"US"}, Coordinate{-80.6792, 41.2608}}, // Youngstown-Warren Regional Airport
    Airport{IataCode{"YNH"}, CountryId{"CA"}, Coordinate{-121.976, 56.0356}}, // Hudson's Hope Airport
    Airport{IataCode{"YNJ"}, CountryId{"CN"}, Coordinate{129.439, 42.8851}}, // Yanji Chaoyangchuan Airport
    Airport{IataCode{"YNL"}, CountryId{"CA"}, Coordinate{-104.082, 58.2767}}, // Points North Landing Airport
    Airport{IataCode{"YNM"}, CountryId{"CA"}, Coordinate{-77.8028, 49.7617}}, // Matagami Airport
    Airport{IataCode{"YNN"}, CountryId{"AU"}, Coordinate{119.2, -22.77}}, // Yandicoogina Airport
    Airport{IataCode{"YNO"}, CountryId{"CA"}, Coordinate{-92.9711, 52.4733}}, // North Spirit Lake Airport
    Airport{IataCode{"YNP"}, CountryId{"CA"}, Coordinate{-61.1844, 55.9139}}, // Natuashish Airport
    Airport{IataCode{"YNS"}, CountryId{"CA"}, Coordinate{-76.1356, 51.6911}}, // Nemiscau Airport
    Airport{IataCode{"YNT"}, CountryId{"CN"}, Coordinate{120.986, 37.6581}}, // Yantai Penglai International Airport
    Airport{IataCode{"YNX"}, CountryId{"CA"}, Coordinate{-110.906, 63.5936}}, // Snap Lake Airport
    Airport{IataCode{"YNY"}, CountryId{"KR"}, Coordinate{128.663, 38.0588}}, // Yangyang International Airport
    Airport{IataCode{"YNZ"}, CountryId{"CN"}, Coordinate{120.204, 33.4327}}, // Yancheng Nanyang Airport
    Airport{IataCode{"YOA"}, CountryId{"CA"}, Coordinate{-110.615, 64.6989}}, // Ekati Airport
    Airport{IataCode{"YOC"}, CountryId{"CA"}, Coordinate{-139.84, 67.57}}, // Old Crow Airport
    Airport{IataCode{"YOE"}, CountryId{"CA"}, Coordinate{-117.094, 55.7094}}, // Donnelly Airport
    Airport{IataCode{"YOG"}, CountryId{"CA"}, Coordinate{-85.9011, 51.6586}}, // Ogoki Post Airport
    Airport{IataCode{"YOH"}, CountryId{"CA"}, Coordinate{-95.287, 54.9305}}, // Oxford House Airport
    Airport{IataCode{"YOJ"}, CountryId{"CA"}, Coordinate{-117.165, 58.6217}}, // High Level Airport
    Airport{IataCode{"YOL"}, CountryId{"NG"}, Coordinate{12.4259, 9.26729}}, // Yola Airport
    Airport{IataCode{"YON"}, CountryId{"BT"}, Coordinate{91.5149, 27.2553}}, // Yongphulla Airport
    Airport{IataCode{"YOO"}, CountryId{"CA"}, Coordinate{-78.8967, 43.9228}}, // Oshawa Airport
    Airport{IataCode{"YOP"}, CountryId{"CA"}, Coordinate{-119.413, 58.4947}}, // Rainbow Lake Airport
    Airport{IataCode{"YOS"}, CountryId{"CA"}, Coordinate{-80.8383, 44.5906}}, // Owen Sound Billy Bishop Regional Airport
    Airport{IataCode{"YOT"}, CountryId{"IL"}, Coordinate{35.0675, 29.9011}}, // Yotvata Airfield
    Airport{IataCode{"YOW"}, CountryId{"CA"}, Coordinate{-75.6673, 45.322}}, // Ottawa Macdonald-Cartier International Airport
    Airport{IataCode{"YPA"}, CountryId{"CA"}, Coordinate{-105.673, 53.2144}}, // Prince Albert (Glass Field) Airport
    Airport{IataCode{"YPB"}, CountryId{"CA"}, Coordinate{-124.928, 49.317}}, // Port Alberni (Alberni Valley Regional) Airport
    Airport{IataCode{"YPC"}, CountryId{"CA"}, Coordinate{-124.076, 69.3606}}, // Paulatuk (Nora Aliqatchialuk Ruben) Airport
    Airport{IataCode{"YPD"}, CountryId{"CA"}, Coordinate{-79.83, 45.2528}}, // Parry Sound Area Municipal Airport
    Airport{IataCode{"YPE"}, CountryId{"CA"}, Coordinate{-117.444, 56.232}}, // Peace River Airport
    Airport{IataCode{"YPF"}, CountryId{"CA"}, Coordinate{-123.4, 48.4333}}, // Esquimalt Airport
    Airport{IataCode{"YPG"}, CountryId{"CA"}, Coordinate{-98.2739, 49.9031}}, // Portage la Prairie Southport Airport
    Airport{IataCode{"YPH"}, CountryId{"CA"}, Coordinate{-78.0769, 58.4719}}, // Inukjuak Airport
    Airport{IataCode{"YPI"}, CountryId{"CA"}, Coordinate{-130.433, 54.5667}}, // Port Simpson Water Aerodrome
    Airport{IataCode{"YPJ"}, CountryId{"CA"}, Coordinate{-69.5997, 59.2967}}, // Aupaluk Airport
    Airport{IataCode{"YPK"}, CountryId{"CA"}, Coordinate{-122.713, 49.2161}}, // Pitt Meadows Airport
    Airport{IataCode{"YPL"}, CountryId{"CA"}, Coordinate{-90.2142, 51.4464}}, // Pickle Lake Airport
    Airport{IataCode{"YPM"}, CountryId{"CA"}, Coordinate{-93.9733, 51.8197}}, // Pikangikum Airport
    Airport{IataCode{"YPN"}, CountryId{"CA"}, Coordinate{-64.2886, 49.8364}}, // Port-Menier Airport
    Airport{IataCode{"YPO"}, CountryId{"CA"}, Coordinate{-85.4433, 54.9881}}, // Peawanuck Airport
    Airport{IataCode{"YPQ"}, CountryId{"CA"}, Coordinate{-78.3633, 44.2306}}, // Peterborough Airport
    Airport{IataCode{"YPR"}, CountryId{"CA"}, Coordinate{-130.446, 54.2927}}, // Prince Rupert Airport
    Airport{IataCode{"YPS"}, CountryId{"CA"}, Coordinate{-61.3681, 45.6567}}, // Port Hawkesbury Airport
    Airport{IataCode{"YPT"}, CountryId{"CA"}, Coordinate{-124.017, 49.6167}}, // Pender Harbour Water Aerodrome
    Airport{IataCode{"YPW"}, CountryId{"CA"}, Coordinate{-124.5, 49.8342}}, // Powell River Airport
    Airport{IataCode{"YPX"}, CountryId{"CA"}, Coordinate{-77.2875, 60.0522}}, // Puvirnituq Airport
    Airport{IataCode{"YPY"}, CountryId{"CA"}, Coordinate{-111.118, 58.7675}}, // Fort Chipewyan Airport
    Airport{IataCode{"YPZ"}, CountryId{"CA"}, Coordinate{-125.951, 54.3764}}, // Burns Lake Airport
    Airport{IataCode{"YQA"}, CountryId{"CA"}, Coordinate{-79.3073, 44.9686}}, // Muskoka Airport
    Airport{IataCode{"YQB"}, CountryId{"CA"}, Coordinate{-71.3832, 46.7923}}, // Québec City Jean Lesage International Airport
    Airport{IataCode{"YQC"}, CountryId{"CA"}, Coordinate{-69.6178, 61.0464}}, // Quaqtaq Airport
    Airport{IataCode{"YQD"}, CountryId{"CA"}, Coordinate{-101.09, 53.974}}, // The Pas Airport
    Airport{IataCode{"YQF"}, CountryId{"CA"}, Coordinate{-113.887, 52.1764}}, // Red Deer Regional Airport
    Airport{IataCode{"YQG"}, CountryId{"CA"}, Coordinate{-82.9602, 42.266}}, // Windsor International Airport
    Airport{IataCode{"YQH"}, CountryId{"CA"}, Coordinate{-128.822, 60.1164}}, // Watson Lake Airport
    Airport{IataCode{"YQI"}, CountryId{"CA"}, Coordinate{-66.088, 43.8302}}, // Yarmouth Airport
    Airport{IataCode{"YQK"}, CountryId{"CA"}, Coordinate{-94.3631, 49.7883}}, // Kenora Airport
    Airport{IataCode{"YQL"}, CountryId{"CA"}, Coordinate{-112.788, 49.6337}}, // Lethbridge Airport
    Airport{IataCode{"YQM"}, CountryId{"CA"}, Coordinate{-64.6884, 46.1162}}, // Greater Moncton International Airport
    Airport{IataCode{"YQN"}, CountryId{"CA"}, Coordinate{-86.6975, 50.1831}}, // Nakina Airport
    Airport{IataCode{"YQR"}, CountryId{"CA"}, Coordinate{-104.656, 50.4335}}, // Regina International Airport
    Airport{IataCode{"YQS"}, CountryId{"CA"}, Coordinate{-81.1097, 42.77}}, // St. Thomas Municipal Airport
    Airport{IataCode{"YQT"}, CountryId{"CA"}, Coordinate{-89.3217, 48.3719}}, // Thunder Bay International Airport
    Airport{IataCode{"YQU"}, CountryId{"CA"}, Coordinate{-118.874, 55.1766}}, // Grande Prairie Airport
    Airport{IataCode{"YQV"}, CountryId{"CA"}, Coordinate{-102.461, 51.2647}}, // Yorkton Municipal Airport
    Airport{IataCode{"YQW"}, CountryId{"CA"}, Coordinate{-108.244, 52.7692}}, // North Battleford (Cameron McIntosh) Airport
    Airport{IataCode{"YQX"}, CountryId{"CA"}, Coordinate{-54.5748, 48.9466}}, // Gander International Airport
    Airport{IataCode{"YQY"}, CountryId{"CA"}, Coordinate{-60.047, 46.1673}}, // Sydney/J.A. Douglas McCurdy Airport
    Airport{IataCode{"YQZ"}, CountryId{"CA"}, Coordinate{-122.51, 53.0261}}, // Quesnel Airport
    Airport{IataCode{"YRA"}, CountryId{"CA"}, Coordinate{-117.31, 64.1161}}, // Gamètì/Rae Lakes Airport
    Airport{IataCode{"YRB"}, CountryId{"CA"}, Coordinate{-94.9694, 74.7169}}, // Resolute Bay Airport
    Airport{IataCode{"YRC"}, CountryId{"CA"}, Coordinate{-71.0506, 48.5208}}, // Chicoutimi/Saint-Honoré Aerodrome
    Airport{IataCode{"YRD"}, CountryId{"CA"}, Coordinate{-126.965, 52.8234}}, // Dean River Airport
    Airport{IataCode{"YRF"}, CountryId{"CA"}, Coordinate{-57.0419, 53.6825}}, // Cartwright Airport
    Airport{IataCode{"YRG"}, CountryId{"CA"}, Coordinate{-58.451, 54.1787}}, // Rigolet Airport
    Airport{IataCode{"YRI"}, CountryId{"CA"}, Coordinate{-69.5844, 47.7644}}, // Rivière-du-Loup Airport
    Airport{IataCode{"YRJ"}, CountryId{"CA"}, Coordinate{-72.2658, 48.52}}, // Roberval Airport
    Airport{IataCode{"YRL"}, CountryId{"CA"}, Coordinate{-93.8009, 51.0684}}, // Red Lake Airport
    Airport{IataCode{"YRM"}, CountryId{"CA"}, Coordinate{-114.904, 52.4297}}, // Rocky Mountain House Airport
    Airport{IataCode{"YRN"}, CountryId{"CA"}, Coordinate{-127.25, 51.6833}}, // Rivers Inlet Water Aerodrome
    Airport{IataCode{"YRO"}, CountryId{"CA"}, Coordinate{-75.6461, 45.4603}}, // Ottawa/Rockcliffe Airport
    Airport{IataCode{"YRP"}, CountryId{"CA"}, Coordinate{-76.0222, 45.3225}}, // Carp Airport
    Airport{IataCode{"YRQ"}, CountryId{"CA"}, Coordinate{-72.6806, 46.3517}}, // Trois-Rivières Airport
    Airport{IataCode{"YRS"}, CountryId{"CA"}, Coordinate{-93.5575, 54.1675}}, // Red Sucker Lake Airport
    Airport{IataCode{"YRT"}, CountryId{"CA"}, Coordinate{-92.1147, 62.8106}}, // Rankin Inlet Airport
    Airport{IataCode{"YRV"}, CountryId{"CA"}, Coordinate{-118.183, 50.9667}}, // Revelstoke Airport
    Airport{IataCode{"YSA"}, CountryId{"CA"}, Coordinate{-59.9597, 43.9294}}, // Sable Island Aerodrome
    Airport{IataCode{"YSB"}, CountryId{"CA"}, Coordinate{-80.7978, 46.6256}}, // Sudbury Airport
    Airport{IataCode{"YSC"}, CountryId{"CA"}, Coordinate{-71.6893, 45.4416}}, // Sherbrooke Airport
    Airport{IataCode{"YSE"}, CountryId{"CA"}, Coordinate{-123.162, 49.7817}}, // Squamish Airport
    Airport{IataCode{"YSF"}, CountryId{"CA"}, Coordinate{-105.841, 59.2503}}, // Stony Rapids Airport
    Airport{IataCode{"YSG"}, CountryId{"CA"}, Coordinate{-110.682, 62.4183}}, // Lutselk'e Airport
    Airport{IataCode{"YSH"}, CountryId{"CA"}, Coordinate{-75.9403, 44.9458}}, // Smiths Falls-Montague Airport
    Airport{IataCode{"YSJ"}, CountryId{"CA"}, Coordinate{-65.8904, 45.3292}}, // Saint John Airport
    Airport{IataCode{"YSK"}, CountryId{"CA"}, Coordinate{-79.2462, 56.536}}, // Sanikiluaq Airport
    Airport{IataCode{"YSL"}, CountryId{"CA"}, Coordinate{-67.8364, 47.1572}}, // Saint-Léonard Aerodrome
    Airport{IataCode{"YSM"}, CountryId{"CA"}, Coordinate{-111.962, 60.0203}}, // Fort Smith Airport
    Airport{IataCode{"YSN"}, CountryId{"CA"}, Coordinate{-119.229, 50.6825}}, // Salmon Arm Airport
    Airport{IataCode{"YSO"}, CountryId{"CA"}, Coordinate{-59.7853, 54.9103}}, // Postville Airport
    Airport{IataCode{"YSP"}, CountryId{"CA"}, Coordinate{-86.3458, 48.7572}}, // Marathon Aerodrome
    Airport{IataCode{"YSQ"}, CountryId{"CN"}, Coordinate{124.449, 44.9381}}, // Songyuan Chaganhu Airport
    Airport{IataCode{"YSV"}, CountryId{"CA"}, Coordinate{-62.6542, 58.4744}}, // Saglek Airport
    Airport{IataCode{"YSY"}, CountryId{"CA"}, Coordinate{-125.241, 71.9936}}, // Sachs Harbour (David Nasogaluak Jr. Saaryuaq) Airport
    Airport{IataCode{"YTA"}, CountryId{"CA"}, Coordinate{-77.2514, 45.8644}}, // Pembroke Airport
    Airport{IataCode{"YTB"}, CountryId{"CA"}, Coordinate{-129.25, 53.4167}}, // Hartley Bay Water Aerodrome
    Airport{IataCode{"YTD"}, CountryId{"CA"}, Coordinate{-97.7078, 55.3189}}, // Thicket Portage Airport
    Airport{IataCode{"YTE"}, CountryId{"CA"}, Coordinate{-76.525, 64.2303}}, // Cape Dorset Airport
    Airport{IataCode{"YTF"}, CountryId{"CA"}, Coordinate{-71.6414, 48.5086}}, // Alma Airport
    Airport{IataCode{"YTG"}, CountryId{"CA"}, Coordinate{-126.833, 50.8833}}, // Sullivan Bay Water Aerodrome
    Airport{IataCode{"YTH"}, CountryId{"CA"}, Coordinate{-97.8609, 55.7977}}, // Thompson Airport
    Airport{IataCode{"YTJ"}, CountryId{"CA"}, Coordinate{-87.0994, 48.8133}}, // Terrace Bay Airport
    Airport{IataCode{"YTL"}, CountryId{"CA"}, Coordinate{-89.8969, 53.8178}}, // Big Trout Lake Airport
    Airport{IataCode{"YTM"}, CountryId{"CA"}, Coordinate{-74.78, 46.4092}}, // Mont Tremblant International Airport
    Airport{IataCode{"YTN"}, CountryId{"CA"}, Coordinate{-62.6211, 45.6119}}, // Trenton Aerodrome
    Airport{IataCode{"YTQ"}, CountryId{"CA"}, Coordinate{-69.9558, 58.6678}}, // Tasiujaq Airport
    Airport{IataCode{"YTS"}, CountryId{"CA"}, Coordinate{-81.3722, 48.5666}}, // Timmins/Victor M. Power Airport
    Airport{IataCode{"YTT"}, CountryId{"CA"}, Coordinate{-104.067, 52.8367}}, // Tisdale Airport
    Airport{IataCode{"YTY"}, CountryId{"CN"}, Coordinate{119.714, 32.5627}}, // Yangzhou Taizhou Airport
    Airport{IataCode{"YTZ"}, CountryId{"CA"}, Coordinate{-79.3966, 43.6316}}, // Billy Bishop Toronto City Airport
    Airport{IataCode{"YUA"}, CountryId{"CN"}, Coordinate{101.883, 25.7343}}, // Yuanmou Airport
    Airport{IataCode{"YUB"}, CountryId{"CA"}, Coordinate{-133.026, 69.4333}}, // Tuktoyaktuk/James Gruben Airport
    Airport{IataCode{"YUD"}, CountryId{"CA"}, Coordinate{-76.5183, 56.5361}}, // Umiujaq Airport
    Airport{IataCode{"YUE"}, CountryId{"AU"}, Coordinate{131.782, -22.2542}}, // Yuendumu Airport
    Airport{IataCode{"YUL"}, CountryId{"CA"}, Coordinate{-73.7495, 45.4574}}, // Montréal–Pierre Elliott Trudeau International Airport
    Airport{IataCode{"YUM"}, CountryId{"US"}, Coordinate{-114.606, 32.6567}}, // Yuma International Airport
    Airport{IataCode{"YUS"}, CountryId{"CN"}, Coordinate{97.038, 32.8399}}, // Yushu Batang Airport
    Airport{IataCode{"YUT"}, CountryId{"CA"}, Coordinate{-86.2247, 66.5206}}, // Repulse Bay Airport
    Airport{IataCode{"YUX"}, CountryId{"CA"}, Coordinate{-81.2425, 68.7758}}, // Hall Beach Airport
    Airport{IataCode{"YUY"}, CountryId{"CA"}, Coordinate{-78.8356, 48.2061}}, // Rouyn-Noranda Airport
    Airport{IataCode{"YVA"}, CountryId{"KM"}, Coordinate{43.2439, -11.7108}}, // Iconi Airport
    Airport{IataCode{"YVB"}, CountryId{"CA"}, Coordinate{-65.4603, 48.0711}}, // Bonaventure Airport
    Airport{IataCode{"YVC"}, CountryId{"CA"}, Coordinate{-105.269, 55.1465}}, // La Ronge (Barber Field) Airport
    Airport{IataCode{"YVD"}, CountryId{"PG"}, Coordinate{146.167, -7.55}}, // Yeva
    Airport{IataCode{"YVE"}, CountryId{"CA"}, Coordinate{-119.331, 50.2461}}, // Vernon Regional Airport
    Airport{IataCode{"YVG"}, CountryId{"CA"}, Coordinate{-110.825, 52.3569}}, // Vermilion Airport
    Airport{IataCode{"YVM"}, CountryId{"CA"}, Coordinate{-64.0317, 67.5467}}, // Qikiqtarjuaq Airport
    Airport{IataCode{"YVO"}, CountryId{"CA"}, Coordinate{-77.7828, 48.0533}}, // Val-d'Or Airport
    Airport{IataCode{"YVP"}, CountryId{"CA"}, Coordinate{-68.4186, 58.099}}, // Kuujjuaq Airport
    Airport{IataCode{"YVQ"}, CountryId{"CA"}, Coordinate{-126.799, 65.2814}}, // Norman Wells Airport
    Airport{IataCode{"YVR"}, CountryId{"CA"}, Coordinate{-123.178, 49.1949}}, // Vancouver International Airport
    Airport{IataCode{"YVT"}, CountryId{"CA"}, Coordinate{-108.419, 55.8415}}, // Buffalo Narrows Airport
    Airport{IataCode{"YVV"}, CountryId{"CA"}, Coordinate{-81.1086, 44.7442}}, // Wiarton Airport
    Airport{IataCode{"YVZ"}, CountryId{"CA"}, Coordinate{-94.0614, 52.6558}}, // Deer Lake Airport
    Airport{IataCode{"YWA"}, CountryId{"CA"}, Coordinate{-77.3192, 45.9522}}, // Petawawa Airport
    Airport{IataCode{"YWB"}, CountryId{"CA"}, Coordinate{-71.9323, 61.5911}}, // Kangiqsujuaq Airport
    Airport{IataCode{"YWG"}, CountryId{"CA"}, Coordinate{-97.2228, 49.9003}}, // Winnipeg James Armstrong Richardson International Airport
    Airport{IataCode{"YWH"}, CountryId{"CA"}, Coordinate{-123.387, 48.4228}}, // Victoria Inner Harbour Airport
    Airport{IataCode{"YWJ"}, CountryId{"CA"}, Coordinate{-123.436, 65.2111}}, // Déline Airport
    Airport{IataCode{"YWK"}, CountryId{"CA"}, Coordinate{-66.8732, 52.9266}}, // Wabush Airport
    Airport{IataCode{"YWL"}, CountryId{"CA"}, Coordinate{-122.054, 52.1833}}, // Williams Lake Airport
    Airport{IataCode{"YWM"}, CountryId{"CA"}, Coordinate{-55.785, 52.5675}}, // Williams Harbour Airport
    Airport{IataCode{"YWP"}, CountryId{"CA"}, Coordinate{-87.3753, 52.9594}}, // Webequie Airport
    Airport{IataCode{"YWQ"}, CountryId{"CA"}, Coordinate{-71.1361, 49.945}}, // Chutes-des-Passes/Lac Margane Water Aerodrome
    Airport{IataCode{"YWR"}, CountryId{"CA"}, Coordinate{-85.2233, 48.6269}}, // White River Water Aerodrome
    Airport{IataCode{"YWV"}, CountryId{"CA"}, Coordinate{-110.857, 52.7958}}, // Wainwright Aerodrome
    Airport{IataCode{"YWY"}, CountryId{"CA"}, Coordinate{-123.437, 63.2097}}, // Wrigley Airport
    Airport{IataCode{"YXC"}, CountryId{"CA"}, Coordinate{-115.786, 49.6145}}, // Canadian Rockies International Airport
    Airport{IataCode{"YXE"}, CountryId{"CA"}, Coordinate{-106.691, 52.1701}}, // Saskatoon John G. Diefenbaker International Airport
    Airport{IataCode{"YXH"}, CountryId{"CA"}, Coordinate{-110.722, 50.022}}, // Medicine Hat Airport
    Airport{IataCode{"YXI"}, CountryId{"CA"}, Coordinate{-77.6028, 45.6631}}, // Killaloe/Bonnechere Airport
    Airport{IataCode{"YXJ"}, CountryId{"CA"}, Coordinate{-120.735, 56.2455}}, // Fort St. John Airport
    Airport{IataCode{"YXK"}, CountryId{"CA"}, Coordinate{-68.5045, 48.4763}}, // Rimouski Airport
    Airport{IataCode{"YXL"}, CountryId{"CA"}, Coordinate{-91.9056, 50.1142}}, // Sioux Lookout Airport
    Airport{IataCode{"YXN"}, CountryId{"CA"}, Coordinate{-92.5981, 62.24}}, // Whale Cove Airport
    Airport{IataCode{"YXP"}, CountryId{"CA"}, Coordinate{-65.7136, 66.145}}, // Pangnirtung Airport
    Airport{IataCode{"YXQ"}, CountryId{"CA"}, Coordinate{-140.869, 62.4103}}, // Beaver Creek Airport
    Airport{IataCode{"YXR"}, CountryId{"CA"}, Coordinate{-79.8489, 47.695}}, // Earlton (Timiskaming Regional) Airport
    Airport{IataCode{"YXS"}, CountryId{"CA"}, Coordinate{-122.677, 53.8842}}, // Prince George Airport
    Airport{IataCode{"YXT"}, CountryId{"CA"}, Coordinate{-128.577, 54.4727}}, // Northwest Regional Airport
    Airport{IataCode{"YXU"}, CountryId{"CA"}, Coordinate{-81.1491, 43.0284}}, // London International Airport
    Airport{IataCode{"YXX"}, CountryId{"CA"}, Coordinate{-122.36, 49.0253}}, // Abbotsford International Airport
    Airport{IataCode{"YXY"}, CountryId{"CA"}, Coordinate{-135.076, 60.7143}}, // Erik Nielsen Whitehorse International Airport
    Airport{IataCode{"YXZ"}, CountryId{"CA"}, Coordinate{-84.7864, 47.9669}}, // Wawa Airport
    Airport{IataCode{"YYA"}, CountryId{"CN"}, Coordinate{113.282, 29.3137}}, // Yueyang Sanhe Airport
    Airport{IataCode{"YYB"}, CountryId{"CA"}, Coordinate{-79.427, 46.3574}}, // North Bay/Jack Garland Airport
    Airport{IataCode{"YYC"}, CountryId{"CA"}, Coordinate{-114.006, 51.1318}}, // Calgary International Airport
    Airport{IataCode{"YYD"}, CountryId{"CA"}, Coordinate{-127.186, 54.823}}, // Smithers Airport
    Airport{IataCode{"YYE"}, CountryId{"CA"}, Coordinate{-122.586, 58.839}}, // Fort Nelson Airport
    Airport{IataCode{"YYF"}, CountryId{"CA"}, Coordinate{-119.602, 49.4625}}, // Penticton Regional Airport
    Airport{IataCode{"YYG"}, CountryId{"CA"}, Coordinate{-63.1311, 46.2859}}, // Charlottetown Airport
    Airport{IataCode{"YYH"}, CountryId{"CA"}, Coordinate{-93.5769, 69.5467}}, // Taloyoak Airport
    Airport{IataCode{"YYJ"}, CountryId{"CA"}, Coordinate{-123.43, 48.6407}}, // Victoria International Airport
    Airport{IataCode{"YYL"}, CountryId{"CA"}, Coordinate{-101.076, 56.8644}}, // Lynn Lake Airport
    Airport{IataCode{"YYM"}, CountryId{"CA"}, Coordinate{-114.094, 49.6364}}, // Cowley Airport
    Airport{IataCode{"YYN"}, CountryId{"CA"}, Coordinate{-107.691, 50.2925}}, // Swift Current Airport
    Airport{IataCode{"YYO"}, CountryId{"CA"}, Coordinate{-104.169, 51.8092}}, // Wynyard/W. B. Needham Field Aerodrome
    Airport{IataCode{"YYT"}, CountryId{"CA"}, Coordinate{-52.743, 47.6126}}, // St. John's International Airport
    Airport{IataCode{"YYU"}, CountryId{"CA"}, Coordinate{-82.4686, 49.4117}}, // Kapuskasing Airport
    Airport{IataCode{"YYW"}, CountryId{"CA"}, Coordinate{-88.9097, 50.2903}}, // Armstrong Airport
    Airport{IataCode{"YYY"}, CountryId{"CA"}, Coordinate{-68.2115, 48.6022}}, // Mont-Joli Airport
    Airport{IataCode{"YYZ"}, CountryId{"CA"}, Coordinate{-79.6134, 43.683}}, // Toronto Pearson International Airport
    Airport{IataCode{"YZA"}, CountryId{"CA"}, Coordinate{-121.322, 50.775}}, // Cache Creek Airport
    Airport{IataCode{"YZD"}, CountryId{"CA"}, Coordinate{-79.4656, 43.7428}}, // Downsview Airport
    Airport{IataCode{"YZE"}, CountryId{"CA"}, Coordinate{-82.5683, 45.8842}}, // Gore Bay-Manitoulin Airport
    Airport{IataCode{"YZF"}, CountryId{"CA"}, Coordinate{-114.44, 62.4631}}, // Yellowknife Airport
    Airport{IataCode{"YZG"}, CountryId{"CA"}, Coordinate{-75.6672, 62.1794}}, // Salluit Airport
    Airport{IataCode{"YZH"}, CountryId{"CA"}, Coordinate{-114.777, 55.2931}}, // Slave Lake Airport
    Airport{IataCode{"YZP"}, CountryId{"CA"}, Coordinate{-131.814, 53.2542}}, // Sandspit Airport
    Airport{IataCode{"YZR"}, CountryId{"CA"}, Coordinate{-82.3061, 42.9933}}, // Sarnia Chris Hadfield Airport
    Airport{IataCode{"YZS"}, CountryId{"CA"}, Coordinate{-83.3594, 64.1933}}, // Coral Harbour Airport
    Airport{IataCode{"YZT"}, CountryId{"CA"}, Coordinate{-127.333, 50.6806}}, // Port Hardy Airport
    Airport{IataCode{"YZU"}, CountryId{"CA"}, Coordinate{-115.784, 54.1402}}, // Whitecourt Airport
    Airport{IataCode{"YZV"}, CountryId{"CA"}, Coordinate{-66.2656, 50.2233}}, // Sept-Îles Airport
    Airport{IataCode{"YZW"}, CountryId{"CA"}, Coordinate{-132.744, 60.1731}}, // Teslin Airport
    Airport{IataCode{"YZY"}, CountryId{"CN"}, Coordinate{100.655, 38.8139}}, // Zhangye Ganzhou Airport
    Airport{IataCode{"YZZ"}, CountryId{"CA"}, Coordinate{-117.608, 49.058}}, // Trail Airport
    Airport{IataCode{"ZAC"}, CountryId{"CA"}, Coordinate{-96.0892, 56.0894}}, // York Landing Airport
    Airport{IataCode{"ZAD"}, CountryId{"HR"}, Coordinate{15.3534, 44.0967}}, // Zadar Airport
    Airport{IataCode{"ZAG"}, CountryId{"HR"}, Coordinate{16.07, 45.7369}}, // Zagreb Airport
    Airport{IataCode{"ZAH"}, CountryId{"IR"}, Coordinate{60.9007, 29.4755}}, // Zahedan Airport
    Airport{IataCode{"ZAJ"}, CountryId{"AF"}, Coordinate{61.8667, 30.9695}}, // Zaranj Airport
    Airport{IataCode{"ZAL"}, CountryId{"CL"}, Coordinate{-73.0815, -39.6509}}, // Pichoy Airport
    Airport{IataCode{"ZAM"}, CountryId{"PH"}, Coordinate{122.062, 6.91967}}, // Zamboanga International Airport
    Airport{IataCode{"ZAR"}, CountryId{"NG"}, Coordinate{7.68556, 11.13}}, // Zaria Airport
    Airport{IataCode{"ZAT"}, CountryId{"CN"}, Coordinate{103.753, 27.3279}}, // Zhaotong Airport
    Airport{IataCode{"ZAZ"}, CountryId{"ES"}, Coordinate{-1.00765, 41.6631}}, // Zaragoza Airport
    Airport{IataCode{"ZBE"}, CountryId{"CZ"}, Coordinate{18.0783, 49.9283}}, // Zábřeh Ostrava Airport
    Airport{IataCode{"ZBF"}, CountryId{"CA"}, Coordinate{-65.7434, 47.6312}}, // Bathurst Airport
    Airport{IataCode{"ZBG"}, CountryId{"PL"}, Coordinate{19.4233, 54.1409}}, // Elbląg Airport
    Airport{IataCode{"ZBK"}, CountryId{"ME"}, Coordinate{19.2333, 43.1167}}, // Žabljak Airport
    Airport{IataCode{"ZBM"}, CountryId{"CA"}, Coordinate{-72.7323, 45.296}}, // Roland-Désourdy Airport
    Airport{IataCode{"ZBO"}, CountryId{"AU"}, Coordinate{148.215, -20.0199}}, // Bowen Airport
    Airport{IataCode{"ZBR"}, CountryId{"IR"}, Coordinate{60.3819, 25.4433}}, // Konarak Airport
    Airport{IataCode{"ZBY"}, CountryId{"LA"}, Coordinate{101.708, 19.2417}}, // Sayaboury Airport
    Airport{IataCode{"ZCL"}, CountryId{"MX"}, Coordinate{-102.68, 22.9004}}, // General Leobardo C. Ruiz International Airport
    Airport{IataCode{"ZCO"}, CountryId{"CL"}, Coordinate{-72.647, -38.9272}}, // Aeropuerto La Araucanía
    Airport{IataCode{"ZCQ"}, CountryId{"CL"}, Coordinate{-71.2169, -34.9669}}, // General Freire Airfield
    Airport{IataCode{"ZDY"}, CountryId{"AE"}, Coordinate{52.333, 24.5025}}, // Dalma Airport
    Airport{IataCode{"ZEF"}, CountryId{"US"}, Coordinate{-80.7861, 36.28}}, // Elkin Municipal Airport
    Airport{IataCode{"ZEL"}, CountryId{"CA"}, Coordinate{-128.157, 52.185}}, // Bella Bella Airport
    Airport{IataCode{"ZEM"}, CountryId{"CA"}, Coordinate{-78.5225, 52.2264}}, // Eastmain River Airport
    Airport{IataCode{"ZER"}, CountryId{"IN"}, Coordinate{93.8281, 27.5883}}, // Zero Airport
    Airport{IataCode{"ZFA"}, CountryId{"CA"}, Coordinate{-133.383, 62.211}}, // Faro Airport
    Airport{IataCode{"ZFD"}, CountryId{"CA"}, Coordinate{-107.182, 59.3344}}, // Fond-du-Lac Airport
    Airport{IataCode{"ZFM"}, CountryId{"CA"}, Coordinate{-134.86, 67.4069}}, // Fort McPherson Airport
    Airport{IataCode{"ZFN"}, CountryId{"CA"}, Coordinate{-125.573, 64.9097}}, // Tulita Airport
    Airport{IataCode{"ZFW"}, CountryId{"CA"}, Coordinate{-118.433, 56.0814}}, // Fairview Airport
    Airport{IataCode{"ZGF"}, CountryId{"CA"}, Coordinate{-118.431, 49.0156}}, // Grand Forks Airport
    Airport{IataCode{"ZGI"}, CountryId{"CA"}, Coordinate{-94.0786, 54.8397}}, // Gods River Airport
    Airport{IataCode{"ZGL"}, CountryId{"AU"}, Coordinate{142.108, -25.6833}}, // South Galway Airport
    Airport{IataCode{"ZGM"}, CountryId{"ZM"}, Coordinate{25.9399, -15.9645}}, // Ngoma Airport
    Airport{IataCode{"ZGR"}, CountryId{"CA"}, Coordinate{-95.4661, 52.045}}, // Little Grand Rapids Airport
    Airport{IataCode{"ZGS"}, CountryId{"CA"}, Coordinate{-60.6693, 50.258}}, // La Romaine Airport
    Airport{IataCode{"ZGU"}, CountryId{"VU"}, Coordinate{167.587, -14.2181}}, // Gaua Airport
    Airport{IataCode{"ZHA"}, CountryId{"CN"}, Coordinate{110.361, 21.2143}}, // Zhanjiang Airport
    Airport{IataCode{"ZHM"}, CountryId{"BD"}, Coordinate{91.9169, 24.3983}}, // Shamshernagar Airport
    Airport{IataCode{"ZHP"}, CountryId{"CA"}, Coordinate{-116.475, 53.3936}}, // High Prairie Airport
    Airport{IataCode{"ZHY"}, CountryId{"CN"}, Coordinate{105.154, 37.5728}}, // Zhongwei Shapotou Airport
    Airport{IataCode{"ZIA"}, CountryId{"RU"}, Coordinate{38.118, 55.5619}}, // Zhukovsky International Airport
    Airport{IataCode{"ZIC"}, CountryId{"CL"}, Coordinate{-72.3459, -38.2441}}, // Victoria Airport
    Airport{IataCode{"ZIG"}, CountryId{"SN"}, Coordinate{-16.2769, 12.5578}}, // Ziguinchor Airport
    Airport{IataCode{"ZIH"}, CountryId{"MX"}, Coordinate{-101.46, 17.6014}}, // Ixtapa-Zihuatanejo International Airport
    Airport{IataCode{"ZIN"}, CountryId{"CH"}, Coordinate{7.87786, 46.6747}}, // Interlaken Airport
    Airport{IataCode{"ZIS"}, CountryId{"LY"}, Coordinate{12.25, 31.775}}, // Alzintan Airport
    Airport{IataCode{"ZIX"}, CountryId{"RU"}, Coordinate{123.363, 66.7942}}, // Zhigansk Airport
    Airport{IataCode{"ZJG"}, CountryId{"CA"}, Coordinate{-98.0461, 54.5189}}, // Jenpeg Airport
    Airport{IataCode{"ZJI"}, CountryId{"CH"}, Coordinate{8.87972, 46.1619}}, // Locarno Airport
    Airport{IataCode{"ZJN"}, CountryId{"CA"}, Coordinate{-101.234, 52.1214}}, // Swan River Airport
    Airport{IataCode{"ZKB"}, CountryId{"ZM"}, Coordinate{30.6614, -8.53333}}, // Kasaba Bay Airport
    Airport{IataCode{"ZKE"}, CountryId{"CA"}, Coordinate{-81.6778, 52.2825}}, // Kashechewan Airport
    Airport{IataCode{"ZKG"}, CountryId{"CA"}, Coordinate{-61.2658, 50.1958}}, // Kegaska Airport
    Airport{IataCode{"ZKM"}, CountryId{"GA"}, Coordinate{9.76528, -2.53889}}, // Sette-Cama Airport
    Airport{IataCode{"ZKP"}, CountryId{"RU"}, Coordinate{150.708, 65.7383}}, // Zyryanka Airport
    Airport{IataCode{"ZLO"}, CountryId{"MX"}, Coordinate{-104.56, 19.1481}}, // Playa de Oro International Airport
    Airport{IataCode{"ZLR"}, CountryId{"CL"}, Coordinate{-71.5486, -35.8617}}, // Linares Airport
    Airport{IataCode{"ZLT"}, CountryId{"CA"}, Coordinate{-58.9756, 50.8308}}, // La Tabatière Airport
    Airport{IataCode{"ZLX"}, CountryId{"SD"}, Coordinate{23.4824, 12.9012}}, // Zalingei Airport
    Airport{IataCode{"ZMH"}, CountryId{"CA"}, Coordinate{-121.333, 51.7367}}, // South Cariboo Regional Airport
    Airport{IataCode{"ZMM"}, CountryId{"MX"}, Coordinate{-102.271, 20.0456}}, // Zamora Airport
    Airport{IataCode{"ZMO"}, CountryId{"IT"}, Coordinate{10.8086, 44.6314}}, // Modena Airport
    Airport{IataCode{"ZMT"}, CountryId{"CA"}, Coordinate{-132.125, 54.0272}}, // Masset Airport
    Airport{IataCode{"ZNA"}, CountryId{"CA"}, Coordinate{-123.935, 49.1692}}, // Nanaimo Harbour Water Airport
    Airport{IataCode{"ZNC"}, CountryId{"US"}, Coordinate{-159.994, 60.9806}}, // Nyac Airport
    Airport{IataCode{"ZND"}, CountryId{"NE"}, Coordinate{8.9837, 13.779}}, // Zinder Airport
    Airport{IataCode{"ZNE"}, CountryId{"AU"}, Coordinate{119.803, -23.4178}}, // Newman Airport
    Airport{IataCode{"ZNJ"}, CountryId{"ZA"}, Coordinate{27.9833, -27.2833}}, // Heilbron Airport
    Airport{IataCode{"ZNL"}, CountryId{"CA"}, Coordinate{-117.301, 49.4942}}, // Nelson Airport
    Airport{IataCode{"ZNZ"}, CountryId{"TZ"}, Coordinate{39.2213, -6.22222}}, // Abeid Amani Karume International Airport
    Airport{IataCode{"ZOS"}, CountryId{"CL"}, Coordinate{-73.0611, -40.6045}}, // Cañal Bajo Carlos Hott Siebert Airport
    Airport{IataCode{"ZPB"}, CountryId{"CA"}, Coordinate{-92.1964, 53.8911}}, // Sachigo Lake Airport
    Airport{IataCode{"ZPC"}, CountryId{"CL"}, Coordinate{-71.9208, -39.2914}}, // Pucón Airport
    Airport{IataCode{"ZPH"}, CountryId{"US"}, Coordinate{-82.1558, 28.2281}}, // Zephyrhills Municipal Airport
    Airport{IataCode{"ZPO"}, CountryId{"CA"}, Coordinate{-106.582, 55.5281}}, // Pinehouse Lake Airport
    Airport{IataCode{"ZQN"}, CountryId{"NZ"}, Coordinate{168.739, -45.0218}}, // Queenstown Airport
    Airport{IataCode{"ZQS"}, CountryId{"CA"}, Coordinate{-132.076, 53.2543}}, // Queen Charlotte City Water Aerodrome
    Airport{IataCode{"ZQW"}, CountryId{"DE"}, Coordinate{7.40056, 49.2094}}, // Zweibrücken Airport
    Airport{IataCode{"ZQZ"}, CountryId{"CN"}, Coordinate{114.931, 40.7392}}, // Zhangjiakou Ningyuan Airport
    Airport{IataCode{"ZRE"}, CountryId{"RS"}, Coordinate{20.4541, 45.3398}}, // Zrenjanin Airport
    Airport{IataCode{"ZRH"}, CountryId{"CH"}, Coordinate{8.56223, 47.4503}}, // Zurich Airport
    Airport{IataCode{"ZRI"}, CountryId{"ID"}, Coordinate{136.24, -1.87386}}, // Serui Airport
    Airport{IataCode{"ZRJ"}, CountryId{"CA"}, Coordinate{-91.3144, 52.9446}}, // Round Lake (Weagamow Lake) Airport
    Airport{IataCode{"ZSA"}, CountryId{"BS"}, Coordinate{-74.5318, 24.066}}, // San Salvador Airport
    Airport{IataCode{"ZSE"}, CountryId{"FR"}, Coordinate{55.4283, -21.3204}}, // Pierrefonds Airport
    Airport{IataCode{"ZSI"}, CountryId{"KZ"}, Coordinate{84.886, 47.4861}}, // Zaysan Airport
    Airport{IataCode{"ZSJ"}, CountryId{"CA"}, Coordinate{-93.3444, 53.0642}}, // Sandy Lake Airport
    Airport{IataCode{"ZSP"}, CountryId{"CA"}, Coordinate{-111.378, 53.9936}}, // St. Paul Aerodrome
    Airport{IataCode{"ZSS"}, CountryId{"CI"}, Coordinate{-6.13278, 4.92833}}, // Sassandra Airport
    Airport{IataCode{"ZST"}, CountryId{"CA"}, Coordinate{-129.983, 55.9333}}, // Stewart Aerodrome
    Airport{IataCode{"ZSU"}, CountryId{"DE"}, Coordinate{12.184, 51.8318}}, // Dessau Aerodrome
    Airport{IataCode{"ZSW"}, CountryId{"CA"}, Coordinate{-130.283, 54.3333}}, // Prince Rupert/Seal Cove Water Airport
    Airport{IataCode{"ZTA"}, CountryId{"FR"}, Coordinate{-138.567, -20.7808}}, // Tureia Airport
    Airport{IataCode{"ZTB"}, CountryId{"CA"}, Coordinate{-59.3836, 50.6744}}, // Tête-à-la-Baleine Airport
    Airport{IataCode{"ZTH"}, CountryId{"GR"}, Coordinate{20.8869, 37.7547}}, // Zakynthos International Airport
    Airport{IataCode{"ZTM"}, CountryId{"CA"}, Coordinate{-92.0814, 55.8631}}, // Shamattawa Airport
    Airport{IataCode{"ZTR"}, CountryId{"UA"}, Coordinate{28.7386, 50.2706}}, // Zhytomyr Airport
    Airport{IataCode{"ZTS"}, CountryId{"CA"}, Coordinate{-126.667, 49.9167}}, // Tahsis Water Aerodrome
    Airport{IataCode{"ZTU"}, CountryId{"AZ"}, Coordinate{46.6672, 41.5622}}, // Zaqatala International Airport
    Airport{IataCode{"ZUC"}, CountryId{"CA"}, Coordinate{-91.7178, 49.4297}}, // Ignace Municipal Airport
    Airport{IataCode{"ZUD"}, CountryId{"CL"}, Coordinate{-73.7966, -41.9035}}, // Pupelde Airport
    Airport{IataCode{"ZUH"}, CountryId{"CN"}, Coordinate{113.373, 22.0105}}, // Zhuhai Jinwan Airport
    Airport{IataCode{"ZUL"}, CountryId{"AR"}, Coordinate{-59.8808, -36.8368}}, // Azul Airport
    Airport{IataCode{"ZUM"}, CountryId{"CA"}, Coordinate{-64.1058, 53.5625}}, // Churchill Falls Airport
    Airport{IataCode{"ZVA"}, CountryId{"MG"}, Coordinate{45.45, -19.5667}}, // Miandrivazo Airport
    Airport{IataCode{"ZVG"}, CountryId{"AU"}, Coordinate{127.67, -17.7869}}, // Springvale Airport
    Airport{IataCode{"ZVK"}, CountryId{"LA"}, Coordinate{104.763, 16.5568}}, // Savannakhet Airport
    Airport{IataCode{"ZWA"}, CountryId{"MG"}, Coordinate{49.6167, -14.6517}}, // Andapa Airport
    Airport{IataCode{"ZWL"}, CountryId{"CA"}, Coordinate{-103.171, 58.1068}}, // Wollaston Lake Airport
    Airport{IataCode{"ZXB"}, CountryId{"NO"}, Coordinate{-8.57583, 70.9611}}, // Jan Mayensfield
    Airport{IataCode{"ZXT"}, CountryId{"AZ"}, Coordinate{49.977, 40.4951}}, // Zabrat Airport
    Airport{IataCode{"ZYI"}, CountryId{"CN"}, Coordinate{107, 27.59}}, // Zunyi Xinzhou Airport
    Airport{IataCode{"ZYL"}, CountryId{"BD"}, Coordinate{91.8708, 24.9585}}, // Osmani International Airport
    Airport{IataCode{"ZZF"}, CountryId{"AU"}, Coordinate{142.9, -37.28}}, // Mystery Flight Airport
    Airport{IataCode{"ZZO"}, CountryId{"RU"}, Coordinate{142.76, 50.6683}}, // Zonalnoye Airport
    Airport{IataCode{"ZZU"}, CountryId{"MW"}, Coordinate{34.0146, -11.4483}}, // Mzuzu Airport
    Airport{IataCode{"ZZV"}, CountryId{"US"}, Coordinate{-81.8922, 39.9444}}, // Zanesville Municipal Airport
};

// reverse name lookup string table for unique strings
static const char name1_string_table_0[] =
    "aachen" // MST
    "aalborg" // AAL
    "aarhus" // AAR
    "aasiaat" // JEG
    "ababa" // ADD
    "abadan" // ABD
    "abaiang" // ABF
    "abakan" // ABA
    "abane" // BJA
    "abbass" // BND
    "abbaye" // BGH
    "abbes" // BFW
    "abbotsford" // YXX
    "abbotsinch" // GLA
    "abbs" // EAB
    "abbse" // EAB
    "abdelhafid" // TID
    "abdullah" // GIZ
    "abdullahi" // GLK
    "abdulmohsin" // YNB
    "abeid" // ZNZ
    "abel" // SNU
    "abelardo" // TIJ
    "abemama" // AEA
    "abensur" // PCL
    "abenzur" // PCL
    "abha" // AHB
    "abilene" // ABI
    "abingdon" // ABG
    "aboisso" // ABO
    "abou" // AOD
    "abraq" // LAQ
    "abreojos" // AJS
    "abruzzo" // PSR
    "abubakar" // SKO
    "abumusa" // AEU
    "acadiana" // ARA
    "acandi" // ACD
    "acapulco" // ACA
    "accomack" // MFV
    "achinsk" // ACS
    "achmad" // SRG
    "achutupo" // ACU
    "acosta" // MOA
    "acres" // LMR
    "adado" // AAD
    "adak" // ADK
    "adam" // AOM
    "adana" // ADA
    "adde" // MGQ
    "addington" // EKX
    "addis" // ADD
    "addison" // ADS
    "adelaide" // ADL
    "adem" // PRN
    "adhair" // TRE
    "adirondack" // SLK
    "adisucipto" // JOG
    "adisumarmo" // SOC
    "adler" // AER
    "adnan" // ADB
    "adolf" // PBM
    "adrar" // AZR
    "advanced" // LBG
    "adıyaman" // ADF
    "aek" // AEG
    "aen" // AID
    "aerea" // QTR
    "aeron" // COR
    "aeronautico" // COR
    "aeroparque" // AEP
    "aeropelican" // BEO
    "aeroplex" // GUS
    "afld" // CIS
    "afore" // AFR
    "afrika" // NCS
    "afton" // AFO
    "afutara" // AFT
    "afyon" // AFY
    "agadir" // AGA
    "agartala" // IXA
    "agatti" // AGX
    "agaun" // AUP
    "agde" // BZR
    "agen" // AGF
    "aggeneys" // AGZ
    "aggi" // MBU
    "aghajari" // AKW
    "agoncillo" // RJL
    "agramonte" // CMW
    "agrio" // LGQ
    "agrı" // AJI
    "aguacate" // CAA
    "aguachica" // HAY
    "aguaclara" // ACL
    "aguas" // OCV
    "aguascalientes" // AGU
    "aguenar" // TMR
    "aguiar" // VIX
    "aguni" // AGJ
    "ahart" // OPL
    "ahilyabai" // IDR
    "ahmad" // KUA
    "ahmedabad" // AMD
    "aho" // NTT
    "ahsa" // HOF
    "ahuas" // AHS
    "ahvaz" // AWZ
    "ahwaz" // AWZ
    "aiac" // SID
    "aiambak" // AIH
    "aiap" // BVC
    "aice" // VXE
    "aihui" // HEK
    "aiken" // AIK
    "ailuk" // AIM
    "aime" // FDF
    "ainsworth" // ANW
    "aiome" // AIE
    "aioun" // AEO
    "aipnm" // RAI
    "airborne" // ILN
    "aircenter" // JCI
    "aircraft" // CEA
    "airm" // RMU
    "airok" // AIC
    "airports" // VCV
    "aishalton" // AHL
    "aitape" // ATP
    "aitutaki" // AIT
    "aix" // CMF
    "aiyura" // AYU
    "aizwal" // AJL
    "ajaccio" // AJA
    "aji" // BPN
    "ajman" // QAJ
    "ajmer" // KQH
    "ajoncs" // EDM
    "akah" // LKH
    "akanu" // ENU
    "akd" // KXE
    "akhamok" // TMR
    "akhiok" // AKK
    "akiak" // AKI
    "akieni" // AKE
    "akita" // AXT
    "akjoujt" // AJJ
    "aklavik" // LAK
    "akola" // AKD
    "aksu" // AKU
    "aktau" // SCO
    "aktion" // PVK
    "aktobe" // AKX
    "aktyubinsk" // AKX
    "akulivik" // AKV
    "akure" // AKR
    "akureyri" // AEY
    "akutan" // KQA
    "akwa" // QUO
    "alacant" // ALC
    "alakanuk" // AUK
    "alameen" // DBB
    "alamein" // DBB
    "alamogordo" // ALM
    "alamos" // LAM
    "alanya" // GZP
    "alashankou" // BPL
    "albacete" // ABC
    "albano" // NOV
    "albatin" // AQI
    "albemarle" // CHO
    "albenga" // ALL
    "alberni" // YPB
    "albertus" // FEP
    "albian" // JHL
    "albina" // ABN
    "albino" // TGZ
    "albion" // WOL
    "albrook" // PAC
    "albuq" // BUK
    "albuquerque" // ABQ
    "albury" // ABX
    "alcala" // HSK
    "alcantari" // SRE
    "alcaravan" // EYP
    "alcides" // ACD
    "aldamiz" // PEM
    "aldan" // ADH
    "aldergrove" // BFS
    "alderney" // ACI
    "alegrete" // ALQ
    "alejandro" // CUZ
    "aleknagik" // WKK
    "aleksandrowice" // QEO
    "alene" // COE
    "aleppo" // ALP
    "aler" // AER
    "alerta" // ALD
    "ales" // FNI
    "alesund" // AES
    "alexandra" // ALR
    "alexandroupolis" // AXD
    "alexeyevka" // TBS
    "alfaro" // MEC
    "alghero" // AHO
    "algiers" // ALG
    "algona" // AXG
    "alguaire" // ILD
    "alia" // AMM
    "alicante" // ALC
    "aliqatchialuk" // YPC
    "aliyev" // GYD
    "allah" // AAV
    "allahabad" // IXD
    "allakaket" // AET
    "allama" // LHE
    "alldays" // ADY
    "allegheny" // AGC
    "allentown" // ABE
    "allgau" // FMM
    "alma" // YTF
    "almandos" // IRJ
    "almaty" // ALA
    "almeirim" // GGF
    "almeria" // LEI
    "almiros" // VOL
    "almonacid" // IRJ
    "along" // IXV
    "alonso" // CTD
    "alor" // ARD
    "alpena" // APN
    "alpha" // ABH
    "alsworth" // PTA
    "alta" // ALF
    "altai" // LTI
    "altamira" // ATM
    "altay" // AAT
    "altaysk" // RGK
    "altenburg" // AOC
    "altenrhein" // ACH
    "alternativa" // DZO
    "altet" // ALC
    "alton" // AWN
    "altoona" // AOO
    "altos" // AAZ
    "altus" // AXS
    "alvarez" // ACA
    "alykel" // NSK
    "alzintan" // ZIS
    "ama" // AMF
    "amahai" // AHI
    "amalie" // STT
    "amami" // ASJ
    "amanab" // AMU
    "amanat" // CGP
    "amani" // ZNZ
    "amarais" // CPQ
    "amarillo" // AMA
    "amata" // AMT
    "amazon" // AZB
    "ambalabe" // WAI
    "ambatondrazaka" // WAM
    "ambedkar" // NAG
    "ambilobe" // AMB
    "ambler" // ABL
    "ambodedjo" // MZI
    "amboim" // PBN
    "amborovy" // MJN
    "amboseli" // ASV
    "ambouli" // JIB
    "ambriz" // AZZ
    "ambrosio" // COR
    "ambunti" // AUJ
    "amderma" // AMV
    "ameijeiras" // VTU
    "amenas" // IAM
    "america" // LBL
    "americas" // SDQ
    "amery" // AHH
    "ames" // AMW
    "amin" // ENO
    "aminu" // KAN
    "aminuddin" // LUW
    "amory" // NEV
    "amos" // YEY
    "amotu" // TBU
    "ampampamena" // IVA
    "ampanihy" // AMP
    "ampapamena" // IVA
    "ampara" // ADP
    "amparai" // ADP
    "amritsar" // ATQ
    "amsei" // BAT
    "anaa" // AAA
    "anacleto" // FRS
    "anaco" // AAO
    "anacortes" // OTS
    "anadolu" // AOE
    "anahim" // YAA
    "anaktuvuk" // AKP
    "analalava" // HVA
    "anapa" // AAQ
    "anapolis" // APS
    "anau" // INU
    "anchialos" // VOL
    "anchorage" // ANC
    "ancona" // AOI
    "anda" // SDN
    "andahuaylas" // ANS
    "andakombe" // ADC
    "andamooka" // ADO
    "andapa" // ZWA
    "andavadoaka" // DVD
    "andenes" // ANX
    "anders" // HEZ
    "andersen" // ODE
    "andi" // MXB
    "andina" // UYU
    "andizhan" // AZN
    "andoya" // ANX
    "andrade" // PLU
    "andre" // GRU
    "andreini" // HAF
    "andrews" // GFK
    "andulo" // ANL
    "andøya" // ANX
    "angads" // OUD
    "angama" // ANA
    "angara" // BQA
    "angelas" // WLP
    "angelina" // LFK
    "angers" // ANE
    "anggi" // AGD
    "angiqsualujjuaq" // XGR
    "anglesey" // VLY
    "anglet" // BIQ
    "angling" // YAX
    "angoche" // ANO
    "angouleme" // ANG
    "anguganak" // AKG
    "anguilla" // AXA
    "aniak" // ANI
    "anibal" // CIJ
    "animas" // AMK
    "aniwa" // AWD
    "ankang" // AKA
    "ankara" // ESB
    "ankavandra" // JVA
    "ann" // ARB
    "anna" // MAA
    "annaba" // AAE
    "annai" // NAI
    "annapolis" // YDG
    "annecy" // NCY
    "annette" // ANN
    "anniston" // ANB
    "annobon" // NBN
    "anqing" // AQG
    "anse" // DSD
    "anshan" // AOG
    "anshun" // AVA
    "anta" // ATA
    "antique" // EUQ
    "antlers" // ATE
    "antofagasta" // ANF
    "antoine" // CYA
    "antrim" // ACB
    "antsalova" // WAQ
    "antsirabato" // ANM
    "antsirabe" // ATJ
    "antsoa" // WBO
    "antwerp" // ANR
    "anua" // BNY
    "anvik" // ANV
    "anyang" // AYN
    "anying" // PZI
    "anzoategui" // BLA
    "aomori" // AOJ
    "aosta" // AOT
    "apache" // GLB
    "apai" // HPA
    "apalachicola" // AAF
    "apalapsili" // AAS
    "apataki" // APK
    "apatity" // KVK
    "apatzingan" // AZG
    "api" // OJU
    "apiaguaiki" // MHW
    "apolo" // APB
    "aponte" // NRR
    "apostle" // OHD
    "apple" // APV
    "appleton" // ATW
    "april" // APR
    "apucarana" // APU
    "apung" // LPU
    "aquila" // QAQ
    "aquino" // MNL
    "aracaju" // AJU
    "aracatuba" // ARU
    "aracena" // IQQ
    "arad" // ARW
    "aragip" // ARP
    "aragon" // CLO
    "aragones" // SDE
    "arak" // AJK
    "aramac" // AXC
    "aramare" // PYH
    "arandis" // ADI
    "arandu" // QVP
    "aransas" // RKP
    "aranuka" // AAK
    "arapahoe" // AHF
    "arapongas" // APX
    "arar" // RAE
    "araracuara" // ACR
    "araraquara" // AQA
    "ararat" // ARY
    "aratika" // RKA
    "arauca" // AUC
    "araucania" // ZCO
    "arauz" // TDD
    "arawa" // RAW
    "araxos" // GPA
    "arba" // AMH
    "arbatax" // TTB
    "arbil" // EBL
    "arbor" // ARB
    "arcata" // ACV
    "ardabil" // ADU
    "arealva" // JTC
    "arenal" // FON
    "arequipa" // AQP
    "argana" // ESG
    "argentinas" // USH
    "aribinda" // XAR
    "ariporo" // PZA
    "aripuana" // AIR
    "arish" // AAC
    "aristarchos" // SMI
    "aristides" // BVC
    "aristotelis" // KSO
    "aristotelous" // KIT
    "arizona" // MSC
    "arka" // KGF
    "arkalyk" // AYK
    "arkhangelsk" // ARH
    "arlanda" // ARN
    "arles" // FNI
    "arlit" // RLT
    "arly" // ARL
    "arm" // YSN
    "armacao" // BZC
    "armenia" // AXM
    "armidale" // ARM
    "armor" // SBK
    "armuelles" // AML
    "army" // EWR
    "arnage" // LME
    "arnat" // QSF
    "arnold" // LBE
    "arnulfo" // SAL
    "aro" // MOL
    "aroeboesman" // ENE
    "aroeppala" // KSR
    "aroostook" // WFK
    "arorae" // AIS
    "aroui" // NDR
    "arpt" // SPK
    "arrabury" // AAB
    "arrachart" // DIE
    "arraias" // AAI
    "arriaga" // SLP
    "arroyo" // EPS
    "arroyos" // OYO
    "arsenio" // ARQ
    "arsizio" // MXP
    "arso" // ARJ
    "art" // BMY
    "artesia" // ATS
    "artigas" // ATI
    "artunduaga" // FLA
    "artvin" // QRI
    "arua" // RUA
    "arusha" // ARK
    "arutua" // AXR
    "arvaikheer" // AVK
    "arviat" // YEK
    "arvidsjaur" // AJR
    "arxan" // YIE
    "asaba" // ABB
    "asahikawa" // AKJ
    "asalouyeh" // YEH
    "asaloyeh" // YEH
    "asapa" // APP
    "asau" // AAU
    "ascencion" // ASC
    "aseki" // AEK
    "ashburton" // ASG
    "asheville" // AVL
    "ashford" // LYX
    "ashgabat" // ASB
    "ashland" // AHM
    "ashley" // ASY
    "ashrafi" // KSH
    "ashtabula" // JFN
    "asirim" // ASZ
    "asis" // PUU
    "aslito" // SPN
    "asmara" // ASM
    "asosa" // ASO
    "aspen" // ASE
    "assab" // ASA
    "assad" // LTK
    "assaf" // ETM
    "assisi" // PEG
    "assiut" // ATZ
    "astete" // CUZ
    "astor" // MDQ
    "astoria" // AST
    "asturias" // OVD
    "astypalaia" // JTY
    "asuncion" // ASU
    "aswan" // ASW
    "asyaee" // QMJ
    "asyut" // ATZ
    "ata" // DMB
    "atacama" // CPO
    "atalaya" // AYX
    "atambua" // ABU
    "ataq" // AXK
    "atar" // ATR
    "ataturk" // ISL
    "atauro" // AUT
    "atbara" // ATB
    "atbasar" // ATX
    "atg" // AYX
    "ati" // ATV
    "atikokan" // YIB
    "atka" // AKB
    "atkamba" // ABP
    "atkinson" // PTS
    "atlanta" // ATL
    "atlantique" // NTE
    "atmautluak" // ATT
    "atoifi" // ATD
    "atqasuk" // ATK
    "atrouss" // AEO
    "atsinanana" // ILK
    "attapeu" // AOU
    "attawapiskat" // YAT
    "attopeu" // AOU
    "atty" // LNU
    "atung" // PXA
    "atuona" // AUQ
    "atyrau" // GUW
    "aua" // AUI
    "auckland" // AKL
    "aue" // UAE
    "auguste" // NGD
    "augustin" // YIF
    "auki" // AKS
    "aulie" // DMB
    "aumo" // AUV
    "aupaluk" // YPJ
    "aur" // AUL
    "aurangabad" // IXU
    "aurel" // BBU
    "aurillac" // AUR
    "aurukun" // AUU
    "australian" // CBR
    "auvergne" // CFE
    "auxerre" // AUF
    "avalon" // AVV
    "avaratra" // WMR
    "avare" // QVP
    "avenger" // SWW
    "avent" // BTN
    "aveyron" // RDZ
    "aviador" // CPC
    "avignon" // AVN
    "awaba" // AWB
    "awang" // CBO
    "awar" // AWR
    "awasa" // AWA
    "axamo" // JKG
    "axum" // AXU
    "ayacucho" // AYP
    "ayapel" // AYA
    "ayawasi" // AYW
    "ayers" // AYQ
    "aymm" // MIS
    "ayolas" // AYO
    "ayub" // ENO
    "azahar" // CDT
    "azam" // KHI
    "azezo" // GDQ
    "azikiwe" // ABV
    "azlan" // IPH
    "azul" // ZUL
    "azur" // NCE
    "babanakira" // MBU
    "babasaheb" // NAG
    "babimost" // IEG
    "babo" // BXB
    "babullah" // TTE
    "babushara" // SUI
    "bacacheri" // BFH
    "bacau" // BCM
    "bacha" // PEW
    "bachigualato" // CUL
    "baco" // BCO
    "bacolod" // BCD
    "badajoz" // BJZ
    "badanjilin" // RHT
    "badaruddin" // PLM
    "bade" // BXD
    "baden" // FKB
    "badu" // BDD
    "bafoussam" // BFX
    "bagan" // NYU
    "bagasbas" // DTE
    "bagdad" // BGT
    "bagdogra" // IXB
    "bage" // BGX
    "baghdad" // BGW
    "baghdogra" // IXB
    "baglung" // BGL
    "bagotville" // YBG
    "bagre" // EBG
    "baguio" // BAG
    "baha" // ABT
    "bahadur" // VNS
    "bahama" // FPO
    "bahawalpur" // BHV
    "bahias" // HUX
    "bahir" // BJR
    "bahrain" // BAH
    "baibara" // BAP
    "baicheng" // DBC
    "baidoa" // BIB
    "baikal" // UUD
    "bailian" // LZH
    "baillif" // BBR
    "baimuru" // VMU
    "bain" // MAY
    "baindoung" // BDZ
    "bains" // CMF
    "bairnsdale" // BSJ
    "baise" // AEB
    "baita" // HET
    "baitadi" // BIT
    "baiyun" // CAN
    "bajawa" // BJW
    "bajhang" // BJH
    "bajio" // BJX
    "bajpe" // IXE
    "bajura" // BJU
    "bakalalan" // BKM
    "bakel" // BXE
    "bakkafjorður" // BJD
    "bakouma" // BMF
    "baku" // GYD
    "bakula" // IXL
    "balakovo" // BWO
    "balalae" // BAS
    "balaton" // SOB
    "bale" // EAP
    "baleine" // ZTB
    "baler" // BQA
    "balgo" // BQW
    "balice" // KRK
    "balimo" // OPU
    "balkhash" // BXH
    "ballera" // BBL
    "ballesteros" // SDR
    "ballina" // BNK
    "ballon" // AQP
    "balmaceda" // BBA
    "balranald" // BZD
    "balsas" // BSS
    "balti" // BZY
    "baltimore" // BWI
    "balurghat" // RGH
    "balıkesir" // EDO
    "bam" // BXR
    "bama" // AEB
    "bamako" // BKO
    "bambari" // BBY
    "bamburi" // BMQ
    "bamda" // BPX
    "bamenda" // BPC
    "bamfield" // YBF
    "bamiyan" // BIN
    "bamu" // BMZ
    "bamyan" // BIN
    "ban" // HOE
    "banak" // LKL
    "bancasi" // BXU
    "banco" // ELB
    "band" // SBF
    "bandanaira" // NDA
    "bandara" // PUM
    "bandaranaike" // CMB
    "bandeirinhas" // QDF
    "bandon" // BDY
    "bandundu" // FDU
    "bandung" // KJT
    "baneasa" // BBU
    "banff" // YBA
    "banfora" // BNR
    "banga" // LBP
    "bangalore" // BLR
    "bangassou" // BGU
    "bangda" // BPX
    "bangoka" // FKI
    "bangor" // BGR
    "bangoy" // DVO
    "bangui" // BGF
    "bani" // XSB
    "banja" // BNX
    "banjul" // BJL
    "bank" // CTB
    "bankstown" // BWU
    "banmaw" // BMO
    "banning" // BNG
    "bannu" // BNP
    "banos" // LSN
    "bantilan" // TLI
    "bantry" // BYT
    "banz" // BNZ
    "banza" // SSY
    "baogede" // XRQ
    "baoshan" // BSD
    "baotou" // BAV
    "bapi" // BPD
    "barajas" // MAD
    "baralande" // BKJ
    "baramita" // BMJ
    "barapani" // SHL
    "baratayevka" // ULV
    "barber" // YVC
    "barberey" // QYR
    "barbuda" // BBQ
    "barcaldine" // BCI
    "barcelona" // BCN
    "barcelos" // BAZ
    "barco" // LCR
    "bardera" // BSY
    "bardufoss" // BDU
    "bareilly" // BEK
    "bariloche" // BRC
    "barimunya" // BYP
    "baringo" // LBN
    "bario" // BBN
    "barisal" // BZL
    "barkley" // PAH
    "barnaul" // BAX
    "barnes" // BAF
    "barnstable" // HYA
    "barnwell" // BNL
    "barrancabermeja" // EJA
    "barranco" // NBB
    "barranquilla" // BAQ
    "barreiras" // BRA
    "barreirinhas" // BRB
    "barretos" // BAT
    "barrie" // YLK
    "barril" // EPS
    "barriles" // TOQ
    "barrios" // PBR
    "barron" // DBN
    "barstow" // DAG
    "barter" // BTI
    "barth" // BBH
    "barthelemy" // SBH
    "bartica" // GFO
    "bartlesville" // BVO
    "bartolome" // MDQ
    "bartolomeu" // CAW
    "baruun" // UUN
    "barvo" // LRI
    "barysiai" // HLJ
    "basango" // KRZ
    "basankusu" // BSU
    "basco" // BSO
    "basel" // EAP
    "basongo" // BAN
    "basque" // BIQ
    "basra" // BSR
    "basse" // BBR
    "bassel" // LTK
    "bassillac" // PGX
    "bastia" // BIA
    "bata" // BSG
    "batagay" // BQJ
    "batang" // YUS
    "batangafo" // BTG
    "batavia" // BVW
    "batee" // KJX
    "bateen" // AZI
    "batesville" // BVX
    "bathinda" // BUP
    "bathpalathang" // BUT
    "bati" // TJB
    "batin" // KMC
    "batlayeri" // SXK
    "batna" // BLJ
    "batom" // BXM
    "baton" // BTR
    "batsfjord" // BJF
    "battambang" // BBM
    "batten" // RAC
    "battleford" // YQW
    "battouta" // TNG
    "batu" // BTW
    "batumi" // BUS
    "batuna" // BPF
    "batyaleri" // SXK
    "bau" // SBG
    "baubau" // BUW
    "baucau" // BCH
    "bauchi" // BCU
    "baudette" // BDE
    "bauer" // AOP
    "bauerfield" // VLI
    "baures" // BVL
    "baver" // AOP
    "bawan" // BWJ
    "bawean" // BXW
    "baxter" // WMH
    "bayadh" // EBH
    "bayanhot" // AXF
    "bayankhongor" // BYN
    "bayannur" // RLK
    "bayda" // BYD
    "bayonne" // BIQ
    "baytown" // HPY
    "bazar" // CXB
    "bazaruto" // BZB
    "bazhong" // BZX
    "beaches" // ECP
    "bearskin" // XBE
    "beatrix" // AUA
    "beatty" // BTY
    "beaufort" // BFT
    "beaumont" // BMT
    "beauregard" // DRI
    "beauvais" // BVA
    "beckley" // SGH
    "bedford" // EWB
    "bedourie" // BEU
    "beech" // BEC
    "beef" // EIS
    "beetz" // YBJ
    "begishevo" // NBC
    "begumpet" // BPM
    "behar" // COH
    "beheshti" // IFN
    "beica" // BEI
    "beida" // OGX
    "beidaihe" // BPE
    "beigan" // MFK
    "beihai" // BHY
    "beihan" // BHN
    "beijiao" // LYA
    "beira" // BEW
    "beirut" // BEY
    "beja" // BYJ
    "bejaia" // BJA
    "bel" // BFW
    "bela" // BCR
    "belaga" // BLG
    "belaya" // BGN
    "belbek" // UKS
    "beldringe" // ODE
    "belep" // BMY
    "belgaum" // IXG
    "belgorod" // EGO
    "belgrade" // BEG
    "belkacem" // HME
    "belkebir" // AZR
    "bellary" // BEP
    "belle" // BYL
    "bellegarde" // LIG
    "belleville" // RPB
    "bellevue" // GRB
    "bellinger" // HCW
    "bellona" // BNY
    "belluno" // BLX
    "belmont" // BEO
    "belmullet" // BLY
    "beloyarsk" // EYK
    "belp" // BRN
    "beltrao" // FBE
    "beluga" // BVU
    "bemidji" // BJI
    "benalla" // BLN
    "benbecula" // BEB
    "bender" // BSA
    "bendigo" // BXG
    "bengaluru" // BLR
    "bengbu" // BFU
    "benguela" // BUG
    "benguera" // BCW
    "beni" // BEM
    "benin" // BNI
    "benina" // BEN
    "benitez" // SCL
    "benjina" // BJK
    "bennett" // GFL
    "bennettsville" // BTN
    "benniu" // CZX
    "bensbach" // BSP
    "benson" // BBB
    "bentley" // MVP
    "benton" // BZF
    "bentonville" // VBT
    "bentota" // BJT
    "benzaquen" // YMS
    "berau" // BEJ
    "berbera" // BBO
    "berberati" // BBT
    "berdyansk" // ERD
    "bere" // ABU
    "bereina" // BEA
    "berens" // YBV
    "bergamo" // BGY
    "berge" // WPB
    "bergen" // BGO
    "bergerac" // EGC
    "bergman" // ALS
    "bergstrom" // AUS
    "berhampur" // BMP
    "berim" // OTC
    "beringin" // GXA
    "berisso" // MVD
    "berlevag" // BVG
    "bermejo" // BJO
    "bermudez" // CUP
    "bern" // BRN
    "bernardina" // DZO
    "bernardino" // SBD
    "bernardo" // YAI
    "berrio" // PBE
    "bert" // BTM
    "berta" // URG
    "bertoua" // BTA
    "beru" // BEZ
    "besalampy" // BPY
    "beslan" // OGZ
    "bessing" // LNU
    "best" // BHD
    "betancourt" // APO
    "betancur" // IGO
    "bethel" // BET
    "bethlehem" // ABE
    "betoambari" // BUW
    "betou" // BTB
    "betsworth" // ALO
    "bettles" // BTT
    "beverley" // BVZ
    "bewani" // BWP
    "bey" // TMR
    "beziers" // BZR
    "bhadrapur" // BDP
    "bhamo" // BMO
    "bharatpur" // BHR
    "bhatinda" // BUP
    "bhavnagar" // BHU
    "bhn" // EAB
    "bhoj" // BHO
    "bhojpur" // BHP
    "bhopal" // BHO
    "bhubaneshwar" // BBI
    "bhubaneswar" // BBI
    "bhuj" // BHJ
    "bhuntar" // KUU
    "bia" // BSR
    "bial" // BLR
    "bialla" // BAA
    "bianco" // SMB
    "biangabip" // BPK
    "biard" // PIS
    "biarritz" // BIQ
    "biaru" // BRP
    "biała" // BXP
    "białystok" // QYY
    "biche" // YLB
    "bie" // SVP
    "bien" // DIN
    "biggin" // BQH
    "bight" // TBI
    "bihoue" // LRT
    "bijie" // BFJ
    "biju" // BBI
    "bikaner" // BKB
    "bikini" // BII
    "bilaspur" // PAB
    "bilbao" // BIO
    "bildudalur" // BIU
    "biliau" // BIJ
    "billard" // TOP
    "billings" // BIL
    "billund" // BLL
    "biloxi" // GPT
    "bima" // BMU
    "bimini" // BIM
    "binaka" // GNS
    "binghamton" // BGM
    "bingol" // BGG
    "binhai" // TSN
    "bintulu" // BTU
    "birao" // IRO
    "biratnagar" // BIR
    "birch" // KBC
    "bird" // LBF
    "birdsville" // BVI
    "birgi" // TPS
    "birjand" // XBJ
    "birsa" // IXR
    "bisha" // BHH
    "bisho" // BIY
    "biskra" // BSK
    "bislig" // BPH
    "bismarck" // BIS
    "bissalanca" // OXB
    "bissau" // OXB
    "bitam" // BMM
    "bitat" // AAE
    "blackall" // BKQ
    "blackbushe" // BBS
    "blacker" // MBL
    "blackpool" // BLK
    "blacksburg" // ROA
    "blackwater" // BLT
    "blackwell" // BWL
    "blagnac" // TLS
    "blaise" // DSS
    "blanca" // RUI
    "blancas" // COR
    "blanco" // REX
    "blanding" // BDG
    "blangpidie" // KJX
    "blankensee" // LBC
    "blas" // CTE
    "blida" // QLD
    "blimbingsari" // BWX
    "block" // BID
    "blodgett" // HTL
    "bloedel" // YPB
    "bloemfontein" // BFN
    "blonduos" // BLO
    "bloodvein" // YDV
    "bloomington" // BMI
    "bloominton" // BMI
    "blosser" // CNK
    "bluefields" // BEF
    "bluethenthal" // ILM
    "bluff" // RBL
    "bluffs" // CBF
    "blumenau" // BNU
    "blythe" // BLH
    "blytheville" // HKA
    "boang" // BOV
    "boardman" // HYA
    "boavista" // BVC
    "bobby" // HBG
    "bobo" // BOY
    "boca" // BCT
    "bocas" // BOC
    "bodaybo" // ODO
    "bodden" // LYB
    "bodo" // BOO
    "bodø" // BOO
    "boeing" // BFI
    "boende" // BNB
    "bogande" // XBG
    "bogashevo" // TOF
    "bogorodskoye" // BQG
    "bogota" // BOG
    "bogue" // BGH
    "bohol" // TAG
    "boigny" // ABJ
    "boigu" // GIC
    "boire" // ASH
    "boise" // BOI
    "bojnord" // BJB
    "boke" // BKJ
    "boki" // MKI
    "bokondini" // BUI
    "bokoro" // BKR
    "bokpyin" // VBP
    "boku" // BOQ
    "bolaang" // BJG
    "bolanos" // SYQ
    "bolgesel" // KZR
    "bolivia" // SJV
    "bolkovce" // LUE
    "bologna" // BLQ
    "bolovip" // BVP
    "bolshoye" // PEE
    "bolson" // EHL
    "bolton" // TZR
    "bolzano" // BZO
    "boma" // BOA
    "bomai" // BMH
    "bomar" // SYI
    "bombay" // BOM
    "bonaire" // BON
    "bonaparte" // AJA
    "bonaventure" // YVB
    "bong" // SUW
    "bongo" // MVB
    "bongor" // OGR
    "bonilla" // CLO
    "bonito" // BYO
    "bonn" // CGN
    "bonnechere" // YXI
    "bonnyville" // YBY
    "bonriki" // TRW
    "bontang" // BXT
    "booker" // HYC
    "boolgeeda" // OCM
    "boorama" // BXX
    "booue" // BGB
    "bora" // BOB
    "borabora" // BOB
    "boraldai" // BXJ
    "boram" // WWK
    "bordeaux" // BOD
    "bordj" // BMW
    "borg" // HBE
    "borges" // PDU
    "borgo" // BLQ
    "borja" // JBS
    "borlange" // BLE
    "bornholm" // RNN
    "borrego" // BXS
    "borroloola" // BOX
    "borsellino" // PMO
    "boryspil" // KBP
    "bosaso" // BSA
    "boscobel" // OCJ
    "boscomantico" // QBS
    "bose" // CCU
    "bossangoa" // BSN
    "bosset" // BOT
    "bost" // BST
    "boswell" // BSW
    "botha" // GRJ
    "botopasi" // BTO
    "botopassi" // BTO
    "bou" // TID
    "bouaghi" // QMH
    "bouake" // BYK
    "bouar" // BOP
    "bouarfa" // UAR
    "bouca" // BCF
    "boudghene" // CBH
    "boudiaf" // CZL
    "bouet" // ABJ
    "boulaid" // BLJ
    "boulia" // BQL
    "boulsa" // XBO
    "boumediene" // ALG
    "boundary" // YDT
    "boundiali" // BXI
    "boundji" // BOE
    "bourget" // LBG
    "bourgogne" // DIJ
    "bourguiba" // MIR
    "bourke" // BRK
    "bournemouth" // BOH
    "bousso" // OUT
    "boussouf" // TID
    "boutheon" // EBU
    "boutilimit" // OTL
    "bovanenkovo" // BVJ
    "bow" // BBW
    "bowen" // ZBO
    "bowerman" // HQM
    "bowers" // ELN
    "bowling" // BWG
    "bowman" // LOU
    "boyington" // COE
    "bozeman" // BZN
    "bozoum" // BOZ
    "brac" // BWK
    "brackett" // POC
    "bradley" // BDL
    "bradshaw" // SKB
    "braga" // BGZ
    "brainard" // HFD
    "brainerd" // BRD
    "bram" // BFN
    "branch" // OLV
    "branches" // AUF
    "brandenburg" // BER
    "brandon" // YBR
    "brandt" // BER
    "brandywine" // OQN
    "brangbiji" // SWQ
    "brasilia" // BSB
    "bratislava" // BTS
    "bratsk" // BTK
    "braunschweig" // BWE
    "brava" // GRO
    "brawley" // BWC
    "bray" // BYF
    "brazil" // SRA
    "brazzaville" // BZV
    "breas" // TTC
    "brega" // LMQ
    "breiðdalsvik" // BXV
    "bremen" // BRE
    "bremerton" // PWT
    "brescia" // VBS
    "bretagne" // BES
    "brevig" // KTS
    "brewarrina" // BWQ
    "bria" // BIV
    "briceno" // VLV
    "bridgeport" // XBP
    "brie" // ANG
    "brieuc" // SBK
    "brigadeiro" // VAG
    "brigham" // BMC
    "brighton" // ESH
    "brindisi" // BDS
    "bringeland" // FDE
    "briscoe" // LZU
    "brittany" // LRT
    "britton" // TTO
    "brive" // BVE
    "brno" // BRQ
    "broadus" // BDX
    "brockville" // XBR
    "bromma" // BMA
    "bron" // LYN
    "bronnoy" // BNN
    "bronnoysund" // BNN
    "brookhaven" // WSH
    "brooks" // BPT
    "broome" // BME
    "brothers" // MGY
    "brownsville" // BRO
    "brownwood" // BWD
    "bruce" // DXE
    "bruges" // OST
    "brunei" // BWN
    "brus" // BHG
    "brussel" // BRU
    "bryan" // STF
    "bryansk" // BZK
    "bryce" // BCE
    "brønnøy" // BNN
    "brønnøysund" // BNN
    "bsl" // EAP
    "bsm" // AUS
    "bubaque" // BQE
    "bubung" // LUW
    "bucaramanga" // BGA
    "buckanan" // UCN
    "buckeye" // BXK
    "buckland" // BKC
    "budapest" // BUD
    "buddha" // BWA
    "buelna" // MZT
    "bueno" // PBQ
    "bugulma" // UUA
    "bujumbura" // BJM
    "buka" // BUA
    "bukhara" // BHK
    "bukoba" // BKZ
    "bulent" // IGD
    "buli" // PGQ
    "bullfrog" // BFG
    "bullhead" // IFP
    "bulloch" // TBR
    "bulolo" // BUL
    "buluh" // TJQ
    "bumba" // BMB
    "bunbury" // BUY
    "bundaberg" // BDB
    "bungo" // BUU
    "bungsu" // PXA
    "bunia" // BUX
    "bunsil" // BXZ
    "buochs" // BXO
    "buol" // UDL
    "buon" // BMV
    "buraimi" // RMB
    "burao" // BUO
    "burbank" // BUR
    "burevestnik" // BVV
    "burgas" // BOJ
    "burgos" // RGS
    "buri" // BFV
    "buriram" // BFV
    "burke" // BKL
    "burketown" // BUC
    "burley" // BYI
    "burlington" // BTV
    "burnell" // ATK
    "burnie" // BWT
    "burwash" // YDB
    "bushehr" // BUZ
    "business" // ELK
    "busselton" // BQB
    "busto" // MXP
    "buta" // BZU
    "butare" // BTQ
    "butaritari" // BBG
    "buthelezi" // ULD
    "butmir" // SJJ
    "butte" // GUC
    "buttonville" // YKZ
    "butuan" // BXU
    "buzios" // BZC
    "bydgoszcz" // BZG
    "byron" // BNK
    "caballero" // PJC
    "caballococha" // LHC
    "cabe" // PCB
    "cabezas" // PUZ
    "cabinda" // CAB
    "cable" // CCB
    "cabos" // SJD
    "cabrera" // GER
    "cacador" // CFC
    "cachoeira" // SJL
    "cachoeiro" // CDI
    "cacique" // PYH
    "cacoal" // OAL
    "cadjehoun" // COO
    "caen" // CFR
    "caerdydd" // CWL
    "cafunfo" // CFF
    "cagliari" // CAG
    "caguan" // SVI
    "caicara" // CXA
    "cairns" // CNS
    "cajamarca" // CJA
    "cakung" // BCH
    "calabozo" // CLZ
    "calabria" // REG
    "calafate" // FTE
    "calais" // CQF
    "calbayog" // CYP
    "caldas" // CLV
    "calden" // KSF
    "caldwell" // RWV
    "caledonia" // LLX
    "calexico" // CXL
    "calgary" // YYC
    "calhoun" // TAL
    "cali" // CLO
    "calicut" // CCJ
    "callaway" // LGC
    "calloway" // CEY
    "caloundra" // CUD
    "calverton" // CTO
    "calvi" // CLY
    "cam" // CXR
    "cama" // ZKM
    "camargo" // SOX
    "camargue" // FNI
    "camaxilo" // CXM
    "cambria" // JST
    "camden" // CDU
    "camdenton" // OZS
    "camejo" // LSP
    "cameron" // YQW
    "camiguin" // CGM
    "camooweal" // CML
    "camp" // HFF
    "campbeltown" // CAL
    "campeche" // CPE
    "campina" // CPV
    "campoformido" // UDN
    "can" // VCA
    "cana" // PUJ
    "canadian" // YXC
    "canaima" // CAJ
    "canal" // ZOS
    "canales" // MAM
    "cananea" // CNA
    "canarana" // CQA
    "canaria" // LPA
    "canberra" // CBR
    "cancun" // CUN
    "candala" // CXN
    "candelaria" // BRC
    "canefield" // DCF
    "canela" // QCN
    "canga" // TBP
    "cangapara" // FLB
    "cangyuan" // CWJ
    "cannes" // CEQ
    "canouan" // CIW
    "cans" // BEL
    "cantu" // SYP
    "cantung" // TNS
    "canyonlands" // CNY
    "caojiabao" // XNN
    "capac" // JUL
    "capodichino" // NAP
    "capt" // NGD
    "capurgana" // CPB
    "carajas" // CKS
    "carano" // UIB
    "caransebes" // CSB
    "caraquez" // BHA
    "carauari" // CAF
    "caravaggio" // BGY
    "carcassonne" // CCF
    "cardenas" // LZC
    "cardiff" // CWL
    "caribbean" // PMV
    "caribe" // PMV
    "cariboo" // ZMH
    "caribou" // CAR
    "carle" // JAU
    "carlisle" // CAX
    "carmelita" // CMM
    "carmelo" // CIO
    "carmichael" // LAK
    "carnarvon" // CVQ
    "carnevalli" // MRD
    "carnot" // CRF
    "carora" // VCR
    "carp" // YRP
    "carpiquet" // CFR
    "carr" // SNY
    "carranza" // LOV
    "carrasco" // MVD
    "carreno" // PCR
    "carriel" // CCP
    "carrillo" // PLD
    "carsamba" // SZF
    "carson" // CSN
    "carta" // LUI
    "cartagena" // CTG
    "cartersville" // VPC
    "carthage" // TUN
    "carti" // CTE
    "cartier" // YOW
    "cartwright" // YRF
    "caruaru" // CAU
    "carupano" // CUP
    "caruru" // CUO
    "carvajal" // XMS
    "casale" // BDS
    "casanare" // HTZ
    "casas" // NCG
    "cascade" // CZK
    "cascais" // CAT
    "casco" // PRQ
    "case" // SFG
    "caselle" // TRN
    "caseros" // MCS
    "casiano" // GPI
    "casigua" // CUV
    "casimiro" // ARR
    "casino" // CSI
    "casparis" // ALE
    "casper" // CPR
    "cassidy" // CXI
    "castellanos" // FRS
    "castellet" // CTT
    "castello" // VDM
    "castellon" // CDT
    "castillo" // CYW
    "castres" // DCM
    "catalina" // AVX
    "cataloi" // TCE
    "catamarca" // CTC
    "catamayo" // LOH
    "catania" // CTA
    "cataratas" // IGR
    "catarina" // FNC
    "catarman" // CRM
    "category:shreveport" // SHV
    "category:yan" // ENY
    "catey" // AZS
    "catharines" // YCM
    "caticlan" // MPH
    "catriel" // CCT
    "cattaraugus" // OLE
    "catumbela" // CBT
    "cauayan" // CYZ
    "caucasia" // CAQ
    "caucaya" // LQM
    "caulker" // CUK
    "caumont" // AVN
    "cauquira" // CDD
    "cavern" // CNM
    "caverns" // PGS
    "caxias" // CXJ
    "cayana" // AAJ
    "caycuma" // ONQ
    "cayenne" // CAY
    "cayes" // CYA
    "cayo" // CCC
    "cazombo" // CAV
    "cca" // YWM
    "cch" // YHG
    "cebu" // CEB
    "cecil" // VQQ
    "cecilia" // WSE
    "cedar" // CDC
    "ceduna" // CED
    "ceiba" // LCE
    "celaque" // GAC
    "celaya" // CYW
    "celestino" // BSC
    "centennial" // APA
    "centrair" // NGO
    "century" // JCI
    "cephalonia" // EFL
    "ceres" // CRR
    "cerrillos" // ULC
    "cesaire" // FDF
    "cesareo" // MVD
    "cesaria" // VXE
    "cespedes" // BYM
    "cess" // GRC
    "cessna" // CEA
    "cessnock" // CES
    "ceuta" // JCU
    "cevennes" // FNI
    "cfs" // TZC
    "chabeuil" // VAF
    "chacalluta" // ARI
    "chacarita" // JAP
    "chachapoyas" // CHH
    "chachoan" // ATF
    "chadron" // CDR
    "chafei" // BAT
    "chaganhu" // YSQ
    "chaghcharan" // CCN
    "chain" // HBG
    "chaiten" // WCH
    "chakeri" // KNU
    "chalkyitsik" // CIK
    "challis" // CHL
    "chalon" // XCD
    "chalons" // XCR
    "chamberlain" // MSP
    "chambery" // CMF
    "champforgeuil" // XCD
    "champniers" // ANG
    "chan" // YKN
    "chanaral" // CNR
    "chandalar" // WCR
    "chandra" // CCU
    "chang" // DBC
    "changbaishan" // NBS
    "changbei" // KHN
    "changchun" // CGQ
    "changde" // CGD
    "changhai" // CNI
    "changi" // SIN
    "changle" // FOC
    "changsha" // CSX
    "changshui" // KMG
    "changuinola" // CHX
    "changzhi" // CIH
    "changzhou" // CZX
    "chania" // CHQ
    "chanmyathazi" // VBC
    "chanute" // CNU
    "chaoshan" // SWA
    "chaoshui" // YNT
    "chaoyang" // CHG
    "chaoyangchuan" // YNJ
    "chapais" // YMT
    "chapeco" // XAP
    "chapel" // CYC
    "chapleau" // YLD
    "charan" // LKO
    "charata" // CNT
    "charco" // ECR
    "charleroi" // CRL
    "charleston" // CHS
    "charleville" // CTL
    "charlevoix" // YML
    "charlie" // FTY
    "charlo" // YCL
    "charlottesville" // CHO
    "charmeil" // VHY
    "charters" // CXT
    "chateauroux" // CHR
    "chattanooga" // CHA
    "chaudhary" // LKO
    "chaurjhari" // RUK
    "chaves" // CHV
    "chavez" // LIM
    "chd" // AZA
    "cheadle" // TIL
    "cheboksary" // CSY
    "cheddi" // GEO
    "chefornak" // CYF
    "chehalis" // CLS
    "chek" // HKG
    "chekif" // TID
    "cheli" // PKH
    "cheliff" // QAS
    "chelinda" // CEH
    "chelyabinsk" // CEK
    "chenega" // NCN
    "chengde" // CDE
    "chenggu" // HZG
    "chengjisihan" // NZL
    "chengzhou" // LNL
    "chennai" // MAA
    "cheongju" // CJJ
    "cheraw" // HCW
    "cherbourg" // CER
    "cherepovets" // CEE
    "cherkasy" // CKC
    "chernihiv" // CEJ
    "chernivtsi" // CWC
    "cherrabun" // CBC
    "cherry" // TVC
    "cherryland" // SUE
    "chersky" // CYX
    "chess" // FKL
    "chester" // CTH
    "chetumal" // CTM
    "chetwynd" // YCQ
    "chevak" // VAK
    "chevery" // YHR
    "cheyenne" // CYS
    "chhatrapati" // BOM
    "chhnang" // KZC
    "chiayi" // CYI
    "chibougamau" // YMT
    "chichen" // CZA
    "chichester" // QUG
    "chickasaw" // CHK
    "chickasha" // CHK
    "chicken" // CKX
    "chiclayo" // CIX
    "chicoutimi" // YRC
    "chien" // PCD
    "chifeng" // CIF
    "chigorodo" // IGO
    "chihuahua" // CUU
    "chilas" // CHB
    "childress" // CDS
    "chileka" // BLZ
    "chiles" // LSL
    "chilko" // CJH
    "chillagoe" // LLG
    "chilliwack" // YCW
    "chiloquin" // CHZ
    "chimbote" // CHM
    "chimbu" // CMU
    "chimoio" // VPY
    "chimore" // CCA
    "china" // SQT
    "chinchilla" // CCL
    "chinde" // INE
    "chinggis" // ULN
    "chingola" // CGJ
    "chingozi" // TET
    "chinguetti" // CGT
    "chinita" // MAR
    "chino" // CNO
    "chios" // JKH
    "chipata" // CIP
    "chipewyan" // YPY
    "chipinge" // CHJ
    "chiquimula" // CIQ
    "chiquitos" // SJS
    "chirino" // CZE
    "chisana" // CZN
    "chisasibi" // YKU
    "chisinau" // KIV
    "chitato" // PGI
    "chitose" // CTS
    "chitral" // CJL
    "chitre" // CTD
    "chizhou" // JUH
    "chlef" // QAS
    "chm" // MZA
    "choibalsan" // COQ
    "choiseul" // CHY
    "chokurdakh" // CKH
    "chokwe" // TGS
    "chongjin" // RGO
    "chongqing" // CKG
    "chopin" // WAW
    "chorrera" // LCR
    "chos" // HOS
    "chris" // YZR
    "christchurch" // CHC
    "christi" // CRP
    "christian" // ODE
    "christiansted" // SSB
    "chu" // VCL
    "chuathbaluk" // CHU
    "chub" // CCZ
    "chubu" // NGO
    "chulman" // NER
    "chumphon" // CJM
    "chungribu" // CVB
    "churchill" // ZUM
    "chutes" // YWQ
    "chuuk" // TKK
    "cia" // GGH
    "cial" // COK
    "ciampino" // CIA
    "cianorte" // GGH
    "cibao" // STI
    "cicia" // ICI
    "cildir" // CII
    "cilipi" // DBV
    "cimei" // CMJ
    "cimitarra" // CIM
    "cira" // BMI
    "ciriani" // TCQ
    "civic" // ALN
    "clara" // PAO
    "claras" // OCV
    "claremont" // CNH
    "claris" // GBZ
    "clarks" // CLP
    "clarksville" // CKV
    "claros" // MOC
    "cleve" // CVC
    "clever" // PHD
    "cliff" // CLR
    "clintonville" // CLI
    "cloncurry" // CNJ
    "clorinda" // CLX
    "clovis" // CVN
    "cluj" // CLJ
    "cmte" // BGX
    "coalinga" // CLG
    "coanda" // OTP
    "coari" // CIZ
    "coatepeque" // CTF
    "coatzacoalcos" // MTT
    "coban" // CBV
    "cobar" // CAZ
    "cobb" // RYY
    "cobo" // LET
    "cochamanidis" // SNG
    "cochin" // COK
    "cochise" // CWX
    "cochran" // TRM
    "cochstedt" // CSO
    "coco" // CCC
    "coconut" // CNC
    "cocos" // CCK
    "codela" // CSC
    "codigo" // HAY
    "codrington" // BBQ
    "coen" // CUQ
    "coet" // SBG
    "coeur" // COE
    "coff" // CFS
    "coffey" // UKL
    "coffeyville" // CFV
    "coffs" // CFS
    "coimbatore" // CJB
    "coimbra" // CBP
    "colby" // CBK
    "cold" // CDB
    "coldfoot" // CXF
    "coles" // MTO
    "colima" // CLQ
    "colina" // MDQ
    "collarenebri" // CRB
    "college" // CGS
    "collier" // TNT
    "colmar" // CMR
    "cologne" // CGN
    "coloma" // LCL
    "colonizadores" // RVE
    "colorada" // PCO
    "colville" // YCK
    "comalapa" // SAL
    "comanche" // MKN
    "comandatuba" // UNA
    "combolcha" // DSE
    "comeau" // YBC
    "comilla" // CLA
    "comiso" // CIY
    "comitan" // CJT
    "complex" // PNP
    "compton" // CPM
    "comte" // DLE
    "con" // VCS
    "conakry" // CKY
    "conceicao" // CDJ
    "conch" // MDS
    "condobolin" // CBX
    "condoto" // COG
    "confresa" // CFO
    "congonhas" // CGH
    "conklin" // CFM
    "conlara" // RLO
    "connaught" // NOC
    "connel" // OBN
    "connellan" // AYQ
    "connemara" // NNR
    "conquista" // VDC
    "conrad" // ONA
    "conselheiro" // QDF
    "consequences" // TCS
    "constable" // CNP
    "constanta" // CND
    "constantijn" // RTI
    "constanza" // COZ
    "contador" // PTX
    "contadora" // OTD
    "continent" // ICT
    "converse" // DGW
    "coober" // CPD
    "cooch" // COH
    "cooktown" // CTN
    "coola" // QBC
    "coolah" // CLH
    "coolangatta" // OOL
    "coolawanyah" // COY
    "cooma" // OOM
    "coonabarabran" // COJ
    "coonamble" // CNB
    "coondewanna" // CJF
    "cooperstown" // COP
    "cootamundra" // CMD
    "copalar" // CJT
    "copenhagen" // CPH
    "copernicus" // WRO
    "copper" // CZC
    "coral" // YZS
    "corazon" // CZJ
    "corbeta" // PDP
    "corbin" // LOZ
    "corda" // BDC
    "corfu" // CFU
    "corisco" // OCS
    "cork" // ORK
    "cormeilles" // POX
    "corn" // RNI
    "cornelio" // CKO
    "corners" // FMN
    "corning" // ELM
    "cornouaille" // UIP
    "coromandel" // CMV
    "coronation" // YCT
    "coronus" // MNY
    "corowa" // CWW
    "corpus" // CRP
    "correia" // OGL
    "corrientes" // CNQ
    "corryong" // CYG
    "corse" // FSC
    "cortez" // CEZ
    "cortissoz" // BAQ
    "cortland" // CTX
    "corumba" // CMG
    "coruna" // LCG
    "corvallis" // CVO
    "corvera" // RMU
    "corvo" // CVU
    "corzo" // TGZ
    "cosmoport" // TNE
    "costilla" // GDL
    "cotabato" // CBO
    "coto" // OTR
    "cotonou" // COO
    "cotopaxi" // LTX
    "cotulla" // COT
    "coulter" // CFD
    "courcelles" // XMF
    "courchevel" // CVF
    "courtenay" // YCA
    "covenas" // CVE
    "coventry" // CVT
    "cowell" // CCW
    "cowley" // YYM
    "cowra" // CWT
    "coyoles" // CYL
    "cozumel" // CZM
    "craiova" // CRA
    "cranbrook" // YXC
    "crawford" // RSV
    "crescencio" // MID
    "crested" // GUC
    "crews" // RTN
    "cristiano" // FNC
    "cristina" // IGN
    "cristobal" // SCY
    "cristoforo" // GOA
    "crkva" // BCR
    "crl" // CIO
    "croix" // SSB
    "croker" // CKI
    "crooked" // CKD
    "crookston" // CKN
    "crosse" // LSE
    "crossing" // FIZ
    "crotone" // CRV
    "crow" // YOC
    "croydon" // CDQ
    "cruces" // LRU
    "cruzeiro" // CZS
    "crystal" // MIC
    "csia" // BOM
    "cuamba" // FXO
    "cuanavale" // CTI
    "cuarto" // RCU
    "cuatia" // UZU
    "cubo" // CUV
    "cucuta" // CUC
    "cuddapah" // CDP
    "cue" // CUY
    "cuernavaca" // CVJ
    "cuito" // CTI
    "culberson" // VHN
    "culiacan" // CUL
    "cumaribo" // PCE
    "cumbica" // GRU
    "cumbre" // LCM
    "cuneo" // CUF
    "cunha" // SLZ
    "cunnamulla" // CMA
    "cupul" // TZM
    "curbelo" // PDP
    "current" // YYN
    "curuzu" // UZU
    "cusco" // CUZ
    "cushing" // CUH
    "cutral" // CUT
    "cuxhaven" // FCN
    "cuyahoga" // CGF
    "cuyo" // CYU
    "cvk" // CKK
    "cyangugu" // KME
    "cypb" // YPB
    "cyril" // STT
    "czestochowa" // CZW
    "cıldır" // CII
    "dabbah" // EDB
    "dabo" // SIQ
    "dabolim" // GOI
    "dabra" // DRH
    "dade" // TNT
    "dadu" // DDU
    "daegu" // TAE
    "daein" // ADV
    "daet" // DTE
    "dag" // KYS
    "dagali" // DLD
    "dagana" // RDT
    "daggett" // DAG
    "dahkla" // DAK
    "dahl" // DCK
    "daito" // MMD
    "dajtki" // QYO
    "dala" // BLE
    "dalaman" // DLM
    "dalanzadgad" // DLZ
    "dalatando" // NDF
    "dalbandin" // DBA
    "dalby" // DBY
    "dalhart" // DHT
    "dali" // DLU
    "dalles" // DLS
    "dalma" // ZDY
    "daloa" // DJO
    "dalton" // DNN
    "dama" // BVF
    "daman" // NMB
    "damascus" // DAM
    "danbury" // DXR
    "dandong" // DDG
    "dane" // MSN
    "dangriga" // DGA
    "dannelly" // MGM
    "dansville" // DSV
    "danville" // DAN
    "danylo" // LWO
    "dao" // VCS
    "daocheng" // DCY
    "daparijo" // DEP
    "daporijo" // DEP
    "daqing" // DQA
    "darchula" // DAP
    "dare" // MEO
    "dargaville" // DGR
    "darke" // VES
    "darnley" // NLF
    "daru" // DAU
    "darwaz" // DAZ
    "dasht" // SRY
    "dashuibo" // WEH
    "daskalogiannis" // CHQ
    "dasoguz" // TAZ
    "dass" // ATQ
    "dassault" // CHR
    "dastghaib" // SYZ
    "dastgheib" // SYZ
    "datadawai" // DTD
    "datong" // DAT
    "datu" // LDU
    "daugavpils" // DGP
    "daugherty" // LGB
    "dave" // KFE
    "davenport" // DVN
    "daviess" // OWB
    "dawadami" // DWD
    "dawadmi" // DWD
    "dawaser" // WAE
    "dawasir" // WAE
    "dawei" // TVY
    "daxing" // PKX
    "day" // SUX
    "dayak" // AJY
    "dayrestan" // GSM
    "daytona" // DAB
    "daza" // CUC
    "dazhou" // DAX
    "dazu" // DZU
    "dcs" // DSA
    "deadhorse" // SCC
    "deadman" // LGI
    "deadmans" // LGI
    "dean" // YRD
    "dease" // YDL
    "deauville" // DOL
    "debba" // EDB
    "debepare" // DBP
    "debrecen" // DEB
    "debremarcos" // DBM
    "decorah" // DEH
    "dedougou" // DGU
    "dedu" // DTU
    "deering" // DRG
    "defence" // NKM
    "defiance" // DFI
    "dehong" // LUM
    "dehradun" // DED
    "dei" // TRS
    "deia" // AOD
    "deir" // DEZ
    "dejazmach" // DIR
    "dekalb" // PDK
    "dele" // NDL
    "delhi" // DEL
    "deline" // YWJ
    "delingha" // HXD
    "deming" // DMN
    "demirag" // VAS
    "demirel" // ISE
    "deniliquin" // DNQ
    "denison" // DNS
    "denpasar" // DPS
    "denver" // DEN
    "deols" // CHR
    "deputado" // SSA
    "deputatsky" // DPT
    "deqen" // DIG
    "deqing" // DEQ
    "derik" // FGD
    "derry" // LDY
    "deseado" // PUD
    "desierto" // CPO
    "desirade" // DSD
    "desourdy" // ZBM
    "desroches" // DES
    "dessau" // ZSU
    "deurne" // ANR
    "devanahalli" // BLR
    "devi" // IDR
    "devil" // RDV
    "devils" // DVL
    "devonport" // DPO
    "dewadaru" // KWB
    "dewitt" // OLD
    "dezful" // DEF
    "dhaalu" // DDD
    "dhabi" // AUH
    "dhala" // DHL
    "dhanbad" // DBD
    "dhangadhi" // DHI
    "dharavandhoo" // DRV
    "dhien" // MEQ
    "diagne" // DSS
    "diagoras" // RHO
    "dial" // DEL
    "diamantino" // DMT
    "diapaga" // DIP
    "diavik" // DVK
    "diaz" // PVR
    "dibba" // BYB
    "dibrugarh" // DIB
    "diebougou" // XDE
    "diefenbaker" // YXE
    "dien" // DIN
    "digby" // YDG
    "dijon" // DIJ
    "dikson" // DKS
    "dillant" // EEN
    "dillingham" // DLG
    "dimapur" // DMU
    "dimbokro" // DIM
    "dimokritos" // AXD
    "dinangat" // DNU
    "dinard" // DNR
    "diomicio" // CCM
    "diori" // NIM
    "dioulasso" // BOY
    "dipolog" // DPL
    "diqing" // DIG
    "dirico" // DRC
    "dirranbandi" // DRN
    "disney" // DWS
    "divinopolis" // DIQ
    "divo" // DIV
    "diwopu" // URC
    "diyarbakir" // DIY
    "diyarbakır" // DIY
    "djalle" // ODJ
    "djambala" // DJM
    "djamena" // NDJ
    "djanet" // DJG
    "djerba" // DJE
    "djibo" // XDJ
    "djibouti" // JIB
    "djili" // FIH
    "djoemoe" // DOE
    "djomoe" // DOE
    "djougou" // DJA
    "djumu" // DOE
    "dnba" // BCU
    "dnipropetrovsk" // DNK
    "dobo" // DOB
    "dobodura" // PNP
    "doctor" // CNQ
    "dodoima" // DDM
    "dodoma" // DOD
    "dog" // RDB
    "doha" // DOH
    "doini" // DOI
    "dolbeau" // YDO
    "dole" // DLE
    "dolisie" // DIS
    "dolo" // NLO
    "dolpa" // DOP
    "dominicci" // SIG
    "domodedovo" // DME
    "doncaster" // DSA
    "donegal" // CFN
    "dong" // VDH
    "dongji" // FYJ
    "dongjiao" // JMU
    "dongola" // DOG
    "dongsha" // DSX
    "dongshan" // HLD
    "dongying" // DOY
    "donnelly" // YOE
    "donoi" // ULZ
    "donskoye" // TBW
    "doomadgee" // DMD
    "door" // SUE
    "dorchester" // CGE
    "dordogne" // EGC
    "dori" // DOR
    "doris" // JOJ
    "dornbirn" // HOH
    "dorobisoro" // DOO
    "dorset" // YTE
    "dortmund" // DTM
    "dorval" // YUL
    "dothan" // DHN
    "doti" // SIH
    "douala" // DLA
    "dourado" // MEU
    "dourados" // DOU
    "downer" // AIV
    "downing" // PIA
    "downsview" // YZD
    "doylestown" // DYL
    "dracena" // QDC
    "draham" // TBJ
    "draughon" // TPL
    "drayton" // YDC
    "dresden" // DRS
    "drietabbetje" // DRJ
    "drive" // BUR
    "drome" // POM
    "dryden" // YHD
    "dschang" // DSC
    "duarte" // AYP
    "dubbo" // DBO
    "dublin" // DUB
    "dubrovnik" // DBV
    "dubuque" // DBQ
    "dufort" // MAL
    "duke" // EGI
    "dulce" // LCF
    "dulles" // IAD
    "duluth" // DLH
    "dum" // CCU
    "dumaguete" // DGT
    "dumont" // SDU
    "dundee" // DND
    "dundo" // DUE
    "dunedin" // DUD
    "dunes" // UDD
    "dunhuang" // DNH
    "dunk" // DKI
    "dunkerque" // CQF
    "dunkirk" // DKK
    "dunsmuir" // MHS
    "dupage" // DPA
    "duqm" // DQM
    "durant" // DUA
    "durer”" // NUE
    "durgapur" // RDP
    "dushanbe" // DYU
    "dusseldorf" // DUS
    "dutchess" // POU
    "dutra" // PDR
    "duval" // RRG
    "dwanga" // DWA
    "dwangwa" // DWA
    "dwight" // ICT
    "dysart" // DYA
    "dzaoudzi" // DZA
    "eaker" // DUA
    "earlton" // YXR
    "easterwood" // CLL
    "eastmain" // ZEM
    "eaton" // OIC
    "ebadon" // EBN
    "ebolowa" // EBW
    "ebon" // EBO
    "eboue" // CAY
    "ech" // QAS
    "echo" // CYS
    "echuca" // ECH
    "eck" // PHW
    "ecuador" // GYE
    "eddie" // HAF
    "eddis" // BUJ
    "eden" // AXM
    "edgardo" // VDM
    "edinburgh" // EDI
    "edmond" // GOK
    "edmonton" // YEG
    "edmundo" // XMS
    "edremit" // EDO
    "edson" // YET
    "edvard" // MBX
    "edwards" // GUF
    "edwin" // BGM
    "eelde" // GRQ
    "efogi" // EFG
    "egal" // HGA
    "egegik" // EGX
    "egidio" // PEG
    "egilsstadir" // EGS
    "egilsstaðir" // EGS
    "eglinton" // LDY
    "eia" // YEG
    "eil" // HCM
    "eiland" // SMZ
    "ein" // EIY
    "einar" // FFM
    "eindhoven" // EIN
    "eirunepe" // ERN
    "eisenberg" // ODW
    "eisenhower" // ICT
    "ekati" // YOA
    "ekibastuz" // EKB
    "ekpo" // CBQ
    "ekwok" // KEK
    "elazig" // EZS
    "elazıg" // EZS
    "elblag" // ZBG
    "elche" // ALC
    "elcho" // ELC
    "elci" // NKT
    "eldoret" // EDL
    "eleftherios" // ATH
    "elena" // SNV
    "elenak" // EAL
    "elias" // PIO
    "elim" // ELI
    "eliptamin" // EPT
    "elisabethville" // FBM
    "elista" // ESL
    "eliye" // EYS
    "elizabethtown" // EKX
    "elkhart" // EKI
    "elkin" // ZEF
    "elko" // EKO
    "ellington" // EFD
    "elliot" // YEL
    "elliott" // YUL
    "ellis" // OAJ
    "ellison" // KOA
    "elmas" // CAG
    "elmira" // ELM
    "elorza" // EOZ
    "eloy" // MEC
    "elrose" // ERQ
    "elx" // ALC
    "ely" // LYU
    "elytis" // MJT
    "embakasi" // NBO
    "embrujo" // PVA
    "emerald" // EMD
    "emmonak" // EMK
    "emporia" // EMP
    "empress" // YEA
    "enarotali" // EWI
    "encarnacion" // ENO
    "eneabba" // ENB
    "enejit" // EJT
    "enewetak" // ENT
    "enfidha" // NBE
    "engati" // EGA
    "enid" // WDG
    "enniskillen" // ENK
    "enontekio" // ENF
    "enrico" // LIN
    "enriquez" // LOH
    "enschede" // ENS
    "enshi" // ENH
    "entebbe" // EBB
    "enterprise" // ETS
    "entrammes" // LVA
    "entzheim" // SXB
    "enua" // AIU
    "enyang" // BZX
    "enyu" // BII
    "ephrata" // EPH
    "epinal" // EPL
    "eppley" // OMA
    "epps" // AHN
    "eprown" // BDH
    "eqa" // EDK
    "erandique" // EDQ
    "erave" // ERE
    "erbil" // EBL
    "erbogachen" // ERG
    "ercan" // ECN
    "erechim" // ERM
    "erenhot" // ERL
    "erfurt" // ERF
    "erigavo" // ERA
    "erik" // YXY
    "erkilet" // ASR
    "erliban" // BAV
    "ernest" // PRC
    "eros" // ERS
    "errol" // ERR
    "ershi" // YIE
    "erume" // ERU
    "erzincan" // ERC
    "erzurum" // ERZ
    "esbjerg" // EBJ
    "escobedo" // MTY
    "escondido" // PXM
    "eseka" // MVR
    "esenboga" // ESB
    "esfahani" // KSH
    "eskilstuna" // EKT
    "eskisehir" // AOE
    "eslam" // NWA
    "esmeralda" // ECI
    "esperanza" // LEZ
    "espinosa" // MBT
    "espora" // BHI
    "esquel" // EQS
    "esquimalt" // YPF
    "essen" // ESS
    "essendon" // MEB
    "essey" // ENC
    "estero" // SDE
    "estevan" // YEN
    "estigarribia" // ESG
    "estrees" // XSJ
    "ethiopia" // NDM
    "etienne" // EBU
    "etjo" // MJO
    "etorofu" // ITU
    "eucla" // EUC
    "eugenio" // MAZ
    "eurico" // VIX
    "euroairport" // EAP
    "evans" // EVH
    "evansville" // EVV
    "evelio" // EUQ
    "evella" // LEL
    "evenes" // EVE
    "evensk" // SWV
    "everett" // UCY
    "evers" // JAN
    "evora" // VXE
    "ewer" // EWE
    "exeter" // EXT
    "exmouth" // EXM
    "express" // TOL
    "exuma" // GGT
    "exupery" // LYS
    "eyl" // HCM
    "eylandt" // GTE
    "eyyubi" // YKO
    "ezeiza" // EZE
    "faa" // PPT
    "faaa" // PPT
    "faaite" // FAC
    "fabio" // MVP
    "facility" // QQS
    "factory" // BEC
    "fada" // FNG
    "fagali" // FGI
    "fagernes" // VDB
    "fagurholsmyri" // FAG
    "fah" // CEI
    "fahd" // DMM
    "faiks" // OEM
    "fairbanks" // FAI
    "fairchild" // CLM
    "fairfield" // FFL
    "fairview" // ZFW
    "faisalabad" // LYP
    "faison" // LRO
    "faizabad" // FZD
    "fakahina" // FHZ
    "fakarava" // FAV
    "fakfak" // FKQ
    "falam" // SRU
    "falcon" // MSC
    "falconara" // AOI
    "falcone" // PMO
    "faleolo" // APW
    "falla" // SVI
    "fallon" // FLX
    "false" // KFP
    "falster" // MRW
    "famingo" // BON
    "fane" // FNE
    "fangatau" // FGU
    "farafangana" // RVA
    "farah" // FAH
    "faranah" // FAA
    "fare" // HUH
    "farfan" // ULQ
    "faria" // GPB
    "farsund" // FAN
    "fasa" // FAZ
    "fascene" // NOS
    "fasher" // ELF
    "fashir" // ELF
    "faskruðsfjorður" // FAS
    "fatmawati" // BKS
    "faustino" // UAQ
    "faya" // FYT
    "fayks" // OEM
    "fayzabad" // FBD
    "fderik" // FGD
    "february" // LAD
    "feijo" // FEJ
    "feixiong" // BFJ
    "felicien" // YDO
    "fellini" // RMI
    "felts" // SFF
    "fenghuang" // TEN
    "fengnin" // TTT
    "fenosu" // FNU
    "fera" // FRE
    "feramin" // FRQ
    "ferdinand" // SIX
    "ferenc" // BUD
    "fergana" // FEG
    "fergus" // FFM
    "ferhat" // GJL
    "ferihegy" // BUD
    "ferit" // VAN
    "ferkessedougou" // FEK
    "fernandes" // ICK
    "fernandini" // HUU
    "ferrand" // CFE
    "ferryfield" // LYX
    "fertilia" // AHO
    "fes" // FEZ
    "fevereiro" // LAD
    "feyzabad" // FBD
    "fgl" // GRX
    "fhar" // HRS
    "fianarantsoa" // WFI
    "ficksburg" // FCB
    "fierro" // CUU
    "figari" // FSC
    "figueroa" // HUU
    "filipe" // SFL
    "filippos" // KZI
    "fillmore" // FIL
    "filton" // FZO
    "fincha" // FNH
    "findel" // LUX
    "findlay" // FDY
    "fine" // AIZ
    "finsch" // LMR
    "finschhafen" // FIN
    "fiord" // YGZ
    "firebag" // YFI
    "firenze" // FLR
    "first" // FFA
    "fisabilillah" // TNJ
    "fischer" // BFN
    "fite" // HAB
    "fiti" // FTI
    "fitini" // OFI
    "fitiuta" // FTI
    "fitzroy" // FIZ
    "fiumicino" // FCO
    "flabob" // RIR
    "flagstaff" // FLG
    "flamingo" // BON
    "flecheras" // SFD
    "fleming" // OCJ
    "flesland" // BGO
    "fletcher" // CKM
    "fliegerhorst" // BRU
    "flin" // YFO
    "flinders" // FLS
    "flint" // FNT
    "flli" // LVI
    "flls" // LUN
    "flon" // YFO
    "floriano" // FLB
    "florianopolis" // FLN
    "florio" // TPS
    "floripa" // FLN
    "floro" // FRO
    "florø" // FRO
    "floyd" // GFL
    "flushing" // FLU
    "flybalaton" // SOB
    "flying" // FCM
    "flz" // SIX
    "fmmg" // WPB
    "foggia" // FOG
    "fogo" // SFL
    "foley" // FPY
    "fonseca" // STM
    "fontages" // YFG
    "fontaine" // YHF
    "fontanarossa" // CTA
    "fontanges" // YFG
    "fonte" // FBA
    "foothills" // MRN
    "fora" // JDF
    "forbes" // FRB
    "force" // NKM
    "forde" // FDE
    "forestville" // YFE
    "forge" // GKT
    "fork" // SPK
    "forlanini" // LIN
    "forli" // FRL
    "former" // CLE
    "formosa" // FMA
    "forney" // TBN
    "foronda" // VIT
    "forquilhinha" // CCM
    "forster" // FOT
    "fortaleza" // FOR
    "fortescue" // KFE
    "fortuna" // FON
    "foshan" // FUO
    "foss" // FSD
    "four" // FMN
    "fourchambault" // NVS
    "foya" // FOY
    "foz" // IGU
    "franca" // FRC
    "france" // FDF
    "frances" // YAG
    "francesco" // PEG
    "franche" // DLE
    "francis" // FOK
    "francistown" // FRW
    "francois" // SFC
    "frankivsk" // IFO
    "freddie" // LAK
    "fredericton" // YFC
    "freeland" // MBS
    "fregate" // FRK
    "freiburg" // EAP
    "freire" // ZCQ
    "freitas" // CCM
    "frejus" // FRJ
    "fremont" // FET
    "fresh" // ASD
    "freyre" // REC
    "friday" // FRD
    "frieda" // FAQ
    "friedman" // SUN
    "friedrichshafen" // FDH
    "friendship" // BWI
    "friuli" // TRS
    "front" // FRR
    "frontera" // XRY
    "frutillar" // FRT
    "fryeburg" // FRY
    "fryklanda" // TYF
    "fua" // TBU
    "fuaʻamotu" // TBU
    "fucheng" // BHY
    "fuentes" // WPR
    "fuerteventura" // FUE
    "fuhlsbuttel" // HAM
    "fujairah" // FJR
    "fukue" // FUJ
    "fukui" // FKJ
    "fukuoka" // FUK
    "fukushima" // FKS
    "fullerton" // FUL
    "fumian" // YLX
    "funadhoo" // FND
    "funafuti" // FUN
    "funchal" // FNC
    "funciona" // GGS
    "furnace" // DTH
    "fuster" // PJC
    "futaleufu" // FFU
    "futuna" // FTA
    "futuro" // LVR
    "fuvahmulah" // FVM
    "fuyang" // FUG
    "fuyuan" // FYJ
    "fuyun" // FYN
    "fuzhou" // FOC
    "fvrg" // HRE
    "fzsi" // MAT
    "førde" // FDE
    "gabbs" // GAB
    "gabes" // GAE
    "gaborone" // GBE
    "gabreski" // FOK
    "gabrielli" // MDZ
    "gachsaran" // GCH
    "gadsden" // GAD
    "gaetan" // RRG
    "gafsa" // GAF
    "gagarin" // GSV
    "gagarinsky" // GSV
    "gage" // GAG
    "gaggal" // DHM
    "gagnoa" // GGN
    "gakd" // KYS
    "galante" // GBJ
    "galbraith" // GBH
    "galcaio" // GLK
    "galeao" // GIG
    "galegu" // DNX
    "galela" // GLX
    "galesburg" // GBG
    "galilei" // PSA
    "galileo" // PSA
    "galion" // GQQ
    "gallardo" // PNT
    "gallen" // ACH
    "gallivare" // GEV
    "gallup" // GUP
    "galveston" // GLS
    "gamar" // GLX
    "gamarmalamu" // GLX
    "gamba" // GAX
    "gambela" // GMB
    "gambell" // GAM
    "gambella" // GMB
    "gambier" // MGB
    "gamboa" // WCA
    "gamboma" // GMM
    "gameti" // YRA
    "ganane" // LGX
    "gandajika" // GDJ
    "gander" // YQX
    "ganesh" // KNU
    "gangaw" // GAW
    "ganges" // YGG
    "gannan" // GXH
    "gansner" // GNF
    "gantgaw" // GAW
    "gao" // GAQ
    "gaoping" // NAO
    "gaoqi" // XMN
    "gaoua" // XGA
    "gaoundere" // NGE
    "garachine" // GHE
    "garaina" // GAR
    "garasa" // GRL
    "garbaharey" // GBM
    "garcas" // BPG
    "gardermoen" // OSL
    "gardner" // GDM
    "gardo" // GSR
    "garenne" // AGF
    "garfield" // RIL
    "gargarin" // MSZ
    "garissa" // GAS
    "garland" // YYB
    "garner" // UVA
    "garons" // FNI
    "garoua" // GOU
    "garowe" // GGR
    "garrett" // ODM
    "garros" // RUN
    "garuahi" // GRH
    "garze" // GZG
    "garzon" // VGZ
    "garzones" // MTR
    "gasa" // JHG
    "gascoyne" // GSC
    "gasmata" // GMI
    "gaspe" // YGP
    "gassim" // ELQ
    "gastao" // GGH
    "gasuke" // GBC
    "gatien" // DOL
    "gatineau" // YND
    "gatka" // GVN
    "gatlinburg" // GKT
    "gatokae" // GTA
    "gatot" // WYK
    "gatwick" // LGW
    "gaua" // ZGU
    "gaulle" // CDG
    "gautam" // BWA
    "gavan" // GVN
    "gaviota" // LGT
    "gaviotas" // LGT
    "gaviria" // PDA
    "gavle" // GVX
    "gaya" // GAY
    "gaylord" // GLR
    "gayndah" // GAH
    "gazan" // GIZ
    "gaziantep" // GZT
    "gazipasa" // GZP
    "gbadolite" // BDT
    "gbangbatok" // GBK
    "gbangbatoke" // GBK
    "gdansk" // GDN
    "gedaref" // GSU
    "geelong" // GEX
    "geilo" // DLD
    "geita" // GIT
    "geiteryggen" // SKE
    "gelabert" // PAC
    "gelendzhik" // GDZ
    "gelephu" // GLU
    "gemena" // GMA
    "geneina" // EGN
    "genoa" // GOA
    "genova" // GOA
    "genoveva" // GYN
    "gentil" // POG
    "geoirs" // GNB
    "gerald" // GRR
    "gerrard" // CYB
    "gesar" // GZG
    "gesell" // VLG
    "gethsemani" // ZGS
    "gettysburg" // GTY
    "gewayantana" // LKA
    "ghadames" // LTD
    "ghanzi" // GNZ
    "ghardaia" // GHA
    "ghat" // GHT
    "ghaydah" // AAY
    "ghazi" // DEA
    "ghazni" // GZI
    "ghazvin" // GZW
    "ghial" // HYD
    "ghinnir" // GNN
    "ghriss" // MUW
    "gia" // VKG
    "gibbs" // MYF
    "gibraltar" // GIB
    "gil" // ULQ
    "gilbert" // GIF
    "gilberto" // REC
    "gilgit" // GIL
    "gill" // PKB
    "gillam" // YGX
    "gillespie" // SEE
    "gillette" // GCC
    "gillies" // YGB
    "gillot" // RUN
    "gilmer" // GVL
    "gimenez" // PIL
    "gimhae" // PUS
    "gimli" // YGM
    "gimpo" // GMP
    "gino" // FOG
    "girardeau" // CGI
    "girardot" // GIR
    "girba" // GBU
    "girdwood" // AQY
    "giresun" // OGU
    "girona" // GRO
    "girua" // PNP
    "gisborne" // GIS
    "gisenyi" // GYI
    "gitega" // GID
    "giulia" // TRS
    "giva" // VPE
    "gjoa" // YHK
    "gjogur" // GJR
    "glades" // PHK
    "gladstone" // GLT
    "gladwin" // GDW
    "glass" // YPA
    "glaze" // BBW
    "glen" // GLI
    "glendale" // BUR
    "glenegedale" // ILY
    "glentanner" // MON
    "gloucestershire" // GLO
    "glynco" // BQK
    "gmoleon" // PPN
    "gnarowein" // GWN
    "gnoss" // NOT
    "goa" // GOI
    "gobabis" // GOG
    "gobind" // NDC
    "godang" // AEG
    "gode" // GDE
    "godofredo" // MPH
    "gogebic" // IWD
    "goiabeiras" // VIX
    "gokceada" // GKD
    "gokcen" // SAW
    "gol" // GLL
    "goldson" // BZE
    "golea" // ELG
    "goleniow" // SZZ
    "golfito" // GLF
    "golfo" // TLU
    "golmud" // GOQ
    "golog" // GMQ
    "goloson" // LCE
    "golovin" // GLV
    "goma" // GOM
    "gombe" // GMO
    "gomel" // GME
    "gomera" // GMZ
    "gomes" // MAO
    "gondar" // GDQ
    "gonggar" // LXA
    "gonzales" // CIX
    "gonzalo" // TRB
    "good" // YGH
    "goodland" // GLD
    "goodnews" // GNU
    "goodwin" // ELD
    "goodwood" // QUG
    "goodyear" // GYR
    "goondiwindi" // GOO
    "gorakhpur" // GOP
    "gore" // YZE
    "gorgan" // GBT
    "gorge" // DLS
    "gorkha" // GKH
    "gorna" // GOZ
    "gorno" // RGK
    "goroka" // GKA
    "gorom" // XGG
    "goshen" // GSH
    "gostomel" // GML
    "goulimime" // GLN
    "goundam" // GUD
    "gourma" // FNG
    "gove" // GOV
    "governors" // GHB
    "gowen" // BOI
    "gowon" // JOS
    "goya" // OYA
    "grabtsevo" // KLF
    "gracias" // GAC
    "graeme" // CKW
    "grafton" // GFN
    "grajales" // GAO
    "gran" // LPA
    "granada" // GRX
    "grandes" // NCG
    "grand’case" // SFG
    "granit" // LAI
    "granites" // GTS
    "grannis" // FAY
    "grantley" // BGI
    "grantsburg" // GTG
    "grass" // LEX
    "gratiot" // AMN
    "grayling" // KGX
    "graz" // GRZ
    "graziani" // ATA
    "greeley" // GXY
    "greenbrier" // LWB
    "greeneville" // GCY
    "greenlee" // CFT
    "greensboro" // XLL
    "greenstone" // YGQ
    "gregores" // GGS
    "gregorio" // POP
    "greif" // SPR
    "grenoble" // GNB
    "greymouth" // GMN
    "grider" // PBF
    "griffiss" // RME
    "griffith" // GFF
    "grimsey" // GRY
    "grise" // YGZ
    "groats" // WIC
    "groningen" // GRQ
    "groote" // GTE
    "grootfontein" // GFY
    "grosse" // ONZ
    "grosseto" // GRS
    "grottaglie" // TAR
    "ground" // LBG
    "grozny" // GRV
    "gruben" // YUB
    "grumeti" // GTZ
    "grumman" // CTO
    "grundarfjorður" // GUU
    "guadalajara" // GDL
    "guajara" // GJM
    "gualberto" // VRA
    "gualeguaychu" // GHU
    "guam" // GUM
    "guamal" // GAA
    "guanacaste" // NCT
    "guanaja" // GJA
    "guanajuato" // BJX
    "guanambi" // GNM
    "guanare" // GUQ
    "guangong" // YCU
    "guangyuan" // GYS
    "guangzhou" // CAN
    "guantanamo" // NBW
    "guanyin" // XUZ
    "guanzhishan" // LCX
    "guapi" // GPI
    "guapiles" // GPL
    "guarani" // AGT
    "guarapari" // GUZ
    "guarapuava" // GPB
    "guararapes" // REC
    "guarayos" // ASC
    "guardia" // SRJ
    "guardiamarina" // WPU
    "guari" // GUG
    "guarulhos" // GRU
    "guasdualito" // GDO
    "guasopa" // GAZ
    "guaviare" // SJE
    "guayana" // PZO
    "guayaramerin" // GYA
    "guaymas" // GYM
    "guelmim" // GLN
    "guemar" // ELU
    "guemes" // SLA
    "guernsey" // GCI
    "guevara" // AGV
    "guezzam" // INF
    "guggal" // DHM
    "guglielmo" // BLQ
    "guiglo" // GGO
    "guildford" // PER
    "guilin" // KWL
    "guipavas" // BES
    "guiria" // GUI
    "guitou" // HSC
    "guiyang" // KWE
    "gulbarga" // GBI
    "gulfport" // GPT
    "gulgubip" // GLP
    "gulian" // OHE
    "gulkana" // GKN
    "gulu" // ULU
    "gunnedah" // GUH
    "gunsa" // NGQ
    "gunsan" // KUV
    "gunson" // GSN
    "guoji" // XMN
    "gurayat" // URY
    "gurion" // TLV
    "gusap" // GAP
    "gustaf" // SBH
    "gustavus" // GST
    "gusti" // KBU
    "guthrie" // GOK
    "guymon" // GUY
    "guyuan" // GYU
    "guzman" // JUJ
    "gwadar" // GWD
    "gwalior" // GWL
    "gwangju" // KWJ
    "gwaunaru" // AKS
    "gwinnett" // LZU
    "gympie" // GYP
    "gyor" // QGY
    "gyumri" // LWN
    "habib" // MIR
    "hacaritama" // HAY
    "hachijojima" // HAC
    "hadfield" // YZR
    "hadinegoro" // JBB
    "hadjer" // OUM
    "haeju" // HAE
    "haelogo" // HEO
    "hafar" // KMC
    "hafr" // AQI
    "hagen" // HGU
    "hagerstown" // HGR
    "hagfors" // HFS
    "hague" // RTM
    "hahn" // HHN
    "haifa" // HFA
    "haikou" // HAK
    "hail" // HAS
    "hailang" // MDG
    "hailar" // HLD
    "haitien" // CAP
    "hakkari" // YKO
    "hakodate" // HKD
    "hal" // ISK
    "halali" // HAL
    "hale" // PVW
    "half" // HAF
    "halifax" // YHZ
    "haliwen" // ABU
    "halle" // LEJ
    "halliburton" // DUC
    "halls" // HCQ
    "halmstad" // HAD
    "haluoleo" // KDI
    "halytskyi" // LWO
    "hamad" // DOH
    "hamadan" // HDM
    "hamani" // NIM
    "hamburg" // HAM
    "hami" // HMI
    "hamid" // KBL
    "hammamet" // NBE
    "hammerfest" // HFT
    "hampton" // HTO
    "hana" // HNM
    "hanamaki" // HNA
    "handan" // HDG
    "haneda" // HND
    "hang" // BTH
    "hangzhou" // HGH
    "hani" // AJI
    "hanimaadhoo" // HAQ
    "hannover" // HAJ
    "hanscom" // BED
    "hansen" // YCF
    "hanzhong" // HZG
    "hao" // HOI
    "harakani" // KSY
    "harapan" // TJS
    "harar" // QHR
    "harare" // HRE
    "harbin" // HRB
    "harcourt" // PHC
    "hare" // ORD
    "hargeisa" // HGA
    "hariri" // BEY
    "harjedalen" // EVG
    "harrell" // CDH
    "harrisburg" // MDT
    "harrismith" // HRS
    "harrison" // ASL
    "harstad" // EVE
    "hart" // MGW
    "hartford" // HFD
    "hartley" // YTB
    "hartness" // VSF
    "hartsfield" // ATL
    "hartsville" // HVS
    "harvey" // RWL
    "hasanuddin" // UPG
    "hashemi" // MHD
    "hassan" // EUN
    "hasvik" // HAA
    "hatay" // HTY
    "hatcher" // PVL
    "hatchet" // YDJ
    "hateruma" // HTR
    "hatfield" // CLR
    "hatta" // CGK
    "hatzfeldthaven" // HAZ
    "hau" // WGP
    "haugesund" // HAU
    "haukasen" // SOG
    "haute" // NCY
    "havalimanı" // CII
    "havasu" // HII
    "havel" // PRG
    "haverfordwest" // HAW
    "havryshivka" // VIN
    "hawabango" // HWA
    "hawarden" // CEG
    "hawke" // NPE
    "hawker" // MBW
    "hawkesbury" // YPS
    "hawkins" // HKS
    "hayden" // KPT
    "hayfields" // HYF
    "hays" // HYS
    "hazleton" // HZL
    "hazrat" // DAC
    "healy" // HKB
    "hearst" // YHF
    "heathrow" // LHR
    "hechi" // HCJ
    "hedland" // PHE
    "hedong" // INC
    "hefei" // HFE
    "heho" // HEH
    "hehua" // DYG
    "heiden" // PTH
    "heihe" // HEK
    "heilbron" // ZNJ
    "heilig" // BFF
    "heiweni" // HNI
    "helens" // HLS
    "helipuerto" // JCU
    "helle" // SVJ
    "helsingfors" // HEL
    "helsinki" // HEL
    "hemet" // HMT
    "hendrik" // PHW
    "hengchun" // HCN
    "hengyang" // HNY
    "henk" // ICK
    "henri" // OTP
    "henrich" // TDD
    "henryk" // POZ
    "henson" // HGR
    "heraklion" // HER
    "heras" // LHS
    "herat" // HEA
    "herceg" // HNO
    "hercilio" // FLN
    "heres" // CBL
    "heringsdorf" // HDF
    "heritage" // PTW
    "herlong" // HEG
    "hermes" // RGA
    "hermiston" // HES
    "hermosillo" // HMO
    "hernandez" // BQN
    "herrera" // EOH
    "hervey" // HVB
    "heshi" // DAX
    "hesler" // LUL
    "hesperides" // STY
    "hetta" // ENF
    "heviz" // SOB
    "hewanorra" // UVF
    "heydar" // GYD
    "hial" // HYD
    "hickory" // HKY
    "hidalgo" // GDL
    "hidroeletrica" // ITR
    "hierro" // VDE
    "higgins" // YAI
    "highlands" // VJI
    "higueras" // RCU
    "higuerote" // HGE
    "hihifo" // WLS
    "hikueru" // HHZ
    "hillview" // RHV
    "hilo" // ITO
    "hin" // HHQ
    "hinckley" // OGD
    "hingurakgoda" // HIM
    "hinton" // YJP
    "hippocrates" // KGS
    "hisar" // HSS
    "hissar" // HSS
    "hiva" // NHV
    "hivaoa" // AUQ
    "hivaro" // HIT
    "hkamti" // KHM
    "hkia" // HKG
    "hle" // NLT
    "hluhluwe" // HLW
    "hoa" // TBB
    "hobby" // HOU
    "hodeida" // HOD
    "hoga" // KRF
    "hogan" // HAO
    "hohenems" // HOH
    "hohhot" // HET
    "hoi" // VDH
    "hokitika" // HKK
    "hola" // HOA
    "holbrook" // HBK
    "hole" // JAC
    "holingol" // HUO
    "holkar" // IDR
    "hollister" // HLI
    "holmavik" // HVK
    "holy" // HCR
    "homel" // GME
    "honduras" // LMH
    "hongqiao" // SHA
    "hongyuan" // AHJ
    "honiara" // HIR
    "honinabi" // HNN
    "honningsvag" // HVG
    "honolulu" // HNL
    "honore" // YRC
    "hook" // MWO
    "hooker" // HOK
    "hooks" // DWH
    "hoonah" // HNH
    "hoop" // ORG
    "hooper" // HPB
    "hopedale" // YHO
    "hopetoun" // HTU
    "hopital" // OMB
    "horizon" // HZP
    "horizonte" // PLU
    "horizontina" // HRZ
    "horn" // HID
    "hornafjordur" // HFN
    "hornafjorður" // HFN
    "hornepayne" // YHN
    "horo" // DSN
    "horqin" // AEQ
    "horsham" // HSM
    "horta" // HOR
    "hosea" // WDH
    "hoskins" // HKN
    "hospital" // OMB
    "hostos" // MAZ
    "hotan" // HTN
    "hotham" // MHU
    "hott" // ZOS
    "houari" // ALG
    "houeisay" // HOE
    "houghton" // CMX
    "hougton" // CMX
    "houlton" // HUL
    "houma" // HUM
    "houphouet" // ABJ
    "houssen" // CMR
    "hovby" // LDK
    "hovden" // HOV
    "howe" // LDH
    "hoybuktmoen" // KKN
    "hpa" // PAA
    "hrodna" // GNA
    "hsat" // MOG
    "hsnl" // UYL
    "hua" // HHQ
    "huacaraje" // BVK
    "huahine" // HUH
    "huai" // HIA
    "huaihua" // HJJ
    "hualien" // HUN
    "huambo" // NOV
    "huangguoshu" // AVA
    "huanghua" // CSX
    "huangjin" // KOW
    "huanglong" // JZH
    "huangping" // KJH
    "huangshan" // TXN
    "huanuco" // HUU
    "huaraz" // ATA
    "huatugou" // HTT
    "huatulco" // HUX
    "huayuan" // SHF
    "hubert" // YHU
    "hubli" // HBX
    "hudiksvall" // HUV
    "huehuetenango" // HUG
    "huesca" // HSK
    "hugh" // EOS
    "hughenden" // HGD
    "hughes" // HUS
    "huizhou" // HUZ
    "huka" // UAH
    "hukuntsi" // HUK
    "hulhule" // MLE
    "hultsfred" // HLF
    "hulunbuir" // HLD
    "humacao" // HUC
    "humaita" // HUW
    "humberside" // HUY
    "humberto" // LIS
    "humboldt" // HUD
    "humera" // HUE
    "hun" // HUQ
    "hunt" // LND
    "hunter" // MLL
    "huntingburg" // HNB
    "huoeisay" // HOE
    "huolinhe" // HUO
    "hurghada" // HRG
    "huron" // HON
    "huronia" // YEE
    "husavik" // HZK
    "husband" // AMA
    "husein" // BDO
    "hussein" // AQJ
    "hwm" // KWM
    "hyeres" // TLN
    "høybuktmoen" // KKN
    "iamalele" // IMA
    "ian" // OCJ
    "iasi" // IAS
    "iata" // HAY
    "ibadan" // IBA
    "ibague" // IBE
    "ibanez" // PUQ
    "ibarra" // MRR
    "iberia" // IBP
    "iberico" // PIU
    "ibiam" // ENU
    "ibiza" // IBZ
    "ibn" // TNG
    "iboki" // IBI
    "ibom" // QUO
    "icabaru" // ICA
    "ice" // SPF
    "iconi" // YVA
    "idiofa" // IDF
    "idrissi" // AHU
    "iejima" // IEJ
    "igarka" // IAA
    "igdır" // IGD
    "igiugig" // IGG
    "iglesias" // CJA
    "igloolik" // YGT
    "ignace" // ZUC
    "ignacy" // BZG
    "ignatyevo" // BQS
    "iguazu" // IGR
    "ihosy" // IHO
    "ijui" // IJU
    "ikaria" // JIK
    "ikela" // IKL
    "ikia" // IKA
    "ilam" // IIL
    "ilan" // ETM
    "ilebo" // PFR
    "ileg" // ILX
    "ilford" // ILF
    "ilheus" // IOS
    "iliamna" // ILI
    "iligan" // IGN
    "ilimsk" // UIK
    "illawarra" // WOL
    "illia" // GNR
    "illizi" // VVZ
    "ilmajoki" // SJY
    "ilo" // ILQ
    "iloilo" // ILO
    "ilopango" // ILS
    "ilorin" // ILR
    "ilulissat" // JAV
    "imam" // IKA
    "imbaimadai" // IMB
    "imelda" // MXI
    "immokalee" // IMM
    "imperatriz" // IMP
    "imperial" // IPL
    "impfondo" // ION
    "imsik" // BXN
    "inaat" // CNP
    "inagua" // IGA
    "inca" // JUL
    "incheon" // ICN
    "independencia" // QRC
    "indigo" // IBL
    "indira" // DEL
    "indore" // IDR
    "ine" // IMI
    "inedbirene" // DJG
    "ingham" // IGH
    "inhaca" // IHC
    "inhambane" // INH
    "inia" // CHT
    "inirida" // PDA
    "inisheer" // INQ
    "inishmaan" // IIA
    "inishmore" // IOR
    "injinoo" // ABM
    "inner" // YWH
    "innes" // GLI
    "innisfail" // IFL
    "innsbruck" // INN
    "inongo" // INO
    "inouye" // HNL
    "int" // SFO
    "inta" // INA
    "inten" // TKG
    "interlaken" // ZIN
    "intermountain" // UMZ
    "internazionale" // LIN
    "intibuca" // LEZ
    "inukjuak" // YPH
    "inus" // IUS
    "inuvik" // YEV
    "invercargill" // IVC
    "inverell" // IVR
    "inverness" // INV
    "inyokern" // IYK
    "ioannina" // IOA
    "iotniczy" // CTE
    "ipatinga" // IPN
    "ipiales" // IPI
    "ipil" // IPE
    "ipiranga" // IPG
    "ipota" // IPA
    "iqaluit" // YFB
    "iqbal" // LHE
    "iquitos" // IQT
    "iraklio" // HER
    "iranamadu" // TBA
    "iranshahr" // IHR
    "irara" // HME
    "ireland" // NOC
    "iringa" // IRI
    "iriona" // IRN
    "irkutsk" // IKT
    "iron" // IWD
    "isaacs" // MCJ
    "isabela" // JBQ
    "isafjordur" // IFJ
    "isafjorður" // IFJ
    "isely" // SPN
    "isere" // GNB
    "isfahan" // IFN
    "ishigaki" // ISG
    "ishurdi" // IRD
    "isiro" // IRP
    "isisford" // ISI
    "iskenderun" // HTY
    "iskushuban" // CMS
    "islam" // RDP
    "islamabad" // ISB
    "islas" // ROS
    "islay" // ILY
    "isles" // BQK
    "islita" // PBP
    "isparta" // ISE
    "itacoatiara" // ITA
    "itaituba" // ITB
    "itami" // ITM
    "itapemirim" // CDI
    "itaqui" // ITQ
    "itasca" // GPZ
    "ithaca" // ITH
    "itokama" // ITK
    "itubera" // ITR
    "itumbiara" // ITR
    "iturup" // ITU
    "itza" // CZA
    "ivalo" // IVL
    "ivano" // IFO
    "ivanovo" // IWA
    "ivato" // TNR
    "ivujivik" // YIK
    "iwa" // AZA
    "iwami" // IWJ
    "ixtapa" // ZIH
    "ixtepec" // IZT
    "izhevsk" // IJK
    "izmail" // IZL
    "izmir" // ADB
    "izumo" // IZO
    "izz" // TAI
    "jaaluni" // DQM
    "jaba" // TOO
    "jabalpur" // JLR
    "jabiru" // JAB
    "jabot" // JAT
    "jacinto" // BRM
    "jackpot" // KPT
    "jacksons" // POM
    "jacmel" // JAK
    "jacobacci" // IGB
    "jacqueline" // TRM
    "jacques" // RNS
    "jacquinot" // JAQ
    "jaffrey" // AFN
    "jagan" // GEO
    "jagdalpur" // JGB
    "jags" // GDT
    "jahrom" // JAR
    "jaipur" // JAI
    "jaisalmer" // JSA
    "jakobstad" // KOK
    "jalalabad" // JAA
    "jalaluddin" // GTO
    "jaluit" // UIT
    "jam" // KNR
    "jamba" // JMB
    "jammu" // IXJ
    "jamnagar" // JGA
    "jamshedpur" // IXW
    "janacek" // OSR
    "janakpur" // JKR
    "jandakot" // JAD
    "janeiro" // GIG
    "januaria" // JNA
    "japura" // RGT
    "jaque" // JQE
    "jara" // VER
    "jardines" // CCC
    "jashari" // PRN
    "jasionka" // RZE
    "jatai" // JTI
    "jauja" // JAU
    "java" // TOO
    "jawf" // AJF
    "jayaprakash" // PAT
    "jee" // ATQ
    "jeh" // JEJ
    "jeju" // CJU
    "jember" // JBB
    "jemma" // MXB
    "jenpeg" // ZJG
    "jeonju" // CHN
    "jequie" // JEQ
    "jeremie" // JEE
    "jerez" // XRY
    "jessore" // JSR
    "jeypore" // PYB
    "jharsuguda" // JRG
    "jiagedaqi" // JGD
    "jiamusi" // JMU
    "jiangbei" // CKG
    "jiangying" // NNY
    "jiansanjiang" // JSJ
    "jiaodong" // TAO
    "jiaohe" // TLQ
    "jiayuguan" // JGN
    "jieyang" // SWA
    "jijel" // GJL
    "jijiga" // JIJ
    "jimmy" // IDI
    "jinan" // TNA
    "jinchang" // JIC
    "jinchengjiang" // HCJ
    "jinchuan" // JIC
    "jindal" // VDY
    "jingdezhen" // JDZ
    "jinggangshan" // JGS
    "jinghong" // JHG
    "jingmai" // JMJ
    "jingzhou" // SHS
    "jinhae" // CHF
    "jinja" // JIN
    "jinjiang" // JJN
    "jinnah" // KHI
    "jinwan" // ZUH
    "jinzhou" // JNZ
    "jipijapa" // JIP
    "jiri" // JIR
    "jiroft" // JYR
    "jiuhuashan" // JUH
    "jiujiang" // JIU
    "jiuzhai" // JZH
    "jiwani" // JIW
    "jixi" // JXA
    "jizan" // GIZ
    "jkia" // NBO
    "jmc" // MDE
    "joacaba" // JCB
    "joaquim" // SVP
    "jobim" // GIG
    "jodhpur" // JDH
    "joe" // FSD
    "joensuu" // JOE
    "joensuun" // JOE
    "johannesburg" // JNB
    "johns" // SJN
    "johnstown" // JST
    "joint" // MMT
    "joinville" // JOI
    "joli" // YYY
    "joliet" // JOT
    "jolly" // DED
    "jolo" // JOL
    "jomo" // NBO
    "jomsom" // JMO
    "jonesboro" // JBR
    "jonkoping" // JKG
    "joplin" // JLN
    "jordan" // JDN
    "jorhat" // JRH
    "josefa" // LSP
    "josep" // BCN
    "joshua" // BUQ
    "joslin" // TWF
    "jouf" // AJF
    "joya" // UYU
    "joze" // LJU
    "jqf" // USA
    "juancho" // SAB
    "juanda" // SUB
    "juanjui" // JJI
    "juara" // JUA
    "juarbe" // ARE
    "juazeiro" // JDO
    "juba" // JUB
    "jubail" // QJB
    "juina" // JIA
    "juiz" // JDF
    "julia" // JCK
    "juliaca" // JUL
    "juliana" // SXM
    "julio" // PNT
    "julius" // DAR
    "jumandy" // TNW
    "jumla" // JUM
    "jundiai" // QDV
    "june" // MMH
    "juneau" // JNU
    "jungseok" // JDG
    "junin" // JNI
    "jura" // DLE
    "jurien" // JUR
    "juruena" // JRN
    "just" // LEQ
    "justo" // PRA
    "jutigalpa" // JUT
    "juvai" // LBW
    "juwata" // TRK
    "jwaneng" // JWA
    "jyvaskyla" // JYV
    "kaadedhdhoo" // KDM
    "kabala" // KBA
    "kabalega" // KBG
    "kabalo" // KBO
    "kaben" // KBT
    "kabri" // ABK
    "kabul" // KBL
    "kabwum" // KBM
    "kadala" // HTA
    "kadanwari" // KCF
    "kadapa" // CDP
    "kadhdhoo" // KDO
    "kadugli" // KDX
    "kaduna" // KAD
    "kaedi" // KED
    "kaele" // KLE
    "kaen" // KKC
    "kaf" // KDH
    "kagau" // KGE
    "kaghau" // KGE
    "kagi" // KGW
    "kagoshima" // KOJ
    "kagua" // AGK
    "kahramanmaras" // KCM
    "kahului" // OGG
    "kaieteur" // KAI
    "kaikohe" // KKO
    "kaikoura" // KBZ
    "kailashahar" // IXH
    "kaili" // KJH
    "kaimana" // KNG
    "kaisiepo" // BIK
    "kaitaia" // KAT
    "kaitoke" // GBZ
    "kajaani" // KAJ
    "kalabo" // KLB
    "kalaburgi" // GBI
    "kalaeloa" // JRF
    "kalaleh" // KLM
    "kalamata" // KLX
    "kalamazoo" // AZO
    "kalaupapa" // LUP
    "kalay" // KMV
    "kalaymyo" // KMV
    "kalbarri" // KAX
    "kalemie" // FMI
    "kalgoorlie" // KGI
    "kalibo" // KLO
    "kalima" // KLY
    "kalimarau" // BEJ
    "kalkgurung" // KFG
    "kallax" // LLA
    "kalmar" // KLR
    "kalokol" // KLK
    "kalskag" // KLG
    "kaltag" // KAL
    "kaluga" // KLF
    "kalymnos" // JKL
    "kamalpur" // IXQ
    "kamaran" // KAM
    "kamarang" // KAR
    "kamarata" // KTV
    "kambalda" // KDB
    "kamberatoro" // KDQ
    "kamchatsky" // PKC
    "kamembe" // KME
    "kamenogorsk" // UKK
    "kamina" // KMN
    "kamloops" // YKA
    "kampai" // DUM
    "kampala" // KLA
    "kampong" // KZC
    "kampot" // KMT
    "kamraj" // MAA
    "kamusi" // KUY
    "kamuzu" // LLW
    "kanab" // KNB
    "kanabea" // KEX
    "kanainj" // KNE
    "kananga" // KGA
    "kanas" // KJI
    "kandahar" // KDH
    "kandep" // KDP
    "kandi" // KDC
    "kandla" // IXY
    "kandrian" // KDR
    "kang" // KOS
    "kangding" // KGT
    "kangiqsualujjuaq" // XGR
    "kangiqsujuaq" // YWB
    "kangirsuk" // YKG
    "kangra" // DHM
    "kaniama" // KNM
    "kankakee" // IKK
    "kankan" // KNN
    "kannur" // CNN
    "kano" // KAN
    "kanpur" // KNU
    "kansai" // KIX
    "kantchari" // XKA
    "kanti" // KHM
    "kanua" // KTK
    "kao" // KAZ
    "kaohsiung" // KHH
    "kaolack" // KLC
    "kaoma" // KMZ
    "kaong" // KOS
    "kapadokya" // NAV
    "kapal" // KPL
    "kapalua" // JHM
    "kapanda" // KNP
    "kapanga" // KAP
    "kapango" // SVP
    "kapit" // KPI
    "kapiti" // PPQ
    "kapodistrias" // CFU
    "kapuskasing" // YYU
    "kapwepwe" // NLA
    "kar" // KRX
    "karachi" // KHI
    "karaganda" // KGF
    "karaj" // PYK
    "karamay" // KRY
    "karanambo" // KRM
    "karara" // KQR
    "karasabai" // KRG
    "karasburg" // KAS
    "karato" // KAF
    "karawari" // KRJ
    "kardla" // KDL
    "karel" // LUV
    "kariba" // KAB
    "karipur" // CCJ
    "karl" // OFK
    "karlovy" // KLV
    "karlskoga" // KSK
    "karlsruhe" // FKB
    "karlstad" // KSD
    "karluk" // KYK
    "karmoy" // HAU
    "karmøy" // HAU
    "karol" // BRI
    "karonga" // KGJ
    "karoola" // KXR
    "karpathos" // AOK
    "karratha" // KTA
    "kars" // KSY
    "karshi" // KSQ
    "karumba" // KRB
    "karup" // KRP
    "karzai" // KBL
    "kasaba" // ZKB
    "kasabonika" // XKS
    "kasama" // KAA
    "kasane" // BBK
    "kasba" // YDU
    "kasese" // KSE
    "kashan" // KKS
    "kashechewan" // ZKE
    "kashgar" // KHG
    "kashi" // KHG
    "kasigluk" // KUK
    "kasiguncu" // PSJ
    "kasim" // PKU
    "kasompe" // CGJ
    "kasos" // KSJ
    "kassala" // KSL
    "kassel" // KSF
    "kassos" // KSJ
    "kastamonu" // KFS
    "kastela" // SPU
    "kastellorizo" // KZS
    "kastelorizo" // KZS
    "kastoria" // KSO
    "kastrup" // CPH
    "kasungu" // KBQ
    "katameya" // CCE
    "katanning" // KNI
    "kathmandu" // KTM
    "katima" // MPA
    "katiola" // KTC
    "katmandu" // KTM
    "kato" // KTO
    "katowice" // KTW
    "katsina" // DKA
    "kattiniq" // YAU
    "kaubang" // KAZ
    "kauehi" // KHZ
    "kaufana" // EUA
    "kauhava" // KAU
    "kaukura" // KKR
    "kaunas" // KUN
    "kaunda" // LUN
    "kavala" // KVA
    "kavanayen" // KAV
    "kavieng" // KVG
    "kavumu" // BKY
    "kawama" // VRO
    "kawito" // KWO
    "kawthaung" // KAW
    "kawthoung" // KAW
    "kaya" // XKY
    "kayenta" // MVM
    "kayes" // KYS
    "kayseri" // ASR
    "kazan" // KZN
    "kazantzakis" // HER
    "kazi" // RDP
    "keahole" // KOA
    "kearney" // EAR
    "keats" // PKT
    "kedougou" // KGG
    "keeling" // CCK
    "keetmanshoop" // KMP
    "keewaywin" // KEW
    "kefallinia" // EFL
    "kefalonia" // EFL
    "keflavik" // KEF
    "kegaska" // ZKG
    "keglsugl" // KEG
    "keibane" // NRM
    "kelafo" // LFO
    "kelalan" // BKM
    "kelle" // KEE
    "keller" // PCW
    "kellogg" // BTL
    "kelowna" // YLW
    "kelsey" // KES
    "kemerovo" // KEJ
    "kemi" // KEM
    "kemmerer" // EMM
    "kempegowda" // BLR
    "kempsey" // KPS
    "ken" // POT
    "kenai" // ENA
    "kendall" // TMB
    "kenema" // KEN
    "kengtung" // KET
    "kenieba" // KNZ
    "kenneth" // LUN
    "kennett" // KNT
    "kenney" // PNP
    "kenora" // YQK
    "kenosha" // ENW
    "kent" // XCM
    "kentland" // KKT
    "kentucky" // CVG
    "kenyatta" // NBO
    "keokuk" // EOK
    "keppel" // YVV
    "kerama" // KJP
    "kerang" // KRA
    "kerau" // KRU
    "kerch" // KHC
    "kerema" // KMA
    "kericho" // KEY
    "kerikeri" // KKE
    "kerman" // KER
    "kermanshah" // KSH
    "kerr" // RKR
    "kerrville" // ERV
    "kerry" // KIR
    "kertajati" // KJT
    "kerteh" // KTE
    "keshod" // IXK
    "ketapang" // KTG
    "ketchikan" // KTN
    "keys" // MTH
    "khaan" // ULN
    "khabarovsk" // KHV
    "khaimah" // RKT
    "khajuraho" // HJR
    "khaled" // RUH
    "khalid" // RUH
    "khama" // GBE
    "khamti" // KHM
    "khanabad" // KSQ
    "khandyga" // KDY
    "khanty" // HMA
    "kharg" // KHK
    "kharga" // UVL
    "khark" // KHK
    "kharkhorin" // KHR
    "kharkiv" // HRK
    "kharkov" // HRK
    "khartoum" // KRT
    "khasab" // KHS
    "khashm" // GBU
    "khatanga" // HTG
    "khatgal" // HTM
    "khawr" // ADE
    "kherson" // KHE
    "khider" // BSK
    "khmelnytskyi" // HMJ
    "khomeini" // IKA
    "khon" // KKC
    "khong" // KOG
    "khonuu" // MQJ
    "khoram" // KHD
    "khorramabad" // KHD
    "khost" // KHT
    "khouang" // XKH
    "khovd" // HVD
    "khowai" // IXN
    "khowst" // KHT
    "khoy" // KHY
    "khrabrovo" // KGD
    "khudzhand" // LBD
    "khujand" // LBD
    "khujirt" // HJT
    "khuong" // DLI
    "khuzdar" // KDD
    "khwahan" // KWH
    "khwai" // KHW
    "khwaja" // KBL
    "kial" // CNN
    "kickapoo" // KIP
    "kidlington" // OXF
    "kiffa" // KFA
    "kigali" // KGL
    "kigoma" // TKQ
    "kikai" // KKX
    "kikori" // KRI
    "kikwit" // KKW
    "kilaguni" // ILU
    "kili" // KIO
    "kilimanjaro" // JRO
    "kiliti" // SFK
    "kilkenny" // KKY
    "killaloe" // YXI
    "killeen" // GRK
    "kilwa" // KIY
    "kimmirut" // YLC
    "kimwarer" // KRV
    "kinabalu" // BKI
    "kincardine" // YKD
    "kindamba" // KNJ
    "kindersley" // YKY
    "kindu" // KND
    "kingaroy" // KGY
    "kingfisher" // KIF
    "kingman" // IGM
    "kingscote" // KGC
    "kingsford" // SYD
    "kingston" // YGK
    "kinkungwa" // KLY
    "kinmen" // KNH
    "kinshasa" // FIH
    "kinston" // ISO
    "kipnuk" // KPN
    "kira" // KIQ
    "kirakira" // IRA
    "kirchner" // VMR
    "kirensk" // KCK
    "kiriwina" // LSA
    "kiriwini" // LSA
    "kirk" // PGR
    "kirkconnell" // CYB
    "kirkenes" // KKN
    "kirkland" // YKX
    "kirksville" // IRK
    "kirkwall" // KOI
    "kirkwood" // CKN
    "kirovsk" // KVK
    "kiruna" // KRN
    "kirundo" // KRE
    "kiryat" // KWS
    "kisengan" // KSG
    "kish" // KIH
    "kishangarh" // KQH
    "kisimayu" // KMU
    "kismayo" // KMU
    "kissidougou" // KSI
    "kissimmee" // ISM
    "kisumu" // KIS
    "kitadaito" // KTD
    "kitakyushu" // KKJ
    "kitale" // KTL
    "kitava" // KVE
    "kithira" // KIT
    "kitkatla" // YKK
    "kittila" // KTT
    "kiunga" // UNG
    "kivalina" // KVL
    "kiwayu" // KWY
    "kjaerstad" // MJF
    "kjevik" // KRS
    "kjula" // EKT
    "klagenfurt" // KLU
    "klamath" // LMT
    "klawock" // KLW
    "kleinsee" // KLZ
    "kleinzee" // KLZ
    "klen" // ELN
    "klia" // KUL
    "klisa" // OSI
    "klom" // LOM
    "kloten" // ZRH
    "klyuch" // KDY
    "knapp" // MPV
    "knee" // YKE
    "kneeland" // NLN
    "knevichi" // VVO
    "knight" // TPF
    "knock" // NOC
    "knox" // RKD
    "kobe" // UKB
    "kobuk" // OBU
    "koca" // EDO
    "kochi" // KCZ
    "kogalniceanu" // CND
    "kogalym" // KGP
    "koggala" // KCT
    "koh" // KKZ
    "kohala" // MUE
    "koinambe" // KMB
    "kok" // HKG
    "kokhanok" // KNK
    "kokkola" // KOK
    "kokoda" // KKD
    "kokomo" // OKK
    "kokoro" // KOR
    "kokshetau" // KOV
    "koktokay" // FYN
    "koladza" // GBR
    "kolhapur" // KLH
    "koliganek" // KGK
    "kolkata" // CCU
    "koln" // CGN
    "koltsovo" // SVX
    "kolwezi" // KWZ
    "komaki" // NKM
    "komatsu" // KMQ
    "komodo" // LBJ
    "kompiam" // KPM
    "komsomolsk" // KXK
    "kona" // KOA
    "konarak" // ZBR
    "konder" // NVT
    "kone" // KNQ
    "konge" // KGB
    "kongiganak" // KKH
    "kongolo" // KOO
    "kongsamba" // NKS
    "kooddoo" // GKK
    "kootenay" // YCG
    "kooy" // DHR
    "kopasker" // OPA
    "kopiago" // KPA
    "kopitnari" // KUT
    "kord" // CQD
    "korfez" // EDO
    "korhogo" // HGO
    "koritz" // RPJ
    "korla" // KRL
    "kornasoren" // FOO
    "koroba" // KDE
    "korogoussou" // GAQ
    "kortrijk" // KJK
    "kos" // KGS
    "koschnick" // BRE
    "kosice" // KSC
    "kosrae" // KSA
    "kostanay" // KSN
    "kostroma" // KMW
    "koszalin" // OSZ
    "kotlas" // KSZ
    "kotlik" // KOT
    "kotoka" // ACC
    "koulamoutou" // KOU
    "koumala" // KOL
    "kourou" // QKR
    "koutiala" // KTX
    "kowanyama" // KWM
    "kowt" // TII
    "koyuk" // KKA
    "koyukuk" // KYU
    "kozani" // KZI
    "kozhikode" // CCJ
    "krabi" // KBV
    "kraemer" // BGX
    "krakor" // KZD
    "krakow" // KRK
    "kraljevo" // KVO
    "kramatorsk" // KRQ
    "kramfors" // KRF
    "kranebitten" // INN
    "krasnodar" // KRR
    "krasnoyarsk" // KJA
    "kratie" // KTI
    "krause" // IGR
    "krayniy" // BXY
    "kremenchuk" // KHU
    "kribi" // KBI
    "krim" // HME
    "kristiansand" // KRS
    "kristianstad" // KID
    "kristiansund" // KSU
    "krk" // RJK
    "kronoberg" // VXO
    "kronoby" // KOK
    "kruger" // MQP
    "kruunupyy" // KOK
    "kryvyi" // KWG
    "krywlany" // QYY
    "ksar" // GAF
    "ksia" // DUR
    "kuabang" // KAZ
    "kualanamu" // KNO
    "kuantan" // KUA
    "kuching" // KCH
    "kudat" // KUD
    "kufra" // AKF
    "kugaaruk" // YBB
    "kugluktuk" // YCO
    "kuini" // NFO
    "kuito" // SVP
    "kukudu" // KUE
    "kulik" // LKK
    "kullu" // KUU
    "kulob" // TJU
    "kulusuk" // KUS
    "kulyab" // TJU
    "kumamoto" // KMJ
    "kumasi" // KMS
    "kumejima" // UEO
    "kunashiri" // DEE
    "kunaye" // LNV
    "kungim" // KGM
    "kungo" // CEO
    "kungsangen" // NRK
    "kunming" // KMG
    "kunovice" // UHE
    "kununurra" // KNX
    "kuopio" // KUO
    "kuparuk" // UUK
    "kupiano" // KUP
    "kupol" // KPX
    "kupper" // JVI
    "kuqa" // KCA
    "kuressaare" // URE
    "kurgan" // KRO
    "kuri" // KUQ
    "kuria" // KUC
    "kurilsk" // DEE
    "kursk" // URS
    "kurtz" // PFB
    "kurumoch" // KUF
    "kurwina" // KWV
    "kushiro" // KUH
    "kushok" // IXL
    "kusten" // KRF
    "kut" // UKX
    "kutai" // GHS
    "kutaisi" // KUT
    "kutako" // WDH
    "kuujjuaq" // YVP
    "kuujjuarapik" // YGW
    "kuusamo" // KAO
    "kuwait" // KWI
    "kuybyshev" // KUF
    "kuyga" // UKG
    "kuyol" // KUX
    "kvernberget" // KSU
    "kwanghan" // GHN
    "kwethluk" // KWT
    "kwigillingok" // KWK
    "kyaukpyu" // KYP
    "kyauktu" // KYT
    "kyiv" // IEV
    "kyle" // CEY
    "kyushu" // HSG
    "kyzyl" // KYZ
    "kyzylorda" // KZO
    "laage" // RLG
    "labasa" // LBS
    "labo" // OZC
    "labrador" // YHG
    "labraq" // LAQ
    "labrea" // LBR
    "labuan" // LBU
    "laconia" // LCI
    "ladjevci" // KVO
    "ladouanie" // LDO
    "ladowisko" // CZW
    "laduani" // LDO
    "ladysmith" // LAY
    "lae" // LML
    "laeso" // BYR
    "lafaiete" // QDF
    "lafayette" // LFT
    "lafleur" // WVL
    "lafon" // SSD
    "lagaligo" // LLO
    "lages" // LAJ
    "laghouat" // LOO
    "lago" // LGQ
    "lagoas" // TJL
    "lagos" // LOS
    "lagrange" // LGC
    "laguardia" // LGA
    "lague" // LCO
    "laguindingan" // CGY
    "lagunas" // DON
    "lahad" // LDU
    "lahm" // MFD
    "lailai" // PTF
    "lajes" // TER
    "lakeba" // LKB
    "lakefront" // BKL
    "lakhimpur" // IXI
    "lakselv" // LKL
    "lalibela" // LLI
    "lambarene" // LBQ
    "lamberton" // FKL
    "lamco" // NIA
    "lamen" // LNB
    "lamentin" // FDF
    "lamerd" // LFM
    "lamezia" // SUF
    "lamidanda" // LDN
    "lampang" // LPT
    "lampedusa" // LMP
    "lampson" // CKE
    "lamu" // LAU
    "lanai" // LNY
    "lanaʻi" // LNY
    "lancang" // JMJ
    "landry" // OPL
    "lands" // LEQ
    "landvetter" // GOT
    "lanet" // NUU
    "langimar" // LNM
    "langkawi" // LGK
    "langley" // YLY
    "langnes" // TOS
    "langtang" // LTG
    "langtou" // DDG
    "lankaran" // LLK
    "lann" // LRT
    "lannion" // LAI
    "lanqi" // YKH
    "lansdowne" // YLH
    "lanseria" // HLA
    "lanyu" // KYD
    "lanzarote" // ACE
    "lanzhou" // LHW
    "laoag" // LAO
    "lap" // HKG
    "lapa" // LAZ
    "lappeenranta" // LPP
    "lapu" // CEB
    "lar" // LRR
    "lara" // BRM
    "laramie" // LAR
    "larantuka" // LKA
    "larbi" // TEE
    "larestan" // LRR
    "largeau" // FYT
    "largo" // MLZ
    "larnaca" // LCA
    "larnaka" // LCA
    "larochelle" // LRH
    "larre" // PDU
    "larsen" // KLN
    "lashio" // LSH
    "latrobe" // TGN
    "latur" // LTU
    "lau" // ONU
    "laucala" // LUC
    "laughlin" // IFP
    "launceston" // LST
    "laura" // LUU
    "laurel" // PIB
    "laurent" // LDX
    "laurie" // LRQ
    "laurinburg" // MXE
    "lauriston" // CRU
    "lavacolla" // SCQ
    "laval" // LVA
    "lavan" // LVP
    "laverton" // LVO
    "lavinia" // NFO
    "lawanti" // GMO
    "lawas" // LWY
    "lawrenceville" // LWV
    "lawton" // LAW
    "lay" // PIZ
    "lazaro" // LZC
    "lazne" // MKA
    "lađevci" // KVO
    "leadville" // LXV
    "leaf" // YLR
    "lebakeng" // LEF
    "lebanon" // LEB
    "lebel" // YLS
    "lech" // GDN
    "leckrone" // SLO
    "leeds" // LBA
    "leesburg" // LEE
    "leeton" // NRA
    "leeward" // NBW
    "lefkada" // PVK
    "leflore" // GWO
    "left" // AXF
    "legazpi" // LGP
    "legionari" // TRS
    "leguizamo" // LQM
    "leh" // IXL
    "lehigh" // ABE
    "lehu" // LHP
    "leigh" // LGH
    "leinster" // LER
    "leirin" // VDB
    "leismer" // CFM
    "lekhwair" // LKW
    "leknes" // LKN
    "lellang" // LGL
    "lelystad" // LEY
    "lembata" // LWE
    "lemhi" // SMN
    "lemnos" // LXS
    "lempira" // PEU
    "lenawee" // ADG
    "lencero" // JAL
    "lengeh" // BDH
    "lengpui" // AJL
    "leninakan" // LWN
    "lennart" // TLL
    "lennon" // LPL
    "lensk" // ULK
    "lentokentta" // UTI
    "leo" // XLU
    "leobardo" // ZCL
    "leonora" // LNO
    "leopold" // DKR
    "leopoldina" // LEP
    "leos" // OSR
    "leribe" // LRB
    "leron" // LPN
    "leros" // LRS
    "lesage" // YQB
    "lese" // LNG
    "leshukonskoye" // LDG
    "lesobeng" // LES
    "lesquin" // LIL
    "lester" // YYZ
    "letfotar" // MOM
    "lethbridge" // YQL
    "lethem" // LTM
    "leticia" // LET
    "letouquet" // LTQ
    "letourneau" // TOC
    "lettsome" // EIS
    "levaldigi" // CUF
    "level" // YOJ
    "levelock" // KLL
    "levuka" // LEV
    "lewistown" // LWT
    "lhasa" // LXA
    "lhok" // LSX
    "liangjiang" // KWL
    "liangjing" // KWL
    "lianshui" // HIA
    "lianyungang" // LYG
    "liard" // YJF
    "libenge" // LIE
    "liberador" // PSS
    "liberal" // LBL
    "libertador" // PSS
    "liberty" // EWR
    "libo" // LLB
    "liboi" // LBK
    "libres" // AOL
    "libreville" // LBV
    "licenciado" // PVR
    "lichinga" // VXC
    "licin" // BTW
    "lick" // FRH
    "lidkoping" // LDK
    "liege" // LGG
    "lien" // DLI
    "liepaja" // LPX
    "lieras" // SOX
    "lieutenant" // VLM
    "lifou" // LIF
    "lifuka" // HPA
    "lightning" // LHG
    "lihir" // LNV
    "lihue" // LIH
    "lijiang" // LJG
    "likiep" // LIK
    "likoma" // LIX
    "lila" // IXI
    "lilabari" // IXI
    "lilienthal“" // TXL
    "lille" // LIL
    "lilongwe" // LLW
    "limbang" // LMN
    "limbe" // VCC
    "lime" // LMR
    "limerick" // PTW
    "limnos" // LXS
    "limoges" // LIG
    "linares" // ZLR
    "linate" // LIN
    "lincang" // LNJ
    "linden" // LDJ
    "linder" // LAL
    "lindi" // LDI
    "lindu" // LDS
    "linfen" // LFQ
    "linga" // LGN
    "lingling" // LLF
    "link" // BGM
    "linkoping" // LPI
    "lins" // LIP
    "linyi" // LYI
    "linz" // LNZ
    "lions" // ORI
    "lipetsk" // LPK
    "liping" // HZH
    "lippstadt" // PAD
    "lisa" // FOG
    "lisala" // LIQ
    "lisboa" // NOV
    "lisbon" // LIS
    "lishe" // NGB
    "lismore" // LSY
    "lista" // FAN
    "liszt" // BUD
    "liuji" // XFN
    "liupanshan" // GYU
    "liupanshui" // LPF
    "liuting" // TAO
    "liuzhou" // LZH
    "livermore" // LVK
    "liverpool" // LPL
    "livingstone" // LVI
    "livramento" // LVB
    "lizard" // LZR
    "ljubljana" // LJU
    "lku" // LOW
    "lleida" // ILD
    "lleras" // SOX
    "llg" // LLJ
    "lloydminster" // YLL
    "loa" // CJC
    "loakan" // BAG
    "lobato" // DIL
    "lobatse" // LOQ
    "lobito" // LLT
    "locarno" // ZJI
    "lochini" // TBS
    "locka" // OPF
    "lockhart" // IRG
    "lockheed" // BUR
    "locks" // CZK
    "lodja" // LJA
    "lodwar" // LOK
    "loei" // LOE
    "logistics" // VCV
    "logrono" // RJL
    "lohegaon" // PNQ
    "loikaw" // LIW
    "loiyangalani" // LOY
    "lok" // PAT
    "lokichoggio" // LKG
    "lokichogio" // LKG
    "lokichokio" // LKG
    "lolland" // MRW
    "lombok" // LOP
    "lome" // LFW
    "lompoc" // LPC
    "loncopue" // LCP
    "londrina" // LDB
    "lone" // CXO
    "lonesome" // LNP
    "longana" // LOD
    "longdongbao" // KWE
    "longjia" // CGQ
    "longnan" // LNL
    "longreach" // LRE
    "longwan" // WNZ
    "longyan" // LCX
    "longyear" // LYR
    "longyearbyen" // LYR
    "lonorore" // LNE
    "lontras" // LOI
    "lookout" // YXL
    "lopes" // RAO
    "lorca" // GRX
    "lord" // LDH
    "loreto" // LTO
    "lorica" // LRI
    "lorient" // LRT
    "loring" // LIZ
    "lorraine" // ETZ
    "losinj" // LSZ
    "lost" // LNN
    "losuia" // LSA
    "lotfi" // CBH
    "lott" // PGL
    "louangnamtha" // LXG
    "loudes" // LPY
    "louisa" // LOW
    "louise" // VBT
    "loup" // YRI
    "louverture" // PAP
    "loveland" // FNL
    "lovell" // CHA
    "low" // SOW
    "lowcountry" // RBW
    "lower" // OYL
    "lowndes" // UBS
    "loyangalani" // LOY
    "loyola" // JOI
    "lpbz" // VSE
    "lpia" // NAS
    "lsmb" // BRN
    "lsms" // SIR
    "lsmu" // BXO
    "lsw" // LSX
    "luanda" // LAD
    "luano" // FBM
    "luau" // UAL
    "lubang" // LBX
    "lubango" // SDD
    "lubbock" // LBB
    "lubeck" // LBC
    "lublin" // LUZ
    "lublinek" // LCJ
    "lubumbashi" // FBM
    "lucapa" // LBZ
    "lucas" // LVR
    "lucca" // LCV
    "lucenec" // LUE
    "lucia" // UVF
    "lucie" // FPR
    "lucio" // REX
    "lucknow" // LKO
    "luderitz" // LUD
    "ludhiana" // LUH
    "luena" // LUO
    "lufthamn" // KKN
    "lugano" // LUG
    "lugh" // LGX
    "lughawe" // GRJ
    "lugu" // NLH
    "luguhu" // NLH
    "luiza" // LZA
    "luka" // BNX
    "luki" // VLU
    "lukla" // LUA
    "lukou" // NKG
    "lukulu" // LXU
    "lulea" // LLA
    "luliang" // LLV
    "lulsgate" // BRS
    "lumbala" // GGC
    "lumban" // SIX
    "lumberton" // LBT
    "lumbo" // LFB
    "lumi" // LMI
    "lumid" // LUB
    "lumpur" // KUL
    "lund" // FRC
    "lungi" // FNA
    "lunken" // LUK
    "luojia" // JDZ
    "luonetjarvi" // JYV
    "luova" // SCZ
    "luoyang" // LYA
    "luperon" // POP
    "luqa" // MLA
    "luqiao" // HYN
    "luque" // ASU
    "lusaka" // LUN
    "lusambo" // LBO
    "lusanga" // LUS
    "lushan" // JIU
    "luton" // LTN
    "lutselk" // YSG
    "lutsk" // UCK
    "luxembourg" // LUX
    "luxor" // LXR
    "luz" // FLN
    "luzamba" // LZM
    "luzhou" // LZO
    "lviv" // LWO
    "lycksele" // LYC
    "lydd" // LYX
    "lyman" // ITO
    "lynch" // HCW
    "lynchburg" // LYH
    "lynden" // NAS
    "lyneham" // LYE
    "lynn" // YYL
    "lysandro" // CAW
    "lyudao" // GNI
    "læsø" // BYR
    "maafaru" // NMF
    "maamigili" // VAM
    "maarianhamina" // MHQ
    "maastricht" // MST
    "maavaarulaa" // RUL
    "maavarulu" // RUL
    "mabaruma" // USI
    "mabuiag" // UBB
    "macae" // MEA
    "macao" // MFM
    "macapa" // MCP
    "macarena" // LMC
    "macarthur" // ISP
    "macau" // MFM
    "macchie" // BRI
    "macdonald" // YOW
    "macenta" // MCA
    "maceo" // SCU
    "mackall" // HFF
    "mackinac" // MCD
    "macmillan" // YPB
    "macmillian" // XMP
    "macomb" // MQB
    "macon" // MAC
    "macready" // MCE
    "mactan" // CEB
    "madang" // MAG
    "madani" // TBZ
    "madeira" // FNC
    "madeleine" // YGR
    "madera" // MAE
    "madurai" // IXM
    "maestra" // MZO
    "maestro" // STM
    "maewo" // MWF
    "maf" // BUU
    "mafeking" // MBD
    "mafeteng" // MFC
    "mafia" // MFA
    "mafikeng" // MBD
    "mafra" // QMF
    "mag" // ZYL
    "magalhaes" // SSA
    "magan" // GYG
    "magangue" // MGN
    "magas" // IGT
    "magdagachi" // GDG
    "magdalena" // MGD
    "magdeburg" // CSO
    "magee" // LOZ
    "magenta" // GEA
    "magheraus" // BAY
    "magic" // TWF
    "magnet" // MMG
    "magnitogorsk" // MQF
    "magnolia" // AGO
    "magny" // YEY
    "maguana" // SJM
    "magway" // MWQ
    "mahana" // TOZ
    "maharajpur" // GWL
    "mahdi" // TGR
    "mahdia" // MHA
    "mahendranagar" // XMG
    "mahlon" // EUG
    "mahshahr" // MRX
    "mai" // CNX
    "maiana" // MNK
    "maiduguri" // MIU
    "maijishan" // THQ
    "maimana" // MMZ
    "maimun" // SBG
    "main" // FRA
    "mainling" // LZY
    "maintirano" // MXT
    "maio" // MMO
    "maison" // ALG
    "maiten" // EMX
    "maitland" // MTL
    "majalengka" // KJT
    "majeed" // ULH
    "majkin" // MJE
    "majoor" // ICK
    "majors" // GVT
    "majuro" // MAJ
    "makabana" // KMK
    "makedonia" // SKG
    "makemo" // MKP
    "makhdum" // RJH
    "makini" // MPG
    "makkovik" // YMN
    "makokola" // CMK
    "makokou" // MKU
    "makoua" // MKJ
    "maksar" // ADE
    "maktoum" // DWC
    "maku" // IMQ
    "makurdi" // MDI
    "mala" // AAM
    "malabang" // MLP
    "malabo" // SSG
    "malaga" // AGP
    "malakal" // MAK
    "malal" // HOS
    "malamo" // GLX
    "malan" // CPT
    "malange" // MEG
    "malanje" // MEG
    "malcolm" // SSI
    "malda" // LDA
    "malden" // MAW
    "maldonado" // PEM
    "male" // MLE
    "malek" // DAV
    "malekoula" // LPM
    "malelane" // LLE
    "malikus" // LSW
    "malindi" // MYD
    "mallacoota" // XMC
    "mallam" // KAN
    "mallorca" // PMI
    "malmo" // MMX
    "malo" // DNR
    "maloelap" // MAV
    "malolo" // PTF
    "malone" // MAL
    "malpensa" // MXP
    "malta" // MLA
    "malvine" // USH
    "mamai" // MAP
    "mamburao" // MBO
    "mamfe" // MMF
    "mammoth" // MMH
    "mampikony" // WMP
    "mana" // MNF
    "manakara" // WVK
    "manali" // KUU
    "mananara" // WMR
    "manang" // NGX
    "mananjary" // MNJ
    "manapouri" // TEU
    "manare" // MRM
    "manas" // FRU
    "manassas" // MNZ
    "manatee" // MZE
    "manaung" // MGU
    "manaus" // MAO
    "manco" // JUL
    "manda" // LAU
    "mandabe" // WMD
    "mandakalli" // MYQ
    "mandalgovi" // MXW
    "mandelieu" // CEQ
    "mandera" // NDE
    "mandinga" // COG
    "manetai" // MVI
    "manga" // MGP
    "mangaia" // MGS
    "mangalore" // IXE
    "mangaluru" // IXE
    "mangla" // XJM
    "manglona" // ROP
    "mangochi" // MAI
    "mangroves" // PNI
    "mangshi" // LUM
    "manguna" // MFO
    "manhattan" // MHK
    "manicore" // MNX
    "manihi" // XMH
    "manihiki" // MHX
    "maniitsoq" // JSU
    "manimba" // MSM
    "maningrida" // MNG
    "manis" // TGC
    "manises" // VLC
    "manistee" // MBL
    "manitouwadge" // YMG
    "manitowaning" // YEM
    "manitowoc" // MTW
    "maniwaki" // YMW
    "manizales" // MZL
    "manja" // MJA
    "manjimup" // MJP
    "mankato" // MKT
    "mano" // AJY
    "manoel" // JBS
    "manokotak" // KMO
    "manrique" // ACE
    "mans" // LME
    "mansa" // MNS
    "mansfield" // MFD
    "mansiysk" // HMA
    "mansons" // YMU
    "mante" // MMC
    "mantilla" // TUA
    "manumu" // UUU
    "manyara" // LKY
    "manzanillo" // ZLO
    "manzhouli" // NZH
    "mao" // AMO
    "maota" // MXS
    "maotai" // WMT
    "mapoda" // MPF
    "maputo" // MPM
    "maqin" // GMQ
    "maquehue" // PZS
    "maquinchao" // MQD
    "maraba" // MAB
    "maradi" // MFQ
    "marais" // GRM
    "marakei" // MZK
    "maramuni" // MWI
    "maramures" // BAY
    "marana" // AVW
    "marawaka" // MWG
    "marble" // MYH
    "marbleton" // BPI
    "marcala" // MRJ
    "marcano" // ICC
    "marce" // ANE
    "marcel" // CHR
    "marcillac" // RDZ
    "marconi" // BLQ
    "mardin" // MQM
    "mareeba" // MRG
    "margane" // YWQ
    "margarima" // MGG
    "margate" // MGH
    "mariana" // GAO
    "marianske" // MKA
    "marib" // MYN
    "maribo" // MRW
    "maribor" // MBX
    "mariehamn" // MHQ
    "marignane" // MRS
    "marilia" // MII
    "marinda" // RJM
    "marinduque" // MRQ
    "marinette" // MNM
    "maringa" // MGF
    "maringe" // FRE
    "marino" // PMV
    "maripasoula" // MPY
    "mariposa" // RMY
    "mariquita" // MQU
    "maris" // SML
    "mariupol" // MPW
    "mark" // GFK
    "markovo" // KVM
    "marlborough" // BHE
    "marmul" // OMM
    "maroantsetra" // WMN
    "maroni" // LDX
    "maroochydore" // MCY
    "marqos" // DBM
    "marquez" // LAP
    "marrakesh" // RAK
    "mars" // LRJ
    "marsabit" // RBT
    "marseille" // MRS
    "marsh" // MHH
    "marshfield" // MFI
    "marta" // SMR
    "martha" // MVY
    "marti" // HAV
    "martinique" // FDF
    "martins" // FOR
    "marudi" // MUR
    "maryborough" // MBH
    "marys" // STQ
    "masasi" // XMI
    "masbate" // MBT
    "mashhad" // MHD
    "masi" // MSM
    "masindi" // KCU
    "masjed" // QMJ
    "masoko" // KIY
    "massawa" // MSW
    "massena" // MSS
    "masset" // ZMT
    "massira" // AGA
    "masterton" // MRO
    "masvingo" // MVZ
    "matacan" // SLM
    "matadi" // MAT
    "matagami" // YNM
    "matahora" // WNI
    "matak" // MWK
    "matamata" // MTA
    "matane" // YME
    "matanzima" // UTT
    "matari" // IRP
    "mataura" // TUB
    "mataveri" // IPC
    "matecana" // PEI
    "matecanas" // PEI
    "matei" // TVU
    "mateos" // TLC
    "material" // RCU
    "mather" // MHR
    "mathilda" // SXK
    "mathis" // SJT
    "mati" // MXI
    "matias" // MQK
    "matienzo" // TUC
    "matmata" // GAE
    "matou" // HDG
    "matrouh" // MUH
    "matruh" // MUH
    "matsaile" // MSG
    "matsapha" // MTS
    "matsumoto" // MMJ
    "matsuyama" // MYJ
    "mattala" // HRI
    "matthew" // SQS
    "matthews" // MWJ
    "matupa" // MBK
    "maues" // MBZ
    "mauke" // MUK
    "maun" // MUB
    "maupertus" // CER
    "maupiti" // MAU
    "maurice" // GND
    "maury" // MRC
    "maverick" // EGP
    "mawlamyaing" // MNU
    "mawlamyine" // MNU
    "maximo" // AVI
    "maxson" // AXB
    "maxton" // MXE
    "maxwell" // OCN
    "mayaguana" // MYG
    "mayen" // ZXB
    "mayensfield" // ZXB
    "mayfa" // MFY
    "mayi" // MJM
    "maymana" // MMZ
    "mayotte" // DZA
    "mayumba" // MYB
    "maza" // FRS
    "mazamari" // MZA
    "mazamet" // DCM
    "mazar" // MZR
    "mazatlan" // MZT
    "mazin" // SNW
    "mazovia" // WMI
    "mbakwe" // QOW
    "mbala" // MMQ
    "mbambanakira" // MBU
    "mbandaka" // MDK
    "mbanza" // SSY
    "mbarara" // MBQ
    "mbeya" // MBI
    "mbigou" // MBC
    "mbo" // DXE
    "mboliasa" // KRZ
    "mbuji" // MJM
    "mcalester" // MLC
    "mcallen" // MFE
    "mcallister" // YKM
    "mcarthur" // MCV
    "mccall" // MYL
    "mccarran" // LAS
    "mccarthy" // MXY
    "mccartney" // GDT
    "mccollum" // RYY
    "mccomb" // MCB
    "mccook" // MCK
    "mccoy" // CMY
    "mccurdy" // YQY
    "mcentire" // MMT
    "mcghee" // TYS
    "mcgrath" // MCG
    "mcintosh" // YQW
    "mckellar" // MKL
    "mckinley" // MCL
    "mckinnon" // SSI
    "mcmahon" // HCA
    "mcminn" // MMI
    "mcminnville" // MMV
    "mcnamara" // CEC
    "mcneill" // YMP
    "mcpherson" // ZFM
    "mdn" // IMS
    "meacham" // FTW
    "meadville" // MEJ
    "meanchey" // OMY
    "mecheria" // MZW
    "meda" // QHR
    "medan" // KNO
    "medani" // DNI
    "medford" // MFR
    "medicine" // YXH
    "medina" // MED
    "mediterranee" // MPL
    "medouneu" // MDV
    "meekatharra" // MKR
    "meenambakkam" // MAA
    "mefford" // TLR
    "megeve" // MVV
    "meghauli" // MEY
    "mehamn" // MEH
    "mehrabad" // THR
    "meilan" // HAK
    "meixian" // MXZ
    "mejia" // TRB
    "mejit" // MJB
    "mekambo" // MKB
    "mekane" // MKS
    "mekoryuk" // MYU
    "mekrareg" // LOO
    "melaka" // MKZ
    "melalan" // GHS
    "melen" // VAN
    "melfi" // MEF
    "melilla" // MLN
    "melinda" // MDB
    "mellah" // AAE
    "mellal" // BEM
    "melonguane" // MNA
    "melsbroek" // BRU
    "melton" // WML
    "melville" // DOM
    "memanbetsu" // MMB
    "memmingen" // FMM
    "mena" // UMZ
    "menara" // RAK
    "mendeleevo" // DEE
    "mendeleyevo" // DEE
    "menderes" // ADB
    "mendez" // CVM
    "mendivil" // AYP
    "menier" // YPN
    "menominee" // MNM
    "menongue" // SPP
    "menorca" // MAH
    "menucos" // LMD
    "mer" // BBV
    "merced" // MCE
    "mercedes" // MDX
    "mercedita" // PSE
    "meri" // TLL
    "merida" // MID
    "meridian" // MEI
    "merignac" // BOD
    "merimbula" // MIM
    "merino" // SCL
    "merkel" // SCD
    "merle" // CDV
    "merlyn" // YHY
    "merowe" // MWE
    "mersa" // MUH
    "mersing" // MEP
    "meselia" // MFZ
    "mesquita" // GGH
    "mesquite" // MFH
    "messali" // TLM
    "messaoud" // HME
    "messina" // MEZ
    "meta" // LMC
    "metro" // DTW
    "mettel" // CEV
    "metz" // ETZ
    "meucon" // VNE
    "mexicali" // MXL
    "meythet" // NCY
    "mez" // UMZ
    "mfuwe" // MFU
    "mge" // MGN
    "mgtk" // FRS
    "mhm" // LMA
    "mial" // BOM
    "miandrivazo" // ZVA
    "mianyang" // MIG
    "michael" // SMK
    "michel" // YGP
    "michelena" // VLN
    "mickelson" // FFM
    "middlemount" // MMM
    "middleton" // MDO
    "middletown" // MWO
    "midlands" // EMA
    "midway" // MDW
    "mifflin" // RED
    "migalovo" // KLD
    "mihail" // CND
    "miho" // YGJ
    "mike" // YEV
    "mikkeli" // MIK
    "mikonos" // JMK
    "milas" // BJV
    "mildred" // NML
    "mildura" // MQL
    "mile" // POM
    "miley" // BPI
    "milford" // MFN
    "mili" // MIJ
    "milingimbi" // MGT
    "militar" // LEN
    "millard" // MIQ
    "millington" // NQA
    "millinocket" // MLT
    "millville" // MIV
    "milos" // MLO
    "milton" // HTS
    "minangkabau" // PDG
    "minatitlan" // MTT
    "minch" // AMH
    "minchumina" // LMA
    "minden" // MEV
    "mindoro" // VGN
    "mineral" // MWL
    "mineralnye" // MRV
    "mines" // LAX
    "mineta" // SJC
    "mingan" // YLP
    "minggang" // XAI
    "mingyueshan" // YIC
    "minj" // MZN
    "minna" // MXJ
    "minneapolis" // MSP
    "minot" // MOT
    "minsk" // MSQ
    "minter" // MIT
    "minto" // MNT
    "minute" // MMN
    "minvoul" // MVX
    "mipl" // NAG
    "miquelon" // MQC
    "mirabel" // YMX
    "mirabilis" // MSZ
    "mirador" // PUX
    "miraflores" // MFS
    "miramar" // MJR
    "miramichi" // YCH
    "mirecourt" // EPL
    "miri" // MYY
    "mirim" // GJM
    "mirny" // MJZ
    "misawa" // MSJ
    "misima" // MIS
    "miskolc" // MCQ
    "misrata" // MRA
    "missoula" // MSO
    "mitiaro" // MOI
    "mitiga" // MJI
    "mitrovica" // SMC
    "mitu" // MVP
    "mitzpe" // MIP
    "miyakejima" // MYE
    "miyako" // MMY
    "miyanmin" // MPX
    "miyazaki" // KMI
    "mizan" // MTF
    "mlk" // GHS
    "mln" // LNU
    "mmia" // LOS
    "mmtb" // TGZ
    "mnh" // HIM
    "moa" // JIO
    "moabi" // MGX
    "moala" // MFJ
    "moanda" // MFF
    "moba" // BDV
    "mobridge" // MBG
    "mochis" // LMM
    "mocimboa" // MZB
    "mocopulli" // MHC
    "mod" // LYE
    "modena" // ZMO
    "modesto" // MOD
    "modiano" // BZC
    "modlin" // WMI
    "moengo" // MOJ
    "moenjodaro" // MJD
    "moffat" // CIG
    "mogadishu" // MGQ
    "mogador" // ESU
    "moganshan" // DEQ
    "moghan" // PFQ
    "mogilev" // MVQ
    "mohammad" // MED
    "mohammed" // CMN
    "mohave" // IGM
    "mohe" // OHE
    "moheli" // NWA
    "moi" // MBA
    "moines" // DSM
    "moisant" // MSY
    "mokha" // UKR
    "mokhdum" // RJH
    "mokhotlong" // MKH
    "mokhtar" // BMW
    "moki" // MJJ
    "mokpo" // MPK
    "mokuti" // OKU
    "molde" // MOL
    "mole" // LTT
    "moller" // PML
    "molokai" // MKK
    "moma" // MQJ
    "momeik" // MOE
    "momote" // MAS
    "mon" // VLY
    "monaco" // MCM
    "monagas" // MUN
    "monastir" // MIR
    "monbetsu" // MBE
    "monclova" // LOV
    "moncton" // YQM
    "mondulkiri" // MWV
    "monflorite" // HSK
    "mong" // MOG
    "monghsat" // MOG
    "mongo" // MVO
    "mongu" // MNR
    "monica" // SMO
    "monmouth" // BLM
    "mono" // MNY
    "mons" // XSJ
    "monsenor" // SAL
    "montauk" // MTP
    "montbeliard" // XMF
    "monteagudo" // MHW
    "montecorvino" // QSR
    "montego" // MBJ
    "montelibano" // MTB
    "monterey" // MRY
    "monteria" // MTR
    "monterrey" // MTY
    "montez" // BRX
    "montichiari" // VBS
    "monto" // MNQ
    "montoir" // SNR
    "montoro" // GRU
    "montpellier" // MPL
    "montreuil" // CHM
    "montrose" // MTJ
    "monument" // PHQ
    "moomba" // MOO
    "moon" // HAF
    "mooney" // BTM
    "moorabbin" // MBW
    "moorea" // MOZ
    "moosonee" // YMO
    "mopah" // MKQ
    "mopti" // MZI
    "mora" // MXX
    "morafenobe" // TVA
    "moranbah" // MOV
    "morava" // KVO
    "morawa" // MWB
    "moree" // MRZ
    "morehead" // MHY
    "morela" // PBE
    "morelia" // MLM
    "moresby" // POM
    "morgantown" // MGW
    "morlaix" // MXN
    "mornington" // ONG
    "moro" // MXH
    "moroak" // MRT
    "morombe" // MXM
    "moron" // MXV
    "morondava" // MOQ
    "morrisville" // MVL
    "morrosquillo" // TLU
    "moruya" // MYA
    "moses" // MOS
    "moshi" // QSI
    "moshoeshoe" // MSU
    "mosjoen" // MJF
    "mosjøen" // MJF
    "moss" // RYG
    "mossendjo" // MSX
    "mostaganem" // MQV
    "mostar" // OMO
    "mostepha" // BLJ
    "mosul" // OSM
    "mota" // MTV
    "mott" // MHS
    "motueka" // MZP
    "moucha" // MHI
    "moue" // ILP
    "moufdi" // GHA
    "mougulu" // GUV
    "mouila" // MJL
    "moulay" // ERH
    "mould" // YMD
    "moultrie" // MGR
    "moundou" // MQQ
    "mouyondzi" // MUY
    "mov" // PKB
    "moxos" // SNM
    "moyale" // OYL
    "moyo" // OYG
    "moyobamba" // MBP
    "mpanda" // NPY
    "mpoa" // OGM
    "mprh" // RIH
    "mpumalanga" // MQP
    "mqabuko" // BUQ
    "mrao" // TTQ
    "mswati" // SHO
    "mthatha" // UTT
    "mtwara" // MYW
    "muan" // MWX
    "muanda" // MNB
    "muara" // BUU
    "muc" // FMO
    "mucuri" // MVS
    "muda" // BTJ
    "mudanjiang" // MDG
    "mudgee" // DGE
    "mudhole" // CDV
    "mueang" // DMK
    "mueda" // MUD
    "mueo" // PDC
    "muhammed" // LOS
    "mui" // MUJ
    "mujeres" // ISJ
    "mukah" // MKM
    "mukeiras" // UKR
    "muko" // MPC
    "mukomuko" // MPC
    "mulatupo" // MPP
    "mulege" // MUG
    "mulheim" // ESS
    "mulhouse" // EAP
    "mulika" // JJM
    "mulilo" // MPA
    "mullewa" // MXU
    "multan" // MUX
    "mulu" // MZV
    "mumbai" // BOM
    "munbil" // LNF
    "mundo" // FRS
    "munduku" // MDM
    "munich" // MUC
    "munoz" // SJU
    "munro" // YHM
    "munster" // FMO
    "murdale" // MDH
    "mures" // TGM
    "murieta" // RIU
    "murillo" // NQU
    "murmansk" // MMK
    "murrell" // MOR
    "murrin" // WUI
    "murtala" // LOS
    "musa" // AEU
    "muscat" // MCT
    "muscatine" // MUT
    "muskegon" // MKG
    "muskoka" // YQA
    "muskrat" // MSA
    "musoma" // MUZ
    "mustelier" // GER
    "mustique" // MQS
    "mutare" // UTA
    "mutiara" // PLW
    "mutis" // BSC
    "muttaburra" // UTB
    "muzaffarabad" // MFG
    "muzzafarpur" // MZU
    "mwadui" // MWN
    "mwanga" // LVI
    "mwansa" // NLA
    "mwanza" // MWZ
    "mweka" // MEW
    "myeik" // MGZ
    "myers" // TMA
    "myitkyina" // MYT
    "mykolaiv" // NLV
    "mykonos" // JMK
    "myrtle" // MYR
    "mysore" // MYQ
    "mystery" // ZZF
    "mytilene" // MJT
    "myvatn" // MVA
    "myxg" // NMC
    "myxy" // DCT
    "mzuzu" // ZZU
    "nabire" // NBX
    "nacala" // MNC
    "nachingwea" // NCH
    "nadi" // NAN
    "nadim" // BTH
    "nador" // NDR
    "nadunumu" // NDN
    "nadym" // NYM
    "nadzab" // LAE
    "naga" // WNP
    "nagasaki" // NGS
    "nagoya" // NKM
    "nagpur" // NAG
    "nahud" // NUD
    "naia" // MNL
    "naicm" // MEX
    "naif" // ELQ
    "nain" // YDP
    "naini" // NNS
    "nainital" // PGH
    "nairobi" // NBO
    "najaf" // NJF
    "najran" // EAM
    "nakashibetsu" // SHB
    "nakhchivan" // NAJ
    "nakina" // YQN
    "nakuru" // NUU
    "nal" // BKB
    "nalati" // NLT
    "nalchik" // NAL
    "namangan" // NMA
    "namatanai" // ATN
    "namibe" // MSZ
    "namlea" // NAM
    "namorik" // NDK
    "nampula" // APL
    "namrole" // NRE
    "namsang" // NMS
    "namsos" // OSY
    "namtha" // LXG
    "namtu" // NMT
    "namur" // QNM
    "namutoni" // NNI
    "nan" // NNT
    "nanchang" // KHN
    "nanchong" // NAO
    "nanded" // NDC
    "nang" // DAD
    "nanga" // NPO
    "nangan" // LZN
    "nangasuri" // BJK
    "nanjing" // NKG
    "nanki" // SHM
    "nankina" // NKN
    "nanning" // NNG
    "nanniwan" // ENY
    "nantes" // NTE
    "nantong" // NTG
    "nantucket" // ACK
    "nanuque" // NNU
    "nanwalek" // KEB
    "nanyuan" // NAY
    "nanyue" // HNY
    "nanyuki" // NYK
    "naone" // MWF
    "napa" // APC
    "napakiak" // WNA
    "napaskiak" // PKA
    "napier" // NPE
    "napoca" // CLJ
    "napoli" // NAP
    "napuka" // NAU
    "naracoorte" // NAC
    "naranjo" // ENJ
    "narathiwat" // NAW
    "nare" // NAR
    "nargana" // NGN
    "narimanovka" // KSN
    "narimanovo" // ASF
    "narino" // PSO
    "nariqo" // PSO
    "narita" // NRT
    "narrabri" // NAA
    "narrandera" // NRA
    "narrogin" // NRG
    "narromine" // QRM
    "nartron" // RCT
    "narvik" // EVE
    "naryan" // NNM
    "nasa" // QQS
    "nasca" // NZC
    "nashik" // ISK
    "nashua" // ASH
    "nashville" // BNA
    "nasik" // ISK
    "nasir" // MLE
    "nasogaluak" // YSY
    "nassau" // NAS
    "natal" // NAT
    "natashquan" // YNA
    "natchez" // HEZ
    "nathong" // NEU
    "nation" // LNN
    "natitingou" // NAE
    "natl" // IAO
    "natrona" // CPR
    "natuashish" // YNP
    "nauru" // INU
    "nausori" // SUV
    "navoi" // NVI
    "naw" // LQN
    "nawabshah" // WNS
    "naxos" // JNX
    "nay" // NYT
    "nayak" // PAT
    "nayef" // ELQ
    "naypyidaw" // NYT
    "naz" // SRY
    "nazaire" // SNR
    "nazarbayev" // NQZ
    "nazrul" // RDP
    "ndia" // DOH
    "ndjole" // KDJ
    "ndola" // NLA
    "nea" // VOL
    "necochea" // NEC
    "necocli" // NCI
    "needham" // YYO
    "needles" // EED
    "nefta" // TOE
    "neftekamsk" // NEF
    "nefteyugansk" // NFG
    "nega" // MQX
    "negage" // GXG
    "negarbo" // GBF
    "neghelle" // EGL
    "negras" // PDS
    "negril" // NEG
    "neil" // AXV
    "neill" // ONL
    "neiva" // NVA
    "nejad" // MHD
    "nejran" // EAM
    "nek" // UNE
    "nekemte" // NEK
    "nelspruit" // NLP
    "nema" // EMN
    "nemiscau" // YNS
    "nenana" // ENN
    "nene" // TIA
    "neom" // NUM
    "neosho" // EOS
    "nepalgunj" // KEP
    "nera" // USR
    "neredin" // OLO
    "nerlerit" // CNP
    "nero" // BBV
    "nervino" // NVN
    "nervo" // TPQ
    "nery" // ARE
    "netaji" // CCU
    "neu" // CIN
    "neua" // NEU
    "neubrandenburg" // FNB
    "neuchatel" // QNC
    "neuman" // NZC
    "nevers" // NVS
    "neves" // CNF
    "nevsehir" // NAV
    "newark" // EWR
    "newbery" // AEP
    "newenham" // EHM
    "newman" // ZNE
    "newnam" // ESN
    "newquay" // NQY
    "news" // PHF
    "newstrom" // GPZ
    "newtok" // WWT
    "nez" // LWS
    "ngaoundere" // NGE
    "ngari" // NGQ
    "ngau" // NGI
    "nggatokae" // GTA
    "ngloram" // CPF
    "ngo" // NKM
    "ngoma" // ZGM
    "ngorangora" // IRA
    "ngukurr" // RPM
    "ngurah" // DPS
    "nhat" // SGN
    "nhưt" // SGN
    "niamey" // NIM
    "niamtougou" // LRL
    "niau" // NIU
    "nibandera" // PUM
    "nicaro" // ICR
    "nice" // NCE
    "nicolau" // DIL
    "nicoya" // NCT
    "nido" // ENI
    "nielsen" // YXY
    "nifty" // NIF
    "nightmute" // NME
    "niigata" // KIJ
    "nikola" // BEG
    "nikolai" // NIB
    "nikolayevsk" // NLI
    "nikos" // HER
    "nikunau" // NIG
    "nimba" // NIA
    "nimes" // FNI
    "ningbo" // NGB
    "ningerum" // NGR
    "ninglang" // NLH
    "ningyuan" // ZQZ
    "ninh" // VDO
    "nino" // CHX
    "ninoy" // MNL
    "nioki" // NIO
    "nioro" // NIX
    "niquelandia" // NQL
    "nis" // INI
    "nishi" // HIW
    "nissan" // IIS
    "niuafoʻou" // NFO
    "niuatoputapu" // NTT
    "niveyro" // CNQ
    "nizhnevartovsk" // NJC
    "nizhny" // GOJ
    "nkaus" // NKU
    "nkolo" // NKL
    "nkomo" // BUQ
    "nkongsamba" // NKS
    "nkumbula" // LVI
    "nnamdi" // ABV
    "noatak" // WTK
    "nogliki" // NGK
    "noi" // HAN
    "noire" // PNR
    "nomad" // NOM
    "nome" // OME
    "nondalton" // NNL
    "nonouti" // NON
    "noor" // BDJ
    "nora" // YPC
    "noranda" // YUY
    "norberto" // RGL
    "nordfjordur" // NOR
    "nordholz" // FCN
    "noriega" // CPX
    "normal" // BMI
    "normandie" // DOL
    "normanton" // NTN
    "noronha" // FEN
    "norridgewock" // OWK
    "norrkoping" // NRK
    "norseman" // NSM
    "norsup" // NUS
    "northeastern" // EDE
    "northrop" // HHR
    "northway" // ORT
    "norway" // YNE
    "norwich" // NWI
    "norwood" // OWD
    "norðfjorður" // NOR
    "nosara" // NOB
    "noshahr" // NSH
    "noshiro" // ONJ
    "notodden" // NTB
    "notohadinegoro" // JBB
    "nouadhibou" // NDB
    "nouakchott" // NKC
    "noumerat" // GHA
    "noumerate" // GHA
    "nouna" // XNU
    "nouzha" // ALY
    "nov" // TBJ
    "novas" // CLV
    "november" // BUG
    "noviembre" // RYO
    "nowata" // NWT
    "noyabrsk" // NOJ
    "nsimalen" // NSI
    "nubia" // MZL
    "nuguria" // NUG
    "nuiqsut" // NUI
    "nukuataha" // NHV
    "nukuhiva" // NHV
    "nukus" // NCU
    "nukutavake" // NUK
    "nulato" // NUL
    "number" // MXY
    "numbulwar" // NUB
    "nunapitchuk" // NUP
    "nunez" // CTG
    "nunukan" // NNX
    "nuqez" // CTG
    "nuqui" // NQU
    "nuremberg" // NUE
    "nuri" // VAS
    "nursultan" // NQZ
    "nusatupe" // GZO
    "nusawiru" // CJN
    "nut" // VCB
    "nutuve" // NUT
    "nuuk" // GOH
    "nuys" // VNY
    "nyac" // ZNC
    "nyack" // BLU
    "nyagan" // NYA
    "nyak" // MEQ
    "nyala" // UYL
    "nyaung" // NYU
    "nyerere" // DAR
    "nyeri" // NYE
    "nyingchi" // LZY
    "nyngan" // NYN
    "nyurba" // NYR
    "nza" // NZC
    "nzagi" // NZA
    "nzerekore" // NZE
    "nzrv" // WIK
    "oak" // RDK
    "oakdale" // ODC
    "oakley" // CEY
    "oamaru" // OAM
    "oaxaca" // OAX
    "obaldia" // PUE
    "oban" // OBN
    "obbia" // CMO
    "obeid" // EBD
    "oberpfaffenhofen" // OBF
    "obihiro" // OBO
    "obispo" // SBP
    "obo" // OBX
    "obock" // OBC
    "obre" // YDW
    "obregon" // CEN
    "ocala" // OCF
    "ocana" // OCV
    "oceanside" // OCN
    "oconee" // CEU
    "octeville" // LEH
    "odate" // ONJ
    "odessa" // ODS
    "odienne" // KEO
    "oduber" // LIR
    "odysseas" // MJT
    "oecusse" // OEC
    "oedw" // DWD
    "oenpelli" // OPI
    "oesman" // LAH
    "oeste" // SQX
    "ogden" // OGD
    "ogdensburg" // OGS
    "ogeranang" // OGE
    "ogilvie" // JDA
    "ogle" // OGL
    "ogobsucum" // OGM
    "ogoki" // YOG
    "oguzeli" // GZT
    "ohakea" // OHA
    "ohkay" // ESO
    "ohrid" // OHD
    "oita" // OIT
    "ojeda" // LUQ
    "okadama" // OKD
    "okao" // OKV
    "okaukuejo" // OKF
    "okayama" // OKJ
    "okb" // OCN
    "okecie" // WAW
    "okeechobee" // OBE
    "okha" // OHH
    "okinoerabu" // OKE
    "okmulgee" // OKM
    "okoboji" // RTL
    "okondja" // OKN
    "okoyo" // OKG
    "oksapmin" // OKP
    "oksibil" // OKL
    "oktyabrsky" // OKT
    "okushiri" // OIR
    "ola" // JOK
    "olafsfjorður" // OFJ
    "olanchito" // OAN
    "olano" // PCR
    "olavarria" // OVR
    "olaya" // EOH
    "olbia" // OLB
    "olean" // OLE
    "olenyok" // ONK
    "olgii" // ULG
    "olimpo" // OLK
    "olive" // OLV
    "oliveira" // PVH
    "olivera" // PIO
    "ollombo" // OLL
    "olmedo" // GYE
    "olomouc" // OLO
    "olpoi" // OLJ
    "olson" // CYS
    "olympia" // OLM
    "olympic" // OLP
    "olyokminsk" // OLZ
    "omak" // OMK
    "omar" // MVB
    "omboue" // OMB
    "omega" // OMG
    "omiros" // JKH
    "omora" // OSE
    "omsk" // OMS
    "onassis" // KIT
    "ondangwa" // OND
    "ondimba" // MVB
    "ondjiva" // VPE
    "oneida" // RHI
    "oneonta" // ONH
    "ongay" // CPE
    "onizuka" // KOA
    "ono" // ONU
    "onotoa" // OOT
    "onslow" // ONS
    "oodnadatta" // OOD
    "opa" // OPF
    "opale" // LTQ
    "opapimiskan" // YBS
    "opelika" // AUO
    "open" // OPB
    "opuwa" // OPW
    "oradea" // OMR
    "oral" // URA
    "oram" // RAX
    "orangeburg" // OGB
    "oranjemund" // OMD
    "orapa" // ORP
    "orbost" // RBS
    "orcas" // ESD
    "orchard" // ORD
    "ordaz" // PVR
    "ordos" // DSN
    "ordu" // OGU
    "orebro" // ORB
    "oregon" // OTH
    "orellana" // OCC
    "orenburg" // REN
    "orestes" // MOA
    "orford" // CPI
    "oria" // OTY
    "oriel" // TJA
    "orillia" // YLK
    "orinduik" // ORJ
    "orinoco" // CXA
    "orio" // BGY
    "oristano" // FNU
    "oriximina" // ORX
    "orland" // OLA
    "orly" // ORY
    "ormara" // ORW
    "ormoc" // OMC
    "ornskoldsvik" // OER
    "orocue" // ORC
    "oroville" // OVE
    "orsk" // OSW
    "orsta" // HOV
    "ortiz" // IGO
    "orumiyeh" // OMH
    "oryahovitsa" // GOZ
    "oryol" // OEL
    "osa" // BAI
    "osaka" // ITM
    "oscar" // SAL
    "oscoda" // OSC
    "osh" // OSS
    "oshakati" // OHI
    "oshawa" // YOO
    "osijek" // OSI
    "oskemen" // UKK
    "oslo" // OSL
    "osmani" // ZYL
    "osmany" // ZYL
    "osnabruck" // FMO
    "ostafyevo" // OSF
    "ostend" // OST
    "osvaldo" // OXB
    "oswaldo" // AGV
    "oti" // MOF
    "otjiwarongo" // OTJ
    "otto" // TXL
    "ottumwa" // OTM
    "ouadda" // ODA
    "ouagadougou" // OUA
    "ouahigouya" // OUG
    "ouakda" // BSK
    "ouanaham" // LIF
    "ouanda" // ODJ
    "ouango" // OFI
    "ouani" // AJN
    "ouargla" // OGX
    "ouarzazate" // OZZ
    "oudomsay" // ODY
    "oued" // HME
    "ouesso" // OUE
    "ouloup" // UVE
    "oulu" // OUL
    "oulunsalo" // OUL
    "oum" // QMH
    "oumtounsy" // NKC
    "ourinhos" // OUS
    "ouro" // PDD
    "outlaw" // CKV
    "ouvea" // UVE
    "ouverture" // PAP
    "ouyen" // OYN
    "ouzinkie" // KOZ
    "ovda" // VDA
    "owainat" // GSQ
    "owando" // FTX
    "owaynat" // GSQ
    "owens" // CUB
    "owensboro" // OWB
    "owingeh" // ESO
    "oyapock" // OYP
    "oybd" // BYD
    "oyem" // OYE
    "oymk" // UKR
    "oyo" // OLL
    "oyunsky" // YKS
    "ozamiz" // OZC
    "ozar" // ISK
    "ozark" // WMH
    "paama" // PBJ
    "paamiut" // JFR
    "pabon" // VLM
    "pac" // ESG
    "pacifico" // BLB
    "padang" // MJU
    "paderborn" // PAD
    "paderewski" // BZG
    "padilla" // RCH
    "pafos" // PFO
    "pagadian" // PAG
    "pago" // PPG
    "pai" // PYY
    "paiela" // PLE
    "paine" // PAE
    "paipa" // RON
    "pais" // HOG
    "paix" // PAX
    "pajala" // PJA
    "pajas" // COR
    "pakdi" // PXR
    "pakhokku" // PKK
    "pakistan" // HDD
    "pakning" // SEQ
    "pakokku" // PKK
    "pakse" // PKZ
    "pakuba" // PAF
    "pakyong" // PYG
    "pala" // PLF
    "palam" // DEL
    "palanga" // PLQ
    "palangos" // PLQ
    "palanka" // SPL
    "palapye" // QPH
    "palena" // WAP
    "palenque" // PQM
    "palermo" // PMO
    "palese" // BRI
    "palmares" // MCZ
    "palmdale" // PMD
    "palmerston" // PMR
    "palms" // TNP
    "palmyra" // PMS
    "paloich" // HGI
    "palonegro" // BGA
    "palopo" // LLO
    "paltaniemi" // KAJ
    "palungtar" // GKH
    "palwaukee" // PWK
    "palyvestre" // TLN
    "pama" // XPA
    "pamandzi" // DZA
    "pamanzi" // DZA
    "pambwa" // PAW
    "pamol" // PAY
    "pamplona" // PNA
    "pampulha" // PLU
    "pamti" // MYT
    "pan" // SXN
    "panama" // BLB
    "pancevo" // QBG
    "pangborn" // EAT
    "pangkor" // PKG
    "panglao" // TAG
    "pangnirtung" // YXP
    "pangsuma" // PSU
    "panguilemo" // TLX
    "panguitch" // PNU
    "panigale" // BLQ
    "panjgur" // PJG
    "panlong" // GYS
    "pantelleria" // PNL
    "pantnagar" // PGH
    "panzhihua" // PZI
    "papadiamandis" // JSI
    "paphos" // PFO
    "papondetta" // EIA
    "pappy" // COE
    "paraburdoo" // PBO
    "parachinar" // PAJ
    "paradise" // PYS
    "paraiso" // IPN
    "parakou" // PKO
    "param" // PPX
    "paramillo" // SCI
    "paranavai" // PVI
    "paraparaumu" // PPQ
    "parasi" // PRS
    "parbo" // KRC
    "parchim" // SZW
    "pardubice" // PED
    "paredes" // FLA
    "parintins" // PIN
    "parish" // OPL
    "parkersburg" // PKB
    "parkes" // PKE
    "parks" // CPS
    "parlin" // NWH
    "parma" // PMF
    "parme" // PMF
    "parnu" // EPU
    "paro" // PBH
    "parry" // YPD
    "parsa" // PFQ
    "parsabad" // PFQ
    "parsabade" // PFQ
    "paruima" // PRR
    "paruma" // PRR
    "pas" // YQD
    "pasadena" // BUR
    "pasco" // PSC
    "pascua" // VDP
    "pasia" // GSA
    "pasighat" // IXT
    "pasni" // PSI
    "passes" // YWQ
    "pastine" // CIA
    "pasto" // PSO
    "pat" // GUM
    "patagones" // CPG
    "patan" // BIT
    "patel" // AMD
    "pathankot" // IXP
    "pathein" // BSX
    "patna" // PAT
    "patnaik" // BBI
    "pato" // PTO
    "patos" // POJ
    "patreksfjordur" // PFJ
    "patreksfjorður" // PFJ
    "pattani" // PAN
    "pattaya" // PYX
    "pattimura" // AMQ
    "pauk" // PAU
    "paula" // SZP
    "paulatuk" // YPC
    "paulista" // BJP
    "pauls" // SVM
    "pavlodar" // PWQ
    "payam" // PYK
    "payne" // MLW
    "pays" // BIQ
    "paysandu" // PDU
    "payson" // PJB
    "pbv" // STG
    "pbx" // PVL
    "peachtree" // PDK
    "pearse" // TIU
    "pease" // PSM
    "peawanuck" // YPO
    "pechora" // PEX
    "peconic" // CTO
    "pecs" // PEV
    "pedernales" // PDZ
    "pedrera" // LPD
    "pedy" // CPD
    "peelamedu" // CJB
    "peinador" // VGO
    "pekoa" // SON
    "pelaneng" // PEL
    "pellston" // PLN
    "pelotas" // PET
    "pelser" // KXE
    "peluda" // ABV
    "pembina" // PMB
    "pembroke" // YTA
    "pembuang" // KLP
    "pen" // KTP
    "penang" // PEN
    "penarlag" // CEG
    "penasco" // PPE
    "pender" // YPT
    "pendopo" // PDO
    "pengel" // PBM
    "penggung" // CBN
    "penglai" // YNT
    "penh" // PNH
    "peninsula" // ABM
    "pennsylvania" // THV
    "pensacola" // PNS
    "penticton" // YYF
    "penza" // PEZ
    "peoria" // PIA
    "per" // QGY
    "peralta" // CIO
    "perancis" // RDZ
    "perce" // LWS
    "perdanakusuma" // HLP
    "peredo" // AGU
    "peretola" // FLR
    "perigord" // EGC
    "perigueux" // PGX
    "perison" // YJM
    "perito" // PMQ
    "perlas" // SIC
    "peron" // NQN
    "peronne" // XSJ
    "perpignan" // PGF
    "perrin" // PNX
    "perryville" // KPV
    "persian" // PGU
    "person" // TDF
    "perth" // PER
    "pertini" // TRN
    "peru" // SMG
    "perugia" // PEG
    "pescara" // PSR
    "peshawar" // PEW
    "pesqueira" // HMO
    "petawawa" // YWA
    "peten" // TKM
    "peter" // TPF
    "peterborough" // YPQ
    "petit" // MPJ
    "petra" // KBR
    "petrolina" // PNZ
    "petropavl" // PPK
    "petropavlovsk" // PKC
    "petrozavodsk" // PES
    "pettirossi" // ASU
    "pevek" // PWE
    "phabang" // LPQ
    "phaeton" // FLT
    "phalaborwa" // PHW
    "phanom" // KOP
    "phaplu" // PPL
    "phare" // IDY
    "phetchabun" // PHY
    "phikwe" // PKW
    "philibert" // MJN
    "phitsanulok" // PHS
    "phnom" // PNH
    "phrae" // PRH
    "phuket" // HKT
    "piar" // PZO
    "piarco" // POS
    "piazzolla" // MDQ
    "picardie" // BYF
    "pichoy" // ZAL
    "pickens" // LQK
    "pickle" // YPL
    "picos" // PCS
    "picton" // PCN
    "piedras" // PDS
    "pienaar" // KMH
    "pierrefonds" // ZSE
    "pierrestegui" // COC
    "piestany" // PZY
    "pietarsaari" // KOK
    "pieter" // GRJ
    "pietermaritzburg" // PZB
    "pigeon" // GKT
    "pignon" // PGN
    "pigue" // PIG
    "pikangikum" // YPM
    "pikwitonei" // PIW
    "pilanesberg" // NTY
    "pilar" // PIL
    "piloto" // RGL
    "pimaga" // PMP
    "pimenta" // PBQ
    "pinang" // DUM
    "pinar" // QPD
    "pincher" // WPC
    "pindling" // NAS
    "pindo" // MTB
    "pinedo" // AYX
    "pinehouse" // ZPO
    "piney" // BPI
    "pingtung" // PIF
    "pinheiro" // PHI
    "pinilla" // ADZ
    "pinillos" // TRU
    "pinoh" // NPO
    "pins" // ILP
    "pioneer" // VDZ
    "piper" // LHV
    "piragine" // CNQ
    "pirie" // PPI
    "pirineos" // HSK
    "pirkkala" // TMP
    "pisa" // PSA
    "pisco" // PIO
    "pistarini" // EZE
    "pitalito" // PTX
    "pithoragarh" // NNS
    "pitka" // GAL
    "pitkin" // ASE
    "pitre" // PTP
    "pitt" // YPK
    "pittsburgh" // PIT
    "pittsfield" // PSF
    "pitu" // OTI
    "piura" // PIU
    "place" // ORD
    "placencia" // PLJ
    "placeres" // BUV
    "placerville" // PVF
    "placid" // LKP
    "plaisance" // MRU
    "plan" // SLW
    "plate" // VMI
    "platinum" // PTU
    "plato" // PLT
    "platon" // YKS
    "platov" // ROV
    "platte" // LBF
    "platteville" // PVB
    "plattsburgh" // PBG
    "playon" // PYC
    "plaza" // TJA
    "pleiku" // PXU
    "pleso" // ZAG
    "pleurtuit" // DNR
    "plock" // QPC
    "ploujean" // MXN
    "pluguffan" // UIP
    "plumerillo" // MDZ
    "pobedilovo" // KVX
    "pocatello" // PIH
    "podgorica" // TGD
    "podkamennaya" // TGP
    "podlaska" // BXP
    "pogany" // PEV
    "pogogul" // UDL
    "pogue" // OWP
    "pohang" // KPO
    "pohnpei" // PNI
    "points" // YNL
    "poitiers" // PIS
    "pokhara" // PKR
    "poko" // BGF
    "pol" // ARE
    "polacca" // PXL
    "polando" // HYA
    "polatkan" // AOE
    "polo" // VCE
    "polokwane" // PTG
    "poltava" // PLV
    "polyarny" // PYJ
    "pomalaa" // PUM
    "pomorskie" // OSZ
    "pompano" // PPM
    "ponca" // PNC
    "ponce" // LOH
    "ponciano" // SLP
    "pond" // YIO
    "pondicherry" // PNY
    "pondok" // PCB
    "pontecagnano" // QSR
    "pontiac" // PTK
    "pontoise" // POX
    "popayan" // PPN
    "pope" // GFD
    "popondetta" // EIA
    "poprad" // TAT
    "poptun" // PON
    "pora" // PMG
    "porbandar" // PBD
    "poretta" // BIA
    "porfiada" // SMB
    "pori" // POR
    "pormpuraaw" // EDR
    "portblair" // IXZ
    "porte" // LPO
    "portela" // LIS
    "porter" // VPZ
    "porterville" // PTV
    "portimao" // PRM
    "portoroz" // POW
    "porvenir" // PVE
    "posada" // ESR
    "postville" // YSO
    "potomac" // VKX
    "potosi" // SLP
    "pottstown" // PTW
    "pou" // UAP
    "pouliot" // YGP
    "pounds" // TYR
    "pouso" // PPY
    "power" // YTS
    "poza" // PAZ
    "poznan" // POZ
    "prabang" // LPQ
    "prado" // MZA
    "prague" // PRG
    "praha" // PRG
    "praslin" // PRI
    "prat" // BCN
    "pratt" // PTT
    "prayagraj" // IXD
    "prefectural" // NKM
    "prefeito" // PHB
    "preguica" // SNE
    "prentice" // PRW
    "prerov" // PRV
    "prescott" // PRC
    "presetto" // FRC
    "presidencia" // PRQ
    "prestwick" // PIK
    "preto" // SJP
    "preturo" // QAQ
    "preveza" // PVK
    "price" // TPR
    "primavera" // LPE
    "primer" // PRQ
    "primo" // LOM
    "princesa" // PPS
    "princess" // SXM
    "princeville" // HPV
    "principal" // GYE
    "principe" // PCP
    "prineville" // PRZ
    "pristina" // PRN
    "private" // SCI
    "procopio" // CKO
    "prof" // ESG
    "professor" // SJK
    "progar" // PGB
    "progreso" // RFR
    "progresso" // NPR
    "prominent" // PXH
    "proserpine" // PPP
    "prospect" // PPC
    "provence" // MRS
    "providence" // PID
    "providencia" // PVA
    "providenciales" // PLS
    "provideniya" // PVS
    "provincetown" // PVC
    "provo" // PVU
    "prudente" // PPB
    "pryor" // DCU
    "pskov" // PKV
    "pto" // PEM
    "pucallpa" // PCL
    "pucnik" // LJU
    "pucon" // ZPC
    "pucu" // FMA
    "pudahuel" // SCL
    "pudong" // PVG
    "puducherry" // PNY
    "puduchery" // PNY
    "pue" // OGM
    "puebla" // PBC
    "pueblo" // PUB
    "puka" // PKP
    "pukaki" // TWZ
    "pukapuka" // PKP
    "pukarua" // PUK
    "pukatawagan" // XPK
    "pula" // PUY
    "pulkovo" // LED
    "pulliam" // FLG
    "pullman" // PUW
    "pumani" // PMN
    "pumarejo" // VUP
    "pune" // PNQ
    "punia" // PUN
    "puning" // CDE
    "puntarenas" // JAP
    "pupelde" // ZUD
    "purdue" // LAF
    "putao" // PBU
    "putumayo" // PYO
    "putuoshan" // HSN
    "puvirnituq" // YPX
    "puy" // LPY
    "puzhehei" // WNH
    "pvp" // SRL
    "pweto" // PWO
    "pyi" // NYT
    "pynt" // CNP
    "pyongyang" // FNJ
    "qaanaaq" // NAQ
    "qaarsut" // JQA
    "qabala" // GBB
    "qacha" // UNE
    "qaisumah" // AQI
    "qala" // LQN
    "qamdo" // BPX
    "qamishli" // KAC
    "qardho" // GSR
    "qarn" // RNM
    "qasim" // MUX
    "qassim" // BSA
    "qazvin" // GZW
    "qeshm" // GSM
    "qianjiang" // JIQ
    "qiaoli" // LFQ
    "qikiqtarjuaq" // YVM
    "qilian" // HBQ
    "qimei" // CMJ
    "qingshan" // XIC
    "qingyang" // IQN
    "qinhuangdao" // BPE
    "qionghai" // BAR
    "qiqihar" // NDG
    "qishn" // IHN
    "qiuci" // KCA
    "qiyang" // LYI
    "quad" // MLI
    "quaid" // KHI
    "quakertown" // UKT
    "qualicum" // XQU
    "quanzhou" // JJN
    "quaqtaq" // YQC
    "quartz" // AXS
    "quatro" // LAD
    "quebec" // YQB
    "queensland" // WEI
    "queenstown" // ZQN
    "quelimane" // UEL
    "quentin" // XSJ
    "quepos" // XQP
    "queretaro" // QRO
    "quesnel" // YQZ
    "quetta" // UET
    "quetzalcoatl" // NLD
    "quetzaltenango" // AAZ
    "quevillon" // YLS
    "qufu" // JNG
    "quibdo" // UIB
    "quiche" // AQB
    "quijada" // RGA
    "quillayute" // UIL
    "quilpie" // ULP
    "quimper" // UIP
    "quincy" // UIN
    "quinhagak" // KWN
    "quinn" // YBO
    "quinones" // CIX
    "quintero" // QTR
    "quirindi" // UIR
    "quiroga" // SRJ
    "quiros" // LIR
    "quiroz" // AUC
    "quoc" // PQC
    "quonset" // OQU
    "qurghonteppa" // KQT
    "quthing" // UTG
    "quzhou" // JUZ
    "rabah" // AAE
    "rabak" // KST
    "rabaraba" // RBP
    "rabi" // RBI
    "rach" // VKG
    "rachman" // MLG
    "racine" // RAC
    "radin" // TKG
    "radom" // RDO
    "raduzhny" // RAT
    "rae" // YRA
    "rafaela" // RAF
    "rafai" // RFA
    "rafha" // RAH
    "rafic" // BEY
    "rafsanjan" // RJN
    "ragusa" // DBV
    "raiatea" // RFP
    "rainbow" // YOP
    "raipur" // RPR
    "raisi" // PMO
    "raivavae" // RVV
    "raizet" // PTP
    "rajahmundry" // RJA
    "rajapaksa" // HRI
    "rajbiraj" // RJB
    "rajiv" // HYD
    "rajkot" // RAJ
    "rajouri" // RJI
    "rakanda" // RAA
    "ramagundam" // RMD
    "ramata" // RBV
    "ramdane" // BJA
    "ramechhap" // RHP
    "ramel" // TTU
    "ramgoolam" // MRU
    "ramingining" // RAM
    "ramos" // MPH
    "rampart" // RMP
    "ramsar" // RZR
    "rana" // MQN
    "ranau" // RNU
    "rancagua" // QRC
    "ranch" // AFN
    "ranchi" // IXR
    "rancho" // RIU
    "rand" // QRA
    "rangiroa" // RGI
    "ranh" // CXR
    "ranong" // UNN
    "rapid" // RAP
    "raroia" // RRR
    "rarotonga" // RAR
    "ras" // RKT
    "rasht" // RAS
    "ratanakiri" // RBE
    "ratchasima" // NAK
    "ratchathani" // UBP
    "ratmalana" // RML
    "ratnagiri" // RTC
    "ratulangi" // MDC
    "raufarhofn" // RFN
    "raul" // LUQ
    "ravenna" // RAN
    "ravensthorpe" // RVT
    "rawalakot" // RAZ
    "rawash" // KBL
    "rawl" // AHW
    "rawlins" // RWL
    "raymond" // TAB
    "rayo" // UPN
    "rayon" // UPN
    "rbk" // RBX
    "rclg" // RMQ
    "reading" // RDG
    "reagan" // DCA
    "reales" // PVO
    "reao" // REA
    "reap" // REP
    "rebun" // RBJ
    "recife" // REC
    "reconquista" // RCQ
    "recreational" // HEG
    "redang" // RDN
    "redbird" // RBD
    "redcliffe" // RCL
    "redding" // RDD
    "redencao" // RDC
    "redmond" // RDM
    "redzikowo" // OSP
    "reeve" // WIK
    "regency" // OJU
    "reggio" // REG
    "regina" // YQR
    "reiche" // NZC
    "reid" // RHV
    "reina" // TFS
    "rejon" // MID
    "reliance" // YFL
    "relizane" // QZN
    "rembele" // TXE
    "remedios" // OTU
    "renan" // PIO
    "rendani" // MKW
    "rene" // YHF
    "renhuai" // WMT
    "renmark" // RMK
    "rennell" // RNL
    "renner" // GLD
    "rennes" // RNS
    "renton" // RNT
    "republic" // FRG
    "repulse" // YUT
    "resende" // REZ
    "resistencia" // RES
    "resolute" // YRB
    "resolution" // YFR
    "resort" // XES
    "resorts" // TRM
    "retalhuleu" // RER
    "retiro" // SVI
    "reunion" // RUN
    "reus" // REU
    "revelstoke" // YRV
    "revoredo" // CJA
    "rexburg" // RXE
    "reykjahlid" // MVA
    "reykjavik" // RKV
    "reymont" // LCJ
    "reynosa" // REX
    "rgia" // HYD
    "rhein" // FRA
    "rhinelander" // RHI
    "rhodes" // RHO
    "rib" // MYN
    "ribas" // SIG
    "riberalta" // RIB
    "richardson" // YWG
    "rick" // AMA
    "rickenbacker" // LCK
    "rif" // OLI
    "riga" // RIX
    "right" // RHT
    "rigolet" // YRG
    "rih" // KWG
    "rijeka" // RJK
    "rimatara" // RMT
    "rimini" // RMI
    "rimouski" // YXK
    "rimpochee" // IXL
    "rinas" // TIA
    "rincon" // RDS
    "ringi" // RIN
    "ringway" // MAN
    "riohacha" // RCH
    "rioja" // RIJ
    "rionegro" // MDE
    "rishiri" // RIS
    "rivadavia" // CRD
    "rivers" // YRN
    "riverside" // RAL
    "riverton" // RIW
    "rivesaltes" // PGF
    "riviera" // ALL
    "rivieres" // YRQ
    "rivne" // RWN
    "riwut" // PKY
    "riyan" // RIY
    "rize" // QRI
    "rizhao" // RIZ
    "rizo" // BCA
    "rjnn" // NKM
    "rkc" // ROF
    "rnzaf" // OHA
    "roadside" // NTQ
    "roanoke" // ROA
    "roatan" // RTB
    "robb" // PKB
    "robbins" // HEE
    "robe" // GOB
    "roben" // WBR
    "robertsfield" // ROB
    "robertson" // ROD
    "roberval" // YRJ
    "robin" // DSA
    "robinvale" // RBC
    "robles" // PRB
    "robore" // RBO
    "rochambeau" // CAY
    "rockcliffe" // YRO
    "rockford" // RFD
    "rockwood" // RKW
    "rodeos" // TFN
    "rodez" // RDZ
    "rodney" // CPN
    "rodolfo" // MXL
    "rogelio" // CYW
    "roger" // GSP
    "rogue" // MFR
    "rohlsen" // STX
    "rohrer" // ROF
    "roissy" // CDG
    "rojo" // CBJ
    "rokot" // RKI
    "roldan" // APO
    "rolla" // VIH
    "rolpa" // RPA
    "romaine" // ZGS
    "romana" // LRM
    "romanzof" // CZF
    "romblon" // TBH
    "romero" // SAL
    "romualdez" // TAC
    "ronald" // DCA
    "ronaldo" // FNC
    "ronaldsway" // IOM
    "ronchi" // TRS
    "rondonopolis" // ROO
    "ronge" // YVC
    "rongelap" // RNP
    "ronne" // RNN
    "ronneby" // RNB
    "rooks" // RCP
    "roque" // PRQ
    "roques" // LRV
    "roros" // RRS
    "rorvik" // RVK
    "rosario" // ROS
    "roscoe" // CRX
    "roscommon" // HTL
    "roseburg" // RBG
    "rosecrans" // STJ
    "rosh" // RPN
    "roshchino" // TJM
    "rosita" // RFS
    "roskilde" // RKE
    "ross" // XRR
    "rossvoll" // MQN
    "rost" // RET
    "rostock" // RLG
    "roswell" // ROW
    "rota" // ROP
    "rotorua" // ROT
    "rotterdam" // RTM
    "rottnest" // RTS
    "rotuma" // RTA
    "rouen" // URO
    "rouge" // BTR
    "roumaniere" // EGC
    "round" // ZRJ
    "roundup" // RPX
    "rourkela" // RRK
    "rouyn" // YUY
    "rovaniemi" // RVN
    "rovirosa" // VSA
    "rowan" // SRW
    "rowley" // CKW
    "roxas" // RXS
    "royal" // FRR
    "rpww" // TDG
    "rubelsanto" // RUV
    "rubem" // URG
    "ruby" // RBY
    "rudeis" // AUE
    "rudine" // SPL
    "rudniki" // CZW
    "rudolf" // LKU
    "rugby" // RUG
    "rughenda" // RUE
    "ruhengeri" // RHG
    "ruinas" // RUY
    "rukumkot" // RUK
    "rumbek" // RBX
    "rumginae" // RMN
    "rumjatar" // RUM
    "run" // YIP
    "rundu" // NDU
    "rupsi" // RUP
    "rurrenabaque" // RBQ
    "rurutu" // RUR
    "rusjan" // MBX
    "russian" // RSH
    "rustaq" // MNH
    "rustaveli" // TBS
    "ruston" // RSN
    "ruti" // RUU
    "rutland" // RUT
    "ruzyne" // PRG
    "rygge" // RYG
    "ryoma" // KCZ
    "ryum" // RVK
    "rzeszow" // RZE
    "rzhevka" // RVH
    "røros" // RRS
    "rørvik" // RVK
    "røst" // RET
    "saab" // LPI
    "saadah" // SYE
    "saarbrucken" // SCN
    "saaryuaq" // YSY
    "saba" // SAB
    "sabadell" // QSA
    "sabah" // SBV
    "sabang" // SBG
    "sabella" // ANF
    "sabetta" // SBT
    "sabha" // SEB
    "sabieh" // AII
    "sabiha" // SAW
    "sable" // YSA
    "sablon" // YBX
    "sabzevar" // AFZ
    "sacheon" // HIN
    "sachigo" // ZPB
    "sachs" // YSY
    "sad" // QND
    "sadah" // SYE
    "sadik" // LAH
    "sadiq" // SKO
    "sadkow" // RDO
    "sado" // SDS
    "sadooghi" // AZD
    "sadsuitubun" // LUV
    "saenz" // PRQ
    "safford" // SAD
    "safia" // SFU
    "saga" // HSG
    "sagarai" // SGJ
    "saglek" // YSV
    "sagvar" // SFK
    "sahabat" // SXS
    "sahand" // ACP
    "sahar" // BOM
    "sahiwal" // RZS
    "sahnewal" // LUH
    "saibai" // SBR
    "saidor" // SDI
    "saidpur" // SPD
    "saidu" // SDT
    "saih" // AHW
    "saini" // NNS
    "saipan" // SPN
    "saiss" // FEZ
    "saiwusu" // ERL
    "sakhalinsk" // UUS
    "sakht" // RZR
    "sakirpasa" // ADA
    "sakkyryr" // SUK
    "sakon" // SNO
    "salaam" // DAR
    "salah" // INZ
    "salak" // MVR
    "salalah" // SLL
    "salamanca" // SLM
    "salamo" // SAM
    "salas" // NVA
    "salazar" // ICC
    "salcea" // SCV
    "sale" // SXE
    "salekhard" // SLY
    "salen" // SCR
    "salento" // BDS
    "salgado" // POA
    "salima" // LMB
    "salinas" // SNS
    "salisbury" // SBY
    "salle" // COT
    "salles" // VIX
    "salluit" // YZG
    "salman" // DWD
    "salomon" // LGS
    "salta" // SLA
    "salton" // SAS
    "salvaza" // CCF
    "salzburg" // SZG
    "samana" // AZS
    "samara" // KUF
    "samarinda" // AAP
    "samarkand" // SKD
    "sambailo" // SBI
    "sambava" // SVB
    "samburu" // UAS
    "samedan" // SMV
    "samjiyon" // YJS
    "samos" // SMI
    "sampit" // SMQ
    "sampson" // CTZ
    "samsun" // SZF
    "samuels" // BRY
    "samui" // USM
    "samungli" // UET
    "sana" // SAH
    "sanam" // SGZ
    "sanandaj" // SDG
    "sanchez" // MXL
    "sancti" // USS
    "sand" // SDP
    "sandakan" // SDK
    "sandane" // SDN
    "sandefjord" // TRF
    "sandino" // MGA
    "sandnessjoen" // SSJ
    "sandnessjøen" // SSJ
    "sandoval" // RZP
    "sandro" // TRN
    "sands" // ALM
    "sandspit" // YZP
    "sandviken" // GVX
    "sandy" // ZSJ
    "sanfebagar" // FEB
    "sanga" // SGS
    "sangapi" // SGK
    "sangia" // PUM
    "sangley" // SGL
    "sangster" // MBJ
    "sanhe" // YYA
    "sania" // TTU
    "saniat" // TTU
    "sanikiluaq" // YSK
    "sanjiazi" // NDG
    "sanlıurfa" // GNY
    "sanming" // SQJ
    "sannuhe" // TVS
    "sanqingshan" // SQD
    "sant" // PEG
    "santander" // SDR
    "santarem" // STM
    "santegidio" // PEG
    "santi" // GSI
    "santorini" // JTR
    "sanya" // SYX
    "sanyi" // LJG
    "sanyuanpu" // TNH
    "sanzao" // ZUH
    "sapmanga" // SMH
    "sapporo" // OKD
    "sar" // RZR
    "sarafovo" // BOJ
    "sarajevo" // SJJ
    "sarakhs" // CKT
    "saransk" // SKX
    "saravena" // RVE
    "sardar" // AMD
    "sardeh" // SBF
    "sardy" // ASE
    "sarichef" // WSF
    "sarmellek" // SOB
    "sarmiento" // UAQ
    "sarnia" // YZR
    "sarre" // SSQ
    "sarteneja" // SJX
    "sartu" // DQA
    "sary" // KGF
    "sasereme" // TDS
    "saskatoon" // YXE
    "saskylakh" // SYS
    "sassandra" // ZSS
    "sasstown" // SAZ
    "sastranegara" // BDO
    "sathya" // PUT
    "satna" // TNI
    "satolas" // LYS
    "satoyama" // NTQ
    "satu" // SUJ
    "sauces" // RDS
    "saudale" // RTI
    "saui" // UAI
    "saul" // XAU
    "saurimo" // VHC
    "sausapor" // WRR
    "sauðarkrokur" // SAK
    "savannah" // SAV
    "savannakhet" // ZVK
    "savarkar" // IXZ
    "savino" // PEE
    "savoie" // NCY
    "savonlinna" // SVL
    "savoonga" // SVA
    "savusavu" // SVU
    "savuti" // SVT
    "sawan" // RZS
    "sayaboury" // ZBY
    "sayak" // IAO
    "sayun" // GXF
    "sbas" // AIF
    "sbbt" // BAT
    "sbln" // LIP
    "sbtl*" // TEC
    "scammon" // SCM
    "scandinavian" // SCR
    "scarlet" // RIH
    "scatsta" // SCS
    "schefferville" // YKL
    "schenectady" // SCH
    "schieber" // NNU
    "schiphol" // AMS
    "schkeuditz" // LEJ
    "schmidt”" // HAM
    "schneidlingen" // CSO
    "scholes" // GLS
    "scholter" // BTP
    "schoolcraft" // ISQ
    "schreiner" // ERV
    "schwechat" // VIE
    "scilly" // ISC
    "scioto" // PMH
    "scott" // FSK
    "scottsdale" // SCF
    "scranton" // AVP
    "scribner" // SCB
    "scusciuban" // CMS
    "searcy" // SRC
    "seatac" // SEA
    "seattle" // SEA
    "seawell" // BGI
    "sebastian" // EAS
    "sebba" // XSE
    "sebring" // SEF
    "secada" // IQT
    "sechelt" // YHS
    "second" // PKX
    "seda" // MOF
    "sedalia" // DMO
    "sedar" // DKR
    "sedona" // SDX
    "sedrata" // OGX
    "see" // AAL
    "seeb" // MCT
    "seewoosagur" // MRU
    "seghe" // EGM
    "segud" // JIM
    "seguela" // SEO
    "seguro" // BPS
    "sehit" // IGD
    "sehonghong" // SHK
    "sehwan" // SYW
    "seinajoki" // SJY
    "seine" // URO
    "sekake" // SKQ
    "selahaddin" // YKO
    "selam" // MKS
    "selaparang" // AMI
    "selatan" // NCS
    "selawik" // WLK
    "selbang" // SBC
    "seldovia" // SOV
    "selebi" // PKW
    "seletar" // XSP
    "self" // NKM
    "selibabi" // SEY
    "selibaby" // SEY
    "semado" // LSM
    "semaring" // LBW
    "sematan" // BSE
    "semera" // SZE
    "semey" // PLX
    "semipalatinsk" // PLX
    "semnan" // SNX
    "semonkong" // SOK
    "semporna" // SMM
    "senai" // JHB
    "senanga" // SXG
    "sendai" // SDJ
    "senegal" // DKR
    "senghor" // DKR
    "senguer" // ARR
    "senia" // ORN
    "senior" // HAF
    "senou" // BKO
    "sentani" // DJJ
    "sentraoes" // FCB
    "seo" // LEU
    "seoul" // ICN
    "sepik" // SPV
    "sept" // YZV
    "sepulot" // SPE
    "sequ" // UIO
    "sequim" // SQV
    "serafettin" // NKT
    "serdan" // PBC
    "serena" // MRE
    "seretse" // GBE
    "seridan" // ODN
    "serio" // BGY
    "seronera" // SEU
    "serra" // CKS
    "serrano" // MCH
    "serui" // ZRI
    "seruyan" // KLP
    "servando" // MAM
    "servel" // LAI
    "sesheke" // SJQ
    "seshutes" // SHZ
    "sestri" // GOA
    "setif" // QSF
    "setm" // LOH
    "sette" // ZKM
    "seu" // LEU
    "sevastopol" // UKS
    "seve" // SDR
    "severn" // YER
    "severo" // SWV
    "sevilla" // SVQ
    "seward" // SWD
    "seychelles" // SEZ
    "seyit" // EDO
    "seymour" // GPS
    "sez" // SDX
    "sfax" // SFA
    "shadi" // FUO
    "shafter" // MIT
    "shageluk" // SHX
    "shahjalal" // DAC
    "shahr" // IHR
    "shahre" // CQD
    "shahrekord" // CQD
    "shahroud" // RUD
    "shaikh" // RYK
    "shaka" // DUR
    "shakawe" // SWX
    "shakhtersk" // EKS
    "shakhtyorsk" // EKS
    "shakiso" // SKR
    "shaktoolik" // SKK
    "sham" // MOD
    "shamattawa" // ZTM
    "shamshabad" // HYD
    "shamshernagar" // ZHM
    "shang" // KNH
    "shangjie" // HSJ
    "shangrao" // SQD
    "shangri" // DIG
    "shangrila" // DIG
    "shankar" // KNU
    "shannon" // SNN
    "shanshan" // SXJ
    "shanzihe" // RIZ
    "shaoguan" // HSC
    "shaoyang" // WGN
    "shapotou" // ZHY
    "sharjah" // SHJ
    "shark" // MJK
    "sharm" // SSH
    "sharp" // CKK
    "sharq" // GSQ
    "sharurah" // SHW
    "shashi" // SHS
    "shastri" // VNS
    "shawnee" // SNL
    "shaxian" // SQJ
    "shay" // SGP
    "shea" // CGF
    "sheboygan" // SBM
    "sheffield" // DSA
    "sheghnan" // SGA
    "sheik" // SSH
    "shelby" // SBX
    "shelbyville" // SYI
    "sheldon" // SXP
    "shellharbour" // WOL
    "shenandoah" // SHD
    "shengli" // DOY
    "shennongjia" // HPG
    "shennufeng" // WSK
    "shenyang" // SHE
    "shenzhen" // SZX
    "shepherd" // MRB
    "shepparton" // SHT
    "sher" // PWD
    "sherbrooke" // YSC
    "sheremetyevo" // SVO
    "sheridan" // SHR
    "shestovitsa" // CEJ
    "sheva" // BEV
    "shidi" // JSJ
    "shigatse" // RKZ
    "shihezi" // SHF
    "shijiazhuang" // SJW
    "shilavo" // HIL
    "shillon" // SHL
    "shillong" // SHL
    "shimla" // SLV
    "shimojishima" // SHI
    "shinyanga" // SHY
    "shirahama" // SHM
    "shirak" // LWN
    "shiraz" // SYZ
    "shirdi" // SAG
    "shire" // SHC
    "shishmaref" // SHH
    "shivaji" // BOM
    "shively" // SAA
    "shiyan" // WDS
    "shizuoka" // FSZ
    "shmona" // KWS
    "sholapur" // SSE
    "shonai" // SYO
    "shoreham" // ESH
    "shota" // TBS
    "show" // SOW
    "shp" // BPE
    "shpakovskoye" // STW
    "shri" // NDC
    "shuangliu" // CTU
    "shumba" // JAE
    "shungnak" // SHG
    "shuofang" // WUX
    "shuttle" // QQS
    "shuttlesworth" // BHM
    "shymkent" // CIT
    "sialkot" // SKT
    "siargao" // IAO
    "siassi" // SSS
    "siauliai" // SQQ
    "sibi" // SBQ
    "sibisa" // SIW
    "sibiti" // SIB
    "sibiu" // SBZ
    "sibu" // SBW
    "sibulan" // DGT
    "siebert" // ZOS
    "siegerland" // SGE
    "siem" // REP
    "sievierodonetsk" // SEV
    "siglufjordur" // SIJ
    "siglufjorður" // SIJ
    "siguanea" // SZJ
    "siguiri" // GII
    "sihanouk" // KOS
    "sihanoukville" // KOS
    "sihanukville" // KOS
    "siirt" // SXZ
    "sikasso" // KSS
    "sikes" // CEW
    "sikeston" // SIK
    "sikhuphe" // SHO
    "sikorsky" // BDR
    "silampari" // LLJ
    "silangit" // DTB
    "silay" // BCD
    "silchar" // IXS
    "silgadi" // SIH
    "silistra" // SLS
    "siljan" // MXX
    "sill" // LAW
    "silur" // SWR
    "silvio" // ASU
    "sim" // SMJ
    "simao" // SYM
    "simara" // SIF
    "simbai" // SIM
    "simbel" // ABS
    "simcoe" // YLK
    "simenstad" // OEO
    "simferopol" // SIP
    "simikot" // IMK
    "sindal" // CNL
    "sindhri" // MPD
    "singapore" // SIN
    "singkep" // SIQ
    "sinoe" // SNI
    "sinop" // NOP
    "siofok" // SFK
    "sion" // SIR
    "sipes" // MKL
    "sipitang" // SPT
    "siring" // AAP
    "sirjan" // SYJ
    "sirri" // SXI
    "sisg" // AJU
    "sishen" // SIS
    "sisimiut" // JHS
    "siskiyou" // SIY
    "sissano" // SIZ
    "sitia" // JSH
    "sitiawan" // SWY
    "sitka" // SIT
    "sitra" // CJB
    "sittwe" // AKY
    "siuna" // SIU
    "sivas" // VAS
    "siwa" // SEW
    "siwo" // EAE
    "sixty" // YDW
    "sjtq" // AGD
    "skag" // ACL
    "skagen" // SKN
    "skagit" // MVW
    "skagway" // SGY
    "skardu" // KDU
    "skavsta" // NYO
    "skelleftea" // SFT
    "skge" // MGN
    "skgy" // GAA
    "skiathos" // JSI
    "skien" // SKE
    "skiring" // CSK
    "skiros" // SKU
    "skirring" // CSK
    "skive" // SQW
    "sklare" // MKA
    "skopje" // SKP
    "skovde" // KVB
    "skrydstrup" // SKS
    "skukuza" // SZK
    "skwentna" // SKW
    "sky" // PHX
    "skylark" // ILE
    "skyros" // SKU
    "slave" // YZH
    "sleetmute" // SLQ
    "slen" // PVE
    "slf" // QQS
    "slhi" // CCA
    "sliac" // SLD
    "sligo" // SXL
    "slimane" // GMD
    "slopes" // FRY
    "sly" // KSR
    "smaland" // VXO
    "smara" // SMW
    "smederevo" // SDO
    "smederevska" // SPL
    "smeralda" // OLB
    "smithers" // YYD
    "smiths" // YSH
    "smithton" // SIO
    "smolensk" // LNX
    "smyrna" // MQY
    "snake" // SNB
    "snap" // YNX
    "snicolau" // SNE
    "snohomish" // PAE
    "snowy" // OOM
    "snyder" // ATO
    "soa" // BJW
    "soalala" // DWB
    "sochi" // AER
    "socotra" // SCT
    "soddo" // SXU
    "soddu" // SXU
    "soderhamn" // SOO
    "sodus" // SDC
    "sogamoso" // SOX
    "sogndal" // SOG
    "sohag" // HMB
    "sohar" // OHS
    "soko" // BDK
    "sokol" // GDX
    "sokongan" // ENT
    "sol" // AGP
    "sola" // SVG
    "solapur" // SSE
    "soldotna" // SXQ
    "soleyman" // QMJ
    "solidarity" // SZZ
    "solis" // GPI
    "solleftea" // KRF
    "solovki" // CSH
    "solwezi" // SLI
    "sonari" // IXW
    "sonderborg" // SGD
    "sondok" // DSO
    "songea" // SGX
    "songkhla" // SGZ
    "songyuan" // YSQ
    "sopu" // SPH
    "sorkjosen" // SOJ
    "soroako" // SQR
    "sorocaba" // SOD
    "sorong" // SOQ
    "soroti" // SRT
    "sorstokken" // SRP
    "sot" // MAQ
    "souanke" // SOE
    "souillac" // BVE
    "soummam" // BJA
    "sousa" // UAL
    "southampton" // SOU
    "southdowns" // KIW
    "southend" // SEN
    "southland" // UXL
    "sovetskaya" // GVN
    "sovetsky" // OVS
    "soyo" // SZA
    "spaatz" // RDG
    "space" // TIX
    "spain" // SQS
    "spanish" // SPK
    "sparrevohn" // SVW
    "sparta" // CMY
    "sparti" // SPJ
    "spence" // MUL
    "sphinx" // SPX
    "spichenkovo" // NOZ
    "spiritus" // USS
    "split" // SPU
    "spm" // FSP
    "spokane" // SFF
    "spriggs" // MLW
    "springbok" // SBU
    "springdale" // SPZ
    "springville" // SPK
    "squamish" // YSE
    "srednekolymsk" // SEK
    "sremska" // SMC
    "sria" // AAP
    "srinagar" // SXR
    "srinagar*" // SXR
    "ssbz" // BZC
    "sspb" // PTO
    "sta" // RLO
    "stafford" // OJA
    "stallings" // ISO
    "stamper" // HUJ
    "stan" // HUJ
    "standiford" // SDF
    "stanfield" // YHZ
    "staniel" // TYM
    "stanley" // PSY
    "stanly" // VUJ
    "stansted" // STN
    "stanthorpe" // SNH
    "stanton" // SYN
    "star" // CXO
    "stara" // SZR
    "staroselye" // RYB
    "statesboro" // TBR
    "stauning" // STA
    "stavanger" // SVG
    "staverton" // GLO
    "stavropol" // STW
    "stawell" // SWC
    "steamboat" // SBS
    "stebbins" // WBB
    "steel" // IPN
    "stefan" // OFK
    "stefanik" // BTS
    "steinberg" // CPS
    "stell" // CRT
    "stella" // SML
    "stephenville" // YJT
    "stern" // WAH
    "steuben" // ANQ
    "stfr" // SFC
    "stillwater" // SWO
    "stinson" // SSF
    "stn" // CXQ
    "stoelmans" // SMZ
    "stokes" // TAD
    "stokka" // SSJ
    "stokmarknes" // SKN
    "stord" // SRP
    "storm" // SLB
    "stornoway" // SYY
    "storuman" // SQO
    "stowe" // MVL
    "strahan" // SRN
    "straits" // SQT
    "stralsund" // BBH
    "strand" // CRE
    "strasbourg" // SXB
    "strathmore" // STH
    "straubel" // GRB
    "streaky" // KBY
    "strezhevoy" // SWT
    "strigino" // GOJ
    "strother" // WLD
    "stroud" // SUD
    "stroudsburg" // ESP
    "stumpf" // SJK
    "stung" // TNX
    "sturt" // SSK
    "sturup" // MMX
    "stuyahok" // KNW
    "stykkisholmur" // SYK
    "sua" // SXN
    "suai" // UAI
    "suarlee" // QNM
    "suavanao" // VAO
    "sub" // SNF
    "subang" // SZB
    "subhas" // CCU
    "subic" // SFS
    "subrato" // WYK
    "suceava" // SCV
    "sucker" // YRS
    "sucua" // SUQ
    "sudan" // PZU
    "sudbury" // YSB
    "sugar" // SGR
    "sugimanuru" // RAQ
    "sui" // SUL
    "sukang" // LSU
    "suketar" // TPJ
    "sukhothai" // THS
    "sukhumi" // SUI
    "suki" // SKC
    "sukkur" // SKZ
    "sukon" // LSX
    "sulaeman" // BDO
    "sulaiman" // BPN
    "sulaimaniyah" // ISU
    "sule" // ULE
    "suleyman" // ISE
    "sulphur" // SLR
    "sulu" // CDY
    "sumbawanga" // SUT
    "sumbe" // NDD
    "sumburgh" // LSI
    "summer" // SUR
    "summit" // UMM
    "sumter" // SUM
    "sumy" // UMY
    "sunchales" // NCJ
    "sundsvall" // SDL
    "sunport" // ABQ
    "sunriver" // SUO
    "sunshine" // MCY
    "suntar" // SUY
    "sunyani" // NYI
    "supadio" // PNK
    "surbung" // SRU
    "surendra" // JRG
    "surgut" // SGC
    "suria" // SUZ
    "surigao" // SUG
    "surin" // PXR
    "surkhet" // SKH
    "susanville" // SVE
    "sussex" // GED
    "suvarnabhumi" // BKK
    "suz" // CSZ
    "svalbard" // LYR
    "svartnes" // VAW
    "sveg" // EVG
    "sviatoshyn" // NNN
    "svicente" // VXE
    "svolvaer" // SVJ
    "svolvær" // SVJ
    "svp" // AMD
    "swakopmund" // SWP
    "swami" // RPR
    "swansea" // SWS
    "swede" // RRT
    "sweet" // EUG
    "sweetwater" // RKS
    "swidnik" // LUZ
    "swift" // YYN
    "swinnie" // ADR
    "swrp" // AIR
    "syamsir" // KBU
    "syamsudin" // BDJ
    "syangboche" // SYH
    "syarif" // PKU
    "syktyvkar" // SCW
    "sylacauga" // SCD
    "sylhet" // ZYL
    "sylt" // GWT
    "syracuse" // SYR
    "syria" // PMS
    "syros" // JSY
    "syukuran" // LUW
    "szczecin" // SZZ
    "szczytno" // SZY
    "szeged" // QZD
    "szi" // ZSI
    "szlapelis" // ARR
    "szwederowo" // BZG
    "szymany" // SZY
    "sønderborg" // SGD
    "sørkjosen" // SOJ
    "sørstokken" // SRP
    "sırnak" // NKT
    "słupsk" // OSP
    "taba" // TCP
    "tabarka" // TBJ
    "tabas" // TCX
    "tabatiere" // ZLT
    "tabatinga" // TBT
    "tablon" // TTM
    "tablones" // LOX
    "taboada" // MXL
    "tabor" // DBT
    "tabora" // TBO
    "tabou" // TXU
    "tabriz" // TBZ
    "tabuaeran" // TNV
    "tabubil" // TBG
    "tabuk" // TUU
    "tac" // SEA
    "tacheng" // TCG
    "tachilek" // THL
    "tachira" // SVZ
    "tackaberry" // XBR
    "tacloban" // TAC
    "tacna" // TCQ
    "tacuarembo" // TAW
    "tadeo" // MUN
    "tadji" // TAJ
    "tadjoura" // TDJ
    "tadoule" // XTL
    "tafaraoui" // TAF
    "tafraoui" // TAF
    "tagula" // TGL
    "taharoa" // THH
    "tahiti" // PPT
    "tahlequah" // TQH
    "tahoua" // THZ
    "tahsis" // ZTS
    "taichung" // RMQ
    "taif" // TIF
    "tainan" // TNN
    "taisacan" // ROP
    "taisha" // TSC
    "taitung" // TTT
    "taiwan" // TPE
    "taiyuan" // TYN
    "tajima" // TJH
    "tajin" // PAZ
    "tak" // TKT
    "takaka" // KTF
    "takamatsu" // TAK
    "takapoto" // TKP
    "takaroa" // TKX
    "takengon" // TXE
    "takhamalt" // VVZ
    "takhli" // TKH
    "takoradi" // TKD
    "takotna" // TCT
    "takume" // TJN
    "talagi" // ARH
    "talakan" // TLK
    "talara" // TYL
    "talavera" // BJZ
    "talkeetna" // TKA
    "talladega" // ASN
    "tallahassee" // TLH
    "tallard" // GAT
    "tallinn" // TLL
    "tallo" // ABU
    "taloqan" // TQN
    "taloyoak" // YYH
    "taltheilei" // GSL
    "talulqan" // TQN
    "tamale" // TML
    "tamana" // TMN
    "tamanrasset" // TMR
    "tamara" // TTM
    "tamarindo" // TNO
    "tamarindos" // PVO
    "tambacounda" // TUD
    "tambao" // TMQ
    "tambler" // GES
    "tambo" // JNB
    "tambohorano" // WTA
    "tambolaka" // TMC
    "tambor" // TMU
    "tambov" // TBW
    "tamchakett" // THT
    "tamchy" // IKU
    "tame" // TME
    "tamiami" // TMB
    "tampere" // TMP
    "tampico" // TAM
    "tamuin" // TSL
    "tamworth" // TMW
    "tanacross" // TSG
    "tandag" // TDG
    "tandil" // TDL
    "tanegashima" // TNE
    "taney" // PLK
    "tanga" // TGT
    "tangier" // TNG
    "tangshan" // TVS
    "tangwangcheng" // TWC
    "tanque" // FON
    "taohuayuan" // CGD
    "taolai" // EJN
    "taos" // TSM
    "taoxian" // SHE
    "taoyuan" // TPE
    "tapachula" // TAP
    "tapao" // UTP
    "taphao" // UTP
    "tapini" // TPI
    "taplejung" // TPJ
    "tappahannock" // XSA
    "tapuruquara" // IRZ
    "tarabits" // TRJ
    "tarakan" // TRK
    "tarama" // TRA
    "tarantine" // ELZ
    "taranto" // TAR
    "tarapaca" // TCD
    "tarapoa" // TPC
    "tarauaca" // TRQ
    "taravell" // COR
    "taravella" // COR
    "taraz" // DMB
    "tarbela" // TLB
    "tarbes" // LDE
    "tardamu" // SAU
    "taree" // TRO
    "targovishte" // TGV
    "targu" // TGM
    "tarin" // TII
    "taroom" // XTO
    "tarradellas" // BCN
    "tartagal" // TTG
    "tartu" // TAY
    "tashkent" // TAS
    "tasikmalaya" // TSY
    "tasiujaq" // YTQ
    "taskul" // TSK
    "tassignano" // LCV
    "tata" // LEK
    "tatakoto" // TKV
    "tatalina" // TLJ
    "tatitlek" // TEK
    "tatry" // TAT
    "tau" // VTG
    "taunton" // TAN
    "taupo" // TUO
    "tauranga" // TRG
    "tautii" // BAY
    "tavaux" // DLE
    "taw" // NYT
    "tawa" // TWY
    "tawau" // TWU
    "taytay" // RZP
    "tazadit" // OUZ
    "ta’if" // TIF
    "tbilisi" // TBS
    "tchibanga" // TCH
    "tchien" // THC
    "tchongorove" // IGE
    "tebelian" // SQG
    "tebessa" // TEE
    "tebessi" // TEE
    "tech" // BCB
    "ted" // ANC
    "tees" // MME
    "teesside" // MME
    "tefe" // TFF
    "teferi" // MTF
    "tegel" // TXL
    "tehachapi" // TSP
    "tehini" // BQO
    "tehuacan" // TCN
    "tehuelche" // PMY
    "tekadu" // TKB
    "tekin" // TKW
    "tela" // TEA
    "telemaco" // TEC
    "telfair" // MQW
    "telfer" // TEF
    "telida" // TLF
    "teller" // TLA
    "telluride" // TEX
    "telupid" // TEL
    "temora" // TEM
    "ten" // CIO
    "tena" // TNW
    "tenente" // FRC
    "teng" // AOG
    "tengchong" // TCZ
    "tenkodogo" // TEG
    "tenna" // DIR
    "tennant" // TCA
    "tentera" // ENT
    "tenzing" // LUA
    "tepic" // TPQ
    "teply" // KDY
    "tepoe" // KCB
    "tepual" // PMC
    "teraina" // TNQ
    "teran" // AGU
    "terapo" // TEO
    "tereen" // TII
    "teresina" // THE
    "teresita" // SST
    "tereza" // TIA
    "terezinha" // STZ
    "termas" // RHD
    "terme" // SUF
    "termez" // TMJ
    "ternopil" // TNL
    "terrace" // YTJ
    "terrance" // EIS
    "terre" // BBR
    "terrebonne" // HUM
    "terrell" // TRL
    "territory" // CBR
    "teruel" // TEV
    "tesla" // BEG
    "teslin" // YZW
    "tessera" // VCE
    "test" // XSD
    "tetabedi" // TDB
    "teterboro" // TEB
    "texada" // YGB
    "texarkana" // TXK
    "teyman" // BEV
    "tezpur" // TEZ
    "tezu" // TEI
    "thaba" // THB
    "thaden" // VBT
    "thaha" // DJB
    "thakhek" // THK
    "thakurgaon" // TKR
    "thalerhof" // GRZ
    "thames" // TMZ
    "thammarat" // NST
    "thandwe" // SNW
    "thangool" // THG
    "thargomindah" // XTG
    "thbeng" // OMY
    "theodore" // DIK
    "thermal" // TRM
    "thessaloniki" // SKG
    "thicket" // YTD
    "thief" // TVF
    "thimarafushi" // TMF
    "thira" // JTR
    "thiriodh" // TRE
    "thiruvananthapuram" // TRV
    "thisted" // TED
    "thomasville" // TVI
    "thoothukudi" // TCR
    "thorshofn" // THO
    "thousand" // XBR
    "thunder" // YQT
    "thuot" // BMV
    "thurgood" // BWI
    "thyna" // SFA
    "tia" // TPE
    "tianfu" // TFU
    "tianhe" // WUH
    "tianjin" // TSN
    "tianjitai" // RLK
    "tianshui" // THQ
    "tianzhushan" // AQG
    "tiaret" // TID
    "tibooburra" // TYB
    "tibu" // TIB
    "tichit" // THI
    "tichitt" // THI
    "tickle" // YBI
    "tidjikja" // TIY
    "tifalmin" // TFB
    "tift" // TMA
    "tiga" // TGJ
    "tigre" // ELX
    "tijuana" // TIJ
    "tikapur" // TPU
    "tikehau" // TIH
    "tikkakoski" // JYV
    "tiko" // TKC
    "tiksi" // IKS
    "tillamook" // OTK
    "tille" // BVA
    "timan" // AMC
    "timaru" // TIU
    "timbedra" // TMD
    "timbiqui" // TBD
    "timbuktu" // TOM
    "timika" // TIM
    "timimoun" // TMX
    "timiskaming" // YXR
    "timisoara" // TSR
    "timmerman" // MWC
    "timmins" // YTS
    "timna" // ETM
    "timra" // SDL
    "tin" // TNC
    "tinak" // TIC
    "tindouf" // TIN
    "tingo" // TGI
    "tingoa" // RNL
    "tingwon" // TIG
    "tinian" // TIQ
    "tinson" // KTP
    "tippi" // TIE
    "tipton" // FME
    "tiputini" // TPN
    "tirana" // TIA
    "tiree" // TRE
    "tires" // CAT
    "tirios" // OBI
    "tirirical" // SLZ
    "tiruchirapalli" // TRZ
    "tiruchirappalli" // TRZ
    "tirupati" // TIR
    "tis" // HID
    "tisdale" // YTT
    "tivat" // TIV
    "tjilik" // PKY
    "tkf" // KTF
    "tlokoeng" // TKO
    "tmetuchl" // ROR
    "tmk" // OTK
    "toamasina" // TMM
    "tobar" // BUN
    "tobias" // SYQ
    "tobing" // SIX
    "tobruk" // TOB
    "tocantins" // PMW
    "toccoa" // TOC
    "tocumen" // PTY
    "tocumwal" // TCW
    "tofino" // YAZ
    "togiak" // TOG
    "toja" // OJU
    "tok" // TKJ
    "tokachi" // OBO
    "tokat" // TJK
    "tokoin" // LFW
    "tokoroa" // TKZ
    "toksook" // OOK
    "tokunoshima" // TKN
    "tokushima" // TKS
    "tol" // TLO
    "tola" // FTE
    "tolagnaro" // FTU
    "tolanaro" // FTU
    "toll" // RDT
    "tolmachevo" // OVB
    "tolu" // TLU
    "toluca" // TLC
    "tomas" // CBL
    "tombouctou" // TOM
    "tommanggong" // TMG
    "tompkins" // ITH
    "toncontin" // TGU
    "tongareva" // PYE
    "tonghua" // TNH
    "tongliao" // TGO
    "tongoa" // TGH
    "tongren" // TEN
    "tonkawa" // BWL
    "tontouta" // NOU
    "tonu" // TON
    "toowoomba" // WTB
    "tor" // ELT
    "torishima" // MUS
    "tornio" // KEM
    "toro" // BOC
    "torokina" // TOK
    "tororo" // TRY
    "torp" // TRF
    "torre" // NRR
    "torreon" // TRC
    "torrington" // TOR
    "torsby" // TYF
    "tortola" // TOV
    "tortoli" // TTB
    "tortuguero" // TTQ
    "totegegie" // GMR
    "totness" // TOT
    "totogegie" // GMR
    "tottori" // TTJ
    "tottri" // TTJ
    "touat" // AZR
    "touho" // TOU
    "toulon" // TLN
    "toulouse" // TLS
    "touquet" // LTQ
    "tours" // TUF
    "toussaint" // PAP
    "towers" // CXT
    "township" // HLM
    "townsville" // TSV
    "toyama" // TOY
    "tozeur" // TOE
    "trabzon" // TZX
    "tracy" // TCY
    "tradewind" // TDW
    "traian" // TSR
    "trail" // YZZ
    "training" // TNT
    "trang" // TST
    "transamerica" // UNA
    "transition" // TNT
    "trapani" // TPS
    "trat" // TDX
    "tree" // VCB
    "treinta" // TYT
    "tremblant" // YTM
    "treng" // TNX
    "trent" // PGL
    "trepell" // TQP
    "treviso" // TSF
    "triad" // GSO
    "tribhuvan" // KTM
    "tribhuvannagar" // DNP
    "trichy" // TRZ
    "trieste" // TRS
    "trinidad" // TDA
    "tripoli" // TIP
    "trivandrum" // TRV
    "trk" // TKF
    "trois" // YRQ
    "trollhattan" // THN
    "trompillo" // SRZ
    "trompowsky" // VAG
    "tromso" // TOS
    "tromsø" // TOS
    "trona" // TRH
    "troncal" // ARQ
    "trondheim" // TRD
    "tronquieres" // AUR
    "tropez" // LTT
    "trout" // YTL
    "troutdale" // TTD
    "troy" // TOI
    "troyes" // QYR
    "truax" // MSN
    "truckee" // TKF
    "trudeau" // YUL
    "truj" // PDA
    "trunojoyo" // SUP
    "truth" // TCS
    "trysil" // SCR
    "tsaratanana" // TTS
    "tse" // NQZ
    "tseka" // THB
    "tsewi" // TSW
    "tshabong" // TBY
    "tshikapa" // TSH
    "tshimpi" // MAT
    "tsili" // TSI
    "tsiranana" // MJN
    "tsiribihina" // BMD
    "tsletsi" // QDJ
    "tstc" // CNW
    "tsumeb" // TSB
    "tsushima" // TSJ
    "tsylma" // UTS
    "tsylos" // CJH
    "tte" // CHM
    "tuba" // TBC
    "tubuai" // TUB
    "tucumcari" // TCC
    "tucupita" // TUV
    "tucurui" // TUR
    "tufi" // TFI
    "tugdan" // TBH
    "tuguegarao" // TUG
    "tuktoyaktuk" // YUB
    "tulcea" // TCE
    "tuli" // TLD
    "tulita" // ZFN
    "tullahoma" // THA
    "tullamarine" // MEL
    "tulsa" // TUL
    "tuluksak" // TLT
    "tumaco" // TCO
    "tumbang" // TJQ
    "tumbes" // TBP
    "tumbler" // TUX
    "tumeremo" // TMO
    "tumlingtar" // TMI
    "tumolbil" // TLP
    "tumpa" // MHW
    "tumushuke" // TWC
    "tumut" // TUM
    "tumxuk" // TWC
    "tunggul" // CXP
    "tungsten" // TNS
    "tunguska" // TGP
    "tunica" // UTM
    "tunis" // TUN
    "tunoshna" // IAR
    "tunta" // KBN
    "tuntutuliak" // WTL
    "tununak" // TNK
    "tunxi" // TXN
    "tuofeng" // TCZ
    "tupelo" // TUP
    "tupg" // NGD
    "tuque" // YLQ
    "tuqui" // OVL
    "turaif" // TUI
    "turany" // BRQ
    "turbat" // TUK
    "turbio" // RYO
    "tureia" // ZTA
    "turin" // TRN
    "turkana" // LKU
    "turkmenabat" // CRZ
    "turkmenbashi" // KRW
    "turku" // TKU
    "turlatovo" // RZN
    "turner" // CRX
    "turpan" // TLQ
    "turukhansk" // THX
    "tuscaloosa" // TCL
    "tuscola" // TZC
    "tuticorin" // TCR
    "tuuta" // CHT
    "tuven" // NTB
    "tuxtla" // TGZ
    "tuy" // TBB
    "tuzla" // TZL
    "tver" // KLD
    "tweed" // HVN
    "twente" // ENS
    "twenthe" // ENS
    "twentynine" // TNP
    "twt" // SGS
    "txg" // RMQ
    "tydeo" // PDU
    "tynda" // TYD
    "tyonek" // TYE
    "tyson" // TYS
    "tzaneen" // LTA
    "uaax" // BXH
    "uairen" // SNV
    "uaxactun" // UAX
    "ubari" // QUB
    "ubatuba" // UBT
    "ube" // UBJ
    "uberaba" // UBA
    "uberlandia" // UDI
    "ubon" // UBP
    "uchiza" // UCZ
    "udaipur" // UDR
    "udara" // PNK
    "ude" // UUD
    "udine" // UDN
    "udon" // UTH
    "ugarteche" // MZA
    "uggg" // TBS
    "ugnu" // UUK
    "ugolny" // DYR
    "uige" // UGO
    "uiju" // UJU
    "ujae" // UJE
    "ukhta" // UCT
    "ukiah" // UKI
    "ukunda" // UKA
    "ulaanbaatar" // UBN
    "ulaangom" // ULO
    "ulan" // UUD
    "ulanhot" // HLH
    "ulanqab" // UCB
    "ulawa" // RNA
    "ulbc" // CEE
    "ulei" // ULB
    "uljin" // UJN
    "ulpiano" // SNC
    "ulsan" // USN
    "ulukhaktok" // YHI
    "ulundi" // ULD
    "umba" // UMC
    "umbria" // PEG
    "umea" // UME
    "umiat" // UMT
    "umiujaq" // YUD
    "ummg" // QYY
    "umuarama" // UMU
    "una" // OJU
    "unalakleet" // UNK
    "unalaska" // DUT
    "united" // BUR
    "uostas" // PLQ
    "upernavik" // JUV
    "upington" // UTN
    "upolu" // UPP
    "uralsk" // URA
    "uranium" // YBE
    "uray" // URJ
    "urbano" // SJK
    "urdaneta" // STB
    "urengoy" // NUX
    "urgel" // LEU
    "urgell" // LEU
    "urgench" // UGC
    "urmia" // OMH
    "uroubi" // URU
    "urquiza" // PRA
    "urrao" // URR
    "urt" // UUN
    "uru" // ATD
    "uruapan" // UPN
    "urubupunga" // URB
    "urumqi" // URC
    "urzhar" // UZR
    "usak" // USQ
    "ushuaia" // USH
    "usiminas" // IPN
    "usinsk" // USK
    "ustupo" // UTU
    "ustupu" // OGM
    "ustyug" // VUS
    "uta" // FTI
    "utapao" // UTP
    "utila" // UII
    "utin" // UTI
    "utirik" // UTK
    "utka" // AZN
    "utsunomiya" // QUT
    "utti" // UTI
    "uytash" // MCX
    "uzhhorod" // UDJ
    "uzunyazi" // KFS
    "vaasa" // VAA
    "vaclav" // PRG
    "vadodara" // BDQ
    "vadso" // VDS
    "vadsø" // VDS
    "vadu" // DIU
    "vaernes" // TRD
    "vagar" // FAE
    "vahitahi" // VHZ
    "valadares" // GVR
    "valan" // HVG
    "valcheta" // VCF
    "valdez" // VDZ
    "valdosta" // VLD
    "valenca" // VAL
    "valence" // VAF
    "valesdir" // VLS
    "valjevo" // QWV
    "vallabhbhai" // AMD
    "valladolid" // VLL
    "vallarta" // PVR
    "valledupar" // VUP
    "vallee" // URO
    "vallegrande" // VAH
    "vallemi" // VMI
    "vallenar" // VLR
    "valletta" // MLA
    "vance" // NEV
    "vanda" // HEL
    "vandenberg" // VDF
    "vanersborg" // THN
    "vangaindrano" // VND
    "vanguardia" // VVC
    "vanimo" // VAI
    "vannes" // VNE
    "vanrook" // VNR
    "vantaa" // HEL
    "vantaan" // HEL
    "vanua" // SLH
    "vanuabalavu" // VBV
    "varadero" // VRA
    "varanasi" // VNS
    "varandey" // VRI
    "vardo" // VAW
    "vardø" // VAW
    "varela" // CTC
    "varese" // QVA
    "varginha" // VAG
    "varna" // VAR
    "vary" // KLV
    "vatomandry" // VAT
    "vatry" // XCR
    "vatukoula" // VAU
    "vatulele" // VTF
    "vava" // VAV
    "vaxjo" // VXO
    "vazquez" // ULA
    "vela" // RIJ
    "velana" // MLE
    "velasquez" // PYA
    "vele" // FUT
    "velikiye" // VLU
    "veliky" // VUS
    "venango" // FKL
    "venegono" // QVA
    "venetie" // VEE
    "vengue" // MVB
    "venizelos" // ATH
    "ventspils" // VNT
    "venustiano" // LOV
    "veracruz" // VER
    "verdad" // LOM
    "verga" // ABV
    "verkehrslandeplatz" // ESS
    "verkhnevilyuysk" // VHV
    "vernal" // VEL
    "vero" // VRB
    "verona" // QBS
    "vestjylland" // STA
    "vestmannaeyjar" // VEY
    "veterans" // MWA
    "vexin" // POX
    "vgzr" // DAC
    "vias" // BZR
    "vicecomodoro" // SDE
    "vichada" // LGT
    "vichadero" // VCH
    "vichy" // VHY
    "victorville" // VCV
    "victorvillesoutherncalifornialogisticsairports" // VCV
    "vida" // AQM
    "vidalia" // VDI
    "videira" // VIA
    "vidin" // VID
    "vidrasau" // TGM
    "vidyanagar" // VDY
    "vidyarthi" // KNU
    "vieira" // OXB
    "viejo" // SFN
    "vienna" // VIE
    "vientiane" // VTE
    "vigan" // VGN
    "vignetta" // IQT
    "vigo" // VGO
    "vigra" // AES
    "vijayanagar" // VDY
    "vijayawada" // VGA
    "vijaynagar" // VDY
    "vil" // CUU
    "vilanculos" // VNX
    "vilankulo" // VNX
    "vilhelmina" // VHM
    "villafria" // RGS
    "villagomez" // VAH
    "villahermosa" // VSA
    "villalobos" // CUU
    "villanubla" // VLL
    "villanueva" // HTZ
    "villeda" // SAP
    "vilnius" // VNO
    "vilo" // CYO
    "vilyuisk" // VYI
    "vina" // KNA
    "vinamar" // VAP
    "vincennes" // LWV
    "vincent" // OEM
    "vincenzo" // TPS
    "vinci" // FCO
    "vineyard" // MVY
    "vinh" // VII
    "vinnytsia" // VIN
    "vipingo" // VPG
    "viqueque" // VIQ
    "virac" // VRC
    "viracopos" // VCP
    "virgil" // BFR
    "virgilio" // LCR
    "virgin" // VIJ
    "viru" // VVI
    "visakhapatnam" // VTZ
    "visalia" // VIS
    "visby" // VBY
    "viseu" // VSE
    "vishakhapatnam" // VTZ
    "vista" // BVB
    "vitebsk" // VTB
    "vito" // TOO
    "vivas" // STD
    "vivekananda" // RPR
    "vladimir" // AOP
    "vladivostok" // VVO
    "vlaicu" // BBU
    "vnrk" // RUK
    "vnukovo" // VKO
    "vodochody" // VOD
    "vody" // MRV
    "vogel" // CVL
    "voinjama" // VOI
    "vojens" // SKS
    "volda" // HOV
    "volgograd" // VOG
    "vologda" // VGD
    "vopnafjordur" // VPN
    "vopnafjorður" // VPN
    "vorkuta" // VKT
    "voronezh" // VOZ
    "votuporanga" // VOT
    "vrazhdebna" // SOF
    "vredendal" // VRE
    "vryburg" // VRU
    "vtpl" // PHY
    "vtus" // SNO
    "vue" // YUE
    "vuia" // TSR
    "vung" // VTG
    "vunisea" // KDV
    "værnes" // TRD
    "waala" // BMY
    "wabo" // WAO
    "wabush" // YWK
    "waca" // WAC
    "wacca" // WAC
    "wad" // DNI
    "wade" // BDA
    "wagau" // WGU
    "wageningen" // AGI
    "waghala" // WJR
    "wai" // MOF
    "waiheke" // WIK
    "waimea" // MUE
    "wairoa" // WIR
    "wajh" // EJH
    "wajir" // WJR
    "wakaya" // KAY
    "wake" // AWK
    "wakeham" // YWB
    "wakkanai" // WKJ
    "wala" // BMY
    "walaha" // WLH
    "wales" // WAA
    "walesa" // GDN
    "walgett" // WGE
    "walker" // WKR
    "walkers" // WKR
    "walla" // ALW
    "wallblake" // AXA
    "walney" // BWF
    "walnut" // ARG
    "walr" // TRK
    "walt" // DWS
    "walton" // VPS
    "walvis" // WVB
    "wamena" // WMX
    "wanaka" // WKA
    "wanfenglin" // ACX
    "wang" // WOT
    "wanganui" // WAG
    "wangaratta" // WGT
    "wangcun" // CIH
    "wanigela" // AGL
    "wannukandi" // NBL
    "wantoat" // WTT
    "wanzhou" // WXN
    "wapekeka" // YAX
    "wapenamanda" // WBM
    "wapolu" // WBC
    "warangal" // WGC
    "warb" // BWX
    "warq" // SOC
    "warraber" // SYU
    "warracknabeal" // WKB
    "warri" // QRW
    "warrnambool" // WMB
    "warroad" // RRT
    "warton" // WRT
    "warukin" // TJG
    "warwick" // WAZ
    "washabo" // WSO
    "washan" // CWJ
    "wasilla" // WWA
    "waskaganish" // YKQ
    "waspam" // WSP
    "waspan" // WSP
    "wasr" // MKW
    "wasu" // WSU
    "waterbury" // OXC
    "waterford" // WAT
    "waterville" // WVL
    "watson" // YQH
    "watsonville" // WVI
    "wattay" // VTE
    "waukegan" // UGN
    "waukesha" // UES
    "waupaca" // PCZ
    "wausau" // AUW
    "wawa" // YXZ
    "wawi" // PMA
    "wawoi" // WAJ
    "waycross" // AYS
    "waynesville" // TBN
    "wałesa" // GDN
    "wbfc" // MZV
    "weagamow" // ZRJ
    "webb" // TXK
    "webequie" // YWP
    "webster" // EBS
    "wedjh" // EJH
    "weedon" // EUF
    "weeze" // NRN
    "weifang" // WEF
    "weihai" // WEH
    "weimar" // ERF
    "weipa" // WEI
    "wekweeti" // YFJ
    "weld" // GXY
    "welkom" // WEL
    "wellcamp" // WTB
    "wellingoton" // WLG
    "wellington" // WLG
    "wellsville" // ELZ
    "welwitschia" // MSZ
    "wemindji" // YNC
    "wendover" // ENV
    "wenshan" // WNH
    "wenz" // PWY
    "wenzhou" // WNZ
    "werur" // WRR
    "westchester" // HPN
    "westerland" // GWT
    "westerly" // WST
    "westheimer" // OUN
    "westover" // CEF
    "westport" // WSZ
    "westville" // COP
    "wevelgem" // KJK
    "wewak" // WWK
    "wexford" // CAD
    "whakatane" // WHK
    "whale" // YXN
    "whangarei" // WRE
    "wharton" // WHT
    "whati" // YLE
    "wheeling" // HLG
    "whitecourt" // YZU
    "whitegrass" // TAH
    "whitehorse" // YXY
    "whiteman" // WHP
    "whiteriver" // WTR
    "whitianga" // WTZ
    "whitted" // SPG
    "whyalla" // WYA
    "wiarton" // YVV
    "wick" // WIC
    "wicomico" // SBY
    "wieniawski" // POZ
    "wikl" // LLJ
    "wilbarger" // WIB
    "wilcannia" // WIO
    "wilcox" // MIA
    "wilgrove" // QWG
    "willard" // CMI
    "willem" // GRJ
    "willemstad" // CUR
    "williamsburg" // PHF
    "williamsport" // IPT
    "williston" // XWA
    "willmar" // ILL
    "willoughby" // LNN
    "willows" // WLW
    "willy" // BER
    "wilsterman" // CBB
    "wilstermann" // CBB
    "wiluna" // WUN
    "wilwal" // JIJ
    "winchester" // WGO
    "windarling" // WRN
    "winder" // WDR
    "windhoek" // WDH
    "windorah" // WNR
    "window" // RQE
    "windsor" // YQG
    "wings" // BBX
    "winkler" // INK
    "winkworth" // NEV
    "winnemucca" // WMC
    "winnipeg" // YWG
    "winona" // ONA
    "winslow" // INW
    "winter" // GIF
    "winton" // WIN
    "wipim" // WPM
    "wirasaba" // PWL
    "wiscasset" // ISS
    "witham" // SUA
    "withybush" // HAW
    "witm" // LSX
    "wittman" // OSH
    "witu" // WIU
    "wkb" // WNI
    "woitape" // WTP
    "woja" // WJA
    "wojtyła" // BRI
    "wokal" // GGW
    "wold" // MSP
    "wollaston" // ZWL
    "won" // GUM
    "wondai" // WDI
    "wonderboom" // PRY
    "wondoola" // WON
    "wonenara" // WOA
    "wonju" // WJU
    "wonopito" // LWE
    "wonsan" // WOS
    "woodbourne" // BHE
    "woodhouse" // SPK
    "woodley" // CPM
    "woodring" // WDG
    "woodrum" // ROA
    "worcester" // ORH
    "worland" // WRL
    "wotho" // WTO
    "wotje" // WTE
    "wrangell" // WRG
    "wrbc" // BTW
    "wrigley" // YWY
    "wrinkle" // HCA
    "wrle" // GHS
    "wrlk" // BEJ
    "wrlr" // TRK
    "wrocław" // WRO
    "wrotham" // WPK
    "wudalianchi" // DTU
    "wudangshan" // WDS
    "wudinna" // WUD
    "wudyan" // CCE
    "wugang" // WGN
    "wuhai" // WUA
    "wuhan" // WUH
    "wuliangye" // YBP
    "wulingshan" // JIQ
    "wulipu" // AKA
    "wulung" // CXP
    "wunnummin" // WNN
    "wuqiao" // WXN
    "wurtsmith" // OSC
    "wushan" // WSK
    "wusu" // TYN
    "wutaishan" // WUT
    "wuvulu" // WUV
    "wuxi" // WUX
    "wuxu" // NNG
    "wuyishan" // WUS
    "wuzhou" // WUZ
    "wyalong" // WWY
    "wycombe" // HYC
    "wyndham" // WYN
    "władysław" // LCJ
    "xangongo" // XGN
    "xanxere" // AXE
    "xatruch" // PLP
    "xavantina" // NOK
    "xfl" // VJI
    "xiahe" // GXH
    "xiamen" // XMN
    "xiangyang" // XFN
    "xianyang" // XIY
    "xiaoshan" // HGH
    "xichang" // XIC
    "xieng" // XKH
    "xienglom" // XIE
    "xiguan" // FUG
    "xijiang" // WUZ
    "xijiao" // NZH
    "xilinhot" // XIL
    "xinbarag" // XRQ
    "xingdong" // NTG
    "xingkaihu" // JXA
    "xingtai" // XNT
    "xingu" // SXX
    "xingyi" // ACX
    "xining" // XNN
    "xinqiao" // HFE
    "xinyang" // XAI
    "xinzheng" // CGO
    "xishuangbanna" // JHG
    "xoxocotlan" // OAX
    "xuan" // THD
    "xujiaping" // ENH
    "xuzhou" // XUZ
    "yaakov" // RPN
    "yacuiba" // BYC
    "yading" // DCY
    "yagoua" // GXX
    "yaguara" // AYG
    "yahav" // EIY
    "yai" // HDY
    "yakima" // YKM
    "yakubu" // JOS
    "yakushima" // KUM
    "yakutat" // YAK
    "yakutsk" // YKS
    "yalgoo" // YLG
    "yalinga" // AIG
    "yalumet" // KYX
    "yam" // XMY
    "yamagata" // GAJ
    "yamaguchi" // UBJ
    "yamoussoukro" // ASK
    "yampa" // HDN
    "yanbu" // YNB
    "yancheng" // YNZ
    "yandicoogina" // YNN
    "yandina" // XYA
    "yanez" // GYM
    "yangambi" // YAN
    "yangon" // RGN
    "yangyang" // YNY
    "yangzhou" // YTY
    "yani" // SRG
    "yanji" // YNJ
    "yantai" // YNT
    "yaoqiang" // TNA
    "yapsiei" // KPE
    "yariguies" // EJA
    "yarmouth" // YQI
    "yas" // XSB
    "yasawa" // YAS
    "yasniy" // ITU
    "yasuj" // YES
    "yasuru" // KSX
    "yazd" // AZD
    "ybam" // ABM
    "ybmc" // MCY
    "yeager" // CRW
    "yeelirrie" // KYF
    "yegepa" // PGE
    "yehuda" // MTZ
    "yelimane" // EYL
    "yella" // BYL
    "yelland" // ELY
    "yellow" // XYR
    "yellowknife" // YZF
    "yengema" // WYE
    "yeniseysk" // EIE
    "yenkis" // YEQ
    "yeosu" // RSU
    "yerington" // EYR
    "yeu" // IDY
    "yeva" // YVD
    "yevlakh" // YLV
    "yibin" // YBP
    "yichang" // YIH
    "yilan" // YLN
    "yilma" // DIR
    "yinchuan" // INC
    "yingkou" // YKH
    "yining" // YIN
    "yiwu" // YIW
    "ynez" // SQA
    "yof" // DKR
    "yoff" // DKR
    "yogyakarta" // YIA
    "yokangassi" // NKY
    "yola" // YOL
    "yon" // EDM
    "yonago" // YGJ
    "yonaguni" // OGN
    "yongai" // KGH
    "yongphulla" // YON
    "yongqiang" // WNZ
    "yongzhou" // LLF
    "yopal" // EYP
    "yorke" // OKR
    "yorkton" // YQV
    "yoro" // ORO
    "yoron" // RNJ
    "yoshkar" // JOK
    "yotvata" // YOT
    "youjiang" // AEB
    "youngstown" // YNG
    "youqi" // XRQ
    "yrausquin" // SAB
    "yreka" // ROF
    "ysch" // CFS
    "yuanmou" // YUA
    "yuba" // MYV
    "yucca" // UCC
    "yudongbei" // AYN
    "yuendumu" // YUE
    "yueyang" // YYA
    "yuezhao" // LPF
    "yukon" // FYU
    "yuksekova" // YKO
    "yulong" // CIF
    "yuma" // YUM
    "yuncheng" // YCU
    "yunduan" // BSD
    "yundum" // BJL
    "yungang" // DAT
    "yunlong" // LZO
    "yuri" // MSZ
    "yurimaguas" // YMS
    "yushu" // YUS
    "yusuf" // GLK
    "yuyang" // UYN
    "zabljak" // ZBK
    "zabol" // ACZ
    "zabrat" // ZXT
    "zabre" // XZA
    "zabreh" // ZBE
    "zacatecas" // ZCL
    "zachar" // KZB
    "zadar" // ZAD
    "zafer" // KZR
    "zagreb" // ZAG
    "zahedan" // ZAH
    "zakaria" // GHA
    "zakouma" // AKM
    "zakynthos" // ZTH
    "zalingei" // ZLX
    "zambezi" // BBZ
    "zamboanga" // ZAM
    "zamora" // ZMM
    "zamperini" // TOA
    "zamzama" // DDU
    "zanaga" // ANJ
    "zanartu" // WPU
    "zanderij" // PBM
    "zanesville" // ZZV
    "zanjan" // JWN
    "zanni" // PEH
    "zanzibar" // ZNZ
    "zapala" // APZ
    "zaporizhzhia" // OZH
    "zaporizhzhya" // OZH
    "zaqatala" // ZTU
    "zar" // REL
    "zaragoza" // ZAZ
    "zaranj" // ZAJ
    "zaria" // ZAR
    "zarzis" // DJE
    "zaventem" // BRU
    "zayed" // RYK
    "zaysan" // ZSI
    "zbsh" // BPE
    "zbsn" // TVS
    "zbuh" // WUA
    "zco" // PZS
    "zega" // BZU
    "zegrze" // OSZ
    "zemio" // IMO
    "zemunik" // ZAD
    "zenata" // TLM
    "zephyrhills" // ZPH
    "zero" // ZER
    "zeto" // ARZ
    "zettel" // GDW
    "zgyy" // YYA
    "zhalantun" // NZL
    "zhangjiajie" // DYG
    "zhangjiakou" // ZQZ
    "zhangye" // YZY
    "zhanjiang" // ZHA
    "zhaotong" // ZAT
    "zhengding" // SJW
    "zhezkazgan" // DZN
    "zhigansk" // ZIX
    "zhijiang" // HJJ
    "zhob" // PZH
    "zhol" // URA
    "zhongchuan" // LHW
    "zhongwei" // ZHY
    "zhoushan" // HSN
    "zhoushuizi" // DLC
    "zhuhai" // ZUH
    "zhukovsky" // ZIA
    "zhuliany" // IEV
    "zhytomyr" // ZTR
    "zia" // DAC
    "zielona" // IEG
    "ziguinchor" // ZIG
    "zihuatanejo" // ZIH
    "zilina" // ILZ
    "zinder" // ZND
    "zlhb" // HBQ
    "zljn" // JNG
    "znnn" // JGS
    "zokniai" // SQQ
    "zona" // IZA
    "zonalnoye" // ZZO
    "zonguldak" // ONQ
    "zor" // DEZ
    "zorg" // ORG
    "zrenjanin" // ZRE
    "zszm" // SQJ
    "zubko" // YEV
    "zubz" // BZX
    "zuks" // SUX
    "zumbi" // MCZ
    "zurich" // ZRH
    "zutc" // TCZ
    "zuwarah" // WAX
    "zuzi" // PZI
    "zvartnots" // EVN
    "zwara" // WAX
    "zweibrucken" // ZQW
    "zwkd" // KGT
    "zwts" // TWC
    "zyryanka" // ZKP
    "zzor" // DEZ
    "ørland" // OLA
    "ørsta" // HOV
    "þorshofn" // THO
    "ławica" // POZ
    "łodz" // LCJ
    "ηρακλειου" // HER
    "κalimnos" // JKL
    "καλυμνοσ" // JKL
    "аstana" // NQZ
    "акжол" // URA
    "актау" // SCO
    "актобе" // AKX
    "алматы" // ALA
    "атма" // GUW
    "бря" // BZK
    "джуба" // JUB
    "жезказган" // DZN
    "караганда" // KGF
    "кокшетау" // KOV
    "костанаи" // KSN
    "кызыл" // KZO
    "летище" // JUB
    "орда" // KZO
    "оскемен" // UKK
    "павлодар" // PWQ
    "петропавловск" // PPK
    "семеи" // PLX
    "тараз" // DMB
    "тоо" // PLX
    "шымкент" // CIT
    "अगरतला" // IXA
    "अगात्ती" // AGX
    "अमतृ" // ATQ
    "अमृतसर" // ATQ
    "अहमदाबाद" // AMD
    "आइजोल" // AJL
    "इंदौर" // IDR
    "इलाहाबाद" // IXD
    "उदयपुर" // UDR
    "ओजार" // ISK
    "औरंगाबाद" // IXU
    "कडप्पा" // CDP
    "कन्नूर" // CNN
    "कांडला" // IXY
    "कानपुर" // KNU
    "कालाबुगी" // GBI
    "कालीकट" // CCJ
    "कााँगड़ा" // DHM
    "कोचीन" // COK
    "कोटा" // KTU
    "कोयंबटू" // CJB
    "कोयंबटूर" // CJB
    "कोलकाता" // CCU
    "कोल्हापुर" // KLH
    "खजुराहो" // HJR
    "गग्गल" // DHM
    "गया" // GAY
    "गोरखपुर" // GOP
    "गोवा" // GOI
    "ग्वातलयर" // GWL
    "ग्वात्रलयर" // GWL
    "चके" // KNU
    "चेन्नई" // MAA
    "जगदलपुर" // JGB
    "जबलपुर" // JLR
    "जम्मू" // IXJ
    "जयपुर" // JAI
    "जामनगर" // JGA
    "जैसलमेर" // JSA
    "जोधपुर" // JDH
    "जोरहाट" // JRH
    "ततरुपतत" // TIR
    "तशमला" // SLV
    "तशरडी" // SAG
    "तशलांग" // SHL
    "तसलचर" // IXS
    "तूतीकोररन" // TCR
    "तेजपुर" // TEZ
    "त्रकशनगढ़" // KQH
    "त्रडब्रूगढ़" // DIB
    "त्रतरुपत्रत" // TIR
    "त्रदल्ली" // DEL
    "त्रपथौरागढ़" // NNS
    "त्रवजयवाड़ा" // VGA
    "त्रवजयानगर" // VDY
    "त्रवशाखापत्तनम" // VTZ
    "त्रशमला" // SLV
    "त्रशरडी" // SAG
    "त्रशलांग" // SHL
    "त्रसलचर" // IXS
    "त्रहसार" // HSS
    "त्रिची" // TRZ
    "त्रिवेंद्रम" // TRV
    "दकशनगढ़" // KQH
    "दगु" // RDP
    "दडब्रूगढ़" // DIB
    "ददल्ली" // DEL
    "दहसार" // HSS
    "दीमापुर" // DMU
    "दीव" // DIU
    "दुगाटपुर" // RDP
    "देहरादनू" // DED
    "देहरादू" // DED
    "नांदेड" // NDC
    "नागपुर" // NAG
    "नातसक" // ISK
    "नात्रसक" // ISK
    "पटना" // PAT
    "पन्त" // PGH
    "पाकयोंग" // PYG
    "पाकयोगं" // PYG
    "पासीघाट" // IXT
    "पुणे" // PNQ
    "पुदचु" // PNY
    "पुदुचेरी" // PNY
    "पोटट" // IXZ
    "पोरबंदर" // PBD
    "प्रयागराज" // IXD
    "बत्र" // BUP
    "बागडोगरा" // IXB
    "बारापानी" // SHL
    "बीकानेर" // BKB
    "बेंगलुरु" // BLR
    "बेलगाम" // IXG
    "ब्लेयर" // IXZ
    "भाव" // BHU
    "भुंतर" // KUU
    "भुज" // BHJ
    "भुवनेश्वर" // BBI
    "भोपाल" // BHO
    "मंगलौर" // IXE
    "मदरु" // IXM
    "मदुरै" // IXM
    "मुंबई" // BOM
    "मैसूर" // MYQ
    "राजकोट" // RAJ
    "राजामुंदरी" // RJA
    "रायपुर" // RPR
    "लखनऊ" // LKO
    "लखीमपुर" // IXI
    "लीलाबाड़ी" // IXI
    "लुतधयाना" // LUH
    "लुत्रधयाना" // LUH
    "लेंगपुई" // AJL
    "लेह" // IXL
    "वड़ोदरा" // BDQ
    "वाराणसी" // VNS
    "श्रीनगर" // SXR
    "सलेम" // SXV
    "सूरत" // STV
    "सोलापुर" // SSE
    "हाल" // ISK
    "हुबली" // HBX
    "हैदराबाद" // HYD
    "ाटपुर" // RDP
    "ानकोट" // IXP
    "ेरी" // PNY
    "“albrecht" // NUE
    "“helmut" // HAM
    "万州五桥机场" // WXN
    "三亚凤凰国际机场" // SYX
    "三宅島" // MYE
    "三明沙县机场" // SQJ
    "上海浦东国际机场" // PVG
    "上海虹桥国际机场" // SHA
    "上饶三清山机场" // SQD
    "下地島" // SHI
    "与那国" // OGN
    "东营胜利机场" // DOY
    "中卫沙坡头机场" // ZHY
    "中標津" // SHB
    "中部国際" // NGO
    "临汾乔李机场" // LFQ
    "临沂沭埠岭国际机场" // LYI
    "临沧机场" // LNJ
    "丹东浪头机场" // DDG
    "丽江三义国际机场" // LJG
    "久米島" // UEO
    "义乌机场" // YIW
    "乌兰察布集宁机场" // UCB
    "乌兰浩特义勒力特机场" // HLH
    "乌海机场" // WUA
    "乌鲁木齐地窝堡国际机场" // URC
    "九寨黄龙机场" // JZH
    "二连浩特赛乌苏国际机场" // ERL
    "井冈山机场" // JGS
    "伊宁机场" // YIN
    "伊春林都机场" // LDS
    "佛山沙堤机场" // FUO
    "佳木斯东郊机场" // JMU
    "保山云瑞机场" // BSD
    "信阳明港机场" // XAI
    "克拉玛依机场" // KRY
    "八丈島" // HAC
    "六盘水月照机场" // LPF
    "兰州中川国际机场" // LHW
    "兴义万峰林机场" // ACX
    "凯里黄平机场" // KJH
    "加格达奇机场" // JGD
    "包头东河机场" // BAV
    "北九州" // KKJ
    "北京南苑机场" // NAY
    "北京大兴国际机场" // PKX
    "北京首都国际机场" // PEK
    "北大東" // KTD
    "北海福成机场" // BHY
    "十堰武当山机场" // WDS
    "南京禄口国际机场" // NKG
    "南充高坪机场" // NAO
    "南大東" // MMD
    "南宁吴圩国际机场" // NNG
    "南昌昌北国际机场" // KHN
    "南紀白浜" // SHM
    "南通兴东国际机场" // NTG
    "南阳姜营机场" // NNY
    "博乐阿拉山口机场" // BPL
    "卡拉杰国际机场" // PYK
    "厦门高崎国际机场" // XMN
    "台州路桥机场" // HYN
    "合肥新桥国际机场" // HFE
    "名古屋" // NKM
    "吐鲁番交河机场" // TLQ
    "吕梁大武机场" // LLV
    "呼伦贝尔海拉尔机场" // HLD
    "呼和浩特白塔国际机场" // HET
    "和田机场" // HTN
    "哈密机场" // HMI
    "哈尔滨太平国际机场" // HRB
    "唐山三女河机场" // TVS
    "喀什机场" // KHG
    "嘉峪关机场" // JGN
    "固原六盘山机场" // GYU
    "图木舒克唐王城机场" // TWC
    "塔城机场" // TCG
    "多良間" // TRA
    "大同云冈机场" // DAT
    "大庆萨尔图机场" // DQA
    "大理机场" // DLU
    "大连周水子国际机场" // DLC
    "大阪国際" // ITM
    "大館能代" // ONJ
    "天水麦积山机场" // THQ
    "天津滨海国际机场" // TSN
    "太原武宿国际机场" // TYN
    "女満別" // MMB
    "威海大水泊国际机场" // WEH
    "宁波栎社国际机场" // NGB
    "宁蒗泸沽湖机场" // NLH
    "安庆天柱山机场" // AQG
    "安康五里铺机场" // AKA
    "安顺黄果树机场" // AVA
    "宜宾五粮液机场" // YBP
;
static const char name1_string_table_1[] =
    "宜昌三峡机场" // YIH
    "宜春明月山机场" // YIC
    "富蕴可可托海机场" // FYN
    "屋久島" // KUM
    "山口宇部" // UBJ
    "岳阳三荷机场" // YYA
    "巴中恩阳机场" // BZX
    "巴彦淖尔天吉泰机场" // RLK
    "布尔津喀纳斯机场" // KJI
    "常州奔牛国际机场" // CZX
    "常德桃花源机场" // CGD
    "广元盘龙机场" // GYS
    "广州白云国际机场" // CAN
    "庆阳机场" // IQN
    "库尔勒机场" // KRL
    "库车龟兹机场" // KCA
    "延吉朝阳川国际机场" // YNJ
    "延安南泥湾机场" // ENY
    "建三江湿地机场" // JSJ
    "张家口宁远机场" // ZQZ
    "张家界荷花国际机场" // DYG
    "张掖甘州机场" // YZY
    "徐州观音国际机场" // XUZ
    "徳之島" // TKN
    "德令哈机场" // HXD
    "德宏芒市机场" // LUM
    "忻州五台山机场" // WUT
    "怀化芷江机场" // HJJ
    "恩施许家坪机场" // ENH
    "惠州平潭机场" // HUZ
    "慶良間" // KJP
    "成都双流国际机场" // CTU
    "扎兰屯成吉思汗机场" // NZL
    "扬州泰州国际机场" // YTY
    "承德普宁机场" // CDE
    "抚远东极机场" // FYJ
    "拉萨贡嘎机场" // LXA
    "揭阳潮汕国际机场" // SWA
    "攀枝花保安营机场" // PZI
    "敦煌机场" // DNH
    "文山普者黑机场" // WNH
    "新千歳" // CTS
    "新源那拉提机场" // NLT
    "日喀则和平机场" // RKZ
    "日照山字河机场" // RIZ
    "昆明长水国际机场" // KMG
    "昌都邦达机场" // BPX
    "昭通机场" // ZAT
    "普洱思茅机场" // SYM
    "景德镇罗家机场" // JDZ
    "朝阳机场" // CHG
    "杭州萧山国际机场" // HGH
    "松原查干湖机场" // YSQ
    "林芝米林机场" // LZY
    "果洛玛沁机场" // GMQ
    "柳州白莲机场" // LZH
    "格尔木机场" // GOQ
    "桂林两江国际机场" // KWL
    "梅县长岗岌机场" // MXZ
    "梧州西江机场" // WUZ
    "榆林榆阳机场" // UYN
    "武夷山机场" // WUS
    "武汉天河国际机场" // WUH
    "毕节飞雄机场" // BFJ
    "永州零陵机场" // LLF
    "汉中城固机场" // HZG
    "池州九华山机场" // JUH
    "沈阳桃仙国际机场" // SHE
    "沖永良部" // OKE
    "沧源佤山机场" // CWJ
    "河池金城江机场" // HCJ
    "泉州晋江国际机场" // JJN
    "泸州云龙机场" // LZO
    "洛阳北郊机场" // LYA
    "济南遥墙国际机场" // TNA
    "济宁曲阜机场" // JNG
    "海北祁连机场" // HBQ
    "海口美兰国际机场" // HAK
    "淮安涟水机场" // HIA
    "深圳宝安国际机场" // SZX
    "温州龙湾国际机场" // WNZ
    "湛江坡头机场" // ZHA
    "满洲里西郊机场" // NZH
    "漠河古莲机场" // OHE
    "潍坊机场" // WEF
    "澜沧景迈机场" // JMJ
    "烟台蓬莱国际机场" // YNT
    "牡丹江海浪国际机场" // MDG
    "玉树巴塘机场" // YUS
    "珠海金湾机场" // ZUH
    "琼海博鳌机场" // BAR
    "甘南夏河机场" // GXH
    "甘孜康定机场" // KGT
    "甘孜格萨尔机场" // GZG
    "白城长安机场" // DBC
    "百色巴马机场" // AEB
    "盐城南洋国际机场" // YNZ
    "石家庄正定国际机场" // SJW
    "石河子花园机场" // SHF
    "神农架红坪机场" // HPG
    "福州长乐国际机场" // FOC
    "秦皇岛北戴河机场" // BPE
    "種子島" // TNE
    "稻城亚丁机场" // DCY
    "绵阳南郊机场" // MIG
    "腾冲驼峰机场" // TCZ
    "舟山普陀山机场" // HSN
    "苏南硕放国际机场" // WUX
    "茫崖花土沟机场" // HTT
    "荔波机场" // LLB
    "营口兰旗机场" // YKH
    "衡阳南岳机场" // HNY
    "衢州机场" // JUZ
    "襄阳刘集机场" // XFN
    "西双版纳嘎洒国际机场" // JHG
    "西宁曹家堡国际机场" // XNN
    "西安咸阳国际机场" // XIY
    "西昌青山机场" // XIC
    "贵阳龙洞堡国际机场" // KWE
    "赣州黄金机场" // KOW
    "赤峰玉龙机场" // CIF
    "达州河市机场" // DAX
    "运城关公机场" // YCU
    "连云港白塔埠机场" // LYG
    "迪庆香格里拉机场" // DIG
    "通化三源浦机场" // TNH
    "通辽机场" // TGO
    "遵义新舟机场" // ZYI
    "遵义茅台机场" // WMT
    "邯郸机场" // HDG
    "邵阳武冈机场" // WGN
    "郑州新郑国际机场" // CGO
    "鄂尔多斯伊金霍洛国际机场" // DSN
    "重庆巫山机场" // WSK
    "重庆江北国际机场" // CKG
    "金昌金川机场" // JIC
    "铜仁凤凰机场" // TEN
    "银川河东国际机场" // INC
    "锡林浩特机场" // XIL
    "锦州湾机场" // JNZ
    "长春龙嘉国际机场" // CGQ
    "长沙黄花国际机场" // CSX
    "长治王村机场" // CIH
    "长海大长山岛机场" // CNI
    "长白山机场" // NBS
    "関西国際" // KIX
    "阜阳西关机场" // FUG
    "阿克苏温宿机场" // AKU
    "阿勒泰机场" // AAT
    "阿坝红原机场" // AHJ
    "阿尔山伊尔施机场" // YIE
    "阿拉善右旗巴丹吉林机场" // RHT
    "阿拉善左旗巴彦浩特机场" // AXF
    "陇南成县机场" // LNL
    "霍林郭勒霍林河机场" // HUO
    "青岛流亭国际机场" // TAO
    "鞍山腾鳌机场" // AOG
    "额济纳旗桃来机场" // EJN
    "鸡西兴凯湖机场" // JXA
    "鹿児島" // KOJ
    "黄山屯溪国际机场" // TXN
    "黎平机场" // HZH
    "黑河瑷珲机场" // HEK
    "黔江武陵山机场" // JIQ
    "齐齐哈尔三家子机场" // NDG
    "龙岩冠豸山机场" // LCX
    "（羽田）" // HND
;

// string table indices into name_string_table
static const Name1Index name1_string_index[] = {
    Name1Index{0, 6, 4061},
    Name1Index{6, 7, 9},
    Name1Index{13, 6, 15},
    Name1Index{19, 7, 2810},
    Name1Index{26, 5, 69},
    Name1Index{31, 6, 25},
    Name1Index{37, 7, 27},
    Name1Index{44, 6, 22},
    Name1Index{50, 5, 631},
    Name1Index{55, 6, 713},
    Name1Index{61, 6, 579},
    Name1Index{67, 5, 570},
    Name1Index{72, 10, 7270},
    Name1Index{82, 10, 2144},
    Name1Index{92, 4, 1649},
    Name1Index{96, 5, 1649},
    Name1Index{101, 10, 6044},
    Name1Index{111, 8, 2132},
    Name1Index{119, 9, 2151},
    Name1Index{128, 11, 7095},
    Name1Index{139, 5, 7377},
    Name1Index{144, 4, 5680},
    Name1Index{148, 8, 6050},
    Name1Index{156, 7, 89},
    Name1Index{163, 7, 4705},
    Name1Index{170, 7, 4705},
    Name1Index{177, 4, 130},
    Name1Index{181, 7, 30},
    Name1Index{188, 8, 28},
    Name1Index{196, 7, 36},
    Name1Index{203, 4, 259},
    Name1Index{207, 5, 3318},
    Name1Index{212, 8, 170},
    Name1Index{220, 7, 4961},
    Name1Index{227, 8, 5607},
    Name1Index{235, 7, 100},
    Name1Index{242, 8, 299},
    Name1Index{250, 6, 50},
    Name1Index{256, 8, 47},
    Name1Index{264, 8, 3809},
    Name1Index{272, 7, 59},
    Name1Index{279, 6, 5745},
    Name1Index{285, 8, 61},
    Name1Index{293, 6, 3968},
    Name1Index{299, 5, 3500},
    Name1Index{304, 5, 3},
    Name1Index{309, 4, 76},
    Name1Index{313, 4, 267},
    Name1Index{317, 5, 66},
    Name1Index{322, 4, 3823},
    Name1Index{326, 9, 1722},
    Name1Index{335, 5, 69},
    Name1Index{340, 7, 83},
    Name1Index{347, 8, 77},
    Name1Index{355, 4, 4938},
    Name1Index{359, 6, 6203},
    Name1Index{365, 10, 5626},
    Name1Index{375, 10, 2866},
    Name1Index{385, 10, 5686},
    Name1Index{395, 5, 97},
    Name1Index{400, 5, 67},
    Name1Index{405, 5, 4692},
    Name1Index{410, 5, 445},
    Name1Index{415, 8, 3332},
    Name1Index{423, 9, 71},
    Name1Index{432, 3, 91},
    Name1Index{435, 3, 146},
    Name1Index{438, 5, 5106},
    Name1Index{443, 5, 1243},
    Name1Index{448, 11, 1243},
    Name1Index{459, 10, 95},
    Name1Index{469, 11, 542},
    Name1Index{480, 8, 2280},
    Name1Index{488, 4, 1126},
    Name1Index{492, 5, 109},
    Name1Index{497, 6, 4240},
    Name1Index{503, 5, 108},
    Name1Index{508, 7, 110},
    Name1Index{515, 5, 112},
    Name1Index{520, 6, 114},
    Name1Index{526, 8, 2749},
    Name1Index{534, 6, 128},
    Name1Index{540, 5, 382},
    Name1Index{545, 4, 944},
    Name1Index{549, 4, 117},
    Name1Index{553, 8, 129},
    Name1Index{561, 4, 3721},
    Name1Index{565, 8, 192},
    Name1Index{573, 9, 5246},
    Name1Index{582, 9, 1204},
    Name1Index{591, 5, 3421},
    Name1Index{596, 5, 164},
    Name1Index{601, 8, 949},
    Name1Index{609, 9, 2345},
    Name1Index{618, 9, 55},
    Name1Index{627, 5, 4449},
    Name1Index{632, 14, 126},
    Name1Index{646, 7, 6133},
    Name1Index{653, 6, 6558},
    Name1Index{659, 5, 119},
    Name1Index{664, 5, 4567},
    Name1Index{669, 9, 2597},
    Name1Index{678, 5, 3240},
    Name1Index{683, 9, 220},
    Name1Index{692, 3, 4384},
    Name1Index{695, 4, 2466},
    Name1Index{699, 5, 141},
    Name1Index{704, 5, 408},
    Name1Index{709, 5, 408},
    Name1Index{714, 4, 5558},
    Name1Index{718, 7, 150},
    Name1Index{725, 4, 863},
    Name1Index{729, 4, 6633},
    Name1Index{733, 5, 2373},
    Name1Index{738, 5, 152},
    Name1Index{743, 5, 153},
    Name1Index{748, 4, 1878},
    Name1Index{752, 9, 255},
    Name1Index{761, 5, 147},
    Name1Index{766, 5, 94},
    Name1Index{771, 5, 5125},
    Name1Index{776, 8, 2645},
    Name1Index{784, 9, 2797},
    Name1Index{793, 8, 1030},
    Name1Index{801, 4, 5279},
    Name1Index{805, 5, 145},
    Name1Index{810, 8, 6510},
    Name1Index{818, 9, 137},
    Name1Index{827, 6, 359},
    Name1Index{833, 8, 158},
    Name1Index{841, 3, 1188},
    Name1Index{844, 6, 435},
    Name1Index{850, 6, 167},
    Name1Index{856, 7, 162},
    Name1Index{863, 3, 760},
    Name1Index{866, 5, 5061},
    Name1Index{871, 5, 3171},
    Name1Index{876, 6, 1681},
    Name1Index{882, 4, 3461},
    Name1Index{886, 5, 1766},
    Name1Index{891, 3, 3285},
    Name1Index{894, 7, 6133},
    Name1Index{901, 6, 182},
    Name1Index{907, 5, 180},
    Name1Index{912, 6, 177},
    Name1Index{918, 5, 422},
    Name1Index{923, 7, 165},
    Name1Index{930, 7, 3312},
    Name1Index{937, 5, 176},
    Name1Index{942, 4, 190},
    Name1Index{946, 5, 5445},
    Name1Index{951, 6, 5013},
    Name1Index{957, 6, 193},
    Name1Index{963, 10, 193},
    Name1Index{973, 8, 191},
    Name1Index{981, 5, 188},
    Name1Index{986, 8, 102},
    Name1Index{994, 6, 3170},
    Name1Index{1000, 4, 5109},
    Name1Index{1004, 7, 197},
    Name1Index{1011, 8, 377},
    Name1Index{1019, 7, 1430},
    Name1Index{1026, 7, 1430},
    Name1Index{1033, 10, 206},
    Name1Index{1043, 6, 3314},
    Name1Index{1049, 6, 2323},
    Name1Index{1055, 10, 758},
    Name1Index{1065, 8, 24},
    Name1Index{1073, 6, 4348},
    Name1Index{1079, 7, 294},
    Name1Index{1086, 9, 1099},
    Name1Index{1095, 7, 205},
    Name1Index{1102, 7, 7126},
    Name1Index{1109, 8, 1890},
    Name1Index{1117, 6, 2824},
    Name1Index{1123, 6, 35},
    Name1Index{1129, 6, 6020},
    Name1Index{1135, 6, 6737},
    Name1Index{1141, 7, 4665},
    Name1Index{1148, 5, 846},
    Name1Index{1153, 11, 38},
    Name1Index{1164, 6, 44},
    Name1Index{1170, 6, 2502},
    Name1Index{1176, 9, 5744},
    Name1Index{1185, 9, 1845},
    Name1Index{1194, 7, 50},
    Name1Index{1201, 7, 4735},
    Name1Index{1208, 5, 73},
    Name1Index{1213, 10, 566},
    Name1Index{1223, 8, 53},
    Name1Index{1231, 8, 210},
    Name1Index{1239, 9, 1345},
    Name1Index{1248, 9, 6704},
    Name1Index{1257, 14, 5072},
    Name1Index{1271, 5, 1232},
    Name1Index{1276, 6, 209},
    Name1Index{1282, 4, 97},
    Name1Index{1286, 6, 198},
    Name1Index{1292, 4, 1947},
    Name1Index{1296, 7, 98},
    Name1Index{1303, 9, 211},
    Name1Index{1312, 15, 412},
    Name1Index{1327, 10, 5942},
    Name1Index{1337, 6, 3772},
    Name1Index{1343, 7, 140},
    Name1Index{1350, 7, 201},
    Name1Index{1357, 6, 415},
    Name1Index{1363, 8, 2637},
    Name1Index{1371, 4, 226},
    Name1Index{1375, 8, 197},
    Name1Index{1383, 13, 7127},
    Name1Index{1396, 6, 2309},
    Name1Index{1402, 5, 19},
    Name1Index{1407, 9, 2751},
    Name1Index{1416, 9, 99},
    Name1Index{1425, 6, 3430},
    Name1Index{1431, 7, 87},
    Name1Index{1438, 9, 115},
    Name1Index{1447, 9, 26},
    Name1Index{1456, 6, 1935},
    Name1Index{1462, 4, 7207},
    Name1Index{1466, 8, 2707},
    Name1Index{1474, 6, 195},
    Name1Index{1480, 8, 2104},
    Name1Index{1488, 7, 3385},
    Name1Index{1495, 7, 6594},
    Name1Index{1502, 9, 2707},
    Name1Index{1511, 5, 2767},
    Name1Index{1516, 6, 1307},
    Name1Index{1522, 4, 302},
    Name1Index{1526, 6, 279},
    Name1Index{1532, 5, 29},
    Name1Index{1537, 8, 4968},
    Name1Index{1545, 4, 200},
    Name1Index{1549, 5, 3601},
    Name1Index{1554, 8, 356},
    Name1Index{1562, 5, 17},
    Name1Index{1567, 7, 5213},
    Name1Index{1574, 9, 258},
    Name1Index{1583, 10, 52},
    Name1Index{1593, 11, 1646},
    Name1Index{1604, 5, 197},
    Name1Index{1609, 5, 406},
    Name1Index{1614, 7, 268},
    Name1Index{1621, 5, 21},
    Name1Index{1626, 5, 421},
    Name1Index{1631, 7, 47},
    Name1Index{1638, 6, 4373},
    Name1Index{1644, 8, 7353},
    Name1Index{1652, 3, 221},
    Name1Index{1655, 6, 135},
    Name1Index{1661, 6, 5789},
    Name1Index{1667, 5, 329},
    Name1Index{1672, 6, 233},
    Name1Index{1678, 6, 1081},
    Name1Index{1684, 5, 7377},
    Name1Index{1689, 7, 1261},
    Name1Index{1696, 8, 217},
    Name1Index{1704, 5, 232},
    Name1Index{1709, 6, 439},
    Name1Index{1715, 8, 6642},
    Name1Index{1723, 14, 6644},
    Name1Index{1737, 8, 4204},
    Name1Index{1745, 8, 218},
    Name1Index{1753, 6, 33},
    Name1Index{1759, 9, 4188},
    Name1Index{1768, 6, 4693},
    Name1Index{1774, 8, 3876},
    Name1Index{1782, 8, 340},
    Name1Index{1790, 7, 2830},
    Name1Index{1797, 6, 447},
    Name1Index{1803, 8, 1243},
    Name1Index{1811, 7, 376},
    Name1Index{1818, 7, 234},
    Name1Index{1825, 10, 6622},
    Name1Index{1835, 6, 2573},
    Name1Index{1841, 7, 3335},
    Name1Index{1848, 8, 5470},
    Name1Index{1856, 5, 134},
    Name1Index{1861, 4, 235},
    Name1Index{1865, 4, 1763},
    Name1Index{1869, 5, 2924},
    Name1Index{1874, 9, 3629},
    Name1Index{1883, 5, 4264},
    Name1Index{1888, 4, 6969},
    Name1Index{1892, 5, 5944},
    Name1Index{1897, 11, 2741},
    Name1Index{1908, 8, 229},
    Name1Index{1916, 10, 2741},
    Name1Index{1926, 6, 80},
    Name1Index{1932, 7, 80},
    Name1Index{1939, 8, 360},
    Name1Index{1947, 5, 460},
    Name1Index{1952, 4, 0},
    Name1Index{1956, 8, 1979},
    Name1Index{1964, 5, 12},
    Name1Index{1969, 9, 4621},
    Name1Index{1978, 7, 260},
    Name1Index{1985, 6, 6884},
    Name1Index{1991, 9, 187},
    Name1Index{2000, 9, 2544},
    Name1Index{2009, 5, 14},
    Name1Index{2014, 8, 283},
    Name1Index{2022, 4, 2680},
    Name1Index{2026, 9, 6594},
    Name1Index{2035, 9, 239},
    Name1Index{2044, 6, 263},
    Name1Index{2050, 4, 5467},
    Name1Index{2054, 11, 253},
    Name1Index{2065, 9, 68},
    Name1Index{2074, 9, 79},
    Name1Index{2083, 6, 7415},
    Name1Index{2089, 11, 1623},
    Name1Index{2100, 7, 256},
    Name1Index{2107, 6, 2379},
    Name1Index{2113, 8, 4453},
    Name1Index{2121, 4, 4142},
    Name1Index{2125, 6, 6471},
    Name1Index{2131, 8, 443},
    Name1Index{2139, 6, 256},
    Name1Index{2145, 7, 4847},
    Name1Index{2152, 5, 2233},
    Name1Index{2157, 8, 2331},
    Name1Index{2165, 7, 2097},
    Name1Index{2172, 6, 246},
    Name1Index{2178, 7, 256},
    Name1Index{2185, 6, 4626},
    Name1Index{2191, 6, 237},
    Name1Index{2197, 6, 765},
    Name1Index{2203, 7, 6712},
    Name1Index{2210, 8, 3402},
    Name1Index{2218, 6, 241},
    Name1Index{2224, 5, 116},
    Name1Index{2229, 15, 6829},
    Name1Index{2244, 8, 6577},
    Name1Index{2252, 6, 624},
    Name1Index{2258, 7, 6900},
    Name1Index{2265, 7, 249},
    Name1Index{2272, 9, 243},
    Name1Index{2281, 9, 179},
    Name1Index{2290, 8, 409},
    Name1Index{2298, 5, 244},
    Name1Index{2303, 6, 1117},
    Name1Index{2309, 6, 224},
    Name1Index{2315, 5, 403},
    Name1Index{2320, 6, 173},
    Name1Index{2326, 6, 1801},
    Name1Index{2332, 10, 2905},
    Name1Index{2342, 3, 300},
    Name1Index{2345, 4, 3681},
    Name1Index{2349, 6, 4},
    Name1Index{2355, 5, 4206},
    Name1Index{2360, 9, 6944},
    Name1Index{2369, 6, 4243},
    Name1Index{2375, 7, 248},
    Name1Index{2382, 8, 238},
    Name1Index{2390, 7, 4226},
    Name1Index{2397, 6, 293},
    Name1Index{2403, 4, 1589},
    Name1Index{2407, 6, 261},
    Name1Index{2413, 6, 391},
    Name1Index{2419, 4, 345},
    Name1Index{2423, 7, 1827},
    Name1Index{2430, 7, 349},
    Name1Index{2437, 11, 242},
    Name1Index{2448, 7, 1383},
    Name1Index{2455, 6, 48},
    Name1Index{2461, 9, 6647},
    Name1Index{2470, 11, 247},
    Name1Index{2481, 9, 353},
    Name1Index{2490, 6, 6656},
    Name1Index{2496, 7, 252},
    Name1Index{2503, 4, 727},
    Name1Index{2507, 5, 254},
    Name1Index{2512, 6, 428},
    Name1Index{2518, 6, 5056},
    Name1Index{2524, 10, 669},
    Name1Index{2534, 6, 264},
    Name1Index{2540, 5, 271},
    Name1Index{2545, 6, 2145},
    Name1Index{2551, 4, 2479},
    Name1Index{2555, 12, 5},
    Name1Index{2567, 10, 16},
    Name1Index{2577, 7, 277},
    Name1Index{2584, 7, 3264},
    Name1Index{2591, 10, 441},
    Name1Index{2601, 3, 4495},
    Name1Index{2604, 10, 3845},
    Name1Index{2614, 5, 274},
    Name1Index{2619, 6, 4369},
    Name1Index{2625, 7, 4484},
    Name1Index{2632, 5, 286},
    Name1Index{2637, 8, 365},
    Name1Index{2645, 5, 282},
    Name1Index{2650, 9, 285},
    Name1Index{2659, 5, 3559},
    Name1Index{2664, 6, 5062},
    Name1Index{2670, 6, 3957},
    Name1Index{2676, 7, 171},
    Name1Index{2683, 9, 316},
    Name1Index{2692, 7, 2700},
    Name1Index{2699, 4, 318},
    Name1Index{2703, 6, 312},
    Name1Index{2709, 6, 1173},
    Name1Index{2715, 8, 5458},
    Name1Index{2723, 4, 166},
    Name1Index{2727, 6, 411},
    Name1Index{2733, 7, 5044},
    Name1Index{2740, 7, 74},
    Name1Index{2747, 6, 5112},
    Name1Index{2753, 7, 5254},
    Name1Index{2760, 7, 8},
    Name1Index{2767, 8, 133},
    Name1Index{2775, 9, 288},
    Name1Index{2784, 4, 5122},
    Name1Index{2788, 10, 58},
    Name1Index{2798, 10, 291},
    Name1Index{2808, 6, 319},
    Name1Index{2814, 7, 5249},
    Name1Index{2821, 6, 370},
    Name1Index{2827, 9, 7325},
    Name1Index{2836, 5, 5969},
    Name1Index{2841, 5, 5137},
    Name1Index{2846, 6, 2208},
    Name1Index{2852, 4, 222},
    Name1Index{2856, 7, 6241},
    Name1Index{2863, 5, 1664},
    Name1Index{2868, 5, 300},
    Name1Index{2873, 6, 62},
    Name1Index{2879, 7, 85},
    Name1Index{2886, 7, 2891},
    Name1Index{2893, 6, 1956},
    Name1Index{2899, 8, 297},
    Name1Index{2907, 6, 1804},
    Name1Index{2913, 10, 6433},
    Name1Index{2923, 8, 6810},
    Name1Index{2931, 7, 5053},
    Name1Index{2938, 8, 156},
    Name1Index{2946, 5, 2},
    Name1Index{2951, 11, 5650},
    Name1Index{2962, 9, 863},
    Name1Index{2971, 11, 3211},
    Name1Index{2982, 12, 3053},
    Name1Index{2994, 7, 4050},
    Name1Index{3001, 4, 3010},
    Name1Index{3005, 7, 427},
    Name1Index{3012, 11, 305},
    Name1Index{3023, 7, 311},
    Name1Index{3030, 5, 1947},
    Name1Index{3035, 5, 5265},
    Name1Index{3040, 4, 309},
    Name1Index{3044, 3, 7197},
    Name1Index{3047, 7, 935},
    Name1Index{3054, 7, 417},
    Name1Index{3061, 8, 310},
    Name1Index{3069, 5, 5419},
    Name1Index{3074, 9, 225},
    Name1Index{3083, 4, 1840},
    Name1Index{3087, 6, 3492},
    Name1Index{3093, 5, 5101},
    Name1Index{3098, 6, 3330},
    Name1Index{3104, 7, 5400},
    Name1Index{3111, 3, 3977},
    Name1Index{3114, 11, 1755},
    Name1Index{3125, 9, 3213},
    Name1Index{3134, 9, 6676},
    Name1Index{3143, 6, 157},
    Name1Index{3149, 5, 4256},
    Name1Index{3154, 4, 5711},
    Name1Index{3158, 8, 1},
    Name1Index{3166, 9, 1488},
    Name1Index{3175, 7, 6},
    Name1Index{3182, 7, 5631},
    Name1Index{3189, 6, 1780},
    Name1Index{3195, 7, 4655},
    Name1Index{3202, 7, 313},
    Name1Index{3209, 7, 4153},
    Name1Index{3216, 4, 307},
    Name1Index{3220, 3, 709},
    Name1Index{3223, 7, 362},
    Name1Index{3230, 7, 352},
    Name1Index{3237, 10, 1917},
    Name1Index{3247, 6, 5094},
    Name1Index{3253, 4, 5346},
    Name1Index{3257, 6, 308},
    Name1Index{3263, 6, 420},
    Name1Index{3269, 10, 393},
    Name1Index{3279, 6, 6959},
    Name1Index{3285, 10, 169},
    Name1Index{3295, 5, 7023},
    Name1Index{3300, 5, 23},
    Name1Index{3305, 9, 181},
    Name1Index{3314, 9, 6958},
    Name1Index{3323, 8, 6958},
    Name1Index{3331, 5, 281},
    Name1Index{3336, 4, 18},
    Name1Index{3340, 9, 323},
    Name1Index{3349, 5, 92},
    Name1Index{3354, 9, 327},
    Name1Index{3363, 9, 394},
    Name1Index{3372, 7, 3671},
    Name1Index{3379, 8, 322},
    Name1Index{3387, 7, 138},
    Name1Index{3394, 6, 343},
    Name1Index{3400, 7, 3204},
    Name1Index{3407, 9, 2815},
    Name1Index{3416, 6, 344},
    Name1Index{3422, 4, 4999},
    Name1Index{3426, 6, 5713},
    Name1Index{3432, 6, 332},
    Name1Index{3438, 5, 334},
    Name1Index{3443, 5, 325},
    Name1Index{3448, 5, 321},
    Name1Index{3453, 5, 3602},
    Name1Index{3458, 5, 1817},
    Name1Index{3463, 6, 4730},
    Name1Index{3469, 6, 368},
    Name1Index{3475, 6, 1345},
    Name1Index{3481, 5, 3761},
    Name1Index{3486, 7, 338},
    Name1Index{3493, 8, 4636},
    Name1Index{3501, 10, 2894},
    Name1Index{3511, 8, 339},
    Name1Index{3519, 5, 341},
    Name1Index{3524, 6, 5082},
    Name1Index{3530, 5, 368},
    Name1Index{3535, 3, 1529},
    Name1Index{3538, 7, 1260},
    Name1Index{3545, 7, 437},
    Name1Index{3552, 7, 42},
    Name1Index{3559, 4, 416},
    Name1Index{3563, 4, 361},
    Name1Index{3567, 7, 2721},
    Name1Index{3574, 6, 386},
    Name1Index{3580, 6, 346},
    Name1Index{3586, 7, 366},
    Name1Index{3593, 3, 437},
    Name1Index{3596, 3, 364},
    Name1Index{3599, 8, 7021},
    Name1Index{3607, 4, 174},
    Name1Index{3611, 7, 37},
    Name1Index{3618, 8, 4978},
    Name1Index{3626, 7, 355},
    Name1Index{3633, 10, 4379},
    Name1Index{3643, 10, 363},
    Name1Index{3653, 6, 348},
    Name1Index{3659, 7, 354},
    Name1Index{3666, 7, 94},
    Name1Index{3673, 10, 2642},
    Name1Index{3683, 7, 272},
    Name1Index{3690, 12, 6898},
    Name1Index{3702, 7, 272},
    Name1Index{3709, 4, 3519},
    Name1Index{3713, 5, 5031},
    Name1Index{3718, 6, 383},
    Name1Index{3724, 6, 2283},
    Name1Index{3730, 3, 375},
    Name1Index{3733, 8, 183},
    Name1Index{3741, 3, 6312},
    Name1Index{3744, 7, 4269},
    Name1Index{3751, 8, 7024},
    Name1Index{3759, 4, 189},
    Name1Index{3763, 5, 1529},
    Name1Index{3768, 4, 388},
    Name1Index{3772, 7, 7134},
    Name1Index{3779, 3, 378},
    Name1Index{3782, 10, 2766},
    Name1Index{3792, 5, 482},
    Name1Index{3797, 8, 384},
    Name1Index{3805, 7, 387},
    Name1Index{3812, 10, 985},
    Name1Index{3822, 8, 1057},
    Name1Index{3830, 7, 372},
    Name1Index{3837, 6, 398},
    Name1Index{3843, 8, 6725},
    Name1Index{3851, 5, 5112},
    Name1Index{3856, 7, 5853},
    Name1Index{3863, 5, 828},
    Name1Index{3868, 7, 5187},
    Name1Index{3875, 7, 1251},
    Name1Index{3882, 7, 395},
    Name1Index{3889, 5, 402},
    Name1Index{3894, 5, 982},
    Name1Index{3899, 4, 407},
    Name1Index{3903, 5, 401},
    Name1Index{3908, 5, 2845},
    Name1Index{3913, 4, 423},
    Name1Index{3917, 8, 430},
    Name1Index{3925, 6, 425},
    Name1Index{3931, 7, 436},
    Name1Index{3938, 5, 431},
    Name1Index{3943, 4, 3861},
    Name1Index{3947, 6, 429},
    Name1Index{3953, 4, 1763},
    Name1Index{3957, 6, 1025},
    Name1Index{3963, 4, 3029},
    Name1Index{3967, 5, 2079},
    Name1Index{3972, 7, 43},
    Name1Index{3979, 5, 2694},
    Name1Index{3984, 4, 7410},
    Name1Index{3988, 4, 4232},
    Name1Index{3992, 10, 3721},
    Name1Index{4002, 9, 4204},
    Name1Index{4011, 8, 2599},
    Name1Index{4019, 4, 898},
    Name1Index{4023, 8, 6244},
    Name1Index{4031, 9, 5801},
    Name1Index{4040, 9, 555},
    Name1Index{4049, 5, 498},
    Name1Index{4054, 5, 4744},
    Name1Index{4059, 12, 1333},
    Name1Index{4071, 4, 500},
    Name1Index{4075, 7, 491},
    Name1Index{4082, 7, 651},
    Name1Index{4089, 10, 5224},
    Name1Index{4099, 10, 4839},
    Name1Index{4109, 4, 899},
    Name1Index{4113, 5, 1910},
    Name1Index{4118, 4, 510},
    Name1Index{4122, 9, 571},
    Name1Index{4131, 5, 4419},
    Name1Index{4136, 8, 1602},
    Name1Index{4144, 6, 588},
    Name1Index{4150, 8, 2750},
    Name1Index{4158, 4, 591},
    Name1Index{4162, 7, 590},
    Name1Index{4169, 9, 2750},
    Name1Index{4178, 7, 582},
    Name1Index{4185, 10, 6908},
    Name1Index{4195, 5, 1661},
    Name1Index{4200, 6, 450},
    Name1Index{4206, 4, 41},
    Name1Index{4210, 7, 6587},
    Name1Index{4217, 6, 1962},
    Name1Index{4223, 10, 611},
    Name1Index{4233, 6, 2541},
    Name1Index{4239, 5, 645},
    Name1Index{4244, 7, 451},
    Name1Index{4251, 7, 456},
    Name1Index{4258, 8, 1431},
    Name1Index{4266, 6, 615},
    Name1Index{4272, 6, 6457},
    Name1Index{4278, 7, 3674},
    Name1Index{4285, 7, 479},
    Name1Index{4292, 7, 6581},
    Name1Index{4299, 4, 3704},
    Name1Index{4303, 9, 528},
    Name1Index{4312, 5, 1188},
    Name1Index{4317, 10, 804},
    Name1Index{4327, 5, 90},
    Name1Index{4332, 5, 2378},
    Name1Index{4337, 7, 627},
    Name1Index{4344, 6, 960},
    Name1Index{4350, 6, 649},
    Name1Index{4356, 7, 637},
    Name1Index{4363, 5, 650},
    Name1Index{4368, 5, 2752},
    Name1Index{4373, 6, 647},
    Name1Index{4379, 9, 660},
    Name1Index{4388, 5, 900},
    Name1Index{4393, 13, 634},
    Name1Index{4406, 7, 695},
    Name1Index{4413, 4, 2309},
    Name1Index{4417, 6, 2758},
    Name1Index{4423, 8, 891},
    Name1Index{4431, 7, 459},
    Name1Index{4438, 7, 5685},
    Name1Index{4445, 4, 1653},
    Name1Index{4449, 7, 7401},
    Name1Index{4456, 5, 765},
    Name1Index{4461, 5, 778},
    Name1Index{4466, 6, 3182},
    Name1Index{4472, 6, 4569},
    Name1Index{4478, 8, 902},
    Name1Index{4486, 7, 474},
    Name1Index{4493, 11, 5471},
    Name1Index{4504, 7, 717},
    Name1Index{4511, 6, 297},
    Name1Index{4517, 9, 466},
    Name1Index{4526, 9, 936},
    Name1Index{4535, 6, 812},
    Name1Index{4541, 5, 948},
    Name1Index{4546, 9, 886},
    Name1Index{4555, 9, 5211},
    Name1Index{4564, 10, 1682},
    Name1Index{4574, 3, 910},
    Name1Index{4577, 4, 90},
    Name1Index{4581, 6, 661},
    Name1Index{4587, 7, 486},
    Name1Index{4594, 7, 704},
    Name1Index{4601, 5, 763},
    Name1Index{4606, 7, 750},
    Name1Index{4613, 8, 6907},
    Name1Index{4621, 7, 622},
    Name1Index{4628, 4, 710},
    Name1Index{4632, 6, 622},
    Name1Index{4638, 3, 2465},
    Name1Index{4641, 5, 3463},
    Name1Index{4646, 7, 913},
    Name1Index{4653, 5, 1723},
    Name1Index{4658, 4, 5415},
    Name1Index{4662, 10, 4244},
    Name1Index{4672, 7, 4992},
    Name1Index{4679, 12, 1185},
    Name1Index{4691, 12, 5069},
    Name1Index{4703, 6, 527},
    Name1Index{4709, 8, 1883},
    Name1Index{4717, 7, 3063},
    Name1Index{4724, 7, 482},
    Name1Index{4731, 5, 6903},
    Name1Index{4736, 7, 722},
    Name1Index{4743, 5, 3338},
    Name1Index{4748, 9, 684},
    Name1Index{4757, 9, 589},
    Name1Index{4766, 6, 763},
    Name1Index{4772, 7, 1911},
    Name1Index{4779, 6, 587},
    Name1Index{4785, 6, 1627},
    Name1Index{4791, 6, 577},
    Name1Index{4797, 4, 6868},
    Name1Index{4801, 5, 726},
    Name1Index{4806, 6, 641},
    Name1Index{4812, 4, 1305},
    Name1Index{4816, 9, 895},
    Name1Index{4825, 6, 702},
    Name1Index{4831, 7, 715},
    Name1Index{4838, 5, 721},
    Name1Index{4843, 5, 3588},
    Name1Index{4848, 8, 6103},
    Name1Index{4856, 6, 933},
    Name1Index{4862, 4, 728},
    Name1Index{4866, 5, 5773},
    Name1Index{4871, 7, 6864},
    Name1Index{4878, 7, 801},
    Name1Index{4885, 6, 462},
    Name1Index{4891, 4, 751},
    Name1Index{4895, 7, 3684},
    Name1Index{4902, 9, 657},
    Name1Index{4911, 8, 699},
    Name1Index{4919, 8, 5542},
    Name1Index{4927, 11, 6394},
    Name1Index{4938, 6, 7231},
    Name1Index{4944, 8, 5116},
    Name1Index{4952, 7, 478},
    Name1Index{4959, 10, 495},
    Name1Index{4969, 9, 499},
    Name1Index{4978, 8, 465},
    Name1Index{4986, 5, 3361},
    Name1Index{4991, 7, 817},
    Name1Index{4998, 9, 524},
    Name1Index{5007, 8, 538},
    Name1Index{5015, 9, 781},
    Name1Index{5024, 9, 931},
    Name1Index{5033, 7, 3336},
    Name1Index{5040, 5, 476},
    Name1Index{5045, 7, 941},
    Name1Index{5052, 7, 4670},
    Name1Index{5059, 7, 463},
    Name1Index{5066, 6, 449},
    Name1Index{5072, 10, 2557},
    Name1Index{5082, 8, 718},
    Name1Index{5090, 15, 1712},
    Name1Index{5105, 8, 4222},
    Name1Index{5113, 12, 457},
    Name1Index{5125, 9, 779},
    Name1Index{5134, 12, 780},
    Name1Index{5146, 8, 460},
    Name1Index{5154, 6, 7065},
    Name1Index{5160, 6, 1780},
    Name1Index{5166, 8, 6174},
    Name1Index{5174, 7, 4697},
    Name1Index{5181, 6, 1434},
    Name1Index{5187, 7, 1415},
    Name1Index{5194, 6, 823},
    Name1Index{5200, 5, 471},
    Name1Index{5205, 10, 5417},
    Name1Index{5215, 7, 2100},
    Name1Index{5222, 12, 871},
    Name1Index{5234, 9, 3761},
    Name1Index{5243, 10, 968},
    Name1Index{5253, 6, 6459},
    Name1Index{5259, 5, 3570},
    Name1Index{5264, 8, 2435},
    Name1Index{5272, 7, 3197},
    Name1Index{5279, 9, 814},
    Name1Index{5288, 5, 808},
    Name1Index{5293, 5, 1653},
    Name1Index{5298, 7, 455},
    Name1Index{5305, 6, 624},
    Name1Index{5311, 5, 811},
    Name1Index{5316, 5, 479},
    Name1Index{5321, 6, 3602},
    Name1Index{5327, 9, 4770},
    Name1Index{5336, 6, 614},
    Name1Index{5342, 4, 803},
    Name1Index{5346, 7, 770},
    Name1Index{5353, 6, 7225},
    Name1Index{5359, 9, 821},
    Name1Index{5368, 7, 875},
    Name1Index{5375, 5, 3064},
    Name1Index{5380, 6, 442},
    Name1Index{5386, 10, 876},
    Name1Index{5396, 8, 850},
    Name1Index{5404, 13, 854},
    Name1Index{5417, 4, 6064},
    Name1Index{5421, 5, 3104},
    Name1Index{5426, 9, 5861},
    Name1Index{5435, 5, 677},
    Name1Index{5440, 5, 906},
    Name1Index{5445, 5, 832},
    Name1Index{5450, 9, 635},
    Name1Index{5459, 10, 475},
    Name1Index{5469, 6, 5121},
    Name1Index{5475, 10, 7165},
    Name1Index{5485, 8, 6143},
    Name1Index{5493, 4, 837},
    Name1Index{5497, 6, 853},
    Name1Index{5503, 6, 753},
    Name1Index{5509, 9, 5861},
    Name1Index{5518, 3, 5416},
    Name1Index{5521, 6, 857},
    Name1Index{5527, 6, 494},
    Name1Index{5533, 6, 504},
    Name1Index{5539, 8, 511},
    Name1Index{5547, 5, 269},
    Name1Index{5552, 10, 6568},
    Name1Index{5562, 6, 870},
    Name1Index{5568, 5, 269},
    Name1Index{5573, 5, 887},
    Name1Index{5578, 6, 915},
    Name1Index{5584, 6, 6719},
    Name1Index{5590, 6, 1662},
    Name1Index{5596, 8, 414},
    Name1Index{5604, 12, 929},
    Name1Index{5616, 8, 5263},
    Name1Index{5624, 5, 921},
    Name1Index{5629, 7, 624},
    Name1Index{5636, 7, 2485},
    Name1Index{5643, 5, 1370},
    Name1Index{5648, 8, 934},
    Name1Index{5656, 7, 947},
    Name1Index{5663, 7, 1674},
    Name1Index{5670, 8, 6812},
    Name1Index{5678, 7, 369},
    Name1Index{5685, 6, 838},
    Name1Index{5691, 8, 567},
    Name1Index{5699, 8, 705},
    Name1Index{5707, 10, 1579},
    Name1Index{5717, 8, 861},
    Name1Index{5725, 7, 5515},
    Name1Index{5732, 7, 1834},
    Name1Index{5739, 8, 547},
    Name1Index{5747, 5, 531},
    Name1Index{5752, 4, 1710},
    Name1Index{5756, 5, 6910},
    Name1Index{5761, 9, 4223},
    Name1Index{5770, 8, 759},
    Name1Index{5778, 5, 1234},
    Name1Index{5783, 8, 2604},
    Name1Index{5791, 5, 536},
    Name1Index{5796, 5, 4481},
    Name1Index{5801, 8, 752},
    Name1Index{5809, 6, 3801},
    Name1Index{5815, 6, 613},
    Name1Index{5821, 6, 604},
    Name1Index{5827, 7, 3659},
    Name1Index{5834, 5, 549},
    Name1Index{5839, 6, 550},
    Name1Index{5845, 4, 925},
    Name1Index{5849, 6, 631},
    Name1Index{5855, 3, 570},
    Name1Index{5858, 4, 501},
    Name1Index{5862, 6, 675},
    Name1Index{5868, 6, 584},
    Name1Index{5874, 6, 6376},
    Name1Index{5880, 9, 4453},
    Name1Index{5889, 5, 709},
    Name1Index{5894, 7, 2753},
    Name1Index{5901, 8, 1700},
    Name1Index{5909, 8, 534},
    Name1Index{5917, 8, 2445},
    Name1Index{5925, 8, 445},
    Name1Index{5933, 7, 543},
    Name1Index{5940, 5, 927},
    Name1Index{5945, 10, 3439},
    Name1Index{5955, 10, 5315},
    Name1Index{5965, 8, 2219},
    Name1Index{5973, 9, 2362},
    Name1Index{5982, 7, 727},
    Name1Index{5989, 7, 687},
    Name1Index{5996, 7, 542},
    Name1Index{6003, 9, 688},
    Name1Index{6012, 9, 1843},
    Name1Index{6021, 4, 788},
    Name1Index{6025, 7, 1868},
    Name1Index{6032, 6, 873},
    Name1Index{6038, 7, 638},
    Name1Index{6045, 7, 681},
    Name1Index{6052, 9, 530},
    Name1Index{6061, 6, 798},
    Name1Index{6067, 7, 901},
    Name1Index{6074, 9, 684},
    Name1Index{6083, 6, 568},
    Name1Index{6089, 8, 843},
    Name1Index{6097, 8, 506},
    Name1Index{6105, 4, 540},
    Name1Index{6109, 5, 716},
    Name1Index{6114, 6, 541},
    Name1Index{6120, 7, 5442},
    Name1Index{6127, 7, 640},
    Name1Index{6134, 7, 2098},
    Name1Index{6141, 13, 828},
    Name1Index{6154, 6, 1411},
    Name1Index{6160, 8, 809},
    Name1Index{6168, 6, 467},
    Name1Index{6174, 7, 4115},
    Name1Index{6181, 6, 938},
    Name1Index{6187, 11, 6495},
    Name1Index{6198, 7, 646},
    Name1Index{6205, 9, 7088},
    Name1Index{6214, 5, 537},
    Name1Index{6219, 7, 477},
    Name1Index{6226, 9, 481},
    Name1Index{6235, 9, 1786},
    Name1Index{6244, 4, 42},
    Name1Index{6248, 7, 529},
    Name1Index{6255, 6, 6918},
    Name1Index{6261, 7, 592},
    Name1Index{6268, 5, 6743},
    Name1Index{6273, 6, 585},
    Name1Index{6279, 8, 1693},
    Name1Index{6287, 7, 212},
    Name1Index{6294, 9, 385},
    Name1Index{6303, 9, 703},
    Name1Index{6312, 5, 4610},
    Name1Index{6317, 8, 2301},
    Name1Index{6325, 7, 4107},
    Name1Index{6332, 8, 866},
    Name1Index{6340, 7, 643},
    Name1Index{6347, 8, 1337},
    Name1Index{6355, 4, 788},
    Name1Index{6359, 10, 1646},
    Name1Index{6369, 10, 5414},
    Name1Index{6379, 8, 6889},
    Name1Index{6387, 6, 4686},
    Name1Index{6393, 4, 827},
    Name1Index{6397, 5, 6424},
    Name1Index{6402, 7, 818},
    Name1Index{6409, 4, 551},
    Name1Index{6413, 9, 764},
    Name1Index{6422, 6, 4482},
    Name1Index{6428, 7, 3519},
    Name1Index{6435, 4, 596},
    Name1Index{6439, 10, 280},
    Name1Index{6449, 8, 2615},
    Name1Index{6457, 6, 546},
    Name1Index{6463, 9, 26},
    Name1Index{6472, 10, 857},
    Name1Index{6482, 5, 819},
    Name1Index{6487, 9, 208},
    Name1Index{6496, 7, 834},
    Name1Index{6503, 8, 878},
    Name1Index{6511, 6, 892},
    Name1Index{6517, 3, 6133},
    Name1Index{6520, 7, 944},
    Name1Index{6527, 9, 519},
    Name1Index{6536, 5, 702},
    Name1Index{6541, 9, 608},
    Name1Index{6550, 8, 850},
    Name1Index{6558, 9, 610},
    Name1Index{6567, 3, 1649},
    Name1Index{6570, 4, 605},
    Name1Index{6574, 7, 606},
    Name1Index{6581, 6, 605},
    Name1Index{6587, 12, 472},
    Name1Index{6599, 11, 472},
    Name1Index{6610, 4, 601},
    Name1Index{6614, 7, 3255},
    Name1Index{6621, 3, 811},
    Name1Index{6624, 4, 684},
    Name1Index{6628, 6, 448},
    Name1Index{6634, 6, 5643},
    Name1Index{6640, 9, 757},
    Name1Index{6649, 5, 4803},
    Name1Index{6654, 8, 624},
    Name1Index{6662, 5, 790},
    Name1Index{6667, 6, 909},
    Name1Index{6673, 10, 5117},
    Name1Index{6683, 5, 7058},
    Name1Index{6688, 3, 5831},
    Name1Index{6691, 4, 1494},
    Name1Index{6695, 6, 769},
    Name1Index{6701, 5, 5936},
    Name1Index{6706, 6, 3578},
    Name1Index{6712, 5, 557},
    Name1Index{6717, 4, 472},
    Name1Index{6721, 7, 652},
    Name1Index{6728, 6, 617},
    Name1Index{6734, 8, 4664},
    Name1Index{6742, 6, 623},
    Name1Index{6748, 10, 628},
    Name1Index{6758, 6, 618},
    Name1Index{6764, 7, 6173},
    Name1Index{6771, 8, 620},
    Name1Index{6779, 7, 679},
    Name1Index{6786, 6, 2216},
    Name1Index{6792, 4, 706},
    Name1Index{6796, 6, 621},
    Name1Index{6802, 6, 2185},
    Name1Index{6808, 10, 583},
    Name1Index{6818, 6, 578},
    Name1Index{6824, 6, 6232},
    Name1Index{6830, 7, 835},
    Name1Index{6837, 5, 2710},
    Name1Index{6842, 10, 625},
    Name1Index{6852, 5, 2937},
    Name1Index{6857, 4, 3331},
    Name1Index{6861, 10, 867},
    Name1Index{6871, 5, 6194},
    Name1Index{6876, 7, 6814},
    Name1Index{6883, 5, 2763},
    Name1Index{6888, 5, 599},
    Name1Index{6893, 5, 630},
    Name1Index{6898, 6, 805},
    Name1Index{6904, 6, 755},
    Name1Index{6910, 8, 626},
    Name1Index{6918, 10, 4646},
    Name1Index{6928, 6, 4646},
    Name1Index{6934, 5, 701},
    Name1Index{6939, 5, 4},
    Name1Index{6944, 8, 662},
    Name1Index{6952, 10, 480},
    Name1Index{6962, 7, 3715},
    Name1Index{6969, 9, 678},
    Name1Index{6978, 10, 5297},
    Name1Index{6988, 10, 685},
    Name1Index{6998, 9, 889},
    Name1Index{7007, 7, 6113},
    Name1Index{7014, 6, 1596},
    Name1Index{7020, 6, 5351},
    Name1Index{7026, 7, 1243},
    Name1Index{7033, 6, 5200},
    Name1Index{7039, 8, 512},
    Name1Index{7047, 10, 3064},
    Name1Index{7057, 10, 3328},
    Name1Index{7067, 4, 1308},
    Name1Index{7071, 5, 5079},
    Name1Index{7076, 12, 897},
    Name1Index{7088, 5, 616},
    Name1Index{7093, 8, 2511},
    Name1Index{7101, 7, 7126},
    Name1Index{7108, 12, 561},
    Name1Index{7120, 8, 682},
    Name1Index{7128, 9, 6952},
    Name1Index{7137, 11, 698},
    Name1Index{7148, 10, 698},
    Name1Index{7158, 7, 1215},
    Name1Index{7165, 10, 533},
    Name1Index{7175, 12, 2644},
    Name1Index{7187, 5, 5149},
    Name1Index{7192, 6, 975},
    Name1Index{7198, 8, 724},
    Name1Index{7206, 6, 676},
    Name1Index{7212, 11, 2418},
    Name1Index{7223, 5, 746},
    Name1Index{7228, 8, 2557},
    Name1Index{7236, 8, 863},
    Name1Index{7244, 5, 2349},
    Name1Index{7249, 4, 748},
    Name1Index{7253, 4, 503},
    Name1Index{7257, 5, 731},
    Name1Index{7262, 7, 4457},
    Name1Index{7269, 6, 3660},
    Name1Index{7275, 4, 741},
    Name1Index{7279, 5, 741},
    Name1Index{7284, 6, 556},
    Name1Index{7290, 6, 712},
    Name1Index{7296, 7, 6813},
    Name1Index{7303, 9, 6164},
    Name1Index{7312, 12, 768},
    Name1Index{7324, 6, 734},
    Name1Index{7330, 5, 579},
    Name1Index{7335, 5, 5913},
    Name1Index{7340, 6, 31},
    Name1Index{7346, 5, 2123},
    Name1Index{7351, 5, 328},
    Name1Index{7356, 5, 736},
    Name1Index{7361, 7, 632},
    Name1Index{7368, 4, 657},
    Name1Index{7372, 4, 3892},
    Name1Index{7376, 9, 844},
    Name1Index{7385, 6, 663},
    Name1Index{7391, 7, 6493},
    Name1Index{7398, 4, 743},
    Name1Index{7402, 7, 636},
    Name1Index{7409, 7, 5886},
    Name1Index{7416, 8, 3303},
    Name1Index{7424, 7, 5594},
    Name1Index{7431, 8, 3615},
    Name1Index{7439, 7, 683},
    Name1Index{7446, 7, 872},
    Name1Index{7453, 8, 4729},
    Name1Index{7461, 6, 1705},
    Name1Index{7467, 6, 6309},
    Name1Index{7473, 7, 943},
    Name1Index{7480, 4, 729},
    Name1Index{7484, 5, 697},
    Name1Index{7489, 5, 5879},
    Name1Index{7494, 6, 739},
    Name1Index{7500, 7, 740},
    Name1Index{7507, 9, 162},
    Name1Index{7516, 11, 7230},
    Name1Index{7527, 4, 5814},
    Name1Index{7531, 5, 4105},
    Name1Index{7536, 6, 4478},
    Name1Index{7542, 7, 1173},
    Name1Index{7549, 6, 930},
    Name1Index{7555, 4, 1079},
    Name1Index{7559, 10, 7259},
    Name1Index{7569, 10, 6920},
    Name1Index{7579, 7, 6218},
    Name1Index{7586, 7, 912},
    Name1Index{7593, 6, 2558},
    Name1Index{7599, 9, 4446},
    Name1Index{7608, 7, 916},
    Name1Index{7615, 5, 573},
    Name1Index{7620, 4, 730},
    Name1Index{7624, 8, 730},
    Name1Index{7632, 8, 904},
    Name1Index{7640, 5, 6797},
    Name1Index{7645, 8, 732},
    Name1Index{7653, 5, 708},
    Name1Index{7658, 4, 2348},
    Name1Index{7662, 6, 4725},
    Name1Index{7668, 5, 683},
    Name1Index{7673, 5, 2795},
    Name1Index{7678, 8, 673},
    Name1Index{7686, 8, 5289},
    Name1Index{7694, 7, 911},
    Name1Index{7701, 10, 747},
    Name1Index{7711, 10, 4864},
    Name1Index{7721, 8, 2944},
    Name1Index{7729, 6, 798},
    Name1Index{7735, 8, 4445},
    Name1Index{7743, 12, 5066},
    Name1Index{7755, 4, 1006},
    Name1Index{7759, 9, 807},
    Name1Index{7768, 6, 745},
    Name1Index{7774, 4, 813},
    Name1Index{7778, 7, 815},
    Name1Index{7785, 5, 2225},
    Name1Index{7790, 8, 829},
    Name1Index{7798, 9, 829},
    Name1Index{7807, 3, 6044},
    Name1Index{7810, 7, 5081},
    Name1Index{7817, 6, 926},
    Name1Index{7823, 5, 742},
    Name1Index{7828, 7, 6319},
    Name1Index{7835, 5, 493},
    Name1Index{7840, 9, 977},
    Name1Index{7849, 7, 1405},
    Name1Index{7856, 5, 31},
    Name1Index{7861, 7, 677},
    Name1Index{7868, 6, 772},
    Name1Index{7874, 6, 6815},
    Name1Index{7880, 10, 201},
    Name1Index{7890, 8, 6950},
    Name1Index{7898, 9, 903},
    Name1Index{7907, 7, 733},
    Name1Index{7914, 7, 3332},
    Name1Index{7921, 9, 1490},
    Name1Index{7930, 9, 3860},
    Name1Index{7939, 6, 785},
    Name1Index{7945, 11, 735},
    Name1Index{7956, 6, 4633},
    Name1Index{7962, 8, 6044},
    Name1Index{7970, 8, 1668},
    Name1Index{7978, 10, 4616},
    Name1Index{7988, 11, 868},
    Name1Index{7999, 3, 484},
    Name1Index{8002, 5, 7321},
    Name1Index{8007, 8, 2486},
    Name1Index{8015, 6, 1733},
    Name1Index{8021, 7, 885},
    Name1Index{8028, 6, 3537},
    Name1Index{8034, 9, 1232},
    Name1Index{8043, 7, 942},
    Name1Index{8050, 6, 749},
    Name1Index{8056, 4, 888},
    Name1Index{8060, 8, 4894},
    Name1Index{8068, 7, 516},
    Name1Index{8075, 8, 5599},
    Name1Index{8083, 5, 593},
    Name1Index{8088, 8, 2381},
    Name1Index{8096, 8, 782},
    Name1Index{8104, 4, 561},
    Name1Index{8108, 6, 4528},
    Name1Index{8114, 8, 372},
    Name1Index{8122, 11, 544},
    Name1Index{8133, 7, 6915},
    Name1Index{8140, 6, 544},
    Name1Index{8146, 10, 4571},
    Name1Index{8156, 9, 5848},
    Name1Index{8165, 8, 799},
    Name1Index{8173, 10, 833},
    Name1Index{8183, 6, 825},
    Name1Index{8189, 12, 883},
    Name1Index{8201, 5, 2229},
    Name1Index{8206, 7, 881},
    Name1Index{8213, 4, 922},
    Name1Index{8217, 6, 5740},
    Name1Index{8223, 11, 946},
    Name1Index{8234, 5, 6242},
    Name1Index{8239, 5, 3499},
    Name1Index{8244, 13, 914},
    Name1Index{8257, 6, 783},
    Name1Index{8263, 9, 5029},
    Name1Index{8272, 7, 6494},
    Name1Index{8279, 8, 545},
    Name1Index{8287, 6, 3234},
    Name1Index{8293, 10, 893},
    Name1Index{8303, 4, 629},
    Name1Index{8307, 7, 6576},
    Name1Index{8314, 10, 6816},
    Name1Index{8324, 4, 243},
    Name1Index{8328, 6, 5419},
    Name1Index{8334, 10, 6477},
    Name1Index{8344, 7, 692},
    Name1Index{8351, 8, 1805},
    Name1Index{8359, 8, 522},
    Name1Index{8367, 10, 1877},
    Name1Index{8377, 7, 3679},
    Name1Index{8384, 8, 3578},
    Name1Index{8392, 7, 6249},
    Name1Index{8399, 5, 864},
    Name1Index{8404, 4, 791},
    Name1Index{8408, 7, 526},
    Name1Index{8415, 10, 6817},
    Name1Index{8425, 6, 690},
    Name1Index{8431, 4, 3666},
    Name1Index{8435, 7, 719},
    Name1Index{8442, 11, 719},
    Name1Index{8453, 10, 6760},
    Name1Index{8463, 6, 762},
    Name1Index{8469, 6, 694},
    Name1Index{8475, 8, 3830},
    Name1Index{8483, 11, 789},
    Name1Index{8494, 9, 882},
    Name1Index{8503, 5, 1636},
    Name1Index{8508, 6, 4605},
    Name1Index{8514, 6, 890},
    Name1Index{8520, 4, 598},
    Name1Index{8524, 7, 794},
    Name1Index{8531, 5, 5779},
    Name1Index{8536, 7, 940},
    Name1Index{8543, 5, 492},
    Name1Index{8548, 9, 719},
    Name1Index{8557, 13, 719},
    Name1Index{8570, 3, 1653},
    Name1Index{8573, 3, 385},
    Name1Index{8576, 7, 767},
    Name1Index{8583, 6, 3629},
    Name1Index{8589, 11, 572},
    Name1Index{8600, 8, 6332},
    Name1Index{8608, 7, 905},
    Name1Index{8615, 8, 653},
    Name1Index{8623, 8, 841},
    Name1Index{8631, 6, 879},
    Name1Index{8637, 6, 4196},
    Name1Index{8643, 5, 4696},
    Name1Index{8648, 7, 6456},
    Name1Index{8655, 9, 642},
    Name1Index{8664, 4, 839},
    Name1Index{8668, 7, 602},
    Name1Index{8675, 6, 668},
    Name1Index{8681, 6, 2609},
    Name1Index{8687, 4, 4766},
    Name1Index{8691, 8, 554},
    Name1Index{8699, 8, 2606},
    Name1Index{8707, 7, 5941},
    Name1Index{8714, 6, 847},
    Name1Index{8720, 5, 6072},
    Name1Index{8725, 5, 691},
    Name1Index{8730, 7, 859},
    Name1Index{8737, 9, 508},
    Name1Index{8746, 5, 855},
    Name1Index{8751, 6, 5031},
    Name1Index{8757, 5, 858},
    Name1Index{8762, 6, 918},
    Name1Index{8768, 6, 908},
    Name1Index{8774, 4, 6341},
    Name1Index{8778, 4, 707},
    Name1Index{8782, 7, 5267},
    Name1Index{8789, 5, 849},
    Name1Index{8794, 7, 852},
    Name1Index{8801, 11, 874},
    Name1Index{8812, 6, 737},
    Name1Index{8818, 6, 5217},
    Name1Index{8824, 4, 569},
    Name1Index{8828, 7, 569},
    Name1Index{8835, 5, 659},
    Name1Index{8840, 9, 840},
    Name1Index{8849, 6, 924},
    Name1Index{8855, 10, 836},
    Name1Index{8865, 7, 354},
    Name1Index{8872, 6, 894},
    Name1Index{8878, 7, 6941},
    Name1Index{8885, 7, 860},
    Name1Index{8892, 8, 1731},
    Name1Index{8900, 9, 766},
    Name1Index{8909, 5, 4153},
    Name1Index{8914, 4, 945},
    Name1Index{8918, 6, 831},
    Name1Index{8924, 10, 470},
    Name1Index{8934, 9, 6383},
    Name1Index{8943, 6, 5583},
    Name1Index{8949, 5, 2269},
    Name1Index{8954, 11, 7057},
    Name1Index{8965, 6, 913},
    Name1Index{8971, 6, 935},
    Name1Index{8977, 9, 939},
    Name1Index{8986, 5, 717},
    Name1Index{8991, 9, 4811},
    Name1Index{9000, 12, 3429},
    Name1Index{9012, 4, 4700},
    Name1Index{9016, 7, 5003},
    Name1Index{9023, 7, 950},
    Name1Index{9030, 5, 991},
    Name1Index{9035, 5, 5580},
    Name1Index{9040, 7, 2090},
    Name1Index{9047, 7, 1055},
    Name1Index{9054, 9, 5585},
    Name1Index{9063, 9, 1017},
    Name1Index{9072, 7, 5044},
    Name1Index{9079, 6, 4428},
    Name1Index{9085, 9, 1240},
    Name1Index{9094, 4, 1064},
    Name1Index{9098, 8, 1364},
    Name1Index{9106, 7, 1058},
    Name1Index{9113, 8, 954},
    Name1Index{9121, 6, 5825},
    Name1Index{9127, 7, 1369},
    Name1Index{9134, 6, 1223},
    Name1Index{9140, 9, 1133},
    Name1Index{9149, 6, 494},
    Name1Index{9155, 8, 1183},
    Name1Index{9163, 8, 5191},
    Name1Index{9171, 8, 1993},
    Name1Index{9179, 6, 1269},
    Name1Index{9185, 8, 1391},
    Name1Index{9193, 6, 1179},
    Name1Index{9199, 6, 3202},
    Name1Index{9205, 8, 5377},
    Name1Index{9213, 9, 3486},
    Name1Index{9222, 8, 1374},
    Name1Index{9230, 7, 7275},
    Name1Index{9237, 7, 5918},
    Name1Index{9244, 4, 1173},
    Name1Index{9248, 7, 997},
    Name1Index{9255, 8, 3412},
    Name1Index{9263, 8, 1052},
    Name1Index{9271, 9, 1328},
    Name1Index{9280, 9, 1317},
    Name1Index{9289, 5, 1182},
    Name1Index{9294, 3, 1380},
    Name1Index{9297, 4, 7361},
    Name1Index{9301, 7, 5701},
    Name1Index{9308, 8, 1947},
    Name1Index{9316, 8, 1375},
    Name1Index{9324, 7, 2888},
    Name1Index{9331, 6, 1026},
    Name1Index{9337, 9, 4660},
    Name1Index{9346, 6, 3589},
    Name1Index{9352, 7, 7165},
    Name1Index{9359, 8, 1078},
    Name1Index{9367, 9, 1194},
    Name1Index{9376, 4, 2383},
    Name1Index{9380, 11, 959},
    Name1Index{9391, 8, 1253},
    Name1Index{9399, 7, 1265},
    Name1Index{9406, 12, 6342},
    Name1Index{9418, 3, 6498},
    Name1Index{9421, 4, 4990},
    Name1Index{9425, 8, 7256},
    Name1Index{9433, 7, 957},
    Name1Index{9440, 5, 7378},
    Name1Index{9445, 7, 3693},
    Name1Index{9452, 7, 1207},
    Name1Index{9459, 8, 1267},
    Name1Index{9467, 7, 3543},
    Name1Index{9474, 8, 985},
    Name1Index{9482, 6, 1335},
    Name1Index{9488, 7, 1376},
    Name1Index{9495, 10, 781},