#include <syslog.h>
#include "syslog_glue.h"

#include <VM.h>
#include <VMState.h>
#include <KayaAPI.h>

void do_openlog(wchar_t* rawident, int opt, int fac) {
  char* ident = CSTRING(rawident);
  int option = 0;
  if (opt & 1) { option = option | LOG_PID; }
  if (opt & 2) { option = option | LOG_CONS; }
  if (opt & 4) { option = option | LOG_PERROR; }
  int facility = 0;
  if (fac == 1) { facility = LOG_AUTHPRIV; }
  else if (fac == 2) { facility = LOG_CRON; }
  else if (fac == 3) { facility = LOG_DAEMON; }
  else if (fac == 4) { facility = LOG_FTP; }
  else if (fac == 5) { facility = LOG_KERN; }
  else if (fac == 6) { facility = LOG_LPR; }
  else if (fac == 7) { facility = LOG_MAIL; }
  else if (fac == 8) { facility = LOG_NEWS; }
  else if (fac == 9) { facility = LOG_SYSLOG; }
  else if (fac == 10) { facility = LOG_USER; }
  else if (fac == 11) { facility = LOG_UUCP; }
  else if (fac == 12) { facility = LOG_LOCAL0; }
  else if (fac == 13) { facility = LOG_LOCAL1; }
  else if (fac == 14) { facility = LOG_LOCAL2; }
  else if (fac == 15) { facility = LOG_LOCAL3; }
  else if (fac == 16) { facility = LOG_LOCAL4; }
  else if (fac == 17) { facility = LOG_LOCAL5; }
  else if (fac == 18) { facility = LOG_LOCAL6; }
  else if (fac == 19) { facility = LOG_LOCAL7; }
  openlog(ident,option,facility);
}

void do_syslog(int pri, wchar_t* rawmsg) {
  char* msg = CSTRING(rawmsg);
  int priority = 0;
  if (pri == 0) { priority = LOG_EMERG; }
  else if (pri == 1) { priority = LOG_ALERT; }
  else if (pri == 2) { priority = LOG_CRIT; }
  else if (pri == 3) { priority = LOG_ERR; }
  else if (pri == 4) { priority = LOG_WARNING; }
  else if (pri == 5) { priority = LOG_NOTICE; }
  else if (pri == 6) { priority = LOG_INFO; }
  else if (pri == 7) { priority = LOG_DEBUG; }
  syslog(priority,msg);
}
