/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IMARKERFAMILY_H
#define IMARKERFAMILY_H


#include "iviewfamily.h"


class iColor;
class iLegend;
class iMarker;
class iMarkerEventObserver;
class iViewModule;

class vtkPointWidget;


class iMarkerFamily : public iViewFamily<iMarker,iViewModule>
{

public:

	static iMarkerFamily* New(iViewModule *vm);

	virtual int CreateMember();
	virtual bool DeleteMember(int i);

	void ShowLegend(bool s);
	bool IsLegendVisible();

	void UpdateLegend();
	void SetLegendPosition(int p);
	inline int GetLegendPosition() const { return mLegendPosition; }

	void SetHandlesColor(const iColor &c);
	void ShowHandles(bool s);
	bool IsHandlesVisible();

protected:

	virtual ~iMarkerFamily();

private:

	iMarkerFamily(iViewModule *vm);

	void BuildLegend(int i = -2);
	void UpdateEntry(int i);

	int mLegendPosition;

	iMarkerEventObserver *mMotionObserver;
	vtkPointWidget *mHandles;
	iLegend *mLegend;
};

#endif // IMARKERFAMILY_H
