/**
 * File name: control_area.h
 * Project: Geonkick (A percussive synthesizer)
 *
 * Copyright (C) 2017 Iurie Nistor
 *
 * This file is part of Geonkick.
 *
 * GeonKick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GKICK_CONTROL_AREA_H
#define GKICK_CONTROL_AREA_H

#include "envelope.h"
#include "geonkick_widget.h"
#include "ViewState.h"

class Oscillator;
class ControlsWidget;
#ifndef GEONKICK_SINGLE
class KitWidget;
class KitTabs;
#endif // GEONKICK_SINGLE
class EnvelopeWidget;
class GeonkickModel;
class OscillatorModel;

class ControlArea: public GeonkickWidget
{
 public:
        explicit ControlArea(GeonkickWidget *parent, GeonkickModel* model);
        ~ControlArea() = default;
        RK_DECL_ACT(updateGui, updateGui(), RK_ARG_TYPE(), RK_ARG_VAL());
        void showControls();
#ifndef GEONKICK_SINGLE
        void showKit();
#endif // GEONKICK_SINGLE
 private:
        void showWidget(ViewState::View view);

 private:
        GeonkickModel *geonkickModel;
        const std::vector<OscillatorModel*> &oscillators;
        RkWidget* currentWidget;
        ControlsWidget *controlsWidget;
#ifndef GEONKICK_SINGLE
        KitWidget *kitWidget;
        KitTabs *kitTabs;
#endif // GEONKICK_SINGLE
};

#endif // GKICK_CONTROL_AREA_H
