#!/bin/sh

## @file
## @brief Simple tethered photography helper
##
## Requires gphoto2
##
## If a file already exists with the same name, it is not overwritten, but the
## download will not take place.
## Auto-rename can be achieved with the --filename option of gphoto2.  
## In file $HOME/.config/gphoto2/settings, set the option:  
## gphoto2=filename=<see the manual>
##

n=$(pgrep "geeqie-tethered" | wc -l)
if [ "$n" -ge 3 ]
then
	exit 0
fi

if ! [ -x "$(command -v gphoto2)" ]
then
	zenity --title="Geeqie tethered photography" --info --text="gphoto2 is not installed" 2>/dev/null
	exit 0
fi

if [ "$(gphoto2 --auto-detect | wc -l)" -le 2 ]
then
	zenity --error --title="Geeqie tethered photography" --text="No camera detected" --window-icon=/usr/local/share/pixmaps/geeqie.png 2>/dev/null
	exit 0
fi

notify-send --expire-time=2000 "$(gphoto2 --auto-detect | sed -n '3p')" --icon=geeqie

script_dir=$(dirname "$0")

tmpfile=$(mktemp "${TMPDIR:-/tmp}/geeqie.XXXXXXXXXX")

yes n | gphoto2 --hook-script "$script_dir/"geeqie-tethered-photography-hook-script --capture-tethered >"$tmpfile" &

gphoto2_pid=$!

zenity --question --title="Geeqie tethered photography" --ok-label="Stop" --cancel-label="Show log data" --text="Tethered photography is running.\n\n\nDownloading to folder:\n""$PWD\n\n\nExisting files will not be overwritten,\nbut the download will not take place.\n\n(Use gphoto2 --filename default option\nfor auto-rename on download)" --window-icon=/usr/local/share/pixmaps/geeqie.png 2>/dev/null

if [ $? = 1 ]
then
	zenity --text-info --title="Geeqie tethered photography" --window-icon=/usr/local/share/pixmaps/geeqie.png --ok-label="Stop" --cancel-label="Abort" <"$tmpfile" 2>/dev/null
fi

kill "$gphoto2_pid"
rm "$tmpfile"
