/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class Favorites {
    private JMenuItem[] favItems = null;
    private JMenu favJMenu;

    public Favorites(JMenu favJMenu) {
        this.favJMenu = favJMenu;
        this.checkSavedFavorites();
        if (this.favItems == null) {
            this.defaultFavorites();
        }
    }

    private void checkSavedFavorites() {
        File ffav = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossFavorites");
        if (!ffav.exists()) {
            return;
        }
        int nmenu = 0;
        Vector<String> vfav = new Vector<String>();
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(ffav));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                vfav.add(line);
                if (line.equals("")) continue;
                ++nmenu;
            }
            if (nmenu < 1) {
                return;
            }
            this.favItems = new JMenuItem[nmenu];
            nmenu = 0;
            for (int i = 0; i < vfav.size(); ++i) {
                line = (String)vfav.get(i);
                if (line.equals("")) {
                    this.favJMenu.add(new JSeparator());
                    continue;
                }
                int index = line.indexOf("\t");
                this.favItems[nmenu] = new JMenuItem(line.substring(0, index));
                this.favItems[nmenu].setActionCommand(line.substring(index + 1));
                this.favJMenu.add(this.favItems[nmenu]);
                ++nmenu;
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
    }

    public JMenuItem[] getFavorites() {
        return this.favItems;
    }

    protected JMenuItem add(String prog, String des) {
        JMenuItem fav = new JMenuItem(des + " (" + prog + ")");
        fav.setActionCommand(prog);
        this.favJMenu.add(fav);
        return fav;
    }

    protected void edit(String[] allProgs) {
        String action;
        JMenuItem fav;
        int i;
        JPanel panel = new JPanel(new BorderLayout());
        final Box bdown = Box.createVerticalBox();
        JScrollPane jsp = new JScrollPane(bdown);
        jsp.setPreferredSize(new Dimension(500, 300));
        panel.add((Component)jsp, "Center");
        Box bacross1 = Box.createHorizontalBox();
        bacross1.add(new JLabel("Application and Description"));
        bacross1.add(Box.createHorizontalGlue());
        panel.add((Component)bacross1, "North");
        int nmenu = this.favJMenu.getItemCount();
        JTextField[] tf = new JTextField[nmenu];
        JComboBox[] combo = new JComboBox[nmenu];
        for (int i2 = 0; i2 < nmenu; ++i2) {
            String action2;
            final JMenuItem fav2 = this.favJMenu.getItem(i2);
            if (fav2 == null || (action2 = fav2.getActionCommand()).equals("ADD") || action2.equals("EDIT")) continue;
            final Box bacross = Box.createHorizontalBox();
            combo[i2] = new JComboBox<String>(allProgs);
            combo[i2].setSelectedItem(action2);
            bacross.add(combo[i2]);
            tf[i2] = new JTextField(fav2.getText());
            Dimension d = tf[i2].getPreferredSize();
            d = new Dimension(200, (int)d.getHeight());
            tf[i2].setPreferredSize(d);
            tf[i2].setCaretPosition(0);
            bacross.add(tf[i2]);
            JButton deleteFav = new JButton("Delete");
            deleteFav.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    bdown.remove(bacross);
                    bdown.repaint();
                    fav2.setActionCommand("DELETE");
                }
            });
            bacross.add(deleteFav);
            bacross.add(Box.createHorizontalGlue());
            bdown.add(bacross);
        }
        bdown.add(Box.createVerticalGlue());
        int n = JOptionPane.showConfirmDialog(null, panel, "Edit Favourites", 2);
        if (n == 2) {
            return;
        }
        for (i = 0; i < nmenu; ++i) {
            fav = this.favJMenu.getItem(i);
            if (fav == null || (action = fav.getActionCommand()).equals("ADD") || action.equals("EDIT") || action.equals("DELETE")) continue;
            fav.setText(tf[i].getText());
            fav.setActionCommand((String)combo[i].getSelectedItem());
        }
        for (i = nmenu - 1; i != 0; --i) {
            fav = this.favJMenu.getItem(i);
            if (fav == null || !(action = fav.getActionCommand()).equals("DELETE")) continue;
            this.favJMenu.remove(fav);
        }
    }

    private void defaultFavorites() {
        String[][] favs = new String[][]{{"Add to Favourites", "ADD"}, {"Edit Favourites", "EDIT"}, {"Database Sequence Retrieval", "seqret"}, {"Multiple Alignments", "emma"}, {"Dotplots (exact)", "dottup"}, {"Dotplots (similar)", "dotmatcher"}, {"Primer Design", "eprimer3"}, {"Pattern Search (nucleotide)", "fuzznuc"}, {"Pattern Search (protein)", "fuzzpro"}, {"Find Reading Frames", "getorf"}, {"Best Local Alignments", "matcher"}, {"Global Alignments", "needle"}, {"Display Restriction Sites", "remap"}};
        int nfavs = favs.length;
        this.favItems = new JMenuItem[nfavs];
        for (int i = 0; i < nfavs; ++i) {
            this.favItems[i] = new JMenuItem(favs[i][0]);
            this.favItems[i].setActionCommand(favs[i][1]);
            this.favJMenu.add(this.favItems[i]);
            if (!this.favItems[i].getActionCommand().equals("EDIT")) continue;
            this.favJMenu.add(new JSeparator());
        }
        this.favJMenu.add(new JSeparator());
    }
}

