/*
// $Id: //open/dev/farrago/src/org/eigenbase/rel/metadata/RelMdExplainVisibility.java#4 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2006-2009 The Eigenbase Project
// Copyright (C) 2006-2009 SQLstream, Inc.
// Copyright (C) 2006-2009 LucidEra, Inc.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.rel.metadata;

import java.util.*;

import org.eigenbase.rel.*;
import org.eigenbase.sql.*;


/**
 * RelMdExplainVisibility supplies a default implementation of {@link
 * RelMetadataQuery#isVisibleInExplain} for the standard logical algebra.
 *
 * @author Zelaine Fong
 * @version $Id: //open/dev/farrago/src/org/eigenbase/rel/metadata/RelMdExplainVisibility.java#4 $
 */
public class RelMdExplainVisibility
    extends ReflectiveRelMetadataProvider
{
    //~ Constructors -----------------------------------------------------------

    public RelMdExplainVisibility()
    {
        // Tell superclass reflection about parameter types expected
        // for various metadata queries.

        // This corresponds to isVisibileInExplain(RelNode, SqlExplainLevel);
        // note that we don't specify the rel type because we always overload
        // on that.
        mapParameterTypes(
            "isVisibleInExplain",
            Collections.singletonList((Class) SqlExplainLevel.class));
    }

    //~ Methods ----------------------------------------------------------------

    // Catch-all rule when none of the others apply.
    public Boolean isVisibleInExplain(RelNode rel)
    {
        // no information available
        return null;
    }
}

// End RelMdExplainVisibility.java
