// This code conforms with the UFC specification version 2.3.0
// and was automatically generated by FFC version 1.3.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          True

#include "Poisson2D_5.h"

/// Constructor
poisson2d_5_finite_element_0::poisson2d_5_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
poisson2d_5_finite_element_0::~poisson2d_5_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* poisson2d_5_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 5, None)";
}

/// Return the cell shape
ufc::shape poisson2d_5_finite_element_0::cell_shape() const
{
    return ufc::triangle;
}

/// Return the topological dimension of the cell shape
std::size_t poisson2d_5_finite_element_0::topological_dimension() const
{
    return 2;
}

/// Return the geometric dimension of the cell shape
std::size_t poisson2d_5_finite_element_0::geometric_dimension() const
{
    return 2;
}

/// Return the dimension of the finite element function space
std::size_t poisson2d_5_finite_element_0::space_dimension() const
{
    return 21;
}

/// Return the rank of the value space
std::size_t poisson2d_5_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t poisson2d_5_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void poisson2d_5_finite_element_0::evaluate_basis(std::size_t i,
                                   double* values,
                                   const double* x,
                                   const double* vertex_coordinates,
                                   int cell_orientation) const
{
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0154328860973251, -0.00945067404923486, -0.00545634920634915, 0.0301875307266957, 0.0233831607535234, 0.013500274155551, -0.0231997605826757, -0.0196073763651313, -0.0151878084249949, -0.00876868528257128, 0.0213898651255978, 0.0188640878998484, 0.0159430641501296, 0.0123494443881937, 0.00712995504186596, -0.0179891757560038, -0.0162718217101153, -0.0143503978743156, -0.0121282998205249, -0.00939454064454067, -0.00542394057003844};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0154328860973254, 0.00945067404923492, -0.00545634920634924, 0.0301875307266957, -0.0233831607535234, 0.013500274155551, 0.0231997605826757, -0.0196073763651313, 0.0151878084249949, -0.00876868528257126, 0.0213898651255978, -0.0188640878998484, 0.0159430641501296, -0.0123494443881937, 0.00712995504186593, 0.0179891757560038, -0.0162718217101153, 0.0143503978743156, -0.0121282998205248, 0.00939454064454064, -0.00542394057003842};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0154328860973254, 0.0, 0.0109126984126983, 0.0, 0.0, 0.0405008224666531, 0.0, 0.0, 0.0, 0.0350747411302851, 0.0, 0.0, 0.0, 0.0, 0.0356497752093297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0325436434202305};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, 0.126008987323133, -0.0843253968253967, 0.101882916202598, -0.0286443719230662, 0.00202504112333267, 0.0773325352755858, -0.0261431684868418, 0.0, 0.00584579018838085, 0.0356497752093297, 0.0125760585998989, -0.0385290716961465, 0.0442521757243607, -0.0297081460077747, 0.0, 0.0325436434202305, -0.0516614323475361, 0.0582158391385193, -0.0526094276094276, 0.0325436434202305};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302852, -0.0329341671412734, 0.121527777777778, -0.0113203240225109, 0.075410693430113, -0.0222754523566592, 0.0, 0.104572673947367, -0.101252056166633, 0.0584579018838085, 0.0, 0.0565922636995452, -0.0093001207542422, -0.0401356942616295, 0.0415914044108846, 0.0, 0.0, 0.0516614323475361, -0.101877718492409, 0.118371212121212, -0.0813591085505763};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302852, 0.0887790592503888, -0.089285714285714, 0.0301875307266956, 0.0432588473940182, -0.0594012062844245, 0.0, 0.0261431684868417, 0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.074400966033938, -0.0308736109704842, -0.0118832584031099, 0.0, 0.0, 0.0, 0.0679184789949393, -0.131523569023569, 0.108478811400768};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.010023442173431, 0.151289682539683, 0.0, 0.0502737956200754, 0.093151891673302, 0.0, 0.0, 0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, 0.0720384255977965, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, 0.0657617845117846, -0.0813591085505764};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, -0.126008987323133, -0.0843253968253969, 0.101882916202598, 0.0286443719230662, 0.00202504112333272, -0.0773325352755858, -0.0261431684868417, 0.0, 0.00584579018838084, 0.0356497752093296, -0.0125760585998989, -0.0385290716961465, -0.0442521757243607, -0.0297081460077748, 0.0, 0.0325436434202305, 0.051661432347536, 0.0582158391385193, 0.0526094276094276, 0.0325436434202305};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302848, 0.0329341671412733, 0.121527777777778, -0.0113203240225108, -0.075410693430113, -0.0222754523566593, 0.0, 0.104572673947367, 0.101252056166633, 0.0584579018838085, 0.0, -0.0565922636995451, -0.00930012075424217, 0.0401356942616295, 0.0415914044108847, 0.0, 0.0, -0.0516614323475361, -0.101877718492409, -0.118371212121212, -0.0813591085505763};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302853, -0.0887790592503889, -0.0892857142857143, 0.0301875307266957, -0.0432588473940182, -0.0594012062844245, 0.0, 0.0261431684868417, -0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.074400966033938, 0.0308736109704842, -0.01188325840311, 0.0, 0.0, 0.0, 0.0679184789949392, 0.131523569023569, 0.108478811400768};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, 0.0100234421734312, 0.151289682539683, 0.0, -0.0502737956200753, 0.0931518916733021, 0.0, 0.0, -0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, -0.0720384255977964, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, -0.0657617845117846, -0.0813591085505764};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302855, -0.136032429496563, -0.0669642857142857, 0.0369797251402022, 0.0789181675431415, 0.0600762199922021, -0.00773325352755864, -0.0457505448519731, -0.055688630891648, -0.0379976362244755, -0.0641695953767935, -0.012576058599899, 0.017271652829307, 0.0277862498734358, 0.0202015392852868, 0.0899458787800191, 0.0488154651303458, 0.0200905570240418, 0.00242565996410494, -0.0056367243867244, -0.00542394057003842};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302855, 0.121713226391662, -0.0322420634920635, -0.0671672558668979, -0.0321518460360947, 0.0276755620188796, 0.139198563496054, 0.0653579212171044, -0.0101252056166633, -0.0292289509419042, 0.0427797302511957, -0.0565922636995451, -0.0332147169794367, 0.00926208329114529, 0.0202015392852869, -0.179891757560038, -0.0325436434202306, 0.0114803182994524, 0.00970263985641995, -0.00187890812890815, -0.00542394057003845};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302854, -0.121713226391662, -0.0322420634920636, -0.0671672558668978, 0.0321518460360947, 0.0276755620188797, -0.139198563496054, 0.0653579212171044, 0.0101252056166633, -0.0292289509419043, 0.0427797302511955, 0.0565922636995451, -0.0332147169794366, -0.00926208329114529, 0.0202015392852868, 0.179891757560038, -0.0325436434202305, -0.0114803182994525, 0.00970263985641989, 0.00187890812890815, -0.0054239405700384};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, 0.136032429496564, -0.0669642857142856, 0.0369797251402022, -0.0789181675431414, 0.060076219992202, 0.00773325352755864, -0.0457505448519731, 0.0556886308916479, -0.0379976362244755, -0.0641695953767934, 0.0125760585998989, 0.017271652829307, -0.0277862498734358, 0.0202015392852869, -0.0899458787800192, 0.0488154651303458, -0.0200905570240418, 0.00242565996410498, 0.0056367243867244, -0.00542394057003848};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.280597929042281, -0.214788046573522, -0.124007936507937, 0.0905625921800871, 0.116915803767617, 0.0, 0.154665070551172, 0.0784295054605253, 0.101252056166633, 0.0818410626373319, -0.142599100837319, 0.0251521171997979, -0.0318861283002592, -0.107028518031012, -0.0950660672248791, 0.0, -0.130174573680922, -0.103322864695072, -0.0291079195692595, 0.0263047138047138, 0.0325436434202306};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, 0.0, -0.124007936507936, -0.38489101676537, 0.0, 0.101252056166633, 0.0, -0.104572673947367, 0.0, 0.0467663215070469, 0.213898651255978, 0.0, 0.140830399992811, 0.0, -0.0950660672248791, 0.0, 0.195261860521383, 0.0, -0.0582158391385195, 0.0, 0.0325436434202304};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.280597929042281, 0.214788046573521, -0.124007936507936, 0.090562592180087, -0.116915803767617, 0.0, -0.154665070551171, 0.0784295054605253, -0.101252056166633, 0.0818410626373318, -0.142599100837319, -0.0251521171997978, -0.0318861283002592, 0.107028518031012, -0.0950660672248791, 0.0, -0.130174573680922, 0.103322864695072, -0.0291079195692596, -0.0263047138047138, 0.0325436434202306};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.107394023286761, 0.0620039682539684, 0.0113203240225108, -0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070467, 0.0, 0.169776791098635, 0.00930012075424214, 0.126581804978985, 0.172307246845093, 0.0, 0.0, 0.154984297042608, 0.101877718492409, -0.0394570707070707, -0.0813591085505763};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, 0.107394023286761, 0.0620039682539682, 0.0113203240225109, 0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070468, 0.0, -0.169776791098635, 0.00930012075424223, -0.126581804978985, 0.172307246845093, 0.0, 0.0, -0.154984297042608, 0.101877718492409, 0.0394570707070707, -0.0813591085505763};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.280597929042281, 0.0, 0.248015873015873, -0.0603750614533913, 0.0, 0.13500274155551, 0.0, -0.0522863369736835, 0.0, -0.210448446781711, 0.0, 0.0, -0.148801932067876, 0.0, -0.142599100837319, 0.0, 0.0, 0.0, -0.135836957989878, 0.0, 0.108478811400768};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point x in cell
void poisson2d_5_finite_element_0::evaluate_basis_all(double* values,
                                       const double* x,
                                       const double* vertex_coordinates,
                                       int cell_orientation) const
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 21; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void poisson2d_5_finite_element_0::evaluate_basis_derivatives(std::size_t i,
                                               std::size_t n,
                                               double* values,
                                               const double* x,
                                               const double* vertex_coordinates,
                                               int cell_orientation) const
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 5)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[32][5];
    for (unsigned int row = 0; row < 32; row++)
    {
      for (unsigned int col = 0; col < 5; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[32][32];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0154328860973251, -0.00945067404923486, -0.00545634920634915, 0.0301875307266957, 0.0233831607535234, 0.013500274155551, -0.0231997605826757, -0.0196073763651313, -0.0151878084249949, -0.00876868528257128, 0.0213898651255978, 0.0188640878998484, 0.0159430641501296, 0.0123494443881937, 0.00712995504186596, -0.0179891757560038, -0.0162718217101153, -0.0143503978743156, -0.0121282998205249, -0.00939454064454067, -0.00542394057003844};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0154328860973254, 0.00945067404923492, -0.00545634920634924, 0.0301875307266957, -0.0233831607535234, 0.013500274155551, 0.0231997605826757, -0.0196073763651313, 0.0151878084249949, -0.00876868528257126, 0.0213898651255978, -0.0188640878998484, 0.0159430641501296, -0.0123494443881937, 0.00712995504186593, 0.0179891757560038, -0.0162718217101153, 0.0143503978743156, -0.0121282998205248, 0.00939454064454064, -0.00542394057003842};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0154328860973254, 0.0, 0.0109126984126983, 0.0, 0.0, 0.0405008224666531, 0.0, 0.0, 0.0, 0.0350747411302851, 0.0, 0.0, 0.0, 0.0, 0.0356497752093297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0325436434202305};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, 0.126008987323133, -0.0843253968253967, 0.101882916202598, -0.0286443719230662, 0.00202504112333267, 0.0773325352755858, -0.0261431684868418, 0.0, 0.00584579018838085, 0.0356497752093297, 0.0125760585998989, -0.0385290716961465, 0.0442521757243607, -0.0297081460077747, 0.0, 0.0325436434202305, -0.0516614323475361, 0.0582158391385193, -0.0526094276094276, 0.0325436434202305};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302852, -0.0329341671412734, 0.121527777777778, -0.0113203240225109, 0.075410693430113, -0.0222754523566592, 0.0, 0.104572673947367, -0.101252056166633, 0.0584579018838085, 0.0, 0.0565922636995452, -0.0093001207542422, -0.0401356942616295, 0.0415914044108846, 0.0, 0.0, 0.0516614323475361, -0.101877718492409, 0.118371212121212, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302852, 0.0887790592503888, -0.089285714285714, 0.0301875307266956, 0.0432588473940182, -0.0594012062844245, 0.0, 0.0261431684868417, 0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.074400966033938, -0.0308736109704842, -0.0118832584031099, 0.0, 0.0, 0.0, 0.0679184789949393, -0.131523569023569, 0.108478811400768};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.010023442173431, 0.151289682539683, 0.0, 0.0502737956200754, 0.093151891673302, 0.0, 0.0, 0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, 0.0720384255977965, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, 0.0657617845117846, -0.0813591085505764};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, -0.126008987323133, -0.0843253968253969, 0.101882916202598, 0.0286443719230662, 0.00202504112333272, -0.0773325352755858, -0.0261431684868417, 0.0, 0.00584579018838084, 0.0356497752093296, -0.0125760585998989, -0.0385290716961465, -0.0442521757243607, -0.0297081460077748, 0.0, 0.0325436434202305, 0.051661432347536, 0.0582158391385193, 0.0526094276094276, 0.0325436434202305};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302848, 0.0329341671412733, 0.121527777777778, -0.0113203240225108, -0.075410693430113, -0.0222754523566593, 0.0, 0.104572673947367, 0.101252056166633, 0.0584579018838085, 0.0, -0.0565922636995451, -0.00930012075424217, 0.0401356942616295, 0.0415914044108847, 0.0, 0.0, -0.0516614323475361, -0.101877718492409, -0.118371212121212, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302853, -0.0887790592503889, -0.0892857142857143, 0.0301875307266957, -0.0432588473940182, -0.0594012062844245, 0.0, 0.0261431684868417, -0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.074400966033938, 0.0308736109704842, -0.01188325840311, 0.0, 0.0, 0.0, 0.0679184789949392, 0.131523569023569, 0.108478811400768};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, 0.0100234421734312, 0.151289682539683, 0.0, -0.0502737956200753, 0.0931518916733021, 0.0, 0.0, -0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, -0.0720384255977964, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, -0.0657617845117846, -0.0813591085505764};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302855, -0.136032429496563, -0.0669642857142857, 0.0369797251402022, 0.0789181675431415, 0.0600762199922021, -0.00773325352755864, -0.0457505448519731, -0.055688630891648, -0.0379976362244755, -0.0641695953767935, -0.012576058599899, 0.017271652829307, 0.0277862498734358, 0.0202015392852868, 0.0899458787800191, 0.0488154651303458, 0.0200905570240418, 0.00242565996410494, -0.0056367243867244, -0.00542394057003842};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302855, 0.121713226391662, -0.0322420634920635, -0.0671672558668979, -0.0321518460360947, 0.0276755620188796, 0.139198563496054, 0.0653579212171044, -0.0101252056166633, -0.0292289509419042, 0.0427797302511957, -0.0565922636995451, -0.0332147169794367, 0.00926208329114529, 0.0202015392852869, -0.179891757560038, -0.0325436434202306, 0.0114803182994524, 0.00970263985641995, -0.00187890812890815, -0.00542394057003845};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302854, -0.121713226391662, -0.0322420634920636, -0.0671672558668978, 0.0321518460360947, 0.0276755620188797, -0.139198563496054, 0.0653579212171044, 0.0101252056166633, -0.0292289509419043, 0.0427797302511955, 0.0565922636995451, -0.0332147169794366, -0.00926208329114529, 0.0202015392852868, 0.179891757560038, -0.0325436434202305, -0.0114803182994525, 0.00970263985641989, 0.00187890812890815, -0.0054239405700384};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.035074741130285, 0.136032429496564, -0.0669642857142856, 0.0369797251402022, -0.0789181675431414, 0.060076219992202, 0.00773325352755864, -0.0457505448519731, 0.0556886308916479, -0.0379976362244755, -0.0641695953767934, 0.0125760585998989, 0.017271652829307, -0.0277862498734358, 0.0202015392852869, -0.0899458787800192, 0.0488154651303458, -0.0200905570240418, 0.00242565996410498, 0.0056367243867244, -0.00542394057003848};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.280597929042281, -0.214788046573522, -0.124007936507937, 0.0905625921800871, 0.116915803767617, 0.0, 0.154665070551172, 0.0784295054605253, 0.101252056166633, 0.0818410626373319, -0.142599100837319, 0.0251521171997979, -0.0318861283002592, -0.107028518031012, -0.0950660672248791, 0.0, -0.130174573680922, -0.103322864695072, -0.0291079195692595, 0.0263047138047138, 0.0325436434202306};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, 0.0, -0.124007936507936, -0.38489101676537, 0.0, 0.101252056166633, 0.0, -0.104572673947367, 0.0, 0.0467663215070469, 0.213898651255978, 0.0, 0.140830399992811, 0.0, -0.0950660672248791, 0.0, 0.195261860521383, 0.0, -0.0582158391385195, 0.0, 0.0325436434202304};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.280597929042281, 0.214788046573521, -0.124007936507936, 0.090562592180087, -0.116915803767617, 0.0, -0.154665070551171, 0.0784295054605253, -0.101252056166633, 0.0818410626373318, -0.142599100837319, -0.0251521171997978, -0.0318861283002592, 0.107028518031012, -0.0950660672248791, 0.0, -0.130174573680922, 0.103322864695072, -0.0291079195692596, -0.0263047138047138, 0.0325436434202306};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.107394023286761, 0.0620039682539684, 0.0113203240225108, -0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070467, 0.0, 0.169776791098635, 0.00930012075424214, 0.126581804978985, 0.172307246845093, 0.0, 0.0, 0.154984297042608, 0.101877718492409, -0.0394570707070707, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.0350747411302851, 0.107394023286761, 0.0620039682539682, 0.0113203240225109, 0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070468, 0.0, -0.169776791098635, 0.00930012075424223, -0.126581804978985, 0.172307246845093, 0.0, 0.0, -0.154984297042608, 0.101877718492409, 0.0394570707070707, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[15] = basisvalues[10]*1.8*tmp0 - basisvalues[6]*0.8*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[16] = basisvalues[10]*(4.5 + 5.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[20] = basisvalues[14]*(0.0185185185185185 + Y*1.83333333333333) - basisvalues[9]*0.814814814814815;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[19] = basisvalues[13]*(0.178571428571429 + Y*1.96428571428571) - basisvalues[8]*0.785714285714286;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[18] = basisvalues[12]*(0.578703703703704 + Y*2.29166666666667) - basisvalues[7]*0.712962962962963;
      basisvalues[17] = basisvalues[11]*(1.51234567901235 + Y*3.05555555555556) - basisvalues[6]*0.54320987654321;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[20] *= std::sqrt(3.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[19] *= std::sqrt(9.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[18] *= std::sqrt(15.0);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[17] *= std::sqrt(21.0);
      basisvalues[10] *= std::sqrt(22.5);
      basisvalues[16] *= std::sqrt(27.0);
      basisvalues[15] *= std::sqrt(33.0);
      
      // Table(s) of coefficients
      static const double coefficients0[21] = \
      {0.280597929042281, 0.0, 0.248015873015873, -0.0603750614533913, 0.0, 0.13500274155551, 0.0, -0.0522863369736835, 0.0, -0.210448446781711, 0.0, 0.0, -0.148801932067876, 0.0, -0.142599100837319, 0.0, 0.0, 0.0, -0.135836957989878, 0.0, 0.108478811400768};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556637, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.28012053682392e-14, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.00000000000001, 0.0, 7.07106781186548, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660787, 0.0, -1.58060166912796e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1349006293932e-14, 0.0, 0.0, 0.0, 0.0},
      {-4.52415882534751e-14, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690616, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.11161080340594e-14, 10.9544511501033, 1.4432899320127e-14, 0.0, -3.83325938999963, 0.0, 17.7482393492988, 0.0, 0.553283335172473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09970309129559e-14, 0.0, 0.0, 0.0},
      {4.73286382647971, 0.0, 3.34664010613632, 4.36435780471985, 0.0, -5.07468037933238, 0.0, 17.0084012854152, 1.37294759591358e-14, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.08721928629529e-14, 2.44948974278319, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0},
      {3.09838667696592, 0.0, 7.66811580507232, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.05990490519578e-14, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309063, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, -1.42355033138623e-14, -4.03686713879667, 0.0, -0.515811962199109, 21.7990825495019, 0.0, 0.45133546692423, 0.0, 0.0576695305542373, 0.0, 0.0, 0.0, -1.01130026781332e-14, 0.0, 0.0},
      {2.22599716437344e-14, 6.85714285714284, 2.1316282072803e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 2.11115961411461e-14, -7.27309832077594, 0.0, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, -1.59753342319967e-14, 0.0, 0.0, 0.0},
      {4.32049379893859, 0.0, 5.935526614419, 1.79284291400159, 0.0, -0.320713490294921, 0.0, 9.20087412456474, 0.0, -5.9663961985342, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {1.60982338570648e-14, 1.53330375599987, 1.06581410364015e-14, 0.0, 6.33793245113118, 0.0, 0.0, 1.0406246085292e-14, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428573, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195777, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278319, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426406871193, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175273, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675851, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106458, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442583, 0.305505046330391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749977, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756886, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238573, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05068851288609e-14, 0.0},
      {4.99999999999999, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299974, 5.47722557505165, -1.89736659610102, 7.4230748895809, -1.91662969499981, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586237, -0.0958314847499869, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323984, 2.89827534923788, 1.67332005306817, 2.18217890235993, 5.74704893215393, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413421, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.22474487139161, 3.53553390593274, -7.37711113563318, 4.57142857142857, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02982334453152e-14, 0.0, 0.0, 1.07088008761969e-14, 0.0},
      {1.54919333848297, 6.64078308635361, 3.83405790253617, 0.0, -6.19677335393188, 5.3665631459995, 0.0, 0.0, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43533881816581e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847148, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86795023893183e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939833, 0.670059394260475, -0.257905981099551, 10.899541274751, -1.06805465250648, 0.225667733462113, -0.0749149177264333, 0.0288347652771187, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897427832, 3.42857142857143, 0.989743318610804, 3.04933917230523, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531683, -3.63654916038797, 1.51635079315151, 12.0498962651136, 10.6270096138723, -2.24536559755125, 0.745394019896834, -0.286902292026514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946931, 1.8142294704443, 2.96776330720951, 0.896421457000798, 5.41604758366941, -0.160356745147462, -9.5257934441568, 4.60043706228237, 5.34522483824849, -2.9831980992671, 0.0, 13.3887736279041, 9.90113162256756, -3.28687867566958, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835054, 0.766651877999931, 3.83609779052925, 8.63680425592141, 3.16896622556559, 3.65920700676628, 0.0, -8.74817765279706, 6.7763092717894, 0.521640530957307, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237311, -6.73025456655335, 3.65714285714288, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.16438404243701e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7154760664941, -1.34315856375784e-14, -4.61880215351698, 0.0, 0.0, 12.7279220613579, 0.0, 0.0, -2.28833187993595e-14, -3.26598632371088, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[32];
      for (unsigned int r = 0; r < 32; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void poisson2d_5_finite_element_0::evaluate_basis_derivatives_all(std::size_t n,
                                                   double* values,
                                                   const double* x,
                                                   const double* vertex_coordinates,
                                                   int cell_orientation) const
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 21; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      }// end loop over 's'
    }// end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 5)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[32];
    for (unsigned int r = 0; r < 32; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 21; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
}

/// Evaluate linear functional for dof i on the function f
double poisson2d_5_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[2];
      y[1] = vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[4];
      y[1] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.8*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.8*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.6*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
      y[1] = 0.6*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.4*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.2*vertex_coordinates[2] + 0.8*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[3] + 0.8*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[4];
      y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[4];
      y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[2];
      y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[2];
      y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[2];
      y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[2];
      y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.6*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.6*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.6*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.6*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void poisson2d_5_finite_element_0::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[2];
    y[1] = vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[4];
    y[1] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.8*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.8*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.6*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    y[1] = 0.6*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.4*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.2*vertex_coordinates[2] + 0.8*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[3] + 0.8*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[4];
    y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[4];
    y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[2];
    y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[2];
    y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[2];
    y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[2];
    y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.6*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.6*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.6*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.6*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
}

/// Interpolate vertex values from dof values
void poisson2d_5_finite_element_0::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void poisson2d_5_finite_element_0::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void poisson2d_5_finite_element_0::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t poisson2d_5_finite_element_0::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* poisson2d_5_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* poisson2d_5_finite_element_0::create() const
{
    return new poisson2d_5_finite_element_0();
}

/// Constructor
poisson2d_5_dofmap_0::poisson2d_5_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
poisson2d_5_dofmap_0::~poisson2d_5_dofmap_0()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* poisson2d_5_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 5, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool poisson2d_5_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t poisson2d_5_dofmap_0::topological_dimension() const
{
    return 2;
}

/// Return the geometric dimension of the associated cell shape
std::size_t poisson2d_5_dofmap_0::geometric_dimension() const
{
    return 2;
}

/// Return the dimension of the global finite element function space
std::size_t poisson2d_5_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0] + 4*num_global_entities[1] + 6*num_global_entities[2];
}

/// Return the dimension of the local finite element function space for a cell
std::size_t poisson2d_5_dofmap_0::local_dimension() const
{
    return 21;
}

/// Return the number of dofs on each cell facet
std::size_t poisson2d_5_dofmap_0::num_facet_dofs() const
{
    return 6;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t poisson2d_5_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void poisson2d_5_dofmap_0::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + 4*c.entity_indices[1][0];
    dofs[4] = offset + 4*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 4*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 4*c.entity_indices[1][0] + 3;
    dofs[7] = offset + 4*c.entity_indices[1][1];
    dofs[8] = offset + 4*c.entity_indices[1][1] + 1;
    dofs[9] = offset + 4*c.entity_indices[1][1] + 2;
    dofs[10] = offset + 4*c.entity_indices[1][1] + 3;
    dofs[11] = offset + 4*c.entity_indices[1][2];
    dofs[12] = offset + 4*c.entity_indices[1][2] + 1;
    dofs[13] = offset + 4*c.entity_indices[1][2] + 2;
    dofs[14] = offset + 4*c.entity_indices[1][2] + 3;
    offset += 4*num_global_entities[1];
    dofs[15] = offset + 6*c.entity_indices[2][0];
    dofs[16] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[17] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[18] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[19] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[20] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*num_global_entities[2];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void poisson2d_5_dofmap_0::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 7;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 10;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void poisson2d_5_dofmap_0::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
        dofs[3] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
        dofs[3] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 11;
        dofs[1] = 12;
        dofs[2] = 13;
        dofs[3] = 14;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 15;
      dofs[1] = 16;
      dofs[2] = 17;
      dofs[3] = 18;
      dofs[4] = 19;
      dofs[5] = 20;
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void poisson2d_5_dofmap_0::tabulate_coordinates(double** dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[1][0] = vertex_coordinates[2];
    dof_coordinates[1][1] = vertex_coordinates[3];
    dof_coordinates[2][0] = vertex_coordinates[4];
    dof_coordinates[2][1] = vertex_coordinates[5];
    dof_coordinates[3][0] = 0.8*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[3][1] = 0.8*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[4][0] = 0.6*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    dof_coordinates[4][1] = 0.6*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    dof_coordinates[5][0] = 0.4*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    dof_coordinates[5][1] = 0.4*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
    dof_coordinates[6][0] = 0.2*vertex_coordinates[2] + 0.8*vertex_coordinates[4];
    dof_coordinates[6][1] = 0.2*vertex_coordinates[3] + 0.8*vertex_coordinates[5];
    dof_coordinates[7][0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[4];
    dof_coordinates[7][1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[5];
    dof_coordinates[8][0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[4];
    dof_coordinates[8][1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[5];
    dof_coordinates[9][0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[4];
    dof_coordinates[9][1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[5];
    dof_coordinates[10][0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[4];
    dof_coordinates[10][1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[5];
    dof_coordinates[11][0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[2];
    dof_coordinates[11][1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[3];
    dof_coordinates[12][0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[2];
    dof_coordinates[12][1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[3];
    dof_coordinates[13][0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[2];
    dof_coordinates[13][1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[3];
    dof_coordinates[14][0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[2];
    dof_coordinates[14][1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[3];
    dof_coordinates[15][0] = 0.6*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[15][1] = 0.6*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[16][0] = 0.4*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[16][1] = 0.4*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[17][0] = 0.2*vertex_coordinates[0] + 0.6*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[17][1] = 0.2*vertex_coordinates[1] + 0.6*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[18][0] = 0.4*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    dof_coordinates[18][1] = 0.4*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    dof_coordinates[19][0] = 0.2*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    dof_coordinates[19][1] = 0.2*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    dof_coordinates[20][0] = 0.2*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    dof_coordinates[20][1] = 0.2*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t poisson2d_5_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* poisson2d_5_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* poisson2d_5_dofmap_0::create() const
{
    return new poisson2d_5_dofmap_0();
}

/// Constructor
poisson2d_5_cell_integral_0_otherwise::poisson2d_5_cell_integral_0_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson2d_5_cell_integral_0_otherwise::~poisson2d_5_cell_integral_0_otherwise()
{
    // Do nothing
}

/// Tabulate the tensor for the contribution from a local cell
void poisson2d_5_cell_integral_0_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 1259
    // Total number of operations (multiply-add pairs):                  1270
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.342406580687829*G0_0_0 + 0.342406580687829*G0_0_1 + 0.342406580687829*G0_1_0 + 0.34240658068783*G0_1_1;
    A[1] = -0.040998401675485*G0_0_0 - 0.0409984016754851*G0_1_0;
    A[2] = -0.040998401675485*G0_0_1 - 0.040998401675485*G0_1_1;
    A[3] = -0.0408192791005283*G0_0_0 - 0.040819279100529*G0_0_1 - 0.0408192791005285*G0_1_0 - 0.0408192791005291*G0_1_1;
    A[4] = -0.0379774305555561*G0_0_0 - 0.0379774305555545*G0_0_1 - 0.0379774305555559*G0_1_0 - 0.0379774305555543*G0_1_1;
    A[5] = -0.0379774305555538*G0_0_0 - 0.0379774305555549*G0_0_1 - 0.037977430555554*G0_1_0 - 0.037977430555555*G0_1_1;
    A[6] = -0.040819279100529*G0_0_0 - 0.0408192791005282*G0_0_1 - 0.040819279100529*G0_1_0 - 0.0408192791005283*G0_1_1;
    A[7] = 0.202287946428571*G0_0_0 - 0.64802758487654*G0_0_1 + 0.202287946428571*G0_1_0 - 0.648027584876541*G0_1_1;
    A[8] = -0.0158454585537927*G0_0_0 + 0.594204695767193*G0_0_1 - 0.0158454585537928*G0_1_0 + 0.594204695767193*G0_1_1;
    A[9] = -0.069668347663138*G0_0_0 - 0.449959352954142*G0_0_1 - 0.069668347663138*G0_1_0 - 0.449959352954143*G0_1_1;
    A[10] = 0.0408192791005289*G0_0_0 + 0.202374063051146*G0_0_1 + 0.0408192791005289*G0_1_0 + 0.202374063051146*G0_1_1;
    A[11] = -0.64802758487654*G0_0_0 + 0.202287946428571*G0_0_1 - 0.64802758487654*G0_1_0 + 0.202287946428572*G0_1_1;
    A[12] = 0.594204695767192*G0_0_0 - 0.0158454585537913*G0_0_1 + 0.594204695767192*G0_1_0 - 0.0158454585537912*G0_1_1;
    A[13] = -0.449959352954142*G0_0_0 - 0.0696683476631398*G0_0_1 - 0.449959352954142*G0_1_0 - 0.0696683476631396*G0_1_1;
    A[14] = 0.202374063051145*G0_0_0 + 0.0408192791005295*G0_0_1 + 0.202374063051146*G0_1_0 + 0.0408192791005296*G0_1_1;
    A[15] = -0.215291556437389*G0_0_0 - 0.215291556437391*G0_0_1 - 0.215291556437389*G0_1_0 - 0.215291556437392*G0_1_1;
    A[16] = -0.0538228891093484*G0_0_0 - 0.0538228891093457*G0_0_1 - 0.0538228891093485*G0_1_0 - 0.053822889109346*G0_1_1;
    A[17] = 0.107645778218694*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218695*G0_1_0 + 0.107645778218693*G0_1_1;
    A[18] = -0.0538228891093464*G0_0_0 - 0.053822889109346*G0_0_1 - 0.0538228891093465*G0_1_0 - 0.0538228891093456*G0_1_1;
    A[19] = 0.107645778218695*G0_0_0 + 0.107645778218694*G0_0_1 + 0.107645778218695*G0_1_0 + 0.107645778218695*G0_1_1;
    A[20] = 0.107645778218692*G0_0_0 + 0.107645778218692*G0_0_1 + 0.107645778218692*G0_1_0 + 0.107645778218692*G0_1_1;
    A[21] = -0.040998401675485*G0_0_0 - 0.0409984016754851*G0_0_1;
    A[22] = 0.342406580687829*G0_0_0;
    A[23] = 0.0409984016754845*G0_0_1;
    A[24] = 0.20228794642857*G0_0_0 + 0.85031553130511*G0_0_1;
    A[25] = -0.0158454585537937*G0_0_0 - 0.610050154320986*G0_0_1;
    A[26] = -0.0696683476631382*G0_0_0 + 0.380291005291002*G0_0_1;
    A[27] = 0.0408192791005282*G0_0_0 - 0.161554783950616*G0_0_1;
    A[28] = -0.0408192791005284*G0_0_0;
    A[29] = -0.037977430555556*G0_0_0;
    A[30] = -0.0379774305555545*G0_0_0;
    A[31] = -0.0408192791005283*G0_0_0;
    A[32] = 0.202374063051145*G0_0_0 + 0.161554783950616*G0_0_1;
    A[33] = -0.449959352954142*G0_0_0 - 0.380291005291001*G0_0_1;
    A[34] = 0.594204695767192*G0_0_0 + 0.610050154320982*G0_0_1;
    A[35] = -0.64802758487654*G0_0_0 - 0.85031553130511*G0_0_1;
    A[36] = 0.107645778218694*G0_0_0;
    A[37] = -0.0538228891093496*G0_0_0;
    A[38] = -0.215291556437387*G0_0_0;
    A[39] = 0.107645778218696*G0_0_0;
    A[40] = -0.0538228891093464*G0_0_0;
    A[41] = 0.107645778218693*G0_0_0;
    A[42] = -0.040998401675485*G0_1_0 - 0.040998401675485*G0_1_1;
    A[43] = 0.0409984016754845*G0_1_0;
    A[44] = 0.34240658068783*G0_1_1;
    A[45] = -0.161554783950617*G0_1_0 + 0.0408192791005279*G0_1_1;
    A[46] = 0.380291005291006*G0_1_0 - 0.0696683476631372*G0_1_1;
    A[47] = -0.610050154320988*G0_1_0 - 0.015845458553793*G0_1_1;
    A[48] = 0.850315531305113*G0_1_0 + 0.20228794642857*G0_1_1;
    A[49] = 0.161554783950618*G0_1_0 + 0.202374063051146*G0_1_1;
    A[50] = -0.380291005291006*G0_1_0 - 0.449959352954144*G0_1_1;
    A[51] = 0.610050154320987*G0_1_0 + 0.594204695767196*G0_1_1;
    A[52] = -0.850315531305113*G0_1_0 - 0.648027584876543*G0_1_1;
    A[53] = -0.0408192791005286*G0_1_1;
    A[54] = -0.0379774305555554*G0_1_1;
    A[55] = -0.0379774305555546*G0_1_1;
    A[56] = -0.0408192791005283*G0_1_1;
    A[57] = 0.107645778218693*G0_1_1;
    A[58] = 0.107645778218695*G0_1_1;
    A[59] = 0.107645778218692*G0_1_1;
    A[60] = -0.0538228891093447*G0_1_1;
    A[61] = -0.0538228891093471*G0_1_1;
    A[62] = -0.21529155643739*G0_1_1;
    A[63] = -0.0408192791005283*G0_0_0 - 0.0408192791005285*G0_0_1 - 0.040819279100529*G0_1_0 - 0.0408192791005292*G0_1_1;
    A[64] = 0.20228794642857*G0_0_0 + 0.85031553130511*G0_1_0;
    A[65] = -0.161554783950617*G0_0_1 + 0.0408192791005279*G0_1_1;
    A[66] = 1.98929398148147*G0_0_0 + 1.28098476080246*G0_0_1 + 1.28098476080246*G0_1_0 + 2.56196952160492*G0_1_1;
    A[67] = -0.906377452601409*G0_0_0 + 0.796578758818337*G0_0_1 - 0.529617228835981*G0_1_0 - 1.39508928571428*G0_1_1;
    A[68] = 0.818107914462078*G0_0_0 - 0.482253086419752*G0_0_1 + 0.232514880952381*G0_1_0 + 0.895612874779533*G0_1_1;
    A[69] = -0.340160659171074*G0_0_0 + 0.329396081349206*G0_0_1 - 0.0710462136243394*G0_1_0 - 0.340160659171072*G0_1_1;
    A[70] = 0.142092427248674*G0_0_0 + 0.0710462136243362*G0_0_1 + 0.0710462136243363*G0_1_0;
    A[71] = 0.131327849426809*G0_0_0 + 0.0301408179012379*G0_0_1 + 0.0301408179012345*G0_1_0;
    A[72] = 0.172233245149907*G0_0_0 + 0.0301408179012311*G0_0_1 + 0.0301408179012338*G0_1_0;
    A[73] = 0.340160659171074*G0_0_0 + 0.0710462136243409*G0_0_1 + 0.0710462136243393*G0_1_0;
    A[74] = 0.198068231922395*G0_0_0 + 0.269114445546734*G0_0_1 + 0.269114445546735*G0_1_0 + 0.340160659171073*G0_1_1;
    A[75] = -0.359536899250436*G0_0_0 - 0.663097993827155*G0_0_1 - 0.663097993827155*G0_1_0 - 0.895612874779531*G0_1_1;
    A[76] = 0.286337770061724*G0_0_0 + 0.865472056878298*G0_0_1 + 0.8654720568783*G0_1_0 + 1.39508928571427*G0_1_1;
    A[77] = -0.286337770061725*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080246*G0_1_0 - 2.56196952160492*G0_1_1;
    A[78] = -0.667403824955902*G0_0_0 - 0.262655698853613*G0_0_1 - 0.262655698853609*G0_1_0;
    A[79] = 1.35633680555554*G0_0_0 + 0.572675540123453*G0_0_1 + 0.572675540123445*G0_1_0;
    A[80] = -2.82031938932979*G0_0_0 - 1.66205081569664*G0_0_1 - 1.66205081569663*G0_1_0;
    A[81] = -0.419818535052911*G0_0_0 - 0.0731991291887145*G0_0_1 - 0.0731991291887099*G0_1_0;
    A[82] = 1.19486813822751*G0_0_0 + 0.572675540123455*G0_0_1 + 0.572675540123456*G0_1_0;
    A[83] = -0.990341159611985*G0_0_0 - 0.262655698853612*G0_0_1 - 0.262655698853615*G0_1_0;
    A[84] = -0.0379774305555561*G0_0_0 - 0.0379774305555558*G0_0_1 - 0.0379774305555545*G0_1_0 - 0.0379774305555543*G0_1_1;
    A[85] = -0.0158454585537937*G0_0_0 - 0.610050154320985*G0_1_0;
    A[86] = 0.380291005291006*G0_0_1 - 0.0696683476631372*G0_1_1;
    A[87] = -0.906377452601409*G0_0_0 - 0.529617228835981*G0_0_1 + 0.796578758818337*G0_1_0 - 1.39508928571428*G0_1_1;
    A[88] = 3.07436342592592*G0_0_0 + 1.17549189814815*G0_0_1 + 1.17549189814815*G0_1_0 + 3.69440310846559*G0_1_1;
    A[89] = -1.80414324294532*G0_0_0 + 0.69969755842151*G0_0_1 - 0.350925236992947*G0_1_0 - 1.80414324294532*G0_1_1;
    A[90] = 0.895612874779541*G0_0_0 - 0.48225308641975*G0_0_1 + 0.232514880952383*G0_1_0 + 0.818107914462077*G0_1_1;
    A[91] = 0.13132784942681*G0_0_0 + 0.101187031525576*G0_0_1 + 0.101187031525575*G0_1_0 + 0.0710462136243381*G0_1_1;
    A[92] = -0.297102347883603*G0_0_0 - 0.148551173941805*G0_0_1 - 0.148551173941801*G0_1_0 - 0.0172233245149925*G0_1_1;
    A[93] = -0.21959738756613*G0_0_0 - 0.062434551366835*G0_0_1 - 0.062434551366842*G0_1_0 - 0.0172233245149881*G0_1_1;
    A[94] = -0.89561287477954*G0_0_0 - 0.232514880952385*G0_0_1 - 0.232514880952383*G0_1_0 + 0.0710462136243353*G0_1_1;
    A[95] = 0.111951609347444*G0_0_0 + 0.142092427248677*G0_0_1 + 0.142092427248675*G0_1_0 + 0.172233245149911*G0_1_1;
    A[96] = -0.111951609347442*G0_0_0 - 0.157162836199293*G0_0_1 - 0.157162836199291*G0_1_0 - 0.219597387566139*G0_1_1;
    A[97] = 0.103339947089946*G0_0_0 + 0.133480764991184*G0_0_1 + 0.133480764991179*G0_1_0 + 0.266961529982366*G0_1_1;
    A[98] = -0.0495170579805987*G0_0_0 + 0.529617228835981*G0_0_1 + 0.529617228835978*G0_1_0 + 1.39508928571428*G0_1_1;
    A[99] = -0.344466490299827*G0_0_0 - 0.447806437389772*G0_0_1 - 0.447806437389773*G0_1_0 - 0.516699735449737*G0_1_1;
    A[100] = 0.387524801587307*G0_0_0 + 0.859013310185179*G0_0_1 + 0.85901331018519*G0_1_0 + 1.01187031525573*G0_1_1;
    A[101] = 0.731991291887121*G0_0_0 - 1.30897266313933*G0_0_1 - 1.30897266313933*G0_1_0 - 3.96136463844796*G0_1_1;
    A[102] = 1.03339947089947*G0_0_0 + 0.374607308201062*G0_0_1 + 0.374607308201053*G0_1_0 + 0.0430583112874783*G0_1_1;
    A[103] = -3.81066054894178*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525572*G0_1_1;
    A[104] = 2.02374063051145*G0_0_0 + 0.413359788359785*G0_0_1 + 0.413359788359789*G0_1_0 - 0.516699735449728*G0_1_1;
    A[105] = -0.0379774305555538*G0_0_0 - 0.037977430555554*G0_0_1 - 0.0379774305555549*G0_1_0 - 0.037977430555555*G0_1_1;
    A[106] = -0.0696683476631382*G0_0_0 + 0.380291005291002*G0_1_0;
    A[107] = -0.610050154320988*G0_0_1 - 0.0158454585537929*G0_1_1;
    A[108] = 0.818107914462078*G0_0_0 + 0.232514880952381*G0_0_1 - 0.482253086419752*G0_1_0 + 0.895612874779533*G0_1_1;
    A[109] = -1.80414324294532*G0_0_0 - 0.350925236992947*G0_0_1 + 0.69969755842151*G0_1_0 - 1.80414324294532*G0_1_1;
    A[110] = 3.6944031084656*G0_0_0 + 1.17549189814814*G0_0_1 + 1.17549189814814*G0_1_0 + 3.0743634259259*G0_1_1;
    A[111] = -1.39508928571428*G0_0_0 + 0.79657875881834*G0_0_1 - 0.529617228835976*G0_1_0 - 0.906377452601404*G0_1_1;
    A[112] = 0.172233245149906*G0_0_0 + 0.14209242724867*G0_0_1 + 0.142092427248673*G0_1_0 + 0.111951609347439*G0_1_1;
    A[113] = -0.219597387566128*G0_0_0 - 0.157162836199283*G0_0_1 - 0.157162836199291*G0_1_0 - 0.111951609347437*G0_1_1;
    A[114] = 0.266961529982354*G0_0_0 + 0.133480764991172*G0_0_1 + 0.133480764991179*G0_1_0 + 0.103339947089942*G0_1_1;
    A[115] = 1.39508928571428*G0_0_0 + 0.529617228835983*G0_0_1 + 0.529617228835977*G0_1_0 - 0.0495170579805959*G0_1_1;
    A[116] = 0.0710462136243354*G0_0_0 + 0.101187031525572*G0_0_1 + 0.101187031525572*G0_1_0 + 0.131327849426806*G0_1_1;
    A[117] = -0.0172233245149888*G0_0_0 - 0.148551173941798*G0_0_1 - 0.148551173941797*G0_1_0 - 0.297102347883594*G0_1_1;
    A[118] = -0.0172233245149926*G0_0_0 - 0.0624345513668466*G0_0_1 - 0.0624345513668439*G0_1_0 - 0.21959738756614*G0_1_1;
    A[119] = 0.0710462136243387*G0_0_0 - 0.232514880952382*G0_0_1 - 0.232514880952379*G0_1_0 - 0.895612874779535*G0_1_1;
    A[120] = -0.516699735449724*G0_0_0 - 0.447806437389765*G0_0_1 - 0.447806437389764*G0_1_0 - 0.344466490299821*G0_1_1;
    A[121] = 0.0430583112874709*G0_0_0 + 0.374607308201058*G0_0_1 + 0.374607308201052*G0_1_0 + 1.03339947089946*G0_1_1;
    A[122] = -0.516699735449731*G0_0_0 + 0.413359788359793*G0_0_1 + 0.41335978835979*G0_1_0 + 2.02374063051146*G0_1_1;
    A[123] = 1.01187031525572*G0_0_0 + 0.859013310185172*G0_0_1 + 0.859013310185178*G0_1_0 + 0.387524801587298*G0_1_1;
    A[124] = 1.01187031525573*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 - 3.81066054894177*G0_1_1;
    A[125] = -3.96136463844795*G0_0_0 - 1.30897266313932*G0_0_1 - 1.30897266313932*G0_1_0 + 0.731991291887121*G0_1_1;
    A[126] = -0.040819279100529*G0_0_0 - 0.040819279100529*G0_0_1 - 0.0408192791005282*G0_1_0 - 0.0408192791005283*G0_1_1;
    A[127] = 0.0408192791005282*G0_0_0 - 0.161554783950616*G0_1_0;
    A[128] = 0.850315531305113*G0_0_1 + 0.20228794642857*G0_1_1;
    A[129] = -0.340160659171074*G0_0_0 - 0.0710462136243394*G0_0_1 + 0.329396081349206*G0_1_0 - 0.340160659171072*G0_1_1;
    A[130] = 0.895612874779541*G0_0_0 + 0.232514880952383*G0_0_1 - 0.48225308641975*G0_1_0 + 0.818107914462077*G0_1_1;
    A[131] = -1.39508928571428*G0_0_0 - 0.529617228835976*G0_0_1 + 0.79657875881834*G0_1_0 - 0.906377452601404*G0_1_1;
    A[132] = 2.56196952160493*G0_0_0 + 1.28098476080246*G0_0_1 + 1.28098476080246*G0_1_0 + 1.98929398148147*G0_1_1;
    A[133] = 0.340160659171078*G0_0_0 + 0.269114445546738*G0_0_1 + 0.269114445546737*G0_1_0 + 0.198068231922396*G0_1_1;
    A[134] = -0.895612874779545*G0_0_0 - 0.663097993827163*G0_0_1 - 0.66309799382716*G0_1_0 - 0.359536899250439*G0_1_1;
    A[135] = 1.39508928571429*G0_0_0 + 0.865472056878311*G0_0_1 + 0.865472056878304*G0_1_0 + 0.286337770061729*G0_1_1;
    A[136] = -2.56196952160493*G0_0_0 - 1.28098476080247*G0_0_1 - 1.28098476080246*G0_1_0 - 0.286337770061728*G0_1_1;
    A[137] = 0.07104621362434*G0_0_1 + 0.071046213624338*G0_1_0 + 0.142092427248678*G0_1_1;
    A[138] = 0.0301408179012343*G0_0_1 + 0.0301408179012348*G0_1_0 + 0.131327849426807*G0_1_1;
    A[139] = 0.0301408179012361*G0_0_1 + 0.0301408179012338*G0_1_0 + 0.172233245149912*G0_1_1;
    A[140] = 0.0710462136243392*G0_0_1 + 0.0710462136243384*G0_1_0 + 0.340160659171072*G0_1_1;
    A[141] = -0.262655698853621*G0_0_1 - 0.262655698853615*G0_1_0 - 0.66740382495591*G0_1_1;
    A[142] = -0.0731991291887108*G0_0_1 - 0.0731991291887092*G0_1_0 - 0.419818535052906*G0_1_1;
    A[143] = -0.262655698853619*G0_0_1 - 0.262655698853619*G0_1_0 - 0.99034115961199*G0_1_1;
    A[144] = 0.572675540123462*G0_0_1 + 0.572675540123456*G0_1_0 + 1.35633680555555*G0_1_1;
    A[145] = 0.572675540123451*G0_0_1 + 0.572675540123453*G0_1_0 + 1.1948681382275*G0_1_1;
    A[146] = -1.66205081569664*G0_0_1 - 1.66205081569664*G0_1_0 - 2.82031938932979*G0_1_1;
    A[147] = 0.202287946428571*G0_0_0 + 0.202287946428571*G0_0_1 - 0.64802758487654*G0_1_0 - 0.648027584876541*G0_1_1;
    A[148] = -0.0408192791005284*G0_0_0;
    A[149] = 0.161554783950618*G0_0_1 + 0.202374063051146*G0_1_1;
    A[150] = 0.142092427248674*G0_0_0 + 0.0710462136243363*G0_0_1 + 0.0710462136243362*G0_1_0;
    A[151] = 0.13132784942681*G0_0_0 + 0.101187031525575*G0_0_1 + 0.101187031525576*G0_1_0 + 0.0710462136243381*G0_1_1;
    A[152] = 0.172233245149906*G0_0_0 + 0.142092427248673*G0_0_1 + 0.14209242724867*G0_1_0 + 0.111951609347439*G0_1_1;
    A[153] = 0.340160659171078*G0_0_0 + 0.269114445546737*G0_0_1 + 0.269114445546738*G0_1_0 + 0.198068231922396*G0_1_1;
    A[154] = 1.98929398148147*G0_0_0 + 0.708309220679007*G0_0_1 + 0.708309220679007*G0_1_0 + 1.98929398148147*G0_1_1;
    A[155] = -0.906377452601406*G0_0_0 - 1.70295621141974*G0_0_1 - 0.376760223765426*G0_1_0 - 2.56842826829805*G0_1_1;
    A[156] = 0.818107914462077*G0_0_0 + 1.30036100088183*G0_0_1 + 0.585593033509693*G0_1_0 + 1.96345899470898*G0_1_1;
    A[157] = -0.340160659171078*G0_0_0 - 0.66955674052028*G0_0_1 - 0.269114445546738*G0_1_0 - 0.938671186067016*G0_1_1;
    A[158] = -0.286337770061728*G0_0_0 + 0.994646990740736*G0_0_1 + 0.994646990740735*G0_1_0 - 0.286337770061729*G0_1_1;
    A[159] = 0.286337770061726*G0_0_0 - 0.579134286816575*G0_0_1 - 0.579134286816575*G0_1_0 - 0.049517057980602*G0_1_1;
    A[160] = -0.359536899250437*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576719*G0_1_0 + 0.0710462136243417*G0_1_1;
    A[161] = 0.198068231922396*G0_0_0 - 0.0710462136243371*G0_0_1 - 0.0710462136243399*G0_1_0;
    A[162] = -2.82031938932979*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063499*G0_1_1;
    A[163] = 1.35633680555554*G0_0_0 + 0.783661265432094*G0_0_1 + 0.783661265432094*G0_1_0 + 0.21098572530864*G0_1_1;
    A[164] = -0.667403824955901*G0_0_0 - 0.404748126102293*G0_0_1 - 0.40474812610229*G0_1_0 - 0.142092427248677*G0_1_1;
    A[165] = 1.19486813822751*G0_0_0 + 0.622192598104048*G0_0_1 + 0.622192598104048*G0_1_0 + 0.0495170579805897*G0_1_1;
    A[166] = -0.419818535052911*G0_0_0 - 0.346619405864192*G0_0_1 - 0.346619405864199*G0_1_0 - 0.273420276675483*G0_1_1;
    A[167] = -0.990341159611982*G0_0_0 - 0.727685460758374*G0_0_1 - 0.727685460758364*G0_1_0 - 0.465029761904753*G0_1_1;
    A[168] = -0.0158454585537927*G0_0_0 - 0.0158454585537928*G0_0_1 + 0.594204695767193*G0_1_0 + 0.594204695767193*G0_1_1;
    A[169] = -0.037977430555556*G0_0_0;
    A[170] = -0.380291005291006*G0_0_1 - 0.449959352954144*G0_1_1;
    A[171] = 0.131327849426809*G0_0_0 + 0.0301408179012345*G0_0_1 + 0.0301408179012379*G0_1_0;
    A[172] = -0.297102347883603*G0_0_0 - 0.148551173941801*G0_0_1 - 0.148551173941805*G0_1_0 - 0.0172233245149925*G0_1_1;
    A[173] = -0.219597387566128*G0_0_0 - 0.157162836199291*G0_0_1 - 0.157162836199283*G0_1_0 - 0.111951609347437*G0_1_1;
    A[174] = -0.895612874779545*G0_0_0 - 0.66309799382716*G0_0_1 - 0.663097993827163*G0_1_0 - 0.359536899250439*G0_1_1;
    A[175] = -0.906377452601406*G0_0_0 - 0.376760223765426*G0_0_1 - 1.70295621141974*G0_1_0 - 2.56842826829805*G0_1_1;
    A[176] = 3.07436342592592*G0_0_0 + 1.89887152777777*G0_0_1 + 1.89887152777777*G0_1_0 + 4.41778273809521*G0_1_1;
    A[177] = -1.80414324294532*G0_0_0 - 2.50384080136683*G0_0_1 - 1.45321800595237*G0_1_0 - 3.9570588073192*G0_1_1;
    A[178] = 0.895612874779545*G0_0_0 + 1.37786596119929*G0_0_1 + 0.663097993827163*G0_1_0 + 1.96345899470899*G0_1_1;
    A[179] = -0.0495170579805976*G0_0_0 - 0.579134286816577*G0_0_1 - 0.579134286816575*G0_1_0 + 0.286337770061727*G0_1_1;
    A[180] = 0.103339947089946*G0_0_0 - 0.0301408179012345*G0_0_1 - 0.0301408179012339*G0_1_0 + 0.103339947089949*G0_1_1;
    A[181] = -0.111951609347442*G0_0_0 + 0.0452112268518518*G0_0_1 + 0.0452112268518497*G0_1_0 - 0.0172233245149949*G0_1_1;
    A[182] = 0.111951609347443*G0_0_0 - 0.0301408179012338*G0_0_1 - 0.0301408179012322*G0_1_0;
    A[183] = 0.731991291887122*G0_0_0 + 2.04096395502645*G0_0_1 + 2.04096395502644*G0_1_0 - 0.611428020282191*G0_1_1;
    A[184] = 0.387524801587298*G0_0_0 - 0.471488508597881*G0_0_1 - 0.47148850859788*G0_1_0 - 0.318631503527332*G0_1_1;
    A[185] = -0.344466490299823*G0_0_0 + 0.103339947089949*G0_0_1 + 0.103339947089945*G0_1_0 + 0.0344466490299834*G0_1_1;
    A[186] = -3.81066054894178*G0_0_0 - 2.40911251653438*G0_0_1 - 2.40911251653437*G0_1_0 + 0.00430583112875654*G0_1_1;
    A[187] = 1.03339947089947*G0_0_0 + 0.658792162698407*G0_0_1 + 0.658792162698414*G0_1_0 + 0.327243165784827*G0_1_1;
    A[188] = 2.02374063051144*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215165*G0_1_0 + 0.680321318342141*G0_1_1;
    A[189] = -0.069668347663138*G0_0_0 - 0.069668347663138*G0_0_1 - 0.449959352954142*G0_1_0 - 0.449959352954143*G0_1_1;
    A[190] = -0.0379774305555544*G0_0_0;
    A[191] = 0.610050154320987*G0_0_1 + 0.594204695767196*G0_1_1;
    A[192] = 0.172233245149907*G0_0_0 + 0.0301408179012338*G0_0_1 + 0.0301408179012311*G0_1_0;
    A[193] = -0.219597387566131*G0_0_0 - 0.062434551366842*G0_0_1 - 0.062434551366835*G0_1_0 - 0.0172233245149881*G0_1_1;
    A[194] = 0.266961529982354*G0_0_0 + 0.133480764991179*G0_0_1 + 0.133480764991172*G0_1_0 + 0.103339947089942*G0_1_1;
    A[195] = 1.39508928571429*G0_0_0 + 0.865472056878304*G0_0_1 + 0.865472056878311*G0_1_0 + 0.286337770061729*G0_1_1;
    A[196] = 0.818107914462077*G0_0_0 + 0.585593033509694*G0_0_1 + 1.30036100088183*G0_1_0 + 1.96345899470898*G0_1_1;
    A[197] = -1.80414324294532*G0_0_0 - 1.45321800595237*G0_0_1 - 2.50384080136683*G0_1_0 - 3.9570588073192*G0_1_1;
    A[198] = 3.6944031084656*G0_0_0 + 2.51891121031745*G0_0_1 + 2.51891121031745*G0_1_0 + 4.41778273809522*G0_1_1;
    A[199] = -1.39508928571429*G0_0_0 - 2.19166804453262*G0_0_1 - 0.865472056878312*G0_1_0 - 2.56842826829805*G0_1_1;
    A[200] = 0.0710462136243353*G0_0_0 + 0.30356109457672*G0_0_1 + 0.303561094576716*G0_1_0 - 0.359536899250439*G0_1_1;
    A[201] = -0.0172233245149901*G0_0_0 + 0.0452112268518527*G0_0_1 + 0.0452112268518517*G0_1_0 - 0.111951609347445*G0_1_1;
    A[202] = -0.0172233245149894*G0_0_0 + 0.131327849426811*G0_0_1 + 0.131327849426809*G0_1_0 - 0.017223324514987*G0_1_1;
    A[203] = 0.0710462136243358*G0_0_0 - 0.0301408179012346*G0_0_1 - 0.0301408179012364*G0_1_0;
    A[204] = -0.516699735449726*G0_0_0 - 0.93005952380952*G0_0_1 - 0.930059523809516*G0_1_0 + 0.680321318342151*G0_1_1;
    A[205] = 0.0430583112874713*G0_0_0 - 0.331548996913582*G0_0_1 - 0.33154899691358*G0_1_0 + 0.327243165784829*G0_1_1;
    A[206] = -0.516699735449729*G0_0_0 - 0.0688932980599681*G0_0_1 - 0.0688932980599629*G0_1_0 + 0.0344466490299786*G0_1_1;
    A[207] = 1.01187031525573*G0_0_0 + 2.41341834766314*G0_0_1 + 2.41341834766313*G0_1_0 + 0.00430583112874527*G0_1_1;
    A[208] = 1.01187031525572*G0_0_0 + 0.15285700507055*G0_0_1 + 0.15285700507054*G0_1_0 - 0.318631503527332*G0_1_1;
    A[209] = -3.96136463844795*G0_0_0 - 2.65239197530864*G0_0_1 - 2.65239197530862*G0_1_0 - 0.611428020282183*G0_1_1;
    A[210] = 0.0408192791005289*G0_0_0 + 0.0408192791005289*G0_0_1 + 0.202374063051146*G0_1_0 + 0.202374063051146*G0_1_1;
    A[211] = -0.0408192791005282*G0_0_0;
    A[212] = -0.850315531305113*G0_0_1 - 0.648027584876543*G0_1_1;
    A[213] = 0.340160659171074*G0_0_0 + 0.0710462136243393*G0_0_1 + 0.0710462136243409*G0_1_0;
    A[214] = -0.89561287477954*G0_0_0 - 0.232514880952383*G0_0_1 - 0.232514880952385*G0_1_0 + 0.0710462136243353*G0_1_1;
    A[215] = 1.39508928571428*G0_0_0 + 0.529617228835977*G0_0_1 + 0.529617228835983*G0_1_0 - 0.0495170579805959*G0_1_1;
    A[216] = -2.56196952160493*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080247*G0_1_0 - 0.286337770061728*G0_1_1;
    A[217] = -0.340160659171078*G0_0_0 - 0.269114445546738*G0_0_1 - 0.66955674052028*G0_1_0 - 0.938671186067016*G0_1_1;
    A[218] = 0.895612874779545*G0_0_0 + 0.663097993827164*G0_0_1 + 1.37786596119929*G0_1_0 + 1.96345899470899*G0_1_1;
    A[219] = -1.39508928571429*G0_0_0 - 0.865472056878312*G0_0_1 - 2.19166804453262*G0_1_0 - 2.56842826829805*G0_1_1;
    A[220] = 2.56196952160493*G0_0_0 + 1.28098476080247*G0_0_1 + 1.28098476080247*G0_1_0 + 1.98929398148148*G0_1_1;
    A[221] = -0.07104621362434*G0_0_1 - 0.0710462136243373*G0_1_0 + 0.198068231922398*G0_1_1;
    A[222] = -0.0301408179012347*G0_0_1 - 0.0301408179012351*G0_1_0 + 0.111951609347443*G0_1_1;
    A[223] = -0.030140817901236*G0_0_1 - 0.0301408179012352*G0_1_0 + 0.0710462136243355*G0_1_1;
    A[224] = -0.071046213624339*G0_0_1 - 0.0710462136243377*G0_1_0;
    A[225] = 0.262655698853621*G0_0_1 + 0.262655698853613*G0_1_0 - 0.46502976190476*G0_1_1;
    A[226] = 0.0731991291887117*G0_0_1 + 0.0731991291887132*G0_1_0 - 0.273420276675482*G0_1_1;
    A[227] = 0.262655698853618*G0_0_1 + 0.262655698853614*G0_1_0 - 0.142092427248673*G0_1_1;
    A[228] = -0.572675540123461*G0_0_1 - 0.572675540123456*G0_1_0 + 0.0495170579805962*G0_1_1;
    A[229] = -0.572675540123452*G0_0_1 - 0.572675540123448*G0_1_0 + 0.210985725308638*G0_1_1;
    A[230] = 1.66205081569664*G0_0_1 + 1.66205081569664*G0_1_0 + 0.503782242063493*G0_1_1;
    A[231] = -0.64802758487654*G0_0_0 - 0.64802758487654*G0_0_1 + 0.202287946428571*G0_1_0 + 0.202287946428572*G0_1_1;
    A[232] = 0.202374063051145*G0_0_0 + 0.161554783950616*G0_1_0;
    A[233] = -0.0408192791005285*G0_1_1;
    A[234] = 0.198068231922395*G0_0_0 + 0.269114445546735*G0_0_1 + 0.269114445546734*G0_1_0 + 0.340160659171073*G0_1_1;
    A[235] = 0.111951609347444*G0_0_0 + 0.142092427248675*G0_0_1 + 0.142092427248677*G0_1_0 + 0.172233245149911*G0_1_1;
    A[236] = 0.0710462136243354*G0_0_0 + 0.101187031525571*G0_0_1 + 0.101187031525572*G0_1_0 + 0.131327849426806*G0_1_1;
    A[237] = 0.071046213624338*G0_0_1 + 0.07104621362434*G0_1_0 + 0.142092427248678*G0_1_1;
    A[238] = -0.286337770061728*G0_0_0 + 0.994646990740735*G0_0_1 + 0.994646990740736*G0_1_0 - 0.286337770061729*G0_1_1;
    A[239] = -0.0495170579805976*G0_0_0 - 0.579134286816575*G0_0_1 - 0.579134286816577*G0_1_0 + 0.286337770061727*G0_1_1;
    A[240] = 0.0710462136243353*G0_0_0 + 0.303561094576717*G0_0_1 + 0.30356109457672*G0_1_0 - 0.359536899250439*G0_1_1;
    A[241] = -0.0710462136243373*G0_0_1 - 0.07104621362434*G0_1_0 + 0.198068231922398*G0_1_1;
    A[242] = 1.98929398148147*G0_0_0 + 0.708309220679006*G0_0_1 + 0.708309220679006*G0_1_0 + 1.98929398148147*G0_1_1;
    A[243] = -2.56842826829804*G0_0_0 - 0.376760223765429*G0_0_1 - 1.70295621141974*G0_1_0 - 0.906377452601403*G0_1_1;
    A[244] = 1.96345899470898*G0_0_0 + 0.585593033509695*G0_0_1 + 1.30036100088183*G0_1_0 + 0.818107914462073*G0_1_1;
    A[245] = -0.938671186067014*G0_0_0 - 0.269114445546736*G0_0_1 - 0.669556740520278*G0_1_0 - 0.340160659171073*G0_1_1;
    A[246] = 0.503782242063491*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 - 2.82031938932979*G0_1_1;
    A[247] = 0.0495170579805971*G0_0_0 + 0.622192598104045*G0_0_1 + 0.622192598104045*G0_1_0 + 1.1948681382275*G0_1_1;
    A[248] = -0.465029761904755*G0_0_0 - 0.727685460758368*G0_0_1 - 0.727685460758368*G0_1_0 - 0.990341159611985*G0_1_1;
    A[249] = 0.210985725308639*G0_0_0 + 0.783661265432093*G0_0_1 + 0.783661265432096*G0_1_0 + 1.35633680555555*G0_1_1;
    A[250] = -0.273420276675483*G0_0_0 - 0.346619405864192*G0_0_1 - 0.346619405864195*G0_1_0 - 0.419818535052904*G0_1_1;
    A[251] = -0.142092427248672*G0_0_0 - 0.404748126102289*G0_0_1 - 0.404748126102292*G0_1_0 - 0.667403824955909*G0_1_1;
    A[252] = 0.594204695767192*G0_0_0 + 0.594204695767192*G0_0_1 - 0.0158454585537913*G0_1_0 - 0.0158454585537913*G0_1_1;
    A[253] = -0.449959352954142*G0_0_0 - 0.380291005291001*G0_1_0;
    A[254] = -0.0379774305555554*G0_1_1;
    A[255] = -0.359536899250436*G0_0_0 - 0.663097993827155*G0_0_1 - 0.663097993827155*G0_1_0 - 0.895612874779531*G0_1_1;
    A[256] = -0.111951609347442*G0_0_0 - 0.157162836199291*G0_0_1 - 0.157162836199293*G0_1_0 - 0.219597387566139*G0_1_1;
    A[257] = -0.0172233245149888*G0_0_0 - 0.148551173941797*G0_0_1 - 0.148551173941798*G0_1_0 - 0.297102347883594*G0_1_1;
    A[258] = 0.0301408179012348*G0_0_1 + 0.0301408179012343*G0_1_0 + 0.131327849426806*G0_1_1;
    A[259] = 0.286337770061726*G0_0_0 - 0.579134286816575*G0_0_1 - 0.579134286816576*G0_1_0 - 0.049517057980602*G0_1_1;
    A[260] = 0.103339947089946*G0_0_0 - 0.0301408179012339*G0_0_1 - 0.0301408179012345*G0_1_0 + 0.103339947089949*G0_1_1;
    A[261] = -0.0172233245149901*G0_0_0 + 0.0452112268518519*G0_0_1 + 0.0452112268518527*G0_1_0 - 0.111951609347445*G0_1_1;
    A[262] = -0.0301408179012351*G0_0_1 - 0.0301408179012347*G0_1_0 + 0.111951609347443*G0_1_1;
    A[263] = -2.56842826829804*G0_0_0 - 1.70295621141974*G0_0_1 - 0.376760223765429*G0_1_0 - 0.906377452601403*G0_1_1;
    A[264] = 4.41778273809521*G0_0_0 + 1.89887152777776*G0_0_1 + 1.89887152777776*G0_1_0 + 3.0743634259259*G0_1_1;
    A[265] = -3.9570588073192*G0_0_0 - 1.45321800595237*G0_0_1 - 2.50384080136682*G0_1_0 - 1.80414324294531*G0_1_1;
    A[266] = 1.96345899470898*G0_0_0 + 0.663097993827155*G0_0_1 + 1.37786596119928*G0_1_0 + 0.895612874779531*G0_1_1;
    A[267] = -0.611428020282184*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502644*G0_1_0 + 0.731991291887116*G0_1_1;
    A[268] = 0.00430583112875335*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653437*G0_1_0 - 3.81066054894177*G0_1_1;
    A[269] = 0.680321318342141*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215166*G0_1_0 + 2.02374063051145*G0_1_1;
    A[270] = -0.318631503527334*G0_0_0 - 0.471488508597882*G0_0_1 - 0.471488508597882*G0_1_0 + 0.387524801587306*G0_1_1;
    A[271] = 0.327243165784828*G0_0_0 + 0.658792162698405*G0_0_1 + 0.658792162698409*G0_1_0 + 1.03339947089947*G0_1_1;
    A[272] = 0.0344466490299804*G0_0_0 + 0.103339947089947*G0_0_1 + 0.103339947089946*G0_1_0 - 0.344466490299824*G0_1_1;
    A[273] = -0.449959352954142*G0_0_0 - 0.449959352954142*G0_0_1 - 0.0696683476631398*G0_1_0 - 0.0696683476631396*G0_1_1;
    A[274] = 0.594204695767192*G0_0_0 + 0.610050154320982*G0_1_0;
    A[275] = -0.0379774305555546*G0_1_1;
    A[276] = 0.286337770061724*G0_0_0 + 0.8654720568783*G0_0_1 + 0.865472056878298*G0_1_0 + 1.39508928571427*G0_1_1;
    A[277] = 0.103339947089946*G0_0_0 + 0.133480764991179*G0_0_1 + 0.133480764991184*G0_1_0 + 0.266961529982366*G0_1_1;
    A[278] = -0.0172233245149927*G0_0_0 - 0.0624345513668439*G0_0_1 - 0.0624345513668466*G0_1_0 - 0.21959738756614*G0_1_1;
    A[279] = 0.0301408179012337*G0_0_1 + 0.0301408179012361*G0_1_0 + 0.172233245149912*G0_1_1;
    A[280] = -0.359536899250437*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576719*G0_1_0 + 0.0710462136243417*G0_1_1;
    A[281] = -0.111951609347442*G0_0_0 + 0.0452112268518497*G0_0_1 + 0.0452112268518518*G0_1_0 - 0.0172233245149949*G0_1_1;
    A[282] = -0.0172233245149894*G0_0_0 + 0.131327849426809*G0_0_1 + 0.131327849426811*G0_1_0 - 0.017223324514987*G0_1_1;
    A[283] = -0.0301408179012352*G0_0_1 - 0.030140817901236*G0_1_0 + 0.0710462136243355*G0_1_1;
    A[284] = 1.96345899470898*G0_0_0 + 1.30036100088183*G0_0_1 + 0.585593033509695*G0_1_0 + 0.818107914462073*G0_1_1;
    A[285] = -3.9570588073192*G0_0_0 - 2.50384080136682*G0_0_1 - 1.45321800595237*G0_1_0 - 1.80414324294531*G0_1_1;
    A[286] = 4.41778273809521*G0_0_0 + 2.51891121031744*G0_0_1 + 2.51891121031744*G0_1_0 + 3.69440310846558*G0_1_1;
    A[287] = -2.56842826829804*G0_0_0 - 0.865472056878301*G0_0_1 - 2.19166804453261*G0_1_0 - 1.39508928571427*G0_1_1;
    A[288] = 0.680321318342151*G0_0_0 - 0.930059523809514*G0_0_1 - 0.93005952380951*G0_1_0 - 0.516699735449723*G0_1_1;
    A[289] = 0.00430583112873832*G0_0_0 + 2.41341834766311*G0_0_1 + 2.41341834766311*G0_1_0 + 1.01187031525571*G0_1_1;
    A[290] = -0.611428020282177*G0_0_0 - 2.65239197530862*G0_0_1 - 2.65239197530862*G0_1_0 - 3.96136463844795*G0_1_1;
    A[291] = 0.32724316578483*G0_0_0 - 0.331548996913579*G0_0_1 - 0.331548996913577*G0_1_0 + 0.0430583112874745*G0_1_1;
    A[292] = -0.318631503527333*G0_0_0 + 0.152857005070552*G0_0_1 + 0.152857005070543*G0_1_0 + 1.01187031525573*G0_1_1;
    A[293] = 0.0344466490299806*G0_0_0 - 0.0688932980599666*G0_0_1 - 0.0688932980599646*G0_1_0 - 0.516699735449736*G0_1_1;
    A[294] = 0.202374063051145*G0_0_0 + 0.202374063051146*G0_0_1 + 0.0408192791005295*G0_1_0 + 0.0408192791005296*G0_1_1;
    A[295] = -0.64802758487654*G0_0_0 - 0.85031553130511*G0_1_0;
    A[296] = -0.0408192791005283*G0_1_1;
    A[297] = -0.286337770061725*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080246*G0_1_0 - 2.56196952160492*G0_1_1;
    A[298] = -0.0495170579805987*G0_0_0 + 0.529617228835977*G0_0_1 + 0.529617228835981*G0_1_0 + 1.39508928571428*G0_1_1;
    A[299] = 0.0710462136243387*G0_0_0 - 0.232514880952379*G0_0_1 - 0.232514880952382*G0_1_0 - 0.895612874779535*G0_1_1;
    A[300] = 0.0710462136243384*G0_0_1 + 0.0710462136243392*G0_1_0 + 0.340160659171072*G0_1_1;
    A[301] = 0.198068231922396*G0_0_0 - 0.0710462136243399*G0_0_1 - 0.0710462136243371*G0_1_0;
    A[302] = 0.111951609347443*G0_0_0 - 0.0301408179012322*G0_0_1 - 0.0301408179012338*G0_1_0;
    A[303] = 0.0710462136243358*G0_0_0 - 0.0301408179012364*G0_0_1 - 0.0301408179012346*G0_1_0;
    A[304] = -0.0710462136243377*G0_0_1 - 0.071046213624339*G0_1_0;
    A[305] = -0.938671186067014*G0_0_0 - 0.669556740520278*G0_0_1 - 0.269114445546736*G0_1_0 - 0.340160659171073*G0_1_1;
    A[306] = 1.96345899470898*G0_0_0 + 1.37786596119928*G0_0_1 + 0.663097993827155*G0_1_0 + 0.895612874779531*G0_1_1;
    A[307] = -2.56842826829804*G0_0_0 - 2.19166804453261*G0_0_1 - 0.865472056878301*G0_1_0 - 1.39508928571427*G0_1_1;
    A[308] = 1.98929398148147*G0_0_0 + 1.28098476080246*G0_0_1 + 1.28098476080246*G0_1_0 + 2.56196952160492*G0_1_1;
    A[309] = -0.465029761904761*G0_0_0 + 0.262655698853611*G0_0_1 + 0.262655698853609*G0_1_0;
    A[310] = 0.0495170579806064*G0_0_0 - 0.572675540123445*G0_0_1 - 0.572675540123445*G0_1_0;
    A[311] = 0.503782242063484*G0_0_0 + 1.66205081569664*G0_0_1 + 1.66205081569663*G0_1_0;
    A[312] = -0.273420276675487*G0_0_0 + 0.0731991291887106*G0_0_1 + 0.0731991291887092*G0_1_0;
    A[313] = 0.210985725308642*G0_0_0 - 0.572675540123459*G0_0_1 - 0.572675540123457*G0_1_0;
    A[314] = -0.142092427248674*G0_0_0 + 0.262655698853619*G0_0_1 + 0.262655698853617*G0_1_0;
    A[315] = -0.215291556437388*G0_0_0 - 0.215291556437389*G0_0_1 - 0.215291556437391*G0_1_0 - 0.215291556437392*G0_1_1;
    A[316] = 0.107645778218694*G0_0_0;
    A[317] = 0.107645778218693*G0_1_1;
    A[318] = -0.667403824955902*G0_0_0 - 0.262655698853609*G0_0_1 - 0.262655698853613*G0_1_0;
    A[319] = -0.344466490299827*G0_0_0 - 0.447806437389773*G0_0_1 - 0.447806437389772*G0_1_0 - 0.516699735449737*G0_1_1;
    A[320] = -0.516699735449724*G0_0_0 - 0.447806437389764*G0_0_1 - 0.447806437389765*G0_1_0 - 0.344466490299821*G0_1_1;
    A[321] = -0.262655698853615*G0_0_1 - 0.262655698853621*G0_1_0 - 0.66740382495591*G0_1_1;
    A[322] = -2.82031938932979*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063499*G0_1_1;
    A[323] = 0.731991291887122*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502645*G0_1_0 - 0.61142802028219*G0_1_1;
    A[324] = -0.516699735449726*G0_0_0 - 0.930059523809516*G0_0_1 - 0.93005952380952*G0_1_0 + 0.680321318342151*G0_1_1;
    A[325] = 0.262655698853613*G0_0_1 + 0.262655698853621*G0_1_0 - 0.46502976190476*G0_1_1;
    A[326] = 0.503782242063491*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 - 2.82031938932979*G0_1_1;
    A[327] = -0.611428020282184*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502644*G0_1_0 + 0.731991291887116*G0_1_1;
    A[328] = 0.680321318342151*G0_0_0 - 0.93005952380951*G0_0_1 - 0.930059523809514*G0_1_0 - 0.516699735449723*G0_1_1;
    A[329] = -0.465029761904761*G0_0_0 + 0.262655698853609*G0_0_1 + 0.262655698853611*G0_1_0;
    A[330] = 7.06156305114633*G0_0_0 + 3.10019841269839*G0_0_1 + 3.10019841269839*G0_1_0 + 7.06156305114637*G0_1_1;
    A[331] = -6.32957175925921*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141091*G0_1_0 - 1.80844907407406*G0_1_1;
    A[332] = 2.75573192239856*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 1.03339947089946*G0_1_1;
    A[333] = -1.80844907407406*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141092*G0_1_0 - 6.32957175925924*G0_1_1;
    A[334] = 1.42092427248677*G0_0_0 + 1.46398258377424*G0_0_1 + 1.46398258377424*G0_1_0 + 1.42092427248676*G0_1_1;
    A[335] = 1.03339947089945*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 2.75573192239858*G0_1_1;
    A[336] = -0.0538228891093484*G0_0_0 - 0.0538228891093485*G0_0_1 - 0.0538228891093457*G0_1_0 - 0.053822889109346*G0_1_1;
    A[337] = -0.0538228891093496*G0_0_0;
    A[338] = 0.107645778218695*G0_1_1;
    A[339] = 1.35633680555554*G0_0_0 + 0.572675540123445*G0_0_1 + 0.572675540123453*G0_1_0;
    A[340] = 0.387524801587307*G0_0_0 + 0.85901331018519*G0_0_1 + 0.859013310185178*G0_1_0 + 1.01187031525573*G0_1_1;
    A[341] = 0.0430583112874709*G0_0_0 + 0.374607308201052*G0_0_1 + 0.374607308201058*G0_1_0 + 1.03339947089946*G0_1_1;
    A[342] = -0.0731991291887092*G0_0_1 - 0.0731991291887109*G0_1_0 - 0.419818535052906*G0_1_1;
    A[343] = 1.35633680555554*G0_0_0 + 0.783661265432094*G0_0_1 + 0.783661265432094*G0_1_0 + 0.21098572530864*G0_1_1;
    A[344] = 0.387524801587298*G0_0_0 - 0.47148850859788*G0_0_1 - 0.471488508597881*G0_1_0 - 0.318631503527332*G0_1_1;
    A[345] = 0.0430583112874713*G0_0_0 - 0.33154899691358*G0_0_1 - 0.331548996913582*G0_1_0 + 0.327243165784829*G0_1_1;
    A[346] = 0.073199129188713*G0_0_1 + 0.0731991291887117*G0_1_0 - 0.273420276675482*G0_1_1;
    A[347] = 0.0495170579805969*G0_0_0 + 0.622192598104045*G0_0_1 + 0.622192598104045*G0_1_0 + 1.1948681382275*G0_1_1;
    A[348] = 0.00430583112875357*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653437*G0_1_0 - 3.81066054894177*G0_1_1;
    A[349] = 0.00430583112873832*G0_0_0 + 2.41341834766311*G0_0_1 + 2.41341834766311*G0_1_0 + 1.01187031525571*G0_1_1;
    A[350] = 0.0495170579806061*G0_0_0 - 0.572675540123445*G0_0_1 - 0.572675540123445*G0_1_0;
    A[351] = -6.32957175925921*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141091*G0_1_0 - 1.80844907407406*G0_1_1;
    A[352] = 9.94646990740734*G0_0_0 + 4.97323495370367*G0_0_1 + 4.97323495370367*G0_1_0 + 8.65472056878302*G0_1_1;
    A[353] = -6.32957175925921*G0_0_0 - 3.2724316578483*G0_0_1 - 3.2724316578483*G0_1_0 - 2.02374063051144*G0_1_1;
    A[354] = -0.387524801587296*G0_0_0 + 2.55120494378305*G0_0_1 + 2.55120494378306*G0_1_0 - 0.387524801587306*G0_1_1;
    A[355] = -0.387524801587308*G0_0_0 - 2.93872974537036*G0_0_1 - 2.93872974537035*G0_1_0 - 5.87745949074072*G0_1_1;
    A[356] = -0.0861166225749424*G0_0_0 - 0.0430583112874729*G0_0_1 - 0.043058311287477*G0_1_0 + 1.42092427248677*G0_1_1;
    A[357] = 0.107645778218694*G0_0_0 + 0.107645778218695*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218693*G0_1_1;
    A[358] = -0.215291556437387*G0_0_0;
    A[359] = 0.107645778218692*G0_1_1;
    A[360] = -2.82031938932979*G0_0_0 - 1.66205081569663*G0_0_1 - 1.66205081569664*G0_1_0;
    A[361] = 0.731991291887121*G0_0_0 - 1.30897266313933*G0_0_1 - 1.30897266313933*G0_1_0 - 3.96136463844796*G0_1_1;
    A[362] = -0.516699735449731*G0_0_0 + 0.41335978835979*G0_0_1 + 0.413359788359793*G0_1_0 + 2.02374063051146*G0_1_1;
    A[363] = -0.262655698853619*G0_0_1 - 0.262655698853619*G0_1_0 - 0.99034115961199*G0_1_1;
    A[364] = -0.667403824955901*G0_0_0 - 0.40474812610229*G0_0_1 - 0.404748126102293*G0_1_0 - 0.142092427248677*G0_1_1;
    A[365] = -0.344466490299823*G0_0_0 + 0.103339947089945*G0_0_1 + 0.103339947089949*G0_1_0 + 0.0344466490299834*G0_1_1;
    A[366] = -0.516699735449729*G0_0_0 - 0.068893298059963*G0_0_1 - 0.0688932980599681*G0_1_0 + 0.0344466490299786*G0_1_1;
    A[367] = 0.262655698853614*G0_0_1 + 0.262655698853618*G0_1_0 - 0.142092427248673*G0_1_1;
    A[368] = -0.465029761904755*G0_0_0 - 0.727685460758368*G0_0_1 - 0.727685460758368*G0_1_0 - 0.990341159611985*G0_1_1;
    A[369] = 0.680321318342141*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215166*G0_1_0 + 2.02374063051145*G0_1_1;
    A[370] = -0.611428020282177*G0_0_0 - 2.65239197530862*G0_0_1 - 2.65239197530862*G0_1_0 - 3.96136463844795*G0_1_1;
    A[371] = 0.503782242063484*G0_0_0 + 1.66205081569663*G0_0_1 + 1.66205081569664*G0_1_0;
    A[372] = 2.75573192239856*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 1.03339947089946*G0_1_1;
    A[373] = -6.32957175925921*G0_0_0 - 3.2724316578483*G0_0_1 - 3.2724316578483*G0_1_0 - 2.02374063051144*G0_1_1;
    A[374] = 7.06156305114634*G0_0_0 + 3.96136463844795*G0_0_1 + 3.96136463844795*G0_1_0 + 7.92272927689591*G0_1_1;
    A[375] = 1.42092427248677*G0_0_0 - 0.0430583112874708*G0_0_1 - 0.0430583112874745*G0_1_0 - 0.086116622574956*G0_1_1;
    A[376] = -1.80844907407407*G0_0_0 + 1.24869102733686*G0_0_1 + 1.24869102733685*G0_1_0 - 2.02374063051146*G0_1_1;
    A[377] = 1.03339947089946*G0_0_0 - 0.344466490299824*G0_0_1 - 0.344466490299825*G0_1_0 + 1.03339947089947*G0_1_1;
    A[378] = -0.0538228891093463*G0_0_0 - 0.0538228891093464*G0_0_1 - 0.0538228891093459*G0_1_0 - 0.0538228891093456*G0_1_1;
    A[379] = 0.107645778218696*G0_0_0;
    A[380] = -0.0538228891093447*G0_1_1;
    A[381] = -0.419818535052911*G0_0_0 - 0.0731991291887099*G0_0_1 - 0.0731991291887145*G0_1_0;
    A[382] = 1.03339947089947*G0_0_0 + 0.374607308201053*G0_0_1 + 0.374607308201062*G0_1_0 + 0.0430583112874783*G0_1_1;
    A[383] = 1.01187031525572*G0_0_0 + 0.859013310185178*G0_0_1 + 0.859013310185172*G0_1_0 + 0.387524801587298*G0_1_1;
    A[384] = 0.572675540123456*G0_0_1 + 0.572675540123462*G0_1_0 + 1.35633680555555*G0_1_1;
    A[385] = 1.19486813822751*G0_0_0 + 0.622192598104048*G0_0_1 + 0.622192598104048*G0_1_0 + 0.0495170579805897*G0_1_1;
    A[386] = -3.81066054894178*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653438*G0_1_0 + 0.00430583112875677*G0_1_1;
    A[387] = 1.01187031525573*G0_0_0 + 2.41341834766313*G0_0_1 + 2.41341834766314*G0_1_0 + 0.00430583112874544*G0_1_1;
    A[388] = -0.572675540123456*G0_0_1 - 0.572675540123462*G0_1_0 + 0.0495170579805963*G0_1_1;
    A[389] = 0.210985725308639*G0_0_0 + 0.783661265432096*G0_0_1 + 0.783661265432093*G0_1_0 + 1.35633680555555*G0_1_1;
    A[390] = -0.318631503527334*G0_0_0 - 0.471488508597882*G0_0_1 - 0.471488508597882*G0_1_0 + 0.387524801587306*G0_1_1;
    A[391] = 0.32724316578483*G0_0_0 - 0.331548996913577*G0_0_1 - 0.331548996913579*G0_1_0 + 0.0430583112874745*G0_1_1;
    A[392] = -0.273420276675487*G0_0_0 + 0.0731991291887092*G0_0_1 + 0.0731991291887106*G0_1_0;
    A[393] = -1.80844907407406*G0_0_0 - 3.05714010141092*G0_0_1 - 3.05714010141091*G0_1_0 - 6.32957175925924*G0_1_1;
    A[394] = -0.387524801587296*G0_0_0 + 2.55120494378306*G0_0_1 + 2.55120494378305*G0_1_0 - 0.387524801587306*G0_1_1;
    A[395] = 1.42092427248677*G0_0_0 - 0.0430583112874745*G0_0_1 - 0.043058311287471*G0_1_0 - 0.0861166225749559*G0_1_1;
    A[396] = 8.65472056878303*G0_0_0 + 4.97323495370368*G0_0_1 + 4.97323495370368*G0_1_0 + 9.94646990740738*G0_1_1;
    A[397] = -5.87745949074072*G0_0_0 - 2.93872974537036*G0_0_1 - 2.93872974537036*G0_1_0 - 0.387524801587293*G0_1_1;
    A[398] = -2.02374063051144*G0_0_0 - 3.27243165784831*G0_0_1 - 3.27243165784831*G0_1_0 - 6.32957175925924*G0_1_1;
    A[399] = 0.107645778218695*G0_0_0 + 0.107645778218695*G0_0_1 + 0.107645778218694*G0_1_0 + 0.107645778218695*G0_1_1;
    A[400] = -0.0538228891093465*G0_0_0;
    A[401] = -0.0538228891093471*G0_1_1;
    A[402] = 1.19486813822751*G0_0_0 + 0.572675540123456*G0_0_1 + 0.572675540123455*G0_1_0;
    A[403] = -3.81066054894178*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525572*G0_1_1;
    A[404] = 1.01187031525573*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 - 3.81066054894177*G0_1_1;
    A[405] = 0.572675540123454*G0_0_1 + 0.572675540123451*G0_1_0 + 1.1948681382275*G0_1_1;
    A[406] = -0.419818535052911*G0_0_0 - 0.346619405864199*G0_0_1 - 0.346619405864192*G0_1_0 - 0.273420276675483*G0_1_1;
    A[407] = 1.03339947089947*G0_0_0 + 0.658792162698414*G0_0_1 + 0.658792162698407*G0_1_0 + 0.327243165784827*G0_1_1;
    A[408] = 1.01187031525572*G0_0_0 + 0.15285700507054*G0_0_1 + 0.15285700507055*G0_1_0 - 0.318631503527332*G0_1_1;
    A[409] = -0.572675540123448*G0_0_1 - 0.572675540123452*G0_1_0 + 0.210985725308638*G0_1_1;
    A[410] = -0.273420276675483*G0_0_0 - 0.346619405864195*G0_0_1 - 0.346619405864192*G0_1_0 - 0.419818535052904*G0_1_1;
    A[411] = 0.327243165784828*G0_0_0 + 0.658792162698409*G0_0_1 + 0.658792162698405*G0_1_0 + 1.03339947089947*G0_1_1;
    A[412] = -0.318631503527333*G0_0_0 + 0.152857005070543*G0_0_1 + 0.152857005070552*G0_1_0 + 1.01187031525573*G0_1_1;
    A[413] = 0.210985725308642*G0_0_0 - 0.572675540123457*G0_0_1 - 0.572675540123459*G0_1_0;
    A[414] = 1.42092427248677*G0_0_0 + 1.46398258377424*G0_0_1 + 1.46398258377424*G0_1_0 + 1.42092427248676*G0_1_1;
    A[415] = -0.387524801587308*G0_0_0 - 2.93872974537035*G0_0_1 - 2.93872974537036*G0_1_0 - 5.87745949074072*G0_1_1;
    A[416] = -1.80844907407407*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733686*G0_1_0 - 2.02374063051146*G0_1_1;
    A[417] = -5.87745949074072*G0_0_0 - 2.93872974537036*G0_0_1 - 2.93872974537036*G0_1_0 - 0.387524801587294*G0_1_1;
    A[418] = 8.65472056878303*G0_0_0 + 3.68148561507935*G0_0_1 + 3.68148561507935*G0_1_0 + 8.65472056878304*G0_1_1;
    A[419] = -2.02374063051145*G0_0_0 + 1.24869102733686*G0_0_1 + 1.24869102733686*G0_1_0 - 1.80844907407407*G0_1_1;
    A[420] = 0.107645778218692*G0_0_0 + 0.107645778218692*G0_0_1 + 0.107645778218692*G0_1_0 + 0.107645778218692*G0_1_1;
    A[421] = 0.107645778218693*G0_0_0;
    A[422] = -0.21529155643739*G0_1_1;
    A[423] = -0.990341159611985*G0_0_0 - 0.262655698853615*G0_0_1 - 0.262655698853612*G0_1_0;
    A[424] = 2.02374063051145*G0_0_0 + 0.413359788359789*G0_0_1 + 0.413359788359785*G0_1_0 - 0.516699735449728*G0_1_1;
    A[425] = -3.96136463844795*G0_0_0 - 1.30897266313932*G0_0_1 - 1.30897266313932*G0_1_0 + 0.731991291887121*G0_1_1;
    A[426] = -1.66205081569664*G0_0_1 - 1.66205081569664*G0_1_0 - 2.82031938932979*G0_1_1;
    A[427] = -0.990341159611981*G0_0_0 - 0.727685460758364*G0_0_1 - 0.727685460758374*G0_1_0 - 0.465029761904753*G0_1_1;
    A[428] = 2.02374063051144*G0_0_0 + 1.61038084215165*G0_0_1 + 1.61038084215166*G0_1_0 + 0.680321318342141*G0_1_1;
    A[429] = -3.96136463844795*G0_0_0 - 2.65239197530862*G0_0_1 - 2.65239197530864*G0_1_0 - 0.611428020282183*G0_1_1;
    A[430] = 1.66205081569664*G0_0_1 + 1.66205081569664*G0_1_0 + 0.503782242063493*G0_1_1;
    A[431] = -0.142092427248672*G0_0_0 - 0.404748126102292*G0_0_1 - 0.404748126102289*G0_1_0 - 0.667403824955909*G0_1_1;
    A[432] = 0.0344466490299804*G0_0_0 + 0.103339947089946*G0_0_1 + 0.103339947089947*G0_1_0 - 0.344466490299824*G0_1_1;
    A[433] = 0.0344466490299806*G0_0_0 - 0.0688932980599646*G0_0_1 - 0.0688932980599665*G0_1_0 - 0.516699735449737*G0_1_1;
    A[434] = -0.142092427248674*G0_0_0 + 0.262655698853617*G0_0_1 + 0.262655698853618*G0_1_0;
    A[435] = 1.03339947089945*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 2.75573192239858*G0_1_1;
    A[436] = -0.0861166225749425*G0_0_0 - 0.043058311287477*G0_0_1 - 0.043058311287473*G0_1_0 + 1.42092427248677*G0_1_1;
    A[437] = 1.03339947089946*G0_0_0 - 0.344466490299825*G0_0_1 - 0.344466490299824*G0_1_0 + 1.03339947089947*G0_1_1;
    A[438] = -2.02374063051144*G0_0_0 - 3.27243165784831*G0_0_1 - 3.27243165784831*G0_1_0 - 6.32957175925924*G0_1_1;
    A[439] = -2.02374063051145*G0_0_0 + 1.24869102733686*G0_0_1 + 1.24869102733686*G0_1_0 - 1.80844907407407*G0_1_1;
    A[440] = 7.9227292768959*G0_0_0 + 3.96136463844795*G0_0_1 + 3.96136463844795*G0_1_0 + 7.06156305114636*G0_1_1;
}

/// Constructor
poisson2d_5_cell_integral_1_otherwise::poisson2d_5_cell_integral_1_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson2d_5_cell_integral_1_otherwise::~poisson2d_5_cell_integral_1_otherwise()
{
    // Do nothing
}

/// Tabulate the tensor for the contribution from a local cell
void poisson2d_5_cell_integral_1_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    21
    // Number of operations (multiply-add pairs) for tensor contraction: 430
    // Total number of operations (multiply-add pairs):                  454
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    
    // Compute element tensor
    A[0] = 0.00138945256132761*G0_0 + 0.000123877456776765*G0_1 + 0.000123877456776765*G0_2 + 0.000363647010782439*G0_3 + 0.000207201813104596*G0_4 + 0.000207201813104597*G0_5 + 0.000363647010782438*G0_6 + 0.00118136348605102*G0_7 - 0.000958243145743178*G0_8 + 0.000462681126743636*G0_9 - 2.29644326866568e-05*G0_10 + 0.00118136348605102*G0_11 - 0.000958243145743178*G0_12 + 0.000462681126743638*G0_13 - 2.29644326866555e-05*G0_14 + 0.000892481361231364*G0_15 - 0.000974683591871135*G0_16 + 0.000879433388113953*G0_17 - 0.000974683591871131*G0_18 + 0.000649789061247419*G0_19 + 0.000879433388113951*G0_20;
    A[1] = 0.000123877456776765*G0_0 + 0.00138945256132761*G0_1 + 0.000123877456776766*G0_2 + 0.00118136348605102*G0_3 - 0.000958243145743182*G0_4 + 0.000462681126743644*G0_5 - 2.2964432686658e-05*G0_6 + 0.000363647010782441*G0_7 + 0.000207201813104595*G0_8 + 0.000207201813104599*G0_9 + 0.000363647010782438*G0_10 - 2.29644326866539e-05*G0_11 + 0.000462681126743647*G0_12 - 0.000958243145743182*G0_13 + 0.00118136348605103*G0_14 + 0.000879433388113976*G0_15 - 0.000974683591871122*G0_16 + 0.00089248136123139*G0_17 + 0.000649789061247416*G0_18 - 0.000974683591871126*G0_19 + 0.00087943338811397*G0_20;
    A[2] = 0.000123877456776765*G0_0 + 0.000123877456776766*G0_1 + 0.00138945256132761*G0_2 - 2.29644326866539e-05*G0_3 + 0.000462681126743638*G0_4 - 0.000958243145743175*G0_5 + 0.00118136348605102*G0_6 - 2.29644326866545e-05*G0_7 + 0.000462681126743639*G0_8 - 0.000958243145743178*G0_9 + 0.00118136348605102*G0_10 + 0.000363647010782442*G0_11 + 0.0002072018131046*G0_12 + 0.000207201813104598*G0_13 + 0.00036364701078244*G0_14 + 0.000879433388113975*G0_15 + 0.000649789061247419*G0_16 + 0.00087943338811397*G0_17 - 0.000974683591871126*G0_18 - 0.00097468359187113*G0_19 + 0.000892481361231379*G0_20;
    A[3] = 0.000363647010782439*G0_0 + 0.00118136348605102*G0_1 - 2.29644326866539e-05*G0_2 + 0.0147050657033301*G0_3 - 0.00958373625474353*G0_4 + 0.00770482812583532*G0_5 - 0.00396984582097443*G0_6 - 0.000411011153198678*G0_7 - 0.00144832501603339*G0_8 - 4.56679059109682e-05*G0_9 - 0.00248237688558877*G0_10 - 0.00248237688558878*G0_11 + 0.00576068013134009*G0_12 - 0.00735253285166507*G0_13 + 0.00735253285166507*G0_14 + 0.00078287838704508*G0_15 - 0.00381653213684479*G0_16 + 0.0102426588971732*G0_17 - 0.00137003717732889*G0_18 + 9.78597983806315e-05*G0_19 - 0.00280531422024486*G0_20;
    A[4] = 0.000207201813104596*G0_0 - 0.000958243145743182*G0_1 + 0.000462681126743638*G0_2 - 0.00958373625474353*G0_3 + 0.0220771705146713*G0_4 - 0.0134785562302928*G0_5 + 0.00770482812583534*G0_6 - 0.00144832501603339*G0_7 + 0.00281836219336229*G0_8 - 0.00135698920421147*G0_9 + 0.00576068013134005*G0_10 - 4.56679059109496e-05*G0_11 - 0.00135698920421148*G0_12 + 0.0029488419245365*G0_13 - 0.00735253285166506*G0_14 + 0.00313151354818033*G0_15 - 0.00548014870931554*G0_16 - 0.00143527704291599*G0_17 - 0.000587158790283811*G0_18 + 0.00528442911255429*G0_19 + 0.00508870951579302*G0_20;
    A[5] = 0.000207201813104597*G0_0 + 0.000462681126743644*G0_1 - 0.000958243145743175*G0_2 + 0.00770482812583532*G0_3 - 0.0134785562302928*G0_4 + 0.0220771705146713*G0_5 - 0.00958373625474352*G0_6 - 4.56679059109687e-05*G0_7 - 0.00135698920421146*G0_8 + 0.00294884192453647*G0_9 - 0.00735253285166504*G0_10 - 0.0014483250160334*G0_11 + 0.00281836219336231*G0_12 - 0.00135698920421148*G0_13 + 0.00576068013134005*G0_14 + 0.00313151354818033*G0_15 - 0.000587158790283832*G0_16 + 0.00508870951579303*G0_17 - 0.00548014870931556*G0_18 + 0.0052844291125543*G0_19 - 0.00143527704291597*G0_20;
    A[6] = 0.000363647010782438*G0_0 - 2.29644326866579e-05*G0_1 + 0.00118136348605102*G0_2 - 0.00396984582097443*G0_3 + 0.00770482812583534*G0_4 - 0.00958373625474352*G0_5 + 0.0147050657033301*G0_6 - 0.00248237688558878*G0_7 + 0.00576068013134005*G0_8 - 0.00735253285166505*G0_9 + 0.00735253285166505*G0_10 - 0.000411011153198661*G0_11 - 0.0014483250160334*G0_12 - 4.56679059109575e-05*G0_13 - 0.00248237688558878*G0_14 + 0.000782878387045073*G0_15 - 0.00137003717732888*G0_16 - 0.00280531422024488*G0_17 - 0.00381653213684476*G0_18 + 9.7859798380642e-05*G0_19 + 0.0102426588971731*G0_20;
    A[7] = 0.00118136348605102*G0_0 + 0.000363647010782441*G0_1 - 2.29644326866545e-05*G0_2 - 0.000411011153198678*G0_3 - 0.00144832501603339*G0_4 - 4.56679059109689e-05*G0_5 - 0.00248237688558878*G0_6 + 0.0147050657033301*G0_7 - 0.00958373625474352*G0_8 + 0.00770482812583533*G0_9 - 0.00396984582097444*G0_10 + 0.00735253285166505*G0_11 - 0.00735253285166505*G0_12 + 0.00576068013134006*G0_13 - 0.00248237688558879*G0_14 + 0.0102426588971732*G0_15 - 0.00381653213684478*G0_16 + 0.000782878387045078*G0_17 + 9.78597983806186e-05*G0_18 - 0.00137003717732889*G0_19 - 0.00280531422024487*G0_20;
    A[8] = -0.000958243145743178*G0_0 + 0.000207201813104595*G0_1 + 0.000462681126743639*G0_2 - 0.00144832501603339*G0_3 + 0.00281836219336229*G0_4 - 0.00135698920421147*G0_5 + 0.00576068013134005*G0_6 - 0.00958373625474352*G0_7 + 0.0220771705146712*G0_8 - 0.0134785562302928*G0_9 + 0.00770482812583534*G0_10 - 0.00735253285166504*G0_11 + 0.00294884192453647*G0_12 - 0.00135698920421148*G0_13 - 4.56679059109633e-05*G0_14 - 0.00143527704291601*G0_15 - 0.00548014870931555*G0_16 + 0.0031315135481803*G0_17 + 0.0052844291125543*G0_18 - 0.000587158790283819*G0_19 + 0.00508870951579298*G0_20;
    A[9] = 0.000462681126743636*G0_0 + 0.0002072018131046*G0_1 - 0.000958243145743178*G0_2 - 4.56679059109682e-05*G0_3 - 0.00135698920421147*G0_4 + 0.00294884192453647*G0_5 - 0.00735253285166505*G0_6 + 0.00770482812583533*G0_7 - 0.0134785562302928*G0_8 + 0.0220771705146713*G0_9 - 0.00958373625474355*G0_10 + 0.00576068013134005*G0_11 - 0.00135698920421147*G0_12 + 0.0028183621933623*G0_13 - 0.0014483250160334*G0_14 + 0.00508870951579306*G0_15 - 0.000587158790283817*G0_16 + 0.00313151354818034*G0_17 + 0.00528442911255427*G0_18 - 0.00548014870931555*G0_19 - 0.00143527704291596*G0_20;
    A[10] = -2.29644326866567e-05*G0_0 + 0.000363647010782438*G0_1 + 0.00118136348605102*G0_2 - 0.00248237688558877*G0_3 + 0.00576068013134005*G0_4 - 0.00735253285166504*G0_5 + 0.00735253285166505*G0_6 - 0.00396984582097444*G0_7 + 0.00770482812583534*G0_8 - 0.00958373625474355*G0_9 + 0.0147050657033301*G0_10 - 0.00248237688558878*G0_11 - 4.56679059109584e-05*G0_12 - 0.0014483250160334*G0_13 - 0.000411011153198662*G0_14 - 0.0028053142202449*G0_15 - 0.00137003717732888*G0_16 + 0.000782878387045079*G0_17 + 9.78597983806383e-05*G0_18 - 0.00381653213684477*G0_19 + 0.0102426588971731*G0_20;
    A[11] = 0.00118136348605102*G0_0 - 2.29644326866539e-05*G0_1 + 0.000363647010782442*G0_2 - 0.00248237688558878*G0_3 - 4.56679059109497e-05*G0_4 - 0.0014483250160334*G0_5 - 0.000411011153198661*G0_6 + 0.00735253285166505*G0_7 - 0.00735253285166504*G0_8 + 0.00576068013134005*G0_9 - 0.00248237688558878*G0_10 + 0.0147050657033301*G0_11 - 0.00958373625474354*G0_12 + 0.00770482812583536*G0_13 - 0.00396984582097444*G0_14 + 0.0102426588971732*G0_15 + 9.7859798380627e-05*G0_16 - 0.00280531422024484*G0_17 - 0.00381653213684478*G0_18 - 0.00137003717732887*G0_19 + 0.000782878387045111*G0_20;
    A[12] = -0.000958243145743178*G0_0 + 0.000462681126743647*G0_1 + 0.0002072018131046*G0_2 + 0.00576068013134009*G0_3 - 0.00135698920421148*G0_4 + 0.00281836219336231*G0_5 - 0.0014483250160334*G0_6 - 0.00735253285166505*G0_7 + 0.00294884192453647*G0_8 - 0.00135698920421147*G0_9 - 4.56679059109584e-05*G0_10 - 0.00958373625474354*G0_11 + 0.0220771705146713*G0_12 - 0.0134785562302928*G0_13 + 0.00770482812583538*G0_14 - 0.00143527704291595*G0_15 + 0.00528442911255429*G0_16 + 0.00508870951579309*G0_17 - 0.00548014870931556*G0_18 - 0.000587158790283808*G0_19 + 0.00313151354818035*G0_20;
    A[13] = 0.000462681126743638*G0_0 - 0.000958243145743182*G0_1 + 0.000207201813104598*G0_2 - 0.00735253285166507*G0_3 + 0.0029488419245365*G0_4 - 0.00135698920421148*G0_5 - 4.5667905910958e-05*G0_6 + 0.00576068013134007*G0_7 - 0.00135698920421148*G0_8 + 0.0028183621933623*G0_9 - 0.0014483250160334*G0_10 + 0.00770482812583536*G0_11 - 0.0134785562302928*G0_12 + 0.0220771705146713*G0_13 - 0.00958373625474357*G0_14 + 0.00508870951579306*G0_15 + 0.0052844291125543*G0_16 - 0.00143527704291599*G0_17 - 0.000587158790283811*G0_18 - 0.00548014870931556*G0_19 + 0.00313151354818033*G0_20;
    A[14] = -2.29644326866554e-05*G0_0 + 0.00118136348605103*G0_1 + 0.00036364701078244*G0_2 + 0.00735253285166507*G0_3 - 0.00735253285166506*G0_4 + 0.00576068013134005*G0_5 - 0.00248237688558878*G0_6 - 0.00248237688558879*G0_7 - 4.56679059109632e-05*G0_8 - 0.0014483250160334*G0_9 - 0.000411011153198661*G0_10 - 0.00396984582097444*G0_11 + 0.00770482812583538*G0_12 - 0.00958373625474357*G0_13 + 0.0147050657033301*G0_14 - 0.00280531422024488*G0_15 + 9.7859798380624e-05*G0_16 + 0.0102426588971732*G0_17 - 0.00137003717732889*G0_18 - 0.00381653213684476*G0_19 + 0.000782878387045086*G0_20;
    A[15] = 0.000892481361231365*G0_0 + 0.000879433388113976*G0_1 + 0.000879433388113975*G0_2 + 0.00078287838704508*G0_3 + 0.00313151354818033*G0_4 + 0.00313151354818033*G0_5 + 0.000782878387045073*G0_6 + 0.0102426588971732*G0_7 - 0.00143527704291601*G0_8 + 0.00508870951579306*G0_9 - 0.0028053142202449*G0_10 + 0.0102426588971732*G0_11 - 0.00143527704291595*G0_12 + 0.00508870951579306*G0_13 - 0.00280531422024487*G0_14 + 0.0704590548340574*G0_15 - 0.0156575677409016*G0_16 + 0.0117431758056762*G0_17 - 0.0156575677409016*G0_18 + 0.0039143919352254*G0_19 + 0.0117431758056762*G0_20;
    A[16] = -0.000974683591871135*G0_0 - 0.000974683591871122*G0_1 + 0.000649789061247419*G0_2 - 0.00381653213684479*G0_3 - 0.00548014870931554*G0_4 - 0.000587158790283832*G0_5 - 0.00137003717732888*G0_6 - 0.00381653213684478*G0_7 - 0.00548014870931555*G0_8 - 0.000587158790283815*G0_9 - 0.00137003717732888*G0_10 + 9.78597983806265e-05*G0_11 + 0.00528442911255429*G0_12 + 0.0052844291125543*G0_13 + 9.78597983806244e-05*G0_14 - 0.0156575677409016*G0_15 + 0.0763306427368953*G0_16 - 0.0156575677409016*G0_17 - 0.0117431758056762*G0_18 - 0.0117431758056762*G0_19 + 0.0039143919352254*G0_20;
    A[17] = 0.000879433388113953*G0_0 + 0.00089248136123139*G0_1 + 0.00087943338811397*G0_2 + 0.0102426588971732*G0_3 - 0.00143527704291599*G0_4 + 0.00508870951579303*G0_5 - 0.00280531422024488*G0_6 + 0.000782878387045078*G0_7 + 0.0031315135481803*G0_8 + 0.00313151354818034*G0_9 + 0.000782878387045079*G0_10 - 0.00280531422024484*G0_11 + 0.00508870951579309*G0_12 - 0.00143527704291599*G0_13 + 0.0102426588971732*G0_14 + 0.0117431758056762*G0_15 - 0.0156575677409016*G0_16 + 0.0704590548340572*G0_17 + 0.00391439193522537*G0_18 - 0.0156575677409016*G0_19 + 0.0117431758056762*G0_20;
    A[18] = -0.000974683591871131*G0_0 + 0.000649789061247416*G0_1 - 0.000974683591871126*G0_2 - 0.00137003717732889*G0_3 - 0.000587158790283811*G0_4 - 0.00548014870931556*G0_5 - 0.00381653213684476*G0_6 + 9.78597983806186e-05*G0_7 + 0.00528442911255429*G0_8 + 0.00528442911255427*G0_9 + 9.78597983806388e-05*G0_10 - 0.00381653213684478*G0_11 - 0.00548014870931557*G0_12 - 0.00058715879028381*G0_13 - 0.00137003717732889*G0_14 - 0.0156575677409016*G0_15 - 0.0117431758056762*G0_16 + 0.00391439193522537*G0_17 + 0.0763306427368953*G0_18 - 0.0117431758056762*G0_19 - 0.0156575677409016*G0_20;
    A[19] = 0.000649789061247419*G0_0 - 0.000974683591871126*G0_1 - 0.00097468359187113*G0_2 + 9.78597983806303e-05*G0_3 + 0.00528442911255429*G0_4 + 0.0052844291125543*G0_5 + 9.78597983806421e-05*G0_6 - 0.00137003717732889*G0_7 - 0.000587158790283818*G0_8 - 0.00548014870931555*G0_9 - 0.00381653213684477*G0_10 - 0.00137003717732887*G0_11 - 0.000587158790283809*G0_12 - 0.00548014870931556*G0_13 - 0.00381653213684476*G0_14 + 0.00391439193522541*G0_15 - 0.0117431758056762*G0_16 - 0.0156575677409016*G0_17 - 0.0117431758056762*G0_18 + 0.0763306427368953*G0_19 - 0.0156575677409016*G0_20;
    A[20] = 0.000879433388113951*G0_0 + 0.00087943338811397*G0_1 + 0.000892481361231379*G0_2 - 0.00280531422024486*G0_3 + 0.00508870951579302*G0_4 - 0.00143527704291597*G0_5 + 0.0102426588971731*G0_6 - 0.00280531422024487*G0_7 + 0.00508870951579298*G0_8 - 0.00143527704291596*G0_9 + 0.0102426588971731*G0_10 + 0.000782878387045111*G0_11 + 0.00313151354818035*G0_12 + 0.00313151354818033*G0_13 + 0.000782878387045086*G0_14 + 0.0117431758056762*G0_15 + 0.0039143919352254*G0_16 + 0.0117431758056762*G0_17 - 0.0156575677409016*G0_18 - 0.0156575677409017*G0_19 + 0.0704590548340572*G0_20;
}

/// Constructor
poisson2d_5_form_0::poisson2d_5_form_0() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson2d_5_form_0::~poisson2d_5_form_0()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson2d_5_form_0::signature() const
{
    return "6a054933ddf3a65a553ded74dcd366870588bf106c1c4fb3d91584c0000fc3fcb7b234179630ea42112ce6c1a8175b19b814a020a4b1883d27746a239b7a5e17";
}

/// Return the rank of the global tensor (r)
std::size_t poisson2d_5_form_0::rank() const
{
    return 2;
}

/// Return the number of coefficients (n)
std::size_t poisson2d_5_form_0::num_coefficients() const
{
    return 0;
}

/// Return the number of cell domains
std::size_t poisson2d_5_form_0::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson2d_5_form_0::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson2d_5_form_0::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson2d_5_form_0::num_point_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson2d_5_form_0::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson2d_5_form_0::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson2d_5_form_0::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson2d_5_form_0::has_point_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson2d_5_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson2d_5_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson2d_5_form_0::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson2d_5_form_0::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson2d_5_form_0::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson2d_5_form_0::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson2d_5_form_0::create_default_cell_integral() const
{
    return new poisson2d_5_cell_integral_0_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson2d_5_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson2d_5_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson2d_5_form_0::create_default_point_integral() const
{
    return 0;
}


/// Constructor
poisson2d_5_form_1::poisson2d_5_form_1() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson2d_5_form_1::~poisson2d_5_form_1()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson2d_5_form_1::signature() const
{
    return "b1a099be42c9c08580a325df4711f42f1da8ec8de4243336df622cc4a21d9591b9fb4f9a73677e2d648766c283e0f89c8ca7edc17fedb44e8dd6883292e185ab";
}

/// Return the rank of the global tensor (r)
std::size_t poisson2d_5_form_1::rank() const
{
    return 1;
}

/// Return the number of coefficients (n)
std::size_t poisson2d_5_form_1::num_coefficients() const
{
    return 1;
}

/// Return the number of cell domains
std::size_t poisson2d_5_form_1::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson2d_5_form_1::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson2d_5_form_1::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson2d_5_form_1::num_point_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson2d_5_form_1::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson2d_5_form_1::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson2d_5_form_1::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson2d_5_form_1::has_point_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson2d_5_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson2d_5_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson2d_5_form_1::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson2d_5_form_1::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson2d_5_form_1::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson2d_5_form_1::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson2d_5_form_1::create_default_cell_integral() const
{
    return new poisson2d_5_cell_integral_1_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson2d_5_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson2d_5_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson2d_5_form_1::create_default_point_integral() const
{
    return 0;
}


