/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.jst.Caps;
import com.fluendo.jst.CapsListener;
import com.fluendo.jst.Element;
import com.fluendo.jst.ElementFactory;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.jst.PadListener;
import com.fluendo.jst.Pipeline;
import com.fluendo.jst.Query;
import com.fluendo.player.Configure;
import com.fluendo.player.Cortado;
import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Vector;

public class CortadoPipeline
extends Pipeline
implements PadListener,
CapsListener {
    private String url;
    private String userId;
    private String password;
    private boolean enableAudio = true;
    private boolean enableVideo = true;
    private boolean keepAspect;
    private boolean ignoreAspect;
    private int enableKate;
    private Component component;
    private int bufferSize = -1;
    private int bufferLow = -1;
    private int bufferHigh = -1;
    private URL documentBase = null;
    private Cortado application;
    private Element httpsrc;
    private Element buffer;
    private Element demux;
    private Element videodec;
    private Element audiodec;
    private Element videosink;
    private Element audiosink;
    private Element v_queue;
    private Element v_queue2;
    private Element a_queue = null;
    private Element overlay;
    private Pad asinkpad;
    private Pad ovsinkpad;
    private Pad oksinkpad;
    private Pad apad;
    private Pad vpad;
    private Vector katedec = new Vector();
    private Vector k_queue = new Vector();
    private Element kselector = null;
    public boolean usingJavaX = false;

    private boolean setupVideoDec(String string) {
        this.videodec = ElementFactory.makeByName(string, "videodec");
        if (this.videodec == null) {
            this.noSuchElement(string);
            return false;
        }
        this.add(this.videodec);
        return true;
    }

    public void padAdded(Pad pad) {
        Caps caps = pad.getCaps();
        if (caps == null) {
            Debug.log(3, "pad added without caps: " + pad);
            return;
        }
        Debug.log(3, "pad added " + pad);
        String string = caps.getMime();
        if (this.enableAudio && string.equals("audio/x-vorbis")) {
            if (this.a_queue != null) {
                Debug.log(3, "More than one audio stream detected, ignoring all except first one");
                return;
            }
            this.a_queue = ElementFactory.makeByName("queue", "a_queue");
            if (this.a_queue == null) {
                this.noSuchElement("queue");
                return;
            }
            if (this.v_queue != null) {
                this.v_queue.setProperty("leaky", "2");
            }
            this.audiodec = ElementFactory.makeByName("vorbisdec", "audiodec");
            if (this.audiodec == null) {
                this.noSuchElement("vorbisdec");
                return;
            }
            this.a_queue.setProperty("maxBuffers", "100");
            this.add(this.a_queue);
            this.add(this.audiodec);
            pad.link(this.a_queue.getPad("sink"));
            this.a_queue.getPad("src").link(this.audiodec.getPad("sink"));
            if (!this.audiodec.getPad("src").link(this.asinkpad)) {
                this.postMessage(Message.newError(this, "audiosink already linked"));
                return;
            }
            this.apad = pad;
            this.audiodec.setState(2);
            this.a_queue.setState(2);
        } else if (this.enableVideo && string.equals("video/x-theora")) {
            this.v_queue = ElementFactory.makeByName("queue", "v_queue");
            this.v_queue2 = ElementFactory.makeByName("queue", "v_queue2");
            if (this.v_queue == null) {
                this.noSuchElement("queue");
                return;
            }
            if (!this.setupVideoDec("theoradec")) {
                return;
            }
            if (this.a_queue != null) {
                this.v_queue.setProperty("leaky", "2");
            }
            this.v_queue.setProperty("maxBuffers", "175");
            this.v_queue2.setProperty("maxBuffers", "1");
            this.add(this.v_queue);
            this.add(this.v_queue2);
            pad.link(this.v_queue.getPad("sink"));
            this.v_queue.getPad("src").link(this.videodec.getPad("sink"));
            this.videodec.getPad("src").link(this.v_queue2.getPad("sink"));
            if (!this.v_queue2.getPad("src").link(this.ovsinkpad)) {
                this.postMessage(Message.newError(this, "videosink already linked"));
                return;
            }
            this.vpad = pad;
            this.videodec.setState(2);
            this.v_queue.setState(2);
            this.v_queue2.setState(2);
        } else if (this.enableVideo && string.equals("image/jpeg")) {
            if (!this.setupVideoDec("jpegdec")) {
                return;
            }
            this.videodec.setProperty("component", this.component);
            pad.link(this.videodec.getPad("sink"));
            if (!this.videodec.getPad("src").link(this.ovsinkpad)) {
                this.postMessage(Message.newError(this, "videosink already linked"));
                return;
            }
            this.videodec.setState(2);
        } else if (this.enableVideo && string.equals("video/x-smoke")) {
            if (!this.setupVideoDec("smokedec")) {
                return;
            }
            this.videodec.setProperty("component", this.component);
            pad.link(this.videodec.getPad("sink"));
            if (!this.videodec.getPad("src").link(this.ovsinkpad)) {
                this.postMessage(Message.newError(this, "videosink already linked"));
                return;
            }
            this.vpad = pad;
            this.videodec.setState(2);
        } else if (this.enableVideo && string.equals("application/x-kate")) {
            int n = this.katedec.size();
            Debug.debug("Found Kate stream, setting up pipeline branch");
            Element element = ElementFactory.makeByName("queue", "k_queue" + n);
            if (element == null) {
                this.noSuchElement("queue");
                return;
            }
            Element element2 = ElementFactory.makeByName("katedec", "katedec" + n);
            if (element2 == null) {
                this.noSuchElement("katedec");
                return;
            }
            if (this.kselector == null) {
                Debug.debug("No Kate selector yet, creating one");
                this.ovsinkpad.unlink();
                this.videodec.getPad("src").unlink();
                this.overlay = ElementFactory.makeByName("kateoverlay", "overlay");
                if (this.overlay == null) {
                    this.noSuchElement("overlay");
                    return;
                }
                this.ovsinkpad = this.overlay.getPad("videosink");
                this.oksinkpad = this.overlay.getPad("katesink");
                if (!this.videodec.getPad("src").link(this.ovsinkpad)) {
                    this.postMessage(Message.newError(this, "Failed linking video decoder to overlay"));
                    return;
                }
                this.add(this.overlay);
                this.overlay.setProperty("component", this.component);
                this.overlay.getPad("videosrc").link(this.videosink.getPad("sink"));
                this.kselector = ElementFactory.makeByName("selector", "selector");
                if (this.kselector == null) {
                    this.noSuchElement("selector");
                    return;
                }
                this.add(this.kselector);
                if (!this.kselector.getPad("src").link(this.oksinkpad)) {
                    this.postMessage(Message.newError(this, "Failed linking Kate selector to overlay"));
                    return;
                }
                this.kselector.setState(2);
            }
            Element element3 = this.kselector;
            this.add(element);
            this.add(element2);
            element3.getPad("sink");
            if (!pad.link(element.getPad("sink"))) {
                this.postMessage(Message.newError(this, "Failed to link new Kate stream to queue"));
                return;
            }
            if (!element.getPad("src").link(element2.getPad("sink"))) {
                this.postMessage(Message.newError(this, "Failed to link new Kate queue to decoder"));
                return;
            }
            Pad pad2 = this.kselector.requestSinkPad(element2.getPad("src"));
            if (!element2.getPad("src").link(pad2)) {
                this.postMessage(Message.newError(this, "kate sink already linked"));
                return;
            }
            element2.setState(2);
            element.setState(2);
            this.katedec.addElement(element2);
            this.k_queue.addElement(element);
            if (this.enableKate == this.katedec.size() - 1) {
                this.doEnableKateIndex(this.enableKate);
            }
        }
    }

    public void padRemoved(Pad pad) {
        pad.unlink();
        if (pad == this.vpad) {
            Debug.log(3, "video pad removed " + pad);
            this.ovsinkpad.unlink();
            this.vpad = null;
        } else if (pad == this.apad) {
            Debug.log(3, "audio pad removed " + pad);
            this.asinkpad.unlink();
            this.apad = null;
        }
    }

    public void noMorePads() {
        boolean bl = false;
        Debug.log(3, "all streams detected");
        if (this.apad == null && this.enableAudio) {
            Debug.log(3, "file has no audio, remove audiosink");
            this.audiosink.setState(1);
            this.remove(this.audiosink);
            this.audiosink = null;
            bl = true;
        }
        if (this.vpad == null && this.enableVideo) {
            Debug.log(3, "file has no video, remove videosink");
            this.videosink.setState(1);
            if (this.overlay != null) {
                this.overlay.setState(1);
            }
            int n = 0;
            while (n < this.katedec.size()) {
                Element element = (Element)this.katedec.elementAt(n);
                element.setState(1);
                this.remove(element);
                element = (Element)this.k_queue.elementAt(n);
                element.setState(1);
                this.remove(element);
                ++n;
            }
            if (this.kselector != null) {
                this.kselector.setState(1);
                this.remove(this.kselector);
                this.kselector = null;
            }
            this.remove(this.videosink);
            this.remove(this.overlay);
            this.katedec.removeAllElements();
            this.k_queue.removeAllElements();
            this.videosink = null;
            this.overlay = null;
            bl = true;
        }
        if (bl) {
            this.scheduleReCalcState();
        }
    }

    public CortadoPipeline(Cortado cortado) {
        super("pipeline");
        this.application = cortado;
        this.enableKate = -1;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setKeepAspect(boolean bl) {
        this.keepAspect = bl;
    }

    public void setIgnoreAspect(boolean bl) {
        this.ignoreAspect = bl;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void enableAudio(boolean bl) {
        this.enableAudio = bl;
    }

    public boolean isAudioEnabled() {
        return this.enableAudio;
    }

    public void enableVideo(boolean bl) {
        this.enableVideo = bl;
    }

    public boolean isVideoEnabled() {
        return this.enableVideo;
    }

    private int findKateStream(String string, String string2) {
        boolean bl;
        int n = -1;
        boolean bl2 = !string.equals("");
        boolean bl3 = bl = !string2.equals("");
        if (bl2 || bl) {
            int n2 = 0;
            while (n2 < this.katedec.size()) {
                Element element = (Element)this.katedec.elementAt(n2);
                if (element != null) {
                    String string3 = String.valueOf(element.getProperty("language"));
                    String string4 = String.valueOf(element.getProperty("category"));
                    if (string.equalsIgnoreCase(string3) && (!bl || string2.equals(string4))) {
                        n = n2;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    public void enableKateStream(int n, String string, String string2) {
        if (n < 0) {
            n = this.findKateStream(string, string2);
        }
        if (n == this.enableKate) {
            return;
        }
        this.doEnableKateIndex(n);
    }

    private void doEnableKateIndex(int n) {
        if (this.kselector != null) {
            Debug.info("Switching Kate streams from " + this.enableKate + " to " + n);
            this.kselector.setProperty("selected", new Integer(n));
        } else {
            Debug.warning("Switching Kate stream request, but no Kate selector exists");
        }
        this.enableKate = n;
    }

    public int getEnabledKateIndex() {
        return this.enableKate;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setDocumentBase(URL uRL) {
        this.documentBase = uRL;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferLow(int n) {
        this.bufferLow = n;
    }

    public int getBufferLow() {
        return this.bufferLow;
    }

    public void setBufferHigh(int n) {
        this.bufferHigh = n;
    }

    public int getBufferHigh() {
        return this.bufferHigh;
    }

    public void resize(Dimension dimension) {
        if (this.videosink == null || dimension == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(dimension);
        if (this.application.getShowStatus() == 1) {
            rectangle.height -= this.application.getStatusHeight();
        }
        if (rectangle.height < 0) {
            rectangle.height = 0;
        }
        this.videosink.setProperty("bounds", rectangle);
    }

    public boolean buildOgg() {
        this.demux = ElementFactory.makeByName("oggdemux", "demux");
        if (this.demux == null) {
            this.noSuchElement("oggdemux");
            return false;
        }
        this.buffer = ElementFactory.makeByName("queue", "buffer");
        if (this.buffer == null) {
            this.demux = null;
            this.noSuchElement("queue");
            return false;
        }
        this.buffer.setProperty("isBuffer", Boolean.TRUE);
        if (this.bufferSize != -1) {
            this.buffer.setProperty("maxSize", new Integer(this.bufferSize * 1024));
        }
        if (this.bufferLow != -1) {
            this.buffer.setProperty("lowPercent", new Integer(this.bufferLow));
        }
        if (this.bufferHigh != -1) {
            this.buffer.setProperty("highPercent", new Integer(this.bufferHigh));
        }
        this.add(this.demux);
        this.add(this.buffer);
        this.httpsrc.getPad("src").link(this.buffer.getPad("sink"));
        this.buffer.getPad("src").link(this.demux.getPad("sink"));
        this.demux.addPadListener(this);
        this.buffer.setState(2);
        this.demux.setState(2);
        return true;
    }

    public boolean buildMultipart() {
        this.demux = ElementFactory.makeByName("multipartdemux", "demux");
        if (this.demux == null) {
            this.noSuchElement("multipartdemux");
            return false;
        }
        this.add(this.demux);
        this.httpsrc.getPad("src").link(this.demux.getPad("sink"));
        this.demux.addPadListener(this);
        return true;
    }

    public void capsChanged(Caps caps) {
        String string = caps.getMime();
        if (string.equals("application/ogg")) {
            this.buildOgg();
        } else if (string.equals("multipart/x-mixed-replace")) {
            this.buildMultipart();
        } else {
            this.postMessage(Message.newError(this, "unknown type: " + string));
        }
    }

    private void noSuchElement(String string) {
        this.postMessage(Message.newError(this, "no such element: " + string + " (check plugins.ini)"));
    }

    private boolean build() {
        Configure configure = new Configure();
        String string = System.getProperty("java.vendor");
        this.httpsrc = ElementFactory.makeByName("httpsrc", "httpsrc");
        if (this.httpsrc == null) {
            this.noSuchElement("httpsrc");
            return false;
        }
        this.httpsrc.setProperty("url", this.url);
        this.httpsrc.setProperty("userId", this.userId);
        this.httpsrc.setProperty("password", this.password);
        String string2 = "Cortado/" + configure.buildVersion + " " + string.substring(0, string.indexOf(" ")) + "/" + System.getProperty("java.version");
        String string3 = "(" + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
        try {
            String string4 = System.getProperty("http.agent");
            if (string4 != null) {
                string3 = string4;
            }
        }
        catch (Exception exception) {}
        string2 = String.valueOf(string2) + " " + string3;
        Debug.log(3, "setting User-Agent " + string2);
        this.httpsrc.setProperty("userAgent", string2);
        this.httpsrc.setProperty("documentBase", this.documentBase);
        this.add(this.httpsrc);
        this.httpsrc.getPad("src").addCapsListener(this);
        if (this.enableAudio) {
            this.audiosink = this.newAudioSink();
            if (this.audiosink == null) {
                this.enableAudio = false;
                ((Cortado)this.component).status.setHaveAudio(false);
                this.component.repaint();
            } else {
                this.asinkpad = this.audiosink.getPad("sink");
                this.add(this.audiosink);
            }
        }
        if (this.enableVideo) {
            this.videosink = ElementFactory.makeByName("videosink", "videosink");
            if (this.videosink == null) {
                this.noSuchElement("videosink");
                return false;
            }
            this.videosink.setProperty("keep-aspect", this.keepAspect ? "true" : "false");
            this.videosink.setProperty("ignore-aspect", this.ignoreAspect ? "true" : "false");
            this.videosink.setProperty("component", this.component);
            this.resize(this.component.getSize());
            this.videosink.setProperty("max-lateness", Long.toString(20000L));
            this.add(this.videosink);
            this.ovsinkpad = this.videosink.getPad("sink");
        }
        if (this.audiosink == null && this.videosink == null) {
            this.postMessage(Message.newError(this, "Both audio and video are disabled, can't play anything"));
            return false;
        }
        return true;
    }

    protected Element newAudioSink() {
        AudioSink audioSink;
        try {
            Class.forName("javax.sound.sampled.AudioSystem");
            Class.forName("javax.sound.sampled.DataLine");
            this.usingJavaX = true;
            audioSink = (AudioSink)ElementFactory.makeByName("audiosinkj2", "audiosink");
            Debug.log(3, "using high quality javax.sound backend");
        }
        catch (Throwable throwable) {
            audioSink = (AudioSink)ElementFactory.makeByName("audiosinksa", "audiosink");
            Debug.log(3, "using low quality sun.audio backend");
        }
        if (audioSink == null) {
            this.noSuchElement("audiosink");
            return null;
        }
        if (!audioSink.test()) {
            return null;
        }
        return audioSink;
    }

    private boolean cleanup() {
        Debug.log(3, "cleanup");
        if (this.httpsrc != null) {
            this.remove(this.httpsrc);
            this.httpsrc = null;
        }
        if (this.audiosink != null) {
            this.remove(this.audiosink);
            this.audiosink = null;
            this.asinkpad = null;
        }
        if (this.videosink != null) {
            this.remove(this.videosink);
            this.videosink = null;
        }
        if (this.overlay != null) {
            this.remove(this.overlay);
            this.overlay = null;
            this.ovsinkpad = null;
            this.oksinkpad = null;
        }
        if (this.buffer != null) {
            this.remove(this.buffer);
            this.buffer = null;
        }
        if (this.demux != null) {
            this.demux.removePadListener(this);
            this.remove(this.demux);
            this.demux = null;
        }
        if (this.v_queue != null) {
            this.remove(this.v_queue);
            this.v_queue = null;
        }
        if (this.v_queue2 != null) {
            this.remove(this.v_queue2);
            this.v_queue2 = null;
        }
        if (this.a_queue != null) {
            this.remove(this.a_queue);
            this.a_queue = null;
        }
        if (this.videodec != null) {
            this.remove(this.videodec);
            this.videodec = null;
        }
        if (this.audiodec != null) {
            this.remove(this.audiodec);
            this.audiodec = null;
        }
        int n = 0;
        while (n < this.katedec.size()) {
            if (this.k_queue.elementAt(n) != null) {
                this.remove((Element)this.k_queue.elementAt(n));
            }
            if (this.katedec.elementAt(n) != null) {
                this.remove((Element)this.katedec.elementAt(n));
            }
            ++n;
        }
        this.k_queue.removeAllElements();
        this.katedec.removeAllElements();
        if (this.kselector != null) {
            this.remove(this.kselector);
            this.kselector = null;
        }
        return true;
    }

    protected int changeState(int n) {
        switch (n) {
            case 18: {
                if (this.build()) break;
                return 0;
            }
        }
        int n2 = super.changeState(n);
        switch (n) {
            case 33: {
                this.cleanup();
                break;
            }
        }
        return n2;
    }

    protected boolean doSendEvent(Event event) {
        if (event.getType() != 5) {
            return false;
        }
        if (event.parseSeekFormat() != 5) {
            return false;
        }
        if (this.httpsrc == null) {
            return false;
        }
        boolean bl = this.httpsrc.getPad("src").sendEvent(event);
        this.getState(null, null, -1L);
        return bl;
    }

    protected long getPosition() {
        long l = 0L;
        Query query = Query.newPosition(3);
        if (super.query(query)) {
            l = query.parsePositionValue();
        }
        return l;
    }
}

