/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTSERVICECAPABILITIES_H_
#define OPENDRIM_BOOTSERVICECAPABILITIES_H_

#include <Instance.h>

const static char* OpenDRIM_BootServiceCapabilities_classnames[] = {"OpenDRIM_BootServiceCapabilities"};
static string OpenDRIM_BootServiceCapabilities_NAMESPACE = _NAMESPACE;

class OpenDRIM_BootServiceCapabilities {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	bool ElementNameEditSupported;
	bool ElementNameEditSupported_isNULL;
	
	unsigned short MaxElementNameLen;
	bool MaxElementNameLen_isNULL;
	
	vector<unsigned short> RequestedStatesSupported;
	bool RequestedStatesSupported_isNULL;
	
	string ElementNameMask;
	bool ElementNameMask_isNULL;
	
	vector<unsigned short> BootConfigCapabilities;
	bool BootConfigCapabilities_isNULL;
	
	vector<string> OtherBootConfigCapabilities;
	bool OtherBootConfigCapabilities_isNULL;
	
	vector<unsigned short> BootStringsSupported;
	bool BootStringsSupported_isNULL;
	
	vector<unsigned short> BootCapabilitiesSupported;
	bool BootCapabilitiesSupported_isNULL;
	
	vector<string> OtherBootCapabilitiesSupported;
	bool OtherBootCapabilitiesSupported_isNULL;
	
	OpenDRIM_BootServiceCapabilities() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		ElementNameEditSupported_isNULL = true;
		MaxElementNameLen_isNULL = true;
		RequestedStatesSupported_isNULL = true;
		ElementNameMask_isNULL = true;
		BootConfigCapabilities_isNULL = true;
		OtherBootConfigCapabilities_isNULL = true;
		BootStringsSupported_isNULL = true;
		BootCapabilitiesSupported_isNULL = true;
		OtherBootCapabilitiesSupported_isNULL = true;
	}
	
	~OpenDRIM_BootServiceCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getElementNameEditSupported(bool& value) const {
		if (ElementNameEditSupported_isNULL==true)
			return NOT_FOUND;
		value = ElementNameEditSupported;
		return OK;
	}
	
	int setElementNameEditSupported(const bool& newValue) {
		ElementNameEditSupported = newValue;
		ElementNameEditSupported_isNULL = false;
		return OK;
	}

	int getMaxElementNameLen(unsigned short& value) const {
		if (MaxElementNameLen_isNULL==true)
			return NOT_FOUND;
		value = MaxElementNameLen;
		return OK;
	}
	
	int setMaxElementNameLen(const unsigned short& newValue) {
		MaxElementNameLen = newValue;
		MaxElementNameLen_isNULL = false;
		return OK;
	}

	int getRequestedStatesSupported(vector<unsigned short>& value) const {
		if (RequestedStatesSupported_isNULL==true)
			return NOT_FOUND;
		value = RequestedStatesSupported;
		return OK;
	}
	
	int setRequestedStatesSupported(const vector<unsigned short>& newValue) {
		RequestedStatesSupported = newValue;
		RequestedStatesSupported_isNULL = false;
		return OK;
	}

	int getElementNameMask(string& value) const {
		if (ElementNameMask_isNULL==true)
			return NOT_FOUND;
		value = ElementNameMask;
		return OK;
	}
	
	int setElementNameMask(const string& newValue) {
		ElementNameMask = newValue;
		ElementNameMask_isNULL = false;
		return OK;
	}

	int getBootConfigCapabilities(vector<unsigned short>& value) const {
		if (BootConfigCapabilities_isNULL==true)
			return NOT_FOUND;
		value = BootConfigCapabilities;
		return OK;
	}
	
	int setBootConfigCapabilities(const vector<unsigned short>& newValue) {
		BootConfigCapabilities = newValue;
		BootConfigCapabilities_isNULL = false;
		return OK;
	}

	int getOtherBootConfigCapabilities(vector<string>& value) const {
		if (OtherBootConfigCapabilities_isNULL==true)
			return NOT_FOUND;
		value = OtherBootConfigCapabilities;
		return OK;
	}
	
	int setOtherBootConfigCapabilities(const vector<string>& newValue) {
		OtherBootConfigCapabilities = newValue;
		OtherBootConfigCapabilities_isNULL = false;
		return OK;
	}

	int getBootStringsSupported(vector<unsigned short>& value) const {
		if (BootStringsSupported_isNULL==true)
			return NOT_FOUND;
		value = BootStringsSupported;
		return OK;
	}
	
	int setBootStringsSupported(const vector<unsigned short>& newValue) {
		BootStringsSupported = newValue;
		BootStringsSupported_isNULL = false;
		return OK;
	}

	int getBootCapabilitiesSupported(vector<unsigned short>& value) const {
		if (BootCapabilitiesSupported_isNULL==true)
			return NOT_FOUND;
		value = BootCapabilitiesSupported;
		return OK;
	}
	
	int setBootCapabilitiesSupported(const vector<unsigned short>& newValue) {
		BootCapabilitiesSupported = newValue;
		BootCapabilitiesSupported_isNULL = false;
		return OK;
	}

	int getOtherBootCapabilitiesSupported(vector<string>& value) const {
		if (OtherBootCapabilitiesSupported_isNULL==true)
			return NOT_FOUND;
		value = OtherBootCapabilitiesSupported;
		return OK;
	}
	
	int setOtherBootCapabilitiesSupported(const vector<string>& newValue) {
		OtherBootCapabilitiesSupported = newValue;
		OtherBootCapabilitiesSupported_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BOOTSERVICECAPABILITIES_H_*/
