/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jvnet.fastinfoset.EncodingAlgorithm;
import org.jvnet.fastinfoset.EncodingAlgorithmException;
import org.web3d.vrml.export.compressors.CompressionTools;

public class QuantizedzlibFloatArrayAlgorithm
implements EncodingAlgorithm {
    public static final String ALGORITHM_URI = "encoder://web3d.org/QuantizedzlibFloatArrayEncoder";
    protected static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    public static final int BYTE_SIZE = 1;
    private static final float NOERROR = 9.0E-7f;
    private float tolerance;

    public QuantizedzlibFloatArrayAlgorithm() {
        this.tolerance = 9.0E-7f;
    }

    public QuantizedzlibFloatArrayAlgorithm(float f) {
        this.tolerance = f;
    }

    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof float[])) {
            throw new IllegalArgumentException("'data' not an instance of float[]");
        }
        float[] fArray = (float[])object;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        CompressionTools.quantizeFloatArrayDeflater(dataOutputStream, fArray, this.tolerance);
    }

    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        try {
            return CompressionTools.dequantizeFloatArrayInflater(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new EncodingAlgorithmException(exception);
        }
    }

    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        return this.decodeFromInputStreamToByteArray(inputStream);
    }

    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new WordListener(){

            public void word(int n, int n2) {
                String string = ((Object)charBuffer.subSequence(n, n2)).toString();
                arrayList.add(Byte.valueOf(string));
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException("'data' not an instance of byte[]");
        }
        byte[] byArray = (byte[])object;
        this.convertToCharactersFromByteArray(byArray, stringBuffer);
    }

    public final void decodeFromBytesToByteArray(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / 1;
        for (int i = 0; i < n4; ++i) {
            byArray[n++] = byArray2[n2++];
        }
    }

    public final byte[] decodeFromInputStreamToByteArray(InputStream inputStream) throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        byte[] byArray = new byte[1];
        while (true) {
            int n;
            int n2;
            if ((n2 = inputStream.read(byArray)) != 1) {
                if (n2 == -1) break;
                while (n2 != 1) {
                    n = inputStream.read(byArray, n2, 1 - n2);
                    if (n == -1) {
                        throw new EOFException();
                    }
                    n2 += n;
                }
            }
            n = byArray[0] & 0xFF;
            arrayList.add(new Byte((byte)n));
        }
        return this.generateArrayFromList(arrayList);
    }

    public final void convertToCharactersFromByteArray(byte[] byArray, StringBuffer stringBuffer) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Byte.toString(byArray[i]));
            if (i == byArray.length) continue;
            stringBuffer.append(' ');
        }
    }

    public final byte[] generateArrayFromList(List list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)list.get(i);
        }
        return byArray;
    }

    public void matchWhiteSpaceDelimnatedWords(CharBuffer charBuffer, WordListener wordListener) {
        Matcher matcher = SPACE_PATTERN.matcher(charBuffer);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n2 != n) {
                wordListener.word(n, n2);
            }
            n = matcher.end();
        }
    }

    private void zlibCompressIntArray(OutputStream outputStream, int[] nArray) throws IOException {
        Object object;
        byte[] byArray;
        int n;
        int n2 = nArray.length;
        boolean bl = false;
        int n3 = -1;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = n2 < 20 ? n2 : 20;
        for (n = 0; n < n5; ++n) {
            ++n4;
            if (nArray[n] != -1) continue;
            if (n3 == -1) {
                n3 = n4;
                n4 = 0;
                continue;
            }
            if (n3 != n4) {
                n3 = -1;
                break;
            }
            n4 = 0;
        }
        if (n3 == -1) {
            n3 = 0;
            byArray = new byte[n2 * 4];
            int n6 = 0;
            for (n = 0; n < n2; ++n) {
                byArray[n6++] = (byte)(nArray[n] + 1 >>> 24 & 0xFF);
                byArray[n6++] = (byte)(nArray[n] + 1 >>> 16 & 0xFF);
                byArray[n6++] = (byte)(nArray[n] + 1 >>> 8 & 0xFF);
                byArray[n6++] = (byte)(nArray[n] + 1 >>> 0 & 0xFF);
            }
        } else {
            int n7;
            n = 0;
            int[] nArray2 = new int[n2];
            int n8 = nArray[0];
            int n9 = nArray[0];
            n = 0;
            object = new int[n3];
            int[] nArray3 = nArray2;
            int n10 = 0;
            if (bl) {
                nArray3 = new int[nArray2.length * (n3 - 1) / n3];
            }
            for (n7 = 0; n7 < n2; ++n7) {
                int n11 = nArray[n7];
                nArray2[n7] = nArray[n7] - object[n];
                if (nArray2[n7] > n9) {
                    n9 = nArray2[n7];
                } else if (nArray2[n7] < n8) {
                    n8 = nArray2[n7];
                }
                object[n++] = n11;
                if (n == n3) {
                    n = 0;
                }
                if (!bl || (n7 + 1) % n3 == 0) continue;
                nArray3[n10++] = nArray2[n7];
            }
            if (bl) {
                nArray2 = nArray3;
                n2 = nArray2.length;
            }
            n2 = nArray2.length;
            byArray = new byte[n2 * 4];
            n10 = 0;
            System.out.println("Delts: ");
            for (n7 = 0; n7 < n2; ++n7) {
                System.out.println(nArray2[n7]);
                byArray[n10++] = (byte)(nArray2[n7] + 1 >>> 24 & 0xFF);
                byArray[n10++] = (byte)(nArray2[n7] + 1 >>> 16 & 0xFF);
                byArray[n10++] = (byte)(nArray2[n7] + 1 >>> 8 & 0xFF);
                byArray[n10++] = (byte)(nArray2[n7] + 1 >>> 0 & 0xFF);
            }
        }
        byte[] byArray2 = new byte[n2 * 4];
        Deflater deflater = new Deflater(9, false);
        deflater.setInput(byArray);
        deflater.finish();
        int n12 = deflater.deflate(byArray2);
        System.out.println("writing: rate: " + (float)n12 / ((float)nArray.length * 4.0f) + " " + nArray.length * 4 + " = " + n12);
        object = new DataOutputStream(outputStream);
        System.out.println("Len: " + n2);
        ((DataOutputStream)object).writeInt(n2);
        ((DataOutputStream)object).write((byte)n3);
        ((DataOutputStream)object).write(byArray2, 0, n12);
    }

    private int[] zlibDecompressIntArray(byte[] byArray, int n, int n2) throws IOException, DataFormatException {
        int n3;
        int n4 = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + ((byArray[n++] & 0xFF) << 0);
        int n5 = byArray[n++];
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, n, n2 - 5);
        byte[] byArray2 = new byte[n4 * 4];
        int n6 = inflater.inflate(byArray2);
        inflater.end();
        int n7 = 0;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = ((byArray2[n7++] & 0xFF) << 24) + ((byArray2[n7++] & 0xFF) << 16) + ((byArray2[n7++] & 0xFF) << 8) + ((byArray2[n7++] & 0xFF) << 0) - 1;
        }
        if (n5 == 0) {
            return nArray;
        }
        int[] nArray2 = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            nArray2[n3] = nArray[n3];
        }
        n3 = 0;
        for (int i = n5; i < n4; ++i) {
            nArray[i] = nArray[i] + nArray2[n3];
            nArray2[n3++] = nArray[i];
            if (n3 != n5) continue;
            n3 = 0;
        }
        return nArray;
    }

    public static interface WordListener {
        public void word(int var1, int var2);
    }
}

