.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XCWAttrib.man,v 1.2 2001/01/27 18:19:57 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XChangeWindowAttributes 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XChangeWindowAttributes, XSetWindowBackground, XSetWindowBackgroundPixmap, XSetWindowBorder, XSetWindowBorderPixmap, XSetWindowColormap \- change window attributes
.SH SYNTAX
XChangeWindowAttributes\^(\^\fIdisplay\fP, \fIw\fP\^, \fIvaluemask\fP\^, \fIattributes\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      unsigned long \fIvaluemask\fP\^;
.br
      XSetWindowAttributes *\fIattributes\fP\^;
.LP
XSetWindowBackground\^(\^\fIdisplay\fP, \fIw\fP\^, \fIbackground_pixel\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      unsigned long \fIbackground_pixel\fP\^;
.LP
XSetWindowBackgroundPixmap\^(\^\fIdisplay\fP, \fIw\fP\^, \fIbackground_pixmap\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      Pixmap \fIbackground_pixmap\fP\^;
.LP 
XSetWindowBorder\^(\^\fIdisplay\fP, \fIw\fP\^, \fIborder_pixel\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      unsigned long \fIborder_pixel\fP\^;
.LP
XSetWindowBorderPixmap\^(\^\fIdisplay\fP, \fIw\fP\^, \fIborder_pixmap\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      Pixmap \fIborder_pixmap\fP\^;
.LP
XSetWindowColormap\^(\^\fIdisplay\fP, \fIw\fP\^, \fIcolormap\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.SH ARGUMENTS
.IP \fIattributes\fP 1i
Specifies the structure from which the values (as specified by the value mask)
are to be taken.
The value mask should have the appropriate bits
set to indicate which attributes have been set in the structure.
.IP \fIbackground_pixel\fP 1i
Specifies the pixel that is to be used for the background.
.IP \fIbackground_pixmap\fP 1i
Specifies the background pixmap,
.ZN ParentRelative ,
or
.ZN None .
.IP \fIborder_pixel\fP 1i
Specifies the entry in the colormap. 
.IP \fIborder_pixmap\fP 1i
Specifies the border pixmap or
.ZN CopyFromParent .
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIvaluemask\fP 1i
Specifies which window attributes are defined in the attributes
argument.
This mask is the bitwise inclusive OR of the valid attribute mask bits.
If valuemask is zero,
the attributes are ignored and are not referenced.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIcolormap\fP 1i
Specifies the colormap.
.SH DESCRIPTION
Depending on the valuemask,
the
.ZN XChangeWindowAttributes
function uses the window attributes in the
.ZN XSetWindowAttributes
structure to change the specified window attributes.
Changing the background does not cause the window contents to be
changed.
To repaint the window and its background, use 
.ZN XClearWindow .
Setting the border or changing the background such that the
border tile origin changes causes the border to be repainted.
Changing the background of a root window to 
.ZN None 
or 
.ZN ParentRelative
restores the default background pixmap.
Changing the border of a root window to
.ZN CopyFromParent
restores the default border pixmap.
Changing the win-gravity does not affect the current position of the
window.
Changing the backing-store of an obscured window to 
.ZN WhenMapped 
or
.ZN Always , 
or changing the backing-planes, backing-pixel, or
save-under of a mapped window may have no immediate effect.
Changing the colormap of a window (that is, defining a new map, not
changing the contents of the existing map) generates a 
.ZN ColormapNotify
event.
Changing the colormap of a visible window may have no
immediate effect on the screen because the map may not be installed
(see
.ZN XInstallColormap ).
Changing the cursor of a root window to 
.ZN None 
restores the default
cursor.
Whenever possible, you are encouraged to share colormaps.
.LP
Multiple clients can select input on the same window. 
Their event masks are maintained separately.
When an event is generated, 
it is reported to all interested clients. 
However, only one client at a time can select for 
.ZN SubstructureRedirectMask , 
.ZN ResizeRedirectMask , 
and
.ZN ButtonPressMask .
If a client attempts to select any of these event masks 
and some other client has already selected one, 
a
.ZN BadAccess
error results.
There is only one do-not-propagate-mask for a window, 
not one per client.
.LP
.ZN XChangeWindowAttributes
can generate
.ZN BadAccess ,
.ZN BadColor ,
.ZN BadCursor ,
.ZN BadMatch ,
.ZN BadPixmap ,
.ZN BadValue ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XSetWindowBackground
function sets the background of the window to the specified pixel value.
Changing the background does not cause the window contents to be changed.
.ZN XSetWindowBackground
uses a pixmap of undefined size filled with the pixel value you passed.
If you try to change the background of an 
.ZN InputOnly
window, a
.ZN BadMatch
error results.
.LP
.ZN XSetWindowBackground
can generate
.ZN BadMatch
and
.ZN BadWindow 
errors.
.LP
The
.ZN XSetWindowBackgroundPixmap
function sets the background pixmap of the window to the specified pixmap.
The background pixmap can immediately be freed if no further explicit
references to it are to be made.
If 
.ZN ParentRelative
is specified, 
the background pixmap of the window's parent is used,
or on the root window, the default background is restored.
If you try to change the background of an 
.ZN InputOnly
window, a
.ZN BadMatch
error results.
If the background is set to
.ZN None ,
the window has no defined background.
.LP
.ZN XSetWindowBackgroundPixmap
can generate
.ZN BadMatch ,
.ZN BadPixmap ,
and
.ZN BadWindow 
errors.
.LP 
The
.ZN XSetWindowBorder
function sets the border of the window to the pixel value you specify.
If you attempt to perform this on an
.ZN InputOnly
window, a
.ZN BadMatch
error results.
.LP
.ZN XSetWindowBorder
can generate
.ZN BadMatch
and
.ZN BadWindow 
errors.
.LP
The
.ZN XSetWindowBorderPixmap
function sets the border pixmap of the window to the pixmap you specify.
The border pixmap can be freed immediately if no further explicit
references to it are to be made.
If you specify
.ZN CopyFromParent ,
a copy of the parent window's border pixmap is used.
If you attempt to perform this on an
.ZN InputOnly
window, a
.ZN BadMatch
error results.
.LP
.ZN XSetWindowBorderPixmap
can generate
.ZN BadMatch ,
.ZN BadPixmap ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XSetWindowColormap
function sets the specified colormap of the specified window.
The colormap must have the same visual type as the window,
or a
.ZN BadMatch
error results.
.LP
.ZN XSetWindowColormap
can generate
.ZN BadColor ,
.ZN BadMatch ,
and
.ZN BadWindow 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAccess
A client attempted
to free a color map entry that it did not already allocate.
.TP 1i
.ZN BadAccess
A client attempted
to store into a read-only color map entry.
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.ZN BadCursor
A value for a Cursor argument does not name a defined Cursor.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window locks this attribute.
.TP 1i
.ZN BadPixmap
A value for a Pixmap argument does not name a defined Pixmap.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XConfigureWindow(3X11),
XCreateWindow(3X11),
XDestroyWindow(3X11),
XInstallColormap(3X11),
XMapWindow(3X11),
XRaiseWindow(3X11),
XUnmapWindow(3X11)
.br
\fI\*(xL\fP
