//Copyright (c) 2014 - 2025, The Trustees of Indiana University, Tulane University.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

#ifndef TOPPIC_COMMON_XML_XML_DOM_DOCUMENT_HPP_
#define TOPPIC_COMMON_XML_XML_DOM_DOCUMENT_HPP_

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMImplementation.hpp>
#include <xercesc/framework/MemBufInputSource.hpp>

#include "common/xml/xml_dom_element.hpp"
#include "common/xml/xml_dom_parser.hpp"

namespace toppic {

class XmlDOMDocument {
 public:
  XmlDOMDocument(XmlDOMParser* parser, const char* xml_file);
  XmlDOMDocument(XmlDOMParser* parser, const xercesc::MemBufInputSource &str_buf);

  XmlDOMDocument(xercesc::DOMDocument* doc);

  XmlDOMDocument(xercesc::DOMImplementation* implementation, 
                 const std::string &root);
  ~XmlDOMDocument();

  XmlDOMElement* createElement(const char* tag);

  xercesc::DOMText* createTextNode(const char* text);

  void addElement(XmlDOMElement* element, 
                  const char* tag, const char* value);

  XmlDOMElement* getDocumentElement() {
    return doc_->getDocumentElement();
  }

  void addElement(XmlDOMElement* element);
  void addElement(XmlDOMElement* parent, XmlDOMElement* child);

  int writeXmlDOMDocument(const char * filename);

  void release() {doc_->release();}

 private:
  xercesc::DOMDocument* doc_;
};

}

#endif
