/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.piccolo2d.PNode;

public class SwingLayoutNode
extends PNode {
    private static final long serialVersionUID = 1L;
    private static final Anchor DEFAULT_ANCHOR = Anchor.WEST;
    private final Container container;
    private final PropertyChangeListener propertyChangeListener;
    private Anchor defaultAnchor;

    public SwingLayoutNode() {
        this(new FlowLayout());
    }

    public SwingLayoutNode(LayoutManager layoutManager) {
        this(new JPanel(layoutManager));
    }

    public SwingLayoutNode(Container container) {
        this.container = container;
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getPropertyName();
                if (SwingLayoutNode.this.isLayoutProperty(propertyName)) {
                    SwingLayoutNode.this.updateContainerLayout();
                }
            }
        };
        this.defaultAnchor = DEFAULT_ANCHOR;
    }

    public void setAnchor(Anchor anchor) {
        this.defaultAnchor = anchor;
    }

    public Anchor getAnchor() {
        return this.defaultAnchor;
    }

    public Container getContainer() {
        return this.container;
    }

    public void addChild(int index, PNode child, Object constraints, Anchor childAnchor) {
        super.addChild(index, child);
        this.addProxyComponent(child, constraints, childAnchor);
    }

    public void addChild(int index, PNode child) {
        this.addChild(index, child, null, this.defaultAnchor);
    }

    public void addChild(int index, PNode child, Object constraints) {
        this.addChild(index, child, constraints, this.defaultAnchor);
    }

    public void addChild(int index, PNode child, Anchor anchor) {
        this.addChild(index, child, null, anchor);
    }

    public void addChild(PNode child, Object constraints, Anchor anchor) {
        int index = this.getChildrenCount();
        if (child.getParent() == this) {
            --index;
        }
        this.addChild(index, child, constraints, anchor);
    }

    public void addChild(PNode child) {
        this.addChild(child, null, this.defaultAnchor);
    }

    public void addChild(PNode child, Object constraints) {
        this.addChild(child, constraints, this.defaultAnchor);
    }

    public void addChild(PNode child, Anchor anchor) {
        this.addChild(child, null, anchor);
    }

    public void addChildren(Collection nodes, Object constraints, Anchor anchor) {
        for (PNode each : nodes) {
            this.addChild(each, constraints, anchor);
        }
    }

    public void addChildren(Collection nodes) {
        this.addChildren(nodes, null, this.defaultAnchor);
    }

    public void addChildren(Collection nodes, Object constraints) {
        this.addChildren(nodes, constraints, this.defaultAnchor);
    }

    public void addChildren(Collection nodes, Anchor anchor) {
        this.addChildren(nodes, null, anchor);
    }

    public PNode removeChild(int index) {
        PNode node = super.removeChild(index);
        this.removeProxyComponent(node);
        return node;
    }

    public void removeAllChildren() {
        ListIterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            this.removeChild((PNode)i.next());
        }
    }

    private void addProxyComponent(PNode node, Object constraints, Anchor anchor) {
        ProxyComponent component = new ProxyComponent(node, anchor);
        this.container.add((Component)component, constraints);
        node.addPropertyChangeListener(this.propertyChangeListener);
        this.updateContainerLayout();
    }

    private void removeProxyComponent(PNode node) {
        ProxyComponent component;
        if (node != null && (component = this.getComponentForNode(node)) != null) {
            this.container.remove(component);
            node.removePropertyChangeListener(this.propertyChangeListener);
            this.updateContainerLayout();
        }
    }

    private ProxyComponent getComponentForNode(PNode node) {
        ProxyComponent nodeComponent = null;
        Component[] components = this.container.getComponents();
        if (components != null) {
            for (int i = 0; i < components.length && nodeComponent == null; ++i) {
                ProxyComponent n;
                if (!(components[i] instanceof ProxyComponent) || (n = (ProxyComponent)components[i]).getNode() != node) continue;
                nodeComponent = n;
            }
        }
        return nodeComponent;
    }

    private boolean isLayoutProperty(String propertyName) {
        return propertyName.equals("visible") || propertyName.equals("fullBounds") || propertyName.equals("bounds") || propertyName.equals("transform");
    }

    private void updateContainerLayout() {
        this.container.invalidate();
        this.container.setSize(this.container.getPreferredSize());
        this.container.doLayout();
    }

    public static interface Anchor {
        public static final Anchor CENTER = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(1.centerX(node, x, w), 1.centerY(node, y, h));
            }
        };
        public static final Anchor NORTH = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(2.centerX(node, x, w), 2.north(node, y, h));
            }
        };
        public static final Anchor NORTHEAST = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(3.east(node, x, w), 3.north(node, y, h));
            }
        };
        public static final Anchor EAST = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(4.east(node, x, w), 4.centerY(node, y, h));
            }
        };
        public static final Anchor SOUTHEAST = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(5.east(node, x, w), 5.south(node, y, h));
            }
        };
        public static final Anchor SOUTH = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(6.centerX(node, x, w), 6.south(node, y, h));
            }
        };
        public static final Anchor SOUTHWEST = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(7.west(node, x, w), 7.south(node, y, h));
            }
        };
        public static final Anchor WEST = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(8.west(node, x, w), 8.centerY(node, y, h));
            }
        };
        public static final Anchor NORTHWEST = new AbstractAnchor(){

            public void positionNode(PNode node, double x, double y, double w, double h) {
                node.setOffset(9.west(node, x, w), 9.north(node, y, h));
            }
        };

        public void positionNode(PNode var1, double var2, double var4, double var6, double var8);

        public static abstract class AbstractAnchor
        implements Anchor {
            protected static double centerX(PNode node, double x, double width) {
                return x + (width - node.getFullBoundsReference().getWidth()) / 2.0;
            }

            protected static double centerY(PNode node, double y, double height) {
                return y + (height - node.getFullBoundsReference().getHeight()) / 2.0;
            }

            protected static double north(PNode node, double y, double height) {
                return y;
            }

            protected static double south(PNode node, double y, double height) {
                return y + height - node.getFullBoundsReference().getHeight();
            }

            protected static double east(PNode node, double x, double width) {
                return x + width - node.getFullBoundsReference().getWidth();
            }

            protected static double west(PNode node, double x, double width) {
                return x;
            }
        }
    }

    private static class ProxyComponent
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final PNode node;
        private final Anchor anchor;

        public ProxyComponent(PNode node, Anchor anchor) {
            this.node = node;
            this.anchor = anchor;
        }

        public PNode getNode() {
            return this.node;
        }

        public Dimension getPreferredSize() {
            double w = this.node.getFullBoundsReference().getWidth();
            double h = this.node.getFullBoundsReference().getHeight();
            return new Dimension(this.roundUp(w), this.roundUp(h));
        }

        private int roundUp(double val) {
            return (int)Math.ceil(val);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setBounds(int x, int y, int w, int h) {
            if (x != this.getX() || y != this.getY() || w != this.getWidth() || h != this.getHeight()) {
                super.setBounds(x, y, w, h);
                this.anchor.positionNode(this.node, x, y, w, h);
            }
        }
    }
}

