/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.nodes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.piccolo2d.PNode;
import org.piccolo2d.util.PPaintContext;

public class PHtmlView
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    public static final String PROPERTY_FONT = "font";
    public static final int PROPERTY_CODE_FONT = 0x100000;
    public static final String PROPERTY_TEXT = "text";
    public static final int PROPERTY_CODE_TEXT = 0x200000;
    public static final String PROPERTY_TEXT_COLOR = "text color";
    public static final int PROPERTY_CODE_TEXT_COLOR = 0x400000;
    private final JLabel label;
    private transient View htmlView;

    public PHtmlView() {
        this(null, DEFAULT_FONT, DEFAULT_TEXT_COLOR);
    }

    public PHtmlView(String text) {
        this(text, DEFAULT_FONT, DEFAULT_TEXT_COLOR);
    }

    public PHtmlView(String text, Font font, Color textColor) {
        this.label = new JLabel(text);
        this.label.setFont(font);
        this.label.setForeground(textColor);
        super.setBounds(0.0, 0.0, this.label.getPreferredSize().getWidth(), this.label.getPreferredSize().getHeight());
        this.update();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        String oldText = this.label.getText();
        if (oldText == null && text == null) {
            return;
        }
        if (oldText == null || !oldText.equals(text)) {
            this.label.setText(text);
            this.update();
            this.firePropertyChange(0x200000, PROPERTY_TEXT, oldText, this.label.getText());
        }
    }

    public Font getFont() {
        return this.label.getFont();
    }

    public void setFont(Font font) {
        Font oldFont = this.label.getFont();
        this.label.setFont(font);
        this.update();
        this.firePropertyChange(0x100000, PROPERTY_FONT, oldFont, this.label.getFont());
    }

    public Color getTextColor() {
        return this.label.getForeground();
    }

    public void setTextColor(Color textColor) {
        Color oldColor = this.label.getForeground();
        this.label.setForeground(textColor);
        this.repaint();
        this.firePropertyChange(0x400000, PROPERTY_TEXT_COLOR, oldColor, this.label.getForeground());
    }

    private void update() {
        String htmlContent = this.label.getText();
        if (htmlContent == null) {
            htmlContent = "";
        }
        this.htmlView = BasicHTML.createHTMLView(this.label, htmlContent);
        this.fitHeightToHtmlContent();
        this.repaint();
    }

    private void fitHeightToHtmlContent() {
        if (this.getWidth() > 0.0) {
            this.htmlView.setSize((float)this.getWidth(), 0.0f);
            float wrapHeight = this.htmlView.getPreferredSpan(1);
            this.label.setSize(new Dimension((int)this.getWidth(), (int)wrapHeight));
            if (this.getHeight() < (double)wrapHeight) {
                System.out.println(this.getHeight());
                System.out.println(wrapHeight);
                super.setBounds(this.getX(), this.getY(), this.getWidth(), wrapHeight);
            }
        }
    }

    public boolean setBounds(double x, double y, double width, double height) {
        boolean boundsChanged = super.setBounds(x, y, width, height);
        this.update();
        return boundsChanged;
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean boundsChanged = super.setBounds(newBounds);
        this.update();
        return boundsChanged;
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        paintContext.pushClip(this.getBounds());
        Graphics2D g2 = paintContext.getGraphics();
        this.htmlView.paint(g2, this.getBounds().getBounds());
        paintContext.popClip(this.getBounds());
    }

    public String getLinkAddressAt(Point2D point) {
        return this.getLinkAddressAt(point.getX(), point.getY());
    }

    public String getLinkAddressAt(double x, double y) {
        String tag;
        String text = this.label.getText();
        String address = null;
        int currentPos = 0;
        for (int position = this.pointToModelIndex(x, y); currentPos < text.length() && (currentPos = text.indexOf(60, currentPos)) != -1 && position >= currentPos; position += tag.length()) {
            int tagStart = currentPos;
            int tagEnd = this.findTagEnd(text, currentPos);
            if (tagEnd == -1) {
                return null;
            }
            currentPos = tagEnd + 1;
            tag = text.substring(tagStart, currentPos);
            if (!"</a>".equals(tag)) continue;
            address = null;
        }
        return address;
    }

    private int pointToModelIndex(double x, double y) {
        Position.Bias[] biasReturn = new Position.Bias[1];
        return this.htmlView.viewToModel((float)x, (float)y, this.getBounds(), biasReturn);
    }

    private int findTagEnd(String text, int startPos) {
        int currentPos = startPos;
        ++currentPos;
        while (currentPos > 0 && currentPos < text.length() && text.charAt(currentPos) != '>') {
            if (text.charAt(currentPos) == '\"') {
                currentPos = text.indexOf(34, currentPos + 1);
            } else if (text.charAt(currentPos) == '\'') {
                currentPos = text.indexOf(39, currentPos + 1);
            }
            ++currentPos;
        }
        if (currentPos == 0 || currentPos >= text.length()) {
            return -1;
        }
        return currentPos + 1;
    }

    private String extractHref(String tag) {
        int currentPos = 0;
        String href = null;
        while (currentPos >= 0 && currentPos < tag.length() - 1) {
            if ((currentPos = tag.indexOf(61, currentPos + 1)) == -1 || !this.isHrefAttributeAssignment(tag, currentPos)) continue;
            return this.extractHrefValue(tag, currentPos + 1);
        }
        return href;
    }

    private String extractHrefValue(String tag, int startPos) {
        int currentPos = startPos;
        if (tag.charAt(currentPos) == '\"') {
            int startHref = currentPos + 1;
            if ((currentPos = tag.indexOf(34, startHref)) == -1) {
                return null;
            }
            return tag.substring(startHref, currentPos);
        }
        if (currentPos < tag.length() && tag.charAt(currentPos) == '\'') {
            int startHref = currentPos + 1;
            if ((currentPos = tag.indexOf(39, startHref)) == -1) {
                return null;
            }
            return tag.substring(startHref, currentPos);
        }
        int startHref = currentPos;
        if (currentPos < tag.length()) {
            while (++currentPos < tag.length() && tag.charAt(currentPos) != ' ' && tag.charAt(currentPos) != '>') {
            }
        }
        return tag.substring(startHref, currentPos);
    }

    private boolean isHrefAttributeAssignment(String tag, int equalPos) {
        return tag.charAt(equalPos) == '=' && equalPos > 4 && " href".equals(tag.substring(equalPos - 5, equalPos));
    }
}

