from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


CP850_CODEC = _Mock()

LOCALE_CODEC = _Mock()

SIGNAL = _Mock()

_ = _Mock()

add_pathlist_to_PYTHONPATH = _Mock()

get_icon = _Mock()

is_text_string = _Mock()

os = _Mock()

shell_split = _Mock()

to_text_string = _Mock()



class ExternalShellBase(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class ExternalSystemShell(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QMessageBox(_Mock):
  pass
  Abort = 262144
  AcceptRole = 0
  Accepted = 1
  ActionRole = 3
  Apply = 33554432
  ApplyRole = 8
  ButtonMask = -769
  Cancel = 4194304
  Close = 2097152
  Critical = 3
  Default = 256
  DestructiveRole = 2
  Discard = 8388608
  DrawChildren = 2
  DrawWindowBackground = 1
  Escape = 512
  FirstButton = 1024
  FlagMask = 768
  Help = 16777216
  HelpRole = 4
  Ignore = 1048576
  IgnoreMask = 4
  Information = 1
  InvalidRole = -1
  LastButton = 134217728
  No = 65536
  NoAll = 131072
  NoButton = 0
  NoIcon = 0
  NoRole = 6
  NoToAll = 131072
  Ok = 1024
  Open = 8192
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Question = 4
  RejectRole = 1
  Rejected = 0
  Reset = 67108864
  ResetRole = 7
  RestoreDefaults = 134217728
  Retry = 524288
  Save = 2048
  SaveAll = 4096
  Warning = 2
  Yes = 16384
  YesAll = 32768
  YesRole = 5
  YesToAll = 32768

class QProcess(_Mock):
  pass
  Append = 4
  CrashExit = 1
  Crashed = 1
  FailedToStart = 0
  ForwardedChannels = 2
  MergedChannels = 1
  NormalExit = 0
  NotOpen = 0
  NotRunning = 0
  ReadError = 3
  ReadOnly = 1
  ReadWrite = 3
  Running = 2
  SeparateChannels = 0
  StandardError = 1
  StandardOutput = 0
  Starting = 1
  Text = 16
  Timedout = 2
  Truncate = 8
  Unbuffered = 32
  UnknownError = 5
  WriteError = 4
  WriteOnly = 2

class QTextCodec(_Mock):
  pass
  ConvertInvalidToNull = -2147483648
  DefaultConversion = 0
  IgnoreHeader = 1

class TerminalWidget(_Mock):
  pass
  Box = 1
  COM = '#'
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  NoWrap = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  SEPARATOR = '\n\n# ---(Tue Mar 10 11:03:54 2015)---'
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WidgetWidth = 1
  WinPanel = 3

