from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_ = _Mock()

codecs = _Mock()

encoding = _Mock()

generate_configuration = _Mock()

generate_context = _Mock()

get_module_data_path = _Mock()

get_module_source_path = _Mock()

is_sphinx_markup = _Mock()

mkdtemp = _Mock()

os = _Mock()

osp = _Mock()

shutil = _Mock()

sphinx = _Mock()

sphinxify = _Mock()

sys = _Mock()

usage = _Mock()

warning = _Mock()

CONFDIR_PATH = '/usr/lib/python2.7/dist-packages/spyderlib/utils/inspector'

CSS_PATH = '/usr/lib/python2.7/dist-packages/spyderlib/utils/inspector/static/css'

JQUERY_PATH = '/usr/share/javascript/jquery'

JS_PATH = '/usr/lib/python2.7/dist-packages/spyderlib/utils/inspector/js'

MATHJAX_PATH = '/usr/share/javascript/mathjax'

class Environment(_Mock):
  pass
  overlayed = False
  sandboxed = False
  shared = False

class FileSystemLoader(_Mock):
  pass
  has_source_access = True

class Sphinx(_Mock):
  pass


class SystemMessage(_Mock):
  pass


