from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


aliases = _Mock()

base_aliases = _Mock()

base_flags = _Mock()

catch_config_error = _Mock()

default_secure = _Mock()

disambiguate_url = _Mock()

flags = _Mock()

import_item = _Mock()

json = _Mock()

launch_new_instance = _Mock()

launch_scheduler = _Mock()

localhost = _Mock()

os = _Mock()

public_ips = _Mock()

real_dbs = _Mock()

session_aliases = _Mock()

session_flags = _Mock()

set_hwm = _Mock()

signal = _Mock()

split_url = _Mock()

stat = _Mock()

sys = _Mock()

with_statement = _Mock()

zmq = _Mock()

SIGABRT = 6

SIGINT = 2

SIGTERM = 15

_description = 'Start the IPython controller for parallel computing.\n\nThe IPython controller provides a gateway between the IPython engines and\nclients. The controller needs to be started before the engines and can be\nconfigured using command line options or using a cluster directory. Cluster\ndirectories contain config, log and security files and are usually located in\nyour ipython directory and named as "profile_name". See the `profile`\nand `profile-dir` options for details.\n'

_examples = '\nipcontroller --ip=192.168.0.1 --port=1000  # listen on ip, port for engines\nipcontroller --scheme=pure  # use the pure zeromq scheduler\n'

class BaseParallelApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Dict(_Mock):
  pass
  info_text = 'any value'

class DictDB(_Mock):
  pass


class HeartMonitor(_Mock):
  pass


class HubFactory(_Mock):
  pass


class IPControllerApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'Start the IPython controller for parallel computing.\n\nThe IPython controller provides a gateway between the IPython engines and\nclients. The controller needs to be started before the engines and can be\nconfigured using command line options or using a cluster directory. Cluster\ndirectories contain config, log and security files and are usually located in\nyour ipython directory and named as "profile_name". See the `profile`\nand `profile-dir` options for details.\n'
  examples = '\nipcontroller --ip=192.168.0.1 --port=1000  # listen on ip, port for engines\nipcontroller --scheme=pure  # use the pure zeromq scheduler\n'
  name = u'ipcontroller'

class Instance(_Mock):
  pass
  info_text = 'any value'

class List(_Mock):
  pass
  info_text = 'any value'

class PUBHandler(_Mock):
  pass
  root_topic = ''

class Process(_Mock):
  pass


class ProcessMonitoredQueue(_Mock):
  pass
  _in_prefix = ''
  _out_prefix = ''

class ProfileDir(_Mock):
  pass


class SQLiteDB(_Mock):
  pass


class Session(_Mock):
  pass


class TaskScheduler(_Mock):
  pass


class TraitError(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

