/********************************** */
/* Rule Set Based Access Control    */
/* Author and (c) 1999-2008:        */
/*   Amon Ott <ao@rsbac.org>        */
/* Getname functions for CAP module */
/* Last modified: 13/Feb/2008       */
/********************************** */

#include <rsbac/getname.h>
#include <rsbac/cap_getname.h>
#include <rsbac/helpers.h>
#include <rsbac/error.h>

#ifdef __KERNEL__
#include <linux/sched.h>
#include <linux/string.h>
#include <rsbac/rkmem.h>
#include <rsbac/debug.h>
#include <rsbac/aci.h>
#else
#include <string.h>
#endif

/*****************************************/

#ifdef __KERNEL__
#ifdef CONFIG_RSBAC_CAP_LOG_MISSING
void rsbac_cap_log_missing_cap(int cap)
  {
    char * tmp;
    union rsbac_target_id_t       i_tid;
    union rsbac_attribute_value_t i_attr_val1;

#if 0 && LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    if(cap == CAP_SYS_ADMIN)
      return;
#endif
    
    i_tid.process = task_pid(current);
    if (rsbac_get_attr(SW_CAP,
                       T_PROCESS,
                       i_tid,
                       A_max_caps_user,
                       &i_attr_val1,
                       FALSE))
      {
        rsbac_ds_get_error("rsbac_cap_log_missing_cap()", A_max_caps_user);
      }
    else
      {
        if(!((i_attr_val1.max_caps_user.cap[0] & (1 << cap)) || ((i_attr_val1.max_caps_user.cap[1] & (1 << cap)))))
          {
            tmp = rsbac_kmalloc(RSBAC_MAXNAMELEN);
            if(tmp)
              {
                get_cap_name(tmp, cap);
                rsbac_printk(KERN_DEBUG
                             "capable(): pid %u(%.15s), uid %u: missing user max_cap %s!\n",
                             current->pid, current->comm,
                             current->uid,
                             tmp);
                  rsbac_kfree(tmp);
              }
          }
      }
    if (rsbac_get_attr(SW_CAP,
                       T_PROCESS,
                       i_tid,
                       A_max_caps_program,
                       &i_attr_val1,
                       FALSE))
      {
        rsbac_ds_get_error("rsbac_cap_log_missing_cap()", A_max_caps_program);
      }
    else
      {
        if(!((i_attr_val1.max_caps_program.cap[0] & (1 << cap)) || (i_attr_val1.max_caps_program.cap[1] & (1 << cap))))
          {
            tmp = rsbac_kmalloc(RSBAC_MAXNAMELEN);
            if(tmp)
              {
                get_cap_name(tmp, cap);
                rsbac_printk(KERN_DEBUG
                             "capable(): pid %u(%.15s), uid %u: missing program max_cap %s!\n",
                             current->pid, current->comm,
                             current->uid,
                             tmp);
                  rsbac_kfree(tmp);
              }
          }
      }
  }
#endif
#endif

