///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// bug rapporte par Mahamar Dicko et Julien De marchi <julien.de-marchi@inria.fr>
// 	uh[0] = vh[1]; 
// => was a simple shallow copy of proxies, without data assignement (fixed)
#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  Float tol = (argc > 2) ? atof(argv[2]) : 1e-10;
  space Xh (omega, "P1");
  space Vh (omega, "P1", "vector");
  space Th (omega, "P1", "tensor");
  field tau_h (Th,0), uh(Vh,1);
  tau_h(0,1) = uh[0]; // old fix: tau_h(0,1) = field(uh[0]); or 1.0*uh[0];
  Float tau_max = tau_h.max();
  dout << "field_component: tau_h.max = " << tau_max << endl;
  // the same with domain indexation:
  field phi_h(Xh,0), psi_h(Xh,1);
  phi_h["boundary"] = psi_h["boundary"];
  Float phi_max = phi_h.max();
  dout << "field_indirect: phi_h.max = " << phi_max << endl;
  Float err = max (fabs(tau_max-1) , fabs(phi_max-1));
  dout << "err = " << err << endl;
  return (err < tol) ? 0 : 1;
}
