# ifndef _RHEO_ENVIRONMENT_H
# define _RHEO_ENVIRONMENT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// boost::mpi::environment-like interface,
// but with  MPI_Init_thread() instead of MPI_Init() call
// => support Scotch when compiled with threads
// note: this file is directly included by distributed.h

#include "rheolef/distributed.h"
#include <boost/optional.hpp>

/*Class:environment
NAME:  @code{environment} - rheolef initialization (@PACKAGE@-@VERSION@)
SYNOPSYS:
  This class is mainly used to initialize the MPI library: it
  should be called juste after the @code{main(argc,argv)} declaration
  as in:
  @example
    #include "rheolef.h"
    using namespace rheolef;
    int main(int argc, char**argv) @{
      environment rheolef (argc, argv);
      ...
    @}
  @end example
  An optional third argument of the @code{environment} constructor
  allows to set the MPI thread feature. By default, its value
  is MPI_THREAD_SINGLE, as defined in @code{mpi.h}.
  Other possible values are related to MPI multi-threaded, see
  the MPI documentation for more details.

AUTHORS: Pierre.Saramito@imag.fr
DATE:   29 september 2015
End:
*/

namespace rheolef {

struct environment_option_type {
  static const int no_thread = 100;
#ifdef _RHEOLEF_HAVE_MPI
  static const int default_thread = MPI_THREAD_SINGLE;
#else // _RHEOLEF_HAVE_MPI
  static const int default_thread = 0;
#endif // _RHEOLEF_HAVE_MPI
  environment_option_type() : thread_level (default_thread) {}
  int thread_level ;
};

#ifndef _RHEOLEF_HAVE_MPI

class environment {
public:
  environment (int& argc, char**& argv, const environment_option_type& opt = environment_option_type());
  ~environment();
protected:
  unsigned int _oldcw;
};
#else
class environment {
public:
  explicit environment (int& argc, char**& argv, const environment_option_type& opt = environment_option_type());
  ~environment();
  static bool initialized();
  static bool finalized();
  static void abort(int errcode);
  static int max_tag();
  static int collectives_tag();
  static boost::optional<int> host_rank();
  static boost::optional<int> io_rank();
  static std::string processor_name();
private:
  bool             _rheolef_has_init;
  unsigned int     _oldcw;
  static const int _num_reserved_tags = 1;
};
#endif // _RHEOLEF_HAVE_MPI
} // namespace rheolef
#endif // _RHEO_ENVIRONMENT_H
