// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewGetLogEntryByUUIDParams creates a new GetLogEntryByUUIDParams object
//
// There are no default values defined in the spec.
func NewGetLogEntryByUUIDParams() GetLogEntryByUUIDParams {

	return GetLogEntryByUUIDParams{}
}

// GetLogEntryByUUIDParams contains all the bound params for the get log entry by UUID operation
// typically these are obtained from a http.Request
//
// swagger:parameters getLogEntryByUUID
type GetLogEntryByUUIDParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*the UUID of the entry for which the inclusion proof information should be returned
	  Required: true
	  Pattern: ^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$
	  In: path
	*/
	EntryUUID string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetLogEntryByUUIDParams() beforehand.
func (o *GetLogEntryByUUIDParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	rEntryUUID, rhkEntryUUID, _ := route.Params.GetOK("entryUUID")
	if err := o.bindEntryUUID(rEntryUUID, rhkEntryUUID, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindEntryUUID binds and validates parameter EntryUUID from path.
func (o *GetLogEntryByUUIDParams) bindEntryUUID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.EntryUUID = raw

	if err := o.validateEntryUUID(formats); err != nil {
		return err
	}

	return nil
}

// validateEntryUUID carries on validations for parameter EntryUUID
func (o *GetLogEntryByUUIDParams) validateEntryUUID(formats strfmt.Registry) error {

	if err := validate.Pattern("entryUUID", "path", o.EntryUUID, `^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$`); err != nil {
		return err
	}

	return nil
}
