% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_psi.R
\name{convert_psi}
\alias{convert_psi}
\title{Convert low/bad quality PSI values to NA}
\usage{
convert_psi(t, qual = c("VLOW", "N", "LOW", "OK", "SOK"))
}
\arguments{
\item{t}{Original PSI plus quality scores data frame WITHOUT the exon
metadata columns}

\item{qual}{String indicating the minimun \emph{vast-tools} quality score
for the PSI to be accepted. Defaults to \code{'VLOW'}. See the
\href{https://github.com/vastgroup/vast-tools/blob/master/README.md}{vast-tools
documentation} for details.}
}
\value{
Data frame with the same dimensions as \emph{t} and low/bad quality P
SI values converted to \code{NA}
}
\description{
Helper function to filter and return PSI values.
PSIs are converted to NA if first coverage code is 'N'
e.g. PSI=100, Coverage=N,N,N,OK,S ---> PSI=NA
For internal use. Called by \code{\link{format_table}}.
}
\examples{
\dontrun{
psiplot:::convert_psi(psi[,7:ncol(psi)])
}
}
